# 3D kinematics and kinetics of change of direction motions reconstructed from virtual inertial sensor data through optimal control simulation
This is the data belonging to the publication "Estimating 3D kinematics and kinetics from inertial sensor data through musculoskeletal movement simulations".

This study investigated the feasibility and accuracy of reconstructing, especially change of direction motions with a 3D full-body musculoskeletal model by tracking virtual inertial sensor data in optimal control simulations. We used the recordings of 90 trials with optical motion capture to generate marker tracking simulations from which we computed virtual inertial sensor data. Using this data, we compared inertial tracking simulations and marker tracking simulations. 

## Study Setup 
The motion capture data was recorded previously. 
It was described in Nitschke et al., "Change the direction: 3D optimal control simulation by directly tracking marker and ground reaction force data" and was published in Nitschke et al., "Optical motion capturing of change of direction motions reconstructed with inverse kinematics and dynamics and optimal control simulation" (doi:10.5281/zenodo.6949012).

The data set contained:
* 10 healthy young participants (4 female, 6 male; age: 27.5 ± 3.5 years; height: 1.76 ± 0.10m; mass: 71.3 ± 12.1 kg)
* Systems
    * Optical motion capturing: 42 markers, 11 cameras (Qualisys), 175 Hz
    * Force plates: 2 plates of (Bertex Corporporation), 1750 Hz
* 3 trials for each participant for each of the following motions:
    * straight running
    * curved running with a radius of 7 m
    * v-cut with 90°
* Motion of interest was defined from right to right initial contact

## Reconstruction Methods
The basis for reconstruction was the generic musculoskeletal model "runMaD" which was scaled with OpenSim to match the participants.
1. **Marker tracking simulation:**    
The motion was reconstructed by solving an optimal control problem that directly tracked the measured marker positions and ground reaction forces. The marker tracking simulations served as a reference and to generate virtual inertial sensor data.
The marker tracking simulations were described in Nitschke et al., "Change the direction: 3D optimal control simulation by directly tracking marker and ground reaction force data" and was published in Nitschke et al., "Optical motion capturing of change of direction motions reconstructed with inverse kinematics and dynamics and optimal control simulation" (doi:10.5281/zenodo.6949012).
2. **Inertial tracking simulation:**
The motion was reconstructed by solving an optimal control problem that directly tracked the virtual inertial sensor data, i.e., linear acceleration and angular velocity.

## Data structure
We provide here the virtual inertial data and muscle forces of the marker tracking simulation as well as the results of the inertial tracking simulation in OpenSim file format and as csv:

```
.
│   README.md                   
│   metaInfo.csv                                            -> meta information of participants, trials, and times of initial contacts 
│
└───Participant_02
│   │   Participant_02.osim                                 -> scaled OpenSim model matching the participant with inertial sensor positions
│   │
│   └───straightslowrunning
│   |   │   trialXXXX_marker_tracking_inertial_data.csv     -> virtual inertial data for motion of interest (file format definition of APDM)
│   |   │   trialXXXX_marker_tracking_muscle_forces.sto     -> estimated muscle forces for motion of interest
│   |   │   trialXXXX_inertial_tracking_coordinates.mot     -> estimated generalized coordinates for motion of interest
│   |   │   trialXXXX_inertial_tracking_moments.sto         -> estimated moments for motion of interest
│   |   │   trialXXXX_inertial_tracking_GRFs.mot            -> estimated GRFs for motion of interest
│   |   │   trialXXXX_inertial_tracking_inertial_data.csv   -> estimated inertial data for motion of interest  (file format definition of APDM)
│   |   │   trialXXXX_inertial_tracking_muscle_forces.sto   -> estimated muscle forces for motion of interest
│   |   │   trialYYYY_...
│   |   │   ...
│   │
│   └───curvedslowrunning
│   |   │   ...
│   │
│   └───vcut
│       │   ...
│   
└───Participant_03
|    │   ...
|    ...
```

## Cite 
When using the data, please cite this data set (10.5281/zenodo.8183292) and cite the following publication for further information:   
Nitschke et al., "Estimating 3D kinematics and kinetics from inertial sensor data through musculoskeletal movement simulations"