import statsmodels.stats.power as smp

# Define the desired power
power = 0.8

# Define the effect size (w) and degrees of freedom (df)
effect_size = 0.3
df = 9

# Define the significance level (alpha)
alpha = 0.05

# Calculate the sample size
sample_size = smp.GofChisquarePower().solve_power(effect_size=effect_size, nobs=None, alpha=alpha, power=power, df=df)

# Round up the sample size to the nearest whole number
sample_size = int(sample_size + 1)

# Print the calculated sample size
print("Sample size:", sample_size)
