# pyregimeshifts

Python scripts for detecting nonlinear regime shifts in multiple paleoclimate time series

# Based on publication

J.F. Donges, R.V. Donner, N. Marwan, S.F.M. Breitenbach, K. Rehfeld, and
J. Kurths,
Nonlinear regime shifts in Holocene Asian monsoon variability:
Potential impacts on cultural change and migratory patterns,
Climate of the Past 11, 709-741 (2015),
DOI: 10.5194/cp-11-709-2015

# Idea

The analysis scripts provided in this package provide a general toolkit for
detecting regime shifts in multiple (paleo-) climate time series. They should,
hence, prove useful for diverse studies on Earth system dynamics beyond the work reported in the original paper. First, the methodology developed in the
original paper can be applied to a broad range of data sets of interest.
Second, the methodology can be easily generalized by making full use of the
capabilities of the pyunicorn package and other approaches of time series analysis. 
For example, other measures for
detecting regime shifts from recurrence analysis such determinism or laminarity
could be used or visibility graph analysis could be applied instead of
recurrence networks.

# General information

Python scripts run in Python 2.x and use standard Python packages numpy,
scipy etc (latest versions in 2014). Additionally, the package pyunicorn
needs to be installed on the system (see below).

Results of the recurrence analysis are stored in Python cPickle (.pickle)
files to be loaded by plotting scripts.

Information on and latest version of Python package pyunicorn can be
obtained here:
http://tocsy.pik-potsdam.de/pyunicorn.php

For the development version of pyunicon:
https://github.com/pik-copan/pyunicorn

Information on and latest version of Matlab package COPRA (Constructing
Proxy Records From Age Models) can be obtained here:
http://tocsy.pik-potsdam.de/copra.php

Note that for some figures in the paper, the layout has been redesigned using
Adobe Illustrator based on the plots generated by the Python scripts provided by this package.


# Material in this package

1. Raw speleothem proxy data (10 data files, one for each cave):
a) data/raw_proxy_data/*.dat (data files from original paper provided as
an example)

2. COPRA ensemble data (10 data files, one for each cave, each contains
1000 realizations of the proxy record):
a) Not distributed in this package due to large size but can be obtained
upon request.

3. Scripts for computing and plotting auto-correlation functions (Fig. 5):
a) scripts/auto_correlation_function/auto_correlation_copra.py
(reproduce Fig. 5)
b) scripts/auto_correlation_function/auto_correlation_irregular_sampling.py
(compute auto-correlation function for irregularly sampled data, produces
part of Fig. 5 - kernel_acf_dongge.txt - that is loaded by the script 3a)
c) kernel_acf_dongge.txt
(Auto-correlation function of Dongge DA record computed using 3b)

4. Scripts for analyzing and plotting of raw proxy data (Figs. 4,7,8,9):
a) scripts/raw_proxy_records_analysis/recurrence_analysis_speleo_raw.py
(Performs recurrence analysis for set of raw proxy records and stores results)
b) scripts/raw_proxy_records_analysis/recurrence_analysis_speleo_raw_plot.py
(Plots results of 4a, Figs. 4, 7, 8)
c) scripts/raw_proxy_records_analysis/speleo_summary_statistics_raw.py
(Computes and plots summary statistics based on results of 4a, Fig. 9)

5. Scripts for analyzing and plotting of COPRA ensembles (Figs. 10,A1,A2,A3):
a) scripts/copra_ensembles_analysis/recurrence_analysis_copra_ensemble_single_record.py
(Performs recurrence analysis for the COPRA ensemble associated to a single
proxy record)
b) scripts/copra_ensembles_analysis/recurrence_analysis_copra_ensemble_multiple_records_plot.py
(Plots results of 5a for several proxy records, Figs. A1, A2, A3)
c) scripts/copra_ensembles_analysis/speleo_summary_statistics_copra.py
(Computes and plots summary statistics based on results of 5a for several
proxy records, Fig. 10)

6. Script for plotting comparative figure for Dongge DA record (Fig. 6):
a) scripts/copra_ensembles_analysis/recurrence_analysis_copra_ensemble_single_record_plot.py
(Plots results of recurrence analysis of single raw proxy record [from 4a]
and its associated COPRA ensemble [from 5a], Fig. 6)
