function xdota = cup_task_model(tt,xx)

global g m M l A f

% Extract states
th1p=xx(1);
th1s=xx(2);

% Define the angular accelerations l*ddtheta = -ddx * cos(theta) - g *
% sin(theta)
thdot = -1./l * (-A/2.*(2*pi*f)^2 * sin(2*pi*f*tt + pi/2.) * cos(th1p) + g * sin(th1p));

% Return the state derivatives to ODE solver
xdota = [th1s; thdot];

end