      subroutine SETD3(*)
      implicit real*8 (a-h,o-z)
      COMMON /D3PARAM/ C6AB(17,17,5,5,3),R0AB(17,17),D3SR6,D3S8,LSETD3,
     &                 LD3SR6,LD3S8
      LOGICAL          LSETD3, LD3SR6, LD3S8
c     Conversion factor bohr -> angstroms:
      parameter(autoang=0.52917726d0)

      if (lsetd3) then
         write(6,*) "D3 parameters already set, so not repeating."
         return
      endif

*     Start of Grimme's -D3 dispersion C6 and R0 parameters.
C     Reference:   J. Chem. Phys. 132, 154104 (2010)
      C6AB( 1, 1,1,1,1)  =    3.02670d0  
      C6AB( 1, 1,1,1,2)  =    0.91180d0  
      C6AB( 1, 1,1,1,3)  =    0.91180d0  
      C6AB( 1, 1,1,2,1)  =    4.73790d0  
      C6AB( 1, 1,1,2,2)  =    0.91180d0  
      C6AB( 1, 1,1,2,3)  =    0.00000d0  
      C6AB( 1, 1,2,1,1)  =    4.73790d0  
      C6AB( 1, 1,2,1,2)  =    0.00000d0  
      C6AB( 1, 1,2,1,3)  =    0.91180d0  
      C6AB( 1, 1,2,2,1)  =    7.59160d0  
      C6AB( 1, 1,2,2,2)  =    0.00000d0  
      C6AB( 1, 1,2,2,3)  =    0.00000d0  
      C6AB( 1, 6,1,1,1)  =   12.14020d0  
      C6AB( 1, 6,1,1,2)  =    0.91180d0  
      C6AB( 1, 6,1,1,3)  =    0.00000d0  
      C6AB( 1, 6,1,2,1)  =   11.39320d0  
      C6AB( 1, 6,1,2,2)  =    0.91180d0  
      C6AB( 1, 6,1,2,3)  =    0.98680d0  
      C6AB( 1, 6,1,3,1)  =    9.42030d0  
      C6AB( 1, 6,1,3,2)  =    0.91180d0  
      C6AB( 1, 6,1,3,3)  =    1.99850d0  
      C6AB( 1, 6,1,4,1)  =    8.82100d0  
      C6AB( 1, 6,1,4,2)  =    0.91180d0  
      C6AB( 1, 6,1,4,3)  =    2.99870d0  
      C6AB( 1, 6,1,5,1)  =    7.36620d0  
      C6AB( 1, 6,1,5,2)  =    0.91180d0  
      C6AB( 1, 6,1,5,3)  =    3.98440d0  
      C6AB( 1, 6,2,1,1)  =   19.26530d0  
      C6AB( 1, 6,2,1,2)  =    0.00000d0  
      C6AB( 1, 6,2,1,3)  =    0.00000d0  
      C6AB( 1, 6,2,2,1)  =   18.05750d0  
      C6AB( 1, 6,2,2,2)  =    0.00000d0  
      C6AB( 1, 6,2,2,3)  =    0.98680d0  
      C6AB( 1, 6,2,3,1)  =   14.76230d0  
      C6AB( 1, 6,2,3,2)  =    0.00000d0  
      C6AB( 1, 6,2,3,3)  =    1.99850d0  
      C6AB( 1, 6,2,4,1)  =   13.79920d0  
      C6AB( 1, 6,2,4,2)  =    0.00000d0  
      C6AB( 1, 6,2,4,3)  =    2.99870d0  
      C6AB( 1, 6,2,5,1)  =   11.32990d0  
      C6AB( 1, 6,2,5,2)  =    0.00000d0  
      C6AB( 1, 6,2,5,3)  =    3.98440d0  
      C6AB( 1, 7,1,1,1)  =    8.71710d0  
      C6AB( 1, 7,1,1,2)  =    0.91180d0  
      C6AB( 1, 7,1,1,3)  =    0.00000d0  
      C6AB( 1, 7,1,2,1)  =    8.14170d0  
      C6AB( 1, 7,1,2,2)  =    0.91180d0  
      C6AB( 1, 7,1,2,3)  =    0.99440d0  
      C6AB( 1, 7,1,3,1)  =    7.66100d0  
      C6AB( 1, 7,1,3,2)  =    0.91180d0  
      C6AB( 1, 7,1,3,3)  =    2.01430d0  
      C6AB( 1, 7,1,4,1)  =    6.77460d0  
      C6AB( 1, 7,1,4,2)  =    0.91180d0  
      C6AB( 1, 7,1,4,3)  =    2.99030d0  
      C6AB( 1, 7,2,1,1)  =   13.51640d0  
      C6AB( 1, 7,2,1,2)  =    0.00000d0  
      C6AB( 1, 7,2,1,3)  =    0.00000d0  
      C6AB( 1, 7,2,2,1)  =   12.59800d0  
      C6AB( 1, 7,2,2,2)  =    0.00000d0  
      C6AB( 1, 7,2,2,3)  =    0.99440d0  
      C6AB( 1, 7,2,3,1)  =   11.82140d0  
      C6AB( 1, 7,2,3,2)  =    0.00000d0  
      C6AB( 1, 7,2,3,3)  =    2.01430d0  
      C6AB( 1, 7,2,4,1)  =   10.39870d0  
      C6AB( 1, 7,2,4,2)  =    0.00000d0  
      C6AB( 1, 7,2,4,3)  =    2.99030d0  
      C6AB( 1, 8,1,1,1)  =    6.71800d0  
      C6AB( 1, 8,1,1,2)  =    0.91180d0  
      C6AB( 1, 8,1,1,3)  =    0.00000d0  
      C6AB( 1, 8,1,2,1)  =    6.05750d0  
      C6AB( 1, 8,1,2,2)  =    0.91180d0  
      C6AB( 1, 8,1,2,3)  =    0.99250d0  
      C6AB( 1, 8,1,3,1)  =    5.37170d0  
      C6AB( 1, 8,1,3,2)  =    0.91180d0  
      C6AB( 1, 8,1,3,3)  =    1.98870d0  
      C6AB( 1, 8,2,1,1)  =   10.23710d0  
      C6AB( 1, 8,2,1,2)  =    0.00000d0  
      C6AB( 1, 8,2,1,3)  =    0.00000d0  
      C6AB( 1, 8,2,2,1)  =    9.18120d0  
      C6AB( 1, 8,2,2,2)  =    0.00000d0  
      C6AB( 1, 8,2,2,3)  =    0.99250d0  
      C6AB( 1, 8,2,3,1)  =    8.08480d0  
      C6AB( 1, 8,2,3,2)  =    0.00000d0  
      C6AB( 1, 8,2,3,3)  =    1.98870d0  
      C6AB( 1,15,1,1,1)  =   23.76040d0  
      C6AB( 1,15,1,1,2)  =    0.91180d0  
      C6AB( 1,15,1,1,3)  =    0.00000d0  
      C6AB( 1,15,1,2,1)  =   23.09080d0  
      C6AB( 1,15,1,2,2)  =    0.91180d0  
      C6AB( 1,15,1,2,3)  =    0.99470d0  
      C6AB( 1,15,1,3,1)  =   22.74290d0  
      C6AB( 1,15,1,3,2)  =    0.91180d0  
      C6AB( 1,15,1,3,3)  =    2.01020d0  
      C6AB( 1,15,1,4,1)  =   21.25070d0  
      C6AB( 1,15,1,4,2)  =    0.91180d0  
      C6AB( 1,15,1,4,3)  =    2.98590d0  
      C6AB( 1,15,2,1,1)  =   38.13970d0  
      C6AB( 1,15,2,1,2)  =    0.00000d0  
      C6AB( 1,15,2,1,3)  =    0.00000d0  
      C6AB( 1,15,2,2,1)  =   37.02360d0  
      C6AB( 1,15,2,2,2)  =    0.00000d0  
      C6AB( 1,15,2,2,3)  =    0.99470d0  
      C6AB( 1,15,2,3,1)  =   36.49360d0  
      C6AB( 1,15,2,3,2)  =    0.00000d0  
      C6AB( 1,15,2,3,3)  =    2.01020d0  
      C6AB( 1,15,2,4,1)  =   33.91930d0  
      C6AB( 1,15,2,4,2)  =    0.00000d0  
      C6AB( 1,15,2,4,3)  =    2.98590d0  
      C6AB( 1,16,1,1,1)  =   20.09480d0  
      C6AB( 1,16,1,1,2)  =    0.91180d0  
      C6AB( 1,16,1,1,3)  =    0.00000d0  
      C6AB( 1,16,1,2,1)  =   19.86670d0  
      C6AB( 1,16,1,2,2)  =    0.91180d0  
      C6AB( 1,16,1,2,3)  =    0.99480d0  
      C6AB( 1,16,1,3,1)  =   19.47290d0  
      C6AB( 1,16,1,3,2)  =    0.91180d0  
      C6AB( 1,16,1,3,3)  =    1.99030d0  
      C6AB( 1,16,2,1,1)  =   31.77130d0  
      C6AB( 1,16,2,1,2)  =    0.00000d0  
      C6AB( 1,16,2,1,3)  =    0.00000d0  
      C6AB( 1,16,2,2,1)  =   31.41270d0  
      C6AB( 1,16,2,2,2)  =    0.00000d0  
      C6AB( 1,16,2,2,3)  =    0.99480d0  
      C6AB( 1,16,2,3,1)  =   30.77470d0  
      C6AB( 1,16,2,3,2)  =    0.00000d0  
      C6AB( 1,16,2,3,3)  =    1.99030d0  
      C6AB( 1,17,1,1,1)  =   16.70520d0  
      C6AB( 1,17,1,1,2)  =    0.91180d0  
      C6AB( 1,17,1,1,3)  =    0.00000d0  
      C6AB( 1,17,1,2,1)  =   16.52730d0  
      C6AB( 1,17,1,2,2)  =    0.91180d0  
      C6AB( 1,17,1,2,3)  =    0.99720d0  
      C6AB( 1,17,2,1,1)  =   26.01700d0  
      C6AB( 1,17,2,1,2)  =    0.00000d0  
      C6AB( 1,17,2,1,3)  =    0.00000d0  
      C6AB( 1,17,2,2,1)  =   25.74140d0  
      C6AB( 1,17,2,2,2)  =    0.00000d0  
      C6AB( 1,17,2,2,3)  =    0.99720d0  
      C6AB( 6, 1,1,1,1)  =   12.14020d0  
      C6AB( 6, 1,1,1,2)  =    0.00000d0  
      C6AB( 6, 1,1,1,3)  =    0.91180d0  
      C6AB( 6, 1,1,2,1)  =   19.26530d0  
      C6AB( 6, 1,1,2,2)  =    0.00000d0  
      C6AB( 6, 1,1,2,3)  =    0.00000d0  
      C6AB( 6, 1,2,1,1)  =   11.39320d0  
      C6AB( 6, 1,2,1,2)  =    0.98680d0  
      C6AB( 6, 1,2,1,3)  =    0.91180d0  
      C6AB( 6, 1,2,2,1)  =   18.05750d0  
      C6AB( 6, 1,2,2,2)  =    0.98680d0  
      C6AB( 6, 1,2,2,3)  =    0.00000d0  
      C6AB( 6, 1,3,1,1)  =    9.42030d0  
      C6AB( 6, 1,3,1,2)  =    1.99850d0  
      C6AB( 6, 1,3,1,3)  =    0.91180d0  
      C6AB( 6, 1,3,2,1)  =   14.76230d0  
      C6AB( 6, 1,3,2,2)  =    1.99850d0  
      C6AB( 6, 1,3,2,3)  =    0.00000d0  
      C6AB( 6, 1,4,1,1)  =    8.82100d0  
      C6AB( 6, 1,4,1,2)  =    2.99870d0  
      C6AB( 6, 1,4,1,3)  =    0.91180d0  
      C6AB( 6, 1,4,2,1)  =   13.79920d0  
      C6AB( 6, 1,4,2,2)  =    2.99870d0  
      C6AB( 6, 1,4,2,3)  =    0.00000d0  
      C6AB( 6, 1,5,1,1)  =    7.36620d0  
      C6AB( 6, 1,5,1,2)  =    3.98440d0  
      C6AB( 6, 1,5,1,3)  =    0.91180d0  
      C6AB( 6, 1,5,2,1)  =   11.32990d0  
      C6AB( 6, 1,5,2,2)  =    3.98440d0  
      C6AB( 6, 1,5,2,3)  =    0.00000d0  
      C6AB( 6, 6,1,1,1)  =   49.11300d0  
      C6AB( 6, 6,1,1,2)  =    0.00000d0  
      C6AB( 6, 6,1,1,3)  =    0.00000d0  
      C6AB( 6, 6,1,2,1)  =   46.06810d0  
      C6AB( 6, 6,1,2,2)  =    0.00000d0  
      C6AB( 6, 6,1,2,3)  =    0.98680d0  
      C6AB( 6, 6,1,3,1)  =   37.84190d0  
      C6AB( 6, 6,1,3,2)  =    0.00000d0  
      C6AB( 6, 6,1,3,3)  =    1.99850d0  
      C6AB( 6, 6,1,4,1)  =   35.41290d0  
      C6AB( 6, 6,1,4,2)  =    0.00000d0  
      C6AB( 6, 6,1,4,3)  =    2.99870d0  
      C6AB( 6, 6,1,5,1)  =   29.28300d0  
      C6AB( 6, 6,1,5,2)  =    0.00000d0  
      C6AB( 6, 6,1,5,3)  =    3.98440d0  
      C6AB( 6, 6,2,1,1)  =   46.06810d0  
      C6AB( 6, 6,2,1,2)  =    0.98680d0  
      C6AB( 6, 6,2,1,3)  =    0.00000d0  
      C6AB( 6, 6,2,2,1)  =   43.24520d0  
      C6AB( 6, 6,2,2,2)  =    0.98680d0  
      C6AB( 6, 6,2,2,3)  =    0.98680d0  
      C6AB( 6, 6,2,3,1)  =   35.52190d0  
      C6AB( 6, 6,2,3,2)  =    0.98680d0  
      C6AB( 6, 6,2,3,3)  =    1.99850d0  
      C6AB( 6, 6,2,4,1)  =   33.25400d0  
      C6AB( 6, 6,2,4,2)  =    0.98680d0  
      C6AB( 6, 6,2,4,3)  =    2.99870d0  
      C6AB( 6, 6,2,5,1)  =   27.52060d0  
      C6AB( 6, 6,2,5,2)  =    0.98680d0  
      C6AB( 6, 6,2,5,3)  =    3.98440d0  
      C6AB( 6, 6,3,1,1)  =   37.84190d0  
      C6AB( 6, 6,3,1,2)  =    1.99850d0  
      C6AB( 6, 6,3,1,3)  =    0.00000d0  
      C6AB( 6, 6,3,2,1)  =   35.52190d0  
      C6AB( 6, 6,3,2,2)  =    1.99850d0  
      C6AB( 6, 6,3,2,3)  =    0.98680d0  
      C6AB( 6, 6,3,3,1)  =   29.36020d0  
      C6AB( 6, 6,3,3,2)  =    1.99850d0  
      C6AB( 6, 6,3,3,3)  =    1.99850d0  
      C6AB( 6, 6,3,4,1)  =   27.50630d0  
      C6AB( 6, 6,3,4,2)  =    1.99850d0  
      C6AB( 6, 6,3,4,3)  =    2.99870d0  
      C6AB( 6, 6,3,5,1)  =   22.95170d0  
      C6AB( 6, 6,3,5,2)  =    1.99850d0  
      C6AB( 6, 6,3,5,3)  =    3.98440d0  
      C6AB( 6, 6,4,1,1)  =   35.41290d0  
      C6AB( 6, 6,4,1,2)  =    2.99870d0  
      C6AB( 6, 6,4,1,3)  =    0.00000d0  
      C6AB( 6, 6,4,2,1)  =   33.25400d0  
      C6AB( 6, 6,4,2,2)  =    2.99870d0  
      C6AB( 6, 6,4,2,3)  =    0.98680d0  
      C6AB( 6, 6,4,3,1)  =   27.50630d0  
      C6AB( 6, 6,4,3,2)  =    2.99870d0  
      C6AB( 6, 6,4,3,3)  =    1.99850d0  
      C6AB( 6, 6,4,4,1)  =   25.78090d0  
      C6AB( 6, 6,4,4,2)  =    2.99870d0  
      C6AB( 6, 6,4,4,3)  =    2.99870d0  
      C6AB( 6, 6,4,5,1)  =   21.53770d0  
      C6AB( 6, 6,4,5,2)  =    2.99870d0  
      C6AB( 6, 6,4,5,3)  =    3.98440d0  
      C6AB( 6, 6,5,1,1)  =   29.28300d0  
      C6AB( 6, 6,5,1,2)  =    3.98440d0  
      C6AB( 6, 6,5,1,3)  =    0.00000d0  
      C6AB( 6, 6,5,2,1)  =   27.52060d0  
      C6AB( 6, 6,5,2,2)  =    3.98440d0  
      C6AB( 6, 6,5,2,3)  =    0.98680d0  
      C6AB( 6, 6,5,3,1)  =   22.95170d0  
      C6AB( 6, 6,5,3,2)  =    3.98440d0  
      C6AB( 6, 6,5,3,3)  =    1.99850d0  
      C6AB( 6, 6,5,4,1)  =   21.53770d0  
      C6AB( 6, 6,5,4,2)  =    3.98440d0  
      C6AB( 6, 6,5,4,3)  =    2.99870d0  
      C6AB( 6, 6,5,5,1)  =   18.20670d0  
      C6AB( 6, 6,5,5,2)  =    3.98440d0  
      C6AB( 6, 6,5,5,3)  =    3.98440d0  
      C6AB( 6, 7,1,1,1)  =   34.81460d0  
      C6AB( 6, 7,1,1,2)  =    0.00000d0  
      C6AB( 6, 7,1,1,3)  =    0.00000d0  
      C6AB( 6, 7,1,2,1)  =   32.48480d0  
      C6AB( 6, 7,1,2,2)  =    0.00000d0  
      C6AB( 6, 7,1,2,3)  =    0.99440d0  
      C6AB( 6, 7,1,3,1)  =   30.53050d0  
      C6AB( 6, 7,1,3,2)  =    0.00000d0  
      C6AB( 6, 7,1,3,3)  =    2.01430d0  
      C6AB( 6, 7,1,4,1)  =   26.93510d0  
      C6AB( 6, 7,1,4,2)  =    0.00000d0  
      C6AB( 6, 7,1,4,3)  =    2.99030d0  
      C6AB( 6, 7,2,1,1)  =   32.70090d0  
      C6AB( 6, 7,2,1,2)  =    0.98680d0  
      C6AB( 6, 7,2,1,3)  =    0.00000d0  
      C6AB( 6, 7,2,2,1)  =   30.54100d0  
      C6AB( 6, 7,2,2,2)  =    0.98680d0  
      C6AB( 6, 7,2,2,3)  =    0.99440d0  
      C6AB( 6, 7,2,3,1)  =   28.69380d0  
      C6AB( 6, 7,2,3,2)  =    0.98680d0  
      C6AB( 6, 7,2,3,3)  =    2.01430d0  
      C6AB( 6, 7,2,4,1)  =   25.33180d0  
      C6AB( 6, 7,2,4,2)  =    0.98680d0  
      C6AB( 6, 7,2,4,3)  =    2.99030d0  
      C6AB( 6, 7,3,1,1)  =   27.17040d0  
      C6AB( 6, 7,3,1,2)  =    1.99850d0  
      C6AB( 6, 7,3,1,3)  =    0.00000d0  
      C6AB( 6, 7,3,2,1)  =   25.38270d0  
      C6AB( 6, 7,3,2,2)  =    1.99850d0  
      C6AB( 6, 7,3,2,3)  =    0.99440d0  
      C6AB( 6, 7,3,3,1)  =   23.89650d0  
      C6AB( 6, 7,3,3,2)  =    1.99850d0  
      C6AB( 6, 7,3,3,3)  =    2.01430d0  
      C6AB( 6, 7,3,4,1)  =   21.14880d0  
      C6AB( 6, 7,3,4,2)  =    1.99850d0  
      C6AB( 6, 7,3,4,3)  =    2.99030d0  
      C6AB( 6, 7,4,1,1)  =   25.47990d0  
      C6AB( 6, 7,4,1,2)  =    2.99870d0  
      C6AB( 6, 7,4,1,3)  =    0.00000d0  
      C6AB( 6, 7,4,2,1)  =   23.81360d0  
      C6AB( 6, 7,4,2,2)  =    2.99870d0  
      C6AB( 6, 7,4,2,3)  =    0.99440d0  
      C6AB( 6, 7,4,3,1)  =   22.42790d0  
      C6AB( 6, 7,4,3,2)  =    2.99870d0  
      C6AB( 6, 7,4,3,3)  =    2.01430d0  
      C6AB( 6, 7,4,4,1)  =   19.86690d0  
      C6AB( 6, 7,4,4,2)  =    2.99870d0  
      C6AB( 6, 7,4,4,3)  =    2.99030d0  
      C6AB( 6, 7,5,1,1)  =   21.41990d0  
      C6AB( 6, 7,5,1,2)  =    3.98440d0  
      C6AB( 6, 7,5,1,3)  =    0.00000d0  
      C6AB( 6, 7,5,2,1)  =   20.04680d0  
      C6AB( 6, 7,5,2,2)  =    3.98440d0  
      C6AB( 6, 7,5,2,3)  =    0.99440d0  
      C6AB( 6, 7,5,3,1)  =   18.91720d0  
      C6AB( 6, 7,5,3,2)  =    3.98440d0  
      C6AB( 6, 7,5,3,3)  =    2.01430d0  
      C6AB( 6, 7,5,4,1)  =   16.81690d0  
      C6AB( 6, 7,5,4,2)  =    3.98440d0  
      C6AB( 6, 7,5,4,3)  =    2.99030d0  
      C6AB( 6, 8,1,1,1)  =   26.59290d0  
      C6AB( 6, 8,1,1,2)  =    0.00000d0  
      C6AB( 6, 8,1,1,3)  =    0.00000d0  
      C6AB( 6, 8,1,2,1)  =   23.91200d0  
      C6AB( 6, 8,1,2,2)  =    0.00000d0  
      C6AB( 6, 8,1,2,3)  =    0.99250d0  
      C6AB( 6, 8,1,3,1)  =   21.14280d0  
      C6AB( 6, 8,1,3,2)  =    0.00000d0  
      C6AB( 6, 8,1,3,3)  =    1.98870d0  
      C6AB( 6, 8,2,1,1)  =   25.00970d0  
      C6AB( 6, 8,2,1,2)  =    0.98680d0  
      C6AB( 6, 8,2,1,3)  =    0.00000d0  
      C6AB( 6, 8,2,2,1)  =   22.51780d0  
      C6AB( 6, 8,2,2,2)  =    0.98680d0  
      C6AB( 6, 8,2,2,3)  =    0.99250d0  
      C6AB( 6, 8,2,3,1)  =   19.90900d0  
      C6AB( 6, 8,2,3,2)  =    0.98680d0  
      C6AB( 6, 8,2,3,3)  =    1.98870d0  
      C6AB( 6, 8,3,1,1)  =   20.95970d0  
      C6AB( 6, 8,3,1,2)  =    1.99850d0  
      C6AB( 6, 8,3,1,3)  =    0.00000d0  
      C6AB( 6, 8,3,2,1)  =   18.90340d0  
      C6AB( 6, 8,3,2,2)  =    1.99850d0  
      C6AB( 6, 8,3,2,3)  =    0.99250d0  
      C6AB( 6, 8,3,3,1)  =   16.78550d0  
      C6AB( 6, 8,3,3,2)  =    1.99850d0  
      C6AB( 6, 8,3,3,3)  =    1.98870d0  
      C6AB( 6, 8,4,1,1)  =   19.69430d0  
      C6AB( 6, 8,4,1,2)  =    2.99870d0  
      C6AB( 6, 8,4,1,3)  =    0.00000d0  
      C6AB( 6, 8,4,2,1)  =   17.77500d0  
      C6AB( 6, 8,4,2,2)  =    2.99870d0  
      C6AB( 6, 8,4,2,3)  =    0.99250d0  
      C6AB( 6, 8,4,3,1)  =   15.80090d0  
      C6AB( 6, 8,4,3,2)  =    2.99870d0  
      C6AB( 6, 8,4,3,3)  =    1.98870d0  
      C6AB( 6, 8,5,1,1)  =   16.75440d0  
      C6AB( 6, 8,5,1,2)  =    3.98440d0  
      C6AB( 6, 8,5,1,3)  =    0.00000d0  
      C6AB( 6, 8,5,2,1)  =   15.17510d0  
      C6AB( 6, 8,5,2,2)  =    3.98440d0  
      C6AB( 6, 8,5,2,3)  =    0.99250d0  
      C6AB( 6, 8,5,3,1)  =   13.55250d0  
      C6AB( 6, 8,5,3,2)  =    3.98440d0  
      C6AB( 6, 8,5,3,3)  =    1.98870d0  
      C6AB( 6,15,1,1,1)  =   96.75030d0  
      C6AB( 6,15,1,1,2)  =    0.00000d0  
      C6AB( 6,15,1,1,3)  =    0.00000d0  
      C6AB( 6,15,1,2,1)  =   93.96630d0  
      C6AB( 6,15,1,2,2)  =    0.00000d0  
      C6AB( 6,15,1,2,3)  =    0.99470d0  
      C6AB( 6,15,1,3,1)  =   92.60800d0  
      C6AB( 6,15,1,3,2)  =    0.00000d0  
      C6AB( 6,15,1,3,3)  =    2.01020d0  
      C6AB( 6,15,1,4,1)  =   86.24270d0  
      C6AB( 6,15,1,4,2)  =    0.00000d0  
      C6AB( 6,15,1,4,3)  =    2.98590d0  
      C6AB( 6,15,2,1,1)  =   90.67670d0  
      C6AB( 6,15,2,1,2)  =    0.98680d0  
      C6AB( 6,15,2,1,3)  =    0.00000d0  
      C6AB( 6,15,2,2,1)  =   88.07690d0  
      C6AB( 6,15,2,2,2)  =    0.98680d0  
      C6AB( 6,15,2,2,3)  =    0.99470d0  
      C6AB( 6,15,2,3,1)  =   86.81280d0  
      C6AB( 6,15,2,3,2)  =    0.98680d0  
      C6AB( 6,15,2,3,3)  =    2.01020d0  
      C6AB( 6,15,2,4,1)  =   80.84960d0  
      C6AB( 6,15,2,4,2)  =    0.98680d0  
      C6AB( 6,15,2,4,3)  =    2.98590d0  
      C6AB( 6,15,3,1,1)  =   74.07840d0  
      C6AB( 6,15,3,1,2)  =    1.99850d0  
      C6AB( 6,15,3,1,3)  =    0.00000d0  
      C6AB( 6,15,3,2,1)  =   71.99140d0  
      C6AB( 6,15,3,2,2)  =    1.99850d0  
      C6AB( 6,15,3,2,3)  =    0.99470d0  
      C6AB( 6,15,3,3,1)  =   70.92690d0  
      C6AB( 6,15,3,3,2)  =    1.99850d0  
      C6AB( 6,15,3,3,3)  =    2.01020d0  
      C6AB( 6,15,3,4,1)  =   66.23430d0  
      C6AB( 6,15,3,4,2)  =    1.99850d0  
      C6AB( 6,15,3,4,3)  =    2.98590d0  
      C6AB( 6,15,4,1,1)  =   69.25150d0  
      C6AB( 6,15,4,1,2)  =    2.99870d0  
      C6AB( 6,15,4,1,3)  =    0.00000d0  
      C6AB( 6,15,4,2,1)  =   67.30880d0  
      C6AB( 6,15,4,2,2)  =    2.99870d0  
      C6AB( 6,15,4,2,3)  =    0.99470d0  
      C6AB( 6,15,4,3,1)  =   66.31940d0  
      C6AB( 6,15,4,3,2)  =    2.99870d0  
      C6AB( 6,15,4,3,3)  =    2.01020d0  
      C6AB( 6,15,4,4,1)  =   61.94330d0  
      C6AB( 6,15,4,4,2)  =    2.99870d0  
      C6AB( 6,15,4,4,3)  =    2.98590d0  
      C6AB( 6,15,5,1,1)  =   56.78520d0  
      C6AB( 6,15,5,1,2)  =    3.98440d0  
      C6AB( 6,15,5,1,3)  =    0.00000d0  
      C6AB( 6,15,5,2,1)  =   55.23750d0  
      C6AB( 6,15,5,2,2)  =    3.98440d0  
      C6AB( 6,15,5,2,3)  =    0.99470d0  
      C6AB( 6,15,5,3,1)  =   54.39410d0  
      C6AB( 6,15,5,3,2)  =    3.98440d0  
      C6AB( 6,15,5,3,3)  =    2.01020d0  
      C6AB( 6,15,5,4,1)  =   51.00480d0  
      C6AB( 6,15,5,4,2)  =    3.98440d0  
      C6AB( 6,15,5,4,3)  =    2.98590d0  
      C6AB( 6,16,1,1,1)  =   81.09190d0  
      C6AB( 6,16,1,1,2)  =    0.00000d0  
      C6AB( 6,16,1,1,3)  =    0.00000d0  
      C6AB( 6,16,1,2,1)  =   80.18040d0  
      C6AB( 6,16,1,2,2)  =    0.00000d0  
      C6AB( 6,16,1,2,3)  =    0.99480d0  
      C6AB( 6,16,1,3,1)  =   78.57290d0  
      C6AB( 6,16,1,3,2)  =    0.00000d0  
      C6AB( 6,16,1,3,3)  =    1.99030d0  
      C6AB( 6,16,2,1,1)  =   76.05520d0  
      C6AB( 6,16,2,1,2)  =    0.98680d0  
      C6AB( 6,16,2,1,3)  =    0.00000d0  
      C6AB( 6,16,2,2,1)  =   75.20390d0  
      C6AB( 6,16,2,2,2)  =    0.98680d0  
      C6AB( 6,16,2,2,3)  =    0.99480d0  
      C6AB( 6,16,2,3,1)  =   73.70060d0  
      C6AB( 6,16,2,3,2)  =    0.98680d0  
      C6AB( 6,16,2,3,3)  =    1.99030d0  
      C6AB( 6,16,3,1,1)  =   62.59530d0  
      C6AB( 6,16,3,1,2)  =    1.99850d0  
      C6AB( 6,16,3,1,3)  =    0.00000d0  
      C6AB( 6,16,3,2,1)  =   61.89160d0  
      C6AB( 6,16,3,2,2)  =    1.99850d0  
      C6AB( 6,16,3,2,3)  =    0.99480d0  
      C6AB( 6,16,3,3,1)  =   60.66900d0  
      C6AB( 6,16,3,3,2)  =    1.99850d0  
      C6AB( 6,16,3,3,3)  =    1.99030d0  
      C6AB( 6,16,4,1,1)  =   58.57760d0  
      C6AB( 6,16,4,1,2)  =    2.99870d0  
      C6AB( 6,16,4,1,3)  =    0.00000d0  
      C6AB( 6,16,4,2,1)  =   57.92210d0  
      C6AB( 6,16,4,2,2)  =    2.99870d0  
      C6AB( 6,16,4,2,3)  =    0.99480d0  
      C6AB( 6,16,4,3,1)  =   56.78260d0  
      C6AB( 6,16,4,3,2)  =    2.99870d0  
      C6AB( 6,16,4,3,3)  =    1.99030d0  
      C6AB( 6,16,5,1,1)  =   48.56810d0  
      C6AB( 6,16,5,1,2)  =    3.98440d0  
      C6AB( 6,16,5,1,3)  =    0.00000d0  
      C6AB( 6,16,5,2,1)  =   48.02210d0  
      C6AB( 6,16,5,2,2)  =    3.98440d0  
      C6AB( 6,16,5,2,3)  =    0.99480d0  
      C6AB( 6,16,5,3,1)  =   47.09430d0  
      C6AB( 6,16,5,3,2)  =    3.98440d0  
      C6AB( 6,16,5,3,3)  =    1.99030d0  
      C6AB( 6,17,1,1,1)  =   66.84070d0  
      C6AB( 6,17,1,1,2)  =    0.00000d0  
      C6AB( 6,17,1,1,3)  =    0.00000d0  
      C6AB( 6,17,1,2,1)  =   66.13540d0  
      C6AB( 6,17,1,2,2)  =    0.00000d0  
      C6AB( 6,17,1,2,3)  =    0.99720d0  
      C6AB( 6,17,2,1,1)  =   62.74650d0  
      C6AB( 6,17,2,1,2)  =    0.98680d0  
      C6AB( 6,17,2,1,3)  =    0.00000d0  
      C6AB( 6,17,2,2,1)  =   62.08640d0  
      C6AB( 6,17,2,2,2)  =    0.98680d0  
      C6AB( 6,17,2,2,3)  =    0.99720d0  
      C6AB( 6,17,3,1,1)  =   52.02080d0  
      C6AB( 6,17,3,1,2)  =    1.99850d0  
      C6AB( 6,17,3,1,3)  =    0.00000d0  
      C6AB( 6,17,3,2,1)  =   51.47210d0  
      C6AB( 6,17,3,2,2)  =    1.99850d0  
      C6AB( 6,17,3,2,3)  =    0.99720d0  
      C6AB( 6,17,4,1,1)  =   48.74480d0  
      C6AB( 6,17,4,1,2)  =    2.99870d0  
      C6AB( 6,17,4,1,3)  =    0.00000d0  
      C6AB( 6,17,4,2,1)  =   48.23280d0  
      C6AB( 6,17,4,2,2)  =    2.99870d0  
      C6AB( 6,17,4,2,3)  =    0.99720d0  
      C6AB( 6,17,5,1,1)  =   40.85160d0  
      C6AB( 6,17,5,1,2)  =    3.98440d0  
      C6AB( 6,17,5,1,3)  =    0.00000d0  
      C6AB( 6,17,5,2,1)  =   40.42090d0  
      C6AB( 6,17,5,2,2)  =    3.98440d0  
      C6AB( 6,17,5,2,3)  =    0.99720d0  
      C6AB( 7, 1,1,1,1)  =    8.71710d0  
      C6AB( 7, 1,1,1,2)  =    0.00000d0  
      C6AB( 7, 1,1,1,3)  =    0.91180d0  
      C6AB( 7, 1,1,2,1)  =   13.51640d0  
      C6AB( 7, 1,1,2,2)  =    0.00000d0  
      C6AB( 7, 1,1,2,3)  =    0.00000d0  
      C6AB( 7, 1,2,1,1)  =    8.14170d0  
      C6AB( 7, 1,2,1,2)  =    0.99440d0  
      C6AB( 7, 1,2,1,3)  =    0.91180d0  
      C6AB( 7, 1,2,2,1)  =   12.59800d0  
      C6AB( 7, 1,2,2,2)  =    0.99440d0  
      C6AB( 7, 1,2,2,3)  =    0.00000d0  
      C6AB( 7, 1,3,1,1)  =    7.66100d0  
      C6AB( 7, 1,3,1,2)  =    2.01430d0  
      C6AB( 7, 1,3,1,3)  =    0.91180d0  
      C6AB( 7, 1,3,2,1)  =   11.82140d0  
      C6AB( 7, 1,3,2,2)  =    2.01430d0  
      C6AB( 7, 1,3,2,3)  =    0.00000d0  
      C6AB( 7, 1,4,1,1)  =    6.77460d0  
      C6AB( 7, 1,4,1,2)  =    2.99030d0  
      C6AB( 7, 1,4,1,3)  =    0.91180d0  
      C6AB( 7, 1,4,2,1)  =   10.39870d0  
      C6AB( 7, 1,4,2,2)  =    2.99030d0  
      C6AB( 7, 1,4,2,3)  =    0.00000d0  
      C6AB( 7, 6,1,1,1)  =   34.81460d0  
      C6AB( 7, 6,1,1,2)  =    0.00000d0  
      C6AB( 7, 6,1,1,3)  =    0.00000d0  
      C6AB( 7, 6,1,2,1)  =   32.70090d0  
      C6AB( 7, 6,1,2,2)  =    0.00000d0  
      C6AB( 7, 6,1,2,3)  =    0.98680d0  
      C6AB( 7, 6,1,3,1)  =   27.17040d0  
      C6AB( 7, 6,1,3,2)  =    0.00000d0  
      C6AB( 7, 6,1,3,3)  =    1.99850d0  
      C6AB( 7, 6,1,4,1)  =   25.47990d0  
      C6AB( 7, 6,1,4,2)  =    0.00000d0  
      C6AB( 7, 6,1,4,3)  =    2.99870d0  
      C6AB( 7, 6,1,5,1)  =   21.41990d0  
      C6AB( 7, 6,1,5,2)  =    0.00000d0  
      C6AB( 7, 6,1,5,3)  =    3.98440d0  
      C6AB( 7, 6,2,1,1)  =   32.48480d0  
      C6AB( 7, 6,2,1,2)  =    0.99440d0  
      C6AB( 7, 6,2,1,3)  =    0.00000d0  
      C6AB( 7, 6,2,2,1)  =   30.54100d0  
      C6AB( 7, 6,2,2,2)  =    0.99440d0  
      C6AB( 7, 6,2,2,3)  =    0.98680d0  
      C6AB( 7, 6,2,3,1)  =   25.38270d0  
      C6AB( 7, 6,2,3,2)  =    0.99440d0  
      C6AB( 7, 6,2,3,3)  =    1.99850d0  
      C6AB( 7, 6,2,4,1)  =   23.81360d0  
      C6AB( 7, 6,2,4,2)  =    0.99440d0  
      C6AB( 7, 6,2,4,3)  =    2.99870d0  
      C6AB( 7, 6,2,5,1)  =   20.04680d0  
      C6AB( 7, 6,2,5,2)  =    0.99440d0  
      C6AB( 7, 6,2,5,3)  =    3.98440d0  
      C6AB( 7, 6,3,1,1)  =   30.53050d0  
      C6AB( 7, 6,3,1,2)  =    2.01430d0  
      C6AB( 7, 6,3,1,3)  =    0.00000d0  
      C6AB( 7, 6,3,2,1)  =   28.69380d0  
      C6AB( 7, 6,3,2,2)  =    2.01430d0  
      C6AB( 7, 6,3,2,3)  =    0.98680d0  
      C6AB( 7, 6,3,3,1)  =   23.89650d0  
      C6AB( 7, 6,3,3,2)  =    2.01430d0  
      C6AB( 7, 6,3,3,3)  =    1.99850d0  
      C6AB( 7, 6,3,4,1)  =   22.42790d0  
      C6AB( 7, 6,3,4,2)  =    2.01430d0  
      C6AB( 7, 6,3,4,3)  =    2.99870d0  
      C6AB( 7, 6,3,5,1)  =   18.91720d0  
      C6AB( 7, 6,3,5,2)  =    2.01430d0  
      C6AB( 7, 6,3,5,3)  =    3.98440d0  
      C6AB( 7, 6,4,1,1)  =   26.93510d0  
      C6AB( 7, 6,4,1,2)  =    2.99030d0  
      C6AB( 7, 6,4,1,3)  =    0.00000d0  
      C6AB( 7, 6,4,2,1)  =   25.33180d0  
      C6AB( 7, 6,4,2,2)  =    2.99030d0  
      C6AB( 7, 6,4,2,3)  =    0.98680d0  
      C6AB( 7, 6,4,3,1)  =   21.14880d0  
      C6AB( 7, 6,4,3,2)  =    2.99030d0  
      C6AB( 7, 6,4,3,3)  =    1.99850d0  
      C6AB( 7, 6,4,4,1)  =   19.86690d0  
      C6AB( 7, 6,4,4,2)  =    2.99030d0  
      C6AB( 7, 6,4,4,3)  =    2.99870d0  
      C6AB( 7, 6,4,5,1)  =   16.81690d0  
      C6AB( 7, 6,4,5,2)  =    2.99030d0  
      C6AB( 7, 6,4,5,3)  =    3.98440d0  
      C6AB( 7, 7,1,1,1)  =   25.26850d0  
      C6AB( 7, 7,1,1,2)  =    0.00000d0  
      C6AB( 7, 7,1,1,3)  =    0.00000d0  
      C6AB( 7, 7,1,2,1)  =   23.62950d0  
      C6AB( 7, 7,1,2,2)  =    0.00000d0  
      C6AB( 7, 7,1,2,3)  =    0.99440d0  
      C6AB( 7, 7,1,3,1)  =   22.27940d0  
      C6AB( 7, 7,1,3,2)  =    0.00000d0  
      C6AB( 7, 7,1,3,3)  =    2.01430d0  
      C6AB( 7, 7,1,4,1)  =   19.77070d0  
      C6AB( 7, 7,1,4,2)  =    0.00000d0  
      C6AB( 7, 7,1,4,3)  =    2.99030d0  
      C6AB( 7, 7,2,1,1)  =   23.62950d0  
      C6AB( 7, 7,2,1,2)  =    0.99440d0  
      C6AB( 7, 7,2,1,3)  =    0.00000d0  
      C6AB( 7, 7,2,2,1)  =   22.12410d0  
      C6AB( 7, 7,2,2,2)  =    0.99440d0  
      C6AB( 7, 7,2,2,3)  =    0.99440d0  
      C6AB( 7, 7,2,3,1)  =   20.85010d0  
      C6AB( 7, 7,2,3,2)  =    0.99440d0  
      C6AB( 7, 7,2,3,3)  =    2.01430d0  
      C6AB( 7, 7,2,4,1)  =   18.51800d0  
      C6AB( 7, 7,2,4,2)  =    0.99440d0  
      C6AB( 7, 7,2,4,3)  =    2.99030d0  
      C6AB( 7, 7,3,1,1)  =   22.27940d0  
      C6AB( 7, 7,3,1,2)  =    2.01430d0  
      C6AB( 7, 7,3,1,3)  =    0.00000d0  
      C6AB( 7, 7,3,2,1)  =   20.85010d0  
      C6AB( 7, 7,3,2,2)  =    2.01430d0  
      C6AB( 7, 7,3,2,3)  =    0.99440d0  
      C6AB( 7, 7,3,3,1)  =   19.67680d0  
      C6AB( 7, 7,3,3,2)  =    2.01430d0  
      C6AB( 7, 7,3,3,3)  =    2.01430d0  
      C6AB( 7, 7,3,4,1)  =   17.49280d0  
      C6AB( 7, 7,3,4,2)  =    2.01430d0  
      C6AB( 7, 7,3,4,3)  =    2.99030d0  
      C6AB( 7, 7,4,1,1)  =   19.77070d0  
      C6AB( 7, 7,4,1,2)  =    2.99030d0  
      C6AB( 7, 7,4,1,3)  =    0.00000d0  
      C6AB( 7, 7,4,2,1)  =   18.51800d0  
      C6AB( 7, 7,4,2,2)  =    2.99030d0  
      C6AB( 7, 7,4,2,3)  =    0.99440d0  
      C6AB( 7, 7,4,3,1)  =   17.49280d0  
      C6AB( 7, 7,4,3,2)  =    2.99030d0  
      C6AB( 7, 7,4,3,3)  =    2.01430d0  
      C6AB( 7, 7,4,4,1)  =   15.58170d0  
      C6AB( 7, 7,4,4,2)  =    2.99030d0  
      C6AB( 7, 7,4,4,3)  =    2.99030d0  
      C6AB( 7, 8,1,1,1)  =   19.65460d0  
      C6AB( 7, 8,1,1,2)  =    0.00000d0  
      C6AB( 7, 8,1,1,3)  =    0.00000d0  
      C6AB( 7, 8,1,2,1)  =   17.76980d0  
      C6AB( 7, 8,1,2,2)  =    0.00000d0  
      C6AB( 7, 8,1,2,3)  =    0.99250d0  
      C6AB( 7, 8,1,3,1)  =   15.83640d0  
      C6AB( 7, 8,1,3,2)  =    0.00000d0  
      C6AB( 7, 8,1,3,3)  =    1.98870d0  
      C6AB( 7, 8,2,1,1)  =   18.41280d0  
      C6AB( 7, 8,2,1,2)  =    0.99440d0  
      C6AB( 7, 8,2,1,3)  =    0.00000d0  
      C6AB( 7, 8,2,2,1)  =   16.67750d0  
      C6AB( 7, 8,2,2,2)  =    0.99440d0  
      C6AB( 7, 8,2,2,3)  =    0.99250d0  
      C6AB( 7, 8,2,3,1)  =   14.86000d0  
      C6AB( 7, 8,2,3,2)  =    0.99440d0  
      C6AB( 7, 8,2,3,3)  =    1.98870d0  
      C6AB( 7, 8,3,1,1)  =   17.40930d0  
      C6AB( 7, 8,3,1,2)  =    2.01430d0  
      C6AB( 7, 8,3,1,3)  =    0.00000d0  
      C6AB( 7, 8,3,2,1)  =   15.76310d0  
      C6AB( 7, 8,3,2,2)  =    2.01430d0  
      C6AB( 7, 8,3,2,3)  =    0.99250d0  
      C6AB( 7, 8,3,3,1)  =   14.08070d0  
      C6AB( 7, 8,3,3,2)  =    2.01430d0  
      C6AB( 7, 8,3,3,3)  =    1.98870d0  
      C6AB( 7, 8,4,1,1)  =   15.52490d0  
      C6AB( 7, 8,4,1,2)  =    2.99030d0  
      C6AB( 7, 8,4,1,3)  =    0.00000d0  
      C6AB( 7, 8,4,2,1)  =   14.07930d0  
      C6AB( 7, 8,4,2,2)  =    2.99030d0  
      C6AB( 7, 8,4,2,3)  =    0.99250d0  
      C6AB( 7, 8,4,3,1)  =   12.60770d0  
      C6AB( 7, 8,4,3,2)  =    2.99030d0  
      C6AB( 7, 8,4,3,3)  =    1.98870d0  
      C6AB( 7,15,1,1,1)  =   67.78730d0  
      C6AB( 7,15,1,1,2)  =    0.00000d0  
      C6AB( 7,15,1,1,3)  =    0.00000d0  
      C6AB( 7,15,1,2,1)  =   65.91270d0  
      C6AB( 7,15,1,2,2)  =    0.00000d0  
      C6AB( 7,15,1,2,3)  =    0.99470d0  
      C6AB( 7,15,1,3,1)  =   64.92090d0  
      C6AB( 7,15,1,3,2)  =    0.00000d0  
      C6AB( 7,15,1,3,3)  =    2.01020d0  
      C6AB( 7,15,1,4,1)  =   60.76630d0  
      C6AB( 7,15,1,4,2)  =    0.00000d0  
      C6AB( 7,15,1,4,3)  =    2.98590d0  
      C6AB( 7,15,2,1,1)  =   63.16690d0  
      C6AB( 7,15,2,1,2)  =    0.99440d0  
      C6AB( 7,15,2,1,3)  =    0.00000d0  
      C6AB( 7,15,2,2,1)  =   61.42860d0  
      C6AB( 7,15,2,2,2)  =    0.99440d0  
      C6AB( 7,15,2,2,3)  =    0.99470d0  
      C6AB( 7,15,2,3,1)  =   60.50850d0  
      C6AB( 7,15,2,3,2)  =    0.99440d0  
      C6AB( 7,15,2,3,3)  =    2.01020d0  
      C6AB( 7,15,2,4,1)  =   56.65080d0  
      C6AB( 7,15,2,4,2)  =    0.99440d0  
      C6AB( 7,15,2,4,3)  =    2.98590d0  
      C6AB( 7,15,3,1,1)  =   59.28590d0  
      C6AB( 7,15,3,1,2)  =    2.01430d0  
      C6AB( 7,15,3,1,3)  =    0.00000d0  
      C6AB( 7,15,3,2,1)  =   57.66320d0  
      C6AB( 7,15,3,2,2)  =    2.01430d0  
      C6AB( 7,15,3,2,3)  =    0.99470d0  
      C6AB( 7,15,3,3,1)  =   56.79810d0  
      C6AB( 7,15,3,3,2)  =    2.01430d0  
      C6AB( 7,15,3,3,3)  =    2.01020d0  
      C6AB( 7,15,3,4,1)  =   53.20760d0  
      C6AB( 7,15,3,4,2)  =    2.01430d0  
      C6AB( 7,15,3,4,3)  =    2.98590d0  
      C6AB( 7,15,4,1,1)  =   52.15090d0  
      C6AB( 7,15,4,1,2)  =    2.99030d0  
      C6AB( 7,15,4,1,3)  =    0.00000d0  
      C6AB( 7,15,4,2,1)  =   50.73980d0  
      C6AB( 7,15,4,2,2)  =    2.99030d0  
      C6AB( 7,15,4,2,3)  =    0.99470d0  
      C6AB( 7,15,4,3,1)  =   49.98180d0  
      C6AB( 7,15,4,3,2)  =    2.99030d0  
      C6AB( 7,15,4,3,3)  =    2.01020d0  
      C6AB( 7,15,4,4,1)  =   46.86350d0  
      C6AB( 7,15,4,4,2)  =    2.99030d0  
      C6AB( 7,15,4,4,3)  =    2.98590d0  
      C6AB( 7,16,1,1,1)  =   57.67340d0  
      C6AB( 7,16,1,1,2)  =    0.00000d0  
      C6AB( 7,16,1,1,3)  =    0.00000d0  
      C6AB( 7,16,1,2,1)  =   57.02550d0  
      C6AB( 7,16,1,2,2)  =    0.00000d0  
      C6AB( 7,16,1,2,3)  =    0.99480d0  
      C6AB( 7,16,1,3,1)  =   55.91360d0  
      C6AB( 7,16,1,3,2)  =    0.00000d0  
      C6AB( 7,16,1,3,3)  =    1.99030d0  
      C6AB( 7,16,2,1,1)  =   53.81070d0  
      C6AB( 7,16,2,1,2)  =    0.99440d0  
      C6AB( 7,16,2,1,3)  =    0.00000d0  
      C6AB( 7,16,2,2,1)  =   53.20860d0  
      C6AB( 7,16,2,2,2)  =    0.99440d0  
      C6AB( 7,16,2,2,3)  =    0.99480d0  
      C6AB( 7,16,2,3,1)  =   52.17530d0  
      C6AB( 7,16,2,3,2)  =    0.99440d0  
      C6AB( 7,16,2,3,3)  =    1.99030d0  
      C6AB( 7,16,3,1,1)  =   50.59460d0  
      C6AB( 7,16,3,1,2)  =    2.01430d0  
      C6AB( 7,16,3,1,3)  =    0.00000d0  
      C6AB( 7,16,3,2,1)  =   50.02980d0  
      C6AB( 7,16,3,2,2)  =    2.01430d0  
      C6AB( 7,16,3,2,3)  =    0.99480d0  
      C6AB( 7,16,3,3,1)  =   49.06290d0  
      C6AB( 7,16,3,3,2)  =    2.01430d0  
      C6AB( 7,16,3,3,3)  =    1.99030d0  
      C6AB( 7,16,4,1,1)  =   44.65290d0  
      C6AB( 7,16,4,1,2)  =    2.99030d0  
      C6AB( 7,16,4,1,3)  =    0.00000d0  
      C6AB( 7,16,4,2,1)  =   44.15810d0  
      C6AB( 7,16,4,2,2)  =    2.99030d0  
      C6AB( 7,16,4,2,3)  =    0.99480d0  
      C6AB( 7,16,4,3,1)  =   43.31300d0  
      C6AB( 7,16,4,3,2)  =    2.99030d0  
      C6AB( 7,16,4,3,3)  =    1.99030d0  
      C6AB( 7,17,1,1,1)  =   48.26240d0  
      C6AB( 7,17,1,1,2)  =    0.00000d0  
      C6AB( 7,17,1,1,3)  =    0.00000d0  
      C6AB( 7,17,1,2,1)  =   47.75400d0  
      C6AB( 7,17,1,2,2)  =    0.00000d0  
      C6AB( 7,17,1,2,3)  =    0.99720d0  
      C6AB( 7,17,2,1,1)  =   45.09520d0  
      C6AB( 7,17,2,1,2)  =    0.99440d0  
      C6AB( 7,17,2,1,3)  =    0.00000d0  
      C6AB( 7,17,2,2,1)  =   44.62170d0  
      C6AB( 7,17,2,2,2)  =    0.99440d0  
      C6AB( 7,17,2,2,3)  =    0.99720d0  
      C6AB( 7,17,3,1,1)  =   42.48160d0  
      C6AB( 7,17,3,1,2)  =    2.01430d0  
      C6AB( 7,17,3,1,3)  =    0.00000d0  
      C6AB( 7,17,3,2,1)  =   42.03670d0  
      C6AB( 7,17,3,2,2)  =    2.01430d0  
      C6AB( 7,17,3,2,3)  =    0.99720d0  
      C6AB( 7,17,4,1,1)  =   37.62950d0  
      C6AB( 7,17,4,1,2)  =    2.99030d0  
      C6AB( 7,17,4,1,3)  =    0.00000d0  
      C6AB( 7,17,4,2,1)  =   37.23810d0  
      C6AB( 7,17,4,2,2)  =    2.99030d0  
      C6AB( 7,17,4,2,3)  =    0.99720d0  
      C6AB( 8, 1,1,1,1)  =    6.71800d0  
      C6AB( 8, 1,1,1,2)  =    0.00000d0  
      C6AB( 8, 1,1,1,3)  =    0.91180d0  
      C6AB( 8, 1,1,2,1)  =   10.23710d0  
      C6AB( 8, 1,1,2,2)  =    0.00000d0  
      C6AB( 8, 1,1,2,3)  =    0.00000d0  
      C6AB( 8, 1,2,1,1)  =    6.05750d0  
      C6AB( 8, 1,2,1,2)  =    0.99250d0  
      C6AB( 8, 1,2,1,3)  =    0.91180d0  
      C6AB( 8, 1,2,2,1)  =    9.18120d0  
      C6AB( 8, 1,2,2,2)  =    0.99250d0  
      C6AB( 8, 1,2,2,3)  =    0.00000d0  
      C6AB( 8, 1,3,1,1)  =    5.37170d0  
      C6AB( 8, 1,3,1,2)  =    1.98870d0  
      C6AB( 8, 1,3,1,3)  =    0.91180d0  
      C6AB( 8, 1,3,2,1)  =    8.08480d0  
      C6AB( 8, 1,3,2,2)  =    1.98870d0  
      C6AB( 8, 1,3,2,3)  =    0.00000d0  
      C6AB( 8, 6,1,1,1)  =   26.59290d0  
      C6AB( 8, 6,1,1,2)  =    0.00000d0  
      C6AB( 8, 6,1,1,3)  =    0.00000d0  
      C6AB( 8, 6,1,2,1)  =   25.00970d0  
      C6AB( 8, 6,1,2,2)  =    0.00000d0  
      C6AB( 8, 6,1,2,3)  =    0.98680d0  
      C6AB( 8, 6,1,3,1)  =   20.95970d0  
      C6AB( 8, 6,1,3,2)  =    0.00000d0  
      C6AB( 8, 6,1,3,3)  =    1.99850d0  
      C6AB( 8, 6,1,4,1)  =   19.69430d0  
      C6AB( 8, 6,1,4,2)  =    0.00000d0  
      C6AB( 8, 6,1,4,3)  =    2.99870d0  
      C6AB( 8, 6,1,5,1)  =   16.75440d0  
      C6AB( 8, 6,1,5,2)  =    0.00000d0  
      C6AB( 8, 6,1,5,3)  =    3.98440d0  
      C6AB( 8, 6,2,1,1)  =   23.91200d0  
      C6AB( 8, 6,2,1,2)  =    0.99250d0  
      C6AB( 8, 6,2,1,3)  =    0.00000d0  
      C6AB( 8, 6,2,2,1)  =   22.51780d0  
      C6AB( 8, 6,2,2,2)  =    0.99250d0  
      C6AB( 8, 6,2,2,3)  =    0.98680d0  
      C6AB( 8, 6,2,3,1)  =   18.90340d0  
      C6AB( 8, 6,2,3,2)  =    0.99250d0  
      C6AB( 8, 6,2,3,3)  =    1.99850d0  
      C6AB( 8, 6,2,4,1)  =   17.77500d0  
      C6AB( 8, 6,2,4,2)  =    0.99250d0  
      C6AB( 8, 6,2,4,3)  =    2.99870d0  
      C6AB( 8, 6,2,5,1)  =   15.17510d0  
      C6AB( 8, 6,2,5,2)  =    0.99250d0  
      C6AB( 8, 6,2,5,3)  =    3.98440d0  
      C6AB( 8, 6,3,1,1)  =   21.14280d0  
      C6AB( 8, 6,3,1,2)  =    1.98870d0  
      C6AB( 8, 6,3,1,3)  =    0.00000d0  
      C6AB( 8, 6,3,2,1)  =   19.90900d0  
      C6AB( 8, 6,3,2,2)  =    1.98870d0  
      C6AB( 8, 6,3,2,3)  =    0.98680d0  
      C6AB( 8, 6,3,3,1)  =   16.78550d0  
      C6AB( 8, 6,3,3,2)  =    1.98870d0  
      C6AB( 8, 6,3,3,3)  =    1.99850d0  
      C6AB( 8, 6,3,4,1)  =   15.80090d0  
      C6AB( 8, 6,3,4,2)  =    1.98870d0  
      C6AB( 8, 6,3,4,3)  =    2.99870d0  
      C6AB( 8, 6,3,5,1)  =   13.55250d0  
      C6AB( 8, 6,3,5,2)  =    1.98870d0  
      C6AB( 8, 6,3,5,3)  =    3.98440d0  
      C6AB( 8, 7,1,1,1)  =   19.65460d0  
      C6AB( 8, 7,1,1,2)  =    0.00000d0  
      C6AB( 8, 7,1,1,3)  =    0.00000d0  
      C6AB( 8, 7,1,2,1)  =   18.41280d0  
      C6AB( 8, 7,1,2,2)  =    0.00000d0  
      C6AB( 8, 7,1,2,3)  =    0.99440d0  
      C6AB( 8, 7,1,3,1)  =   17.40930d0  
      C6AB( 8, 7,1,3,2)  =    0.00000d0  
      C6AB( 8, 7,1,3,3)  =    2.01430d0  
      C6AB( 8, 7,1,4,1)  =   15.52490d0  
      C6AB( 8, 7,1,4,2)  =    0.00000d0  
      C6AB( 8, 7,1,4,3)  =    2.99030d0  
      C6AB( 8, 7,2,1,1)  =   17.76980d0  
      C6AB( 8, 7,2,1,2)  =    0.99250d0  
      C6AB( 8, 7,2,1,3)  =    0.00000d0  
      C6AB( 8, 7,2,2,1)  =   16.67750d0  
      C6AB( 8, 7,2,2,2)  =    0.99250d0  
      C6AB( 8, 7,2,2,3)  =    0.99440d0  
      C6AB( 8, 7,2,3,1)  =   15.76310d0  
      C6AB( 8, 7,2,3,2)  =    0.99250d0  
      C6AB( 8, 7,2,3,3)  =    2.01430d0  
      C6AB( 8, 7,2,4,1)  =   14.07930d0  
      C6AB( 8, 7,2,4,2)  =    0.99250d0  
      C6AB( 8, 7,2,4,3)  =    2.99030d0  
      C6AB( 8, 7,3,1,1)  =   15.83640d0  
      C6AB( 8, 7,3,1,2)  =    1.98870d0  
      C6AB( 8, 7,3,1,3)  =    0.00000d0  
      C6AB( 8, 7,3,2,1)  =   14.86000d0  
      C6AB( 8, 7,3,2,2)  =    1.98870d0  
      C6AB( 8, 7,3,2,3)  =    0.99440d0  
      C6AB( 8, 7,3,3,1)  =   14.08070d0  
      C6AB( 8, 7,3,3,2)  =    1.98870d0  
      C6AB( 8, 7,3,3,3)  =    2.01430d0  
      C6AB( 8, 7,3,4,1)  =   12.60770d0  
      C6AB( 8, 7,3,4,2)  =    1.98870d0  
      C6AB( 8, 7,3,4,3)  =    2.99030d0  
      C6AB( 8, 8,1,1,1)  =   15.50590d0  
      C6AB( 8, 8,1,1,2)  =    0.00000d0  
      C6AB( 8, 8,1,1,3)  =    0.00000d0  
      C6AB( 8, 8,1,2,1)  =   14.07640d0  
      C6AB( 8, 8,1,2,2)  =    0.00000d0  
      C6AB( 8, 8,1,2,3)  =    0.99250d0  
      C6AB( 8, 8,1,3,1)  =   12.62770d0  
      C6AB( 8, 8,1,3,2)  =    0.00000d0  
      C6AB( 8, 8,1,3,3)  =    1.98870d0  
      C6AB( 8, 8,2,1,1)  =   14.07640d0  
      C6AB( 8, 8,2,1,2)  =    0.99250d0  
      C6AB( 8, 8,2,1,3)  =    0.00000d0  
      C6AB( 8, 8,2,2,1)  =   12.81610d0  
      C6AB( 8, 8,2,2,2)  =    0.99250d0  
      C6AB( 8, 8,2,2,3)  =    0.99250d0  
      C6AB( 8, 8,2,3,1)  =   11.50090d0  
      C6AB( 8, 8,2,3,2)  =    0.99250d0  
      C6AB( 8, 8,2,3,3)  =    1.98870d0  
      C6AB( 8, 8,3,1,1)  =   12.62770d0  
      C6AB( 8, 8,3,1,2)  =    1.98870d0  
      C6AB( 8, 8,3,1,3)  =    0.00000d0  
      C6AB( 8, 8,3,2,1)  =   11.50090d0  
      C6AB( 8, 8,3,2,2)  =    1.98870d0  
      C6AB( 8, 8,3,2,3)  =    0.99250d0  
      C6AB( 8, 8,3,3,1)  =   10.37080d0  
      C6AB( 8, 8,3,3,2)  =    1.98870d0  
      C6AB( 8, 8,3,3,3)  =    1.98870d0  
      C6AB( 8,15,1,1,1)  =   51.30980d0  
      C6AB( 8,15,1,1,2)  =    0.00000d0  
      C6AB( 8,15,1,1,3)  =    0.00000d0  
      C6AB( 8,15,1,2,1)  =   49.93740d0  
      C6AB( 8,15,1,2,2)  =    0.00000d0  
      C6AB( 8,15,1,2,3)  =    0.99470d0  
      C6AB( 8,15,1,3,1)  =   49.17290d0  
      C6AB( 8,15,1,3,2)  =    0.00000d0  
      C6AB( 8,15,1,3,3)  =    2.01020d0  
      C6AB( 8,15,1,4,1)  =   46.19270d0  
      C6AB( 8,15,1,4,2)  =    0.00000d0  
      C6AB( 8,15,1,4,3)  =    2.98590d0  
      C6AB( 8,15,2,1,1)  =   45.99370d0  
      C6AB( 8,15,2,1,2)  =    0.99250d0  
      C6AB( 8,15,2,1,3)  =    0.00000d0  
      C6AB( 8,15,2,2,1)  =   44.77700d0  
      C6AB( 8,15,2,2,2)  =    0.99250d0  
      C6AB( 8,15,2,2,3)  =    0.99470d0  
      C6AB( 8,15,2,3,1)  =   44.09040d0  
      C6AB( 8,15,2,3,2)  =    0.99250d0  
      C6AB( 8,15,2,3,3)  =    2.01020d0  
      C6AB( 8,15,2,4,1)  =   41.46000d0  
      C6AB( 8,15,2,4,2)  =    0.99250d0  
      C6AB( 8,15,2,4,3)  =    2.98590d0  
      C6AB( 8,15,3,1,1)  =   40.51670d0  
      C6AB( 8,15,3,1,2)  =    1.98870d0  
      C6AB( 8,15,3,1,3)  =    0.00000d0  
      C6AB( 8,15,3,2,1)  =   39.46170d0  
      C6AB( 8,15,3,2,2)  =    1.98870d0  
      C6AB( 8,15,3,2,3)  =    0.99470d0  
      C6AB( 8,15,3,3,1)  =   38.85780d0  
      C6AB( 8,15,3,3,2)  =    1.98870d0  
      C6AB( 8,15,3,3,3)  =    2.01020d0  
      C6AB( 8,15,3,4,1)  =   36.58750d0  
      C6AB( 8,15,3,4,2)  =    1.98870d0  
      C6AB( 8,15,3,4,3)  =    2.98590d0  
      C6AB( 8,16,1,1,1)  =   44.14700d0  
      C6AB( 8,16,1,1,2)  =    0.00000d0  
      C6AB( 8,16,1,1,3)  =    0.00000d0  
      C6AB( 8,16,1,2,1)  =   43.65480d0  
      C6AB( 8,16,1,2,2)  =    0.00000d0  
      C6AB( 8,16,1,2,3)  =    0.99480d0  
      C6AB( 8,16,1,3,1)  =   42.82450d0  
      C6AB( 8,16,1,3,2)  =    0.00000d0  
      C6AB( 8,16,1,3,3)  =    1.99030d0  
      C6AB( 8,16,2,1,1)  =   39.70910d0  
      C6AB( 8,16,2,1,2)  =    0.99250d0  
      C6AB( 8,16,2,1,3)  =    0.00000d0  
      C6AB( 8,16,2,2,1)  =   39.26830d0  
      C6AB( 8,16,2,2,2)  =    0.99250d0  
      C6AB( 8,16,2,2,3)  =    0.99480d0  
      C6AB( 8,16,2,3,1)  =   38.52760d0  
      C6AB( 8,16,2,3,2)  =    0.99250d0  
      C6AB( 8,16,2,3,3)  =    1.99030d0  
      C6AB( 8,16,3,1,1)  =   35.13770d0  
      C6AB( 8,16,3,1,2)  =    1.98870d0  
      C6AB( 8,16,3,1,3)  =    0.00000d0  
      C6AB( 8,16,3,2,1)  =   34.75100d0  
      C6AB( 8,16,3,2,2)  =    1.98870d0  
      C6AB( 8,16,3,2,3)  =    0.99480d0  
      C6AB( 8,16,3,3,1)  =   34.10420d0  
      C6AB( 8,16,3,3,2)  =    1.98870d0  
      C6AB( 8,16,3,3,3)  =    1.99030d0  
      C6AB( 8,17,1,1,1)  =   37.36880d0  
      C6AB( 8,17,1,1,2)  =    0.00000d0  
      C6AB( 8,17,1,1,3)  =    0.00000d0  
      C6AB( 8,17,1,2,1)  =   36.97830d0  
      C6AB( 8,17,1,2,2)  =    0.00000d0  
      C6AB( 8,17,1,2,3)  =    0.99720d0  
      C6AB( 8,17,2,1,1)  =   33.73130d0  
      C6AB( 8,17,2,1,2)  =    0.99250d0  
      C6AB( 8,17,2,1,3)  =    0.00000d0  
      C6AB( 8,17,2,2,1)  =   33.38010d0  
      C6AB( 8,17,2,2,2)  =    0.99250d0  
      C6AB( 8,17,2,2,3)  =    0.99720d0  
      C6AB( 8,17,3,1,1)  =   29.99180d0  
      C6AB( 8,17,3,1,2)  =    1.98870d0  
      C6AB( 8,17,3,1,3)  =    0.00000d0  
      C6AB( 8,17,3,2,1)  =   29.68220d0  
      C6AB( 8,17,3,2,2)  =    1.98870d0  
      C6AB( 8,17,3,2,3)  =    0.99720d0  
      C6AB(15, 1,1,1,1)  =   23.76040d0  
      C6AB(15, 1,1,1,2)  =    0.00000d0  
      C6AB(15, 1,1,1,3)  =    0.91180d0  
      C6AB(15, 1,1,2,1)  =   38.13970d0  
      C6AB(15, 1,1,2,2)  =    0.00000d0  
      C6AB(15, 1,1,2,3)  =    0.00000d0  
      C6AB(15, 1,2,1,1)  =   23.09080d0  
      C6AB(15, 1,2,1,2)  =    0.99470d0  
      C6AB(15, 1,2,1,3)  =    0.91180d0  
      C6AB(15, 1,2,2,1)  =   37.02360d0  
      C6AB(15, 1,2,2,2)  =    0.99470d0  
      C6AB(15, 1,2,2,3)  =    0.00000d0  
      C6AB(15, 1,3,1,1)  =   22.74290d0  
      C6AB(15, 1,3,1,2)  =    2.01020d0  
      C6AB(15, 1,3,1,3)  =    0.91180d0  
      C6AB(15, 1,3,2,1)  =   36.49360d0  
      C6AB(15, 1,3,2,2)  =    2.01020d0  
      C6AB(15, 1,3,2,3)  =    0.00000d0  
      C6AB(15, 1,4,1,1)  =   21.25070d0  
      C6AB(15, 1,4,1,2)  =    2.98590d0  
      C6AB(15, 1,4,1,3)  =    0.91180d0  
      C6AB(15, 1,4,2,1)  =   33.91930d0  
      C6AB(15, 1,4,2,2)  =    2.98590d0  
      C6AB(15, 1,4,2,3)  =    0.00000d0  
      C6AB(15, 6,1,1,1)  =   96.75030d0  
      C6AB(15, 6,1,1,2)  =    0.00000d0  
      C6AB(15, 6,1,1,3)  =    0.00000d0  
      C6AB(15, 6,1,2,1)  =   90.67670d0  
      C6AB(15, 6,1,2,2)  =    0.00000d0  
      C6AB(15, 6,1,2,3)  =    0.98680d0  
      C6AB(15, 6,1,3,1)  =   74.07840d0  
      C6AB(15, 6,1,3,2)  =    0.00000d0  
      C6AB(15, 6,1,3,3)  =    1.99850d0  
      C6AB(15, 6,1,4,1)  =   69.25150d0  
      C6AB(15, 6,1,4,2)  =    0.00000d0  
      C6AB(15, 6,1,4,3)  =    2.99870d0  
      C6AB(15, 6,1,5,1)  =   56.78520d0  
      C6AB(15, 6,1,5,2)  =    0.00000d0  
      C6AB(15, 6,1,5,3)  =    3.98440d0  
      C6AB(15, 6,2,1,1)  =   93.96630d0  
      C6AB(15, 6,2,1,2)  =    0.99470d0  
      C6AB(15, 6,2,1,3)  =    0.00000d0  
      C6AB(15, 6,2,2,1)  =   88.07690d0  
      C6AB(15, 6,2,2,2)  =    0.99470d0  
      C6AB(15, 6,2,2,3)  =    0.98680d0  
      C6AB(15, 6,2,3,1)  =   71.99140d0  
      C6AB(15, 6,2,3,2)  =    0.99470d0  
      C6AB(15, 6,2,3,3)  =    1.99850d0  
      C6AB(15, 6,2,4,1)  =   67.30880d0  
      C6AB(15, 6,2,4,2)  =    0.99470d0  
      C6AB(15, 6,2,4,3)  =    2.99870d0  
      C6AB(15, 6,2,5,1)  =   55.23750d0  
      C6AB(15, 6,2,5,2)  =    0.99470d0  
      C6AB(15, 6,2,5,3)  =    3.98440d0  
      C6AB(15, 6,3,1,1)  =   92.60800d0  
      C6AB(15, 6,3,1,2)  =    2.01020d0  
      C6AB(15, 6,3,1,3)  =    0.00000d0  
      C6AB(15, 6,3,2,1)  =   86.81280d0  
      C6AB(15, 6,3,2,2)  =    2.01020d0  
      C6AB(15, 6,3,2,3)  =    0.98680d0  
      C6AB(15, 6,3,3,1)  =   70.92690d0  
      C6AB(15, 6,3,3,2)  =    2.01020d0  
      C6AB(15, 6,3,3,3)  =    1.99850d0  
      C6AB(15, 6,3,4,1)  =   66.31940d0  
      C6AB(15, 6,3,4,2)  =    2.01020d0  
      C6AB(15, 6,3,4,3)  =    2.99870d0  
      C6AB(15, 6,3,5,1)  =   54.39410d0  
      C6AB(15, 6,3,5,2)  =    2.01020d0  
      C6AB(15, 6,3,5,3)  =    3.98440d0  
      C6AB(15, 6,4,1,1)  =   86.24270d0  
      C6AB(15, 6,4,1,2)  =    2.98590d0  
      C6AB(15, 6,4,1,3)  =    0.00000d0  
      C6AB(15, 6,4,2,1)  =   80.84960d0  
      C6AB(15, 6,4,2,2)  =    2.98590d0  
      C6AB(15, 6,4,2,3)  =    0.98680d0  
      C6AB(15, 6,4,3,1)  =   66.23430d0  
      C6AB(15, 6,4,3,2)  =    2.98590d0  
      C6AB(15, 6,4,3,3)  =    1.99850d0  
      C6AB(15, 6,4,4,1)  =   61.94330d0  
      C6AB(15, 6,4,4,2)  =    2.98590d0  
      C6AB(15, 6,4,4,3)  =    2.99870d0  
      C6AB(15, 6,4,5,1)  =   51.00480d0  
      C6AB(15, 6,4,5,2)  =    2.98590d0  
      C6AB(15, 6,4,5,3)  =    3.98440d0  
      C6AB(15, 7,1,1,1)  =   67.78730d0  
      C6AB(15, 7,1,1,2)  =    0.00000d0  
      C6AB(15, 7,1,1,3)  =    0.00000d0  
      C6AB(15, 7,1,2,1)  =   63.16690d0  
      C6AB(15, 7,1,2,2)  =    0.00000d0  
      C6AB(15, 7,1,2,3)  =    0.99440d0  
      C6AB(15, 7,1,3,1)  =   59.28590d0  
      C6AB(15, 7,1,3,2)  =    0.00000d0  
      C6AB(15, 7,1,3,3)  =    2.01430d0  
      C6AB(15, 7,1,4,1)  =   52.15090d0  
      C6AB(15, 7,1,4,2)  =    0.00000d0  
      C6AB(15, 7,1,4,3)  =    2.99030d0  
      C6AB(15, 7,2,1,1)  =   65.91270d0  
      C6AB(15, 7,2,1,2)  =    0.99470d0  
      C6AB(15, 7,2,1,3)  =    0.00000d0  
      C6AB(15, 7,2,2,1)  =   61.42860d0  
      C6AB(15, 7,2,2,2)  =    0.99470d0  
      C6AB(15, 7,2,2,3)  =    0.99440d0  
      C6AB(15, 7,2,3,1)  =   57.66320d0  
      C6AB(15, 7,2,3,2)  =    0.99470d0  
      C6AB(15, 7,2,3,3)  =    2.01430d0  
      C6AB(15, 7,2,4,1)  =   50.73980d0  
      C6AB(15, 7,2,4,2)  =    0.99470d0  
      C6AB(15, 7,2,4,3)  =    2.99030d0  
      C6AB(15, 7,3,1,1)  =   64.92090d0  
      C6AB(15, 7,3,1,2)  =    2.01020d0  
      C6AB(15, 7,3,1,3)  =    0.00000d0  
      C6AB(15, 7,3,2,1)  =   60.50850d0  
      C6AB(15, 7,3,2,2)  =    2.01020d0  
      C6AB(15, 7,3,2,3)  =    0.99440d0  
      C6AB(15, 7,3,3,1)  =   56.79810d0  
      C6AB(15, 7,3,3,2)  =    2.01020d0  
      C6AB(15, 7,3,3,3)  =    2.01430d0  
      C6AB(15, 7,3,4,1)  =   49.98180d0  
      C6AB(15, 7,3,4,2)  =    2.01020d0  
      C6AB(15, 7,3,4,3)  =    2.99030d0  
      C6AB(15, 7,4,1,1)  =   60.76630d0  
      C6AB(15, 7,4,1,2)  =    2.98590d0  
      C6AB(15, 7,4,1,3)  =    0.00000d0  
      C6AB(15, 7,4,2,1)  =   56.65080d0  
      C6AB(15, 7,4,2,2)  =    2.98590d0  
      C6AB(15, 7,4,2,3)  =    0.99440d0  
      C6AB(15, 7,4,3,1)  =   53.20760d0  
      C6AB(15, 7,4,3,2)  =    2.98590d0  
      C6AB(15, 7,4,3,3)  =    2.01430d0  
      C6AB(15, 7,4,4,1)  =   46.86350d0  
      C6AB(15, 7,4,4,2)  =    2.98590d0  
      C6AB(15, 7,4,4,3)  =    2.99030d0  
      C6AB(15, 8,1,1,1)  =   51.30980d0  
      C6AB(15, 8,1,1,2)  =    0.00000d0  
      C6AB(15, 8,1,1,3)  =    0.00000d0  
      C6AB(15, 8,1,2,1)  =   45.99370d0  
      C6AB(15, 8,1,2,2)  =    0.00000d0  
      C6AB(15, 8,1,2,3)  =    0.99250d0  
      C6AB(15, 8,1,3,1)  =   40.51670d0  
      C6AB(15, 8,1,3,2)  =    0.00000d0  
      C6AB(15, 8,1,3,3)  =    1.98870d0  
      C6AB(15, 8,2,1,1)  =   49.93740d0  
      C6AB(15, 8,2,1,2)  =    0.99470d0  
      C6AB(15, 8,2,1,3)  =    0.00000d0  
      C6AB(15, 8,2,2,1)  =   44.77700d0  
      C6AB(15, 8,2,2,2)  =    0.99470d0  
      C6AB(15, 8,2,2,3)  =    0.99250d0  
      C6AB(15, 8,2,3,1)  =   39.46170d0  
      C6AB(15, 8,2,3,2)  =    0.99470d0  
      C6AB(15, 8,2,3,3)  =    1.98870d0  
      C6AB(15, 8,3,1,1)  =   49.17290d0  
      C6AB(15, 8,3,1,2)  =    2.01020d0  
      C6AB(15, 8,3,1,3)  =    0.00000d0  
      C6AB(15, 8,3,2,1)  =   44.09040d0  
      C6AB(15, 8,3,2,2)  =    2.01020d0  
      C6AB(15, 8,3,2,3)  =    0.99250d0  
      C6AB(15, 8,3,3,1)  =   38.85780d0  
      C6AB(15, 8,3,3,2)  =    2.01020d0  
      C6AB(15, 8,3,3,3)  =    1.98870d0  
      C6AB(15, 8,4,1,1)  =   46.19270d0  
      C6AB(15, 8,4,1,2)  =    2.98590d0  
      C6AB(15, 8,4,1,3)  =    0.00000d0  
      C6AB(15, 8,4,2,1)  =   41.46000d0  
      C6AB(15, 8,4,2,2)  =    2.98590d0  
      C6AB(15, 8,4,2,3)  =    0.99250d0  
      C6AB(15, 8,4,3,1)  =   36.58750d0  
      C6AB(15, 8,4,3,2)  =    2.98590d0  
      C6AB(15, 8,4,3,3)  =    1.98870d0  
      C6AB(15,15,1,1,1)  =  191.68870d0  
      C6AB(15,15,1,1,2)  =    0.00000d0  
      C6AB(15,15,1,1,3)  =    0.00000d0  
      C6AB(15,15,1,2,1)  =  186.06840d0  
      C6AB(15,15,1,2,2)  =    0.00000d0  
      C6AB(15,15,1,2,3)  =    0.99470d0  
      C6AB(15,15,1,3,1)  =  183.43220d0  
      C6AB(15,15,1,3,2)  =    0.00000d0  
      C6AB(15,15,1,3,3)  =    2.01020d0  
      C6AB(15,15,1,4,1)  =  170.40450d0  
      C6AB(15,15,1,4,2)  =    0.00000d0  
      C6AB(15,15,1,4,3)  =    2.98590d0  
      C6AB(15,15,2,1,1)  =  186.06840d0  
      C6AB(15,15,2,1,2)  =    0.99470d0  
      C6AB(15,15,2,1,3)  =    0.00000d0  
      C6AB(15,15,2,2,1)  =  180.62380d0  
      C6AB(15,15,2,2,2)  =    0.99470d0  
      C6AB(15,15,2,2,3)  =    0.99470d0  
      C6AB(15,15,2,3,1)  =  178.06220d0  
      C6AB(15,15,2,3,2)  =    0.99470d0  
      C6AB(15,15,2,3,3)  =    2.01020d0  
      C6AB(15,15,2,4,1)  =  165.45180d0  
      C6AB(15,15,2,4,2)  =    0.99470d0  
      C6AB(15,15,2,4,3)  =    2.98590d0  
      C6AB(15,15,3,1,1)  =  183.43220d0  
      C6AB(15,15,3,1,2)  =    2.01020d0  
      C6AB(15,15,3,1,3)  =    0.00000d0  
      C6AB(15,15,3,2,1)  =  178.06220d0  
      C6AB(15,15,3,2,2)  =    2.01020d0  
      C6AB(15,15,3,2,3)  =    0.99470d0  
      C6AB(15,15,3,3,1)  =  175.55340d0  
      C6AB(15,15,3,3,2)  =    2.01020d0  
      C6AB(15,15,3,3,3)  =    2.01020d0  
      C6AB(15,15,3,4,1)  =  163.07640d0  
      C6AB(15,15,3,4,2)  =    2.01020d0  
      C6AB(15,15,3,4,3)  =    2.98590d0  
      C6AB(15,15,4,1,1)  =  170.40450d0  
      C6AB(15,15,4,1,2)  =    2.98590d0  
      C6AB(15,15,4,1,3)  =    0.00000d0  
      C6AB(15,15,4,2,1)  =  165.45180d0  
      C6AB(15,15,4,2,2)  =    2.98590d0  
      C6AB(15,15,4,2,3)  =    0.99470d0  
      C6AB(15,15,4,3,1)  =  163.07640d0  
      C6AB(15,15,4,3,2)  =    2.98590d0  
      C6AB(15,15,4,3,3)  =    2.01020d0  
      C6AB(15,15,4,4,1)  =  151.68860d0  
      C6AB(15,15,4,4,2)  =    2.98590d0  
      C6AB(15,15,4,4,3)  =    2.98590d0  
      C6AB(15,16,1,1,1)  =  159.48980d0  
      C6AB(15,16,1,1,2)  =    0.00000d0  
      C6AB(15,16,1,1,3)  =    0.00000d0  
      C6AB(15,16,1,2,1)  =  157.69710d0  
      C6AB(15,16,1,2,2)  =    0.00000d0  
      C6AB(15,16,1,2,3)  =    0.99480d0  
      C6AB(15,16,1,3,1)  =  154.49350d0  
      C6AB(15,16,1,3,2)  =    0.00000d0  
      C6AB(15,16,1,3,3)  =    1.99030d0  
      C6AB(15,16,2,1,1)  =  154.92290d0  
      C6AB(15,16,2,1,2)  =    0.99470d0  
      C6AB(15,16,2,1,3)  =    0.00000d0  
      C6AB(15,16,2,2,1)  =  153.18230d0  
      C6AB(15,16,2,2,2)  =    0.99470d0  
      C6AB(15,16,2,2,3)  =    0.99480d0  
      C6AB(15,16,2,3,1)  =  150.07480d0  
      C6AB(15,16,2,3,2)  =    0.99470d0  
      C6AB(15,16,2,3,3)  =    1.99030d0  
      C6AB(15,16,3,1,1)  =  152.64700d0  
      C6AB(15,16,3,1,2)  =    2.01020d0  
      C6AB(15,16,3,1,3)  =    0.00000d0  
      C6AB(15,16,3,2,1)  =  150.93640d0  
      C6AB(15,16,3,2,2)  =    2.01020d0  
      C6AB(15,16,3,2,3)  =    0.99480d0  
      C6AB(15,16,3,3,1)  =  147.87500d0  
      C6AB(15,16,3,3,2)  =    2.01020d0  
      C6AB(15,16,3,3,3)  =    1.99030d0  
      C6AB(15,16,4,1,1)  =  142.29820d0  
      C6AB(15,16,4,1,2)  =    2.98590d0  
      C6AB(15,16,4,1,3)  =    0.00000d0  
      C6AB(15,16,4,2,1)  =  140.69580d0  
      C6AB(15,16,4,2,2)  =    2.98590d0  
      C6AB(15,16,4,2,3)  =    0.99480d0  
      C6AB(15,16,4,3,1)  =  137.85400d0  
      C6AB(15,16,4,3,2)  =    2.98590d0  
      C6AB(15,16,4,3,3)  =    1.99030d0  
      C6AB(15,17,1,1,1)  =  130.47250d0  
      C6AB(15,17,1,1,2)  =    0.00000d0  
      C6AB(15,17,1,1,3)  =    0.00000d0  
      C6AB(15,17,1,2,1)  =  129.09560d0  
      C6AB(15,17,1,2,2)  =    0.00000d0  
      C6AB(15,17,1,2,3)  =    0.99720d0  
      C6AB(15,17,2,1,1)  =  126.83120d0  
      C6AB(15,17,2,1,2)  =    0.99470d0  
      C6AB(15,17,2,1,3)  =    0.00000d0  
      C6AB(15,17,2,2,1)  =  125.49300d0  
      C6AB(15,17,2,2,2)  =    0.99470d0  
      C6AB(15,17,2,2,3)  =    0.99720d0  
      C6AB(15,17,3,1,1)  =  124.91620d0  
      C6AB(15,17,3,1,2)  =    2.01020d0  
      C6AB(15,17,3,1,3)  =    0.00000d0  
      C6AB(15,17,3,2,1)  =  123.60110d0  
      C6AB(15,17,3,2,2)  =    2.01020d0  
      C6AB(15,17,3,2,3)  =    0.99720d0  
      C6AB(15,17,4,1,1)  =  116.83550d0  
      C6AB(15,17,4,1,2)  =    2.98590d0  
      C6AB(15,17,4,1,3)  =    0.00000d0  
      C6AB(15,17,4,2,1)  =  115.60060d0  
      C6AB(15,17,4,2,2)  =    2.98590d0  
      C6AB(15,17,4,2,3)  =    0.99720d0  
      C6AB(16, 1,1,1,1)  =   20.09480d0  
      C6AB(16, 1,1,1,2)  =    0.00000d0  
      C6AB(16, 1,1,1,3)  =    0.91180d0  
      C6AB(16, 1,1,2,1)  =   31.77130d0  
      C6AB(16, 1,1,2,2)  =    0.00000d0  
      C6AB(16, 1,1,2,3)  =    0.00000d0  
      C6AB(16, 1,2,1,1)  =   19.86670d0  
      C6AB(16, 1,2,1,2)  =    0.99480d0  
      C6AB(16, 1,2,1,3)  =    0.91180d0  
      C6AB(16, 1,2,2,1)  =   31.41270d0  
      C6AB(16, 1,2,2,2)  =    0.99480d0  
      C6AB(16, 1,2,2,3)  =    0.00000d0  
      C6AB(16, 1,3,1,1)  =   19.47290d0  
      C6AB(16, 1,3,1,2)  =    1.99030d0  
      C6AB(16, 1,3,1,3)  =    0.91180d0  
      C6AB(16, 1,3,2,1)  =   30.77470d0  
      C6AB(16, 1,3,2,2)  =    1.99030d0  
      C6AB(16, 1,3,2,3)  =    0.00000d0  
      C6AB(16, 6,1,1,1)  =   81.09190d0  
      C6AB(16, 6,1,1,2)  =    0.00000d0  
      C6AB(16, 6,1,1,3)  =    0.00000d0  
      C6AB(16, 6,1,2,1)  =   76.05520d0  
      C6AB(16, 6,1,2,2)  =    0.00000d0  
      C6AB(16, 6,1,2,3)  =    0.98680d0  
      C6AB(16, 6,1,3,1)  =   62.59530d0  
      C6AB(16, 6,1,3,2)  =    0.00000d0  
      C6AB(16, 6,1,3,3)  =    1.99850d0  
      C6AB(16, 6,1,4,1)  =   58.57760d0  
      C6AB(16, 6,1,4,2)  =    0.00000d0  
      C6AB(16, 6,1,4,3)  =    2.99870d0  
      C6AB(16, 6,1,5,1)  =   48.56810d0  
      C6AB(16, 6,1,5,2)  =    0.00000d0  
      C6AB(16, 6,1,5,3)  =    3.98440d0  
      C6AB(16, 6,2,1,1)  =   80.18040d0  
      C6AB(16, 6,2,1,2)  =    0.99480d0  
      C6AB(16, 6,2,1,3)  =    0.00000d0  
      C6AB(16, 6,2,2,1)  =   75.20390d0  
      C6AB(16, 6,2,2,2)  =    0.99480d0  
      C6AB(16, 6,2,2,3)  =    0.98680d0  
      C6AB(16, 6,2,3,1)  =   61.89160d0  
      C6AB(16, 6,2,3,2)  =    0.99480d0  
      C6AB(16, 6,2,3,3)  =    1.99850d0  
      C6AB(16, 6,2,4,1)  =   57.92210d0  
      C6AB(16, 6,2,4,2)  =    0.99480d0  
      C6AB(16, 6,2,4,3)  =    2.99870d0  
      C6AB(16, 6,2,5,1)  =   48.02210d0  
      C6AB(16, 6,2,5,2)  =    0.99480d0  
      C6AB(16, 6,2,5,3)  =    3.98440d0  
      C6AB(16, 6,3,1,1)  =   78.57290d0  
      C6AB(16, 6,3,1,2)  =    1.99030d0  
      C6AB(16, 6,3,1,3)  =    0.00000d0  
      C6AB(16, 6,3,2,1)  =   73.70060d0  
      C6AB(16, 6,3,2,2)  =    1.99030d0  
      C6AB(16, 6,3,2,3)  =    0.98680d0  
      C6AB(16, 6,3,3,1)  =   60.66900d0  
      C6AB(16, 6,3,3,2)  =    1.99030d0  
      C6AB(16, 6,3,3,3)  =    1.99850d0  
      C6AB(16, 6,3,4,1)  =   56.78260d0  
      C6AB(16, 6,3,4,2)  =    1.99030d0  
      C6AB(16, 6,3,4,3)  =    2.99870d0  
      C6AB(16, 6,3,5,1)  =   47.09430d0  
      C6AB(16, 6,3,5,2)  =    1.99030d0  
      C6AB(16, 6,3,5,3)  =    3.98440d0  
      C6AB(16, 7,1,1,1)  =   57.67340d0  
      C6AB(16, 7,1,1,2)  =    0.00000d0  
      C6AB(16, 7,1,1,3)  =    0.00000d0  
      C6AB(16, 7,1,2,1)  =   53.81070d0  
      C6AB(16, 7,1,2,2)  =    0.00000d0  
      C6AB(16, 7,1,2,3)  =    0.99440d0  
      C6AB(16, 7,1,3,1)  =   50.59460d0  
      C6AB(16, 7,1,3,2)  =    0.00000d0  
      C6AB(16, 7,1,3,3)  =    2.01430d0  
      C6AB(16, 7,1,4,1)  =   44.65290d0  
      C6AB(16, 7,1,4,2)  =    0.00000d0  
      C6AB(16, 7,1,4,3)  =    2.99030d0  
      C6AB(16, 7,2,1,1)  =   57.02550d0  
      C6AB(16, 7,2,1,2)  =    0.99480d0  
      C6AB(16, 7,2,1,3)  =    0.00000d0  
      C6AB(16, 7,2,2,1)  =   53.20860d0  
      C6AB(16, 7,2,2,2)  =    0.99480d0  
      C6AB(16, 7,2,2,3)  =    0.99440d0  
      C6AB(16, 7,2,3,1)  =   50.02980d0  
      C6AB(16, 7,2,3,2)  =    0.99480d0  
      C6AB(16, 7,2,3,3)  =    2.01430d0  
      C6AB(16, 7,2,4,1)  =   44.15810d0  
      C6AB(16, 7,2,4,2)  =    0.99480d0  
      C6AB(16, 7,2,4,3)  =    2.99030d0  
      C6AB(16, 7,3,1,1)  =   55.91360d0  
      C6AB(16, 7,3,1,2)  =    1.99030d0  
      C6AB(16, 7,3,1,3)  =    0.00000d0  
      C6AB(16, 7,3,2,1)  =   52.17530d0  
      C6AB(16, 7,3,2,2)  =    1.99030d0  
      C6AB(16, 7,3,2,3)  =    0.99440d0  
      C6AB(16, 7,3,3,1)  =   49.06290d0  
      C6AB(16, 7,3,3,2)  =    1.99030d0  
      C6AB(16, 7,3,3,3)  =    2.01430d0  
      C6AB(16, 7,3,4,1)  =   43.31300d0  
      C6AB(16, 7,3,4,2)  =    1.99030d0  
      C6AB(16, 7,3,4,3)  =    2.99030d0  
      C6AB(16, 8,1,1,1)  =   44.14700d0  
      C6AB(16, 8,1,1,2)  =    0.00000d0  
      C6AB(16, 8,1,1,3)  =    0.00000d0  
      C6AB(16, 8,1,2,1)  =   39.70910d0  
      C6AB(16, 8,1,2,2)  =    0.00000d0  
      C6AB(16, 8,1,2,3)  =    0.99250d0  
      C6AB(16, 8,1,3,1)  =   35.13770d0  
      C6AB(16, 8,1,3,2)  =    0.00000d0  
      C6AB(16, 8,1,3,3)  =    1.98870d0  
      C6AB(16, 8,2,1,1)  =   43.65480d0  
      C6AB(16, 8,2,1,2)  =    0.99480d0  
      C6AB(16, 8,2,1,3)  =    0.00000d0  
      C6AB(16, 8,2,2,1)  =   39.26830d0  
      C6AB(16, 8,2,2,2)  =    0.99480d0  
      C6AB(16, 8,2,2,3)  =    0.99250d0  
      C6AB(16, 8,2,3,1)  =   34.75100d0  
      C6AB(16, 8,2,3,2)  =    0.99480d0  
      C6AB(16, 8,2,3,3)  =    1.98870d0  
      C6AB(16, 8,3,1,1)  =   42.82450d0  
      C6AB(16, 8,3,1,2)  =    1.99030d0  
      C6AB(16, 8,3,1,3)  =    0.00000d0  
      C6AB(16, 8,3,2,1)  =   38.52760d0  
      C6AB(16, 8,3,2,2)  =    1.99030d0  
      C6AB(16, 8,3,2,3)  =    0.99250d0  
      C6AB(16, 8,3,3,1)  =   34.10420d0  
      C6AB(16, 8,3,3,2)  =    1.99030d0  
      C6AB(16, 8,3,3,3)  =    1.98870d0  
      C6AB(16,15,1,1,1)  =  159.48980d0  
      C6AB(16,15,1,1,2)  =    0.00000d0  
      C6AB(16,15,1,1,3)  =    0.00000d0  
      C6AB(16,15,1,2,1)  =  154.92290d0  
      C6AB(16,15,1,2,2)  =    0.00000d0  
      C6AB(16,15,1,2,3)  =    0.99470d0  
      C6AB(16,15,1,3,1)  =  152.64700d0  
      C6AB(16,15,1,3,2)  =    0.00000d0  
      C6AB(16,15,1,3,3)  =    2.01020d0  
      C6AB(16,15,1,4,1)  =  142.29820d0  
      C6AB(16,15,1,4,2)  =    0.00000d0  
      C6AB(16,15,1,4,3)  =    2.98590d0  
      C6AB(16,15,2,1,1)  =  157.69710d0  
      C6AB(16,15,2,1,2)  =    0.99480d0  
      C6AB(16,15,2,1,3)  =    0.00000d0  
      C6AB(16,15,2,2,1)  =  153.18230d0  
      C6AB(16,15,2,2,2)  =    0.99480d0  
      C6AB(16,15,2,2,3)  =    0.99470d0  
      C6AB(16,15,2,3,1)  =  150.93640d0  
      C6AB(16,15,2,3,2)  =    0.99480d0  
      C6AB(16,15,2,3,3)  =    2.01020d0  
      C6AB(16,15,2,4,1)  =  140.69580d0  
      C6AB(16,15,2,4,2)  =    0.99480d0  
      C6AB(16,15,2,4,3)  =    2.98590d0  
      C6AB(16,15,3,1,1)  =  154.49350d0  
      C6AB(16,15,3,1,2)  =    1.99030d0  
      C6AB(16,15,3,1,3)  =    0.00000d0  
      C6AB(16,15,3,2,1)  =  150.07480d0  
      C6AB(16,15,3,2,2)  =    1.99030d0  
      C6AB(16,15,3,2,3)  =    0.99470d0  
      C6AB(16,15,3,3,1)  =  147.87500d0  
      C6AB(16,15,3,3,2)  =    1.99030d0  
      C6AB(16,15,3,3,3)  =    2.01020d0  
      C6AB(16,15,3,4,1)  =  137.85400d0  
      C6AB(16,15,3,4,2)  =    1.99030d0  
      C6AB(16,15,3,4,3)  =    2.98590d0  
      C6AB(16,16,1,1,1)  =  134.00660d0  
      C6AB(16,16,1,1,2)  =    0.00000d0  
      C6AB(16,16,1,1,3)  =    0.00000d0  
      C6AB(16,16,1,2,1)  =  132.49220d0  
      C6AB(16,16,1,2,2)  =    0.00000d0  
      C6AB(16,16,1,2,3)  =    0.99480d0  
      C6AB(16,16,1,3,1)  =  129.84130d0  
      C6AB(16,16,1,3,2)  =    0.00000d0  
      C6AB(16,16,1,3,3)  =    1.99030d0  
      C6AB(16,16,2,1,1)  =  132.49220d0  
      C6AB(16,16,2,1,2)  =    0.99480d0  
      C6AB(16,16,2,1,3)  =    0.00000d0  
      C6AB(16,16,2,2,1)  =  130.99650d0  
      C6AB(16,16,2,2,2)  =    0.99480d0  
      C6AB(16,16,2,2,3)  =    0.99480d0  
      C6AB(16,16,2,3,1)  =  128.37640d0  
      C6AB(16,16,2,3,2)  =    0.99480d0  
      C6AB(16,16,2,3,3)  =    1.99030d0  
      C6AB(16,16,3,1,1)  =  129.84130d0  
      C6AB(16,16,3,1,2)  =    1.99030d0  
      C6AB(16,16,3,1,3)  =    0.00000d0  
      C6AB(16,16,3,2,1)  =  128.37640d0  
      C6AB(16,16,3,2,2)  =    1.99030d0  
      C6AB(16,16,3,2,3)  =    0.99480d0  
      C6AB(16,16,3,3,1)  =  125.81090d0  
      C6AB(16,16,3,3,2)  =    1.99030d0  
      C6AB(16,16,3,3,3)  =    1.99030d0  
      C6AB(16,17,1,1,1)  =  110.70060d0  
      C6AB(16,17,1,1,2)  =    0.00000d0  
      C6AB(16,17,1,1,3)  =    0.00000d0  
      C6AB(16,17,1,2,1)  =  109.52700d0  
      C6AB(16,17,1,2,2)  =    0.00000d0  
      C6AB(16,17,1,2,3)  =    0.99720d0  
      C6AB(16,17,2,1,1)  =  109.44860d0  
      C6AB(16,17,2,1,2)  =    0.99480d0  
      C6AB(16,17,2,1,3)  =    0.00000d0  
      C6AB(16,17,2,2,1)  =  108.28930d0  
      C6AB(16,17,2,2,2)  =    0.99480d0  
      C6AB(16,17,2,2,3)  =    0.99720d0  
      C6AB(16,17,3,1,1)  =  107.29640d0  
      C6AB(16,17,3,1,2)  =    1.99030d0  
      C6AB(16,17,3,1,3)  =    0.00000d0  
      C6AB(16,17,3,2,1)  =  106.16060d0  
      C6AB(16,17,3,2,2)  =    1.99030d0  
      C6AB(16,17,3,2,3)  =    0.99720d0  
      C6AB(17, 1,1,1,1)  =   16.70520d0  
      C6AB(17, 1,1,1,2)  =    0.00000d0  
      C6AB(17, 1,1,1,3)  =    0.91180d0  
      C6AB(17, 1,1,2,1)  =   26.01700d0  
      C6AB(17, 1,1,2,2)  =    0.00000d0  
      C6AB(17, 1,1,2,3)  =    0.00000d0  
      C6AB(17, 1,2,1,1)  =   16.52730d0  
      C6AB(17, 1,2,1,2)  =    0.99720d0  
      C6AB(17, 1,2,1,3)  =    0.91180d0  
      C6AB(17, 1,2,2,1)  =   25.74140d0  
      C6AB(17, 1,2,2,2)  =    0.99720d0  
      C6AB(17, 1,2,2,3)  =    0.00000d0  
      C6AB(17, 6,1,1,1)  =   66.84070d0  
      C6AB(17, 6,1,1,2)  =    0.00000d0  
      C6AB(17, 6,1,1,3)  =    0.00000d0  
      C6AB(17, 6,1,2,1)  =   62.74650d0  
      C6AB(17, 6,1,2,2)  =    0.00000d0  
      C6AB(17, 6,1,2,3)  =    0.98680d0  
      C6AB(17, 6,1,3,1)  =   52.02080d0  
      C6AB(17, 6,1,3,2)  =    0.00000d0  
      C6AB(17, 6,1,3,3)  =    1.99850d0  
      C6AB(17, 6,1,4,1)  =   48.74480d0  
      C6AB(17, 6,1,4,2)  =    0.00000d0  
      C6AB(17, 6,1,4,3)  =    2.99870d0  
      C6AB(17, 6,1,5,1)  =   40.85160d0  
      C6AB(17, 6,1,5,2)  =    0.00000d0  
      C6AB(17, 6,1,5,3)  =    3.98440d0  
      C6AB(17, 6,2,1,1)  =   66.13540d0  
      C6AB(17, 6,2,1,2)  =    0.99720d0  
      C6AB(17, 6,2,1,3)  =    0.00000d0  
      C6AB(17, 6,2,2,1)  =   62.08640d0  
      C6AB(17, 6,2,2,2)  =    0.99720d0  
      C6AB(17, 6,2,2,3)  =    0.98680d0  
      C6AB(17, 6,2,3,1)  =   51.47210d0  
      C6AB(17, 6,2,3,2)  =    0.99720d0  
      C6AB(17, 6,2,3,3)  =    1.99850d0  
      C6AB(17, 6,2,4,1)  =   48.23280d0  
      C6AB(17, 6,2,4,2)  =    0.99720d0  
      C6AB(17, 6,2,4,3)  =    2.99870d0  
      C6AB(17, 6,2,5,1)  =   40.42090d0  
      C6AB(17, 6,2,5,2)  =    0.99720d0  
      C6AB(17, 6,2,5,3)  =    3.98440d0  
      C6AB(17, 7,1,1,1)  =   48.26240d0  
      C6AB(17, 7,1,1,2)  =    0.00000d0  
      C6AB(17, 7,1,1,3)  =    0.00000d0  
      C6AB(17, 7,1,2,1)  =   45.09520d0  
      C6AB(17, 7,1,2,2)  =    0.00000d0  
      C6AB(17, 7,1,2,3)  =    0.99440d0  
      C6AB(17, 7,1,3,1)  =   42.48160d0  
      C6AB(17, 7,1,3,2)  =    0.00000d0  
      C6AB(17, 7,1,3,3)  =    2.01430d0  
      C6AB(17, 7,1,4,1)  =   37.62950d0  
      C6AB(17, 7,1,4,2)  =    0.00000d0  
      C6AB(17, 7,1,4,3)  =    2.99030d0  
      C6AB(17, 7,2,1,1)  =   47.75400d0  
      C6AB(17, 7,2,1,2)  =    0.99720d0  
      C6AB(17, 7,2,1,3)  =    0.00000d0  
      C6AB(17, 7,2,2,1)  =   44.62170d0  
      C6AB(17, 7,2,2,2)  =    0.99720d0  
      C6AB(17, 7,2,2,3)  =    0.99440d0  
      C6AB(17, 7,2,3,1)  =   42.03670d0  
      C6AB(17, 7,2,3,2)  =    0.99720d0  
      C6AB(17, 7,2,3,3)  =    2.01430d0  
      C6AB(17, 7,2,4,1)  =   37.23810d0  
      C6AB(17, 7,2,4,2)  =    0.99720d0  
      C6AB(17, 7,2,4,3)  =    2.99030d0  
      C6AB(17, 8,1,1,1)  =   37.36880d0  
      C6AB(17, 8,1,1,2)  =    0.00000d0  
      C6AB(17, 8,1,1,3)  =    0.00000d0  
      C6AB(17, 8,1,2,1)  =   33.73130d0  
      C6AB(17, 8,1,2,2)  =    0.00000d0  
      C6AB(17, 8,1,2,3)  =    0.99250d0  
      C6AB(17, 8,1,3,1)  =   29.99180d0  
      C6AB(17, 8,1,3,2)  =    0.00000d0  
      C6AB(17, 8,1,3,3)  =    1.98870d0  
      C6AB(17, 8,2,1,1)  =   36.97830d0  
      C6AB(17, 8,2,1,2)  =    0.99720d0  
      C6AB(17, 8,2,1,3)  =    0.00000d0  
      C6AB(17, 8,2,2,1)  =   33.38010d0  
      C6AB(17, 8,2,2,2)  =    0.99720d0  
      C6AB(17, 8,2,2,3)  =    0.99250d0  
      C6AB(17, 8,2,3,1)  =   29.68220d0  
      C6AB(17, 8,2,3,2)  =    0.99720d0  
      C6AB(17, 8,2,3,3)  =    1.98870d0  
      C6AB(17,15,1,1,1)  =  130.47250d0  
      C6AB(17,15,1,1,2)  =    0.00000d0  
      C6AB(17,15,1,1,3)  =    0.00000d0  
      C6AB(17,15,1,2,1)  =  126.83120d0  
      C6AB(17,15,1,2,2)  =    0.00000d0  
      C6AB(17,15,1,2,3)  =    0.99470d0  
      C6AB(17,15,1,3,1)  =  124.91620d0  
      C6AB(17,15,1,3,2)  =    0.00000d0  
      C6AB(17,15,1,3,3)  =    2.01020d0  
      C6AB(17,15,1,4,1)  =  116.83550d0  
      C6AB(17,15,1,4,2)  =    0.00000d0  
      C6AB(17,15,1,4,3)  =    2.98590d0  
      C6AB(17,15,2,1,1)  =  129.09560d0  
      C6AB(17,15,2,1,2)  =    0.99720d0  
      C6AB(17,15,2,1,3)  =    0.00000d0  
      C6AB(17,15,2,2,1)  =  125.49300d0  
      C6AB(17,15,2,2,2)  =    0.99720d0  
      C6AB(17,15,2,2,3)  =    0.99470d0  
      C6AB(17,15,2,3,1)  =  123.60110d0  
      C6AB(17,15,2,3,2)  =    0.99720d0  
      C6AB(17,15,2,3,3)  =    2.01020d0  
      C6AB(17,15,2,4,1)  =  115.60060d0  
      C6AB(17,15,2,4,2)  =    0.99720d0  
      C6AB(17,15,2,4,3)  =    2.98590d0  
      C6AB(17,16,1,1,1)  =  110.70060d0  
      C6AB(17,16,1,1,2)  =    0.00000d0  
      C6AB(17,16,1,1,3)  =    0.00000d0  
      C6AB(17,16,1,2,1)  =  109.44860d0  
      C6AB(17,16,1,2,2)  =    0.00000d0  
      C6AB(17,16,1,2,3)  =    0.99480d0  
      C6AB(17,16,1,3,1)  =  107.29640d0  
      C6AB(17,16,1,3,2)  =    0.00000d0  
      C6AB(17,16,1,3,3)  =    1.99030d0  
      C6AB(17,16,2,1,1)  =  109.52700d0  
      C6AB(17,16,2,1,2)  =    0.99720d0  
      C6AB(17,16,2,1,3)  =    0.00000d0  
      C6AB(17,16,2,2,1)  =  108.28930d0  
      C6AB(17,16,2,2,2)  =    0.99720d0  
      C6AB(17,16,2,2,3)  =    0.99480d0  
      C6AB(17,16,2,3,1)  =  106.16060d0  
      C6AB(17,16,2,3,2)  =    0.99720d0  
      C6AB(17,16,2,3,3)  =    1.99030d0  
      C6AB(17,17,1,1,1)  =   92.34600d0  
      C6AB(17,17,1,1,2)  =    0.00000d0  
      C6AB(17,17,1,1,3)  =    0.00000d0  
      C6AB(17,17,1,2,1)  =   91.36670d0  
      C6AB(17,17,1,2,2)  =    0.00000d0  
      C6AB(17,17,1,2,3)  =    0.99720d0  
      C6AB(17,17,2,1,1)  =   91.36670d0  
      C6AB(17,17,2,1,2)  =    0.99720d0  
      C6AB(17,17,2,1,3)  =    0.00000d0  
      C6AB(17,17,2,2,1)  =   90.39850d0  
      C6AB(17,17,2,2,2)  =    0.99720d0  
      C6AB(17,17,2,2,3)  =    0.99720d0  

      R0AB = -9.0d99  ! To check for parameters not written.
      R0AB  ( 1, 1) =    2.18230d0  / autoang
      R0AB  ( 1, 6) =    2.44920d0  / autoang
      R0AB  ( 1, 7) =    2.36670d0  / autoang
      R0AB  ( 1, 8) =    2.17680d0  / autoang
      R0AB  ( 1,15) =    2.83040d0  / autoang
      R0AB  ( 1,16) =    2.61900d0  / autoang
      R0AB  ( 1,17) =    2.47570d0  / autoang
      R0AB  ( 6, 1) =    2.44920d0  / autoang
      R0AB  ( 6, 6) =    2.91030d0  / autoang
      R0AB  ( 6, 7) =    2.70630d0  / autoang
      R0AB  ( 6, 8) =    2.56970d0  / autoang
      R0AB  ( 6,15) =    3.12450d0  / autoang
      R0AB  ( 6,16) =    2.98790d0  / autoang
      R0AB  ( 6,17) =    2.88480d0  / autoang
      R0AB  ( 7, 1) =    2.36670d0  / autoang
      R0AB  ( 7, 6) =    2.70630d0  / autoang
      R0AB  ( 7, 7) =    2.62250d0  / autoang
      R0AB  ( 7, 8) =    2.48460d0  / autoang
      R0AB  ( 7,15) =    3.04650d0  / autoang
      R0AB  ( 7,16) =    2.90540d0  / autoang
      R0AB  ( 7,17) =    2.79520d0  / autoang
      R0AB  ( 8, 1) =    2.17680d0  / autoang
      R0AB  ( 8, 6) =    2.56970d0  / autoang
      R0AB  ( 8, 7) =    2.48460d0  / autoang
      R0AB  ( 8, 8) =    2.48170d0  / autoang
      R0AB  ( 8,15) =    2.87270d0  / autoang
      R0AB  ( 8,16) =    2.88050d0  / autoang
      R0AB  ( 8,17) =    2.74570d0  / autoang
      R0AB  (15, 1) =    2.83040d0  / autoang
      R0AB  (15, 6) =    3.12450d0  / autoang
      R0AB  (15, 7) =    3.04650d0  / autoang
      R0AB  (15, 8) =    2.87270d0  / autoang
      R0AB  (15,15) =    3.50170d0  / autoang
      R0AB  (15,16) =    3.31800d0  / autoang
      R0AB  (15,17) =    3.19160d0  / autoang
      R0AB  (16, 1) =    2.61900d0  / autoang
      R0AB  (16, 6) =    2.98790d0  / autoang
      R0AB  (16, 7) =    2.90540d0  / autoang
      R0AB  (16, 8) =    2.88050d0  / autoang
      R0AB  (16,15) =    3.31800d0  / autoang
      R0AB  (16,16) =    3.31070d0  / autoang
      R0AB  (16,17) =    3.15230d0  / autoang
      R0AB  (17, 1) =    2.47570d0  / autoang
      R0AB  (17, 6) =    2.88480d0  / autoang
      R0AB  (17, 7) =    2.79520d0  / autoang
      R0AB  (17, 8) =    2.74570d0  / autoang
      R0AB  (17,15) =    3.19160d0  / autoang
      R0AB  (17,16) =    3.15230d0  / autoang
      R0AB  (17,17) =    3.10460d0  / autoang

      lsetd3=.true.
      return
 9999 return 1
      end
