      SUBROUTINE MECIP (P,C,WORK,N,W2,NMOS)
      IMPLICIT DOUBLE PRECISION(A-H,O-Z)
       INCLUDE 'SIZES.i'
      COMMON /BASEOC/ OCCA(NMECI),NFA(NMECI+2)
     1       /CIDATA/ VECTCI(MAXCI),XX,NCI1,NCI2,NCI3                   DL0397
     2               ,NALPHA(MAXCI)                                     DL0397
     3               ,MICROA(NMECI,MAXCI),MICROB(NMECI,MAXCI)           DL0397
C
C     UPDATE TOTAL DENSITY MATRIX DUE TO C.I. CORRECTION
C
C  INPUT
C     P        : TOTAL DENSITY MATRIX ISSUING FROM SCF COMPUTATION
C     C(N,N)   : M.O. COEFFICIENTS , IN COLUMN
C     WORK(N,NMOS) : WORK ARRAY
C     W2(NMOS,NMOS): WORK ARRAY. (NMOS MUST BE EQUAL TO NCI2)
C  OUTPUT
C     P        : TOTAL DENSITY MATRIX AFTER C.I. CORRECTION,
C                RETURNED IN PACKED CANONICAL ORDER.
C
      DIMENSION P(*),C(N,N),WORK(N,NMOS),W2(NMOS,NMOS)
      SAVE
C
C     BUILD  DENSITY MATRIX IN C.I-ACTIVE M.O BASIS, STORED IN W2.
C     ------------------------------------------------------------
C
C     INITIALIZE WITH THE OPPOSITE OF THE 'SCF' DENSITY.
      DO 10 I=1,NCI2
      W2(I,I)=-OCCA(I)*2.D0
      DO 10 J=1,I-1
   10 W2(I,J)=0.D0
C
C     ADD THE C.I. CORRECTION
      DO 120 ID=1,NCI3
      DO 120 JD=1,ID
C     CHECK SPIN AGREEMENT
      IF(NALPHA(ID).NE.NALPHA(JD)) GO TO 120
      IX=0
      IY=0
      DO 20 J=1,NCI2
      IX=IX+ABS(MICROA(J,ID)-MICROA(J,JD))
   20 IY=IY+ABS(MICROB(J,ID)-MICROB(J,JD))
C     CHECK NUMBER OF DIFFERING M.O.
      IF(IX+IY.GT.2) GO TO 120
      IF(IX.EQ.2) THEN
C        DETERMINANTS ID AND JD DIFFER BY M.O I IN ID AND M.O J IN JD:
         DO 30 I=1,NCI2
   30    IF(MICROA(I,ID).NE.MICROA(I,JD)) GO TO 40
   40    IJ=MICROB(I,ID)
         DO 50 J=I+1,NCI2
         IF(MICROA(J,ID).NE.MICROA(J,JD)) GO TO 60
   50    IJ=IJ+MICROA(J,ID)+MICROB(J,ID)
C        IJ GIVES THE SIGN OF THE PERMUTATION
   60    W2(J,I)=W2(J,I)+VECTCI(ID)*VECTCI(JD)*DBLE(1-2*MOD(IJ,2))      GCL0393
      ELSE IF(IY.EQ.2) THEN
C        DETERMINANTS ID AND JD DIFFER BY M.O J IN ID AND M.O I IN JD:
         DO 70 I=1,NCI2
   70    IF(MICROB(I,ID).NE.MICROB(I,JD)) GO TO 80
   80    IJ=0
         DO 90 J=I+1,NCI2
         IF(MICROB(J,ID).NE.MICROB(J,JD)) GO TO 100
   90    IJ=IJ+MICROA(J,ID)+MICROB(J,ID)
  100    IJ=IJ+MICROA(J,ID)
         W2(J,I)=W2(J,I)+VECTCI(ID)*VECTCI(JD)*DBLE(1-2*MOD(IJ,2))      GCL0393
      ELSE
C        DETERMINANTS ID AND JD ARE IDENTICAL:
         DO 110 I=1,NCI2
  110    W2(I,I)=W2(I,I)+(MICROA(I,ID)+MICROB(I,ID))*VECTCI(ID)**2
      ENDIF
  120 CONTINUE
C
C     BACK TRANSFORM INTO A.O. BASIS.
C     -------------------------------
C     P(C.I.) = P(SCF) + C * W2 * C'
      DO 130 I=1,NCI2
CDIR$ IVDEP
      DO 130 J=1,I-1
  130 W2(J,I)=W2(I,J)
C     STEP 1: WORK = C * W2
      CALL MXM (C(1,NCI1+1),N,W2,NCI2,WORK,NCI2)
C     STEP 2: P = P + WORK * C'
      IJ=0
      DO 150 I=1,N
      DO 150 J=1,I
      IJ=IJ+1
      SUM=0.D0
      DO 140 K=1,NCI2
  140 SUM=SUM+WORK(I,K)*C(J,NCI1+K)
  150 P(IJ)=P(IJ)+SUM
C     NOTE FROM D.L.: AT THIS POINT THE 'NATURAL ORBITALS' OF THIS STATE
C     CAN BE OBTAINED STRAIGHTWAY AS EIGENVECTORS OF THE DENSITY MATRIX.
      RETURN
      END
