      DOUBLE PRECISION FUNCTION DIGIT(STRING,ISTART)
C     FORTRAN FUNCTION TO CONVERT NUMERIC FIELD TO DOUBLE PRECISION
C     NUMBER.  THE STRING IS ASSUMED TO BE CLEAN (NO INVALID DIGIT
C     OR CHARACTER COMBINATIONS FROM ISTART TO THE FIRST NONSPACE,
C     NONDIGIT, NONSIGN, AND NONDECIMAL POINT CHARACTER).
C
      CHARACTER STRING*(*)
      DOUBLE PRECISION C1,C2,DECIML
      LOGICAL SIGN
CSAV         SAVE                                                           GL0892
C
C     DEFINE ASCII VALUES OF NUMERIC FIELD CHARACTERS
      I0=ICHAR('0')
      I9=ICHAR('9')
      INEG=ICHAR('-')
      IPOS=ICHAR('+')
      IDOT=ICHAR('.')
      ISPC=ICHAR(' ')
C
      C1=0.D0
      C2=0.D0
      SIGN=.TRUE.
      L=LEN(STRING)
C
C     DETERMINE THE CONTRIBUTION TO THE NUMBER GREATER THAN ONE
      IDIG=0
      DO 10 I=ISTART,L
         N=ICHAR(STRING(I:I))
         IF(N.GE.I0.AND.N.LE.I9)THEN
            IDIG=IDIG+1
            C1=C1*1.D1+N-I0
         ELSEIF(N.EQ.INEG.OR.N.EQ.IPOS.OR.N.EQ.ISPC)THEN
            IF(N.EQ.INEG)SIGN=.FALSE.
         ELSEIF(N.EQ.IDOT)THEN
            GOTO 20
         ELSE
            GOTO 40
         ENDIF
   10 CONTINUE
C
C     DETERMINE THE CONTRIBUTION TO THE NUMBER LESS THAN THAN ONE
   20 DECIML=1.D0
      DO 30 J=I+1,L
         N=ICHAR(STRING(J:J))
         IF(N.GE.I0.AND.N.LE.I9)THEN
            DECIML=DECIML/1.D1
            C2=C2+(N-I0)*DECIML
         ELSEIF(N.NE.ISPC)THEN
            GOTO 40
         ENDIF
   30 CONTINUE
C
C     PUT THE PIECES TOGETHER
   40 DIGIT=C1+C2
      IF(.NOT.SIGN)DIGIT=-DIGIT
      RETURN
      END
