      SUBROUTINE DIAG(FAO,VECTOR,NOCC,EIG,MDIM,N,*)                     CSTP
C***********************************************************************
C
C   "FAST" DIAGONALISATION PROCEDURE.
C
C             ************************************************
C             * CRAY VERSION: CONVERTS FAO FROM PACKED FORM  *
C             * TO SQUARE MATRIX FORM, DESTROYING ORIGINAL   *
C             * FORM OF FAO IN THE PROCESS (BEWARE!!!)       *
C             ************************************************
C
C    ON INPUT FAO CONTAINS THE LOWER HALF TRIANGLE OF THE MATRIX
C             TO BE DIAGONALIZED, IN PACKED FORM.
C             VECTOR  CONTAINS THE OLD EIGENVECTORS ON INPUT, THE NEW
C             VECTORS ON EXITING.
C             NOCC = NUMBER OF OCCUPIED MOLECULAR ORBITALS.
C             EIG  = EIGENVALUES FROM AN EXACT DIAGONALISATION
C             MDIM = DECLARED SIZE OF MATRIX "C".
C             N = NUMBER OF ATOMIC ORBITALS IN BASIS SET
C
C  DIAG IS A PSEUDO-DIAGONALISATION PROCEDURE, IN THAT THE VECTORS THAT
C       ARE GENERATED BY IT ARE MORE NEARLY ABLE TO BLOCK-DIAGONALISE
C       THE FOCK MATRIX OVER MOLECULAR ORBITALS THAN THE STARTING
C       VECTORS. IT MUST BE CONSIDERED PSEUDO FOR SEVERAL REASONS:
C       (A) IT DOES NOT GENERATE EIGENVECTORS - THE SECULAR DETERMINANT
C           IS NOT DIAGONALISED, ONLY THE OCCUPIED-VIRTUAL INTERSECTION.
C       (B) MANY SMALL ELEMENTS IN THE SEC.DET. ARE IGNORED AS BEING TOO
C           SMALL COMPARED WITH THE LARGEST ELEMENT.
C       (C) WHEN ELEMENTS ARE ELIMINATED BY ROTATION, THE REST OF THE
C           SEC. DET. IS ASSUMED NOT TO CHANGE, I.E. ELEMENTS CREATED
C           ARE IGNORED.
C       (D) THE ROTATION REQUIRED TO ELIMINATE THOSE ELEMENTS CONSIDERED
C           SIGNIFICANT IS APPROXIMATED TO USING THE EIGENVALUES OF THE
C           EXACT DIAGONALISATION THROUGHOUT THE REST OF THE ITERATIVE
C           PROCEDURE.
C
C  (NOTE:- IN AN ITERATIVE PROCEDURE ALL THE APPROXIMATIONS PRESENT IN
C          DIAG BECOME VALID AT SELF-CONSISTENCY, SELF-CONSISTENCY IS
C          NOT SLOWED DOWN BY USE OF THESE APPROXIMATIONS)
C
C    REFERENCE:
C             "FAST SEMIEMPIRICAL CALCULATIONS",
C             STEWART. J.J.P., CSASZAR, P., PULAY, P., J. COMP. CHEM.,
C             3, 227, (1982)
C
C***********************************************************************
      IMPLICIT DOUBLE PRECISION(A-H,O-Z)
C
      INCLUDE 'SIZES.i'
C
************************************************************************
      DIMENSION FAO(*),VECTOR(MDIM,*),EIG(*)
C---WORKSPACE ARRAYS
      DIMENSION WS(MAXORB), SQFAO(MAXORB,MAXORB)
      COMMON /SCRACH/ FMO(MAXORB,MAXORB), XDUMY(MAXPAR**2-MORB2)
      COMMON /ETAEPS/ ETA, EPS
CSAV         SAVE                                                           GL0892
************************************************************************
*
*   TAKES A PACKED LOWER-TRIANGULAR MATRIX IN ARRAY FAO AND
*   RE-ARRANGES IT INTO A PACKED SQUARE MATRIX IN THE SAME SPACE.
*
************************************************************************
C
C  FIRST FILL ONE HALF OF THE SQUARE MATRIX.
C
      L=(N*(N+1))/2+1
      DO 10 I=N,1,-1
         DO 10 J=I,1,-1
            L=L-1
   10 SQFAO(j,i) = FAO(l)
C
C  NOW FILL OTHER HALF OF THE SQUARE MATRIX.
C
      DO 20 I=1,N
         DO 20 J=I+1,N
   20 SQFAO(j,i)= SQFAO(i,j)
************************************************************************
      TINY = 0.0
C--- EPS IS THE SMALLEST NUMBER WHICH, WHEN ADDED TO 1.0,
C--- IS NOT EQUAL TO 1.0.  BIGEPS ACCOUNTS FOR ROUND-OFF
      BIGEPS = 100.0*EPS
      LUMO=NOCC+1
C---THIS LOOP REDONE BY ERICH WIMMER (CRAY RESEARCH)
      DO 90 I=LUMO,N
C
         DO 30 M=1,N
            WS(M) = SQFAO(M,1)*VECTOR(1,I)
   30    CONTINUE
C
         DO 50 K=2,N
            DO 40 M=1,N
               WS(M) = WS(M) + SQFAO(M,K)*VECTOR(K,I)
   40       CONTINUE
   50    CONTINUE
C
         DO 60 J=1,NOCC
            FMO(J,I) = VECTOR(1,J)*WS(1)
   60    CONTINUE
C
         DO 80 M=2,N
            DO 70 J=1,NOCC
               FMO(J,I) = FMO(J,I) + VECTOR(M,J)*WS(M)
   70       CONTINUE
   80    CONTINUE
         km=idamax(nocc,fmo(1,i),1)
         tiny=max(tiny,abs(fmo(km,i)))
C
   90 CONTINUE
      TINY = 0.04D0*TINY
C***********************************************************************
C
C   NOW DO A CRUDE 2 BY 2 ROTATION TO "ELIMINATE" SIGNIFICANT ELEMENTS
C
C***********************************************************************
      DO 120 I=LUMO,N
         DO 110 J=1,NOCC
            IF(ABS(FMO(J,I)) .LT. TINY) GO TO 110
C
C      BEGIN 2 X 2 ROTATIONS
C
            A=EIG(J)
            B=EIG(I)
            C=FMO(J,I)
            D=A-B
C
C   Jeff:  I've modified the following lines so that the round-off
C          error is minimized.
            E = MIN((C/D)**2,0.5D0)
C
C    USE BIGEPS TO DETERMINE WHETHER TO DO A 2 BY 2 ROTATION
C
            IF(E.LT.BIGEPS) GOTO 110
            IF(E.LT.-0.01D0)THEN
C
C    ANGLE IS VERY SMALL, THEREFORE USE APPROXIMATE METHODS TO DETERMINE
C    ALPHA AND BETA.  TRUNCATE SERIES AT E**2
C
               ALPHA=1.D0-E*0.5D0-E*E*0.125D0
               BETA=-SIGN(SQRT(E),C)
            ELSE
C
C    ANGLE IS LARGE, GREATER THAN 0.573 DEGREES, THEREFORE USE EXACT
C    METHOD
C
               E=SIGN(MAX(D,SQRT(4.D0*C*C+D*D)),D)
               ALPHA=SQRT(0.5D0*(1.D0+D/E))
               BETA=-SIGN(SQRT(1.D0-ALPHA*ALPHA),C)
            ENDIF
C
C   End of modification
C
C
C      ROTATION OF PSEUDO-EIGENVECTORS
C
            DO 100 M=1,N
               A=VECTOR(M,J)
               B=VECTOR(M,I)
               VECTOR(M,J)=ALPHA*A +BETA*B
               VECTOR(M,I)=ALPHA*B -BETA*A
  100       continue
  110    CONTINUE
  120 CONTINUE
      RETURN
 9999 RETURN 1                                                          CSTP
      END
