      SUBROUTINE DERI21 (A,NT,MINEAR,CUTOFF,SUM2,MAXITE,VNERT,PNERT
     .                  ,B,NCUT)
      IMPLICIT DOUBLE PRECISION(A-H,O-Z)
      INCLUDE 'SIZES.i'
C ---------------------------------------------------------------------+
C     LEAST-SQUARE ANALYSIS OF A SET OF NT POINTS {A} :
C
C     PRODUCE A SUBSET OF NCUT ORTHONORMALIZED VECTORS B, OPTIMUM IN A
C     LEAST-SQUARE SENSE WITH RESPECT TO THE INITIAL SPACE {A}.
C     EACH NEW HIERARCHIZED VECTOR B EXTRACTS A MAXIMUM PERCENTAGE FROM
C     THE REMAINING DISPERSION OF THE SET {A} OUT OF THE PREVIOUS
C     {B} SUBSPACE.
C   INPUT
C     A(MINEAR,NT)  : ORIGINAL SET {A}.
C     CUTOFF        : LEAST-SQUARE CUTOFF TO BE APPLIED.
C     SUM2          : INITIAL VALUE OF THE PERCENTAGE OF EXTRACTION.
C     MAXITE        : MAXIMUM ALLOWED SIZE OF THE BASIS B.
C   OUTPUT
C     SUM2          : FINAL VALUE OF THE PERCENTAGE OF EXTRACTION.
C     VNERT(NT,NT)  : EIGENVECTORS OF A'* A.
C     PNERT(NT)     : SQUARE ROOT OF THE ASSOCIATED EIGENVALUES
C                     IN DECREASING ORDER.
C     B(MINEAR,NCUT): OPTIMUM ORTHONORMALIZED SUBSET {B}.
C ---------------------------------------------------------------------+
      COMMON /SCRCHR/ WORK1(MORB2), WORK2(MAXORB,MAXORB),               3GL3092
     1                DUM3(6*MAXPAR**2+1-2*MORB2)                       GCL0393
C    1                DUM3(6*MAXPAR**2+1-MORB2)
C
C
      DIMENSION A(MINEAR,NT),VNERT(NT,NT),PNERT(NT),B(MINEAR,*)
       SAVE
C
C     VNERT = A' * A
      DO 10 J=1,NT
      L=J
      DO 10 I=1,MINEAR
      B(L,1)=-A(I,J)
   10 L=L+NT
      CALL MXM (B,NT,A,MINEAR,VNERT,NT)
C     DIAGONALIZE IN DECREASING ORDER OF EIGENVALUES
      CALL DIAGIV (VNERT,NT,NT,PNERT,EPS1)
C     FIND NCUT ACCORDING TO CUTOFF, BUILD WORK = VNERT * (PNERT)**-0.5
      SUM=0.D0
      DO 20 I=1,NT
c       write(6,*) 'PNERT ', PNERT(I)
        PNERT(I)=MIN(-1D-30,PNERT(I))                                   GDH0295
   20 SUM=SUM-PNERT(I)
      L=1
      DO 40 I=1,MAXITE
      SUM2=SUM2-PNERT(I)/SUM
      PNERT(I)=DSQRT(-PNERT(I))
      DO 30 J=1,NT
C     WORK(L)=VNERT(L,1)/PNERT(I)
      WORK1(L)=VNERT(L,1)/PNERT(I)                                      3GL3092
C     WORK1(L)=VNERT(J,I)/PNERT(I)                                      3GL3092
      WORK2(L,1) = WORK1(L)                                             3GL3092
   30 L=L+1
      IF(SUM2.GE.CUTOFF) THEN
         NCUT=I
         GO TO 50
      ENDIF
   40 CONTINUE
      NCUT=MAXITE
C     ORTHONORMALIZED BASIS B(MINEAR,NCUT) = A(MINEAR,NT)*WORK(NT,NCUT)
   50 CALL MXM (A,MINEAR,WORK2,NT,B,NCUT)                               3GL3092
      RETURN
      END
