      SUBROUTINE DERI2 (C,CT,E,N,MINEAR,THROLD,F,FD,FCI,NINEAR,NVAR
     .                 ,MAXITE,WORK,B,NBSIZE,GRAD,FAIL,AB,FB,MAXFB)
      IMPLICIT DOUBLE PRECISION(A-H,O-Z)
       INCLUDE 'SIZES.i'
C      INCLUDE 'KEYS.i'                                                 DJG0995
C      INCLUDE 'FFILES.i'                                               GDH1095
      PARAMETER (MFBWO=9*MAXPAR)                                        3GL3092
      EXTERNAL SDOT                                                     GL0492
C********************************************************************
C
C     DERI2 COMPUTE THE RELAXATION PART OF THE DERIVATIVES OF THE
C     (1/2 ELECTRON OR CI)-ENERGY WITH RESPECT TO NVAR OPTIMIZED
C     COORDINATES AT A TIME. THIS IS DONE IN THREE STEPS.
C
C==>  THE M.O DERIVATIVES ARE SOLUTION {X} OF A LINEAR SYSTEM
C                        (D-A) * X = F
C     WHERE D IS A DIAGONAL SUPER-MATRIX OF FOCK'EIGENVALUE DIFFERENCES
C     AND A IS A SUPER-MATRIX OF 2-ELECTRONS INTEGRALS IN M.O BASIS.
C==>  SUCH A SYSTEM IS TOO LARGE TO BE INVERTED DIRECTLY THUS ONE MUST
C     USES A RELAXATION METHOD TO GET A REASONABLE ESTIMATE OF {X}.
C==>  THIS REQUIRES A BASIS SET {B} TO BE GENERATED ITERATIVELY. THEN
C     ONE SOLVES BY DIRECT INVERSION THE LINEAR SYSTEM PROJECTED IN THIS
C     BASIS {B}. IT WORKS QUICKLY BUT REQUIRE A LARGE CORE MEMORY.
C==>  USE A FORMALISM WITH FOCK OPERATOR THUS AVOIDING THE EXPLICIT
C     COMPUTATION (AND STORAGE) OF THE SUPER-MATRIX A.
C==>  NDDO METHOD DONT NEED LARGE C.I CALCULATION. THEREFORE FOR EACH
C     GRADIENT COMPONENT ONE BUILDS THE C.I MATRIX DERIVATIVE FROM THE
C     <IJ!KL> AND FOCK EIGENVALUES DERIVATIVES, THUS PROVIDING THE
C     RELAXATION CONTRIBUTION TO THE GRADIENT WITHOUT COMPUTATION AND
C     STORAGE OF THE 2ND ORDER DENSITY MATRIX.
C
C   STEP 1)
C     USE THE PREVIOUS B AND THE NEW F VECTORS TO BUILD AN INITIAL
C     BASIS SET B.
C   STEP 2)
C     OWING THAT THE ELECTRONIC HESSIAN (D-A) IS THE SAME FOR EACH
C     DERIVATIVE, ENLARGE ITERATIVELY THE ORTHONORMAL BASIS SET {B}
C     USED TO INVERT THE PROJECTED HESSIAN.
C     ( DRIVED BY THE LARGEST RESIDUAL VECTOR ).
C     THIS SECTION IS CARRIED OUT IN THE DIAGONAL METRIC 'SCALAR'.
C   STEP 3) ... LOOP ON THE GEOMETRIC VARIABLE :
C 3.1 FOR EACH GEOMETRIC VARIABLE , GET THE M.O DERIVATIVES IN A.O.
C 3.2 COMPUTE THE FOCK EIGENVALUES AND 2-ELECT INTEGRALS RELAXATION.
C 3.3 BUILD THE ELECTRONIC RELAXATION CONTRIBUTION TO THE C.I MATRIX
C     AND GET THE ASSOCIATED EIGENSTATE DERIVATIVE WITH RESPECT TO
C     THE GEOMETRIC VARIABLE.
C
C   INPUT
C     C(N,N) : M.O. COEFFICIENTS, IN COLUMN.
C     CT     : IDEM, TRANSPOSED, ORDERED CLOSED,OPEN,VIRTUAL.
C     E(N)   : EIGENVALUES OF THE FOCK MATRIX.
C     MINEAR : NUMBER OF NON REDUNDANT ROTATION OF THE M.O.
C     THROLD : THRESHOLD OF CONVERGENCE (LARGEST ALLOWED RESIDUE).
C     F(MINEAR,NVAR)   : NON-RELAXED FOCK MATRICES DERIVATIVES
C                        IN M.O BASIS, OFF-DIAGONAL BLOCKS.
C     FD(NINEAR,NVAR)  : IDEM, DIAGONAL BLOCKS, C.I-ACTIVE ONLY.
C     MAXITE           : MAXIMUM SIZE OF THE BASIS {B}.
C     WORK             : WORK ARRAY OF SIZE N*N.
C     B(MINEAR,NBSIZE) : INITIAL ORTHONORMALIZED BASIS SET {B}.
C     GRAD(NVAR)  : GRADIENT VECTOR BEFORE RELAXATION CORRECTION.
C     FAIL        : LOGICAL, NOT DEFINED.
C     AB(MINEAR,MAXITE): STORAGE FOR THE (D-A) * B VECTORS.
C     FB(NVAR,MAXITE)  : STORAGE FOR THE MATRIX PRODUCT F' * B.
C   OUTPUT
C     GRAD   : DERIVATIVE OF THE HEAT OF FORMATION WITH RESPECT TO
C              THE NVAR OPTIMIZED VARIABLES.
C     FAIL   : .FALSE. IF RELAXATION CONVERGED,
C              .TRUE.  OTHERWISE. IN SUCH A CASE, THE REQUIRED DATA
C                      TO RESTART WITH A SMALLER VALUE OF NVAR
C                      ARE AVAILABLE IN /SCRAH2/.
C***********************************************************************
C     NOTE.../SCRCHR/ IS ALSO USED AS A TEMPORARY WORK ARRAY IN ROUTINES
C                     DERI21 , DERI22  , HQRII , DIAGIV
C                     THE LENGTH AGREES WITH 'DERI1' FOR COHERENCY.
C     COMMON /SCRCHR/ BABINV(3600),BCOEF(6*MAXPAR**2+1-3600)            DL0397
      COMMON /SCRCHR/ BABINV(MORB2),BCOEF(6*MAXPAR**2+1-MORB2)          DL0397
C     COMMON /SCRCHR1/ BABINV(MORB2),DUMW(MAXORB**2),
C    1                BCOEF(6*MAXPAR**2+1-MORB2)
      COMMON /SCRAH1/ SCALAR(MPACK/2),DIAG(MPACK/2),FRACT,FBWO(MFBWO),  3GL3092
     1                NBO(3), IDUM                                      3GL3092
     2       /SCRAH2/ DIJKL(NRELAX*MORB2+1)                             GCL0892
     3       /XYIJKL/ XY(NMECI,NMECI,NMECI,NMECI)                       3GL3092
     4       /CIDATA/ VECTCI(MAXCI),XXCI,NCI1,NCI2,NCI3,                DL0397
     5                NCIDUM((1+2*NMECI)*MAXCI)                         DL0397
     6       /WMATRX/ WJ(N2ELEC),WK(N2ELEC*2),NBAND(NUMATM+1)           3GL3092
     7       /DWMAT/  DWJ(N2ELEC),DWK(N2ELEC*2)                         JZ0315
C    6       /WMATRX/ WJ(N2ELEC),WK(N2ELEC),NBAND(NUMATM+1)             3GL3092
     7       /OPTIMI / IMP,IMP0                                         3GL3092
      DIMENSION BAB(60,60),LCONV(60)
     1         ,C(N,N),CT(*),E(N),WORK(N,N),F(MINEAR,*),FD(NINEAR,*)
     2         ,FCI(NINEAR,*),B(MINEAR,*),AB(MINEAR,*),FB(NVAR,*),W(1)
     3         ,GRAD(NVAR)
      LOGICAL FAIL,LCONV,DEBUG,LBAB
C     EQUIVALENCE (W,WJ)
      EQUIVALENCE (W,DWJ)
       SAVE
C
C     * * * STEP 1 * * *
C     BUILD UP THE INITIAL ORTHONORMALIZED BASIS.
C     -------------------------------------------
C
C     READ KEYWORDS, INITIALIZE AND CHECK SIZE OF BLOCKS
      FAIL=.FALSE.
      DEBUG=IDERI2.NE.0                                                 DJG0995

C     DEBUG = .TRUE.
C     JOUT = 6

      LINEAR=N*(N+1)/2
      NOPEN =NBO(1)+NBO(2)
      MAXITE=MIN(MAXITE,60,(6*MAXPAR**2+1-3600)/NVAR,MAXFB/NVAR)        DL0397
      CUTOFF=0.85D0
      NFIST=MIN(NVAR,1+MAXITE/4)
C     CALL PORCPU (TIME1)                                               GL0492
      NBSZE=NBSIZE
      IF(NBSZE.NE.0) THEN
C
C        RESTART CASE. USE BOTH OLD B AND F.
C
C        NORM OF F.
         RNORM=1.D0/SDOT(MINEAR*NVAR,F,1,F,1)
C        SCALED SQUARE OVERLAP OF F ONTO B, STORED IN BCOEF.
         SUM=0.D0
         DO 10 I=1,NBSZE
         LCONV(I)=.FALSE.
         BCOEF(I)=SDOT(NVAR,FB(1,I),1,FB(1,I),1)*RNORM
   10    SUM=SUM+BCOEF(I)
C        SELECT THE BEST SUBSET OF B OVERLAPPING WITH F.
         SUM2=0.D0
         SUM=SUM*0.8D0
   20    TEST=0.D0
         DO 30 J=1,NBSZE
         IF(.NOT.LCONV(J).AND.BCOEF(J).GT.TEST) THEN
            TEST=BCOEF(J)
            K=J
         ENDIF
   30    CONTINUE
         SUM2=SUM2+TEST
         LCONV(K)=.TRUE.
         IF(SUM2.LT.SUM) GO TO 20
         NBSIZE=0
         DO 50 J=1,NBSZE
         IF(LCONV(J)) THEN
            NBSIZE=NBSIZE+1
            IF(NBSIZE.LT.J) THEN
               CALL SCOPY(MINEAR,B(1,J),1,B(1,NBSIZE),1)
C              UPDATE ALSO THE ROW OF BAB AND THE FB MATRIX.
               DO 40 I=1,NBSZE
   40          BAB(NBSIZE,I)=BAB(J,I)
               CALL SCOPY(NVAR,FB(1,J),1,FB(1,NBSIZE),1)
            ENDIF
         ENDIF
   50    CONTINUE
C        NOW TO COMPLETE THE BASIS FROM THE ORTHOGONAL SUBSET OF F.
C        ORTHOGONALIZE {F} WITH {B #1}. STORE IN AB.
         CALL MXMT(B,MINEAR,FB,NBSIZE,AB,NVAR)
         DO 60 I=1,MINEAR*NVAR
   60    AB(I,1)=F(I,1)-AB(I,1)
C        EXTRACT OPTIMUM ORTHONORMALIZED SUBSET FROM AB,
C        THUS PROVIDING A NEW SUBSET #2 TO THE INITIAL BASIS.
         CALL DERI21 (AB,NVAR,MINEAR,CUTOFF,SUM2,NFIST,WORK
     .               ,WORK(NVAR*NVAR+1,1),B(1,NBSIZE+1),NLAST)
C        UPDATE SUBSET #1 OF AB AND BAB (WITH NO CALL TO DERI22).
         K=0
         DO 80 J=1,NBSZE
         IF(LCONV(J)) THEN
            K=K+1
            CALL SCOPY (MINEAR,B(1,NBSZE+J),1,AB(1,K),1)
            DO 70 I=1,NBSIZE
   70       BAB(I,K)=BAB(I,J)
         ENDIF
   80    CONTINUE
      ELSE
C
C        NORMAL CASE. USE F ONLY.
C
         SUM2=0.D0
         CALL DERI21 (F,NVAR,MINEAR,CUTOFF,SUM2,NFIST,WORK
     .               ,WORK(NVAR*NVAR+1,1),B,NLAST)
         NBSIZE=0
      ENDIF
      LBAB=.FALSE.
      NFIST=NBSIZE+1
      NLAST=NBSIZE+NLAST
      DO 90 I=1,NVAR
   90 LCONV(I)=.FALSE.
C
C     * * * STEP 2 * * *
C     RELAXATION METHOD WITH OPTIMUM INCREASE OF THE BASIS SET.
C     ---------------------------------------------------------
C
C     UPDATE AB ,FCI AND BAB. (BAB IS SYMMETRIC)
  100 DO 110 J=NFIST,NLAST
      CALL DERI22 (C,CT,B(1,J),WORK,N,WORK,AB(1,J),MINEAR,FCI(1,J)
     .            ,NCI1,NCI2)
      CALL MXM(AB(1,J),1,B,MINEAR,BAB(1,J),NLAST)
CDIR$ IVDEP
      DO 110 I=1,NFIST-1
  110 BAB(J,I)=BAB(I,J)
C     INVERT BAB, STORE IN BABINV.
  115 L=0
      DO 120 J=1,NLAST
      DO 120 I=1,NLAST
      L=L+1
  120 BABINV(L)=BAB(I,J)
      CALL OSINV (BABINV,NLAST,DETER)
      IF (ISTOP.NE.0) RETURN                                            GDH1095
      IF (DETER.EQ.0) THEN
         WRITE(JOUT,'('' THE BAB MATRIX OF ORDER'',I3,
     .   '' IS SINGULAR IN DERI2''/
     .   '' THE RELAXATION IS STOPPED AT THIS POINT.'')')NLAST
         LBAB=.TRUE.
         NLAST=NLAST-1
         GO TO 115
      ENDIF
      IF (.NOT.LBAB) THEN
C        UPDATE F * B'
         CALL MTXM (F,NVAR,B(1,NFIST),MINEAR,FB(1,NFIST),NLAST-NFIST+1)
      ENDIF
C     NEW SOLUTIONS IN BASIS B , STORED IN BCOEF(NVAR,*).
C     BCOEF = BABINV * FB'
      CALL MXMT (BABINV,NLAST,FB,NLAST,BCOEF,NVAR)
      IF(LBAB) GO TO 200
C
C     SELECT THE NEXT BASIS VECTOR AS THE LARGEST RESIDUAL VECTOR.
C     AND TEST FOR CONVERGENCE ON THE LARGEST RESIDUE.
      NRES=0
      TEST2=0.D0
      DO 140 IVAR=1,NVAR
      IF(LCONV(IVAR)) GO TO 140
C     GET ONE NOT-CONVERGED RESIDUAL VECTOR (# IVAR),
C     STORED IN WORK.
      CALL MXM  (AB,MINEAR,BCOEF(NLAST*(IVAR-1)+1),NLAST,WORK,1)
      DO 130 I=1,MINEAR
  130 WORK(I,1)=F(I,IVAR)-WORK(I,1)
      TEST=ABS(WORK(ISMAX(MINEAR,WORK,1),1))
      TEST2=MAX(TEST2,TEST)
      IF (TEST.LE.THROLD) THEN
         LCONV(IVAR)=.TRUE.
         GO TO 140
      ELSE IF (NLAST+NRES.EQ.MAXITE) THEN
C        NO MORE STORAGE...
         FAIL=NRES.EQ.0
         GO TO 150
      ELSE
C        STORE THE FOLLOWING RESIDUE IN AB(CONTINUED).
         NRES=NRES+1
         CALL SCOPY (MINEAR,WORK,1,AB(1,NLAST+NRES),1)
      ENDIF
  140 CONTINUE
  150 IF (NRES.EQ.0) GO TO 200
C     FIND OPTIMUM FOLLOWING SUBSET, ADD TO B AND LOOP.
      SUM2=0.D0
      NFIST=NLAST+1
      CALL DERI21(AB(1,NFIST),NRES,MINEAR,CUTOFF,SUM2,NRES,WORK
     .           ,WORK(NRES*NRES+1,1),B(1,NFIST),NADD)
      NLAST=NLAST+NADD
      GO TO 100
C
C     CONVERGENCE ACHIEVED OR HALTED.
C     -------------------------------
C
  200 NBSZE=NBSIZE
      IF(DEBUG.OR.LBAB) THEN
         WRITE(JOUT,'('' RELAXATION ENDED IN DERI2 AFTER'',I3,
     .   '' CYCLES''/'' REQUIRED CONVERGENCE THRESHOLD ON RESIDUALS =''
     .   ,F12.9/'' HIGHEST RESIDUAL ON'',I3,'' GRADIENT COMPONENTS = ''
     .   ,F12.9)')NLAST-NBSZE,THROLD,NVAR,TEST2
C        CALL PORCPU (TIME2)                                            GL0492
C        WRITE(JOUT,'('' ELAPSED TIME IN RELAXATION'',F15.3,'' SECOND'')
C    .              ')TIME2-TIME1
      ENDIF
      IF(FAIL) THEN
C        KEEP MOST OF DATA FOR FURTHER REUSE,AB IS STORED IN END OF B.
         NBSIZE=NLAST/2
         CALL SCOPY (NBSIZE*MINEAR,AB,1,B(1,NBSIZE+1),1)
         RETURN
      ELSE
         NBSIZE=0
C        UNSCALED SOLUTION SUPERVECTORS, STORED IN F.
         CALL MXM (B,MINEAR,BCOEF,NLAST,F,NVAR)
         DO 210 J=1,NVAR
         DO 210 I=1,MINEAR
  210    F(I,J)=F(I,J)*SCALAR(I)
C        FOCK MATRIX DIAGONAL BLOCKS OVER C.I-ACTIVE M.O.
C        STORED IN FB.
         CALL MXM (FCI,NINEAR,BCOEF,NLAST,FB,NVAR)
      ENDIF
C
C     * * * STEP 3 * * *
C     FINAL LOOP (390) ON THE GEOMETRIC VARIABLES.
C     --------------------------------------------
C
      DO 390 IVAR=1,NVAR
C
C     C.I-ACTIVE M.O DERIVATIVES INTO THE M.O BASIS,
C         RETURNED IN AB (N,NCI1+1,...,NCI1+NCI2).
C     C.I-ACTIVE EIGENVALUES DERIVATIVES,
C         RETURNED IN BCOEF(NCI1+1,...,NCI1+NCI2).
      CALL DERI23 (F(1,IVAR),MINEAR,FD(1,IVAR),NINEAR,E
     .            ,FB(NINEAR*(IVAR-1)+1,1),AB,BCOEF,N,NCI1,NCI2)
C
C     DERIVATIVES OF THE 2-ELECTRONS INTEGRALS OVER C.I-ACTIVE M.O.
C     STORED IN /XYIJKL/.
      CALL DIJKL2 (AB(N*NCI1+1,1),N,NCI2,DIJKL,XY,NMECI)
      IF(DEBUG.AND.IDEBUG.NE.0) THEN                                    DJG0995
         WRITE(JOUT,'('' * * * CART. GRADIENT COMPONENT'',I4)')IVAR
         WRITE(JOUT,'('' C.I-ACTIVE M.O. DERIVATIVES IN M.O BASIS'',
     .                '', IN ROW.'')')
         L=N*NCI1+1
         DO 320 I=NCI1+1,NCI1+NCI2
         WRITE(JOUT,'(8F10.4)')(AB(K,1),K=L,L+N-1)
 320     L=L+N
         WRITE(JOUT,'('' C.I-ACTIVE FOCK EIGENVALUES RELAXATION (E.V.)''
     .               )')
         WRITE(JOUT,'(8F10.4)')(BCOEF(I),I=NCI1+1,NCI1+NCI2)
         WRITE(JOUT,'('' 2-ELECTRON INTEGRALS RELAXATION (E.V.)''/
     .''  I    J    K    L       d<I(1)J(1)!K(2)L(2)> RELAXATION ONLY'')
     .')
         DO 330 I=1,NCI2
         DO 330 J=1,I
         DO 330 K=1,I
         LL=K
         IF(K.EQ.I) LL=J
         DO 330 L=1,LL
 330     WRITE(JOUT,'(4I5,F20.10)')
     .              NCI1+I,NCI1+J,NCI1+K,NCI1+L,XY(I,J,K,L)
         
      ENDIF
C
C     BUILD THE C.I MATRIX DERIVATIVE, STORED IN AB.
      CALL MECID (BCOEF,GSE,WORK(NCI3+1,1),WORK)
      CALL MECIH (WORK,AB)
C     RELAXATION CORRECTION TO THE C.I ENERGY DERIVATIVE.
      CALL SUPDOT (WORK,AB,VECTCI,NCI3,1)
      GRAD(IVAR)=GRAD(IVAR)+SDOT(NCI3,VECTCI,1,WORK,1)*23.061D0
      IF (DEBUG) WRITE(JOUT,'('' RELAXATION OF CART. GRAD. COMPONENT'',
     .I3,'' : '',F10.4,'' KCAL/MOLE'')')
     .IVAR,SDOT(NCI3,VECTCI,1,WORK,1)*23.061D0
C
C     THE END .
  390 CONTINUE
C     IF(DEBUG) THEN
C       CALL PORCPU(TFLY)                                               GL0492
C       WRITE(JOUT,'('' ELAPSED TIME IN C.I-ENERGY RELAXATION'',F15.3,
C    .                '' SECOND'')')TFLY-TIME2
C     ENDIF
      RETURN
      END
