from astropy.table import Table

ref_table = Table.read("./table_spectra.csv")

for line in ref_table:
    filename = f"./{line['reference']}/{line['file_id']}.ecsv"
    spectrum = Table.read(filename)
    meta = spectrum.meta

    print(f"Source: {meta['source_name']}")
    print(f"Observation period: {meta['mjd_start']} - {meta['mjd_stop']} MJD")
    print(f"Observatory: {meta['instrument']}")
    print("\n")

    for key in ['e_ref', 'dnde', 'dnde_errn', 'dnde_errp']:
        print(spectrum[key])
        print("\n")
    print("\n\n")

print("Total number of spectra:")
print(len(ref_table))
