-- MySQL dump 10.13  Distrib 8.0.33, for Linux (x86_64)
--
-- Host: localhost    Database: NU_creepAndShrinkage
-- ------------------------------------------------------
-- Server version	8.0.33-0ubuntu0.22.04.2

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!50503 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `acknowledgement`
--

DROP TABLE IF EXISTS `acknowledgement`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `acknowledgement` (
  `A_id` int NOT NULL AUTO_INCREMENT COMMENT '[INT] primary key',
  `A_Person` text CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci COMMENT '[TEXT] Person',
  `A_Affiliation` text CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci COMMENT '[TEXT] Affiliation',
  `A_Project` text CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci COMMENT '[TEXT] Project',
  `A_Year_from` int DEFAULT NULL COMMENT '[INT] Year from the beginning of contribution',
  `A_Year_to` int DEFAULT NULL COMMENT '[INT] Year of finished contribution',
  `A_note` text CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL COMMENT '[TEXT] Main topics of contribution',
  PRIMARY KEY (`A_id`)
) ENGINE=InnoDB AUTO_INCREMENT=18 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `acknowledgement`
--

LOCK TABLES `acknowledgement` WRITE;
/*!40000 ALTER TABLE `acknowledgement` DISABLE KEYS */;
INSERT INTO `acknowledgement` VALUES (1,'Z.P. Bažant','Northwestern University, IL, USA','U.S. Department of Transportation, Infrastructure Technology Institute of Northwestern University\r\n',1978,NULL,'Original founder of the database'),(2,'Liisa Panula','Northwestern University, IL, USA',NULL,1979,NULL,''),(12,'G.-H. Li','Bažant\'s student',NULL,2008,2008,''),(13,'Mija Hubler','Northwestern University, IL, USA',NULL,2010,2020,''),(14,'Roman Wendner','Northwestern University, IL, USA','Austrian Science Fund (FWF) in the form of the Erwin-Schrödinger Scholarship J3619-N13.\r\n',2013,2021,''),(15,'Mohammad Rasoolinejad','Northwestern University, IL, USA',NULL,2018,2019,''),(16,'Vít Šmilauer','Czech Technical University in Prague, Faculty of Civil Engineering, Department of mechanics, Czech Republic','EU H2020 Euratom Research\r\nproject ‘Towards improved assessment of safety performance for long-term operation of nuclear civil engineering structures’ — NFRP-2019-2020.\r\n\r\n',2020,NULL,'Revamp of NU Creep and Shrinkage database to MySQL form.'),(17,'Lenka Dohnalová','Czech Technical University in Prague, Faculty of Civil Engineering, Department of mechanics, Czech Republic','EU H2020 Euratom Research\r\nproject ‘Towards improved assessment of safety performance for long-term operation of nuclear civil engineering structures’ — NFRP-2019-2020.',2020,NULL,'Fixes of several data, appending new Creep and Shrinkage data');
/*!40000 ALTER TABLE `acknowledgement` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cement`
--

DROP TABLE IF EXISTS `cement`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cement` (
  `CEM_id` int NOT NULL AUTO_INCREMENT COMMENT '[INT] Primary key',
  `CEM_Blaine` float DEFAULT NULL COMMENT '[m2/kg] Blaine fineness of cement (cement as M_c_mass)',
  `CEM_SiO2` float DEFAULT NULL COMMENT '[%] Mass fraction in clinker.',
  `CEM_Al2O3` float DEFAULT NULL COMMENT '[%] Mass fraction in clinker.',
  `CEM_Fe2O3` float DEFAULT NULL COMMENT '[%] Mass fraction in clinker.',
  `CEM_CaO_tot` float DEFAULT NULL COMMENT '[%] Mass fraction in clinker.',
  `CEM_CaO_free` float DEFAULT NULL COMMENT '[%] Mass fraction of clinker. Free lime content.',
  `CEM_MgO` float DEFAULT NULL COMMENT '[%] Mass fraction in clinker.',
  `CEM_Na2O` float DEFAULT NULL COMMENT '[%] Mass fraction in clinker.',
  `CEM_K2O` float DEFAULT NULL COMMENT '[%] Mass fraction in clinker.',
  `CEM_Na2O_eq` float DEFAULT NULL COMMENT '[%] Mass fraction in clinker.',
  `CEM_SO3` float DEFAULT NULL COMMENT '[%] Mass fraction in clinker.',
  `CEM_LossOnIgnition` float DEFAULT NULL COMMENT '[%] Mass fraction in clinker.',
  `CEM_C3S` float DEFAULT NULL COMMENT '[%] Mass fraction in clinker.',
  `CEM_C2S` float DEFAULT NULL COMMENT '[%] Mass fraction in clinker.',
  `CEM_C3A` float DEFAULT NULL COMMENT '[%] Mass fraction in clinker.',
  `CEM_C4AF` float DEFAULT NULL COMMENT '[%] Mass fraction in clinker.',
  `CEM_gypsum` float DEFAULT NULL COMMENT '[%] Mass fraction in clinker (or added to clinker)',
  `CEM_d50` float DEFAULT NULL COMMENT '[um] Diameter with 50% on PSD',
  `CEM_fc_1d` float DEFAULT NULL COMMENT '[MPa] Compressive strength of cement at 1 day (usually on 40x40x40 cubes with 1:3 mortar and w/c=0.50)',
  `CEM_fc_2d` float DEFAULT NULL COMMENT '[MPa] Compressive strength of cement (usually on 40x40x40 cubes with 1:3 mortar and w/c=0.50)',
  `CEM_fc_3d` float DEFAULT NULL COMMENT '[MPa] Compressive strength of cement at 1 day (usually on 40x40x40 cubes with 1:3 mortar and w/c=0.50)',
  `CEM_fc_7d` float DEFAULT NULL COMMENT '[MPa] Compressive strength of cement at 1 day (usually on 40x40x40 cubes with 1:3 mortar and w/c=0.50)',
  `CEM_fc_14d` float DEFAULT NULL COMMENT '[MPa] Compressive strength of cement at 1 day (usually on 40x40x40 cubes with 1:3 mortar and w/c=0.50)',
  `CEM_fc_28d` float DEFAULT NULL COMMENT '[MPa] Compressive strength of cement at 1 day (usually on 40x40x40 cubes with 1:3 mortar and w/c=0.50)',
  `CEM_fc_90d` float DEFAULT NULL COMMENT '[MPa] Compressive strength of cement (usually on 40x40x40 cubes with 1:3 mortar and w/c=0.50)',
  `CEM _ft_1d` int DEFAULT NULL COMMENT '[MPa] Modulus of rupture of cement at 1 day (usually on 40x40x40 cubes with 1:3 mortar and w/c=0.50)',
  `CEM_ft_2d` float DEFAULT NULL COMMENT '[MPa] Modulus of rupture of cement (usually on 40x40x40 cubes with 1:3 mortar and w/c=0.50)',
  `CEM_ft_3d` float DEFAULT NULL COMMENT '[MPa] Modulus of rupture of cement (usually on 40x40x40 cubes with 1:3 mortar and w/c=0.50)',
  `CEM_ft_7d` float DEFAULT NULL COMMENT '[MPa] Modulus of rupture of cement (usually on 40x40x40 cubes with 1:3 mortar and w/c=0.50)',
  `CEM_ft_14d` float DEFAULT NULL COMMENT '[MPa] Modulus of rupture of cement (usually on 40x40x40 cubes with 1:3 mortar and w/c=0.50)',
  `CEM_ft_28d` float DEFAULT NULL COMMENT '[MPa] Modulus of rupture of cement (usually on 40x40x40 cubes with 1:3 mortar and w/c=0.50)',
  `CEM_ft_90d` float DEFAULT NULL COMMENT '[MPa] Modulus of rupture of cement (usually on 40x40x40 cubes with 1:3 mortar and w/c=0.50)',
  `CEM_note` text CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci COMMENT '[TEXT] Notes to cement',
  PRIMARY KEY (`CEM_id`)
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cement`
--

LOCK TABLES `cement` WRITE;
/*!40000 ALTER TABLE `cement` DISABLE KEYS */;
INSERT INTO `cement` VALUES (1,339,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(2,557,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(3,623,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(4,743,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(5,643,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,59,25.9,0.6,14.2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(6,387,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,59,25.9,0.6,14.2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(7,254,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,59,25.9,0.6,14.2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(8,212,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,59,25.9,0.6,14.2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(9,580,23.5,5.8,5.4,60,NULL,0.8,NULL,NULL,NULL,4.1,1.04,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Premixed low heat high belite cement\r\n(LHSF) containing 10% of SF as a partial replacement of cement.\r\n'),(10,415,20.5,4.4,2.3,63.3,NULL,1.9,0.09,0.82,0.62,3.3,2.3,68,10,9,8,3.8,NULL,22,36,NULL,51,NULL,63,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'CCB Italcementi Group - Gaurain - CEM I 52.5 N CE CP2 NF.'),(11,378,19.08,4.55,3.14,62.81,NULL,1.36,0.13,1.53,1.08,2.73,3.87,59.8,15.8,7.2,10.7,3,16,NULL,33.5,NULL,NULL,NULL,54.4,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'CEM II/A-LL 42,5 R CE PM-CP2 NF'),(12,380,20.69,4.72,3.06,63.76,NULL,2.08,0.26,0.61,NULL,2.92,0.87,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
/*!40000 ALTER TABLE `cement` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `change_log`
--

DROP TABLE IF EXISTS `change_log`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `change_log` (
  `CL_id` int NOT NULL AUTO_INCREMENT COMMENT '[INT] Primary key',
  `CL_date` timestamp NULL DEFAULT CURRENT_TIMESTAMP COMMENT '[TIMESTAMP] Date of creation',
  `CL_who` text CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci COMMENT '[TEXT] Family name, (first name)',
  `CL_what` text CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci COMMENT '[TEXT] What has been done',
  PRIMARY KEY (`CL_id`),
  UNIQUE KEY `CL_id` (`CL_id`)
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `change_log`
--

LOCK TABLES `change_log` WRITE;
/*!40000 ALTER TABLE `change_log` DISABLE KEYS */;
INSERT INTO `change_log` VALUES (4,'2020-10-10 10:46:33','Smilauer, Vit','Imported references from Bažant\'s database (CreepShrinkData_20191209GB.xlsx)'),(5,'2020-10-14 15:37:46','Smilauer, Vit','Imported concretes from Bažant\'s database, about 1/3 of columns filled so far.'),(8,'2020-10-23 13:41:17','Smilauer, Vit','Paired all Mix to Literature, That means we have all connections, although a few references remain unknown.'),(9,'2020-10-29 13:29:21','Smilauer, Vit','Added all Bažant\'s DB data for Creep and Shrinkage. Missing parent data for Shrinkage datasets: H_001_01, A_036_05, A_036_06, A_036_08, A_042_05, A_048_01 - A_048_05, A_072_13 - A_072_15. They were omitted.\r\n'),(10,'2020-11-11 08:02:00','Smilauer, Vit','Checked swelling of all concretes/mortar/pastes which are stored in water. Fixed about 50 test data, where the strain signs were wrong, i.e. expansion +, shrinkage-. Checked against original literature source.'),(11,'2021-01-05 10:15:50','Smilauer, Vit','Revamp of table mix. Classical specification in terms of kg/m3 of everything (aggregates, admixtures, superplasticizer etc.). The ratios w/c, a/c and M_agg_all_mass are automatically calculated by triggers on UPDATE and INSERT commands.'),(12,'2021-05-03 14:00:00','Smilauer, Vit','First official release of SQL version as NU Database of Laboratory Creep and Shrinkage Data.');
/*!40000 ALTER TABLE `change_log` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `creep_data`
--

DROP TABLE IF EXISTS `creep_data`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `creep_data` (
  `CD_id` int NOT NULL AUTO_INCREMENT COMMENT '[INT] Primary key',
  `CD_CT_id` int NOT NULL COMMENT '[INT] Reference to creep_test table',
  `CD_dt` float NOT NULL COMMENT '[Day] Time difference: for drying creep t-t0 (since exposure), for basic or total creep t-t'' (since mechanical loading)',
  `CD_Jcreep` float NOT NULL COMMENT '[uE/MPa] Creep function',
  `CD_massLoss` float DEFAULT NULL COMMENT '[%] Mass loss during the test',
  `CD_elimData` tinyint(1) DEFAULT NULL COMMENT '[BOOL] If true, suspicious data',
  `CD_note` text CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci COMMENT '[TEXT] Note',
  `CD_checked_by` text CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci COMMENT '[TEXT] Checked by',
  PRIMARY KEY (`CD_id`),
  KEY `CD_CI_id key` (`CD_CT_id`),
  CONSTRAINT `CD_CI_id key` FOREIGN KEY (`CD_CT_id`) REFERENCES `creep_test` (`CT_id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE=InnoDB AUTO_INCREMENT=72715 DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `creep_data`
--

LOCK TABLES `creep_data` WRITE;
/*!40000 ALTER TABLE `creep_data` DISABLE KEYS */;
INSERT INTO `creep_data` VALUES (1,1,40,57,NULL,NULL,NULL,NULL),(2,1,161,83,NULL,NULL,NULL,NULL),(3,1,241,92,NULL,NULL,NULL,NULL),(4,1,300,96,NULL,NULL,NULL,NULL),(5,1,700,111,NULL,NULL,NULL,NULL),(6,1,900,112,NULL,NULL,NULL,NULL),(7,2,40,60,NULL,NULL,NULL,NULL),(8,2,100,78,NULL,NULL,NULL,NULL),(9,2,161,93,NULL,NULL,NULL,NULL),(10,2,241,102,NULL,NULL,NULL,NULL),(11,2,300,105,NULL,NULL,NULL,NULL),(12,2,400,112,NULL,NULL,NULL,NULL),(13,2,550,115,NULL,NULL,NULL,NULL),(14,2,700,120,NULL,NULL,NULL,NULL),(15,2,900,124,NULL,NULL,NULL,NULL),(16,3,40,39,NULL,NULL,NULL,NULL),(17,3,100,47,NULL,NULL,NULL,NULL),(18,3,242,51,NULL,NULL,NULL,NULL),(19,3,400,52,NULL,NULL,NULL,NULL),(20,3,549,53,NULL,NULL,NULL,NULL),(21,3,700,53,NULL,NULL,NULL,NULL),(22,3,900,53,NULL,NULL,NULL,NULL),(23,4,40,40,NULL,NULL,NULL,NULL),(24,4,100,43,NULL,NULL,NULL,NULL),(25,4,160,46,NULL,NULL,NULL,NULL),(26,4,242,50,NULL,NULL,NULL,NULL),(27,4,322,50,NULL,NULL,NULL,NULL),(28,4,400,51,NULL,NULL,NULL,NULL),(29,4,549,52,NULL,NULL,NULL,NULL),(30,4,700,52,NULL,NULL,NULL,NULL),(31,4,900,54,NULL,NULL,NULL,NULL),(32,5,40,44,NULL,NULL,NULL,NULL),(33,5,82,55,NULL,NULL,NULL,NULL),(34,5,100,58,NULL,NULL,NULL,NULL),(35,5,160,64,NULL,NULL,NULL,NULL),(36,5,400,78,NULL,NULL,NULL,NULL),(37,5,552,83,NULL,NULL,NULL,NULL),(38,5,700,85,NULL,NULL,NULL,NULL),(39,5,900,87,NULL,NULL,NULL,NULL),(40,6,23,50,NULL,NULL,NULL,NULL),(41,6,40,64,NULL,NULL,NULL,NULL),(42,6,82,85,NULL,NULL,NULL,NULL),(43,6,120,104,NULL,NULL,NULL,NULL),(44,6,160,113,NULL,NULL,NULL,NULL),(45,6,240,120,NULL,NULL,NULL,NULL),(46,6,320,125,NULL,NULL,NULL,NULL),(47,6,400,129,NULL,NULL,NULL,NULL),(48,6,548,135,NULL,NULL,NULL,NULL),(49,6,700,140,NULL,NULL,NULL,NULL),(50,6,900,142,NULL,NULL,NULL,NULL),(51,7,5,60,NULL,NULL,NULL,NULL),(52,7,31,67,NULL,NULL,NULL,NULL),(53,7,83,73,NULL,NULL,NULL,NULL),(54,7,140,76,NULL,NULL,NULL,NULL),(55,7,220,78,NULL,NULL,NULL,NULL),(56,7,332,81,NULL,NULL,NULL,NULL),(57,7,472,84,NULL,NULL,NULL,NULL),(58,7,732,87,NULL,NULL,NULL,NULL),(59,7,972,89,NULL,NULL,NULL,NULL),(60,7,1222,90,NULL,NULL,NULL,NULL),(61,7,1472,91,NULL,NULL,NULL,NULL),(62,7,1722,93,NULL,NULL,NULL,NULL),(63,7,1972,94,NULL,NULL,NULL,NULL),(64,7,2222,94,NULL,NULL,NULL,NULL),(65,7,2472,95,NULL,NULL,NULL,NULL),(66,7,2722,95,NULL,NULL,NULL,NULL),(67,7,2972,96,NULL,NULL,NULL,NULL),(68,7,3222,96,NULL,NULL,NULL,NULL),(69,8,5,91,NULL,NULL,NULL,NULL),(70,8,26,109,NULL,NULL,NULL,NULL),(71,8,48,120,NULL,NULL,NULL,NULL),(72,8,98,129,NULL,NULL,NULL,NULL),(73,8,148,133,NULL,NULL,NULL,NULL),(74,8,198,136,NULL,NULL,NULL,NULL),(75,8,248,138,NULL,NULL,NULL,NULL),(76,8,298,139,NULL,NULL,NULL,NULL),(77,8,348,141,NULL,NULL,NULL,NULL),(78,8,398,142,NULL,NULL,NULL,NULL),(79,8,448,142,NULL,NULL,NULL,NULL),(80,8,498,143,NULL,NULL,NULL,NULL),(81,8,548,143,NULL,NULL,NULL,NULL),(82,8,598,144,NULL,NULL,NULL,NULL),(83,8,648,144,NULL,NULL,NULL,NULL),(84,8,698,144,NULL,NULL,NULL,NULL),(85,8,748,145,NULL,NULL,NULL,NULL),(86,9,3,55,NULL,NULL,NULL,NULL),(87,9,21,70,NULL,NULL,NULL,NULL),(88,9,43,78,NULL,NULL,NULL,NULL),(89,9,93,85,NULL,NULL,NULL,NULL),(90,9,143,89,NULL,NULL,NULL,NULL),(91,9,193,92,NULL,NULL,NULL,NULL),(92,9,243,93,NULL,NULL,NULL,NULL),(93,9,293,95,NULL,NULL,NULL,NULL),(94,9,343,96,NULL,NULL,NULL,NULL),(95,10,22,47,NULL,NULL,NULL,NULL),(96,10,72,55,NULL,NULL,NULL,NULL),(97,10,122,58,NULL,NULL,NULL,NULL),(98,10,172,60,NULL,NULL,NULL,NULL),(99,10,222,61,NULL,NULL,NULL,NULL),(100,10,272,63,NULL,NULL,NULL,NULL),(101,10,322,63,NULL,NULL,NULL,NULL),(102,10,372,64,NULL,NULL,NULL,NULL),(103,10,422,65,NULL,NULL,NULL,NULL),(104,10,472,66,NULL,NULL,NULL,NULL),(105,10,522,66,NULL,NULL,NULL,NULL),(106,10,572,66,NULL,NULL,NULL,NULL),(107,10,622,66,NULL,NULL,NULL,NULL),(108,10,672,67,NULL,NULL,NULL,NULL),(109,10,722,67,NULL,NULL,NULL,NULL),(110,11,10,38,NULL,NULL,NULL,NULL),(111,11,60,45,NULL,NULL,NULL,NULL),(112,11,110,48,NULL,NULL,NULL,NULL),(113,11,160,50,NULL,NULL,NULL,NULL),(114,11,210,51,NULL,NULL,NULL,NULL),(115,11,260,52,NULL,NULL,NULL,NULL),(116,12,35,34,NULL,NULL,NULL,NULL),(117,12,85,37,NULL,NULL,NULL,NULL),(118,12,135,39,NULL,NULL,NULL,NULL),(119,12,185,40,NULL,NULL,NULL,NULL),(120,12,235,41,NULL,NULL,NULL,NULL),(121,12,285,42,NULL,NULL,NULL,NULL),(122,12,335,43,NULL,NULL,NULL,NULL),(123,12,385,44,NULL,NULL,NULL,NULL),(124,13,13,76,NULL,NULL,NULL,NULL),(125,13,27,80,NULL,NULL,NULL,NULL),(126,13,62,85,NULL,NULL,NULL,NULL),(127,13,585,99,NULL,NULL,NULL,NULL),(128,13,663,100,NULL,NULL,NULL,NULL),(129,13,820,103,NULL,NULL,NULL,NULL),(130,13,1874,108,NULL,NULL,NULL,NULL),(131,13,2778,110,NULL,NULL,NULL,NULL),(132,13,4671,116,NULL,NULL,NULL,NULL),(133,13,6979,118,NULL,NULL,NULL,NULL),(134,14,12,66,NULL,NULL,NULL,NULL),(135,14,33,75,NULL,NULL,NULL,NULL),(136,14,55,79,NULL,NULL,NULL,NULL),(137,14,112,88,NULL,NULL,NULL,NULL),(138,14,388,93,NULL,NULL,NULL,NULL),(139,14,567,100,NULL,NULL,NULL,NULL),(140,14,674,100,NULL,NULL,NULL,NULL),(141,14,758,100,NULL,NULL,NULL,NULL),(142,14,814,109,NULL,NULL,NULL,NULL),(143,14,1874,110,NULL,NULL,NULL,NULL),(144,14,2714,111,NULL,NULL,NULL,NULL),(145,14,4635,104,NULL,NULL,NULL,NULL),(146,14,8700,125,NULL,NULL,NULL,NULL),(147,15,12,83,NULL,NULL,NULL,NULL),(148,15,33,100,NULL,NULL,NULL,NULL),(149,15,49,113,NULL,NULL,NULL,NULL),(150,15,118,127,NULL,NULL,NULL,NULL),(151,15,382,157,NULL,NULL,NULL,NULL),(152,15,567,164,NULL,NULL,NULL,NULL),(153,15,648,165,NULL,NULL,NULL,NULL),(154,15,758,166,NULL,NULL,NULL,NULL),(155,15,1874,175,NULL,NULL,NULL,NULL),(156,15,2692,173,NULL,NULL,NULL,NULL),(157,15,4598,181,NULL,NULL,NULL,NULL),(158,15,6924,194,NULL,NULL,NULL,NULL),(159,16,13,97,NULL,NULL,NULL,NULL),(160,16,26,112,NULL,NULL,NULL,NULL),(161,16,60,134,NULL,NULL,NULL,NULL),(162,16,94,151,NULL,NULL,NULL,NULL),(163,16,388,175,NULL,NULL,NULL,NULL),(164,16,562,205,NULL,NULL,NULL,NULL),(165,16,643,208,NULL,NULL,NULL,NULL),(166,16,758,210,NULL,NULL,NULL,NULL),(167,16,814,210,NULL,NULL,NULL,NULL),(168,16,1889,223,NULL,NULL,NULL,NULL),(169,16,2714,228,NULL,NULL,NULL,NULL),(170,16,4635,234,NULL,NULL,NULL,NULL),(171,16,8497,240,NULL,NULL,NULL,NULL),(172,17,1,50,NULL,NULL,NULL,NULL),(173,17,2,58,NULL,NULL,NULL,NULL),(174,17,4,63,NULL,NULL,NULL,NULL),(175,17,8,68,NULL,NULL,NULL,NULL),(176,17,15,74,NULL,NULL,NULL,NULL),(177,17,29,83,NULL,NULL,NULL,NULL),(178,17,56,94,NULL,NULL,NULL,NULL),(179,17,90,102,NULL,NULL,NULL,NULL),(180,17,141,108,NULL,NULL,NULL,NULL),(181,17,173,110,NULL,NULL,NULL,NULL),(182,17,253,115,NULL,NULL,NULL,NULL),(183,17,362,117,NULL,NULL,NULL,NULL),(184,17,530,121,NULL,NULL,NULL,NULL),(185,17,768,124,NULL,NULL,NULL,NULL),(186,18,8,68,NULL,NULL,NULL,NULL),(187,18,15,73,NULL,NULL,NULL,NULL),(188,18,29,82,NULL,NULL,NULL,NULL),(189,18,56,93,NULL,NULL,NULL,NULL),(190,18,90,100,NULL,NULL,NULL,NULL),(191,18,141,107,NULL,NULL,NULL,NULL),(192,18,173,111,NULL,NULL,NULL,NULL),(193,18,253,114,NULL,NULL,NULL,NULL),(194,18,362,117,NULL,NULL,NULL,NULL),(195,18,530,122,NULL,NULL,NULL,NULL),(196,18,768,125,NULL,NULL,NULL,NULL),(197,19,1,52,NULL,NULL,NULL,NULL),(198,19,2,58,NULL,NULL,NULL,NULL),(199,19,4,62,NULL,NULL,NULL,NULL),(200,19,8,66,NULL,NULL,NULL,NULL),(201,19,15,70,NULL,NULL,NULL,NULL),(202,19,29,78,NULL,NULL,NULL,NULL),(203,19,56,86,NULL,NULL,NULL,NULL),(204,19,90,89,NULL,NULL,NULL,NULL),(205,19,141,94,NULL,NULL,NULL,NULL),(206,19,173,100,NULL,NULL,NULL,NULL),(207,19,253,105,NULL,NULL,NULL,NULL),(208,19,362,107,NULL,NULL,NULL,NULL),(209,19,530,110,NULL,NULL,NULL,NULL),(210,19,768,112,NULL,NULL,NULL,NULL),(211,20,1,50,NULL,NULL,NULL,NULL),(212,20,2,56,NULL,NULL,NULL,NULL),(213,20,4,60,NULL,NULL,NULL,NULL),(214,20,8,63,NULL,NULL,NULL,NULL),(215,20,15,68,NULL,NULL,NULL,NULL),(216,20,29,75,NULL,NULL,NULL,NULL),(217,20,56,81,NULL,NULL,NULL,NULL),(218,20,90,85,NULL,NULL,NULL,NULL),(219,20,141,90,NULL,NULL,NULL,NULL),(220,20,173,91,NULL,NULL,NULL,NULL),(221,20,253,93,NULL,NULL,NULL,NULL),(222,20,362,96,NULL,NULL,NULL,NULL),(223,20,530,103,NULL,NULL,NULL,NULL),(224,20,768,107,NULL,NULL,NULL,NULL),(225,21,1,58,NULL,NULL,NULL,NULL),(226,21,3,70,NULL,NULL,NULL,NULL),(227,21,7,77,NULL,NULL,NULL,NULL),(228,21,13,83,NULL,NULL,NULL,NULL),(229,21,28,91,NULL,NULL,NULL,NULL),(230,21,56,101,NULL,NULL,NULL,NULL),(231,21,82,106,NULL,NULL,NULL,NULL),(232,21,174,113,NULL,NULL,NULL,NULL),(233,21,272,115,NULL,NULL,NULL,NULL),(234,21,365,120,NULL,NULL,NULL,NULL),(235,21,550,123,NULL,NULL,NULL,NULL),(236,21,736,127,NULL,NULL,NULL,NULL),(237,22,1,73,NULL,NULL,NULL,NULL),(238,22,3,84,NULL,NULL,NULL,NULL),(239,22,7,94,NULL,NULL,NULL,NULL),(240,22,13,101,NULL,NULL,NULL,NULL),(241,22,28,112,NULL,NULL,NULL,NULL),(242,22,56,123,NULL,NULL,NULL,NULL),(243,22,82,129,NULL,NULL,NULL,NULL),(244,22,174,137,NULL,NULL,NULL,NULL),(245,22,272,141,NULL,NULL,NULL,NULL),(246,22,365,145,NULL,NULL,NULL,NULL),(247,22,550,149,NULL,NULL,NULL,NULL),(248,22,736,154,NULL,NULL,NULL,NULL),(249,23,1,38,NULL,NULL,NULL,NULL),(250,23,3,47,NULL,NULL,NULL,NULL),(251,23,7,51,NULL,NULL,NULL,NULL),(252,23,14,55,NULL,NULL,NULL,NULL),(253,23,28,58,NULL,NULL,NULL,NULL),(254,23,55,65,NULL,NULL,NULL,NULL),(255,23,85,69,NULL,NULL,NULL,NULL),(256,23,180,76,NULL,NULL,NULL,NULL),(257,23,269,78,NULL,NULL,NULL,NULL),(258,23,375,78,NULL,NULL,NULL,NULL),(259,23,569,82,NULL,NULL,NULL,NULL),(260,23,767,89,NULL,NULL,NULL,NULL),(261,24,1,43,NULL,NULL,NULL,NULL),(262,24,3,49,NULL,NULL,NULL,NULL),(263,24,7,54,NULL,NULL,NULL,NULL),(264,24,14,58,NULL,NULL,NULL,NULL),(265,24,28,65,NULL,NULL,NULL,NULL),(266,24,55,72,NULL,NULL,NULL,NULL),(267,24,85,76,NULL,NULL,NULL,NULL),(268,24,180,83,NULL,NULL,NULL,NULL),(269,24,269,86,NULL,NULL,NULL,NULL),(270,24,375,90,NULL,NULL,NULL,NULL),(271,24,569,95,NULL,NULL,NULL,NULL),(272,24,767,99,NULL,NULL,NULL,NULL),(273,25,1,90.7,NULL,NULL,NULL,NULL),(274,25,3,107,NULL,NULL,NULL,NULL),(275,25,7,119.7,NULL,NULL,NULL,NULL),(276,25,13,130.6,NULL,NULL,NULL,NULL),(277,25,28,144.9,NULL,NULL,NULL,NULL),(278,25,56,160.7,NULL,NULL,NULL,NULL),(279,25,82,169.3,NULL,NULL,NULL,NULL),(280,25,174,182,NULL,NULL,NULL,NULL),(281,25,272,187.4,NULL,NULL,NULL,NULL),(282,25,365,190.3,NULL,NULL,NULL,NULL),(283,25,550,194.9,NULL,NULL,NULL,NULL),(284,25,736,198.6,NULL,NULL,NULL,NULL),(285,26,1,94.2,NULL,NULL,NULL,NULL),(286,26,3,105.8,NULL,NULL,NULL,NULL),(287,26,7,125.1,NULL,NULL,NULL,NULL),(288,26,13,142.2,NULL,NULL,NULL,NULL),(289,26,28,161.2,NULL,NULL,NULL,NULL),(290,26,56,176.1,NULL,NULL,NULL,NULL),(291,26,82,187.3,NULL,NULL,NULL,NULL),(292,26,174,204.5,NULL,NULL,NULL,NULL),(293,26,272,213,NULL,NULL,NULL,NULL),(294,27,1,45,NULL,NULL,NULL,NULL),(295,27,3,52,NULL,NULL,NULL,NULL),(296,27,7,58.7,NULL,NULL,NULL,NULL),(297,27,14,64,NULL,NULL,NULL,NULL),(298,27,28,70.6,NULL,NULL,NULL,NULL),(299,27,55,77.7,NULL,NULL,NULL,NULL),(300,27,85,82.8,NULL,NULL,NULL,NULL),(301,27,180,89.2,NULL,NULL,NULL,NULL),(302,27,269,94.2,NULL,NULL,NULL,NULL),(303,27,375,97.6,NULL,NULL,NULL,NULL),(304,27,569,101,NULL,NULL,NULL,NULL),(305,27,767,104.7,NULL,NULL,NULL,NULL),(306,28,1,50,NULL,NULL,NULL,NULL),(307,28,3,58.8,NULL,NULL,NULL,NULL),(308,28,7,64.9,NULL,NULL,NULL,NULL),(309,28,14,70.1,NULL,NULL,NULL,NULL),(310,28,28,76.2,NULL,NULL,NULL,NULL),(311,28,55,83.2,NULL,NULL,NULL,NULL),(312,28,85,87.3,NULL,NULL,NULL,NULL),(313,28,180,94.2,NULL,NULL,NULL,NULL),(314,28,269,98.6,NULL,NULL,NULL,NULL),(315,28,375,100.7,NULL,NULL,NULL,NULL),(316,28,569,105.8,NULL,NULL,NULL,NULL),(317,28,767,109.5,NULL,NULL,NULL,NULL),(318,29,1,85.6,NULL,NULL,NULL,NULL),(319,29,3,99.9,NULL,NULL,NULL,NULL),(320,29,7,101.9,NULL,NULL,NULL,NULL),(321,29,14,116.2,NULL,NULL,NULL,NULL),(322,29,28,128.4,NULL,NULL,NULL,NULL),(323,29,56,146.8,NULL,NULL,NULL,NULL),(324,29,91,148.8,NULL,NULL,NULL,NULL),(325,29,120,159,NULL,NULL,NULL,NULL),(326,29,150,159,NULL,NULL,NULL,NULL),(327,29,180,161.1,NULL,NULL,NULL,NULL),(328,29,270,171.3,NULL,NULL,NULL,NULL),(329,29,360,175.3,NULL,NULL,NULL,NULL),(330,29,540,181.4,NULL,NULL,NULL,NULL),(331,29,720,177.4,NULL,NULL,NULL,NULL),(332,29,994,177.4,NULL,NULL,NULL,NULL),(333,29,1132,173.3,NULL,NULL,NULL,NULL),(334,29,1224,177.4,NULL,NULL,NULL,NULL),(335,30,1,64.9,NULL,NULL,NULL,NULL),(336,30,3,73.2,NULL,NULL,NULL,NULL),(337,30,7,80.6,NULL,NULL,NULL,NULL),(338,30,14,83.4,NULL,NULL,NULL,NULL),(339,30,28,93.6,NULL,NULL,NULL,NULL),(340,30,56,109.4,NULL,NULL,NULL,NULL),(341,30,90,120.5,NULL,NULL,NULL,NULL),(342,30,120,124.2,NULL,NULL,NULL,NULL),(343,30,150,128.8,NULL,NULL,NULL,NULL),(344,30,180,131.6,NULL,NULL,NULL,NULL),(345,30,271,138.1,NULL,NULL,NULL,NULL),(346,30,360,143.6,NULL,NULL,NULL,NULL),(347,30,516,146.4,NULL,NULL,NULL,NULL),(348,30,693,145.5,NULL,NULL,NULL,NULL),(349,30,969,152,NULL,NULL,NULL,NULL),(350,30,1105,154.8,NULL,NULL,NULL,NULL),(351,30,1585,153.8,NULL,NULL,NULL,NULL),(352,31,1,66.3,NULL,NULL,NULL,NULL),(353,31,4,75.7,NULL,NULL,NULL,NULL),(354,31,7,81.5,NULL,NULL,NULL,NULL),(355,31,14,89.6,NULL,NULL,NULL,NULL),(356,31,28,101.2,NULL,NULL,NULL,NULL),(357,31,56,110.7,NULL,NULL,NULL,NULL),(358,31,89,118,NULL,NULL,NULL,NULL),(359,31,151,129.6,NULL,NULL,NULL,NULL),(360,31,181,133.2,NULL,NULL,NULL,NULL),(361,31,270,139.8,NULL,NULL,NULL,NULL),(362,31,298,140.5,NULL,NULL,NULL,NULL),(363,31,360,143.4,NULL,NULL,NULL,NULL),(364,31,907,152.9,NULL,NULL,NULL,NULL),(365,31,1045,158,NULL,NULL,NULL,NULL),(366,31,1137,157.3,NULL,NULL,NULL,NULL),(367,32,1,63.7,NULL,NULL,NULL,NULL),(368,32,3,72.2,NULL,NULL,NULL,NULL),(369,32,7,81.5,NULL,NULL,NULL,NULL),(370,32,14,90,NULL,NULL,NULL,NULL),(371,32,28,101.1,NULL,NULL,NULL,NULL),(372,32,56,111.3,NULL,NULL,NULL,NULL),(373,32,90,113.8,NULL,NULL,NULL,NULL),(374,32,120,118.1,NULL,NULL,NULL,NULL),(375,32,150,121.5,NULL,NULL,NULL,NULL),(376,32,181,126.6,NULL,NULL,NULL,NULL),(377,32,270,135.1,NULL,NULL,NULL,NULL),(378,32,360,137.6,NULL,NULL,NULL,NULL),(379,32,540,142.7,NULL,NULL,NULL,NULL),(380,32,716,143.6,NULL,NULL,NULL,NULL),(381,32,990,146.1,NULL,NULL,NULL,NULL),(382,32,1131,147.8,NULL,NULL,NULL,NULL),(383,32,1306,152.9,NULL,NULL,NULL,NULL),(384,33,1,43.2,NULL,NULL,NULL,NULL),(385,33,3,50.4,NULL,NULL,NULL,NULL),(386,33,7,51.6,NULL,NULL,NULL,NULL),(387,33,14,57.6,NULL,NULL,NULL,NULL),(388,33,28,68.4,NULL,NULL,NULL,NULL),(389,33,56,74.4,NULL,NULL,NULL,NULL),(390,33,90,80.9,NULL,NULL,NULL,NULL),(391,33,120,85.7,NULL,NULL,NULL,NULL),(392,33,150,89.3,NULL,NULL,NULL,NULL),(393,33,181,94.1,NULL,NULL,NULL,NULL),(394,33,270,101.3,NULL,NULL,NULL,NULL),(395,33,492,109.7,NULL,NULL,NULL,NULL),(396,33,514,110.9,NULL,NULL,NULL,NULL),(397,33,689,109.7,NULL,NULL,NULL,NULL),(398,33,965,112.1,NULL,NULL,NULL,NULL),(399,33,1103,116.9,NULL,NULL,NULL,NULL),(400,33,1278,116.9,NULL,NULL,NULL,NULL),(401,34,1,46.5,NULL,NULL,NULL,NULL),(402,34,3,50.2,NULL,NULL,NULL,NULL),(403,34,5,53.8,NULL,NULL,NULL,NULL),(404,34,7,54.9,NULL,NULL,NULL,NULL),(405,34,14,60.1,NULL,NULL,NULL,NULL),(406,34,28,65.9,NULL,NULL,NULL,NULL),(407,34,56,73.7,NULL,NULL,NULL,NULL),(408,34,91,80.5,NULL,NULL,NULL,NULL),(409,34,101,82.1,NULL,NULL,NULL,NULL),(410,34,102,82.6,NULL,NULL,NULL,NULL),(411,34,104,83.6,NULL,NULL,NULL,NULL),(412,34,150,89.4,NULL,NULL,NULL,NULL),(413,34,179,93.6,NULL,NULL,NULL,NULL),(414,34,273,99.3,NULL,NULL,NULL,NULL),(415,34,360,100.9,NULL,NULL,NULL,NULL),(416,34,903,108.7,NULL,NULL,NULL,NULL),(417,34,1041,112.9,NULL,NULL,NULL,NULL),(418,34,1111,110.3,NULL,NULL,NULL,NULL),(419,35,1,41.4,NULL,NULL,NULL,NULL),(420,35,3,46.6,NULL,NULL,NULL,NULL),(421,35,7,48.9,NULL,NULL,NULL,NULL),(422,35,14,51.8,NULL,NULL,NULL,NULL),(423,35,28,57.1,NULL,NULL,NULL,NULL),(424,35,56,61.7,NULL,NULL,NULL,NULL),(425,35,90,65.8,NULL,NULL,NULL,NULL),(426,35,121,67.6,NULL,NULL,NULL,NULL),(427,35,150,71.1,NULL,NULL,NULL,NULL),(428,35,181,72.2,NULL,NULL,NULL,NULL),(429,35,270,74,NULL,NULL,NULL,NULL),(430,35,360,76.3,NULL,NULL,NULL,NULL),(431,35,540,78.1,NULL,NULL,NULL,NULL),(432,35,727,77.5,NULL,NULL,NULL,NULL),(433,35,941,81.5,NULL,NULL,NULL,NULL),(434,35,1078,82.1,NULL,NULL,NULL,NULL),(435,35,1253,83.9,NULL,NULL,NULL,NULL),(436,36,1,45,NULL,NULL,NULL,NULL),(437,36,3,48.6,NULL,NULL,NULL,NULL),(438,36,7,57,NULL,NULL,NULL,NULL),(439,36,14,60.5,NULL,NULL,NULL,NULL),(440,36,28,64.7,NULL,NULL,NULL,NULL),(441,36,56,71.8,NULL,NULL,NULL,NULL),(442,36,90,76,NULL,NULL,NULL,NULL),(443,36,120,79.5,NULL,NULL,NULL,NULL),(444,36,150,80.9,NULL,NULL,NULL,NULL),(445,36,181,84.4,NULL,NULL,NULL,NULL),(446,36,270,88,NULL,NULL,NULL,NULL),(447,36,360,89.4,NULL,NULL,NULL,NULL),(448,36,542,94.3,NULL,NULL,NULL,NULL),(449,36,734,92.2,NULL,NULL,NULL,NULL),(450,36,948,97.1,NULL,NULL,NULL,NULL),(451,36,1085,98.5,NULL,NULL,NULL,NULL),(452,36,1260,102,NULL,NULL,NULL,NULL),(453,37,1,79,NULL,NULL,NULL,NULL),(454,37,3,86.6,NULL,NULL,NULL,NULL),(455,37,7,95.6,NULL,NULL,NULL,NULL),(456,37,14,100.7,NULL,NULL,NULL,NULL),(457,37,28,112.1,NULL,NULL,NULL,NULL),(458,37,56,123.6,NULL,NULL,NULL,NULL),(459,37,90,135.1,NULL,NULL,NULL,NULL),(460,37,120,142.7,NULL,NULL,NULL,NULL),(461,37,153,151.6,NULL,NULL,NULL,NULL),(462,37,181,156.7,NULL,NULL,NULL,NULL),(463,37,268,165.6,NULL,NULL,NULL,NULL),(464,37,360,169.5,NULL,NULL,NULL,NULL),(465,37,548,180.9,NULL,NULL,NULL,NULL),(466,37,751,175.8,NULL,NULL,NULL,NULL),(467,37,966,187.3,NULL,NULL,NULL,NULL),(468,37,1092,186,NULL,NULL,NULL,NULL),(469,37,1168,186,NULL,NULL,NULL,NULL),(470,38,1,43.3,NULL,NULL,NULL,NULL),(471,38,2,48.3,NULL,NULL,NULL,NULL),(472,38,3,51.9,NULL,NULL,NULL,NULL),(473,38,4,54.9,NULL,NULL,NULL,NULL),(474,38,5,56.7,NULL,NULL,NULL,NULL),(475,38,6,58.6,NULL,NULL,NULL,NULL),(476,38,10,60.6,NULL,NULL,NULL,NULL),(477,38,15,61.3,NULL,NULL,NULL,NULL),(478,38,20,61.7,NULL,NULL,NULL,NULL),(479,38,25,62.2,NULL,NULL,NULL,NULL),(480,38,30,62.4,NULL,NULL,NULL,NULL),(481,38,35,62.6,NULL,NULL,NULL,NULL),(482,38,40,63.4,NULL,NULL,NULL,NULL),(483,38,45,63.5,NULL,NULL,NULL,NULL),(484,38,50,64.1,NULL,NULL,NULL,NULL),(485,38,55,64.5,NULL,NULL,NULL,NULL),(486,38,60,64.8,NULL,NULL,NULL,NULL),(487,39,1,51.2,NULL,NULL,NULL,NULL),(488,39,2,53.4,NULL,NULL,NULL,NULL),(489,39,3,55.6,NULL,NULL,NULL,NULL),(490,39,4,57.5,NULL,NULL,NULL,NULL),(491,39,5,58,NULL,NULL,NULL,NULL),(492,39,6,58.9,NULL,NULL,NULL,NULL),(493,39,10,60.6,NULL,NULL,NULL,NULL),(494,39,15,60.8,NULL,NULL,NULL,NULL),(495,39,20,60.8,NULL,NULL,NULL,NULL),(496,39,25,60.4,NULL,NULL,NULL,NULL),(497,39,30,60.4,NULL,NULL,NULL,NULL),(498,39,35,60.4,NULL,NULL,NULL,NULL),(499,39,40,60.6,NULL,NULL,NULL,NULL),(500,39,45,60.4,NULL,NULL,NULL,NULL),(501,39,50,60,NULL,NULL,NULL,NULL),(502,39,53,59.9,NULL,NULL,NULL,NULL),(503,40,1,67.4,NULL,NULL,NULL,NULL),(504,40,2,73.4,NULL,NULL,NULL,NULL),(505,40,3,75.2,NULL,NULL,NULL,NULL),(506,40,4,76.1,NULL,NULL,NULL,NULL),(507,40,5,75.7,NULL,NULL,NULL,NULL),(508,40,6,76.1,NULL,NULL,NULL,NULL),(509,40,10,77,NULL,NULL,NULL,NULL),(510,40,15,78.3,NULL,NULL,NULL,NULL),(511,40,20,78.8,NULL,NULL,NULL,NULL),(512,40,25,79.3,NULL,NULL,NULL,NULL),(513,40,30,80.1,NULL,NULL,NULL,NULL),(514,40,35,81,NULL,NULL,NULL,NULL),(515,40,40,81.9,NULL,NULL,NULL,NULL),(516,40,45,82.4,NULL,NULL,NULL,NULL),(517,40,50,83.3,NULL,NULL,NULL,NULL),(518,40,55,83.9,NULL,NULL,NULL,NULL),(519,40,60,84.8,NULL,NULL,NULL,NULL),(520,41,1,50.4,NULL,NULL,NULL,NULL),(521,41,2,57.6,NULL,NULL,NULL,NULL),(522,41,3,61.8,NULL,NULL,NULL,NULL),(523,41,4,66.7,NULL,NULL,NULL,NULL),(524,41,5,67.9,NULL,NULL,NULL,NULL),(525,41,6,68.1,NULL,NULL,NULL,NULL),(526,41,10,68.7,NULL,NULL,NULL,NULL),(527,41,15,68.8,NULL,NULL,NULL,NULL),(528,41,20,68.8,NULL,NULL,NULL,NULL),(529,41,25,68.8,NULL,NULL,NULL,NULL),(530,41,30,68.6,NULL,NULL,NULL,NULL),(531,41,35,68.6,NULL,NULL,NULL,NULL),(532,41,40,68.8,NULL,NULL,NULL,NULL),(533,42,1,46.1,NULL,NULL,NULL,NULL),(534,42,2,51.4,NULL,NULL,NULL,NULL),(535,42,3,54.5,NULL,NULL,NULL,NULL),(536,42,4,57.1,NULL,NULL,NULL,NULL),(537,42,5,57.9,NULL,NULL,NULL,NULL),(538,42,6,58.1,NULL,NULL,NULL,NULL),(539,42,10,58.5,NULL,NULL,NULL,NULL),(540,42,15,59.2,NULL,NULL,NULL,NULL),(541,42,20,59.8,NULL,NULL,NULL,NULL),(542,42,25,60.6,NULL,NULL,NULL,NULL),(543,42,30,60.8,NULL,NULL,NULL,NULL),(544,42,35,61,NULL,NULL,NULL,NULL),(545,42,40,61.5,NULL,NULL,NULL,NULL),(546,42,45,61.9,NULL,NULL,NULL,NULL),(547,42,50,62.7,NULL,NULL,NULL,NULL),(548,42,55,62.9,NULL,NULL,NULL,NULL),(549,42,60,63.6,NULL,NULL,NULL,NULL),(550,43,1,53.1,NULL,NULL,NULL,NULL),(551,43,2,55.2,NULL,NULL,NULL,NULL),(552,43,3,56.4,NULL,NULL,NULL,NULL),(553,43,4,57.3,NULL,NULL,NULL,NULL),(554,43,5,57.9,NULL,NULL,NULL,NULL),(555,43,6,58.1,NULL,NULL,NULL,NULL),(556,43,10,58.5,NULL,NULL,NULL,NULL),(557,43,15,58.1,NULL,NULL,NULL,NULL),(558,43,20,58.3,NULL,NULL,NULL,NULL),(559,43,25,58.7,NULL,NULL,NULL,NULL),(560,43,30,58.8,NULL,NULL,NULL,NULL),(561,43,35,58.9,NULL,NULL,NULL,NULL),(562,43,40,58.9,NULL,NULL,NULL,NULL),(563,43,45,58.9,NULL,NULL,NULL,NULL),(564,43,50,58.9,NULL,NULL,NULL,NULL),(565,43,54,59,NULL,NULL,NULL,NULL),(566,44,1,53.3,NULL,NULL,NULL,NULL),(567,44,2,55,NULL,NULL,NULL,NULL),(568,44,3,55.7,NULL,NULL,NULL,NULL),(569,44,4,56.7,NULL,NULL,NULL,NULL),(570,44,5,57,NULL,NULL,NULL,NULL),(571,44,6,57.7,NULL,NULL,NULL,NULL),(572,44,10,58.4,NULL,NULL,NULL,NULL),(573,44,15,59.6,NULL,NULL,NULL,NULL),(574,44,20,60.5,NULL,NULL,NULL,NULL),(575,44,25,61.9,NULL,NULL,NULL,NULL),(576,44,30,62.7,NULL,NULL,NULL,NULL),(577,44,35,63.7,NULL,NULL,NULL,NULL),(578,44,40,65.1,NULL,NULL,NULL,NULL),(579,44,45,66,NULL,NULL,NULL,NULL),(580,44,50,67,NULL,NULL,NULL,NULL),(581,44,55,67.9,NULL,NULL,NULL,NULL),(582,44,60,68.2,NULL,NULL,NULL,NULL),(583,45,1,55.3,NULL,NULL,NULL,NULL),(584,45,2,66.2,NULL,NULL,NULL,NULL),(585,45,3,67.7,NULL,NULL,NULL,NULL),(586,45,4,68.7,NULL,NULL,NULL,NULL),(587,45,5,68.7,NULL,NULL,NULL,NULL),(588,45,6,68.7,NULL,NULL,NULL,NULL),(589,45,10,68.7,NULL,NULL,NULL,NULL),(590,45,15,68.7,NULL,NULL,NULL,NULL),(591,45,20,68.7,NULL,NULL,NULL,NULL),(592,45,25,69.1,NULL,NULL,NULL,NULL),(593,45,30,69.1,NULL,NULL,NULL,NULL),(594,45,35,69.1,NULL,NULL,NULL,NULL),(595,45,40,69.1,NULL,NULL,NULL,NULL),(596,45,45,69.1,NULL,NULL,NULL,NULL),(597,45,50,69.1,NULL,NULL,NULL,NULL),(598,45,54,69.1,NULL,NULL,NULL,NULL),(599,46,1,49.7,NULL,NULL,NULL,NULL),(600,46,2,51.9,NULL,NULL,NULL,NULL),(601,46,3,54.3,NULL,NULL,NULL,NULL),(602,46,4,56,NULL,NULL,NULL,NULL),(603,46,5,57.1,NULL,NULL,NULL,NULL),(604,46,6,57.8,NULL,NULL,NULL,NULL),(605,46,10,59.3,NULL,NULL,NULL,NULL),(606,46,15,59.9,NULL,NULL,NULL,NULL),(607,46,20,60.4,NULL,NULL,NULL,NULL),(608,46,25,60,NULL,NULL,NULL,NULL),(609,46,30,60.8,NULL,NULL,NULL,NULL),(610,46,35,60.9,NULL,NULL,NULL,NULL),(611,46,40,61,NULL,NULL,NULL,NULL),(612,46,45,61,NULL,NULL,NULL,NULL),(613,46,50,61.1,NULL,NULL,NULL,NULL),(614,46,55,61.7,NULL,NULL,NULL,NULL),(615,46,60,61.9,NULL,NULL,NULL,NULL),(616,47,1,48.8,NULL,NULL,NULL,NULL),(617,47,2,55.2,NULL,NULL,NULL,NULL),(618,47,3,59.9,NULL,NULL,NULL,NULL),(619,47,4,62.2,NULL,NULL,NULL,NULL),(620,47,5,65.4,NULL,NULL,NULL,NULL),(621,47,6,66.5,NULL,NULL,NULL,NULL),(622,47,10,69.1,NULL,NULL,NULL,NULL),(623,47,15,69.1,NULL,NULL,NULL,NULL),(624,47,20,69.1,NULL,NULL,NULL,NULL),(625,47,25,69.1,NULL,NULL,NULL,NULL),(626,47,30,69.1,NULL,NULL,NULL,NULL),(627,47,35,69.1,NULL,NULL,NULL,NULL),(628,47,40,69.1,NULL,NULL,NULL,NULL),(629,47,45,69.1,NULL,NULL,NULL,NULL),(630,47,50,69.1,NULL,NULL,NULL,NULL),(631,47,55,69.1,NULL,NULL,NULL,NULL),(632,47,60,69.1,NULL,NULL,NULL,NULL),(633,48,1,48.8,NULL,NULL,NULL,NULL),(634,48,2,52.2,NULL,NULL,NULL,NULL),(635,48,3,54.7,NULL,NULL,NULL,NULL),(636,48,4,56.9,NULL,NULL,NULL,NULL),(637,48,5,58.1,NULL,NULL,NULL,NULL),(638,48,6,58.9,NULL,NULL,NULL,NULL),(639,48,10,59.8,NULL,NULL,NULL,NULL),(640,48,15,60.6,NULL,NULL,NULL,NULL),(641,48,20,60.9,NULL,NULL,NULL,NULL),(642,48,25,61.6,NULL,NULL,NULL,NULL),(643,48,30,62,NULL,NULL,NULL,NULL),(644,48,35,63.1,NULL,NULL,NULL,NULL),(645,48,40,63.1,NULL,NULL,NULL,NULL),(646,48,45,63.1,NULL,NULL,NULL,NULL),(647,48,50,64,NULL,NULL,NULL,NULL),(648,48,55,64.3,NULL,NULL,NULL,NULL),(649,48,60,64.8,NULL,NULL,NULL,NULL),(650,49,1,49.7,NULL,NULL,NULL,NULL),(651,49,2,58.1,NULL,NULL,NULL,NULL),(652,49,3,62.3,NULL,NULL,NULL,NULL),(653,49,4,65.5,NULL,NULL,NULL,NULL),(654,49,5,68.2,NULL,NULL,NULL,NULL),(655,49,6,69.9,NULL,NULL,NULL,NULL),(656,49,10,74.9,NULL,NULL,NULL,NULL),(657,49,15,75.6,NULL,NULL,NULL,NULL),(658,49,20,75.8,NULL,NULL,NULL,NULL),(659,49,25,75.9,NULL,NULL,NULL,NULL),(660,49,30,75.9,NULL,NULL,NULL,NULL),(661,49,35,76.1,NULL,NULL,NULL,NULL),(662,49,40,76.6,NULL,NULL,NULL,NULL),(663,49,45,76.7,NULL,NULL,NULL,NULL),(664,49,50,76.8,NULL,NULL,NULL,NULL),(665,49,55,76.8,NULL,NULL,NULL,NULL),(666,49,60,76.8,NULL,NULL,NULL,NULL),(667,50,0.0599194,51,NULL,NULL,NULL,NULL),(668,50,1,69.7,NULL,NULL,NULL,NULL),(669,50,2,74.9,NULL,NULL,NULL,NULL),(670,50,3,77,NULL,NULL,NULL,NULL),(671,50,4,81.1,NULL,NULL,NULL,NULL),(672,50,6,84.4,NULL,NULL,NULL,NULL),(673,50,8,86.3,NULL,NULL,NULL,NULL),(674,50,12,90.5,NULL,NULL,NULL,NULL),(675,50,15,91.5,NULL,NULL,NULL,NULL),(676,50,22,97.8,NULL,NULL,NULL,NULL),(677,50,28,98.8,NULL,NULL,NULL,NULL),(678,50,33,104,NULL,NULL,NULL,NULL),(679,50,36,104,NULL,NULL,NULL,NULL),(680,50,44,107.1,NULL,NULL,NULL,NULL),(681,50,62,112.3,NULL,NULL,NULL,NULL),(682,50,68,115.5,NULL,NULL,NULL,NULL),(683,50,81,118.6,NULL,NULL,NULL,NULL),(684,50,98,120.7,NULL,NULL,NULL,NULL),(685,50,109,123.8,NULL,NULL,NULL,NULL),(686,50,134,126.9,NULL,NULL,NULL,NULL),(687,50,141,130,NULL,NULL,NULL,NULL),(688,50,155,131.1,NULL,NULL,NULL,NULL),(689,50,183,133.1,NULL,NULL,NULL,NULL),(690,50,197,134.2,NULL,NULL,NULL,NULL),(691,50,231,138.3,NULL,NULL,NULL,NULL),(692,50,270,139.4,NULL,NULL,NULL,NULL),(693,50,294,140.4,NULL,NULL,NULL,NULL),(694,50,323,141.5,NULL,NULL,NULL,NULL),(695,50,342,142.5,NULL,NULL,NULL,NULL),(696,50,361,144.6,NULL,NULL,NULL,NULL),(697,51,0.214587,31.2,NULL,NULL,NULL,NULL),(698,51,1,38.5,NULL,NULL,NULL,NULL),(699,51,2,43.7,NULL,NULL,NULL,NULL),(700,51,3,44.7,NULL,NULL,NULL,NULL),(701,51,4,46.8,NULL,NULL,NULL,NULL),(702,51,7,51,NULL,NULL,NULL,NULL),(703,51,9,52,NULL,NULL,NULL,NULL),(704,51,15,57.2,NULL,NULL,NULL,NULL),(705,51,22,60.3,NULL,NULL,NULL,NULL),(706,51,25,60.3,NULL,NULL,NULL,NULL),(707,51,29,62.4,NULL,NULL,NULL,NULL),(708,51,35,63.5,NULL,NULL,NULL,NULL),(709,51,39,65.5,NULL,NULL,NULL,NULL),(710,51,45,64.5,NULL,NULL,NULL,NULL),(711,51,51,68.7,NULL,NULL,NULL,NULL),(712,51,56,70.7,NULL,NULL,NULL,NULL),(713,51,73,74.9,NULL,NULL,NULL,NULL),(714,51,79,75.9,NULL,NULL,NULL,NULL),(715,51,95,77,NULL,NULL,NULL,NULL),(716,51,109,81.1,NULL,NULL,NULL,NULL),(717,51,123,83.2,NULL,NULL,NULL,NULL),(718,51,141,84.3,NULL,NULL,NULL,NULL),(719,51,144,85.3,NULL,NULL,NULL,NULL),(720,51,157,88.4,NULL,NULL,NULL,NULL),(721,51,165,87.4,NULL,NULL,NULL,NULL),(722,51,184,90.5,NULL,NULL,NULL,NULL),(723,51,217,89.5,NULL,NULL,NULL,NULL),(724,51,270,91.5,NULL,NULL,NULL,NULL),(725,51,289,91.5,NULL,NULL,NULL,NULL),(726,51,309,93.6,NULL,NULL,NULL,NULL),(727,52,0.190425,42.6,NULL,NULL,NULL,NULL),(728,52,1,56.2,NULL,NULL,NULL,NULL),(729,52,2,64.5,NULL,NULL,NULL,NULL),(730,52,3,66.6,NULL,NULL,NULL,NULL),(731,52,7,72.8,NULL,NULL,NULL,NULL),(732,52,10,77,NULL,NULL,NULL,NULL),(733,52,14,81.1,NULL,NULL,NULL,NULL),(734,52,17,83.2,NULL,NULL,NULL,NULL),(735,52,20,86.3,NULL,NULL,NULL,NULL),(736,52,27,87.4,NULL,NULL,NULL,NULL),(737,52,31,89.5,NULL,NULL,NULL,NULL),(738,52,36,92.6,NULL,NULL,NULL,NULL),(739,52,43,95.7,NULL,NULL,NULL,NULL),(740,52,58,100.9,NULL,NULL,NULL,NULL),(741,52,66,103,NULL,NULL,NULL,NULL),(742,52,73,106.1,NULL,NULL,NULL,NULL),(743,52,80,107.1,NULL,NULL,NULL,NULL),(744,52,101,111.3,NULL,NULL,NULL,NULL),(745,52,120,114.4,NULL,NULL,NULL,NULL),(746,52,129,116.5,NULL,NULL,NULL,NULL),(747,52,163,118.6,NULL,NULL,NULL,NULL),(748,52,177,120.7,NULL,NULL,NULL,NULL),(749,52,255,123.8,NULL,NULL,NULL,NULL),(750,52,275,124.8,NULL,NULL,NULL,NULL),(751,52,308,125.9,NULL,NULL,NULL,NULL),(752,52,348,129,NULL,NULL,NULL,NULL),(753,52,391,129,NULL,NULL,NULL,NULL),(754,52,455,131.1,NULL,NULL,NULL,NULL),(755,52,534,132.1,NULL,NULL,NULL,NULL),(756,52,572,131.1,NULL,NULL,NULL,NULL),(757,53,0.0567541,61.4,NULL,NULL,NULL,NULL),(758,53,1,83.2,NULL,NULL,NULL,NULL),(759,53,2,86.3,NULL,NULL,NULL,NULL),(760,53,7,96.7,NULL,NULL,NULL,NULL),(761,53,9,98.8,NULL,NULL,NULL,NULL),(762,53,14,104,NULL,NULL,NULL,NULL),(763,53,17,105.1,NULL,NULL,NULL,NULL),(764,53,21,107.1,NULL,NULL,NULL,NULL),(765,53,27,110.3,NULL,NULL,NULL,NULL),(766,53,31,111.3,NULL,NULL,NULL,NULL),(767,53,43,116.5,NULL,NULL,NULL,NULL),(768,53,48,119.6,NULL,NULL,NULL,NULL),(769,53,65,124.8,NULL,NULL,NULL,NULL),(770,53,77,125.9,NULL,NULL,NULL,NULL),(771,53,83,127.9,NULL,NULL,NULL,NULL),(772,53,94,127.9,NULL,NULL,NULL,NULL),(773,53,104,131.1,NULL,NULL,NULL,NULL),(774,53,122,133.1,NULL,NULL,NULL,NULL),(775,53,136,134.2,NULL,NULL,NULL,NULL),(776,53,155,137.3,NULL,NULL,NULL,NULL),(777,53,176,138.3,NULL,NULL,NULL,NULL),(778,53,209,139.4,NULL,NULL,NULL,NULL),(779,53,262,141.5,NULL,NULL,NULL,NULL),(780,53,282,143.5,NULL,NULL,NULL,NULL),(781,53,315,145.6,NULL,NULL,NULL,NULL),(782,53,357,148.7,NULL,NULL,NULL,NULL),(783,53,399,148.7,NULL,NULL,NULL,NULL),(784,53,464,149.8,NULL,NULL,NULL,NULL),(785,53,547,151.9,NULL,NULL,NULL,NULL),(786,53,580,151.9,NULL,NULL,NULL,NULL),(787,54,0.0178853,53,NULL,NULL,NULL,NULL),(788,54,0.2,62.4,NULL,NULL,NULL,NULL),(789,54,1,69.7,NULL,NULL,NULL,NULL),(790,54,2,72.8,NULL,NULL,NULL,NULL),(791,54,3,75,NULL,NULL,NULL,NULL),(792,54,6,80.1,NULL,NULL,NULL,NULL),(793,54,9,84.3,NULL,NULL,NULL,NULL),(794,54,12,86.3,NULL,NULL,NULL,NULL),(795,54,16,87.4,NULL,NULL,NULL,NULL),(796,54,23,93.6,NULL,NULL,NULL,NULL),(797,54,33,97.8,NULL,NULL,NULL,NULL),(798,54,44,101.9,NULL,NULL,NULL,NULL),(799,54,51,103,NULL,NULL,NULL,NULL),(800,54,62,106.1,NULL,NULL,NULL,NULL),(801,54,65,107.1,NULL,NULL,NULL,NULL),(802,54,75,111.3,NULL,NULL,NULL,NULL),(803,54,86,113.4,NULL,NULL,NULL,NULL),(804,54,99,114.4,NULL,NULL,NULL,NULL),(805,54,113,117.5,NULL,NULL,NULL,NULL),(806,54,138,118.6,NULL,NULL,NULL,NULL),(807,54,162,120.7,NULL,NULL,NULL,NULL),(808,54,177,121.7,NULL,NULL,NULL,NULL),(809,54,191,122.7,NULL,NULL,NULL,NULL),(810,54,211,123.8,NULL,NULL,NULL,NULL),(811,54,244,126.9,NULL,NULL,NULL,NULL),(812,54,286,132.1,NULL,NULL,NULL,NULL),(813,54,328,131.1,NULL,NULL,NULL,NULL),(814,54,392,133.1,NULL,NULL,NULL,NULL),(815,54,477,135.2,NULL,NULL,NULL,NULL),(816,54,509,136.3,NULL,NULL,NULL,NULL),(817,55,0.234152,31.2,NULL,NULL,NULL,NULL),(818,55,1,39.5,NULL,NULL,NULL,NULL),(819,55,2,44.7,NULL,NULL,NULL,NULL),(820,55,4,48.9,NULL,NULL,NULL,NULL),(821,55,7,52,NULL,NULL,NULL,NULL),(822,55,11,53,NULL,NULL,NULL,NULL),(823,55,14,56.2,NULL,NULL,NULL,NULL),(824,55,18,58.2,NULL,NULL,NULL,NULL),(825,55,25,62.4,NULL,NULL,NULL,NULL),(826,55,32,62.4,NULL,NULL,NULL,NULL),(827,55,43,66.6,NULL,NULL,NULL,NULL),(828,55,46,66.6,NULL,NULL,NULL,NULL),(829,55,56,69.7,NULL,NULL,NULL,NULL),(830,55,64,69.7,NULL,NULL,NULL,NULL),(831,55,71,71.8,NULL,NULL,NULL,NULL),(832,55,80,73.9,NULL,NULL,NULL,NULL),(833,55,88,72.8,NULL,NULL,NULL,NULL),(834,55,119,76.8,NULL,NULL,NULL,NULL),(835,55,142,78,NULL,NULL,NULL,NULL),(836,55,158,78,NULL,NULL,NULL,NULL),(837,55,172,80.1,NULL,NULL,NULL,NULL),(838,55,192,81.1,NULL,NULL,NULL,NULL),(839,55,225,82.2,NULL,NULL,NULL,NULL),(840,55,267,86.3,NULL,NULL,NULL,NULL),(841,55,309,86.3,NULL,NULL,NULL,NULL),(842,55,373,88.4,NULL,NULL,NULL,NULL),(843,55,458,88.4,NULL,NULL,NULL,NULL),(844,55,595,89.5,NULL,NULL,NULL,NULL),(845,56,0.012,47.6,NULL,NULL,NULL,NULL),(846,56,1,66,NULL,NULL,NULL,NULL),(847,56,7,76,NULL,NULL,NULL,NULL),(848,56,28,86,NULL,NULL,NULL,NULL),(849,56,91,96,NULL,NULL,NULL,NULL),(850,56,175,102,NULL,NULL,NULL,NULL),(851,56,365,105,NULL,NULL,NULL,NULL),(852,56,897,107,NULL,NULL,NULL,NULL),(853,57,0.063,47.6,NULL,NULL,NULL,NULL),(854,57,1,66,NULL,NULL,NULL,NULL),(855,57,7,82,NULL,NULL,NULL,NULL),(856,57,28,96,NULL,NULL,NULL,NULL),(857,57,91,108,NULL,NULL,NULL,NULL),(858,57,175,113,NULL,NULL,NULL,NULL),(859,57,365,117,NULL,NULL,NULL,NULL),(860,57,897,120,NULL,NULL,NULL,NULL),(861,58,0.1,47.6,NULL,NULL,NULL,NULL),(862,58,1,67,NULL,NULL,NULL,NULL),(863,58,7,86,NULL,NULL,NULL,NULL),(864,58,28,104,NULL,NULL,NULL,NULL),(865,58,91,120,NULL,NULL,NULL,NULL),(866,58,175,128,NULL,NULL,NULL,NULL),(867,58,365,136,NULL,NULL,NULL,NULL),(868,58,897,141,NULL,NULL,NULL,NULL),(869,59,0.057,47.6,NULL,NULL,NULL,NULL),(870,59,1,73,NULL,NULL,NULL,NULL),(871,59,7,91,NULL,NULL,NULL,NULL),(872,59,28,112,NULL,NULL,NULL,NULL),(873,59,91,132,NULL,NULL,NULL,NULL),(874,59,175,140,NULL,NULL,NULL,NULL),(875,59,365,145,NULL,NULL,NULL,NULL),(876,59,897,150,NULL,NULL,NULL,NULL),(877,60,0.06,47.6,NULL,NULL,NULL,NULL),(878,60,1,64,NULL,NULL,NULL,NULL),(879,60,7,77,NULL,NULL,NULL,NULL),(880,60,28,90,NULL,NULL,NULL,NULL),(881,60,91,105,NULL,NULL,NULL,NULL),(882,60,175,112,NULL,NULL,NULL,NULL),(883,60,365,115,NULL,NULL,NULL,NULL),(884,60,897,118,NULL,NULL,NULL,NULL),(885,61,0.1,47.6,NULL,NULL,NULL,NULL),(886,61,1,63,NULL,NULL,NULL,NULL),(887,61,7,79,NULL,NULL,NULL,NULL),(888,61,28,93,NULL,NULL,NULL,NULL),(889,61,91,105,NULL,NULL,NULL,NULL),(890,61,175,112,NULL,NULL,NULL,NULL),(891,61,365,118,NULL,NULL,NULL,NULL),(892,61,897,121,NULL,NULL,NULL,NULL),(893,62,0.18,47.6,NULL,NULL,NULL,NULL),(894,62,1,63,NULL,NULL,NULL,NULL),(895,62,7,81,NULL,NULL,NULL,NULL),(896,62,28,100,NULL,NULL,NULL,NULL),(897,62,91,118,NULL,NULL,NULL,NULL),(898,62,175,126,NULL,NULL,NULL,NULL),(899,62,365,137,NULL,NULL,NULL,NULL),(900,62,897,138,NULL,NULL,NULL,NULL),(901,63,0.21,47.6,NULL,NULL,NULL,NULL),(902,63,1,63,NULL,NULL,NULL,NULL),(903,63,7,85,NULL,NULL,NULL,NULL),(904,63,28,105,NULL,NULL,NULL,NULL),(905,63,91,124,NULL,NULL,NULL,NULL),(906,63,175,135,NULL,NULL,NULL,NULL),(907,63,365,143,NULL,NULL,NULL,NULL),(908,63,897,146,NULL,NULL,NULL,NULL),(909,64,1,67,NULL,NULL,NULL,NULL),(910,64,7,85,NULL,NULL,NULL,NULL),(911,64,14,90,NULL,NULL,NULL,NULL),(912,64,21,93,NULL,NULL,NULL,NULL),(913,64,28,93,NULL,NULL,NULL,NULL),(914,64,43,96,NULL,NULL,NULL,NULL),(915,64,56,107,NULL,NULL,NULL,NULL),(916,64,70,106,NULL,NULL,NULL,NULL),(917,64,90,114,NULL,NULL,NULL,NULL),(918,64,117,117,NULL,NULL,NULL,NULL),(919,64,150,120,NULL,NULL,NULL,NULL),(920,64,178,122,NULL,NULL,NULL,NULL),(921,64,211,122,NULL,NULL,NULL,NULL),(922,64,243,127,NULL,NULL,NULL,NULL),(923,64,348,131,NULL,NULL,NULL,NULL),(924,64,422,136,NULL,NULL,NULL,NULL),(925,64,540,129,NULL,NULL,NULL,NULL),(926,64,790,143,NULL,NULL,NULL,NULL),(927,64,1000,144,NULL,NULL,NULL,NULL),(928,64,1090,140,NULL,NULL,NULL,NULL),(929,64,1250,144,NULL,NULL,NULL,NULL),(930,64,1350,144,NULL,NULL,NULL,NULL),(931,64,1550,144,NULL,NULL,NULL,NULL),(932,64,1750,148,NULL,NULL,NULL,NULL),(933,64,2050,160,NULL,NULL,NULL,NULL),(934,65,1,42,NULL,NULL,NULL,NULL),(935,65,28,71,NULL,NULL,NULL,NULL),(936,65,90,85,NULL,NULL,NULL,NULL),(937,65,475,104,NULL,NULL,NULL,NULL),(938,66,1,45,NULL,NULL,NULL,NULL),(939,66,30,53,NULL,NULL,NULL,NULL),(940,66,90,68,NULL,NULL,NULL,NULL),(941,66,180,83,NULL,NULL,NULL,NULL),(942,66,320,90,NULL,NULL,NULL,NULL),(943,66,348,87,NULL,NULL,NULL,NULL),(944,66,520,104,NULL,NULL,NULL,NULL),(945,66,592,98,NULL,NULL,NULL,NULL),(946,66,630,105,NULL,NULL,NULL,NULL),(947,66,740,105,NULL,NULL,NULL,NULL),(948,66,880,108,NULL,NULL,NULL,NULL),(949,66,980,108,NULL,NULL,NULL,NULL),(950,66,1260,110,NULL,NULL,NULL,NULL),(951,66,1540,114,NULL,NULL,NULL,NULL),(952,66,1760,114,NULL,NULL,NULL,NULL),(953,66,2050,117,NULL,NULL,NULL,NULL),(954,67,1,37,NULL,NULL,NULL,NULL),(955,67,21,38,NULL,NULL,NULL,NULL),(956,67,210,45,NULL,NULL,NULL,NULL),(957,67,307,53,NULL,NULL,NULL,NULL),(958,67,365,55,NULL,NULL,NULL,NULL),(959,67,635,53,NULL,NULL,NULL,NULL),(960,67,695,56,NULL,NULL,NULL,NULL),(961,67,960,68,NULL,NULL,NULL,NULL),(962,67,1140,65,NULL,NULL,NULL,NULL),(963,67,1230,69,NULL,NULL,NULL,NULL),(964,67,1420,68,NULL,NULL,NULL,NULL),(965,67,1765,71,NULL,NULL,NULL,NULL),(966,68,1,67,NULL,NULL,NULL,NULL),(967,68,7,90,NULL,NULL,NULL,NULL),(968,68,14,101,NULL,NULL,NULL,NULL),(969,68,21,107,NULL,NULL,NULL,NULL),(970,68,28,109,NULL,NULL,NULL,NULL),(971,68,43,117,NULL,NULL,NULL,NULL),(972,68,56,123,NULL,NULL,NULL,NULL),(973,68,70,125,NULL,NULL,NULL,NULL),(974,68,90,128,NULL,NULL,NULL,NULL),(975,68,117,134,NULL,NULL,NULL,NULL),(976,68,150,138,NULL,NULL,NULL,NULL),(977,68,178,139,NULL,NULL,NULL,NULL),(978,68,211,141,NULL,NULL,NULL,NULL),(979,68,243,145,NULL,NULL,NULL,NULL),(980,68,348,148,NULL,NULL,NULL,NULL),(981,68,422,151,NULL,NULL,NULL,NULL),(982,68,540,155,NULL,NULL,NULL,NULL),(983,68,790,160,NULL,NULL,NULL,NULL),(984,68,1000,157,NULL,NULL,NULL,NULL),(985,68,1090,157,NULL,NULL,NULL,NULL),(986,68,1250,169,NULL,NULL,NULL,NULL),(987,68,1350,169,NULL,NULL,NULL,NULL),(988,68,1550,172,NULL,NULL,NULL,NULL),(989,68,1750,183,NULL,NULL,NULL,NULL),(990,68,2050,183,NULL,NULL,NULL,NULL),(991,69,1,44,NULL,NULL,NULL,NULL),(992,69,3,46,NULL,NULL,NULL,NULL),(993,69,4,54,NULL,NULL,NULL,NULL),(994,69,7,59,NULL,NULL,NULL,NULL),(995,69,23,71,NULL,NULL,NULL,NULL),(996,69,28,73,NULL,NULL,NULL,NULL),(997,69,90,87,NULL,NULL,NULL,NULL),(998,69,95,85,NULL,NULL,NULL,NULL),(999,69,183,88,NULL,NULL,NULL,NULL),(1000,69,331,98,NULL,NULL,NULL,NULL),(1001,69,475,109,NULL,NULL,NULL,NULL),(1002,69,517,105,NULL,NULL,NULL,NULL),(1003,69,549,108,NULL,NULL,NULL,NULL),(1004,69,713,111,NULL,NULL,NULL,NULL),(1005,69,920,113,NULL,NULL,NULL,NULL),(1006,69,1040,114,NULL,NULL,NULL,NULL),(1007,69,1170,113,NULL,NULL,NULL,NULL),(1008,69,1320,114,NULL,NULL,NULL,NULL),(1009,69,1650,118,NULL,NULL,NULL,NULL),(1010,69,1980,123,NULL,NULL,NULL,NULL),(1011,70,1,56,NULL,NULL,NULL,NULL),(1012,70,7,67,NULL,NULL,NULL,NULL),(1013,70,11,70,NULL,NULL,NULL,NULL),(1014,70,15,75,NULL,NULL,NULL,NULL),(1015,70,28,85,NULL,NULL,NULL,NULL),(1016,70,41,88,NULL,NULL,NULL,NULL),(1017,70,57,91,NULL,NULL,NULL,NULL),(1018,70,77,97,NULL,NULL,NULL,NULL),(1019,70,91,102,NULL,NULL,NULL,NULL),(1020,70,159,110,NULL,NULL,NULL,NULL),(1021,70,185,112,NULL,NULL,NULL,NULL),(1022,70,271,112,NULL,NULL,NULL,NULL),(1023,70,394,124,NULL,NULL,NULL,NULL),(1024,70,576,129,NULL,NULL,NULL,NULL),(1025,71,1,44,NULL,NULL,NULL,NULL),(1026,71,30,58,NULL,NULL,NULL,NULL),(1027,71,90,69,NULL,NULL,NULL,NULL),(1028,71,180,77,NULL,NULL,NULL,NULL),(1029,71,320,84,NULL,NULL,NULL,NULL),(1030,71,348,87,NULL,NULL,NULL,NULL),(1031,71,520,92,NULL,NULL,NULL,NULL),(1032,71,592,94,NULL,NULL,NULL,NULL),(1033,71,630,93,NULL,NULL,NULL,NULL),(1034,71,740,96,NULL,NULL,NULL,NULL),(1035,71,880,98,NULL,NULL,NULL,NULL),(1036,71,980,97,NULL,NULL,NULL,NULL),(1037,71,1285,100,NULL,NULL,NULL,NULL),(1038,71,1540,103,NULL,NULL,NULL,NULL),(1039,71,1800,104,NULL,NULL,NULL,NULL),(1040,71,2050,111,NULL,NULL,NULL,NULL),(1041,72,1,38,NULL,NULL,NULL,NULL),(1042,72,21,41,NULL,NULL,NULL,NULL),(1043,72,210,54,NULL,NULL,NULL,NULL),(1044,72,307,56,NULL,NULL,NULL,NULL),(1045,72,365,59,NULL,NULL,NULL,NULL),(1046,72,635,62,NULL,NULL,NULL,NULL),(1047,72,695,63,NULL,NULL,NULL,NULL),(1048,72,960,67,NULL,NULL,NULL,NULL),(1049,72,1140,68,NULL,NULL,NULL,NULL),(1050,72,1230,69,NULL,NULL,NULL,NULL),(1051,72,1420,71,NULL,NULL,NULL,NULL),(1052,72,1765,77,NULL,NULL,NULL,NULL),(1053,73,28,33,NULL,NULL,NULL,NULL),(1054,73,80,39,NULL,NULL,NULL,NULL),(1055,73,126,46,NULL,NULL,NULL,NULL),(1056,73,227,47,NULL,NULL,NULL,NULL),(1057,73,300,50,NULL,NULL,NULL,NULL),(1058,73,560,55,NULL,NULL,NULL,NULL),(1059,73,680,54,NULL,NULL,NULL,NULL),(1060,73,855,55,NULL,NULL,NULL,NULL),(1061,73,1160,56,NULL,NULL,NULL,NULL),(1062,73,1420,70,NULL,NULL,NULL,NULL),(1063,74,1,39,NULL,NULL,NULL,NULL),(1064,74,7,50,NULL,NULL,NULL,NULL),(1065,74,14,52,NULL,NULL,NULL,NULL),(1066,74,21,52,NULL,NULL,NULL,NULL),(1067,74,28,54,NULL,NULL,NULL,NULL),(1068,74,43,63,NULL,NULL,NULL,NULL),(1069,74,56,60,NULL,NULL,NULL,NULL),(1070,74,70,61,NULL,NULL,NULL,NULL),(1071,74,90,59,NULL,NULL,NULL,NULL),(1072,74,117,66,NULL,NULL,NULL,NULL),(1073,74,150,64,NULL,NULL,NULL,NULL),(1074,74,180,63,NULL,NULL,NULL,NULL),(1075,74,211,61,NULL,NULL,NULL,NULL),(1076,74,243,57,NULL,NULL,NULL,NULL),(1077,74,348,61,NULL,NULL,NULL,NULL),(1078,74,422,66,NULL,NULL,NULL,NULL),(1079,74,540,62,NULL,NULL,NULL,NULL),(1080,74,645,72,NULL,NULL,NULL,NULL),(1081,74,790,68,NULL,NULL,NULL,NULL),(1082,74,1065,71,NULL,NULL,NULL,NULL),(1083,74,1205,64,NULL,NULL,NULL,NULL),(1084,74,1720,76,NULL,NULL,NULL,NULL),(1085,74,2070,82,NULL,NULL,NULL,NULL),(1086,75,1,30,NULL,NULL,NULL,NULL),(1087,75,28,41,NULL,NULL,NULL,NULL),(1088,75,90,47,NULL,NULL,NULL,NULL),(1089,75,475,54,NULL,NULL,NULL,NULL),(1090,76,1,28,NULL,NULL,NULL,NULL),(1091,76,7,30,NULL,NULL,NULL,NULL),(1092,76,11,35,NULL,NULL,NULL,NULL),(1093,76,15,29,NULL,NULL,NULL,NULL),(1094,76,28,38,NULL,NULL,NULL,NULL),(1095,76,41,43,NULL,NULL,NULL,NULL),(1096,76,57,43,NULL,NULL,NULL,NULL),(1097,76,77,46,NULL,NULL,NULL,NULL),(1098,76,91,41,NULL,NULL,NULL,NULL),(1099,76,159,47,NULL,NULL,NULL,NULL),(1100,76,185,48,NULL,NULL,NULL,NULL),(1101,76,271,49,NULL,NULL,NULL,NULL),(1102,76,394,47,NULL,NULL,NULL,NULL),(1103,76,576,50,NULL,NULL,NULL,NULL),(1104,77,1,27,NULL,NULL,NULL,NULL),(1105,77,21,28,NULL,NULL,NULL,NULL),(1106,77,28,32,NULL,NULL,NULL,NULL),(1107,77,120,33,NULL,NULL,NULL,NULL),(1108,77,220,32,NULL,NULL,NULL,NULL),(1109,77,307,37,NULL,NULL,NULL,NULL),(1110,77,365,37,NULL,NULL,NULL,NULL),(1111,77,490,41,NULL,NULL,NULL,NULL),(1112,77,605,48,NULL,NULL,NULL,NULL),(1113,77,920,53,NULL,NULL,NULL,NULL),(1114,77,1060,52,NULL,NULL,NULL,NULL),(1115,77,1200,48,NULL,NULL,NULL,NULL),(1116,77,1410,45,NULL,NULL,NULL,NULL),(1117,77,1780,51,NULL,NULL,NULL,NULL),(1118,78,116,22,NULL,NULL,NULL,NULL),(1119,78,216,18,NULL,NULL,NULL,NULL),(1120,78,475,32,NULL,NULL,NULL,NULL),(1121,78,600,25,NULL,NULL,NULL,NULL),(1122,78,865,32,NULL,NULL,NULL,NULL),(1123,78,1065,31,NULL,NULL,NULL,NULL),(1124,78,1410,35,NULL,NULL,NULL,NULL),(1125,79,1,42,NULL,NULL,NULL,NULL),(1126,79,7,47,NULL,NULL,NULL,NULL),(1127,79,14,51,NULL,NULL,NULL,NULL),(1128,79,21,53,NULL,NULL,NULL,NULL),(1129,79,28,54,NULL,NULL,NULL,NULL),(1130,79,43,57,NULL,NULL,NULL,NULL),(1131,79,56,59,NULL,NULL,NULL,NULL),(1132,79,70,59,NULL,NULL,NULL,NULL),(1133,79,90,58,NULL,NULL,NULL,NULL),(1134,79,117,63,NULL,NULL,NULL,NULL),(1135,79,150,62,NULL,NULL,NULL,NULL),(1136,79,178,61,NULL,NULL,NULL,NULL),(1137,79,211,61,NULL,NULL,NULL,NULL),(1138,79,243,62,NULL,NULL,NULL,NULL),(1139,79,348,64,NULL,NULL,NULL,NULL),(1140,79,422,66,NULL,NULL,NULL,NULL),(1141,79,540,65,NULL,NULL,NULL,NULL),(1142,79,645,67,NULL,NULL,NULL,NULL),(1143,79,790,66,NULL,NULL,NULL,NULL),(1144,79,1065,72,NULL,NULL,NULL,NULL),(1145,79,1205,71,NULL,NULL,NULL,NULL),(1146,79,1720,73,NULL,NULL,NULL,NULL),(1147,79,2070,77,NULL,NULL,NULL,NULL),(1148,80,1,36,NULL,NULL,NULL,NULL),(1149,80,28,48,NULL,NULL,NULL,NULL),(1150,80,90,51,NULL,NULL,NULL,NULL),(1151,80,415,58,NULL,NULL,NULL,NULL),(1152,81,1,31,NULL,NULL,NULL,NULL),(1153,81,28,43,NULL,NULL,NULL,NULL),(1154,81,90,48,NULL,NULL,NULL,NULL),(1155,81,180,51,NULL,NULL,NULL,NULL),(1156,81,324,55,NULL,NULL,NULL,NULL),(1157,81,409,56,NULL,NULL,NULL,NULL),(1158,81,475,55,NULL,NULL,NULL,NULL),(1159,81,594,52,NULL,NULL,NULL,NULL),(1160,81,733,51,NULL,NULL,NULL,NULL),(1161,81,1040,53,NULL,NULL,NULL,NULL),(1162,81,1175,55,NULL,NULL,NULL,NULL),(1163,81,1295,58,NULL,NULL,NULL,NULL),(1164,81,1610,62,NULL,NULL,NULL,NULL),(1165,81,1980,62,NULL,NULL,NULL,NULL),(1166,82,1,29,NULL,NULL,NULL,NULL),(1167,82,7,32,NULL,NULL,NULL,NULL),(1168,82,11,33,NULL,NULL,NULL,NULL),(1169,82,15,32,NULL,NULL,NULL,NULL),(1170,82,28,37,NULL,NULL,NULL,NULL),(1171,82,41,38,NULL,NULL,NULL,NULL),(1172,82,57,39,NULL,NULL,NULL,NULL),(1173,82,77,41,NULL,NULL,NULL,NULL),(1174,82,91,42,NULL,NULL,NULL,NULL),(1175,82,159,42,NULL,NULL,NULL,NULL),(1176,82,185,43,NULL,NULL,NULL,NULL),(1177,82,271,44,NULL,NULL,NULL,NULL),(1178,82,394,48,NULL,NULL,NULL,NULL),(1179,82,576,50,NULL,NULL,NULL,NULL),(1180,82,785,46,NULL,NULL,NULL,NULL),(1181,82,925,47,NULL,NULL,NULL,NULL),(1182,82,1160,49,NULL,NULL,NULL,NULL),(1183,82,1395,51,NULL,NULL,NULL,NULL),(1184,82,1740,52,NULL,NULL,NULL,NULL),(1185,83,1,24,NULL,NULL,NULL,NULL),(1186,83,21,27,NULL,NULL,NULL,NULL),(1187,83,28,30,NULL,NULL,NULL,NULL),(1188,83,120,31,NULL,NULL,NULL,NULL),(1189,83,220,32,NULL,NULL,NULL,NULL),(1190,83,307,31,NULL,NULL,NULL,NULL),(1191,83,365,33,NULL,NULL,NULL,NULL),(1192,83,490,37,NULL,NULL,NULL,NULL),(1193,83,605,41,NULL,NULL,NULL,NULL),(1194,83,920,46,NULL,NULL,NULL,NULL),(1195,83,1060,45,NULL,NULL,NULL,NULL),(1196,83,1200,45,NULL,NULL,NULL,NULL),(1197,83,1410,44,NULL,NULL,NULL,NULL),(1198,83,1780,46,NULL,NULL,NULL,NULL),(1199,84,28,13,NULL,NULL,NULL,NULL),(1200,84,116,18,NULL,NULL,NULL,NULL),(1201,84,216,18,NULL,NULL,NULL,NULL),(1202,84,350,22,NULL,NULL,NULL,NULL),(1203,84,475,27,NULL,NULL,NULL,NULL),(1204,84,600,27,NULL,NULL,NULL,NULL),(1205,84,780,31,NULL,NULL,NULL,NULL),(1206,84,1065,30,NULL,NULL,NULL,NULL),(1207,84,1410,36,NULL,NULL,NULL,NULL),(1208,85,1,41,NULL,NULL,NULL,NULL),(1209,85,7,48,NULL,NULL,NULL,NULL),(1210,85,14,55,NULL,NULL,NULL,NULL),(1211,85,21,55,NULL,NULL,NULL,NULL),(1212,85,28,57,NULL,NULL,NULL,NULL),(1213,85,43,62,NULL,NULL,NULL,NULL),(1214,85,56,62,NULL,NULL,NULL,NULL),(1215,85,70,63,NULL,NULL,NULL,NULL),(1216,85,90,63,NULL,NULL,NULL,NULL),(1217,85,117,65,NULL,NULL,NULL,NULL),(1218,85,150,64,NULL,NULL,NULL,NULL),(1219,85,178,64,NULL,NULL,NULL,NULL),(1220,85,211,63,NULL,NULL,NULL,NULL),(1221,85,243,63,NULL,NULL,NULL,NULL),(1222,85,348,66,NULL,NULL,NULL,NULL),(1223,85,422,68,NULL,NULL,NULL,NULL),(1224,85,540,66,NULL,NULL,NULL,NULL),(1225,85,645,69,NULL,NULL,NULL,NULL),(1226,85,790,69,NULL,NULL,NULL,NULL),(1227,85,1065,72,NULL,NULL,NULL,NULL),(1228,85,1205,69,NULL,NULL,NULL,NULL),(1229,85,1720,74,NULL,NULL,NULL,NULL),(1230,85,2070,72,NULL,NULL,NULL,NULL),(1231,86,1,33,NULL,NULL,NULL,NULL),(1232,86,7,36,NULL,NULL,NULL,NULL),(1233,86,11,37,NULL,NULL,NULL,NULL),(1234,86,15,37,NULL,NULL,NULL,NULL),(1235,86,28,42,NULL,NULL,NULL,NULL),(1236,86,41,44,NULL,NULL,NULL,NULL),(1237,86,57,44,NULL,NULL,NULL,NULL),(1238,86,77,46,NULL,NULL,NULL,NULL),(1239,86,91,45,NULL,NULL,NULL,NULL),(1240,86,159,48,NULL,NULL,NULL,NULL),(1241,86,185,48,NULL,NULL,NULL,NULL),(1242,86,271,51,NULL,NULL,NULL,NULL),(1243,86,394,51,NULL,NULL,NULL,NULL),(1244,86,576,53,NULL,NULL,NULL,NULL),(1245,87,1,24,NULL,NULL,NULL,NULL),(1246,87,21,26,NULL,NULL,NULL,NULL),(1247,87,28,29,NULL,NULL,NULL,NULL),(1248,87,120,31,NULL,NULL,NULL,NULL),(1249,87,220,33,NULL,NULL,NULL,NULL),(1250,87,307,32,NULL,NULL,NULL,NULL),(1251,87,365,36,NULL,NULL,NULL,NULL),(1252,87,490,39,NULL,NULL,NULL,NULL),(1253,87,605,41,NULL,NULL,NULL,NULL),(1254,87,920,46,NULL,NULL,NULL,NULL),(1255,87,1060,46,NULL,NULL,NULL,NULL),(1256,87,1200,46,NULL,NULL,NULL,NULL),(1257,87,1410,46,NULL,NULL,NULL,NULL),(1258,87,1780,47,NULL,NULL,NULL,NULL),(1259,88,28,16,NULL,NULL,NULL,NULL),(1260,88,116,19,NULL,NULL,NULL,NULL),(1261,88,216,19,NULL,NULL,NULL,NULL),(1262,88,350,21,NULL,NULL,NULL,NULL),(1263,88,475,25,NULL,NULL,NULL,NULL),(1264,88,600,25,NULL,NULL,NULL,NULL),(1265,88,780,31,NULL,NULL,NULL,NULL),(1266,88,1065,29,NULL,NULL,NULL,NULL),(1267,88,1410,36,NULL,NULL,NULL,NULL),(1268,89,1,39,NULL,NULL,NULL,NULL),(1269,89,28,58,NULL,NULL,NULL,NULL),(1270,89,479,92,NULL,NULL,NULL,NULL),(1271,90,1,46,NULL,NULL,NULL,NULL),(1272,90,3,47,NULL,NULL,NULL,NULL),(1273,90,14,61,NULL,NULL,NULL,NULL),(1274,90,21,65,NULL,NULL,NULL,NULL),(1275,90,28,69,NULL,NULL,NULL,NULL),(1276,90,43,71,NULL,NULL,NULL,NULL),(1277,90,57,75,NULL,NULL,NULL,NULL),(1278,90,71,81,NULL,NULL,NULL,NULL),(1279,90,94,87,NULL,NULL,NULL,NULL),(1280,90,154,97,NULL,NULL,NULL,NULL),(1281,90,203,102,NULL,NULL,NULL,NULL),(1282,90,479,111,NULL,NULL,NULL,NULL),(1283,91,1,40,NULL,NULL,NULL,NULL),(1284,91,3,45,NULL,NULL,NULL,NULL),(1285,91,7,51,NULL,NULL,NULL,NULL),(1286,91,14,56,NULL,NULL,NULL,NULL),(1287,91,21,60,NULL,NULL,NULL,NULL),(1288,91,28,64,NULL,NULL,NULL,NULL),(1289,91,43,69,NULL,NULL,NULL,NULL),(1290,91,57,65,NULL,NULL,NULL,NULL),(1291,91,71,75,NULL,NULL,NULL,NULL),(1292,91,94,75,NULL,NULL,NULL,NULL),(1293,91,154,82,NULL,NULL,NULL,NULL),(1294,91,203,80,NULL,NULL,NULL,NULL),(1295,91,479,86,NULL,NULL,NULL,NULL),(1296,92,1,29,NULL,NULL,NULL,NULL),(1297,92,3,32,NULL,NULL,NULL,NULL),(1298,92,7,34,NULL,NULL,NULL,NULL),(1299,92,14,34,NULL,NULL,NULL,NULL),(1300,92,21,39,NULL,NULL,NULL,NULL),(1301,92,28,39,NULL,NULL,NULL,NULL),(1302,92,43,43,NULL,NULL,NULL,NULL),(1303,92,57,41,NULL,NULL,NULL,NULL),(1304,92,71,45,NULL,NULL,NULL,NULL),(1305,92,94,48,NULL,NULL,NULL,NULL),(1306,92,154,53,NULL,NULL,NULL,NULL),(1307,92,203,50,NULL,NULL,NULL,NULL),(1308,92,479,51,NULL,NULL,NULL,NULL),(1309,93,1,31,NULL,NULL,NULL,NULL),(1310,93,3,33,NULL,NULL,NULL,NULL),(1311,93,7,34,NULL,NULL,NULL,NULL),(1312,93,14,36,NULL,NULL,NULL,NULL),(1313,93,21,39,NULL,NULL,NULL,NULL),(1314,93,28,40,NULL,NULL,NULL,NULL),(1315,93,43,42,NULL,NULL,NULL,NULL),(1316,93,57,42,NULL,NULL,NULL,NULL),(1317,93,71,42,NULL,NULL,NULL,NULL),(1318,93,94,46,NULL,NULL,NULL,NULL),(1319,93,154,46,NULL,NULL,NULL,NULL),(1320,93,203,46,NULL,NULL,NULL,NULL),(1321,93,479,49,NULL,NULL,NULL,NULL),(1322,94,9,54.4,NULL,NULL,NULL,NULL),(1323,94,10,59.1,NULL,NULL,NULL,NULL),(1324,94,11,64.6,NULL,NULL,NULL,NULL),(1325,94,19,68.9,NULL,NULL,NULL,NULL),(1326,94,30,75.7,NULL,NULL,NULL,NULL),(1327,94,40,80.6,NULL,NULL,NULL,NULL),(1328,94,51,84.2,NULL,NULL,NULL,NULL),(1329,94,62,86.3,NULL,NULL,NULL,NULL),(1330,94,89,94.1,NULL,NULL,NULL,NULL),(1331,94,117,98.4,NULL,NULL,NULL,NULL),(1332,94,147,97.8,NULL,NULL,NULL,NULL),(1333,94,185,101.2,NULL,NULL,NULL,NULL),(1334,94,209,101.4,NULL,NULL,NULL,NULL),(1335,94,247,103.1,NULL,NULL,NULL,NULL),(1336,94,267,104,NULL,NULL,NULL,NULL),(1337,94,298,105.5,NULL,NULL,NULL,NULL),(1338,94,361,107,NULL,NULL,NULL,NULL),(1339,94,413,105.7,NULL,NULL,NULL,NULL),(1340,94,484,106.3,NULL,NULL,NULL,NULL),(1341,94,538,106.3,NULL,NULL,NULL,NULL),(1342,94,606,107,NULL,NULL,NULL,NULL),(1343,94,664,107.2,NULL,NULL,NULL,NULL),(1344,94,762,107.6,NULL,NULL,NULL,NULL),(1345,94,843,106.9,NULL,NULL,NULL,NULL),(1346,94,944,108.6,NULL,NULL,NULL,NULL),(1347,94,1034,109.5,NULL,NULL,NULL,NULL),(1348,94,1154,108.7,NULL,NULL,NULL,NULL),(1349,94,1244,109.3,NULL,NULL,NULL,NULL),(1350,95,5,56.8,NULL,NULL,NULL,NULL),(1351,95,7,65.3,NULL,NULL,NULL,NULL),(1352,95,8,72.2,NULL,NULL,NULL,NULL),(1353,95,14,78.8,NULL,NULL,NULL,NULL),(1354,95,23,84.3,NULL,NULL,NULL,NULL),(1355,95,30,88.5,NULL,NULL,NULL,NULL),(1356,95,40,96.8,NULL,NULL,NULL,NULL),(1357,95,49,97.8,NULL,NULL,NULL,NULL),(1358,95,71,103.9,NULL,NULL,NULL,NULL),(1359,95,90,109,NULL,NULL,NULL,NULL),(1360,95,113,111.6,NULL,NULL,NULL,NULL),(1361,95,154,114.8,NULL,NULL,NULL,NULL),(1362,95,179,116.9,NULL,NULL,NULL,NULL),(1363,95,264,120.1,NULL,NULL,NULL,NULL),(1364,95,332,123.3,NULL,NULL,NULL,NULL),(1365,95,414,126,NULL,NULL,NULL,NULL),(1366,95,455,127,NULL,NULL,NULL,NULL),(1367,95,516,127.6,NULL,NULL,NULL,NULL),(1368,95,540,127.8,NULL,NULL,NULL,NULL),(1369,95,630,129,NULL,NULL,NULL,NULL),(1370,95,680,129.5,NULL,NULL,NULL,NULL),(1371,95,753,131,NULL,NULL,NULL,NULL),(1372,95,806,131.6,NULL,NULL,NULL,NULL),(1373,95,1034,132.8,NULL,NULL,NULL,NULL),(1374,95,1119,133,NULL,NULL,NULL,NULL),(1375,95,1215,134.4,NULL,NULL,NULL,NULL),(1376,95,1303,134.4,NULL,NULL,NULL,NULL),(1377,95,1421,135.9,NULL,NULL,NULL,NULL),(1378,95,1515,136.3,NULL,NULL,NULL,NULL),(1379,96,9,63.5,NULL,NULL,NULL,NULL),(1380,96,13,73.2,NULL,NULL,NULL,NULL),(1381,96,24,77.4,NULL,NULL,NULL,NULL),(1382,96,32,81,NULL,NULL,NULL,NULL),(1383,96,39,83.8,NULL,NULL,NULL,NULL),(1384,96,46,87.6,NULL,NULL,NULL,NULL),(1385,96,52,92.4,NULL,NULL,NULL,NULL),(1386,96,64,95.3,NULL,NULL,NULL,NULL),(1387,96,76,96.1,NULL,NULL,NULL,NULL),(1388,96,85,101.9,NULL,NULL,NULL,NULL),(1389,96,97,103.7,NULL,NULL,NULL,NULL),(1390,96,140,110.9,NULL,NULL,NULL,NULL),(1391,96,160,110.7,NULL,NULL,NULL,NULL),(1392,96,197,113.4,NULL,NULL,NULL,NULL),(1393,96,254,121,NULL,NULL,NULL,NULL),(1394,96,285,122.9,NULL,NULL,NULL,NULL),(1395,96,352,125,NULL,NULL,NULL,NULL),(1396,96,382,125.8,NULL,NULL,NULL,NULL),(1397,96,409,126.4,NULL,NULL,NULL,NULL),(1398,96,450,127,NULL,NULL,NULL,NULL),(1399,96,626,130.8,NULL,NULL,NULL,NULL),(1400,96,677,130.9,NULL,NULL,NULL,NULL),(1401,96,872,133.4,NULL,NULL,NULL,NULL),(1402,96,1032,134.9,NULL,NULL,NULL,NULL),(1403,96,1166,135.7,NULL,NULL,NULL,NULL),(1404,96,1211,134.1,NULL,NULL,NULL,NULL),(1405,96,1308,135.5,NULL,NULL,NULL,NULL),(1406,96,1427,135.9,NULL,NULL,NULL,NULL),(1407,96,1515,136.9,NULL,NULL,NULL,NULL),(1408,97,3,48.6,NULL,NULL,NULL,NULL),(1409,97,5,54.6,NULL,NULL,NULL,NULL),(1410,97,10,57.6,NULL,NULL,NULL,NULL),(1411,97,22,65.9,NULL,NULL,NULL,NULL),(1412,97,27,68.3,NULL,NULL,NULL,NULL),(1413,97,41,70.4,NULL,NULL,NULL,NULL),(1414,97,51,77.7,NULL,NULL,NULL,NULL),(1415,97,55,80.4,NULL,NULL,NULL,NULL),(1416,97,72,84.9,NULL,NULL,NULL,NULL),(1417,97,120,89.2,NULL,NULL,NULL,NULL),(1418,97,152,91.9,NULL,NULL,NULL,NULL),(1419,97,206,93.2,NULL,NULL,NULL,NULL),(1420,97,273,94.8,NULL,NULL,NULL,NULL),(1421,97,306,97.3,NULL,NULL,NULL,NULL),(1422,97,333,97,NULL,NULL,NULL,NULL),(1423,97,361,97.7,NULL,NULL,NULL,NULL),(1424,97,392,97.9,NULL,NULL,NULL,NULL),(1425,97,431,98.8,NULL,NULL,NULL,NULL),(1426,97,546,100.4,NULL,NULL,NULL,NULL),(1427,97,608,101.7,NULL,NULL,NULL,NULL),(1428,97,657,100.8,NULL,NULL,NULL,NULL),(1429,97,852,106,NULL,NULL,NULL,NULL),(1430,97,912,106.5,NULL,NULL,NULL,NULL),(1431,97,1018,106.9,NULL,NULL,NULL,NULL),(1432,97,1098,107.5,NULL,NULL,NULL,NULL),(1433,97,1195,107.6,NULL,NULL,NULL,NULL),(1434,97,1273,108.2,NULL,NULL,NULL,NULL),(1435,97,1408,109.1,NULL,NULL,NULL,NULL),(1436,97,1508,109.4,NULL,NULL,NULL,NULL),(1437,98,4,48.4,NULL,NULL,NULL,NULL),(1438,98,9,53.8,NULL,NULL,NULL,NULL),(1439,98,14,59.2,NULL,NULL,NULL,NULL),(1440,98,22,62.8,NULL,NULL,NULL,NULL),(1441,98,27,66.1,NULL,NULL,NULL,NULL),(1442,98,41,68.4,NULL,NULL,NULL,NULL),(1443,98,51,73.4,NULL,NULL,NULL,NULL),(1444,98,67,75.3,NULL,NULL,NULL,NULL),(1445,98,94,79.9,NULL,NULL,NULL,NULL),(1446,98,141,84.4,NULL,NULL,NULL,NULL),(1447,98,179,86.2,NULL,NULL,NULL,NULL),(1448,98,274,90.2,NULL,NULL,NULL,NULL),(1449,98,303,90.2,NULL,NULL,NULL,NULL),(1450,98,333,90.9,NULL,NULL,NULL,NULL),(1451,98,361,93.6,NULL,NULL,NULL,NULL),(1452,98,421,92.9,NULL,NULL,NULL,NULL),(1453,98,462,93.6,NULL,NULL,NULL,NULL),(1454,98,484,93.6,NULL,NULL,NULL,NULL),(1455,98,517,94.2,NULL,NULL,NULL,NULL),(1456,98,627,96.2,NULL,NULL,NULL,NULL),(1457,98,702,99.6,NULL,NULL,NULL,NULL),(1458,98,752,99.2,NULL,NULL,NULL,NULL),(1459,98,822,100.7,NULL,NULL,NULL,NULL),(1460,98,979,103,NULL,NULL,NULL,NULL),(1461,98,1066,102.5,NULL,NULL,NULL,NULL),(1462,98,1163,103.4,NULL,NULL,NULL,NULL),(1463,98,1251,104.1,NULL,NULL,NULL,NULL),(1464,98,1378,104.1,NULL,NULL,NULL,NULL),(1465,98,1525,104.2,NULL,NULL,NULL,NULL),(1466,99,7,52.6,NULL,NULL,NULL,NULL),(1467,99,10,58.3,NULL,NULL,NULL,NULL),(1468,99,15,61.7,NULL,NULL,NULL,NULL),(1469,99,20,64.6,NULL,NULL,NULL,NULL),(1470,99,30,66,NULL,NULL,NULL,NULL),(1471,99,43,72.5,NULL,NULL,NULL,NULL),(1472,99,54,74.1,NULL,NULL,NULL,NULL),(1473,99,65,76.2,NULL,NULL,NULL,NULL),(1474,99,82,79.4,NULL,NULL,NULL,NULL),(1475,99,118,85.5,NULL,NULL,NULL,NULL),(1476,99,166,85.9,NULL,NULL,NULL,NULL),(1477,99,195,87.5,NULL,NULL,NULL,NULL),(1478,99,230,88.8,NULL,NULL,NULL,NULL),(1479,99,263,90.2,NULL,NULL,NULL,NULL),(1480,99,294,91.8,NULL,NULL,NULL,NULL),(1481,99,354,92,NULL,NULL,NULL,NULL),(1482,99,421,93.8,NULL,NULL,NULL,NULL),(1483,99,486,96.1,NULL,NULL,NULL,NULL),(1484,99,508,98.3,NULL,NULL,NULL,NULL),(1485,99,536,98.3,NULL,NULL,NULL,NULL),(1486,99,649,102.2,NULL,NULL,NULL,NULL),(1487,99,724,100.5,NULL,NULL,NULL,NULL),(1488,99,901,104.2,NULL,NULL,NULL,NULL),(1489,99,1075,105.8,NULL,NULL,NULL,NULL),(1490,99,1184,105.8,NULL,NULL,NULL,NULL),(1491,99,1276,106.8,NULL,NULL,NULL,NULL),(1492,99,1393,107.3,NULL,NULL,NULL,NULL),(1493,99,1555,108.1,NULL,NULL,NULL,NULL),(1494,99,1735,108.3,NULL,NULL,NULL,NULL),(1495,100,3,51.1,NULL,NULL,NULL,NULL),(1496,100,4,55.4,NULL,NULL,NULL,NULL),(1497,100,12,61.4,NULL,NULL,NULL,NULL),(1498,100,20,67,NULL,NULL,NULL,NULL),(1499,100,30,71.6,NULL,NULL,NULL,NULL),(1500,100,54,76.6,NULL,NULL,NULL,NULL),(1501,100,88,81.7,NULL,NULL,NULL,NULL),(1502,100,119,82.4,NULL,NULL,NULL,NULL),(1503,100,153,84,NULL,NULL,NULL,NULL),(1504,100,173,85.7,NULL,NULL,NULL,NULL),(1505,100,203,86.3,NULL,NULL,NULL,NULL),(1506,100,233,88.2,NULL,NULL,NULL,NULL),(1507,100,270,90.4,NULL,NULL,NULL,NULL),(1508,100,292,91.5,NULL,NULL,NULL,NULL),(1509,100,322,91.7,NULL,NULL,NULL,NULL),(1510,100,353,92.1,NULL,NULL,NULL,NULL),(1511,100,390,92.3,NULL,NULL,NULL,NULL),(1512,100,454,95.6,NULL,NULL,NULL,NULL),(1513,100,475,94.4,NULL,NULL,NULL,NULL),(1514,100,621,96.2,NULL,NULL,NULL,NULL),(1515,100,695,102,NULL,NULL,NULL,NULL),(1516,100,748,100,NULL,NULL,NULL,NULL),(1517,100,872,103.5,NULL,NULL,NULL,NULL),(1518,100,976,104.9,NULL,NULL,NULL,NULL),(1519,100,1059,105.7,NULL,NULL,NULL,NULL),(1520,100,1242,106.6,NULL,NULL,NULL,NULL),(1521,100,1371,106.6,NULL,NULL,NULL,NULL),(1522,100,1528,106.8,NULL,NULL,NULL,NULL),(1523,100,1743,108,NULL,NULL,NULL,NULL),(1524,101,4,48.5,NULL,NULL,NULL,NULL),(1525,101,5,54.3,NULL,NULL,NULL,NULL),(1526,101,14,58.4,NULL,NULL,NULL,NULL),(1527,101,20,66,NULL,NULL,NULL,NULL),(1528,101,53,74.8,NULL,NULL,NULL,NULL),(1529,101,76,77.4,NULL,NULL,NULL,NULL),(1530,101,84,81.1,NULL,NULL,NULL,NULL),(1531,101,106,82.8,NULL,NULL,NULL,NULL),(1532,101,138,85.8,NULL,NULL,NULL,NULL),(1533,101,174,88.2,NULL,NULL,NULL,NULL),(1534,101,202,90,NULL,NULL,NULL,NULL),(1535,101,236,92.1,NULL,NULL,NULL,NULL),(1536,101,263,93,NULL,NULL,NULL,NULL),(1537,101,289,95.1,NULL,NULL,NULL,NULL),(1538,101,321,94.5,NULL,NULL,NULL,NULL),(1539,101,362,95.6,NULL,NULL,NULL,NULL),(1540,101,383,97.3,NULL,NULL,NULL,NULL),(1541,101,442,99.5,NULL,NULL,NULL,NULL),(1542,101,471,101.4,NULL,NULL,NULL,NULL),(1543,101,660,105.1,NULL,NULL,NULL,NULL),(1544,101,711,106.2,NULL,NULL,NULL,NULL),(1545,101,782,106.8,NULL,NULL,NULL,NULL),(1546,101,838,108.7,NULL,NULL,NULL,NULL),(1547,101,1025,106.8,NULL,NULL,NULL,NULL),(1548,101,1124,108.5,NULL,NULL,NULL,NULL),(1549,101,1204,109,NULL,NULL,NULL,NULL),(1550,101,1251,109.2,NULL,NULL,NULL,NULL),(1551,101,1335,111.1,NULL,NULL,NULL,NULL),(1552,101,1466,110.9,NULL,NULL,NULL,NULL),(1553,102,6,53.6,NULL,NULL,NULL,NULL),(1554,102,9,63.4,NULL,NULL,NULL,NULL),(1555,102,13,69.2,NULL,NULL,NULL,NULL),(1556,102,21,77.7,NULL,NULL,NULL,NULL),(1557,102,26,81.7,NULL,NULL,NULL,NULL),(1558,102,60,89.9,NULL,NULL,NULL,NULL),(1559,102,82,94.1,NULL,NULL,NULL,NULL),(1560,102,112,95.7,NULL,NULL,NULL,NULL),(1561,102,145,96.1,NULL,NULL,NULL,NULL),(1562,102,185,100.5,NULL,NULL,NULL,NULL),(1563,102,209,100.1,NULL,NULL,NULL,NULL),(1564,102,273,105.3,NULL,NULL,NULL,NULL),(1565,102,327,108.3,NULL,NULL,NULL,NULL),(1566,102,364,108.3,NULL,NULL,NULL,NULL),(1567,102,429,110.5,NULL,NULL,NULL,NULL),(1568,102,452,110.9,NULL,NULL,NULL,NULL),(1569,102,481,110.9,NULL,NULL,NULL,NULL),(1570,102,541,112.5,NULL,NULL,NULL,NULL),(1571,102,594,112.7,NULL,NULL,NULL,NULL),(1572,102,658,114.1,NULL,NULL,NULL,NULL),(1573,102,722,114.3,NULL,NULL,NULL,NULL),(1574,102,787,114.5,NULL,NULL,NULL,NULL),(1575,102,843,115.9,NULL,NULL,NULL,NULL),(1576,102,950,115.5,NULL,NULL,NULL,NULL),(1577,102,1033,115.1,NULL,NULL,NULL,NULL),(1578,102,1133,116.1,NULL,NULL,NULL,NULL),(1579,102,1223,116.7,NULL,NULL,NULL,NULL),(1580,102,1340,117.7,NULL,NULL,NULL,NULL),(1581,102,1436,117.9,NULL,NULL,NULL,NULL),(1582,103,6,52.9,NULL,NULL,NULL,NULL),(1583,103,9,61.5,NULL,NULL,NULL,NULL),(1584,103,10,66.5,NULL,NULL,NULL,NULL),(1585,103,14,72,NULL,NULL,NULL,NULL),(1586,103,21,76.6,NULL,NULL,NULL,NULL),(1587,103,31,82.3,NULL,NULL,NULL,NULL),(1588,103,35,86,NULL,NULL,NULL,NULL),(1589,103,61,94.1,NULL,NULL,NULL,NULL),(1590,103,71,96.5,NULL,NULL,NULL,NULL),(1591,103,91,98.3,NULL,NULL,NULL,NULL),(1592,103,113,100,NULL,NULL,NULL,NULL),(1593,103,140,102,NULL,NULL,NULL,NULL),(1594,103,163,106.4,NULL,NULL,NULL,NULL),(1595,103,230,108.2,NULL,NULL,NULL,NULL),(1596,103,261,109.4,NULL,NULL,NULL,NULL),(1597,103,298,109.9,NULL,NULL,NULL,NULL),(1598,103,320,110.6,NULL,NULL,NULL,NULL),(1599,103,363,112.3,NULL,NULL,NULL,NULL),(1600,103,475,113,NULL,NULL,NULL,NULL),(1601,103,524,113.8,NULL,NULL,NULL,NULL),(1602,103,653,115.4,NULL,NULL,NULL,NULL),(1603,103,720,116.5,NULL,NULL,NULL,NULL),(1604,103,774,116.9,NULL,NULL,NULL,NULL),(1605,103,882,118,NULL,NULL,NULL,NULL),(1606,103,962,118.6,NULL,NULL,NULL,NULL),(1607,103,1060,118.7,NULL,NULL,NULL,NULL),(1608,103,1152,119.5,NULL,NULL,NULL,NULL),(1609,103,1211,119.5,NULL,NULL,NULL,NULL),(1610,103,1366,123.9,NULL,NULL,NULL,NULL),(1611,104,2.5,36.9,NULL,NULL,NULL,NULL),(1612,104,5,39.8,NULL,NULL,NULL,NULL),(1613,104,7.5,40.2,NULL,NULL,NULL,NULL),(1614,104,10,41.7,NULL,NULL,NULL,NULL),(1615,104,12.5,42,NULL,NULL,NULL,NULL),(1616,104,15,43.8,NULL,NULL,NULL,NULL),(1617,104,20,46.6,NULL,NULL,NULL,NULL),(1618,104,25,47.6,NULL,NULL,NULL,NULL),(1619,104,30,50.7,NULL,NULL,NULL,NULL),(1620,104,35,53.4,NULL,NULL,NULL,NULL),(1621,104,40,54.7,NULL,NULL,NULL,NULL),(1622,104,45,55.3,NULL,NULL,NULL,NULL),(1623,104,50,57.4,NULL,NULL,NULL,NULL),(1624,104,55,58.2,NULL,NULL,NULL,NULL),(1625,104,60,59.2,NULL,NULL,NULL,NULL),(1626,105,2.5,42.5,NULL,NULL,NULL,NULL),(1627,105,5,43.3,NULL,NULL,NULL,NULL),(1628,105,7.5,45,NULL,NULL,NULL,NULL),(1629,105,10,46.8,NULL,NULL,NULL,NULL),(1630,105,12.5,48.9,NULL,NULL,NULL,NULL),(1631,105,15,50.7,NULL,NULL,NULL,NULL),(1632,105,20,54.5,NULL,NULL,NULL,NULL),(1633,105,25,56.5,NULL,NULL,NULL,NULL),(1634,105,30,60.3,NULL,NULL,NULL,NULL),(1635,105,35,62.5,NULL,NULL,NULL,NULL),(1636,105,40,64.2,NULL,NULL,NULL,NULL),(1637,105,45,66.1,NULL,NULL,NULL,NULL),(1638,105,50,68.1,NULL,NULL,NULL,NULL),(1639,105,55,69.6,NULL,NULL,NULL,NULL),(1640,105,60,70.2,NULL,NULL,NULL,NULL),(1641,106,2.5,43.3,NULL,NULL,NULL,NULL),(1642,106,5,53.6,NULL,NULL,NULL,NULL),(1643,106,7.5,60.3,NULL,NULL,NULL,NULL),(1644,106,10,62.4,NULL,NULL,NULL,NULL),(1645,106,12.5,64.2,NULL,NULL,NULL,NULL),(1646,106,15,64.6,NULL,NULL,NULL,NULL),(1647,106,20,68.1,NULL,NULL,NULL,NULL),(1648,106,25,69.6,NULL,NULL,NULL,NULL),(1649,106,30,73.9,NULL,NULL,NULL,NULL),(1650,106,35,76.2,NULL,NULL,NULL,NULL),(1651,106,40,77.7,NULL,NULL,NULL,NULL),(1652,106,45,81.6,NULL,NULL,NULL,NULL),(1653,106,50,83.5,NULL,NULL,NULL,NULL),(1654,106,55,85.5,NULL,NULL,NULL,NULL),(1655,106,60,87.6,NULL,NULL,NULL,NULL),(1656,107,2.5,58.4,NULL,NULL,NULL,NULL),(1657,107,5,60.7,NULL,NULL,NULL,NULL),(1658,107,7.5,63.2,NULL,NULL,NULL,NULL),(1659,107,10,66.1,NULL,NULL,NULL,NULL),(1660,107,15,69,NULL,NULL,NULL,NULL),(1661,107,20,73.7,NULL,NULL,NULL,NULL),(1662,107,25,79.7,NULL,NULL,NULL,NULL),(1663,107,30,82.4,NULL,NULL,NULL,NULL),(1664,107,35,83.5,NULL,NULL,NULL,NULL),(1665,107,40,87.4,NULL,NULL,NULL,NULL),(1666,107,45,89.7,NULL,NULL,NULL,NULL),(1667,107,50,93.2,NULL,NULL,NULL,NULL),(1668,107,55,95.1,NULL,NULL,NULL,NULL),(1669,107,60,97.6,NULL,NULL,NULL,NULL),(1670,108,2.5,62.7,NULL,NULL,NULL,NULL),(1671,108,5,70.5,NULL,NULL,NULL,NULL),(1672,108,7.5,75.5,NULL,NULL,NULL,NULL),(1673,108,10,76.7,NULL,NULL,NULL,NULL),(1674,108,12.5,80.9,NULL,NULL,NULL,NULL),(1675,108,15,79.9,NULL,NULL,NULL,NULL),(1676,108,20,87.3,NULL,NULL,NULL,NULL),(1677,108,30,93.9,NULL,NULL,NULL,NULL),(1678,108,35,96.1,NULL,NULL,NULL,NULL),(1679,108,40,98.3,NULL,NULL,NULL,NULL),(1680,108,45,102.5,NULL,NULL,NULL,NULL),(1681,108,50,104,NULL,NULL,NULL,NULL),(1682,108,55,106.4,NULL,NULL,NULL,NULL),(1683,108,60,108.4,NULL,NULL,NULL,NULL),(1684,109,0.74,54.8,NULL,NULL,NULL,NULL),(1685,109,2,71,NULL,NULL,NULL,NULL),(1686,109,3,78.1,NULL,NULL,NULL,NULL),(1687,109,4,83.3,NULL,NULL,NULL,NULL),(1688,109,5,87.4,NULL,NULL,NULL,NULL),(1689,109,7,92.6,NULL,NULL,NULL,NULL),(1690,109,10,98,NULL,NULL,NULL,NULL),(1691,109,20,109.3,NULL,NULL,NULL,NULL),(1692,109,30,116.5,NULL,NULL,NULL,NULL),(1693,109,40,122.7,NULL,NULL,NULL,NULL),(1694,109,50,124.7,NULL,NULL,NULL,NULL),(1695,109,70,130.2,NULL,NULL,NULL,NULL),(1696,109,100,134.3,NULL,NULL,NULL,NULL),(1697,109,200,150.4,NULL,NULL,NULL,NULL),(1698,109,300,158.3,NULL,NULL,NULL,NULL),(1699,109,400,167.9,NULL,NULL,NULL,NULL),(1700,109,500,172.7,NULL,NULL,NULL,NULL),(1701,109,700,184.4,NULL,NULL,NULL,NULL),(1702,109,1000,176.8,NULL,NULL,NULL,NULL),(1703,110,0.96,49.3,NULL,NULL,NULL,NULL),(1704,110,2,64.3,NULL,NULL,NULL,NULL),(1705,110,3,71.3,NULL,NULL,NULL,NULL),(1706,110,4,74.5,NULL,NULL,NULL,NULL),(1707,110,5,77.5,NULL,NULL,NULL,NULL),(1708,110,7,81.8,NULL,NULL,NULL,NULL),(1709,110,10,86,NULL,NULL,NULL,NULL),(1710,110,20,95.5,NULL,NULL,NULL,NULL),(1711,110,30,101.4,NULL,NULL,NULL,NULL),(1712,110,40,107.2,NULL,NULL,NULL,NULL),(1713,110,50,110.8,NULL,NULL,NULL,NULL),(1714,110,70,117.1,NULL,NULL,NULL,NULL),(1715,110,100,122.8,NULL,NULL,NULL,NULL),(1716,110,200,130.6,NULL,NULL,NULL,NULL),(1717,110,300,138.7,NULL,NULL,NULL,NULL),(1718,110,400,142.8,NULL,NULL,NULL,NULL),(1719,110,500,134.3,NULL,NULL,NULL,NULL),(1720,110,700,141.7,NULL,NULL,NULL,NULL),(1721,110,1000,150.6,NULL,NULL,NULL,NULL),(1722,111,0.8,46.2,NULL,NULL,NULL,NULL),(1723,111,1.88,61.2,NULL,NULL,NULL,NULL),(1724,111,2.88,66.3,NULL,NULL,NULL,NULL),(1725,111,3.88,68.9,NULL,NULL,NULL,NULL),(1726,111,4.88,71,NULL,NULL,NULL,NULL),(1727,111,6.88,73.8,NULL,NULL,NULL,NULL),(1728,111,9.88,77.7,NULL,NULL,NULL,NULL),(1729,111,19.88,85,NULL,NULL,NULL,NULL),(1730,111,29.88,90.9,NULL,NULL,NULL,NULL),(1731,111,39.88,96.2,NULL,NULL,NULL,NULL),(1732,111,49.88,99.1,NULL,NULL,NULL,NULL),(1733,111,69.88,103.9,NULL,NULL,NULL,NULL),(1734,111,99.88,110.1,NULL,NULL,NULL,NULL),(1735,111,199.88,120.2,NULL,NULL,NULL,NULL),(1736,111,299.88,126.7,NULL,NULL,NULL,NULL),(1737,111,399.88,132,NULL,NULL,NULL,NULL),(1738,111,499.88,136.3,NULL,NULL,NULL,NULL),(1739,111,699.88,142.8,NULL,NULL,NULL,NULL),(1740,111,999.88,155.1,NULL,NULL,NULL,NULL),(1741,112,1.88,63.1,NULL,NULL,NULL,NULL),(1742,112,2.88,71.6,NULL,NULL,NULL,NULL),(1743,112,3.88,76.7,NULL,NULL,NULL,NULL),(1744,112,4.88,80,NULL,NULL,NULL,NULL),(1745,112,6.88,85,NULL,NULL,NULL,NULL),(1746,112,9.88,91.5,NULL,NULL,NULL,NULL),(1747,112,19.88,97.1,NULL,NULL,NULL,NULL),(1748,112,29.88,106,NULL,NULL,NULL,NULL),(1749,112,39.88,110.7,NULL,NULL,NULL,NULL),(1750,112,49.88,114.3,NULL,NULL,NULL,NULL),(1751,112,69.88,120.8,NULL,NULL,NULL,NULL),(1752,112,99.88,125.6,NULL,NULL,NULL,NULL),(1753,112,199.88,134.3,NULL,NULL,NULL,NULL),(1754,112,299.88,140.8,NULL,NULL,NULL,NULL),(1755,112,399.88,146.6,NULL,NULL,NULL,NULL),(1756,112,499.88,150.8,NULL,NULL,NULL,NULL),(1757,112,699.88,156.1,NULL,NULL,NULL,NULL),(1758,112,999.88,163.6,NULL,NULL,NULL,NULL),(1759,113,0.54,61.3,NULL,NULL,NULL,NULL),(1760,113,2,82.9,NULL,NULL,NULL,NULL),(1761,113,3,90.8,NULL,NULL,NULL,NULL),(1762,113,4,95.6,NULL,NULL,NULL,NULL),(1763,113,5,97.7,NULL,NULL,NULL,NULL),(1764,113,7,101.8,NULL,NULL,NULL,NULL),(1765,113,10,107,NULL,NULL,NULL,NULL),(1766,113,20,114.1,NULL,NULL,NULL,NULL),(1767,113,30,119.1,NULL,NULL,NULL,NULL),(1768,113,40,122.7,NULL,NULL,NULL,NULL),(1769,113,50,126.4,NULL,NULL,NULL,NULL),(1770,113,70,129.9,NULL,NULL,NULL,NULL),(1771,113,100,135.4,NULL,NULL,NULL,NULL),(1772,113,200,146.7,NULL,NULL,NULL,NULL),(1773,113,300,150.8,NULL,NULL,NULL,NULL),(1774,113,400,162.6,NULL,NULL,NULL,NULL),(1775,113,500,168.9,NULL,NULL,NULL,NULL),(1776,113,700,175.8,NULL,NULL,NULL,NULL),(1777,113,1000,181,NULL,NULL,NULL,NULL),(1778,114,1,38.6,NULL,NULL,NULL,NULL),(1779,114,2,56.8,NULL,NULL,NULL,NULL),(1780,114,3,61.3,NULL,NULL,NULL,NULL),(1781,114,4,63.8,NULL,NULL,NULL,NULL),(1782,114,5,65.4,NULL,NULL,NULL,NULL),(1783,114,7,68.3,NULL,NULL,NULL,NULL),(1784,114,10,70.9,NULL,NULL,NULL,NULL),(1785,114,20,76.3,NULL,NULL,NULL,NULL),(1786,114,30,79.7,NULL,NULL,NULL,NULL),(1787,114,40,81.8,NULL,NULL,NULL,NULL),(1788,114,50,83.5,NULL,NULL,NULL,NULL),(1789,114,70,86.1,NULL,NULL,NULL,NULL),(1790,114,100,89.2,NULL,NULL,NULL,NULL),(1791,114,200,95,NULL,NULL,NULL,NULL),(1792,114,300,100.9,NULL,NULL,NULL,NULL),(1793,114,400,104.6,NULL,NULL,NULL,NULL),(1794,114,500,107.3,NULL,NULL,NULL,NULL),(1795,114,700,112.7,NULL,NULL,NULL,NULL),(1796,114,1000,117.1,NULL,NULL,NULL,NULL),(1797,115,0.88,44.1,NULL,NULL,NULL,NULL),(1798,115,1.88,59.2,NULL,NULL,NULL,NULL),(1799,115,2.88,64.2,NULL,NULL,NULL,NULL),(1800,115,3.88,67.2,NULL,NULL,NULL,NULL),(1801,115,4.88,69.4,NULL,NULL,NULL,NULL),(1802,115,6.88,71.5,NULL,NULL,NULL,NULL),(1803,115,9.88,75.4,NULL,NULL,NULL,NULL),(1804,115,19.88,80.2,NULL,NULL,NULL,NULL),(1805,115,29.88,84.1,NULL,NULL,NULL,NULL),(1806,115,39.88,87.3,NULL,NULL,NULL,NULL),(1807,115,49.88,89.6,NULL,NULL,NULL,NULL),(1808,115,69.88,92.8,NULL,NULL,NULL,NULL),(1809,115,99.88,96.9,NULL,NULL,NULL,NULL),(1810,115,199.88,103.7,NULL,NULL,NULL,NULL),(1811,115,299.88,110.1,NULL,NULL,NULL,NULL),(1812,115,399.88,116.5,NULL,NULL,NULL,NULL),(1813,115,499.88,120.2,NULL,NULL,NULL,NULL),(1814,115,699.88,126.6,NULL,NULL,NULL,NULL),(1815,115,999.88,132,NULL,NULL,NULL,NULL),(1816,116,0.88,44.8,NULL,NULL,NULL,NULL),(1817,116,1.88,57.6,NULL,NULL,NULL,NULL),(1818,116,2.88,62,NULL,NULL,NULL,NULL),(1819,116,3.88,64.7,NULL,NULL,NULL,NULL),(1820,116,4.88,66.3,NULL,NULL,NULL,NULL),(1821,116,6.88,69.3,NULL,NULL,NULL,NULL),(1822,116,9.88,72.5,NULL,NULL,NULL,NULL),(1823,116,19.88,78,NULL,NULL,NULL,NULL),(1824,116,29.88,82.1,NULL,NULL,NULL,NULL),(1825,116,39.88,86.2,NULL,NULL,NULL,NULL),(1826,116,49.88,88.5,NULL,NULL,NULL,NULL),(1827,116,69.88,91.9,NULL,NULL,NULL,NULL),(1828,116,99.88,96.7,NULL,NULL,NULL,NULL),(1829,116,199.88,104.9,NULL,NULL,NULL,NULL),(1830,116,299.88,111.1,NULL,NULL,NULL,NULL),(1831,116,399.88,116.1,NULL,NULL,NULL,NULL),(1832,116,499.88,119.5,NULL,NULL,NULL,NULL),(1833,116,699.88,124.1,NULL,NULL,NULL,NULL),(1834,116,999.88,122,NULL,NULL,NULL,NULL),(1835,117,1,51.8,NULL,NULL,NULL,NULL),(1836,117,2,74.7,NULL,NULL,NULL,NULL),(1837,117,3,82.2,NULL,NULL,NULL,NULL),(1838,117,4,86.7,NULL,NULL,NULL,NULL),(1839,117,5,87.7,NULL,NULL,NULL,NULL),(1840,117,7,91.1,NULL,NULL,NULL,NULL),(1841,117,10,96.3,NULL,NULL,NULL,NULL),(1842,117,20,104.5,NULL,NULL,NULL,NULL),(1843,117,30,109,NULL,NULL,NULL,NULL),(1844,117,40,111.1,NULL,NULL,NULL,NULL),(1845,117,50,113.8,NULL,NULL,NULL,NULL),(1846,117,70,117.5,NULL,NULL,NULL,NULL),(1847,117,100,122,NULL,NULL,NULL,NULL),(1848,117,200,128.2,NULL,NULL,NULL,NULL),(1849,117,300,125.4,NULL,NULL,NULL,NULL),(1850,117,400,127.5,NULL,NULL,NULL,NULL),(1851,117,500,129.5,NULL,NULL,NULL,NULL),(1852,117,700,132.3,NULL,NULL,NULL,NULL),(1853,117,1000,135.7,NULL,NULL,NULL,NULL),(1854,118,0.51,24.04,NULL,NULL,NULL,NULL),(1855,118,1,38.4,NULL,NULL,NULL,NULL),(1856,118,2,58.9,NULL,NULL,NULL,NULL),(1857,118,3,65.1,NULL,NULL,NULL,NULL),(1858,118,4,68.5,NULL,NULL,NULL,NULL),(1859,118,5,70.6,NULL,NULL,NULL,NULL),(1860,118,7,74,NULL,NULL,NULL,NULL),(1861,118,10,77.4,NULL,NULL,NULL,NULL),(1862,118,20,83.6,NULL,NULL,NULL,NULL),(1863,118,30,87.7,NULL,NULL,NULL,NULL),(1864,118,40,91.1,NULL,NULL,NULL,NULL),(1865,118,50,92.5,NULL,NULL,NULL,NULL),(1866,118,70,95.9,NULL,NULL,NULL,NULL),(1867,118,100,100.1,NULL,NULL,NULL,NULL),(1868,118,200,106.2,NULL,NULL,NULL,NULL),(1869,118,300,111,NULL,NULL,NULL,NULL),(1870,118,400,114.4,NULL,NULL,NULL,NULL),(1871,118,500,117.2,NULL,NULL,NULL,NULL),(1872,118,700,118.6,NULL,NULL,NULL,NULL),(1873,118,1000,121.3,NULL,NULL,NULL,NULL),(1874,119,0.88,39.2,NULL,NULL,NULL,NULL),(1875,119,1.88,50.6,NULL,NULL,NULL,NULL),(1876,119,2.88,53.6,NULL,NULL,NULL,NULL),(1877,119,3.88,56.3,NULL,NULL,NULL,NULL),(1878,119,4.88,57.7,NULL,NULL,NULL,NULL),(1879,119,6.88,59.5,NULL,NULL,NULL,NULL),(1880,119,9.88,62.5,NULL,NULL,NULL,NULL),(1881,119,19.88,65.7,NULL,NULL,NULL,NULL),(1882,119,29.88,68.4,NULL,NULL,NULL,NULL),(1883,119,39.88,70.7,NULL,NULL,NULL,NULL),(1884,119,49.88,72.1,NULL,NULL,NULL,NULL),(1885,119,69.88,73.9,NULL,NULL,NULL,NULL),(1886,119,99.88,75.2,NULL,NULL,NULL,NULL),(1887,119,199.88,79.4,NULL,NULL,NULL,NULL),(1888,119,299.88,81.4,NULL,NULL,NULL,NULL),(1889,119,399.88,83.9,NULL,NULL,NULL,NULL),(1890,119,499.88,86.3,NULL,NULL,NULL,NULL),(1891,119,699.88,89.2,NULL,NULL,NULL,NULL),(1892,119,999.88,92.6,NULL,NULL,NULL,NULL),(1893,120,0.88,32.1,NULL,NULL,NULL,NULL),(1894,120,1.88,42.9,NULL,NULL,NULL,NULL),(1895,120,2.88,47.2,NULL,NULL,NULL,NULL),(1896,120,3.88,49.7,NULL,NULL,NULL,NULL),(1897,120,4.88,51.5,NULL,NULL,NULL,NULL),(1898,120,6.88,53.6,NULL,NULL,NULL,NULL),(1899,120,9.88,55.4,NULL,NULL,NULL,NULL),(1900,120,19.88,60.5,NULL,NULL,NULL,NULL),(1901,120,29.88,63.6,NULL,NULL,NULL,NULL),(1902,120,39.88,66.4,NULL,NULL,NULL,NULL),(1903,120,49.88,68,NULL,NULL,NULL,NULL),(1904,120,69.88,71,NULL,NULL,NULL,NULL),(1905,120,99.88,72.5,NULL,NULL,NULL,NULL),(1906,120,199.88,78.3,NULL,NULL,NULL,NULL),(1907,120,299.88,81.2,NULL,NULL,NULL,NULL),(1908,120,399.88,83.3,NULL,NULL,NULL,NULL),(1909,120,499.88,84.9,NULL,NULL,NULL,NULL),(1910,120,699.88,86.7,NULL,NULL,NULL,NULL),(1911,120,999.88,88.8,NULL,NULL,NULL,NULL),(1912,121,0.88,33.5,NULL,NULL,NULL,NULL),(1913,121,1.88,44,NULL,NULL,NULL,NULL),(1914,121,2.88,47.5,NULL,NULL,NULL,NULL),(1915,121,3.88,49.3,NULL,NULL,NULL,NULL),(1916,121,4.88,50.9,NULL,NULL,NULL,NULL),(1917,121,6.88,52.7,NULL,NULL,NULL,NULL),(1918,121,9.88,55.9,NULL,NULL,NULL,NULL),(1919,121,19.88,60.4,NULL,NULL,NULL,NULL),(1920,121,29.88,63.4,NULL,NULL,NULL,NULL),(1921,121,39.88,65.5,NULL,NULL,NULL,NULL),(1922,121,49.88,66.6,NULL,NULL,NULL,NULL),(1923,121,69.88,68.6,NULL,NULL,NULL,NULL),(1924,121,99.88,71,NULL,NULL,NULL,NULL),(1925,121,199.88,75.1,NULL,NULL,NULL,NULL),(1926,121,299.88,77.1,NULL,NULL,NULL,NULL),(1927,121,399.88,79.2,NULL,NULL,NULL,NULL),(1928,121,499.88,79.9,NULL,NULL,NULL,NULL),(1929,121,699.88,81.7,NULL,NULL,NULL,NULL),(1930,121,999.88,82.4,NULL,NULL,NULL,NULL),(1931,122,1,46.1,NULL,NULL,NULL,NULL),(1932,122,2,59.3,NULL,NULL,NULL,NULL),(1933,122,3,64.4,NULL,NULL,NULL,NULL),(1934,122,4,66.9,NULL,NULL,NULL,NULL),(1935,122,5,68.5,NULL,NULL,NULL,NULL),(1936,122,7,70.6,NULL,NULL,NULL,NULL),(1937,122,10,74,NULL,NULL,NULL,NULL),(1938,122,20,79.3,NULL,NULL,NULL,NULL),(1939,122,30,82.9,NULL,NULL,NULL,NULL),(1940,122,40,85.7,NULL,NULL,NULL,NULL),(1941,122,50,87.5,NULL,NULL,NULL,NULL),(1942,122,70,90,NULL,NULL,NULL,NULL),(1943,122,100,93.4,NULL,NULL,NULL,NULL),(1944,122,200,92.9,NULL,NULL,NULL,NULL),(1945,122,300,97.7,NULL,NULL,NULL,NULL),(1946,122,400,89.8,NULL,NULL,NULL,NULL),(1947,122,500,93.2,NULL,NULL,NULL,NULL),(1948,122,700,98.7,NULL,NULL,NULL,NULL),(1949,122,1000,105.5,NULL,NULL,NULL,NULL),(1950,123,1,35,NULL,NULL,NULL,NULL),(1951,123,2,41.8,NULL,NULL,NULL,NULL),(1952,123,3,43,NULL,NULL,NULL,NULL),(1953,123,4,44.2,NULL,NULL,NULL,NULL),(1954,123,5,45.3,NULL,NULL,NULL,NULL),(1955,123,7,46.6,NULL,NULL,NULL,NULL),(1956,123,10,48,NULL,NULL,NULL,NULL),(1957,123,20,50.1,NULL,NULL,NULL,NULL),(1958,123,30,51.7,NULL,NULL,NULL,NULL),(1959,123,40,53.6,NULL,NULL,NULL,NULL),(1960,123,50,54.5,NULL,NULL,NULL,NULL),(1961,123,70,55.9,NULL,NULL,NULL,NULL),(1962,123,100,58.1,NULL,NULL,NULL,NULL),(1963,123,200,61.7,NULL,NULL,NULL,NULL),(1964,123,300,64.9,NULL,NULL,NULL,NULL),(1965,123,400,65.6,NULL,NULL,NULL,NULL),(1966,123,500,67,NULL,NULL,NULL,NULL),(1967,123,700,69.4,NULL,NULL,NULL,NULL),(1968,123,1000,71.5,NULL,NULL,NULL,NULL),(1969,124,0.88,33.7,NULL,NULL,NULL,NULL),(1970,124,1.88,39.9,NULL,NULL,NULL,NULL),(1971,124,2.88,41.9,NULL,NULL,NULL,NULL),(1972,124,3.88,43.8,NULL,NULL,NULL,NULL),(1973,124,4.88,44.5,NULL,NULL,NULL,NULL),(1974,124,6.88,46.1,NULL,NULL,NULL,NULL),(1975,124,9.88,47.7,NULL,NULL,NULL,NULL),(1976,124,19.88,50.9,NULL,NULL,NULL,NULL),(1977,124,29.88,52.9,NULL,NULL,NULL,NULL),(1978,124,39.88,54.8,NULL,NULL,NULL,NULL),(1979,124,49.88,55.9,NULL,NULL,NULL,NULL),(1980,124,69.88,57.7,NULL,NULL,NULL,NULL),(1981,124,99.88,60,NULL,NULL,NULL,NULL),(1982,124,199.88,64.3,NULL,NULL,NULL,NULL),(1983,124,299.88,67.9,NULL,NULL,NULL,NULL),(1984,124,399.88,70.7,NULL,NULL,NULL,NULL),(1985,124,499.88,71.8,NULL,NULL,NULL,NULL),(1986,124,699.88,75.1,NULL,NULL,NULL,NULL),(1987,124,999.88,78.3,NULL,NULL,NULL,NULL),(1988,125,0.88,26.6,NULL,NULL,NULL,NULL),(1989,125,1.88,32,NULL,NULL,NULL,NULL),(1990,125,2.88,34.1,NULL,NULL,NULL,NULL),(1991,125,3.88,34.8,NULL,NULL,NULL,NULL),(1992,125,4.88,35.8,NULL,NULL,NULL,NULL),(1993,125,6.88,37,NULL,NULL,NULL,NULL),(1994,125,9.88,38.4,NULL,NULL,NULL,NULL),(1995,125,19.88,41.6,NULL,NULL,NULL,NULL),(1996,125,29.88,44.4,NULL,NULL,NULL,NULL),(1997,125,39.88,45.8,NULL,NULL,NULL,NULL),(1998,125,49.88,47.3,NULL,NULL,NULL,NULL),(1999,125,69.88,49.2,NULL,NULL,NULL,NULL),(2000,125,99.88,53.5,NULL,NULL,NULL,NULL),(2001,125,199.88,52.7,NULL,NULL,NULL,NULL),(2002,125,299.88,57.5,NULL,NULL,NULL,NULL),(2003,125,399.88,62,NULL,NULL,NULL,NULL),(2004,125,499.88,66.4,NULL,NULL,NULL,NULL),(2005,125,699.88,71.2,NULL,NULL,NULL,NULL),(2006,125,999.88,77.7,NULL,NULL,NULL,NULL),(2007,126,0.88,27.8,NULL,NULL,NULL,NULL),(2008,126,1.88,35.9,NULL,NULL,NULL,NULL),(2009,126,2.88,37,NULL,NULL,NULL,NULL),(2010,126,3.88,38.6,NULL,NULL,NULL,NULL),(2011,126,4.88,39.1,NULL,NULL,NULL,NULL),(2012,126,6.88,40.2,NULL,NULL,NULL,NULL),(2013,126,9.88,41.1,NULL,NULL,NULL,NULL),(2014,126,19.88,42.7,NULL,NULL,NULL,NULL),(2015,126,29.88,43.8,NULL,NULL,NULL,NULL),(2016,126,39.88,44.3,NULL,NULL,NULL,NULL),(2017,126,49.88,44.7,NULL,NULL,NULL,NULL),(2018,126,69.88,45.6,NULL,NULL,NULL,NULL),(2019,126,99.88,46.6,NULL,NULL,NULL,NULL),(2020,126,199.88,47.9,NULL,NULL,NULL,NULL),(2021,126,299.88,48.8,NULL,NULL,NULL,NULL),(2022,126,399.88,49.8,NULL,NULL,NULL,NULL),(2023,126,499.88,50.2,NULL,NULL,NULL,NULL),(2024,126,699.88,50.9,NULL,NULL,NULL,NULL),(2025,126,999.88,51.8,NULL,NULL,NULL,NULL),(2026,127,9,28.6,NULL,NULL,NULL,NULL),(2027,127,18,32.7,NULL,NULL,NULL,NULL),(2028,127,27,32.7,NULL,NULL,NULL,NULL),(2029,127,37,33.8,NULL,NULL,NULL,NULL),(2030,127,43,32.7,NULL,NULL,NULL,NULL),(2031,127,50,33.1,NULL,NULL,NULL,NULL),(2032,127,67,33.1,NULL,NULL,NULL,NULL),(2033,127,80,35.5,NULL,NULL,NULL,NULL),(2034,127,94,38.2,NULL,NULL,NULL,NULL),(2035,127,100,38.2,NULL,NULL,NULL,NULL),(2036,127,120,37.2,NULL,NULL,NULL,NULL),(2037,127,130,35.5,NULL,NULL,NULL,NULL),(2038,127,150,33.8,NULL,NULL,NULL,NULL),(2039,127,180,34.8,NULL,NULL,NULL,NULL),(2040,127,210,35.5,NULL,NULL,NULL,NULL),(2041,127,250,42.4,NULL,NULL,NULL,NULL),(2042,127,290,37.2,NULL,NULL,NULL,NULL),(2043,127,330,42.4,NULL,NULL,NULL,NULL),(2044,127,380,40.7,NULL,NULL,NULL,NULL),(2045,127,430,40.7,NULL,NULL,NULL,NULL),(2046,127,470,42.4,NULL,NULL,NULL,NULL),(2047,127,500,45.1,NULL,NULL,NULL,NULL),(2048,127,570,45.8,NULL,NULL,NULL,NULL),(2049,127,600,51.1,NULL,NULL,NULL,NULL),(2050,127,660,45.8,NULL,NULL,NULL,NULL),(2051,127,743,45.8,NULL,NULL,NULL,NULL),(2052,128,9,35.7,NULL,NULL,NULL,NULL),(2053,128,18,39.1,NULL,NULL,NULL,NULL),(2054,128,27,42.6,NULL,NULL,NULL,NULL),(2055,128,37,47.7,NULL,NULL,NULL,NULL),(2056,128,43,47.7,NULL,NULL,NULL,NULL),(2057,128,50,49.5,NULL,NULL,NULL,NULL),(2058,128,67,52.9,NULL,NULL,NULL,NULL),(2059,128,80,56.4,NULL,NULL,NULL,NULL),(2060,128,94,58.2,NULL,NULL,NULL,NULL),(2061,128,100,58.1,NULL,NULL,NULL,NULL),(2062,128,120,57.4,NULL,NULL,NULL,NULL),(2063,128,130,59.8,NULL,NULL,NULL,NULL),(2064,128,150,59.8,NULL,NULL,NULL,NULL),(2065,128,180,63.3,NULL,NULL,NULL,NULL),(2066,128,210,66.7,NULL,NULL,NULL,NULL),(2067,128,250,67.8,NULL,NULL,NULL,NULL),(2068,128,290,75.4,NULL,NULL,NULL,NULL),(2069,128,330,77.1,NULL,NULL,NULL,NULL),(2070,128,380,80.5,NULL,NULL,NULL,NULL),(2071,128,430,82.3,NULL,NULL,NULL,NULL),(2072,128,470,84,NULL,NULL,NULL,NULL),(2073,128,500,87.4,NULL,NULL,NULL,NULL),(2074,128,570,89.2,NULL,NULL,NULL,NULL),(2075,128,600,87.4,NULL,NULL,NULL,NULL),(2076,128,660,89.2,NULL,NULL,NULL,NULL),(2077,128,743,94.3,NULL,NULL,NULL,NULL),(2078,129,9,50.9,NULL,NULL,NULL,NULL),(2079,129,18,58.9,NULL,NULL,NULL,NULL),(2080,129,27,64.7,NULL,NULL,NULL,NULL),(2081,129,37,69.9,NULL,NULL,NULL,NULL),(2082,129,43,66.4,NULL,NULL,NULL,NULL),(2083,129,50,73.4,NULL,NULL,NULL,NULL),(2084,129,67,75.1,NULL,NULL,NULL,NULL),(2085,129,80,80.3,NULL,NULL,NULL,NULL),(2086,129,94,80.5,NULL,NULL,NULL,NULL),(2087,129,100,80.9,NULL,NULL,NULL,NULL),(2088,129,120,82,NULL,NULL,NULL,NULL),(2089,129,130,83.7,NULL,NULL,NULL,NULL),(2090,129,150,85.4,NULL,NULL,NULL,NULL),(2091,129,180,90.6,NULL,NULL,NULL,NULL),(2092,129,210,92.3,NULL,NULL,NULL,NULL),(2093,129,250,95.8,NULL,NULL,NULL,NULL),(2094,129,290,95.8,NULL,NULL,NULL,NULL),(2095,129,330,97.5,NULL,NULL,NULL,NULL),(2096,129,380,97.5,NULL,NULL,NULL,NULL),(2097,129,430,102.7,NULL,NULL,NULL,NULL),(2098,129,470,106.1,NULL,NULL,NULL,NULL),(2099,129,500,109.6,NULL,NULL,NULL,NULL),(2100,129,570,116.5,NULL,NULL,NULL,NULL),(2101,129,600,118.2,NULL,NULL,NULL,NULL),(2102,129,660,126.9,NULL,NULL,NULL,NULL),(2103,129,743,125.8,NULL,NULL,NULL,NULL),(2104,130,8,28.6,NULL,NULL,NULL,NULL),(2105,130,19,31.2,NULL,NULL,NULL,NULL),(2106,130,32,32,NULL,NULL,NULL,NULL),(2107,130,42,33.8,NULL,NULL,NULL,NULL),(2108,130,47,32.5,NULL,NULL,NULL,NULL),(2109,130,68,36.3,NULL,NULL,NULL,NULL),(2110,130,77,35.5,NULL,NULL,NULL,NULL),(2111,130,95,38.1,NULL,NULL,NULL,NULL),(2112,130,100,37.2,NULL,NULL,NULL,NULL),(2113,130,113,36.3,NULL,NULL,NULL,NULL),(2114,130,129,37.7,NULL,NULL,NULL,NULL),(2115,130,148,36.3,NULL,NULL,NULL,NULL),(2116,130,180,39.8,NULL,NULL,NULL,NULL),(2117,130,207,40.7,NULL,NULL,NULL,NULL),(2118,130,245,43.2,NULL,NULL,NULL,NULL),(2119,130,280,39.8,NULL,NULL,NULL,NULL),(2120,130,316,41.5,NULL,NULL,NULL,NULL),(2121,130,362,41.5,NULL,NULL,NULL,NULL),(2122,130,413,41.5,NULL,NULL,NULL,NULL),(2123,130,455,44.1,NULL,NULL,NULL,NULL),(2124,130,497,44.1,NULL,NULL,NULL,NULL),(2125,130,571,46.7,NULL,NULL,NULL,NULL),(2126,130,597,48.1,NULL,NULL,NULL,NULL),(2127,130,655,46.7,NULL,NULL,NULL,NULL),(2128,130,736,46.7,NULL,NULL,NULL,NULL),(2129,131,8,40,NULL,NULL,NULL,NULL),(2130,131,19,46,NULL,NULL,NULL,NULL),(2131,131,32,48.3,NULL,NULL,NULL,NULL),(2132,131,42,51.2,NULL,NULL,NULL,NULL),(2133,131,47,51.2,NULL,NULL,NULL,NULL),(2134,131,68,53.8,NULL,NULL,NULL,NULL),(2135,131,77,53.8,NULL,NULL,NULL,NULL),(2136,131,95,56.4,NULL,NULL,NULL,NULL),(2137,131,100,57.2,NULL,NULL,NULL,NULL),(2138,131,113,59,NULL,NULL,NULL,NULL),(2139,131,129,59.8,NULL,NULL,NULL,NULL),(2140,131,148,62.4,NULL,NULL,NULL,NULL),(2141,131,180,65.9,NULL,NULL,NULL,NULL),(2142,131,207,67.6,NULL,NULL,NULL,NULL),(2143,131,245,67.2,NULL,NULL,NULL,NULL),(2144,131,280,71.9,NULL,NULL,NULL,NULL),(2145,131,316,73.6,NULL,NULL,NULL,NULL),(2146,131,368,76.2,NULL,NULL,NULL,NULL),(2147,131,413,77.1,NULL,NULL,NULL,NULL),(2148,131,455,80.5,NULL,NULL,NULL,NULL),(2149,131,497,81.4,NULL,NULL,NULL,NULL),(2150,131,571,84.5,NULL,NULL,NULL,NULL),(2151,131,597,84,NULL,NULL,NULL,NULL),(2152,131,655,85.7,NULL,NULL,NULL,NULL),(2153,131,736,88.3,NULL,NULL,NULL,NULL),(2154,132,8,57.8,NULL,NULL,NULL,NULL),(2155,132,19,67,NULL,NULL,NULL,NULL),(2156,132,32,69,NULL,NULL,NULL,NULL),(2157,132,42,71.6,NULL,NULL,NULL,NULL),(2158,132,47,73.4,NULL,NULL,NULL,NULL),(2159,132,68,82,NULL,NULL,NULL,NULL),(2160,132,77,82,NULL,NULL,NULL,NULL),(2161,132,95,84.9,NULL,NULL,NULL,NULL),(2162,132,100,87.2,NULL,NULL,NULL,NULL),(2163,132,113,88.9,NULL,NULL,NULL,NULL),(2164,132,129,89.7,NULL,NULL,NULL,NULL),(2165,132,148,94.1,NULL,NULL,NULL,NULL),(2166,132,180,95.8,NULL,NULL,NULL,NULL),(2167,132,207,100.1,NULL,NULL,NULL,NULL),(2168,132,245,103.2,NULL,NULL,NULL,NULL),(2169,132,280,105.3,NULL,NULL,NULL,NULL),(2170,132,316,108.4,NULL,NULL,NULL,NULL),(2171,132,368,111.3,NULL,NULL,NULL,NULL),(2172,132,413,116.5,NULL,NULL,NULL,NULL),(2173,132,455,115.6,NULL,NULL,NULL,NULL),(2174,132,497,120,NULL,NULL,NULL,NULL),(2175,132,571,122.9,NULL,NULL,NULL,NULL),(2176,132,597,126.3,NULL,NULL,NULL,NULL),(2177,132,655,132,NULL,NULL,NULL,NULL),(2178,132,736,132.6,NULL,NULL,NULL,NULL),(2179,133,8,27.5,NULL,NULL,NULL,NULL),(2180,133,17,30.4,NULL,NULL,NULL,NULL),(2181,133,26,31.6,NULL,NULL,NULL,NULL),(2182,133,36,32.8,NULL,NULL,NULL,NULL),(2183,133,42,32.2,NULL,NULL,NULL,NULL),(2184,133,47,33.9,NULL,NULL,NULL,NULL),(2185,133,68,35.1,NULL,NULL,NULL,NULL),(2186,133,77,36.6,NULL,NULL,NULL,NULL),(2187,133,94,37.8,NULL,NULL,NULL,NULL),(2188,133,100,37.4,NULL,NULL,NULL,NULL),(2189,133,113,37.1,NULL,NULL,NULL,NULL),(2190,133,129,38.6,NULL,NULL,NULL,NULL),(2191,133,148,37.8,NULL,NULL,NULL,NULL),(2192,133,180,39.2,NULL,NULL,NULL,NULL),(2193,133,210,40.4,NULL,NULL,NULL,NULL),(2194,133,245,41.3,NULL,NULL,NULL,NULL),(2195,133,280,41.3,NULL,NULL,NULL,NULL),(2196,133,316,42.1,NULL,NULL,NULL,NULL),(2197,133,374,43.3,NULL,NULL,NULL,NULL),(2198,133,415,42.1,NULL,NULL,NULL,NULL),(2199,133,455,44.4,NULL,NULL,NULL,NULL),(2200,133,497,44.1,NULL,NULL,NULL,NULL),(2201,133,577,45.6,NULL,NULL,NULL,NULL),(2202,133,597,47.1,NULL,NULL,NULL,NULL),(2203,133,655,45.6,NULL,NULL,NULL,NULL),(2204,133,736,46,NULL,NULL,NULL,NULL),(2205,134,8,41.1,NULL,NULL,NULL,NULL),(2206,134,17,43.4,NULL,NULL,NULL,NULL),(2207,134,42,46.9,NULL,NULL,NULL,NULL),(2208,134,47,49.9,NULL,NULL,NULL,NULL),(2209,134,68,51,NULL,NULL,NULL,NULL),(2210,134,77,51.6,NULL,NULL,NULL,NULL),(2211,134,94,54.5,NULL,NULL,NULL,NULL),(2212,134,100,53.9,NULL,NULL,NULL,NULL),(2213,134,113,55.7,NULL,NULL,NULL,NULL),(2214,134,129,57.2,NULL,NULL,NULL,NULL),(2215,134,148,58.4,NULL,NULL,NULL,NULL),(2216,134,180,60.7,NULL,NULL,NULL,NULL),(2217,134,210,61.5,NULL,NULL,NULL,NULL),(2218,134,245,63.3,NULL,NULL,NULL,NULL),(2219,134,280,65.6,NULL,NULL,NULL,NULL),(2220,134,316,66.8,NULL,NULL,NULL,NULL),(2221,134,374,68.9,NULL,NULL,NULL,NULL),(2222,134,415,68,NULL,NULL,NULL,NULL),(2223,134,455,69.1,NULL,NULL,NULL,NULL),(2224,134,497,72.4,NULL,NULL,NULL,NULL),(2225,134,577,75,NULL,NULL,NULL,NULL),(2226,134,597,76.2,NULL,NULL,NULL,NULL),(2227,134,655,77.1,NULL,NULL,NULL,NULL),(2228,134,736,80.6,NULL,NULL,NULL,NULL),(2229,135,17,46.3,NULL,NULL,NULL,NULL),(2230,135,26,48.1,NULL,NULL,NULL,NULL),(2231,135,36,51,NULL,NULL,NULL,NULL),(2232,135,42,50.7,NULL,NULL,NULL,NULL),(2233,135,47,53.7,NULL,NULL,NULL,NULL),(2234,135,68,56.3,NULL,NULL,NULL,NULL),(2235,135,77,58,NULL,NULL,NULL,NULL),(2236,135,94,61,NULL,NULL,NULL,NULL),(2237,135,100,61,NULL,NULL,NULL,NULL),(2238,135,113,62.1,NULL,NULL,NULL,NULL),(2239,135,129,63.9,NULL,NULL,NULL,NULL),(2240,135,148,65.6,NULL,NULL,NULL,NULL),(2241,135,180,69.4,NULL,NULL,NULL,NULL),(2242,135,210,71.5,NULL,NULL,NULL,NULL),(2243,135,245,73.8,NULL,NULL,NULL,NULL),(2244,135,280,76.2,NULL,NULL,NULL,NULL),(2245,135,316,78.5,NULL,NULL,NULL,NULL),(2246,135,374,79.9,NULL,NULL,NULL,NULL),(2247,135,415,82.6,NULL,NULL,NULL,NULL),(2248,135,455,84.1,NULL,NULL,NULL,NULL),(2249,135,497,85.3,NULL,NULL,NULL,NULL),(2250,135,577,88.4,NULL,NULL,NULL,NULL),(2251,135,597,89,NULL,NULL,NULL,NULL),(2252,135,655,89,NULL,NULL,NULL,NULL),(2253,135,736,93.7,NULL,NULL,NULL,NULL),(2254,136,8,54.2,NULL,NULL,NULL,NULL),(2255,136,17,59.8,NULL,NULL,NULL,NULL),(2256,136,26,64.1,NULL,NULL,NULL,NULL),(2257,136,36,65.3,NULL,NULL,NULL,NULL),(2258,136,42,68.2,NULL,NULL,NULL,NULL),(2259,136,47,70.5,NULL,NULL,NULL,NULL),(2260,136,68,75.8,NULL,NULL,NULL,NULL),(2261,136,77,77.6,NULL,NULL,NULL,NULL),(2262,136,94,81.3,NULL,NULL,NULL,NULL),(2263,136,100,81.3,NULL,NULL,NULL,NULL),(2264,136,113,84,NULL,NULL,NULL,NULL),(2265,136,129,86.3,NULL,NULL,NULL,NULL),(2266,136,148,89.2,NULL,NULL,NULL,NULL),(2267,136,180,93.9,NULL,NULL,NULL,NULL),(2268,136,210,96,NULL,NULL,NULL,NULL),(2269,136,245,99.2,NULL,NULL,NULL,NULL),(2270,136,280,101.5,NULL,NULL,NULL,NULL),(2271,136,316,103.3,NULL,NULL,NULL,NULL),(2272,136,374,105,NULL,NULL,NULL,NULL),(2273,136,415,108.5,NULL,NULL,NULL,NULL),(2274,136,455,109.7,NULL,NULL,NULL,NULL),(2275,136,497,113.2,NULL,NULL,NULL,NULL),(2276,136,577,115.6,NULL,NULL,NULL,NULL),(2277,136,597,116.7,NULL,NULL,NULL,NULL),(2278,136,655,120.2,NULL,NULL,NULL,NULL),(2279,136,736,123.7,NULL,NULL,NULL,NULL),(2280,137,1,33.5,NULL,NULL,NULL,NULL),(2281,137,3,36.2,NULL,NULL,NULL,NULL),(2282,137,7,37.1,NULL,NULL,NULL,NULL),(2283,137,14,41.7,NULL,NULL,NULL,NULL),(2284,137,18,85.8,NULL,1,NULL,NULL),(2285,137,31,46.2,NULL,NULL,NULL,NULL),(2286,137,50,48.9,NULL,NULL,NULL,NULL),(2287,137,66,50.7,NULL,NULL,NULL,NULL),(2288,137,85,51.6,NULL,NULL,NULL,NULL),(2289,137,107,52.5,NULL,NULL,NULL,NULL),(2290,137,144,56.2,NULL,NULL,NULL,NULL),(2291,137,180,56.2,NULL,NULL,NULL,NULL),(2292,138,1,48.9,NULL,NULL,NULL,NULL),(2293,138,3,58,NULL,NULL,NULL,NULL),(2294,138,7,64.3,NULL,NULL,NULL,NULL),(2295,138,14,69.8,NULL,NULL,NULL,NULL),(2296,138,18,70.7,NULL,NULL,NULL,NULL),(2297,138,31,78.8,NULL,NULL,NULL,NULL),(2298,138,50,84.3,NULL,NULL,NULL,NULL),(2299,138,66,87,NULL,NULL,NULL,NULL),(2300,138,85,90.6,NULL,NULL,NULL,NULL),(2301,138,107,92.4,NULL,NULL,NULL,NULL),(2302,138,144,96,NULL,NULL,NULL,NULL),(2303,138,180,96.9,NULL,NULL,NULL,NULL),(2304,139,1,63.4,NULL,NULL,NULL,NULL),(2305,139,3,76.1,NULL,NULL,NULL,NULL),(2306,139,7,86.1,NULL,NULL,NULL,NULL),(2307,139,14,95.2,NULL,NULL,NULL,NULL),(2308,139,18,97,NULL,NULL,NULL,NULL),(2309,139,31,105.1,NULL,NULL,NULL,NULL),(2310,139,50,110.6,NULL,NULL,NULL,NULL),(2311,139,66,118.7,NULL,NULL,NULL,NULL),(2312,139,85,123.2,NULL,NULL,NULL,NULL),(2313,139,107,127.8,NULL,NULL,NULL,NULL),(2314,139,144,128.7,NULL,NULL,NULL,NULL),(2315,139,180,129.6,NULL,NULL,NULL,NULL),(2316,140,1,87,NULL,NULL,NULL,NULL),(2317,140,3,108.7,NULL,NULL,NULL,NULL),(2318,140,7,121.4,NULL,NULL,NULL,NULL),(2319,140,14,125,NULL,NULL,NULL,NULL),(2320,140,18,128.7,NULL,NULL,NULL,NULL),(2321,140,31,135.9,NULL,NULL,NULL,NULL),(2322,140,50,139.5,NULL,NULL,NULL,NULL),(2323,140,66,143.2,NULL,NULL,NULL,NULL),(2324,140,85,146.8,NULL,NULL,NULL,NULL),(2325,140,107,148.6,NULL,NULL,NULL,NULL),(2326,140,144,150.4,NULL,NULL,NULL,NULL),(2327,140,180,150.4,NULL,NULL,NULL,NULL),(2328,141,1,100.6,NULL,NULL,NULL,NULL),(2329,141,3,121.4,NULL,NULL,NULL,NULL),(2330,141,7,128.7,NULL,NULL,NULL,NULL),(2331,141,14,129.6,NULL,NULL,NULL,NULL),(2332,141,18,138.6,NULL,NULL,NULL,NULL),(2333,141,31,135.9,NULL,NULL,NULL,NULL),(2334,141,50,143.2,NULL,NULL,NULL,NULL),(2335,141,66,145.9,NULL,NULL,NULL,NULL),(2336,141,85,148.6,NULL,NULL,NULL,NULL),(2337,141,107,146.8,NULL,NULL,NULL,NULL),(2338,141,144,153.1,NULL,NULL,NULL,NULL),(2339,141,180,157.7,NULL,NULL,NULL,NULL),(2340,142,0.1,32,NULL,NULL,NULL,NULL),(2341,142,2.7,40.6,NULL,NULL,NULL,NULL),(2342,142,4.8,43,NULL,NULL,NULL,NULL),(2343,142,11.1,49.1,NULL,NULL,NULL,NULL),(2344,142,19.1,55.9,NULL,NULL,NULL,NULL),(2345,142,33.5,60,NULL,NULL,NULL,NULL),(2346,142,103,66.9,NULL,NULL,NULL,NULL),(2347,142,236,79.8,NULL,NULL,NULL,NULL),(2348,142,403,83.6,NULL,NULL,NULL,NULL),(2349,143,1,27.8,NULL,NULL,NULL,NULL),(2350,143,1.3,29.4,NULL,NULL,NULL,NULL),(2351,143,2,29.8,NULL,NULL,NULL,NULL),(2352,143,3.1,29.8,NULL,NULL,NULL,NULL),(2353,143,4.1,30.8,NULL,NULL,NULL,NULL),(2354,143,9.9,30.7,NULL,NULL,NULL,NULL),(2355,143,11.2,30.7,NULL,NULL,NULL,NULL),(2356,143,21.2,32.9,NULL,NULL,NULL,NULL),(2357,143,31.3,31.7,NULL,NULL,NULL,NULL),(2358,143,42.5,34.8,NULL,NULL,NULL,NULL),(2359,143,51.6,34.4,NULL,NULL,NULL,NULL),(2360,143,62.1,34.7,NULL,NULL,NULL,NULL),(2361,143,92.4,38.2,NULL,NULL,NULL,NULL),(2362,143,136,38.1,NULL,NULL,NULL,NULL),(2363,143,212,41.5,NULL,NULL,NULL,NULL),(2364,143,282,41.9,NULL,NULL,NULL,NULL),(2365,143,402,46.5,NULL,NULL,NULL,NULL),(2366,143,511,45.7,NULL,NULL,NULL,NULL),(2367,144,1,43.2,NULL,NULL,NULL,NULL),(2368,144,3,43.2,NULL,NULL,NULL,NULL),(2369,144,10,45.7,NULL,NULL,NULL,NULL),(2370,144,30,50.2,NULL,NULL,NULL,NULL),(2371,144,50,53.9,NULL,NULL,NULL,NULL),(2372,144,100,58.1,NULL,NULL,NULL,NULL),(2373,145,1,50.2,NULL,NULL,NULL,NULL),(2374,145,3,55,NULL,NULL,NULL,NULL),(2375,145,10,68.6,NULL,NULL,NULL,NULL),(2376,145,30,83.5,NULL,NULL,NULL,NULL),(2377,145,50,90.9,NULL,NULL,NULL,NULL),(2378,145,100,125.4,NULL,NULL,NULL,NULL),(2379,146,1,57,NULL,NULL,NULL,NULL),(2380,146,3,74,NULL,NULL,NULL,NULL),(2381,146,10,105.1,NULL,NULL,NULL,NULL),(2382,146,30,131.2,NULL,NULL,NULL,NULL),(2383,146,50,150.5,NULL,NULL,NULL,NULL),(2384,146,100,171.2,NULL,NULL,NULL,NULL),(2385,147,1,47.2,NULL,NULL,NULL,NULL),(2386,147,5,55.5,NULL,NULL,NULL,NULL),(2387,147,10,61.5,NULL,NULL,NULL,NULL),(2388,147,30,66.7,NULL,NULL,NULL,NULL),(2389,147,60,71.2,NULL,NULL,NULL,NULL),(2390,147,100,75.3,NULL,NULL,NULL,NULL),(2391,148,5,76.7,NULL,NULL,NULL,NULL),(2392,148,10,83.5,NULL,NULL,NULL,NULL),(2393,148,30,96.1,NULL,NULL,NULL,NULL),(2394,148,60,102.1,NULL,NULL,NULL,NULL),(2395,148,100,111.1,NULL,NULL,NULL,NULL),(2396,149,5,94,NULL,NULL,NULL,NULL),(2397,149,10,101.2,NULL,NULL,NULL,NULL),(2398,149,30,153.8,NULL,NULL,NULL,NULL),(2399,149,60,166.9,NULL,NULL,NULL,NULL),(2400,149,100,204.6,NULL,NULL,NULL,NULL),(2401,150,0.22,26,NULL,NULL,NULL,NULL),(2402,150,0.62,26.9,NULL,NULL,NULL,NULL),(2403,150,1.12,27.8,NULL,NULL,NULL,NULL),(2404,150,2.12,28.5,NULL,NULL,NULL,NULL),(2405,150,3.12,29.4,NULL,NULL,NULL,NULL),(2406,150,4.12,29.4,NULL,NULL,NULL,NULL),(2407,150,5.12,29.5,NULL,NULL,NULL,NULL),(2408,150,6.12,29.5,NULL,NULL,NULL,NULL),(2409,150,8.12,30,NULL,NULL,NULL,NULL),(2410,150,15.12,32.8,NULL,NULL,NULL,NULL),(2411,150,21.12,34,NULL,NULL,NULL,NULL),(2412,150,28.12,34.3,NULL,NULL,NULL,NULL),(2413,150,56.12,36.3,NULL,NULL,NULL,NULL),(2414,150,84.12,38.6,NULL,NULL,NULL,NULL),(2415,150,112.12,39.9,NULL,NULL,NULL,NULL),(2416,150,140.12,40.5,NULL,NULL,NULL,NULL),(2417,150,168.12,41.7,NULL,NULL,NULL,NULL),(2418,150,196.12,42.3,NULL,NULL,NULL,NULL),(2419,150,224.12,43.8,NULL,NULL,NULL,NULL),(2420,150,252.12,44.4,NULL,NULL,NULL,NULL),(2421,150,280.12,45.1,NULL,NULL,NULL,NULL),(2422,150,308.12,45.7,NULL,NULL,NULL,NULL),(2423,150,336.12,46.9,NULL,NULL,NULL,NULL),(2424,150,364.12,48,NULL,NULL,NULL,NULL),(2425,151,0.1,27.3,NULL,NULL,NULL,NULL),(2426,151,0.3,28.1,NULL,NULL,NULL,NULL),(2427,151,0.5,28.6,NULL,NULL,NULL,NULL),(2428,151,1,29.1,NULL,NULL,NULL,NULL),(2429,151,2,29.7,NULL,NULL,NULL,NULL),(2430,151,3,30.2,NULL,NULL,NULL,NULL),(2431,151,4,30,NULL,NULL,NULL,NULL),(2432,151,5,30,NULL,NULL,NULL,NULL),(2433,151,6,30.2,NULL,NULL,NULL,NULL),(2434,151,8,30.5,NULL,NULL,NULL,NULL),(2435,151,15,32.4,NULL,NULL,NULL,NULL),(2436,151,21,33.3,NULL,NULL,NULL,NULL),(2437,151,28,33.2,NULL,NULL,NULL,NULL),(2438,151,56,33.7,NULL,NULL,NULL,NULL),(2439,151,84,34.8,NULL,NULL,NULL,NULL),(2440,151,112,35.1,NULL,NULL,NULL,NULL),(2441,151,140,34.3,NULL,NULL,NULL,NULL),(2442,151,168,34.3,NULL,NULL,NULL,NULL),(2443,151,196,34.3,NULL,NULL,NULL,NULL),(2444,152,0.22,28.3,NULL,NULL,NULL,NULL),(2445,152,0.42,28.6,NULL,NULL,NULL,NULL),(2446,152,0.62,29.1,NULL,NULL,NULL,NULL),(2447,152,1.12,29.5,NULL,NULL,NULL,NULL),(2448,152,2.12,30.2,NULL,NULL,NULL,NULL),(2449,152,3.12,32.6,NULL,NULL,NULL,NULL),(2450,152,4.12,33.3,NULL,NULL,NULL,NULL),(2451,152,5.12,32.6,NULL,NULL,NULL,NULL),(2452,152,6.12,32.7,NULL,NULL,NULL,NULL),(2453,152,7.12,32.7,NULL,NULL,NULL,NULL),(2454,152,14.12,32.5,NULL,NULL,NULL,NULL),(2455,152,21.12,34.1,NULL,NULL,NULL,NULL),(2456,152,28.12,35.3,NULL,NULL,NULL,NULL),(2457,152,56.12,39.5,NULL,NULL,NULL,NULL),(2458,152,84.12,40.8,NULL,NULL,NULL,NULL),(2459,152,112.12,42.7,NULL,NULL,NULL,NULL),(2460,152,140.12,43.8,NULL,NULL,NULL,NULL),(2461,152,168.12,44.3,NULL,NULL,NULL,NULL),(2462,152,196.12,44.9,NULL,NULL,NULL,NULL),(2463,152,224.12,45.2,NULL,NULL,NULL,NULL),(2464,152,252.12,45.9,NULL,NULL,NULL,NULL),(2465,152,280.12,46.8,NULL,NULL,NULL,NULL),(2466,152,308.12,47.3,NULL,NULL,NULL,NULL),(2467,152,336.12,47.8,NULL,NULL,NULL,NULL),(2468,152,364.12,48.2,NULL,NULL,NULL,NULL),(2469,153,0.1,27.5,NULL,NULL,NULL,NULL),(2470,153,0.3,27.9,NULL,NULL,NULL,NULL),(2471,153,0.5,28.5,NULL,NULL,NULL,NULL),(2472,153,1,29.2,NULL,NULL,NULL,NULL),(2473,153,2,30.2,NULL,NULL,NULL,NULL),(2474,153,3,33,NULL,NULL,NULL,NULL),(2475,153,4,33.4,NULL,NULL,NULL,NULL),(2476,153,5,33.9,NULL,NULL,NULL,NULL),(2477,153,6,33.4,NULL,NULL,NULL,NULL),(2478,153,7,33.2,NULL,NULL,NULL,NULL),(2479,153,14,35.2,NULL,NULL,NULL,NULL),(2480,153,21,35.5,NULL,NULL,NULL,NULL),(2481,153,28,36.9,NULL,NULL,NULL,NULL),(2482,153,56,41.6,NULL,NULL,NULL,NULL),(2483,153,84,43.1,NULL,NULL,NULL,NULL),(2484,153,112,44.9,NULL,NULL,NULL,NULL),(2485,153,140,45.9,NULL,NULL,NULL,NULL),(2486,153,168,46.4,NULL,NULL,NULL,NULL),(2487,153,196,46.7,NULL,NULL,NULL,NULL),(2488,153,224,46.9,NULL,NULL,NULL,NULL),(2489,153,252,47.5,NULL,NULL,NULL,NULL),(2490,153,280,48.3,NULL,NULL,NULL,NULL),(2491,153,308,48.7,NULL,NULL,NULL,NULL),(2492,153,336,49,NULL,NULL,NULL,NULL),(2493,153,364,49.3,NULL,NULL,NULL,NULL),(2494,154,0.22,29.6,NULL,NULL,NULL,NULL),(2495,154,0.42,29.9,NULL,NULL,NULL,NULL),(2496,154,0.62,30.5,NULL,NULL,NULL,NULL),(2497,154,1.12,31,NULL,NULL,NULL,NULL),(2498,154,2.12,33,NULL,NULL,NULL,NULL),(2499,154,3.12,33,NULL,NULL,NULL,NULL),(2500,154,4.12,33.1,NULL,NULL,NULL,NULL),(2501,154,5.12,33.4,NULL,NULL,NULL,NULL),(2502,154,6.12,33.8,NULL,NULL,NULL,NULL),(2503,154,7.12,33.8,NULL,NULL,NULL,NULL),(2504,154,14.12,34.9,NULL,NULL,NULL,NULL),(2505,154,22.12,34.9,NULL,NULL,NULL,NULL),(2506,154,28.12,36.9,NULL,NULL,NULL,NULL),(2507,154,56.12,36.3,NULL,NULL,NULL,NULL),(2508,154,84.12,34.9,NULL,NULL,NULL,NULL),(2509,154,112.12,35.8,NULL,NULL,NULL,NULL),(2510,154,140.12,37,NULL,NULL,NULL,NULL),(2511,154,168.12,36.5,NULL,NULL,NULL,NULL),(2512,154,196.12,36.3,NULL,NULL,NULL,NULL),(2513,154,224.12,36.9,NULL,NULL,NULL,NULL),(2514,154,252.12,38.5,NULL,NULL,NULL,NULL),(2515,154,280.12,34.4,NULL,NULL,NULL,NULL),(2516,154,308.12,37.7,NULL,NULL,NULL,NULL),(2517,154,336.12,38.8,NULL,NULL,NULL,NULL),(2518,154,364.12,38.8,NULL,NULL,NULL,NULL),(2519,155,0.22,25.7,NULL,NULL,NULL,NULL),(2520,155,0.42,26,NULL,NULL,NULL,NULL),(2521,155,0.62,26.3,NULL,NULL,NULL,NULL),(2522,155,1.12,27,NULL,NULL,NULL,NULL),(2523,155,2.12,28.7,NULL,NULL,NULL,NULL),(2524,155,3.12,28.6,NULL,NULL,NULL,NULL),(2525,155,4.12,28.7,NULL,NULL,NULL,NULL),(2526,155,5.12,29,NULL,NULL,NULL,NULL),(2527,155,6.12,29.4,NULL,NULL,NULL,NULL),(2528,155,7.12,29.7,NULL,NULL,NULL,NULL),(2529,155,14.12,31.9,NULL,NULL,NULL,NULL),(2530,155,21.12,32.7,NULL,NULL,NULL,NULL),(2531,155,28.12,36.3,NULL,NULL,NULL,NULL),(2532,155,56.12,38.5,NULL,NULL,NULL,NULL),(2533,155,84.12,37.9,NULL,NULL,NULL,NULL),(2534,155,112.12,43.8,NULL,NULL,NULL,NULL),(2535,155,140.12,46.3,NULL,NULL,NULL,NULL),(2536,155,168.12,48.3,NULL,NULL,NULL,NULL),(2537,155,196.12,51.5,NULL,NULL,NULL,NULL),(2538,155,224.12,55.4,NULL,NULL,NULL,NULL),(2539,155,252.12,59.9,NULL,NULL,NULL,NULL),(2540,155,280.12,61.3,NULL,NULL,NULL,NULL),(2541,155,308.12,68.7,NULL,NULL,NULL,NULL),(2542,156,0.14,28.9,NULL,NULL,NULL,NULL),(2543,156,0.24,28.9,NULL,NULL,NULL,NULL),(2544,156,0.44,29.9,NULL,NULL,NULL,NULL),(2545,156,0.94,31.1,NULL,NULL,NULL,NULL),(2546,156,1.94,31.2,NULL,NULL,NULL,NULL),(2547,156,2.94,32.9,NULL,NULL,NULL,NULL),(2548,156,3.94,33.1,NULL,NULL,NULL,NULL),(2549,156,4.94,33.8,NULL,NULL,NULL,NULL),(2550,156,5.94,34.1,NULL,NULL,NULL,NULL),(2551,156,6.94,34.4,NULL,NULL,NULL,NULL),(2552,156,13.94,36.3,NULL,NULL,NULL,NULL),(2553,156,20.94,36.7,NULL,NULL,NULL,NULL),(2554,156,27.94,37.8,NULL,NULL,NULL,NULL),(2555,156,55.94,41.1,NULL,NULL,NULL,NULL),(2556,156,83.94,40.7,NULL,NULL,NULL,NULL),(2557,156,111.94,43.6,NULL,NULL,NULL,NULL),(2558,156,139.94,43.6,NULL,NULL,NULL,NULL),(2559,156,167.94,44.1,NULL,NULL,NULL,NULL),(2560,156,195.94,45.1,NULL,NULL,NULL,NULL),(2561,156,223.94,45.9,NULL,NULL,NULL,NULL),(2562,156,252.94,46.7,NULL,NULL,NULL,NULL),(2563,156,279.94,47,NULL,NULL,NULL,NULL),(2564,156,307.94,47.6,NULL,NULL,NULL,NULL),(2565,156,335.94,48.1,NULL,NULL,NULL,NULL),(2566,156,363.94,48.6,NULL,NULL,NULL,NULL),(2567,157,0.32,35,NULL,NULL,NULL,NULL),(2568,157,0.42,35.1,NULL,NULL,NULL,NULL),(2569,157,0.62,35.7,NULL,NULL,NULL,NULL),(2570,157,1.12,36.5,NULL,NULL,NULL,NULL),(2571,157,2.12,36.7,NULL,NULL,NULL,NULL),(2572,157,3.12,37.6,NULL,NULL,NULL,NULL),(2573,157,4.12,38.1,NULL,NULL,NULL,NULL),(2574,157,5.12,38.7,NULL,NULL,NULL,NULL),(2575,157,6.12,38.9,NULL,NULL,NULL,NULL),(2576,157,7.12,38.9,NULL,NULL,NULL,NULL),(2577,157,14.12,40.3,NULL,NULL,NULL,NULL),(2578,157,21.12,40.3,NULL,NULL,NULL,NULL),(2579,157,28.12,40.6,NULL,NULL,NULL,NULL),(2580,157,56.12,43,NULL,NULL,NULL,NULL),(2581,157,84.12,42.1,NULL,NULL,NULL,NULL),(2582,157,112.12,45.4,NULL,NULL,NULL,NULL),(2583,157,140.12,45.4,NULL,NULL,NULL,NULL),(2584,157,168.12,46.7,NULL,NULL,NULL,NULL),(2585,157,196.12,47.9,NULL,NULL,NULL,NULL),(2586,157,224.12,48,NULL,NULL,NULL,NULL),(2587,157,253.12,48.6,NULL,NULL,NULL,NULL),(2588,157,280.12,49.4,NULL,NULL,NULL,NULL),(2589,157,308.12,50.1,NULL,NULL,NULL,NULL),(2590,157,336.12,50.9,NULL,NULL,NULL,NULL),(2591,157,364.12,51.5,NULL,NULL,NULL,NULL),(2592,158,0.22,31,NULL,NULL,NULL,NULL),(2593,158,0.42,31.8,NULL,NULL,NULL,NULL),(2594,158,0.62,32.7,NULL,NULL,NULL,NULL),(2595,158,1.12,34.3,NULL,NULL,NULL,NULL),(2596,158,2.12,36.3,NULL,NULL,NULL,NULL),(2597,158,3.12,37,NULL,NULL,NULL,NULL),(2598,158,4.12,37.6,NULL,NULL,NULL,NULL),(2599,158,5.12,38.3,NULL,NULL,NULL,NULL),(2600,158,6.12,39.3,NULL,NULL,NULL,NULL),(2601,158,7.12,39.7,NULL,NULL,NULL,NULL),(2602,158,14.12,42.5,NULL,NULL,NULL,NULL),(2603,158,21.12,42.8,NULL,NULL,NULL,NULL),(2604,158,28.12,44.7,NULL,NULL,NULL,NULL),(2605,158,56.12,48.4,NULL,NULL,NULL,NULL),(2606,158,84.12,50.4,NULL,NULL,NULL,NULL),(2607,158,112.12,52.6,NULL,NULL,NULL,NULL),(2608,158,140.12,53.7,NULL,NULL,NULL,NULL),(2609,158,168.12,54.9,NULL,NULL,NULL,NULL),(2610,158,196.12,55.2,NULL,NULL,NULL,NULL),(2611,158,224.12,57.3,NULL,NULL,NULL,NULL),(2612,158,252.12,58.6,NULL,NULL,NULL,NULL),(2613,158,280.12,60,NULL,NULL,NULL,NULL),(2614,158,308.12,61.8,NULL,NULL,NULL,NULL),(2615,158,336.12,63.9,NULL,NULL,NULL,NULL),(2616,159,0.22,36.8,NULL,NULL,NULL,NULL),(2617,159,0.42,37.9,NULL,NULL,NULL,NULL),(2618,159,0.62,39.1,NULL,NULL,NULL,NULL),(2619,159,1.12,41.3,NULL,NULL,NULL,NULL),(2620,159,2.12,44,NULL,NULL,NULL,NULL),(2621,159,3.12,44.9,NULL,NULL,NULL,NULL),(2622,159,4.12,45.7,NULL,NULL,NULL,NULL),(2623,159,5.12,46.6,NULL,NULL,NULL,NULL),(2624,159,6.12,47.8,NULL,NULL,NULL,NULL),(2625,159,7.12,48.4,NULL,NULL,NULL,NULL),(2626,159,14.12,51.8,NULL,NULL,NULL,NULL),(2627,159,21.12,51.9,NULL,NULL,NULL,NULL),(2628,159,28.12,54,NULL,NULL,NULL,NULL),(2629,159,56.12,58,NULL,NULL,NULL,NULL),(2630,159,84.12,60.4,NULL,NULL,NULL,NULL),(2631,159,112.12,62.7,NULL,NULL,NULL,NULL),(2632,159,140.12,63.6,NULL,NULL,NULL,NULL),(2633,159,168.12,64.6,NULL,NULL,NULL,NULL),(2634,159,196.12,65.1,NULL,NULL,NULL,NULL),(2635,159,224.12,66.5,NULL,NULL,NULL,NULL),(2636,159,252.12,67.4,NULL,NULL,NULL,NULL),(2637,159,280.12,68.1,NULL,NULL,NULL,NULL),(2638,159,308.12,69,NULL,NULL,NULL,NULL),(2639,159,336.12,69.8,NULL,NULL,NULL,NULL),(2640,159,364.12,70.4,NULL,NULL,NULL,NULL),(2641,160,0.22,26.5,NULL,NULL,NULL,NULL),(2642,160,0.42,27.2,NULL,NULL,NULL,NULL),(2643,160,0.62,28.7,NULL,NULL,NULL,NULL),(2644,160,1.12,29.9,NULL,NULL,NULL,NULL),(2645,160,2.12,31.4,NULL,NULL,NULL,NULL),(2646,160,3.12,32.7,NULL,NULL,NULL,NULL),(2647,160,4.12,33.6,NULL,NULL,NULL,NULL),(2648,160,5.12,34.1,NULL,NULL,NULL,NULL),(2649,160,6.12,34.8,NULL,NULL,NULL,NULL),(2650,160,7.12,34.9,NULL,NULL,NULL,NULL),(2651,160,14.12,37.9,NULL,NULL,NULL,NULL),(2652,160,21.12,39,NULL,NULL,NULL,NULL),(2653,160,28.12,40.6,NULL,NULL,NULL,NULL),(2654,160,56.12,44.5,NULL,NULL,NULL,NULL),(2655,160,84.12,47.5,NULL,NULL,NULL,NULL),(2656,160,112.12,49.6,NULL,NULL,NULL,NULL),(2657,161,0.1,34.4,NULL,NULL,NULL,NULL),(2658,161,0.2,35.6,NULL,NULL,NULL,NULL),(2659,161,0.3,36.2,NULL,NULL,NULL,NULL),(2660,161,0.5,36.9,NULL,NULL,NULL,NULL),(2661,161,0.7,37.5,NULL,NULL,NULL,NULL),(2662,161,1,38.5,NULL,NULL,NULL,NULL),(2663,161,2,40.3,NULL,NULL,NULL,NULL),(2664,161,3,41.4,NULL,NULL,NULL,NULL),(2665,161,5,43,NULL,NULL,NULL,NULL),(2666,161,7,44.4,NULL,NULL,NULL,NULL),(2667,161,10,46,NULL,NULL,NULL,NULL),(2668,161,14,47.7,NULL,NULL,NULL,NULL),(2669,161,21,50.2,NULL,NULL,NULL,NULL),(2670,161,28,51.9,NULL,NULL,NULL,NULL),(2671,161,42,54.6,NULL,NULL,NULL,NULL),(2672,161,56,56.9,NULL,NULL,NULL,NULL),(2673,161,70,58.7,NULL,NULL,NULL,NULL),(2674,161,91,60.8,NULL,NULL,NULL,NULL),(2675,161,119,63,NULL,NULL,NULL,NULL),(2676,161,175,66.7,NULL,NULL,NULL,NULL),(2677,161,273,70.6,NULL,NULL,NULL,NULL),(2678,161,360,72.3,NULL,NULL,NULL,NULL),(2679,161,542,75.1,NULL,NULL,NULL,NULL),(2680,161,724,77,NULL,NULL,NULL,NULL),(2681,161,1101,79.2,NULL,NULL,NULL,NULL),(2682,161,1315,79.8,NULL,NULL,NULL,NULL),(2683,162,0.1,32.7,NULL,NULL,NULL,NULL),(2684,162,0.2,33.8,NULL,NULL,NULL,NULL),(2685,162,0.5,35,NULL,NULL,NULL,NULL),(2686,162,1,36.5,NULL,NULL,NULL,NULL),(2687,162,1.5,37.5,NULL,NULL,NULL,NULL),(2688,162,2,38.3,NULL,NULL,NULL,NULL),(2689,162,4,40.5,NULL,NULL,NULL,NULL),(2690,162,7,42.4,NULL,NULL,NULL,NULL),(2691,162,10,43.9,NULL,NULL,NULL,NULL),(2692,162,14,45.2,NULL,NULL,NULL,NULL),(2693,162,21,47,NULL,NULL,NULL,NULL),(2694,162,28,48.7,NULL,NULL,NULL,NULL),(2695,162,42,50.8,NULL,NULL,NULL,NULL),(2696,162,70,54.3,NULL,NULL,NULL,NULL),(2697,162,91,55.9,NULL,NULL,NULL,NULL),(2698,162,175,60.6,NULL,NULL,NULL,NULL),(2699,162,273,63.5,NULL,NULL,NULL,NULL),(2700,162,360,64.7,NULL,NULL,NULL,NULL),(2701,162,472,66.6,NULL,NULL,NULL,NULL),(2702,162,542,67.2,NULL,NULL,NULL,NULL),(2703,162,724,69,NULL,NULL,NULL,NULL),(2704,162,923,70.3,NULL,NULL,NULL,NULL),(2705,162,1101,71.3,NULL,NULL,NULL,NULL),(2706,162,1315,72.2,NULL,NULL,NULL,NULL),(2707,163,0.01,30.9,NULL,NULL,NULL,NULL),(2708,163,0.11,31.6,NULL,NULL,NULL,NULL),(2709,163,0.41,32.1,NULL,NULL,NULL,NULL),(2710,163,0.91,32.8,NULL,NULL,NULL,NULL),(2711,163,1.41,33.3,NULL,NULL,NULL,NULL),(2712,163,1.91,33.6,NULL,NULL,NULL,NULL),(2713,163,3.91,34.9,NULL,NULL,NULL,NULL),(2714,163,6.91,36.3,NULL,NULL,NULL,NULL),(2715,163,9.91,37.3,NULL,NULL,NULL,NULL),(2716,163,13.91,38.3,NULL,NULL,NULL,NULL),(2717,163,20.91,39.7,NULL,NULL,NULL,NULL),(2718,163,27.91,40.6,NULL,NULL,NULL,NULL),(2719,163,41.91,41.9,NULL,NULL,NULL,NULL),(2720,163,69.91,44,NULL,NULL,NULL,NULL),(2721,163,90.91,45.4,NULL,NULL,NULL,NULL),(2722,163,174.91,48.8,NULL,NULL,NULL,NULL),(2723,163,272.91,51.7,NULL,NULL,NULL,NULL),(2724,163,359.91,52.9,NULL,NULL,NULL,NULL),(2725,163,471.91,54.1,NULL,NULL,NULL,NULL),(2726,163,541.91,54.6,NULL,NULL,NULL,NULL),(2727,163,723.91,56.9,NULL,NULL,NULL,NULL),(2728,163,922.91,58.6,NULL,NULL,NULL,NULL),(2729,163,1100.91,60.1,NULL,NULL,NULL,NULL),(2730,163,1314.91,60.9,NULL,NULL,NULL,NULL),(2731,164,1,21.8,NULL,NULL,NULL,NULL),(2732,164,4.8,23.2,NULL,NULL,NULL,NULL),(2733,164,5.8,23.2,NULL,NULL,NULL,NULL),(2734,164,7,23.2,NULL,NULL,NULL,NULL),(2735,164,8,23.2,NULL,NULL,NULL,NULL),(2736,164,9,23.4,NULL,NULL,NULL,NULL),(2737,164,12,23.9,NULL,NULL,NULL,NULL),(2738,164,14.2,23.4,NULL,NULL,NULL,NULL),(2739,164,15.9,23.4,NULL,NULL,NULL,NULL),(2740,164,19,23.7,NULL,NULL,NULL,NULL),(2741,164,21,24.2,NULL,NULL,NULL,NULL),(2742,164,21.9,24.7,NULL,NULL,NULL,NULL),(2743,164,26,24.9,NULL,NULL,NULL,NULL),(2744,164,30.9,24.2,NULL,NULL,NULL,NULL),(2745,164,37,24.9,NULL,NULL,NULL,NULL),(2746,164,43.9,24.9,NULL,NULL,NULL,NULL),(2747,164,57.8,25.9,NULL,NULL,NULL,NULL),(2748,164,84,26.1,NULL,NULL,NULL,NULL),(2749,164,92,25.6,NULL,NULL,NULL,NULL),(2750,164,105.9,26.1,NULL,NULL,NULL,NULL),(2751,164,119.9,26.1,NULL,NULL,NULL,NULL),(2752,164,168.9,26.8,NULL,NULL,NULL,NULL),(2753,164,196.9,28,NULL,NULL,NULL,NULL),(2754,164,224.9,29.5,NULL,NULL,NULL,NULL),(2755,164,253.9,29,NULL,NULL,NULL,NULL),(2756,164,284.8,29,NULL,NULL,NULL,NULL),(2757,164,314.1,28.5,NULL,NULL,NULL,NULL),(2758,164,347.9,30.7,NULL,NULL,NULL,NULL),(2759,164,363.1,30.2,NULL,NULL,NULL,NULL),(2760,164,366,30.2,NULL,NULL,NULL,NULL),(2761,165,1,22.2,NULL,NULL,NULL,NULL),(2762,165,4.8,23.4,NULL,NULL,NULL,NULL),(2763,165,5.8,23.9,NULL,NULL,NULL,NULL),(2764,165,7,24.2,NULL,NULL,NULL,NULL),(2765,165,8,24.2,NULL,NULL,NULL,NULL),(2766,165,9,23.9,NULL,NULL,NULL,NULL),(2767,165,12,24.2,NULL,NULL,NULL,NULL),(2768,165,14.2,24.2,NULL,NULL,NULL,NULL),(2769,165,15.9,24.2,NULL,NULL,NULL,NULL),(2770,165,19,24.4,NULL,NULL,NULL,NULL),(2771,165,21,24.7,NULL,NULL,NULL,NULL),(2772,165,21.9,24.7,NULL,NULL,NULL,NULL),(2773,165,26,25.1,NULL,NULL,NULL,NULL),(2774,165,30.9,24.4,NULL,NULL,NULL,NULL),(2775,165,37,25.1,NULL,NULL,NULL,NULL),(2776,165,43.9,25.4,NULL,NULL,NULL,NULL),(2777,165,57.8,25.9,NULL,NULL,NULL,NULL),(2778,165,84,26.1,NULL,NULL,NULL,NULL),(2779,165,92,26.1,NULL,NULL,NULL,NULL),(2780,165,105.9,26.1,NULL,NULL,NULL,NULL),(2781,165,168.9,26.3,NULL,NULL,NULL,NULL),(2782,165,196.9,27.3,NULL,NULL,NULL,NULL),(2783,165,224.9,28.3,NULL,NULL,NULL,NULL),(2784,165,253.9,28.3,NULL,NULL,NULL,NULL),(2785,165,284.8,27.8,NULL,NULL,NULL,NULL),(2786,165,314.1,27.8,NULL,NULL,NULL,NULL),(2787,165,347.9,29.5,NULL,NULL,NULL,NULL),(2788,165,363.1,28.8,NULL,NULL,NULL,NULL),(2789,165,366,28.5,NULL,NULL,NULL,NULL),(2790,166,1,22.7,NULL,NULL,NULL,NULL),(2791,166,4.9,23.6,NULL,NULL,NULL,NULL),(2792,166,5.8,23.9,NULL,NULL,NULL,NULL),(2793,166,7,23.8,NULL,NULL,NULL,NULL),(2794,166,8,23.9,NULL,NULL,NULL,NULL),(2795,166,9,23.9,NULL,NULL,NULL,NULL),(2796,166,12,24.3,NULL,NULL,NULL,NULL),(2797,166,14.2,24.4,NULL,NULL,NULL,NULL),(2798,166,15.9,24.7,NULL,NULL,NULL,NULL),(2799,166,19.1,24.8,NULL,NULL,NULL,NULL),(2800,166,21.1,25.3,NULL,NULL,NULL,NULL),(2801,166,26,25.3,NULL,NULL,NULL,NULL),(2802,166,30.9,25.2,NULL,NULL,NULL,NULL),(2803,166,37,25.7,NULL,NULL,NULL,NULL),(2804,166,44,26.2,NULL,NULL,NULL,NULL),(2805,166,57.9,26.7,NULL,NULL,NULL,NULL),(2806,166,85.1,27.5,NULL,NULL,NULL,NULL),(2807,166,93,27.4,NULL,NULL,NULL,NULL),(2808,166,107,27.7,NULL,NULL,NULL,NULL),(2809,166,121.1,27.9,NULL,NULL,NULL,NULL),(2810,166,170.1,28.5,NULL,NULL,NULL,NULL),(2811,166,198.1,29.1,NULL,NULL,NULL,NULL),(2812,166,226.1,29.4,NULL,NULL,NULL,NULL),(2813,166,255.1,29,NULL,NULL,NULL,NULL),(2814,166,284.8,29.8,NULL,NULL,NULL,NULL),(2815,166,314,30,NULL,NULL,NULL,NULL),(2816,166,347.8,30.7,NULL,NULL,NULL,NULL),(2817,166,363,30.7,NULL,NULL,NULL,NULL),(2818,166,366,30.7,NULL,NULL,NULL,NULL),(2819,167,1,24.5,NULL,NULL,NULL,NULL),(2820,167,4.9,25.4,NULL,NULL,NULL,NULL),(2821,167,5.8,25.8,NULL,NULL,NULL,NULL),(2822,167,7,25.8,NULL,NULL,NULL,NULL),(2823,167,8,25.9,NULL,NULL,NULL,NULL),(2824,167,9,25.9,NULL,NULL,NULL,NULL),(2825,167,12,26.3,NULL,NULL,NULL,NULL),(2826,167,14.2,26.5,NULL,NULL,NULL,NULL),(2827,167,15.9,26.7,NULL,NULL,NULL,NULL),(2828,167,19.1,26.9,NULL,NULL,NULL,NULL),(2829,167,21.1,27.3,NULL,NULL,NULL,NULL),(2830,167,26,27.1,NULL,NULL,NULL,NULL),(2831,167,30.9,27.4,NULL,NULL,NULL,NULL),(2832,167,37,27.7,NULL,NULL,NULL,NULL),(2833,167,44,28.4,NULL,NULL,NULL,NULL),(2834,167,57.9,28.7,NULL,NULL,NULL,NULL),(2835,167,81.1,29.5,NULL,NULL,NULL,NULL),(2836,167,93,29.5,NULL,NULL,NULL,NULL),(2837,167,107,29.5,NULL,NULL,NULL,NULL),(2838,167,121.1,29.7,NULL,NULL,NULL,NULL),(2839,167,170.1,30.3,NULL,NULL,NULL,NULL),(2840,167,198.1,30.8,NULL,NULL,NULL,NULL),(2841,167,226.1,30.9,NULL,NULL,NULL,NULL),(2842,167,255.1,31,NULL,NULL,NULL,NULL),(2843,167,284.8,31.2,NULL,NULL,NULL,NULL),(2844,167,314,31.5,NULL,NULL,NULL,NULL),(2845,167,347.8,32.2,NULL,NULL,NULL,NULL),(2846,167,363,32.1,NULL,NULL,NULL,NULL),(2847,167,366,32.1,NULL,NULL,NULL,NULL),(2848,168,1.1,23.7,NULL,NULL,NULL,NULL),(2849,168,5,27.3,NULL,NULL,NULL,NULL),(2850,168,6,27.6,NULL,NULL,NULL,NULL),(2851,168,7.1,27.6,NULL,NULL,NULL,NULL),(2852,168,8.1,28.3,NULL,NULL,NULL,NULL),(2853,168,9.1,28.3,NULL,NULL,NULL,NULL),(2854,168,12.1,29.5,NULL,NULL,NULL,NULL),(2855,168,14.3,30.2,NULL,NULL,NULL,NULL),(2856,168,16,30.5,NULL,NULL,NULL,NULL),(2857,168,19.2,30.7,NULL,NULL,NULL,NULL),(2858,168,21.1,30.7,NULL,NULL,NULL,NULL),(2859,168,26.1,30.9,NULL,NULL,NULL,NULL),(2860,168,31.1,30.9,NULL,NULL,NULL,NULL),(2861,168,36.9,31.2,NULL,NULL,NULL,NULL),(2862,168,44,31.9,NULL,NULL,NULL,NULL),(2863,168,58,32.6,NULL,NULL,NULL,NULL),(2864,168,84.2,34.1,NULL,NULL,NULL,NULL),(2865,168,92.1,32.6,NULL,NULL,NULL,NULL),(2866,168,106,33.4,NULL,NULL,NULL,NULL),(2867,168,120,33.4,NULL,NULL,NULL,NULL),(2868,168,197.1,34.3,NULL,NULL,NULL,NULL),(2869,168,225,34.3,NULL,NULL,NULL,NULL),(2870,169,1.1,24.9,NULL,NULL,NULL,NULL),(2871,169,5,28,NULL,NULL,NULL,NULL),(2872,169,6,28.3,NULL,NULL,NULL,NULL),(2873,169,7.1,28.5,NULL,NULL,NULL,NULL),(2874,169,8.1,28.8,NULL,NULL,NULL,NULL),(2875,169,9.1,29.2,NULL,NULL,NULL,NULL),(2876,169,12.1,30.5,NULL,NULL,NULL,NULL),(2877,169,14.3,31.2,NULL,NULL,NULL,NULL),(2878,169,16,31.4,NULL,NULL,NULL,NULL),(2879,169,19.2,32.1,NULL,NULL,NULL,NULL),(2880,169,21.1,32.1,NULL,NULL,NULL,NULL),(2881,169,22,32.1,NULL,NULL,NULL,NULL),(2882,169,26.1,32.9,NULL,NULL,NULL,NULL),(2883,169,31,33.8,NULL,NULL,NULL,NULL),(2884,169,36.9,35.3,NULL,NULL,NULL,NULL),(2885,169,44,35.3,NULL,NULL,NULL,NULL),(2886,169,58,37.9,NULL,NULL,NULL,NULL),(2887,169,84,40.4,NULL,NULL,NULL,NULL),(2888,169,92.1,41.8,NULL,NULL,NULL,NULL),(2889,169,106,43,NULL,NULL,NULL,NULL),(2890,170,1,26.9,NULL,NULL,NULL,NULL),(2891,170,5,29.9,NULL,NULL,NULL,NULL),(2892,170,6,30.5,NULL,NULL,NULL,NULL),(2893,170,7.1,30.6,NULL,NULL,NULL,NULL),(2894,170,8,31.1,NULL,NULL,NULL,NULL),(2895,170,9,31.3,NULL,NULL,NULL,NULL),(2896,170,12,32.3,NULL,NULL,NULL,NULL),(2897,170,14.3,32.8,NULL,NULL,NULL,NULL),(2898,170,16,33.4,NULL,NULL,NULL,NULL),(2899,170,19.2,34,NULL,NULL,NULL,NULL),(2900,170,21.2,33.8,NULL,NULL,NULL,NULL),(2901,170,26.1,34.7,NULL,NULL,NULL,NULL),(2902,170,31,34.9,NULL,NULL,NULL,NULL),(2903,170,36.8,35.2,NULL,NULL,NULL,NULL),(2904,170,44,36.7,NULL,NULL,NULL,NULL),(2905,170,57.9,37.4,NULL,NULL,NULL,NULL),(2906,170,84.1,39.6,NULL,NULL,NULL,NULL),(2907,170,92,38.9,NULL,NULL,NULL,NULL),(2908,170,106,39.9,NULL,NULL,NULL,NULL),(2909,170,120.1,40.4,NULL,NULL,NULL,NULL),(2910,171,1,27.2,NULL,NULL,NULL,NULL),(2911,171,5,29.9,NULL,NULL,NULL,NULL),(2912,171,6,30.4,NULL,NULL,NULL,NULL),(2913,171,7.1,31.2,NULL,NULL,NULL,NULL),(2914,171,8,31.4,NULL,NULL,NULL,NULL),(2915,171,9,31.8,NULL,NULL,NULL,NULL),(2916,171,12,32.8,NULL,NULL,NULL,NULL),(2917,171,14.3,33.3,NULL,NULL,NULL,NULL),(2918,171,16,33.8,NULL,NULL,NULL,NULL),(2919,171,19.2,34.5,NULL,NULL,NULL,NULL),(2920,171,21.2,35.6,NULL,NULL,NULL,NULL),(2921,171,31,35.6,NULL,NULL,NULL,NULL),(2922,171,36.3,36.1,NULL,NULL,NULL,NULL),(2923,171,44,36.2,NULL,NULL,NULL,NULL),(2924,171,57.9,38.2,NULL,NULL,NULL,NULL),(2925,171,84.1,40,NULL,NULL,NULL,NULL),(2926,171,92,40.4,NULL,NULL,NULL,NULL),(2927,171,106,41,NULL,NULL,NULL,NULL),(2928,171,120.1,41.8,NULL,NULL,NULL,NULL),(2929,171,169.1,43.4,NULL,NULL,NULL,NULL),(2930,171,197.1,44.8,NULL,NULL,NULL,NULL),(2931,171,224.9,45.7,NULL,NULL,NULL,NULL),(2932,171,253.9,46.8,NULL,NULL,NULL,NULL),(2933,171,284.9,48.2,NULL,NULL,NULL,NULL),(2934,172,1.12,27.8,NULL,NULL,NULL,NULL),(2935,172,2.02,28.2,NULL,NULL,NULL,NULL),(2936,172,2.92,29.9,NULL,NULL,NULL,NULL),(2937,172,6.02,29.7,NULL,NULL,NULL,NULL),(2938,172,7.92,30.2,NULL,NULL,NULL,NULL),(2939,172,8.02,30.2,NULL,NULL,NULL,NULL),(2940,172,8.82,30.4,NULL,NULL,NULL,NULL),(2941,172,15.92,30.9,NULL,NULL,NULL,NULL),(2942,172,20.62,31.9,NULL,NULL,NULL,NULL),(2943,172,30.92,31.6,NULL,NULL,NULL,NULL),(2944,172,41.72,31.6,NULL,NULL,NULL,NULL),(2945,172,71.02,34.3,NULL,NULL,NULL,NULL),(2946,172,78.92,34.5,NULL,NULL,NULL,NULL),(2947,172,92.92,35,NULL,NULL,NULL,NULL),(2948,172,110.62,35.2,NULL,NULL,NULL,NULL),(2949,172,155.92,37.4,NULL,NULL,NULL,NULL),(2950,172,187.92,37.7,NULL,NULL,NULL,NULL),(2951,172,211.82,39.4,NULL,NULL,NULL,NULL),(2952,172,240.82,39.8,NULL,NULL,NULL,NULL),(2953,172,271.82,39.4,NULL,NULL,NULL,NULL),(2954,172,301.72,39.4,NULL,NULL,NULL,NULL),(2955,172,334.72,41.5,NULL,NULL,NULL,NULL),(2956,172,365.12,40.8,NULL,NULL,NULL,NULL),(2957,173,1,29.2,NULL,NULL,NULL,NULL),(2958,173,1.9,29.7,NULL,NULL,NULL,NULL),(2959,173,2.8,30.7,NULL,NULL,NULL,NULL),(2960,173,5.9,31.4,NULL,NULL,NULL,NULL),(2961,173,7.8,31.9,NULL,NULL,NULL,NULL),(2962,173,7.9,31.4,NULL,NULL,NULL,NULL),(2963,173,8.7,32.4,NULL,NULL,NULL,NULL),(2964,173,12.8,33.1,NULL,NULL,NULL,NULL),(2965,173,15.8,33.1,NULL,NULL,NULL,NULL),(2966,173,20.5,34.1,NULL,NULL,NULL,NULL),(2967,173,30.8,34.1,NULL,NULL,NULL,NULL),(2968,173,41.6,35.5,NULL,NULL,NULL,NULL),(2969,173,70.9,37.5,NULL,NULL,NULL,NULL),(2970,173,78.8,37.2,NULL,NULL,NULL,NULL),(2971,173,92.8,38.2,NULL,NULL,NULL,NULL),(2972,173,110.5,39.2,NULL,NULL,NULL,NULL),(2973,173,155.8,40.8,NULL,NULL,NULL,NULL),(2974,173,187.8,41.8,NULL,NULL,NULL,NULL),(2975,173,211.7,43.3,NULL,NULL,NULL,NULL),(2976,173,240.7,44,NULL,NULL,NULL,NULL),(2977,173,271.7,44.2,NULL,NULL,NULL,NULL),(2978,173,301.5,44.5,NULL,NULL,NULL,NULL),(2979,173,334.5,46.6,NULL,NULL,NULL,NULL),(2980,173,365,47.1,NULL,NULL,NULL,NULL),(2981,174,1.02,27.8,NULL,NULL,NULL,NULL),(2982,174,2.42,28.4,NULL,NULL,NULL,NULL),(2983,174,3.32,29.5,NULL,NULL,NULL,NULL),(2984,174,6.42,30.3,NULL,NULL,NULL,NULL),(2985,174,16.32,31.8,NULL,NULL,NULL,NULL),(2986,174,21.02,32.1,NULL,NULL,NULL,NULL),(2987,174,31.32,33.5,NULL,NULL,NULL,NULL),(2988,174,41.72,34.4,NULL,NULL,NULL,NULL),(2989,174,70.92,35.6,NULL,NULL,NULL,NULL),(2990,174,78.92,35.7,NULL,NULL,NULL,NULL),(2991,174,92.82,36.2,NULL,NULL,NULL,NULL),(2992,174,110.62,36.8,NULL,NULL,NULL,NULL),(2993,174,155.92,38.2,NULL,NULL,NULL,NULL),(2994,174,187.92,38.5,NULL,NULL,NULL,NULL),(2995,174,211.82,38.7,NULL,NULL,NULL,NULL),(2996,174,240.82,39.1,NULL,NULL,NULL,NULL),(2997,174,271.82,39.5,NULL,NULL,NULL,NULL),(2998,174,301.62,39.9,NULL,NULL,NULL,NULL),(2999,174,334.62,40.7,NULL,NULL,NULL,NULL),(3000,174,365.12,40.9,NULL,NULL,NULL,NULL),(3001,175,0.9,27.8,NULL,NULL,NULL,NULL),(3002,175,2.3,30.2,NULL,NULL,NULL,NULL),(3003,175,3.2,31.3,NULL,NULL,NULL,NULL),(3004,175,6.3,32.5,NULL,NULL,NULL,NULL),(3005,175,13.2,34.7,NULL,NULL,NULL,NULL),(3006,175,16.2,34.6,NULL,NULL,NULL,NULL),(3007,175,20.9,35,NULL,NULL,NULL,NULL),(3008,175,31.2,36.7,NULL,NULL,NULL,NULL),(3009,175,41.6,37.7,NULL,NULL,NULL,NULL),(3010,175,70.8,39.6,NULL,NULL,NULL,NULL),(3011,175,78.8,39.5,NULL,NULL,NULL,NULL),(3012,175,92.7,40.1,NULL,NULL,NULL,NULL),(3013,175,110.5,40.8,NULL,NULL,NULL,NULL),(3014,175,155.8,42.2,NULL,NULL,NULL,NULL),(3015,175,187.8,43,NULL,NULL,NULL,NULL),(3016,175,211.7,43.3,NULL,NULL,NULL,NULL),(3017,175,240.7,43.7,NULL,NULL,NULL,NULL),(3018,175,271.7,44.2,NULL,NULL,NULL,NULL),(3019,175,301.5,44.5,NULL,NULL,NULL,NULL),(3020,175,334.5,45.6,NULL,NULL,NULL,NULL),(3021,175,365,45.7,NULL,NULL,NULL,NULL),(3022,176,0.78,27.6,NULL,NULL,NULL,NULL),(3023,176,1.98,28.8,NULL,NULL,NULL,NULL),(3024,176,2.78,29,NULL,NULL,NULL,NULL),(3025,176,5.98,29.2,NULL,NULL,NULL,NULL),(3026,176,7.98,30.2,NULL,NULL,NULL,NULL),(3027,176,8.78,30.9,NULL,NULL,NULL,NULL),(3028,176,12.78,31.9,NULL,NULL,NULL,NULL),(3029,176,15.88,32.1,NULL,NULL,NULL,NULL),(3030,176,20.58,33.1,NULL,NULL,NULL,NULL),(3031,176,30.78,33.6,NULL,NULL,NULL,NULL),(3032,176,41.78,33.8,NULL,NULL,NULL,NULL),(3033,176,78.88,35,NULL,NULL,NULL,NULL),(3034,176,92.78,35.3,NULL,NULL,NULL,NULL),(3035,177,0.88,32.4,NULL,NULL,NULL,NULL),(3036,177,1.78,33.8,NULL,NULL,NULL,NULL),(3037,177,3.68,35,NULL,NULL,NULL,NULL),(3038,177,5.78,37.1,NULL,NULL,NULL,NULL),(3039,177,8.68,37.4,NULL,NULL,NULL,NULL),(3040,177,12.68,39.1,NULL,NULL,NULL,NULL),(3041,177,15.78,38.5,NULL,NULL,NULL,NULL),(3042,177,20.48,41.2,NULL,NULL,NULL,NULL),(3043,177,30.68,43.9,NULL,NULL,NULL,NULL),(3044,177,41.58,45.4,NULL,NULL,NULL,NULL),(3045,177,70.78,48,NULL,NULL,NULL,NULL),(3046,177,78.78,48.2,NULL,NULL,NULL,NULL),(3047,177,92.68,49.4,NULL,NULL,NULL,NULL),(3048,177,121.68,51,NULL,NULL,NULL,NULL),(3049,178,1,54.7,NULL,NULL,NULL,NULL),(3050,178,1.9,56.3,NULL,NULL,NULL,NULL),(3051,178,5.8,59.2,NULL,NULL,NULL,NULL),(3052,178,9,60.2,NULL,NULL,NULL,NULL),(3053,178,13.6,60.8,NULL,NULL,NULL,NULL),(3054,178,26.8,65.2,NULL,NULL,NULL,NULL),(3055,178,40.8,67.5,NULL,NULL,NULL,NULL),(3056,178,63.8,69.7,NULL,NULL,NULL,NULL),(3057,178,86,70.8,NULL,NULL,NULL,NULL),(3058,178,103.7,71.7,NULL,NULL,NULL,NULL),(3059,178,148.9,74.4,NULL,NULL,NULL,NULL),(3060,178,180.9,75.9,NULL,NULL,NULL,NULL),(3061,178,204.6,76.4,NULL,NULL,NULL,NULL),(3062,178,237.8,77.3,NULL,NULL,NULL,NULL),(3063,178,264.8,78.2,NULL,NULL,NULL,NULL),(3064,178,294.7,78.9,NULL,NULL,NULL,NULL),(3065,178,327.7,80.1,NULL,NULL,NULL,NULL),(3066,178,362.7,81.1,NULL,NULL,NULL,NULL),(3067,178,363.6,81.1,NULL,NULL,NULL,NULL),(3068,178,365,81,NULL,NULL,NULL,NULL),(3069,179,1,52.1,NULL,NULL,NULL,NULL),(3070,179,1.9,52.2,NULL,NULL,NULL,NULL),(3071,179,5.8,54.3,NULL,NULL,NULL,NULL),(3072,179,8,51.6,NULL,NULL,NULL,NULL),(3073,179,9,51.8,NULL,NULL,NULL,NULL),(3074,179,13.6,52.2,NULL,NULL,NULL,NULL),(3075,180,1,63.7,NULL,NULL,NULL,NULL),(3076,180,1.7,66.5,NULL,NULL,NULL,NULL),(3077,180,5.7,72.2,NULL,NULL,NULL,NULL),(3078,180,7.8,73.8,NULL,NULL,NULL,NULL),(3079,180,8.9,74.3,NULL,NULL,NULL,NULL),(3080,180,13.5,74.7,NULL,NULL,NULL,NULL),(3081,180,23.3,77.4,NULL,NULL,NULL,NULL),(3082,180,26.3,79.9,NULL,NULL,NULL,NULL),(3083,181,1.02,49.4,NULL,NULL,NULL,NULL),(3084,181,2.02,51.8,NULL,NULL,NULL,NULL),(3085,181,4.22,55.9,NULL,NULL,NULL,NULL),(3086,181,10.32,63.9,NULL,NULL,NULL,NULL),(3087,181,11.22,65.4,NULL,NULL,NULL,NULL),(3088,181,17.32,70.4,NULL,NULL,NULL,NULL),(3089,181,20.92,73.1,NULL,NULL,NULL,NULL),(3090,181,29.32,77.2,NULL,NULL,NULL,NULL),(3091,181,38.22,80.6,NULL,NULL,NULL,NULL),(3092,181,49.22,83.5,NULL,NULL,NULL,NULL),(3093,181,78.22,88.6,NULL,NULL,NULL,NULL),(3094,181,107.22,91,NULL,NULL,NULL,NULL),(3095,181,141.02,97,NULL,NULL,NULL,NULL),(3096,181,183.02,99.2,NULL,NULL,NULL,NULL),(3097,181,198.12,99.7,NULL,NULL,NULL,NULL),(3098,181,238.12,101.4,NULL,NULL,NULL,NULL),(3099,181,261.12,102.3,NULL,NULL,NULL,NULL),(3100,181,266.12,103.8,NULL,NULL,NULL,NULL),(3101,181,273.12,103.8,NULL,NULL,NULL,NULL),(3102,181,280.12,103.3,NULL,NULL,NULL,NULL),(3103,181,287.12,103.5,NULL,NULL,NULL,NULL),(3104,181,301.12,103.8,NULL,NULL,NULL,NULL),(3105,181,308.12,104,NULL,NULL,NULL,NULL),(3106,181,315.12,103.8,NULL,NULL,NULL,NULL),(3107,181,324.12,105.5,NULL,NULL,NULL,NULL),(3108,181,329.12,103.8,NULL,NULL,NULL,NULL),(3109,181,343.12,106.7,NULL,NULL,NULL,NULL),(3110,181,350.12,106.9,NULL,NULL,NULL,NULL),(3111,182,1.02,56.5,NULL,NULL,NULL,NULL),(3112,182,2.02,56.7,NULL,NULL,NULL,NULL),(3113,182,4.22,59.6,NULL,NULL,NULL,NULL),(3114,182,10.32,65.4,NULL,NULL,NULL,NULL),(3115,182,11.22,66.6,NULL,NULL,NULL,NULL),(3116,182,17.32,67.3,NULL,NULL,NULL,NULL),(3117,182,20.92,68.6,NULL,NULL,NULL,NULL),(3118,182,29.32,94.9,NULL,1,NULL,NULL),(3119,182,38.22,71.9,NULL,NULL,NULL,NULL),(3120,182,49.22,72.4,NULL,NULL,NULL,NULL),(3121,182,78.22,73.6,NULL,NULL,NULL,NULL),(3122,182,107.12,74.6,NULL,NULL,NULL,NULL),(3123,182,140.92,78.5,NULL,NULL,NULL,NULL),(3124,182,182.92,78.2,NULL,NULL,NULL,NULL),(3125,182,198.12,76.5,NULL,NULL,NULL,NULL),(3126,182,238.12,75.8,NULL,NULL,NULL,NULL),(3127,182,261.12,76.3,NULL,NULL,NULL,NULL),(3128,182,266.12,78,NULL,NULL,NULL,NULL),(3129,182,273.12,77.5,NULL,NULL,NULL,NULL),(3130,183,0.02,27.4,NULL,NULL,NULL,NULL),(3131,183,0.1,29,NULL,NULL,NULL,NULL),(3132,183,0.3,29.8,NULL,NULL,NULL,NULL),(3133,183,0.8,31.2,NULL,NULL,NULL,NULL),(3134,183,1,31.6,NULL,NULL,NULL,NULL),(3135,183,2,33.2,NULL,NULL,NULL,NULL),(3136,183,4,34.9,NULL,NULL,NULL,NULL),(3137,183,7,36.6,NULL,NULL,NULL,NULL),(3138,183,11,38,NULL,NULL,NULL,NULL),(3139,183,15,39.9,NULL,NULL,NULL,NULL),(3140,183,27,41.6,NULL,NULL,NULL,NULL),(3141,183,44,43.9,NULL,NULL,NULL,NULL),(3142,183,59,45.4,NULL,NULL,NULL,NULL),(3143,183,68,46.1,NULL,NULL,NULL,NULL),(3144,183,89,47.8,NULL,NULL,NULL,NULL),(3145,183,104,48.8,NULL,NULL,NULL,NULL),(3146,183,135,50.5,NULL,NULL,NULL,NULL),(3147,183,182,52,NULL,NULL,NULL,NULL),(3148,183,225,53.4,NULL,NULL,NULL,NULL),(3149,183,280,55,NULL,NULL,NULL,NULL),(3150,183,348,56.4,NULL,NULL,NULL,NULL),(3151,183,380,57.4,NULL,NULL,NULL,NULL),(3152,183,422,58,NULL,NULL,NULL,NULL),(3153,183,485,59.3,NULL,NULL,NULL,NULL),(3154,183,545,60.5,NULL,NULL,NULL,NULL),(3155,183,608,61.6,NULL,NULL,NULL,NULL),(3156,183,642,62.3,NULL,NULL,NULL,NULL),(3157,183,707,63.1,NULL,NULL,NULL,NULL),(3158,183,769,64.1,NULL,NULL,NULL,NULL),(3159,184,0.01,24.8,NULL,NULL,NULL,NULL),(3160,184,0.04,25.3,NULL,NULL,NULL,NULL),(3161,184,0.1,26.1,NULL,NULL,NULL,NULL),(3162,184,0.4,27.1,NULL,NULL,NULL,NULL),(3163,184,1,27.8,NULL,NULL,NULL,NULL),(3164,184,2,28.9,NULL,NULL,NULL,NULL),(3165,184,5,30.5,NULL,NULL,NULL,NULL),(3166,184,8,31.4,NULL,NULL,NULL,NULL),(3167,184,10,31.7,NULL,NULL,NULL,NULL),(3168,184,15,33,NULL,NULL,NULL,NULL),(3169,184,20,33.9,NULL,NULL,NULL,NULL),(3170,184,27,35.1,NULL,NULL,NULL,NULL),(3171,184,42,37,NULL,NULL,NULL,NULL),(3172,184,55,38.1,NULL,NULL,NULL,NULL),(3173,184,73,39.6,NULL,NULL,NULL,NULL),(3174,184,87,40.3,NULL,NULL,NULL,NULL),(3175,184,127,42,NULL,NULL,NULL,NULL),(3176,184,183,44.2,NULL,NULL,NULL,NULL),(3177,184,233,45.9,NULL,NULL,NULL,NULL),(3178,184,273,46.9,NULL,NULL,NULL,NULL),(3179,184,302,47.1,NULL,NULL,NULL,NULL),(3180,184,336,47.7,NULL,NULL,NULL,NULL),(3181,184,360,48.3,NULL,NULL,NULL,NULL),(3182,184,389,48.7,NULL,NULL,NULL,NULL),(3183,184,423,49.5,NULL,NULL,NULL,NULL),(3184,184,483,50.4,NULL,NULL,NULL,NULL),(3185,184,546,51.4,NULL,NULL,NULL,NULL),(3186,184,617,52.8,NULL,NULL,NULL,NULL),(3187,184,707,53.6,NULL,NULL,NULL,NULL),(3188,185,0.004,24.9,NULL,NULL,NULL,NULL),(3189,185,0.01,25.5,NULL,NULL,NULL,NULL),(3190,185,0.04,26.3,NULL,NULL,NULL,NULL),(3191,185,0.1,27.3,NULL,NULL,NULL,NULL),(3192,185,0.4,28.3,NULL,NULL,NULL,NULL),(3193,185,1,29.6,NULL,NULL,NULL,NULL),(3194,185,2,30.6,NULL,NULL,NULL,NULL),(3195,185,4,31.8,NULL,NULL,NULL,NULL),(3196,185,6,32.8,NULL,NULL,NULL,NULL),(3197,185,9,33.6,NULL,NULL,NULL,NULL),(3198,185,13,34.7,NULL,NULL,NULL,NULL),(3199,185,15,35.1,NULL,NULL,NULL,NULL),(3200,185,26,37.2,NULL,NULL,NULL,NULL),(3201,185,33,38.1,NULL,NULL,NULL,NULL),(3202,185,41,38.5,NULL,NULL,NULL,NULL),(3203,185,55,40.2,NULL,NULL,NULL,NULL),(3204,185,71,41.5,NULL,NULL,NULL,NULL),(3205,185,77,41.9,NULL,NULL,NULL,NULL),(3206,185,98,43.2,NULL,NULL,NULL,NULL),(3207,185,120,44.4,NULL,NULL,NULL,NULL),(3208,185,154,45.6,NULL,NULL,NULL,NULL),(3209,185,182,46.3,NULL,NULL,NULL,NULL),(3210,185,224,47.9,NULL,NULL,NULL,NULL),(3211,185,251,48.8,NULL,NULL,NULL,NULL),(3212,185,314,49.9,NULL,NULL,NULL,NULL),(3213,185,367,51,NULL,NULL,NULL,NULL),(3214,185,404,51.6,NULL,NULL,NULL,NULL),(3215,186,0.004,25.6,NULL,NULL,NULL,NULL),(3216,186,0.01,26.5,NULL,NULL,NULL,NULL),(3217,186,0.04,28.1,NULL,NULL,NULL,NULL),(3218,186,0.1,29.3,NULL,NULL,NULL,NULL),(3219,186,0.3,30.8,NULL,NULL,NULL,NULL),(3220,186,0.7,32.2,NULL,NULL,NULL,NULL),(3221,186,1,33.3,NULL,NULL,NULL,NULL),(3222,186,2,34.1,NULL,NULL,NULL,NULL),(3223,186,4,35.7,NULL,NULL,NULL,NULL),(3224,186,6,37,NULL,NULL,NULL,NULL),(3225,186,9,38,NULL,NULL,NULL,NULL),(3226,186,13,39.3,NULL,NULL,NULL,NULL),(3227,186,26,42,NULL,NULL,NULL,NULL),(3228,186,33,43,NULL,NULL,NULL,NULL),(3229,186,41,43.5,NULL,NULL,NULL,NULL),(3230,186,55,45.6,NULL,NULL,NULL,NULL),(3231,186,61,46.1,NULL,NULL,NULL,NULL),(3232,186,71,47,NULL,NULL,NULL,NULL),(3233,186,98,48.5,NULL,NULL,NULL,NULL),(3234,186,120,50.1,NULL,NULL,NULL,NULL),(3235,186,154,51.7,NULL,NULL,NULL,NULL),(3236,186,182,52.8,NULL,NULL,NULL,NULL),(3237,186,211,53.8,NULL,NULL,NULL,NULL),(3238,186,280,55.4,NULL,NULL,NULL,NULL),(3239,186,314,56.3,NULL,NULL,NULL,NULL),(3240,186,367,57.1,NULL,NULL,NULL,NULL),(3241,186,404,57.9,NULL,NULL,NULL,NULL),(3242,187,0.004,23.6,NULL,NULL,NULL,NULL),(3243,187,0.01,24,NULL,NULL,NULL,NULL),(3244,187,0.04,24.2,NULL,NULL,NULL,NULL),(3245,187,0.3,25.1,NULL,NULL,NULL,NULL),(3246,187,0.9,26.1,NULL,NULL,NULL,NULL),(3247,187,2,26.8,NULL,NULL,NULL,NULL),(3248,187,4,27.5,NULL,NULL,NULL,NULL),(3249,187,7,28.3,NULL,NULL,NULL,NULL),(3250,187,9,28.8,NULL,NULL,NULL,NULL),(3251,187,11,29.2,NULL,NULL,NULL,NULL),(3252,187,23,30.6,NULL,NULL,NULL,NULL),(3253,187,36,32.1,NULL,NULL,NULL,NULL),(3254,187,42,32.5,NULL,NULL,NULL,NULL),(3255,187,52,33.2,NULL,NULL,NULL,NULL),(3256,187,63,33.6,NULL,NULL,NULL,NULL),(3257,187,79,34.1,NULL,NULL,NULL,NULL),(3258,187,85,34.4,NULL,NULL,NULL,NULL),(3259,187,105,35.3,NULL,NULL,NULL,NULL),(3260,187,137,36.7,NULL,NULL,NULL,NULL),(3261,187,165,37.3,NULL,NULL,NULL,NULL),(3262,187,179,37.8,NULL,NULL,NULL,NULL),(3263,187,208,38.3,NULL,NULL,NULL,NULL),(3264,187,242,39.4,NULL,NULL,NULL,NULL),(3265,187,274,41.7,NULL,NULL,NULL,NULL),(3266,187,282,43.3,NULL,NULL,NULL,NULL),(3267,187,302,47.1,NULL,NULL,NULL,NULL),(3268,187,365,53.7,NULL,NULL,NULL,NULL),(3269,188,0.027,26.9,NULL,NULL,NULL,NULL),(3270,188,0.03,27.1,NULL,NULL,NULL,NULL),(3271,188,0.04,27.5,NULL,NULL,NULL,NULL),(3272,188,0.12,29.8,NULL,NULL,NULL,NULL),(3273,188,0.22,31.1,NULL,NULL,NULL,NULL),(3274,188,1.02,34.9,NULL,NULL,NULL,NULL),(3275,188,2.02,37.1,NULL,NULL,NULL,NULL),(3276,188,3.02,38.5,NULL,NULL,NULL,NULL),(3277,188,7.02,41.3,NULL,NULL,NULL,NULL),(3278,188,11.02,42.7,NULL,NULL,NULL,NULL),(3279,188,19.02,44,NULL,NULL,NULL,NULL),(3280,188,25.02,46.1,NULL,NULL,NULL,NULL),(3281,188,35.02,48.2,NULL,NULL,NULL,NULL),(3282,188,42.02,48.9,NULL,NULL,NULL,NULL),(3283,188,52.02,50,NULL,NULL,NULL,NULL),(3284,188,62.02,50.7,NULL,NULL,NULL,NULL),(3285,188,76.02,52.4,NULL,NULL,NULL,NULL),(3286,188,90.02,53.4,NULL,NULL,NULL,NULL),(3287,188,102.02,54.4,NULL,NULL,NULL,NULL),(3288,188,146.02,56.9,NULL,NULL,NULL,NULL),(3289,188,180.02,58.6,NULL,NULL,NULL,NULL),(3290,188,250.02,62.9,NULL,NULL,NULL,NULL),(3291,188,279.02,64,NULL,NULL,NULL,NULL),(3292,188,307.02,65.1,NULL,NULL,NULL,NULL),(3293,188,362.02,66.7,NULL,NULL,NULL,NULL),(3294,188,396.02,67.4,NULL,NULL,NULL,NULL),(3295,188,449.02,68.7,NULL,NULL,NULL,NULL),(3296,188,487.02,69.9,NULL,NULL,NULL,NULL),(3297,189,0.004,25.7,NULL,NULL,NULL,NULL),(3298,189,0.01,26.4,NULL,NULL,NULL,NULL),(3299,189,0.04,27.5,NULL,NULL,NULL,NULL),(3300,189,0.2,29.1,NULL,NULL,NULL,NULL),(3301,189,0.5,30.9,NULL,NULL,NULL,NULL),(3302,189,1,32.5,NULL,NULL,NULL,NULL),(3303,189,2,34.5,NULL,NULL,NULL,NULL),(3304,189,4,36.5,NULL,NULL,NULL,NULL),(3305,189,8,38.9,NULL,NULL,NULL,NULL),(3306,189,11,40.1,NULL,NULL,NULL,NULL),(3307,189,14,41.1,NULL,NULL,NULL,NULL),(3308,189,21,42.9,NULL,NULL,NULL,NULL),(3309,189,28,44.3,NULL,NULL,NULL,NULL),(3310,189,40,46.2,NULL,NULL,NULL,NULL),(3311,189,53,47.8,NULL,NULL,NULL,NULL),(3312,189,75,49.8,NULL,NULL,NULL,NULL),(3313,189,97,51.8,NULL,NULL,NULL,NULL),(3314,189,125,53.7,NULL,NULL,NULL,NULL),(3315,189,153,55.4,NULL,NULL,NULL,NULL),(3316,189,183,57.2,NULL,NULL,NULL,NULL),(3317,189,232,59.4,NULL,NULL,NULL,NULL),(3318,189,245,60,NULL,NULL,NULL,NULL),(3319,189,300,61.9,NULL,NULL,NULL,NULL),(3320,189,334,62.9,NULL,NULL,NULL,NULL),(3321,189,387,64.4,NULL,NULL,NULL,NULL),(3322,189,421,65.4,NULL,NULL,NULL,NULL),(3323,189,425,65.7,NULL,NULL,NULL,NULL),(3324,190,0.014,25.2,NULL,NULL,NULL,NULL),(3325,190,0.05,27,NULL,NULL,NULL,NULL),(3326,190,0.11,28.2,NULL,NULL,NULL,NULL),(3327,190,0.31,29.2,NULL,NULL,NULL,NULL),(3328,190,1.01,31.6,NULL,NULL,NULL,NULL),(3329,190,2.01,33.5,NULL,NULL,NULL,NULL),(3330,190,6.01,35.7,NULL,NULL,NULL,NULL),(3331,190,9.01,35.9,NULL,NULL,NULL,NULL),(3332,190,15.01,37.9,NULL,NULL,NULL,NULL),(3333,190,28.01,42.4,NULL,NULL,NULL,NULL),(3334,190,41.01,44.3,NULL,NULL,NULL,NULL),(3335,190,52.01,45.5,NULL,NULL,NULL,NULL),(3336,190,65.01,46.6,NULL,NULL,NULL,NULL),(3337,190,98.01,46.6,NULL,NULL,NULL,NULL),(3338,190,108.01,47.8,NULL,NULL,NULL,NULL),(3339,190,115.01,48.7,NULL,NULL,NULL,NULL),(3340,190,154.01,51.4,NULL,NULL,NULL,NULL),(3341,190,172.01,52.7,NULL,NULL,NULL,NULL),(3342,190,207.01,54.2,NULL,NULL,NULL,NULL),(3343,190,241.01,57.8,NULL,NULL,NULL,NULL),(3344,190,272.01,59.3,NULL,NULL,NULL,NULL),(3345,190,301.01,60.3,NULL,NULL,NULL,NULL),(3346,190,339.01,61.5,NULL,NULL,NULL,NULL),(3347,190,366.01,62.2,NULL,NULL,NULL,NULL),(3348,190,398.01,63.2,NULL,NULL,NULL,NULL),(3349,191,0.07,29.8,NULL,NULL,NULL,NULL),(3350,191,0.1,30.7,NULL,NULL,NULL,NULL),(3351,191,0.26,32.4,NULL,NULL,NULL,NULL),(3352,191,0.46,34.2,NULL,NULL,NULL,NULL),(3353,191,1.06,37.3,NULL,NULL,NULL,NULL),(3354,191,2.06,38.4,NULL,NULL,NULL,NULL),(3355,191,4.06,42.5,NULL,NULL,NULL,NULL),(3356,191,7.06,44.7,NULL,NULL,NULL,NULL),(3357,191,11.06,47.2,NULL,NULL,NULL,NULL),(3358,191,18.06,49.6,NULL,NULL,NULL,NULL),(3359,191,30.06,56,NULL,NULL,NULL,NULL),(3360,191,60.06,58.1,NULL,NULL,NULL,NULL),(3361,191,103.06,63.9,NULL,NULL,NULL,NULL),(3362,191,124.06,65.5,NULL,NULL,NULL,NULL),(3363,191,148.06,72.8,NULL,NULL,NULL,NULL),(3364,191,224.06,86.4,NULL,NULL,NULL,NULL),(3365,191,280.06,90.8,NULL,NULL,NULL,NULL),(3366,191,334.06,94.4,NULL,NULL,NULL,NULL),(3367,191,397.06,96.9,NULL,NULL,NULL,NULL),(3368,191,421.06,100.1,NULL,NULL,NULL,NULL),(3369,191,456.06,102.6,NULL,NULL,NULL,NULL),(3370,191,516.06,105.8,NULL,NULL,NULL,NULL),(3371,191,539.06,106.7,NULL,NULL,NULL,NULL),(3372,191,581.06,107.8,NULL,NULL,NULL,NULL),(3373,191,613.06,110.2,NULL,NULL,NULL,NULL),(3374,191,678.06,114.1,NULL,NULL,NULL,NULL),(3375,191,740.06,115.8,NULL,NULL,NULL,NULL),(3376,192,0.003,29.2,NULL,NULL,NULL,NULL),(3377,192,0.01,30,NULL,NULL,NULL,NULL),(3378,192,0.04,31.3,NULL,NULL,NULL,NULL),(3379,192,0.1,33.2,NULL,NULL,NULL,NULL),(3380,192,0.3,34.4,NULL,NULL,NULL,NULL),(3381,192,0.8,37.6,NULL,NULL,NULL,NULL),(3382,192,1,38.3,NULL,NULL,NULL,NULL),(3383,192,2,40.9,NULL,NULL,NULL,NULL),(3384,192,5,45.1,NULL,NULL,NULL,NULL),(3385,192,8,48.1,NULL,NULL,NULL,NULL),(3386,192,13,52.2,NULL,NULL,NULL,NULL),(3387,192,23,57.5,NULL,NULL,NULL,NULL),(3388,192,34,62.1,NULL,NULL,NULL,NULL),(3389,192,48,68.1,NULL,NULL,NULL,NULL),(3390,192,65,72.8,NULL,NULL,NULL,NULL),(3391,192,84,77.3,NULL,NULL,NULL,NULL),(3392,192,111,83,NULL,NULL,NULL,NULL),(3393,192,156,89.3,NULL,NULL,NULL,NULL),(3394,192,190,93.8,NULL,NULL,NULL,NULL),(3395,192,244,98.9,NULL,NULL,NULL,NULL),(3396,192,273,101.1,NULL,NULL,NULL,NULL),(3397,192,307,102.9,NULL,NULL,NULL,NULL),(3398,192,331,103.6,NULL,NULL,NULL,NULL),(3399,192,360,107.2,NULL,NULL,NULL,NULL),(3400,192,394,109.6,NULL,NULL,NULL,NULL),(3401,192,398,109.7,NULL,NULL,NULL,NULL),(3402,193,0.004,30,NULL,NULL,NULL,NULL),(3403,193,0.007,30.7,NULL,NULL,NULL,NULL),(3404,193,0.01,31.2,NULL,NULL,NULL,NULL),(3405,193,0.02,32.1,NULL,NULL,NULL,NULL),(3406,193,0.04,33.2,NULL,NULL,NULL,NULL),(3407,193,0.1,35.3,NULL,NULL,NULL,NULL),(3408,193,0.2,37.1,NULL,NULL,NULL,NULL),(3409,193,0.4,38.6,NULL,NULL,NULL,NULL),(3410,193,1,41.2,NULL,NULL,NULL,NULL),(3411,193,2,43.4,NULL,NULL,NULL,NULL),(3412,193,4,46.1,NULL,NULL,NULL,NULL),(3413,193,7,49.7,NULL,NULL,NULL,NULL),(3414,193,11,53.6,NULL,NULL,NULL,NULL),(3415,193,19,58.9,NULL,NULL,NULL,NULL),(3416,193,25,61.7,NULL,NULL,NULL,NULL),(3417,193,32,64.5,NULL,NULL,NULL,NULL),(3418,193,40,67.2,NULL,NULL,NULL,NULL),(3419,193,57,73.4,NULL,NULL,NULL,NULL),(3420,193,76,79.5,NULL,NULL,NULL,NULL),(3421,193,111,89.2,NULL,NULL,NULL,NULL),(3422,193,167,98.2,NULL,NULL,NULL,NULL),(3423,193,196,101.9,NULL,NULL,NULL,NULL),(3424,193,224,105.2,NULL,NULL,NULL,NULL),(3425,193,279,110.6,NULL,NULL,NULL,NULL),(3426,193,337,119,NULL,NULL,NULL,NULL),(3427,193,366,122.3,NULL,NULL,NULL,NULL),(3428,193,400,126.9,NULL,NULL,NULL,NULL),(3429,193,404,127.7,NULL,NULL,NULL,NULL),(3430,194,0.004,34.8,NULL,NULL,NULL,NULL),(3431,194,0.005,35.6,NULL,NULL,NULL,NULL),(3432,194,0.01,37.8,NULL,NULL,NULL,NULL),(3433,194,0.04,42,NULL,NULL,NULL,NULL),(3434,194,0.1,45.2,NULL,NULL,NULL,NULL),(3435,194,0.2,47.6,NULL,NULL,NULL,NULL),(3436,194,0.4,49.8,NULL,NULL,NULL,NULL),(3437,194,0.6,51.5,NULL,NULL,NULL,NULL),(3438,194,1,53.9,NULL,NULL,NULL,NULL),(3439,194,2,57.9,NULL,NULL,NULL,NULL),(3440,194,4,62.2,NULL,NULL,NULL,NULL),(3441,194,9,68.9,NULL,NULL,NULL,NULL),(3442,194,19,77.1,NULL,NULL,NULL,NULL),(3443,194,29,81.6,NULL,NULL,NULL,NULL),(3444,194,40,86.3,NULL,NULL,NULL,NULL),(3445,194,54,93.2,NULL,NULL,NULL,NULL),(3446,194,71,100.3,NULL,NULL,NULL,NULL),(3447,194,97,109.8,NULL,NULL,NULL,NULL),(3448,194,140,119.5,NULL,NULL,NULL,NULL),(3449,194,167,120.2,NULL,NULL,NULL,NULL),(3450,194,196,122.9,NULL,NULL,NULL,NULL),(3451,194,250,127.2,NULL,NULL,NULL,NULL),(3452,194,295,131.4,NULL,NULL,NULL,NULL),(3453,194,323,131.9,NULL,NULL,NULL,NULL),(3454,194,366,133.6,NULL,NULL,NULL,NULL),(3455,194,431,136.9,NULL,NULL,NULL,NULL),(3456,194,498,143.3,NULL,NULL,NULL,NULL),(3457,194,540,150,NULL,NULL,NULL,NULL),(3458,195,0.004,28.8,NULL,NULL,NULL,NULL),(3459,195,0.01,29.7,NULL,NULL,NULL,NULL),(3460,195,0.04,31.1,NULL,NULL,NULL,NULL),(3461,195,0.1,32.3,NULL,NULL,NULL,NULL),(3462,195,0.3,34.2,NULL,NULL,NULL,NULL),(3463,195,1,36.9,NULL,NULL,NULL,NULL),(3464,195,2,40,NULL,NULL,NULL,NULL),(3465,195,6,44.2,NULL,NULL,NULL,NULL),(3466,195,8,45.6,NULL,NULL,NULL,NULL),(3467,195,10,47.7,NULL,NULL,NULL,NULL),(3468,195,17,51.6,NULL,NULL,NULL,NULL),(3469,195,21,53.5,NULL,NULL,NULL,NULL),(3470,195,25,55.1,NULL,NULL,NULL,NULL),(3471,195,38,59.1,NULL,NULL,NULL,NULL),(3472,195,51,63,NULL,NULL,NULL,NULL),(3473,195,67,66.2,NULL,NULL,NULL,NULL),(3474,195,81,70,NULL,NULL,NULL,NULL),(3475,195,88,71.5,NULL,NULL,NULL,NULL),(3476,195,98,73.6,NULL,NULL,NULL,NULL),(3477,195,109,75.3,NULL,NULL,NULL,NULL),(3478,195,127,78.5,NULL,NULL,NULL,NULL),(3479,195,180,84.8,NULL,NULL,NULL,NULL),(3480,195,214,88.9,NULL,NULL,NULL,NULL),(3481,195,245,91.4,NULL,NULL,NULL,NULL),(3482,195,312,93.5,NULL,NULL,NULL,NULL),(3483,195,371,90.4,NULL,NULL,NULL,NULL),(3484,195,396,92.9,NULL,NULL,NULL,NULL),(3485,195,436,93.5,NULL,NULL,NULL,NULL),(3486,195,498,96.3,NULL,NULL,NULL,NULL),(3487,196,0.003,25.8,NULL,NULL,NULL,NULL),(3488,196,0.01,26.6,NULL,NULL,NULL,NULL),(3489,196,0.03,27.3,NULL,NULL,NULL,NULL),(3490,196,0.2,28.4,NULL,NULL,NULL,NULL),(3491,196,0.3,28.9,NULL,NULL,NULL,NULL),(3492,196,0.8,30.7,NULL,NULL,NULL,NULL),(3493,196,1,31.1,NULL,NULL,NULL,NULL),(3494,196,3,33.3,NULL,NULL,NULL,NULL),(3495,196,7,35.3,NULL,NULL,NULL,NULL),(3496,196,10,36.5,NULL,NULL,NULL,NULL),(3497,196,15,37.7,NULL,NULL,NULL,NULL),(3498,196,25,39.8,NULL,NULL,NULL,NULL),(3499,196,35,41.2,NULL,NULL,NULL,NULL),(3500,196,47,42.7,NULL,NULL,NULL,NULL),(3501,196,63,44.3,NULL,NULL,NULL,NULL),(3502,196,88,46.1,NULL,NULL,NULL,NULL),(3503,196,104,46.7,NULL,NULL,NULL,NULL),(3504,196,125,47.6,NULL,NULL,NULL,NULL),(3505,196,154,48.8,NULL,NULL,NULL,NULL),(3506,196,181,49.8,NULL,NULL,NULL,NULL),(3507,196,209,50.7,NULL,NULL,NULL,NULL),(3508,196,271,52.3,NULL,NULL,NULL,NULL),(3509,196,307,52.8,NULL,NULL,NULL,NULL),(3510,196,341,53.4,NULL,NULL,NULL,NULL),(3511,196,365,54,NULL,NULL,NULL,NULL),(3512,196,394,54.3,NULL,NULL,NULL,NULL),(3513,196,428,55,NULL,NULL,NULL,NULL),(3514,196,459,55.7,NULL,NULL,NULL,NULL),(3515,197,0.004,24.4,NULL,NULL,NULL,NULL),(3516,197,0.01,24.9,NULL,NULL,NULL,NULL),(3517,197,0.04,25.5,NULL,NULL,NULL,NULL),(3518,197,0.1,26.2,NULL,NULL,NULL,NULL),(3519,197,0.3,26.6,NULL,NULL,NULL,NULL),(3520,197,0.8,27.6,NULL,NULL,NULL,NULL),(3521,197,1,27.8,NULL,NULL,NULL,NULL),(3522,197,6,30.2,NULL,NULL,NULL,NULL),(3523,197,9,31.1,NULL,NULL,NULL,NULL),(3524,197,11,31.8,NULL,NULL,NULL,NULL),(3525,197,20,33.3,NULL,NULL,NULL,NULL),(3526,197,36,35.3,NULL,NULL,NULL,NULL),(3527,197,56,36.9,NULL,NULL,NULL,NULL),(3528,197,70,37.8,NULL,NULL,NULL,NULL),(3529,197,91,39.1,NULL,NULL,NULL,NULL),(3530,197,107,39.8,NULL,NULL,NULL,NULL),(3531,197,147,41.4,NULL,NULL,NULL,NULL),(3532,197,176,43.1,NULL,NULL,NULL,NULL),(3533,197,245,44.3,NULL,NULL,NULL,NULL),(3534,197,303,45.6,NULL,NULL,NULL,NULL),(3535,197,365,46.9,NULL,NULL,NULL,NULL),(3536,197,426,47.8,NULL,NULL,NULL,NULL),(3537,197,464,48.5,NULL,NULL,NULL,NULL),(3538,197,523,49.4,NULL,NULL,NULL,NULL),(3539,197,560,50.4,NULL,NULL,NULL,NULL),(3540,197,588,50.3,NULL,NULL,NULL,NULL),(3541,197,650,51.2,NULL,NULL,NULL,NULL),(3542,198,0.004,24.7,NULL,NULL,NULL,NULL),(3543,198,0.01,25.2,NULL,NULL,NULL,NULL),(3544,198,0.02,25.7,NULL,NULL,NULL,NULL),(3545,198,0.05,26.1,NULL,NULL,NULL,NULL),(3546,198,0.1,26.9,NULL,NULL,NULL,NULL),(3547,198,0.3,27.4,NULL,NULL,NULL,NULL),(3548,198,0.8,28.5,NULL,NULL,NULL,NULL),(3549,198,1,29,NULL,NULL,NULL,NULL),(3550,198,3,30.5,NULL,NULL,NULL,NULL),(3551,198,6,31.8,NULL,NULL,NULL,NULL),(3552,198,9,32.5,NULL,NULL,NULL,NULL),(3553,198,15,34.3,NULL,NULL,NULL,NULL),(3554,198,25,35.4,NULL,NULL,NULL,NULL),(3555,198,40,37.5,NULL,NULL,NULL,NULL),(3556,198,64,39.4,NULL,NULL,NULL,NULL),(3557,198,98,41.3,NULL,NULL,NULL,NULL),(3558,198,112,41.9,NULL,NULL,NULL,NULL),(3559,198,140,43.1,NULL,NULL,NULL,NULL),(3560,198,169,44.3,NULL,NULL,NULL,NULL),(3561,198,195,45.4,NULL,NULL,NULL,NULL),(3562,198,224,45.7,NULL,NULL,NULL,NULL),(3563,198,258,46.5,NULL,NULL,NULL,NULL),(3564,198,282,46.9,NULL,NULL,NULL,NULL),(3565,198,311,47.4,NULL,NULL,NULL,NULL),(3566,198,345,48,NULL,NULL,NULL,NULL),(3567,198,376,49.1,NULL,NULL,NULL,NULL),(3568,199,0.004,27,NULL,NULL,NULL,NULL),(3569,199,0.007,27.6,NULL,NULL,NULL,NULL),(3570,199,0.01,27.9,NULL,NULL,NULL,NULL),(3571,199,0.04,29.5,NULL,NULL,NULL,NULL),(3572,199,0.08,30.3,NULL,NULL,NULL,NULL),(3573,199,0.2,31.8,NULL,NULL,NULL,NULL),(3574,199,0.7,33.7,NULL,NULL,NULL,NULL),(3575,199,1,34.2,NULL,NULL,NULL,NULL),(3576,199,2,35.7,NULL,NULL,NULL,NULL),(3577,199,4,37.2,NULL,NULL,NULL,NULL),(3578,199,7,38.7,NULL,NULL,NULL,NULL),(3579,199,12,40.3,NULL,NULL,NULL,NULL),(3580,199,25,42.8,NULL,NULL,NULL,NULL),(3581,199,35,44.1,NULL,NULL,NULL,NULL),(3582,199,56,46.3,NULL,NULL,NULL,NULL),(3583,199,71,47.5,NULL,NULL,NULL,NULL),(3584,199,98,49,NULL,NULL,NULL,NULL),(3585,199,126,50.5,NULL,NULL,NULL,NULL),(3586,199,140,51.1,NULL,NULL,NULL,NULL),(3587,199,195,53.2,NULL,NULL,NULL,NULL),(3588,199,224,53.7,NULL,NULL,NULL,NULL),(3589,199,258,54.8,NULL,NULL,NULL,NULL),(3590,199,281,55.3,NULL,NULL,NULL,NULL),(3591,199,311,55.8,NULL,NULL,NULL,NULL),(3592,199,345,56.5,NULL,NULL,NULL,NULL),(3593,199,376,57.1,NULL,NULL,NULL,NULL),(3594,199,390,57.3,NULL,NULL,NULL,NULL),(3595,200,0.004,23.7,NULL,NULL,NULL,NULL),(3596,200,0.01,24,NULL,NULL,NULL,NULL),(3597,200,0.05,24.5,NULL,NULL,NULL,NULL),(3598,200,0.1,25,NULL,NULL,NULL,NULL),(3599,200,0.3,25.4,NULL,NULL,NULL,NULL),(3600,200,1,26.3,NULL,NULL,NULL,NULL),(3601,200,4,27.8,NULL,NULL,NULL,NULL),(3602,200,7,28.4,NULL,NULL,NULL,NULL),(3603,200,10,29.1,NULL,NULL,NULL,NULL),(3604,200,23,30.4,NULL,NULL,NULL,NULL),(3605,200,32,31.5,NULL,NULL,NULL,NULL),(3606,200,49,32.6,NULL,NULL,NULL,NULL),(3607,200,65,33.6,NULL,NULL,NULL,NULL),(3608,200,81,34.6,NULL,NULL,NULL,NULL),(3609,200,99,35.2,NULL,NULL,NULL,NULL),(3610,200,109,35.6,NULL,NULL,NULL,NULL),(3611,200,123,36.2,NULL,NULL,NULL,NULL),(3612,200,152,37,NULL,NULL,NULL,NULL),(3613,200,186,38.4,NULL,NULL,NULL,NULL),(3614,200,217,39,NULL,NULL,NULL,NULL),(3615,200,246,39.8,NULL,NULL,NULL,NULL),(3616,200,284,40.4,NULL,NULL,NULL,NULL),(3617,200,309,41.3,NULL,NULL,NULL,NULL),(3618,200,343,42,NULL,NULL,NULL,NULL),(3619,200,365,42.7,NULL,NULL,NULL,NULL),(3620,201,0.004,28.4,NULL,NULL,NULL,NULL),(3621,201,0.01,29.2,NULL,NULL,NULL,NULL),(3622,201,0.04,30.7,NULL,NULL,NULL,NULL),(3623,201,0.09,31.9,NULL,NULL,NULL,NULL),(3624,201,0.1,32.7,NULL,NULL,NULL,NULL),(3625,201,0.3,34,NULL,NULL,NULL,NULL),(3626,201,1,37.8,NULL,NULL,NULL,NULL),(3627,201,3,41.6,NULL,NULL,NULL,NULL),(3628,201,5,43.6,NULL,NULL,NULL,NULL),(3629,201,9,45.9,NULL,NULL,NULL,NULL),(3630,201,16,48.1,NULL,NULL,NULL,NULL),(3631,201,31,49.6,NULL,NULL,NULL,NULL),(3632,201,42,51.4,NULL,NULL,NULL,NULL),(3633,201,56,52.9,NULL,NULL,NULL,NULL),(3634,201,78,55,NULL,NULL,NULL,NULL),(3635,201,113,57.8,NULL,NULL,NULL,NULL),(3636,201,167,60.6,NULL,NULL,NULL,NULL),(3637,201,198,62.1,NULL,NULL,NULL,NULL),(3638,201,226,63.2,NULL,NULL,NULL,NULL),(3639,201,252,64.1,NULL,NULL,NULL,NULL),(3640,201,281,65.1,NULL,NULL,NULL,NULL),(3641,201,315,66,NULL,NULL,NULL,NULL),(3642,201,339,66.7,NULL,NULL,NULL,NULL),(3643,201,368,67.4,NULL,NULL,NULL,NULL),(3644,201,402,68.4,NULL,NULL,NULL,NULL),(3645,201,433,69.6,NULL,NULL,NULL,NULL),(3646,201,440,69.8,NULL,NULL,NULL,NULL),(3647,202,0.004,26.8,NULL,NULL,NULL,NULL),(3648,202,0.01,27.4,NULL,NULL,NULL,NULL),(3649,202,0.04,28.7,NULL,NULL,NULL,NULL),(3650,202,0.09,29.7,NULL,NULL,NULL,NULL),(3651,202,0.3,31.4,NULL,NULL,NULL,NULL),(3652,202,1,34.1,NULL,NULL,NULL,NULL),(3653,202,2,36.1,NULL,NULL,NULL,NULL),(3654,202,4,38,NULL,NULL,NULL,NULL),(3655,202,7,40.2,NULL,NULL,NULL,NULL),(3656,202,11,41.7,NULL,NULL,NULL,NULL),(3657,202,16,43.1,NULL,NULL,NULL,NULL),(3658,202,20,44,NULL,NULL,NULL,NULL),(3659,202,30,45.8,NULL,NULL,NULL,NULL),(3660,202,42,47.6,NULL,NULL,NULL,NULL),(3661,202,51,48.8,NULL,NULL,NULL,NULL),(3662,202,72,50.8,NULL,NULL,NULL,NULL),(3663,202,93,52.3,NULL,NULL,NULL,NULL),(3664,202,107,53.2,NULL,NULL,NULL,NULL),(3665,202,136,54.9,NULL,NULL,NULL,NULL),(3666,202,164,56.3,NULL,NULL,NULL,NULL),(3667,202,190,57.9,NULL,NULL,NULL,NULL),(3668,202,219,59,NULL,NULL,NULL,NULL),(3669,202,252,60,NULL,NULL,NULL,NULL),(3670,202,277,60.7,NULL,NULL,NULL,NULL),(3671,202,306,61.5,NULL,NULL,NULL,NULL),(3672,202,340,62.5,NULL,NULL,NULL,NULL),(3673,202,371,63.6,NULL,NULL,NULL,NULL),(3674,202,378,63.8,NULL,NULL,NULL,NULL),(3675,203,0.004,25.5,NULL,NULL,NULL,NULL),(3676,203,0.01,26.2,NULL,NULL,NULL,NULL),(3677,203,0.02,26.7,NULL,NULL,NULL,NULL),(3678,203,0.04,27.4,NULL,NULL,NULL,NULL),(3679,203,0.1,28.7,NULL,NULL,NULL,NULL),(3680,203,0.5,31,NULL,NULL,NULL,NULL),(3681,203,1,32.8,NULL,NULL,NULL,NULL),(3682,203,4,36.6,NULL,NULL,NULL,NULL),(3683,203,6,38,NULL,NULL,NULL,NULL),(3684,203,11,40.4,NULL,NULL,NULL,NULL),(3685,203,14,41.9,NULL,NULL,NULL,NULL),(3686,203,18,42.6,NULL,NULL,NULL,NULL),(3687,203,28,44.3,NULL,NULL,NULL,NULL),(3688,203,31,44.8,NULL,NULL,NULL,NULL),(3689,203,40,46,NULL,NULL,NULL,NULL),(3690,203,56,47.8,NULL,NULL,NULL,NULL),(3691,203,74,49.4,NULL,NULL,NULL,NULL),(3692,203,84,50.1,NULL,NULL,NULL,NULL),(3693,203,98,51.1,NULL,NULL,NULL,NULL),(3694,203,116,52.3,NULL,NULL,NULL,NULL),(3695,203,161,54.4,NULL,NULL,NULL,NULL),(3696,203,192,55.8,NULL,NULL,NULL,NULL),(3697,203,221,57,NULL,NULL,NULL,NULL),(3698,203,259,58.1,NULL,NULL,NULL,NULL),(3699,203,286,58.7,NULL,NULL,NULL,NULL),(3700,203,318,59.6,NULL,NULL,NULL,NULL),(3701,203,343,61,NULL,NULL,NULL,NULL),(3702,203,367,60.8,NULL,NULL,NULL,NULL),(3703,204,0.004,28.4,NULL,NULL,NULL,NULL),(3704,204,0.01,29.3,NULL,NULL,NULL,NULL),(3705,204,0.04,30.7,NULL,NULL,NULL,NULL),(3706,204,0.1,32.2,NULL,NULL,NULL,NULL),(3707,204,0.4,34.7,NULL,NULL,NULL,NULL),(3708,204,1,36.7,NULL,NULL,NULL,NULL),(3709,204,2,39.1,NULL,NULL,NULL,NULL),(3710,204,3,40.5,NULL,NULL,NULL,NULL),(3711,204,5,42.3,NULL,NULL,NULL,NULL),(3712,204,8,43.8,NULL,NULL,NULL,NULL),(3713,204,13,46.8,NULL,NULL,NULL,NULL),(3714,204,18,49.2,NULL,NULL,NULL,NULL),(3715,204,25,51.5,NULL,NULL,NULL,NULL),(3716,204,30,53.7,NULL,NULL,NULL,NULL),(3717,204,40,57,NULL,NULL,NULL,NULL),(3718,204,61,61.6,NULL,NULL,NULL,NULL),(3719,204,97,67,NULL,NULL,NULL,NULL),(3720,204,153,70.3,NULL,NULL,NULL,NULL),(3721,204,217,78.3,NULL,NULL,NULL,NULL),(3722,204,271,78.6,NULL,NULL,NULL,NULL),(3723,204,300,81.7,NULL,NULL,NULL,NULL),(3724,204,358,84.5,NULL,NULL,NULL,NULL),(3725,204,387,86.2,NULL,NULL,NULL,NULL),(3726,204,421,89,NULL,NULL,NULL,NULL),(3727,204,481,93.8,NULL,NULL,NULL,NULL),(3728,204,519,94.4,NULL,NULL,NULL,NULL),(3729,204,578,96.7,NULL,NULL,NULL,NULL),(3730,204,603,99.3,NULL,NULL,NULL,NULL),(3731,204,704,100.8,NULL,NULL,NULL,NULL),(3732,205,0.004,29.3,NULL,NULL,NULL,NULL),(3733,205,0.02,30.9,NULL,NULL,NULL,NULL),(3734,205,0.1,33.3,NULL,NULL,NULL,NULL),(3735,205,0.3,34.7,NULL,NULL,NULL,NULL),(3736,205,0.8,37.4,NULL,NULL,NULL,NULL),(3737,205,1,38.3,NULL,NULL,NULL,NULL),(3738,205,3,41.8,NULL,NULL,NULL,NULL),(3739,205,5,43.6,NULL,NULL,NULL,NULL),(3740,205,9,46.7,NULL,NULL,NULL,NULL),(3741,205,16,50,NULL,NULL,NULL,NULL),(3742,205,20,52.2,NULL,NULL,NULL,NULL),(3743,205,30,56,NULL,NULL,NULL,NULL),(3744,205,39,58.3,NULL,NULL,NULL,NULL),(3745,205,56,62.6,NULL,NULL,NULL,NULL),(3746,205,79,68.3,NULL,NULL,NULL,NULL),(3747,205,99,71.5,NULL,NULL,NULL,NULL),(3748,205,126,74.8,NULL,NULL,NULL,NULL),(3749,205,155,77.7,NULL,NULL,NULL,NULL),(3750,205,183,80.6,NULL,NULL,NULL,NULL),(3751,205,209,83,NULL,NULL,NULL,NULL),(3752,205,238,84.2,NULL,NULL,NULL,NULL),(3753,205,296,86.8,NULL,NULL,NULL,NULL),(3754,205,325,88.8,NULL,NULL,NULL,NULL),(3755,205,359,90.9,NULL,NULL,NULL,NULL),(3756,205,390,92.3,NULL,NULL,NULL,NULL),(3757,205,397,93.1,NULL,NULL,NULL,NULL),(3758,206,0.004,34.7,NULL,NULL,NULL,NULL),(3759,206,0.007,35.3,NULL,NULL,NULL,NULL),(3760,206,0.01,36.5,NULL,NULL,NULL,NULL),(3761,206,0.03,37.9,NULL,NULL,NULL,NULL),(3762,206,0.06,39.4,NULL,NULL,NULL,NULL),(3763,206,0.1,41.2,NULL,NULL,NULL,NULL),(3764,206,0.4,44.3,NULL,NULL,NULL,NULL),(3765,206,1,48.2,NULL,NULL,NULL,NULL),(3766,206,3,53,NULL,NULL,NULL,NULL),(3767,206,5,55.6,NULL,NULL,NULL,NULL),(3768,206,7,57.6,NULL,NULL,NULL,NULL),(3769,206,9,59,NULL,NULL,NULL,NULL),(3770,206,12,61.2,NULL,NULL,NULL,NULL),(3771,206,21,65.8,NULL,NULL,NULL,NULL),(3772,206,34,70.7,NULL,NULL,NULL,NULL),(3773,206,40,72.5,NULL,NULL,NULL,NULL),(3774,206,62,79.9,NULL,NULL,NULL,NULL),(3775,206,98,87.9,NULL,NULL,NULL,NULL),(3776,206,126,92.8,NULL,NULL,NULL,NULL),(3777,206,141,94.7,NULL,NULL,NULL,NULL),(3778,206,169,98.4,NULL,NULL,NULL,NULL),(3779,206,195,101.2,NULL,NULL,NULL,NULL),(3780,206,224,104,NULL,NULL,NULL,NULL),(3781,206,258,106.9,NULL,NULL,NULL,NULL),(3782,206,311,109.9,NULL,NULL,NULL,NULL),(3783,206,345,112.9,NULL,NULL,NULL,NULL),(3784,206,376,114.4,NULL,NULL,NULL,NULL),(3785,206,383,114.7,NULL,NULL,NULL,NULL),(3786,207,0.004,39.7,NULL,NULL,NULL,NULL),(3787,207,0.006,40.4,NULL,NULL,NULL,NULL),(3788,207,0.01,42.2,NULL,NULL,NULL,NULL),(3789,207,0.02,44,NULL,NULL,NULL,NULL),(3790,207,0.04,46.3,NULL,NULL,NULL,NULL),(3791,207,0.08,49.2,NULL,NULL,NULL,NULL),(3792,207,0.1,51,NULL,NULL,NULL,NULL),(3793,207,0.3,54.1,NULL,NULL,NULL,NULL),(3794,207,0.4,57,NULL,NULL,NULL,NULL),(3795,207,1,61,NULL,NULL,NULL,NULL),(3796,207,4,69.9,NULL,NULL,NULL,NULL),(3797,207,9,75.6,NULL,NULL,NULL,NULL),(3798,207,16,80.8,NULL,NULL,NULL,NULL),(3799,207,25,85.7,NULL,NULL,NULL,NULL),(3800,207,34,89.4,NULL,NULL,NULL,NULL),(3801,207,40,91.5,NULL,NULL,NULL,NULL),(3802,207,56,98,NULL,NULL,NULL,NULL),(3803,207,62,100.5,NULL,NULL,NULL,NULL),(3804,207,85,106.9,NULL,NULL,NULL,NULL),(3805,207,141,113.6,NULL,NULL,NULL,NULL),(3806,207,169,116.9,NULL,NULL,NULL,NULL),(3807,207,224,121.4,NULL,NULL,NULL,NULL),(3808,207,282,124.8,NULL,NULL,NULL,NULL),(3809,207,376,128.6,NULL,NULL,NULL,NULL),(3810,207,428,130.9,NULL,NULL,NULL,NULL),(3811,207,502,133.6,NULL,NULL,NULL,NULL),(3812,207,566,135.1,NULL,NULL,NULL,NULL),(3813,207,629,136,NULL,NULL,NULL,NULL),(3814,208,0.123,29.1,NULL,NULL,NULL,NULL),(3815,208,0.13,29.5,NULL,NULL,NULL,NULL),(3816,208,0.16,30.6,NULL,NULL,NULL,NULL),(3817,208,0.32,32.4,NULL,NULL,NULL,NULL),(3818,208,0.42,33,NULL,NULL,NULL,NULL),(3819,208,1.12,36.1,NULL,NULL,NULL,NULL),(3820,208,2.12,28.6,NULL,1,NULL,NULL),(3821,208,4.12,41.1,NULL,NULL,NULL,NULL),(3822,208,7.12,44,NULL,NULL,NULL,NULL),(3823,208,16.12,48.9,NULL,NULL,NULL,NULL),(3824,208,18.12,49.6,NULL,NULL,NULL,NULL),(3825,208,32.12,50.7,NULL,NULL,NULL,NULL),(3826,208,36.12,53.6,NULL,NULL,NULL,NULL),(3827,208,53.12,58.2,NULL,NULL,NULL,NULL),(3828,208,74.12,62.5,NULL,NULL,NULL,NULL),(3829,208,92.12,66.1,NULL,NULL,NULL,NULL),(3830,208,102.12,66.8,NULL,NULL,NULL,NULL),(3831,208,145.12,72.3,NULL,NULL,NULL,NULL),(3832,208,179.12,75.7,NULL,NULL,NULL,NULL),(3833,208,210.12,78.1,NULL,NULL,NULL,NULL),(3834,208,225.12,79.3,NULL,NULL,NULL,NULL),(3835,208,277.12,80.5,NULL,NULL,NULL,NULL),(3836,208,288.12,81.1,NULL,NULL,NULL,NULL),(3837,208,336.12,83.3,NULL,NULL,NULL,NULL),(3838,208,361.12,85.6,NULL,NULL,NULL,NULL),(3839,208,401.12,85.9,NULL,NULL,NULL,NULL),(3840,208,463.12,28,NULL,1,NULL,NULL),(3841,209,1,52,NULL,NULL,NULL,NULL),(3842,209,2,56,NULL,NULL,NULL,NULL),(3843,209,3,58,NULL,NULL,NULL,NULL),(3844,209,7,64,NULL,NULL,NULL,NULL),(3845,209,14,71,NULL,NULL,NULL,NULL),(3846,209,28,78,NULL,NULL,NULL,NULL),(3847,209,56,90,NULL,NULL,NULL,NULL),(3848,209,90,98,NULL,NULL,NULL,NULL),(3849,209,180,107,NULL,NULL,NULL,NULL),(3850,209,360,116,NULL,NULL,NULL,NULL),(3851,209,720,124,NULL,NULL,NULL,NULL),(3852,210,1,44,NULL,NULL,NULL,NULL),(3853,210,2,48,NULL,NULL,NULL,NULL),(3854,210,3,50,NULL,NULL,NULL,NULL),(3855,210,7,54,NULL,NULL,NULL,NULL),(3856,210,14,59,NULL,NULL,NULL,NULL),(3857,210,28,67,NULL,NULL,NULL,NULL),(3858,210,56,77,NULL,NULL,NULL,NULL),(3859,210,90,85,NULL,NULL,NULL,NULL),(3860,210,180,98,NULL,NULL,NULL,NULL),(3861,210,360,106,NULL,NULL,NULL,NULL),(3862,210,720,114,NULL,NULL,NULL,NULL),(3863,210,1080,116,NULL,NULL,NULL,NULL),(3864,210,1440,118,NULL,NULL,NULL,NULL),(3865,210,1800,120,NULL,NULL,NULL,NULL),(3866,211,1,50,NULL,NULL,NULL,NULL),(3867,211,2,54,NULL,NULL,NULL,NULL),(3868,211,3,56,NULL,NULL,NULL,NULL),(3869,211,7,63,NULL,NULL,NULL,NULL),(3870,211,14,69,NULL,NULL,NULL,NULL),(3871,211,28,79,NULL,NULL,NULL,NULL),(3872,211,56,88,NULL,NULL,NULL,NULL),(3873,211,90,95,NULL,NULL,NULL,NULL),(3874,211,180,104,NULL,NULL,NULL,NULL),(3875,211,360,113,NULL,NULL,NULL,NULL),(3876,211,720,121,NULL,NULL,NULL,NULL),(3877,211,1080,124,NULL,NULL,NULL,NULL),(3878,211,1440,127,NULL,NULL,NULL,NULL),(3879,211,1800,128,NULL,NULL,NULL,NULL),(3880,212,1,49,NULL,NULL,NULL,NULL),(3881,212,2,54,NULL,NULL,NULL,NULL),(3882,212,3,58,NULL,NULL,NULL,NULL),(3883,212,7,65,NULL,NULL,NULL,NULL),(3884,212,14,72,NULL,NULL,NULL,NULL),(3885,212,28,81,NULL,NULL,NULL,NULL),(3886,212,56,94,NULL,NULL,NULL,NULL),(3887,212,90,103,NULL,NULL,NULL,NULL),(3888,212,180,116,NULL,NULL,NULL,NULL),(3889,212,360,126,NULL,NULL,NULL,NULL),(3890,212,720,135,NULL,NULL,NULL,NULL),(3891,212,1080,140,NULL,NULL,NULL,NULL),(3892,212,1440,141,NULL,NULL,NULL,NULL),(3893,213,1,29,NULL,NULL,NULL,NULL),(3894,213,2,31,NULL,NULL,NULL,NULL),(3895,213,3,32,NULL,NULL,NULL,NULL),(3896,213,7,36,NULL,NULL,NULL,NULL),(3897,213,14,40,NULL,NULL,NULL,NULL),(3898,213,28,45,NULL,NULL,NULL,NULL),(3899,213,56,51,NULL,NULL,NULL,NULL),(3900,213,90,55,NULL,NULL,NULL,NULL),(3901,213,180,61,NULL,NULL,NULL,NULL),(3902,213,360,69,NULL,NULL,NULL,NULL),(3903,213,720,76,NULL,NULL,NULL,NULL),(3904,214,1,37,NULL,NULL,NULL,NULL),(3905,214,2,40,NULL,NULL,NULL,NULL),(3906,214,3,43,NULL,NULL,NULL,NULL),(3907,214,7,47,NULL,NULL,NULL,NULL),(3908,214,14,53,NULL,NULL,NULL,NULL),(3909,214,28,61,NULL,NULL,NULL,NULL),(3910,214,56,71,NULL,NULL,NULL,NULL),(3911,214,90,78,NULL,NULL,NULL,NULL),(3912,214,180,89,NULL,NULL,NULL,NULL),(3913,214,360,97,NULL,NULL,NULL,NULL),(3914,214,720,103,NULL,NULL,NULL,NULL),(3915,215,1,54.8,NULL,NULL,NULL,NULL),(3916,215,2,58.3,NULL,NULL,NULL,NULL),(3917,215,3,59.5,NULL,NULL,NULL,NULL),(3918,215,7,63.4,NULL,NULL,NULL,NULL),(3919,215,14,68.3,NULL,NULL,NULL,NULL),(3920,215,28,76.4,NULL,NULL,NULL,NULL),(3921,215,56,88.2,NULL,NULL,NULL,NULL),(3922,215,90,97.2,NULL,NULL,NULL,NULL),(3923,215,180,110.6,NULL,NULL,NULL,NULL),(3924,215,360,119.7,NULL,NULL,NULL,NULL),(3925,216,1,43.8,NULL,NULL,NULL,NULL),(3926,216,2,45.5,NULL,NULL,NULL,NULL),(3927,216,3,46.1,NULL,NULL,NULL,NULL),(3928,216,7,48.5,NULL,NULL,NULL,NULL),(3929,216,14,51.8,NULL,NULL,NULL,NULL),(3930,216,28,56.3,NULL,NULL,NULL,NULL),(3931,216,56,61.8,NULL,NULL,NULL,NULL),(3932,216,90,66.7,NULL,NULL,NULL,NULL),(3933,216,180,74.6,NULL,NULL,NULL,NULL),(3934,216,360,84,NULL,NULL,NULL,NULL),(3935,217,1,71.9,NULL,NULL,NULL,NULL),(3936,217,2,77.2,NULL,NULL,NULL,NULL),(3937,217,3,81,NULL,NULL,NULL,NULL),(3938,217,7,90.1,NULL,NULL,NULL,NULL),(3939,217,14,98.3,NULL,NULL,NULL,NULL),(3940,217,28,108.2,NULL,NULL,NULL,NULL),(3941,217,56,121,NULL,NULL,NULL,NULL),(3942,217,90,131.9,NULL,NULL,NULL,NULL),(3943,217,180,146.1,NULL,NULL,NULL,NULL),(3944,217,360,157.3,NULL,NULL,NULL,NULL),(3945,217,720,166.1,NULL,NULL,NULL,NULL),(3946,217,1080,170.6,NULL,NULL,NULL,NULL),(3947,217,1440,173.8,NULL,NULL,NULL,NULL),(3948,217,1800,175.6,NULL,NULL,NULL,NULL),(3949,218,1,37.7,NULL,NULL,NULL,NULL),(3950,218,2,39.8,NULL,NULL,NULL,NULL),(3951,218,3,41.4,NULL,NULL,NULL,NULL),(3952,218,7,45.6,NULL,NULL,NULL,NULL),(3953,218,14,50.1,NULL,NULL,NULL,NULL),(3954,218,28,55.2,NULL,NULL,NULL,NULL),(3955,218,56,62.2,NULL,NULL,NULL,NULL),(3956,218,90,67.8,NULL,NULL,NULL,NULL),(3957,218,180,77.2,NULL,NULL,NULL,NULL),(3958,218,360,81.8,NULL,NULL,NULL,NULL),(3959,219,1,52.7,NULL,NULL,NULL,NULL),(3960,219,2,56.4,NULL,NULL,NULL,NULL),(3961,219,3,57.8,NULL,NULL,NULL,NULL),(3962,219,7,66,NULL,NULL,NULL,NULL),(3963,219,14,74.2,NULL,NULL,NULL,NULL),(3964,219,28,84.8,NULL,NULL,NULL,NULL),(3965,219,56,96.1,NULL,NULL,NULL,NULL),(3966,219,90,102.7,NULL,NULL,NULL,NULL),(3967,219,180,111.8,NULL,NULL,NULL,NULL),(3968,219,360,120,NULL,NULL,NULL,NULL),(3969,219,720,127.3,NULL,NULL,NULL,NULL),(3970,220,1,46.9,NULL,NULL,NULL,NULL),(3971,220,2,50.6,NULL,NULL,NULL,NULL),(3972,220,3,52.5,NULL,NULL,NULL,NULL),(3973,220,7,57.9,NULL,NULL,NULL,NULL),(3974,220,14,63.4,NULL,NULL,NULL,NULL),(3975,220,28,70.7,NULL,NULL,NULL,NULL),(3976,220,56,79.9,NULL,NULL,NULL,NULL),(3977,220,90,86.5,NULL,NULL,NULL,NULL),(3978,220,180,95.3,NULL,NULL,NULL,NULL),(3979,220,360,103.2,NULL,NULL,NULL,NULL),(3980,221,1,39.8,NULL,NULL,NULL,NULL),(3981,221,2,41.9,NULL,NULL,NULL,NULL),(3982,221,3,43.4,NULL,NULL,NULL,NULL),(3983,221,7,47.4,NULL,NULL,NULL,NULL),(3984,221,14,50.6,NULL,NULL,NULL,NULL),(3985,221,28,54.6,NULL,NULL,NULL,NULL),(3986,221,56,60,NULL,NULL,NULL,NULL),(3987,221,90,63.6,NULL,NULL,NULL,NULL),(3988,221,180,70.3,NULL,NULL,NULL,NULL),(3989,221,360,78.4,NULL,NULL,NULL,NULL),(3990,222,1,27.3,NULL,NULL,NULL,NULL),(3991,222,2,30,NULL,NULL,NULL,NULL),(3992,222,3,32.4,NULL,NULL,NULL,NULL),(3993,222,7,38.9,NULL,NULL,NULL,NULL),(3994,222,14,45.9,NULL,NULL,NULL,NULL),(3995,222,28,53.4,NULL,NULL,NULL,NULL),(3996,222,56,62.4,NULL,NULL,NULL,NULL),(3997,222,90,68.3,NULL,NULL,NULL,NULL),(3998,222,180,77.7,NULL,NULL,NULL,NULL),(3999,222,360,87.5,NULL,NULL,NULL,NULL),(4000,222,720,98.3,NULL,NULL,NULL,NULL),(4001,223,1,28.3,NULL,NULL,NULL,NULL),(4002,223,2,28.5,NULL,NULL,NULL,NULL),(4003,223,3,28.8,NULL,NULL,NULL,NULL),(4004,223,7,29.9,NULL,NULL,NULL,NULL),(4005,223,14,34.9,NULL,NULL,NULL,NULL),(4006,223,28,41.3,NULL,NULL,NULL,NULL),(4007,223,56,49.4,NULL,NULL,NULL,NULL),(4008,223,90,54.1,NULL,NULL,NULL,NULL),(4009,223,180,62.9,NULL,NULL,NULL,NULL),(4010,223,360,70.3,NULL,NULL,NULL,NULL),(4011,223,720,77,NULL,NULL,NULL,NULL),(4012,224,1,29.3,NULL,NULL,NULL,NULL),(4013,224,2,30.1,NULL,NULL,NULL,NULL),(4014,224,3,31.7,NULL,NULL,NULL,NULL),(4015,224,7,38.6,NULL,NULL,NULL,NULL),(4016,224,14,46,NULL,NULL,NULL,NULL),(4017,224,28,55.4,NULL,NULL,NULL,NULL),(4018,224,56,66,NULL,NULL,NULL,NULL),(4019,224,90,73.1,NULL,NULL,NULL,NULL),(4020,224,180,85.3,NULL,NULL,NULL,NULL),(4021,224,360,98.2,NULL,NULL,NULL,NULL),(4022,224,720,110.6,NULL,NULL,NULL,NULL),(4023,225,1,46.2,NULL,NULL,NULL,NULL),(4024,225,2,50.5,NULL,NULL,NULL,NULL),(4025,225,3,53.3,NULL,NULL,NULL,NULL),(4026,225,7,59.1,NULL,NULL,NULL,NULL),(4027,225,14,66.1,NULL,NULL,NULL,NULL),(4028,225,28,72.2,NULL,NULL,NULL,NULL),(4029,225,56,79.5,NULL,NULL,NULL,NULL),(4030,225,90,84.6,NULL,NULL,NULL,NULL),(4031,225,180,94.3,NULL,NULL,NULL,NULL),(4032,225,360,104.5,NULL,NULL,NULL,NULL),(4033,226,1,29.4,NULL,NULL,NULL,NULL),(4034,226,2,31.4,NULL,NULL,NULL,NULL),(4035,226,3,32.4,NULL,NULL,NULL,NULL),(4036,226,7,36.5,NULL,NULL,NULL,NULL),(4037,226,14,39.9,NULL,NULL,NULL,NULL),(4038,226,28,44.4,NULL,NULL,NULL,NULL),(4039,226,56,49,NULL,NULL,NULL,NULL),(4040,226,90,52.6,NULL,NULL,NULL,NULL),(4041,226,180,59.7,NULL,NULL,NULL,NULL),(4042,226,360,68.1,NULL,NULL,NULL,NULL),(4043,227,1,47.1,NULL,NULL,NULL,NULL),(4044,227,3,51.9,NULL,NULL,NULL,NULL),(4045,227,7,54.9,NULL,NULL,NULL,NULL),(4046,227,28,68.6,NULL,NULL,NULL,NULL),(4047,227,91,80.3,NULL,NULL,NULL,NULL),(4048,227,182,89.1,NULL,NULL,NULL,NULL),(4049,227,365,93.7,NULL,NULL,NULL,NULL),(4050,227,730,97.5,NULL,NULL,NULL,NULL),(4051,227,1095,100.2,NULL,NULL,NULL,NULL),(4052,227,1460,101.5,NULL,NULL,NULL,NULL),(4053,227,1825,102.1,NULL,NULL,NULL,NULL),(4054,227,2190,103.2,NULL,NULL,NULL,NULL),(4055,228,1,41.7,NULL,NULL,NULL,NULL),(4056,228,3,47.4,NULL,NULL,NULL,NULL),(4057,228,7,51.2,NULL,NULL,NULL,NULL),(4058,228,28,61.2,NULL,NULL,NULL,NULL),(4059,228,91,66.8,NULL,NULL,NULL,NULL),(4060,228,182,80.2,NULL,NULL,NULL,NULL),(4061,228,365,85.9,NULL,NULL,NULL,NULL),(4062,228,730,89.7,NULL,NULL,NULL,NULL),(4063,228,1095,91.7,NULL,NULL,NULL,NULL),(4064,228,1460,92.8,NULL,NULL,NULL,NULL),(4065,228,1825,94.8,NULL,NULL,NULL,NULL),(4066,228,2190,94.8,NULL,NULL,NULL,NULL),(4067,229,1,33,NULL,NULL,NULL,NULL),(4068,229,3,37.9,NULL,NULL,NULL,NULL),(4069,229,7,40.1,NULL,NULL,NULL,NULL),(4070,229,28,46.7,NULL,NULL,NULL,NULL),(4071,229,91,53.2,NULL,NULL,NULL,NULL),(4072,229,182,59.8,NULL,NULL,NULL,NULL),(4073,229,365,66.1,NULL,NULL,NULL,NULL),(4074,229,730,71.4,NULL,NULL,NULL,NULL),(4075,229,1095,72.7,NULL,NULL,NULL,NULL),(4076,229,1460,73.9,NULL,NULL,NULL,NULL),(4077,229,1825,74.8,NULL,NULL,NULL,NULL),(4078,229,2190,77.4,NULL,NULL,NULL,NULL),(4079,230,1,50.3,NULL,NULL,NULL,NULL),(4080,230,3,60.9,NULL,NULL,NULL,NULL),(4081,230,7,68.1,NULL,NULL,NULL,NULL),(4082,230,28,80.3,NULL,NULL,NULL,NULL),(4083,230,91,98,NULL,NULL,NULL,NULL),(4084,230,182,111.4,NULL,NULL,NULL,NULL),(4085,230,365,120.1,NULL,NULL,NULL,NULL),(4086,230,730,126.9,NULL,NULL,NULL,NULL),(4087,230,1095,131.1,NULL,NULL,NULL,NULL),(4088,230,1460,133.4,NULL,NULL,NULL,NULL),(4089,230,1825,134.2,NULL,NULL,NULL,NULL),(4090,230,2190,136.5,NULL,NULL,NULL,NULL),(4091,231,1,41.5,NULL,NULL,NULL,NULL),(4092,231,3,48.7,NULL,NULL,NULL,NULL),(4093,231,7,52.5,NULL,NULL,NULL,NULL),(4094,231,28,66.4,NULL,NULL,NULL,NULL),(4095,231,91,84.7,NULL,NULL,NULL,NULL),(4096,231,182,98.8,NULL,NULL,NULL,NULL),(4097,231,365,107.5,NULL,NULL,NULL,NULL),(4098,231,730,114.3,NULL,NULL,NULL,NULL),(4099,231,1095,118.4,NULL,NULL,NULL,NULL),(4100,231,1460,120.5,NULL,NULL,NULL,NULL),(4101,231,1825,123.3,NULL,NULL,NULL,NULL),(4102,231,2190,123.9,NULL,NULL,NULL,NULL),(4103,232,1,36.4,NULL,NULL,NULL,NULL),(4104,232,3,40.3,NULL,NULL,NULL,NULL),(4105,232,7,43.5,NULL,NULL,NULL,NULL),(4106,232,28,54.4,NULL,NULL,NULL,NULL),(4107,232,91,65.6,NULL,NULL,NULL,NULL),(4108,232,182,74.8,NULL,NULL,NULL,NULL),(4109,232,365,85.1,NULL,NULL,NULL,NULL),(4110,232,730,89.6,NULL,NULL,NULL,NULL),(4111,232,1095,91.7,NULL,NULL,NULL,NULL),(4112,232,1460,93.3,NULL,NULL,NULL,NULL),(4113,232,1825,92.1,NULL,NULL,NULL,NULL),(4114,232,2190,93.6,NULL,NULL,NULL,NULL),(4115,233,1,50.8,NULL,NULL,NULL,NULL),(4116,233,3,58.3,NULL,NULL,NULL,NULL),(4117,233,7,64.2,NULL,NULL,NULL,NULL),(4118,233,28,74.7,NULL,NULL,NULL,NULL),(4119,233,91,89.3,NULL,NULL,NULL,NULL),(4120,233,182,93.2,NULL,NULL,NULL,NULL),(4121,233,365,95.9,NULL,NULL,NULL,NULL),(4122,233,730,99.1,NULL,NULL,NULL,NULL),(4123,233,1095,101.1,NULL,NULL,NULL,NULL),(4124,233,1460,101,NULL,NULL,NULL,NULL),(4125,233,1825,100.4,NULL,NULL,NULL,NULL),(4126,233,2190,100.3,NULL,NULL,NULL,NULL),(4127,234,1,39.4,NULL,NULL,NULL,NULL),(4128,234,3,40.4,NULL,NULL,NULL,NULL),(4129,234,7,48.7,NULL,NULL,NULL,NULL),(4130,234,28,60.5,NULL,NULL,NULL,NULL),(4131,234,91,68.7,NULL,NULL,NULL,NULL),(4132,234,182,73.6,NULL,NULL,NULL,NULL),(4133,234,365,77.7,NULL,NULL,NULL,NULL),(4134,234,730,80.6,NULL,NULL,NULL,NULL),(4135,234,1095,82.6,NULL,NULL,NULL,NULL),(4136,234,1460,83.7,NULL,NULL,NULL,NULL),(4137,234,1825,82.6,NULL,NULL,NULL,NULL),(4138,234,2190,85.3,NULL,NULL,NULL,NULL),(4139,235,1,27.2,NULL,NULL,NULL,NULL),(4140,235,3,31,NULL,NULL,NULL,NULL),(4141,235,7,35.9,NULL,NULL,NULL,NULL),(4142,235,28,45.3,NULL,NULL,NULL,NULL),(4143,235,91,55.6,NULL,NULL,NULL,NULL),(4144,235,182,61.6,NULL,NULL,NULL,NULL),(4145,235,365,65.9,NULL,NULL,NULL,NULL),(4146,235,730,69.4,NULL,NULL,NULL,NULL),(4147,235,1095,71.4,NULL,NULL,NULL,NULL),(4148,235,1460,72.7,NULL,NULL,NULL,NULL),(4149,235,1825,74.1,NULL,NULL,NULL,NULL),(4150,235,2190,73.8,NULL,NULL,NULL,NULL),(4151,236,1,55.4,NULL,NULL,NULL,NULL),(4152,236,3,66.3,NULL,NULL,NULL,NULL),(4153,236,7,72.7,NULL,NULL,NULL,NULL),(4154,236,28,89,NULL,NULL,NULL,NULL),(4155,236,91,103,NULL,NULL,NULL,NULL),(4156,236,182,112.4,NULL,NULL,NULL,NULL),(4157,236,365,116.9,NULL,NULL,NULL,NULL),(4158,236,730,122,NULL,NULL,NULL,NULL),(4159,236,1095,125.8,NULL,NULL,NULL,NULL),(4160,236,1460,127.3,NULL,NULL,NULL,NULL),(4161,236,1825,129.6,NULL,NULL,NULL,NULL),(4162,236,2190,130.1,NULL,NULL,NULL,NULL),(4163,237,1,45.4,NULL,NULL,NULL,NULL),(4164,237,3,52.1,NULL,NULL,NULL,NULL),(4165,237,7,59,NULL,NULL,NULL,NULL),(4166,237,28,72.7,NULL,NULL,NULL,NULL),(4167,237,91,84.9,NULL,NULL,NULL,NULL),(4168,237,182,93.7,NULL,NULL,NULL,NULL),(4169,237,365,100.5,NULL,NULL,NULL,NULL),(4170,237,730,105.1,NULL,NULL,NULL,NULL),(4171,237,1095,107.8,NULL,NULL,NULL,NULL),(4172,237,1460,109.6,NULL,NULL,NULL,NULL),(4173,237,1825,109.3,NULL,NULL,NULL,NULL),(4174,237,2190,112.6,NULL,NULL,NULL,NULL),(4175,238,1,39.5,NULL,NULL,NULL,NULL),(4176,238,3,43.6,NULL,NULL,NULL,NULL),(4177,238,7,49.6,NULL,NULL,NULL,NULL),(4178,238,28,60,NULL,NULL,NULL,NULL),(4179,238,91,71.1,NULL,NULL,NULL,NULL),(4180,238,182,78.2,NULL,NULL,NULL,NULL),(4181,238,365,84.7,NULL,NULL,NULL,NULL),(4182,238,730,89.8,NULL,NULL,NULL,NULL),(4183,238,1095,92.4,NULL,NULL,NULL,NULL),(4184,238,1460,94.1,NULL,NULL,NULL,NULL),(4185,238,1825,96.5,NULL,NULL,NULL,NULL),(4186,238,2190,96.4,NULL,NULL,NULL,NULL),(4187,239,1,58.6,NULL,NULL,NULL,NULL),(4188,239,3,66.3,NULL,NULL,NULL,NULL),(4189,239,7,71.4,NULL,NULL,NULL,NULL),(4190,239,28,80.5,NULL,NULL,NULL,NULL),(4191,239,91,88.2,NULL,NULL,NULL,NULL),(4192,239,182,92.9,NULL,NULL,NULL,NULL),(4193,239,365,96.7,NULL,NULL,NULL,NULL),(4194,239,730,100,NULL,NULL,NULL,NULL),(4195,239,1095,101.5,NULL,NULL,NULL,NULL),(4196,239,1460,103.2,NULL,NULL,NULL,NULL),(4197,239,1825,104.2,NULL,NULL,NULL,NULL),(4198,239,2190,104.3,NULL,NULL,NULL,NULL),(4199,240,1,40.3,NULL,NULL,NULL,NULL),(4200,240,3,44.2,NULL,NULL,NULL,NULL),(4201,240,7,51.5,NULL,NULL,NULL,NULL),(4202,240,28,59.5,NULL,NULL,NULL,NULL),(4203,240,91,66,NULL,NULL,NULL,NULL),(4204,240,182,68.8,NULL,NULL,NULL,NULL),(4205,240,365,70.9,NULL,NULL,NULL,NULL),(4206,240,730,73,NULL,NULL,NULL,NULL),(4207,240,1095,74.1,NULL,NULL,NULL,NULL),(4208,240,1460,74.7,NULL,NULL,NULL,NULL),(4209,240,1825,75.1,NULL,NULL,NULL,NULL),(4210,240,2190,74.9,NULL,NULL,NULL,NULL),(4211,241,1,26.6,NULL,NULL,NULL,NULL),(4212,241,3,32,NULL,NULL,NULL,NULL),(4213,241,7,34.7,NULL,NULL,NULL,NULL),(4214,241,28,41.4,NULL,NULL,NULL,NULL),(4215,241,91,48.1,NULL,NULL,NULL,NULL),(4216,241,182,52.1,NULL,NULL,NULL,NULL),(4217,241,365,51.7,NULL,NULL,NULL,NULL),(4218,241,730,54.6,NULL,NULL,NULL,NULL),(4219,241,1095,56.3,NULL,NULL,NULL,NULL),(4220,241,1460,57.3,NULL,NULL,NULL,NULL),(4221,241,1825,58.7,NULL,NULL,NULL,NULL),(4222,241,2190,58.4,NULL,NULL,NULL,NULL),(4223,242,0.065,56.9,NULL,NULL,NULL,NULL),(4224,242,1,76.4,NULL,NULL,NULL,NULL),(4225,242,2,80.3,NULL,NULL,NULL,NULL),(4226,242,4,88.1,NULL,NULL,NULL,NULL),(4227,242,5,90.5,NULL,NULL,NULL,NULL),(4228,242,6,93.1,NULL,NULL,NULL,NULL),(4229,242,7,94.3,NULL,NULL,NULL,NULL),(4230,242,8,95.8,NULL,NULL,NULL,NULL),(4231,242,11,99.1,NULL,NULL,NULL,NULL),(4232,242,14,101.7,NULL,NULL,NULL,NULL),(4233,242,18,104.5,NULL,NULL,NULL,NULL),(4234,242,21,107.8,NULL,NULL,NULL,NULL),(4235,242,28,110.6,NULL,NULL,NULL,NULL),(4236,242,39,114.4,NULL,NULL,NULL,NULL),(4237,242,53,118.1,NULL,NULL,NULL,NULL),(4238,242,67,122.2,NULL,NULL,NULL,NULL),(4239,242,81,127.5,NULL,NULL,NULL,NULL),(4240,242,102,133.1,NULL,NULL,NULL,NULL),(4241,242,123,136.9,NULL,NULL,NULL,NULL),(4242,242,137,139.2,NULL,NULL,NULL,NULL),(4243,242,165,143.3,NULL,NULL,NULL,NULL),(4244,242,242,154,NULL,NULL,NULL,NULL),(4245,242,305,159.6,NULL,NULL,NULL,NULL),(4246,242,333,161.3,NULL,NULL,NULL,NULL),(4247,242,368,162.7,NULL,NULL,NULL,NULL),(4248,242,396,164.6,NULL,NULL,NULL,NULL),(4249,242,431,166.6,NULL,NULL,NULL,NULL),(4250,242,492,168.9,NULL,NULL,NULL,NULL),(4251,242,522,172.1,NULL,NULL,NULL,NULL),(4252,242,553,173.6,NULL,NULL,NULL,NULL),(4253,243,0.11,46.3,NULL,NULL,NULL,NULL),(4254,243,1,65.6,NULL,NULL,NULL,NULL),(4255,243,2,72.2,NULL,NULL,NULL,NULL),(4256,243,3,76.8,NULL,NULL,NULL,NULL),(4257,243,4,79.2,NULL,NULL,NULL,NULL),(4258,243,7,84.8,NULL,NULL,NULL,NULL),(4259,243,10,89.1,NULL,NULL,NULL,NULL),(4260,243,14,92.3,NULL,NULL,NULL,NULL),(4261,243,17,94.8,NULL,NULL,NULL,NULL),(4262,243,21,97,NULL,NULL,NULL,NULL),(4263,243,28,97.2,NULL,NULL,NULL,NULL),(4264,243,35,98.2,NULL,NULL,NULL,NULL),(4265,243,42,103.4,NULL,NULL,NULL,NULL),(4266,243,56,105.6,NULL,NULL,NULL,NULL),(4267,243,71,108.3,NULL,NULL,NULL,NULL),(4268,243,84,112.9,NULL,NULL,NULL,NULL),(4269,243,98,114.8,NULL,NULL,NULL,NULL),(4270,243,105,116.1,NULL,NULL,NULL,NULL),(4271,243,165,126.1,NULL,NULL,NULL,NULL),(4272,243,182,126.5,NULL,NULL,NULL,NULL),(4273,243,196,127.8,NULL,NULL,NULL,NULL),(4274,243,210,129.4,NULL,NULL,NULL,NULL),(4275,243,245,132.6,NULL,NULL,NULL,NULL),(4276,243,301,136.3,NULL,NULL,NULL,NULL),(4277,243,329,138.8,NULL,NULL,NULL,NULL),(4278,243,364,140.7,NULL,NULL,NULL,NULL),(4279,243,457,143.4,NULL,NULL,NULL,NULL),(4280,243,488,146.1,NULL,NULL,NULL,NULL),(4281,243,518,148.7,NULL,NULL,NULL,NULL),(4282,243,549,150.1,NULL,NULL,NULL,NULL),(4283,244,0.0173063,41.5,NULL,NULL,NULL,NULL),(4284,244,1,60.2,NULL,NULL,NULL,NULL),(4285,244,3,66.6,NULL,NULL,NULL,NULL),(4286,244,6,71.2,NULL,NULL,NULL,NULL),(4287,244,9,74.7,NULL,NULL,NULL,NULL),(4288,244,12,77.9,NULL,NULL,NULL,NULL),(4289,244,15,80,NULL,NULL,NULL,NULL),(4290,244,18,83.6,NULL,NULL,NULL,NULL),(4291,244,23,85.8,NULL,NULL,NULL,NULL),(4292,244,30,89.6,NULL,NULL,NULL,NULL),(4293,244,40,93.1,NULL,NULL,NULL,NULL),(4294,244,50,96,NULL,NULL,NULL,NULL),(4295,244,70,100.4,NULL,NULL,NULL,NULL),(4296,244,90,103.8,NULL,NULL,NULL,NULL),(4297,244,100,105,NULL,NULL,NULL,NULL),(4298,244,120,107.6,NULL,NULL,NULL,NULL),(4299,244,140,109.7,NULL,NULL,NULL,NULL),(4300,244,180,113,NULL,NULL,NULL,NULL),(4301,244,220,115.3,NULL,NULL,NULL,NULL),(4302,244,260,117.9,NULL,NULL,NULL,NULL),(4303,244,300,119.6,NULL,NULL,NULL,NULL),(4304,244,362,122.6,NULL,NULL,NULL,NULL),(4305,244,425,126.5,NULL,NULL,NULL,NULL),(4306,244,453,127.6,NULL,NULL,NULL,NULL),(4307,244,516,129.5,NULL,NULL,NULL,NULL),(4308,244,572,131.5,NULL,NULL,NULL,NULL),(4309,244,642,132.6,NULL,NULL,NULL,NULL),(4310,244,735,135.2,NULL,NULL,NULL,NULL),(4311,244,766,136,NULL,NULL,NULL,NULL),(4312,244,796,136.7,NULL,NULL,NULL,NULL),(4313,245,0.86,34.8,NULL,NULL,NULL,NULL),(4314,245,1,35.4,NULL,NULL,NULL,NULL),(4315,245,1.2,36.7,NULL,NULL,NULL,NULL),(4316,245,1.9,38.8,NULL,NULL,NULL,NULL),(4317,245,2.2,40.5,NULL,NULL,NULL,NULL),(4318,245,3.2,40.8,NULL,NULL,NULL,NULL),(4319,245,5.1,41,NULL,NULL,NULL,NULL),(4320,245,6.2,41.2,NULL,NULL,NULL,NULL),(4321,245,7.2,41.5,NULL,NULL,NULL,NULL),(4322,245,14,42,NULL,NULL,NULL,NULL),(4323,245,21,44.5,NULL,NULL,NULL,NULL),(4324,245,28,45.2,NULL,NULL,NULL,NULL),(4325,245,56,46.8,NULL,NULL,NULL,NULL),(4326,245,90,48.2,NULL,NULL,NULL,NULL),(4327,245,121,50,NULL,NULL,NULL,NULL),(4328,245,152,50.3,NULL,NULL,NULL,NULL),(4329,245,177,51.2,NULL,NULL,NULL,NULL),(4330,245,303,53.6,NULL,NULL,NULL,NULL),(4331,245,394,55.2,NULL,NULL,NULL,NULL),(4332,245,484,55.1,NULL,NULL,NULL,NULL),(4333,245,576,55.8,NULL,NULL,NULL,NULL),(4334,245,666,56.5,NULL,NULL,NULL,NULL),(4335,245,761,58.9,NULL,NULL,NULL,NULL),(4336,246,0.0032,33.4,NULL,NULL,NULL,NULL),(4337,246,0.2,35.1,NULL,NULL,NULL,NULL),(4338,246,1.2,36.1,NULL,NULL,NULL,NULL),(4339,246,2,36.4,NULL,NULL,NULL,NULL),(4340,246,3,36.5,NULL,NULL,NULL,NULL),(4341,246,4,36.9,NULL,NULL,NULL,NULL),(4342,246,4.9,36.9,NULL,NULL,NULL,NULL),(4343,246,6,37.1,NULL,NULL,NULL,NULL),(4344,246,7,37.5,NULL,NULL,NULL,NULL),(4345,246,14,37.9,NULL,NULL,NULL,NULL),(4346,246,21,37.8,NULL,NULL,NULL,NULL),(4347,246,28,38.1,NULL,NULL,NULL,NULL),(4348,246,56,39,NULL,NULL,NULL,NULL),(4349,246,90,40.9,NULL,NULL,NULL,NULL),(4350,246,122,41.2,NULL,NULL,NULL,NULL),(4351,246,147,42.2,NULL,NULL,NULL,NULL),(4352,246,193.3,43,NULL,NULL,NULL,NULL),(4353,246,273,45.9,NULL,NULL,NULL,NULL),(4354,246,364,44.7,NULL,NULL,NULL,NULL),(4355,246,454,46,NULL,NULL,NULL,NULL),(4356,246,546,46.4,NULL,NULL,NULL,NULL),(4357,246,636,46.7,NULL,NULL,NULL,NULL),(4358,246,731,46.6,NULL,NULL,NULL,NULL),(4359,247,1,60.7,NULL,NULL,NULL,NULL),(4360,247,12,80.4,NULL,NULL,NULL,NULL),(4361,247,13,82,NULL,NULL,NULL,NULL),(4362,247,19,85.4,NULL,NULL,NULL,NULL),(4363,247,26,88.9,NULL,NULL,NULL,NULL),(4364,247,34,92.6,NULL,NULL,NULL,NULL),(4365,247,40,94.4,NULL,NULL,NULL,NULL),(4366,247,61,99,NULL,NULL,NULL,NULL),(4367,247,77,103.4,NULL,NULL,NULL,NULL),(4368,247,89,106,NULL,NULL,NULL,NULL),(4369,247,117,111.1,NULL,NULL,NULL,NULL),(4370,247,139,113.4,NULL,NULL,NULL,NULL),(4371,247,166,116.2,NULL,NULL,NULL,NULL),(4372,247,181,117.8,NULL,NULL,NULL,NULL),(4373,247,201,119.6,NULL,NULL,NULL,NULL),(4374,247,215,121.5,NULL,NULL,NULL,NULL),(4375,247,257,124.5,NULL,NULL,NULL,NULL),(4376,247,292,127.1,NULL,NULL,NULL,NULL),(4377,247,313,128.8,NULL,NULL,NULL,NULL),(4378,247,362,131.8,NULL,NULL,NULL,NULL),(4379,247,390,135.1,NULL,NULL,NULL,NULL),(4380,247,418,137.1,NULL,NULL,NULL,NULL),(4381,247,488,140.4,NULL,NULL,NULL,NULL),(4382,247,544,143.1,NULL,NULL,NULL,NULL),(4383,247,579,144.5,NULL,NULL,NULL,NULL),(4384,247,642,146.2,NULL,NULL,NULL,NULL),(4385,247,700,147.6,NULL,NULL,NULL,NULL),(4386,247,731,149.3,NULL,NULL,NULL,NULL),(4387,247,761,150.9,NULL,NULL,NULL,NULL),(4388,248,0.2,37.3,NULL,NULL,NULL,NULL),(4389,248,1.3,38.4,NULL,NULL,NULL,NULL),(4390,248,2.1,38.8,NULL,NULL,NULL,NULL),(4391,248,3,39.4,NULL,NULL,NULL,NULL),(4392,248,4.1,40,NULL,NULL,NULL,NULL),(4393,248,5,40.6,NULL,NULL,NULL,NULL),(4394,248,6.1,41,NULL,NULL,NULL,NULL),(4395,248,7,41.1,NULL,NULL,NULL,NULL),(4396,248,14,41.7,NULL,NULL,NULL,NULL),(4397,248,21,41.6,NULL,NULL,NULL,NULL),(4398,248,28,42.1,NULL,NULL,NULL,NULL),(4399,248,56,42.6,NULL,NULL,NULL,NULL),(4400,248,90,44.6,NULL,NULL,NULL,NULL),(4401,248,122,46.2,NULL,NULL,NULL,NULL),(4402,248,147,45.8,NULL,NULL,NULL,NULL),(4403,248,182,47,NULL,NULL,NULL,NULL),(4404,248,273,50.9,NULL,NULL,NULL,NULL),(4405,248,364,50.6,NULL,NULL,NULL,NULL),(4406,248,454,52.1,NULL,NULL,NULL,NULL),(4407,248,546,52.6,NULL,NULL,NULL,NULL),(4408,248,636,53,NULL,NULL,NULL,NULL),(4409,248,731,53,NULL,NULL,NULL,NULL),(4410,249,0.2,34.8,NULL,NULL,NULL,NULL),(4411,249,1.3,35.4,NULL,NULL,NULL,NULL),(4412,249,2.1,36,NULL,NULL,NULL,NULL),(4413,249,3.1,35.5,NULL,NULL,NULL,NULL),(4414,249,4.2,36.7,NULL,NULL,NULL,NULL),(4415,249,5.1,36.2,NULL,NULL,NULL,NULL),(4416,249,6.1,37,NULL,NULL,NULL,NULL),(4417,249,7.1,38.1,NULL,NULL,NULL,NULL),(4418,249,14,37.9,NULL,NULL,NULL,NULL),(4419,249,21,37,NULL,NULL,NULL,NULL),(4420,249,28,38,NULL,NULL,NULL,NULL),(4421,249,56,39.5,NULL,NULL,NULL,NULL),(4422,249,90,40,NULL,NULL,NULL,NULL),(4423,249,122,40.4,NULL,NULL,NULL,NULL),(4424,249,147,40.6,NULL,NULL,NULL,NULL),(4425,249,182,40.6,NULL,NULL,NULL,NULL),(4426,249,273,43.2,NULL,NULL,NULL,NULL),(4427,249,364,43.2,NULL,NULL,NULL,NULL),(4428,249,454,43.8,NULL,NULL,NULL,NULL),(4429,249,546,44.3,NULL,NULL,NULL,NULL),(4430,249,636,44.6,NULL,NULL,NULL,NULL),(4431,249,731,44.9,NULL,NULL,NULL,NULL),(4432,250,1,83,NULL,NULL,NULL,NULL),(4433,250,2,87,NULL,NULL,NULL,NULL),(4434,250,3,89.4,NULL,NULL,NULL,NULL),(4435,250,7,96.2,NULL,NULL,NULL,NULL),(4436,250,8,96.8,NULL,NULL,NULL,NULL),(4437,250,10,99.1,NULL,NULL,NULL,NULL),(4438,250,12,100.9,NULL,NULL,NULL,NULL),(4439,250,16,102.9,NULL,NULL,NULL,NULL),(4440,250,21,105.5,NULL,NULL,NULL,NULL),(4441,250,28,109.1,NULL,NULL,NULL,NULL),(4442,250,35,111.6,NULL,NULL,NULL,NULL),(4443,250,49,116.1,NULL,NULL,NULL,NULL),(4444,250,64,119.9,NULL,NULL,NULL,NULL),(4445,250,77,122.1,NULL,NULL,NULL,NULL),(4446,250,91,125.5,NULL,NULL,NULL,NULL),(4447,250,105,127.7,NULL,NULL,NULL,NULL),(4448,250,134,132.6,NULL,NULL,NULL,NULL),(4449,250,177,136.1,NULL,NULL,NULL,NULL),(4450,250,184,138.1,NULL,NULL,NULL,NULL),(4451,250,201,137,NULL,NULL,NULL,NULL),(4452,250,218,139,NULL,NULL,NULL,NULL),(4453,250,252,141.9,NULL,NULL,NULL,NULL),(4454,250,299,142.5,NULL,NULL,NULL,NULL),(4455,250,360,145.3,NULL,NULL,NULL,NULL),(4456,250,405,146.4,NULL,NULL,NULL,NULL),(4457,250,459,148.5,NULL,NULL,NULL,NULL),(4458,250,500,148.9,NULL,NULL,NULL,NULL),(4459,250,650,149.8,NULL,NULL,NULL,NULL),(4460,250,721,151.6,NULL,NULL,NULL,NULL),(4461,251,0.0046,43.7,NULL,NULL,NULL,NULL),(4462,251,1,63.1,NULL,NULL,NULL,NULL),(4463,251,2,66.5,NULL,NULL,NULL,NULL),(4464,251,3,68.5,NULL,NULL,NULL,NULL),(4465,251,4,72.5,NULL,NULL,NULL,NULL),(4466,251,5,73.5,NULL,NULL,NULL,NULL),(4467,251,7,76.7,NULL,NULL,NULL,NULL),(4468,251,9,77.9,NULL,NULL,NULL,NULL),(4469,251,12,81.1,NULL,NULL,NULL,NULL),(4470,251,15,83.3,NULL,NULL,NULL,NULL),(4471,251,19,86,NULL,NULL,NULL,NULL),(4472,251,25,89.2,NULL,NULL,NULL,NULL),(4473,251,34,93.2,NULL,NULL,NULL,NULL),(4474,251,48,97.4,NULL,NULL,NULL,NULL),(4475,251,62,100.9,NULL,NULL,NULL,NULL),(4476,251,76,102.5,NULL,NULL,NULL,NULL),(4477,251,90,105.6,NULL,NULL,NULL,NULL),(4478,251,103,107.4,NULL,NULL,NULL,NULL),(4479,251,133,110.2,NULL,NULL,NULL,NULL),(4480,251,162,113,NULL,NULL,NULL,NULL),(4481,251,190,113.7,NULL,NULL,NULL,NULL),(4482,251,218,117,NULL,NULL,NULL,NULL),(4483,251,255,119.5,NULL,NULL,NULL,NULL),(4484,251,295,122.5,NULL,NULL,NULL,NULL),(4485,251,386,124.5,NULL,NULL,NULL,NULL),(4486,251,501,126.7,NULL,NULL,NULL,NULL),(4487,251,586,128.9,NULL,NULL,NULL,NULL),(4488,251,681,129.3,NULL,NULL,NULL,NULL),(4489,251,720,129.6,NULL,NULL,NULL,NULL),(4490,251,765,129.8,NULL,NULL,NULL,NULL),(4491,252,0.0152231,40,NULL,NULL,NULL,NULL),(4492,252,1,52.8,NULL,NULL,NULL,NULL),(4493,252,2,55.7,NULL,NULL,NULL,NULL),(4494,252,4,58.4,NULL,NULL,NULL,NULL),(4495,252,5,60,NULL,NULL,NULL,NULL),(4496,252,8,64.3,NULL,NULL,NULL,NULL),(4497,252,11,67.5,NULL,NULL,NULL,NULL),(4498,252,15,71,NULL,NULL,NULL,NULL),(4499,252,19,72.7,NULL,NULL,NULL,NULL),(4500,252,27,75.9,NULL,NULL,NULL,NULL),(4501,252,33,77.7,NULL,NULL,NULL,NULL),(4502,252,47,81.4,NULL,NULL,NULL,NULL),(4503,252,61,84.4,NULL,NULL,NULL,NULL),(4504,252,76,87,NULL,NULL,NULL,NULL),(4505,252,97,90,NULL,NULL,NULL,NULL),(4506,252,125,94,NULL,NULL,NULL,NULL),(4507,252,146,96.7,NULL,NULL,NULL,NULL),(4508,252,174,99.9,NULL,NULL,NULL,NULL),(4509,252,197,102.5,NULL,NULL,NULL,NULL),(4510,252,231,105.9,NULL,NULL,NULL,NULL),(4511,252,244,105.5,NULL,NULL,NULL,NULL),(4512,252,285,107.5,NULL,NULL,NULL,NULL),(4513,252,369,110.4,NULL,NULL,NULL,NULL),(4514,252,425,110.4,NULL,NULL,NULL,NULL),(4515,252,488,111.1,NULL,NULL,NULL,NULL),(4516,252,551,112.1,NULL,NULL,NULL,NULL),(4517,252,587,112.5,NULL,NULL,NULL,NULL),(4518,252,641,112.7,NULL,NULL,NULL,NULL),(4519,252,705,113,NULL,NULL,NULL,NULL),(4520,252,760,113.2,NULL,NULL,NULL,NULL),(4521,253,0.120927,37.7,NULL,NULL,NULL,NULL),(4522,253,1,47.8,NULL,NULL,NULL,NULL),(4523,253,2,51.2,NULL,NULL,NULL,NULL),(4524,253,5,56.9,NULL,NULL,NULL,NULL),(4525,253,7,58.5,NULL,NULL,NULL,NULL),(4526,253,12,62.1,NULL,NULL,NULL,NULL),(4527,253,16,64.6,NULL,NULL,NULL,NULL),(4528,253,19,65.6,NULL,NULL,NULL,NULL),(4529,253,27,69.2,NULL,NULL,NULL,NULL),(4530,253,34,71.5,NULL,NULL,NULL,NULL),(4531,253,49,75.8,NULL,NULL,NULL,NULL),(4532,253,62,78.2,NULL,NULL,NULL,NULL),(4533,253,77,81.1,NULL,NULL,NULL,NULL),(4534,253,91,83.8,NULL,NULL,NULL,NULL),(4535,253,112,87,NULL,NULL,NULL,NULL),(4536,253,133,89.2,NULL,NULL,NULL,NULL),(4537,253,155,92.9,NULL,NULL,NULL,NULL),(4538,253,184,96,NULL,NULL,NULL,NULL),(4539,253,196,97.5,NULL,NULL,NULL,NULL),(4540,253,216,99.4,NULL,NULL,NULL,NULL),(4541,253,223,99.3,NULL,NULL,NULL,NULL),(4542,253,284,102.6,NULL,NULL,NULL,NULL),(4543,253,363,104.6,NULL,NULL,NULL,NULL),(4544,253,393,106.1,NULL,NULL,NULL,NULL),(4545,253,492,107.2,NULL,NULL,NULL,NULL),(4546,253,545,108.2,NULL,NULL,NULL,NULL),(4547,253,580,108.4,NULL,NULL,NULL,NULL),(4548,253,636,108.7,NULL,NULL,NULL,NULL),(4549,253,700,108.9,NULL,NULL,NULL,NULL),(4550,253,762,108.9,NULL,NULL,NULL,NULL),(4551,254,0.0233074,30.2,NULL,NULL,NULL,NULL),(4552,254,0.3,31.7,NULL,NULL,NULL,NULL),(4553,254,1.3,32.7,NULL,NULL,NULL,NULL),(4554,254,2,33.1,NULL,NULL,NULL,NULL),(4555,254,3,33.8,NULL,NULL,NULL,NULL),(4556,254,4.1,34.2,NULL,NULL,NULL,NULL),(4557,254,5,34.3,NULL,NULL,NULL,NULL),(4558,254,6,34.6,NULL,NULL,NULL,NULL),(4559,254,7.1,34.9,NULL,NULL,NULL,NULL),(4560,254,14,35.8,NULL,NULL,NULL,NULL),(4561,254,21,36.2,NULL,NULL,NULL,NULL),(4562,254,28,36.5,NULL,NULL,NULL,NULL),(4563,254,56,37.6,NULL,NULL,NULL,NULL),(4564,254,90,39.4,NULL,NULL,NULL,NULL),(4565,254,122,40.2,NULL,NULL,NULL,NULL),(4566,254,147,41,NULL,NULL,NULL,NULL),(4567,254,182,41.2,NULL,NULL,NULL,NULL),(4568,254,273,43.1,NULL,NULL,NULL,NULL),(4569,254,364,43,NULL,NULL,NULL,NULL),(4570,254,454,44,NULL,NULL,NULL,NULL),(4571,254,546,44.5,NULL,NULL,NULL,NULL),(4572,254,636,45.5,NULL,NULL,NULL,NULL),(4573,254,731,45.4,NULL,NULL,NULL,NULL),(4574,255,0.3,32,NULL,NULL,NULL,NULL),(4575,255,1.3,32.8,NULL,NULL,NULL,NULL),(4576,255,2,33.2,NULL,NULL,NULL,NULL),(4577,255,3,33.4,NULL,NULL,NULL,NULL),(4578,255,4.1,34,NULL,NULL,NULL,NULL),(4579,255,5,33.9,NULL,NULL,NULL,NULL),(4580,255,6,34.3,NULL,NULL,NULL,NULL),(4581,255,7,34.3,NULL,NULL,NULL,NULL),(4582,255,14,35.1,NULL,NULL,NULL,NULL),(4583,255,21,35.3,NULL,NULL,NULL,NULL),(4584,255,28,35.6,NULL,NULL,NULL,NULL),(4585,255,56,36.3,NULL,NULL,NULL,NULL),(4586,255,90,37.2,NULL,NULL,NULL,NULL),(4587,255,122,37.7,NULL,NULL,NULL,NULL),(4588,255,147,38.5,NULL,NULL,NULL,NULL),(4589,255,182,38.3,NULL,NULL,NULL,NULL),(4590,255,272,39.7,NULL,NULL,NULL,NULL),(4591,255,364,39.2,NULL,NULL,NULL,NULL),(4592,255,454,39.9,NULL,NULL,NULL,NULL),(4593,255,546,40.4,NULL,NULL,NULL,NULL),(4594,255,636,40.9,NULL,NULL,NULL,NULL),(4595,255,731,41,NULL,NULL,NULL,NULL),(4596,256,1,100.8,NULL,NULL,NULL,NULL),(4597,256,2,111.4,NULL,NULL,NULL,NULL),(4598,256,3,109.4,NULL,NULL,NULL,NULL),(4599,256,4,111,NULL,NULL,NULL,NULL),(4600,256,6,113.2,NULL,NULL,NULL,NULL),(4601,256,10,116.8,NULL,NULL,NULL,NULL),(4602,256,12,119.9,NULL,NULL,NULL,NULL),(4603,256,14,123.6,NULL,NULL,NULL,NULL),(4604,256,18,124.2,NULL,NULL,NULL,NULL),(4605,256,26,125.9,NULL,NULL,NULL,NULL),(4606,256,32,131.4,NULL,NULL,NULL,NULL),(4607,256,39,132.9,NULL,NULL,NULL,NULL),(4608,256,46,135.1,NULL,NULL,NULL,NULL),(4609,256,53,135.7,NULL,NULL,NULL,NULL),(4610,256,66,141.8,NULL,NULL,NULL,NULL),(4611,256,75,142.5,NULL,NULL,NULL,NULL),(4612,256,90,144.6,NULL,NULL,NULL,NULL),(4613,256,105,147.9,NULL,NULL,NULL,NULL),(4614,256,140,156.1,NULL,NULL,NULL,NULL),(4615,256,175,161.8,NULL,NULL,NULL,NULL),(4616,256,204,169.6,NULL,NULL,NULL,NULL),(4617,256,251,173.7,NULL,NULL,NULL,NULL),(4618,256,299,180.2,NULL,NULL,NULL,NULL),(4619,256,348,185.9,NULL,NULL,NULL,NULL),(4620,256,398,187.4,NULL,NULL,NULL,NULL),(4621,256,495,194.8,NULL,NULL,NULL,NULL),(4622,256,588,198.7,NULL,NULL,NULL,NULL),(4623,256,706,199.4,NULL,NULL,NULL,NULL),(4624,256,761,200.4,NULL,NULL,NULL,NULL),(4625,257,1,62.9,NULL,NULL,NULL,NULL),(4626,257,2,66.9,NULL,NULL,NULL,NULL),(4627,257,3,69.7,NULL,NULL,NULL,NULL),(4628,257,5,73.8,NULL,NULL,NULL,NULL),(4629,257,7,77,NULL,NULL,NULL,NULL),(4630,257,18,88,NULL,NULL,NULL,NULL),(4631,257,23,92.7,NULL,NULL,NULL,NULL),(4632,257,30,96.6,NULL,NULL,NULL,NULL),(4633,257,40,100.7,NULL,NULL,NULL,NULL),(4634,257,48,102.7,NULL,NULL,NULL,NULL),(4635,257,63,111.9,NULL,NULL,NULL,NULL),(4636,257,110,125.6,NULL,NULL,NULL,NULL),(4637,257,124,130.3,NULL,NULL,NULL,NULL),(4638,257,153,136.4,NULL,NULL,NULL,NULL),(4639,257,185,141,NULL,NULL,NULL,NULL),(4640,257,216,145.7,NULL,NULL,NULL,NULL),(4641,257,277,151.9,NULL,NULL,NULL,NULL),(4642,257,306,155,NULL,NULL,NULL,NULL),(4643,257,368,157.4,NULL,NULL,NULL,NULL),(4644,257,424,162.2,NULL,NULL,NULL,NULL),(4645,257,491,165.2,NULL,NULL,NULL,NULL),(4646,257,524,166.5,NULL,NULL,NULL,NULL),(4647,257,559,168.1,NULL,NULL,NULL,NULL),(4648,257,604,168.6,NULL,NULL,NULL,NULL),(4649,257,667,170.7,NULL,NULL,NULL,NULL),(4650,257,699,172.1,NULL,NULL,NULL,NULL),(4651,257,786,174.2,NULL,NULL,NULL,NULL),(4652,257,817,174.2,NULL,NULL,NULL,NULL),(4653,257,849,174.5,NULL,NULL,NULL,NULL),(4654,258,1,57.3,NULL,NULL,NULL,NULL),(4655,258,2,60.8,NULL,NULL,NULL,NULL),(4656,258,3,63.5,NULL,NULL,NULL,NULL),(4657,258,7,69.5,NULL,NULL,NULL,NULL),(4658,258,8,70.8,NULL,NULL,NULL,NULL),(4659,258,10,73.6,NULL,NULL,NULL,NULL),(4660,258,13,76.9,NULL,NULL,NULL,NULL),(4661,258,16,79.4,NULL,NULL,NULL,NULL),(4662,258,20,82.6,NULL,NULL,NULL,NULL),(4663,258,27,87.2,NULL,NULL,NULL,NULL),(4664,258,35,90.9,NULL,NULL,NULL,NULL),(4665,258,42,94.3,NULL,NULL,NULL,NULL),(4666,258,48,96.6,NULL,NULL,NULL,NULL),(4667,258,55,99.4,NULL,NULL,NULL,NULL),(4668,258,67,102.8,NULL,NULL,NULL,NULL),(4669,258,83,105.6,NULL,NULL,NULL,NULL),(4670,258,97,108.9,NULL,NULL,NULL,NULL),(4671,258,125,113.5,NULL,NULL,NULL,NULL),(4672,258,168,120.9,NULL,NULL,NULL,NULL),(4673,258,202,126.2,NULL,NULL,NULL,NULL),(4674,258,259,134.5,NULL,NULL,NULL,NULL),(4675,258,306,139.9,NULL,NULL,NULL,NULL),(4676,258,363,146,NULL,NULL,NULL,NULL),(4677,258,425,148.7,NULL,NULL,NULL,NULL),(4678,258,544,154.6,NULL,NULL,NULL,NULL),(4679,258,642,158.5,NULL,NULL,NULL,NULL),(4680,258,698,159.5,NULL,NULL,NULL,NULL),(4681,258,762,159.4,NULL,NULL,NULL,NULL),(4682,258,817,160.1,NULL,NULL,NULL,NULL),(4683,259,0.2,37.1,NULL,NULL,NULL,NULL),(4684,259,1.2,38.2,NULL,NULL,NULL,NULL),(4685,259,2,38.8,NULL,NULL,NULL,NULL),(4686,259,3,39.3,NULL,NULL,NULL,NULL),(4687,259,4.1,39.7,NULL,NULL,NULL,NULL),(4688,259,5,40.6,NULL,NULL,NULL,NULL),(4689,259,6,40.9,NULL,NULL,NULL,NULL),(4690,259,7,40.9,NULL,NULL,NULL,NULL),(4691,259,14,41.5,NULL,NULL,NULL,NULL),(4692,259,21,41.7,NULL,NULL,NULL,NULL),(4693,259,28,42.5,NULL,NULL,NULL,NULL),(4694,259,56,43.3,NULL,NULL,NULL,NULL),(4695,259,90,45,NULL,NULL,NULL,NULL),(4696,259,122,46.2,NULL,NULL,NULL,NULL),(4697,259,146,47.3,NULL,NULL,NULL,NULL),(4698,259,182,47.8,NULL,NULL,NULL,NULL),(4699,259,273,49.7,NULL,NULL,NULL,NULL),(4700,259,364,49.3,NULL,NULL,NULL,NULL),(4701,259,454,50.8,NULL,NULL,NULL,NULL),(4702,259,546,51.5,NULL,NULL,NULL,NULL),(4703,259,636,52.4,NULL,NULL,NULL,NULL),(4704,259,731,52.6,NULL,NULL,NULL,NULL),(4705,260,1,59.5,NULL,NULL,NULL,NULL),(4706,260,2,64,NULL,NULL,NULL,NULL),(4707,260,3,66.7,NULL,NULL,NULL,NULL),(4708,260,6,73,NULL,NULL,NULL,NULL),(4709,260,7,73.9,NULL,NULL,NULL,NULL),(4710,260,8,75.3,NULL,NULL,NULL,NULL),(4711,260,10,78.3,NULL,NULL,NULL,NULL),(4712,260,13,80.3,NULL,NULL,NULL,NULL),(4713,260,17,83.3,NULL,NULL,NULL,NULL),(4714,260,20,87.9,NULL,NULL,NULL,NULL),(4715,260,28,89.4,NULL,NULL,NULL,NULL),(4716,260,36,91.9,NULL,NULL,NULL,NULL),(4717,260,42,93.7,NULL,NULL,NULL,NULL),(4718,260,48,96.3,NULL,NULL,NULL,NULL),(4719,260,56,95.7,NULL,NULL,NULL,NULL),(4720,260,70,97.8,NULL,NULL,NULL,NULL),(4721,260,85,99.6,NULL,NULL,NULL,NULL),(4722,260,106,101.9,NULL,NULL,NULL,NULL),(4723,260,127,103.2,NULL,NULL,NULL,NULL),(4724,260,162,106.6,NULL,NULL,NULL,NULL),(4725,260,205,111.2,NULL,NULL,NULL,NULL),(4726,260,245,113.5,NULL,NULL,NULL,NULL),(4727,260,301,117.6,NULL,NULL,NULL,NULL),(4728,260,357,121.7,NULL,NULL,NULL,NULL),(4729,260,399,124.6,NULL,NULL,NULL,NULL),(4730,260,518,128.9,NULL,NULL,NULL,NULL),(4731,260,610,133.3,NULL,NULL,NULL,NULL),(4732,260,728,133.5,NULL,NULL,NULL,NULL),(4733,260,791,133.7,NULL,NULL,NULL,NULL),(4734,261,1,50.5,NULL,NULL,NULL,NULL),(4735,261,2,54.2,NULL,NULL,NULL,NULL),(4736,261,3,56.8,NULL,NULL,NULL,NULL),(4737,261,6,60.6,NULL,NULL,NULL,NULL),(4738,261,7,61.4,NULL,NULL,NULL,NULL),(4739,261,9,63.4,NULL,NULL,NULL,NULL),(4740,261,14,66.4,NULL,NULL,NULL,NULL),(4741,261,17,67,NULL,NULL,NULL,NULL),(4742,261,27,71.8,NULL,NULL,NULL,NULL),(4743,261,34,73.3,NULL,NULL,NULL,NULL),(4744,261,41,75.1,NULL,NULL,NULL,NULL),(4745,261,48,76.5,NULL,NULL,NULL,NULL),(4746,261,55,78.1,NULL,NULL,NULL,NULL),(4747,261,62,80,NULL,NULL,NULL,NULL),(4748,261,71,80.4,NULL,NULL,NULL,NULL),(4749,261,84,82.1,NULL,NULL,NULL,NULL),(4750,261,99,84,NULL,NULL,NULL,NULL),(4751,261,120,87,NULL,NULL,NULL,NULL),(4752,261,169,93.3,NULL,NULL,NULL,NULL),(4753,261,206,97.7,NULL,NULL,NULL,NULL),(4754,261,258,101.5,NULL,NULL,NULL,NULL),(4755,261,307,106.8,NULL,NULL,NULL,NULL),(4756,261,342,109.4,NULL,NULL,NULL,NULL),(4757,261,395,111.1,NULL,NULL,NULL,NULL),(4758,261,455,114,NULL,NULL,NULL,NULL),(4759,261,517,116.7,NULL,NULL,NULL,NULL),(4760,261,608,120.7,NULL,NULL,NULL,NULL),(4761,261,728,121.5,NULL,NULL,NULL,NULL),(4762,261,796,122.3,NULL,NULL,NULL,NULL),(4763,262,0.2,30.3,NULL,NULL,NULL,NULL),(4764,262,1.2,31.2,NULL,NULL,NULL,NULL),(4765,262,2,31.6,NULL,NULL,NULL,NULL),(4766,262,3,31.6,NULL,NULL,NULL,NULL),(4767,262,4.1,32,NULL,NULL,NULL,NULL),(4768,262,5,32.4,NULL,NULL,NULL,NULL),(4769,262,6,32.7,NULL,NULL,NULL,NULL),(4770,262,7,33,NULL,NULL,NULL,NULL),(4771,262,14,33.3,NULL,NULL,NULL,NULL),(4772,262,21,32.9,NULL,NULL,NULL,NULL),(4773,262,28,33.9,NULL,NULL,NULL,NULL),(4774,262,56,34.6,NULL,NULL,NULL,NULL),(4775,262,90,36,NULL,NULL,NULL,NULL),(4776,262,122,36.4,NULL,NULL,NULL,NULL),(4777,262,147,37.4,NULL,NULL,NULL,NULL),(4778,262,182,37.7,NULL,NULL,NULL,NULL),(4779,262,273,40.2,NULL,NULL,NULL,NULL),(4780,262,364,38.7,NULL,NULL,NULL,NULL),(4781,262,454,39.9,NULL,NULL,NULL,NULL),(4782,262,546,40.1,NULL,NULL,NULL,NULL),(4783,262,636,40.4,NULL,NULL,NULL,NULL),(4784,262,731,40.9,NULL,NULL,NULL,NULL),(4785,263,1,79.9,NULL,NULL,NULL,NULL),(4786,263,2,84.8,NULL,NULL,NULL,NULL),(4787,263,3,87.9,NULL,NULL,NULL,NULL),(4788,263,5,92.7,NULL,NULL,NULL,NULL),(4789,263,7,96.8,NULL,NULL,NULL,NULL),(4790,263,8,98.8,NULL,NULL,NULL,NULL),(4791,263,9,100.2,NULL,NULL,NULL,NULL),(4792,263,12,103.6,NULL,NULL,NULL,NULL),(4793,263,16,105.8,NULL,NULL,NULL,NULL),(4794,263,20,109.6,NULL,NULL,NULL,NULL),(4795,263,26,113.3,NULL,NULL,NULL,NULL),(4796,263,33,117.1,NULL,NULL,NULL,NULL),(4797,263,41,118.9,NULL,NULL,NULL,NULL),(4798,263,54,121.6,NULL,NULL,NULL,NULL),(4799,263,61,121.9,NULL,NULL,NULL,NULL),(4800,263,75,124.3,NULL,NULL,NULL,NULL),(4801,263,89,126.6,NULL,NULL,NULL,NULL),(4802,263,111,128.3,NULL,NULL,NULL,NULL),(4803,263,147,132.9,NULL,NULL,NULL,NULL),(4804,263,182,137.5,NULL,NULL,NULL,NULL),(4805,263,225,143.1,NULL,NULL,NULL,NULL),(4806,263,334,150.2,NULL,NULL,NULL,NULL),(4807,263,398,155.2,NULL,NULL,NULL,NULL),(4808,263,480,156.7,NULL,NULL,NULL,NULL),(4809,263,551,162.5,NULL,NULL,NULL,NULL),(4810,263,635,164.8,NULL,NULL,NULL,NULL),(4811,263,691,165.8,NULL,NULL,NULL,NULL),(4812,263,761,166.4,NULL,NULL,NULL,NULL),(4813,263,789,166.6,NULL,NULL,NULL,NULL),(4814,264,1,61.6,NULL,NULL,NULL,NULL),(4815,264,2,65.4,NULL,NULL,NULL,NULL),(4816,264,3,66.9,NULL,NULL,NULL,NULL),(4817,264,4,68.1,NULL,NULL,NULL,NULL),(4818,264,7,72.1,NULL,NULL,NULL,NULL),(4819,264,11,75.6,NULL,NULL,NULL,NULL),(4820,264,14,76.4,NULL,NULL,NULL,NULL),(4821,264,18,79.3,NULL,NULL,NULL,NULL),(4822,264,21,81.2,NULL,NULL,NULL,NULL),(4823,264,28,83.9,NULL,NULL,NULL,NULL),(4824,264,35,86.9,NULL,NULL,NULL,NULL),(4825,264,42,88.7,NULL,NULL,NULL,NULL),(4826,264,49,91.8,NULL,NULL,NULL,NULL),(4827,264,56,93.6,NULL,NULL,NULL,NULL),(4828,264,63,95.4,NULL,NULL,NULL,NULL),(4829,264,70,98.7,NULL,NULL,NULL,NULL),(4830,264,84,103.8,NULL,NULL,NULL,NULL),(4831,264,98,107.2,NULL,NULL,NULL,NULL),(4832,264,126,111.8,NULL,NULL,NULL,NULL),(4833,264,161,116.3,NULL,NULL,NULL,NULL),(4834,264,210,121.3,NULL,NULL,NULL,NULL),(4835,264,266,126.3,NULL,NULL,NULL,NULL),(4836,264,301,128,NULL,NULL,NULL,NULL),(4837,264,336,130.2,NULL,NULL,NULL,NULL),(4838,264,394,133.3,NULL,NULL,NULL,NULL),(4839,264,423,134.2,NULL,NULL,NULL,NULL),(4840,264,453,137.7,NULL,NULL,NULL,NULL),(4841,264,486,138.8,NULL,NULL,NULL,NULL),(4842,265,0.2,47.8,NULL,NULL,NULL,NULL),(4843,265,1.2,49.2,NULL,NULL,NULL,NULL),(4844,265,2,50.3,NULL,NULL,NULL,NULL),(4845,265,3,50.5,NULL,NULL,NULL,NULL),(4846,265,4.1,50.9,NULL,NULL,NULL,NULL),(4847,265,5,52,NULL,NULL,NULL,NULL),(4848,265,6,52.5,NULL,NULL,NULL,NULL),(4849,265,7,53.3,NULL,NULL,NULL,NULL),(4850,265,14,54.2,NULL,NULL,NULL,NULL),(4851,265,21,54,NULL,NULL,NULL,NULL),(4852,265,28,55.4,NULL,NULL,NULL,NULL),(4853,265,56,56.2,NULL,NULL,NULL,NULL),(4854,265,90,58.4,NULL,NULL,NULL,NULL),(4855,265,122,59.5,NULL,NULL,NULL,NULL),(4856,265,147,60.6,NULL,NULL,NULL,NULL),(4857,265,182,61.9,NULL,NULL,NULL,NULL),(4858,265,273,64.8,NULL,NULL,NULL,NULL),(4859,265,364,65.2,NULL,NULL,NULL,NULL),(4860,265,454,67.1,NULL,NULL,NULL,NULL),(4861,265,546,68.5,NULL,NULL,NULL,NULL),(4862,265,636,70.1,NULL,NULL,NULL,NULL),(4863,265,731,70.9,NULL,NULL,NULL,NULL),(4864,266,0.0579636,38.9,NULL,NULL,NULL,NULL),(4865,266,1,51.8,NULL,NULL,NULL,NULL),(4866,266,3,57.4,NULL,NULL,NULL,NULL),(4867,266,6,62.1,NULL,NULL,NULL,NULL),(4868,266,9,64.9,NULL,NULL,NULL,NULL),(4869,266,12,67.5,NULL,NULL,NULL,NULL),(4870,266,15,70.1,NULL,NULL,NULL,NULL),(4871,266,23,75,NULL,NULL,NULL,NULL),(4872,266,30,78.2,NULL,NULL,NULL,NULL),(4873,266,40,81.4,NULL,NULL,NULL,NULL),(4874,266,50,84.5,NULL,NULL,NULL,NULL),(4875,266,60,86.7,NULL,NULL,NULL,NULL),(4876,266,70,88.7,NULL,NULL,NULL,NULL),(4877,266,80,90.1,NULL,NULL,NULL,NULL),(4878,266,90,91.4,NULL,NULL,NULL,NULL),(4879,266,100,92.9,NULL,NULL,NULL,NULL),(4880,266,120,94.9,NULL,NULL,NULL,NULL),(4881,266,140,96.5,NULL,NULL,NULL,NULL),(4882,266,180,99.9,NULL,NULL,NULL,NULL),(4883,266,220,103,NULL,NULL,NULL,NULL),(4884,266,260,104.5,NULL,NULL,NULL,NULL),(4885,266,300,106.1,NULL,NULL,NULL,NULL),(4886,266,351,109.1,NULL,NULL,NULL,NULL),(4887,266,393,110.1,NULL,NULL,NULL,NULL),(4888,266,456,110.9,NULL,NULL,NULL,NULL),(4889,266,512,112.5,NULL,NULL,NULL,NULL),(4890,266,568,115.8,NULL,NULL,NULL,NULL),(4891,266,666,116.5,NULL,NULL,NULL,NULL),(4892,266,701,117.9,NULL,NULL,NULL,NULL),(4893,266,731,118.6,NULL,NULL,NULL,NULL),(4894,267,0.05,40.4,NULL,NULL,NULL,NULL),(4895,267,1,55.3,NULL,NULL,NULL,NULL),(4896,267,3,62.4,NULL,NULL,NULL,NULL),(4897,267,6,66.6,NULL,NULL,NULL,NULL),(4898,267,9,70.2,NULL,NULL,NULL,NULL),(4899,267,12,73,NULL,NULL,NULL,NULL),(4900,267,18,76.3,NULL,NULL,NULL,NULL),(4901,267,23,78,NULL,NULL,NULL,NULL),(4902,267,30,81.2,NULL,NULL,NULL,NULL),(4903,267,35,83.2,NULL,NULL,NULL,NULL),(4904,267,40,83.9,NULL,NULL,NULL,NULL),(4905,267,50,86.2,NULL,NULL,NULL,NULL),(4906,267,60,88.6,NULL,NULL,NULL,NULL),(4907,267,70,90.3,NULL,NULL,NULL,NULL),(4908,267,80,91.6,NULL,NULL,NULL,NULL),(4909,267,90,93.1,NULL,NULL,NULL,NULL),(4910,267,100,94.4,NULL,NULL,NULL,NULL),(4911,267,120,96.9,NULL,NULL,NULL,NULL),(4912,267,160,98.3,NULL,NULL,NULL,NULL),(4913,267,200,100.5,NULL,NULL,NULL,NULL),(4914,267,240,102.2,NULL,NULL,NULL,NULL),(4915,267,300,104.6,NULL,NULL,NULL,NULL),(4916,267,341,105.8,NULL,NULL,NULL,NULL),(4917,267,400,107.2,NULL,NULL,NULL,NULL),(4918,267,464,108.3,NULL,NULL,NULL,NULL),(4919,267,520,109.1,NULL,NULL,NULL,NULL),(4920,267,584,110.8,NULL,NULL,NULL,NULL),(4921,267,650,111.2,NULL,NULL,NULL,NULL),(4922,267,700,112.1,NULL,NULL,NULL,NULL),(4923,267,730,112.1,NULL,NULL,NULL,NULL),(4924,268,0.0469576,39.1,NULL,NULL,NULL,NULL),(4925,268,1,50.3,NULL,NULL,NULL,NULL),(4926,268,3,54.7,NULL,NULL,NULL,NULL),(4927,268,6,58.6,NULL,NULL,NULL,NULL),(4928,268,9,61.6,NULL,NULL,NULL,NULL),(4929,268,12,63.9,NULL,NULL,NULL,NULL),(4930,268,15,65.9,NULL,NULL,NULL,NULL),(4931,268,18,67.4,NULL,NULL,NULL,NULL),(4932,268,23,69.9,NULL,NULL,NULL,NULL),(4933,268,30,72.2,NULL,NULL,NULL,NULL),(4934,268,35,73.8,NULL,NULL,NULL,NULL),(4935,268,40,74.9,NULL,NULL,NULL,NULL),(4936,268,50,77.2,NULL,NULL,NULL,NULL),(4937,268,60,79.3,NULL,NULL,NULL,NULL),(4938,268,70,80.9,NULL,NULL,NULL,NULL),(4939,268,80,81.9,NULL,NULL,NULL,NULL),(4940,268,90,83.1,NULL,NULL,NULL,NULL),(4941,268,120,85,NULL,NULL,NULL,NULL),(4942,268,160,87.6,NULL,NULL,NULL,NULL),(4943,268,200,90,NULL,NULL,NULL,NULL),(4944,268,240,91.7,NULL,NULL,NULL,NULL),(4945,268,280,93,NULL,NULL,NULL,NULL),(4946,268,320,94.1,NULL,NULL,NULL,NULL),(4947,268,360,95.1,NULL,NULL,NULL,NULL),(4948,268,419,96.1,NULL,NULL,NULL,NULL),(4949,268,490,98,NULL,NULL,NULL,NULL),(4950,268,608,100.8,NULL,NULL,NULL,NULL),(4951,268,671,101.9,NULL,NULL,NULL,NULL),(4952,268,706,102.4,NULL,NULL,NULL,NULL),(4953,268,736,103.2,NULL,NULL,NULL,NULL),(4954,269,0.0642026,39.1,NULL,NULL,NULL,NULL),(4955,269,1,50.2,NULL,NULL,NULL,NULL),(4956,269,3,54.8,NULL,NULL,NULL,NULL),(4957,269,6,59.2,NULL,NULL,NULL,NULL),(4958,269,9,62,NULL,NULL,NULL,NULL),(4959,269,12,64.5,NULL,NULL,NULL,NULL),(4960,269,15,66.6,NULL,NULL,NULL,NULL),(4961,269,18,68.2,NULL,NULL,NULL,NULL),(4962,269,23,70.4,NULL,NULL,NULL,NULL),(4963,269,30,73,NULL,NULL,NULL,NULL),(4964,269,40,76.1,NULL,NULL,NULL,NULL),(4965,269,50,78.6,NULL,NULL,NULL,NULL),(4966,269,60,80.7,NULL,NULL,NULL,NULL),(4967,269,70,82.3,NULL,NULL,NULL,NULL),(4968,269,80,83.9,NULL,NULL,NULL,NULL),(4969,269,100,86.5,NULL,NULL,NULL,NULL),(4970,269,120,88.5,NULL,NULL,NULL,NULL),(4971,269,160,91.7,NULL,NULL,NULL,NULL),(4972,269,200,94,NULL,NULL,NULL,NULL),(4973,269,240,96,NULL,NULL,NULL,NULL),(4974,269,280,97.1,NULL,NULL,NULL,NULL),(4975,269,320,101.1,NULL,NULL,NULL,NULL),(4976,269,364,102.9,NULL,NULL,NULL,NULL),(4977,269,420,105.2,NULL,NULL,NULL,NULL),(4978,269,483,107.5,NULL,NULL,NULL,NULL),(4979,269,546,109.5,NULL,NULL,NULL,NULL),(4980,269,609,110.4,NULL,NULL,NULL,NULL),(4981,269,672,111.1,NULL,NULL,NULL,NULL),(4982,269,702,111.9,NULL,NULL,NULL,NULL),(4983,269,733,113,NULL,NULL,NULL,NULL),(4984,270,0.9,34.7,NULL,NULL,NULL,NULL),(4985,270,1.2,34.9,NULL,NULL,NULL,NULL),(4986,270,1.9,35.1,NULL,NULL,NULL,NULL),(4987,270,2.2,35.1,NULL,NULL,NULL,NULL),(4988,270,3.2,35.5,NULL,NULL,NULL,NULL),(4989,270,5.1,36,NULL,NULL,NULL,NULL),(4990,270,6.2,36.1,NULL,NULL,NULL,NULL),(4991,270,7.2,36.3,NULL,NULL,NULL,NULL),(4992,270,14,36.6,NULL,NULL,NULL,NULL),(4993,270,21,36.8,NULL,NULL,NULL,NULL),(4994,270,28,37,NULL,NULL,NULL,NULL),(4995,270,56,37.6,NULL,NULL,NULL,NULL),(4996,270,90,38.5,NULL,NULL,NULL,NULL),(4997,270,121,39.6,NULL,NULL,NULL,NULL),(4998,270,152,40.9,NULL,NULL,NULL,NULL),(4999,270,177,41.7,NULL,NULL,NULL,NULL),(5000,270,303,43.5,NULL,NULL,NULL,NULL),(5001,270,394,43.9,NULL,NULL,NULL,NULL),(5002,270,484,44,NULL,NULL,NULL,NULL),(5003,270,576,45,NULL,NULL,NULL,NULL),(5004,270,666,45.2,NULL,NULL,NULL,NULL),(5005,270,761,45.3,NULL,NULL,NULL,NULL),(5006,271,0.2,33.5,NULL,NULL,NULL,NULL),(5007,271,1.2,34.6,NULL,NULL,NULL,NULL),(5008,271,2,35.3,NULL,NULL,NULL,NULL),(5009,271,3,35.6,NULL,NULL,NULL,NULL),(5010,271,4.1,36,NULL,NULL,NULL,NULL),(5011,271,5,36.4,NULL,NULL,NULL,NULL),(5012,271,6,36.7,NULL,NULL,NULL,NULL),(5013,271,7,36.8,NULL,NULL,NULL,NULL),(5014,271,14,37.6,NULL,NULL,NULL,NULL),(5015,271,21,37.3,NULL,NULL,NULL,NULL),(5016,271,28,38.1,NULL,NULL,NULL,NULL),(5017,271,56,38.8,NULL,NULL,NULL,NULL),(5018,271,90,40.6,NULL,NULL,NULL,NULL),(5019,271,122,41.3,NULL,NULL,NULL,NULL),(5020,271,147,42.9,NULL,NULL,NULL,NULL),(5021,271,182,42.2,NULL,NULL,NULL,NULL),(5022,271,273,44.2,NULL,NULL,NULL,NULL),(5023,271,364,44,NULL,NULL,NULL,NULL),(5024,271,454,44.8,NULL,NULL,NULL,NULL),(5025,271,546,45.6,NULL,NULL,NULL,NULL),(5026,271,636,46,NULL,NULL,NULL,NULL),(5027,271,731,46.3,NULL,NULL,NULL,NULL),(5028,272,0.2,33.8,NULL,NULL,NULL,NULL),(5029,272,1.4,35,NULL,NULL,NULL,NULL),(5030,272,2.1,35.3,NULL,NULL,NULL,NULL),(5031,272,3.1,35.4,NULL,NULL,NULL,NULL),(5032,272,4.2,36.1,NULL,NULL,NULL,NULL),(5033,272,5.1,36.2,NULL,NULL,NULL,NULL),(5034,272,6.1,36.4,NULL,NULL,NULL,NULL),(5035,272,7.1,37,NULL,NULL,NULL,NULL),(5036,272,14,37.2,NULL,NULL,NULL,NULL),(5037,272,21,37.6,NULL,NULL,NULL,NULL),(5038,272,28,38.1,NULL,NULL,NULL,NULL),(5039,272,56,39.2,NULL,NULL,NULL,NULL),(5040,272,90,40.9,NULL,NULL,NULL,NULL),(5041,272,122,41.5,NULL,NULL,NULL,NULL),(5042,272,147,41.9,NULL,NULL,NULL,NULL),(5043,272,182,41.7,NULL,NULL,NULL,NULL),(5044,272,273,44,NULL,NULL,NULL,NULL),(5045,272,364,44.2,NULL,NULL,NULL,NULL),(5046,272,454,45,NULL,NULL,NULL,NULL),(5047,272,546,45.5,NULL,NULL,NULL,NULL),(5048,272,636,46.1,NULL,NULL,NULL,NULL),(5049,272,731,46.3,NULL,NULL,NULL,NULL),(5050,273,1.2,31.3,NULL,NULL,NULL,NULL),(5051,273,2,31.9,NULL,NULL,NULL,NULL),(5052,273,3,32.2,NULL,NULL,NULL,NULL),(5053,273,4.1,32.1,NULL,NULL,NULL,NULL),(5054,273,5,32.2,NULL,NULL,NULL,NULL),(5055,273,6,32.4,NULL,NULL,NULL,NULL),(5056,273,7,32.8,NULL,NULL,NULL,NULL),(5057,273,14,33,NULL,NULL,NULL,NULL),(5058,273,21,32.5,NULL,NULL,NULL,NULL),(5059,273,28,33,NULL,NULL,NULL,NULL),(5060,273,56,33.7,NULL,NULL,NULL,NULL),(5061,273,90,36.4,NULL,NULL,NULL,NULL),(5062,273,122,37.5,NULL,NULL,NULL,NULL),(5063,273,147,38.6,NULL,NULL,NULL,NULL),(5064,273,182,38.6,NULL,NULL,NULL,NULL),(5065,273,273,39.9,NULL,NULL,NULL,NULL),(5066,273,364,38.4,NULL,NULL,NULL,NULL),(5067,273,454,40.1,NULL,NULL,NULL,NULL),(5068,273,546,40.3,NULL,NULL,NULL,NULL),(5069,273,636,40.9,NULL,NULL,NULL,NULL),(5070,273,731,41.1,NULL,NULL,NULL,NULL),(5071,274,0.4,23.1,NULL,NULL,NULL,NULL),(5072,274,0.9,23.7,NULL,NULL,NULL,NULL),(5073,274,1.9,24,NULL,NULL,NULL,NULL),(5074,274,3,24.2,NULL,NULL,NULL,NULL),(5075,274,6.1,24.8,NULL,NULL,NULL,NULL),(5076,274,8.7,25.3,NULL,NULL,NULL,NULL),(5077,274,13,25.7,NULL,NULL,NULL,NULL),(5078,274,20,26.3,NULL,NULL,NULL,NULL),(5079,274,27.1,27.5,NULL,NULL,NULL,NULL),(5080,274,34.1,28.5,NULL,NULL,NULL,NULL),(5081,274,53.1,29.7,NULL,NULL,NULL,NULL),(5082,274,72,31.1,NULL,NULL,NULL,NULL),(5083,274,105,31.6,NULL,NULL,NULL,NULL),(5084,274,132,32.3,NULL,NULL,NULL,NULL),(5085,274,171,33,NULL,NULL,NULL,NULL),(5086,274,206,34.4,NULL,NULL,NULL,NULL),(5087,274,371,38,NULL,NULL,NULL,NULL),(5088,275,0.13,26.5,NULL,NULL,NULL,NULL),(5089,275,0.23,26.9,NULL,NULL,NULL,NULL),(5090,275,0.43,27.5,NULL,NULL,NULL,NULL),(5091,275,1.03,28.3,NULL,NULL,NULL,NULL),(5092,275,2.03,28.8,NULL,NULL,NULL,NULL),(5093,275,3.23,29.3,NULL,NULL,NULL,NULL),(5094,275,6.03,29.8,NULL,NULL,NULL,NULL),(5095,275,8.83,30.3,NULL,NULL,NULL,NULL),(5096,275,12.93,30.7,NULL,NULL,NULL,NULL),(5097,275,20.03,31.5,NULL,NULL,NULL,NULL),(5098,275,26.73,32,NULL,NULL,NULL,NULL),(5099,275,33.33,32.6,NULL,NULL,NULL,NULL),(5100,275,55.33,33.6,NULL,NULL,NULL,NULL),(5101,275,72.93,34.3,NULL,NULL,NULL,NULL),(5102,275,105.03,35.3,NULL,NULL,NULL,NULL),(5103,275,130.03,35.9,NULL,NULL,NULL,NULL),(5104,275,166.03,36.5,NULL,NULL,NULL,NULL),(5105,275,201.03,37.2,NULL,NULL,NULL,NULL),(5106,275,265.03,38,NULL,NULL,NULL,NULL),(5107,276,1,35.6,NULL,NULL,NULL,NULL),(5108,276,2,38.1,NULL,NULL,NULL,NULL),(5109,276,3,39.9,NULL,NULL,NULL,NULL),(5110,276,4,41.3,NULL,NULL,NULL,NULL),(5111,276,5,43,NULL,NULL,NULL,NULL),(5112,276,6.3,44.1,NULL,NULL,NULL,NULL),(5113,276,7,46.2,NULL,NULL,NULL,NULL),(5114,276,15,47.8,NULL,NULL,NULL,NULL),(5115,276,31,52.2,NULL,NULL,NULL,NULL),(5116,276,45,55.4,NULL,NULL,NULL,NULL),(5117,276,60,61.4,NULL,NULL,NULL,NULL),(5118,277,1,38.2,NULL,NULL,NULL,NULL),(5119,277,2,40.9,NULL,NULL,NULL,NULL),(5120,277,3,42.4,NULL,NULL,NULL,NULL),(5121,277,4,43.4,NULL,NULL,NULL,NULL),(5122,277,5,45.9,NULL,NULL,NULL,NULL),(5123,277,6.3,46.7,NULL,NULL,NULL,NULL),(5124,277,7,47.1,NULL,NULL,NULL,NULL),(5125,277,15,51.6,NULL,NULL,NULL,NULL),(5126,277,31,54.6,NULL,NULL,NULL,NULL),(5127,277,45,56.8,NULL,NULL,NULL,NULL),(5128,277,60,58.9,NULL,NULL,NULL,NULL),(5129,278,1,34.2,NULL,NULL,NULL,NULL),(5130,278,2,35.7,NULL,NULL,NULL,NULL),(5131,278,3,36.6,NULL,NULL,NULL,NULL),(5132,278,4,37,NULL,NULL,NULL,NULL),(5133,278,5,37.4,NULL,NULL,NULL,NULL),(5134,278,7,39.3,NULL,NULL,NULL,NULL),(5135,278,20,43.8,NULL,NULL,NULL,NULL),(5136,278,31,50.5,NULL,NULL,NULL,NULL),(5137,278,45,55.2,NULL,NULL,NULL,NULL),(5138,278,60,60,NULL,NULL,NULL,NULL),(5139,279,0.2,47.9,NULL,NULL,NULL,NULL),(5140,279,0.6,61.8,NULL,NULL,NULL,NULL),(5141,279,1.5,65.7,NULL,NULL,NULL,NULL),(5142,279,7.6,98.4,NULL,NULL,NULL,NULL),(5143,279,20.2,109.1,NULL,NULL,NULL,NULL),(5144,279,55.1,112.6,NULL,NULL,NULL,NULL),(5145,279,150,161.6,NULL,NULL,NULL,NULL),(5146,280,0.1,46.4,NULL,NULL,NULL,NULL),(5147,280,0.2,52.4,NULL,NULL,NULL,NULL),(5148,280,0.6,64.3,NULL,NULL,NULL,NULL),(5149,280,1.6,72.2,NULL,NULL,NULL,NULL),(5150,280,7.9,94,NULL,NULL,NULL,NULL),(5151,280,20.5,108.6,NULL,NULL,NULL,NULL),(5152,280,55.1,129,NULL,NULL,NULL,NULL),(5153,280,150,173.5,NULL,NULL,NULL,NULL),(5154,281,0.04,34.4,NULL,NULL,NULL,NULL),(5155,281,0.2,47.4,NULL,NULL,NULL,NULL),(5156,281,0.6,57.7,NULL,NULL,NULL,NULL),(5157,281,1.5,67,NULL,NULL,NULL,NULL),(5158,281,7.5,90,NULL,NULL,NULL,NULL),(5159,281,20.5,100.5,NULL,NULL,NULL,NULL),(5160,281,55.1,110.5,NULL,NULL,NULL,NULL),(5161,281,150,132,NULL,NULL,NULL,NULL),(5162,282,0.1,54.5,NULL,NULL,NULL,NULL),(5163,282,0.2,58.1,NULL,NULL,NULL,NULL),(5164,282,0.6,68.3,NULL,NULL,NULL,NULL),(5165,282,1.6,76.3,NULL,NULL,NULL,NULL),(5166,282,7.8,89.1,NULL,NULL,NULL,NULL),(5167,282,20.5,97.6,NULL,NULL,NULL,NULL),(5168,282,55.1,108,NULL,NULL,NULL,NULL),(5169,282,150,132.3,NULL,NULL,NULL,NULL),(5170,283,0.1,53.1,NULL,NULL,NULL,NULL),(5171,283,0.4,57.2,NULL,NULL,NULL,NULL),(5172,283,0.8,59.8,NULL,NULL,NULL,NULL),(5173,283,1.8,67,NULL,NULL,NULL,NULL),(5174,283,6.9,73.9,NULL,NULL,NULL,NULL),(5175,283,12.9,90.1,NULL,NULL,NULL,NULL),(5176,283,45.5,89.4,NULL,NULL,NULL,NULL),(5177,283,144,117.1,NULL,NULL,NULL,NULL),(5178,284,0.2,58.2,NULL,NULL,NULL,NULL),(5179,284,0.7,65,NULL,NULL,NULL,NULL),(5180,284,1.6,70,NULL,NULL,NULL,NULL),(5181,284,6.5,82.2,NULL,NULL,NULL,NULL),(5182,284,13,90.9,NULL,NULL,NULL,NULL),(5183,284,65.3,117.7,NULL,NULL,NULL,NULL),(5184,284,144,126.9,NULL,NULL,NULL,NULL),(5185,285,0.2,62.3,NULL,NULL,NULL,NULL),(5186,285,0.7,82.6,NULL,NULL,NULL,NULL),(5187,285,1.6,89.9,NULL,NULL,NULL,NULL),(5188,285,6.4,107.7,NULL,NULL,NULL,NULL),(5189,285,13.5,122.7,NULL,NULL,NULL,NULL),(5190,285,32.2,153.5,NULL,NULL,NULL,NULL),(5191,285,144,210.1,NULL,NULL,NULL,NULL),(5192,286,0.1,89.1,NULL,NULL,NULL,NULL),(5193,286,0.3,96.1,NULL,NULL,NULL,NULL),(5194,286,0.7,107.1,NULL,NULL,NULL,NULL),(5195,286,1.7,108.2,NULL,NULL,NULL,NULL),(5196,286,6.9,122.1,NULL,NULL,NULL,NULL),(5197,286,13.9,140.9,NULL,NULL,NULL,NULL),(5198,286,48,171.4,NULL,NULL,NULL,NULL),(5199,286,144,230,NULL,NULL,NULL,NULL),(5200,287,0.2,48.8,NULL,NULL,NULL,NULL),(5201,287,0.6,57.5,NULL,NULL,NULL,NULL),(5202,287,1.1,59.4,NULL,NULL,NULL,NULL),(5203,287,2,62.5,NULL,NULL,NULL,NULL),(5204,287,5.6,75.3,NULL,NULL,NULL,NULL),(5205,287,6.6,79.6,NULL,NULL,NULL,NULL),(5206,287,8.7,82.4,NULL,NULL,NULL,NULL),(5207,287,12.9,86.9,NULL,NULL,NULL,NULL),(5208,287,15.6,95.4,NULL,NULL,NULL,NULL),(5209,287,19.2,101.4,NULL,NULL,NULL,NULL),(5210,287,27.9,107.4,NULL,NULL,NULL,NULL),(5211,287,37.1,112.3,NULL,NULL,NULL,NULL),(5212,287,51.2,118.8,NULL,NULL,NULL,NULL),(5213,287,65.4,131.1,NULL,NULL,NULL,NULL),(5214,287,100,136.5,NULL,NULL,NULL,NULL),(5215,287,128,141.7,NULL,NULL,NULL,NULL),(5216,287,153,146.9,NULL,NULL,NULL,NULL),(5217,287,206,152.2,NULL,NULL,NULL,NULL),(5218,288,0.3,51.7,NULL,NULL,NULL,NULL),(5219,288,0.6,59.6,NULL,NULL,NULL,NULL),(5220,288,1.1,67.4,NULL,NULL,NULL,NULL),(5221,288,2.2,72.6,NULL,NULL,NULL,NULL),(5222,288,5.4,83.3,NULL,NULL,NULL,NULL),(5223,288,6.3,85.9,NULL,NULL,NULL,NULL),(5224,288,8.4,93.9,NULL,NULL,NULL,NULL),(5225,288,11.6,97.8,NULL,NULL,NULL,NULL),(5226,288,15.2,108.5,NULL,NULL,NULL,NULL),(5227,288,20.9,115,NULL,NULL,NULL,NULL),(5228,288,27.6,123.3,NULL,NULL,NULL,NULL),(5229,288,34.5,132.7,NULL,NULL,NULL,NULL),(5230,288,47.5,140.3,NULL,NULL,NULL,NULL),(5231,288,65.4,150.4,NULL,NULL,NULL,NULL),(5232,288,96.3,160.6,NULL,NULL,NULL,NULL),(5233,288,120,170.8,NULL,NULL,NULL,NULL),(5234,288,152,175.8,NULL,NULL,NULL,NULL),(5235,288,202,182.6,NULL,NULL,NULL,NULL),(5236,288,240,188.7,NULL,NULL,NULL,NULL),(5237,288,315,191.5,NULL,NULL,NULL,NULL),(5238,288,371,195.1,NULL,NULL,NULL,NULL),(5239,288,464,197.3,NULL,NULL,NULL,NULL),(5240,288,767,204,NULL,NULL,NULL,NULL),(5241,288,963,210.5,NULL,NULL,NULL,NULL),(5242,289,19.5402,39.2332,NULL,NULL,NULL,NULL),(5243,289,29.8851,39.9216,NULL,NULL,NULL,NULL),(5244,289,36.3985,41.5281,NULL,NULL,NULL,NULL),(5245,289,43.6782,43.2492,NULL,NULL,NULL,NULL),(5246,289,57.0881,45.0851,NULL,NULL,NULL,NULL),(5247,289,72.0307,46.8063,NULL,NULL,NULL,NULL),(5248,289,86.2069,47.0358,NULL,NULL,NULL,NULL),(5249,289,105.747,48.298,NULL,NULL,NULL,NULL),(5250,289,124.904,46.921,NULL,NULL,NULL,NULL),(5251,289,141.762,48.6421,NULL,NULL,NULL,NULL),(5252,289,163.602,50.1339,NULL,NULL,NULL,NULL),(5253,289,184.674,51.0518,NULL,NULL,NULL,NULL),(5254,289,207.28,51.855,NULL,NULL,NULL,NULL),(5255,289,230.268,52.6582,NULL,NULL,NULL,NULL),(5256,289,248.276,52.4288,NULL,NULL,NULL,NULL),(5257,289,268.966,51.855,NULL,NULL,NULL,NULL),(5258,289,294.636,53.6909,NULL,NULL,NULL,NULL),(5259,289,315.326,54.4941,NULL,NULL,NULL,NULL),(5260,289,335.632,51.5108,NULL,NULL,NULL,NULL),(5261,289,349.808,52.6582,NULL,NULL,NULL,NULL),(5262,290,22.6054,37.3428,NULL,NULL,NULL,NULL),(5263,290,30.2682,39.9046,NULL,NULL,NULL,NULL),(5264,290,36.0153,41.5515,NULL,NULL,NULL,NULL),(5265,290,44.0613,42.6495,NULL,NULL,NULL,NULL),(5266,290,50.5747,42.741,NULL,NULL,NULL,NULL),(5267,290,64.3678,43.5645,NULL,NULL,NULL,NULL),(5268,290,77.7778,45.6688,NULL,NULL,NULL,NULL),(5269,290,98.8506,46.1263,NULL,NULL,NULL,NULL),(5270,290,119.157,46.6753,NULL,NULL,NULL,NULL),(5271,290,135.632,47.7732,NULL,NULL,NULL,NULL),(5272,290,157.088,49.6031,NULL,NULL,NULL,NULL),(5273,290,177.395,50.7011,NULL,NULL,NULL,NULL),(5274,290,200.383,50.3351,NULL,NULL,NULL,NULL),(5275,290,222.222,51.3415,NULL,NULL,NULL,NULL),(5276,290,242.529,52.4395,NULL,NULL,NULL,NULL),(5277,290,262.835,52.531,NULL,NULL,NULL,NULL),(5278,290,287.739,53.2629,NULL,NULL,NULL,NULL),(5279,290,306.13,53.1714,NULL,NULL,NULL,NULL),(5280,290,330.268,53.4459,NULL,NULL,NULL,NULL),(5281,290,342.529,54.6354,NULL,NULL,NULL,NULL),(5282,291,24.1379,41.9033,NULL,NULL,NULL,NULL),(5283,291,30.6513,42.865,NULL,NULL,NULL,NULL),(5284,291,37.5479,44.1473,NULL,NULL,NULL,NULL),(5285,291,45.2107,43.7199,NULL,NULL,NULL,NULL),(5286,291,51.341,46.2845,NULL,NULL,NULL,NULL),(5287,291,66.2835,48.208,NULL,NULL,NULL,NULL),(5288,291,80.0766,47.8874,NULL,NULL,NULL,NULL),(5289,291,96.9349,48.7423,NULL,NULL,NULL,NULL),(5290,291,108.812,50.3453,NULL,NULL,NULL,NULL),(5291,291,121.839,51.2001,NULL,NULL,NULL,NULL),(5292,291,132.567,51.2001,NULL,NULL,NULL,NULL),(5293,291,167.816,53.4442,NULL,NULL,NULL,NULL),(5294,291,185.441,53.4442,NULL,NULL,NULL,NULL),(5295,291,211.494,54.6197,NULL,NULL,NULL,NULL),(5296,291,236.398,58.6804,NULL,NULL,NULL,NULL),(5297,291,258.238,57.9323,NULL,NULL,NULL,NULL),(5298,291,276.628,61.0313,NULL,NULL,NULL,NULL),(5299,291,300.383,60.9244,NULL,NULL,NULL,NULL),(5300,291,320.69,63.1685,NULL,NULL,NULL,NULL),(5301,291,344.828,66.588,NULL,NULL,NULL,NULL),(5302,292,20.6897,44.6077,NULL,NULL,NULL,NULL),(5303,292,29.1188,46.1728,NULL,NULL,NULL,NULL),(5304,292,36.0153,48.0857,NULL,NULL,NULL,NULL),(5305,292,43.295,49.1291,NULL,NULL,NULL,NULL),(5306,292,51.341,50.7811,NULL,NULL,NULL,NULL),(5307,292,65.1341,52.1723,NULL,NULL,NULL,NULL),(5308,292,78.9272,52.52,NULL,NULL,NULL,NULL),(5309,292,97.318,53.6504,NULL,NULL,NULL,NULL),(5310,292,108.429,53.7374,NULL,NULL,NULL,NULL),(5311,292,120.69,55.6502,NULL,NULL,NULL,NULL),(5312,292,141.762,55.5632,NULL,NULL,NULL,NULL),(5313,292,167.05,57.4761,NULL,NULL,NULL,NULL),(5314,292,183.908,57.5631,NULL,NULL,NULL,NULL),(5315,292,209.195,57.5631,NULL,NULL,NULL,NULL),(5316,292,237.548,61.3888,NULL,NULL,NULL,NULL),(5317,292,257.088,61.3888,NULL,NULL,NULL,NULL),(5318,292,277.395,63.3017,NULL,NULL,NULL,NULL),(5319,292,297.318,62.5191,NULL,NULL,NULL,NULL),(5320,292,318.008,66.6058,NULL,NULL,NULL,NULL),(5321,292,344.828,65.1276,NULL,NULL,NULL,NULL),(5322,293,22.2222,49.8776,NULL,NULL,NULL,NULL),(5323,293,28.3525,51.9585,NULL,NULL,NULL,NULL),(5324,293,36.0153,54.8907,NULL,NULL,NULL,NULL),(5325,293,43.295,54.9852,NULL,NULL,NULL,NULL),(5326,293,51.7241,57.6337,NULL,NULL,NULL,NULL),(5327,293,63.2184,59.2416,NULL,NULL,NULL,NULL),(5328,293,78.5441,59.9037,NULL,NULL,NULL,NULL),(5329,293,95.0192,61.1334,NULL,NULL,NULL,NULL),(5330,293,106.13,61.7008,NULL,NULL,NULL,NULL),(5331,293,120.307,63.4034,NULL,NULL,NULL,NULL),(5332,293,141.379,65.2951,NULL,NULL,NULL,NULL),(5333,293,166.284,66.8085,NULL,NULL,NULL,NULL),(5334,293,184.674,66.8085,NULL,NULL,NULL,NULL),(5335,293,210.345,67.4706,NULL,NULL,NULL,NULL),(5336,293,234.866,70.6865,NULL,NULL,NULL,NULL),(5337,293,254.789,73.4295,NULL,NULL,NULL,NULL),(5338,293,276.628,76.078,NULL,NULL,NULL,NULL),(5339,293,298.084,75.5105,NULL,NULL,NULL,NULL),(5340,293,318.391,78.0642,NULL,NULL,NULL,NULL),(5341,293,340.23,79.1047,NULL,NULL,NULL,NULL),(5342,294,15.9696,38.3828,NULL,NULL,NULL,NULL),(5343,294,30.038,43.6437,NULL,NULL,NULL,NULL),(5344,294,36.5019,45.5894,NULL,NULL,NULL,NULL),(5345,294,44.4867,46.5106,NULL,NULL,NULL,NULL),(5346,294,50.9506,47.202,NULL,NULL,NULL,NULL),(5347,294,58.1749,49.1486,NULL,NULL,NULL,NULL),(5348,294,71.1027,50.4175,NULL,NULL,NULL,NULL),(5349,294,86.3118,51.8031,NULL,NULL,NULL,NULL),(5350,294,105.703,52.6233,NULL,NULL,NULL,NULL),(5351,294,125.475,55.1542,NULL,NULL,NULL,NULL),(5352,294,142.586,55.8579,NULL,NULL,NULL,NULL),(5353,294,163.118,57.3635,NULL,NULL,NULL,NULL),(5354,294,183.27,58.0706,NULL,NULL,NULL,NULL),(5355,294,205.703,56.4999,NULL,NULL,NULL,NULL),(5356,294,230.418,57.0982,NULL,NULL,NULL,NULL),(5357,294,248.669,59.7414,NULL,NULL,NULL,NULL),(5358,294,269.202,60.1068,NULL,NULL,NULL,NULL),(5359,294,291.635,60.8165,NULL,NULL,NULL,NULL),(5360,294,311.787,60.8395,NULL,NULL,NULL,NULL),(5361,294,333.84,60.0666,NULL,NULL,NULL,NULL),(5362,294,346.768,60.1953,NULL,NULL,NULL,NULL),(5363,295,15.9696,40.8503,NULL,NULL,NULL,NULL),(5364,295,19.7719,41.9448,NULL,NULL,NULL,NULL),(5365,295,23.5741,43.4029,NULL,NULL,NULL,NULL),(5366,295,29.6578,44.4085,NULL,NULL,NULL,NULL),(5367,295,36.8821,45.6879,NULL,NULL,NULL,NULL),(5368,295,44.8669,46.6043,NULL,NULL,NULL,NULL),(5369,295,51.3308,47.4284,NULL,NULL,NULL,NULL),(5370,295,65.3992,48.7141,NULL,NULL,NULL,NULL),(5371,295,78.7072,49.9081,NULL,NULL,NULL,NULL),(5372,295,100.38,50.746,NULL,NULL,NULL,NULL),(5373,295,118.631,52.1263,NULL,NULL,NULL,NULL),(5374,295,134.601,52.2318,NULL,NULL,NULL,NULL),(5375,295,156.274,53.1606,NULL,NULL,NULL,NULL),(5376,295,176.806,53.0883,NULL,NULL,NULL,NULL),(5377,295,198.479,53.199,NULL,NULL,NULL,NULL),(5378,295,222.433,54.4936,NULL,NULL,NULL,NULL),(5379,295,236.122,55.2334,NULL,NULL,NULL,NULL),(5380,295,260.456,56.3465,NULL,NULL,NULL,NULL),(5381,295,286.312,56.5518,NULL,NULL,NULL,NULL),(5382,295,304.563,56.8412,NULL,NULL,NULL,NULL),(5383,295,327.757,56.3167,NULL,NULL,NULL,NULL),(5384,295,342.205,56.6027,NULL,NULL,NULL,NULL),(5385,296,9.5057,50.5771,NULL,NULL,NULL,NULL),(5386,296,13.6882,51.6435,NULL,NULL,NULL,NULL),(5387,296,16.73,53.9827,NULL,NULL,NULL,NULL),(5388,296,23.9544,56.0079,NULL,NULL,NULL,NULL),(5389,296,31.5589,58.5644,NULL,NULL,NULL,NULL),(5390,296,38.403,59.7397,NULL,NULL,NULL,NULL),(5391,296,45.6274,60.9154,NULL,NULL,NULL,NULL),(5392,296,52.4715,62.9402,NULL,NULL,NULL,NULL),(5393,296,66.5399,66.2468,NULL,NULL,NULL,NULL),(5394,296,80.6084,64.2443,NULL,NULL,NULL,NULL),(5395,296,97.7186,65.4304,NULL,NULL,NULL,NULL),(5396,296,109.506,66.2924,NULL,NULL,NULL,NULL),(5397,296,123.194,68.6431,NULL,NULL,NULL,NULL),(5398,296,143.346,69.7263,NULL,NULL,NULL,NULL),(5399,296,166.92,70.2822,NULL,NULL,NULL,NULL),(5400,296,184.791,71.1507,NULL,NULL,NULL,NULL),(5401,296,209.886,70.1155,NULL,NULL,NULL,NULL),(5402,296,234.981,72.6905,NULL,NULL,NULL,NULL),(5403,296,256.274,72.8193,NULL,NULL,NULL,NULL),(5404,296,276.426,72.7346,NULL,NULL,NULL,NULL),(5405,296,297.719,72.7571,NULL,NULL,NULL,NULL),(5406,296,318.251,73.4161,NULL,NULL,NULL,NULL),(5407,296,342.966,75.4599,NULL,NULL,NULL,NULL),(5408,297,7.98479,47.8103,NULL,NULL,NULL,NULL),(5409,297,11.0266,50.5776,NULL,NULL,NULL,NULL),(5410,297,15.2091,53.9508,NULL,NULL,NULL,NULL),(5411,297,22.8137,56.6357,NULL,NULL,NULL,NULL),(5412,297,30.038,59.0611,NULL,NULL,NULL,NULL),(5413,297,37.2624,62.0049,NULL,NULL,NULL,NULL),(5414,297,44.8669,61.7522,NULL,NULL,NULL,NULL),(5415,297,51.3308,64.2634,NULL,NULL,NULL,NULL),(5416,297,66.1597,67.8186,NULL,NULL,NULL,NULL),(5417,297,78.7072,66.3606,NULL,NULL,NULL,NULL),(5418,297,96.9582,68.1044,NULL,NULL,NULL,NULL),(5419,297,108.365,67.855,NULL,NULL,NULL,NULL),(5420,297,121.673,69.9401,NULL,NULL,NULL,NULL),(5421,297,142.586,71.3405,NULL,NULL,NULL,NULL),(5422,297,166.54,72.1388,NULL,NULL,NULL,NULL),(5423,297,184.411,73.3638,NULL,NULL,NULL,NULL),(5424,297,208.745,72.4344,NULL,NULL,NULL,NULL),(5425,297,234.221,74.3572,NULL,NULL,NULL,NULL),(5426,297,257.795,74.5504,NULL,NULL,NULL,NULL),(5427,297,276.806,74.9988,NULL,NULL,NULL,NULL),(5428,297,297.719,75.0169,NULL,NULL,NULL,NULL),(5429,297,317.49,76.7619,NULL,NULL,NULL,NULL),(5430,297,342.205,76.6105,NULL,NULL,NULL,NULL),(5431,298,12.1673,50.2524,NULL,NULL,NULL,NULL),(5432,298,14.8289,53.0745,NULL,NULL,NULL,NULL),(5433,298,19.3916,55.6165,NULL,NULL,NULL,NULL),(5434,298,29.2776,57.6935,NULL,NULL,NULL,NULL),(5435,298,37.6426,59.9571,NULL,NULL,NULL,NULL),(5436,298,44.1065,60.5271,NULL,NULL,NULL,NULL),(5437,298,51.3308,63.5414,NULL,NULL,NULL,NULL),(5438,298,64.2586,67.3131,NULL,NULL,NULL,NULL),(5439,298,77.5665,66.5737,NULL,NULL,NULL,NULL),(5440,298,95.4373,68.1883,NULL,NULL,NULL,NULL),(5441,298,106.844,69.5148,NULL,NULL,NULL,NULL),(5442,298,120.152,70.3733,NULL,NULL,NULL,NULL),(5443,298,140.684,71.8023,NULL,NULL,NULL,NULL),(5444,298,165.399,72.3895,NULL,NULL,NULL,NULL),(5445,298,183.27,74.1921,NULL,NULL,NULL,NULL),(5446,298,208.365,72.6178,NULL,NULL,NULL,NULL),(5447,298,234.981,75.0866,NULL,NULL,NULL,NULL),(5448,298,254.373,74.9168,NULL,NULL,NULL,NULL),(5449,298,276.046,74.4673,NULL,NULL,NULL,NULL),(5450,298,296.578,74.4866,NULL,NULL,NULL,NULL),(5451,298,315.97,75.7266,NULL,NULL,NULL,NULL),(5452,298,341.065,77.7239,NULL,NULL,NULL,NULL),(5453,299,1.74452,30.8243,NULL,NULL,NULL,NULL),(5454,299,5.94775,60.4603,NULL,NULL,NULL,NULL),(5455,299,6.97274,74.5748,NULL,NULL,NULL,NULL),(5456,299,13.0219,109.252,NULL,NULL,NULL,NULL),(5457,299,14.9231,124.644,NULL,NULL,NULL,NULL),(5458,299,16.9088,143.878,NULL,NULL,NULL,NULL),(5459,299,19.8228,160.555,NULL,NULL,NULL,NULL),(5460,299,29.8348,199.045,NULL,NULL,NULL,NULL),(5461,299,37.0198,237.508,NULL,NULL,NULL,NULL),(5462,299,48.619,281.104,NULL,NULL,NULL,NULL),(5463,299,63.8526,308.045,NULL,NULL,NULL,NULL),(5464,299,77.4508,347.787,NULL,NULL,NULL,NULL),(5465,299,91.8351,358.059,NULL,NULL,NULL,NULL),(5466,299,98.3109,365.755,NULL,NULL,NULL,NULL),(5467,299,126.215,379.882,NULL,NULL,NULL,NULL),(5468,299,154.842,394.005,NULL,NULL,NULL,NULL),(5469,299,183.6,401.714,NULL,NULL,NULL,NULL),(5470,299,210.406,409.419,NULL,NULL,NULL,NULL),(5471,299,238.403,414.562,NULL,NULL,NULL,NULL),(5472,299,252.332,418.413,NULL,NULL,NULL,NULL),(5473,299,285.908,423.556,NULL,NULL,NULL,NULL),(5474,299,316.677,427.413,NULL,NULL,NULL,NULL),(5475,299,342.88,432.549,NULL,NULL,NULL,NULL),(5476,299,362.913,433.837,NULL,NULL,NULL,NULL),(5477,299,406.56,440.259,NULL,NULL,NULL,NULL),(5478,299,425.455,436.422,NULL,NULL,NULL,NULL),(5479,299,455.456,437.712,NULL,NULL,NULL,NULL),(5480,299,482.067,440.281,NULL,NULL,NULL,NULL),(5481,299,540.044,446.703,NULL,NULL,NULL,NULL),(5482,299,598.162,451.841,NULL,NULL,NULL,NULL),(5483,299,655.053,454.417,NULL,NULL,NULL,NULL),(5484,299,717.354,451.866,NULL,NULL,NULL,NULL),(5485,299,725.547,454.431,NULL,NULL,NULL,NULL),(5486,299,767.939,455.721,NULL,NULL,NULL,NULL),(5487,299,822.091,459.574,NULL,NULL,NULL,NULL),(5488,299,880.061,462.145,NULL,NULL,NULL,NULL),(5489,299,942.12,464.717,NULL,NULL,NULL,NULL),(5490,299,1043.51,467.293,NULL,NULL,NULL,NULL),(5491,299,1079.67,467.297,NULL,NULL,NULL,NULL),(5492,299,1129.85,473.71,NULL,NULL,NULL,NULL),(5493,299,1209.52,476.281,NULL,NULL,NULL,NULL),(5494,299,1265.73,481.413,NULL,NULL,NULL,NULL),(5495,299,1370.47,486.546,NULL,NULL,NULL,NULL),(5496,299,1450.54,486.556,NULL,NULL,NULL,NULL),(5497,299,1588.5,490.41,NULL,NULL,NULL,NULL),(5498,299,1662.32,489.136,NULL,NULL,NULL,NULL),(5499,299,1719.93,494.265,NULL,NULL,NULL,NULL),(5500,299,1820.42,517.333,NULL,NULL,NULL,NULL),(5501,299,2016.33,523.753,NULL,NULL,NULL,NULL),(5502,299,2183.17,528.889,NULL,NULL,NULL,NULL),(5503,299,2310.73,526.336,NULL,NULL,NULL,NULL),(5504,299,2445.73,528.905,NULL,NULL,NULL,NULL),(5505,299,2559.4,512.256,NULL,NULL,NULL,NULL),(5506,299,2771.17,508.424,NULL,NULL,NULL,NULL),(5507,299,3034.74,519.966,NULL,NULL,NULL,NULL),(5508,299,3285.84,519.977,NULL,NULL,NULL,NULL),(5509,299,3477.82,523.83,NULL,NULL,NULL,NULL),(5510,299,3681.02,522.556,NULL,NULL,NULL,NULL),(5511,299,3852.09,525.125,NULL,NULL,NULL,NULL),(5512,299,4031.12,525.132,NULL,NULL,NULL,NULL),(5513,299,4218.46,530.261,NULL,NULL,NULL,NULL),(5514,299,4414.51,534.111,NULL,NULL,NULL,NULL),(5515,299,4619.68,537.961,NULL,NULL,NULL,NULL),(5516,299,4725.81,540.526,NULL,NULL,NULL,NULL),(5517,299,4945.44,545.658,NULL,NULL,NULL,NULL),(5518,299,5175.27,537.977,NULL,NULL,NULL,NULL),(5519,299,5294.17,541.823,NULL,NULL,NULL,NULL),(5520,299,5540.21,549.517,NULL,NULL,NULL,NULL),(5521,299,5667.49,552.082,NULL,NULL,NULL,NULL),(5522,299,6136.44,549.531,NULL,NULL,NULL,NULL),(5523,299,6494.97,554.662,NULL,NULL,NULL,NULL),(5524,299,6952.97,554.671,NULL,NULL,NULL,NULL),(5525,299,7276.1,557.24,NULL,NULL,NULL,NULL),(5526,299,7614.26,561.091,NULL,NULL,NULL,NULL),(5527,299,7968.13,559.816,NULL,NULL,NULL,NULL),(5528,299,8433.68,558.542,NULL,NULL,NULL,NULL),(5529,299,10229.7,558.569,NULL,NULL,NULL,NULL),(5530,299,11076.2,567.549,NULL,NULL,NULL,NULL),(5531,300,1.68609,13.2404,NULL,NULL,NULL,NULL),(5532,300,1.72482,13.5086,NULL,NULL,NULL,NULL),(5533,300,1.74452,13.6426,NULL,NULL,NULL,NULL),(5534,300,5.01614,26.1109,NULL,NULL,NULL,NULL),(5535,300,5.94775,32.0923,NULL,NULL,NULL,NULL),(5536,300,6.97274,37.6752,NULL,NULL,NULL,NULL),(5537,300,7.99078,40.5719,NULL,NULL,NULL,NULL),(5538,300,13.0219,54.957,NULL,NULL,NULL,NULL),(5539,300,13.9401,56.9643,NULL,NULL,NULL,NULL),(5540,300,14.9231,62.2929,NULL,NULL,NULL,NULL),(5541,300,16.1579,68.5097,NULL,NULL,NULL,NULL),(5542,300,16.9088,69.4752,NULL,NULL,NULL,NULL),(5543,300,19.8228,72.8548,NULL,NULL,NULL,NULL),(5544,300,20.2782,73.3376,NULL,NULL,NULL,NULL),(5545,300,20.9809,80.067,NULL,NULL,NULL,NULL),(5546,300,29.1647,102.201,NULL,NULL,NULL,NULL),(5547,300,29.8348,102.923,NULL,NULL,NULL,NULL),(5548,300,34.9762,107.985,NULL,NULL,NULL,NULL),(5549,300,37.0198,112.218,NULL,NULL,NULL,NULL),(5550,300,46.4598,129.153,NULL,NULL,NULL,NULL),(5551,300,48.619,132.232,NULL,NULL,NULL,NULL),(5552,300,61.7138,148.399,NULL,NULL,NULL,NULL),(5553,300,63.8526,151.605,NULL,NULL,NULL,NULL),(5554,300,75.7114,167.637,NULL,NULL,NULL,NULL),(5555,300,77.4508,168.024,NULL,NULL,NULL,NULL),(5556,300,89.7727,170.537,NULL,NULL,NULL,NULL),(5557,300,91.8351,171.692,NULL,NULL,NULL,NULL),(5558,300,98.3109,175.158,NULL,NULL,NULL,NULL),(5559,300,100.569,176.315,NULL,NULL,NULL,NULL),(5560,300,126.215,184.024,NULL,NULL,NULL,NULL),(5561,300,154.842,192.694,NULL,NULL,NULL,NULL),(5562,300,183.6,194.633,NULL,NULL,NULL,NULL),(5563,300,208.03,198.49,NULL,NULL,NULL,NULL),(5564,300,210.406,198.927,NULL,NULL,NULL,NULL),(5565,300,235.711,203.306,NULL,NULL,NULL,NULL),(5566,300,238.403,203.628,NULL,NULL,NULL,NULL),(5567,300,252.332,205.235,NULL,NULL,NULL,NULL),(5568,300,285.908,207.17,NULL,NULL,NULL,NULL),(5569,300,309.565,211.022,NULL,NULL,NULL,NULL),(5570,300,316.677,211.665,NULL,NULL,NULL,NULL),(5571,300,342.88,213.915,NULL,NULL,NULL,NULL),(5572,300,362.913,217.124,NULL,NULL,NULL,NULL),(5573,300,367.058,217.765,NULL,NULL,NULL,NULL),(5574,300,401.969,216.813,NULL,NULL,NULL,NULL),(5575,300,406.56,217.391,NULL,NULL,NULL,NULL),(5576,300,425.455,219.702,NULL,NULL,NULL,NULL),(5577,300,455.456,218.748,NULL,NULL,NULL,NULL),(5578,300,482.067,218.755,NULL,NULL,NULL,NULL),(5579,300,493.142,218.757,NULL,NULL,NULL,NULL),(5580,300,540.044,223.57,NULL,NULL,NULL,NULL),(5581,300,598.162,225.311,NULL,NULL,NULL,NULL),(5582,300,604.994,225.503,NULL,NULL,NULL,NULL),(5583,300,655.053,225.512,NULL,NULL,NULL,NULL),(5584,300,662.534,225.514,NULL,NULL,NULL,NULL),(5585,300,717.354,226.362,NULL,NULL,NULL,NULL),(5586,300,725.547,226.483,NULL,NULL,NULL,NULL),(5587,300,767.939,226.49,NULL,NULL,NULL,NULL),(5588,300,822.091,225.536,NULL,NULL,NULL,NULL),(5589,300,880.061,229.386,NULL,NULL,NULL,NULL),(5590,300,931.481,228.432,NULL,NULL,NULL,NULL),(5591,300,942.12,228.913,NULL,NULL,NULL,NULL),(5592,300,1043.51,233.248,NULL,NULL,NULL,NULL),(5593,300,1079.67,232.531,NULL,NULL,NULL,NULL),(5594,300,1092,232.291,NULL,NULL,NULL,NULL),(5595,300,1129.85,228.692,NULL,NULL,NULL,NULL),(5596,300,1142.76,227.492,NULL,NULL,NULL,NULL),(5597,300,1209.52,233.675,NULL,NULL,NULL,NULL),(5598,300,1237.31,236.148,NULL,NULL,NULL,NULL),(5599,300,1265.73,238.071,NULL,NULL,NULL,NULL),(5600,300,1294.81,239.997,NULL,NULL,NULL,NULL),(5601,300,1370.47,240.963,NULL,NULL,NULL,NULL),(5602,300,1450.54,243.371,NULL,NULL,NULL,NULL),(5603,300,1467.1,243.852,NULL,NULL,NULL,NULL),(5604,300,1570.56,243.859,NULL,NULL,NULL,NULL),(5605,300,1588.5,243.998,NULL,NULL,NULL,NULL),(5606,300,1662.32,244.551,NULL,NULL,NULL,NULL),(5607,300,1700.51,244.828,NULL,NULL,NULL,NULL),(5608,300,1719.93,248.352,NULL,NULL,NULL,NULL),(5609,300,1759.45,255.401,NULL,NULL,NULL,NULL),(5610,300,1820.42,251.801,NULL,NULL,NULL,NULL),(5611,300,1841.22,250.602,NULL,NULL,NULL,NULL),(5612,300,1993.56,251.571,NULL,NULL,NULL,NULL),(5613,300,2016.33,250.611,NULL,NULL,NULL,NULL),(5614,300,2039.36,249.651,NULL,NULL,NULL,NULL),(5615,300,2183.17,251.306,NULL,NULL,NULL,NULL),(5616,300,2208.11,251.582,NULL,NULL,NULL,NULL),(5617,300,2310.73,251.587,NULL,NULL,NULL,NULL),(5618,300,2445.73,250.791,NULL,NULL,NULL,NULL),(5619,300,2473.67,250.633,NULL,NULL,NULL,NULL),(5620,300,2559.4,256.401,NULL,NULL,NULL,NULL),(5621,300,2708.94,256.406,NULL,NULL,NULL,NULL),(5622,300,2771.17,256.959,NULL,NULL,NULL,NULL),(5623,300,2933.08,258.337,NULL,NULL,NULL,NULL),(5624,300,3034.74,261.223,NULL,NULL,NULL,NULL),(5625,300,3069.4,262.185,NULL,NULL,NULL,NULL),(5626,300,3285.84,262.192,NULL,NULL,NULL,NULL),(5627,300,3477.82,264.119,NULL,NULL,NULL,NULL),(5628,300,3639.45,263.163,NULL,NULL,NULL,NULL),(5629,300,3681.02,263.439,NULL,NULL,NULL,NULL),(5630,300,3852.09,264.543,NULL,NULL,NULL,NULL),(5631,300,3940.59,265.094,NULL,NULL,NULL,NULL),(5632,300,4031.12,264.136,NULL,NULL,NULL,NULL),(5633,300,4218.46,266.446,NULL,NULL,NULL,NULL),(5634,300,4266.64,267.024,NULL,NULL,NULL,NULL),(5635,300,4414.51,268.18,NULL,NULL,NULL,NULL),(5636,300,4515.93,268.951,NULL,NULL,NULL,NULL),(5637,300,4619.68,269.274,NULL,NULL,NULL,NULL),(5638,300,4725.81,269.597,NULL,NULL,NULL,NULL),(5639,300,4834.37,269.918,NULL,NULL,NULL,NULL),(5640,300,4945.44,269.537,NULL,NULL,NULL,NULL),(5641,300,5116.83,268.964,NULL,NULL,NULL,NULL),(5642,300,5175.27,268.966,NULL,NULL,NULL,NULL),(5643,300,5294.17,268.968,NULL,NULL,NULL,NULL),(5644,300,5540.21,271.534,NULL,NULL,NULL,NULL),(5645,300,5667.49,272.818,NULL,NULL,NULL,NULL),(5646,300,5797.69,279.546,NULL,NULL,NULL,NULL),(5647,300,6136.44,279.116,NULL,NULL,NULL,NULL),(5648,300,6494.97,278.685,NULL,NULL,NULL,NULL),(5649,300,6569.15,278.599,NULL,NULL,NULL,NULL),(5650,300,6952.97,283.408,NULL,NULL,NULL,NULL),(5651,300,7276.1,280.852,NULL,NULL,NULL,NULL),(5652,300,7443.26,279.573,NULL,NULL,NULL,NULL),(5653,300,7614.26,281.223,NULL,NULL,NULL,NULL),(5654,300,7968.13,284.52,NULL,NULL,NULL,NULL),(5655,300,8059.14,285.345,NULL,NULL,NULL,NULL),(5656,300,8433.68,286.311,NULL,NULL,NULL,NULL),(5657,300,10229.7,294.929,NULL,NULL,NULL,NULL),(5658,300,10464.7,295.942,NULL,NULL,NULL,NULL),(5659,300,11076.2,291.145,NULL,NULL,NULL,NULL),(5660,301,1.99923,15.8919,NULL,NULL,NULL,NULL),(5661,301,2.97502,21.4033,NULL,NULL,NULL,NULL),(5662,301,3.99693,25.6891,NULL,NULL,NULL,NULL),(5663,301,6.97274,32.43,NULL,NULL,NULL,NULL),(5664,301,7.99078,36.0958,NULL,NULL,NULL,NULL),(5665,301,10.0284,42.2055,NULL,NULL,NULL,NULL),(5666,301,10.9822,44.6493,NULL,NULL,NULL,NULL),(5667,301,14.9231,51.3737,NULL,NULL,NULL,NULL),(5668,301,17.8968,58.0899,NULL,NULL,NULL,NULL),(5669,301,20.744,64.8037,NULL,NULL,NULL,NULL),(5670,301,30.8688,85.5517,NULL,NULL,NULL,NULL),(5671,301,37.8703,91.6599,NULL,NULL,NULL,NULL),(5672,301,50.3041,106.306,NULL,NULL,NULL,NULL),(5673,301,63.8526,116.073,NULL,NULL,NULL,NULL),(5674,301,79.2301,131.933,NULL,NULL,NULL,NULL),(5675,301,92.884,133.772,NULL,NULL,NULL,NULL),(5676,301,99.4338,137.434,NULL,NULL,NULL,NULL),(5677,301,127.656,144.154,NULL,NULL,NULL,NULL),(5678,301,156.611,149.043,NULL,NULL,NULL,NULL),(5679,301,183.6,153.32,NULL,NULL,NULL,NULL),(5680,301,212.809,153.94,NULL,NULL,NULL,NULL),(5681,301,246.666,159.434,NULL,NULL,NULL,NULL),(5682,301,279.488,162.49,NULL,NULL,NULL,NULL),(5683,301,309.565,164.325,NULL,NULL,NULL,NULL),(5684,301,335.179,167.378,NULL,NULL,NULL,NULL),(5685,301,367.058,167.384,NULL,NULL,NULL,NULL),(5686,301,397.43,169.217,NULL,NULL,NULL,NULL),(5687,301,420.65,169.831,NULL,NULL,NULL,NULL),(5688,301,450.313,169.225,NULL,NULL,NULL,NULL),(5689,301,482.067,168.62,NULL,NULL,NULL,NULL),(5690,301,540.044,172.894,NULL,NULL,NULL,NULL),(5691,301,598.162,174.12,NULL,NULL,NULL,NULL),(5692,301,655.053,173.517,NULL,NULL,NULL,NULL),(5693,301,701.244,172.912,NULL,NULL,NULL,NULL),(5694,301,725.547,174.133,NULL,NULL,NULL,NULL),(5695,301,759.267,174.745,NULL,NULL,NULL,NULL),(5696,301,822.091,174.141,NULL,NULL,NULL,NULL),(5697,301,870.123,176.583,NULL,NULL,NULL,NULL),(5698,301,931.481,178.415,NULL,NULL,NULL,NULL),(5699,301,1008.55,178.421,NULL,NULL,NULL,NULL),(5700,301,1079.67,177.206,NULL,NULL,NULL,NULL),(5701,301,1142.76,179.039,NULL,NULL,NULL,NULL),(5702,301,1209.52,183.309,NULL,NULL,NULL,NULL),(5703,301,1280.19,181.483,NULL,NULL,NULL,NULL),(5704,301,1370.47,185.146,NULL,NULL,NULL,NULL),(5705,301,1467.1,186.369,NULL,NULL,NULL,NULL),(5706,301,1552.82,183.934,NULL,NULL,NULL,NULL),(5707,301,1662.32,185.158,NULL,NULL,NULL,NULL),(5708,301,1719.93,186.988,NULL,NULL,NULL,NULL),(5709,301,1820.42,190.04,NULL,NULL,NULL,NULL),(5710,301,1971.05,185.779,NULL,NULL,NULL,NULL),(5711,301,2039.36,189.438,NULL,NULL,NULL,NULL),(5712,301,2183.17,190.052,NULL,NULL,NULL,NULL),(5713,301,2310.73,191.883,NULL,NULL,NULL,NULL),(5714,301,2473.67,190.669,NULL,NULL,NULL,NULL),(5715,301,2559.4,193.109,NULL,NULL,NULL,NULL),(5716,301,2708.94,194.942,NULL,NULL,NULL,NULL),(5717,301,2933.08,195.557,NULL,NULL,NULL,NULL),(5718,301,3139.91,194.951,NULL,NULL,NULL,NULL),(5719,301,3323.37,195.564,NULL,NULL,NULL,NULL),(5720,301,3477.82,197.396,NULL,NULL,NULL,NULL),(5721,301,3639.45,196.79,NULL,NULL,NULL,NULL),(5722,301,3896.09,198.013,NULL,NULL,NULL,NULL),(5723,301,4031.12,196.187,NULL,NULL,NULL,NULL),(5724,301,4170.82,199.846,NULL,NULL,NULL,NULL),(5725,301,4414.51,199.85,NULL,NULL,NULL,NULL),(5726,301,4567.51,203.508,NULL,NULL,NULL,NULL),(5727,301,4834.37,202.293,NULL,NULL,NULL,NULL),(5728,301,5059.05,203.516,NULL,NULL,NULL,NULL),(5729,301,5294.17,202.3,NULL,NULL,NULL,NULL),(5730,301,5477.65,205.35,NULL,NULL,NULL,NULL),(5731,301,5732.22,205.352,NULL,NULL,NULL,NULL),(5732,301,6136.44,205.965,NULL,NULL,NULL,NULL),(5733,301,6569.15,208.409,NULL,NULL,NULL,NULL),(5734,301,6874.45,209.63,NULL,NULL,NULL,NULL),(5735,301,7276.1,208.415,NULL,NULL,NULL,NULL),(5736,301,7614.26,209.028,NULL,NULL,NULL,NULL),(5737,301,7968.13,210.859,NULL,NULL,NULL,NULL),(5738,301,8433.68,212.691,NULL,NULL,NULL,NULL),(5739,301,10346.6,216.361,NULL,NULL,NULL,NULL),(5740,301,10951.1,216.975,NULL,NULL,NULL,NULL),(5741,302,1.70535,16.6838,NULL,NULL,NULL,NULL),(5742,302,5.01614,27.086,NULL,NULL,NULL,NULL),(5743,302,8.95182,34.012,NULL,NULL,NULL,NULL),(5744,302,13.0219,42.0736,NULL,NULL,NULL,NULL),(5745,302,14.9231,47.8237,NULL,NULL,NULL,NULL),(5746,302,19.1588,54.155,NULL,NULL,NULL,NULL),(5747,302,21.2206,55.8838,NULL,NULL,NULL,NULL),(5748,302,29.1647,65.0901,NULL,NULL,NULL,NULL),(5749,302,36.1884,73.716,NULL,NULL,NULL,NULL),(5750,302,46.9905,78.8997,NULL,NULL,NULL,NULL),(5751,302,62.4187,91.5489,NULL,NULL,NULL,NULL),(5752,302,75.7114,99.5991,NULL,NULL,NULL,NULL),(5753,302,90.798,105.926,NULL,NULL,NULL,NULL),(5754,302,100.569,111.674,NULL,NULL,NULL,NULL),(5755,302,126.215,121.449,NULL,NULL,NULL,NULL),(5756,302,154.842,116.295,NULL,NULL,NULL,NULL),(5757,302,183.6,125.492,NULL,NULL,NULL,NULL),(5758,302,210.406,128.945,NULL,NULL,NULL,NULL),(5759,302,241.126,130.676,NULL,NULL,NULL,NULL),(5760,302,252.332,132.976,NULL,NULL,NULL,NULL),(5761,302,273.211,135.276,NULL,NULL,NULL,NULL),(5762,302,302.613,135.858,NULL,NULL,NULL,NULL),(5763,302,331.394,140.456,NULL,NULL,NULL,NULL),(5764,302,358.815,139.313,NULL,NULL,NULL,NULL),(5765,302,367.058,141.611,NULL,NULL,NULL,NULL),(5766,302,388.504,139.318,NULL,NULL,NULL,NULL),(5767,302,411.203,139.321,NULL,NULL,NULL,NULL),(5768,302,440.2,140.475,NULL,NULL,NULL,NULL),(5769,302,471.241,141.053,NULL,NULL,NULL,NULL),(5770,302,533.945,143.357,NULL,NULL,NULL,NULL),(5771,302,591.407,145.66,NULL,NULL,NULL,NULL),(5772,302,647.655,147.388,NULL,NULL,NULL,NULL),(5773,302,701.244,145.671,NULL,NULL,NULL,NULL),(5774,302,733.834,146.822,NULL,NULL,NULL,NULL),(5775,302,759.267,146.25,NULL,NULL,NULL,NULL),(5776,302,822.091,147.977,NULL,NULL,NULL,NULL),(5777,302,870.123,149.703,NULL,NULL,NULL,NULL),(5778,302,931.481,149.133,NULL,NULL,NULL,NULL),(5779,302,1020.07,149.713,NULL,NULL,NULL,NULL),(5780,302,1043.51,151.437,NULL,NULL,NULL,NULL),(5781,302,1092,149.717,NULL,NULL,NULL,NULL),(5782,302,1169.01,152.018,NULL,NULL,NULL,NULL),(5783,302,1280.19,154.894,NULL,NULL,NULL,NULL),(5784,302,1354.99,155.473,NULL,NULL,NULL,NULL),(5785,302,1450.54,154.902,NULL,NULL,NULL,NULL),(5786,302,1643.55,155.485,NULL,NULL,NULL,NULL),(5787,302,1719.93,156.061,NULL,NULL,NULL,NULL),(5788,302,1841.22,159.51,NULL,NULL,NULL,NULL),(5789,302,2062.66,159.517,NULL,NULL,NULL,NULL),(5790,302,2183.17,158.947,NULL,NULL,NULL,NULL),(5791,302,2310.73,158.95,NULL,NULL,NULL,NULL),(5792,302,2418.12,157.805,NULL,NULL,NULL,NULL),(5793,302,2559.4,161.253,NULL,NULL,NULL,NULL),(5794,302,2739.88,161.832,NULL,NULL,NULL,NULL),(5795,302,2933.08,162.985,NULL,NULL,NULL,NULL),(5796,302,3104.45,163.562,NULL,NULL,NULL,NULL),(5797,302,3361.32,164.141,NULL,NULL,NULL,NULL),(5798,302,3477.82,165.866,NULL,NULL,NULL,NULL),(5799,302,3681.02,165.87,NULL,NULL,NULL,NULL),(5800,302,3852.09,165.872,NULL,NULL,NULL,NULL),(5801,302,4170.82,167.6,NULL,NULL,NULL,NULL),(5802,302,4414.51,168.752,NULL,NULL,NULL,NULL),(5803,302,4567.51,167.606,NULL,NULL,NULL,NULL),(5804,302,4779.78,169.904,NULL,NULL,NULL,NULL),(5805,302,4945.44,168.759,NULL,NULL,NULL,NULL),(5806,302,5116.83,168.187,NULL,NULL,NULL,NULL),(5807,302,5294.17,169.337,NULL,NULL,NULL,NULL),(5808,302,5477.65,168.191,NULL,NULL,NULL,NULL),(5809,302,5667.49,172.787,NULL,NULL,NULL,NULL),(5810,302,6136.44,173.366,NULL,NULL,NULL,NULL),(5811,302,6569.15,171.647,NULL,NULL,NULL,NULL),(5812,302,6952.97,173.373,NULL,NULL,NULL,NULL),(5813,302,7443.26,172.229,NULL,NULL,NULL,NULL),(5814,302,7701.22,175.102,NULL,NULL,NULL,NULL),(5815,302,8059.14,176.253,NULL,NULL,NULL,NULL),(5816,302,8433.68,176.256,NULL,NULL,NULL,NULL),(5817,302,10229.7,179.713,NULL,NULL,NULL,NULL),(5818,302,11076.2,180.292,NULL,NULL,NULL,NULL),(5819,303,1.97666,11.2964,NULL,NULL,NULL,NULL),(5820,303,5.01614,16.9774,NULL,NULL,NULL,NULL),(5821,303,6.01568,19.0344,NULL,NULL,NULL,NULL),(5822,303,7.99078,24.1678,NULL,NULL,NULL,NULL),(5823,303,9.05406,24.1746,NULL,NULL,NULL,NULL),(5824,303,12.0267,26.7492,NULL,NULL,NULL,NULL),(5825,303,16.1579,29.8361,NULL,NULL,NULL,NULL),(5826,303,19.1588,33.9396,NULL,NULL,NULL,NULL),(5827,303,20.9809,35.4798,NULL,NULL,NULL,NULL),(5828,303,29.1647,40.6157,NULL,NULL,NULL,NULL),(5829,303,36.1884,45.2334,NULL,NULL,NULL,NULL),(5830,303,48.07,50.3667,NULL,NULL,NULL,NULL),(5831,303,62.4187,56.5222,NULL,NULL,NULL,NULL),(5832,303,76.5762,62.6745,NULL,NULL,NULL,NULL),(5833,303,91.8351,65.2434,NULL,NULL,NULL,NULL),(5834,303,113.952,69.8611,NULL,NULL,NULL,NULL),(5835,303,126.215,72.4255,NULL,NULL,NULL,NULL),(5836,303,154.842,76.0191,NULL,NULL,NULL,NULL),(5837,303,183.6,77.0521,NULL,NULL,NULL,NULL),(5838,303,210.406,79.1067,NULL,NULL,NULL,NULL),(5839,303,246.666,80.6507,NULL,NULL,NULL,NULL),(5840,303,282.68,82.7053,NULL,NULL,NULL,NULL),(5841,303,309.565,83.7339,NULL,NULL,NULL,NULL),(5842,303,339.008,85.2742,NULL,NULL,NULL,NULL),(5843,303,367.058,85.7903,NULL,NULL,NULL,NULL),(5844,303,397.43,86.8183,NULL,NULL,NULL,NULL),(5845,303,420.65,87.3332,NULL,NULL,NULL,NULL),(5846,303,450.313,86.8252,NULL,NULL,NULL,NULL),(5847,303,476.623,86.8284,NULL,NULL,NULL,NULL),(5848,303,533.945,87.8582,NULL,NULL,NULL,NULL),(5849,303,598.162,89.3997,NULL,NULL,NULL,NULL),(5850,303,655.053,89.9165,NULL,NULL,NULL,NULL),(5851,303,709.253,88.8975,NULL,NULL,NULL,NULL),(5852,303,767.939,89.4136,NULL,NULL,NULL,NULL),(5853,303,822.091,90.9529,NULL,NULL,NULL,NULL),(5854,303,880.061,91.9801,NULL,NULL,NULL,NULL),(5855,303,931.481,91.9828,NULL,NULL,NULL,NULL),(5856,303,1104.48,91.9928,NULL,NULL,NULL,NULL),(5857,303,1142.76,93.5299,NULL,NULL,NULL,NULL),(5858,303,1209.52,93.5326,NULL,NULL,NULL,NULL),(5859,303,1280.19,94.048,NULL,NULL,NULL,NULL),(5860,303,1370.47,95.0752,NULL,NULL,NULL,NULL),(5861,303,1467.1,95.5906,NULL,NULL,NULL,NULL),(5862,303,1570.56,95.5942,NULL,NULL,NULL,NULL),(5863,303,1739.58,96.6232,NULL,NULL,NULL,NULL),(5864,303,1841.22,99.1857,NULL,NULL,NULL,NULL),(5865,303,2039.36,98.6793,NULL,NULL,NULL,NULL),(5866,303,2208.11,99.1957,NULL,NULL,NULL,NULL),(5867,303,2310.73,98.1748,NULL,NULL,NULL,NULL),(5868,303,2473.67,99.202,NULL,NULL,NULL,NULL),(5869,303,2708.94,99.2065,NULL,NULL,NULL,NULL),(5870,303,2933.08,101.258,NULL,NULL,NULL,NULL),(5871,303,3104.45,101.774,NULL,NULL,NULL,NULL),(5872,303,3323.37,102.289,NULL,NULL,NULL,NULL),(5873,303,3681.02,103.318,NULL,NULL,NULL,NULL),(5874,303,3896.09,103.832,NULL,NULL,NULL,NULL),(5875,303,4077.16,102.3,NULL,NULL,NULL,NULL),(5876,303,4315.37,103.839,NULL,NULL,NULL,NULL),(5877,303,4414.51,104.863,NULL,NULL,NULL,NULL),(5878,303,4567.51,102.306,NULL,NULL,NULL,NULL),(5879,303,4779.78,104.868,NULL,NULL,NULL,NULL),(5880,303,4945.44,107.94,NULL,NULL,NULL,NULL),(5881,303,5354.64,102.315,NULL,NULL,NULL,NULL),(5882,303,5732.22,105.901,NULL,NULL,NULL,NULL),(5883,303,6067.14,106.416,NULL,NULL,NULL,NULL),(5884,303,6494.97,106.42,NULL,NULL,NULL,NULL),(5885,303,6952.97,106.936,NULL,NULL,NULL,NULL),(5886,303,7359.21,106.938,NULL,NULL,NULL,NULL),(5887,303,7701.22,111.035,NULL,NULL,NULL,NULL),(5888,303,8433.68,108.994,NULL,NULL,NULL,NULL),(5889,303,10951.1,112.078,NULL,NULL,NULL,NULL),(5890,303,11076.2,112.079,NULL,NULL,NULL,NULL),(5891,304,3.00239,60.1596,NULL,NULL,NULL,NULL),(5892,304,3.97438,73.9667,NULL,NULL,NULL,NULL),(5893,304,7.04282,79.884,NULL,NULL,NULL,NULL),(5894,304,8.05772,87.7737,NULL,NULL,NULL,NULL),(5895,304,9.01432,94.6774,NULL,NULL,NULL,NULL),(5896,304,11.1559,91.7187,NULL,NULL,NULL,NULL),(5897,304,14.9341,114.402,NULL,NULL,NULL,NULL),(5898,304,17.8703,128.209,NULL,NULL,NULL,NULL),(5899,304,21.1453,144.975,NULL,NULL,NULL,NULL),(5900,304,30.9646,173.575,NULL,NULL,NULL,NULL),(5901,304,37.8933,194.286,NULL,NULL,NULL,NULL),(5902,304,51.2991,221.9,NULL,NULL,NULL,NULL),(5903,304,63.4862,239.653,NULL,NULL,NULL,NULL),(5904,304,78.5687,250.5,NULL,NULL,NULL,NULL),(5905,304,92.9675,260.363,NULL,NULL,NULL,NULL),(5906,304,100.562,266.281,NULL,NULL,NULL,NULL),(5907,304,127.277,276.142,NULL,NULL,NULL,NULL),(5908,304,155.757,285.018,NULL,NULL,NULL,NULL),(5909,304,184.302,291.922,NULL,NULL,NULL,NULL),(5910,304,215.645,293.895,NULL,NULL,NULL,NULL),(5911,304,246.72,299.811,NULL,NULL,NULL,NULL),(5912,304,282.273,304.742,NULL,NULL,NULL,NULL),(5913,304,312.262,315.591,NULL,NULL,NULL,NULL),(5914,304,341.583,315.591,NULL,NULL,NULL,NULL),(5915,304,369.488,317.564,NULL,NULL,NULL,NULL),(5916,304,390.806,324.468,NULL,NULL,NULL,NULL),(5917,304,422.733,321.509,NULL,NULL,NULL,NULL),(5918,304,457.268,323.482,NULL,NULL,NULL,NULL),(5919,304,483.65,323.482,NULL,NULL,NULL,NULL),(5920,304,541.068,326.441,NULL,NULL,NULL,NULL),(5921,304,598.551,334.329,NULL,NULL,NULL,NULL),(5922,304,654.754,333.342,NULL,NULL,NULL,NULL),(5923,304,716.234,336.301,NULL,NULL,NULL,NULL),(5924,304,740.749,338.274,NULL,NULL,NULL,NULL),(5925,304,766.104,339.26,NULL,NULL,NULL,NULL),(5926,304,819.446,341.233,NULL,NULL,NULL,NULL),(5927,304,937.53,345.178,NULL,NULL,NULL,NULL),(5928,304,991.621,347.151,NULL,NULL,NULL,NULL),(5929,304,1037.13,347.151,NULL,NULL,NULL,NULL),(5930,304,1096.97,347.151,NULL,NULL,NULL,NULL),(5931,304,1199.97,357.011,NULL,NULL,NULL,NULL),(5932,304,1298.01,362.929,NULL,NULL,NULL,NULL),(5933,304,1357.58,365.888,NULL,NULL,NULL,NULL),(5934,304,1468.49,367.861,NULL,NULL,NULL,NULL),(5935,304,1570.73,372.792,NULL,NULL,NULL,NULL),(5936,304,1680.1,367.861,NULL,NULL,NULL,NULL),(5937,304,1737.61,371.806,NULL,NULL,NULL,NULL),(5938,304,1837.86,384.628,NULL,NULL,NULL,NULL),(5939,304,2033.11,385.612,NULL,NULL,NULL,NULL),(5940,304,2199.2,388.571,NULL,NULL,NULL,NULL),(5941,304,2326.09,386.598,NULL,NULL,NULL,NULL),(5942,304,2460.29,386.598,NULL,NULL,NULL,NULL),(5943,304,2573.21,393.502,NULL,NULL,NULL,NULL),(5944,304,2721.67,393.502,NULL,NULL,NULL,NULL),(5945,304,2944.02,399.42,NULL,NULL,NULL,NULL),(5946,304,3113.87,401.393,NULL,NULL,NULL,NULL),(5947,304,3330.68,404.352,NULL,NULL,NULL,NULL),(5948,304,3483.55,407.311,NULL,NULL,NULL,NULL),(5949,304,3726.1,408.297,NULL,NULL,NULL,NULL),(5950,304,3897.11,415.199,NULL,NULL,NULL,NULL),(5951,304,4030.5,408.297,NULL,NULL,NULL,NULL),(5952,304,4168.46,413.228,NULL,NULL,NULL,NULL),(5953,304,4408.96,422.103,NULL,NULL,NULL,NULL),(5954,304,4611.31,428.021,NULL,NULL,NULL,NULL),(5955,304,4769.15,431.966,NULL,NULL,NULL,NULL),(5956,304,5044.31,426.048,NULL,NULL,NULL,NULL),(5957,304,5101.21,425.062,NULL,NULL,NULL,NULL),(5958,305,1.89544,39.721,NULL,NULL,NULL,NULL),(5959,305,6.96425,59.5814,NULL,NULL,NULL,NULL),(5960,305,13.0531,73.7675,NULL,NULL,NULL,NULL),(5961,305,15.9739,81.5698,NULL,NULL,NULL,NULL),(5962,305,19.1146,90.0814,NULL,NULL,NULL,NULL),(5963,305,21.1453,97.1745,NULL,NULL,NULL,NULL),(5964,305,28.9489,109.233,NULL,NULL,NULL,NULL),(5965,305,35.8263,121.291,NULL,NULL,NULL,NULL),(5966,305,49.048,139.023,NULL,NULL,NULL,NULL),(5967,305,60.7004,154.628,NULL,NULL,NULL,NULL),(5968,305,76.8255,156.756,NULL,NULL,NULL,NULL),(5969,305,91.9304,158.884,NULL,NULL,NULL,NULL),(5970,305,100.562,166.686,NULL,NULL,NULL,NULL),(5971,305,125.857,172.361,NULL,NULL,NULL,NULL),(5972,305,154.02,176.616,NULL,NULL,NULL,NULL),(5973,305,182.246,173.78,NULL,NULL,NULL,NULL),(5974,305,210.86,183,NULL,NULL,NULL,NULL),(5975,305,246.72,185.837,NULL,NULL,NULL,NULL),(5976,305,279.124,192.931,NULL,NULL,NULL,NULL),(5977,305,308.778,192.931,NULL,NULL,NULL,NULL),(5978,305,337.772,193.64,NULL,NULL,NULL,NULL),(5979,305,365.366,195.767,NULL,NULL,NULL,NULL),(5980,305,395.215,200.023,NULL,NULL,NULL,NULL),(5981,305,422.733,200.023,NULL,NULL,NULL,NULL),(5982,305,483.65,203.57,NULL,NULL,NULL,NULL),(5983,305,505.847,200.023,NULL,NULL,NULL,NULL),(5984,305,572.285,200.023,NULL,NULL,NULL,NULL),(5985,305,626.022,202.151,NULL,NULL,NULL,NULL),(5986,305,684.804,203.57,NULL,NULL,NULL,NULL),(5987,305,716.234,206.407,NULL,NULL,NULL,NULL),(5988,305,732.485,207.826,NULL,NULL,NULL,NULL),(5989,305,766.104,206.407,NULL,NULL,NULL,NULL),(5990,305,819.446,207.826,NULL,NULL,NULL,NULL),(5991,305,886.39,207.117,NULL,NULL,NULL,NULL),(5992,305,937.53,212.082,NULL,NULL,NULL,NULL),(5993,305,1037.13,213.501,NULL,NULL,NULL,NULL),(5994,305,1096.97,213.501,NULL,NULL,NULL,NULL),(5995,305,1109.35,219.174,NULL,NULL,NULL,NULL),(5996,305,1213.51,218.465,NULL,NULL,NULL,NULL),(5997,305,1298.01,218.465,NULL,NULL,NULL,NULL),(5998,305,1372.89,222.721,NULL,NULL,NULL,NULL),(5999,305,1485.05,222.721,NULL,NULL,NULL,NULL),(6000,305,1570.73,224.14,NULL,NULL,NULL,NULL),(6001,305,1680.1,223.43,NULL,NULL,NULL,NULL),(6002,305,1737.61,221.302,NULL,NULL,NULL,NULL),(6003,305,1858.59,228.396,NULL,NULL,NULL,NULL),(6004,305,2056.05,231.233,NULL,NULL,NULL,NULL),(6005,305,2079.24,236.906,NULL,NULL,NULL,NULL),(6006,305,2199.2,230.524,NULL,NULL,NULL,NULL),(6007,305,2326.09,231.233,NULL,NULL,NULL,NULL),(6008,305,2460.29,231.943,NULL,NULL,NULL,NULL),(6009,305,2573.21,235.489,NULL,NULL,NULL,NULL),(6010,305,2721.67,235.489,NULL,NULL,NULL,NULL),(6011,305,2944.02,236.906,NULL,NULL,NULL,NULL),(6012,305,3149,238.325,NULL,NULL,NULL,NULL),(6013,305,3330.68,240.453,NULL,NULL,NULL,NULL),(6014,305,3483.55,241.872,NULL,NULL,NULL,NULL),(6015,305,3684.53,242.581,NULL,NULL,NULL,NULL),(6016,305,3941.08,244,NULL,NULL,NULL,NULL),(6017,305,4075.97,239.744,NULL,NULL,NULL,NULL),(6018,305,4215.49,244.709,NULL,NULL,NULL,NULL),(6019,305,4408.96,248.256,NULL,NULL,NULL,NULL),(6020,305,4611.31,251.803,NULL,NULL,NULL,NULL),(6021,305,4769.15,253.222,NULL,NULL,NULL,NULL),(6022,305,5101.21,253.222,NULL,NULL,NULL,NULL),(6023,306,1.73274,28.5898,NULL,NULL,NULL,NULL),(6024,306,4.01922,34.8276,NULL,NULL,NULL,NULL),(6025,306,9.11602,48.3427,NULL,NULL,NULL,NULL),(6026,306,11.0314,54.0606,NULL,NULL,NULL,NULL),(6027,306,14.9341,59.7786,NULL,NULL,NULL,NULL),(6028,306,17.8703,64.9768,NULL,NULL,NULL,NULL),(6029,306,20.9094,67.5758,NULL,NULL,NULL,NULL),(6030,306,23.9225,69.1353,NULL,NULL,NULL,NULL),(6031,306,30.9646,76.4126,NULL,NULL,NULL,NULL),(6032,306,37.8933,82.6504,NULL,NULL,NULL,NULL),(6033,306,50.1609,89.9278,NULL,NULL,NULL,NULL),(6034,306,64.2025,99.8043,NULL,NULL,NULL,NULL),(6035,306,77.6922,99.2845,NULL,NULL,NULL,NULL),(6036,306,92.9675,103.443,NULL,NULL,NULL,NULL),(6037,306,100.562,105.522,NULL,NULL,NULL,NULL),(6038,306,127.277,110.201,NULL,NULL,NULL,NULL),(6039,306,148.922,111.76,NULL,NULL,NULL,NULL),(6040,306,155.757,113.319,NULL,NULL,NULL,NULL),(6041,306,186.381,114.879,NULL,NULL,NULL,NULL),(6042,306,213.239,116.438,NULL,NULL,NULL,NULL),(6043,306,241.246,116.958,NULL,NULL,NULL,NULL),(6044,306,276.011,121.117,NULL,NULL,NULL,NULL),(6045,306,301.927,123.716,NULL,NULL,NULL,NULL),(6046,306,330.278,123.716,NULL,NULL,NULL,NULL),(6047,306,369.488,125.795,NULL,NULL,NULL,NULL),(6048,306,386.446,127.874,NULL,NULL,NULL,NULL),(6049,306,418.017,127.874,NULL,NULL,NULL,NULL),(6050,306,447.122,127.355,NULL,NULL,NULL,NULL),(6051,306,472.919,127.355,NULL,NULL,NULL,NULL),(6052,306,535.032,127.355,NULL,NULL,NULL,NULL),(6053,306,591.874,127.874,NULL,NULL,NULL,NULL),(6054,306,647.449,130.993,NULL,NULL,NULL,NULL),(6055,306,700.343,130.993,NULL,NULL,NULL,NULL),(6056,306,740.749,131.513,NULL,NULL,NULL,NULL),(6057,306,757.557,131.513,NULL,NULL,NULL,NULL),(6058,306,819.446,133.072,NULL,NULL,NULL,NULL),(6059,306,866.724,133.592,NULL,NULL,NULL,NULL),(6060,306,948.107,133.592,NULL,NULL,NULL,NULL),(6061,306,1025.56,134.112,NULL,NULL,NULL,NULL),(6062,306,1096.97,132.032,NULL,NULL,NULL,NULL),(6063,306,1109.35,135.671,NULL,NULL,NULL,NULL),(6064,306,1199.97,138.271,NULL,NULL,NULL,NULL),(6065,306,1298.01,139.31,NULL,NULL,NULL,NULL),(6066,306,1342.43,140.87,NULL,NULL,NULL,NULL),(6067,306,1468.49,142.948,NULL,NULL,NULL,NULL),(6068,306,1553.21,141.91,NULL,NULL,NULL,NULL),(6069,306,1642.82,141.39,NULL,NULL,NULL,NULL),(6070,306,1718.22,140.35,NULL,NULL,NULL,NULL),(6071,306,1858.59,144.508,NULL,NULL,NULL,NULL),(6072,306,2079.24,147.107,NULL,NULL,NULL,NULL),(6073,306,2199.2,145.548,NULL,NULL,NULL,NULL),(6074,306,2300.14,144.508,NULL,NULL,NULL,NULL),(6075,306,2488.05,145.028,NULL,NULL,NULL,NULL),(6076,306,2573.21,151.786,NULL,NULL,NULL,NULL),(6077,306,2721.67,145.548,NULL,NULL,NULL,NULL),(6078,306,2944.02,148.147,NULL,NULL,NULL,NULL),(6079,306,3113.87,151.266,NULL,NULL,NULL,NULL),(6080,306,3368.26,151.266,NULL,NULL,NULL,NULL),(6081,306,3483.55,151.786,NULL,NULL,NULL,NULL),(6082,306,3684.53,149.706,NULL,NULL,NULL,NULL),(6083,306,3810.65,150.746,NULL,NULL,NULL,NULL),(6084,306,4030.5,151.786,NULL,NULL,NULL,NULL),(6085,306,4215.49,148.667,NULL,NULL,NULL,NULL),(6086,306,4408.96,155.425,NULL,NULL,NULL,NULL),(6087,306,4611.31,156.984,NULL,NULL,NULL,NULL),(6088,306,4769.15,158.543,NULL,NULL,NULL,NULL),(6089,306,4988.03,159.582,NULL,NULL,NULL,NULL),(6090,306,5158.76,158.023,NULL,NULL,NULL,NULL),(6091,307,4.97406,24.5599,NULL,NULL,NULL,NULL),(6092,307,9.01432,31.3019,NULL,NULL,NULL,NULL),(6093,307,12.9074,37.0806,NULL,NULL,NULL,NULL),(6094,307,15.9739,39.0069,NULL,NULL,NULL,NULL),(6095,307,18.9013,41.4147,NULL,NULL,NULL,NULL),(6096,307,21.1453,42.3779,NULL,NULL,NULL,NULL),(6097,307,22.1157,44.7857,NULL,NULL,NULL,NULL),(6098,307,28.9489,45.7488,NULL,NULL,NULL,NULL),(6099,307,35.8263,50.0829,NULL,NULL,NULL,NULL),(6100,307,47.9598,52.9724,NULL,NULL,NULL,NULL),(6101,307,62.0777,56.8249,NULL,NULL,NULL,NULL),(6102,307,76.8255,59.7143,NULL,NULL,NULL,NULL),(6103,307,90.9049,60.6774,NULL,NULL,NULL,NULL),(6104,307,100.562,63.0853,NULL,NULL,NULL,NULL),(6105,307,127.277,65.4931,NULL,NULL,NULL,NULL),(6106,307,154.02,67.4194,NULL,NULL,NULL,NULL),(6107,307,182.246,68.8641,NULL,NULL,NULL,NULL),(6108,307,213.239,69.3456,NULL,NULL,NULL,NULL),(6109,307,238.555,70.3088,NULL,NULL,NULL,NULL),(6110,307,272.931,72.7166,NULL,NULL,NULL,NULL),(6111,307,301.927,73.1981,NULL,NULL,NULL,NULL),(6112,307,330.278,74.1613,NULL,NULL,NULL,NULL),(6113,307,365.366,75.1244,NULL,NULL,NULL,NULL),(6114,307,413.353,78.4954,NULL,NULL,NULL,NULL),(6115,307,472.919,75.606,NULL,NULL,NULL,NULL),(6116,307,535.032,74.6428,NULL,NULL,NULL,NULL),(6117,307,766.104,78.4954,NULL,NULL,NULL,NULL),(6118,307,828.69,79.4585,NULL,NULL,NULL,NULL),(6119,307,906.503,80.4216,NULL,NULL,NULL,NULL),(6120,307,1199.97,84.7557,NULL,NULL,NULL,NULL),(6121,307,2102.7,88.1268,NULL,NULL,NULL,NULL),(6122,307,3684.53,92.9424,NULL,NULL,NULL,NULL),(6123,307,3941.08,93.424,NULL,NULL,NULL,NULL),(6124,307,4030.5,91.9793,NULL,NULL,NULL,NULL),(6125,307,4408.96,93.9056,NULL,NULL,NULL,NULL),(6126,307,4715.95,98.2397,NULL,NULL,NULL,NULL),(6127,307,5101.21,96.795,NULL,NULL,NULL,NULL),(6128,308,1.8743,17.7035,NULL,NULL,NULL,NULL),(6129,308,3.97438,22.4244,NULL,NULL,NULL,NULL),(6130,308,7.96783,28.719,NULL,NULL,NULL,NULL),(6131,308,9.01432,31.4729,NULL,NULL,NULL,NULL),(6132,308,10.9083,33.0465,NULL,NULL,NULL,NULL),(6133,308,13.9619,36.1938,NULL,NULL,NULL,NULL),(6134,308,15.9739,38.1608,NULL,NULL,NULL,NULL),(6135,308,17.8703,39.3411,NULL,NULL,NULL,NULL),(6136,308,20.9094,40.5213,NULL,NULL,NULL,NULL),(6137,308,23.9225,41.3082,NULL,NULL,NULL,NULL),(6138,308,30.9646,44.062,NULL,NULL,NULL,NULL),(6139,308,35.0314,45.6357,NULL,NULL,NULL,NULL),(6140,308,44.8378,47.9962,NULL,NULL,NULL,NULL),(6141,308,51.8778,49.1764,NULL,NULL,NULL,NULL),(6142,308,58.6915,49.9632,NULL,NULL,NULL,NULL),(6143,308,66.4,50.75,NULL,NULL,NULL,NULL),(6144,308,72.6348,51.5369,NULL,NULL,NULL,NULL),(6145,308,80.3515,52.3237,NULL,NULL,NULL,NULL),(6146,308,86.9158,53.1105,NULL,NULL,NULL,NULL),(6147,308,94.0164,53.5039,NULL,NULL,NULL,NULL),(6148,308,100.562,53.8974,NULL,NULL,NULL,NULL),(6149,308,128.713,56.2578,NULL,NULL,NULL,NULL),(6150,308,162.906,58.2249,NULL,NULL,NULL,NULL),(6151,308,190.61,58.6183,NULL,NULL,NULL,NULL),(6152,308,218.078,61.3721,NULL,NULL,NULL,NULL),(6153,308,246.72,60.5853,NULL,NULL,NULL,NULL),(6154,308,276.011,63.3392,NULL,NULL,NULL,NULL),(6155,308,301.927,61.3721,NULL,NULL,NULL,NULL),(6156,308,330.278,61.7656,NULL,NULL,NULL,NULL),(6157,308,365.366,62.5524,NULL,NULL,NULL,NULL),(6158,308,422.733,63.7326,NULL,NULL,NULL,NULL),(6159,308,478.254,64.9128,NULL,NULL,NULL,NULL),(6160,308,535.032,64.126,NULL,NULL,NULL,NULL),(6161,308,654.754,65.3063,NULL,NULL,NULL,NULL),(6162,308,828.69,66.0931,NULL,NULL,NULL,NULL),(6163,308,969.62,66.8799,NULL,NULL,NULL,NULL),(6164,308,1419.89,70.0271,NULL,NULL,NULL,NULL),(6165,308,1922.21,70.814,NULL,NULL,NULL,NULL),(6166,308,2814.83,75.535,NULL,NULL,NULL,NULL),(6167,308,3293.53,75.535,NULL,NULL,NULL,NULL),(6168,308,3643.43,76.3218,NULL,NULL,NULL,NULL),(6169,308,3853.64,75.535,NULL,NULL,NULL,NULL),(6170,308,4121.96,78.2888,NULL,NULL,NULL,NULL),(6171,308,4458.7,75.9283,NULL,NULL,NULL,NULL),(6172,309,1.79078,5.46038,NULL,NULL,NULL,NULL),(6173,309,10.8767,26.8469,NULL,NULL,NULL,NULL),(6174,309,13.0123,31.3973,NULL,NULL,NULL,NULL),(6175,309,17.8077,37.7676,NULL,NULL,NULL,NULL),(6176,309,20.8322,37.3126,NULL,NULL,NULL,NULL),(6177,309,37.7261,63.7044,NULL,NULL,NULL,NULL),(6178,309,49.9226,83.2707,NULL,NULL,NULL,NULL),(6179,309,60.3979,91.4614,NULL,NULL,NULL,NULL),(6180,309,77.2819,103.292,NULL,NULL,NULL,NULL),(6181,309,92.4563,110.118,NULL,NULL,NULL,NULL),(6182,309,101.127,116.488,NULL,NULL,NULL,NULL),(6183,309,106.954,118.763,NULL,NULL,NULL,NULL),(6184,309,126.529,125.134,NULL,NULL,NULL,NULL),(6185,309,154.804,128.319,NULL,NULL,NULL,NULL),(6186,309,183.136,129.684,NULL,NULL,NULL,NULL),(6187,309,234.331,134.689,NULL,NULL,NULL,NULL),(6188,309,245.072,141.515,NULL,NULL,NULL,NULL),(6189,309,268.055,143.79,NULL,NULL,NULL,NULL),(6190,309,293.193,145.61,NULL,NULL,NULL,NULL),(6191,309,320.688,145.155,NULL,NULL,NULL,NULL),(6192,309,350.762,146.52,NULL,NULL,NULL,NULL),(6193,309,366.84,146.975,NULL,NULL,NULL,NULL),(6194,309,375.154,147.885,NULL,NULL,NULL,NULL),(6195,309,405.763,146.975,NULL,NULL,NULL,NULL),(6196,309,433.98,148.795,NULL,NULL,NULL,NULL),(6197,309,464.159,147.43,NULL,NULL,NULL,NULL),(6198,309,525.043,153.801,NULL,NULL,NULL,NULL),(6199,309,580.751,151.981,NULL,NULL,NULL,NULL),(6200,309,635.213,150.16,NULL,NULL,NULL,NULL),(6201,309,687.041,152.436,NULL,NULL,NULL,NULL),(6202,309,726.631,152.891,NULL,NULL,NULL,NULL),(6203,309,751.471,151.071,NULL,NULL,NULL,NULL),(6204,309,803.729,150.615,NULL,NULL,NULL,NULL),(6205,309,859.62,152.436,NULL,NULL,NULL,NULL),(6206,309,919.398,153.346,NULL,NULL,NULL,NULL),(6207,309,1005.62,151.525,NULL,NULL,NULL,NULL),(6208,309,1063.56,154.711,NULL,NULL,NULL,NULL),(6209,309,1099.92,155.621,NULL,NULL,NULL,NULL),(6210,309,1150.34,161.536,NULL,NULL,NULL,NULL),(6211,309,1272.4,160.171,NULL,NULL,NULL,NULL),(6212,309,1345.72,161.081,NULL,NULL,NULL,NULL),(6213,309,1455.52,161.536,NULL,NULL,NULL,NULL),(6214,309,1628.09,160.626,NULL,NULL,NULL,NULL),(6215,309,1683.75,165.176,NULL,NULL,NULL,NULL),(6216,309,1780.77,170.182,NULL,NULL,NULL,NULL),(6217,309,1821.13,173.367,NULL,NULL,NULL,NULL),(6218,309,2037.05,173.822,NULL,NULL,NULL,NULL),(6219,309,2178.71,172.912,NULL,NULL,NULL,NULL),(6220,309,2304.25,173.822,NULL,NULL,NULL,NULL),(6221,309,2548.74,172.457,NULL,NULL,NULL,NULL),(6222,309,2725.98,174.277,NULL,NULL,NULL,NULL),(6223,309,2948.4,185.198,NULL,NULL,NULL,NULL),(6224,309,3297.98,179.737,NULL,NULL,NULL,NULL),(6225,309,3449.16,179.737,NULL,NULL,NULL,NULL),(6226,309,3607.26,184.288,NULL,NULL,NULL,NULL),(6227,309,3815.12,183.833,NULL,NULL,NULL,NULL),(6228,309,4080.43,185.198,NULL,NULL,NULL,NULL),(6229,309,4172.9,187.018,NULL,NULL,NULL,NULL),(6230,309,4315.55,189.293,NULL,NULL,NULL,NULL),(6231,309,4564.23,191.568,NULL,NULL,NULL,NULL),(6232,309,4667.67,193.844,NULL,NULL,NULL,NULL),(6233,309,4936.63,195.209,NULL,NULL,NULL,NULL),(6234,309,5048.51,189.293,NULL,NULL,NULL,NULL),(6235,310,1.73158,11.0211,NULL,NULL,NULL,NULL),(6236,310,6.94783,22.672,NULL,NULL,NULL,NULL),(6237,310,8.99024,29.5995,NULL,NULL,NULL,NULL),(6238,310,10.8767,33.0634,NULL,NULL,NULL,NULL),(6239,310,14.885,35.2676,NULL,NULL,NULL,NULL),(6240,310,18.0084,34.3228,NULL,NULL,NULL,NULL),(6241,310,20.8322,37.4717,NULL,NULL,NULL,NULL),(6242,310,24.0988,39.0463,NULL,NULL,NULL,NULL),(6243,310,30.8355,43.7696,NULL,NULL,NULL,NULL),(6244,310,38.1512,48.4929,NULL,NULL,NULL,NULL),(6245,310,49.9226,54.1608,NULL,NULL,NULL,NULL),(6246,310,63.8782,62.0331,NULL,NULL,NULL,NULL),(6247,310,78.1527,68.3308,NULL,NULL,NULL,NULL),(6248,310,85.4818,69.5904,NULL,NULL,NULL,NULL),(6249,310,100,74.3137,NULL,NULL,NULL,NULL),(6250,310,113.117,78.0924,NULL,NULL,NULL,NULL),(6251,310,129.396,80.6115,NULL,NULL,NULL,NULL),(6252,310,141.531,81.5561,NULL,NULL,NULL,NULL),(6253,310,173.158,82.5009,NULL,NULL,NULL,NULL),(6254,310,198.078,82.5009,NULL,NULL,NULL,NULL),(6255,310,209.492,85.3349,NULL,NULL,NULL,NULL),(6256,310,211.853,90.0582,NULL,NULL,NULL,NULL),(6257,310,224.06,91.9475,NULL,NULL,NULL,NULL),(6258,310,245.072,93.5219,NULL,NULL,NULL,NULL),(6259,310,274.13,95.4113,NULL,NULL,NULL,NULL),(6260,310,303.216,97.6155,NULL,NULL,NULL,NULL),(6261,310,327.956,97.3006,NULL,NULL,NULL,NULL),(6262,310,358.711,97.6155,NULL,NULL,NULL,NULL),(6263,310,366.84,99.19,NULL,NULL,NULL,NULL),(6264,310,383.656,95.4113,NULL,NULL,NULL,NULL),(6265,310,414.959,96.6709,NULL,NULL,NULL,NULL),(6266,310,443.815,96.9857,NULL,NULL,NULL,NULL),(6267,310,502.03,98.875,NULL,NULL,NULL,NULL),(6268,310,555.297,99.5048,NULL,NULL,NULL,NULL),(6269,310,614.216,102.969,NULL,NULL,NULL,NULL),(6270,310,671.816,101.709,NULL,NULL,NULL,NULL),(6271,310,726.631,102.969,NULL,NULL,NULL,NULL),(6272,310,794.773,102.339,NULL,NULL,NULL,NULL),(6273,310,840.571,102.654,NULL,NULL,NULL,NULL),(6274,310,909.154,103.284,NULL,NULL,NULL,NULL),(6275,310,994.413,97.3006,NULL,NULL,NULL,NULL),(6276,310,1051.71,104.858,NULL,NULL,NULL,NULL),(6277,310,1124.85,108.322,NULL,NULL,NULL,NULL),(6278,310,1244.2,109.266,NULL,NULL,NULL,NULL),(6279,310,1330.72,111.471,NULL,NULL,NULL,NULL),(6280,310,1423.26,109.896,NULL,NULL,NULL,NULL),(6281,310,1455.52,112.415,NULL,NULL,NULL,NULL),(6282,310,1683.75,112.73,NULL,NULL,NULL,NULL),(6283,310,1760.93,114.934,NULL,NULL,NULL,NULL),(6284,310,1821.13,116.194,NULL,NULL,NULL,NULL),(6285,310,2083.22,115.249,NULL,NULL,NULL,NULL),(6286,310,2178.71,117.453,NULL,NULL,NULL,NULL),(6287,310,2278.58,116.824,NULL,NULL,NULL,NULL),(6288,310,2409.88,119.343,NULL,NULL,NULL,NULL),(6289,310,2548.74,116.194,NULL,NULL,NULL,NULL),(6290,310,2695.61,119.658,NULL,NULL,NULL,NULL),(6291,310,2948.4,121.862,NULL,NULL,NULL,NULL),(6292,310,3083.55,121.547,NULL,NULL,NULL,NULL),(6293,310,3335.14,119.658,NULL,NULL,NULL,NULL),(6294,310,3607.26,121.232,NULL,NULL,NULL,NULL),(6295,310,3815.12,121.547,NULL,NULL,NULL,NULL),(6296,310,4126.4,122.177,NULL,NULL,NULL,NULL),(6297,310,4364.18,124.381,NULL,NULL,NULL,NULL),(6298,310,4564.23,127.215,NULL,NULL,NULL,NULL),(6299,310,4667.67,129.42,NULL,NULL,NULL,NULL),(6300,310,4992.26,128.474,NULL,NULL,NULL,NULL),(6301,311,2.86696,13.0762,NULL,NULL,NULL,NULL),(6302,311,6.94783,19.7819,NULL,NULL,NULL,NULL),(6303,311,8.99024,25.4818,NULL,NULL,NULL,NULL),(6304,311,10.0562,28.4993,NULL,NULL,NULL,NULL),(6305,311,15.9201,32.5228,NULL,NULL,NULL,NULL),(6306,311,21.0669,37.5521,NULL,NULL,NULL,NULL),(6307,311,30.8355,40.5696,NULL,NULL,NULL,NULL),(6308,311,37.7261,41.5756,NULL,NULL,NULL,NULL),(6309,311,49.9226,43.5872,NULL,NULL,NULL,NULL),(6310,311,63.8782,47.2754,NULL,NULL,NULL,NULL),(6311,311,76.4208,51.9694,NULL,NULL,NULL,NULL),(6312,311,92.4563,55.6575,NULL,NULL,NULL,NULL),(6313,311,98.8858,56.3281,NULL,NULL,NULL,NULL),(6314,311,126.529,63.7045,NULL,NULL,NULL,NULL),(6315,311,154.804,65.0456,NULL,NULL,NULL,NULL),(6316,311,183.136,68.7337,NULL,NULL,NULL,NULL),(6317,311,219.095,73.0924,NULL,NULL,NULL,NULL),(6318,311,231.72,69.7395,NULL,NULL,NULL,NULL),(6319,311,253.45,73.4277,NULL,NULL,NULL,NULL),(6320,311,280.342,73.763,NULL,NULL,NULL,NULL),(6321,311,306.632,73.763,NULL,NULL,NULL,NULL),(6322,311,335.388,76.4453,NULL,NULL,NULL,NULL),(6323,311,362.753,77.7865,NULL,NULL,NULL,NULL),(6324,311,392.35,76.4453,NULL,NULL,NULL,NULL),(6325,311,419.634,77.1159,NULL,NULL,NULL,NULL),(6326,311,443.815,76.7806,NULL,NULL,NULL,NULL),(6327,311,507.687,77.7865,NULL,NULL,NULL,NULL),(6328,311,567.882,79.1275,NULL,NULL,NULL,NULL),(6329,311,621.137,81.1393,NULL,NULL,NULL,NULL),(6330,311,679.386,79.1275,NULL,NULL,NULL,NULL),(6331,311,726.631,80.804,NULL,NULL,NULL,NULL),(6332,311,734.818,82.4804,NULL,NULL,NULL,NULL),(6333,311,794.773,81.1393,NULL,NULL,NULL,NULL),(6334,311,850.042,81.1393,NULL,NULL,NULL,NULL),(6335,311,899.024,82.1452,NULL,NULL,NULL,NULL),(6336,311,1005.62,80.1335,NULL,NULL,NULL,NULL),(6337,311,1051.71,84.4922,NULL,NULL,NULL,NULL),(6338,311,1087.67,84.8274,NULL,NULL,NULL,NULL),(6339,311,1124.85,87.5097,NULL,NULL,NULL,NULL),(6340,311,1230.34,86.8391,NULL,NULL,NULL,NULL),(6341,311,1330.72,87.5097,NULL,NULL,NULL,NULL),(6342,311,1439.3,86.8391,NULL,NULL,NULL,NULL),(6343,311,1471.92,86.1686,NULL,NULL,NULL,NULL),(6344,311,1609.95,85.1628,NULL,NULL,NULL,NULL),(6345,311,1683.75,88.1803,NULL,NULL,NULL,NULL),(6346,311,1760.93,98.2389,NULL,NULL,NULL,NULL),(6347,311,1800.84,93.5449,NULL,NULL,NULL,NULL),(6348,311,2083.22,90.8626,NULL,NULL,NULL,NULL),(6349,311,2178.71,93.5449,NULL,NULL,NULL,NULL),(6350,311,2278.58,92.539,NULL,NULL,NULL,NULL),(6351,311,2383.03,91.8684,NULL,NULL,NULL,NULL),(6352,311,2577.46,92.8744,NULL,NULL,NULL,NULL),(6353,311,2695.61,92.8744,NULL,NULL,NULL,NULL),(6354,311,2948.4,96.5625,NULL,NULL,NULL,NULL),(6355,311,3083.55,95.8919,NULL,NULL,NULL,NULL),(6356,311,3297.98,97.9036,NULL,NULL,NULL,NULL),(6357,311,3449.16,96.5625,NULL,NULL,NULL,NULL),(6358,311,3607.26,98.5742,NULL,NULL,NULL,NULL),(6359,311,3815.12,98.9094,NULL,NULL,NULL,NULL),(6360,311,4126.4,99.9154,NULL,NULL,NULL,NULL),(6361,311,4413.35,101.257,NULL,NULL,NULL,NULL),(6362,311,4667.67,106.621,NULL,NULL,NULL,NULL),(6363,311,5048.51,106.286,NULL,NULL,NULL,NULL),(6364,312,1.98078,9.8674,NULL,NULL,NULL,NULL),(6365,312,4.01242,12.3343,NULL,NULL,NULL,NULL),(6366,312,7.02612,13.0391,NULL,NULL,NULL,NULL),(6367,312,8.99024,15.1535,NULL,NULL,NULL,NULL),(6368,312,10.9992,16.9156,NULL,NULL,NULL,NULL),(6369,312,13.9172,21.8492,NULL,NULL,NULL,NULL),(6370,312,18.0084,22.2017,NULL,NULL,NULL,NULL),(6371,312,20.8322,21.8492,NULL,NULL,NULL,NULL),(6372,312,28.8306,24.3162,NULL,NULL,NULL,NULL),(6373,312,38.1512,25.7257,NULL,NULL,NULL,NULL),(6374,312,78.1527,34.1835,NULL,NULL,NULL,NULL),(6375,312,92.4563,37.3552,NULL,NULL,NULL,NULL),(6376,312,100,36.6504,NULL,NULL,NULL,NULL),(6377,312,126.529,39.1172,NULL,NULL,NULL,NULL),(6378,312,154.804,42.2889,NULL,NULL,NULL,NULL),(6379,312,247.834,46.8702,NULL,NULL,NULL,NULL),(6380,312,274.13,46.5177,NULL,NULL,NULL,NULL),(6381,312,303.216,48.6322,NULL,NULL,NULL,NULL),(6382,312,331.651,49.337,NULL,NULL,NULL,NULL),(6383,312,366.84,52.5087,NULL,NULL,NULL,NULL),(6384,312,414.959,50.0418,NULL,NULL,NULL,NULL),(6385,312,443.815,50.3943,NULL,NULL,NULL,NULL),(6386,312,502.03,52.1563,NULL,NULL,NULL,NULL),(6387,312,561.554,51.099,NULL,NULL,NULL,NULL),(6388,312,614.216,51.4515,NULL,NULL,NULL,NULL),(6389,312,734.818,52.1563,NULL,NULL,NULL,NULL),(6390,312,777.161,53.9183,NULL,NULL,NULL,NULL),(6391,312,840.571,54.2708,NULL,NULL,NULL,NULL),(6392,312,899.024,53.566,NULL,NULL,NULL,NULL),(6393,312,994.413,53.566,NULL,NULL,NULL,NULL),(6394,312,1051.71,55.3279,NULL,NULL,NULL,NULL),(6395,312,1099.92,58.1472,NULL,NULL,NULL,NULL),(6396,312,1163.3,58.1472,NULL,NULL,NULL,NULL),(6397,312,1592.01,58.4996,NULL,NULL,NULL,NULL),(6398,312,1683.75,60.2617,NULL,NULL,NULL,NULL),(6399,312,1800.84,63.4333,NULL,NULL,NULL,NULL),(6400,312,2060.01,63.7857,NULL,NULL,NULL,NULL),(6401,312,2203.26,64.4905,NULL,NULL,NULL,NULL),(6402,312,2548.74,63.0809,NULL,NULL,NULL,NULL),(6403,312,2948.4,68.3671,NULL,NULL,NULL,NULL),(6404,312,3118.3,68.0146,NULL,NULL,NULL,NULL),(6405,312,3297.98,68.0146,NULL,NULL,NULL,NULL),(6406,312,3449.16,69.7766,NULL,NULL,NULL,NULL),(6407,312,3607.26,70.4814,NULL,NULL,NULL,NULL),(6408,312,3815.12,70.4814,NULL,NULL,NULL,NULL),(6409,312,4126.4,70.1291,NULL,NULL,NULL,NULL),(6410,312,4364.18,71.1862,NULL,NULL,NULL,NULL),(6411,312,4564.23,72.9484,NULL,NULL,NULL,NULL),(6412,312,4667.67,75.4152,NULL,NULL,NULL,NULL),(6413,312,4992.26,76.12,NULL,NULL,NULL,NULL),(6414,313,1.86898,15.6576,NULL,NULL,NULL,NULL),(6415,313,4.00377,29.8919,NULL,NULL,NULL,NULL),(6416,313,8.87459,46.2612,NULL,NULL,NULL,NULL),(6417,313,9.94331,54.8017,NULL,NULL,NULL,NULL),(6418,313,14.8037,64.054,NULL,NULL,NULL,NULL),(6419,313,17.9606,74.0178,NULL,NULL,NULL,NULL),(6420,313,21.0599,80.4233,NULL,NULL,NULL,NULL),(6421,313,30.6492,104.621,NULL,NULL,NULL,NULL),(6422,313,37.6105,125.973,NULL,NULL,NULL,NULL),(6423,313,49.9765,144.477,NULL,NULL,NULL,NULL),(6424,313,63.4555,162.982,NULL,NULL,NULL,NULL),(6425,313,77.8678,172.945,NULL,NULL,NULL,NULL),(6426,313,92.349,181.486,NULL,NULL,NULL,NULL),(6427,313,101.144,182.909,NULL,NULL,NULL,NULL),(6428,313,128.423,190.027,NULL,NULL,NULL,NULL),(6429,313,216.672,204.261,NULL,NULL,NULL,NULL),(6430,313,245.541,208.53,NULL,NULL,NULL,NULL),(6431,313,271.999,215.648,NULL,NULL,NULL,NULL),(6432,313,301.309,217.072,NULL,NULL,NULL,NULL),(6433,313,330.003,220.631,NULL,NULL,NULL,NULL),(6434,313,361.43,220.631,NULL,NULL,NULL,NULL),(6435,313,386.95,218.494,NULL,NULL,NULL,NULL),(6436,313,414.27,228.458,NULL,NULL,NULL,NULL),(6437,313,532.018,229.883,NULL,NULL,NULL,NULL),(6438,313,589.346,231.305,NULL,NULL,NULL,NULL),(6439,313,645.471,237,NULL,NULL,NULL,NULL),(6440,313,715.025,235.576,NULL,NULL,NULL,NULL),(6441,313,867.504,239.134,NULL,NULL,NULL,NULL),(6442,313,960.984,241.269,NULL,NULL,NULL,NULL),(6443,313,1017.2,245.54,NULL,NULL,NULL,NULL),(6444,313,1089.02,248.386,NULL,NULL,NULL,NULL),(6445,313,1139.7,256.928,NULL,NULL,NULL,NULL),(6446,313,1220.17,259.062,NULL,NULL,NULL,NULL),(6447,313,1306.32,262.621,NULL,NULL,NULL,NULL),(6448,313,1463.63,261.909,NULL,NULL,NULL,NULL),(6449,313,1549.26,261.909,NULL,NULL,NULL,NULL),(6450,313,1658.64,264.756,NULL,NULL,NULL,NULL),(6451,313,1775.75,272.585,NULL,NULL,NULL,NULL),(6452,313,1816.6,275.432,NULL,NULL,NULL,NULL),(6453,313,2058.64,270.449,NULL,NULL,NULL,NULL),(6454,313,2179.07,275.432,NULL,NULL,NULL,NULL),(6455,313,2306.55,274.72,NULL,NULL,NULL,NULL),(6456,313,2555.1,276.144,NULL,NULL,NULL,NULL),(6457,313,2673.99,278.991,NULL,NULL,NULL,NULL),(6458,313,2928.64,278.991,NULL,NULL,NULL,NULL),(6459,313,3099.97,282.549,NULL,NULL,NULL,NULL),(6460,313,3434.02,283.261,NULL,NULL,NULL,NULL),(6461,313,3593.81,286.82,NULL,NULL,NULL,NULL),(6462,313,3891.56,281.837,NULL,NULL,NULL,NULL),(6463,313,4119.22,286.108,NULL,NULL,NULL,NULL),(6464,313,4460.49,291.801,NULL,NULL,NULL,NULL),(6465,313,4775.43,296.072,NULL,NULL,NULL,NULL),(6466,313,5054.8,290.377,NULL,NULL,NULL,NULL),(6467,313,5473.58,293.225,NULL,NULL,NULL,NULL),(6468,313,5994.84,291.801,NULL,NULL,NULL,NULL),(6469,313,6418.11,296.782,NULL,NULL,NULL,NULL),(6470,313,6871.27,296.072,NULL,NULL,NULL,NULL),(6471,313,7273.25,294.648,NULL,NULL,NULL,NULL),(6472,313,8056.99,298.206,NULL,NULL,NULL,NULL),(6473,313,10230,302.477,NULL,NULL,NULL,NULL),(6474,313,10952.3,302.477,NULL,NULL,NULL,NULL),(6475,314,1.97832,14.0254,NULL,NULL,NULL,NULL),(6476,314,6.98947,29.018,NULL,NULL,NULL,NULL),(6477,314,8.97607,34.8216,NULL,NULL,NULL,NULL),(6478,314,11.0148,40.1416,NULL,NULL,NULL,NULL),(6479,314,14.973,45.9452,NULL,NULL,NULL,NULL),(6480,314,17.9606,52.2324,NULL,NULL,NULL,NULL),(6481,314,20.8218,57.5524,NULL,NULL,NULL,NULL),(6482,314,30.6492,67.7086,NULL,NULL,NULL,NULL),(6483,314,49.9765,91.8902,NULL,NULL,NULL,NULL),(6484,314,64.1811,106.883,NULL,NULL,NULL,NULL),(6485,314,79.6589,116.556,NULL,NULL,NULL,NULL),(6486,314,92.349,122.359,NULL,NULL,NULL,NULL),(6487,314,100,123.81,NULL,NULL,NULL,NULL),(6488,314,121.325,129.614,NULL,NULL,NULL,NULL),(6489,314,195.595,139.286,NULL,NULL,NULL,NULL),(6490,314,224.191,147.992,NULL,NULL,NULL,NULL),(6491,314,254.061,150.409,NULL,NULL,NULL,NULL),(6492,314,281.438,151.377,NULL,NULL,NULL,NULL),(6493,314,311.765,154.279,NULL,NULL,NULL,NULL),(6494,314,337.594,156.214,NULL,NULL,NULL,NULL),(6495,314,365.564,156.214,NULL,NULL,NULL,NULL),(6496,314,369.744,154.763,NULL,NULL,NULL,NULL),(6497,314,400.377,154.279,NULL,NULL,NULL,NULL),(6498,314,404.956,160.082,NULL,NULL,NULL,NULL),(6499,314,514.175,156.698,NULL,NULL,NULL,NULL),(6500,314,576.095,156.698,NULL,NULL,NULL,NULL),(6501,314,739.837,160.566,NULL,NULL,NULL,NULL),(6502,314,792.073,162.017,NULL,NULL,NULL,NULL),(6503,314,867.504,162.017,NULL,NULL,NULL,NULL),(6504,314,994.331,163.468,NULL,NULL,NULL,NULL),(6505,314,1101.48,168.788,NULL,NULL,NULL,NULL),(6506,314,1192.73,168.788,NULL,NULL,NULL,NULL),(6507,314,1291.55,173.14,NULL,NULL,NULL,NULL),(6508,314,1367.11,172.656,NULL,NULL,NULL,NULL),(6509,314,1463.63,175.075,NULL,NULL,NULL,NULL),(6510,314,1549.26,163.951,NULL,NULL,NULL,NULL),(6511,314,1639.89,176.042,NULL,NULL,NULL,NULL),(6512,314,1755.68,179.427,NULL,NULL,NULL,NULL),(6513,314,2035.36,181.846,NULL,NULL,NULL,NULL),(6514,314,2280.47,182.813,NULL,NULL,NULL,NULL),(6515,314,2469.41,184.748,NULL,NULL,NULL,NULL),(6516,314,2555.1,183.78,NULL,NULL,NULL,NULL),(6517,314,2673.99,185.232,NULL,NULL,NULL,NULL),(6518,314,2928.64,188.616,NULL,NULL,NULL,NULL),(6519,314,2962.14,190.068,NULL,NULL,NULL,NULL),(6520,314,3281.33,191.035,NULL,NULL,NULL,NULL),(6521,314,3318.85,192.003,NULL,NULL,NULL,NULL),(6522,314,3634.91,193.453,NULL,NULL,NULL,NULL),(6523,314,3891.56,190.551,NULL,NULL,NULL,NULL),(6524,314,4072.64,194.421,NULL,NULL,NULL,NULL),(6525,314,4563.09,197.322,NULL,NULL,NULL,NULL),(6526,314,4721.44,198.773,NULL,NULL,NULL,NULL),(6527,314,4885.27,199.257,NULL,NULL,NULL,NULL),(6528,314,5112.6,197.322,NULL,NULL,NULL,NULL),(6529,314,5290.01,194.905,NULL,NULL,NULL,NULL),(6530,314,5860.05,194.421,NULL,NULL,NULL,NULL),(6531,314,5994.84,193.937,NULL,NULL,NULL,NULL),(6532,314,6491.51,199.257,NULL,NULL,NULL,NULL),(6533,314,6793.58,197.806,NULL,NULL,NULL,NULL),(6534,314,7109.71,197.322,NULL,NULL,NULL,NULL),(6535,314,7698.74,199.257,NULL,NULL,NULL,NULL),(6536,314,7965.89,201.674,NULL,NULL,NULL,NULL),(6537,314,8336.57,203.61,NULL,NULL,NULL,NULL),(6538,314,10230,204.577,NULL,NULL,NULL,NULL),(6539,314,11077.6,202.158,NULL,NULL,NULL,NULL),(6540,315,2.00094,13.2727,NULL,NULL,NULL,NULL),(6541,315,3.9585,17.8352,NULL,NULL,NULL,NULL),(6542,315,6.98947,28.6192,NULL,NULL,NULL,NULL),(6543,315,8.97607,29.8636,NULL,NULL,NULL,NULL),(6544,315,10.8902,33.1817,NULL,NULL,NULL,NULL),(6545,315,14.973,38.5737,NULL,NULL,NULL,NULL),(6546,315,17.9606,41.8919,NULL,NULL,NULL,NULL),(6547,315,20.8218,51.8465,NULL,NULL,NULL,NULL),(6548,315,23.0655,52.2611,NULL,NULL,NULL,NULL),(6549,315,29.9601,60.1418,NULL,NULL,NULL,NULL),(6550,315,41.6632,68.8521,NULL,NULL,NULL,NULL),(6551,315,55.9949,84.1986,NULL,NULL,NULL,NULL),(6552,315,67.9358,86.2724,NULL,NULL,NULL,NULL),(6553,315,82.4232,92.9088,NULL,NULL,NULL,NULL),(6554,315,100,97.0565,NULL,NULL,NULL,NULL),(6555,315,191.197,109.914,NULL,NULL,NULL,NULL),(6556,315,216.672,113.233,NULL,NULL,NULL,NULL),(6557,315,245.541,110.744,NULL,NULL,NULL,NULL),(6558,315,275.11,110.744,NULL,NULL,NULL,NULL),(6559,315,301.309,108.67,NULL,NULL,NULL,NULL),(6560,315,330.003,113.648,NULL,NULL,NULL,NULL),(6561,315,361.43,114.477,NULL,NULL,NULL,NULL),(6562,315,365.564,115.307,NULL,NULL,NULL,NULL),(6563,315,386.95,115.307,NULL,NULL,NULL,NULL),(6564,315,443.52,128.993,NULL,NULL,NULL,NULL),(6565,315,502.614,122.773,NULL,NULL,NULL,NULL),(6566,315,556.774,120.284,NULL,NULL,NULL,NULL),(6567,315,675.507,121.114,NULL,NULL,NULL,NULL),(6568,315,731.472,122.773,NULL,NULL,NULL,NULL),(6569,315,783.118,123.188,NULL,NULL,NULL,NULL),(6570,315,828.931,124.017,NULL,NULL,NULL,NULL),(6571,315,928.755,125.26,NULL,NULL,NULL,NULL),(6572,315,994.331,125.26,NULL,NULL,NULL,NULL),(6573,315,1089.02,128.993,NULL,NULL,NULL,NULL),(6574,315,1179.25,131.482,NULL,NULL,NULL,NULL),(6575,315,1291.55,131.067,NULL,NULL,NULL,NULL),(6576,315,1351.65,132.312,NULL,NULL,NULL,NULL),(6577,315,1463.63,132.727,NULL,NULL,NULL,NULL),(6578,315,1531.74,130.653,NULL,NULL,NULL,NULL),(6579,315,1621.35,134.386,NULL,NULL,NULL,NULL),(6580,315,1755.68,136.874,NULL,NULL,NULL,NULL),(6581,315,1816.6,138.119,NULL,NULL,NULL,NULL),(6582,315,2058.64,140.193,NULL,NULL,NULL,NULL),(6583,315,2203.99,138.948,NULL,NULL,NULL,NULL),(6584,315,2280.47,140.607,NULL,NULL,NULL,NULL),(6585,315,2413.88,140.607,NULL,NULL,NULL,NULL),(6586,315,2526.21,141.022,NULL,NULL,NULL,NULL),(6587,315,2673.99,141.022,NULL,NULL,NULL,NULL),(6588,315,2928.64,142.681,NULL,NULL,NULL,NULL),(6589,315,3135.42,145.17,NULL,NULL,NULL,NULL),(6590,315,3281.33,145.585,NULL,NULL,NULL,NULL),(6591,315,3473.29,146.414,NULL,NULL,NULL,NULL),(6592,315,3634.91,146.829,NULL,NULL,NULL,NULL),(6593,315,3891.56,146.414,NULL,NULL,NULL,NULL),(6594,315,4072.64,149.733,NULL,NULL,NULL,NULL),(6595,315,4410.06,154.71,NULL,NULL,NULL,NULL),(6596,315,4563.09,151.392,NULL,NULL,NULL,NULL),(6597,315,4721.44,151.392,NULL,NULL,NULL,NULL),(6598,315,4885.27,152.221,NULL,NULL,NULL,NULL),(6599,315,5112.6,151.392,NULL,NULL,NULL,NULL),(6600,315,5290.01,148.903,NULL,NULL,NULL,NULL),(6601,315,5793.79,148.488,NULL,NULL,NULL,NULL),(6602,315,5994.84,148.073,NULL,NULL,NULL,NULL),(6603,315,6418.11,150.977,NULL,NULL,NULL,NULL),(6604,315,6716.77,151.807,NULL,NULL,NULL,NULL),(6605,315,7611.7,154.71,NULL,NULL,NULL,NULL),(6606,315,7875.83,151.392,NULL,NULL,NULL,NULL),(6607,315,7965.89,152.636,NULL,NULL,NULL,NULL),(6608,315,8336.57,155.954,NULL,NULL,NULL,NULL),(6609,315,10230,152.221,NULL,NULL,NULL,NULL),(6610,315,10952.3,158.443,NULL,NULL,NULL,NULL),(6611,316,1.91197,11.6428,NULL,NULL,NULL,NULL),(6612,316,8.87459,22.8842,NULL,NULL,NULL,NULL),(6613,316,10.8902,26.096,NULL,NULL,NULL,NULL),(6614,316,14.973,30.1108,NULL,NULL,NULL,NULL),(6615,316,17.9606,31.3153,NULL,NULL,NULL,NULL),(6616,316,21.7907,32.5197,NULL,NULL,NULL,NULL),(6617,316,30.6492,37.3374,NULL,NULL,NULL,NULL),(6618,316,38.0406,38.5419,NULL,NULL,NULL,NULL),(6619,316,51.7107,38.1404,NULL,NULL,NULL,NULL),(6620,316,63.4555,46.5714,NULL,NULL,NULL,NULL),(6621,316,77.8678,52.1921,NULL,NULL,NULL,NULL),(6622,316,92.349,55.0025,NULL,NULL,NULL,NULL),(6623,316,100,56.2068,NULL,NULL,NULL,NULL),(6624,316,142.261,63.0319,NULL,NULL,NULL,NULL),(6625,316,176.569,66.2438,NULL,NULL,NULL,NULL),(6626,316,204.697,66.2438,NULL,NULL,NULL,NULL),(6627,316,231.97,69.4556,NULL,NULL,NULL,NULL),(6628,316,259.905,69.0542,NULL,NULL,NULL,NULL),(6629,316,287.912,71.8644,NULL,NULL,NULL,NULL),(6630,316,315.33,71.8644,NULL,NULL,NULL,NULL),(6631,316,341.455,72.6674,NULL,NULL,NULL,NULL),(6632,316,361.43,72.2659,NULL,NULL,NULL,NULL),(6633,316,373.972,71.0615,NULL,NULL,NULL,NULL),(6634,316,433.548,75.0763,NULL,NULL,NULL,NULL),(6635,316,464.159,74.6748,NULL,NULL,NULL,NULL),(6636,316,550.479,75.4778,NULL,NULL,NULL,NULL),(6637,316,667.869,77.0837,NULL,NULL,NULL,NULL),(6638,316,723.201,81.9014,NULL,NULL,NULL,NULL),(6639,316,731.472,78.6895,NULL,NULL,NULL,NULL),(6640,316,774.264,78.2881,NULL,NULL,NULL,NULL),(6641,316,918.254,77.8866,NULL,NULL,NULL,NULL),(6642,316,983.088,79.894,NULL,NULL,NULL,NULL),(6643,316,1064.54,81.4999,NULL,NULL,NULL,NULL),(6644,316,1165.91,83.9088,NULL,NULL,NULL,NULL),(6645,316,1276.95,79.894,NULL,NULL,NULL,NULL),(6646,316,1351.65,83.1059,NULL,NULL,NULL,NULL),(6647,316,1463.63,83.1059,NULL,NULL,NULL,NULL),(6648,316,1549.26,82.7044,NULL,NULL,NULL,NULL),(6649,316,1603.02,83.1059,NULL,NULL,NULL,NULL),(6650,316,1755.68,85.5147,NULL,NULL,NULL,NULL),(6651,316,1837.37,87.1206,NULL,NULL,NULL,NULL),(6652,316,2035.36,88.7265,NULL,NULL,NULL,NULL),(6653,316,2179.07,85.1133,NULL,NULL,NULL,NULL),(6654,316,2280.47,87.5221,NULL,NULL,NULL,NULL),(6655,316,2413.88,87.1206,NULL,NULL,NULL,NULL),(6656,316,2555.1,87.9236,NULL,NULL,NULL,NULL),(6657,316,2643.76,89.5295,NULL,NULL,NULL,NULL),(6658,316,2928.64,91.1354,NULL,NULL,NULL,NULL),(6659,316,3135.42,91.1354,NULL,NULL,NULL,NULL),(6660,316,3281.33,91.5369,NULL,NULL,NULL,NULL),(6661,316,3473.29,91.5369,NULL,NULL,NULL,NULL),(6662,316,3847.56,91.9384,NULL,NULL,NULL,NULL),(6663,316,4072.64,93.1427,NULL,NULL,NULL,NULL),(6664,316,4360.2,95.5516,NULL,NULL,NULL,NULL),(6665,316,5054.8,95.5516,NULL,NULL,NULL,NULL),(6666,316,5350.51,94.3472,NULL,NULL,NULL,NULL),(6667,316,5927.06,94.7487,NULL,NULL,NULL,NULL),(6668,316,6871.27,97.559,NULL,NULL,NULL,NULL),(6669,316,7273.25,95.5516,NULL,NULL,NULL,NULL),(6670,316,7698.74,97.9605,NULL,NULL,NULL,NULL),(6671,316,8149.13,97.9605,NULL,NULL,NULL,NULL),(6672,316,8336.57,99.5665,NULL,NULL,NULL,NULL),(6673,316,10230,100.771,NULL,NULL,NULL,NULL),(6674,316,10952.3,103.18,NULL,NULL,NULL,NULL),(6675,317,1.15909,8.98835,NULL,NULL,NULL,NULL),(6676,317,1.97666,19.3115,NULL,NULL,NULL,NULL),(6677,317,3.009,21.9322,NULL,NULL,NULL,NULL),(6678,317,6.01568,34.8397,NULL,NULL,NULL,NULL),(6679,317,10.0284,40.0351,NULL,NULL,NULL,NULL),(6680,317,13.0219,46.4771,NULL,NULL,NULL,NULL),(6681,317,16.9088,55.4812,NULL,NULL,NULL,NULL),(6682,317,20.0492,64.4728,NULL,NULL,NULL,NULL),(6683,317,29.8348,64.5281,NULL,NULL,NULL,NULL),(6684,317,37.0198,70.9637,NULL,NULL,NULL,NULL),(6685,317,49.1743,73.5653,NULL,NULL,NULL,NULL),(6686,317,77.4508,77.4719,NULL,NULL,NULL,NULL),(6687,317,98.3109,80.0673,NULL,NULL,NULL,NULL),(6688,317,127.656,83.9469,NULL,NULL,NULL,NULL),(6689,317,154.842,91.6605,NULL,NULL,NULL,NULL),(6690,317,183.6,94.2465,NULL,NULL,NULL,NULL),(6691,317,210.406,96.8277,NULL,NULL,NULL,NULL),(6692,317,238.403,98.1261,NULL,NULL,NULL,NULL),(6693,317,255.214,99.4168,NULL,NULL,NULL,NULL),(6694,317,285.908,105.838,NULL,NULL,NULL,NULL),(6695,317,313.101,109.694,NULL,NULL,NULL,NULL),(6696,317,342.88,112.269,NULL,NULL,NULL,NULL),(6697,317,362.913,113.558,NULL,NULL,NULL,NULL),(6698,317,401.969,113.572,NULL,NULL,NULL,NULL),(6699,317,482.067,116.16,NULL,NULL,NULL,NULL),(6700,317,533.945,123.861,NULL,NULL,NULL,NULL),(6701,317,604.994,126.44,NULL,NULL,NULL,NULL),(6702,317,655.053,130.295,NULL,NULL,NULL,NULL),(6703,317,725.547,132.871,NULL,NULL,NULL,NULL),(6704,317,831.48,125.203,NULL,NULL,NULL,NULL),(6705,317,942.12,126.502,NULL,NULL,NULL,NULL),(6706,317,1031.72,129.077,NULL,NULL,NULL,NULL),(6707,317,1142.76,135.496,NULL,NULL,NULL,NULL),(6708,317,1467.1,144.499,NULL,NULL,NULL,NULL),(6709,317,1681.31,162.454,NULL,NULL,NULL,NULL),(6710,317,1739.58,173.988,NULL,NULL,NULL,NULL),(6711,317,1841.22,172.715,NULL,NULL,NULL,NULL),(6712,317,2039.36,179.135,NULL,NULL,NULL,NULL),(6713,317,2183.17,189.393,NULL,NULL,NULL,NULL),(6714,317,2310.73,193.245,NULL,NULL,NULL,NULL),(6715,317,2473.67,188.13,NULL,NULL,NULL,NULL),(6716,317,2559.4,200.946,NULL,NULL,NULL,NULL),(6717,317,2739.88,217.61,NULL,NULL,NULL,NULL),(6718,317,2802.82,212.488,NULL,NULL,NULL,NULL),(6719,317,3069.4,213.782,NULL,NULL,NULL,NULL),(6720,317,3285.84,222.759,NULL,NULL,NULL,NULL),(6721,317,3517.54,240.705,NULL,NULL,NULL,NULL),(6722,317,3681.02,234.306,NULL,NULL,NULL,NULL),(6723,317,3852.09,243.279,NULL,NULL,NULL,NULL),(6724,317,4218.46,240.73,NULL,NULL,NULL,NULL),(6725,317,6136.44,275.372,NULL,NULL,NULL,NULL),(6726,317,6569.15,277.943,NULL,NULL,NULL,NULL),(6727,317,6952.97,293.324,NULL,NULL,NULL,NULL),(6728,317,7359.21,292.052,NULL,NULL,NULL,NULL),(6729,317,7701.22,303.587,NULL,NULL,NULL,NULL),(6730,317,7968.13,308.717,NULL,NULL,NULL,NULL),(6731,317,8338.45,311.286,NULL,NULL,NULL,NULL),(6732,317,10346.6,338.22,NULL,NULL,NULL,NULL),(6733,317,10827.4,339.506,NULL,NULL,NULL,NULL),(6734,317,11076.2,334.385,NULL,NULL,NULL,NULL),(6735,318,1,7.68668,NULL,NULL,NULL,NULL),(6736,318,1.99923,12.5631,NULL,NULL,NULL,NULL),(6737,318,5.01614,26.1109,NULL,NULL,NULL,NULL),(6738,318,7.99078,26.1594,NULL,NULL,NULL,NULL),(6739,318,13.9401,31.9825,NULL,NULL,NULL,NULL),(6740,318,35.3757,43.6097,NULL,NULL,NULL,NULL),(6741,318,46.9905,47.4827,NULL,NULL,NULL,NULL),(6742,318,61.7138,49.4327,NULL,NULL,NULL,NULL),(6743,318,75.7114,48.4932,NULL,NULL,NULL,NULL),(6744,318,99.4338,54.2867,NULL,NULL,NULL,NULL),(6745,318,153.094,53.3709,NULL,NULL,NULL,NULL),(6746,318,181.526,54.3495,NULL,NULL,NULL,NULL),(6747,318,208.03,57.2463,NULL,NULL,NULL,NULL),(6748,318,238.403,58.2213,NULL,NULL,NULL,NULL),(6749,318,285.908,61.1226,NULL,NULL,NULL,NULL),(6750,318,415.9,65.0051,NULL,NULL,NULL,NULL),(6751,318,482.067,69.8247,NULL,NULL,NULL,NULL),(6752,318,662.534,75.623,NULL,NULL,NULL,NULL),(6753,318,831.48,79.49,NULL,NULL,NULL,NULL),(6754,318,890.113,79.4971,NULL,NULL,NULL,NULL),(6755,318,1209.52,77.6073,NULL,NULL,NULL,NULL),(6756,318,1294.81,74.732,NULL,NULL,NULL,NULL),(6757,318,1370.47,72.8162,NULL,NULL,NULL,NULL),(6758,318,1483.86,75.707,NULL,NULL,NULL,NULL),(6759,318,1570.56,73.7913,NULL,NULL,NULL,NULL),(6760,318,2039.36,96.8786,NULL,NULL,NULL,NULL),(6761,318,2284.63,108.42,NULL,NULL,NULL,NULL),(6762,318,2559.4,110.354,NULL,NULL,NULL,NULL),(6763,318,2678.35,110.359,NULL,NULL,NULL,NULL),(6764,318,3069.4,116.138,NULL,NULL,NULL,NULL),(6765,318,3323.37,120.951,NULL,NULL,NULL,NULL),(6766,318,3723.06,125.766,NULL,NULL,NULL,NULL),(6767,318,3940.59,128.655,NULL,NULL,NULL,NULL),(6768,318,4170.82,126.739,NULL,NULL,NULL,NULL),(6769,318,4364.66,133.47,NULL,NULL,NULL,NULL),(6770,318,4619.68,137.319,NULL,NULL,NULL,NULL),(6771,318,4834.37,142.128,NULL,NULL,NULL,NULL),(6772,318,5175.27,144.057,NULL,NULL,NULL,NULL),(6773,318,5477.65,142.141,NULL,NULL,NULL,NULL),(6774,318,5732.22,147.911,NULL,NULL,NULL,NULL),(6775,318,6206.52,147.919,NULL,NULL,NULL,NULL),(6776,318,6569.15,152.729,NULL,NULL,NULL,NULL),(6777,318,6952.97,158.5,NULL,NULL,NULL,NULL),(6778,318,7443.26,160.429,NULL,NULL,NULL,NULL),(6779,318,7701.22,162.354,NULL,NULL,NULL,NULL),(6780,318,8433.68,165.246,NULL,NULL,NULL,NULL),(6781,318,10346.6,179.68,NULL,NULL,NULL,NULL),(6782,318,11076.2,183.531,NULL,NULL,NULL,NULL),(6783,319,2.81079,12.8671,NULL,NULL,NULL,NULL),(6784,319,3.81942,14.1064,NULL,NULL,NULL,NULL),(6785,319,6.97274,18.4124,NULL,NULL,NULL,NULL),(6786,319,7.99078,19.6403,NULL,NULL,NULL,NULL),(6787,319,9.91519,20.8736,NULL,NULL,NULL,NULL),(6788,319,10.9822,22.0992,NULL,NULL,NULL,NULL),(6789,319,17.8968,25.1789,NULL,NULL,NULL,NULL),(6790,319,20.9809,24.5799,NULL,NULL,NULL,NULL),(6791,319,30.8688,27.0433,NULL,NULL,NULL,NULL),(6792,319,38.3028,29.4955,NULL,NULL,NULL,NULL),(6793,319,50.3041,30.7324,NULL,NULL,NULL,NULL),(6794,319,63.8526,31.9671,NULL,NULL,NULL,NULL),(6795,319,78.3354,34.4184,NULL,NULL,NULL,NULL),(6796,319,92.884,35.6487,NULL,NULL,NULL,NULL),(6797,319,127.656,38.1076,NULL,NULL,NULL,NULL),(6798,319,154.842,38.7298,NULL,NULL,NULL,NULL),(6799,319,185.697,39.9607,NULL,NULL,NULL,NULL),(6800,319,210.406,40.5785,NULL,NULL,NULL,NULL),(6801,319,243.88,40.5882,NULL,NULL,NULL,NULL),(6802,319,282.68,44.2548,NULL,NULL,NULL,NULL),(6803,319,309.565,45.4797,NULL,NULL,NULL,NULL),(6804,319,339.008,46.0953,NULL,NULL,NULL,NULL),(6805,319,371.251,46.7107,NULL,NULL,NULL,NULL),(6806,319,401.969,47.3254,NULL,NULL,NULL,NULL),(6807,319,440.2,47.9409,NULL,NULL,NULL,NULL),(6808,319,476.623,49.165,NULL,NULL,NULL,NULL),(6809,319,533.945,50.3915,NULL,NULL,NULL,NULL),(6810,319,598.162,52.2274,NULL,NULL,NULL,NULL),(6811,319,647.655,52.8422,NULL,NULL,NULL,NULL),(6812,319,725.547,54.0686,NULL,NULL,NULL,NULL),(6813,319,890.113,56.52,NULL,NULL,NULL,NULL),(6814,319,1104.48,58.3626,NULL,NULL,NULL,NULL),(6815,319,1223.34,61.4167,NULL,NULL,NULL,NULL),(6816,319,1354.99,62.6424,NULL,NULL,NULL,NULL),(6817,319,1570.56,64.4806,NULL,NULL,NULL,NULL),(6818,319,1588.5,68.1381,NULL,NULL,NULL,NULL),(6819,319,1820.42,75.4606,NULL,NULL,NULL,NULL),(6820,319,2039.36,77.2965,NULL,NULL,NULL,NULL),(6821,319,2208.11,79.1302,NULL,NULL,NULL,NULL),(6822,319,2337.12,80.9623,NULL,NULL,NULL,NULL),(6823,319,2473.67,78.5283,NULL,NULL,NULL,NULL),(6824,319,2588.63,81.5785,NULL,NULL,NULL,NULL),(6825,319,2867.21,82.1948,NULL,NULL,NULL,NULL),(6826,319,3104.45,82.8095,NULL,NULL,NULL,NULL),(6827,319,3285.84,85.8605,NULL,NULL,NULL,NULL),(6828,319,3517.54,88.3029,NULL,NULL,NULL,NULL),(6829,319,3681.02,89.5248,NULL,NULL,NULL,NULL),(6830,319,3896.09,92.5759,NULL,NULL,NULL,NULL),(6831,319,3985.6,90.7491,NULL,NULL,NULL,NULL),(6832,319,4170.82,90.752,NULL,NULL,NULL,NULL),(6833,319,4414.51,93.1936,NULL,NULL,NULL,NULL),(6834,319,4619.68,94.4156,NULL,NULL,NULL,NULL),(6835,319,4725.81,99.2928,NULL,NULL,NULL,NULL),(6836,319,4945.44,99.9053,NULL,NULL,NULL,NULL),(6837,319,5234.38,98.6901,NULL,NULL,NULL,NULL),(6838,319,5477.65,99.912,NULL,NULL,NULL,NULL),(6839,319,5732.22,98.0866,NULL,NULL,NULL,NULL),(6840,319,6136.44,102.357,NULL,NULL,NULL,NULL),(6841,319,6644.18,103.582,NULL,NULL,NULL,NULL),(6842,319,6952.97,108.461,NULL,NULL,NULL,NULL),(6843,319,7276.1,109.072,NULL,NULL,NULL,NULL),(6844,319,7701.22,112.124,NULL,NULL,NULL,NULL),(6845,319,8151.18,113.346,NULL,NULL,NULL,NULL),(6846,319,8433.68,113.958,NULL,NULL,NULL,NULL),(6847,319,10346.6,121.285,NULL,NULL,NULL,NULL),(6848,319,10951.1,123.727,NULL,NULL,NULL,NULL),(6849,319,11076.2,120.071,NULL,NULL,NULL,NULL),(6850,320,1.88887,5.78123,NULL,NULL,NULL,NULL),(6851,320,5.07343,9.86193,NULL,NULL,NULL,NULL),(6852,320,6.01568,10.4467,NULL,NULL,NULL,NULL),(6853,320,9.05406,14.4913,NULL,NULL,NULL,NULL),(6854,320,13.0219,16.8106,NULL,NULL,NULL,NULL),(6855,320,18.9424,19.1306,NULL,NULL,NULL,NULL),(6856,320,21.2206,19.7118,NULL,NULL,NULL,NULL),(6857,320,28.8354,22.0275,NULL,NULL,NULL,NULL),(6858,320,35.7798,22.6151,NULL,NULL,NULL,NULL),(6859,320,46.9905,24.3547,NULL,NULL,NULL,NULL),(6860,320,61.7138,24.9458,NULL,NULL,NULL,NULL),(6861,320,75.7114,25.5327,NULL,NULL,NULL,NULL),(6862,320,91.8351,27.2672,NULL,NULL,NULL,NULL),(6863,320,100.569,27.8471,NULL,NULL,NULL,NULL),(6864,320,126.215,31.3061,NULL,NULL,NULL,NULL),(6865,320,156.611,30.1712,NULL,NULL,NULL,NULL),(6866,320,181.526,31.3288,NULL,NULL,NULL,NULL),(6867,320,210.406,32.4863,NULL,NULL,NULL,NULL),(6868,320,270.126,36.521,NULL,NULL,NULL,NULL),(6869,320,327.652,37.6813,NULL,NULL,NULL,NULL),(6870,320,358.815,37.687,NULL,NULL,NULL,NULL),(6871,320,384.117,37.6913,NULL,NULL,NULL,NULL),(6872,320,527.916,42.3044,NULL,NULL,NULL,NULL),(6873,320,591.407,42.8856,NULL,NULL,NULL,NULL),(6874,320,647.655,44.0395,NULL,NULL,NULL,NULL),(6875,320,822.091,47.4994,NULL,NULL,NULL,NULL),(6876,320,880.061,47.5037,NULL,NULL,NULL,NULL),(6877,320,931.481,47.5072,NULL,NULL,NULL,NULL),(6878,320,1339.69,49.8264,NULL,NULL,NULL,NULL),(6879,320,1467.1,50.4063,NULL,NULL,NULL,NULL),(6880,320,1820.42,61.3288,NULL,NULL,NULL,NULL),(6881,320,2110.04,60.7638,NULL,NULL,NULL,NULL),(6882,320,2418.12,61.3464,NULL,NULL,NULL,NULL),(6883,320,2559.4,61.9242,NULL,NULL,NULL,NULL),(6884,320,2739.88,61.3543,NULL,NULL,NULL,NULL),(6885,320,2966.58,63.0817,NULL,NULL,NULL,NULL),(6886,320,3104.45,63.6586,NULL,NULL,NULL,NULL),(6887,320,3361.32,65.9603,NULL,NULL,NULL,NULL),(6888,320,3477.82,69.4073,NULL,NULL,NULL,NULL),(6889,320,3681.02,68.8367,NULL,NULL,NULL,NULL),(6890,320,3896.09,69.4144,NULL,NULL,NULL,NULL),(6891,320,4218.46,68.271,NULL,NULL,NULL,NULL),(6892,320,4414.51,69.4222,NULL,NULL,NULL,NULL),(6893,320,4567.51,73.4434,NULL,NULL,NULL,NULL),(6894,320,4889.59,73.4477,NULL,NULL,NULL,NULL),(6895,320,4945.44,71.7259,NULL,NULL,NULL,NULL),(6896,320,5234.38,74.026,NULL,NULL,NULL,NULL),(6897,320,5540.21,75.752,NULL,NULL,NULL,NULL),(6898,320,5930.89,74.608,NULL,NULL,NULL,NULL),(6899,320,6136.44,80.9259,NULL,NULL,NULL,NULL),(6900,320,6569.15,81.5043,NULL,NULL,NULL,NULL),(6901,320,6874.45,83.8038,NULL,NULL,NULL,NULL),(6902,320,7359.21,83.2338,NULL,NULL,NULL,NULL),(6903,320,8059.14,86.1103,NULL,NULL,NULL,NULL),(6904,320,8433.68,87.2615,NULL,NULL,NULL,NULL),(6905,320,10346.6,90.145,NULL,NULL,NULL,NULL),(6906,320,10951.1,89.0002,NULL,NULL,NULL,NULL),(6907,321,1.97666,8.73761,NULL,NULL,NULL,NULL),(6908,321,5.01614,14.4186,NULL,NULL,NULL,NULL),(6909,321,8.95182,15.9861,NULL,NULL,NULL,NULL),(6910,321,12.0267,16.5142,NULL,NULL,NULL,NULL),(6911,321,16.1579,17.0423,NULL,NULL,NULL,NULL),(6912,321,18.9424,17.563,NULL,NULL,NULL,NULL),(6913,321,36.1884,20.6694,NULL,NULL,NULL,NULL),(6914,321,48.619,22.221,NULL,NULL,NULL,NULL),(6915,321,76.5762,25.8285,NULL,NULL,NULL,NULL),(6916,321,119.247,27.3884,NULL,NULL,NULL,NULL),(6917,321,181.526,28.4352,NULL,NULL,NULL,NULL),(6918,321,210.406,28.9552,NULL,NULL,NULL,NULL),(6919,321,246.666,29.4758,NULL,NULL,NULL,NULL),(6920,321,282.68,32.0421,NULL,NULL,NULL,NULL),(6921,321,306.069,32.5582,NULL,NULL,NULL,NULL),(6922,321,397.43,34.1081,NULL,NULL,NULL,NULL),(6923,321,445.228,34.1143,NULL,NULL,NULL,NULL),(6924,321,476.623,35.1417,NULL,NULL,NULL,NULL),(6925,321,540.044,35.6603,NULL,NULL,NULL,NULL),(6926,321,591.407,36.1771,NULL,NULL,NULL,NULL),(6927,321,647.655,37.2056,NULL,NULL,NULL,NULL),(6928,321,709.253,37.7225,NULL,NULL,NULL,NULL),(6929,321,750.693,39.2609,NULL,NULL,NULL,NULL),(6930,321,822.091,39.2659,NULL,NULL,NULL,NULL),(6931,321,890.113,39.7821,NULL,NULL,NULL,NULL),(6932,321,942.12,39.7852,NULL,NULL,NULL,NULL),(6933,321,1117.09,41.33,NULL,NULL,NULL,NULL),(6934,321,1450.54,46.9737,NULL,NULL,NULL,NULL),(6935,321,1643.55,49.0276,NULL,NULL,NULL,NULL),(6936,321,1841.22,47.4987,NULL,NULL,NULL,NULL),(6937,321,2016.33,47.5037,NULL,NULL,NULL,NULL),(6938,321,2208.11,48.5323,NULL,NULL,NULL,NULL),(6939,321,2310.73,46.9995,NULL,NULL,NULL,NULL),(6940,321,2473.67,45.4681,NULL,NULL,NULL,NULL),(6941,321,2559.4,49.0523,NULL,NULL,NULL,NULL),(6942,321,2708.94,47.5202,NULL,NULL,NULL,NULL),(6943,321,2933.08,48.5481,NULL,NULL,NULL,NULL),(6944,321,3139.91,48.5519,NULL,NULL,NULL,NULL),(6945,321,3248.73,49.5773,NULL,NULL,NULL,NULL),(6946,321,3517.54,50.6052,NULL,NULL,NULL,NULL),(6947,321,3681.02,52.6547,NULL,NULL,NULL,NULL),(6948,321,3896.09,52.1461,NULL,NULL,NULL,NULL),(6949,321,4170.82,51.1264,NULL,NULL,NULL,NULL),(6950,321,4464.93,53.6889,NULL,NULL,NULL,NULL),(6951,321,4779.78,56.7632,NULL,NULL,NULL,NULL),(6952,321,5001.92,54.207,NULL,NULL,NULL,NULL),(6953,321,5294.17,52.1631,NULL,NULL,NULL,NULL),(6954,321,5477.65,56.7707,NULL,NULL,NULL,NULL),(6955,321,5732.22,54.2146,NULL,NULL,NULL,NULL),(6956,321,6206.52,55.2425,NULL,NULL,NULL,NULL),(6957,321,6644.18,56.7815,NULL,NULL,NULL,NULL),(6958,321,6952.97,60.3663,NULL,NULL,NULL,NULL),(6959,321,7701.22,59.8602,NULL,NULL,NULL,NULL),(6960,321,8059.14,59.8628,NULL,NULL,NULL,NULL),(6961,321,8433.68,59.3535,NULL,NULL,NULL,NULL),(6962,321,10346.6,68.5764,NULL,NULL,NULL,NULL),(6963,321,10827.4,67.5553,NULL,NULL,NULL,NULL),(6964,321,11202.7,65.5103,NULL,NULL,NULL,NULL),(6965,322,2.90302,27.6142,NULL,NULL,NULL,NULL),(6966,322,3.97438,32.5454,NULL,NULL,NULL,NULL),(6967,322,7.04282,38.4628,NULL,NULL,NULL,NULL),(6968,322,9.01432,39.4489,NULL,NULL,NULL,NULL),(6969,322,11.0314,43.3938,NULL,NULL,NULL,NULL),(6970,322,14.9341,48.3249,NULL,NULL,NULL,NULL),(6971,322,17.8703,49.3112,NULL,NULL,NULL,NULL),(6972,322,21.1453,57.2009,NULL,NULL,NULL,NULL),(6973,322,31.3139,64.1046,NULL,NULL,NULL,NULL),(6974,322,38.3208,69.0356,NULL,NULL,NULL,NULL),(6975,322,51.2991,73.9667,NULL,NULL,NULL,NULL),(6976,322,62.778,74.953,NULL,NULL,NULL,NULL),(6977,322,78.5687,76.9253,NULL,NULL,NULL,NULL),(6978,322,94.0164,83.829,NULL,NULL,NULL,NULL),(6979,322,128.713,88.76,NULL,NULL,NULL,NULL),(6980,322,155.757,87.7737,NULL,NULL,NULL,NULL),(6981,322,184.302,89.7463,NULL,NULL,NULL,NULL),(6982,322,213.239,96.6498,NULL,NULL,NULL,NULL),(6983,322,246.72,98.6221,NULL,NULL,NULL,NULL),(6984,322,282.273,109.471,NULL,NULL,NULL,NULL),(6985,322,312.262,110.457,NULL,NULL,NULL,NULL),(6986,322,345.436,115.388,NULL,NULL,NULL,NULL),(6987,322,390.806,114.402,NULL,NULL,NULL,NULL),(6988,322,422.733,121.305,NULL,NULL,NULL,NULL),(6989,322,478.254,120.319,NULL,NULL,NULL,NULL),(6990,322,535.032,125.25,NULL,NULL,NULL,NULL),(6991,322,598.551,133.14,NULL,NULL,NULL,NULL),(6992,322,662.14,133.14,NULL,NULL,NULL,NULL),(6993,322,766.104,134.126,NULL,NULL,NULL,NULL),(6994,322,876.502,138.071,NULL,NULL,NULL,NULL),(6995,322,1037.13,137.085,NULL,NULL,NULL,NULL),(6996,322,1096.97,137.085,NULL,NULL,NULL,NULL),(6997,322,1213.51,140.044,NULL,NULL,NULL,NULL),(6998,322,1357.58,145.961,NULL,NULL,NULL,NULL),(6999,322,1468.49,152.864,NULL,NULL,NULL,NULL),(7000,322,1737.61,181.465,NULL,NULL,NULL,NULL),(7001,322,1817.35,184.424,NULL,NULL,NULL,NULL),(7002,322,2056.05,183.437,NULL,NULL,NULL,NULL),(7003,322,2460.29,177.52,NULL,NULL,NULL,NULL),(7004,322,2944.02,179.492,NULL,NULL,NULL,NULL),(7005,322,3368.26,196.258,NULL,NULL,NULL,NULL),(7006,322,3522.85,205.134,NULL,NULL,NULL,NULL),(7007,322,4215.49,203.162,NULL,NULL,NULL,NULL),(7008,322,4359.77,213.024,NULL,NULL,NULL,NULL),(7009,322,4715.95,235.708,NULL,NULL,NULL,NULL),(7010,323,4.70274,31.2094,NULL,NULL,NULL,NULL),(7011,323,4.97406,41.8489,NULL,NULL,NULL,NULL),(7012,323,6.96425,45.3954,NULL,NULL,NULL,NULL),(7013,323,9.11602,47.5233,NULL,NULL,NULL,NULL),(7014,323,13.0531,49.6512,NULL,NULL,NULL,NULL),(7015,323,28.9489,61.7094,NULL,NULL,NULL,NULL),(7016,323,35.8263,69.5117,NULL,NULL,NULL,NULL),(7017,323,61.3852,73.7675,NULL,NULL,NULL,NULL),(7018,323,92.9675,79.4419,NULL,NULL,NULL,NULL),(7019,323,101.697,82.2791,NULL,NULL,NULL,NULL),(7020,323,312.262,102.14,NULL,NULL,NULL,NULL),(7021,323,337.772,104.267,NULL,NULL,NULL,NULL),(7022,323,365.366,104.977,NULL,NULL,NULL,NULL),(7023,323,395.215,105.686,NULL,NULL,NULL,NULL),(7024,323,427.502,107.814,NULL,NULL,NULL,NULL),(7025,323,457.268,109.233,NULL,NULL,NULL,NULL),(7026,323,483.65,109.233,NULL,NULL,NULL,NULL),(7027,323,547.172,114.198,NULL,NULL,NULL,NULL),(7028,323,598.551,115.616,NULL,NULL,NULL,NULL),(7029,323,662.14,116.326,NULL,NULL,NULL,NULL),(7030,323,716.234,121.291,NULL,NULL,NULL,NULL),(7031,323,724.314,124.837,NULL,NULL,NULL,NULL),(7032,323,757.557,124.128,NULL,NULL,NULL,NULL),(7033,323,819.446,125.547,NULL,NULL,NULL,NULL),(7034,323,876.502,124.128,NULL,NULL,NULL,NULL),(7035,323,937.53,126.965,NULL,NULL,NULL,NULL),(7036,323,1048.83,130.512,NULL,NULL,NULL,NULL),(7037,323,1084.73,132.64,NULL,NULL,NULL,NULL),(7038,323,1096.97,135.477,NULL,NULL,NULL,NULL),(7039,323,1199.97,136.895,NULL,NULL,NULL,NULL),(7040,323,1298.01,139.023,NULL,NULL,NULL,NULL),(7041,323,1372.89,139.023,NULL,NULL,NULL,NULL),(7042,323,1485.05,146.826,NULL,NULL,NULL,NULL),(7043,323,1570.73,148.954,NULL,NULL,NULL,NULL),(7044,323,1624.5,139.733,NULL,NULL,NULL,NULL),(7045,323,1680.1,145.407,NULL,NULL,NULL,NULL),(7046,323,1718.22,142.57,NULL,NULL,NULL,NULL),(7047,323,1837.86,151.081,NULL,NULL,NULL,NULL),(7048,323,2056.05,153.919,NULL,NULL,NULL,NULL),(7049,323,2199.2,153.919,NULL,NULL,NULL,NULL),(7050,323,2326.09,148.244,NULL,NULL,NULL,NULL),(7051,323,2460.29,153.919,NULL,NULL,NULL,NULL),(7052,323,2573.21,158.175,NULL,NULL,NULL,NULL),(7053,323,2721.67,157.465,NULL,NULL,NULL,NULL),(7054,323,2944.02,156.756,NULL,NULL,NULL,NULL),(7055,323,3113.87,161.012,NULL,NULL,NULL,NULL),(7056,323,3368.26,163.849,NULL,NULL,NULL,NULL),(7057,323,3522.85,168.105,NULL,NULL,NULL,NULL),(7058,323,3684.53,170.233,NULL,NULL,NULL,NULL),(7059,323,3941.08,175.906,NULL,NULL,NULL,NULL),(7060,323,4030.5,170.943,NULL,NULL,NULL,NULL),(7061,323,4263.04,170.943,NULL,NULL,NULL,NULL),(7062,323,4458.7,177.325,NULL,NULL,NULL,NULL),(7063,323,4611.31,183,NULL,NULL,NULL,NULL),(7064,323,4822.95,186.547,NULL,NULL,NULL,NULL),(7065,323,5101.21,183.709,NULL,NULL,NULL,NULL),(7066,324,1.83271,17.1539,NULL,NULL,NULL,NULL),(7067,324,3.97438,22.8718,NULL,NULL,NULL,NULL),(7068,324,6.88656,27.0303,NULL,NULL,NULL,NULL),(7069,324,6.96425,32.2285,NULL,NULL,NULL,NULL),(7070,324,8.91376,28.0699,NULL,NULL,NULL,NULL),(7071,324,10.9083,31.1888,NULL,NULL,NULL,NULL),(7072,324,14.9341,33.2681,NULL,NULL,NULL,NULL),(7073,324,17.8703,37.9464,NULL,NULL,NULL,NULL),(7074,324,20.9094,40.0256,NULL,NULL,NULL,NULL),(7075,324,31.3139,47.3031,NULL,NULL,NULL,NULL),(7076,324,40.0796,49.3823,NULL,NULL,NULL,NULL),(7077,324,50.1609,51.9813,NULL,NULL,NULL,NULL),(7078,324,63.4862,59.7786,NULL,NULL,NULL,NULL),(7079,324,78.5687,56.6597,NULL,NULL,NULL,NULL),(7080,324,99.4406,59.2588,NULL,NULL,NULL,NULL),(7081,324,127.277,61.338,NULL,NULL,NULL,NULL),(7082,324,147.261,61.338,NULL,NULL,NULL,NULL),(7083,324,157.514,62.3777,NULL,NULL,NULL,NULL),(7084,324,186.381,64.4569,NULL,NULL,NULL,NULL),(7085,324,210.86,65.4965,NULL,NULL,NULL,NULL),(7086,324,241.246,66.5362,NULL,NULL,NULL,NULL),(7087,324,305.334,71.7343,NULL,NULL,NULL,NULL),(7088,324,395.215,74.3335,NULL,NULL,NULL,NULL),(7089,324,457.268,73.2937,NULL,NULL,NULL,NULL),(7090,324,500.204,74.8532,NULL,NULL,NULL,NULL),(7091,324,541.068,72.774,NULL,NULL,NULL,NULL),(7092,324,598.551,76.9325,NULL,NULL,NULL,NULL),(7093,324,801.264,76.9325,NULL,NULL,NULL,NULL),(7094,324,916.729,79.0117,NULL,NULL,NULL,NULL),(7095,324,1014.12,80.5711,NULL,NULL,NULL,NULL),(7096,324,1134.52,81.6108,NULL,NULL,NULL,NULL),(7097,324,1213.51,82.1306,NULL,NULL,NULL,NULL),(7098,324,1283.53,85.7693,NULL,NULL,NULL,NULL),(7099,324,1388.38,85.7693,NULL,NULL,NULL,NULL),(7100,324,1485.05,93.0467,NULL,NULL,NULL,NULL),(7101,324,1661.36,91.4872,NULL,NULL,NULL,NULL),(7102,324,1737.61,93.0467,NULL,NULL,NULL,NULL),(7103,324,1837.86,93.0467,NULL,NULL,NULL,NULL),(7104,324,2056.05,98.2449,NULL,NULL,NULL,NULL),(7105,324,2224.01,100.844,NULL,NULL,NULL,NULL),(7106,324,2300.14,102.923,NULL,NULL,NULL,NULL),(7107,324,2516.12,101.884,NULL,NULL,NULL,NULL),(7108,324,2691.31,102.923,NULL,NULL,NULL,NULL),(7109,324,2944.02,104.483,NULL,NULL,NULL,NULL),(7110,324,3113.87,106.042,NULL,NULL,NULL,NULL),(7111,324,3330.68,109.681,NULL,NULL,NULL,NULL),(7112,324,3522.85,111.76,NULL,NULL,NULL,NULL),(7113,324,3726.1,112.8,NULL,NULL,NULL,NULL),(7114,324,4121.96,115.399,NULL,NULL,NULL,NULL),(7115,324,4408.96,115.399,NULL,NULL,NULL,NULL),(7116,324,4769.15,118.518,NULL,NULL,NULL,NULL),(7117,324,4988.03,121.117,NULL,NULL,NULL,NULL),(7118,324,5158.76,122.156,NULL,NULL,NULL,NULL),(7119,325,1.93845,12.5207,NULL,NULL,NULL,NULL),(7120,325,4.97406,16.3732,NULL,NULL,NULL,NULL),(7121,325,6.96425,17.3365,NULL,NULL,NULL,NULL),(7122,325,13.0531,20.7074,NULL,NULL,NULL,NULL),(7123,325,13.9619,25.0415,NULL,NULL,NULL,NULL),(7124,325,16.1541,25.0415,NULL,NULL,NULL,NULL),(7125,325,18.9013,26.4862,NULL,NULL,NULL,NULL),(7126,325,21.3838,27.4493,NULL,NULL,NULL,NULL),(7127,325,29.2755,31.3019,NULL,NULL,NULL,NULL),(7128,325,36.2305,34.6728,NULL,NULL,NULL,NULL),(7129,325,47.9598,34.1912,NULL,NULL,NULL,NULL),(7130,325,62.0777,38.5253,NULL,NULL,NULL,NULL),(7131,325,75.9685,38.5253,NULL,NULL,NULL,NULL),(7132,325,91.9304,39.4885,NULL,NULL,NULL,NULL),(7133,325,127.277,45.2673,NULL,NULL,NULL,NULL),(7134,325,155.757,44.7857,NULL,NULL,NULL,NULL),(7135,325,182.246,47.1935,NULL,NULL,NULL,NULL),(7136,325,208.508,47.6751,NULL,NULL,NULL,NULL),(7137,325,252.318,47.6751,NULL,NULL,NULL,NULL),(7138,325,272.931,51.046,NULL,NULL,NULL,NULL),(7139,325,305.334,52.4907,NULL,NULL,NULL,NULL),(7140,325,369.488,56.3434,NULL,NULL,NULL,NULL),(7141,325,447.122,56.3434,NULL,NULL,NULL,NULL),(7142,325,505.847,56.8249,NULL,NULL,NULL,NULL),(7143,325,565.901,55.8618,NULL,NULL,NULL,NULL),(7144,325,591.874,59.2327,NULL,NULL,NULL,NULL),(7145,325,647.449,59.2327,NULL,NULL,NULL,NULL),(7146,325,700.343,61.159,NULL,NULL,NULL,NULL),(7147,325,732.485,61.159,NULL,NULL,NULL,NULL),(7148,325,757.557,60.6774,NULL,NULL,NULL,NULL),(7149,325,819.446,58.7512,NULL,NULL,NULL,NULL),(7150,325,876.502,59.7143,NULL,NULL,NULL,NULL),(7151,325,937.53,60.6774,NULL,NULL,NULL,NULL),(7152,325,1037.13,60.6774,NULL,NULL,NULL,NULL),(7153,325,1084.73,61.159,NULL,NULL,NULL,NULL),(7154,325,1109.35,63.0853,NULL,NULL,NULL,NULL),(7155,325,1199.97,64.0484,NULL,NULL,NULL,NULL),(7156,325,1283.53,62.1221,NULL,NULL,NULL,NULL),(7157,325,1372.89,62.1221,NULL,NULL,NULL,NULL),(7158,325,1468.49,68.8641,NULL,NULL,NULL,NULL),(7159,325,1535.88,67.4194,NULL,NULL,NULL,NULL),(7160,325,1570.73,70.7903,NULL,NULL,NULL,NULL),(7161,325,1642.82,71.2719,NULL,NULL,NULL,NULL),(7162,325,1718.22,69.3456,NULL,NULL,NULL,NULL),(7163,325,1837.86,72.7166,NULL,NULL,NULL,NULL),(7164,325,2079.24,72.7166,NULL,NULL,NULL,NULL),(7165,325,2199.2,73.1981,NULL,NULL,NULL,NULL),(7166,325,2460.29,71.2719,NULL,NULL,NULL,NULL),(7167,325,2631.6,73.1981,NULL,NULL,NULL,NULL),(7168,325,2721.67,72.235,NULL,NULL,NULL,NULL),(7169,325,3079.14,75.1244,NULL,NULL,NULL,NULL),(7170,325,3726.1,78.4954,NULL,NULL,NULL,NULL),(7171,325,4075.97,80.9032,NULL,NULL,NULL,NULL),(7172,325,4822.95,87.1635,NULL,NULL,NULL,NULL),(7173,325,5101.21,89.0899,NULL,NULL,NULL,NULL),(7174,326,1.91682,14.9496,NULL,NULL,NULL,NULL),(7175,326,3.97438,17.7035,NULL,NULL,NULL,NULL),(7176,326,8.14862,21.2442,NULL,NULL,NULL,NULL),(7177,326,9.11602,23.9981,NULL,NULL,NULL,NULL),(7178,326,11.0314,26.3586,NULL,NULL,NULL,NULL),(7179,326,14.1194,29.1124,NULL,NULL,NULL,NULL),(7180,326,16.5206,29.8993,NULL,NULL,NULL,NULL),(7181,326,17.8703,29.8993,NULL,NULL,NULL,NULL),(7182,326,21.1453,33.44,NULL,NULL,NULL,NULL),(7183,326,24.1924,32.2597,NULL,NULL,NULL,NULL),(7184,326,31.3139,33.0465,NULL,NULL,NULL,NULL),(7185,326,34.6406,35.407,NULL,NULL,NULL,NULL),(7186,326,45.3436,36.9807,NULL,NULL,NULL,NULL),(7187,326,52.4631,37.7675,NULL,NULL,NULL,NULL),(7188,326,60.0232,38.5543,NULL,NULL,NULL,NULL),(7189,326,66.4,38.9477,NULL,NULL,NULL,NULL),(7190,326,74.283,39.3411,NULL,NULL,NULL,NULL),(7191,326,81.258,41.3082,NULL,NULL,NULL,NULL),(7192,326,87.8963,42.095,NULL,NULL,NULL,NULL),(7193,326,95.077,43.6687,NULL,NULL,NULL,NULL),(7194,326,99.4406,42.095,NULL,NULL,NULL,NULL),(7195,326,125.857,46.8159,NULL,NULL,NULL,NULL),(7196,326,164.744,48.3895,NULL,NULL,NULL,NULL),(7197,326,194.935,50.75,NULL,NULL,NULL,NULL),(7198,326,225.542,51.9302,NULL,NULL,NULL,NULL),(7199,326,249.504,52.3237,NULL,NULL,NULL,NULL),(7200,326,279.124,53.8974,NULL,NULL,NULL,NULL),(7201,326,301.927,54.2907,NULL,NULL,NULL,NULL),(7202,326,330.278,54.2907,NULL,NULL,NULL,NULL),(7203,326,369.488,54.2907,NULL,NULL,NULL,NULL),(7204,326,422.733,55.8644,NULL,NULL,NULL,NULL),(7205,326,478.254,57.4381,NULL,NULL,NULL,NULL),(7206,326,541.068,57.0446,NULL,NULL,NULL,NULL),(7207,326,662.14,58.6183,NULL,NULL,NULL,NULL),(7208,326,708.244,60.1919,NULL,NULL,NULL,NULL),(7209,326,732.485,58.6183,NULL,NULL,NULL,NULL),(7210,326,749.106,59.7985,NULL,NULL,NULL,NULL),(7211,326,819.446,59.7985,NULL,NULL,NULL,NULL),(7212,326,906.503,61.3721,NULL,NULL,NULL,NULL),(7213,326,958.803,63.7326,NULL,NULL,NULL,NULL),(7214,326,1109.35,64.9128,NULL,NULL,NULL,NULL),(7215,326,1160.26,65.3063,NULL,NULL,NULL,NULL),(7216,326,1255.05,64.9128,NULL,NULL,NULL,NULL),(7217,326,1342.43,68.847,NULL,NULL,NULL,NULL),(7218,326,1468.49,66.4865,NULL,NULL,NULL,NULL),(7219,326,1535.88,68.0601,NULL,NULL,NULL,NULL),(7220,326,1606.37,66.4865,NULL,NULL,NULL,NULL),(7221,326,1680.1,64.9128,NULL,NULL,NULL,NULL),(7222,326,1900.76,65.6996,NULL,NULL,NULL,NULL),(7223,326,2199.2,63.7326,NULL,NULL,NULL,NULL),(7224,326,2274.48,62.9458,NULL,NULL,NULL,NULL),(7225,326,2432.85,62.5524,NULL,NULL,NULL,NULL),(7226,326,2573.21,62.9458,NULL,NULL,NULL,NULL),(7227,326,2661.28,64.9128,NULL,NULL,NULL,NULL),(7228,326,2944.02,57.4381,NULL,NULL,NULL,NULL),(7229,326,2977.23,60.1919,NULL,NULL,NULL,NULL),(7230,326,3293.53,63.3392,NULL,NULL,NULL,NULL),(7231,326,3483.55,60.1919,NULL,NULL,NULL,NULL),(7232,326,3684.53,62.5524,NULL,NULL,NULL,NULL),(7233,326,3897.11,62.9458,NULL,NULL,NULL,NULL),(7234,326,4075.97,61.7656,NULL,NULL,NULL,NULL),(7235,326,4359.77,66.0931,NULL,NULL,NULL,NULL),(7236,326,4611.31,66.8799,NULL,NULL,NULL,NULL),(7237,326,4769.15,69.6338,NULL,NULL,NULL,NULL),(7238,326,5044.31,68.0601,NULL,NULL,NULL,NULL),(7239,327,1,9.55566,NULL,NULL,NULL,NULL),(7240,327,2.0031,19.5663,NULL,NULL,NULL,NULL),(7241,327,3.96771,19.5663,NULL,NULL,NULL,NULL),(7242,327,6.94783,20.0214,NULL,NULL,NULL,NULL),(7243,327,8.89007,23.2066,NULL,NULL,NULL,NULL),(7244,327,10.8767,28.667,NULL,NULL,NULL,NULL),(7245,327,20.8322,33.6723,NULL,NULL,NULL,NULL),(7246,327,30.8355,36.4026,NULL,NULL,NULL,NULL),(7247,327,38.1512,37.3126,NULL,NULL,NULL,NULL),(7248,327,49.9226,38.6777,NULL,NULL,NULL,NULL),(7249,327,63.1665,42.7729,NULL,NULL,NULL,NULL),(7250,327,77.2819,42.3179,NULL,NULL,NULL,NULL),(7251,327,92.4563,43.228,NULL,NULL,NULL,NULL),(7252,327,105.762,46.4132,NULL,NULL,NULL,NULL),(7253,327,127.955,45.0482,NULL,NULL,NULL,NULL),(7254,327,153.079,48.2333,NULL,NULL,NULL,NULL),(7255,327,234.331,51.8736,NULL,NULL,NULL,NULL),(7256,327,245.072,56.424,NULL,NULL,NULL,NULL),(7257,327,268.055,75.5352,NULL,NULL,NULL,NULL),(7258,327,293.193,64.6145,NULL,NULL,NULL,NULL),(7259,327,320.688,68.7097,NULL,NULL,NULL,NULL),(7260,327,379.381,64.1595,NULL,NULL,NULL,NULL),(7261,327,405.763,68.7097,NULL,NULL,NULL,NULL),(7262,327,433.98,68.2548,NULL,NULL,NULL,NULL),(7263,327,464.159,70.985,NULL,NULL,NULL,NULL),(7264,327,525.043,71.8951,NULL,NULL,NULL,NULL),(7265,327,580.751,77.3553,NULL,NULL,NULL,NULL),(7266,327,642.371,80.0855,NULL,NULL,NULL,NULL),(7267,327,694.783,83.2707,NULL,NULL,NULL,NULL),(7268,327,751.471,83.2707,NULL,NULL,NULL,NULL),(7269,327,812.785,82.8158,NULL,NULL,NULL,NULL),(7270,327,850.042,85.0908,NULL,NULL,NULL,NULL),(7271,327,929.758,84.1808,NULL,NULL,NULL,NULL),(7272,327,1005.62,87.3661,NULL,NULL,NULL,NULL),(7273,327,1040,89.1863,NULL,NULL,NULL,NULL),(7274,327,1075.55,87.8211,NULL,NULL,NULL,NULL),(7275,327,1203.07,91.0062,NULL,NULL,NULL,NULL),(7276,327,1272.4,92.3714,NULL,NULL,NULL,NULL),(7277,327,1376.21,91.0062,NULL,NULL,NULL,NULL),(7278,327,1455.52,100.562,NULL,NULL,NULL,NULL),(7279,327,1592.01,100.107,NULL,NULL,NULL,NULL),(7280,327,1664.99,106.477,NULL,NULL,NULL,NULL),(7281,327,1800.84,107.387,NULL,NULL,NULL,NULL),(7282,327,2060.01,106.477,NULL,NULL,NULL,NULL),(7283,327,2178.71,111.028,NULL,NULL,NULL,NULL),(7284,327,2304.25,112.393,NULL,NULL,NULL,NULL),(7285,327,2548.74,107.842,NULL,NULL,NULL,NULL),(7286,327,2695.61,108.753,NULL,NULL,NULL,NULL),(7287,327,2948.4,106.932,NULL,NULL,NULL,NULL),(7288,327,3083.55,117.398,NULL,NULL,NULL,NULL),(7289,327,3297.98,121.949,NULL,NULL,NULL,NULL),(7290,327,3449.16,135.599,NULL,NULL,NULL,NULL),(7291,327,4126.4,129.229,NULL,NULL,NULL,NULL),(7292,327,4413.35,135.144,NULL,NULL,NULL,NULL),(7293,327,4564.23,140.605,NULL,NULL,NULL,NULL),(7294,328,2.0031,10.3913,NULL,NULL,NULL,NULL),(7295,328,2.99837,16.6891,NULL,NULL,NULL,NULL),(7296,328,4.01242,11.336,NULL,NULL,NULL,NULL),(7297,328,8.89007,19.5231,NULL,NULL,NULL,NULL),(7298,328,10.9992,20.4678,NULL,NULL,NULL,NULL),(7299,328,15.0527,21.7274,NULL,NULL,NULL,NULL),(7300,328,18.0084,23.9316,NULL,NULL,NULL,NULL),(7301,328,21.0669,27.0805,NULL,NULL,NULL,NULL),(7302,328,24.0988,26.7655,NULL,NULL,NULL,NULL),(7303,328,30.8355,29.9144,NULL,NULL,NULL,NULL),(7304,328,37.7261,29.5995,NULL,NULL,NULL,NULL),(7305,328,49.9226,33.3782,NULL,NULL,NULL,NULL),(7306,328,63.8782,34.3228,NULL,NULL,NULL,NULL),(7307,328,78.1527,35.8973,NULL,NULL,NULL,NULL),(7308,328,84.5293,36.5271,NULL,NULL,NULL,NULL),(7309,328,98.8858,35.5824,NULL,NULL,NULL,NULL),(7310,328,111.857,37.1569,NULL,NULL,NULL,NULL),(7311,328,127.955,37.7867,NULL,NULL,NULL,NULL),(7312,328,139.954,39.3611,NULL,NULL,NULL,NULL),(7313,328,154.804,39.6759,NULL,NULL,NULL,NULL),(7314,328,169.321,41.8802,NULL,NULL,NULL,NULL),(7315,328,183.136,42.8248,NULL,NULL,NULL,NULL),(7316,328,211.853,44.3994,NULL,NULL,NULL,NULL),(7317,328,224.06,47.5482,NULL,NULL,NULL,NULL),(7318,328,245.072,48.4929,NULL,NULL,NULL,NULL),(7319,328,274.13,49.4375,NULL,NULL,NULL,NULL),(7320,328,303.216,53.2162,NULL,NULL,NULL,NULL),(7321,328,327.956,51.9567,NULL,NULL,NULL,NULL),(7322,328,362.753,52.2715,NULL,NULL,NULL,NULL),(7323,328,383.656,52.9013,NULL,NULL,NULL,NULL),(7324,328,438.87,56.68,NULL,NULL,NULL,NULL),(7325,328,502.03,55.1056,NULL,NULL,NULL,NULL),(7326,328,555.297,56.68,NULL,NULL,NULL,NULL),(7327,328,614.216,55.7354,NULL,NULL,NULL,NULL),(7328,328,671.816,58.5693,NULL,NULL,NULL,NULL),(7329,328,726.631,60.1437,NULL,NULL,NULL,NULL),(7330,328,785.918,62.0331,NULL,NULL,NULL,NULL),(7331,328,840.571,62.6629,NULL,NULL,NULL,NULL),(7332,328,899.024,61.4033,NULL,NULL,NULL,NULL),(7333,328,1099.92,64.5522,NULL,NULL,NULL,NULL),(7334,328,1163.3,63.9224,NULL,NULL,NULL,NULL),(7335,328,1230.34,58.8842,NULL,NULL,NULL,NULL),(7336,328,1407.4,60.4587,NULL,NULL,NULL,NULL),(7337,328,1455.52,59.1991,NULL,NULL,NULL,NULL),(7338,328,1592.01,60.7735,NULL,NULL,NULL,NULL),(7339,328,2409.88,68.3308,NULL,NULL,NULL,NULL),(7340,328,2548.74,70.2202,NULL,NULL,NULL,NULL),(7341,328,2665.57,69.9053,NULL,NULL,NULL,NULL),(7342,328,2915.55,77.1478,NULL,NULL,NULL,NULL),(7343,328,3083.55,79.6668,NULL,NULL,NULL,NULL),(7344,328,3297.98,81.2413,NULL,NULL,NULL,NULL),(7345,328,3449.16,88.1688,NULL,NULL,NULL,NULL),(7346,328,3647.91,87.2242,NULL,NULL,NULL,NULL),(7347,328,3815.12,87.539,NULL,NULL,NULL,NULL),(7348,328,4034.96,83.1307,NULL,NULL,NULL,NULL),(7349,328,4364.18,85.3349,NULL,NULL,NULL,NULL),(7350,328,4564.23,87.2242,NULL,NULL,NULL,NULL),(7351,328,4667.67,89.1136,NULL,NULL,NULL,NULL),(7352,328,4881.63,92.2624,NULL,NULL,NULL,NULL),(7353,328,4992.26,90.0582,NULL,NULL,NULL,NULL),(7354,329,2.99837,12.0703,NULL,NULL,NULL,NULL),(7355,329,3.96771,16.7644,NULL,NULL,NULL,NULL),(7356,329,7.02612,17.7702,NULL,NULL,NULL,NULL),(7357,329,8.99024,18.776,NULL,NULL,NULL,NULL),(7358,329,9.94413,21.7937,NULL,NULL,NULL,NULL),(7359,329,21.0669,23.1348,NULL,NULL,NULL,NULL),(7360,329,30.8355,25.1464,NULL,NULL,NULL,NULL),(7361,329,37.7261,26.1524,NULL,NULL,NULL,NULL),(7362,329,49.9226,27.8287,NULL,NULL,NULL,NULL),(7363,329,63.1665,28.4993,NULL,NULL,NULL,NULL),(7364,329,77.2819,29.8405,NULL,NULL,NULL,NULL),(7365,329,92.4563,29.8405,NULL,NULL,NULL,NULL),(7366,329,98.8858,30.1757,NULL,NULL,NULL,NULL),(7367,329,126.529,29.5053,NULL,NULL,NULL,NULL),(7368,329,154.804,35.5404,NULL,NULL,NULL,NULL),(7369,329,185.2,35.5404,NULL,NULL,NULL,NULL),(7370,329,219.095,36.8815,NULL,NULL,NULL,NULL),(7371,329,229.138,39.5638,NULL,NULL,NULL,NULL),(7372,329,253.45,40.2344,NULL,NULL,NULL,NULL),(7373,329,283.501,40.905,NULL,NULL,NULL,NULL),(7374,329,310.087,43.252,NULL,NULL,NULL,NULL),(7375,329,331.651,45.5989,NULL,NULL,NULL,NULL),(7376,329,362.753,43.9225,NULL,NULL,NULL,NULL),(7377,329,392.35,44.2578,NULL,NULL,NULL,NULL),(7378,329,424.363,43.9225,NULL,NULL,NULL,NULL),(7379,329,448.816,44.9283,NULL,NULL,NULL,NULL),(7380,329,507.687,42.9166,NULL,NULL,NULL,NULL),(7381,329,561.554,45.2637,NULL,NULL,NULL,NULL),(7382,329,621.137,45.2637,NULL,NULL,NULL,NULL),(7383,329,679.386,47.2754,NULL,NULL,NULL,NULL),(7384,329,726.631,46.6049,NULL,NULL,NULL,NULL),(7385,329,794.773,48.6165,NULL,NULL,NULL,NULL),(7386,329,850.042,50.293,NULL,NULL,NULL,NULL),(7387,329,909.154,49.9576,NULL,NULL,NULL,NULL),(7388,329,994.413,50.293,NULL,NULL,NULL,NULL),(7389,329,1016.95,45.2637,NULL,NULL,NULL,NULL),(7390,329,1087.67,51.9694,NULL,NULL,NULL,NULL),(7391,329,1176.41,50.9636,NULL,NULL,NULL,NULL),(7392,329,1244.2,51.6341,NULL,NULL,NULL,NULL),(7393,329,1345.72,56.9986,NULL,NULL,NULL,NULL),(7394,329,1423.26,58.6752,NULL,NULL,NULL,NULL),(7395,329,1455.52,55.3223,NULL,NULL,NULL,NULL),(7396,329,1609.95,52.9753,NULL,NULL,NULL,NULL),(7397,329,1646.44,62.6985,NULL,NULL,NULL,NULL),(7398,329,1683.75,66.722,NULL,NULL,NULL,NULL),(7399,329,1721.91,68.7337,NULL,NULL,NULL,NULL),(7400,329,1800.84,70.7455,NULL,NULL,NULL,NULL),(7401,329,2106.69,69.7395,NULL,NULL,NULL,NULL),(7402,329,2178.71,67.0572,NULL,NULL,NULL,NULL),(7403,329,2304.25,67.0572,NULL,NULL,NULL,NULL),(7404,329,2383.03,61.6927,NULL,NULL,NULL,NULL),(7405,329,2520.34,64.375,NULL,NULL,NULL,NULL),(7406,329,2695.61,61.6927,NULL,NULL,NULL,NULL),(7407,329,4315.55,73.763,NULL,NULL,NULL,NULL),(7408,329,4564.23,74.4336,NULL,NULL,NULL,NULL),(7409,329,4667.67,78.4569,NULL,NULL,NULL,NULL),(7410,329,4992.26,80.804,NULL,NULL,NULL,NULL),(7411,330,2.0031,4.22889,NULL,NULL,NULL,NULL),(7412,330,4.01242,8.81018,NULL,NULL,NULL,NULL),(7413,330,7.02612,10.9246,NULL,NULL,NULL,NULL),(7414,330,8.89007,12.6867,NULL,NULL,NULL,NULL),(7415,330,10.9992,12.3343,NULL,NULL,NULL,NULL),(7416,330,13.9172,12.6867,NULL,NULL,NULL,NULL),(7417,330,18.0084,14.0963,NULL,NULL,NULL,NULL),(7418,330,21.0669,14.0963,NULL,NULL,NULL,NULL),(7419,330,29.1555,16.2108,NULL,NULL,NULL,NULL),(7420,330,38.1512,18.6776,NULL,NULL,NULL,NULL),(7421,330,49.9226,20.0872,NULL,NULL,NULL,NULL),(7422,330,63.8782,20.4396,NULL,NULL,NULL,NULL),(7423,330,78.1527,22.2017,NULL,NULL,NULL,NULL),(7424,330,92.4563,24.3162,NULL,NULL,NULL,NULL),(7425,330,100,25.021,NULL,NULL,NULL,NULL),(7426,330,127.955,26.4305,NULL,NULL,NULL,NULL),(7427,330,154.804,27.4878,NULL,NULL,NULL,NULL),(7428,330,247.834,32.7739,NULL,NULL,NULL,NULL),(7429,330,274.13,33.4787,NULL,NULL,NULL,NULL),(7430,330,303.216,34.1835,NULL,NULL,NULL,NULL),(7431,330,327.956,32.7739,NULL,NULL,NULL,NULL),(7432,330,362.753,34.1835,NULL,NULL,NULL,NULL),(7433,330,383.656,33.4787,NULL,NULL,NULL,NULL),(7434,330,410.335,33.8311,NULL,NULL,NULL,NULL),(7435,330,443.815,33.1262,NULL,NULL,NULL,NULL),(7436,330,507.687,33.8311,NULL,NULL,NULL,NULL),(7437,330,561.554,43.6986,NULL,NULL,NULL,NULL),(7438,330,614.216,36.298,NULL,NULL,NULL,NULL),(7439,330,734.818,39.1172,NULL,NULL,NULL,NULL),(7440,330,785.918,38.4123,NULL,NULL,NULL,NULL),(7441,330,840.571,38.4123,NULL,NULL,NULL,NULL),(7442,330,899.024,37.3552,NULL,NULL,NULL,NULL),(7443,330,994.413,39.1172,NULL,NULL,NULL,NULL),(7444,330,1051.71,44.4033,NULL,NULL,NULL,NULL),(7445,330,1099.92,44.4033,NULL,NULL,NULL,NULL),(7446,330,1176.41,43.3461,NULL,NULL,NULL,NULL),(7447,330,1244.2,46.1654,NULL,NULL,NULL,NULL),(7448,330,1345.72,46.8702,NULL,NULL,NULL,NULL),(7449,330,1455.52,48.6322,NULL,NULL,NULL,NULL),(7450,330,1609.95,47.2226,NULL,NULL,NULL,NULL),(7451,330,1683.75,46.5177,NULL,NULL,NULL,NULL),(7452,330,1702.72,52.5087,NULL,NULL,NULL,NULL),(7453,330,1821.13,52.5087,NULL,NULL,NULL,NULL),(7454,330,2060.01,55.6804,NULL,NULL,NULL,NULL),(7455,330,2154.43,52.5087,NULL,NULL,NULL,NULL),(7456,330,2356.47,52.1563,NULL,NULL,NULL,NULL),(7457,330,2492.26,53.9183,NULL,NULL,NULL,NULL),(7458,330,2548.74,51.8038,NULL,NULL,NULL,NULL),(7459,330,2665.57,48.9847,NULL,NULL,NULL,NULL),(7460,330,2948.4,58.1472,NULL,NULL,NULL,NULL),(7461,330,3049.19,61.3189,NULL,NULL,NULL,NULL),(7462,330,3297.98,62.0237,NULL,NULL,NULL,NULL),(7463,330,3449.16,65.9001,NULL,NULL,NULL,NULL),(7464,330,3607.26,66.2526,NULL,NULL,NULL,NULL),(7465,330,3858.11,67.6623,NULL,NULL,NULL,NULL),(7466,330,4126.4,62.0237,NULL,NULL,NULL,NULL),(7467,330,4364.18,63.0809,NULL,NULL,NULL,NULL),(7468,330,4564.23,64.4905,NULL,NULL,NULL,NULL),(7469,330,4720.26,70.1291,NULL,NULL,NULL,NULL),(7470,330,4936.63,69.4243,NULL,NULL,NULL,NULL),(7471,330,4992.26,66.2526,NULL,NULL,NULL,NULL),(7472,331,1.8063,6.4054,NULL,NULL,NULL,NULL),(7473,331,4.00377,12.0991,NULL,NULL,NULL,NULL),(7474,331,6.91045,21.3513,NULL,NULL,NULL,NULL),(7475,331,9.07872,19.9278,NULL,NULL,NULL,NULL),(7476,331,9.94331,24.9098,NULL,NULL,NULL,NULL),(7477,331,14.8037,31.3152,NULL,NULL,NULL,NULL),(7478,331,17.7575,28.4684,NULL,NULL,NULL,NULL),(7479,331,20.8218,38.4324,NULL,NULL,NULL,NULL),(7480,331,30.9997,40.5674,NULL,NULL,NULL,NULL),(7481,331,38.0406,41.2792,NULL,NULL,NULL,NULL),(7482,331,49.9765,43.4144,NULL,NULL,NULL,NULL),(7483,331,64.1811,46.2612,NULL,NULL,NULL,NULL),(7484,331,77.8678,48.3962,NULL,NULL,NULL,NULL),(7485,331,93.4051,48.3962,NULL,NULL,NULL,NULL),(7486,331,100,54.09,NULL,NULL,NULL,NULL),(7487,331,184.785,55.5134,NULL,NULL,NULL,NULL),(7488,331,219.15,83.2701,NULL,NULL,NULL,NULL),(7489,331,242.765,66.189,NULL,NULL,NULL,NULL),(7490,331,275.11,71.171,NULL,NULL,NULL,NULL),(7491,331,304.755,71.171,NULL,NULL,NULL,NULL),(7492,331,326.272,72.5945,NULL,NULL,NULL,NULL),(7493,331,365.564,73.3061,NULL,NULL,NULL,NULL),(7494,331,391.375,71.8828,NULL,NULL,NULL,NULL),(7495,331,414.27,73.3061,NULL,NULL,NULL,NULL),(7496,331,480.266,75.4413,NULL,NULL,NULL,NULL),(7497,331,514.175,78.2881,NULL,NULL,NULL,NULL),(7498,331,582.683,78.2881,NULL,NULL,NULL,NULL),(7499,331,683.232,79.7116,NULL,NULL,NULL,NULL),(7500,331,756.854,79.7116,NULL,NULL,NULL,NULL),(7501,331,877.425,81.1348,NULL,NULL,NULL,NULL),(7502,331,971.973,83.2701,NULL,NULL,NULL,NULL),(7503,331,1101.48,87.5403,NULL,NULL,NULL,NULL),(7504,331,1139.7,84.6936,NULL,NULL,NULL,NULL),(7505,331,1206.37,87.5403,NULL,NULL,NULL,NULL),(7506,331,1336.37,85.4051,NULL,NULL,NULL,NULL),(7507,331,1382.74,99.6394,NULL,NULL,NULL,NULL),(7508,331,1463.63,93.9456,NULL,NULL,NULL,NULL),(7509,331,1566.97,96.7926,NULL,NULL,NULL,NULL),(7510,331,1639.89,93.2341,NULL,NULL,NULL,NULL),(7511,331,1837.37,93.9456,NULL,NULL,NULL,NULL),(7512,331,2058.64,120.279,NULL,NULL,NULL,NULL),(7513,331,2154.43,125.973,NULL,NULL,NULL,NULL),(7514,331,2306.55,128.82,NULL,NULL,NULL,NULL),(7515,331,2497.65,129.531,NULL,NULL,NULL,NULL),(7516,331,2584.32,123.126,NULL,NULL,NULL,NULL),(7517,331,2735.5,125.261,NULL,NULL,NULL,NULL),(7518,331,2928.64,135.225,NULL,NULL,NULL,NULL),(7519,331,3099.97,142.342,NULL,NULL,NULL,NULL),(7520,331,3281.33,148.747,NULL,NULL,NULL,NULL),(7521,331,3513.01,142.342,NULL,NULL,NULL,NULL),(7522,331,3634.91,147.324,NULL,NULL,NULL,NULL),(7523,331,3936.06,148.747,NULL,NULL,NULL,NULL),(7524,331,4072.64,143.765,NULL,NULL,NULL,NULL),(7525,331,4511.5,167.964,NULL,NULL,NULL,NULL),(7526,331,4721.44,173.657,NULL,NULL,NULL,NULL),(7527,331,4775.43,158,NULL,NULL,NULL,NULL),(7528,331,4941.14,165.117,NULL,NULL,NULL,NULL),(7529,331,5112.6,161.558,NULL,NULL,NULL,NULL),(7530,331,5536.18,158.711,NULL,NULL,NULL,NULL),(7531,331,5994.84,169.387,NULL,NULL,NULL,NULL),(7532,331,6565.74,170.099,NULL,NULL,NULL,NULL),(7533,331,6949.85,179.351,NULL,NULL,NULL,NULL),(7534,331,7191.01,183.621,NULL,NULL,NULL,NULL),(7535,331,7525.64,181.486,NULL,NULL,NULL,NULL),(7536,331,7875.83,185.756,NULL,NULL,NULL,NULL),(7537,331,8336.57,187.891,NULL,NULL,NULL,NULL),(7538,331,10230,208.53,NULL,NULL,NULL,NULL),(7539,331,10952.3,202.125,NULL,NULL,NULL,NULL),(7540,332,1.93384,18.378,NULL,NULL,NULL,NULL),(7541,332,4.00377,22.7308,NULL,NULL,NULL,NULL),(7542,332,8.97607,24.1816,NULL,NULL,NULL,NULL),(7543,332,14.973,30.4689,NULL,NULL,NULL,NULL),(7544,332,17.9606,32.887,NULL,NULL,NULL,NULL),(7545,332,20.8218,29.9852,NULL,NULL,NULL,NULL),(7546,332,49.9765,36.7561,NULL,NULL,NULL,NULL),(7547,332,64.1811,36.7561,NULL,NULL,NULL,NULL),(7548,332,79.6589,40.1416,NULL,NULL,NULL,NULL),(7549,332,100,42.0761,NULL,NULL,NULL,NULL),(7550,332,128.423,44.0106,NULL,NULL,NULL,NULL),(7551,332,207.038,50.2978,NULL,NULL,NULL,NULL),(7552,332,262.877,52.2324,NULL,NULL,NULL,NULL),(7553,332,284.656,51.2651,NULL,NULL,NULL,NULL),(7554,332,395.85,53.6833,NULL,NULL,NULL,NULL),(7555,332,464.159,54.6506,NULL,NULL,NULL,NULL),(7556,332,569.581,55.1341,NULL,NULL,NULL,NULL),(7557,332,739.837,49.8142,NULL,NULL,NULL,NULL),(7558,332,960.984,54.1669,NULL,NULL,NULL,NULL),(7559,332,1367.11,64.3232,NULL,NULL,NULL,NULL),(7560,332,1566.97,58.5196,NULL,NULL,NULL,NULL),(7561,332,1639.89,65.7741,NULL,NULL,NULL,NULL),(7562,332,2058.64,55.6178,NULL,NULL,NULL,NULL),(7563,332,2229.2,48.847,NULL,NULL,NULL,NULL),(7564,332,2332.93,49.8142,NULL,NULL,NULL,NULL),(7565,332,2469.41,50.7815,NULL,NULL,NULL,NULL),(7566,332,2555.1,47.8797,NULL,NULL,NULL,NULL),(7567,332,2673.99,49.3306,NULL,NULL,NULL,NULL),(7568,332,2895.53,54.1669,NULL,NULL,NULL,NULL),(7569,332,3135.42,57.0687,NULL,NULL,NULL,NULL),(7570,332,3513.01,50.2978,NULL,NULL,NULL,NULL),(7571,332,3936.06,54.6506,NULL,NULL,NULL,NULL),(7572,332,4119.22,53.1996,NULL,NULL,NULL,NULL),(7573,332,4460.49,59.0032,NULL,NULL,NULL,NULL),(7574,332,4668.05,55.6178,NULL,NULL,NULL,NULL),(7575,332,5054.8,59.0032,NULL,NULL,NULL,NULL),(7576,332,5536.18,57.0687,NULL,NULL,NULL,NULL),(7577,332,5994.84,59.4869,NULL,NULL,NULL,NULL),(7578,332,6565.74,56.5851,NULL,NULL,NULL,NULL),(7579,332,7273.25,53.1996,NULL,NULL,NULL,NULL),(7580,332,11077.6,67.7086,NULL,NULL,NULL,NULL),(7581,333,2.00094,10.3693,NULL,NULL,NULL,NULL),(7582,333,3.9585,14.9318,NULL,NULL,NULL,NULL),(7583,333,6.98947,17.8352,NULL,NULL,NULL,NULL),(7584,333,8.87459,18.6647,NULL,NULL,NULL,NULL),(7585,333,10.8902,22.3977,NULL,NULL,NULL,NULL),(7586,333,14.973,24.4715,NULL,NULL,NULL,NULL),(7587,333,17.9606,25.3011,NULL,NULL,NULL,NULL),(7588,333,20.8218,25.7158,NULL,NULL,NULL,NULL),(7589,333,30.9997,28.6192,NULL,NULL,NULL,NULL),(7590,333,37.6105,29.8636,NULL,NULL,NULL,NULL),(7591,333,49.9765,31.5226,NULL,NULL,NULL,NULL),(7592,333,65.6574,32.3522,NULL,NULL,NULL,NULL),(7593,333,76.9874,34.8408,NULL,NULL,NULL,NULL),(7594,333,92.349,34.8408,NULL,NULL,NULL,NULL),(7595,333,100,30.693,NULL,NULL,NULL,NULL),(7596,333,191.197,43.1362,NULL,NULL,NULL,NULL),(7597,333,214.222,43.551,NULL,NULL,NULL,NULL),(7598,333,245.541,44.7954,NULL,NULL,NULL,NULL),(7599,333,275.11,44.3806,NULL,NULL,NULL,NULL),(7600,333,301.309,46.0396,NULL,NULL,NULL,NULL),(7601,333,326.272,46.8692,NULL,NULL,NULL,NULL),(7602,333,365.564,47.2839,NULL,NULL,NULL,NULL),(7603,333,386.95,47.2839,NULL,NULL,NULL,NULL),(7604,333,448.592,48.1135,NULL,NULL,NULL,NULL),(7605,333,496.931,48.1135,NULL,NULL,NULL,NULL),(7606,333,550.479,48.5283,NULL,NULL,NULL,NULL),(7607,333,675.507,49.3578,NULL,NULL,NULL,NULL),(7608,333,723.201,49.7725,NULL,NULL,NULL,NULL),(7609,333,783.118,50.6021,NULL,NULL,NULL,NULL),(7610,333,838.411,51.8465,NULL,NULL,NULL,NULL),(7611,333,939.376,54.7498,NULL,NULL,NULL,NULL),(7612,333,994.331,58.4828,NULL,NULL,NULL,NULL),(7613,333,1114.07,55.5794,NULL,NULL,NULL,NULL),(7614,333,1179.25,60.1418,NULL,NULL,NULL,NULL),(7615,333,1291.55,60.9714,NULL,NULL,NULL,NULL),(7616,333,1351.65,69.6816,NULL,NULL,NULL,NULL),(7617,333,1447.08,72.9998,NULL,NULL,NULL,NULL),(7618,333,1531.74,75.4884,NULL,NULL,NULL,NULL),(7619,333,1603.02,75.9032,NULL,NULL,NULL,NULL),(7620,333,1658.64,67.6077,NULL,NULL,NULL,NULL),(7621,333,1755.68,65.1191,NULL,NULL,NULL,NULL),(7622,333,1816.6,68.0225,NULL,NULL,NULL,NULL),(7623,333,2058.64,60.5566,NULL,NULL,NULL,NULL),(7624,333,2179.07,50.1873,NULL,NULL,NULL,NULL),(7625,333,2280.47,49.7725,NULL,NULL,NULL,NULL),(7626,333,2441.49,50.6021,NULL,NULL,NULL,NULL),(7627,333,2673.99,49.7725,NULL,NULL,NULL,NULL),(7628,333,2962.14,52.6759,NULL,NULL,NULL,NULL),(7629,333,3473.29,48.5283,NULL,NULL,NULL,NULL),(7630,333,3676.48,50.1873,NULL,NULL,NULL,NULL),(7631,333,4026.6,48.943,NULL,NULL,NULL,NULL),(7632,333,4410.06,53.0907,NULL,NULL,NULL,NULL),(7633,333,5054.8,55.9941,NULL,NULL,NULL,NULL),(7634,333,5473.58,52.2611,NULL,NULL,NULL,NULL),(7635,333,6063.4,55.1646,NULL,NULL,NULL,NULL),(7636,333,6491.51,52.6759,NULL,NULL,NULL,NULL),(7637,333,6871.27,55.5794,NULL,NULL,NULL,NULL),(7638,333,7525.64,57.2384,NULL,NULL,NULL,NULL),(7639,333,7875.83,59.3124,NULL,NULL,NULL,NULL),(7640,333,8336.57,59.3124,NULL,NULL,NULL,NULL),(7641,333,10230,65.9487,NULL,NULL,NULL,NULL),(7642,333,10952.3,61.8009,NULL,NULL,NULL,NULL),(7643,334,1.13324,4.81772,NULL,NULL,NULL,NULL),(7644,334,1.84785,7.62807,NULL,NULL,NULL,NULL),(7645,334,3.9585,15.6576,NULL,NULL,NULL,NULL),(7646,334,4.00377,8.43103,NULL,NULL,NULL,NULL),(7647,334,6.91045,10.4384,NULL,NULL,NULL,NULL),(7648,334,8.97607,12.4458,NULL,NULL,NULL,NULL),(7649,334,11.0148,12.8473,NULL,NULL,NULL,NULL),(7650,334,14.973,15.2561,NULL,NULL,NULL,NULL),(7651,334,21.7907,16.4606,NULL,NULL,NULL,NULL),(7652,334,30.6492,18.4679,NULL,NULL,NULL,NULL),(7653,334,38.0406,21.6798,NULL,NULL,NULL,NULL),(7654,334,51.7107,22.0813,NULL,NULL,NULL,NULL),(7655,334,63.4555,22.4827,NULL,NULL,NULL,NULL),(7656,334,77.8678,23.2857,NULL,NULL,NULL,NULL),(7657,334,92.349,25.2931,NULL,NULL,NULL,NULL),(7658,334,98.8694,25.2931,NULL,NULL,NULL,NULL),(7659,334,143.888,28.1034,NULL,NULL,NULL,NULL),(7660,334,174.572,30.1108,NULL,NULL,NULL,NULL),(7661,334,204.697,31.7167,NULL,NULL,NULL,NULL),(7662,334,231.97,31.3153,NULL,NULL,NULL,NULL),(7663,334,262.877,32.1182,NULL,NULL,NULL,NULL),(7664,334,287.912,32.5197,NULL,NULL,NULL,NULL),(7665,334,315.33,33.3227,NULL,NULL,NULL,NULL),(7666,334,341.455,32.9212,NULL,NULL,NULL,NULL),(7667,334,373.972,31.7167,NULL,NULL,NULL,NULL),(7668,334,433.548,32.1182,NULL,NULL,NULL,NULL),(7669,334,464.159,33.7241,NULL,NULL,NULL,NULL),(7670,334,550.479,33.7241,NULL,NULL,NULL,NULL),(7671,334,667.869,34.1255,NULL,NULL,NULL,NULL),(7672,334,715.025,35.33,NULL,NULL,NULL,NULL),(7673,334,765.51,36.133,NULL,NULL,NULL,NULL),(7674,334,828.931,34.1255,NULL,NULL,NULL,NULL),(7675,334,918.254,32.9212,NULL,NULL,NULL,NULL),(7676,334,983.088,37.7389,NULL,NULL,NULL,NULL),(7677,334,1165.91,38.9433,NULL,NULL,NULL,NULL),(7678,334,1234.12,36.9359,NULL,NULL,NULL,NULL),(7679,334,1276.95,38.1404,NULL,NULL,NULL,NULL),(7680,334,1367.11,36.9359,NULL,NULL,NULL,NULL),(7681,334,1463.63,41.3521,NULL,NULL,NULL,NULL),(7682,334,1531.74,39.3448,NULL,NULL,NULL,NULL),(7683,334,1566.97,37.3374,NULL,NULL,NULL,NULL),(7684,334,1621.35,40.5493,NULL,NULL,NULL,NULL),(7685,334,1735.83,39.3448,NULL,NULL,NULL,NULL),(7686,334,1837.37,38.9433,NULL,NULL,NULL,NULL),(7687,334,2012.35,38.9433,NULL,NULL,NULL,NULL),(7688,334,2526.21,50.1847,NULL,NULL,NULL,NULL),(7689,334,3281.33,53.3965,NULL,NULL,NULL,NULL),(7690,334,3676.48,52.1921,NULL,NULL,NULL,NULL),(7691,334,4026.6,51.3891,NULL,NULL,NULL,NULL),(7692,334,4310.9,55.0025,NULL,NULL,NULL,NULL),(7693,334,4563.09,57.0098,NULL,NULL,NULL,NULL),(7694,334,4997.65,57.0098,NULL,NULL,NULL,NULL),(7695,334,5994.84,56.2068,NULL,NULL,NULL,NULL),(7696,334,7109.71,57.0098,NULL,NULL,NULL,NULL),(7697,334,8336.57,55.8053,NULL,NULL,NULL,NULL),(7698,334,11077.6,59.4187,NULL,NULL,NULL,NULL),(7699,335,0.22,67.3,NULL,NULL,NULL,NULL),(7700,335,0.42,69.4,NULL,NULL,NULL,NULL),(7701,335,0.52,69.9,NULL,NULL,NULL,NULL),(7702,335,1.12,73.1,NULL,NULL,NULL,NULL),(7703,335,2.42,76.4,NULL,NULL,NULL,NULL),(7704,335,3.12,78,NULL,NULL,NULL,NULL),(7705,335,4.32,79.7,NULL,NULL,NULL,NULL),(7706,335,5.12,81.4,NULL,NULL,NULL,NULL),(7707,335,6.42,84.7,NULL,NULL,NULL,NULL),(7708,335,11.82,89.7,NULL,NULL,NULL,NULL),(7709,335,18.92,93.3,NULL,NULL,NULL,NULL),(7710,335,27.22,94.3,NULL,NULL,NULL,NULL),(7711,335,125.12,111.2,NULL,NULL,NULL,NULL),(7712,336,0.32,107.7,NULL,NULL,NULL,NULL),(7713,336,0.52,106.2,NULL,NULL,NULL,NULL),(7714,336,1.12,160.4,NULL,NULL,NULL,NULL),(7715,336,2.22,174.7,NULL,NULL,NULL,NULL),(7716,336,2.72,180.5,NULL,NULL,NULL,NULL),(7717,336,4.32,185.9,NULL,NULL,NULL,NULL),(7718,336,8.42,192.5,NULL,NULL,NULL,NULL),(7719,336,14.32,195.8,NULL,NULL,NULL,NULL),(7720,336,21.82,206.3,NULL,NULL,NULL,NULL),(7721,336,29.32,209.2,NULL,NULL,NULL,NULL),(7722,336,35.52,199.5,NULL,NULL,NULL,NULL),(7723,336,41.82,203.5,NULL,NULL,NULL,NULL),(7724,336,58.42,206.7,NULL,NULL,NULL,NULL),(7725,336,70.92,210.3,NULL,NULL,NULL,NULL),(7726,336,75.12,211.8,NULL,NULL,NULL,NULL),(7727,336,91.82,218.8,NULL,NULL,NULL,NULL),(7728,336,112.62,228.2,NULL,NULL,NULL,NULL),(7729,336,145.92,231.1,NULL,NULL,NULL,NULL),(7730,336,166.82,231.1,NULL,NULL,NULL,NULL),(7731,337,0.2,64.8,NULL,NULL,NULL,NULL),(7732,337,0.4,81.2,NULL,NULL,NULL,NULL),(7733,337,1,115.1,NULL,NULL,NULL,NULL),(7734,337,2.1,144.8,NULL,NULL,NULL,NULL),(7735,337,3,159.8,NULL,NULL,NULL,NULL),(7736,337,4.2,166.6,NULL,NULL,NULL,NULL),(7737,337,8.3,198.4,NULL,NULL,NULL,NULL),(7738,337,14.2,222.5,NULL,NULL,NULL,NULL),(7739,337,22.5,244.3,NULL,NULL,NULL,NULL),(7740,337,30,233.4,NULL,1,NULL,NULL),(7741,337,37.5,218.7,NULL,1,NULL,NULL),(7742,337,41.7,215.9,NULL,1,NULL,NULL),(7743,337,50,218.7,NULL,1,NULL,NULL),(7744,337,58.3,217.2,NULL,1,NULL,NULL),(7745,337,66.7,215.6,NULL,1,NULL,NULL),(7746,337,79.2,214.1,NULL,1,NULL,NULL),(7747,337,83.3,216.8,NULL,1,NULL,NULL),(7748,337,91.7,210.7,NULL,1,NULL,NULL),(7749,337,104.2,214.1,NULL,1,NULL,NULL),(7750,337,125,213.4,NULL,1,NULL,NULL),(7751,337,133.3,214.7,NULL,1,NULL,NULL),(7752,337,145.8,215.9,NULL,1,NULL,NULL),(7753,337,166.7,215.1,NULL,1,NULL,NULL),(7754,338,0.12,66.8,NULL,NULL,NULL,NULL),(7755,338,0.32,86.6,NULL,NULL,NULL,NULL),(7756,338,0.92,137.3,NULL,NULL,NULL,NULL),(7757,338,2.02,172.6,NULL,NULL,NULL,NULL),(7758,338,2.92,197.3,NULL,NULL,NULL,NULL),(7759,338,4.12,207.3,NULL,NULL,NULL,NULL),(7760,338,6.82,225.8,NULL,NULL,NULL,NULL),(7761,338,14.52,250.7,NULL,NULL,NULL,NULL),(7762,338,20.72,256.8,NULL,NULL,NULL,NULL),(7763,338,29.12,231.4,NULL,1,NULL,NULL),(7764,338,37.42,214.1,NULL,1,NULL,NULL),(7765,338,41.62,208.8,NULL,1,NULL,NULL),(7766,338,49.92,208.9,NULL,1,NULL,NULL),(7767,338,62.42,210.7,NULL,1,NULL,NULL),(7768,338,70.72,218.2,NULL,1,NULL,NULL),(7769,338,79.12,224.1,NULL,1,NULL,NULL),(7770,338,83.22,222.6,NULL,1,NULL,NULL),(7771,339,0.01,82.7,NULL,NULL,NULL,NULL),(7772,339,0.11,120.6,NULL,NULL,NULL,NULL),(7773,339,0.31,143,NULL,NULL,NULL,NULL),(7774,339,0.91,170.4,NULL,NULL,NULL,NULL),(7775,339,1.91,204,NULL,NULL,NULL,NULL),(7776,339,2.91,202.5,NULL,NULL,NULL,NULL),(7777,339,4.11,209.7,NULL,NULL,NULL,NULL),(7778,339,4.91,217.9,NULL,NULL,NULL,NULL),(7779,339,6.61,232.6,NULL,NULL,NULL,NULL),(7780,339,12.41,265.2,NULL,NULL,NULL,NULL),(7781,339,20.71,284.3,NULL,NULL,NULL,NULL),(7782,339,27.01,287.7,NULL,NULL,NULL,NULL),(7783,339,33.21,292.2,NULL,NULL,NULL,NULL),(7784,339,39.51,301,NULL,NULL,NULL,NULL),(7785,339,62.41,324.4,NULL,NULL,NULL,NULL),(7786,339,83.21,355.4,NULL,NULL,NULL,NULL),(7787,339,87.41,365.2,NULL,NULL,NULL,NULL),(7788,339,91.61,372.3,NULL,NULL,NULL,NULL),(7789,339,99.91,378,NULL,NULL,NULL,NULL),(7790,339,108.21,383.6,NULL,NULL,NULL,NULL),(7791,339,129.11,391.3,NULL,NULL,NULL,NULL),(7792,339,141.61,391.9,NULL,NULL,NULL,NULL),(7793,340,0.015,34.1,NULL,NULL,NULL,NULL),(7794,340,0.2,44.4,NULL,NULL,NULL,NULL),(7795,340,0.3,46.2,NULL,NULL,NULL,NULL),(7796,340,0.4,47.7,NULL,NULL,NULL,NULL),(7797,340,1,48.1,NULL,NULL,NULL,NULL),(7798,340,1.3,48.6,NULL,NULL,NULL,NULL),(7799,340,2.1,50.7,NULL,NULL,NULL,NULL),(7800,340,3,53.9,NULL,NULL,NULL,NULL),(7801,340,6.3,63.7,NULL,NULL,NULL,NULL),(7802,340,10.4,61.5,NULL,NULL,NULL,NULL),(7803,340,14.6,62.2,NULL,NULL,NULL,NULL),(7804,340,20.8,63.7,NULL,NULL,NULL,NULL),(7805,341,0,31.1,NULL,NULL,NULL,NULL),(7806,341,0.08,59.5,NULL,NULL,NULL,NULL),(7807,341,0.18,86.3,NULL,NULL,NULL,NULL),(7808,341,0.28,101.1,NULL,NULL,NULL,NULL),(7809,341,0.88,131.4,NULL,NULL,NULL,NULL),(7810,341,1.18,137.4,NULL,NULL,NULL,NULL),(7811,341,1.98,144.4,NULL,NULL,NULL,NULL),(7812,341,2.88,152.7,NULL,NULL,NULL,NULL),(7813,341,4.08,164.9,NULL,NULL,NULL,NULL),(7814,341,6.18,178.6,NULL,NULL,NULL,NULL),(7815,341,10.28,204.6,NULL,NULL,NULL,NULL),(7816,341,13.18,228,NULL,NULL,NULL,NULL),(7817,341,20.68,235.7,NULL,NULL,NULL,NULL),(7818,341,29.08,233.3,NULL,NULL,NULL,NULL),(7819,341,37.38,252.6,NULL,NULL,NULL,NULL),(7820,341,49.88,257.9,NULL,NULL,NULL,NULL),(7821,341,62.38,254.4,NULL,NULL,NULL,NULL),(7822,341,83.18,259.1,NULL,NULL,NULL,NULL),(7823,341,99.88,256.2,NULL,NULL,NULL,NULL),(7824,342,0.05,13.1,NULL,NULL,NULL,NULL),(7825,342,0.08,26.7,NULL,NULL,NULL,NULL),(7826,342,0.28,88.4,NULL,NULL,NULL,NULL),(7827,342,0.88,175.7,NULL,NULL,NULL,NULL),(7828,342,1.18,222.7,NULL,NULL,NULL,NULL),(7829,342,1.98,288.5,NULL,NULL,NULL,NULL),(7830,342,4.08,315.3,NULL,NULL,NULL,NULL),(7831,342,20.68,338.7,NULL,NULL,NULL,NULL),(7832,342,41.58,358,NULL,NULL,NULL,NULL),(7833,342,62.38,358.9,NULL,NULL,NULL,NULL),(7834,342,83.18,359.8,NULL,NULL,NULL,NULL),(7835,342,87.38,362.3,NULL,NULL,NULL,NULL),(7836,343,0.01,34.1,NULL,NULL,NULL,NULL),(7837,343,0.051,51.2,NULL,NULL,NULL,NULL),(7838,343,0.17,75.7,NULL,NULL,NULL,NULL),(7839,343,0.27,84.3,NULL,NULL,NULL,NULL),(7840,343,0.37,95.6,NULL,NULL,NULL,NULL),(7841,343,1.27,120,NULL,NULL,NULL,NULL),(7842,343,2.07,140.2,NULL,NULL,NULL,NULL),(7843,343,3.17,162.9,NULL,NULL,NULL,NULL),(7844,343,37.47,228.7,NULL,NULL,NULL,NULL),(7845,343,41.67,234.2,NULL,NULL,NULL,NULL),(7846,343,59.17,244.4,NULL,NULL,NULL,NULL),(7847,343,124.97,244.6,NULL,NULL,NULL,NULL),(7848,344,0.013,43.7,NULL,NULL,NULL,NULL),(7849,344,0.11,57.4,NULL,NULL,NULL,NULL),(7850,344,0.41,87.6,NULL,NULL,NULL,NULL),(7851,344,0.91,99.9,NULL,NULL,NULL,NULL),(7852,344,1.01,128.8,NULL,NULL,NULL,NULL),(7853,344,1.21,140.4,NULL,NULL,NULL,NULL),(7854,344,2.21,160.2,NULL,NULL,NULL,NULL),(7855,344,2.91,159,NULL,NULL,NULL,NULL),(7856,344,4.11,166.7,NULL,NULL,NULL,NULL),(7857,344,7.41,189.8,NULL,NULL,NULL,NULL),(7858,344,12.91,220.4,NULL,NULL,NULL,NULL),(7859,344,20.01,226.9,NULL,NULL,NULL,NULL),(7860,344,35.31,248.2,NULL,NULL,NULL,NULL),(7861,344,44.91,266.2,NULL,NULL,NULL,NULL),(7862,344,83.21,296.3,NULL,NULL,NULL,NULL),(7863,344,124.91,338.6,NULL,NULL,NULL,NULL),(7864,345,0.08,19.4,NULL,NULL,NULL,NULL),(7865,345,0.18,33.1,NULL,NULL,NULL,NULL),(7866,345,0.28,64.6,NULL,NULL,NULL,NULL),(7867,345,0.48,75.4,NULL,NULL,NULL,NULL),(7868,345,0.78,148.3,NULL,NULL,NULL,NULL),(7869,345,0.88,152.8,NULL,NULL,NULL,NULL),(7870,345,1.18,165,NULL,NULL,NULL,NULL),(7871,345,1.98,188.7,NULL,NULL,NULL,NULL),(7872,345,2.88,205.4,NULL,NULL,NULL,NULL),(7873,345,4.08,223.8,NULL,NULL,NULL,NULL),(7874,345,6.48,247.6,NULL,NULL,NULL,NULL),(7875,345,10.28,269.4,NULL,NULL,NULL,NULL),(7876,345,14.28,283.5,NULL,NULL,NULL,NULL),(7877,345,20.68,284.7,NULL,NULL,NULL,NULL),(7878,345,29.08,320.8,NULL,NULL,NULL,NULL),(7879,345,37.38,312.9,NULL,NULL,NULL,NULL),(7880,345,41.58,329.7,NULL,NULL,NULL,NULL),(7881,345,49.18,323.2,NULL,NULL,NULL,NULL),(7882,345,59.08,341.5,NULL,NULL,NULL,NULL),(7883,345,61.28,332.1,NULL,NULL,NULL,NULL),(7884,345,80.98,363.2,NULL,NULL,NULL,NULL),(7885,345,98.38,374.1,NULL,NULL,NULL,NULL),(7886,345,124.88,409.2,NULL,NULL,NULL,NULL),(7887,345,187.38,429.4,NULL,NULL,NULL,NULL),(7888,346,0.03,40.8,NULL,NULL,NULL,NULL),(7889,346,0.08,48.4,NULL,NULL,NULL,NULL),(7890,346,0.18,57.5,NULL,NULL,NULL,NULL),(7891,346,0.28,66.3,NULL,NULL,NULL,NULL),(7892,346,0.88,91.9,NULL,NULL,NULL,NULL),(7893,346,1.18,111.8,NULL,NULL,NULL,NULL),(7894,346,1.98,108.8,NULL,NULL,NULL,NULL),(7895,346,2.88,118.6,NULL,NULL,NULL,NULL),(7896,346,4.08,129.9,NULL,NULL,NULL,NULL),(7897,346,6.18,137.9,NULL,NULL,NULL,NULL),(7898,346,10.28,157.1,NULL,NULL,NULL,NULL),(7899,346,14.88,161.4,NULL,NULL,NULL,NULL),(7900,346,20.68,171.3,NULL,NULL,NULL,NULL),(7901,346,29.08,171.3,NULL,NULL,NULL,NULL),(7902,346,37.38,187,NULL,NULL,NULL,NULL),(7903,346,41.58,194.4,NULL,NULL,NULL,NULL),(7904,346,62.38,201.8,NULL,NULL,NULL,NULL),(7905,346,83.18,198.6,NULL,NULL,NULL,NULL),(7906,346,104.08,200.1,NULL,NULL,NULL,NULL),(7907,347,1,46,NULL,NULL,NULL,NULL),(7908,347,3,51.3,NULL,NULL,NULL,NULL),(7909,347,7,55.6,NULL,NULL,NULL,NULL),(7910,347,13,61.9,NULL,NULL,NULL,NULL),(7911,347,17,67.9,NULL,NULL,NULL,NULL),(7912,347,21,70.4,NULL,NULL,NULL,NULL),(7913,347,24,71.3,NULL,NULL,NULL,NULL),(7914,347,28,72.9,NULL,NULL,NULL,NULL),(7915,347,31,74.5,NULL,NULL,NULL,NULL),(7916,347,35,75.9,NULL,NULL,NULL,NULL),(7917,347,38,77.1,NULL,NULL,NULL,NULL),(7918,347,42,78.5,NULL,NULL,NULL,NULL),(7919,347,49,81.3,NULL,NULL,NULL,NULL),(7920,347,56,81.9,NULL,NULL,NULL,NULL),(7921,347,63,85.4,NULL,NULL,NULL,NULL),(7922,347,70,85.4,NULL,NULL,NULL,NULL),(7923,347,77,88.2,NULL,NULL,NULL,NULL),(7924,347,84,87.6,NULL,NULL,NULL,NULL),(7925,347,98,90.1,NULL,NULL,NULL,NULL),(7926,347,112,92.3,NULL,NULL,NULL,NULL),(7927,347,126,93,NULL,NULL,NULL,NULL),(7928,347,140,95.3,NULL,NULL,NULL,NULL),(7929,347,156,95.7,NULL,NULL,NULL,NULL),(7930,347,174,98.1,NULL,NULL,NULL,NULL),(7931,347,197,99.2,NULL,NULL,NULL,NULL),(7932,347,210,100.6,NULL,NULL,NULL,NULL),(7933,347,224,101.4,NULL,NULL,NULL,NULL),(7934,347,238,102.9,NULL,NULL,NULL,NULL),(7935,347,252,103.6,NULL,NULL,NULL,NULL),(7936,347,266,103.9,NULL,NULL,NULL,NULL),(7937,347,294,105.7,NULL,NULL,NULL,NULL),(7938,347,308,106.5,NULL,NULL,NULL,NULL),(7939,347,322,106.9,NULL,NULL,NULL,NULL),(7940,347,337,108.6,NULL,NULL,NULL,NULL),(7941,347,359,109.5,NULL,NULL,NULL,NULL),(7942,347,378,109.8,NULL,NULL,NULL,NULL),(7943,347,408,111.3,NULL,NULL,NULL,NULL),(7944,347,434,111.1,NULL,NULL,NULL,NULL),(7945,347,463,112.1,NULL,NULL,NULL,NULL),(7946,347,504,113.1,NULL,NULL,NULL,NULL),(7947,347,562,113.6,NULL,NULL,NULL,NULL),(7948,347,584,115.1,NULL,NULL,NULL,NULL),(7949,347,602,115.3,NULL,NULL,NULL,NULL),(7950,347,629,114.3,NULL,NULL,NULL,NULL),(7951,347,665,116.3,NULL,NULL,NULL,NULL),(7952,347,723,115.7,NULL,NULL,NULL,NULL),(7953,347,785,116.9,NULL,NULL,NULL,NULL),(7954,347,890,119.1,NULL,NULL,NULL,NULL),(7955,347,922,119.4,NULL,NULL,NULL,NULL),(7956,347,985,119.9,NULL,NULL,NULL,NULL),(7957,347,1056,121.1,NULL,NULL,NULL,NULL),(7958,347,1254,121.7,NULL,NULL,NULL,NULL),(7959,348,1,46.2,NULL,NULL,NULL,NULL),(7960,348,2,48.5,NULL,NULL,NULL,NULL),(7961,348,6,49.8,NULL,NULL,NULL,NULL),(7962,348,9,54.1,NULL,NULL,NULL,NULL),(7963,348,13,53.9,NULL,NULL,NULL,NULL),(7964,348,19,58.9,NULL,NULL,NULL,NULL),(7965,348,23,63.3,NULL,NULL,NULL,NULL),(7966,348,27,64.9,NULL,NULL,NULL,NULL),(7967,348,30,65.4,NULL,NULL,NULL,NULL),(7968,348,34,67,NULL,NULL,NULL,NULL),(7969,348,37,67.3,NULL,NULL,NULL,NULL),(7970,348,41,69.4,NULL,NULL,NULL,NULL),(7971,348,44,71.2,NULL,NULL,NULL,NULL),(7972,348,48,72,NULL,NULL,NULL,NULL),(7973,348,55,74.1,NULL,NULL,NULL,NULL),(7974,348,62,73.7,NULL,NULL,NULL,NULL),(7975,348,69,77.8,NULL,NULL,NULL,NULL),(7976,348,76,76.1,NULL,NULL,NULL,NULL),(7977,348,83,78.2,NULL,NULL,NULL,NULL),(7978,348,90,80.5,NULL,NULL,NULL,NULL),(7979,348,104,80.7,NULL,NULL,NULL,NULL),(7980,348,118,83.7,NULL,NULL,NULL,NULL),(7981,348,132,84,NULL,NULL,NULL,NULL),(7982,348,146,85.6,NULL,NULL,NULL,NULL),(7983,348,162,86.1,NULL,NULL,NULL,NULL),(7984,348,180,87.4,NULL,NULL,NULL,NULL),(7985,348,203,90,NULL,NULL,NULL,NULL),(7986,348,216,91,NULL,NULL,NULL,NULL),(7987,348,230,92.2,NULL,NULL,NULL,NULL),(7988,348,244,93.6,NULL,NULL,NULL,NULL),(7989,348,258,94.1,NULL,NULL,NULL,NULL),(7990,348,272,94,NULL,NULL,NULL,NULL),(7991,348,300,96.2,NULL,NULL,NULL,NULL),(7992,348,314,96.9,NULL,NULL,NULL,NULL),(7993,348,328,97.1,NULL,NULL,NULL,NULL),(7994,348,343,99.1,NULL,NULL,NULL,NULL),(7995,348,365,100,NULL,NULL,NULL,NULL),(7996,348,384,101.5,NULL,NULL,NULL,NULL),(7997,348,414,102.6,NULL,NULL,NULL,NULL),(7998,348,440,101.7,NULL,NULL,NULL,NULL),(7999,348,469,101.6,NULL,NULL,NULL,NULL),(8000,348,510,103.1,NULL,NULL,NULL,NULL),(8001,348,568,103,NULL,NULL,NULL,NULL),(8002,348,590,104.3,NULL,NULL,NULL,NULL),(8003,348,608,103.9,NULL,NULL,NULL,NULL),(8004,348,635,105.6,NULL,NULL,NULL,NULL),(8005,348,671,107.7,NULL,NULL,NULL,NULL),(8006,348,716,107.5,NULL,NULL,NULL,NULL),(8007,348,792,108.2,NULL,NULL,NULL,NULL),(8008,348,897,110.6,NULL,NULL,NULL,NULL),(8009,348,929,109.3,NULL,NULL,NULL,NULL),(8010,348,992,110.1,NULL,NULL,NULL,NULL),(8011,348,1063,113.1,NULL,NULL,NULL,NULL),(8012,348,1261,112.8,NULL,NULL,NULL,NULL),(8013,348,1458,112.8,NULL,NULL,NULL,NULL),(8014,348,1630,114.4,NULL,NULL,NULL,NULL),(8015,349,1,45,NULL,NULL,NULL,NULL),(8016,349,3,51.2,NULL,NULL,NULL,NULL),(8017,349,7,57.2,NULL,NULL,NULL,NULL),(8018,349,15,60.2,NULL,NULL,NULL,NULL),(8019,349,21,66.6,NULL,NULL,NULL,NULL),(8020,349,28,68,NULL,NULL,NULL,NULL),(8021,349,35,72,NULL,NULL,NULL,NULL),(8022,349,43,74.2,NULL,NULL,NULL,NULL),(8023,349,50,74.6,NULL,NULL,NULL,NULL),(8024,349,56,76.8,NULL,NULL,NULL,NULL),(8025,349,70,81.4,NULL,NULL,NULL,NULL),(8026,349,91,85.2,NULL,NULL,NULL,NULL),(8027,349,108,87,NULL,NULL,NULL,NULL),(8028,349,161,88.6,NULL,NULL,NULL,NULL),(8029,349,190,90.2,NULL,NULL,NULL,NULL),(8030,349,220,92.8,NULL,NULL,NULL,NULL),(8031,349,260,96.4,NULL,NULL,NULL,NULL),(8032,349,308,97.2,NULL,NULL,NULL,NULL),(8033,349,378,100.4,NULL,NULL,NULL,NULL),(8034,349,442,104,NULL,NULL,NULL,NULL),(8035,349,574,106,NULL,NULL,NULL,NULL),(8036,349,724,109.8,NULL,NULL,NULL,NULL),(8037,349,829,110.2,NULL,NULL,NULL,NULL),(8038,349,928,111,NULL,NULL,NULL,NULL),(8039,349,1022,111.8,NULL,NULL,NULL,NULL),(8040,349,1128,113,NULL,NULL,NULL,NULL),(8041,349,1200,116.4,NULL,NULL,NULL,NULL),(8042,349,1404,115,NULL,NULL,NULL,NULL),(8043,349,1659,117.2,NULL,NULL,NULL,NULL),(8044,350,0.315,31.69,NULL,NULL,NULL,NULL),(8045,350,3,40.8,NULL,NULL,NULL,NULL),(8046,350,4,42,NULL,NULL,NULL,NULL),(8047,350,8,45,NULL,NULL,NULL,NULL),(8048,350,14,48.3,NULL,NULL,NULL,NULL),(8049,350,21,53,NULL,NULL,NULL,NULL),(8050,350,28,51.8,NULL,NULL,NULL,NULL),(8051,350,36,53.1,NULL,NULL,NULL,NULL),(8052,350,43,54.7,NULL,NULL,NULL,NULL),(8053,350,52,55,NULL,NULL,NULL,NULL),(8054,350,74,56.5,NULL,NULL,NULL,NULL),(8055,350,94,57.6,NULL,NULL,NULL,NULL),(8056,350,136,58.2,NULL,NULL,NULL,NULL),(8057,350,184,61,NULL,NULL,NULL,NULL),(8058,350,197,61,NULL,NULL,NULL,NULL),(8059,350,224,61.1,NULL,NULL,NULL,NULL),(8060,350,317,60.4,NULL,NULL,NULL,NULL),(8061,350,522,65.9,NULL,NULL,NULL,NULL),(8062,350,722,67.4,NULL,NULL,NULL,NULL),(8063,350,1101,70,NULL,NULL,NULL,NULL),(8064,350,1310,69.1,NULL,NULL,NULL,NULL),(8065,350,1452,71,NULL,NULL,NULL,NULL),(8066,350,3802,74,NULL,NULL,NULL,NULL),(8067,350,4300,78.2,NULL,NULL,NULL,NULL),(8068,350,5148,74.9,NULL,NULL,NULL,NULL),(8069,350,6321,78.4,NULL,NULL,NULL,NULL),(8070,351,0.959,31.7,NULL,NULL,NULL,NULL),(8071,351,3,41.3,NULL,NULL,NULL,NULL),(8072,351,4,41.7,NULL,NULL,NULL,NULL),(8073,351,8,47.5,NULL,NULL,NULL,NULL),(8074,351,14,52.5,NULL,NULL,NULL,NULL),(8075,351,21,56.2,NULL,NULL,NULL,NULL),(8076,351,28,59,NULL,NULL,NULL,NULL),(8077,351,36,63.1,NULL,NULL,NULL,NULL),(8078,351,43,65.8,NULL,NULL,NULL,NULL),(8079,351,52,67.7,NULL,NULL,NULL,NULL),(8080,351,74,72.2,NULL,NULL,NULL,NULL),(8081,351,94,78.1,NULL,NULL,NULL,NULL),(8082,351,114,81.9,NULL,NULL,NULL,NULL),(8083,351,136,84.5,NULL,NULL,NULL,NULL),(8084,351,162,86.4,NULL,NULL,NULL,NULL),(8085,351,184,88.6,NULL,NULL,NULL,NULL),(8086,351,197,89.5,NULL,NULL,NULL,NULL),(8087,351,224,90.3,NULL,NULL,NULL,NULL),(8088,351,317,93.1,NULL,NULL,NULL,NULL),(8089,351,417,97,NULL,NULL,NULL,NULL),(8090,351,522,98.2,NULL,NULL,NULL,NULL),(8091,351,722,100.9,NULL,NULL,NULL,NULL),(8092,351,899,101.4,NULL,NULL,NULL,NULL),(8093,351,1101,103.4,NULL,NULL,NULL,NULL),(8094,351,1310,105.1,NULL,NULL,NULL,NULL),(8095,351,1452,105.7,NULL,NULL,NULL,NULL),(8096,351,3802,113,NULL,NULL,NULL,NULL),(8097,351,4300,118.9,NULL,NULL,NULL,NULL),(8098,351,5148,116.3,NULL,NULL,NULL,NULL),(8099,351,6321,112,NULL,NULL,NULL,NULL),(8100,352,0.5,31.7,NULL,NULL,NULL,NULL),(8101,352,1,33.1,NULL,NULL,NULL,NULL),(8102,352,2,33.7,NULL,NULL,NULL,NULL),(8103,352,3,35.3,NULL,NULL,NULL,NULL),(8104,352,8,40.2,NULL,NULL,NULL,NULL),(8105,352,24,46.9,NULL,NULL,NULL,NULL),(8106,352,30,48.5,NULL,NULL,NULL,NULL),(8107,352,43,51.3,NULL,NULL,NULL,NULL),(8108,352,70,55.5,NULL,NULL,NULL,NULL),(8109,352,91,58.1,NULL,NULL,NULL,NULL),(8110,352,109,59.5,NULL,NULL,NULL,NULL),(8111,352,163,64.8,NULL,NULL,NULL,NULL),(8112,352,196,66.5,NULL,NULL,NULL,NULL),(8113,352,228,67.4,NULL,NULL,NULL,NULL),(8114,352,263,70,NULL,NULL,NULL,NULL),(8115,352,316,71.3,NULL,NULL,NULL,NULL),(8116,352,368,72.3,NULL,NULL,NULL,NULL),(8117,352,568,76.4,NULL,NULL,NULL,NULL),(8118,352,745,78.1,NULL,NULL,NULL,NULL),(8119,352,947,79.3,NULL,NULL,NULL,NULL),(8120,352,1156,81,NULL,NULL,NULL,NULL),(8121,352,1298,81.7,NULL,NULL,NULL,NULL),(8122,352,3648,90.9,NULL,NULL,NULL,NULL),(8123,352,4146,95.5,NULL,NULL,NULL,NULL),(8124,352,4994,94.8,NULL,NULL,NULL,NULL),(8125,352,6167,91,NULL,NULL,NULL,NULL),(8126,353,0.5,28.8,NULL,NULL,NULL,NULL),(8127,353,1.16,31.7,NULL,NULL,NULL,NULL),(8128,353,17,42.7,NULL,NULL,NULL,NULL),(8129,353,25,43.9,NULL,NULL,NULL,NULL),(8130,353,49,47.7,NULL,NULL,NULL,NULL),(8131,353,84,51.3,NULL,NULL,NULL,NULL),(8132,353,137,54.5,NULL,NULL,NULL,NULL),(8133,353,189,57,NULL,NULL,NULL,NULL),(8134,353,300,61,NULL,NULL,NULL,NULL),(8135,353,389,63.9,NULL,NULL,NULL,NULL),(8136,353,482,66,NULL,NULL,NULL,NULL),(8137,353,566,67.1,NULL,NULL,NULL,NULL),(8138,353,768,69.6,NULL,NULL,NULL,NULL),(8139,353,977,71.9,NULL,NULL,NULL,NULL),(8140,353,1119,71.9,NULL,NULL,NULL,NULL),(8141,353,3469,82.8,NULL,NULL,NULL,NULL),(8142,353,3967,85.6,NULL,NULL,NULL,NULL),(8143,353,4815,85.4,NULL,NULL,NULL,NULL),(8144,353,5988,83.4,NULL,NULL,NULL,NULL),(8145,354,0.766,27.59,NULL,NULL,NULL,NULL),(8146,354,1,28.5,NULL,NULL,NULL,NULL),(8147,354,2,30.8,NULL,NULL,NULL,NULL),(8148,354,3,32.4,NULL,NULL,NULL,NULL),(8149,354,7,35.9,NULL,NULL,NULL,NULL),(8150,354,14,39.4,NULL,NULL,NULL,NULL),(8151,354,21,42.5,NULL,NULL,NULL,NULL),(8152,354,28,43.9,NULL,NULL,NULL,NULL),(8153,354,41,47.1,NULL,NULL,NULL,NULL),(8154,354,55,49.3,NULL,NULL,NULL,NULL),(8155,354,107,54.8,NULL,NULL,NULL,NULL),(8156,354,143,57.4,NULL,NULL,NULL,NULL),(8157,354,169,58.6,NULL,NULL,NULL,NULL),(8158,354,308,65.1,NULL,NULL,NULL,NULL),(8159,354,356,67,NULL,NULL,NULL,NULL),(8160,354,420,69.2,NULL,NULL,NULL,NULL),(8161,354,457,69.6,NULL,NULL,NULL,NULL),(8162,354,500,69.9,NULL,NULL,NULL,NULL),(8163,354,542,71.1,NULL,NULL,NULL,NULL),(8164,354,632,71.1,NULL,NULL,NULL,NULL),(8165,354,646,71.3,NULL,NULL,NULL,NULL),(8166,354,673,71.8,NULL,NULL,NULL,NULL),(8167,354,764,70.8,NULL,NULL,NULL,NULL),(8168,354,969,77.3,NULL,NULL,NULL,NULL),(8169,354,1169,79.3,NULL,NULL,NULL,NULL),(8170,354,1548,84.8,NULL,NULL,NULL,NULL),(8171,354,1757,83.5,NULL,NULL,NULL,NULL),(8172,354,1899,86.1,NULL,NULL,NULL,NULL),(8173,354,4249,92.2,NULL,NULL,NULL,NULL),(8174,354,4747,96,NULL,NULL,NULL,NULL),(8175,354,5595,95,NULL,NULL,NULL,NULL),(8176,354,6768,96.6,NULL,NULL,NULL,NULL),(8177,355,0.257,27.59,NULL,NULL,NULL,NULL),(8178,355,1,33.8,NULL,NULL,NULL,NULL),(8179,355,2,37.6,NULL,NULL,NULL,NULL),(8180,355,3,39.5,NULL,NULL,NULL,NULL),(8181,355,7,44.1,NULL,NULL,NULL,NULL),(8182,355,14,49.1,NULL,NULL,NULL,NULL),(8183,355,21,52,NULL,NULL,NULL,NULL),(8184,355,28,54,NULL,NULL,NULL,NULL),(8185,355,41,57.8,NULL,NULL,NULL,NULL),(8186,355,55,60.7,NULL,NULL,NULL,NULL),(8187,355,107,69.4,NULL,NULL,NULL,NULL),(8188,355,143,73,NULL,NULL,NULL,NULL),(8189,355,169,75,NULL,NULL,NULL,NULL),(8190,355,308,82,NULL,NULL,NULL,NULL),(8191,355,356,84,NULL,NULL,NULL,NULL),(8192,355,420,86.1,NULL,NULL,NULL,NULL),(8193,355,457,85.6,NULL,NULL,NULL,NULL),(8194,355,500,86.9,NULL,NULL,NULL,NULL),(8195,355,542,85.8,NULL,NULL,NULL,NULL),(8196,355,632,88.4,NULL,NULL,NULL,NULL),(8197,355,646,89.1,NULL,NULL,NULL,NULL),(8198,355,673,88.8,NULL,NULL,NULL,NULL),(8199,355,764,89.4,NULL,NULL,NULL,NULL),(8200,355,969,92,NULL,NULL,NULL,NULL),(8201,355,1169,92.7,NULL,NULL,NULL,NULL),(8202,355,1548,95.4,NULL,NULL,NULL,NULL),(8203,355,1757,97,NULL,NULL,NULL,NULL),(8204,355,1899,95.8,NULL,NULL,NULL,NULL),(8205,355,4249,101.6,NULL,NULL,NULL,NULL),(8206,355,4747,104.5,NULL,NULL,NULL,NULL),(8207,355,5595,104.4,NULL,NULL,NULL,NULL),(8208,355,6768,101.9,NULL,NULL,NULL,NULL),(8209,356,1,26.1,NULL,NULL,NULL,NULL),(8210,356,2,27.4,NULL,NULL,NULL,NULL),(8211,356,3,28.8,NULL,NULL,NULL,NULL),(8212,356,4,30,NULL,NULL,NULL,NULL),(8213,356,7,31.5,NULL,NULL,NULL,NULL),(8214,356,11,34.8,NULL,NULL,NULL,NULL),(8215,356,14,36.1,NULL,NULL,NULL,NULL),(8216,356,16,37.3,NULL,NULL,NULL,NULL),(8217,356,23,40.2,NULL,NULL,NULL,NULL),(8218,356,32,42.2,NULL,NULL,NULL,NULL),(8219,356,45,46,NULL,NULL,NULL,NULL),(8220,356,53,47,NULL,NULL,NULL,NULL),(8221,356,60,47.7,NULL,NULL,NULL,NULL),(8222,356,71,50.3,NULL,NULL,NULL,NULL),(8223,356,91,51.8,NULL,NULL,NULL,NULL),(8224,356,130,56,NULL,NULL,NULL,NULL),(8225,356,155,58.2,NULL,NULL,NULL,NULL),(8226,356,203,59.9,NULL,NULL,NULL,NULL),(8227,356,267,61.5,NULL,NULL,NULL,NULL),(8228,356,304,63.7,NULL,NULL,NULL,NULL),(8229,356,347,64.5,NULL,NULL,NULL,NULL),(8230,356,389,65.3,NULL,NULL,NULL,NULL),(8231,356,479,68.6,NULL,NULL,NULL,NULL),(8232,356,493,68.8,NULL,NULL,NULL,NULL),(8233,356,520,69.1,NULL,NULL,NULL,NULL),(8234,356,611,68.8,NULL,NULL,NULL,NULL),(8235,356,816,72.1,NULL,NULL,NULL,NULL),(8236,356,1016,73.5,NULL,NULL,NULL,NULL),(8237,356,1395,76.6,NULL,NULL,NULL,NULL),(8238,356,1604,76.9,NULL,NULL,NULL,NULL),(8239,356,1746,77,NULL,NULL,NULL,NULL),(8240,356,4096,82.8,NULL,NULL,NULL,NULL),(8241,356,4594,86.8,NULL,NULL,NULL,NULL),(8242,356,5442,84.1,NULL,NULL,NULL,NULL),(8243,357,0.11,27.6,NULL,NULL,NULL,NULL),(8244,357,1,30,NULL,NULL,NULL,NULL),(8245,357,4,31.2,NULL,NULL,NULL,NULL),(8246,357,6,32.5,NULL,NULL,NULL,NULL),(8247,357,7,31.9,NULL,NULL,NULL,NULL),(8248,357,8,32.4,NULL,NULL,NULL,NULL),(8249,357,12,32.9,NULL,NULL,NULL,NULL),(8250,357,15,33.8,NULL,NULL,NULL,NULL),(8251,357,40,37.6,NULL,NULL,NULL,NULL),(8252,357,62,39.6,NULL,NULL,NULL,NULL),(8253,357,95,41.6,NULL,NULL,NULL,NULL),(8254,357,127,43.4,NULL,NULL,NULL,NULL),(8255,357,162,43.8,NULL,NULL,NULL,NULL),(8256,357,267,46.6,NULL,NULL,NULL,NULL),(8257,357,467,49.6,NULL,NULL,NULL,NULL),(8258,357,647,51.2,NULL,NULL,NULL,NULL),(8259,357,846,54.4,NULL,NULL,NULL,NULL),(8260,357,1055,54.7,NULL,NULL,NULL,NULL),(8261,357,1197,55.6,NULL,NULL,NULL,NULL),(8262,357,3547,64.4,NULL,NULL,NULL,NULL),(8263,357,4045,67.5,NULL,NULL,NULL,NULL),(8264,357,4893,66.2,NULL,NULL,NULL,NULL),(8265,357,6066,63.9,NULL,NULL,NULL,NULL),(8266,358,1,50.1,NULL,NULL,NULL,NULL),(8267,358,3,61,NULL,NULL,NULL,NULL),(8268,358,6,64.6,NULL,NULL,NULL,NULL),(8269,358,7,68.1,NULL,NULL,NULL,NULL),(8270,358,9,71.1,NULL,NULL,NULL,NULL),(8271,358,13,77.7,NULL,NULL,NULL,NULL),(8272,358,20,86.3,NULL,NULL,NULL,NULL),(8273,358,34,98,NULL,NULL,NULL,NULL),(8274,358,55,111.4,NULL,NULL,NULL,NULL),(8275,358,76,118.7,NULL,NULL,NULL,NULL),(8276,358,104,129.9,NULL,NULL,NULL,NULL),(8277,358,132,138.6,NULL,NULL,NULL,NULL),(8278,358,174,147.3,NULL,NULL,NULL,NULL),(8279,358,204,151.4,NULL,NULL,NULL,NULL),(8280,358,244,154.9,NULL,NULL,NULL,NULL),(8281,358,295,160.7,NULL,NULL,NULL,NULL),(8282,358,384,167.4,NULL,NULL,NULL,NULL),(8283,358,514,173.1,NULL,NULL,NULL,NULL),(8284,358,687,178.9,NULL,NULL,NULL,NULL),(8285,358,1935,189.1,NULL,NULL,NULL,NULL),(8286,358,3492,190.7,NULL,NULL,NULL,NULL),(8287,359,1,48,NULL,NULL,NULL,NULL),(8288,359,3,53.3,NULL,NULL,NULL,NULL),(8289,359,7,61.3,NULL,NULL,NULL,NULL),(8290,359,14,70.3,NULL,NULL,NULL,NULL),(8291,359,28,83.7,NULL,NULL,NULL,NULL),(8292,359,49,98.7,NULL,NULL,NULL,NULL),(8293,359,70,107.4,NULL,NULL,NULL,NULL),(8294,359,98,118.9,NULL,NULL,NULL,NULL),(8295,359,126,126.9,NULL,NULL,NULL,NULL),(8296,359,168,135.9,NULL,NULL,NULL,NULL),(8297,359,198,140,NULL,NULL,NULL,NULL),(8298,359,238,144.1,NULL,NULL,NULL,NULL),(8299,359,289,149.1,NULL,NULL,NULL,NULL),(8300,359,378,156.7,NULL,NULL,NULL,NULL),(8301,359,508,162.7,NULL,NULL,NULL,NULL),(8302,359,681,168.1,NULL,NULL,NULL,NULL),(8303,359,1929,179.3,NULL,NULL,NULL,NULL),(8304,359,3486,183,NULL,NULL,NULL,NULL),(8305,360,0.112,35.1,NULL,NULL,NULL,NULL),(8306,360,1,47.6,NULL,NULL,NULL,NULL),(8307,360,3,55.6,NULL,NULL,NULL,NULL),(8308,360,7,61.4,NULL,NULL,NULL,NULL),(8309,360,21,73.6,NULL,NULL,NULL,NULL),(8310,360,42,91.6,NULL,NULL,NULL,NULL),(8311,360,63,100.4,NULL,NULL,NULL,NULL),(8312,360,91,113.4,NULL,NULL,NULL,NULL),(8313,360,119,119.6,NULL,NULL,NULL,NULL),(8314,360,161,129.4,NULL,NULL,NULL,NULL),(8315,360,191,135.1,NULL,NULL,NULL,NULL),(8316,360,231,138.4,NULL,NULL,NULL,NULL),(8317,360,282,143.7,NULL,NULL,NULL,NULL),(8318,360,371,151.4,NULL,NULL,NULL,NULL),(8319,360,501,157.1,NULL,NULL,NULL,NULL),(8320,360,674,163,NULL,NULL,NULL,NULL),(8321,360,1922,175.4,NULL,NULL,NULL,NULL),(8322,361,0.0672,35,NULL,NULL,NULL,NULL),(8323,361,1,47.1,NULL,NULL,NULL,NULL),(8324,361,9,57.7,NULL,NULL,NULL,NULL),(8325,361,14,63.1,NULL,NULL,NULL,NULL),(8326,361,28,75.4,NULL,NULL,NULL,NULL),(8327,361,35,79.7,NULL,NULL,NULL,NULL),(8328,361,56,89.6,NULL,NULL,NULL,NULL),(8329,361,84,102.9,NULL,NULL,NULL,NULL),(8330,361,112,108.7,NULL,NULL,NULL,NULL),(8331,361,154,118.6,NULL,NULL,NULL,NULL),(8332,361,184,123.3,NULL,NULL,NULL,NULL),(8333,361,224,126.4,NULL,NULL,NULL,NULL),(8334,361,275,131.9,NULL,NULL,NULL,NULL),(8335,361,364,139.1,NULL,NULL,NULL,NULL),(8336,361,494,145,NULL,NULL,NULL,NULL),(8337,361,667,150.6,NULL,NULL,NULL,NULL),(8338,361,1915,163,NULL,NULL,NULL,NULL),(8339,361,3472,166.3,NULL,NULL,NULL,NULL),(8340,362,0.17,33.3,NULL,NULL,NULL,NULL),(8341,362,1,42.7,NULL,NULL,NULL,NULL),(8342,362,4,49.4,NULL,NULL,NULL,NULL),(8343,362,7,55,NULL,NULL,NULL,NULL),(8344,362,10,57.7,NULL,NULL,NULL,NULL),(8345,362,14,60.9,NULL,NULL,NULL,NULL),(8346,362,22,66,NULL,NULL,NULL,NULL),(8347,362,28,70.3,NULL,NULL,NULL,NULL),(8348,362,56,79.6,NULL,NULL,NULL,NULL),(8349,362,98,91.9,NULL,NULL,NULL,NULL),(8350,362,128,96.7,NULL,NULL,NULL,NULL),(8351,362,168,100.7,NULL,NULL,NULL,NULL),(8352,362,219,107.3,NULL,NULL,NULL,NULL),(8353,362,308,115.6,NULL,NULL,NULL,NULL),(8354,362,438,122.6,NULL,NULL,NULL,NULL),(8355,362,611,128.6,NULL,NULL,NULL,NULL),(8356,362,1859,141,NULL,NULL,NULL,NULL),(8357,363,0.049,33.4,NULL,NULL,NULL,NULL),(8358,363,1,42,NULL,NULL,NULL,NULL),(8359,363,4,47,NULL,NULL,NULL,NULL),(8360,363,7,49.1,NULL,NULL,NULL,NULL),(8361,363,11,53.1,NULL,NULL,NULL,NULL),(8362,363,14,54,NULL,NULL,NULL,NULL),(8363,363,22,54.6,NULL,NULL,NULL,NULL),(8364,363,30,59.4,NULL,NULL,NULL,NULL),(8365,363,70,67.4,NULL,NULL,NULL,NULL),(8366,363,121,74.9,NULL,NULL,NULL,NULL),(8367,363,210,85.4,NULL,NULL,NULL,NULL),(8368,363,340,92.4,NULL,NULL,NULL,NULL),(8369,363,513,97.7,NULL,NULL,NULL,NULL),(8370,363,1761,113.3,NULL,NULL,NULL,NULL),(8371,364,1,45.7,NULL,NULL,NULL,NULL),(8372,364,3,50.6,NULL,NULL,NULL,NULL),(8373,364,6,52.9,NULL,NULL,NULL,NULL),(8374,364,7,55.1,NULL,NULL,NULL,NULL),(8375,364,9,57.6,NULL,NULL,NULL,NULL),(8376,364,13,59.7,NULL,NULL,NULL,NULL),(8377,364,20,63.3,NULL,NULL,NULL,NULL),(8378,364,34,68.3,NULL,NULL,NULL,NULL),(8379,364,55,71.9,NULL,NULL,NULL,NULL),(8380,364,76,73.1,NULL,NULL,NULL,NULL),(8381,364,104,75.1,NULL,NULL,NULL,NULL),(8382,364,132,76.9,NULL,NULL,NULL,NULL),(8383,364,174,81,NULL,NULL,NULL,NULL),(8384,364,204,82.1,NULL,NULL,NULL,NULL),(8385,364,244,83,NULL,NULL,NULL,NULL),(8386,364,295,83.9,NULL,NULL,NULL,NULL),(8387,364,384,85,NULL,NULL,NULL,NULL),(8388,364,514,89.1,NULL,NULL,NULL,NULL),(8389,364,687,93.6,NULL,NULL,NULL,NULL),(8390,364,1935,100,NULL,NULL,NULL,NULL),(8391,365,1,41.1,NULL,NULL,NULL,NULL),(8392,365,3,44,NULL,NULL,NULL,NULL),(8393,365,7,48.4,NULL,NULL,NULL,NULL),(8394,365,14,50.7,NULL,NULL,NULL,NULL),(8395,365,28,57.4,NULL,NULL,NULL,NULL),(8396,365,49,61.6,NULL,NULL,NULL,NULL),(8397,365,70,64.3,NULL,NULL,NULL,NULL),(8398,365,98,66.6,NULL,NULL,NULL,NULL),(8399,365,126,68,NULL,NULL,NULL,NULL),(8400,365,168,71.3,NULL,NULL,NULL,NULL),(8401,365,198,72.3,NULL,NULL,NULL,NULL),(8402,365,238,73.3,NULL,NULL,NULL,NULL),(8403,365,289,73.9,NULL,NULL,NULL,NULL),(8404,365,378,76.3,NULL,NULL,NULL,NULL),(8405,365,508,81,NULL,NULL,NULL,NULL),(8406,365,681,84.9,NULL,NULL,NULL,NULL),(8407,365,1929,92.3,NULL,NULL,NULL,NULL),(8408,366,1,37.7,NULL,NULL,NULL,NULL),(8409,366,3,42.7,NULL,NULL,NULL,NULL),(8410,366,7,44.1,NULL,NULL,NULL,NULL),(8411,366,21,50.1,NULL,NULL,NULL,NULL),(8412,366,42,56.1,NULL,NULL,NULL,NULL),(8413,366,63,59,NULL,NULL,NULL,NULL),(8414,366,91,62.6,NULL,NULL,NULL,NULL),(8415,366,119,62.6,NULL,NULL,NULL,NULL),(8416,366,161,66.4,NULL,NULL,NULL,NULL),(8417,366,191,69.3,NULL,NULL,NULL,NULL),(8418,366,231,70.4,NULL,NULL,NULL,NULL),(8419,366,282,72.7,NULL,NULL,NULL,NULL),(8420,366,371,76,NULL,NULL,NULL,NULL),(8421,366,501,80.3,NULL,NULL,NULL,NULL),(8422,366,674,86.3,NULL,NULL,NULL,NULL),(8423,366,1922,97,NULL,NULL,NULL,NULL),(8424,367,0.0187,33.56,NULL,NULL,NULL,NULL),(8425,367,1,36.9,NULL,NULL,NULL,NULL),(8426,367,9,39.4,NULL,NULL,NULL,NULL),(8427,367,14,42,NULL,NULL,NULL,NULL),(8428,367,28,45.3,NULL,NULL,NULL,NULL),(8429,367,35,47.1,NULL,NULL,NULL,NULL),(8430,367,56,50.3,NULL,NULL,NULL,NULL),(8431,367,84,53.3,NULL,NULL,NULL,NULL),(8432,367,112,53.6,NULL,NULL,NULL,NULL),(8433,367,154,57.7,NULL,NULL,NULL,NULL),(8434,367,184,60.1,NULL,NULL,NULL,NULL),(8435,367,224,60.1,NULL,NULL,NULL,NULL),(8436,367,275,62.4,NULL,NULL,NULL,NULL),(8437,367,364,63.4,NULL,NULL,NULL,NULL),(8438,367,494,68.7,NULL,NULL,NULL,NULL),(8439,367,667,73.7,NULL,NULL,NULL,NULL),(8440,367,1915,82.9,NULL,NULL,NULL,NULL),(8441,368,0.88,31.7,NULL,NULL,NULL,NULL),(8442,368,2.375,33.56,NULL,NULL,NULL,NULL),(8443,368,3.88,34.4,NULL,NULL,NULL,NULL),(8444,368,6.88,36.1,NULL,NULL,NULL,NULL),(8445,368,9.88,37.1,NULL,NULL,NULL,NULL),(8446,368,13.88,37.9,NULL,NULL,NULL,NULL),(8447,368,21.88,38.6,NULL,NULL,NULL,NULL),(8448,368,27.88,40.6,NULL,NULL,NULL,NULL),(8449,368,55.88,41.7,NULL,NULL,NULL,NULL),(8450,368,97.88,46.1,NULL,NULL,NULL,NULL),(8451,368,127.88,49,NULL,NULL,NULL,NULL),(8452,368,167.88,49.9,NULL,NULL,NULL,NULL),(8453,368,218.88,53,NULL,NULL,NULL,NULL),(8454,368,307.88,55.1,NULL,NULL,NULL,NULL),(8455,368,437.88,61.4,NULL,NULL,NULL,NULL),(8456,368,610.88,66.7,NULL,NULL,NULL,NULL),(8457,368,1858.88,78.7,NULL,NULL,NULL,NULL),(8458,369,1,29.7,NULL,NULL,NULL,NULL),(8459,369,4,32.3,NULL,NULL,NULL,NULL),(8460,369,6.49,33.56,NULL,NULL,NULL,NULL),(8461,369,7,33.85,NULL,NULL,NULL,NULL),(8462,369,11,35.1,NULL,NULL,NULL,NULL),(8463,369,14,35.1,NULL,NULL,NULL,NULL),(8464,369,22,33.4,NULL,NULL,NULL,NULL),(8465,369,30,36.4,NULL,NULL,NULL,NULL),(8466,369,70,39.3,NULL,NULL,NULL,NULL),(8467,369,121,42,NULL,NULL,NULL,NULL),(8468,369,210,44,NULL,NULL,NULL,NULL),(8469,369,340,50.6,NULL,NULL,NULL,NULL),(8470,369,513,56,NULL,NULL,NULL,NULL),(8471,369,1761,64.6,NULL,NULL,NULL,NULL),(8472,370,1,52.9,NULL,NULL,NULL,NULL),(8473,370,3,59.1,NULL,NULL,NULL,NULL),(8474,370,7,66.9,NULL,NULL,NULL,NULL),(8475,370,14,78.7,NULL,NULL,NULL,NULL),(8476,370,28,97.4,NULL,NULL,NULL,NULL),(8477,370,49,115.7,NULL,NULL,NULL,NULL),(8478,370,70,126.7,NULL,NULL,NULL,NULL),(8479,370,98,138.3,NULL,NULL,NULL,NULL),(8480,370,126,146.9,NULL,NULL,NULL,NULL),(8481,370,168,153,NULL,NULL,NULL,NULL),(8482,370,198,156.6,NULL,NULL,NULL,NULL),(8483,370,238,160.3,NULL,NULL,NULL,NULL),(8484,370,289,164.1,NULL,NULL,NULL,NULL),(8485,370,378,168.1,NULL,NULL,NULL,NULL),(8486,370,508,173.4,NULL,NULL,NULL,NULL),(8487,370,681,177.4,NULL,NULL,NULL,NULL),(8488,370,1929,189.3,NULL,NULL,NULL,NULL),(8489,370,3486,191.6,NULL,NULL,NULL,NULL),(8490,371,1,48.7,NULL,NULL,NULL,NULL),(8491,371,3,54.1,NULL,NULL,NULL,NULL),(8492,371,7,60,NULL,NULL,NULL,NULL),(8493,371,14,68.6,NULL,NULL,NULL,NULL),(8494,371,28,78.7,NULL,NULL,NULL,NULL),(8495,371,49,89.6,NULL,NULL,NULL,NULL),(8496,371,70,96.6,NULL,NULL,NULL,NULL),(8497,371,98,104.4,NULL,NULL,NULL,NULL),(8498,371,126,110.6,NULL,NULL,NULL,NULL),(8499,371,168,118.6,NULL,NULL,NULL,NULL),(8500,371,198,122,NULL,NULL,NULL,NULL),(8501,371,238,126.9,NULL,NULL,NULL,NULL),(8502,371,289,132.4,NULL,NULL,NULL,NULL),(8503,371,378,140.4,NULL,NULL,NULL,NULL),(8504,371,508,145.7,NULL,NULL,NULL,NULL),(8505,371,681,151.4,NULL,NULL,NULL,NULL),(8506,371,1929,164.1,NULL,NULL,NULL,NULL),(8507,371,3486,168.6,NULL,NULL,NULL,NULL),(8508,372,1,46.4,NULL,NULL,NULL,NULL),(8509,372,3,50.7,NULL,NULL,NULL,NULL),(8510,372,7,56.4,NULL,NULL,NULL,NULL),(8511,372,14,64.1,NULL,NULL,NULL,NULL),(8512,372,28,70,NULL,NULL,NULL,NULL),(8513,372,49,79,NULL,NULL,NULL,NULL),(8514,372,70,85.6,NULL,NULL,NULL,NULL),(8515,372,98,92.4,NULL,NULL,NULL,NULL),(8516,372,126,96.7,NULL,NULL,NULL,NULL),(8517,372,168,102.9,NULL,NULL,NULL,NULL),(8518,372,198,103.9,NULL,NULL,NULL,NULL),(8519,372,238,108.6,NULL,NULL,NULL,NULL),(8520,372,289,112.1,NULL,NULL,NULL,NULL),(8521,372,378,119.6,NULL,NULL,NULL,NULL),(8522,372,508,126.6,NULL,NULL,NULL,NULL),(8523,372,681,132.3,NULL,NULL,NULL,NULL),(8524,372,1929,147,NULL,NULL,NULL,NULL),(8525,372,3486,154.3,NULL,NULL,NULL,NULL),(8526,373,1,42.9,NULL,NULL,NULL,NULL),(8527,373,3,47.3,NULL,NULL,NULL,NULL),(8528,373,7,51,NULL,NULL,NULL,NULL),(8529,373,14,56.6,NULL,NULL,NULL,NULL),(8530,373,28,66.7,NULL,NULL,NULL,NULL),(8531,373,49,72.1,NULL,NULL,NULL,NULL),(8532,373,70,78.1,NULL,NULL,NULL,NULL),(8533,373,98,83.3,NULL,NULL,NULL,NULL),(8534,373,126,87,NULL,NULL,NULL,NULL),(8535,373,168,92.3,NULL,NULL,NULL,NULL),(8536,373,198,95,NULL,NULL,NULL,NULL),(8537,373,238,97.1,NULL,NULL,NULL,NULL),(8538,373,289,100.9,NULL,NULL,NULL,NULL),(8539,373,378,105.3,NULL,NULL,NULL,NULL),(8540,373,508,111.1,NULL,NULL,NULL,NULL),(8541,373,681,117.3,NULL,NULL,NULL,NULL),(8542,373,1929,132.6,NULL,NULL,NULL,NULL),(8543,373,3486,140.6,NULL,NULL,NULL,NULL),(8544,374,0.8,52.7,NULL,NULL,NULL,NULL),(8545,374,3.8,75.3,NULL,NULL,NULL,NULL),(8546,374,9.8,87.9,NULL,NULL,NULL,NULL),(8547,374,19.8,93.6,NULL,NULL,NULL,NULL),(8548,374,29.8,96.6,NULL,NULL,NULL,NULL),(8549,374,39.8,98.1,NULL,NULL,NULL,NULL),(8550,375,0.8,54.4,NULL,NULL,NULL,NULL),(8551,375,3.8,64.4,NULL,NULL,NULL,NULL),(8552,375,9.8,72.2,NULL,NULL,NULL,NULL),(8553,375,19.8,80,NULL,NULL,NULL,NULL),(8554,375,29.8,83.3,NULL,NULL,NULL,NULL),(8555,375,39.8,84.2,NULL,NULL,NULL,NULL),(8556,376,0.8,52.8,NULL,NULL,NULL,NULL),(8557,376,3.8,62.7,NULL,NULL,NULL,NULL),(8558,376,9.8,72,NULL,NULL,NULL,NULL),(8559,376,19.8,82.7,NULL,NULL,NULL,NULL),(8560,376,29.8,86.4,NULL,NULL,NULL,NULL),(8561,376,39.8,92,NULL,NULL,NULL,NULL),(8562,377,1,76.5,NULL,NULL,NULL,NULL),(8563,377,4,92,NULL,NULL,NULL,NULL),(8564,377,9.6,104.7,NULL,NULL,NULL,NULL),(8565,377,19.6,118.8,NULL,NULL,NULL,NULL),(8566,377,29.6,122.4,NULL,NULL,NULL,NULL),(8567,377,39.6,124.2,NULL,NULL,NULL,NULL),(8568,378,1,85.9,NULL,NULL,NULL,NULL),(8569,378,4,102.7,NULL,NULL,NULL,NULL),(8570,378,9.6,112,NULL,NULL,NULL,NULL),(8571,378,19.6,128,NULL,NULL,NULL,NULL),(8572,378,29.6,132,NULL,NULL,NULL,NULL),(8573,378,39.6,133.3,NULL,NULL,NULL,NULL),(8574,379,1,90.7,NULL,NULL,NULL,NULL),(8575,379,4,107.2,NULL,NULL,NULL,NULL),(8576,379,9.6,124,NULL,NULL,NULL,NULL),(8577,379,19.6,136.3,NULL,NULL,NULL,NULL),(8578,379,29.6,140,NULL,NULL,NULL,NULL),(8579,379,39.6,145.3,NULL,NULL,NULL,NULL),(8580,380,1,78.6,NULL,NULL,NULL,NULL),(8581,380,4,98,NULL,NULL,NULL,NULL),(8582,380,9.6,113.4,NULL,NULL,NULL,NULL),(8583,380,19.6,127.7,NULL,NULL,NULL,NULL),(8584,380,29.6,134.3,NULL,NULL,NULL,NULL),(8585,380,39.6,138.6,NULL,NULL,NULL,NULL),(8586,381,1,87.7,NULL,NULL,NULL,NULL),(8587,381,4,108.7,NULL,NULL,NULL,NULL),(8588,381,9.6,126.6,NULL,NULL,NULL,NULL),(8589,381,19.6,140.9,NULL,NULL,NULL,NULL),(8590,381,29.6,149,NULL,NULL,NULL,NULL),(8591,381,39.6,152.4,NULL,NULL,NULL,NULL),(8592,382,1,107.2,NULL,NULL,NULL,NULL),(8593,382,4,126.6,NULL,NULL,NULL,NULL),(8594,382,9.4,141.6,NULL,NULL,NULL,NULL),(8595,382,19.4,153.1,NULL,NULL,NULL,NULL),(8596,382,29.4,156,NULL,NULL,NULL,NULL),(8597,382,39.4,157.1,NULL,NULL,NULL,NULL),(8598,383,0.4,83,NULL,NULL,NULL,NULL),(8599,383,1.4,122.5,NULL,NULL,NULL,NULL),(8600,383,2.4,130.5,NULL,NULL,NULL,NULL),(8601,383,4.4,137.5,NULL,NULL,NULL,NULL),(8602,383,10,147.5,NULL,NULL,NULL,NULL),(8603,383,20,157.8,NULL,NULL,NULL,NULL),(8604,383,30,162.5,NULL,NULL,NULL,NULL),(8605,383,40,165,NULL,NULL,NULL,NULL),(8606,384,1,88.1,NULL,NULL,NULL,NULL),(8607,384,2,97.7,NULL,NULL,NULL,NULL),(8608,384,4,108.2,NULL,NULL,NULL,NULL),(8609,384,9.4,123.3,NULL,NULL,NULL,NULL),(8610,384,19.4,137.2,NULL,NULL,NULL,NULL),(8611,384,29.4,143.5,NULL,NULL,NULL,NULL),(8612,384,39.4,146.2,NULL,NULL,NULL,NULL),(8613,385,1,117.3,NULL,NULL,NULL,NULL),(8614,385,2,132.5,NULL,NULL,NULL,NULL),(8615,385,4,138.7,NULL,NULL,NULL,NULL),(8616,385,9.4,156,NULL,NULL,NULL,NULL),(8617,385,19.4,162.7,NULL,NULL,NULL,NULL),(8618,385,29.4,164,NULL,NULL,NULL,NULL),(8619,385,39.4,166.7,NULL,NULL,NULL,NULL),(8620,386,0.6,148.8,NULL,NULL,NULL,NULL),(8621,386,1.6,168.5,NULL,NULL,NULL,NULL),(8622,386,4.6,182.1,NULL,NULL,NULL,NULL),(8623,386,9.4,196.8,NULL,NULL,NULL,NULL),(8624,386,19.4,212,NULL,NULL,NULL,NULL),(8625,386,29.4,218.9,NULL,NULL,NULL,NULL),(8626,386,39.4,221.2,NULL,NULL,NULL,NULL),(8627,387,0.6,149.3,NULL,NULL,NULL,NULL),(8628,387,1.6,182.9,NULL,NULL,NULL,NULL),(8629,387,4.6,196.8,NULL,NULL,NULL,NULL),(8630,387,9.4,213.3,NULL,NULL,NULL,NULL),(8631,387,19.4,225.9,NULL,NULL,NULL,NULL),(8632,387,29.4,232.8,NULL,NULL,NULL,NULL),(8633,387,39.4,233.3,NULL,NULL,NULL,NULL),(8634,388,1,66.1,NULL,NULL,NULL,NULL),(8635,388,4,84.7,NULL,NULL,NULL,NULL),(8636,388,9.4,101.2,NULL,NULL,NULL,NULL),(8637,388,19.4,116.5,NULL,NULL,NULL,NULL),(8638,388,29.4,126.6,NULL,NULL,NULL,NULL),(8639,388,39.4,129.6,NULL,NULL,NULL,NULL),(8640,389,0.0551,28.4,NULL,NULL,NULL,NULL),(8641,389,1,37.5,NULL,NULL,NULL,NULL),(8642,389,2,40.1,NULL,NULL,NULL,NULL),(8643,389,3,41.7,NULL,NULL,NULL,NULL),(8644,389,4,44.3,NULL,NULL,NULL,NULL),(8645,389,5,45.2,NULL,NULL,NULL,NULL),(8646,389,6,46.5,NULL,NULL,NULL,NULL),(8647,389,14,54.2,NULL,NULL,NULL,NULL),(8648,389,21,58.2,NULL,NULL,NULL,NULL),(8649,389,28,62.4,NULL,NULL,NULL,NULL),(8650,389,49,67.1,NULL,NULL,NULL,NULL),(8651,389,63,71.8,NULL,NULL,NULL,NULL),(8652,389,84,74.6,NULL,NULL,NULL,NULL),(8653,389,112,77.6,NULL,NULL,NULL,NULL),(8654,389,140,80.1,NULL,NULL,NULL,NULL),(8655,389,180,82.8,NULL,NULL,NULL,NULL),(8656,389,210,85.5,NULL,NULL,NULL,NULL),(8657,389,231,86.1,NULL,NULL,NULL,NULL),(8658,389,259,88.2,NULL,NULL,NULL,NULL),(8659,389,301,90.3,NULL,NULL,NULL,NULL),(8660,389,336,91.9,NULL,NULL,NULL,NULL),(8661,389,364,92.7,NULL,NULL,NULL,NULL),(8662,389,427,90.2,NULL,NULL,NULL,NULL),(8663,390,0.177,26.2,NULL,NULL,NULL,NULL),(8664,390,1,28.8,NULL,NULL,NULL,NULL),(8665,390,2,30.1,NULL,NULL,NULL,NULL),(8666,390,3,30.7,NULL,NULL,NULL,NULL),(8667,390,4,33.9,NULL,NULL,NULL,NULL),(8668,390,5,34.2,NULL,NULL,NULL,NULL),(8669,390,6,34.5,NULL,NULL,NULL,NULL),(8670,390,14,39.1,NULL,NULL,NULL,NULL),(8671,390,21,40.9,NULL,NULL,NULL,NULL),(8672,390,28,43.5,NULL,NULL,NULL,NULL),(8673,390,49,47.1,NULL,NULL,NULL,NULL),(8674,390,63,48.3,NULL,NULL,NULL,NULL),(8675,390,84,50.4,NULL,NULL,NULL,NULL),(8676,390,112,52.1,NULL,NULL,NULL,NULL),(8677,390,140,53.8,NULL,NULL,NULL,NULL),(8678,390,180,55.5,NULL,NULL,NULL,NULL),(8679,390,210,58.5,NULL,NULL,NULL,NULL),(8680,390,231,58.6,NULL,NULL,NULL,NULL),(8681,390,259,59.5,NULL,NULL,NULL,NULL),(8682,390,301,63.1,NULL,NULL,NULL,NULL),(8683,390,336,66,NULL,NULL,NULL,NULL),(8684,390,364,66.1,NULL,NULL,NULL,NULL),(8685,390,427,68,NULL,NULL,NULL,NULL),(8686,391,0.0545,22.9,NULL,NULL,NULL,NULL),(8687,391,1,25.7,NULL,NULL,NULL,NULL),(8688,391,2,26.2,NULL,NULL,NULL,NULL),(8689,391,3,27,NULL,NULL,NULL,NULL),(8690,391,4,28.5,NULL,NULL,NULL,NULL),(8691,391,5,28.7,NULL,NULL,NULL,NULL),(8692,391,6,28.8,NULL,NULL,NULL,NULL),(8693,391,14,32,NULL,NULL,NULL,NULL),(8694,391,21,33.5,NULL,NULL,NULL,NULL),(8695,391,28,35.4,NULL,NULL,NULL,NULL),(8696,391,49,37.2,NULL,NULL,NULL,NULL),(8697,391,63,38.7,NULL,NULL,NULL,NULL),(8698,391,84,39.3,NULL,NULL,NULL,NULL),(8699,391,112,40.7,NULL,NULL,NULL,NULL),(8700,391,140,41.7,NULL,NULL,NULL,NULL),(8701,391,180,42.4,NULL,NULL,NULL,NULL),(8702,391,210,42.9,NULL,NULL,NULL,NULL),(8703,391,231,43.9,NULL,NULL,NULL,NULL),(8704,391,259,43.5,NULL,NULL,NULL,NULL),(8705,391,301,45.1,NULL,NULL,NULL,NULL),(8706,391,336,46.3,NULL,NULL,NULL,NULL),(8707,391,364,48.7,NULL,NULL,NULL,NULL),(8708,391,427,46.4,NULL,NULL,NULL,NULL),(8709,392,0.161,25.8,NULL,NULL,NULL,NULL),(8710,392,1,28.4,NULL,NULL,NULL,NULL),(8711,392,2,29.1,NULL,NULL,NULL,NULL),(8712,392,3,30.2,NULL,NULL,NULL,NULL),(8713,392,4,31,NULL,NULL,NULL,NULL),(8714,392,5,31.4,NULL,NULL,NULL,NULL),(8715,392,6,31.8,NULL,NULL,NULL,NULL),(8716,392,14,35.8,NULL,NULL,NULL,NULL),(8717,392,21,37,NULL,NULL,NULL,NULL),(8718,392,28,38.8,NULL,NULL,NULL,NULL),(8719,392,49,40.9,NULL,NULL,NULL,NULL),(8720,392,63,41.5,NULL,NULL,NULL,NULL),(8721,392,84,42.5,NULL,NULL,NULL,NULL),(8722,392,112,43.9,NULL,NULL,NULL,NULL),(8723,392,140,45.5,NULL,NULL,NULL,NULL),(8724,392,180,46,NULL,NULL,NULL,NULL),(8725,392,210,47.1,NULL,NULL,NULL,NULL),(8726,392,231,47.2,NULL,NULL,NULL,NULL),(8727,392,259,47.7,NULL,NULL,NULL,NULL),(8728,392,301,49,NULL,NULL,NULL,NULL),(8729,392,336,50,NULL,NULL,NULL,NULL),(8730,392,364,50.4,NULL,NULL,NULL,NULL),(8731,392,427,51,NULL,NULL,NULL,NULL),(8732,393,0.08,71.2,NULL,NULL,NULL,NULL),(8733,393,0.28,75.8,NULL,NULL,NULL,NULL),(8734,393,0.48,77.8,NULL,NULL,NULL,NULL),(8735,393,0.68,79.5,NULL,NULL,NULL,NULL),(8736,393,0.88,80.8,NULL,NULL,NULL,NULL),(8737,393,1.08,81.6,NULL,NULL,NULL,NULL),(8738,393,1.28,82.5,NULL,NULL,NULL,NULL),(8739,393,1.48,83,NULL,NULL,NULL,NULL),(8740,393,1.68,83.5,NULL,NULL,NULL,NULL),(8741,393,1.88,84,NULL,NULL,NULL,NULL),(8742,393,2.38,84.8,NULL,NULL,NULL,NULL),(8743,393,2.88,85.5,NULL,NULL,NULL,NULL),(8744,393,3.38,85.8,NULL,NULL,NULL,NULL),(8745,394,0.08,38.6,NULL,NULL,NULL,NULL),(8746,394,0.28,56.1,NULL,NULL,NULL,NULL),(8747,394,0.48,62.3,NULL,NULL,NULL,NULL),(8748,394,0.68,66.7,NULL,NULL,NULL,NULL),(8749,394,0.88,67.7,NULL,NULL,NULL,NULL),(8750,394,1.08,69.6,NULL,NULL,NULL,NULL),(8751,394,1.28,70.7,NULL,NULL,NULL,NULL),(8752,394,1.48,71.6,NULL,NULL,NULL,NULL),(8753,394,1.68,72.6,NULL,NULL,NULL,NULL),(8754,394,1.88,73.2,NULL,NULL,NULL,NULL),(8755,394,2.38,74.5,NULL,NULL,NULL,NULL),(8756,394,2.88,75.9,NULL,NULL,NULL,NULL),(8757,394,3.38,76.9,NULL,NULL,NULL,NULL),(8758,395,0.1,80.8,NULL,NULL,NULL,NULL),(8759,395,0.3,85.7,NULL,NULL,NULL,NULL),(8760,395,0.5,87.7,NULL,NULL,NULL,NULL),(8761,395,0.7,89.3,NULL,NULL,NULL,NULL),(8762,395,0.9,90.3,NULL,NULL,NULL,NULL),(8763,395,1.1,91.3,NULL,NULL,NULL,NULL),(8764,395,1.3,92.4,NULL,NULL,NULL,NULL),(8765,395,1.5,93.3,NULL,NULL,NULL,NULL),(8766,395,1.7,94.3,NULL,NULL,NULL,NULL),(8767,395,1.9,94.8,NULL,NULL,NULL,NULL),(8768,395,2.4,95,NULL,NULL,NULL,NULL),(8769,395,2.9,96.2,NULL,NULL,NULL,NULL),(8770,396,0.08,37.3,NULL,NULL,NULL,NULL),(8771,396,0.28,62.4,NULL,NULL,NULL,NULL),(8772,396,0.48,86.5,NULL,NULL,NULL,NULL),(8773,396,0.68,110.4,NULL,NULL,NULL,NULL),(8774,396,0.88,119.6,NULL,NULL,NULL,NULL),(8775,396,1.08,123.8,NULL,NULL,NULL,NULL),(8776,396,1.28,126.2,NULL,NULL,NULL,NULL),(8777,396,1.48,127.3,NULL,NULL,NULL,NULL),(8778,396,1.68,128.2,NULL,NULL,NULL,NULL),(8779,396,1.88,128.9,NULL,NULL,NULL,NULL),(8780,396,2.38,130.9,NULL,NULL,NULL,NULL),(8781,396,2.88,131,NULL,NULL,NULL,NULL),(8782,397,0.29,87.9,NULL,NULL,NULL,NULL),(8783,397,0.49,88.9,NULL,NULL,NULL,NULL),(8784,397,0.69,96.9,NULL,NULL,NULL,NULL),(8785,397,0.89,99.6,NULL,NULL,NULL,NULL),(8786,397,1.09,102.3,NULL,NULL,NULL,NULL),(8787,397,1.29,103.9,NULL,NULL,NULL,NULL),(8788,397,1.49,106.2,NULL,NULL,NULL,NULL),(8789,397,1.69,107.5,NULL,NULL,NULL,NULL),(8790,397,1.89,108.8,NULL,NULL,NULL,NULL),(8791,397,2.09,110,NULL,NULL,NULL,NULL),(8792,397,2.59,111.9,NULL,NULL,NULL,NULL),(8793,398,0.08,37,NULL,NULL,NULL,NULL),(8794,398,0.28,63,NULL,NULL,NULL,NULL),(8795,398,0.48,83.4,NULL,NULL,NULL,NULL),(8796,398,0.68,96.7,NULL,NULL,NULL,NULL),(8797,398,0.88,111.4,NULL,NULL,NULL,NULL),(8798,398,1.08,113.5,NULL,NULL,NULL,NULL),(8799,398,1.28,114.4,NULL,NULL,NULL,NULL),(8800,398,1.48,115.2,NULL,NULL,NULL,NULL),(8801,398,1.68,115,NULL,NULL,NULL,NULL),(8802,398,1.88,115.4,NULL,NULL,NULL,NULL),(8803,398,2.38,116.9,NULL,NULL,NULL,NULL),(8804,399,0.32,53.9,NULL,NULL,NULL,NULL),(8805,399,0.52,56.9,NULL,NULL,NULL,NULL),(8806,399,0.72,58.4,NULL,NULL,NULL,NULL),(8807,399,0.92,61.8,NULL,NULL,NULL,NULL),(8808,399,1.12,63.6,NULL,NULL,NULL,NULL),(8809,399,1.32,65.2,NULL,NULL,NULL,NULL),(8810,399,1.52,66.4,NULL,NULL,NULL,NULL),(8811,399,1.72,67.3,NULL,NULL,NULL,NULL),(8812,399,1.92,68.5,NULL,NULL,NULL,NULL),(8813,399,2.12,69.6,NULL,NULL,NULL,NULL),(8814,399,2.62,71.9,NULL,NULL,NULL,NULL),(8815,400,0.08,163,NULL,NULL,NULL,NULL),(8816,400,0.28,199.8,NULL,NULL,NULL,NULL),(8817,400,0.48,205.2,NULL,NULL,NULL,NULL),(8818,400,0.68,208.8,NULL,NULL,NULL,NULL),(8819,400,0.88,211.6,NULL,NULL,NULL,NULL),(8820,400,1.08,213.6,NULL,NULL,NULL,NULL),(8821,400,1.28,215.3,NULL,NULL,NULL,NULL),(8822,400,1.48,216.6,NULL,NULL,NULL,NULL),(8823,400,1.68,217.9,NULL,NULL,NULL,NULL),(8824,400,1.88,218.8,NULL,NULL,NULL,NULL),(8825,400,2.38,220.7,NULL,NULL,NULL,NULL),(8826,401,0.08,110.2,NULL,NULL,NULL,NULL),(8827,401,0.28,119.2,NULL,NULL,NULL,NULL),(8828,401,0.48,123.5,NULL,NULL,NULL,NULL),(8829,401,0.68,127.3,NULL,NULL,NULL,NULL),(8830,401,0.88,129.8,NULL,NULL,NULL,NULL),(8831,401,1.08,131.7,NULL,NULL,NULL,NULL),(8832,401,1.28,133.5,NULL,NULL,NULL,NULL),(8833,401,1.48,134.6,NULL,NULL,NULL,NULL),(8834,401,1.68,135.9,NULL,NULL,NULL,NULL),(8835,401,1.88,137.7,NULL,NULL,NULL,NULL),(8836,401,2.38,138.3,NULL,NULL,NULL,NULL),(8837,401,2.88,139.6,NULL,NULL,NULL,NULL),(8838,402,0.08,36.9,NULL,NULL,NULL,NULL),(8839,402,0.28,51.1,NULL,NULL,NULL,NULL),(8840,402,0.48,63,NULL,NULL,NULL,NULL),(8841,402,0.68,84.8,NULL,NULL,NULL,NULL),(8842,402,0.88,94.2,NULL,NULL,NULL,NULL),(8843,402,1.08,99.2,NULL,NULL,NULL,NULL),(8844,402,1.28,102,NULL,NULL,NULL,NULL),(8845,402,1.48,103.4,NULL,NULL,NULL,NULL),(8846,402,1.68,104.4,NULL,NULL,NULL,NULL),(8847,402,1.88,105.7,NULL,NULL,NULL,NULL),(8848,402,2.38,108.1,NULL,NULL,NULL,NULL),(8849,402,2.88,109.3,NULL,NULL,NULL,NULL),(8850,403,0.08,67.9,NULL,NULL,NULL,NULL),(8851,403,0.28,73.3,NULL,NULL,NULL,NULL),(8852,403,0.48,75.9,NULL,NULL,NULL,NULL),(8853,403,0.68,77.7,NULL,NULL,NULL,NULL),(8854,403,0.88,79.2,NULL,NULL,NULL,NULL),(8855,403,1.08,80.6,NULL,NULL,NULL,NULL),(8856,403,1.28,81.3,NULL,NULL,NULL,NULL),(8857,403,1.48,81.6,NULL,NULL,NULL,NULL),(8858,403,1.68,82.8,NULL,NULL,NULL,NULL),(8859,403,1.88,83.8,NULL,NULL,NULL,NULL),(8860,403,2.38,85.5,NULL,NULL,NULL,NULL),(8861,403,2.88,86.9,NULL,NULL,NULL,NULL),(8862,404,0.08,43.1,NULL,NULL,NULL,NULL),(8863,404,0.28,63.4,NULL,NULL,NULL,NULL),(8864,404,0.48,87.1,NULL,NULL,NULL,NULL),(8865,404,0.68,137.2,NULL,NULL,NULL,NULL),(8866,404,0.88,152.1,NULL,NULL,NULL,NULL),(8867,404,1.08,156.9,NULL,NULL,NULL,NULL),(8868,404,1.28,159.9,NULL,NULL,NULL,NULL),(8869,404,1.48,159.1,NULL,NULL,NULL,NULL),(8870,404,1.68,159.8,NULL,NULL,NULL,NULL),(8871,404,1.88,162.5,NULL,NULL,NULL,NULL),(8872,404,2.38,163.4,NULL,NULL,NULL,NULL),(8873,404,2.88,164.3,NULL,NULL,NULL,NULL),(8874,405,0.32,16.1,NULL,NULL,NULL,NULL),(8875,405,0.52,15.9,NULL,NULL,NULL,NULL),(8876,405,0.72,15.6,NULL,NULL,NULL,NULL),(8877,405,0.92,15.9,NULL,NULL,NULL,NULL),(8878,405,1.12,16,NULL,NULL,NULL,NULL),(8879,405,1.32,18.2,NULL,NULL,NULL,NULL),(8880,405,1.52,17.4,NULL,NULL,NULL,NULL),(8881,405,1.72,18.3,NULL,NULL,NULL,NULL),(8882,405,1.92,19.2,NULL,NULL,NULL,NULL),(8883,405,2.12,18.6,NULL,NULL,NULL,NULL),(8884,405,2.62,22.5,NULL,NULL,NULL,NULL),(8885,405,3.12,21.3,NULL,NULL,NULL,NULL),(8886,405,3.62,20.2,NULL,NULL,NULL,NULL),(8887,406,0.08,109.2,NULL,NULL,NULL,NULL),(8888,406,0.28,124,NULL,NULL,NULL,NULL),(8889,406,0.48,135.3,NULL,NULL,NULL,NULL),(8890,406,0.68,139,NULL,NULL,NULL,NULL),(8891,406,0.88,141.4,NULL,NULL,NULL,NULL),(8892,406,1.08,143.5,NULL,NULL,NULL,NULL),(8893,406,1.28,144.4,NULL,NULL,NULL,NULL),(8894,406,1.48,145.4,NULL,NULL,NULL,NULL),(8895,406,1.68,146.7,NULL,NULL,NULL,NULL),(8896,406,1.88,147.7,NULL,NULL,NULL,NULL),(8897,406,2.38,149.8,NULL,NULL,NULL,NULL),(8898,406,2.88,153.1,NULL,NULL,NULL,NULL),(8899,406,3.38,154.7,NULL,NULL,NULL,NULL),(8900,407,0.23,66.4,NULL,NULL,NULL,NULL),(8901,407,0.43,72.2,NULL,NULL,NULL,NULL),(8902,407,0.63,75,NULL,NULL,NULL,NULL),(8903,407,0.83,77.9,NULL,NULL,NULL,NULL),(8904,407,1.03,82.1,NULL,NULL,NULL,NULL),(8905,407,1.23,84,NULL,NULL,NULL,NULL),(8906,407,1.43,87,NULL,NULL,NULL,NULL),(8907,407,1.63,87.9,NULL,NULL,NULL,NULL),(8908,407,1.83,89.7,NULL,NULL,NULL,NULL),(8909,407,2.03,90.6,NULL,NULL,NULL,NULL),(8910,407,2.53,92.1,NULL,NULL,NULL,NULL),(8911,407,3.03,96.1,NULL,NULL,NULL,NULL),(8912,407,3.53,97.5,NULL,NULL,NULL,NULL),(8913,408,0.08,58.8,NULL,NULL,NULL,NULL),(8914,408,0.28,89.2,NULL,NULL,NULL,NULL),(8915,408,0.48,118.7,NULL,NULL,NULL,NULL),(8916,408,0.68,155.8,NULL,NULL,NULL,NULL),(8917,408,0.88,171.7,NULL,NULL,NULL,NULL),(8918,408,1.08,180.6,NULL,NULL,NULL,NULL),(8919,408,1.28,186.8,NULL,NULL,NULL,NULL),(8920,408,1.48,192.2,NULL,NULL,NULL,NULL),(8921,408,1.68,197.4,NULL,NULL,NULL,NULL),(8922,408,1.88,199.8,NULL,NULL,NULL,NULL),(8923,408,2.38,207.6,NULL,NULL,NULL,NULL),(8924,408,2.88,212,NULL,NULL,NULL,NULL),(8925,408,3.38,217.8,NULL,NULL,NULL,NULL),(8926,409,0.18,46.5,NULL,NULL,NULL,NULL),(8927,409,0.38,49.1,NULL,NULL,NULL,NULL),(8928,409,0.58,50.5,NULL,NULL,NULL,NULL),(8929,409,0.78,52.2,NULL,NULL,NULL,NULL),(8930,409,0.98,53.2,NULL,NULL,NULL,NULL),(8931,409,1.18,53.9,NULL,NULL,NULL,NULL),(8932,409,1.38,54.8,NULL,NULL,NULL,NULL),(8933,409,1.58,55.3,NULL,NULL,NULL,NULL),(8934,409,1.78,55.9,NULL,NULL,NULL,NULL),(8935,409,1.98,56.3,NULL,NULL,NULL,NULL),(8936,409,2.48,57.2,NULL,NULL,NULL,NULL),(8937,409,2.98,57.7,NULL,NULL,NULL,NULL),(8938,410,0.08,157.9,NULL,NULL,NULL,NULL),(8939,410,0.28,202,NULL,NULL,NULL,NULL),(8940,410,0.48,237.5,NULL,NULL,NULL,NULL),(8941,410,0.68,297.2,NULL,NULL,NULL,NULL),(8942,410,0.88,334.9,NULL,NULL,NULL,NULL),(8943,410,1.08,356,NULL,NULL,NULL,NULL),(8944,410,1.28,367.5,NULL,NULL,NULL,NULL),(8945,410,1.48,370.9,NULL,NULL,NULL,NULL),(8946,410,1.68,376.6,NULL,NULL,NULL,NULL),(8947,410,1.88,380.9,NULL,NULL,NULL,NULL),(8948,410,2.38,389.1,NULL,NULL,NULL,NULL),(8949,410,2.88,394.2,NULL,NULL,NULL,NULL),(8950,411,1,20.5,NULL,NULL,NULL,NULL),(8951,411,2,26.6,NULL,NULL,NULL,NULL),(8952,411,8,27.4,NULL,NULL,NULL,NULL),(8953,411,9,27.5,NULL,NULL,NULL,NULL),(8954,411,12,28.5,NULL,NULL,NULL,NULL),(8955,411,15,30.5,NULL,NULL,NULL,NULL),(8956,411,20,30.2,NULL,NULL,NULL,NULL),(8957,411,22,31.1,NULL,NULL,NULL,NULL),(8958,411,26,31.4,NULL,NULL,NULL,NULL),(8959,411,30,31.4,NULL,NULL,NULL,NULL),(8960,411,33,31.6,NULL,NULL,NULL,NULL),(8961,411,35,32.6,NULL,NULL,NULL,NULL),(8962,411,54,35.1,NULL,NULL,NULL,NULL),(8963,411,70,35.6,NULL,NULL,NULL,NULL),(8964,411,82,36.5,NULL,NULL,NULL,NULL),(8965,411,105,36.6,NULL,NULL,NULL,NULL),(8966,411,110,36.5,NULL,NULL,NULL,NULL),(8967,411,145,36.6,NULL,NULL,NULL,NULL),(8968,411,162,37.1,NULL,NULL,NULL,NULL),(8969,411,236,38.5,NULL,NULL,NULL,NULL),(8970,412,1,20.5,NULL,NULL,NULL,NULL),(8971,412,2,34.7,NULL,NULL,NULL,NULL),(8972,412,8,37.9,NULL,NULL,NULL,NULL),(8973,412,9,38.4,NULL,NULL,NULL,NULL),(8974,412,12,40.5,NULL,NULL,NULL,NULL),(8975,412,15,42.3,NULL,NULL,NULL,NULL),(8976,412,20,43.5,NULL,NULL,NULL,NULL),(8977,412,22,45.1,NULL,NULL,NULL,NULL),(8978,412,26,44.5,NULL,NULL,NULL,NULL),(8979,412,30,44.8,NULL,NULL,NULL,NULL),(8980,412,33,46.6,NULL,NULL,NULL,NULL),(8981,412,35,45.8,NULL,NULL,NULL,NULL),(8982,412,54,49,NULL,NULL,NULL,NULL),(8983,412,70,50,NULL,NULL,NULL,NULL),(8984,412,82,52.5,NULL,NULL,NULL,NULL),(8985,412,105,53.8,NULL,NULL,NULL,NULL),(8986,412,110,54.2,NULL,NULL,NULL,NULL),(8987,412,145,55.2,NULL,NULL,NULL,NULL),(8988,412,162,55.3,NULL,NULL,NULL,NULL),(8989,412,236,57.9,NULL,NULL,NULL,NULL),(8990,413,1,23.8,NULL,NULL,NULL,NULL),(8991,413,5,25.5,NULL,NULL,NULL,NULL),(8992,413,6,27.5,NULL,NULL,NULL,NULL),(8993,413,8,30,NULL,NULL,NULL,NULL),(8994,413,13,31.2,NULL,NULL,NULL,NULL),(8995,413,26,32.3,NULL,NULL,NULL,NULL),(8996,413,36,32.9,NULL,NULL,NULL,NULL),(8997,413,75,35.6,NULL,NULL,NULL,NULL),(8998,413,89,36.1,NULL,NULL,NULL,NULL),(8999,413,92,36.1,NULL,NULL,NULL,NULL),(9000,413,152,37.5,NULL,NULL,NULL,NULL),(9001,413,222,39.4,NULL,NULL,NULL,NULL),(9002,414,1,27.5,NULL,NULL,NULL,NULL),(9003,414,2,29.9,NULL,NULL,NULL,NULL),(9004,414,6,30.3,NULL,NULL,NULL,NULL),(9005,414,12,33.7,NULL,NULL,NULL,NULL),(9006,414,16,34.7,NULL,NULL,NULL,NULL),(9007,414,19,35,NULL,NULL,NULL,NULL),(9008,414,21,35.4,NULL,NULL,NULL,NULL),(9009,414,40,38.6,NULL,NULL,NULL,NULL),(9010,414,56,37.5,NULL,NULL,NULL,NULL),(9011,414,68,38.9,NULL,NULL,NULL,NULL),(9012,414,91,40,NULL,NULL,NULL,NULL),(9013,414,96,39.1,NULL,NULL,NULL,NULL),(9014,414,131,40.3,NULL,NULL,NULL,NULL),(9015,414,148,40.7,NULL,NULL,NULL,NULL),(9016,414,222,42.1,NULL,NULL,NULL,NULL),(9017,414,236,42.7,NULL,NULL,NULL,NULL),(9018,415,1,32.5,NULL,NULL,NULL,NULL),(9019,415,2,37.2,NULL,NULL,NULL,NULL),(9020,415,6,40,NULL,NULL,NULL,NULL),(9021,415,12,44.9,NULL,NULL,NULL,NULL),(9022,415,16,47.1,NULL,NULL,NULL,NULL),(9023,415,19,46.2,NULL,NULL,NULL,NULL),(9024,415,21,46.9,NULL,NULL,NULL,NULL),(9025,415,40,52.1,NULL,NULL,NULL,NULL),(9026,415,56,54,NULL,NULL,NULL,NULL),(9027,415,68,55.6,NULL,NULL,NULL,NULL),(9028,415,91,58.2,NULL,NULL,NULL,NULL),(9029,415,96,57.8,NULL,NULL,NULL,NULL),(9030,415,131,60.4,NULL,NULL,NULL,NULL),(9031,415,148,61,NULL,NULL,NULL,NULL),(9032,415,222,62.8,NULL,NULL,NULL,NULL),(9033,415,236,64.4,NULL,NULL,NULL,NULL),(9034,416,1,25.2,NULL,NULL,NULL,NULL),(9035,416,3,25.5,NULL,NULL,NULL,NULL),(9036,416,6,26.4,NULL,NULL,NULL,NULL),(9037,416,8,27.1,NULL,NULL,NULL,NULL),(9038,416,13,27.7,NULL,NULL,NULL,NULL),(9039,416,20,28.5,NULL,NULL,NULL,NULL),(9040,416,27,29.7,NULL,NULL,NULL,NULL),(9041,416,43,29.7,NULL,NULL,NULL,NULL),(9042,416,55,30.1,NULL,NULL,NULL,NULL),(9043,416,78,30,NULL,NULL,NULL,NULL),(9044,416,83,30.6,NULL,NULL,NULL,NULL),(9045,416,101,30.3,NULL,NULL,NULL,NULL),(9046,416,118,31.2,NULL,NULL,NULL,NULL),(9047,416,135,31.3,NULL,NULL,NULL,NULL),(9048,416,209,31.6,NULL,NULL,NULL,NULL),(9049,416,226,31,NULL,NULL,NULL,NULL),(9050,417,1,26.7,NULL,NULL,NULL,NULL),(9051,417,3,26.8,NULL,NULL,NULL,NULL),(9052,417,6,27.6,NULL,NULL,NULL,NULL),(9053,417,8,28.4,NULL,NULL,NULL,NULL),(9054,417,13,29.9,NULL,NULL,NULL,NULL),(9055,417,20,30.3,NULL,NULL,NULL,NULL),(9056,417,27,32.2,NULL,NULL,NULL,NULL),(9057,417,43,33.1,NULL,NULL,NULL,NULL),(9058,417,55,32.6,NULL,NULL,NULL,NULL),(9059,417,78,33.5,NULL,NULL,NULL,NULL),(9060,417,83,33.5,NULL,NULL,NULL,NULL),(9061,417,101,34.5,NULL,NULL,NULL,NULL),(9062,417,135,34.9,NULL,NULL,NULL,NULL),(9063,417,147,35.2,NULL,NULL,NULL,NULL),(9064,417,209,36.2,NULL,NULL,NULL,NULL),(9065,417,226,36.5,NULL,NULL,NULL,NULL),(9066,418,1,21.4,NULL,NULL,NULL,NULL),(9067,418,7,22.8,NULL,NULL,NULL,NULL),(9068,418,8,22.8,NULL,NULL,NULL,NULL),(9069,418,11,23.3,NULL,NULL,NULL,NULL),(9070,418,14,23.9,NULL,NULL,NULL,NULL),(9071,418,19,24.9,NULL,NULL,NULL,NULL),(9072,418,25,25.2,NULL,NULL,NULL,NULL),(9073,418,29,25.1,NULL,NULL,NULL,NULL),(9074,418,32,24.4,NULL,NULL,NULL,NULL),(9075,418,34,25.5,NULL,NULL,NULL,NULL),(9076,418,53,26.2,NULL,NULL,NULL,NULL),(9077,418,104,27.4,NULL,NULL,NULL,NULL),(9078,418,109,27.3,NULL,NULL,NULL,NULL),(9079,418,144,28.6,NULL,NULL,NULL,NULL),(9080,418,235,29,NULL,NULL,NULL,NULL),(9081,419,1,23.7,NULL,NULL,NULL,NULL),(9082,419,7,25.8,NULL,NULL,NULL,NULL),(9083,419,8,25.8,NULL,NULL,NULL,NULL),(9084,419,14,27.4,NULL,NULL,NULL,NULL),(9085,419,19,27.4,NULL,NULL,NULL,NULL),(9086,419,25,28.9,NULL,NULL,NULL,NULL),(9087,419,29,29.7,NULL,NULL,NULL,NULL),(9088,419,53,30.6,NULL,NULL,NULL,NULL),(9089,419,81,31.6,NULL,NULL,NULL,NULL),(9090,419,104,32.1,NULL,NULL,NULL,NULL),(9091,419,144,32.7,NULL,NULL,NULL,NULL),(9092,419,161,32.9,NULL,NULL,NULL,NULL),(9093,419,235,34.5,NULL,NULL,NULL,NULL),(9094,420,1,23.6,NULL,NULL,NULL,NULL),(9095,420,6,24.9,NULL,NULL,NULL,NULL),(9096,420,8,25.6,NULL,NULL,NULL,NULL),(9097,420,10,26,NULL,NULL,NULL,NULL),(9098,420,13,26.5,NULL,NULL,NULL,NULL),(9099,420,24,27.6,NULL,NULL,NULL,NULL),(9100,420,31,28.5,NULL,NULL,NULL,NULL),(9101,420,65,29.6,NULL,NULL,NULL,NULL),(9102,420,139,30.6,NULL,NULL,NULL,NULL),(9103,421,1,23.9,NULL,NULL,NULL,NULL),(9104,421,2,24.5,NULL,NULL,NULL,NULL),(9105,421,5,24.5,NULL,NULL,NULL,NULL),(9106,421,8,26.5,NULL,NULL,NULL,NULL),(9107,421,13,27.3,NULL,NULL,NULL,NULL),(9108,421,26,27.8,NULL,NULL,NULL,NULL),(9109,421,36,28.5,NULL,NULL,NULL,NULL),(9110,421,75,30,NULL,NULL,NULL,NULL),(9111,421,89,30.7,NULL,NULL,NULL,NULL),(9112,421,92,30.9,NULL,NULL,NULL,NULL),(9113,421,152,33.7,NULL,NULL,NULL,NULL),(9114,421,222,32.5,NULL,NULL,NULL,NULL),(9115,422,1,31.8,NULL,NULL,NULL,NULL),(9116,422,2,32,NULL,NULL,NULL,NULL),(9117,422,11,39.1,NULL,NULL,NULL,NULL),(9118,422,14,41,NULL,NULL,NULL,NULL),(9119,422,35,44.7,NULL,NULL,NULL,NULL),(9120,422,42,46.5,NULL,NULL,NULL,NULL),(9121,422,60,49,NULL,NULL,NULL,NULL),(9122,422,77,50.6,NULL,NULL,NULL,NULL),(9123,422,94,50.9,NULL,NULL,NULL,NULL),(9124,422,168,56.3,NULL,NULL,NULL,NULL),(9125,422,204,57.2,NULL,NULL,NULL,NULL),(9126,422,231,59.2,NULL,NULL,NULL,NULL),(9127,423,1,39.6,NULL,NULL,NULL,NULL),(9128,423,2,41.6,NULL,NULL,NULL,NULL),(9129,423,11,54.1,NULL,NULL,NULL,NULL),(9130,423,14,56,NULL,NULL,NULL,NULL),(9131,423,35,64.5,NULL,NULL,NULL,NULL),(9132,423,42,66.6,NULL,NULL,NULL,NULL),(9133,423,60,70.1,NULL,NULL,NULL,NULL),(9134,423,77,73.2,NULL,NULL,NULL,NULL),(9135,423,94,75.7,NULL,NULL,NULL,NULL),(9136,423,168,81.8,NULL,NULL,NULL,NULL),(9137,423,204,84,NULL,NULL,NULL,NULL),(9138,423,231,84.8,NULL,NULL,NULL,NULL),(9139,424,1,25.8,NULL,NULL,NULL,NULL),(9140,424,7,28.8,NULL,NULL,NULL,NULL),(9141,424,19,31.6,NULL,NULL,NULL,NULL),(9142,424,40,33.8,NULL,NULL,NULL,NULL),(9143,424,44,34.3,NULL,NULL,NULL,NULL),(9144,424,47,33.9,NULL,NULL,NULL,NULL),(9145,424,82,36,NULL,NULL,NULL,NULL),(9146,424,99,35.9,NULL,NULL,NULL,NULL),(9147,424,173,38,NULL,NULL,NULL,NULL),(9148,424,209,38.1,NULL,NULL,NULL,NULL),(9149,424,236,39.8,NULL,NULL,NULL,NULL),(9150,425,1,26.9,NULL,NULL,NULL,NULL),(9151,425,7,42.5,NULL,NULL,NULL,NULL),(9152,425,19,47.9,NULL,NULL,NULL,NULL),(9153,425,40,52.2,NULL,NULL,NULL,NULL),(9154,425,44,52.4,NULL,NULL,NULL,NULL),(9155,425,47,52.7,NULL,NULL,NULL,NULL),(9156,425,82,56.5,NULL,NULL,NULL,NULL),(9157,425,99,57.3,NULL,NULL,NULL,NULL),(9158,425,173,59.8,NULL,NULL,NULL,NULL),(9159,425,209,59.8,NULL,NULL,NULL,NULL),(9160,425,236,61.8,NULL,NULL,NULL,NULL),(9161,426,1,23.8,NULL,NULL,NULL,NULL),(9162,426,7,26.7,NULL,NULL,NULL,NULL),(9163,426,12,27.5,NULL,NULL,NULL,NULL),(9164,426,14,28.8,NULL,NULL,NULL,NULL),(9165,426,16,28.9,NULL,NULL,NULL,NULL),(9166,426,19,28.9,NULL,NULL,NULL,NULL),(9167,426,37,31.4,NULL,NULL,NULL,NULL),(9168,426,71,33,NULL,NULL,NULL,NULL),(9169,426,145,34.9,NULL,NULL,NULL,NULL),(9170,426,181,35.7,NULL,NULL,NULL,NULL),(9171,426,194,37.1,NULL,NULL,NULL,NULL),(9172,426,243,37.1,NULL,NULL,NULL,NULL),(9173,426,251,36.7,NULL,NULL,NULL,NULL),(9174,427,1,26.2,NULL,NULL,NULL,NULL),(9175,427,2,27.5,NULL,NULL,NULL,NULL),(9176,427,10,30.7,NULL,NULL,NULL,NULL),(9177,427,13,31.2,NULL,NULL,NULL,NULL),(9178,427,16,31.7,NULL,NULL,NULL,NULL),(9179,427,30,32.6,NULL,NULL,NULL,NULL),(9180,427,77,37.6,NULL,NULL,NULL,NULL),(9181,427,153,39.7,NULL,NULL,NULL,NULL),(9182,428,1,21.4,NULL,NULL,NULL,NULL),(9183,428,2,22.4,NULL,NULL,NULL,NULL),(9184,428,10,23.7,NULL,NULL,NULL,NULL),(9185,428,13,24,NULL,NULL,NULL,NULL),(9186,428,16,24.4,NULL,NULL,NULL,NULL),(9187,428,30,24.9,NULL,NULL,NULL,NULL),(9188,428,77,27.4,NULL,NULL,NULL,NULL),(9189,428,154,28.7,NULL,NULL,NULL,NULL),(9190,429,1,24.8,NULL,NULL,NULL,NULL),(9191,429,2,25.8,NULL,NULL,NULL,NULL),(9192,429,5,26.5,NULL,NULL,NULL,NULL),(9193,429,8,27.6,NULL,NULL,NULL,NULL),(9194,429,22,27.6,NULL,NULL,NULL,NULL),(9195,429,69,31.4,NULL,NULL,NULL,NULL),(9196,429,146,32.7,NULL,NULL,NULL,NULL),(9197,430,1,27.2,NULL,NULL,NULL,NULL),(9198,430,3,29.6,NULL,NULL,NULL,NULL),(9199,430,13,33.2,NULL,NULL,NULL,NULL),(9200,430,29,36.3,NULL,NULL,NULL,NULL),(9201,430,44,38.2,NULL,NULL,NULL,NULL),(9202,430,69,39.6,NULL,NULL,NULL,NULL),(9203,430,136,42.6,NULL,NULL,NULL,NULL),(9204,430,178,42.2,NULL,NULL,NULL,NULL),(9205,430,234,43.5,NULL,NULL,NULL,NULL),(9206,430,244,43,NULL,NULL,NULL,NULL),(9207,431,1,22.5,NULL,NULL,NULL,NULL),(9208,431,3,23.6,NULL,NULL,NULL,NULL),(9209,431,13,26.4,NULL,NULL,NULL,NULL),(9210,431,29,28.1,NULL,NULL,NULL,NULL),(9211,431,44,29.2,NULL,NULL,NULL,NULL),(9212,431,69,30.9,NULL,NULL,NULL,NULL),(9213,431,136,32.4,NULL,NULL,NULL,NULL),(9214,431,178,31.9,NULL,NULL,NULL,NULL),(9215,431,234,33.7,NULL,NULL,NULL,NULL),(9216,431,244,33,NULL,NULL,NULL,NULL),(9217,432,1,29,NULL,NULL,NULL,NULL),(9218,432,5,33,NULL,NULL,NULL,NULL),(9219,432,15,37,NULL,NULL,NULL,NULL),(9220,432,40,41,NULL,NULL,NULL,NULL),(9221,432,107,44.8,NULL,NULL,NULL,NULL),(9222,432,149,44.6,NULL,NULL,NULL,NULL),(9223,432,205,45.8,NULL,NULL,NULL,NULL),(9224,432,295,46,NULL,NULL,NULL,NULL),(9225,433,2,20.2,NULL,NULL,NULL,NULL),(9226,433,3,20.4,NULL,NULL,NULL,NULL),(9227,433,6,21.1,NULL,NULL,NULL,NULL),(9228,433,15,21.9,NULL,NULL,NULL,NULL),(9229,433,27,23.1,NULL,NULL,NULL,NULL),(9230,433,50,24.7,NULL,NULL,NULL,NULL),(9231,433,55,24.7,NULL,NULL,NULL,NULL),(9232,433,90,25.5,NULL,NULL,NULL,NULL),(9233,433,107,25.9,NULL,NULL,NULL,NULL),(9234,433,181,27.2,NULL,NULL,NULL,NULL),(9235,433,217,27.6,NULL,NULL,NULL,NULL),(9236,433,224,27.6,NULL,NULL,NULL,NULL),(9237,434,2,21.6,NULL,NULL,NULL,NULL),(9238,434,3,22,NULL,NULL,NULL,NULL),(9239,434,6,22.3,NULL,NULL,NULL,NULL),(9240,434,15,24.9,NULL,NULL,NULL,NULL),(9241,434,27,26.5,NULL,NULL,NULL,NULL),(9242,434,50,27,NULL,NULL,NULL,NULL),(9243,434,55,27.4,NULL,NULL,NULL,NULL),(9244,434,90,28.5,NULL,NULL,NULL,NULL),(9245,434,107,29,NULL,NULL,NULL,NULL),(9246,434,181,29.9,NULL,NULL,NULL,NULL),(9247,434,217,30.5,NULL,NULL,NULL,NULL),(9248,434,244,31,NULL,NULL,NULL,NULL),(9249,435,1,24.3,NULL,NULL,NULL,NULL),(9250,435,6,25.5,NULL,NULL,NULL,NULL),(9251,435,8,25.9,NULL,NULL,NULL,NULL),(9252,435,10,26.6,NULL,NULL,NULL,NULL),(9253,435,13,27,NULL,NULL,NULL,NULL),(9254,435,24,29.2,NULL,NULL,NULL,NULL),(9255,435,31,29.8,NULL,NULL,NULL,NULL),(9256,435,65,31.6,NULL,NULL,NULL,NULL),(9257,435,139,33.4,NULL,NULL,NULL,NULL),(9258,436,1,16.8,NULL,NULL,NULL,NULL),(9259,436,4,19.9,NULL,NULL,NULL,NULL),(9260,436,11,21.2,NULL,NULL,NULL,NULL),(9261,436,19,22.5,NULL,NULL,NULL,NULL),(9262,436,22,22.1,NULL,NULL,NULL,NULL),(9263,436,32,22.6,NULL,NULL,NULL,NULL),(9264,436,48,24,NULL,NULL,NULL,NULL),(9265,436,63,24.2,NULL,NULL,NULL,NULL),(9266,436,88,24.3,NULL,NULL,NULL,NULL),(9267,436,155,26.9,NULL,NULL,NULL,NULL),(9268,437,1,18.2,NULL,NULL,NULL,NULL),(9269,437,2,18.9,NULL,NULL,NULL,NULL),(9270,437,5,19.1,NULL,NULL,NULL,NULL),(9271,437,9,20.3,NULL,NULL,NULL,NULL),(9272,437,22,19.9,NULL,NULL,NULL,NULL),(9273,437,69,22.5,NULL,NULL,NULL,NULL),(9274,437,146,22.9,NULL,NULL,NULL,NULL),(9275,438,1,28.4,NULL,NULL,NULL,NULL),(9276,438,4,31.7,NULL,NULL,NULL,NULL),(9277,438,11,34.4,NULL,NULL,NULL,NULL),(9278,438,19,37.1,NULL,NULL,NULL,NULL),(9279,438,22,37.2,NULL,NULL,NULL,NULL),(9280,438,32,37.7,NULL,NULL,NULL,NULL),(9281,438,48,39.8,NULL,NULL,NULL,NULL),(9282,438,63,41.1,NULL,NULL,NULL,NULL),(9283,438,88,56.1,NULL,NULL,NULL,NULL),(9284,438,155,60.7,NULL,NULL,NULL,NULL),(9285,439,1,20.5,NULL,NULL,NULL,NULL),(9286,439,7,23.8,NULL,NULL,NULL,NULL),(9287,439,12,24.2,NULL,NULL,NULL,NULL),(9288,439,14,24.6,NULL,NULL,NULL,NULL),(9289,439,16,24.8,NULL,NULL,NULL,NULL),(9290,439,19,25.3,NULL,NULL,NULL,NULL),(9291,439,30,26.8,NULL,NULL,NULL,NULL),(9292,439,37,27.9,NULL,NULL,NULL,NULL),(9293,439,71,30,NULL,NULL,NULL,NULL),(9294,439,145,31.7,NULL,NULL,NULL,NULL),(9295,439,181,32.3,NULL,NULL,NULL,NULL),(9296,439,194,33.1,NULL,NULL,NULL,NULL),(9297,439,243,33.7,NULL,NULL,NULL,NULL),(9298,439,251,33.8,NULL,NULL,NULL,NULL),(9299,440,1,30.3,NULL,NULL,NULL,NULL),(9300,440,5,34.8,NULL,NULL,NULL,NULL),(9301,440,15,38.2,NULL,NULL,NULL,NULL),(9302,440,40,39,NULL,NULL,NULL,NULL),(9303,440,107,41.8,NULL,NULL,NULL,NULL),(9304,440,149,41,NULL,NULL,NULL,NULL),(9305,440,205,42.4,NULL,NULL,NULL,NULL),(9306,440,225,41.4,NULL,NULL,NULL,NULL),(9307,440,295,42.3,NULL,NULL,NULL,NULL),(9308,441,1,35.9,NULL,NULL,NULL,NULL),(9309,441,2,37.1,NULL,NULL,NULL,NULL),(9310,441,5,40.7,NULL,NULL,NULL,NULL),(9311,441,8,44.4,NULL,NULL,NULL,NULL),(9312,441,12,44.8,NULL,NULL,NULL,NULL),(9313,441,13,45.3,NULL,NULL,NULL,NULL),(9314,441,29,44,NULL,NULL,NULL,NULL),(9315,441,41,43.9,NULL,NULL,NULL,NULL),(9316,441,47,45.4,NULL,NULL,NULL,NULL),(9317,441,96,50.7,NULL,NULL,NULL,NULL),(9318,441,113,51.2,NULL,NULL,NULL,NULL),(9319,441,173,51.9,NULL,NULL,NULL,NULL),(9320,441,243,53.8,NULL,NULL,NULL,NULL),(9321,441,244,31.9,NULL,1,NULL,NULL),(9322,442,1,37.9,NULL,NULL,NULL,NULL),(9323,442,5,41.5,NULL,NULL,NULL,NULL),(9324,442,8,44.3,NULL,NULL,NULL,NULL),(9325,442,12,43.6,NULL,NULL,NULL,NULL),(9326,442,13,44,NULL,NULL,NULL,NULL),(9327,442,29,43.9,NULL,NULL,NULL,NULL),(9328,442,41,44.7,NULL,NULL,NULL,NULL),(9329,442,47,46,NULL,NULL,NULL,NULL),(9330,442,96,48.4,NULL,NULL,NULL,NULL),(9331,442,113,48.6,NULL,NULL,NULL,NULL),(9332,442,173,49.6,NULL,NULL,NULL,NULL),(9333,442,243,49.7,NULL,NULL,NULL,NULL),(9334,443,1,36.9,NULL,NULL,NULL,NULL),(9335,443,4,42.2,NULL,NULL,NULL,NULL),(9336,443,7,44.5,NULL,NULL,NULL,NULL),(9337,443,11,45.5,NULL,NULL,NULL,NULL),(9338,443,28,45.3,NULL,NULL,NULL,NULL),(9339,443,40,44.8,NULL,NULL,NULL,NULL),(9340,443,46,45.7,NULL,NULL,NULL,NULL),(9341,443,95,50.7,NULL,NULL,NULL,NULL),(9342,443,112,51.3,NULL,NULL,NULL,NULL),(9343,443,173,51.1,NULL,NULL,NULL,NULL),(9344,443,244,52.4,NULL,NULL,NULL,NULL),(9345,444,1,35.1,NULL,NULL,NULL,NULL),(9346,444,4,39.8,NULL,NULL,NULL,NULL),(9347,444,7,40.8,NULL,NULL,NULL,NULL),(9348,444,11,41.5,NULL,NULL,NULL,NULL),(9349,444,28,41.5,NULL,NULL,NULL,NULL),(9350,444,40,41.5,NULL,NULL,NULL,NULL),(9351,444,46,41.6,NULL,NULL,NULL,NULL),(9352,444,95,44.1,NULL,NULL,NULL,NULL),(9353,444,112,44.4,NULL,NULL,NULL,NULL),(9354,444,126,43.9,NULL,NULL,NULL,NULL),(9355,444,173,45.6,NULL,NULL,NULL,NULL),(9356,444,244,46.7,NULL,NULL,NULL,NULL),(9357,445,1,28.3,NULL,NULL,NULL,NULL),(9358,445,2,31.7,NULL,NULL,NULL,NULL),(9359,445,8,35.2,NULL,NULL,NULL,NULL),(9360,445,15,38.7,NULL,NULL,NULL,NULL),(9361,445,22,40.3,NULL,NULL,NULL,NULL),(9362,445,38,42.1,NULL,NULL,NULL,NULL),(9363,445,77,48.7,NULL,NULL,NULL,NULL),(9364,445,94,49.5,NULL,NULL,NULL,NULL),(9365,445,155,51.7,NULL,NULL,NULL,NULL),(9366,445,224,52.6,NULL,NULL,NULL,NULL),(9367,445,226,53,NULL,NULL,NULL,NULL),(9368,446,1,22.1,NULL,NULL,NULL,NULL),(9369,446,2,22.9,NULL,NULL,NULL,NULL),(9370,446,8,24.1,NULL,NULL,NULL,NULL),(9371,446,22,25.7,NULL,NULL,NULL,NULL),(9372,446,38,26.3,NULL,NULL,NULL,NULL),(9373,446,77,29,NULL,NULL,NULL,NULL),(9374,446,94,29.3,NULL,NULL,NULL,NULL),(9375,446,155,30.7,NULL,NULL,NULL,NULL),(9376,446,224,31.4,NULL,NULL,NULL,NULL),(9377,446,226,31.2,NULL,NULL,NULL,NULL),(9378,447,2,20.2,NULL,NULL,NULL,NULL),(9379,447,7,22.2,NULL,NULL,NULL,NULL),(9380,447,42,24.7,NULL,NULL,NULL,NULL),(9381,447,118,26,NULL,NULL,NULL,NULL),(9382,448,1,28.4,NULL,NULL,NULL,NULL),(9383,448,2,28.6,NULL,NULL,NULL,NULL),(9384,448,5,31.2,NULL,NULL,NULL,NULL),(9385,448,8,32.5,NULL,NULL,NULL,NULL),(9386,448,14,34.8,NULL,NULL,NULL,NULL),(9387,448,22,36,NULL,NULL,NULL,NULL),(9388,448,69,46.6,NULL,NULL,NULL,NULL),(9389,448,145,52.9,NULL,NULL,NULL,NULL),(9390,449,1,40.4,NULL,NULL,NULL,NULL),(9391,449,2,42.9,NULL,NULL,NULL,NULL),(9392,449,5,47.7,NULL,NULL,NULL,NULL),(9393,449,8,52.3,NULL,NULL,NULL,NULL),(9394,449,14,57.2,NULL,NULL,NULL,NULL),(9395,449,22,61.5,NULL,NULL,NULL,NULL),(9396,449,69,76,NULL,NULL,NULL,NULL),(9397,449,145,87.4,NULL,NULL,NULL,NULL),(9398,450,2,28,NULL,NULL,NULL,NULL),(9399,450,7,30.3,NULL,NULL,NULL,NULL),(9400,450,12,31.5,NULL,NULL,NULL,NULL),(9401,450,17,32.5,NULL,NULL,NULL,NULL),(9402,450,22,33.3,NULL,NULL,NULL,NULL),(9403,450,32,34.5,NULL,NULL,NULL,NULL),(9404,450,42,35.4,NULL,NULL,NULL,NULL),(9405,450,52,36.2,NULL,NULL,NULL,NULL),(9406,450,62,37,NULL,NULL,NULL,NULL),(9407,450,72,37.4,NULL,NULL,NULL,NULL),(9408,450,122,39.7,NULL,NULL,NULL,NULL),(9409,450,172,41,NULL,NULL,NULL,NULL),(9410,450,222,41.9,NULL,NULL,NULL,NULL),(9411,450,272,42.6,NULL,NULL,NULL,NULL),(9412,450,322,43.1,NULL,NULL,NULL,NULL),(9413,450,372,43.7,NULL,NULL,NULL,NULL),(9414,450,422,44.1,NULL,NULL,NULL,NULL),(9415,450,472,44.5,NULL,NULL,NULL,NULL),(9416,450,572,45.3,NULL,NULL,NULL,NULL),(9417,450,672,45.7,NULL,NULL,NULL,NULL),(9418,450,772,46,NULL,NULL,NULL,NULL),(9419,450,872,46.7,NULL,NULL,NULL,NULL),(9420,450,972,47,NULL,NULL,NULL,NULL),(9421,450,1472,48,NULL,NULL,NULL,NULL),(9422,451,2,29.8,NULL,NULL,NULL,NULL),(9423,451,7,33.2,NULL,NULL,NULL,NULL),(9424,451,12,34.5,NULL,NULL,NULL,NULL),(9425,451,17,35.6,NULL,NULL,NULL,NULL),(9426,451,22,36.7,NULL,NULL,NULL,NULL),(9427,451,32,37.8,NULL,NULL,NULL,NULL),(9428,451,42,38.8,NULL,NULL,NULL,NULL),(9429,451,52,39.7,NULL,NULL,NULL,NULL),(9430,451,62,40.4,NULL,NULL,NULL,NULL),(9431,451,72,41.1,NULL,NULL,NULL,NULL),(9432,451,122,43.2,NULL,NULL,NULL,NULL),(9433,451,172,44.7,NULL,NULL,NULL,NULL),(9434,451,222,45.8,NULL,NULL,NULL,NULL),(9435,451,272,46.8,NULL,NULL,NULL,NULL),(9436,451,322,47.3,NULL,NULL,NULL,NULL),(9437,451,372,47.9,NULL,NULL,NULL,NULL),(9438,451,422,48.3,NULL,NULL,NULL,NULL),(9439,451,472,48.7,NULL,NULL,NULL,NULL),(9440,451,572,49.3,NULL,NULL,NULL,NULL),(9441,451,672,49.8,NULL,NULL,NULL,NULL),(9442,451,772,50.3,NULL,NULL,NULL,NULL),(9443,451,872,50.7,NULL,NULL,NULL,NULL),(9444,451,972,51.1,NULL,NULL,NULL,NULL),(9445,451,1472,52.3,NULL,NULL,NULL,NULL),(9446,452,2,51.3,NULL,NULL,NULL,NULL),(9447,452,7,66.3,NULL,NULL,NULL,NULL),(9448,452,12,67.7,NULL,NULL,NULL,NULL),(9449,452,17,71.3,NULL,NULL,NULL,NULL),(9450,452,22,74.5,NULL,NULL,NULL,NULL),(9451,452,32,79.3,NULL,NULL,NULL,NULL),(9452,452,42,82.8,NULL,NULL,NULL,NULL),(9453,452,52,86,NULL,NULL,NULL,NULL),(9454,452,62,88.5,NULL,NULL,NULL,NULL),(9455,452,72,91.2,NULL,NULL,NULL,NULL),(9456,452,122,100,NULL,NULL,NULL,NULL),(9457,452,172,105.5,NULL,NULL,NULL,NULL),(9458,452,222,109.9,NULL,NULL,NULL,NULL),(9459,452,272,113,NULL,NULL,NULL,NULL),(9460,452,322,115.3,NULL,NULL,NULL,NULL),(9461,452,372,117,NULL,NULL,NULL,NULL),(9462,452,422,119.2,NULL,NULL,NULL,NULL),(9463,452,472,120.3,NULL,NULL,NULL,NULL),(9464,452,572,122.3,NULL,NULL,NULL,NULL),(9465,452,672,123.7,NULL,NULL,NULL,NULL),(9466,452,772,125,NULL,NULL,NULL,NULL),(9467,452,872,126.1,NULL,NULL,NULL,NULL),(9468,452,972,127,NULL,NULL,NULL,NULL),(9469,452,1472,130,NULL,NULL,NULL,NULL),(9470,453,0.1,61.8,NULL,NULL,NULL,NULL),(9471,453,0.5,64.4,NULL,NULL,NULL,NULL),(9472,453,1,75.1,NULL,NULL,NULL,NULL),(9473,453,1.2,82,NULL,NULL,NULL,NULL),(9474,453,1.8,87.8,NULL,NULL,NULL,NULL),(9475,453,2.3,91.1,NULL,NULL,NULL,NULL),(9476,453,3,97.8,NULL,NULL,NULL,NULL),(9477,453,4.2,108.9,NULL,NULL,NULL,NULL),(9478,453,5.4,113.8,NULL,NULL,NULL,NULL),(9479,453,6.2,117.8,NULL,NULL,NULL,NULL),(9480,453,7.4,126.9,NULL,NULL,NULL,NULL),(9481,453,9,131.1,NULL,NULL,NULL,NULL),(9482,453,12.8,146.7,NULL,NULL,NULL,NULL),(9483,453,18,151.1,NULL,NULL,NULL,NULL),(9484,453,20,168.9,NULL,NULL,NULL,NULL),(9485,453,25.1,177.8,NULL,NULL,NULL,NULL),(9486,453,36,186.7,NULL,NULL,NULL,NULL),(9487,453,51,197.1,NULL,NULL,NULL,NULL),(9488,453,61,204.4,NULL,NULL,NULL,NULL),(9489,453,74,207.1,NULL,NULL,NULL,NULL),(9490,453,120,217.8,NULL,NULL,NULL,NULL),(9491,453,156,224.9,NULL,NULL,NULL,NULL),(9492,453,692,248.4,NULL,NULL,NULL,NULL),(9493,454,3,21.3,NULL,NULL,NULL,NULL),(9494,454,5,22.2,NULL,NULL,NULL,NULL),(9495,454,7,22.7,NULL,NULL,NULL,NULL),(9496,454,10,23.4,NULL,NULL,NULL,NULL),(9497,454,30,25.6,NULL,NULL,NULL,NULL),(9498,454,50,26.4,NULL,NULL,NULL,NULL),(9499,454,70,27,NULL,NULL,NULL,NULL),(9500,454,100,27.8,NULL,NULL,NULL,NULL),(9501,454,150,28,NULL,NULL,NULL,NULL),(9502,454,216,29.9,NULL,NULL,NULL,NULL),(9503,455,3,24.8,NULL,NULL,NULL,NULL),(9504,455,5,25.5,NULL,NULL,NULL,NULL),(9505,455,7,26.2,NULL,NULL,NULL,NULL),(9506,455,10,26.9,NULL,NULL,NULL,NULL),(9507,455,30,29.1,NULL,NULL,NULL,NULL),(9508,455,50,30.1,NULL,NULL,NULL,NULL),(9509,455,70,30.8,NULL,NULL,NULL,NULL),(9510,455,100,31.6,NULL,NULL,NULL,NULL),(9511,455,150,32.5,NULL,NULL,NULL,NULL),(9512,455,210,33.4,NULL,NULL,NULL,NULL),(9513,456,3,24.6,NULL,NULL,NULL,NULL),(9514,456,5,25.8,NULL,NULL,NULL,NULL),(9515,456,7,26.5,NULL,NULL,NULL,NULL),(9516,456,10,27.3,NULL,NULL,NULL,NULL),(9517,456,30,30.1,NULL,NULL,NULL,NULL),(9518,456,50,31.4,NULL,NULL,NULL,NULL),(9519,456,70,32.1,NULL,NULL,NULL,NULL),(9520,456,100,33.1,NULL,NULL,NULL,NULL),(9521,456,150,34.2,NULL,NULL,NULL,NULL),(9522,456,203,35,NULL,NULL,NULL,NULL),(9523,457,1,57.8,NULL,NULL,NULL,NULL),(9524,457,3,63.8,NULL,NULL,NULL,NULL),(9525,457,5,70.3,NULL,NULL,NULL,NULL),(9526,457,7,72.7,NULL,NULL,NULL,NULL),(9527,457,10,75.7,NULL,NULL,NULL,NULL),(9528,457,30,82.3,NULL,NULL,NULL,NULL),(9529,457,50,83.7,NULL,NULL,NULL,NULL),(9530,457,70,85.9,NULL,NULL,NULL,NULL),(9531,457,90,87.4,NULL,NULL,NULL,NULL),(9532,458,1,57.4,NULL,NULL,NULL,NULL),(9533,458,3,63.9,NULL,NULL,NULL,NULL),(9534,458,5,68.2,NULL,NULL,NULL,NULL),(9535,458,7,70.5,NULL,NULL,NULL,NULL),(9536,458,10,72.5,NULL,NULL,NULL,NULL),(9537,458,30,78.2,NULL,NULL,NULL,NULL),(9538,458,50,80,NULL,NULL,NULL,NULL),(9539,458,70,81.1,NULL,NULL,NULL,NULL),(9540,458,90,81.8,NULL,NULL,NULL,NULL),(9541,459,1,59.7,NULL,NULL,NULL,NULL),(9542,459,3,65.7,NULL,NULL,NULL,NULL),(9543,459,5,70.3,NULL,NULL,NULL,NULL),(9544,459,7,72.9,NULL,NULL,NULL,NULL),(9545,459,10,74.9,NULL,NULL,NULL,NULL),(9546,459,30,81.1,NULL,NULL,NULL,NULL),(9547,459,50,82.6,NULL,NULL,NULL,NULL),(9548,459,70,83.7,NULL,NULL,NULL,NULL),(9549,459,90,84.5,NULL,NULL,NULL,NULL),(9550,460,1,51.6,NULL,NULL,NULL,NULL),(9551,460,3,61.9,NULL,NULL,NULL,NULL),(9552,460,5,66.3,NULL,NULL,NULL,NULL),(9553,460,7,68.5,NULL,NULL,NULL,NULL),(9554,460,10,71.5,NULL,NULL,NULL,NULL),(9555,460,30,76.6,NULL,NULL,NULL,NULL),(9556,460,50,78.1,NULL,NULL,NULL,NULL),(9557,460,70,79.6,NULL,NULL,NULL,NULL),(9558,460,90,80.8,NULL,NULL,NULL,NULL),(9559,461,1,55.7,NULL,NULL,NULL,NULL),(9560,461,3,64.5,NULL,NULL,NULL,NULL),(9561,461,5,69,NULL,NULL,NULL,NULL),(9562,461,7,71.6,NULL,NULL,NULL,NULL),(9563,461,10,74.3,NULL,NULL,NULL,NULL),(9564,461,30,79.6,NULL,NULL,NULL,NULL),(9565,461,50,81.3,NULL,NULL,NULL,NULL),(9566,461,70,82.2,NULL,NULL,NULL,NULL),(9567,461,90,83.3,NULL,NULL,NULL,NULL),(9568,462,1,66.9,NULL,NULL,NULL,NULL),(9569,462,3,72.6,NULL,NULL,NULL,NULL),(9570,462,5,77.7,NULL,NULL,NULL,NULL),(9571,462,7,80.8,NULL,NULL,NULL,NULL),(9572,462,10,83.3,NULL,NULL,NULL,NULL),(9573,462,30,89.3,NULL,NULL,NULL,NULL),(9574,462,50,90.9,NULL,NULL,NULL,NULL),(9575,462,70,92.2,NULL,NULL,NULL,NULL),(9576,462,90,93.1,NULL,NULL,NULL,NULL),(9577,463,1,42.3,NULL,NULL,NULL,NULL),(9578,463,3,50.2,NULL,NULL,NULL,NULL),(9579,463,5,54.8,NULL,NULL,NULL,NULL),(9580,463,7,57.3,NULL,NULL,NULL,NULL),(9581,463,10,59.3,NULL,NULL,NULL,NULL),(9582,463,30,64,NULL,NULL,NULL,NULL),(9583,463,50,65.1,NULL,NULL,NULL,NULL),(9584,463,70,65.7,NULL,NULL,NULL,NULL),(9585,463,90,67,NULL,NULL,NULL,NULL),(9586,464,1,50.5,NULL,NULL,NULL,NULL),(9587,464,3,56.7,NULL,NULL,NULL,NULL),(9588,464,5,60.5,NULL,NULL,NULL,NULL),(9589,464,7,63.6,NULL,NULL,NULL,NULL),(9590,464,10,66,NULL,NULL,NULL,NULL),(9591,464,30,71.8,NULL,NULL,NULL,NULL),(9592,464,50,73.9,NULL,NULL,NULL,NULL),(9593,464,70,75.2,NULL,NULL,NULL,NULL),(9594,464,90,76.1,NULL,NULL,NULL,NULL),(9595,465,1,56.1,NULL,NULL,NULL,NULL),(9596,465,3,63.3,NULL,NULL,NULL,NULL),(9597,465,5,68,NULL,NULL,NULL,NULL),(9598,465,7,70.6,NULL,NULL,NULL,NULL),(9599,465,10,73.2,NULL,NULL,NULL,NULL),(9600,465,30,73.8,NULL,NULL,NULL,NULL),(9601,465,50,81.5,NULL,NULL,NULL,NULL),(9602,465,70,82.6,NULL,NULL,NULL,NULL),(9603,465,90,83.8,NULL,NULL,NULL,NULL),(9604,466,0.2,23.6,NULL,NULL,NULL,NULL),(9605,466,0.4,23.7,NULL,NULL,NULL,NULL),(9606,466,0.6,23.7,NULL,NULL,NULL,NULL),(9607,466,0.8,23.7,NULL,NULL,NULL,NULL),(9608,466,1,23.7,NULL,NULL,NULL,NULL),(9609,466,1.2,23.7,NULL,NULL,NULL,NULL),(9610,466,1.4,23.8,NULL,NULL,NULL,NULL),(9611,466,1.6,23.8,NULL,NULL,NULL,NULL),(9612,466,1.8,23.8,NULL,NULL,NULL,NULL),(9613,466,2,23.8,NULL,NULL,NULL,NULL),(9614,466,2.2,23.8,NULL,NULL,NULL,NULL),(9615,466,2.4,23.8,NULL,NULL,NULL,NULL),(9616,466,2.6,23.8,NULL,NULL,NULL,NULL),(9617,466,2.8,23.8,NULL,NULL,NULL,NULL),(9618,466,3,23.8,NULL,NULL,NULL,NULL),(9619,466,3.2,23.9,NULL,NULL,NULL,NULL),(9620,466,3.4,23.9,NULL,NULL,NULL,NULL),(9621,466,3.6,23.9,NULL,NULL,NULL,NULL),(9622,466,3.8,23.9,NULL,NULL,NULL,NULL),(9623,466,4,23.9,NULL,NULL,NULL,NULL),(9624,467,0.08,31.6,NULL,NULL,NULL,NULL),(9625,467,0.28,31.8,NULL,NULL,NULL,NULL),(9626,467,0.48,31.8,NULL,NULL,NULL,NULL),(9627,467,0.68,31.9,NULL,NULL,NULL,NULL),(9628,467,0.88,31.9,NULL,NULL,NULL,NULL),(9629,467,1.08,31.9,NULL,NULL,NULL,NULL),(9630,467,1.28,32,NULL,NULL,NULL,NULL),(9631,467,1.48,32,NULL,NULL,NULL,NULL),(9632,467,1.68,32,NULL,NULL,NULL,NULL),(9633,467,1.88,32,NULL,NULL,NULL,NULL),(9634,467,2.08,32,NULL,NULL,NULL,NULL),(9635,467,2.28,32,NULL,NULL,NULL,NULL),(9636,467,2.48,32,NULL,NULL,NULL,NULL),(9637,467,2.68,32,NULL,NULL,NULL,NULL),(9638,467,2.88,32,NULL,NULL,NULL,NULL),(9639,467,3.08,32,NULL,NULL,NULL,NULL),(9640,467,3.28,32,NULL,NULL,NULL,NULL),(9641,467,3.48,32,NULL,NULL,NULL,NULL),(9642,467,3.68,32,NULL,NULL,NULL,NULL),(9643,467,3.88,32,NULL,NULL,NULL,NULL),(9644,468,0.08,24.9,NULL,NULL,NULL,NULL),(9645,468,0.28,25.5,NULL,NULL,NULL,NULL),(9646,468,0.48,26,NULL,NULL,NULL,NULL),(9647,468,0.68,26.4,NULL,NULL,NULL,NULL),(9648,468,0.88,26.8,NULL,NULL,NULL,NULL),(9649,468,1.08,27,NULL,NULL,NULL,NULL),(9650,468,1.28,27.1,NULL,NULL,NULL,NULL),(9651,468,1.48,27.1,NULL,NULL,NULL,NULL),(9652,468,1.68,27.1,NULL,NULL,NULL,NULL),(9653,468,1.88,27.2,NULL,NULL,NULL,NULL),(9654,468,2.08,27.2,NULL,NULL,NULL,NULL),(9655,468,2.28,27.2,NULL,NULL,NULL,NULL),(9656,468,2.48,27.2,NULL,NULL,NULL,NULL),(9657,468,2.68,27.2,NULL,NULL,NULL,NULL),(9658,468,2.88,27.2,NULL,NULL,NULL,NULL),(9659,468,3.08,27.2,NULL,NULL,NULL,NULL),(9660,468,3.28,27.2,NULL,NULL,NULL,NULL),(9661,468,3.48,27.2,NULL,NULL,NULL,NULL),(9662,468,3.68,27.2,NULL,NULL,NULL,NULL),(9663,468,3.88,27.2,NULL,NULL,NULL,NULL),(9664,469,0.01,27,NULL,NULL,NULL,NULL),(9665,469,0.2,27.2,NULL,NULL,NULL,NULL),(9666,469,0.4,27.2,NULL,NULL,NULL,NULL),(9667,469,0.6,27.2,NULL,NULL,NULL,NULL),(9668,469,0.8,27.2,NULL,NULL,NULL,NULL),(9669,469,1,27.2,NULL,NULL,NULL,NULL),(9670,469,1.2,27.2,NULL,NULL,NULL,NULL),(9671,469,1.4,27.2,NULL,NULL,NULL,NULL),(9672,469,1.6,27.2,NULL,NULL,NULL,NULL),(9673,469,1.8,27.3,NULL,NULL,NULL,NULL),(9674,469,2,27.3,NULL,NULL,NULL,NULL),(9675,469,2.2,27.3,NULL,NULL,NULL,NULL),(9676,469,2.4,27.3,NULL,NULL,NULL,NULL),(9677,469,2.6,27.3,NULL,NULL,NULL,NULL),(9678,469,2.8,27.3,NULL,NULL,NULL,NULL),(9679,469,3,27.3,NULL,NULL,NULL,NULL),(9680,469,3.2,27.3,NULL,NULL,NULL,NULL),(9681,469,3.4,27.3,NULL,NULL,NULL,NULL),(9682,469,3.6,27.3,NULL,NULL,NULL,NULL),(9683,469,3.8,27.3,NULL,NULL,NULL,NULL),(9684,469,4,27.3,NULL,NULL,NULL,NULL),(9685,470,0.12,38.2,NULL,NULL,NULL,NULL),(9686,470,0.32,38.4,NULL,NULL,NULL,NULL),(9687,470,0.52,38.5,NULL,NULL,NULL,NULL),(9688,470,0.72,38.6,NULL,NULL,NULL,NULL),(9689,470,0.92,38.6,NULL,NULL,NULL,NULL),(9690,470,1.12,38.7,NULL,NULL,NULL,NULL),(9691,470,1.32,38.7,NULL,NULL,NULL,NULL),(9692,470,1.52,38.7,NULL,NULL,NULL,NULL),(9693,470,1.72,38.8,NULL,NULL,NULL,NULL),(9694,470,1.92,38.8,NULL,NULL,NULL,NULL),(9695,470,2.12,38.8,NULL,NULL,NULL,NULL),(9696,470,2.32,38.8,NULL,NULL,NULL,NULL),(9697,470,2.52,38.9,NULL,NULL,NULL,NULL),(9698,470,2.72,38.9,NULL,NULL,NULL,NULL),(9699,470,2.92,38.9,NULL,NULL,NULL,NULL),(9700,470,3.12,38.9,NULL,NULL,NULL,NULL),(9701,470,3.32,38.9,NULL,NULL,NULL,NULL),(9702,470,3.52,38.9,NULL,NULL,NULL,NULL),(9703,470,3.72,38.9,NULL,NULL,NULL,NULL),(9704,470,3.92,38.9,NULL,NULL,NULL,NULL),(9705,471,0.08,29.3,NULL,NULL,NULL,NULL),(9706,471,0.28,29.7,NULL,NULL,NULL,NULL),(9707,471,0.48,30.3,NULL,NULL,NULL,NULL),(9708,471,0.68,30.7,NULL,NULL,NULL,NULL),(9709,471,0.88,31.1,NULL,NULL,NULL,NULL),(9710,471,1.08,31.3,NULL,NULL,NULL,NULL),(9711,471,1.28,31.4,NULL,NULL,NULL,NULL),(9712,471,1.48,31.5,NULL,NULL,NULL,NULL),(9713,471,1.68,31.5,NULL,NULL,NULL,NULL),(9714,471,1.88,31.6,NULL,NULL,NULL,NULL),(9715,471,2.08,31.6,NULL,NULL,NULL,NULL),(9716,471,2.28,31.7,NULL,NULL,NULL,NULL),(9717,471,2.48,31.7,NULL,NULL,NULL,NULL),(9718,471,2.68,31.7,NULL,NULL,NULL,NULL),(9719,471,2.88,31.7,NULL,NULL,NULL,NULL),(9720,471,3.08,31.8,NULL,NULL,NULL,NULL),(9721,471,3.28,31.8,NULL,NULL,NULL,NULL),(9722,471,3.48,31.8,NULL,NULL,NULL,NULL),(9723,471,3.68,31.8,NULL,NULL,NULL,NULL),(9724,471,3.88,31.8,NULL,NULL,NULL,NULL),(9725,472,1,68.5,NULL,NULL,NULL,NULL),(9726,472,2,74,NULL,NULL,NULL,NULL),(9727,472,3,77.6,NULL,NULL,NULL,NULL),(9728,472,7,85.5,NULL,NULL,NULL,NULL),(9729,472,14,92.7,NULL,NULL,NULL,NULL),(9730,472,28,100.9,NULL,NULL,NULL,NULL),(9731,472,56,109.3,NULL,NULL,NULL,NULL),(9732,472,90,115.4,NULL,NULL,NULL,NULL),(9733,472,180,122.5,NULL,NULL,NULL,NULL),(9734,472,365,128.4,NULL,NULL,NULL,NULL),(9735,472,730,132.2,NULL,NULL,NULL,NULL),(9736,472,790,132.8,NULL,NULL,NULL,NULL),(9737,473,1,57.5,NULL,NULL,NULL,NULL),(9738,473,2,59.8,NULL,NULL,NULL,NULL),(9739,473,3,62.1,NULL,NULL,NULL,NULL),(9740,473,7,68.2,NULL,NULL,NULL,NULL),(9741,473,14,73.3,NULL,NULL,NULL,NULL),(9742,473,28,80.5,NULL,NULL,NULL,NULL),(9743,473,56,88.3,NULL,NULL,NULL,NULL),(9744,473,90,95.1,NULL,NULL,NULL,NULL),(9745,473,180,104.1,NULL,NULL,NULL,NULL),(9746,473,365,111.1,NULL,NULL,NULL,NULL),(9747,473,730,116,NULL,NULL,NULL,NULL),(9748,473,775,116.2,NULL,NULL,NULL,NULL),(9749,474,0.041,40.5,NULL,NULL,NULL,NULL),(9750,474,1,53.4,NULL,NULL,NULL,NULL),(9751,474,2,56.6,NULL,NULL,NULL,NULL),(9752,474,3,58.9,NULL,NULL,NULL,NULL),(9753,474,7,64.5,NULL,NULL,NULL,NULL),(9754,474,14,70.4,NULL,NULL,NULL,NULL),(9755,474,28,78.1,NULL,NULL,NULL,NULL),(9756,474,56,86.4,NULL,NULL,NULL,NULL),(9757,474,90,93.8,NULL,NULL,NULL,NULL),(9758,474,180,101.9,NULL,NULL,NULL,NULL),(9759,474,365,108.6,NULL,NULL,NULL,NULL),(9760,474,730,113.1,NULL,NULL,NULL,NULL),(9761,474,820,113.9,NULL,NULL,NULL,NULL),(9762,475,0.033,37.8,NULL,NULL,NULL,NULL),(9763,475,1,47.7,NULL,NULL,NULL,NULL),(9764,475,2,49.8,NULL,NULL,NULL,NULL),(9765,475,3,51.7,NULL,NULL,NULL,NULL),(9766,475,7,56,NULL,NULL,NULL,NULL),(9767,475,14,60.1,NULL,NULL,NULL,NULL),(9768,475,28,67,NULL,NULL,NULL,NULL),(9769,475,56,75,NULL,NULL,NULL,NULL),(9770,475,90,82,NULL,NULL,NULL,NULL),(9771,475,180,92.5,NULL,NULL,NULL,NULL),(9772,475,365,100.9,NULL,NULL,NULL,NULL),(9773,475,730,106.6,NULL,NULL,NULL,NULL),(9774,475,770,107,NULL,NULL,NULL,NULL),(9775,476,0.0354,35,NULL,NULL,NULL,NULL),(9776,476,1,44.3,NULL,NULL,NULL,NULL),(9777,476,2,46.7,NULL,NULL,NULL,NULL),(9778,476,3,48.1,NULL,NULL,NULL,NULL),(9779,476,7,52.3,NULL,NULL,NULL,NULL),(9780,476,14,56.6,NULL,NULL,NULL,NULL),(9781,476,28,62.6,NULL,NULL,NULL,NULL),(9782,476,56,69.1,NULL,NULL,NULL,NULL),(9783,476,90,74.8,NULL,NULL,NULL,NULL),(9784,476,180,84.8,NULL,NULL,NULL,NULL),(9785,476,365,93,NULL,NULL,NULL,NULL),(9786,476,730,99.1,NULL,NULL,NULL,NULL),(9787,476,750,99.4,NULL,NULL,NULL,NULL),(9788,477,1,56.4,NULL,NULL,NULL,NULL),(9789,477,2,61.6,NULL,NULL,NULL,NULL),(9790,477,3,64.5,NULL,NULL,NULL,NULL),(9791,477,7,72,NULL,NULL,NULL,NULL),(9792,477,14,78.3,NULL,NULL,NULL,NULL),(9793,477,28,85.4,NULL,NULL,NULL,NULL),(9794,477,56,94.3,NULL,NULL,NULL,NULL),(9795,477,90,100.7,NULL,NULL,NULL,NULL),(9796,477,180,111.6,NULL,NULL,NULL,NULL),(9797,477,365,121.8,NULL,NULL,NULL,NULL),(9798,477,730,129.7,NULL,NULL,NULL,NULL),(9799,477,907,131.6,NULL,NULL,NULL,NULL),(9800,478,1,47.1,NULL,NULL,NULL,NULL),(9801,478,2,49.3,NULL,NULL,NULL,NULL),(9802,478,3,51.1,NULL,NULL,NULL,NULL),(9803,478,7,56.8,NULL,NULL,NULL,NULL),(9804,478,14,62.6,NULL,NULL,NULL,NULL),(9805,478,28,69.2,NULL,NULL,NULL,NULL),(9806,478,56,77.2,NULL,NULL,NULL,NULL),(9807,478,90,82.9,NULL,NULL,NULL,NULL),(9808,478,180,92.3,NULL,NULL,NULL,NULL),(9809,478,365,102.8,NULL,NULL,NULL,NULL),(9810,478,730,111.4,NULL,NULL,NULL,NULL),(9811,478,878,113.4,NULL,NULL,NULL,NULL),(9812,479,0.0704,35.9,NULL,NULL,NULL,NULL),(9813,479,1,41.1,NULL,NULL,NULL,NULL),(9814,479,2,42.4,NULL,NULL,NULL,NULL),(9815,479,3,43.7,NULL,NULL,NULL,NULL),(9816,479,7,48.2,NULL,NULL,NULL,NULL),(9817,479,14,53.6,NULL,NULL,NULL,NULL),(9818,479,28,60,NULL,NULL,NULL,NULL),(9819,479,56,69.1,NULL,NULL,NULL,NULL),(9820,479,90,75.9,NULL,NULL,NULL,NULL),(9821,479,180,87.3,NULL,NULL,NULL,NULL),(9822,479,365,98.1,NULL,NULL,NULL,NULL),(9823,479,730,107.1,NULL,NULL,NULL,NULL),(9824,479,879,109.3,NULL,NULL,NULL,NULL),(9825,480,0.14,33.11,NULL,NULL,NULL,NULL),(9826,480,1,36.2,NULL,NULL,NULL,NULL),(9827,480,2,37.2,NULL,NULL,NULL,NULL),(9828,480,3,38.2,NULL,NULL,NULL,NULL),(9829,480,7,41.3,NULL,NULL,NULL,NULL),(9830,480,14,45,NULL,NULL,NULL,NULL),(9831,480,28,49.6,NULL,NULL,NULL,NULL),(9832,480,56,55.6,NULL,NULL,NULL,NULL),(9833,480,90,60.1,NULL,NULL,NULL,NULL),(9834,480,180,68.1,NULL,NULL,NULL,NULL),(9835,480,365,77.1,NULL,NULL,NULL,NULL),(9836,480,730,84.8,NULL,NULL,NULL,NULL),(9837,480,796,85.1,NULL,NULL,NULL,NULL),(9838,481,0.984082,60.454,NULL,NULL,NULL,NULL),(9839,481,3.22635,64.4549,NULL,NULL,NULL,NULL),(9840,481,5.84186,68.2852,NULL,NULL,NULL,NULL),(9841,481,7.98802,73.1834,NULL,NULL,NULL,NULL),(9842,481,9.76218,78.075,NULL,NULL,NULL,NULL),(9843,481,20.7525,80.6948,NULL,NULL,NULL,NULL),(9844,481,31.4963,83.7014,NULL,NULL,NULL,NULL),(9845,481,55.2281,89.9698,NULL,NULL,NULL,NULL),(9846,481,76.7397,94.5978,NULL,NULL,NULL,NULL),(9847,481,85.8618,97.9931,NULL,NULL,NULL,NULL),(9848,481,205.869,100.891,NULL,NULL,NULL,NULL),(9849,481,257.721,104.429,NULL,NULL,NULL,NULL),(9850,481,381.839,106.485,NULL,NULL,NULL,NULL),(9851,481,430.675,110.559,NULL,NULL,NULL,NULL),(9852,481,505.627,108.128,NULL,NULL,NULL,NULL),(9853,482,0.953003,39.9841,NULL,NULL,NULL,NULL),(9854,482,3.25233,43.3097,NULL,NULL,NULL,NULL),(9855,482,5.34839,47.9476,NULL,NULL,NULL,NULL),(9856,482,15.9254,58.0425,NULL,NULL,NULL,NULL),(9857,482,17.9622,61.0316,NULL,NULL,NULL,NULL),(9858,482,29.5379,65.3985,NULL,NULL,NULL,NULL),(9859,482,30.7468,67.8408,NULL,NULL,NULL,NULL),(9860,482,57.0296,70.1814,NULL,NULL,NULL,NULL),(9861,482,71.3937,71.8212,NULL,NULL,NULL,NULL),(9862,482,90.8218,75.9019,NULL,NULL,NULL,NULL),(9863,482,179.622,77.162,NULL,NULL,NULL,NULL),(9864,482,270.433,77.186,NULL,NULL,NULL,NULL),(9865,482,372.761,81.6781,NULL,NULL,NULL,NULL),(9866,482,474.198,82.5056,NULL,NULL,NULL,NULL),(9867,483,2.61889,36.655,NULL,NULL,NULL,NULL),(9868,483,8.31498,41.3317,NULL,NULL,NULL,NULL),(9869,483,26.6128,43.9756,NULL,NULL,NULL,NULL),(9870,483,50.9706,47.1315,NULL,NULL,NULL,NULL),(9871,483,82.486,48.6509,NULL,NULL,NULL,NULL),(9872,483,138.95,52.477,NULL,NULL,NULL,NULL),(9873,483,214.294,54.2646,NULL,NULL,NULL,NULL),(9874,483,317.497,54.1522,NULL,NULL,NULL,NULL),(9875,483,403.896,57.8261,NULL,NULL,NULL,NULL),(9876,483,501.591,59.1944,NULL,NULL,NULL,NULL),(9877,484,2.47587,28.5188,NULL,NULL,NULL,NULL),(9878,484,3.00159,31.6477,NULL,NULL,NULL,NULL),(9879,484,5.84186,31.5514,NULL,NULL,NULL,NULL),(9880,484,9.30338,32.2565,NULL,NULL,NULL,NULL),(9881,484,25.5664,34.6204,NULL,NULL,NULL,NULL),(9882,484,34.9583,35.1809,NULL,NULL,NULL,NULL),(9883,484,69.1385,36.1699,NULL,NULL,NULL,NULL),(9884,484,128.236,39.595,NULL,NULL,NULL,NULL),(9885,484,219.513,41.1178,NULL,NULL,NULL,NULL),(9886,484,293.022,41.4058,NULL,NULL,NULL,NULL),(9887,485,2.71797,24.4195,NULL,NULL,NULL,NULL),(9888,485,6.15237,25.9602,NULL,NULL,NULL,NULL),(9889,485,9.96081,27.7512,NULL,NULL,NULL,NULL),(9890,485,44.5913,30.4154,NULL,NULL,NULL,NULL),(9891,485,73.2524,32.4778,NULL,NULL,NULL,NULL),(9892,485,88.0729,32.7599,NULL,NULL,NULL,NULL),(9893,485,124.308,33.3223,NULL,NULL,NULL,NULL),(9894,485,204.341,34.7072,NULL,NULL,NULL,NULL),(9895,486,0.948881,57.7146,NULL,NULL,NULL,NULL),(9896,486,4.66032,58.789,NULL,NULL,NULL,NULL),(9897,486,9.83438,60.3407,NULL,NULL,NULL,NULL),(9898,486,15.7123,61.8925,NULL,NULL,NULL,NULL),(9899,486,68.7132,73.5906,NULL,NULL,NULL,NULL),(9900,486,96.2698,72.1582,NULL,NULL,NULL,NULL),(9901,486,118.724,73.5906,NULL,NULL,NULL,NULL),(9902,486,126.669,75.978,NULL,NULL,NULL,NULL),(9903,486,190.722,79.3204,NULL,NULL,NULL,NULL),(9904,486,249.678,78.6041,NULL,NULL,NULL,NULL),(9905,486,446.098,83.4982,NULL,NULL,NULL,NULL),(9906,486,598.343,87.3181,NULL,NULL,NULL,NULL),(9907,486,955.542,89.3472,NULL,NULL,NULL,NULL),(9908,486,1248.53,90.541,NULL,NULL,NULL,NULL),(9909,486,1527.21,90.541,NULL,NULL,NULL,NULL),(9910,486,1916.06,94.0026,NULL,NULL,NULL,NULL),(9911,486,2385.72,95.4351,NULL,NULL,NULL,NULL),(9912,486,2679.72,94.3607,NULL,NULL,NULL,NULL),(9913,486,2807.37,95.7932,NULL,NULL,NULL,NULL),(9914,486,3366.36,96.5094,NULL,NULL,NULL,NULL),(9915,487,2.08391,38.3769,NULL,NULL,NULL,NULL),(9916,487,2.85467,40.2869,NULL,NULL,NULL,NULL),(9917,487,7.89545,39.9288,NULL,NULL,NULL,NULL),(9918,487,11.7744,43.2711,NULL,NULL,NULL,NULL),(9919,487,37.6773,41.003,NULL,NULL,NULL,NULL),(9920,487,38.3116,43.5098,NULL,NULL,NULL,NULL),(9921,487,64.2347,44.8228,NULL,NULL,NULL,NULL),(9922,487,74.6174,48.5233,NULL,NULL,NULL,NULL),(9923,487,109.509,48.6426,NULL,NULL,NULL,NULL),(9924,487,136.37,49.9556,NULL,NULL,NULL,NULL),(9925,487,171.498,51.03,NULL,NULL,NULL,NULL),(9926,487,263.906,51.7462,NULL,NULL,NULL,NULL),(9927,487,286.992,54.2529,NULL,NULL,NULL,NULL),(9928,488,0.863088,30.8924,NULL,NULL,NULL,NULL),(9929,488,5.02846,34.9508,NULL,NULL,NULL,NULL),(9930,488,16.5176,32.4441,NULL,NULL,NULL,NULL),(9931,488,25.9385,34.7121,NULL,NULL,NULL,NULL),(9932,488,27.9505,37.0995,NULL,NULL,NULL,NULL),(9933,488,57.4823,37.8157,NULL,NULL,NULL,NULL),(9934,488,84.5501,36.3833,NULL,NULL,NULL,NULL),(9935,488,115.798,38.8901,NULL,NULL,NULL,NULL),(9936,488,131.209,38.7707,NULL,NULL,NULL,NULL),(9937,488,138.779,40.3224,NULL,NULL,NULL,NULL),(9938,488,173.32,38.8901,NULL,NULL,NULL,NULL),(9939,489,4.07475,32.8567,NULL,NULL,NULL,NULL),(9940,489,11.967,29.3951,NULL,NULL,NULL,NULL),(9941,489,22.1782,31.4244,NULL,NULL,NULL,NULL),(9942,489,39.6913,32.2599,NULL,NULL,NULL,NULL),(9943,489,53.8987,32.4986,NULL,NULL,NULL,NULL),(9944,489,100.417,32.8567,NULL,NULL,NULL,NULL),(9945,489,121.33,35.3635,NULL,NULL,NULL,NULL),(9946,489,197.462,37.2734,NULL,NULL,NULL,NULL),(9947,489,386.612,36.6766,NULL,NULL,NULL,NULL),(9948,489,468.696,35.9603,NULL,NULL,NULL,NULL),(9949,489,490.621,38.2283,NULL,NULL,NULL,NULL),(9950,489,507.041,34.0505,NULL,NULL,NULL,NULL),(9951,490,1.29041,92.4149,NULL,NULL,NULL,NULL),(9952,490,27.2892,111.18,NULL,NULL,NULL,NULL),(9953,490,48.0463,123.058,NULL,NULL,NULL,NULL),(9954,490,109.159,133.507,NULL,NULL,NULL,NULL),(9955,490,190.669,136.292,NULL,NULL,NULL,NULL),(9956,490,272.891,138.462,NULL,NULL,NULL,NULL),(9957,490,400.018,141.729,NULL,NULL,NULL,NULL),(9958,490,693.154,145.769,NULL,NULL,NULL,NULL),(9959,490,887.36,148.104,NULL,NULL,NULL,NULL),(9960,491,2.68575,57.399,NULL,NULL,NULL,NULL),(9961,491,23.0845,71.5212,NULL,NULL,NULL,NULL),(9962,491,40.3218,77.5982,NULL,NULL,NULL,NULL),(9963,491,99.2065,88.5128,NULL,NULL,NULL,NULL),(9964,491,178.896,90.0406,NULL,NULL,NULL,NULL),(9965,491,262.235,93.9344,NULL,NULL,NULL,NULL),(9966,491,335.699,96.4265,NULL,NULL,NULL,NULL),(9967,491,499.988,98.2809,NULL,NULL,NULL,NULL),(9968,492,24.9988,55.2088,NULL,NULL,NULL,NULL),(9969,492,69.3154,57.0209,NULL,NULL,NULL,NULL),(9970,492,138.634,58.0712,NULL,NULL,NULL,NULL),(9971,492,206.481,59.6121,NULL,NULL,NULL,NULL),(9972,492,248.005,61.7948,NULL,NULL,NULL,NULL),(9973,492,320.029,63.3454,NULL,NULL,NULL,NULL),(9974,492,563.469,65.6589,NULL,NULL,NULL,NULL),(9975,492,845.941,68.6104,NULL,NULL,NULL,NULL),(9976,493,9.7638,37.7114,NULL,NULL,NULL,NULL),(9977,493,68.2197,44.6349,NULL,NULL,NULL,NULL),(9978,493,125.994,47.8859,NULL,NULL,NULL,NULL),(9979,493,223.604,49.7284,NULL,NULL,NULL,NULL),(9980,493,275.074,50.3414,NULL,NULL,NULL,NULL),(9981,493,360.653,52.3614,NULL,NULL,NULL,NULL),(9982,494,41.9604,34.0058,NULL,NULL,NULL,NULL),(9983,494,88.0319,35.6802,NULL,NULL,NULL,NULL),(9984,494,170.541,38.1439,NULL,NULL,NULL,NULL),(9985,494,242.148,40.0016,NULL,NULL,NULL,NULL),(9986,494,307.532,41.5533,NULL,NULL,NULL,NULL),(9987,494,484.306,43.0903,NULL,NULL,NULL,NULL),(9988,494,615.078,44.3285,NULL,NULL,NULL,NULL),(9989,495,1.6681,58.636,NULL,NULL,NULL,NULL),(9990,495,6.59848,68.6931,NULL,NULL,NULL,NULL),(9991,495,10.325,75.9682,NULL,NULL,NULL,NULL),(9992,495,10.9192,77.5166,NULL,NULL,NULL,NULL),(9993,495,21.7175,79.4541,NULL,NULL,NULL,NULL),(9994,495,28.0492,83.7471,NULL,NULL,NULL,NULL),(9995,495,32.3907,90.0554,NULL,NULL,NULL,NULL),(9996,495,41.5011,92.8025,NULL,NULL,NULL,NULL),(9997,495,49.4812,92.6927,NULL,NULL,NULL,NULL),(9998,495,57.14,98.0499,NULL,NULL,NULL,NULL),(9999,495,70.3429,105.312,NULL,NULL,NULL,NULL),(10000,495,80.5842,107.222,NULL,NULL,NULL,NULL),(10001,495,94.5562,110.44,NULL,NULL,NULL,NULL),(10002,495,117.338,113.78,NULL,NULL,NULL,NULL),(10003,495,162.858,114.034,NULL,NULL,NULL,NULL),(10004,495,233.378,127.011,NULL,NULL,NULL,NULL),(10005,495,339.821,126.674,NULL,NULL,NULL,NULL),(10006,495,453.158,129.899,NULL,NULL,NULL,NULL),(10007,496,0.15133,27.1268,NULL,NULL,NULL,NULL),(10008,496,0.402108,28.7323,NULL,NULL,NULL,NULL),(10009,496,0.902206,30.4704,NULL,NULL,NULL,NULL),(10010,496,1.19932,30.9593,NULL,NULL,NULL,NULL),(10011,496,2.17555,32.1383,NULL,NULL,NULL,NULL),(10012,496,4.25245,33.7234,NULL,NULL,NULL,NULL),(10013,496,8.43553,35.9801,NULL,NULL,NULL,NULL),(10014,496,11.753,36.7383,NULL,NULL,NULL,NULL),(10015,496,13.9789,37.4872,NULL,NULL,NULL,NULL),(10016,496,21.1588,39.2572,NULL,NULL,NULL,NULL),(10017,496,27.2957,40.4137,NULL,NULL,NULL,NULL),(10018,496,37.6743,41.977,NULL,NULL,NULL,NULL),(10019,496,43.1023,42.7906,NULL,NULL,NULL,NULL),(10020,496,57.1995,44.6201,NULL,NULL,NULL,NULL),(10021,496,68.1139,45.3018,NULL,NULL,NULL,NULL),(10022,496,96.694,47.3367,NULL,NULL,NULL,NULL),(10023,496,112.121,48.0168,NULL,NULL,NULL,NULL),(10024,496,135.386,48.9678,NULL,NULL,NULL,NULL),(10025,496,165.701,49.9868,NULL,NULL,NULL,NULL),(10026,496,194.777,50.8021,NULL,NULL,NULL,NULL),(10027,496,255.184,52.6309,NULL,NULL,NULL,NULL),(10028,496,288.006,53.0407,NULL,NULL,NULL,NULL),(10029,496,324.99,53.3163,NULL,NULL,NULL,NULL),(10030,496,361.888,53.6585,NULL,NULL,NULL,NULL),(10031,496,382.038,54.1316,NULL,NULL,NULL,NULL),(10032,496,414.091,54.3377,NULL,NULL,NULL,NULL),(10033,496,455.15,54.9475,NULL,NULL,NULL,NULL),(10034,496,487.155,55.6901,NULL,NULL,NULL,NULL),(10035,497,0.0304167,24.6454,NULL,NULL,NULL,NULL),(10036,497,0.152786,25.9354,NULL,NULL,NULL,NULL),(10037,497,0.272678,26.51,NULL,NULL,NULL,NULL),(10038,497,0.841716,27.3846,NULL,NULL,NULL,NULL),(10039,497,1.08003,27.6008,NULL,NULL,NULL,NULL),(10040,497,6.00179,30.1191,NULL,NULL,NULL,NULL),(10041,497,9.21217,31.017,NULL,NULL,NULL,NULL),(10042,497,11.4175,31.6339,NULL,NULL,NULL,NULL),(10043,497,13.5931,32.1141,NULL,NULL,NULL,NULL),(10044,497,20.8836,33.2135,NULL,NULL,NULL,NULL),(10045,497,27.3299,34.3036,NULL,NULL,NULL,NULL),(10046,497,37.732,35.3296,NULL,NULL,NULL,NULL),(10047,497,52.0999,36.4229,NULL,NULL,NULL,NULL),(10048,497,66.3775,37.3769,NULL,NULL,NULL,NULL),(10049,497,86.89,38.5342,NULL,NULL,NULL,NULL),(10050,497,104.914,39.3511,NULL,NULL,NULL,NULL),(10051,497,130.166,40.438,NULL,NULL,NULL,NULL),(10052,497,159.245,41.0539,NULL,NULL,NULL,NULL),(10053,497,220.135,42.8859,NULL,NULL,NULL,NULL),(10054,497,292.058,44.0439,NULL,NULL,NULL,NULL),(10055,497,352.716,44.9949,NULL,NULL,NULL,NULL),(10056,497,403.842,46.0772,NULL,NULL,NULL,NULL),(10057,497,431.967,46.3497,NULL,NULL,NULL,NULL),(10058,497,462.082,46.6894,NULL,NULL,NULL,NULL),(10059,497,514.751,47.3,NULL,NULL,NULL,NULL),(10060,497,543.27,47.5717,NULL,NULL,NULL,NULL),(10061,497,581.146,47.9113,NULL,NULL,NULL,NULL),(10062,497,673.865,48.4573,NULL,NULL,NULL,NULL),(10063,498,0.000265734,23.7715,NULL,NULL,NULL,NULL),(10064,498,0.0412153,24.3353,NULL,NULL,NULL,NULL),(10065,498,0.122576,24.7938,NULL,NULL,NULL,NULL),(10066,498,0.282226,25.1755,NULL,NULL,NULL,NULL),(10067,498,1.01982,26.0547,NULL,NULL,NULL,NULL),(10068,498,3.0408,27.2597,NULL,NULL,NULL,NULL),(10069,498,5.27601,27.8288,NULL,NULL,NULL,NULL),(10070,498,7.28318,28.2505,NULL,NULL,NULL,NULL),(10071,498,11.5014,29.1501,NULL,NULL,NULL,NULL),(10072,498,23.7431,30.1995,NULL,NULL,NULL,NULL),(10073,498,32.7927,31.2926,NULL,NULL,NULL,NULL),(10074,498,40.6774,32.1782,NULL,NULL,NULL,NULL),(10075,498,51.0911,32.3929,NULL,NULL,NULL,NULL),(10076,498,59.2484,33.0058,NULL,NULL,NULL,NULL),(10077,498,67.776,33.4165,NULL,NULL,NULL,NULL),(10078,498,73.5006,33.9586,NULL,NULL,NULL,NULL),(10079,498,85.2195,34.4372,NULL,NULL,NULL,NULL),(10080,498,101.47,34.7831,NULL,NULL,NULL,NULL),(10081,498,114.549,35.3273,NULL,NULL,NULL,NULL),(10082,498,124.235,35.9363,NULL,NULL,NULL,NULL),(10083,498,158.195,36.4204,NULL,NULL,NULL,NULL),(10084,498,188.607,37.7065,NULL,NULL,NULL,NULL),(10085,498,221.646,38.2531,NULL,NULL,NULL,NULL),(10086,498,253.655,38.9996,NULL,NULL,NULL,NULL),(10087,498,290.185,39.4775,NULL,NULL,NULL,NULL),(10088,498,319.056,40.2887,NULL,NULL,NULL,NULL),(10089,498,350.629,40.7643,NULL,NULL,NULL,NULL),(10090,498,380.171,41.1719,NULL,NULL,NULL,NULL),(10091,499,0.0211101,0.189767,NULL,NULL,NULL,NULL),(10092,499,0.134606,0.201395,NULL,NULL,NULL,NULL),(10093,499,0.2612,0.206047,NULL,NULL,NULL,NULL),(10094,499,0.871558,0.215814,NULL,NULL,NULL,NULL),(10095,499,1.09816,0.21907,NULL,NULL,NULL,NULL),(10096,499,2.44805,0.229767,NULL,NULL,NULL,NULL),(10097,499,4.3982,0.24,NULL,NULL,NULL,NULL),(10098,499,7.79128,0.249302,NULL,NULL,NULL,NULL),(10099,499,12.5606,0.258605,NULL,NULL,NULL,NULL),(10100,499,16.7857,0.269302,NULL,NULL,NULL,NULL),(10101,499,31.4398,0.281395,NULL,NULL,NULL,NULL),(10102,499,51.5822,0.296744,NULL,NULL,NULL,NULL),(10103,499,68.8478,0.305581,NULL,NULL,NULL,NULL),(10104,499,79.0934,0.311628,NULL,NULL,NULL,NULL),(10105,499,104.285,0.322326,NULL,NULL,NULL,NULL),(10106,499,126.433,0.328372,NULL,NULL,NULL,NULL),(10107,499,160.004,0.33814,NULL,NULL,NULL,NULL),(10108,499,216.661,0.348372,NULL,NULL,NULL,NULL),(10109,499,263.087,0.356744,NULL,NULL,NULL,NULL),(10110,499,341.602,0.364651,NULL,NULL,NULL,NULL),(10111,499,431.768,0.372558,NULL,NULL,NULL,NULL),(10112,499,469.862,0.37814,NULL,NULL,NULL,NULL),(10113,499,517.118,0.380465,NULL,NULL,NULL,NULL),(10114,499,594.443,0.387442,NULL,NULL,NULL,NULL),(10115,499,673.767,0.393488,NULL,NULL,NULL,NULL),(10116,499,752.749,0.39814,NULL,NULL,NULL,NULL),(10117,499,818.389,0.402326,NULL,NULL,NULL,NULL),(10118,499,913.755,0.406047,NULL,NULL,NULL,NULL),(10119,499,1020.23,0.409767,NULL,NULL,NULL,NULL),(10120,500,0.0427199,0.176744,NULL,NULL,NULL,NULL),(10121,500,0.138237,0.18093,NULL,NULL,NULL,NULL),(10122,500,1.09232,0.191163,NULL,NULL,NULL,NULL),(10123,500,2.24114,0.198605,NULL,NULL,NULL,NULL),(10124,500,5.56604,0.209767,NULL,NULL,NULL,NULL),(10125,500,9.32258,0.215814,NULL,NULL,NULL,NULL),(10126,500,10.8211,0.217209,NULL,NULL,NULL,NULL),(10127,500,16.52,0.225581,NULL,NULL,NULL,NULL),(10128,500,21.741,0.233488,NULL,NULL,NULL,NULL),(10129,500,28.5759,0.239535,NULL,NULL,NULL,NULL),(10130,500,48.1028,0.253023,NULL,NULL,NULL,NULL),(10131,500,62.4008,0.259535,NULL,NULL,NULL,NULL),(10132,500,84.4695,0.269302,NULL,NULL,NULL,NULL),(10133,500,98.3535,0.275349,NULL,NULL,NULL,NULL),(10134,500,148.187,0.284186,NULL,NULL,NULL,NULL),(10135,500,212.427,0.29907,NULL,NULL,NULL,NULL),(10136,500,276.261,0.309302,NULL,NULL,NULL,NULL),(10137,500,317.074,0.313953,NULL,NULL,NULL,NULL),(10138,500,367.46,0.313023,NULL,NULL,NULL,NULL),(10139,500,410.025,0.315814,NULL,NULL,NULL,NULL),(10140,500,452.387,0.32186,NULL,NULL,NULL,NULL),(10141,500,499.137,0.327907,NULL,NULL,NULL,NULL),(10142,500,571.623,0.329302,NULL,NULL,NULL,NULL),(10143,500,637.236,0.330698,NULL,NULL,NULL,NULL),(10144,500,655.858,0.333488,NULL,NULL,NULL,NULL),(10145,500,764.381,0.34093,NULL,NULL,NULL,NULL),(10146,500,853.454,0.344651,NULL,NULL,NULL,NULL),(10147,501,0.00991585,0.167442,NULL,NULL,NULL,NULL),(10148,501,0.0407596,0.166977,NULL,NULL,NULL,NULL),(10149,501,0.269678,0.173488,NULL,NULL,NULL,NULL),(10150,501,0.986316,0.179535,NULL,NULL,NULL,NULL),(10151,501,2.22018,0.184651,NULL,NULL,NULL,NULL),(10152,501,4.30958,0.189767,NULL,NULL,NULL,NULL),(10153,501,7.71843,0.195349,NULL,NULL,NULL,NULL),(10154,501,9.70689,0.195814,NULL,NULL,NULL,NULL),(10155,501,11.7501,0.199535,NULL,NULL,NULL,NULL),(10156,501,25.5059,0.210698,NULL,NULL,NULL,NULL),(10157,501,37.9271,0.22,NULL,NULL,NULL,NULL),(10158,501,45.8955,0.223256,NULL,NULL,NULL,NULL),(10159,501,57.1084,0.227907,NULL,NULL,NULL,NULL),(10160,501,69.0415,0.229767,NULL,NULL,NULL,NULL),(10161,501,85.7749,0.232093,NULL,NULL,NULL,NULL),(10162,501,95.7414,0.235349,NULL,NULL,NULL,NULL),(10163,501,101.228,0.23814,NULL,NULL,NULL,NULL),(10164,501,120.745,0.24,NULL,NULL,NULL,NULL),(10165,501,148.607,0.248372,NULL,NULL,NULL,NULL),(10166,501,174.997,0.251163,NULL,NULL,NULL,NULL),(10167,501,197.852,0.253488,NULL,NULL,NULL,NULL),(10168,501,233.136,0.257209,NULL,NULL,NULL,NULL),(10169,501,271.625,0.264186,NULL,NULL,NULL,NULL),(10170,501,322.077,0.277209,NULL,NULL,NULL,NULL),(10171,501,348.081,0.292558,NULL,NULL,NULL,NULL),(10172,501,356.246,0.286977,NULL,NULL,NULL,NULL),(10173,502,0.00937174,29.3635,NULL,NULL,NULL,NULL),(10174,502,0.958441,43.202,NULL,NULL,NULL,NULL),(10175,502,23.9558,52.3653,NULL,NULL,NULL,NULL),(10176,502,84.8809,57.649,NULL,NULL,NULL,NULL),(10177,502,328.141,62.0142,NULL,NULL,NULL,NULL),(10178,502,468.177,63.465,NULL,NULL,NULL,NULL),(10179,502,598.053,71.9835,NULL,NULL,NULL,NULL),(10180,502,688.811,63.4823,NULL,NULL,NULL,NULL),(10181,502,826.285,66.1553,NULL,NULL,NULL,NULL),(10182,502,951.152,67.6991,NULL,NULL,NULL,NULL),(10183,502,1112.01,68.4236,NULL,NULL,NULL,NULL),(10184,502,1189.19,71.399,NULL,NULL,NULL,NULL),(10185,502,1516.95,71.205,NULL,NULL,NULL,NULL),(10186,502,1698.48,72.1325,NULL,NULL,NULL,NULL),(10187,503,0.00988234,22.4983,NULL,NULL,NULL,NULL),(10188,503,0.977665,29.7752,NULL,NULL,NULL,NULL),(10189,503,24.1218,38.0156,NULL,NULL,NULL,NULL),(10190,503,84.834,38.6865,NULL,NULL,NULL,NULL),(10191,503,144.994,43.7328,NULL,NULL,NULL,NULL),(10192,503,321.159,47.5608,NULL,NULL,NULL,NULL),(10193,503,471.65,48.8078,NULL,NULL,NULL,NULL),(10194,503,577.325,47.4843,NULL,NULL,NULL,NULL),(10195,503,746.707,47.5983,NULL,NULL,NULL,NULL),(10196,503,845.045,50.9863,NULL,NULL,NULL,NULL),(10197,503,972.546,42.9976,NULL,NULL,NULL,NULL),(10198,503,989.145,50.8908,NULL,NULL,NULL,NULL),(10199,503,996.667,45.7662,NULL,NULL,NULL,NULL),(10200,503,1157.47,51.0003,NULL,NULL,NULL,NULL),(10201,503,1166.11,45.9781,NULL,NULL,NULL,NULL),(10202,503,1297,51.4154,NULL,NULL,NULL,NULL),(10203,503,1430.28,52.9573,NULL,NULL,NULL,NULL),(10204,503,1556.54,53.781,NULL,NULL,NULL,NULL),(10205,504,0.00960661,22.292,NULL,NULL,NULL,NULL),(10206,504,0.954718,26.4942,NULL,NULL,NULL,NULL),(10207,504,19.1439,29.9077,NULL,NULL,NULL,NULL),(10208,504,86.6184,34.28,NULL,NULL,NULL,NULL),(10209,504,109.837,38.083,NULL,NULL,NULL,NULL),(10210,504,273.647,39.7637,NULL,NULL,NULL,NULL),(10211,504,463.095,41.837,NULL,NULL,NULL,NULL),(10212,504,567.035,40.3086,NULL,NULL,NULL,NULL),(10213,504,722.437,40.9343,NULL,NULL,NULL,NULL),(10214,504,827.828,45.5529,NULL,NULL,NULL,NULL),(10215,504,984.17,44.6381,NULL,NULL,NULL,NULL),(10216,504,1152.68,44.1327,NULL,NULL,NULL,NULL),(10217,504,1213.36,48.1324,NULL,NULL,NULL,NULL),(10218,504,1921.85,46.6154,NULL,NULL,NULL,NULL),(10219,505,0.00954971,16.6542,NULL,NULL,NULL,NULL),(10220,505,0.950915,19.5241,NULL,NULL,NULL,NULL),(10221,505,27.672,22.5441,NULL,NULL,NULL,NULL),(10222,505,93.42,31.5158,NULL,NULL,NULL,NULL),(10223,505,127.547,24.0471,NULL,NULL,NULL,NULL),(10224,505,192.34,26.7305,NULL,NULL,NULL,NULL),(10225,505,300.843,33.7204,NULL,NULL,NULL,NULL),(10226,505,320.782,29.0081,NULL,NULL,NULL,NULL),(10227,505,374.973,29.8351,NULL,NULL,NULL,NULL),(10228,505,423.77,34.1457,NULL,NULL,NULL,NULL),(10229,505,504.557,32.2059,NULL,NULL,NULL,NULL),(10230,505,568.761,38.2586,NULL,NULL,NULL,NULL),(10231,505,627.408,39.5956,NULL,NULL,NULL,NULL),(10232,505,631.51,35.1883,NULL,NULL,NULL,NULL),(10233,505,781.286,36.3253,NULL,NULL,NULL,NULL),(10234,505,1013.89,34.1844,NULL,NULL,NULL,NULL),(10235,506,0.608611,27.3847,NULL,NULL,NULL,NULL),(10236,506,2.36477,28.1962,NULL,NULL,NULL,NULL),(10237,506,3.29448,29.2611,NULL,NULL,NULL,NULL),(10238,506,6.27599,29.8189,NULL,NULL,NULL,NULL),(10239,506,15.9934,31.1882,NULL,NULL,NULL,NULL),(10240,506,20.904,31.7968,NULL,NULL,NULL,NULL),(10241,506,31.1399,33.2167,NULL,NULL,NULL,NULL),(10242,506,42.0061,33.9266,NULL,NULL,NULL,NULL),(10243,506,69.7522,35.4987,NULL,NULL,NULL,NULL),(10244,506,77.6786,35.3973,NULL,NULL,NULL,NULL),(10245,506,82.6079,36.1581,NULL,NULL,NULL,NULL),(10246,506,107.297,36.1073,NULL,NULL,NULL,NULL),(10247,506,150.524,37.578,NULL,NULL,NULL,NULL),(10248,506,181.058,38.3893,NULL,NULL,NULL,NULL),(10249,506,207.96,38.3893,NULL,NULL,NULL,NULL),(10250,506,235.213,38.6936,NULL,NULL,NULL,NULL),(10251,506,268.092,39.15,NULL,NULL,NULL,NULL),(10252,506,291.782,39.8094,NULL,NULL,NULL,NULL),(10253,506,359.191,40.4178,NULL,NULL,NULL,NULL),(10254,507,0.241358,28.6346,NULL,NULL,NULL,NULL),(10255,507,0.355865,28.8254,NULL,NULL,NULL,NULL),(10256,507,0.60097,29.1181,NULL,NULL,NULL,NULL),(10257,507,1.10065,29.5136,NULL,NULL,NULL,NULL),(10258,507,2.06168,30.2185,NULL,NULL,NULL,NULL),(10259,507,3.02061,32.6782,NULL,NULL,NULL,NULL),(10260,507,4.02969,32.7744,NULL,NULL,NULL,NULL),(10261,507,5.00088,32.5638,NULL,NULL,NULL,NULL),(10262,507,6.0377,32.6109,NULL,NULL,NULL,NULL),(10263,507,7.02257,32.7618,NULL,NULL,NULL,NULL),(10264,507,13.9337,32.6949,NULL,NULL,NULL,NULL),(10265,507,21.1874,34.0741,NULL,NULL,NULL,NULL),(10266,507,27.9287,35.4051,NULL,NULL,NULL,NULL),(10267,507,55.9966,39.5555,NULL,NULL,NULL,NULL),(10268,507,82.9218,40.8325,NULL,NULL,NULL,NULL),(10269,507,110.393,42.729,NULL,NULL,NULL,NULL),(10270,507,138.879,43.8041,NULL,NULL,NULL,NULL),(10271,507,165.043,44.3145,NULL,NULL,NULL,NULL),(10272,507,192.425,44.7225,NULL,NULL,NULL,NULL),(10273,507,220.149,44.8737,NULL,NULL,NULL,NULL),(10274,507,246.951,45.3856,NULL,NULL,NULL,NULL),(10275,507,274.227,46.2575,NULL,NULL,NULL,NULL),(10276,507,298.913,46.6156,NULL,NULL,NULL,NULL),(10277,507,328.949,47.0249,NULL,NULL,NULL,NULL),(10278,507,355.154,47.3318,NULL,NULL,NULL,NULL),(10279,508,0.245251,26.3281,NULL,NULL,NULL,NULL),(10280,508,0.358621,27.0337,NULL,NULL,NULL,NULL),(10281,508,0.602813,25.938,NULL,NULL,NULL,NULL),(10282,508,1.0931,27.7739,NULL,NULL,NULL,NULL),(10283,508,2.0845,28.3753,NULL,NULL,NULL,NULL),(10284,508,3.06093,29.2406,NULL,NULL,NULL,NULL),(10285,508,4.04736,29.0799,NULL,NULL,NULL,NULL),(10286,508,4.97328,29.2808,NULL,NULL,NULL,NULL),(10287,508,6.11707,29.5333,NULL,NULL,NULL,NULL),(10288,508,7.96769,30.1445,NULL,NULL,NULL,NULL),(10289,508,15.026,33.1131,NULL,NULL,NULL,NULL),(10290,508,21.1786,34.0827,NULL,NULL,NULL,NULL),(10291,508,27.9517,34.4879,NULL,NULL,NULL,NULL),(10292,508,55.6912,36.1183,NULL,NULL,NULL,NULL),(10293,508,83.1414,38.5265,NULL,NULL,NULL,NULL),(10294,508,111.824,39.9601,NULL,NULL,NULL,NULL),(10295,508,138.123,40.3668,NULL,NULL,NULL,NULL),(10296,508,163.986,41.5973,NULL,NULL,NULL,NULL),(10297,508,193.112,41.748,NULL,NULL,NULL,NULL),(10298,508,218.564,42.7738,NULL,NULL,NULL,NULL),(10299,508,247.691,42.8224,NULL,NULL,NULL,NULL),(10300,508,272.622,43.1289,NULL,NULL,NULL,NULL),(10301,508,303,43.3323,NULL,NULL,NULL,NULL),(10302,508,326.979,43.9992,NULL,NULL,NULL,NULL),(10303,508,356.276,44.6658,NULL,NULL,NULL,NULL),(10304,509,1.02329,34.235,NULL,NULL,NULL,NULL),(10305,509,2.0547,35.3113,NULL,NULL,NULL,NULL),(10306,509,3.01523,35.67,NULL,NULL,NULL,NULL),(10307,509,4.01914,36.3875,NULL,NULL,NULL,NULL),(10308,509,4.99731,36.7463,NULL,NULL,NULL,NULL),(10309,509,5.94822,37.1563,NULL,NULL,NULL,NULL),(10310,509,7.01989,37.2587,NULL,NULL,NULL,NULL),(10311,509,7.85956,37.925,NULL,NULL,NULL,NULL),(10312,509,8.95674,38.1813,NULL,NULL,NULL,NULL),(10313,509,9.94223,38.6426,NULL,NULL,NULL,NULL),(10314,509,10.9433,38.6426,NULL,NULL,NULL,NULL),(10315,509,12.0448,38.6937,NULL,NULL,NULL,NULL),(10316,509,12.9101,39.3601,NULL,NULL,NULL,NULL),(10317,509,13.9624,39.6163,NULL,NULL,NULL,NULL),(10318,509,14.8368,40.1287,NULL,NULL,NULL,NULL),(10319,509,16.911,40.0776,NULL,NULL,NULL,NULL),(10320,509,18.7694,40.7439,NULL,NULL,NULL,NULL),(10321,509,21.0179,41.1539,NULL,NULL,NULL,NULL),(10322,509,23.7432,41.4614,NULL,NULL,NULL,NULL),(10323,509,27.2929,41.82,NULL,NULL,NULL,NULL),(10324,509,30.5619,42.2301,NULL,NULL,NULL,NULL),(10325,509,35.1229,42.9988,NULL,NULL,NULL,NULL),(10326,509,42.1735,43.3576,NULL,NULL,NULL,NULL),(10327,509,48.0485,44.0239,NULL,NULL,NULL,NULL),(10328,509,54.2738,44.4851,NULL,NULL,NULL,NULL),(10329,509,61.3225,44.4851,NULL,NULL,NULL,NULL),(10330,509,69.8667,45.1513,NULL,NULL,NULL,NULL),(10331,509,74.2352,45.8176,NULL,NULL,NULL,NULL),(10332,509,83.8707,45.9201,NULL,NULL,NULL,NULL),(10333,509,88.3446,46.5351,NULL,NULL,NULL,NULL),(10334,509,103.314,47.3038,NULL,NULL,NULL,NULL),(10335,509,114.707,47.4063,NULL,NULL,NULL,NULL),(10336,509,128.431,48.0213,NULL,NULL,NULL,NULL),(10337,509,142.541,48.7388,NULL,NULL,NULL,NULL),(10338,509,158.194,49.5076,NULL,NULL,NULL,NULL),(10339,509,171.041,50.2251,NULL,NULL,NULL,NULL),(10340,509,185.008,50.2251,NULL,NULL,NULL,NULL),(10341,509,194.868,50.8913,NULL,NULL,NULL,NULL),(10342,509,205.329,50.9426,NULL,NULL,NULL,NULL),(10343,509,223.955,51.6088,NULL,NULL,NULL,NULL),(10344,509,238.051,51.6088,NULL,NULL,NULL,NULL),(10345,509,242.092,52.6339,NULL,NULL,NULL,NULL),(10346,509,271.082,53.0951,NULL,NULL,NULL,NULL),(10347,509,308.966,53.1463,NULL,NULL,NULL,NULL),(10348,509,336.977,53.8638,NULL,NULL,NULL,NULL),(10349,509,351.852,54.5301,NULL,NULL,NULL,NULL),(10350,509,394.067,54.6839,NULL,NULL,NULL,NULL),(10351,509,481.404,55.35,NULL,NULL,NULL,NULL),(10352,509,534.306,56.0163,NULL,NULL,NULL,NULL),(10353,509,548.252,56.6826,NULL,NULL,NULL,NULL),(10354,509,598.164,56.8364,NULL,NULL,NULL,NULL),(10355,509,641.18,57.4001,NULL,NULL,NULL,NULL),(10356,509,669.468,58.1176,NULL,NULL,NULL,NULL),(10357,509,717.695,58.4763,NULL,NULL,NULL,NULL),(10358,509,769.396,58.8351,NULL,NULL,NULL,NULL),(10359,509,831.84,59.6038,NULL,NULL,NULL,NULL),(10360,509,853.729,59.9113,NULL,NULL,NULL,NULL),(10361,509,899.353,60.3725,NULL,NULL,NULL,NULL),(10362,509,939.074,61.0388,NULL,NULL,NULL,NULL),(10363,509,1042.49,61.3463,NULL,NULL,NULL,NULL),(10364,509,1117.56,61.7563,NULL,NULL,NULL,NULL),(10365,509,1230.13,61.7051,NULL,NULL,NULL,NULL),(10366,510,1.12492,82.8495,NULL,NULL,NULL,NULL),(10367,510,23.6042,103.306,NULL,NULL,NULL,NULL),(10368,510,46.3938,116.398,NULL,NULL,NULL,NULL),(10369,510,102.216,128.059,NULL,NULL,NULL,NULL),(10370,510,153.695,131.127,NULL,NULL,NULL,NULL),(10371,510,202.558,134.809,NULL,NULL,NULL,NULL),(10372,510,310.327,137.878,NULL,NULL,NULL,NULL),(10373,510,531.105,142.174,NULL,NULL,NULL,NULL),(10374,510,755.37,144.833,NULL,NULL,NULL,NULL),(10375,511,2.15996,41.5271,NULL,NULL,NULL,NULL),(10376,511,19.2739,57.2786,NULL,NULL,NULL,NULL),(10377,511,41.7542,67.5069,NULL,NULL,NULL,NULL),(10378,511,90.7173,75.485,NULL,NULL,NULL,NULL),(10379,511,146.855,79.3719,NULL,NULL,NULL,NULL),(10380,511,186.479,82.8495,NULL,NULL,NULL,NULL),(10381,511,296.203,86.9408,NULL,NULL,NULL,NULL),(10382,511,357.182,86.9408,NULL,NULL,NULL,NULL),(10383,512,21.464,31.9124,NULL,NULL,NULL,NULL),(10384,512,69.0558,40.2996,NULL,NULL,NULL,NULL),(10385,512,122.758,44.1863,NULL,NULL,NULL,NULL),(10386,512,174.828,45.8229,NULL,NULL,NULL,NULL),(10387,512,226.731,47.4594,NULL,NULL,NULL,NULL),(10388,512,283.537,48.2777,NULL,NULL,NULL,NULL),(10389,512,467.552,52.3691,NULL,NULL,NULL,NULL),(10390,512,744.423,54.6193,NULL,NULL,NULL,NULL),(10391,513,9.73942,20.4567,NULL,NULL,NULL,NULL),(10392,513,54.9883,28.2301,NULL,NULL,NULL,NULL),(10393,513,109.373,32.117,NULL,NULL,NULL,NULL),(10394,513,171.045,33.7535,NULL,NULL,NULL,NULL),(10395,513,217.831,34.9809,NULL,NULL,NULL,NULL),(10396,513,261.909,37.2312,NULL,NULL,NULL,NULL),(10397,514,35.005,15.547,NULL,NULL,NULL,NULL),(10398,514,77.983,18.6156,NULL,NULL,NULL,NULL),(10399,514,136.276,21.2749,NULL,NULL,NULL,NULL),(10400,514,201.321,23.5251,NULL,NULL,NULL,NULL),(10401,514,271.119,24.9571,NULL,NULL,NULL,NULL),(10402,514,345.279,26.1845,NULL,NULL,NULL,NULL),(10403,514,448.497,26.5937,NULL,NULL,NULL,NULL),(10404,515,0.988689,51.9067,NULL,NULL,NULL,NULL),(10405,515,9.85571,62.2879,NULL,NULL,NULL,NULL),(10406,515,39.5767,74.5333,NULL,NULL,NULL,NULL),(10407,515,98.6847,87.0209,NULL,NULL,NULL,NULL),(10408,515,197.301,100.701,NULL,NULL,NULL,NULL),(10409,515,397.933,114.534,NULL,NULL,NULL,NULL),(10410,515,590.215,123.746,NULL,NULL,NULL,NULL),(10411,515,990.9,131.601,NULL,NULL,NULL,NULL),(10412,515,1470.86,138.219,NULL,NULL,NULL,NULL),(10413,515,1946.61,144.973,NULL,NULL,NULL,NULL),(10414,516,0.94893,41.825,NULL,NULL,NULL,NULL),(10415,516,9.9002,47.4794,NULL,NULL,NULL,NULL),(10416,516,39.8602,51.023,NULL,NULL,NULL,NULL),(10417,516,99.5979,56.7932,NULL,NULL,NULL,NULL),(10418,516,196.024,64.0585,NULL,NULL,NULL,NULL),(10419,516,399.659,71.3285,NULL,NULL,NULL,NULL),(10420,516,593.021,79.1671,NULL,NULL,NULL,NULL),(10421,516,986.984,86.5629,NULL,NULL,NULL,NULL),(10422,516,1478.09,93.0287,NULL,NULL,NULL,NULL),(10423,516,1972.38,101.769,NULL,NULL,NULL,NULL),(10424,517,0.99246,39.3882,NULL,NULL,NULL,NULL),(10425,517,9.83105,41.5243,NULL,NULL,NULL,NULL),(10426,517,39.942,44.3057,NULL,NULL,NULL,NULL),(10427,517,99.0307,46.5635,NULL,NULL,NULL,NULL),(10428,517,196.798,51.082,NULL,NULL,NULL,NULL),(10429,517,394.566,55.4491,NULL,NULL,NULL,NULL),(10430,517,596.499,59.9313,NULL,NULL,NULL,NULL),(10431,517,993.802,63.9685,NULL,NULL,NULL,NULL),(10432,517,1490.42,65.7015,NULL,NULL,NULL,NULL),(10433,517,1975.38,67.7236,NULL,NULL,NULL,NULL),(10434,518,1.10699,28.8478,NULL,NULL,NULL,NULL),(10435,518,10.1604,30.5295,NULL,NULL,NULL,NULL),(10436,518,39.8602,32.2386,NULL,NULL,NULL,NULL),(10437,518,99.4773,36.0242,NULL,NULL,NULL,NULL),(10438,518,202.968,38.867,NULL,NULL,NULL,NULL),(10439,518,403.412,41.8588,NULL,NULL,NULL,NULL),(10440,518,605.015,43.2866,NULL,NULL,NULL,NULL),(10441,518,999.844,44.7274,NULL,NULL,NULL,NULL),(10442,518,1498.53,48.4451,NULL,NULL,NULL,NULL),(10443,518,1985.53,51.3832,NULL,NULL,NULL,NULL),(10454,520,0.01,141.325,NULL,1,NULL,NULL),(10455,520,0.0192659,193.615,NULL,NULL,NULL,NULL),(10456,520,0.124025,206.611,NULL,NULL,NULL,NULL),(10457,520,0.977163,231.055,NULL,NULL,NULL,NULL),(10458,520,1.74675,239.718,NULL,NULL,NULL,NULL),(10459,520,2.0299,241.266,NULL,NULL,NULL,NULL),(10460,520,5.92723,249.929,NULL,NULL,NULL,NULL),(10461,520,8.62327,255.19,NULL,NULL,NULL,NULL),(10462,520,12.0826,260.14,NULL,NULL,NULL,NULL),(10463,520,16.9762,259.52,NULL,NULL,NULL,NULL),(10464,520,20.0826,263.233,NULL,NULL,NULL,NULL),(10465,520,23.7936,263.853,NULL,NULL,NULL,NULL),(10466,520,30.9756,264.781,NULL,NULL,NULL,NULL),(10467,520,32.1041,268.803,NULL,NULL,NULL,NULL),(10468,520,40.2522,269.422,NULL,NULL,NULL,NULL),(10469,520,48.745,263.853,NULL,NULL,NULL,NULL),(10470,520,57.6315,268.803,NULL,NULL,NULL,NULL),(10471,520,65.7113,270.659,NULL,NULL,NULL,NULL),(10472,520,77.913,269.731,NULL,NULL,NULL,NULL),(10473,520,82.2148,275.611,NULL,NULL,NULL,NULL),(10474,521,0.01,97.0785,NULL,1,NULL,NULL),(10475,521,0.0184264,130.186,NULL,NULL,NULL,NULL),(10476,521,0.125931,136.684,NULL,NULL,NULL,NULL),(10477,521,0.298685,145.966,NULL,NULL,NULL,NULL),(10478,521,1.05475,151.844,NULL,NULL,NULL,NULL),(10479,521,3.84984,167.316,NULL,NULL,NULL,NULL),(10480,521,7.01084,176.598,NULL,NULL,NULL,NULL),(10481,521,9.45381,182.787,NULL,NULL,NULL,NULL),(10482,521,15.3986,188.665,NULL,NULL,NULL,NULL),(10483,521,18.2217,191.759,NULL,NULL,NULL,NULL),(10484,521,19.9797,196.4,NULL,NULL,NULL,NULL),(10485,521,21.1023,200.423,NULL,NULL,NULL,NULL),(10486,521,30.7659,201.352,NULL,NULL,NULL,NULL),(10487,521,34.4128,203.826,NULL,NULL,NULL,NULL),(10488,521,38.5274,204.445,NULL,NULL,NULL,NULL),(10489,521,53.0787,205.373,NULL,NULL,NULL,NULL),(10490,521,62.8767,206.302,NULL,NULL,NULL,NULL),(10491,521,71.5303,212.799,NULL,NULL,NULL,NULL),(10492,521,81.5849,214.037,NULL,NULL,NULL,NULL),(10493,521,93.0079,216.203,NULL,NULL,NULL,NULL),(10494,522,0,70.6479,NULL,1,NULL,NULL),(10495,522,0.00910073,89.5221,NULL,NULL,NULL,NULL),(10496,522,0.120459,97.2575,NULL,NULL,NULL,NULL),(10497,522,0.135859,100.661,NULL,NULL,NULL,NULL),(10498,522,0.987738,105.302,NULL,NULL,NULL,NULL),(10499,522,3.19216,113.656,NULL,NULL,NULL,NULL),(10500,522,7.28926,126.961,NULL,NULL,NULL,NULL),(10501,522,11.8665,135.006,NULL,NULL,NULL,NULL),(10502,522,15.7338,137.481,NULL,NULL,NULL,NULL),(10503,522,18.6237,140.266,NULL,NULL,NULL,NULL),(10504,522,20.4554,141.503,NULL,NULL,NULL,NULL),(10505,522,25.6337,143.36,NULL,NULL,NULL,NULL),(10506,522,26.0671,147.692,NULL,NULL,NULL,NULL),(10507,522,35.9161,148.62,NULL,NULL,NULL,NULL),(10508,522,41.7211,151.096,NULL,NULL,NULL,NULL),(10509,522,48.4496,154.19,NULL,NULL,NULL,NULL),(10510,522,55.2766,154.809,NULL,NULL,NULL,NULL),(10511,522,63.0857,154.809,NULL,NULL,NULL,NULL),(10512,522,74.745,155.427,NULL,NULL,NULL,NULL),(10513,522,83.6947,155.737,NULL,NULL,NULL,NULL),(10514,522,95.4453,157.283,NULL,NULL,NULL,NULL),(10515,523,0.01,51.5947,NULL,1,NULL,NULL),(10516,523,0.0201767,60.2584,NULL,NULL,NULL,NULL),(10517,523,0.354466,65.8278,NULL,NULL,NULL,NULL),(10518,523,1.07647,71.3973,NULL,NULL,NULL,NULL),(10519,523,7.63519,79.1326,NULL,NULL,NULL,NULL),(10520,523,10.3191,80.6797,NULL,NULL,NULL,NULL),(10521,523,15.8994,84.3927,NULL,NULL,NULL,NULL),(10522,523,17.7893,86.2492,NULL,NULL,NULL,NULL),(10523,523,21.8842,87.1774,NULL,NULL,NULL,NULL),(10524,523,27.4429,87.4868,NULL,NULL,NULL,NULL),(10525,523,31.9102,87.7961,NULL,NULL,NULL,NULL),(10526,523,36.3739,90.2715,NULL,NULL,NULL,NULL),(10527,523,41.5174,89.9621,NULL,NULL,NULL,NULL),(10528,523,50.1637,89.0339,NULL,NULL,NULL,NULL),(10529,523,59.2994,94.2938,NULL,NULL,NULL,NULL),(10530,523,80.1807,94.9127,NULL,NULL,NULL,NULL),(10531,523,96.7765,96.1503,NULL,NULL,NULL,NULL),(10532,523,119.017,97.6974,NULL,NULL,NULL,NULL),(10533,523,149.087,100.173,NULL,NULL,NULL,NULL),(10534,523,170.016,101.72,NULL,NULL,NULL,NULL),(10535,523,201.405,102.648,NULL,NULL,NULL,NULL),(10536,523,252.522,103.267,NULL,NULL,NULL,NULL),(10537,523,304.789,104.504,NULL,NULL,NULL,NULL),(10538,524,0,41.7405,NULL,1,NULL,NULL),(10539,524,0.00917874,46.6913,NULL,NULL,NULL,NULL),(10540,524,0.259621,44.8348,NULL,NULL,NULL,NULL),(10541,524,0.82554,47.6195,NULL,NULL,NULL,NULL),(10542,524,1.07856,47.0006,NULL,NULL,NULL,NULL),(10543,524,2.13556,48.8571,NULL,NULL,NULL,NULL),(10544,524,7.01886,53.8077,NULL,NULL,NULL,NULL),(10545,524,16.419,54.4266,NULL,NULL,NULL,NULL),(10546,524,71.4446,58.7584,NULL,NULL,NULL,NULL),(10547,524,89.5801,59.3771,NULL,NULL,NULL,NULL),(10548,524,105.91,64.3278,NULL,NULL,NULL,NULL),(10549,524,125.333,67.4219,NULL,NULL,NULL,NULL),(10550,524,179.154,70.2067,NULL,NULL,NULL,NULL),(10551,524,246.708,72.0631,NULL,NULL,NULL,NULL),(10552,524,292.298,72.682,NULL,NULL,NULL,NULL),(10553,524,1033.13,76.7043,NULL,NULL,NULL,NULL),(10554,525,0.01,120.314,NULL,1,NULL,NULL),(10555,525,0.0268269,178.47,NULL,NULL,NULL,NULL),(10556,525,0.150859,193.205,NULL,NULL,NULL,NULL),(10557,525,1.17877,218.507,NULL,NULL,NULL,NULL),(10558,525,2.27585,230.392,NULL,NULL,NULL,NULL),(10559,525,3.43332,232.91,NULL,NULL,NULL,NULL),(10560,525,6.62871,242.486,NULL,NULL,NULL,NULL),(10561,525,10,246.16,NULL,NULL,NULL,NULL),(10562,525,20.9619,256.933,NULL,NULL,NULL,NULL),(10563,525,31.6228,259.449,NULL,NULL,NULL,NULL),(10564,525,43.94,261.927,NULL,NULL,NULL,NULL),(10565,525,61.0534,259.78,NULL,NULL,NULL,NULL),(10566,525,78.1376,263.371,NULL,NULL,NULL,NULL),(10567,525,92.1064,270.388,NULL,NULL,NULL,NULL),(10568,526,0.01,69.5472,NULL,1,NULL,NULL),(10569,526,0.0247093,105.621,NULL,NULL,NULL,NULL),(10570,526,0.138949,118.044,NULL,NULL,NULL,NULL),(10571,526,0.517948,126.794,NULL,NULL,NULL,NULL),(10572,526,1.08571,132.944,NULL,NULL,NULL,NULL),(10573,526,4.39397,150.981,NULL,NULL,NULL,NULL),(10574,526,7.19686,160.474,NULL,NULL,NULL,NULL),(10575,526,13.895,168.894,NULL,NULL,NULL,NULL),(10576,526,22.7583,181.854,NULL,NULL,NULL,NULL),(10577,526,29.1266,187.757,NULL,NULL,NULL,NULL),(10578,526,37.2761,190.192,NULL,NULL,NULL,NULL),(10579,526,61.0534,199.685,NULL,NULL,NULL,NULL),(10580,526,84.834,203.317,NULL,NULL,NULL,NULL),(10581,527,0,43.0768,NULL,1,NULL,NULL),(10582,527,0.0168269,65.4474,NULL,NULL,NULL,NULL),(10583,527,0.11798,74.3214,NULL,NULL,NULL,NULL),(10584,527,1.16877,86.9925,NULL,NULL,NULL,NULL),(10585,527,3.15228,95.5776,NULL,NULL,NULL,NULL),(10586,527,7.18686,109.859,NULL,NULL,NULL,NULL),(10587,527,11.7777,115.885,NULL,NULL,NULL,NULL),(10588,527,22.7483,126.616,NULL,NULL,NULL,NULL),(10589,527,34.3229,130.289,NULL,NULL,NULL,NULL),(10590,527,47.6957,135.077,NULL,NULL,NULL,NULL),(10591,527,66.2773,141.021,NULL,NULL,NULL,NULL),(10592,527,99.99,143.539,NULL,NULL,NULL,NULL),(10593,528,0.01,21.9992,NULL,1,NULL,NULL),(10594,528,0.0227583,35.0832,NULL,NULL,NULL,NULL),(10595,528,0.291263,40.9853,NULL,NULL,NULL,NULL),(10596,528,1,47.3828,NULL,NULL,NULL,NULL),(10597,528,3.16228,52.5834,NULL,NULL,NULL,NULL),(10598,528,7.8137,58.8158,NULL,NULL,NULL,NULL),(10599,528,10.857,61.2922,NULL,NULL,NULL,NULL),(10600,528,17.7828,67.3183,NULL,NULL,NULL,NULL),(10601,528,29.1266,67.566,NULL,NULL,NULL,NULL),(10602,528,43.94,70.0837,NULL,NULL,NULL,NULL),(10603,528,56.2341,74.8302,NULL,NULL,NULL,NULL),(10604,528,78.1376,74.9954,NULL,NULL,NULL,NULL),(10605,528,138.95,79.9069,NULL,NULL,NULL,NULL),(10606,528,177.828,81.1865,NULL,NULL,NULL,NULL),(10607,528,316.228,86.098,NULL,NULL,NULL,NULL),(10608,528,719.681,92.2893,NULL,NULL,NULL,NULL),(10609,529,0.01,10.5662,NULL,1,NULL,NULL),(10610,529,0.0209619,20.018,NULL,NULL,NULL,NULL),(10611,529,0.291263,22.4945,NULL,NULL,NULL,NULL),(10612,529,0.848343,25.3424,NULL,NULL,NULL,NULL),(10613,529,2.91263,28.2729,NULL,NULL,NULL,NULL),(10614,529,7.8137,32.2352,NULL,NULL,NULL,NULL),(10615,529,16.3791,33.7623,NULL,NULL,NULL,NULL),(10616,529,61.0534,36.7341,NULL,NULL,NULL,NULL),(10617,529,100,43.9158,NULL,NULL,NULL,NULL),(10618,529,163.791,49.9419,NULL,NULL,NULL,NULL),(10619,529,209.619,51.2214,NULL,NULL,NULL,NULL),(10620,529,268.269,53.6566,NULL,NULL,NULL,NULL),(10621,529,662.872,59.889,NULL,NULL,NULL,NULL),(10622,530,0.0215168,129.774,NULL,NULL,NULL,NULL),(10623,530,0.12709,194.79,NULL,NULL,NULL,NULL),(10624,530,0.295592,232.388,NULL,NULL,NULL,NULL),(10625,530,0.502332,267.438,NULL,NULL,NULL,NULL),(10626,530,0.872471,310.292,NULL,NULL,NULL,NULL),(10627,530,1.12264,337.604,NULL,NULL,NULL,NULL),(10628,530,2.04898,397.395,NULL,NULL,NULL,NULL),(10629,530,3.16155,454.651,NULL,NULL,NULL,NULL),(10630,530,3.99369,501.562,NULL,NULL,NULL,NULL),(10631,530,5.12256,526.252,NULL,NULL,NULL,NULL),(10632,530,5.46994,553.654,NULL,NULL,NULL,NULL),(10633,530,7.32958,579.625,NULL,NULL,NULL,NULL),(10634,530,8.2534,593.931,NULL,NULL,NULL,NULL),(10635,530,9.37769,610.847,NULL,NULL,NULL,NULL),(10636,530,10.296,660.447,NULL,NULL,NULL,NULL),(10637,530,13.6312,678.582,NULL,NULL,NULL,NULL),(10638,530,19.9843,759.378,NULL,NULL,NULL,NULL),(10639,531,0.208167,166.834,NULL,NULL,NULL,NULL),(10640,531,0.913887,277.06,NULL,NULL,NULL,NULL),(10641,531,1.09308,286.104,NULL,NULL,NULL,NULL),(10642,531,1.21821,306.949,NULL,NULL,NULL,NULL),(10643,531,2.0153,365.463,NULL,NULL,NULL,NULL),(10644,531,3.18614,412.242,NULL,NULL,NULL,NULL),(10645,531,4.02536,440.857,NULL,NULL,NULL,NULL),(10646,531,5.27299,477.289,NULL,NULL,NULL,NULL),(10647,531,5.62195,503.385,NULL,NULL,NULL,NULL),(10648,531,7.36148,533.285,NULL,NULL,NULL,NULL),(10649,531,8.20217,550.211,NULL,NULL,NULL,NULL),(10650,531,9.39591,582.799,NULL,NULL,NULL,NULL),(10651,531,13.6905,608.719,NULL,NULL,NULL,NULL),(10652,531,19.8683,714.346,NULL,NULL,NULL,NULL),(10653,532,0.409357,133.785,NULL,NULL,NULL,NULL),(10654,532,0.591024,155.789,NULL,NULL,NULL,NULL),(10655,532,0.88532,196.066,NULL,NULL,NULL,NULL),(10656,532,1.21206,224.634,NULL,NULL,NULL,NULL),(10657,532,2.13061,254.367,NULL,NULL,NULL,NULL),(10658,532,4.07092,333.704,NULL,NULL,NULL,NULL),(10659,532,5.14112,355.785,NULL,NULL,NULL,NULL),(10660,532,5.52559,367.504,NULL,NULL,NULL,NULL),(10661,532,7.23881,405.244,NULL,NULL,NULL,NULL),(10662,532,8.06354,418.248,NULL,NULL,NULL,NULL),(10663,532,9.58284,467.803,NULL,NULL,NULL,NULL),(10664,532,13.6007,501.578,NULL,NULL,NULL,NULL),(10665,532,20.7864,578.429,NULL,NULL,NULL,NULL),(10666,532,27.2904,651.447,NULL,NULL,NULL,NULL),(10667,533,0.784927,125.575,NULL,NULL,NULL,NULL),(10668,533,0.785999,147.788,NULL,NULL,NULL,NULL),(10669,533,1.19685,164.535,NULL,NULL,NULL,NULL),(10670,533,1.97774,204.757,NULL,NULL,NULL,NULL),(10671,533,2.32426,217.731,NULL,NULL,NULL,NULL),(10672,533,3.0142,235.876,NULL,NULL,NULL,NULL),(10673,533,5.1205,290.455,NULL,NULL,NULL,NULL),(10674,533,5.55009,294.329,NULL,NULL,NULL,NULL),(10675,533,7.33253,324.225,NULL,NULL,NULL,NULL),(10676,533,8.62277,347.653,NULL,NULL,NULL,NULL),(10677,533,9.60367,358.045,NULL,NULL,NULL,NULL),(10678,533,13.1595,400.984,NULL,NULL,NULL,NULL),(10679,533,18.1882,438.694,NULL,NULL,NULL,NULL),(10680,534,0.598964,82.6096,NULL,NULL,NULL,NULL),(10681,534,0.812211,100.73,NULL,NULL,NULL,NULL),(10682,534,1.22597,120.096,NULL,NULL,NULL,NULL),(10683,534,1.95262,142.045,NULL,NULL,NULL,NULL),(10684,534,2.25305,147.19,NULL,NULL,NULL,NULL),(10685,534,3.0009,164.014,NULL,NULL,NULL,NULL),(10686,534,3.02439,145.717,NULL,NULL,NULL,NULL),(10687,534,5.46947,201.566,NULL,NULL,NULL,NULL),(10688,534,7.22718,234.074,NULL,NULL,NULL,NULL),(10689,534,8.04995,245.772,NULL,NULL,NULL,NULL),(10690,534,9.46795,271.814,NULL,NULL,NULL,NULL),(10691,534,12.0584,286.049,NULL,NULL,NULL,NULL),(10692,535,0.40742,56.6954,NULL,NULL,NULL,NULL),(10693,535,0.818504,81.1257,NULL,NULL,NULL,NULL),(10694,535,1.20283,100.507,NULL,NULL,NULL,NULL),(10695,535,1.96791,123.747,NULL,NULL,NULL,NULL),(10696,535,2.31195,131.496,NULL,NULL,NULL,NULL),(10697,535,5.36408,175.443,NULL,NULL,NULL,NULL),(10698,535,6.89568,196.208,NULL,NULL,NULL,NULL),(10699,535,8.17847,213.098,NULL,NULL,NULL,NULL),(10700,535,9.35447,220.861,NULL,NULL,NULL,NULL),(10701,535,11.9157,237.71,NULL,NULL,NULL,NULL),(10702,536,0.43337,44.9005,NULL,NULL,NULL,NULL),(10703,536,0.788913,62.8536,NULL,NULL,NULL,NULL),(10704,536,2.91224,111.765,NULL,NULL,NULL,NULL),(10705,536,4.20127,120.704,NULL,NULL,NULL,NULL),(10706,536,6.06281,134.869,NULL,NULL,NULL,NULL),(10707,536,6.87243,141.331,NULL,NULL,NULL,NULL),(10708,536,8.14826,152.995,NULL,NULL,NULL,NULL),(10709,536,10.0039,151.57,NULL,NULL,NULL,NULL),(10710,536,11.9715,151.57,NULL,NULL,NULL,NULL),(10711,536,16.9703,151.57,NULL,NULL,NULL,NULL),(10712,537,1.03094,60.0884,NULL,NULL,NULL,NULL),(10713,537,1.71526,66.3327,NULL,NULL,NULL,NULL),(10714,537,2.0511,71.4579,NULL,NULL,NULL,NULL),(10715,537,2.75574,84.3567,NULL,NULL,NULL,NULL),(10716,537,3.29398,82.9488,NULL,NULL,NULL,NULL),(10717,537,4.23077,89.3401,NULL,NULL,NULL,NULL),(10718,537,6.10685,107.425,NULL,NULL,NULL,NULL),(10719,537,7.24056,119.088,NULL,NULL,NULL,NULL),(10720,537,8.58335,128.138,NULL,NULL,NULL,NULL),(10721,537,9.72566,128.067,NULL,NULL,NULL,NULL),(10722,537,13.3085,148.796,NULL,NULL,NULL,NULL),(10723,538,1.44517,34.3077,NULL,NULL,NULL,NULL),(10724,538,2.84658,36.3369,NULL,NULL,NULL,NULL),(10725,538,5.93455,37.6593,NULL,NULL,NULL,NULL),(10726,538,9.10924,38.9641,NULL,NULL,NULL,NULL),(10727,538,19.366,40.7556,NULL,NULL,NULL,NULL),(10728,538,49.6329,44.7713,NULL,NULL,NULL,NULL),(10729,538,87.1505,46.6875,NULL,NULL,NULL,NULL),(10730,538,184.026,48.0094,NULL,NULL,NULL,NULL),(10731,539,1.46104,32.2226,NULL,NULL,NULL,NULL),(10732,539,2.89476,33.6644,NULL,NULL,NULL,NULL),(10733,539,5.81096,35.4875,NULL,NULL,NULL,NULL),(10734,539,13.5105,37.5104,NULL,NULL,NULL,NULL),(10735,539,27.1281,39.6271,NULL,NULL,NULL,NULL),(10736,539,82.0805,43.8124,NULL,NULL,NULL,NULL),(10737,539,101.562,46.6228,NULL,NULL,NULL,NULL),(10738,539,175.885,47.3358,NULL,NULL,NULL,NULL),(10739,540,1.4663,29.0516,NULL,NULL,NULL,NULL),(10740,540,2.9042,30.1119,NULL,NULL,NULL,NULL),(10741,540,5.93869,31.2001,NULL,NULL,NULL,NULL),(10742,540,11.6985,33.3175,NULL,NULL,NULL,NULL),(10743,540,51.2165,36.9603,NULL,NULL,NULL,NULL),(10744,540,89.3306,38.5245,NULL,NULL,NULL,NULL),(10745,540,168.244,40.3499,NULL,NULL,NULL,NULL),(10746,541,1.46365,26.9965,NULL,NULL,NULL,NULL),(10747,541,2.95572,28.3495,NULL,NULL,NULL,NULL),(10748,541,5.93409,30.3194,NULL,NULL,NULL,NULL),(10749,541,9.89161,31.1219,NULL,NULL,NULL,NULL),(10750,541,19.5925,32.2407,NULL,NULL,NULL,NULL),(10751,541,39.3179,33.7114,NULL,NULL,NULL,NULL),(10752,541,96.7787,35.2917,NULL,NULL,NULL,NULL),(10753,541,135.788,35.9834,NULL,NULL,NULL,NULL),(10754,542,1.4803,25.3519,NULL,NULL,NULL,NULL),(10755,542,2.91291,26.2656,NULL,NULL,NULL,NULL),(10756,542,5.91985,27.5889,NULL,NULL,NULL,NULL),(10757,542,9.02331,28.1894,NULL,NULL,NULL,NULL),(10758,542,28.4813,29.7016,NULL,NULL,NULL,NULL),(10759,542,49.0129,30.4734,NULL,NULL,NULL,NULL),(10760,542,107.542,31.9113,NULL,NULL,NULL,NULL),(10761,543,0,33.6619,NULL,NULL,NULL,NULL),(10762,543,1.483,40.3806,NULL,NULL,NULL,NULL),(10763,543,4.127,49.1931,NULL,NULL,NULL,NULL),(10764,543,7.722,56.8806,NULL,NULL,NULL,NULL),(10765,543,11.41,62.7556,NULL,NULL,NULL,NULL),(10766,543,14.78,67.4744,NULL,NULL,NULL,NULL),(10767,543,21.42,73.7244,NULL,NULL,NULL,NULL),(10768,543,27.6,77.7869,NULL,NULL,NULL,NULL),(10769,543,35.74,87.1619,NULL,NULL,NULL,NULL),(10770,543,42.46,90.9119,NULL,NULL,NULL,NULL),(10771,543,56.51,94.9744,NULL,NULL,NULL,NULL),(10772,543,70.25,98.0994,NULL,NULL,NULL,NULL),(10773,543,83.94,104.662,NULL,NULL,NULL,NULL),(10774,543,98.35,106.849,NULL,NULL,NULL,NULL),(10775,543,111.6,109.037,NULL,NULL,NULL,NULL),(10776,543,126,109.974,NULL,NULL,NULL,NULL),(10777,543,139.8,113.099,NULL,NULL,NULL,NULL),(10778,543,154,113.099,NULL,NULL,NULL,NULL),(10779,544,0,33.45,NULL,NULL,NULL,NULL),(10780,544,1.241,39.4786,NULL,NULL,NULL,NULL),(10781,544,3.309,51.6214,NULL,NULL,NULL,NULL),(10782,544,7.211,59.45,NULL,NULL,NULL,NULL),(10783,544,10.42,63.25,NULL,NULL,NULL,NULL),(10784,544,14.44,65.5357,NULL,NULL,NULL,NULL),(10785,544,21.35,70.3929,NULL,NULL,NULL,NULL),(10786,544,28.24,74.9643,NULL,NULL,NULL,NULL),(10787,544,35.37,82.6786,NULL,NULL,NULL,NULL),(10788,544,42.23,86.1071,NULL,NULL,NULL,NULL),(10789,544,56.35,92.1071,NULL,NULL,NULL,NULL),(10790,544,69.97,95.5357,NULL,NULL,NULL,NULL),(10791,544,83.77,100.679,NULL,NULL,NULL,NULL),(10792,544,97.9,102.393,NULL,NULL,NULL,NULL),(10793,544,112,103.821,NULL,NULL,NULL,NULL),(10794,544,125.6,104.964,NULL,NULL,NULL,NULL),(10795,544,139.9,105.821,NULL,NULL,NULL,NULL),(10796,544,153.7,106.107,NULL,NULL,NULL,NULL),(10797,545,0,31.8904,NULL,NULL,NULL,NULL),(10798,545,1.321,37.2199,NULL,NULL,NULL,NULL),(10799,545,1.406,40.065,NULL,NULL,NULL,NULL),(10800,545,3.352,48.5439,NULL,NULL,NULL,NULL),(10801,545,6.59,53.1073,NULL,NULL,NULL,NULL),(10802,545,10.51,56.7974,NULL,NULL,NULL,NULL),(10803,545,14.53,59.2199,NULL,NULL,NULL,NULL),(10804,545,21.71,63.727,NULL,NULL,NULL,NULL),(10805,545,28.43,67.1073,NULL,NULL,NULL,NULL),(10806,545,35.53,73.3044,NULL,NULL,NULL,NULL),(10807,545,42.25,76.6847,NULL,NULL,NULL,NULL),(10808,545,56.62,81.1918,NULL,NULL,NULL,NULL),(10809,545,70.24,84.2904,NULL,NULL,NULL,NULL),(10810,545,84.08,89.6425,NULL,NULL,NULL,NULL),(10811,545,97.8,91.3326,NULL,NULL,NULL,NULL),(10812,545,111.8,92.7411,NULL,NULL,NULL,NULL),(10813,545,126.1,93.8678,NULL,NULL,NULL,NULL),(10814,545,140.2,94.4312,NULL,NULL,NULL,NULL),(10815,545,154.2,95.2763,NULL,NULL,NULL,NULL),(10816,546,0,27.6061,NULL,NULL,NULL,NULL),(10817,546,1.978,31.193,NULL,NULL,NULL,NULL),(10818,546,3.455,42.0877,NULL,NULL,NULL,NULL),(10819,546,7.261,46.4825,NULL,NULL,NULL,NULL),(10820,546,10.63,54.5614,NULL,NULL,NULL,NULL),(10821,546,14.25,57.7193,NULL,NULL,NULL,NULL),(10822,546,21.41,61.4035,NULL,NULL,NULL,NULL),(10823,546,28.4,64.0351,NULL,NULL,NULL,NULL),(10824,546,35.39,71.1404,NULL,NULL,NULL,NULL),(10825,546,42.24,73.5088,NULL,NULL,NULL,NULL),(10826,546,56.45,77.4561,NULL,NULL,NULL,NULL),(10827,546,70.19,79.2982,NULL,NULL,NULL,NULL),(10828,546,84.01,84.0351,NULL,NULL,NULL,NULL),(10829,546,97.88,85.8772,NULL,NULL,NULL,NULL),(10830,546,111.9,86.9298,NULL,NULL,NULL,NULL),(10831,546,125.8,87.7193,NULL,NULL,NULL,NULL),(10832,546,139.7,89.2982,NULL,NULL,NULL,NULL),(10833,546,153.9,90.8772,NULL,NULL,NULL,NULL),(10834,547,0,25.475,NULL,NULL,NULL,NULL),(10835,547,0.7215,27.8597,NULL,NULL,NULL,NULL),(10836,547,0.8855,30.23,NULL,NULL,NULL,NULL),(10837,547,2.944,40.9214,NULL,NULL,NULL,NULL),(10838,547,7.144,43.9337,NULL,NULL,NULL,NULL),(10839,547,10.23,46.4276,NULL,NULL,NULL,NULL),(10840,547,13.99,47.835,NULL,NULL,NULL,NULL),(10841,547,20.83,50.2547,NULL,NULL,NULL,NULL),(10842,547,28.21,52.23,NULL,NULL,NULL,NULL),(10843,547,35.45,52.9708,NULL,NULL,NULL,NULL),(10844,547,42.54,53.9584,NULL,NULL,NULL,NULL),(10845,547,56.6,55.9337,NULL,NULL,NULL,NULL),(10846,547,70.37,56.6745,NULL,NULL,NULL,NULL),(10847,547,84.85,59.6374,NULL,NULL,NULL,NULL),(10848,547,98.62,60.872,NULL,NULL,NULL,NULL),(10849,547,112.4,61.1189,NULL,NULL,NULL,NULL),(10850,547,126.6,62.1066,NULL,NULL,NULL,NULL),(10851,547,140.6,62.1066,NULL,NULL,NULL,NULL),(10852,547,154.5,62.1066,NULL,NULL,NULL,NULL),(10853,548,0,24.8837,NULL,NULL,NULL,NULL),(10854,548,0.7165,26.5633,NULL,NULL,NULL,NULL),(10855,548,0.7454,29.0509,NULL,NULL,NULL,NULL),(10856,548,3.257,29.9723,NULL,NULL,NULL,NULL),(10857,548,6.898,32.3768,NULL,NULL,NULL,NULL),(10858,548,10.26,35.006,NULL,NULL,NULL,NULL),(10859,548,14.02,35.5902,NULL,NULL,NULL,NULL),(10860,548,20.86,38.197,NULL,NULL,NULL,NULL),(10861,548,28.09,38.8711,NULL,NULL,NULL,NULL),(10862,548,35.21,41.1633,NULL,NULL,NULL,NULL),(10863,548,42.17,42.0846,NULL,NULL,NULL,NULL),(10864,548,56.5,43.4329,NULL,NULL,NULL,NULL),(10865,548,70.4,44.6239,NULL,NULL,NULL,NULL),(10866,548,84.61,47.0284,NULL,NULL,NULL,NULL),(10867,548,98.37,47.8374,NULL,NULL,NULL,NULL),(10868,548,112.3,48.0621,NULL,NULL,NULL,NULL),(10869,548,126.2,48.2869,NULL,NULL,NULL,NULL),(10870,548,140.3,48.5116,NULL,NULL,NULL,NULL),(10871,548,154.1,48.961,NULL,NULL,NULL,NULL),(10872,549,0,22.9357,NULL,NULL,NULL,NULL),(10873,549,0.5576,24.1562,NULL,NULL,NULL,NULL),(10874,549,1.391,26.0606,NULL,NULL,NULL,NULL),(10875,549,3.075,31.305,NULL,NULL,NULL,NULL),(10876,549,6.879,33.1273,NULL,NULL,NULL,NULL),(10877,549,10.01,35.5051,NULL,NULL,NULL,NULL),(10878,549,14.08,36.4606,NULL,NULL,NULL,NULL),(10879,549,21.24,37.1717,NULL,NULL,NULL,NULL),(10880,549,28.15,38.8606,NULL,NULL,NULL,NULL),(10881,549,35.45,39.7939,NULL,NULL,NULL,NULL),(10882,549,42.75,40.2606,NULL,NULL,NULL,NULL),(10883,549,56.53,40.7939,NULL,NULL,NULL,NULL),(10884,549,70.05,41.305,NULL,NULL,NULL,NULL),(10885,549,83.83,41.7273,NULL,NULL,NULL,NULL),(10886,549,97.88,42.2162,NULL,NULL,NULL,NULL),(10887,549,111.8,42.2162,NULL,NULL,NULL,NULL),(10888,549,125.7,42.3717,NULL,NULL,NULL,NULL),(10889,549,139.6,42.6606,NULL,NULL,NULL,NULL),(10890,549,153.8,43.1273,NULL,NULL,NULL,NULL),(10891,550,0,22.3363,NULL,NULL,NULL,NULL),(10892,550,0.5648,24.1605,NULL,NULL,NULL,NULL),(10893,550,1.395,25.7116,NULL,NULL,NULL,NULL),(10894,550,2.794,29.5839,NULL,NULL,NULL,NULL),(10895,550,7.139,31.3712,NULL,NULL,NULL,NULL),(10896,550,10.26,32.5414,NULL,NULL,NULL,NULL),(10897,550,13.91,33.0946,NULL,NULL,NULL,NULL),(10898,550,21.08,33.9669,NULL,NULL,NULL,NULL),(10899,550,28.38,34.3073,NULL,NULL,NULL,NULL),(10900,550,35.43,36.3924,NULL,NULL,NULL,NULL),(10901,550,42.46,36.9031,NULL,NULL,NULL,NULL),(10902,550,56.37,37.4988,NULL,NULL,NULL,NULL),(10903,550,70.17,38.7754,NULL,NULL,NULL,NULL),(10904,550,83.81,39.3286,NULL,NULL,NULL,NULL),(10905,550,97.59,39.6052,NULL,NULL,NULL,NULL),(10906,550,111.8,39.7116,NULL,NULL,NULL,NULL),(10907,550,125.8,39.9669,NULL,NULL,NULL,NULL),(10908,550,140,40.5626,NULL,NULL,NULL,NULL),(10909,550,153.7,40.8818,NULL,NULL,NULL,NULL),(10910,551,0,66.6,NULL,NULL,NULL,NULL),(10911,551,0.1,90.66,NULL,NULL,NULL,NULL),(10912,551,0.13,93.03,NULL,NULL,NULL,NULL),(10913,551,0.16,96.18,NULL,NULL,NULL,NULL),(10914,551,0.2,96.58,NULL,NULL,NULL,NULL),(10915,551,0.25,98.35,NULL,NULL,NULL,NULL),(10916,551,0.32,100.91,NULL,NULL,NULL,NULL),(10917,551,0.4,103.67,NULL,NULL,NULL,NULL),(10918,551,0.5,105.05,NULL,NULL,NULL,NULL),(10919,551,0.63,107.81,NULL,NULL,NULL,NULL),(10920,551,0.79,112.75,NULL,NULL,NULL,NULL),(10921,551,1.03,113.41,NULL,NULL,NULL,NULL),(10922,551,1.28,120.69,NULL,NULL,NULL,NULL),(10923,551,3.13,116.25,NULL,NULL,NULL,NULL),(10924,551,4,119.8,NULL,NULL,NULL,NULL),(10925,551,5,119.8,NULL,NULL,NULL,NULL),(10926,551,6.27,122.76,NULL,NULL,NULL,NULL),(10927,551,7.93,122.95,NULL,NULL,NULL,NULL),(10928,551,10,129.46,NULL,NULL,NULL,NULL),(10929,551,12.61,130.84,NULL,NULL,NULL,NULL),(10930,551,15.85,131.03,NULL,NULL,NULL,NULL),(10931,551,20,137.93,NULL,NULL,NULL,NULL),(10932,551,25.12,139.71,NULL,NULL,NULL,NULL),(10933,551,31.59,141.08,NULL,NULL,NULL,NULL),(10934,551,39.82,143.05,NULL,NULL,NULL,NULL),(10935,551,50.21,140.45,NULL,NULL,NULL,NULL),(10936,551,63.15,143.81,NULL,NULL,NULL,NULL),(10937,551,79.43,145.59,NULL,NULL,NULL,NULL),(10938,551,100.03,143.41,NULL,NULL,NULL,NULL),(10939,551,125.89,151.3,NULL,NULL,NULL,NULL),(10940,551,158.45,147.56,NULL,NULL,NULL,NULL),(10941,551,199.53,145.38,NULL,NULL,NULL,NULL),(10942,551,251.25,148.54,NULL,NULL,NULL,NULL),(10943,551,275.89,150.71,NULL,NULL,NULL,NULL),(10944,552,0.1,69.3,NULL,NULL,NULL,NULL),(10945,552,0.13,70.9,NULL,NULL,NULL,NULL),(10946,552,0.16,72.69,NULL,NULL,NULL,NULL),(10947,552,0.2,74.38,NULL,NULL,NULL,NULL),(10948,552,0.25,75.98,NULL,NULL,NULL,NULL),(10949,552,0.32,77.39,NULL,NULL,NULL,NULL),(10950,552,0.4,78.14,NULL,NULL,NULL,NULL),(10951,552,0.5,79.83,NULL,NULL,NULL,NULL),(10952,552,0.63,80.77,NULL,NULL,NULL,NULL),(10953,552,0.79,82.46,NULL,NULL,NULL,NULL),(10954,552,1.03,83.97,NULL,NULL,NULL,NULL),(10955,552,1.28,85.38,NULL,NULL,NULL,NULL),(10956,552,1.62,86.32,NULL,NULL,NULL,NULL),(10957,552,2.03,88.01,NULL,NULL,NULL,NULL),(10958,552,2.53,89.42,NULL,NULL,NULL,NULL),(10959,552,3.11,91.3,NULL,NULL,NULL,NULL),(10960,552,3.95,92.15,NULL,NULL,NULL,NULL),(10961,552,5.03,94.31,NULL,NULL,NULL,NULL),(10962,552,6.36,94.97,NULL,NULL,NULL,NULL),(10963,552,7.95,97.13,NULL,NULL,NULL,NULL),(10964,552,10.09,99.39,NULL,NULL,NULL,NULL),(10965,552,12.59,100.33,NULL,NULL,NULL,NULL),(10966,552,15.84,101.08,NULL,NULL,NULL,NULL),(10967,552,20.09,101.46,NULL,NULL,NULL,NULL),(10968,552,25.12,104.54,NULL,NULL,NULL,NULL),(10969,552,31.59,104.35,NULL,NULL,NULL,NULL),(10970,552,39.88,106.61,NULL,NULL,NULL,NULL),(10971,552,50.13,107.54,NULL,NULL,NULL,NULL),(10972,552,63.1,107.7,NULL,NULL,NULL,NULL),(10973,552,79.43,109.77,NULL,NULL,NULL,NULL),(10974,552,91.19,110.14,NULL,NULL,NULL,NULL),(10975,553,0,45.45,NULL,NULL,NULL,NULL),(10976,553,0.1,49.01,NULL,NULL,NULL,NULL),(10977,553,0.13,49.73,NULL,NULL,NULL,NULL),(10978,553,0.16,50.86,NULL,NULL,NULL,NULL),(10979,553,0.2,51.48,NULL,NULL,NULL,NULL),(10980,553,0.25,51.99,NULL,NULL,NULL,NULL),(10981,553,0.32,53.12,NULL,NULL,NULL,NULL),(10982,553,0.4,54.46,NULL,NULL,NULL,NULL),(10983,553,0.5,54.87,NULL,NULL,NULL,NULL),(10984,553,0.63,56.32,NULL,NULL,NULL,NULL),(10985,553,0.79,57.14,NULL,NULL,NULL,NULL),(10986,553,1,58.58,NULL,NULL,NULL,NULL),(10987,553,1.26,60.23,NULL,NULL,NULL,NULL),(10988,553,1.58,62.39,NULL,NULL,NULL,NULL),(10989,553,2.11,63.83,NULL,NULL,NULL,NULL),(10990,553,2.61,65.89,NULL,NULL,NULL,NULL),(10991,553,3.11,67.43,NULL,NULL,NULL,NULL),(10992,553,4.11,69.6,NULL,NULL,NULL,NULL),(10993,553,5.11,71.65,NULL,NULL,NULL,NULL),(10994,553,6.36,72.06,NULL,NULL,NULL,NULL),(10995,553,7.94,74.43,NULL,NULL,NULL,NULL),(10996,553,10.03,75.98,NULL,NULL,NULL,NULL),(10997,553,12.57,77.42,NULL,NULL,NULL,NULL),(10998,553,15.86,79.17,NULL,NULL,NULL,NULL),(10999,553,19.94,80.19,NULL,NULL,NULL,NULL),(11000,553,25.31,81.95,NULL,NULL,NULL,NULL),(11001,553,31.62,82.98,NULL,NULL,NULL,NULL),(11002,553,39.95,85.03,NULL,NULL,NULL,NULL),(11003,553,48.45,87.03,NULL,NULL,NULL,NULL),(11004,553,63.12,89.29,NULL,NULL,NULL,NULL),(11005,553,79.61,88.67,NULL,NULL,NULL,NULL),(11006,553,101.14,89.7,NULL,NULL,NULL,NULL),(11007,553,126.01,91.97,NULL,NULL,NULL,NULL),(11008,553,158.49,92.58,NULL,NULL,NULL,NULL),(11009,553,181.98,92.58,NULL,NULL,NULL,NULL),(11010,554,0,19.6,NULL,NULL,NULL,NULL),(11011,554,0.1,26.19,NULL,NULL,NULL,NULL),(11012,554,0.13,26.81,NULL,NULL,NULL,NULL),(11013,554,0.16,27.29,NULL,NULL,NULL,NULL),(11014,554,0.2,27.15,NULL,NULL,NULL,NULL),(11015,554,0.25,27.53,NULL,NULL,NULL,NULL),(11016,554,0.32,27.87,NULL,NULL,NULL,NULL),(11017,554,0.4,28.16,NULL,NULL,NULL,NULL),(11018,554,0.5,28.16,NULL,NULL,NULL,NULL),(11019,554,0.63,28.45,NULL,NULL,NULL,NULL),(11020,554,0.84,30.48,NULL,NULL,NULL,NULL),(11021,554,0.96,31.01,NULL,NULL,NULL,NULL),(11022,554,1.21,32.07,NULL,NULL,NULL,NULL),(11023,554,1.59,33.18,NULL,NULL,NULL,NULL),(11024,554,1.96,34.91,NULL,NULL,NULL,NULL),(11025,554,2.46,36.75,NULL,NULL,NULL,NULL),(11026,554,3.21,38.29,NULL,NULL,NULL,NULL),(11027,554,4.1,38.96,NULL,NULL,NULL,NULL),(11028,554,5.1,39.83,NULL,NULL,NULL,NULL),(11029,554,6.35,41.23,NULL,NULL,NULL,NULL),(11030,554,7.85,42.1,NULL,NULL,NULL,NULL),(11031,554,10.1,45.38,NULL,NULL,NULL,NULL),(11032,554,12.6,48.13,NULL,NULL,NULL,NULL),(11033,554,15.85,49.38,NULL,NULL,NULL,NULL),(11034,554,19.85,50.35,NULL,NULL,NULL,NULL),(11035,554,24.85,50.35,NULL,NULL,NULL,NULL),(11036,554,31.73,50.83,NULL,NULL,NULL,NULL),(11037,554,39.73,52.37,NULL,NULL,NULL,NULL),(11038,554,50.23,53.82,NULL,NULL,NULL,NULL),(11039,554,63.23,54.73,NULL,NULL,NULL,NULL),(11040,554,77.78,57.24,NULL,NULL,NULL,NULL),(11041,554,94.89,59.66,NULL,NULL,NULL,NULL),(11042,555,0.01,36.12,NULL,NULL,NULL,NULL),(11043,555,0.11,39.27,NULL,NULL,NULL,NULL),(11044,555,0.14,39.66,NULL,NULL,NULL,NULL),(11045,555,0.17,39.61,NULL,NULL,NULL,NULL),(11046,555,0.21,40.1,NULL,NULL,NULL,NULL),(11047,555,0.26,40.24,NULL,NULL,NULL,NULL),(11048,555,0.33,40.54,NULL,NULL,NULL,NULL),(11049,555,0.39,40.68,NULL,NULL,NULL,NULL),(11050,555,0.73,41.61,NULL,NULL,NULL,NULL),(11051,555,0.98,42.2,NULL,NULL,NULL,NULL),(11052,555,1.23,42.83,NULL,NULL,NULL,NULL),(11053,555,1.48,43.08,NULL,NULL,NULL,NULL),(11054,555,1.98,43.62,NULL,NULL,NULL,NULL),(11055,555,2.48,43.96,NULL,NULL,NULL,NULL),(11056,555,3.23,44.69,NULL,NULL,NULL,NULL),(11057,555,3.98,44.98,NULL,NULL,NULL,NULL),(11058,555,4.98,45.33,NULL,NULL,NULL,NULL),(11059,555,6.23,45.67,NULL,NULL,NULL,NULL),(11060,555,7.98,46.31,NULL,NULL,NULL,NULL),(11061,555,9.98,46.84,NULL,NULL,NULL,NULL),(11062,555,12.48,47.77,NULL,NULL,NULL,NULL),(11063,555,15.98,48.5,NULL,NULL,NULL,NULL),(11064,555,19.98,49.24,NULL,NULL,NULL,NULL),(11065,555,25.23,49.58,NULL,NULL,NULL,NULL),(11066,555,31.73,50.56,NULL,NULL,NULL,NULL),(11067,555,39.73,51.98,NULL,NULL,NULL,NULL),(11068,555,52.77,53.2,NULL,NULL,NULL,NULL),(11069,556,0,41.6,NULL,NULL,NULL,NULL),(11070,556,0.1,53.31,NULL,NULL,NULL,NULL),(11071,556,0.13,54.4,NULL,NULL,NULL,NULL),(11072,556,0.16,55.16,NULL,NULL,NULL,NULL),(11073,556,0.2,56.01,NULL,NULL,NULL,NULL),(11074,556,0.25,56.94,NULL,NULL,NULL,NULL),(11075,556,0.32,57.86,NULL,NULL,NULL,NULL),(11076,556,0.4,58.72,NULL,NULL,NULL,NULL),(11077,556,0.5,59.42,NULL,NULL,NULL,NULL),(11078,556,0.63,60.5,NULL,NULL,NULL,NULL),(11079,556,0.79,61.38,NULL,NULL,NULL,NULL),(11080,556,1,62.64,NULL,NULL,NULL,NULL),(11081,556,1.26,63.68,NULL,NULL,NULL,NULL),(11082,556,1.58,64.3,NULL,NULL,NULL,NULL),(11083,556,2,64.66,NULL,NULL,NULL,NULL),(11084,556,2.51,66.09,NULL,NULL,NULL,NULL),(11085,556,3.16,67.41,NULL,NULL,NULL,NULL),(11086,556,3.98,68.33,NULL,NULL,NULL,NULL),(11087,556,5.04,69.32,NULL,NULL,NULL,NULL),(11088,556,6.29,70.35,NULL,NULL,NULL,NULL),(11089,556,7.78,71.1,NULL,NULL,NULL,NULL),(11090,556,10.11,72.65,NULL,NULL,NULL,NULL),(11091,556,22.74,75.3,NULL,NULL,NULL,NULL),(11092,556,25.07,75.82,NULL,NULL,NULL,NULL),(11093,556,31.62,75.36,NULL,NULL,NULL,NULL),(11094,556,39.96,76,NULL,NULL,NULL,NULL),(11095,556,63.1,77.1,NULL,NULL,NULL,NULL),(11096,556,79.44,77.71,NULL,NULL,NULL,NULL),(11097,556,90.65,78.3,NULL,NULL,NULL,NULL),(11098,557,0,33.33,NULL,NULL,NULL,NULL),(11099,557,0.1,42.39,NULL,NULL,NULL,NULL),(11100,557,0.13,43.64,NULL,NULL,NULL,NULL),(11101,557,0.16,44.09,NULL,NULL,NULL,NULL),(11102,557,0.2,45.14,NULL,NULL,NULL,NULL),(11103,557,0.25,46.04,NULL,NULL,NULL,NULL),(11104,557,0.32,46.92,NULL,NULL,NULL,NULL),(11105,557,0.4,47.8,NULL,NULL,NULL,NULL),(11106,557,0.5,48.53,NULL,NULL,NULL,NULL),(11107,557,0.63,49.41,NULL,NULL,NULL,NULL),(11108,557,0.79,50.34,NULL,NULL,NULL,NULL),(11109,557,1.03,51.55,NULL,NULL,NULL,NULL),(11110,557,1.26,52.17,NULL,NULL,NULL,NULL),(11111,557,1.58,52.8,NULL,NULL,NULL,NULL),(11112,557,2,54.2,NULL,NULL,NULL,NULL),(11113,557,2.51,54.93,NULL,NULL,NULL,NULL),(11114,557,3.16,56.04,NULL,NULL,NULL,NULL),(11115,557,4.08,57.01,NULL,NULL,NULL,NULL),(11116,557,5.07,58.01,NULL,NULL,NULL,NULL),(11117,557,6.31,58.63,NULL,NULL,NULL,NULL),(11118,557,8,59.63,NULL,NULL,NULL,NULL),(11119,557,10,60.51,NULL,NULL,NULL,NULL),(11120,557,12.58,61.5,NULL,NULL,NULL,NULL),(11121,557,15.83,61.91,NULL,NULL,NULL,NULL),(11122,557,20.08,62.48,NULL,NULL,NULL,NULL),(11123,557,25.08,62.75,NULL,NULL,NULL,NULL),(11124,557,31.58,63.06,NULL,NULL,NULL,NULL),(11125,557,39.77,63.32,NULL,NULL,NULL,NULL),(11126,557,49.51,63.53,NULL,NULL,NULL,NULL),(11127,557,63.1,63.89,NULL,NULL,NULL,NULL),(11128,557,79.55,64,NULL,NULL,NULL,NULL),(11129,557,99.5,64.27,NULL,NULL,NULL,NULL),(11130,557,125.83,64.25,NULL,NULL,NULL,NULL),(11131,557,158.54,63.89,NULL,NULL,NULL,NULL),(11132,557,183.13,62.99,NULL,NULL,NULL,NULL),(11133,558,0,28.3,NULL,NULL,NULL,NULL),(11134,558,0.11,35.98,NULL,NULL,NULL,NULL),(11135,558,0.13,36.58,NULL,NULL,NULL,NULL),(11136,558,0.16,37.1,NULL,NULL,NULL,NULL),(11137,558,0.2,37.77,NULL,NULL,NULL,NULL),(11138,558,0.25,38.43,NULL,NULL,NULL,NULL),(11139,558,0.32,39.3,NULL,NULL,NULL,NULL),(11140,558,0.4,40.04,NULL,NULL,NULL,NULL),(11141,558,0.5,40.7,NULL,NULL,NULL,NULL),(11142,558,0.63,41.26,NULL,NULL,NULL,NULL),(11143,558,0.79,42.24,NULL,NULL,NULL,NULL),(11144,558,1,42.94,NULL,NULL,NULL,NULL),(11145,558,1.26,43.92,NULL,NULL,NULL,NULL),(11146,558,1.58,44.76,NULL,NULL,NULL,NULL),(11147,558,2,45.74,NULL,NULL,NULL,NULL),(11148,558,2.54,46.79,NULL,NULL,NULL,NULL),(11149,558,3.16,47.31,NULL,NULL,NULL,NULL),(11150,558,3.98,48.4,NULL,NULL,NULL,NULL),(11151,558,5.01,49.27,NULL,NULL,NULL,NULL),(11152,558,6.31,50.22,NULL,NULL,NULL,NULL),(11153,558,8,51.16,NULL,NULL,NULL,NULL),(11154,558,10,52,NULL,NULL,NULL,NULL),(11155,558,12.5,52.6,NULL,NULL,NULL,NULL),(11156,558,16,53.51,NULL,NULL,NULL,NULL),(11157,558,20,53.79,NULL,NULL,NULL,NULL),(11158,558,25.26,54.1,NULL,NULL,NULL,NULL),(11159,558,31.57,54.73,NULL,NULL,NULL,NULL),(11160,558,39.82,55.32,NULL,NULL,NULL,NULL),(11161,558,50.15,55.57,NULL,NULL,NULL,NULL),(11162,558,63.28,56.41,NULL,NULL,NULL,NULL),(11163,558,79.42,56.76,NULL,NULL,NULL,NULL),(11164,558,91.03,57.11,NULL,NULL,NULL,NULL),(11165,559,0,29.31,NULL,NULL,NULL,NULL),(11166,559,0.11,33.98,NULL,NULL,NULL,NULL),(11167,559,0.13,34.46,NULL,NULL,NULL,NULL),(11168,559,0.16,34.89,NULL,NULL,NULL,NULL),(11169,559,0.2,35.54,NULL,NULL,NULL,NULL),(11170,559,0.25,36.08,NULL,NULL,NULL,NULL),(11171,559,0.32,36.3,NULL,NULL,NULL,NULL),(11172,559,0.4,36.79,NULL,NULL,NULL,NULL),(11173,559,0.5,37.46,NULL,NULL,NULL,NULL),(11174,559,0.63,37.84,NULL,NULL,NULL,NULL),(11175,559,0.8,39.32,NULL,NULL,NULL,NULL),(11176,559,1.05,40.27,NULL,NULL,NULL,NULL),(11177,559,1.3,40.92,NULL,NULL,NULL,NULL),(11178,559,1.55,41.43,NULL,NULL,NULL,NULL),(11179,559,2.05,42.19,NULL,NULL,NULL,NULL),(11180,559,2.55,42.94,NULL,NULL,NULL,NULL),(11181,559,3.18,43.57,NULL,NULL,NULL,NULL),(11182,559,3.93,44.51,NULL,NULL,NULL,NULL),(11183,559,5.05,45.35,NULL,NULL,NULL,NULL),(11184,559,6.3,45.83,NULL,NULL,NULL,NULL),(11185,559,7.93,46.75,NULL,NULL,NULL,NULL),(11186,559,10.05,47.4,NULL,NULL,NULL,NULL),(11187,559,12.55,48.19,NULL,NULL,NULL,NULL),(11188,559,15.8,50.51,NULL,NULL,NULL,NULL),(11189,559,19.95,51.14,NULL,NULL,NULL,NULL),(11190,559,25.12,51.79,NULL,NULL,NULL,NULL),(11191,559,31.66,52.17,NULL,NULL,NULL,NULL),(11192,559,39.94,52.82,NULL,NULL,NULL,NULL),(11193,559,50.13,53.36,NULL,NULL,NULL,NULL),(11194,559,63.13,53.66,NULL,NULL,NULL,NULL),(11195,559,89.23,54.47,NULL,NULL,NULL,NULL),(11196,559,98.59,55.81,NULL,NULL,NULL,NULL),(11197,560,0.03,24.3,NULL,NULL,NULL,NULL),(11198,560,0.14,25.85,NULL,NULL,NULL,NULL),(11199,560,0.16,25.82,NULL,NULL,NULL,NULL),(11200,560,0.19,25.93,NULL,NULL,NULL,NULL),(11201,560,0.23,26.17,NULL,NULL,NULL,NULL),(11202,560,0.28,26.22,NULL,NULL,NULL,NULL),(11203,560,0.35,26.33,NULL,NULL,NULL,NULL),(11204,560,0.43,26.49,NULL,NULL,NULL,NULL),(11205,560,0.53,26.62,NULL,NULL,NULL,NULL),(11206,560,0.66,26.78,NULL,NULL,NULL,NULL),(11207,560,0.73,27.48,NULL,NULL,NULL,NULL),(11208,560,0.98,27.75,NULL,NULL,NULL,NULL),(11209,560,1.22,28.07,NULL,NULL,NULL,NULL),(11210,560,1.72,28.42,NULL,NULL,NULL,NULL),(11211,560,1.97,28.52,NULL,NULL,NULL,NULL),(11212,560,2.47,28.84,NULL,NULL,NULL,NULL),(11213,560,3.22,29.19,NULL,NULL,NULL,NULL),(11214,560,3.97,29.62,NULL,NULL,NULL,NULL),(11215,560,5.22,30.08,NULL,NULL,NULL,NULL),(11216,560,6.47,30.37,NULL,NULL,NULL,NULL),(11217,560,7.97,30.67,NULL,NULL,NULL,NULL),(11218,560,10.22,31.15,NULL,NULL,NULL,NULL),(11219,560,12.72,31.58,NULL,NULL,NULL,NULL),(11220,560,15.75,31.74,NULL,NULL,NULL,NULL),(11221,560,19.96,32.27,NULL,NULL,NULL,NULL),(11222,560,25.15,33.13,NULL,NULL,NULL,NULL),(11223,560,31.69,33.58,NULL,NULL,NULL,NULL),(11224,560,39.94,33.88,NULL,NULL,NULL,NULL),(11225,560,44.94,33.13,NULL,NULL,NULL,NULL),(11226,560,64.29,35.43,NULL,NULL,NULL,NULL),(11227,560,73.9,35.53,NULL,NULL,NULL,NULL),(11228,561,0,28.57,NULL,NULL,NULL,NULL),(11229,561,0.22,43.17,NULL,NULL,NULL,NULL),(11230,561,0.63,47.77,NULL,NULL,NULL,NULL),(11231,561,1.04,51.27,NULL,NULL,NULL,NULL),(11232,561,2,62.37,NULL,NULL,NULL,NULL),(11233,561,3.66,68.07,NULL,NULL,NULL,NULL),(11234,561,7.01,73.47,NULL,NULL,NULL,NULL),(11235,561,10.1,75.77,NULL,NULL,NULL,NULL),(11236,561,13.7,77.47,NULL,NULL,NULL,NULL),(11237,561,21.4,79.47,NULL,NULL,NULL,NULL),(11238,561,28.7,81.27,NULL,NULL,NULL,NULL),(11239,561,56.1,83.97,NULL,NULL,NULL,NULL),(11240,562,0,28.57,NULL,NULL,NULL,NULL),(11241,562,0.5,43.07,NULL,NULL,NULL,NULL),(11242,562,0.8,46.37,NULL,NULL,NULL,NULL),(11243,562,1,51.47,NULL,NULL,NULL,NULL),(11244,562,2.43,58.87,NULL,NULL,NULL,NULL),(11245,562,4.1,61.17,NULL,NULL,NULL,NULL),(11246,562,6.61,65.07,NULL,NULL,NULL,NULL),(11247,562,10.1,66.17,NULL,NULL,NULL,NULL),(11248,562,14.6,67.37,NULL,NULL,NULL,NULL),(11249,562,21,69.27,NULL,NULL,NULL,NULL),(11250,562,28.7,69.97,NULL,NULL,NULL,NULL),(11251,562,56.1,71.37,NULL,NULL,NULL,NULL),(11252,563,0,25,NULL,NULL,NULL,NULL),(11253,563,0.05,37.24,NULL,NULL,NULL,NULL),(11254,563,0.74,42.44,NULL,NULL,NULL,NULL),(11255,563,1.85,46.84,NULL,NULL,NULL,NULL),(11256,563,3.79,51.44,NULL,NULL,NULL,NULL),(11257,563,5.33,53.74,NULL,NULL,NULL,NULL),(11258,563,7.1,55.64,NULL,NULL,NULL,NULL),(11259,563,8.7,56.84,NULL,NULL,NULL,NULL),(11260,563,9.9,57.14,NULL,NULL,NULL,NULL),(11261,563,15.1,59.54,NULL,NULL,NULL,NULL),(11262,563,22.1,60.94,NULL,NULL,NULL,NULL),(11263,563,29.5,61.54,NULL,NULL,NULL,NULL),(11264,563,54.1,64.24,NULL,NULL,NULL,NULL),(11265,564,0,25.64,NULL,NULL,NULL,NULL),(11266,564,0.05,36.24,NULL,NULL,NULL,NULL),(11267,564,0.46,41.94,NULL,NULL,NULL,NULL),(11268,564,2.13,45.04,NULL,NULL,NULL,NULL),(11269,564,4.08,49.24,NULL,NULL,NULL,NULL),(11270,564,5.05,51.04,NULL,NULL,NULL,NULL),(11271,564,6.87,51.64,NULL,NULL,NULL,NULL),(11272,564,8.5,52.44,NULL,NULL,NULL,NULL),(11273,564,10.2,52.84,NULL,NULL,NULL,NULL),(11274,564,15,54.04,NULL,NULL,NULL,NULL),(11275,564,22.4,55.24,NULL,NULL,NULL,NULL),(11276,564,29.2,56.04,NULL,NULL,NULL,NULL),(11277,564,54.3,57.34,NULL,NULL,NULL,NULL),(11278,565,0,24.39,NULL,NULL,NULL,NULL),(11279,565,1.9,29.52,NULL,NULL,NULL,NULL),(11280,565,4,31.38,NULL,NULL,NULL,NULL),(11281,565,7.2,32.59,NULL,NULL,NULL,NULL),(11282,565,11,33.96,NULL,NULL,NULL,NULL),(11283,565,14.1,34.99,NULL,NULL,NULL,NULL),(11284,565,20.9,37.09,NULL,NULL,NULL,NULL),(11285,565,29.2,38.19,NULL,NULL,NULL,NULL),(11286,566,0,22.73,NULL,NULL,NULL,NULL),(11287,566,0.9,26.5,NULL,NULL,NULL,NULL),(11288,566,3.9,27.7,NULL,NULL,NULL,NULL),(11289,566,7.5,28.91,NULL,NULL,NULL,NULL),(11290,566,11.3,29.78,NULL,NULL,NULL,NULL),(11291,566,14.6,30.48,NULL,NULL,NULL,NULL),(11292,566,21.4,31.55,NULL,NULL,NULL,NULL),(11293,566,29.3,32.29,NULL,NULL,NULL,NULL),(11294,567,0,33.33,NULL,NULL,NULL,NULL),(11295,567,0.8,40.41,NULL,NULL,NULL,NULL),(11296,567,1.3,43.73,NULL,NULL,NULL,NULL),(11297,567,3.4,45.53,NULL,NULL,NULL,NULL),(11298,567,4.8,47.23,NULL,NULL,NULL,NULL),(11299,567,6.9,48.93,NULL,NULL,NULL,NULL),(11300,567,9.6,50.93,NULL,NULL,NULL,NULL),(11301,567,14.8,53.63,NULL,NULL,NULL,NULL),(11302,567,21.7,55.63,NULL,NULL,NULL,NULL),(11303,567,29.8,56.43,NULL,NULL,NULL,NULL),(11304,567,38.4,58.43,NULL,NULL,NULL,NULL),(11305,567,68,62.23,NULL,NULL,NULL,NULL),(11306,567,95,64.93,NULL,NULL,NULL,NULL),(11307,567,124,66.93,NULL,NULL,NULL,NULL),(11308,567,151,68.53,NULL,NULL,NULL,NULL),(11309,568,0,33.33,NULL,NULL,NULL,NULL),(11310,568,0.4,38.66,NULL,NULL,NULL,NULL),(11311,568,2.2,40.41,NULL,NULL,NULL,NULL),(11312,568,3.2,41.72,NULL,NULL,NULL,NULL),(11313,568,5.3,42.81,NULL,NULL,NULL,NULL),(11314,568,8.4,43.83,NULL,NULL,NULL,NULL),(11315,568,9.8,44.63,NULL,NULL,NULL,NULL),(11316,568,15.6,46.53,NULL,NULL,NULL,NULL),(11317,568,21.7,47.63,NULL,NULL,NULL,NULL),(11318,568,29.6,48.73,NULL,NULL,NULL,NULL),(11319,568,38.4,49.83,NULL,NULL,NULL,NULL),(11320,568,54.1,51.13,NULL,NULL,NULL,NULL),(11321,568,68.3,51.93,NULL,NULL,NULL,NULL),(11322,568,97,53.43,NULL,NULL,NULL,NULL),(11323,568,123,54.33,NULL,NULL,NULL,NULL),(11324,568,152,55.43,NULL,NULL,NULL,NULL),(11325,569,0,31.25,NULL,NULL,NULL,NULL),(11326,569,2.5,41.65,NULL,NULL,NULL,NULL),(11327,569,3.9,42.75,NULL,NULL,NULL,NULL),(11328,569,8,44.45,NULL,NULL,NULL,NULL),(11329,569,24.2,49.95,NULL,NULL,NULL,NULL),(11330,569,39.5,53.05,NULL,NULL,NULL,NULL),(11331,569,53.5,54.85,NULL,NULL,NULL,NULL),(11332,569,82,57.15,NULL,NULL,NULL,NULL),(11333,569,110,59.85,NULL,NULL,NULL,NULL),(11334,569,137,61.85,NULL,NULL,NULL,NULL),(11335,570,0,31.25,NULL,NULL,NULL,NULL),(11336,570,2,36.98,NULL,NULL,NULL,NULL),(11337,570,2.1,39.17,NULL,NULL,NULL,NULL),(11338,570,3.5,39.93,NULL,NULL,NULL,NULL),(11339,570,7.3,41.45,NULL,NULL,NULL,NULL),(11340,570,15.5,43.85,NULL,NULL,NULL,NULL),(11341,570,24,45.75,NULL,NULL,NULL,NULL),(11342,570,40,47.65,NULL,NULL,NULL,NULL),(11343,570,53.6,48.85,NULL,NULL,NULL,NULL),(11344,570,82,51.05,NULL,NULL,NULL,NULL),(11345,570,110,52.15,NULL,NULL,NULL,NULL),(11346,571,0,30.3,NULL,NULL,NULL,NULL),(11347,571,1.7,36.07,NULL,NULL,NULL,NULL),(11348,571,3.8,38.04,NULL,NULL,NULL,NULL),(11349,571,7.3,39.35,NULL,NULL,NULL,NULL),(11350,571,11,40.5,NULL,NULL,NULL,NULL),(11351,571,16,42.3,NULL,NULL,NULL,NULL),(11352,571,22,43.9,NULL,NULL,NULL,NULL),(11353,571,30,45.1,NULL,NULL,NULL,NULL),(11354,571,57,48.3,NULL,NULL,NULL,NULL),(11355,571,94,51.4,NULL,NULL,NULL,NULL),(11356,572,0,28.57,NULL,NULL,NULL,NULL),(11357,572,2,32.26,NULL,NULL,NULL,NULL),(11358,572,4.8,33.68,NULL,NULL,NULL,NULL),(11359,572,8.9,34.87,NULL,NULL,NULL,NULL),(11360,572,15,36.5,NULL,NULL,NULL,NULL),(11361,572,21,37.03,NULL,NULL,NULL,NULL),(11362,572,29,37.89,NULL,NULL,NULL,NULL),(11363,572,58,39.17,NULL,NULL,NULL,NULL),(11364,572,95,41.47,NULL,NULL,NULL,NULL),(11365,573,0,25.9067,NULL,NULL,NULL,NULL),(11366,573,0.000679917,27.2235,NULL,NULL,NULL,NULL),(11367,573,0.00143046,27.2454,NULL,NULL,NULL,NULL),(11368,573,0.00212375,27.9082,NULL,NULL,NULL,NULL),(11369,573,0.00286763,28.4597,NULL,NULL,NULL,NULL),(11370,573,0.00432667,28.6889,NULL,NULL,NULL,NULL),(11371,573,0.00539875,28.9124,NULL,NULL,NULL,NULL),(11372,573,0.0148592,29.4849,NULL,NULL,NULL,NULL),(11373,573,0.0194392,30.0354,NULL,NULL,NULL,NULL),(11374,573,0.0317442,30.2669,NULL,NULL,NULL,NULL),(11375,573,0.0494333,30.6056,NULL,NULL,NULL,NULL),(11376,573,0.0552208,30.6088,NULL,NULL,NULL,NULL),(11377,573,0.774167,34.1595,NULL,NULL,NULL,NULL),(11378,573,2.78458,36.8018,NULL,NULL,NULL,NULL),(11379,573,3.25938,38.0002,NULL,NULL,NULL,NULL),(11380,573,3.878,38.4395,NULL,NULL,NULL,NULL),(11381,573,7.29083,40.9542,NULL,NULL,NULL,NULL),(11382,573,18.495,45.1056,NULL,NULL,NULL,NULL),(11383,573,19.6933,45.8672,NULL,NULL,NULL,NULL),(11384,573,30.1471,48.0503,NULL,NULL,NULL,NULL),(11385,573,34.1908,49.1392,NULL,NULL,NULL,NULL),(11386,573,38.765,50.6623,NULL,NULL,NULL,NULL),(11387,573,46.875,50.5594,NULL,NULL,NULL,NULL),(11388,573,63.2375,52.4132,NULL,NULL,NULL,NULL),(11389,573,68.4,53.3922,NULL,NULL,NULL,NULL),(11390,573,78.8292,54.1561,NULL,NULL,NULL,NULL),(11391,573,89.4292,54.811,NULL,NULL,NULL,NULL),(11392,573,95.2083,55.7896,NULL,NULL,NULL,NULL),(11393,573,106.363,55.7928,NULL,NULL,NULL,NULL),(11394,573,106.3,56.661,NULL,NULL,NULL,NULL),(11395,573,106.238,57.5292,NULL,NULL,NULL,NULL),(11396,573,126.4,57.9685,NULL,NULL,NULL,NULL),(11397,573,143.346,59.166,NULL,NULL,NULL,NULL),(11398,573,147.9,59.7095,NULL,NULL,NULL,NULL),(11399,573,147.792,60.7948,NULL,NULL,NULL,NULL),(11400,573,162.371,62.0999,NULL,NULL,NULL,NULL),(11401,573,184.283,62.1036,NULL,NULL,NULL,NULL),(11402,573,222.575,63.7371,NULL,NULL,NULL,NULL),(11403,573,244.637,64.391,NULL,NULL,NULL,NULL),(11404,573,277.492,65.2629,NULL,NULL,NULL,NULL),(11405,573,300.075,66.5676,NULL,NULL,NULL,NULL),(11406,573,319.4,67.8717,NULL,NULL,NULL,NULL),(11407,573,345.571,68.4167,NULL,NULL,NULL,NULL),(11408,573,398.263,69.1806,NULL,NULL,NULL,NULL),(11409,573,417.375,70.0502,NULL,NULL,NULL,NULL),(11410,574,0,27.6243,NULL,NULL,NULL,NULL),(11411,574,0.00209179,28.6326,NULL,NULL,NULL,NULL),(11412,574,0.00273671,29.0753,NULL,NULL,NULL,NULL),(11413,574,0.0254742,29.7613,NULL,NULL,NULL,NULL),(11414,574,0.268562,33.5257,NULL,NULL,NULL,NULL),(11415,574,1.20671,34.7524,NULL,NULL,NULL,NULL),(11416,574,3.31829,36.6326,NULL,NULL,NULL,NULL),(11417,574,14.1804,41.8147,NULL,NULL,NULL,NULL),(11418,574,18.2596,42.3672,NULL,NULL,NULL,NULL),(11419,574,24.6429,43.6895,NULL,NULL,NULL,NULL),(11420,574,27.0692,45.229,NULL,NULL,NULL,NULL),(11421,574,45.55,47.8726,NULL,NULL,NULL,NULL),(11422,574,55.9083,49.0839,NULL,NULL,NULL,NULL),(11423,574,61.4833,48.9751,NULL,NULL,NULL,NULL),(11424,574,69.75,49.6359,NULL,NULL,NULL,NULL),(11425,574,84.2792,50.6272,NULL,NULL,NULL,NULL),(11426,574,91.1583,51.6172,NULL,NULL,NULL,NULL),(11427,574,101.846,51.5086,NULL,NULL,NULL,NULL),(11428,574,111.808,53.9273,NULL,NULL,NULL,NULL),(11429,574,137.233,55.1385,NULL,NULL,NULL,NULL),(11430,574,137.108,56.4572,NULL,NULL,NULL,NULL),(11431,574,158.121,56.2391,NULL,NULL,NULL,NULL),(11432,574,185.317,55.5817,NULL,NULL,NULL,NULL),(11433,574,203.442,58.0004,NULL,NULL,NULL,NULL),(11434,574,227.204,58.4412,NULL,NULL,NULL,NULL),(11435,574,253.688,59.2118,NULL,NULL,NULL,NULL),(11436,574,270.104,60.0917,NULL,NULL,NULL,NULL),(11437,574,283.108,60.7516,NULL,NULL,NULL,NULL),(11438,574,331.554,61.193,NULL,NULL,NULL,NULL),(11439,574,363.683,64.8205,NULL,NULL,NULL,NULL),(11440,574,387.129,66.03,NULL,NULL,NULL,NULL),(11441,574,418.958,66.2507,NULL,NULL,NULL,NULL),(11442,574,453,67.6802,NULL,NULL,NULL,NULL),(11443,574,539.042,67.9021,NULL,NULL,NULL,NULL),(11444,574,671.958,69.663,NULL,NULL,NULL,NULL),(11445,574,891.083,73.5125,NULL,NULL,NULL,NULL),(11446,575,0,27.248,NULL,NULL,NULL,NULL),(11447,575,0.112867,27.9556,NULL,NULL,NULL,NULL),(11448,575,0.226383,28.4102,NULL,NULL,NULL,NULL),(11449,575,0.305721,28.7446,NULL,NULL,NULL,NULL),(11450,575,0.33615,28.856,NULL,NULL,NULL,NULL),(11451,575,1.01717,29.6483,NULL,NULL,NULL,NULL),(11452,575,1.13608,29.9771,NULL,NULL,NULL,NULL),(11453,575,1.24917,30.0884,NULL,NULL,NULL,NULL),(11454,575,1.37287,30.8509,NULL,NULL,NULL,NULL),(11455,575,1.68608,31.1825,NULL,NULL,NULL,NULL),(11456,575,2.00608,31.6218,NULL,NULL,NULL,NULL),(11457,575,2.34938,32.0605,NULL,NULL,NULL,NULL),(11458,575,2.79629,31.9571,NULL,NULL,NULL,NULL),(11459,575,3.22404,32.0699,NULL,NULL,NULL,NULL),(11460,575,3.95963,32.4015,NULL,NULL,NULL,NULL),(11461,575,6.35958,33.8263,NULL,NULL,NULL,NULL),(11462,575,10.3696,36.2283,NULL,NULL,NULL,NULL),(11463,575,21.0746,40.5903,NULL,NULL,NULL,NULL),(11464,575,32.8196,40.8204,NULL,NULL,NULL,NULL),(11465,575,44.2792,42.5657,NULL,NULL,NULL,NULL),(11466,575,49.4708,42.4604,NULL,NULL,NULL,NULL),(11467,575,73.3292,45.5108,NULL,NULL,NULL,NULL),(11468,575,91.4458,46.6026,NULL,NULL,NULL,NULL),(11469,575,123.396,48.1308,NULL,NULL,NULL,NULL),(11470,575,144.396,49.7633,NULL,NULL,NULL,NULL),(11471,575,171.683,51.1792,NULL,NULL,NULL,NULL),(11472,575,191.613,52.5933,NULL,NULL,NULL,NULL),(11473,575,220.879,53.0316,NULL,NULL,NULL,NULL),(11474,575,246.354,55.4224,NULL,NULL,NULL,NULL),(11475,575,270.792,55.9679,NULL,NULL,NULL,NULL),(11476,575,311.783,58.1426,NULL,NULL,NULL,NULL),(11477,575,342.508,59.5562,NULL,NULL,NULL,NULL),(11478,575,364.567,60.8603,NULL,NULL,NULL,NULL),(11479,575,406.883,62.2744,NULL,NULL,NULL,NULL),(11480,575,461.167,64.3401,NULL,NULL,NULL,NULL),(11481,575,546.917,69.5545,NULL,NULL,NULL,NULL),(11482,575,723.292,77.3767,NULL,NULL,NULL,NULL),(11483,576,0,29.6736,NULL,NULL,NULL,NULL),(11484,576,0.00138608,30.7943,NULL,NULL,NULL,NULL),(11485,576,0.00352525,31.1474,NULL,NULL,NULL,NULL),(11486,576,0.0131037,31.9457,NULL,NULL,NULL,NULL),(11487,576,0.0217433,31.9606,NULL,NULL,NULL,NULL),(11488,576,0.0637625,32.3179,NULL,NULL,NULL,NULL),(11489,576,0.138413,32.8834,NULL,NULL,NULL,NULL),(11490,576,0.776625,33.2598,NULL,NULL,NULL,NULL),(11491,576,1.01621,33.4847,NULL,NULL,NULL,NULL),(11492,576,5.6975,34.9464,NULL,NULL,NULL,NULL),(11493,576,6.8875,35.2775,NULL,NULL,NULL,NULL),(11494,576,14.2413,37.578,NULL,NULL,NULL,NULL),(11495,576,20.8079,38.4574,NULL,NULL,NULL,NULL),(11496,576,27.6496,39.334,NULL,NULL,NULL,NULL),(11497,576,39.1379,40.321,NULL,NULL,NULL,NULL),(11498,576,51.15,42.2824,NULL,NULL,NULL,NULL),(11499,576,71.275,43.1603,NULL,NULL,NULL,NULL),(11500,576,84.8,43.5996,NULL,NULL,NULL,NULL),(11501,576,112.742,43.7165,NULL,NULL,NULL,NULL),(11502,576,134.137,44.1557,NULL,NULL,NULL,NULL),(11503,576,169.988,44.9224,NULL,NULL,NULL,NULL),(11504,576,195.933,45.4692,NULL,NULL,NULL,NULL),(11505,576,229.496,45.6909,NULL,NULL,NULL,NULL),(11506,576,273.075,46.0216,NULL,NULL,NULL,NULL),(11507,576,309.929,46.0253,NULL,NULL,NULL,NULL),(11508,576,357.208,46.6807,NULL,NULL,NULL,NULL),(11509,576,398.85,47.4436,NULL,NULL,NULL,NULL),(11510,576,467,48.208,NULL,NULL,NULL,NULL),(11511,576,610.667,49.4097,NULL,NULL,NULL,NULL),(11512,576,692.958,49.6304,NULL,NULL,NULL,NULL),(11513,576,836.792,51.5895,NULL,NULL,NULL,NULL),(11514,577,0,31.348,NULL,NULL,NULL,NULL),(11515,577,0.000712667,33.3324,NULL,NULL,NULL,NULL),(11516,577,0.0014295,33.6704,NULL,NULL,NULL,NULL),(11517,577,0.00215667,34.0049,NULL,NULL,NULL,NULL),(11518,577,0.00282221,34.118,NULL,NULL,NULL,NULL),(11519,577,0.00490917,34.5642,NULL,NULL,NULL,NULL),(11520,577,0.00854,34.9005,NULL,NULL,NULL,NULL),(11521,577,0.0128829,35.3449,NULL,NULL,NULL,NULL),(11522,577,0.099125,36.7979,NULL,NULL,NULL,NULL),(11523,577,0.123692,37.0203,NULL,NULL,NULL,NULL),(11524,577,0.135883,38.45,NULL,NULL,NULL,NULL),(11525,577,0.154208,38.5614,NULL,NULL,NULL,NULL),(11526,577,0.965417,40.7811,NULL,NULL,NULL,NULL),(11527,577,2.91783,43.3218,NULL,NULL,NULL,NULL),(11528,577,3.94163,43.2155,NULL,NULL,NULL,NULL),(11529,577,13.4979,48.2851,NULL,NULL,NULL,NULL),(11530,577,24.5821,51.0395,NULL,NULL,NULL,NULL),(11531,577,26.175,51.8095,NULL,NULL,NULL,NULL),(11532,577,28.3154,52.5797,NULL,NULL,NULL,NULL),(11533,577,32.64,53.0209,NULL,NULL,NULL,NULL),(11534,577,38.8029,54.6713,NULL,NULL,NULL,NULL),(11535,577,52.3542,56.3233,NULL,NULL,NULL,NULL),(11536,577,63.2708,57.0947,NULL,NULL,NULL,NULL),(11537,577,68.4458,57.8649,NULL,NULL,NULL,NULL),(11538,577,75.2083,58.9649,NULL,NULL,NULL,NULL),(11539,577,80.0875,59.625,NULL,NULL,NULL,NULL),(11540,577,92.325,59.9564,NULL,NULL,NULL,NULL),(11541,577,95.2417,60.726,NULL,NULL,NULL,NULL),(11542,577,106.375,61.057,NULL,NULL,NULL,NULL),(11543,577,113.271,61.827,NULL,NULL,NULL,NULL),(11544,577,130.5,63.0374,NULL,NULL,NULL,NULL),(11545,577,138.871,64.6865,NULL,NULL,NULL,NULL),(11546,577,162.442,66.8862,NULL,NULL,NULL,NULL),(11547,577,178.621,66.8873,NULL,NULL,NULL,NULL),(11548,577,187.196,67.767,NULL,NULL,NULL,NULL),(11549,577,219.242,68.0986,NULL,NULL,NULL,NULL),(11550,577,237.171,68.8687,NULL,NULL,NULL,NULL),(11551,577,268.758,71.1779,NULL,NULL,NULL,NULL),(11552,577,290.717,72.058,NULL,NULL,NULL,NULL),(11553,577,309.458,73.2675,NULL,NULL,NULL,NULL),(11554,577,351.2,73.3789,NULL,NULL,NULL,NULL),(11555,577,379.579,75.4678,NULL,NULL,NULL,NULL),(11556,577,430.458,76.6781,NULL,NULL,NULL,NULL),(11557,577,451,77.9973,NULL,NULL,NULL,NULL),(11558,577,465.167,78.9867,NULL,NULL,NULL,NULL),(11559,577,503.083,80.0865,NULL,NULL,NULL,NULL),(11560,577,535.667,80.9664,NULL,NULL,NULL,NULL),(11561,577,579.25,82.286,NULL,NULL,NULL,NULL),(11562,577,721.292,85.5853,NULL,NULL,NULL,NULL),(11563,577,791.792,88.1139,NULL,NULL,NULL,NULL),(11564,577,912.417,88.9947,NULL,NULL,NULL,NULL),(11565,578,0,26.0417,NULL,NULL,NULL,NULL),(11566,578,0.00566708,27.6113,NULL,NULL,NULL,NULL),(11567,578,0.0861208,28.8525,NULL,NULL,NULL,NULL),(11568,578,4.01375,34.5028,NULL,NULL,NULL,NULL),(11569,578,7.43292,35.9387,NULL,NULL,NULL,NULL),(11570,578,17.4392,38.5863,NULL,NULL,NULL,NULL),(11571,578,20.4183,39.3574,NULL,NULL,NULL,NULL),(11572,578,22.1,39.3583,NULL,NULL,NULL,NULL),(11573,578,27.5667,40.1302,NULL,NULL,NULL,NULL),(11574,578,32.2858,40.4617,NULL,NULL,NULL,NULL),(11575,578,48.6792,41.6754,NULL,NULL,NULL,NULL),(11576,578,57.9,42.5566,NULL,NULL,NULL,NULL),(11577,578,71.0958,43.2184,NULL,NULL,NULL,NULL),(11578,578,85.9583,43.3306,NULL,NULL,NULL,NULL),(11579,578,99.0792,43.8817,NULL,NULL,NULL,NULL),(11580,578,110.633,44.5424,NULL,NULL,NULL,NULL),(11581,578,115.963,45.2023,NULL,NULL,NULL,NULL),(11582,578,125.492,45.423,NULL,NULL,NULL,NULL),(11583,578,140.108,46.3034,NULL,NULL,NULL,NULL),(11584,578,151.521,47.5131,NULL,NULL,NULL,NULL),(11585,578,169.358,46.7452,NULL,NULL,NULL,NULL),(11586,578,207.967,47.2971,NULL,NULL,NULL,NULL),(11587,578,243.479,48.1781,NULL,NULL,NULL,NULL),(11588,578,267.575,49.0584,NULL,NULL,NULL,NULL),(11589,578,303.55,49.7192,NULL,NULL,NULL,NULL),(11590,578,344.367,50.3801,NULL,NULL,NULL,NULL),(11591,578,429.708,50.6025,NULL,NULL,NULL,NULL),(11592,578,479.708,51.5928,NULL,NULL,NULL,NULL),(11593,578,552.875,52.3638,NULL,NULL,NULL,NULL),(11594,578,930.333,55.0073,NULL,NULL,NULL,NULL),(11595,579,0,22.8467,NULL,NULL,NULL,NULL),(11596,579,2.634,27.9039,NULL,NULL,NULL,NULL),(11597,579,4.92,32.2053,NULL,NULL,NULL,NULL),(11598,579,14.01,35.0343,NULL,NULL,NULL,NULL),(11599,579,16.29,33.7361,NULL,NULL,NULL,NULL),(11600,579,20.09,32.7091,NULL,NULL,NULL,NULL),(11601,579,26.29,35.5574,NULL,NULL,NULL,NULL),(11602,579,28.25,34.8405,NULL,NULL,NULL,NULL),(11603,579,32.02,34.5305,NULL,NULL,NULL,NULL),(11604,579,36.28,35.7705,NULL,NULL,NULL,NULL),(11605,579,40.04,37.5919,NULL,NULL,NULL,NULL),(11606,579,41.75,37.96,NULL,NULL,NULL,NULL),(11607,579,44.09,35.3055,NULL,NULL,NULL,NULL),(11608,579,47.72,37.7663,NULL,NULL,NULL,NULL),(11609,579,49.92,36.1774,NULL,NULL,NULL,NULL),(11610,579,53.44,38.8707,NULL,NULL,NULL,NULL),(11611,579,55.91,37.5144,NULL,NULL,NULL,NULL),(11612,579,61.57,39.7426,NULL,NULL,NULL,NULL),(11613,579,64.26,39.6264,NULL,NULL,NULL,NULL),(11614,579,67.5,38.4251,NULL,NULL,NULL,NULL),(11615,579,74.52,40.2077,NULL,NULL,NULL,NULL),(11616,579,78.09,38.0376,NULL,NULL,NULL,NULL),(11617,579,83.62,40.9827,NULL,NULL,NULL,NULL),(11618,579,88.53,40.8665,NULL,NULL,NULL,NULL),(11619,579,99.46,41.4477,NULL,NULL,NULL,NULL),(11620,579,119,42.2228,NULL,NULL,NULL,NULL),(11621,580,0,22.8467,NULL,NULL,NULL,NULL),(11622,580,3.052,30.2484,NULL,NULL,NULL,NULL),(11623,580,4.645,32.9223,NULL,NULL,NULL,NULL),(11624,580,14.24,36.0999,NULL,NULL,NULL,NULL),(11625,580,16.87,35.1699,NULL,NULL,NULL,NULL),(11626,580,19.79,34.6274,NULL,NULL,NULL,NULL),(11627,580,23.24,35.9449,NULL,NULL,NULL,NULL),(11628,580,26.33,37.9407,NULL,NULL,NULL,NULL),(11629,580,28.66,36.6425,NULL,NULL,NULL,NULL),(11630,580,31.65,37.6307,NULL,NULL,NULL,NULL),(11631,580,36.28,37.9988,NULL,NULL,NULL,NULL),(11632,580,41.6,40.2658,NULL,NULL,NULL,NULL),(11633,580,43.99,38.0763,NULL,NULL,NULL,NULL),(11634,580,48.2,40.0333,NULL,NULL,NULL,NULL),(11635,580,50.39,38.4638,NULL,NULL,NULL,NULL),(11636,580,54.09,40.8083,NULL,NULL,NULL,NULL),(11637,580,56.38,40.1495,NULL,NULL,NULL,NULL),(11638,580,62.41,41.3315,NULL,NULL,NULL,NULL),(11639,580,65.3,41.4284,NULL,NULL,NULL,NULL),(11640,580,68.24,40.6146,NULL,NULL,NULL,NULL),(11641,580,75.08,41.719,NULL,NULL,NULL,NULL),(11642,580,79.45,41.1765,NULL,NULL,NULL,NULL),(11643,580,83.97,43.1916,NULL,NULL,NULL,NULL),(11644,580,87.85,42.9978,NULL,NULL,NULL,NULL),(11645,580,117.5,44.3542,NULL,NULL,NULL,NULL),(11646,580,122.2,43.1916,NULL,NULL,NULL,NULL),(11647,580,132.2,44.7417,NULL,NULL,NULL,NULL),(11648,580,136.3,45.9042,NULL,NULL,NULL,NULL),(11649,580,140.4,44.5479,NULL,NULL,NULL,NULL),(11650,580,143.3,45.1292,NULL,NULL,NULL,NULL),(11651,580,147.2,44.5479,NULL,NULL,NULL,NULL),(11652,580,150.7,45.1292,NULL,NULL,NULL,NULL),(11653,580,158,43.7729,NULL,NULL,NULL,NULL),(11654,580,161.4,45.323,NULL,NULL,NULL,NULL),(11655,580,164.8,45.9042,NULL,NULL,NULL,NULL),(11656,580,168.3,45.7105,NULL,NULL,NULL,NULL),(11657,580,178.8,46.8731,NULL,NULL,NULL,NULL),(11658,581,0,22.8467,NULL,NULL,NULL,NULL),(11659,581,2.295,28.9502,NULL,NULL,NULL,NULL),(11660,581,4.583,32.8835,NULL,NULL,NULL,NULL),(11661,581,14.11,36.9331,NULL,NULL,NULL,NULL),(11662,581,19.9,35.693,NULL,NULL,NULL,NULL),(11663,581,23.68,38.2119,NULL,NULL,NULL,NULL),(11664,581,26.59,38.4057,NULL,NULL,NULL,NULL),(11665,581,28.7,37.9988,NULL,NULL,NULL,NULL),(11666,581,35.67,39.3939,NULL,NULL,NULL,NULL),(11667,581,40.4,40.6146,NULL,NULL,NULL,NULL),(11668,581,42.57,41.6221,NULL,NULL,NULL,NULL),(11669,581,44.11,39.5876,NULL,NULL,NULL,NULL),(11670,581,48.29,41.2927,NULL,NULL,NULL,NULL),(11671,581,50.3,39.8202,NULL,NULL,NULL,NULL),(11672,581,54.78,42.1647,NULL,NULL,NULL,NULL),(11673,581,56.75,41.1765,NULL,NULL,NULL,NULL),(11674,581,58.92,42.1647,NULL,NULL,NULL,NULL),(11675,581,61.96,42.9978,NULL,NULL,NULL,NULL),(11676,581,64.89,43.1916,NULL,NULL,NULL,NULL),(11677,581,68.94,42.0097,NULL,NULL,NULL,NULL),(11678,581,76.08,43.3854,NULL,NULL,NULL,NULL),(11679,581,79.54,43.3854,NULL,NULL,NULL,NULL),(11680,581,84.1,44.5479,NULL,NULL,NULL,NULL),(11681,581,89.82,44.3542,NULL,NULL,NULL,NULL),(11682,581,101.4,44.5479,NULL,NULL,NULL,NULL),(11683,581,119.1,45.7105,NULL,NULL,NULL,NULL),(11684,581,124,44.1604,NULL,NULL,NULL,NULL),(11685,581,130.4,45.5167,NULL,NULL,NULL,NULL),(11686,581,137.8,46.6793,NULL,NULL,NULL,NULL),(11687,581,140.9,44.9354,NULL,NULL,NULL,NULL),(11688,581,144.4,46.098,NULL,NULL,NULL,NULL),(11689,581,148.6,44.9354,NULL,NULL,NULL,NULL),(11690,581,151.3,45.7105,NULL,NULL,NULL,NULL),(11691,581,158.5,44.3542,NULL,NULL,NULL,NULL),(11692,581,162.7,45.1292,NULL,NULL,NULL,NULL),(11693,581,165.3,46.2918,NULL,NULL,NULL,NULL),(11694,581,169.6,46.4855,NULL,NULL,NULL,NULL),(11695,581,172.4,47.0668,NULL,NULL,NULL,NULL),(11696,581,179,47.4543,NULL,NULL,NULL,NULL),(11697,582,0,22.8467,NULL,NULL,NULL,NULL),(11698,582,2.977,30.9653,NULL,NULL,NULL,NULL),(11699,582,4.746,34.298,NULL,NULL,NULL,NULL),(11700,582,13.79,34.8405,NULL,NULL,NULL,NULL),(11701,582,16.3,36.255,NULL,NULL,NULL,NULL),(11702,582,19.73,35.8481,NULL,NULL,NULL,NULL),(11703,582,26.45,40.3821,NULL,NULL,NULL,NULL),(11704,582,28.89,40.2658,NULL,NULL,NULL,NULL),(11705,582,36.08,42.1259,NULL,NULL,NULL,NULL),(11706,582,40.41,42.8041,NULL,NULL,NULL,NULL),(11707,582,42.64,43.5791,NULL,NULL,NULL,NULL),(11708,582,44.08,40.8277,NULL,NULL,NULL,NULL),(11709,582,48.32,43.3854,NULL,NULL,NULL,NULL),(11710,582,50.37,41.3315,NULL,NULL,NULL,NULL),(11711,582,54.76,44.1604,NULL,NULL,NULL,NULL),(11712,582,56.78,42.6103,NULL,NULL,NULL,NULL),(11713,582,59.14,43.9666,NULL,NULL,NULL,NULL),(11714,582,61.83,45.1292,NULL,NULL,NULL,NULL),(11715,582,65.4,44.9354,NULL,NULL,NULL,NULL),(11716,582,75.34,43.9666,NULL,NULL,NULL,NULL),(11717,582,78.89,43.9666,NULL,NULL,NULL,NULL),(11718,582,83.35,45.5167,NULL,NULL,NULL,NULL),(11719,582,88.79,46.8731,NULL,NULL,NULL,NULL),(11720,582,119.6,49.9732,NULL,NULL,NULL,NULL),(11721,582,123.9,48.0356,NULL,NULL,NULL,NULL),(11722,582,130.5,48.8107,NULL,NULL,NULL,NULL),(11723,582,132.9,48.4231,NULL,NULL,NULL,NULL),(11724,582,137.2,49.7795,NULL,NULL,NULL,NULL),(11725,582,141,47.8419,NULL,NULL,NULL,NULL),(11726,582,144.4,49.0044,NULL,NULL,NULL,NULL),(11727,582,148.1,48.2294,NULL,NULL,NULL,NULL),(11728,582,150.9,48.8107,NULL,NULL,NULL,NULL),(11729,582,155.3,48.2294,NULL,NULL,NULL,NULL),(11730,582,158.2,47.2606,NULL,NULL,NULL,NULL),(11731,582,162.2,48.4231,NULL,NULL,NULL,NULL),(11732,582,165.3,49.0044,NULL,NULL,NULL,NULL),(11733,582,169.6,49.1982,NULL,NULL,NULL,NULL),(11734,582,172.5,49.9732,NULL,NULL,NULL,NULL),(11735,582,178.5,50.5545,NULL,NULL,NULL,NULL),(11736,583,0,19.3761,NULL,NULL,NULL,NULL),(11737,583,3.268,25.5571,NULL,NULL,NULL,NULL),(11738,583,5.424,26.0027,NULL,NULL,NULL,NULL),(11739,583,9.983,27.5334,NULL,NULL,NULL,NULL),(11740,583,13.9,29.1223,NULL,NULL,NULL,NULL),(11741,583,18.65,30.3623,NULL,NULL,NULL,NULL),(11742,583,20.93,29.6454,NULL,NULL,NULL,NULL),(11743,583,24.45,30.6336,NULL,NULL,NULL,NULL),(11744,583,27.28,30.6723,NULL,NULL,NULL,NULL),(11745,583,31.13,31.4668,NULL,NULL,NULL,NULL),(11746,583,33.49,31.4668,NULL,NULL,NULL,NULL),(11747,583,41.65,33.23,NULL,NULL,NULL,NULL),(11748,583,44.98,32.9781,NULL,NULL,NULL,NULL),(11749,583,51.66,33.8888,NULL,NULL,NULL,NULL),(11750,583,55.68,33.0362,NULL,NULL,NULL,NULL),(11751,583,60.13,34.1213,NULL,NULL,NULL,NULL),(11752,583,65.09,34.8963,NULL,NULL,NULL,NULL),(11753,583,72.15,35.1095,NULL,NULL,NULL,NULL),(11754,583,95.57,36.989,NULL,NULL,NULL,NULL),(11755,583,102,36.8146,NULL,NULL,NULL,NULL),(11756,583,105.9,37.2796,NULL,NULL,NULL,NULL),(11757,583,109,37.8803,NULL,NULL,NULL,NULL),(11758,583,113.5,37.2796,NULL,NULL,NULL,NULL),(11759,583,116.4,37.6477,NULL,NULL,NULL,NULL),(11760,583,120.7,37.2408,NULL,NULL,NULL,NULL),(11761,583,123.7,37.7834,NULL,NULL,NULL,NULL),(11762,583,127.6,37.764,NULL,NULL,NULL,NULL),(11763,583,130.2,37.3571,NULL,NULL,NULL,NULL),(11764,583,137.6,38.6359,NULL,NULL,NULL,NULL),(11765,583,142.5,38.5584,NULL,NULL,NULL,NULL),(11766,583,150.8,39.1397,NULL,NULL,NULL,NULL),(11767,584,0,19.3761,NULL,NULL,NULL,NULL),(11768,584,2.987,23.697,NULL,NULL,NULL,NULL),(11769,584,13.48,26.7196,NULL,NULL,NULL,NULL),(11770,584,18.38,28.6379,NULL,NULL,NULL,NULL),(11771,584,21.59,28.1341,NULL,NULL,NULL,NULL),(11772,584,26.48,28.7735,NULL,NULL,NULL,NULL),(11773,584,31.27,28.8704,NULL,NULL,NULL,NULL),(11774,584,33.16,29.4517,NULL,NULL,NULL,NULL),(11775,584,38.31,30.5173,NULL,NULL,NULL,NULL),(11776,584,41.7,31.0792,NULL,NULL,NULL,NULL),(11777,584,44.59,30.7886,NULL,NULL,NULL,NULL),(11778,584,51.54,31.8155,NULL,NULL,NULL,NULL),(11779,584,55.65,31.2924,NULL,NULL,NULL,NULL),(11780,584,61.45,31.8543,NULL,NULL,NULL,NULL),(11781,584,65.24,32.8812,NULL,NULL,NULL,NULL),(11782,584,76.04,33.0944,NULL,NULL,NULL,NULL),(11783,584,95.59,34.2957,NULL,NULL,NULL,NULL),(11784,584,101.9,34.4313,NULL,NULL,NULL,NULL),(11785,584,105.3,34.6832,NULL,NULL,NULL,NULL),(11786,584,109.4,35.6714,NULL,NULL,NULL,NULL),(11787,584,113.2,34.9738,NULL,NULL,NULL,NULL),(11788,584,116.4,35.2645,NULL,NULL,NULL,NULL),(11789,584,120.6,34.9738,NULL,NULL,NULL,NULL),(11790,584,123.1,35.6326,NULL,NULL,NULL,NULL),(11791,584,127.7,35.7683,NULL,NULL,NULL,NULL),(11792,584,130.7,34.8188,NULL,NULL,NULL,NULL),(11793,584,135.2,36.0008,NULL,NULL,NULL,NULL),(11794,584,137.7,36.4658,NULL,NULL,NULL,NULL),(11795,584,141.8,36.1558,NULL,NULL,NULL,NULL),(11796,584,146,36.3302,NULL,NULL,NULL,NULL),(11797,584,150.9,36.8146,NULL,NULL,NULL,NULL),(11798,585,0,19.3761,NULL,NULL,NULL,NULL),(11799,585,2.966,24.6076,NULL,NULL,NULL,NULL),(11800,585,4.531,24.9758,NULL,NULL,NULL,NULL),(11801,585,8.252,26.4484,NULL,NULL,NULL,NULL),(11802,585,12.31,27.5334,NULL,NULL,NULL,NULL),(11803,585,16.76,29.316,NULL,NULL,NULL,NULL),(11804,585,18.76,29.3935,NULL,NULL,NULL,NULL),(11805,585,21.05,28.2697,NULL,NULL,NULL,NULL),(11806,585,26.07,29.316,NULL,NULL,NULL,NULL),(11807,585,31.23,29.6648,NULL,NULL,NULL,NULL),(11808,585,32.7,29.9361,NULL,NULL,NULL,NULL),(11809,585,38.22,31.4668,NULL,NULL,NULL,NULL),(11810,585,41.15,31.9318,NULL,NULL,NULL,NULL),(11811,585,44.14,31.4474,NULL,NULL,NULL,NULL),(11812,585,51.49,32.455,NULL,NULL,NULL,NULL),(11813,585,55.43,32.0868,NULL,NULL,NULL,NULL),(11814,585,60.59,32.5131,NULL,NULL,NULL,NULL),(11815,585,65.91,33.7144,NULL,NULL,NULL,NULL),(11816,585,75.63,33.9082,NULL,NULL,NULL,NULL),(11817,585,95.62,35.9039,NULL,NULL,NULL,NULL),(11818,585,99.77,35.5164,NULL,NULL,NULL,NULL),(11819,585,102.6,35.8845,NULL,NULL,NULL,NULL),(11820,585,105.6,35.8845,NULL,NULL,NULL,NULL),(11821,585,109.7,37.0665,NULL,NULL,NULL,NULL),(11822,586,0,19.3761,NULL,NULL,NULL,NULL),(11823,586,2.529,25.2858,NULL,NULL,NULL,NULL),(11824,586,4.576,25.5377,NULL,NULL,NULL,NULL),(11825,586,8.327,26.4871,NULL,NULL,NULL,NULL),(11826,586,11.72,28.231,NULL,NULL,NULL,NULL),(11827,586,16.23,29.8392,NULL,NULL,NULL,NULL),(11828,586,18.26,30.3236,NULL,NULL,NULL,NULL),(11829,586,20.38,29.2191,NULL,NULL,NULL,NULL),(11830,586,24.45,30.0329,NULL,NULL,NULL,NULL),(11831,586,26.82,30.1492,NULL,NULL,NULL,NULL),(11832,586,30.12,30.6917,NULL,NULL,NULL,NULL),(11833,586,32.8,30.9049,NULL,NULL,NULL,NULL),(11834,586,38.41,32.7262,NULL,NULL,NULL,NULL),(11835,586,41.86,33.2881,NULL,NULL,NULL,NULL),(11836,586,45.21,32.9975,NULL,NULL,NULL,NULL),(11837,586,51.47,34.3151,NULL,NULL,NULL,NULL),(11838,586,54.96,34.3732,NULL,NULL,NULL,NULL),(11839,586,59.57,34.0244,NULL,NULL,NULL,NULL),(11840,586,64.9,35.1676,NULL,NULL,NULL,NULL),(11841,586,75.34,35.4389,NULL,NULL,NULL,NULL),(11842,586,96.14,37.4734,NULL,NULL,NULL,NULL),(11843,586,100.1,37.0083,NULL,NULL,NULL,NULL),(11844,586,103.6,37.1827,NULL,NULL,NULL,NULL),(11845,586,109.6,38.384,NULL,NULL,NULL,NULL),(11846,586,113.3,37.3571,NULL,NULL,NULL,NULL),(11847,586,117.2,37.9384,NULL,NULL,NULL,NULL),(11848,586,120.4,37.2796,NULL,NULL,NULL,NULL),(11849,586,124,37.9384,NULL,NULL,NULL,NULL),(11850,586,128.3,37.919,NULL,NULL,NULL,NULL),(11851,586,131.2,36.8921,NULL,NULL,NULL,NULL),(11852,586,137.4,38.9459,NULL,NULL,NULL,NULL),(11853,586,142.5,38.694,NULL,NULL,NULL,NULL),(11854,586,146.3,38.9459,NULL,NULL,NULL,NULL),(11855,586,151.8,39.5272,NULL,NULL,NULL,NULL),(11856,587,0,26.0417,NULL,NULL,NULL,NULL),(11857,587,1.864,31.3423,NULL,NULL,NULL,NULL),(11858,587,6.428,34.4604,NULL,NULL,NULL,NULL),(11859,587,9.589,35.908,NULL,NULL,NULL,NULL),(11860,587,14.23,39.5829,NULL,NULL,NULL,NULL),(11861,587,18.38,40.1842,NULL,NULL,NULL,NULL),(11862,587,21.09,41.3869,NULL,NULL,NULL,NULL),(11863,587,23.83,42.1218,NULL,NULL,NULL,NULL),(11864,587,26.27,42.2555,NULL,NULL,NULL,NULL),(11865,587,27.98,42.7677,NULL,NULL,NULL,NULL),(11866,587,37.93,43.5918,NULL,NULL,NULL,NULL),(11867,587,45.15,45.1953,NULL,NULL,NULL,NULL),(11868,587,49.45,45.2176,NULL,NULL,NULL,NULL),(11869,587,53.72,45.7076,NULL,NULL,NULL,NULL),(11870,587,59.33,46.9548,NULL,NULL,NULL,NULL),(11871,587,62.38,46.5539,NULL,NULL,NULL,NULL),(11872,587,69.39,47.8011,NULL,NULL,NULL,NULL),(11873,587,88.66,48.3134,NULL,NULL,NULL,NULL),(11874,587,93.28,48.9815,NULL,NULL,NULL,NULL),(11875,587,98.41,48.5361,NULL,NULL,NULL,NULL),(11876,587,102.8,48.9815,NULL,NULL,NULL,NULL),(11877,587,107,48.5361,NULL,NULL,NULL,NULL),(11878,587,117.1,49.427,NULL,NULL,NULL,NULL),(11879,587,123.8,49.2043,NULL,NULL,NULL,NULL),(11880,587,128.7,49.6497,NULL,NULL,NULL,NULL),(11881,587,131.1,50.3178,NULL,NULL,NULL,NULL),(11882,587,135.1,50.0951,NULL,NULL,NULL,NULL),(11883,587,137.9,50.5406,NULL,NULL,NULL,NULL),(11884,588,0,26.0417,NULL,NULL,NULL,NULL),(11885,588,1.772,31.6319,NULL,NULL,NULL,NULL),(11886,588,5.258,35.0172,NULL,NULL,NULL,NULL),(11887,588,11.74,37.957,NULL,NULL,NULL,NULL),(11888,588,17.67,40.4737,NULL,NULL,NULL,NULL),(11889,588,20.29,40.6742,NULL,NULL,NULL,NULL),(11890,588,24.2,42.5227,NULL,NULL,NULL,NULL),(11891,588,27.95,43.1018,NULL,NULL,NULL,NULL),(11892,588,32.4,43.2577,NULL,NULL,NULL,NULL),(11893,588,35.22,44.0372,NULL,NULL,NULL,NULL),(11894,588,37.51,44.0372,NULL,NULL,NULL,NULL),(11895,588,45.21,45.5294,NULL,NULL,NULL,NULL),(11896,588,53.98,46.3089,NULL,NULL,NULL,NULL),(11897,588,59.28,47.7789,NULL,NULL,NULL,NULL),(11898,588,68.83,48.7588,NULL,NULL,NULL,NULL),(11899,588,88.92,49.6497,NULL,NULL,NULL,NULL),(11900,588,92.56,50.0951,NULL,NULL,NULL,NULL),(11901,588,99.43,49.8724,NULL,NULL,NULL,NULL),(11902,588,103.1,50.3178,NULL,NULL,NULL,NULL),(11903,588,107.1,49.6497,NULL,NULL,NULL,NULL),(11904,588,113.7,50.5406,NULL,NULL,NULL,NULL),(11905,588,120.6,50.5406,NULL,NULL,NULL,NULL),(11906,588,128,51.2087,NULL,NULL,NULL,NULL),(11907,588,130.9,50.986,NULL,NULL,NULL,NULL),(11908,588,135.5,51.2087,NULL,NULL,NULL,NULL),(11909,588,138.4,51.8769,NULL,NULL,NULL,NULL),(11910,589,0,26.0417,NULL,NULL,NULL,NULL),(11911,589,1.796,31.4314,NULL,NULL,NULL,NULL),(11912,589,5.805,35.084,NULL,NULL,NULL,NULL),(11913,589,9.918,37.3334,NULL,NULL,NULL,NULL),(11914,589,12.09,37.6007,NULL,NULL,NULL,NULL),(11915,589,13.63,39.0706,NULL,NULL,NULL,NULL),(11916,589,18.15,40.3178,NULL,NULL,NULL,NULL),(11917,589,20.5,41.1864,NULL,NULL,NULL,NULL),(11918,589,24.69,42.2777,NULL,NULL,NULL,NULL),(11919,589,27.84,42.7677,NULL,NULL,NULL,NULL),(11920,589,34.46,43.7254,NULL,NULL,NULL,NULL),(11921,589,38.31,43.5695,NULL,NULL,NULL,NULL),(11922,589,45.55,45.1285,NULL,NULL,NULL,NULL),(11923,589,54.07,45.663,NULL,NULL,NULL,NULL),(11924,589,58.36,46.9325,NULL,NULL,NULL,NULL),(11925,589,62.87,46.8212,NULL,NULL,NULL,NULL),(11926,589,91.04,48.7588,NULL,NULL,NULL,NULL),(11927,589,95.84,48.9815,NULL,NULL,NULL,NULL),(11928,589,99.05,48.5361,NULL,NULL,NULL,NULL),(11929,589,102.9,48.9815,NULL,NULL,NULL,NULL),(11930,589,106.8,48.7588,NULL,NULL,NULL,NULL),(11931,589,113.3,49.2043,NULL,NULL,NULL,NULL),(11932,589,116.9,49.2043,NULL,NULL,NULL,NULL),(11933,589,120.1,49.427,NULL,NULL,NULL,NULL),(11934,589,124.4,49.427,NULL,NULL,NULL,NULL),(11935,589,138,50.0951,NULL,NULL,NULL,NULL),(11936,590,0,26.0417,NULL,NULL,NULL,NULL),(11937,590,1.812,32.5005,NULL,NULL,NULL,NULL),(11938,590,6.007,36.9548,NULL,NULL,NULL,NULL),(11939,590,11.55,39.7833,NULL,NULL,NULL,NULL),(11940,590,23.88,43.4581,NULL,NULL,NULL,NULL),(11941,590,27.55,44.104,NULL,NULL,NULL,NULL),(11942,590,38.36,45.3735,NULL,NULL,NULL,NULL),(11943,590,45.03,46.4203,NULL,NULL,NULL,NULL),(11944,590,48.91,45.663,NULL,NULL,NULL,NULL),(11945,590,53.42,47.0662,NULL,NULL,NULL,NULL),(11946,590,58.85,48.1798,NULL,NULL,NULL,NULL),(11947,590,89.33,49.2043,NULL,NULL,NULL,NULL),(11948,590,93.34,49.8724,NULL,NULL,NULL,NULL),(11949,590,101.4,50.0951,NULL,NULL,NULL,NULL),(11950,590,107.3,50.0951,NULL,NULL,NULL,NULL),(11951,590,113,50.3178,NULL,NULL,NULL,NULL),(11952,590,117.1,50.3178,NULL,NULL,NULL,NULL),(11953,590,120.5,50.986,NULL,NULL,NULL,NULL),(11954,590,134.5,50.986,NULL,NULL,NULL,NULL),(11955,590,137.9,51.6541,NULL,NULL,NULL,NULL),(11956,591,0,22.2717,NULL,NULL,NULL,NULL),(11957,591,3.074,27.461,NULL,NULL,NULL,NULL),(11958,591,7.32,30.4677,NULL,NULL,NULL,NULL),(11959,591,11.24,32.4053,NULL,NULL,NULL,NULL),(11960,591,13.82,33.2739,NULL,NULL,NULL,NULL),(11961,591,17.34,33.7194,NULL,NULL,NULL,NULL),(11962,591,23.03,35.0557,NULL,NULL,NULL,NULL),(11963,591,27.35,35.7016,NULL,NULL,NULL,NULL),(11964,591,37.51,38.3296,NULL,NULL,NULL,NULL),(11965,591,40.96,38.3519,NULL,NULL,NULL,NULL),(11966,591,47.69,39.265,NULL,NULL,NULL,NULL),(11967,591,69.62,40.6459,NULL,NULL,NULL,NULL),(11968,591,75.17,41.1581,NULL,NULL,NULL,NULL),(11969,591,78.81,41.3363,NULL,NULL,NULL,NULL),(11970,591,81.44,41.5145,NULL,NULL,NULL,NULL),(11971,591,85.92,41.3363,NULL,NULL,NULL,NULL),(11972,591,89.31,42.1381,NULL,NULL,NULL,NULL),(11973,591,93.4,41.8263,NULL,NULL,NULL,NULL),(11974,591,99.97,42.1158,NULL,NULL,NULL,NULL),(11975,591,103.2,41.804,NULL,NULL,NULL,NULL),(11976,591,110.4,42.6058,NULL,NULL,NULL,NULL),(11977,591,116.9,42.8731,NULL,NULL,NULL,NULL),(11978,592,0,22.2717,NULL,NULL,NULL,NULL),(11979,592,2.826,27.5724,NULL,NULL,NULL,NULL),(11980,592,5.971,29.4878,NULL,NULL,NULL,NULL),(11981,592,11.21,32.1604,NULL,NULL,NULL,NULL),(11982,592,14,33.2962,NULL,NULL,NULL,NULL),(11983,592,18.12,34.2984,NULL,NULL,NULL,NULL),(11984,592,24.03,36.0579,NULL,NULL,NULL,NULL),(11985,592,28.02,35.9911,NULL,NULL,NULL,NULL),(11986,592,32.71,37.7283,NULL,NULL,NULL,NULL),(11987,592,37.74,38.9087,NULL,NULL,NULL,NULL),(11988,592,40.61,38.7751,NULL,NULL,NULL,NULL),(11989,592,51.02,40.3786,NULL,NULL,NULL,NULL),(11990,592,68.58,42.1604,NULL,NULL,NULL,NULL),(11991,592,71.74,42.1826,NULL,NULL,NULL,NULL),(11992,592,75.18,42.7617,NULL,NULL,NULL,NULL),(11993,592,77.93,42.784,NULL,NULL,NULL,NULL),(11994,592,81.89,43.2517,NULL,NULL,NULL,NULL),(11995,592,85.89,42.9399,NULL,NULL,NULL,NULL),(11996,592,89.08,44.098,NULL,NULL,NULL,NULL),(11997,592,93.3,43.6748,NULL,NULL,NULL,NULL),(11998,592,96.25,43.8753,NULL,NULL,NULL,NULL),(11999,592,100.2,43.8753,NULL,NULL,NULL,NULL),(12000,592,103,43.7194,NULL,NULL,NULL,NULL),(12001,592,107.1,44.1648,NULL,NULL,NULL,NULL),(12002,592,110.3,44.2094,NULL,NULL,NULL,NULL),(12003,592,113.7,44.4543,NULL,NULL,NULL,NULL),(12004,592,117,44.3207,NULL,NULL,NULL,NULL),(12005,593,0,22.2717,NULL,NULL,NULL,NULL),(12006,593,3.049,27.6169,NULL,NULL,NULL,NULL),(12007,593,5.235,29.3541,NULL,NULL,NULL,NULL),(12008,593,7.257,30.1782,NULL,NULL,NULL,NULL),(12009,593,11.16,32.5835,NULL,NULL,NULL,NULL),(12010,593,14.93,33.5189,NULL,NULL,NULL,NULL),(12011,593,24,35.6347,NULL,NULL,NULL,NULL),(12012,593,27.81,35.7461,NULL,NULL,NULL,NULL),(12013,593,37.95,39.0423,NULL,NULL,NULL,NULL),(12014,593,41.26,38.7305,NULL,NULL,NULL,NULL),(12015,593,67.4,41.4922,NULL,NULL,NULL,NULL),(12016,593,72.04,41.4699,NULL,NULL,NULL,NULL),(12017,593,74.89,42.2272,NULL,NULL,NULL,NULL),(12018,593,77.88,42.0935,NULL,NULL,NULL,NULL),(12019,593,81.56,42.7171,NULL,NULL,NULL,NULL),(12020,593,85.6,42.2049,NULL,NULL,NULL,NULL),(12021,593,88.96,43.118,NULL,NULL,NULL,NULL),(12022,593,92.67,43.118,NULL,NULL,NULL,NULL),(12023,593,95.64,43.3185,NULL,NULL,NULL,NULL),(12024,593,100.2,43.029,NULL,NULL,NULL,NULL),(12025,593,107.3,43.3185,NULL,NULL,NULL,NULL),(12026,593,110.1,43.7639,NULL,NULL,NULL,NULL),(12027,593,114.2,43.9421,NULL,NULL,NULL,NULL),(12028,593,116.8,43.8307,NULL,NULL,NULL,NULL),(12029,594,0,22.2717,NULL,NULL,NULL,NULL),(12030,594,3.205,27.3942,NULL,NULL,NULL,NULL),(12031,594,7.438,30.1114,NULL,NULL,NULL,NULL),(12032,594,10.96,31.8931,NULL,NULL,NULL,NULL),(12033,594,24.05,34.7661,NULL,NULL,NULL,NULL),(12034,594,27.74,34.8552,NULL,NULL,NULL,NULL),(12035,594,37.98,37.6169,NULL,NULL,NULL,NULL),(12036,594,42.09,37.7728,NULL,NULL,NULL,NULL),(12037,594,48.28,38.7305,NULL,NULL,NULL,NULL),(12038,594,67.72,40.6459,NULL,NULL,NULL,NULL),(12039,594,72.37,40.3563,NULL,NULL,NULL,NULL),(12040,594,75.1,40.7572,NULL,NULL,NULL,NULL),(12041,594,78.26,40.6904,NULL,NULL,NULL,NULL),(12042,594,81.84,41.1136,NULL,NULL,NULL,NULL),(12043,594,85.64,40.8018,NULL,NULL,NULL,NULL),(12044,594,88.67,41.6926,NULL,NULL,NULL,NULL),(12045,594,93,41.4922,NULL,NULL,NULL,NULL),(12046,594,100.6,41.8708,NULL,NULL,NULL,NULL),(12047,594,107.7,42.0713,NULL,NULL,NULL,NULL),(12048,594,113.6,41.8931,NULL,NULL,NULL,NULL),(12049,594,116.6,42.1826,NULL,NULL,NULL,NULL),(12050,595,0,18.7266,NULL,NULL,NULL,NULL),(12051,595,0.00681625,18.8142,NULL,NULL,NULL,NULL),(12052,595,0.0234567,18.9769,NULL,NULL,NULL,NULL),(12053,595,0.0451417,19.1645,NULL,NULL,NULL,NULL),(12054,595,0.107413,19.2996,NULL,NULL,NULL,NULL),(12055,595,1.78579,21.0584,NULL,NULL,NULL,NULL),(12056,595,5.9075,23.0777,NULL,NULL,NULL,NULL),(12057,595,6.96958,23.5821,NULL,NULL,NULL,NULL),(12058,595,7.64083,23.7946,NULL,NULL,NULL,NULL),(12059,595,8.45458,23.9806,NULL,NULL,NULL,NULL),(12060,595,11.7708,24.8038,NULL,NULL,NULL,NULL),(12061,595,12.5525,24.9897,NULL,NULL,NULL,NULL),(12062,595,15.7979,25.4678,NULL,NULL,NULL,NULL),(12063,595,18.3054,25.6539,NULL,NULL,NULL,NULL),(12064,595,20.2537,25.8929,NULL,NULL,NULL,NULL),(12065,595,25.2379,26.875,NULL,NULL,NULL,NULL),(12066,595,30.0604,27.1673,NULL,NULL,NULL,NULL),(12067,595,40.3271,28.1495,NULL,NULL,NULL,NULL),(12068,595,46.2875,28.5478,NULL,NULL,NULL,NULL),(12069,595,54.6083,29.0522,NULL,NULL,NULL,NULL),(12070,595,61.5375,29.3709,NULL,NULL,NULL,NULL),(12071,595,66.2167,29.7159,NULL,NULL,NULL,NULL),(12072,595,82.5583,30.3266,NULL,NULL,NULL,NULL),(12073,595,93.8417,31.0432,NULL,NULL,NULL,NULL),(12074,595,104.817,31.1231,NULL,NULL,NULL,NULL),(12075,595,118.113,31.4682,NULL,NULL,NULL,NULL),(12076,595,123.667,31.601,NULL,NULL,NULL,NULL),(12077,595,138.108,31.7604,NULL,NULL,NULL,NULL),(12078,595,157.079,32.0791,NULL,NULL,NULL,NULL),(12079,595,170.613,32.3446,NULL,NULL,NULL,NULL),(12080,595,194.096,32.4776,NULL,NULL,NULL,NULL),(12081,595,193.95,33.0081,NULL,NULL,NULL,NULL),(12082,596,0,18.7266,NULL,NULL,NULL,NULL),(12083,596,0.00135642,18.9952,NULL,NULL,NULL,NULL),(12084,596,0.00273412,19.0503,NULL,NULL,NULL,NULL),(12085,596,0.00546042,19.1054,NULL,NULL,NULL,NULL),(12086,596,0.0157712,19.2145,NULL,NULL,NULL,NULL),(12087,596,0.02239,19.2686,NULL,NULL,NULL,NULL),(12088,596,0.0365017,19.3761,NULL,NULL,NULL,NULL),(12089,596,0.105425,19.4852,NULL,NULL,NULL,NULL),(12090,596,0.137737,19.5921,NULL,NULL,NULL,NULL),(12091,596,0.208592,19.6198,NULL,NULL,NULL,NULL),(12092,596,0.260242,19.7266,NULL,NULL,NULL,NULL),(12093,596,1.88667,21.3503,NULL,NULL,NULL,NULL),(12094,596,6.02417,22.2555,NULL,NULL,NULL,NULL),(12095,596,7.51417,22.5479,NULL,NULL,NULL,NULL),(12096,596,8.01458,22.6011,NULL,NULL,NULL,NULL),(12097,596,8.78667,22.7871,NULL,NULL,NULL,NULL),(12098,596,11.7933,23.4245,NULL,NULL,NULL,NULL),(12099,596,13.1733,23.4514,NULL,NULL,NULL,NULL),(12100,596,15.9812,23.7968,NULL,NULL,NULL,NULL),(12101,596,18.6875,24.0624,NULL,NULL,NULL,NULL),(12102,596,20.8687,24.275,NULL,NULL,NULL,NULL),(12103,596,25.7829,24.7795,NULL,NULL,NULL,NULL),(12104,596,30.1433,25.1779,NULL,NULL,NULL,NULL),(12105,596,41.2158,25.7358,NULL,NULL,NULL,NULL),(12106,596,46.4458,26.081,NULL,NULL,NULL,NULL),(12107,596,55.3042,26.5589,NULL,NULL,NULL,NULL),(12108,596,63.5083,26.5858,NULL,NULL,NULL,NULL),(12109,596,68.3292,27.037,NULL,NULL,NULL,NULL),(12110,596,83.6708,27.3293,NULL,NULL,NULL,NULL),(12111,596,95.1458,27.7541,NULL,NULL,NULL,NULL),(12112,596,103.371,27.8339,NULL,NULL,NULL,NULL),(12113,596,116.496,28.0995,NULL,NULL,NULL,NULL),(12114,596,126.537,28.3385,NULL,NULL,NULL,NULL),(12115,596,141.329,28.4449,NULL,NULL,NULL,NULL),(12116,596,159.275,28.7105,NULL,NULL,NULL,NULL),(12117,596,174.629,28.8699,NULL,NULL,NULL,NULL),(12118,596,181.125,29.1353,NULL,NULL,NULL,NULL),(12119,596,200.408,29.3478,NULL,NULL,NULL,NULL),(12120,596,198.475,29.6925,NULL,NULL,NULL,NULL),(12121,596,245.363,29.7462,NULL,NULL,NULL,NULL),(12122,597,0,27.1739,NULL,NULL,NULL,NULL),(12123,597,0.00265971,27.6675,NULL,NULL,NULL,NULL),(12124,597,0.0061,27.8171,NULL,NULL,NULL,NULL),(12125,597,0.00940917,27.9645,NULL,NULL,NULL,NULL),(12126,597,0.0162125,28.1609,NULL,NULL,NULL,NULL),(12127,597,0.0368383,28.4072,NULL,NULL,NULL,NULL),(12128,597,1.70125,34.5726,NULL,NULL,NULL,NULL),(12129,597,5.67875,38.5468,NULL,NULL,NULL,NULL),(12130,597,6.8825,40.3865,NULL,NULL,NULL,NULL),(12131,597,7.61583,40.7257,NULL,NULL,NULL,NULL),(12132,597,8.745,40.8716,NULL,NULL,NULL,NULL),(12133,597,11.8308,43.6797,NULL,NULL,NULL,NULL),(12134,597,12.3854,44.1155,NULL,NULL,NULL,NULL),(12135,597,15.5771,45.8586,NULL,NULL,NULL,NULL),(12136,597,18.5479,46.7789,NULL,NULL,NULL,NULL),(12137,597,20.5158,47.602,NULL,NULL,NULL,NULL),(12138,597,24.3792,51.1837,NULL,NULL,NULL,NULL),(12139,597,29.3075,51.6685,NULL,NULL,NULL,NULL),(12140,597,40.7058,56.3155,NULL,NULL,NULL,NULL),(12141,597,46.2458,58.3969,NULL,NULL,NULL,NULL),(12142,597,57.0958,60.1883,NULL,NULL,NULL,NULL),(12143,597,61.3583,62.5597,NULL,NULL,NULL,NULL),(12144,597,69.15,63.0442,NULL,NULL,NULL,NULL),(12145,597,82.9792,65.8517,NULL,NULL,NULL,NULL),(12146,597,96.9125,67.9816,NULL,NULL,NULL,NULL),(12147,597,102.312,69.4335,NULL,NULL,NULL,NULL),(12148,597,118.433,71.0795,NULL,NULL,NULL,NULL),(12149,597,126.175,72.725,NULL,NULL,NULL,NULL),(12150,597,138.113,75.1449,NULL,NULL,NULL,NULL),(12151,597,162.833,76.9845,NULL,NULL,NULL,NULL),(12152,597,176.829,77.7108,NULL,NULL,NULL,NULL),(12153,597,183.354,78.5819,NULL,NULL,NULL,NULL),(12154,597,193.475,80.7113,NULL,NULL,NULL,NULL),(12155,597,208.254,80.9536,NULL,NULL,NULL,NULL),(12156,597,238.883,82.4543,NULL,NULL,NULL,NULL),(12157,598,0,27.1739,NULL,NULL,NULL,NULL),(12158,598,0.0067525,27.624,NULL,NULL,NULL,NULL),(12159,598,0.0204225,27.8234,NULL,NULL,NULL,NULL),(12160,598,0.033915,27.9712,NULL,NULL,NULL,NULL),(12161,598,0.0568458,28.0707,NULL,NULL,NULL,NULL),(12162,598,0.0671042,28.2168,NULL,NULL,NULL,NULL),(12163,598,0.0784958,28.2176,NULL,NULL,NULL,NULL),(12164,598,1.75321,31.3791,NULL,NULL,NULL,NULL),(12165,598,5.80333,34.1919,NULL,NULL,NULL,NULL),(12166,598,7.0425,34.4349,NULL,NULL,NULL,NULL),(12167,598,7.65083,34.6772,NULL,NULL,NULL,NULL),(12168,598,8.62375,34.9682,NULL,NULL,NULL,NULL),(12169,598,11.575,36.0827,NULL,NULL,NULL,NULL),(12170,598,12.6904,36.3735,NULL,NULL,NULL,NULL),(12171,598,15.6821,37.0037,NULL,NULL,NULL,NULL),(12172,598,19.0229,37.7789,NULL,NULL,NULL,NULL),(12173,598,20.4679,38.5535,NULL,NULL,NULL,NULL),(12174,598,25.5254,39.2805,NULL,NULL,NULL,NULL),(12175,598,29.5717,39.8619,NULL,NULL,NULL,NULL),(12176,598,40.41,41.6539,NULL,NULL,NULL,NULL),(12177,598,45.95,42.5256,NULL,NULL,NULL,NULL),(12178,598,55.7333,43.3975,NULL,NULL,NULL,NULL),(12179,598,60.5333,43.9302,NULL,NULL,NULL,NULL),(12180,598,67.5917,44.4631,NULL,NULL,NULL,NULL),(12181,598,81.2375,45.2866,NULL,NULL,NULL,NULL),(12182,598,96.7208,46.3037,NULL,NULL,NULL,NULL),(12183,598,101.146,48.1427,NULL,NULL,NULL,NULL),(12184,598,116.158,48.0951,NULL,NULL,NULL,NULL),(12185,598,126.192,48.3374,NULL,NULL,NULL,NULL),(12186,598,137.021,49.2088,NULL,NULL,NULL,NULL),(12187,598,158.675,50.3709,NULL,NULL,NULL,NULL),(12188,598,175.554,50.8553,NULL,NULL,NULL,NULL),(12189,598,180.433,51.1942,NULL,NULL,NULL,NULL),(12190,598,195.858,52.5011,NULL,NULL,NULL,NULL),(12191,598,237.483,53.8086,NULL,NULL,NULL,NULL),(12192,599,0,47.74,NULL,NULL,NULL,NULL),(12193,599,0,50.71,NULL,NULL,NULL,NULL),(12194,599,0,51.95,NULL,NULL,NULL,NULL),(12195,599,0.01,52.78,NULL,NULL,NULL,NULL),(12196,599,0.01,53.03,NULL,NULL,NULL,NULL),(12197,599,0.01,53.61,NULL,NULL,NULL,NULL),(12198,599,0.01,54.35,NULL,NULL,NULL,NULL),(12199,599,0.01,54.6,NULL,NULL,NULL,NULL),(12200,599,0.02,55.18,NULL,NULL,NULL,NULL),(12201,599,0.03,56.91,NULL,NULL,NULL,NULL),(12202,599,0.07,58.39,NULL,NULL,NULL,NULL),(12203,599,0.09,59.31,NULL,NULL,NULL,NULL),(12204,599,0.14,60.63,NULL,NULL,NULL,NULL),(12205,599,0.19,60.98,NULL,NULL,NULL,NULL),(12206,599,0.3,61.47,NULL,NULL,NULL,NULL),(12207,599,0.34,62.04,NULL,NULL,NULL,NULL),(12208,599,1.05,64.76,NULL,NULL,NULL,NULL),(12209,599,1.87,66.75,NULL,NULL,NULL,NULL),(12210,599,2.18,67.66,NULL,NULL,NULL,NULL),(12211,599,2.67,69.06,NULL,NULL,NULL,NULL),(12212,599,3.45,70.55,NULL,NULL,NULL,NULL),(12213,599,4.25,72.04,NULL,NULL,NULL,NULL),(12214,599,5,72.7,NULL,NULL,NULL,NULL),(12215,599,5.8,73.77,NULL,NULL,NULL,NULL),(12216,599,6.18,74.38,NULL,NULL,NULL,NULL),(12217,599,6.59,75.01,NULL,NULL,NULL,NULL),(12218,599,7.38,75.84,NULL,NULL,NULL,NULL),(12219,599,8.17,76.5,NULL,NULL,NULL,NULL),(12220,599,11.75,77.74,NULL,NULL,NULL,NULL),(12221,599,15.07,78.48,NULL,NULL,NULL,NULL),(12222,599,27.18,79.99,NULL,NULL,NULL,NULL),(12223,599,40.92,81.7,NULL,NULL,NULL,NULL),(12224,599,70.75,84.68,NULL,NULL,NULL,NULL),(12225,599,90.18,85.74,NULL,NULL,NULL,NULL),(12226,599,97.92,86.17,NULL,NULL,NULL,NULL),(12227,599,126.92,86.33,NULL,NULL,NULL,NULL),(12228,599,153.92,87.57,NULL,NULL,NULL,NULL),(12229,599,196.09,89.14,NULL,NULL,NULL,NULL),(12230,600,0,36.37,NULL,NULL,NULL,NULL),(12231,600,0,38.2,NULL,NULL,NULL,NULL),(12232,600,0,38.86,NULL,NULL,NULL,NULL),(12233,600,0,39.47,NULL,NULL,NULL,NULL),(12234,600,0.01,39.77,NULL,NULL,NULL,NULL),(12235,600,0.01,40.58,NULL,NULL,NULL,NULL),(12236,600,0.03,42.82,NULL,NULL,NULL,NULL),(12237,600,0.22,46.88,NULL,NULL,NULL,NULL),(12238,600,0.4,48.2,NULL,NULL,NULL,NULL),(12239,600,0.57,48.86,NULL,NULL,NULL,NULL),(12240,600,0.74,49.72,NULL,NULL,NULL,NULL),(12241,600,1.56,52.31,NULL,NULL,NULL,NULL),(12242,600,1.88,53.12,NULL,NULL,NULL,NULL),(12243,600,2.37,54.39,NULL,NULL,NULL,NULL),(12244,600,3.17,56.27,NULL,NULL,NULL,NULL),(12245,600,3.98,57.44,NULL,NULL,NULL,NULL),(12246,600,4.77,58.2,NULL,NULL,NULL,NULL),(12247,600,5.56,59.21,NULL,NULL,NULL,NULL),(12248,600,5.88,59.62,NULL,NULL,NULL,NULL),(12249,600,6.35,60.23,NULL,NULL,NULL,NULL),(12250,600,7.1,61.34,NULL,NULL,NULL,NULL),(12251,600,7.95,61.7,NULL,NULL,NULL,NULL),(12252,600,8.27,61.75,NULL,NULL,NULL,NULL),(12253,600,11.43,63.68,NULL,NULL,NULL,NULL),(12254,600,26.85,64.69,NULL,NULL,NULL,NULL),(12255,600,49.6,68.15,NULL,NULL,NULL,NULL),(12256,601,0,29.96,NULL,NULL,NULL,NULL),(12257,601,0,30.42,NULL,NULL,NULL,NULL),(12258,601,0,30.87,NULL,NULL,NULL,NULL),(12259,601,0,31.56,NULL,NULL,NULL,NULL),(12260,601,0.01,32.02,NULL,NULL,NULL,NULL),(12261,601,0.01,32.47,NULL,NULL,NULL,NULL),(12262,601,0.01,32.7,NULL,NULL,NULL,NULL),(12263,601,0.01,32.7,NULL,NULL,NULL,NULL),(12264,601,0.02,32.93,NULL,NULL,NULL,NULL),(12265,601,0.02,33.15,NULL,NULL,NULL,NULL),(12266,601,0.02,33.15,NULL,NULL,NULL,NULL),(12267,601,0.04,33.37,NULL,NULL,NULL,NULL),(12268,601,0.13,35.16,NULL,NULL,NULL,NULL),(12269,601,0.23,35.35,NULL,NULL,NULL,NULL),(12270,601,0.3,35.78,NULL,NULL,NULL,NULL),(12271,601,0.4,35.96,NULL,NULL,NULL,NULL),(12272,601,1.25,38.39,NULL,NULL,NULL,NULL),(12273,601,2.02,40.66,NULL,NULL,NULL,NULL),(12274,601,2.95,42.92,NULL,NULL,NULL,NULL),(12275,601,3.99,44.27,NULL,NULL,NULL,NULL),(12276,601,4.93,44.76,NULL,NULL,NULL,NULL),(12277,601,5.92,46.18,NULL,NULL,NULL,NULL),(12278,601,7.3,46.41,NULL,NULL,NULL,NULL),(12279,601,9.32,47.26,NULL,NULL,NULL,NULL),(12280,601,9.95,48.1,NULL,NULL,NULL,NULL),(12281,601,26.14,51.61,NULL,NULL,NULL,NULL),(12282,601,28.22,51.73,NULL,NULL,NULL,NULL),(12283,601,30.96,52.75,NULL,NULL,NULL,NULL),(12284,601,34.18,52.61,NULL,NULL,NULL,NULL),(12285,601,37.95,52.92,NULL,NULL,NULL,NULL),(12286,601,40.97,53.73,NULL,NULL,NULL,NULL),(12287,601,44.93,53.61,NULL,NULL,NULL,NULL),(12288,601,49.17,53.49,NULL,NULL,NULL,NULL),(12289,601,54.14,53.82,NULL,NULL,NULL,NULL),(12290,601,60.99,54.13,NULL,NULL,NULL,NULL),(12291,601,73,54.36,NULL,NULL,NULL,NULL),(12292,601,96.93,55.4,NULL,NULL,NULL,NULL),(12293,601,122.94,56.51,NULL,NULL,NULL,NULL),(12294,601,163.94,58.52,NULL,NULL,NULL,NULL),(12295,601,191.94,58.37,NULL,NULL,NULL,NULL),(12296,601,248.92,58.61,NULL,NULL,NULL,NULL),(12297,601,283.15,60.34,NULL,NULL,NULL,NULL),(12298,601,342.92,60.2,NULL,NULL,NULL,NULL),(12299,601,376.92,60.82,NULL,NULL,NULL,NULL),(12300,601,387.96,61.49,NULL,NULL,NULL,NULL),(12301,601,433.96,62.11,NULL,NULL,NULL,NULL),(12302,601,507.16,62.93,NULL,NULL,NULL,NULL),(12303,601,585,64.68,NULL,NULL,NULL,NULL),(12304,601,611.02,64.89,NULL,NULL,NULL,NULL),(12305,602,0,25.81,NULL,NULL,NULL,NULL),(12306,602,0,26.54,NULL,NULL,NULL,NULL),(12307,602,0,26.73,NULL,NULL,NULL,NULL),(12308,602,0,26.91,NULL,NULL,NULL,NULL),(12309,602,0,27.28,NULL,NULL,NULL,NULL),(12310,602,0.01,27.46,NULL,NULL,NULL,NULL),(12311,602,0.02,28.56,NULL,NULL,NULL,NULL),(12312,602,0.03,28.56,NULL,NULL,NULL,NULL),(12313,602,0.1,29.1,NULL,NULL,NULL,NULL),(12314,602,0.13,29.64,NULL,NULL,NULL,NULL),(12315,602,0.76,32.47,NULL,NULL,NULL,NULL),(12316,602,0.94,32.63,NULL,NULL,NULL,NULL),(12317,602,1.75,34.35,NULL,NULL,NULL,NULL),(12318,602,3.13,35.45,NULL,NULL,NULL,NULL),(12319,602,5.16,36.87,NULL,NULL,NULL,NULL),(12320,602,5.78,37.91,NULL,NULL,NULL,NULL),(12321,602,21.97,42.38,NULL,NULL,NULL,NULL),(12322,602,24.06,42.29,NULL,NULL,NULL,NULL),(12323,602,26.8,43.11,NULL,NULL,NULL,NULL),(12324,602,30.01,43.36,NULL,NULL,NULL,NULL),(12325,602,36.81,44.45,NULL,NULL,NULL,NULL),(12326,602,45.01,44.25,NULL,NULL,NULL,NULL),(12327,602,47.87,44.56,NULL,NULL,NULL,NULL),(12328,602,49.97,45.26,NULL,NULL,NULL,NULL),(12329,602,68.83,45.87,NULL,NULL,NULL,NULL),(12330,602,85,46.6,NULL,NULL,NULL,NULL),(12331,602,92.76,47.26,NULL,NULL,NULL,NULL),(12332,602,118.77,48.33,NULL,NULL,NULL,NULL),(12333,602,160.14,49.75,NULL,NULL,NULL,NULL),(12334,602,187.78,50,NULL,NULL,NULL,NULL),(12335,602,244.75,50.56,NULL,NULL,NULL,NULL),(12336,602,278.98,52.13,NULL,NULL,NULL,NULL),(12337,602,338.75,52.39,NULL,NULL,NULL,NULL),(12338,602,372.76,52.7,NULL,NULL,NULL,NULL),(12339,602,383.79,53.06,NULL,NULL,NULL,NULL),(12340,602,429.8,53.92,NULL,NULL,NULL,NULL),(12341,602,502.96,54.94,NULL,NULL,NULL,NULL),(12342,602,580.84,55.98,NULL,NULL,NULL,NULL),(12343,602,606.85,56.15,NULL,NULL,NULL,NULL),(12344,603,0,25.07,NULL,NULL,NULL,NULL),(12345,603,0,25.36,NULL,NULL,NULL,NULL),(12346,603,0,25.65,NULL,NULL,NULL,NULL),(12347,603,0,25.79,NULL,NULL,NULL,NULL),(12348,603,0,25.93,NULL,NULL,NULL,NULL),(12349,603,0.02,26.65,NULL,NULL,NULL,NULL),(12350,603,0.03,27.23,NULL,NULL,NULL,NULL),(12351,603,0.07,27.66,NULL,NULL,NULL,NULL),(12352,603,0.09,27.8,NULL,NULL,NULL,NULL),(12353,603,0.75,29.5,NULL,NULL,NULL,NULL),(12354,603,0.96,30.07,NULL,NULL,NULL,NULL),(12355,603,2.09,30.76,NULL,NULL,NULL,NULL),(12356,603,3.05,31.59,NULL,NULL,NULL,NULL),(12357,603,5.79,32.8,NULL,NULL,NULL,NULL),(12358,603,7.85,33.61,NULL,NULL,NULL,NULL),(12359,603,9.01,33.87,NULL,NULL,NULL,NULL),(12360,603,12.78,34.93,NULL,NULL,NULL,NULL),(12361,603,15.8,35.58,NULL,NULL,NULL,NULL),(12362,603,16.75,35.42,NULL,NULL,NULL,NULL),(12363,603,19.76,35.79,NULL,NULL,NULL,NULL),(12364,603,21.06,35.91,NULL,NULL,NULL,NULL),(12365,603,21.86,36.04,NULL,NULL,NULL,NULL),(12366,603,26.87,36.24,NULL,NULL,NULL,NULL),(12367,603,28.97,36.64,NULL,NULL,NULL,NULL),(12368,603,35.82,37.55,NULL,NULL,NULL,NULL),(12369,603,47.82,37.7,NULL,NULL,NULL,NULL),(12370,603,63.99,39.28,NULL,NULL,NULL,NULL),(12371,603,71.76,40.22,NULL,NULL,NULL,NULL),(12372,603,97.76,41.35,NULL,NULL,NULL,NULL),(12373,603,139.14,43.47,NULL,NULL,NULL,NULL),(12374,603,166.77,44.54,NULL,NULL,NULL,NULL),(12375,603,223.75,45.55,NULL,NULL,NULL,NULL),(12376,603,257.97,46.49,NULL,NULL,NULL,NULL),(12377,603,317.75,46.41,NULL,NULL,NULL,NULL),(12378,603,351.75,46.65,NULL,NULL,NULL,NULL),(12379,603,362.8,47.07,NULL,NULL,NULL,NULL),(12380,603,408.79,47.6,NULL,NULL,NULL,NULL),(12381,603,481.95,48.98,NULL,NULL,NULL,NULL),(12382,603,559.83,50.52,NULL,NULL,NULL,NULL),(12383,603,585.84,51.08,NULL,NULL,NULL,NULL),(12384,604,0,43.29,NULL,NULL,NULL,NULL),(12385,604,0,56.16,NULL,NULL,NULL,NULL),(12386,604,0.01,58.61,NULL,NULL,NULL,NULL),(12387,604,0.01,60.48,NULL,NULL,NULL,NULL),(12388,604,0.01,62.35,NULL,NULL,NULL,NULL),(12389,604,0.02,64.34,NULL,NULL,NULL,NULL),(12390,604,0.05,73,NULL,NULL,NULL,NULL),(12391,604,0.08,77.79,NULL,NULL,NULL,NULL),(12392,604,0.1,80.83,NULL,NULL,NULL,NULL),(12393,604,0.13,82.71,NULL,NULL,NULL,NULL),(12394,604,0.16,84.2,NULL,NULL,NULL,NULL),(12395,604,0.17,84.58,NULL,NULL,NULL,NULL),(12396,604,0.23,85.75,NULL,NULL,NULL,NULL),(12397,604,0.3,87.03,NULL,NULL,NULL,NULL),(12398,604,0.35,87.32,NULL,NULL,NULL,NULL),(12399,604,0.94,90.78,NULL,NULL,NULL,NULL),(12400,604,1.8,92.06,NULL,NULL,NULL,NULL),(12401,604,2.18,92.51,NULL,NULL,NULL,NULL),(12402,604,2.6,93,NULL,NULL,NULL,NULL),(12403,604,3.4,93.7,NULL,NULL,NULL,NULL),(12404,604,4.18,94.17,NULL,NULL,NULL,NULL),(12405,604,5.35,95.34,NULL,NULL,NULL,NULL),(12406,604,6.18,95.67,NULL,NULL,NULL,NULL),(12407,604,6.51,95.8,NULL,NULL,NULL,NULL),(12408,604,7.58,95.92,NULL,NULL,NULL,NULL),(12409,604,11.58,97.09,NULL,NULL,NULL,NULL),(12410,604,14.88,97.68,NULL,NULL,NULL,NULL),(12411,604,19.92,98.26,NULL,NULL,NULL,NULL),(12412,604,27.18,98.71,NULL,NULL,NULL,NULL),(12413,604,38.63,99.43,NULL,NULL,NULL,NULL),(12414,604,73.67,101.18,NULL,NULL,NULL,NULL),(12415,604,90.18,101.54,NULL,NULL,NULL,NULL),(12416,604,100.57,101.77,NULL,NULL,NULL,NULL),(12417,604,123.67,101.18,NULL,NULL,NULL,NULL),(12418,604,209.77,100.6,NULL,NULL,NULL,NULL),(12419,604,278.94,102.35,NULL,NULL,NULL,NULL),(12420,604,367.82,102.94,NULL,NULL,NULL,NULL),(12421,605,0,35.84,NULL,NULL,NULL,NULL),(12422,605,0,38.97,NULL,NULL,NULL,NULL),(12423,605,0.01,40.58,NULL,NULL,NULL,NULL),(12424,605,0.01,40.76,NULL,NULL,NULL,NULL),(12425,605,0.01,41.54,NULL,NULL,NULL,NULL),(12426,605,0.02,42.02,NULL,NULL,NULL,NULL),(12427,605,0.02,43.1,NULL,NULL,NULL,NULL),(12428,605,0.04,44.23,NULL,NULL,NULL,NULL),(12429,605,0.05,44.76,NULL,NULL,NULL,NULL),(12430,605,0.08,46.36,NULL,NULL,NULL,NULL),(12431,605,0.11,47.23,NULL,NULL,NULL,NULL),(12432,605,0.15,48.89,NULL,NULL,NULL,NULL),(12433,605,0.18,49.36,NULL,NULL,NULL,NULL),(12434,605,0.24,50.15,NULL,NULL,NULL,NULL),(12435,605,0.35,51.32,NULL,NULL,NULL,NULL),(12436,605,0.49,52.32,NULL,NULL,NULL,NULL),(12437,605,0.66,53.45,NULL,NULL,NULL,NULL),(12438,605,1.02,54.84,NULL,NULL,NULL,NULL),(12439,605,1.85,56.93,NULL,NULL,NULL,NULL),(12440,605,2.02,57.32,NULL,NULL,NULL,NULL),(12441,605,2.45,58.32,NULL,NULL,NULL,NULL),(12442,605,3.25,58.93,NULL,NULL,NULL,NULL),(12443,605,4.23,59.67,NULL,NULL,NULL,NULL),(12444,605,5.39,60.36,NULL,NULL,NULL,NULL),(12445,605,6.02,60.6,NULL,NULL,NULL,NULL),(12446,605,7.13,61.02,NULL,NULL,NULL,NULL),(12447,605,11.43,61.45,NULL,NULL,NULL,NULL),(12448,605,14.72,63.19,NULL,NULL,NULL,NULL),(12449,605,24.69,63.19,NULL,NULL,NULL,NULL),(12450,605,27.02,63.41,NULL,NULL,NULL,NULL),(12451,605,38.48,64.49,NULL,NULL,NULL,NULL),(12452,605,73.52,66.67,NULL,NULL,NULL,NULL),(12453,605,90.02,66.54,NULL,NULL,NULL,NULL),(12454,605,100.42,66.45,NULL,NULL,NULL,NULL),(12455,605,123.52,66.67,NULL,NULL,NULL,NULL),(12456,605,153.43,66.89,NULL,NULL,NULL,NULL),(12457,605,209.62,67.1,NULL,NULL,NULL,NULL),(12458,606,0,29.33,NULL,NULL,NULL,NULL),(12459,606,0,29.86,NULL,NULL,NULL,NULL),(12460,606,0,30.38,NULL,NULL,NULL,NULL),(12461,606,0.01,31.43,NULL,NULL,NULL,NULL),(12462,606,0.03,33.2,NULL,NULL,NULL,NULL),(12463,606,0.04,33.7,NULL,NULL,NULL,NULL),(12464,606,0.1,35.55,NULL,NULL,NULL,NULL),(12465,606,0.12,35.49,NULL,NULL,NULL,NULL),(12466,606,0.14,35.71,NULL,NULL,NULL,NULL),(12467,606,0.99,40.18,NULL,NULL,NULL,NULL),(12468,606,3.81,45.37,NULL,NULL,NULL,NULL),(12469,606,5.06,46.76,NULL,NULL,NULL,NULL),(12470,606,6.02,46.82,NULL,NULL,NULL,NULL),(12471,606,7.11,46.89,NULL,NULL,NULL,NULL),(12472,606,11.08,47.75,NULL,NULL,NULL,NULL),(12473,606,12.78,47.86,NULL,NULL,NULL,NULL),(12474,606,13.87,48.16,NULL,NULL,NULL,NULL),(12475,606,17.78,48.51,NULL,NULL,NULL,NULL),(12476,606,19.13,49.1,NULL,NULL,NULL,NULL),(12477,606,19.77,49.01,NULL,NULL,NULL,NULL),(12478,606,22.13,48.42,NULL,NULL,NULL,NULL),(12479,606,26,50.64,NULL,NULL,NULL,NULL),(12480,606,26.78,50.03,NULL,NULL,NULL,NULL),(12481,607,0,20.55,NULL,NULL,NULL,NULL),(12482,607,0,21.11,NULL,NULL,NULL,NULL),(12483,607,0.02,21.76,NULL,NULL,NULL,NULL),(12484,607,0.07,22.5,NULL,NULL,NULL,NULL),(12485,607,0.12,22.58,NULL,NULL,NULL,NULL),(12486,607,1,24.97,NULL,NULL,NULL,NULL),(12487,607,1.08,24.96,NULL,NULL,NULL,NULL),(12488,607,1.75,25.7,NULL,NULL,NULL,NULL),(12489,607,2.08,25.75,NULL,NULL,NULL,NULL),(12490,607,4.77,27.68,NULL,NULL,NULL,NULL),(12491,607,6.02,28.03,NULL,NULL,NULL,NULL),(12492,607,6.81,28.71,NULL,NULL,NULL,NULL),(12493,607,8,28.52,NULL,NULL,NULL,NULL),(12494,607,9.04,27.98,NULL,NULL,NULL,NULL),(12495,607,9.88,28.86,NULL,NULL,NULL,NULL),(12496,607,11.83,29.11,NULL,NULL,NULL,NULL),(12497,607,13.08,29.13,NULL,NULL,NULL,NULL),(12498,607,14.08,29.17,NULL,NULL,NULL,NULL),(12499,607,15.08,29.68,NULL,NULL,NULL,NULL),(12500,607,16.04,29.55,NULL,NULL,NULL,NULL),(12501,607,18.73,29.8,NULL,NULL,NULL,NULL),(12502,607,19.75,30.51,NULL,NULL,NULL,NULL),(12503,607,21.04,30.84,NULL,NULL,NULL,NULL),(12504,607,22,30.62,NULL,NULL,NULL,NULL),(12505,607,22.75,30.41,NULL,NULL,NULL,NULL),(12506,607,26,30.59,NULL,NULL,NULL,NULL),(12507,607,28.06,30.71,NULL,NULL,NULL,NULL),(12508,607,30,30.94,NULL,NULL,NULL,NULL),(12509,607,34.04,30.94,NULL,NULL,NULL,NULL),(12510,607,35.06,31.11,NULL,NULL,NULL,NULL),(12511,607,36.04,31.37,NULL,NULL,NULL,NULL),(12512,607,40.04,31.48,NULL,NULL,NULL,NULL),(12513,607,42.02,31.44,NULL,NULL,NULL,NULL),(12514,607,43.06,31.52,NULL,NULL,NULL,NULL),(12515,607,49.83,31.6,NULL,NULL,NULL,NULL),(12516,607,55.04,32,NULL,NULL,NULL,NULL),(12517,607,60.83,32.4,NULL,NULL,NULL,NULL),(12518,607,65.02,32.83,NULL,NULL,NULL,NULL),(12519,607,69.04,32.97,NULL,NULL,NULL,NULL),(12520,607,97.08,33.23,NULL,NULL,NULL,NULL),(12521,607,102.79,33.39,NULL,NULL,NULL,NULL),(12522,607,126,33.65,NULL,NULL,NULL,NULL),(12523,607,142,34.62,NULL,NULL,NULL,NULL),(12524,607,155,34.3,NULL,NULL,NULL,NULL),(12525,607,201.83,34.37,NULL,NULL,NULL,NULL),(12526,607,224.96,34.42,NULL,NULL,NULL,NULL),(12527,607,237.96,34.59,NULL,NULL,NULL,NULL),(12528,607,264.98,34.45,NULL,NULL,NULL,NULL),(12529,607,298.79,34.6,NULL,NULL,NULL,NULL),(12530,607,330.96,34.28,NULL,NULL,NULL,NULL),(12531,607,349.88,34.27,NULL,NULL,NULL,NULL),(12532,607,371.88,34.44,NULL,NULL,NULL,NULL),(12533,607,446.79,34.57,NULL,NULL,NULL,NULL),(12534,607,480.96,34.64,NULL,NULL,NULL,NULL),(12535,608,0.01,19.54,NULL,NULL,NULL,NULL),(12536,608,0.01,19.68,NULL,NULL,NULL,NULL),(12537,608,0.01,19.75,NULL,NULL,NULL,NULL),(12538,608,0.01,19.82,NULL,NULL,NULL,NULL),(12539,608,0.01,19.89,NULL,NULL,NULL,NULL),(12540,608,0.03,20.03,NULL,NULL,NULL,NULL),(12541,608,0.03,20.24,NULL,NULL,NULL,NULL),(12542,608,0.04,20.31,NULL,NULL,NULL,NULL),(12543,608,0.06,20.45,NULL,NULL,NULL,NULL),(12544,608,0.11,20.66,NULL,NULL,NULL,NULL),(12545,608,0.75,22.13,NULL,NULL,NULL,NULL),(12546,608,0.99,22.12,NULL,NULL,NULL,NULL),(12547,608,1.75,22.17,NULL,NULL,NULL,NULL),(12548,608,4.77,23.23,NULL,NULL,NULL,NULL),(12549,608,5.96,23.42,NULL,NULL,NULL,NULL),(12550,608,8.8,23.29,NULL,NULL,NULL,NULL),(12551,608,12.95,24.49,NULL,NULL,NULL,NULL),(12552,608,15.75,24.73,NULL,NULL,NULL,NULL),(12553,608,21.76,25.14,NULL,NULL,NULL,NULL),(12554,608,22.74,25.2,NULL,NULL,NULL,NULL),(12555,608,29.97,25.61,NULL,NULL,NULL,NULL),(12556,608,35.97,25.76,NULL,NULL,NULL,NULL),(12557,608,40.74,26.49,NULL,NULL,NULL,NULL),(12558,608,48.76,26.71,NULL,NULL,NULL,NULL),(12559,608,70,27,NULL,NULL,NULL,NULL),(12560,608,82.83,27.58,NULL,NULL,NULL,NULL),(12561,608,95.76,27.81,NULL,NULL,NULL,NULL),(12562,608,123.94,27.93,NULL,NULL,NULL,NULL),(12563,608,134.76,28.11,NULL,NULL,NULL,NULL),(12564,608,147.78,28.5,NULL,NULL,NULL,NULL),(12565,608,153.82,28.2,NULL,NULL,NULL,NULL),(12566,608,165.77,28.32,NULL,NULL,NULL,NULL),(12567,608,186.96,28.63,NULL,NULL,NULL,NULL),(12568,608,196.81,28.41,NULL,NULL,NULL,NULL),(12569,608,210.01,28.31,NULL,NULL,NULL,NULL),(12570,608,278.76,28.58,NULL,NULL,NULL,NULL),(12571,609,0,33.87,NULL,NULL,NULL,NULL),(12572,609,0,35.87,NULL,NULL,NULL,NULL),(12573,609,0.01,41.87,NULL,NULL,NULL,NULL),(12574,609,0.04,53.87,NULL,NULL,NULL,NULL),(12575,609,0.68,79.87,NULL,NULL,NULL,NULL),(12576,609,0.99,82.87,NULL,NULL,NULL,NULL),(12577,609,1.7,83.87,NULL,NULL,NULL,NULL),(12578,609,2.9,83.87,NULL,NULL,NULL,NULL),(12579,609,5.72,89.87,NULL,NULL,NULL,NULL),(12580,609,6.97,93.87,NULL,NULL,NULL,NULL),(12581,609,7.93,99.87,NULL,NULL,NULL,NULL),(12582,609,15.78,93.87,NULL,NULL,NULL,NULL),(12583,609,26.74,99.87,NULL,NULL,NULL,NULL),(12584,610,0.02,21.36,NULL,NULL,NULL,NULL),(12585,610,0.02,21.62,NULL,NULL,NULL,NULL),(12586,610,0.04,22.27,NULL,NULL,NULL,NULL),(12587,610,0.06,22.78,NULL,NULL,NULL,NULL),(12588,610,0.12,23.55,NULL,NULL,NULL,NULL),(12589,610,0.32,24.81,NULL,NULL,NULL,NULL),(12590,610,0.72,26.04,NULL,NULL,NULL,NULL),(12591,610,0.97,26.39,NULL,NULL,NULL,NULL),(12592,610,1.08,26.63,NULL,NULL,NULL,NULL),(12593,610,1.75,27.95,NULL,NULL,NULL,NULL),(12594,610,3.74,29.76,NULL,NULL,NULL,NULL),(12595,610,4.74,30.16,NULL,NULL,NULL,NULL),(12596,610,5.07,30.65,NULL,NULL,NULL,NULL),(12597,610,5.74,30.84,NULL,NULL,NULL,NULL),(12598,610,6.1,30.93,NULL,NULL,NULL,NULL),(12599,610,6.75,31.52,NULL,NULL,NULL,NULL),(12600,610,8.07,31.65,NULL,NULL,NULL,NULL),(12601,610,10.76,32.48,NULL,NULL,NULL,NULL),(12602,610,12,32.65,NULL,NULL,NULL,NULL),(12603,610,12.8,33.24,NULL,NULL,NULL,NULL),(12604,610,13.99,32.9,NULL,NULL,NULL,NULL),(12605,610,15.03,32.58,NULL,NULL,NULL,NULL),(12606,610,15.86,32.92,NULL,NULL,NULL,NULL),(12607,610,17.82,33.2,NULL,NULL,NULL,NULL),(12608,610,19.07,33.4,NULL,NULL,NULL,NULL),(12609,610,20.07,33.74,NULL,NULL,NULL,NULL),(12610,610,21.07,33.3,NULL,NULL,NULL,NULL),(12611,610,22.03,33.39,NULL,NULL,NULL,NULL),(12612,610,24.71,33.53,NULL,NULL,NULL,NULL),(12613,610,25.74,34.01,NULL,NULL,NULL,NULL),(12614,610,27.03,33.83,NULL,NULL,NULL,NULL),(12615,610,31.99,34.3,NULL,NULL,NULL,NULL),(12616,610,35.99,34.7,NULL,NULL,NULL,NULL),(12617,610,41.05,35.07,NULL,NULL,NULL,NULL),(12618,610,56.99,35.11,NULL,NULL,NULL,NULL),(12619,610,71.01,35.39,NULL,NULL,NULL,NULL),(12620,610,103.07,35.52,NULL,NULL,NULL,NULL),(12621,610,147.94,35.69,NULL,NULL,NULL,NULL),(12622,610,160.99,35.61,NULL,NULL,NULL,NULL),(12623,610,230.94,35.95,NULL,NULL,NULL,NULL),(12624,610,304.78,36.12,NULL,NULL,NULL,NULL),(12625,610,355.86,35.75,NULL,NULL,NULL,NULL),(12626,610,386.78,35.96,NULL,NULL,NULL,NULL),(12627,610,452.78,35.98,NULL,NULL,NULL,NULL),(12628,610,486.94,35.94,NULL,NULL,NULL,NULL),(12629,611,0,20,NULL,NULL,NULL,NULL),(12630,611,0,20.28,NULL,NULL,NULL,NULL),(12631,611,0.02,21.32,NULL,NULL,NULL,NULL),(12632,611,0.05,21.41,NULL,NULL,NULL,NULL),(12633,611,0.12,21.69,NULL,NULL,NULL,NULL),(12634,611,0.15,21.78,NULL,NULL,NULL,NULL),(12635,611,0.76,22.87,NULL,NULL,NULL,NULL),(12636,611,1.09,23.31,NULL,NULL,NULL,NULL),(12637,611,1.76,24.21,NULL,NULL,NULL,NULL),(12638,611,2.77,24.7,NULL,NULL,NULL,NULL),(12639,611,3.76,25.39,NULL,NULL,NULL,NULL),(12640,611,6.78,26.82,NULL,NULL,NULL,NULL),(12641,611,10.01,27.03,NULL,NULL,NULL,NULL),(12642,611,13.84,27.63,NULL,NULL,NULL,NULL),(12643,611,17.09,28.27,NULL,NULL,NULL,NULL),(12644,611,24.76,28.7,NULL,NULL,NULL,NULL),(12645,611,32.01,29.09,NULL,NULL,NULL,NULL),(12646,611,44.01,29.53,NULL,NULL,NULL,NULL),(12647,611,99.09,30.45,NULL,NULL,NULL,NULL),(12648,611,157.01,30.8,NULL,NULL,NULL,NULL),(12649,611,239.96,31.11,NULL,NULL,NULL,NULL),(12650,611,300.99,31.45,NULL,NULL,NULL,NULL),(12651,611,373.88,31.25,NULL,NULL,NULL,NULL),(12652,611,448.8,31.64,NULL,NULL,NULL,NULL),(12653,611,482.96,31.51,NULL,NULL,NULL,NULL),(12654,612,0,19.4,NULL,NULL,NULL,NULL),(12655,612,0,19.54,NULL,NULL,NULL,NULL),(12656,612,0,19.61,NULL,NULL,NULL,NULL),(12657,612,0,19.68,NULL,NULL,NULL,NULL),(12658,612,0.01,19.75,NULL,NULL,NULL,NULL),(12659,612,0.01,19.89,NULL,NULL,NULL,NULL),(12660,612,0.02,20.04,NULL,NULL,NULL,NULL),(12661,612,0.03,20.25,NULL,NULL,NULL,NULL),(12662,612,0.05,20.18,NULL,NULL,NULL,NULL),(12663,612,0.06,20.25,NULL,NULL,NULL,NULL),(12664,612,0.08,20.32,NULL,NULL,NULL,NULL),(12665,612,0.19,20.74,NULL,NULL,NULL,NULL),(12666,612,0.28,20.74,NULL,NULL,NULL,NULL),(12667,612,0.98,21.36,NULL,NULL,NULL,NULL),(12668,612,1.27,21.49,NULL,NULL,NULL,NULL),(12669,612,1.98,21.76,NULL,NULL,NULL,NULL),(12670,612,2.22,21.97,NULL,NULL,NULL,NULL),(12671,612,2.98,21.95,NULL,NULL,NULL,NULL),(12672,612,6.01,22.53,NULL,NULL,NULL,NULL),(12673,612,7.19,22.65,NULL,NULL,NULL,NULL),(12674,612,10.04,22.95,NULL,NULL,NULL,NULL),(12675,612,14.18,23.45,NULL,NULL,NULL,NULL),(12676,612,16.98,23.55,NULL,NULL,NULL,NULL),(12677,612,23,24.04,NULL,NULL,NULL,NULL),(12678,612,23.97,24.03,NULL,NULL,NULL,NULL),(12679,612,31.2,24.44,NULL,NULL,NULL,NULL),(12680,612,37.2,24.59,NULL,NULL,NULL,NULL),(12681,612,41.97,24.83,NULL,NULL,NULL,NULL),(12682,612,50,24.98,NULL,NULL,NULL,NULL),(12683,612,71.23,25.33,NULL,NULL,NULL,NULL),(12684,612,84.07,25.9,NULL,NULL,NULL,NULL),(12685,612,96.99,25.84,NULL,NULL,NULL,NULL),(12686,612,125.18,26.3,NULL,NULL,NULL,NULL),(12687,612,135.99,26.54,NULL,NULL,NULL,NULL),(12688,612,149.01,26.65,NULL,NULL,NULL,NULL),(12689,612,155.05,26.56,NULL,NULL,NULL,NULL),(12690,612,167,26.6,NULL,NULL,NULL,NULL),(12691,612,188.19,26.83,NULL,NULL,NULL,NULL),(12692,612,198.05,26.81,NULL,NULL,NULL,NULL),(12693,612,211.22,26.93,NULL,NULL,NULL,NULL),(12694,612,246.21,26.87,NULL,NULL,NULL,NULL),(12695,612,280,27.1,NULL,NULL,NULL,NULL),(12696,612,349,27.45,NULL,NULL,NULL,NULL),(12697,612,440.19,28.08,NULL,NULL,NULL,NULL),(12698,612,534.19,28.02,NULL,NULL,NULL,NULL),(12699,612,545.03,28.01,NULL,NULL,NULL,NULL),(12700,612,591.02,28.27,NULL,NULL,NULL,NULL),(12701,612,768.03,29.12,NULL,NULL,NULL,NULL),(12702,612,849.1,29.24,NULL,NULL,NULL,NULL),(12703,612,920.19,29.5,NULL,NULL,NULL,NULL),(12704,612,1025.19,29.34,NULL,NULL,NULL,NULL),(12705,612,1079.98,29.54,NULL,NULL,NULL,NULL),(12706,612,1113.24,29.67,NULL,NULL,NULL,NULL),(12707,612,1277.01,29.86,NULL,NULL,NULL,NULL),(12708,612,1427,32.2,NULL,NULL,NULL,NULL),(12709,612,1772,32.36,NULL,NULL,NULL,NULL),(12710,612,1872,33.56,NULL,NULL,NULL,NULL),(12711,613,0,35.3,NULL,NULL,NULL,NULL),(12712,613,0,36.08,NULL,NULL,NULL,NULL),(12713,613,0,36.62,NULL,NULL,NULL,NULL),(12714,613,0,37.68,NULL,NULL,NULL,NULL),(12715,613,0.01,38.23,NULL,NULL,NULL,NULL),(12716,613,0.01,38.16,NULL,NULL,NULL,NULL),(12717,613,0.01,38.94,NULL,NULL,NULL,NULL),(12718,613,0.02,39.65,NULL,NULL,NULL,NULL),(12719,613,0.04,39.77,NULL,NULL,NULL,NULL),(12720,613,0.04,40.28,NULL,NULL,NULL,NULL),(12721,613,0.08,41.47,NULL,NULL,NULL,NULL),(12722,613,0.1,41.31,NULL,NULL,NULL,NULL),(12723,613,0.11,41.78,NULL,NULL,NULL,NULL),(12724,613,0.75,48.73,NULL,NULL,NULL,NULL),(12725,613,1.05,49.58,NULL,NULL,NULL,NULL),(12726,613,1.76,52.03,NULL,NULL,NULL,NULL),(12727,613,2.08,52.22,NULL,NULL,NULL,NULL),(12728,613,2.96,52.79,NULL,NULL,NULL,NULL),(12729,613,6.03,55.12,NULL,NULL,NULL,NULL),(12730,613,7.03,55.21,NULL,NULL,NULL,NULL),(12731,613,7.99,55.96,NULL,NULL,NULL,NULL),(12732,613,9.08,56.12,NULL,NULL,NULL,NULL),(12733,613,13.05,56.32,NULL,NULL,NULL,NULL),(12734,613,14.75,56.47,NULL,NULL,NULL,NULL),(12735,613,15.84,56.5,NULL,NULL,NULL,NULL),(12736,613,16.75,56.59,NULL,NULL,NULL,NULL),(12737,613,19.76,56.87,NULL,NULL,NULL,NULL),(12738,613,21.09,56.63,NULL,NULL,NULL,NULL),(12739,613,21.75,57.4,NULL,NULL,NULL,NULL),(12740,613,24.1,56.43,NULL,NULL,NULL,NULL),(12741,613,26.8,56.33,NULL,NULL,NULL,NULL),(12742,614,0,22.33,NULL,NULL,NULL,NULL),(12743,614,0.01,23.42,NULL,NULL,NULL,NULL),(12744,614,0.02,24.92,NULL,NULL,NULL,NULL),(12745,614,0.04,25.6,NULL,NULL,NULL,NULL),(12746,614,0.11,26.67,NULL,NULL,NULL,NULL),(12747,614,0.28,28.11,NULL,NULL,NULL,NULL),(12748,614,0.69,30.15,NULL,NULL,NULL,NULL),(12749,614,0.92,31.44,NULL,NULL,NULL,NULL),(12750,614,1.04,32.36,NULL,NULL,NULL,NULL),(12751,614,1.7,33.66,NULL,NULL,NULL,NULL),(12752,614,3.69,35.62,NULL,NULL,NULL,NULL),(12753,614,5.03,36.72,NULL,NULL,NULL,NULL),(12754,614,6.05,37.63,NULL,NULL,NULL,NULL),(12755,614,7.04,38.29,NULL,NULL,NULL,NULL),(12756,614,8.03,39.09,NULL,NULL,NULL,NULL),(12757,614,10.71,39.69,NULL,NULL,NULL,NULL),(12758,614,11.96,40.23,NULL,NULL,NULL,NULL),(12759,614,13.94,40.44,NULL,NULL,NULL,NULL),(12760,614,17.78,41.19,NULL,NULL,NULL,NULL),(12761,614,20.03,41.83,NULL,NULL,NULL,NULL),(12762,614,25.69,42.55,NULL,NULL,NULL,NULL),(12763,614,31.94,43.17,NULL,NULL,NULL,NULL),(12764,614,35.94,43.95,NULL,NULL,NULL,NULL),(12765,614,42.78,44.49,NULL,NULL,NULL,NULL),(12766,614,47.94,45.14,NULL,NULL,NULL,NULL),(12767,614,60.99,45.58,NULL,NULL,NULL,NULL),(12768,614,74.99,46.22,NULL,NULL,NULL,NULL),(12769,614,118.74,46.09,NULL,NULL,NULL,NULL),(12770,614,147.9,46.46,NULL,NULL,NULL,NULL),(12771,614,207.94,47.11,NULL,NULL,NULL,NULL),(12772,614,304.74,47.74,NULL,NULL,NULL,NULL),(12773,614,377.82,47.91,NULL,NULL,NULL,NULL),(12774,614,452.74,48.13,NULL,NULL,NULL,NULL),(12775,614,486.9,47.79,NULL,NULL,NULL,NULL),(12776,615,0.01,20.56,NULL,NULL,NULL,NULL),(12777,615,0.02,20.84,NULL,NULL,NULL,NULL),(12778,615,0.05,21.49,NULL,NULL,NULL,NULL),(12779,615,0.14,22.04,NULL,NULL,NULL,NULL),(12780,615,0.75,23.74,NULL,NULL,NULL,NULL),(12781,615,1.09,24.54,NULL,NULL,NULL,NULL),(12782,615,1.75,25.02,NULL,NULL,NULL,NULL),(12783,615,2.11,25.82,NULL,NULL,NULL,NULL),(12784,615,3.1,26.37,NULL,NULL,NULL,NULL),(12785,615,4.1,27.01,NULL,NULL,NULL,NULL),(12786,615,6.77,27.99,NULL,NULL,NULL,NULL),(12787,615,8.81,28.58,NULL,NULL,NULL,NULL),(12788,615,11.04,28.99,NULL,NULL,NULL,NULL),(12789,615,11.88,29.31,NULL,NULL,NULL,NULL),(12790,615,15.09,29.79,NULL,NULL,NULL,NULL),(12791,615,18.04,30.2,NULL,NULL,NULL,NULL),(12792,615,28,30.84,NULL,NULL,NULL,NULL),(12793,615,37.06,31.51,NULL,NULL,NULL,NULL),(12794,615,57.04,32.3,NULL,NULL,NULL,NULL),(12795,615,71.04,32.65,NULL,NULL,NULL,NULL),(12796,615,99.09,33.07,NULL,NULL,NULL,NULL),(12797,615,128,33.3,NULL,NULL,NULL,NULL),(12798,615,143.96,33.56,NULL,NULL,NULL,NULL),(12799,615,168.96,33.98,NULL,NULL,NULL,NULL),(12800,615,226.96,33.73,NULL,NULL,NULL,NULL),(12801,615,266.98,33.59,NULL,NULL,NULL,NULL),(12802,615,300.79,34.06,NULL,NULL,NULL,NULL),(12803,615,332.96,34.08,NULL,NULL,NULL,NULL),(12804,615,373.88,33.8,NULL,NULL,NULL,NULL),(12805,615,448.79,33.96,NULL,NULL,NULL,NULL),(12806,615,482.96,33.91,NULL,NULL,NULL,NULL),(12807,616,0,19.83,NULL,NULL,NULL,NULL),(12808,616,0,19.97,NULL,NULL,NULL,NULL),(12809,616,0,20.04,NULL,NULL,NULL,NULL),(12810,616,0,20.04,NULL,NULL,NULL,NULL),(12811,616,0.01,20.66,NULL,NULL,NULL,NULL),(12812,616,0.01,20.73,NULL,NULL,NULL,NULL),(12813,616,0.02,20.79,NULL,NULL,NULL,NULL),(12814,616,0.04,20.79,NULL,NULL,NULL,NULL),(12815,616,0.06,20.86,NULL,NULL,NULL,NULL),(12816,616,0.17,21.07,NULL,NULL,NULL,NULL),(12817,616,0.26,21.13,NULL,NULL,NULL,NULL),(12818,616,0.96,21.8,NULL,NULL,NULL,NULL),(12819,616,1.25,22.07,NULL,NULL,NULL,NULL),(12820,616,1.96,22.12,NULL,NULL,NULL,NULL),(12821,616,2.2,22.18,NULL,NULL,NULL,NULL),(12822,616,2.96,22.36,NULL,NULL,NULL,NULL),(12823,616,5.98,23.11,NULL,NULL,NULL,NULL),(12824,616,7.17,23.42,NULL,NULL,NULL,NULL),(12825,616,10.02,23.22,NULL,NULL,NULL,NULL),(12826,616,14.16,24.03,NULL,NULL,NULL,NULL),(12827,616,16.96,24.18,NULL,NULL,NULL,NULL),(12828,616,22.97,24.69,NULL,NULL,NULL,NULL),(12829,616,23.95,24.81,NULL,NULL,NULL,NULL),(12830,616,31.18,25.25,NULL,NULL,NULL,NULL),(12831,616,37.18,25.24,NULL,NULL,NULL,NULL),(12832,616,41.95,25.53,NULL,NULL,NULL,NULL),(12833,616,49.98,25.99,NULL,NULL,NULL,NULL),(12834,616,71.21,26.49,NULL,NULL,NULL,NULL),(12835,616,84.05,26.81,NULL,NULL,NULL,NULL),(12836,616,96.97,26.8,NULL,NULL,NULL,NULL),(12837,616,125.15,27.14,NULL,NULL,NULL,NULL),(12838,616,135.97,27.3,NULL,NULL,NULL,NULL),(12839,616,148.99,27.45,NULL,NULL,NULL,NULL),(12840,616,155.03,27.43,NULL,NULL,NULL,NULL),(12841,616,166.98,27.38,NULL,NULL,NULL,NULL),(12842,616,188.17,27.52,NULL,NULL,NULL,NULL),(12843,616,198.03,27.63,NULL,NULL,NULL,NULL),(12844,616,211.2,27.53,NULL,NULL,NULL,NULL),(12845,616,246.19,27.44,NULL,NULL,NULL,NULL),(12846,616,279.97,27.72,NULL,NULL,NULL,NULL),(12847,616,348.97,28.16,NULL,NULL,NULL,NULL),(12848,616,440.17,28.59,NULL,NULL,NULL,NULL),(12849,616,534.17,28.64,NULL,NULL,NULL,NULL),(12850,616,545,28.77,NULL,NULL,NULL,NULL),(12851,616,590.99,29.01,NULL,NULL,NULL,NULL),(12852,616,768,29.79,NULL,NULL,NULL,NULL),(12853,616,849.08,29.68,NULL,NULL,NULL,NULL),(12854,616,920.16,29.79,NULL,NULL,NULL,NULL),(12855,616,1025.17,29.89,NULL,NULL,NULL,NULL),(12856,616,1079.95,30.08,NULL,NULL,NULL,NULL),(12857,616,1113.21,30.13,NULL,NULL,NULL,NULL),(12858,616,1276.98,30.23,NULL,NULL,NULL,NULL),(12859,617,0,28,NULL,NULL,NULL,NULL),(12860,617,0,28.42,NULL,NULL,NULL,NULL),(12861,617,0,28.63,NULL,NULL,NULL,NULL),(12862,617,0,29.04,NULL,NULL,NULL,NULL),(12863,617,0.01,29.66,NULL,NULL,NULL,NULL),(12864,617,0.01,31.1,NULL,NULL,NULL,NULL),(12865,617,0.05,33.09,NULL,NULL,NULL,NULL),(12866,617,0.09,34.24,NULL,NULL,NULL,NULL),(12867,617,0.73,40.17,NULL,NULL,NULL,NULL),(12868,617,3.08,44.83,NULL,NULL,NULL,NULL),(12869,617,6.95,46.71,NULL,NULL,NULL,NULL),(12870,617,8.75,47.2,NULL,NULL,NULL,NULL),(12871,617,12.77,48.1,NULL,NULL,NULL,NULL),(12872,617,13.95,48.06,NULL,NULL,NULL,NULL),(12873,617,16.8,47.12,NULL,NULL,NULL,NULL),(12874,617,20.94,49.01,NULL,NULL,NULL,NULL),(12875,617,23.74,49.07,NULL,NULL,NULL,NULL),(12876,617,26.76,49.56,NULL,NULL,NULL,NULL),(12877,618,0,21,NULL,NULL,NULL,NULL),(12878,618,0,21.2,NULL,NULL,NULL,NULL),(12879,618,0,21.29,NULL,NULL,NULL,NULL),(12880,618,0,21.49,NULL,NULL,NULL,NULL),(12881,618,0,21.59,NULL,NULL,NULL,NULL),(12882,618,0.01,21.68,NULL,NULL,NULL,NULL),(12883,618,0.01,21.78,NULL,NULL,NULL,NULL),(12884,618,0.03,22.07,NULL,NULL,NULL,NULL),(12885,618,0.04,22.17,NULL,NULL,NULL,NULL),(12886,618,0.06,22.36,NULL,NULL,NULL,NULL),(12887,618,0.08,22.55,NULL,NULL,NULL,NULL),(12888,618,0.13,22.84,NULL,NULL,NULL,NULL),(12889,618,0.17,23.03,NULL,NULL,NULL,NULL),(12890,618,0.21,23.22,NULL,NULL,NULL,NULL),(12891,618,0.29,23.5,NULL,NULL,NULL,NULL),(12892,618,0.42,23.87,NULL,NULL,NULL,NULL),(12893,618,0.63,24.33,NULL,NULL,NULL,NULL),(12894,618,1,24.95,NULL,NULL,NULL,NULL),(12895,618,1.5,25.57,NULL,NULL,NULL,NULL),(12896,618,1.7,25.84,NULL,NULL,NULL,NULL),(12897,618,6.77,28.79,NULL,NULL,NULL,NULL),(12898,618,8.76,29.59,NULL,NULL,NULL,NULL),(12899,618,10.79,30.11,NULL,NULL,NULL,NULL),(12900,618,14.73,31.21,NULL,NULL,NULL,NULL),(12901,618,18.03,31.51,NULL,NULL,NULL,NULL),(12902,618,27.78,32.43,NULL,NULL,NULL,NULL),(12903,618,42.07,33.25,NULL,NULL,NULL,NULL),(12904,618,52.01,33.7,NULL,NULL,NULL,NULL),(12905,618,77.72,34.62,NULL,NULL,NULL,NULL),(12906,618,157.76,34.59,NULL,NULL,NULL,NULL),(12907,618,188.74,34.82,NULL,NULL,NULL,NULL),(12908,618,268.01,35.12,NULL,NULL,NULL,NULL),(12909,618,335.76,35.55,NULL,NULL,NULL,NULL),(12910,618,485.93,36.39,NULL,NULL,NULL,NULL),(12911,618,575.76,36.68,NULL,NULL,NULL,NULL),(12912,618,778.76,37.36,NULL,NULL,NULL,NULL),(12913,618,981.76,38.87,NULL,NULL,NULL,NULL),(12914,618,1149.34,39.3,NULL,NULL,NULL,NULL),(12915,618,1303.34,39.84,NULL,NULL,NULL,NULL),(12916,618,1700.34,40.34,NULL,NULL,NULL,NULL),(12917,619,0,19.5,NULL,NULL,NULL,NULL),(12918,619,0,19.63,NULL,NULL,NULL,NULL),(12919,619,0,19.77,NULL,NULL,NULL,NULL),(12920,619,0,19.83,NULL,NULL,NULL,NULL),(12921,619,0,19.9,NULL,NULL,NULL,NULL),(12922,619,0.01,20.03,NULL,NULL,NULL,NULL),(12923,619,0.1,20.97,NULL,NULL,NULL,NULL),(12924,619,0.77,22.44,NULL,NULL,NULL,NULL),(12925,619,1.06,22.91,NULL,NULL,NULL,NULL),(12926,619,3.1,23.98,NULL,NULL,NULL,NULL),(12927,619,6.81,25.18,NULL,NULL,NULL,NULL),(12928,619,10.02,25.78,NULL,NULL,NULL,NULL),(12929,619,19.77,26.85,NULL,NULL,NULL,NULL),(12930,619,33.77,27.92,NULL,NULL,NULL,NULL),(12931,619,51.85,28.65,NULL,NULL,NULL,NULL),(12932,619,82.97,29.45,NULL,NULL,NULL,NULL),(12933,619,163.79,30.32,NULL,NULL,NULL,NULL),(12934,619,294.81,30.39,NULL,NULL,NULL,NULL),(12935,619,427.81,31.66,NULL,NULL,NULL,NULL),(12936,620,0,34.5,NULL,NULL,NULL,NULL),(12937,620,0,35.28,NULL,NULL,NULL,NULL),(12938,620,0,36.46,NULL,NULL,NULL,NULL),(12939,620,0.01,38.03,NULL,NULL,NULL,NULL),(12940,620,0.06,39.21,NULL,NULL,NULL,NULL),(12941,620,0.12,43.13,NULL,NULL,NULL,NULL),(12942,620,0.78,48.62,NULL,NULL,NULL,NULL),(12943,620,1.87,50.97,NULL,NULL,NULL,NULL),(12944,620,2.78,53.32,NULL,NULL,NULL,NULL),(12945,620,5.78,55.68,NULL,NULL,NULL,NULL),(12946,620,7.12,57.25,NULL,NULL,NULL,NULL),(12947,620,7.77,56.46,NULL,NULL,NULL,NULL),(12948,620,14,57.64,NULL,NULL,NULL,NULL),(12949,620,15.79,59.6,NULL,NULL,NULL,NULL),(12950,620,19.81,59.99,NULL,NULL,NULL,NULL),(12951,620,23.84,60.77,NULL,NULL,NULL,NULL),(12952,620,26.8,60.77,NULL,NULL,NULL,NULL),(12953,621,0,23.06,NULL,NULL,NULL,NULL),(12954,621,0,23.32,NULL,NULL,NULL,NULL),(12955,621,0,23.44,NULL,NULL,NULL,NULL),(12956,621,0,23.7,NULL,NULL,NULL,NULL),(12957,621,0,23.83,NULL,NULL,NULL,NULL),(12958,621,0.01,23.96,NULL,NULL,NULL,NULL),(12959,621,0.01,24.08,NULL,NULL,NULL,NULL),(12960,621,0.01,24.21,NULL,NULL,NULL,NULL),(12961,621,0.02,24.47,NULL,NULL,NULL,NULL),(12962,621,0.03,24.59,NULL,NULL,NULL,NULL),(12963,621,0.04,24.59,NULL,NULL,NULL,NULL),(12964,621,0.06,24.85,NULL,NULL,NULL,NULL),(12965,621,0.08,24.97,NULL,NULL,NULL,NULL),(12966,621,0.12,25.35,NULL,NULL,NULL,NULL),(12967,621,0.17,25.6,NULL,NULL,NULL,NULL),(12968,621,0.21,25.85,NULL,NULL,NULL,NULL),(12969,621,0.29,26.22,NULL,NULL,NULL,NULL),(12970,621,0.42,26.59,NULL,NULL,NULL,NULL),(12971,621,0.67,27.33,NULL,NULL,NULL,NULL),(12972,621,0.83,27.69,NULL,NULL,NULL,NULL),(12973,621,0.96,28.19,NULL,NULL,NULL,NULL),(12974,621,1.73,29.12,NULL,NULL,NULL,NULL),(12975,621,3.78,30.7,NULL,NULL,NULL,NULL),(12976,621,6.68,32.13,NULL,NULL,NULL,NULL),(12977,621,8.82,32.88,NULL,NULL,NULL,NULL),(12978,621,13.74,34.29,NULL,NULL,NULL,NULL),(12979,621,15.73,34.58,NULL,NULL,NULL,NULL),(12980,621,17.77,34.89,NULL,NULL,NULL,NULL),(12981,621,21.7,35.26,NULL,NULL,NULL,NULL),(12982,621,25.01,35.67,NULL,NULL,NULL,NULL),(12983,621,34.77,36.46,NULL,NULL,NULL,NULL),(12984,621,49.05,36.85,NULL,NULL,NULL,NULL),(12985,621,58.98,37.23,NULL,NULL,NULL,NULL),(12986,621,84.69,37.74,NULL,NULL,NULL,NULL),(12987,621,114.78,38.18,NULL,NULL,NULL,NULL),(12988,621,164.73,38.45,NULL,NULL,NULL,NULL),(12989,621,195.71,38.86,NULL,NULL,NULL,NULL),(12990,621,274.98,38.92,NULL,NULL,NULL,NULL),(12991,621,342.69,39.31,NULL,NULL,NULL,NULL),(12992,621,492.9,40.41,NULL,NULL,NULL,NULL),(12993,621,582.73,40.72,NULL,NULL,NULL,NULL),(12994,622,0.01,21.19,NULL,NULL,NULL,NULL),(12995,622,0.01,21.28,NULL,NULL,NULL,NULL),(12996,622,0.01,21.36,NULL,NULL,NULL,NULL),(12997,622,0.01,21.45,NULL,NULL,NULL,NULL),(12998,622,0.02,21.62,NULL,NULL,NULL,NULL),(12999,622,0.02,21.7,NULL,NULL,NULL,NULL),(13000,622,0.05,22.05,NULL,NULL,NULL,NULL),(13001,622,0.07,22.3,NULL,NULL,NULL,NULL),(13002,622,0.1,22.65,NULL,NULL,NULL,NULL),(13003,622,0.73,24.26,NULL,NULL,NULL,NULL),(13004,622,0.94,24.69,NULL,NULL,NULL,NULL),(13005,622,1.74,25.19,NULL,NULL,NULL,NULL),(13006,622,2.06,25.52,NULL,NULL,NULL,NULL),(13007,622,2.74,25.77,NULL,NULL,NULL,NULL),(13008,622,3.01,26.11,NULL,NULL,NULL,NULL),(13009,622,3.74,26.18,NULL,NULL,NULL,NULL),(13010,622,4.03,26.52,NULL,NULL,NULL,NULL),(13011,622,6.73,26.72,NULL,NULL,NULL,NULL),(13012,622,9.75,26.85,NULL,NULL,NULL,NULL),(13013,622,10.73,26.92,NULL,NULL,NULL,NULL),(13014,622,17.96,27.33,NULL,NULL,NULL,NULL),(13015,622,23.96,28.03,NULL,NULL,NULL,NULL),(13016,622,28.73,28.24,NULL,NULL,NULL,NULL),(13017,622,36.76,28.6,NULL,NULL,NULL,NULL),(13018,622,47.99,29.37,NULL,NULL,NULL,NULL),(13019,622,70.83,30.44,NULL,NULL,NULL,NULL),(13020,622,83.75,30.29,NULL,NULL,NULL,NULL),(13021,622,111.93,31.47,NULL,NULL,NULL,NULL),(13022,622,122.75,31.7,NULL,NULL,NULL,NULL),(13023,622,135.77,31.66,NULL,NULL,NULL,NULL),(13024,622,141.81,32.16,NULL,NULL,NULL,NULL),(13025,622,153.76,32.21,NULL,NULL,NULL,NULL),(13026,622,174.95,32.68,NULL,NULL,NULL,NULL),(13027,622,184.81,32.49,NULL,NULL,NULL,NULL),(13028,622,197.98,32.55,NULL,NULL,NULL,NULL),(13029,622,266.75,33.31,NULL,NULL,NULL,NULL),(13030,622,335.75,33.83,NULL,NULL,NULL,NULL),(13031,622,426.95,34.61,NULL,NULL,NULL,NULL),(13032,622,520.95,34.98,NULL,NULL,NULL,NULL),(13033,622,531.78,35.23,NULL,NULL,NULL,NULL),(13034,622,577.77,35.55,NULL,NULL,NULL,NULL),(13035,622,754.78,37.02,NULL,NULL,NULL,NULL),(13036,622,835.86,37.42,NULL,NULL,NULL,NULL),(13037,622,906.94,38.43,NULL,NULL,NULL,NULL),(13038,622,1011.95,38.14,NULL,NULL,NULL,NULL),(13039,622,1066.73,38.65,NULL,NULL,NULL,NULL),(13040,622,1099.99,38.9,NULL,NULL,NULL,NULL),(13041,623,0,28.04,NULL,NULL,NULL,NULL),(13042,623,0,28.44,NULL,NULL,NULL,NULL),(13043,623,0,28.64,NULL,NULL,NULL,NULL),(13044,623,0,29.26,NULL,NULL,NULL,NULL),(13045,623,0.01,29.66,NULL,NULL,NULL,NULL),(13046,623,0.01,29.84,NULL,NULL,NULL,NULL),(13047,623,0.02,30.87,NULL,NULL,NULL,NULL),(13048,623,0.03,31.46,NULL,NULL,NULL,NULL),(13049,623,0.09,32.97,NULL,NULL,NULL,NULL),(13050,623,0.14,34.34,NULL,NULL,NULL,NULL),(13051,623,0.75,39.08,NULL,NULL,NULL,NULL),(13052,623,3.76,44.69,NULL,NULL,NULL,NULL),(13053,623,5.1,46.18,NULL,NULL,NULL,NULL),(13054,623,5.75,46.42,NULL,NULL,NULL,NULL),(13055,623,8.1,46.69,NULL,NULL,NULL,NULL),(13056,623,11.97,47.69,NULL,NULL,NULL,NULL),(13057,623,13.76,48.28,NULL,NULL,NULL,NULL),(13058,623,17.78,48.85,NULL,NULL,NULL,NULL),(13059,623,21.82,47.76,NULL,NULL,NULL,NULL),(13060,623,25.96,49.13,NULL,NULL,NULL,NULL),(13061,623,26.77,49.71,NULL,NULL,NULL,NULL),(13062,624,0,20.9,NULL,NULL,NULL,NULL),(13063,624,0,21.18,NULL,NULL,NULL,NULL),(13064,624,0,21.45,NULL,NULL,NULL,NULL),(13065,624,0.01,21.73,NULL,NULL,NULL,NULL),(13066,624,0.01,21.86,NULL,NULL,NULL,NULL),(13067,624,0.02,22,NULL,NULL,NULL,NULL),(13068,624,0.04,21.99,NULL,NULL,NULL,NULL),(13069,624,0.06,22.12,NULL,NULL,NULL,NULL),(13070,624,0.09,22.25,NULL,NULL,NULL,NULL),(13071,624,0.12,22.38,NULL,NULL,NULL,NULL),(13072,624,0.16,22.51,NULL,NULL,NULL,NULL),(13073,624,0.25,22.76,NULL,NULL,NULL,NULL),(13074,624,0.37,23.41,NULL,NULL,NULL,NULL),(13075,624,0.5,23.79,NULL,NULL,NULL,NULL),(13076,624,0.75,24.42,NULL,NULL,NULL,NULL),(13077,624,1.5,25.61,NULL,NULL,NULL,NULL),(13078,624,1.87,26.08,NULL,NULL,NULL,NULL),(13079,624,3.16,27.76,NULL,NULL,NULL,NULL),(13080,624,3.91,28.05,NULL,NULL,NULL,NULL),(13081,624,5.95,29.26,NULL,NULL,NULL,NULL),(13082,624,8.86,30.16,NULL,NULL,NULL,NULL),(13083,624,11,30.77,NULL,NULL,NULL,NULL),(13084,624,15.92,32.03,NULL,NULL,NULL,NULL),(13085,624,17.91,32.31,NULL,NULL,NULL,NULL),(13086,624,19.93,32.73,NULL,NULL,NULL,NULL),(13087,624,23.88,33.2,NULL,NULL,NULL,NULL),(13088,624,27.18,33.32,NULL,NULL,NULL,NULL),(13089,624,36.94,33.75,NULL,NULL,NULL,NULL),(13090,624,51.22,34.29,NULL,NULL,NULL,NULL),(13091,624,61.16,34.33,NULL,NULL,NULL,NULL),(13092,624,86.87,34.56,NULL,NULL,NULL,NULL),(13093,624,116.95,34.6,NULL,NULL,NULL,NULL),(13094,624,166.91,34.44,NULL,NULL,NULL,NULL),(13095,624,197.89,34.66,NULL,NULL,NULL,NULL),(13096,624,277.16,34.42,NULL,NULL,NULL,NULL),(13097,624,344.87,34.61,NULL,NULL,NULL,NULL),(13098,624,419.16,34.7,NULL,NULL,NULL,NULL),(13099,625,0,19.91,NULL,NULL,NULL,NULL),(13100,625,0,20.09,NULL,NULL,NULL,NULL),(13101,625,0,20.26,NULL,NULL,NULL,NULL),(13102,625,0,20.35,NULL,NULL,NULL,NULL),(13103,625,0,20.52,NULL,NULL,NULL,NULL),(13104,625,0,20.52,NULL,NULL,NULL,NULL),(13105,625,0.01,20.61,NULL,NULL,NULL,NULL),(13106,625,0.01,20.7,NULL,NULL,NULL,NULL),(13107,625,0.02,20.79,NULL,NULL,NULL,NULL),(13108,625,0.03,20.87,NULL,NULL,NULL,NULL),(13109,625,0.04,21.05,NULL,NULL,NULL,NULL),(13110,625,0.09,21.3,NULL,NULL,NULL,NULL),(13111,625,0.13,21.48,NULL,NULL,NULL,NULL),(13112,625,0.17,21.65,NULL,NULL,NULL,NULL),(13113,625,0.21,21.82,NULL,NULL,NULL,NULL),(13114,625,0.29,22.07,NULL,NULL,NULL,NULL),(13115,625,0.42,22.41,NULL,NULL,NULL,NULL),(13116,625,0.67,22.82,NULL,NULL,NULL,NULL),(13117,625,1,23.23,NULL,NULL,NULL,NULL),(13118,625,1.5,23.8,NULL,NULL,NULL,NULL),(13119,625,1.88,24.12,NULL,NULL,NULL,NULL),(13120,625,3,25.07,NULL,NULL,NULL,NULL),(13121,625,4,25.52,NULL,NULL,NULL,NULL),(13122,625,4.86,25.81,NULL,NULL,NULL,NULL),(13123,625,7,26.47,NULL,NULL,NULL,NULL),(13124,625,11.92,27.52,NULL,NULL,NULL,NULL),(13125,625,13.91,27.96,NULL,NULL,NULL,NULL),(13126,625,15.95,28.23,NULL,NULL,NULL,NULL),(13127,625,19.89,28.79,NULL,NULL,NULL,NULL),(13128,625,23.19,29.04,NULL,NULL,NULL,NULL),(13129,625,32.94,29.58,NULL,NULL,NULL,NULL),(13130,625,47.23,30.09,NULL,NULL,NULL,NULL),(13131,625,57.16,30.38,NULL,NULL,NULL,NULL),(13132,625,82.87,30.62,NULL,NULL,NULL,NULL),(13133,625,112.96,30.9,NULL,NULL,NULL,NULL),(13134,625,162.91,30.98,NULL,NULL,NULL,NULL),(13135,625,193.89,31.11,NULL,NULL,NULL,NULL),(13136,625,273.16,31.14,NULL,NULL,NULL,NULL),(13137,625,340.87,31.44,NULL,NULL,NULL,NULL),(13138,625,491.08,31.92,NULL,NULL,NULL,NULL),(13139,625,580.91,32,NULL,NULL,NULL,NULL),(13140,626,0,19.34,NULL,NULL,NULL,NULL),(13141,626,0,19.41,NULL,NULL,NULL,NULL),(13142,626,0,19.41,NULL,NULL,NULL,NULL),(13143,626,0.01,19.6,NULL,NULL,NULL,NULL),(13144,626,0.02,19.67,NULL,NULL,NULL,NULL),(13145,626,0.04,19.8,NULL,NULL,NULL,NULL),(13146,626,0.08,19.86,NULL,NULL,NULL,NULL),(13147,626,0.13,19.99,NULL,NULL,NULL,NULL),(13148,626,0.77,20.24,NULL,NULL,NULL,NULL),(13149,626,1.04,20.43,NULL,NULL,NULL,NULL),(13150,626,1.77,20.75,NULL,NULL,NULL,NULL),(13151,626,2.06,20.87,NULL,NULL,NULL,NULL),(13152,626,4.76,21.34,NULL,NULL,NULL,NULL),(13153,626,7.78,21.74,NULL,NULL,NULL,NULL),(13154,626,8.76,21.86,NULL,NULL,NULL,NULL),(13155,626,16.03,22.26,NULL,NULL,NULL,NULL),(13156,626,21.99,22.51,NULL,NULL,NULL,NULL),(13157,626,26.76,22.64,NULL,NULL,NULL,NULL),(13158,626,34.78,22.75,NULL,NULL,NULL,NULL),(13159,626,56.02,23.35,NULL,NULL,NULL,NULL),(13160,626,68.85,23.92,NULL,NULL,NULL,NULL),(13161,626,81.78,23.84,NULL,NULL,NULL,NULL),(13162,626,109.96,24.36,NULL,NULL,NULL,NULL),(13163,626,120.78,24.64,NULL,NULL,NULL,NULL),(13164,626,153.8,24.53,NULL,NULL,NULL,NULL),(13165,626,139.84,24.57,NULL,NULL,NULL,NULL),(13166,626,151.79,24.73,NULL,NULL,NULL,NULL),(13167,626,172.98,24.86,NULL,NULL,NULL,NULL),(13168,626,182.83,24.84,NULL,NULL,NULL,NULL),(13169,626,196.01,24.94,NULL,NULL,NULL,NULL),(13170,626,231,24.93,NULL,NULL,NULL,NULL),(13171,626,264.78,24.86,NULL,NULL,NULL,NULL),(13172,626,333.78,25.75,NULL,NULL,NULL,NULL),(13173,626,424.97,25.97,NULL,NULL,NULL,NULL),(13174,626,518.98,26.15,NULL,NULL,NULL,NULL),(13175,626,529.81,26.15,NULL,NULL,NULL,NULL),(13176,626,575.8,26.44,NULL,NULL,NULL,NULL),(13177,626,752.81,27.4,NULL,NULL,NULL,NULL),(13178,626,904.98,27.33,NULL,NULL,NULL,NULL),(13179,626,1009.98,27.1,NULL,NULL,NULL,NULL),(13180,626,1064.76,27.41,NULL,NULL,NULL,NULL),(13181,626,1098.02,27.54,NULL,NULL,NULL,NULL),(13182,627,0,34.18,NULL,NULL,NULL,NULL),(13183,627,0,34.62,NULL,NULL,NULL,NULL),(13184,627,0.01,35.83,NULL,NULL,NULL,NULL),(13185,627,0.01,36.56,NULL,NULL,NULL,NULL),(13186,627,0.02,36.71,NULL,NULL,NULL,NULL),(13187,627,0.04,37.76,NULL,NULL,NULL,NULL),(13188,627,0.89,46.15,NULL,NULL,NULL,NULL),(13189,627,3.71,51.32,NULL,NULL,NULL,NULL),(13190,627,4.96,52.74,NULL,NULL,NULL,NULL),(13191,627,5.92,53.76,NULL,NULL,NULL,NULL),(13192,627,7.01,55.27,NULL,NULL,NULL,NULL),(13193,627,10.98,54.04,NULL,NULL,NULL,NULL),(13194,627,12.68,54.74,NULL,NULL,NULL,NULL),(13195,627,13.77,55.28,NULL,NULL,NULL,NULL),(13196,627,14.68,55.44,NULL,NULL,NULL,NULL),(13197,627,17.69,55.95,NULL,NULL,NULL,NULL),(13198,627,19.02,55.15,NULL,NULL,NULL,NULL),(13199,627,19.68,56.38,NULL,NULL,NULL,NULL),(13200,627,22.03,55.39,NULL,NULL,NULL,NULL),(13201,627,25.9,56.51,NULL,NULL,NULL,NULL),(13202,627,26.68,56.84,NULL,NULL,NULL,NULL),(13203,628,0.02,22.91,NULL,NULL,NULL,NULL),(13204,628,0.03,23.43,NULL,NULL,NULL,NULL),(13205,628,0.06,24.47,NULL,NULL,NULL,NULL),(13206,628,0.1,25.5,NULL,NULL,NULL,NULL),(13207,628,0.17,26.17,NULL,NULL,NULL,NULL),(13208,628,0.52,27.56,NULL,NULL,NULL,NULL),(13209,628,1.02,29.25,NULL,NULL,NULL,NULL),(13210,628,1.87,30.65,NULL,NULL,NULL,NULL),(13211,628,2.87,32.06,NULL,NULL,NULL,NULL),(13212,628,4.23,32.91,NULL,NULL,NULL,NULL),(13213,628,4.88,33.45,NULL,NULL,NULL,NULL),(13214,628,5.87,34.28,NULL,NULL,NULL,NULL),(13215,628,8.89,35.5,NULL,NULL,NULL,NULL),(13216,628,10.93,36.97,NULL,NULL,NULL,NULL),(13217,628,12.12,35.58,NULL,NULL,NULL,NULL),(13218,628,13.16,35.11,NULL,NULL,NULL,NULL),(13219,628,15.95,36.41,NULL,NULL,NULL,NULL),(13220,628,18.2,36.91,NULL,NULL,NULL,NULL),(13221,628,23.87,37.2,NULL,NULL,NULL,NULL),(13222,628,30.12,38.08,NULL,NULL,NULL,NULL),(13223,628,34.12,38.42,NULL,NULL,NULL,NULL),(13224,628,39.18,38.38,NULL,NULL,NULL,NULL),(13225,628,44.16,39.08,NULL,NULL,NULL,NULL),(13226,628,53.95,39.32,NULL,NULL,NULL,NULL),(13227,628,73.16,39.76,NULL,NULL,NULL,NULL),(13228,628,101.2,40.38,NULL,NULL,NULL,NULL),(13229,628,106.91,40.49,NULL,NULL,NULL,NULL),(13230,628,171.08,40.08,NULL,NULL,NULL,NULL),(13231,628,229.08,40.28,NULL,NULL,NULL,NULL),(13232,628,242.08,40.4,NULL,NULL,NULL,NULL),(13233,628,269.08,39.93,NULL,NULL,NULL,NULL),(13234,628,302.91,40.34,NULL,NULL,NULL,NULL),(13235,628,335.08,39.89,NULL,NULL,NULL,NULL),(13236,628,353.99,40.01,NULL,NULL,NULL,NULL),(13237,628,450.91,41.02,NULL,NULL,NULL,NULL),(13238,628,485.08,41.14,NULL,NULL,NULL,NULL),(13239,629,0,22.63,NULL,NULL,NULL,NULL),(13240,629,0,23.11,NULL,NULL,NULL,NULL),(13241,629,0.01,23.6,NULL,NULL,NULL,NULL),(13242,629,0.02,23.96,NULL,NULL,NULL,NULL),(13243,629,0.03,24.2,NULL,NULL,NULL,NULL),(13244,629,0.04,24.32,NULL,NULL,NULL,NULL),(13245,629,0.05,24.44,NULL,NULL,NULL,NULL),(13246,629,0.08,24.55,NULL,NULL,NULL,NULL),(13247,629,0.12,24.67,NULL,NULL,NULL,NULL),(13248,629,1.11,27.17,NULL,NULL,NULL,NULL),(13249,629,1.76,27.92,NULL,NULL,NULL,NULL),(13250,629,4.78,30.2,NULL,NULL,NULL,NULL),(13251,629,6.03,30.44,NULL,NULL,NULL,NULL),(13252,629,6.83,31.21,NULL,NULL,NULL,NULL),(13253,629,9.05,31.27,NULL,NULL,NULL,NULL),(13254,629,11.85,31.92,NULL,NULL,NULL,NULL),(13255,629,16.05,32.52,NULL,NULL,NULL,NULL),(13256,629,19.76,32.71,NULL,NULL,NULL,NULL),(13257,629,26.01,33.79,NULL,NULL,NULL,NULL),(13258,629,35.08,33.88,NULL,NULL,NULL,NULL),(13259,629,42.01,34.32,NULL,NULL,NULL,NULL),(13260,629,51.01,34.5,NULL,NULL,NULL,NULL),(13261,629,69.05,34.47,NULL,NULL,NULL,NULL),(13262,629,97.1,35.02,NULL,NULL,NULL,NULL),(13263,629,126.01,35.16,NULL,NULL,NULL,NULL),(13264,629,155.01,34.99,NULL,NULL,NULL,NULL),(13265,629,201.85,35.15,NULL,NULL,NULL,NULL),(13266,629,237.97,35.27,NULL,NULL,NULL,NULL),(13267,629,298.8,35.72,NULL,NULL,NULL,NULL),(13268,629,330.97,35.4,NULL,NULL,NULL,NULL),(13269,629,349.89,35.25,NULL,NULL,NULL,NULL),(13270,629,446.8,35.34,NULL,NULL,NULL,NULL),(13271,629,480.97,35.17,NULL,NULL,NULL,NULL),(13272,630,0,20.9,NULL,NULL,NULL,NULL),(13273,630,0,20.98,NULL,NULL,NULL,NULL),(13274,630,0,20.98,NULL,NULL,NULL,NULL),(13275,630,0,20.98,NULL,NULL,NULL,NULL),(13276,630,0,21.23,NULL,NULL,NULL,NULL),(13277,630,0.01,21.31,NULL,NULL,NULL,NULL),(13278,630,0.01,21.48,NULL,NULL,NULL,NULL),(13279,630,0.03,21.48,NULL,NULL,NULL,NULL),(13280,630,0.08,21.56,NULL,NULL,NULL,NULL),(13281,630,0.72,22.37,NULL,NULL,NULL,NULL),(13282,630,0.96,22.78,NULL,NULL,NULL,NULL),(13283,630,1.72,23.01,NULL,NULL,NULL,NULL),(13284,630,4.74,24.09,NULL,NULL,NULL,NULL),(13285,630,5.93,24.23,NULL,NULL,NULL,NULL),(13286,630,8.78,24.17,NULL,NULL,NULL,NULL),(13287,630,12.92,25,NULL,NULL,NULL,NULL),(13288,630,15.72,25.28,NULL,NULL,NULL,NULL),(13289,630,21.73,25.77,NULL,NULL,NULL,NULL),(13290,630,22.71,25.92,NULL,NULL,NULL,NULL),(13291,630,29.94,26.24,NULL,NULL,NULL,NULL),(13292,630,35.94,26.25,NULL,NULL,NULL,NULL),(13293,630,40.71,26.45,NULL,NULL,NULL,NULL),(13294,630,48.74,27.04,NULL,NULL,NULL,NULL),(13295,630,69.97,27.21,NULL,NULL,NULL,NULL),(13296,630,82.81,27.96,NULL,NULL,NULL,NULL),(13297,630,95.73,27.97,NULL,NULL,NULL,NULL),(13298,630,123.91,28.51,NULL,NULL,NULL,NULL),(13299,630,134.73,28.89,NULL,NULL,NULL,NULL),(13300,630,147.75,29.26,NULL,NULL,NULL,NULL),(13301,630,153.8,29.08,NULL,NULL,NULL,NULL),(13302,630,165.74,29.21,NULL,NULL,NULL,NULL),(13303,630,186.93,29.57,NULL,NULL,NULL,NULL),(13304,630,196.79,29.29,NULL,NULL,NULL,NULL),(13305,630,209.99,29.43,NULL,NULL,NULL,NULL),(13306,630,244.95,29.28,NULL,NULL,NULL,NULL),(13307,630,278.73,29.72,NULL,NULL,NULL,NULL),(13308,630,347.73,30.37,NULL,NULL,NULL,NULL),(13309,630,438.93,31.19,NULL,NULL,NULL,NULL),(13310,630,532.93,31.45,NULL,NULL,NULL,NULL),(13311,630,543.77,31.69,NULL,NULL,NULL,NULL),(13312,630,589.75,32.08,NULL,NULL,NULL,NULL),(13313,630,766.77,33.23,NULL,NULL,NULL,NULL),(13314,630,918.92,33.67,NULL,NULL,NULL,NULL),(13315,630,1023.93,33.55,NULL,NULL,NULL,NULL),(13316,630,1078.71,34.2,NULL,NULL,NULL,NULL),(13317,630,1111.97,34.52,NULL,NULL,NULL,NULL),(13318,630,1275.74,35.15,NULL,NULL,NULL,NULL),(13319,631,0,30.85,NULL,NULL,NULL,NULL),(13320,631,0,31.41,NULL,NULL,NULL,NULL),(13321,631,0,31.7,NULL,NULL,NULL,NULL),(13322,631,0,31.84,NULL,NULL,NULL,NULL),(13323,631,0.01,33.1,NULL,NULL,NULL,NULL),(13324,631,0.03,35.08,NULL,NULL,NULL,NULL),(13325,631,0.08,35.92,NULL,NULL,NULL,NULL),(13326,631,0.74,41.55,NULL,NULL,NULL,NULL),(13327,631,1.82,44.65,NULL,NULL,NULL,NULL),(13328,631,2.73,45.5,NULL,NULL,NULL,NULL),(13329,631,5.74,46.91,NULL,NULL,NULL,NULL),(13330,631,7.08,48.6,NULL,NULL,NULL,NULL),(13331,631,8.08,48.88,NULL,NULL,NULL,NULL),(13332,631,10.08,49.16,NULL,NULL,NULL,NULL),(13333,631,13.95,50.57,NULL,NULL,NULL,NULL),(13334,631,15.74,50.57,NULL,NULL,NULL,NULL),(13335,631,19.76,51.41,NULL,NULL,NULL,NULL),(13336,631,26.76,52.82,NULL,NULL,NULL,NULL),(13337,632,0,23.36,NULL,NULL,NULL,NULL),(13338,632,0,23.56,NULL,NULL,NULL,NULL),(13339,632,0,23.76,NULL,NULL,NULL,NULL),(13340,632,0,23.95,NULL,NULL,NULL,NULL),(13341,632,0.01,24.35,NULL,NULL,NULL,NULL),(13342,632,0.01,24.54,NULL,NULL,NULL,NULL),(13343,632,0.02,24.74,NULL,NULL,NULL,NULL),(13344,632,0.04,24.93,NULL,NULL,NULL,NULL),(13345,632,0.06,25.32,NULL,NULL,NULL,NULL),(13346,632,0.08,25.32,NULL,NULL,NULL,NULL),(13347,632,0.08,25.51,NULL,NULL,NULL,NULL),(13348,632,0.12,25.5,NULL,NULL,NULL,NULL),(13349,632,0.21,25.87,NULL,NULL,NULL,NULL),(13350,632,0.33,26.23,NULL,NULL,NULL,NULL),(13351,632,0.5,26.58,NULL,NULL,NULL,NULL),(13352,632,0.74,27.3,NULL,NULL,NULL,NULL),(13353,632,1,27.63,NULL,NULL,NULL,NULL),(13354,632,1.68,28.67,NULL,NULL,NULL,NULL),(13355,632,3.68,29.7,NULL,NULL,NULL,NULL),(13356,632,4.98,30.12,NULL,NULL,NULL,NULL),(13357,632,5.73,30.23,NULL,NULL,NULL,NULL),(13358,632,7.77,30.41,NULL,NULL,NULL,NULL),(13359,632,10.67,30.77,NULL,NULL,NULL,NULL),(13360,632,12.81,31.02,NULL,NULL,NULL,NULL),(13361,632,17.73,31.55,NULL,NULL,NULL,NULL),(13362,632,19.73,31.85,NULL,NULL,NULL,NULL),(13363,632,21.76,32.17,NULL,NULL,NULL,NULL),(13364,632,25.69,32.42,NULL,NULL,NULL,NULL),(13365,632,29,32.71,NULL,NULL,NULL,NULL),(13366,632,38.76,33.04,NULL,NULL,NULL,NULL),(13367,632,52.76,33.36,NULL,NULL,NULL,NULL),(13368,632,62.98,33.6,NULL,NULL,NULL,NULL),(13369,632,88.68,33.89,NULL,NULL,NULL,NULL),(13370,632,118.77,34.23,NULL,NULL,NULL,NULL),(13371,632,168.73,34.52,NULL,NULL,NULL,NULL),(13372,632,199.71,34.78,NULL,NULL,NULL,NULL),(13373,632,278.98,35.49,NULL,NULL,NULL,NULL),(13374,632,346.73,35.91,NULL,NULL,NULL,NULL),(13375,632,496.89,37.22,NULL,NULL,NULL,NULL),(13376,632,586.73,37.89,NULL,NULL,NULL,NULL),(13377,633,0,21.76,NULL,NULL,NULL,NULL),(13378,633,0,22.01,NULL,NULL,NULL,NULL),(13379,633,0,22.13,NULL,NULL,NULL,NULL),(13380,633,0,22.38,NULL,NULL,NULL,NULL),(13381,633,0,22.5,NULL,NULL,NULL,NULL),(13382,633,0.01,22.63,NULL,NULL,NULL,NULL),(13383,633,0.01,22.75,NULL,NULL,NULL,NULL),(13384,633,0.01,22.87,NULL,NULL,NULL,NULL),(13385,633,0.02,23,NULL,NULL,NULL,NULL),(13386,633,0.03,23,NULL,NULL,NULL,NULL),(13387,633,0.04,23,NULL,NULL,NULL,NULL),(13388,633,0.06,23.12,NULL,NULL,NULL,NULL),(13389,633,0.08,23.24,NULL,NULL,NULL,NULL),(13390,633,0.12,23.36,NULL,NULL,NULL,NULL),(13391,633,0.16,23.48,NULL,NULL,NULL,NULL),(13392,633,0.2,23.6,NULL,NULL,NULL,NULL),(13393,633,0.29,23.84,NULL,NULL,NULL,NULL),(13394,633,0.41,24.08,NULL,NULL,NULL,NULL),(13395,633,0.66,24.43,NULL,NULL,NULL,NULL),(13396,633,0.83,24.66,NULL,NULL,NULL,NULL),(13397,633,0.95,24.9,NULL,NULL,NULL,NULL),(13398,633,1.82,25.71,NULL,NULL,NULL,NULL),(13399,633,3.78,26.7,NULL,NULL,NULL,NULL),(13400,633,6.68,27.79,NULL,NULL,NULL,NULL),(13401,633,8.82,28.32,NULL,NULL,NULL,NULL),(13402,633,13.74,29.26,NULL,NULL,NULL,NULL),(13403,633,14.74,29.48,NULL,NULL,NULL,NULL),(13404,633,17.77,29.9,NULL,NULL,NULL,NULL),(13405,633,21.71,30.18,NULL,NULL,NULL,NULL),(13406,633,25.01,30.49,NULL,NULL,NULL,NULL),(13407,633,34.76,30.95,NULL,NULL,NULL,NULL),(13408,633,49.05,31.51,NULL,NULL,NULL,NULL),(13409,633,58.99,31.79,NULL,NULL,NULL,NULL),(13410,633,84.7,32.34,NULL,NULL,NULL,NULL),(13411,633,114.78,32.93,NULL,NULL,NULL,NULL),(13412,633,164.74,33.36,NULL,NULL,NULL,NULL),(13413,633,195.72,33.76,NULL,NULL,NULL,NULL),(13414,633,274.99,34.09,NULL,NULL,NULL,NULL),(13415,633,342.7,34.6,NULL,NULL,NULL,NULL),(13416,633,490.82,35.42,NULL,NULL,NULL,NULL),(13417,633,886.74,36.14,NULL,NULL,NULL,NULL),(13418,633,1250,36.98,NULL,NULL,NULL,NULL),(13419,633,2083.33,38.51,NULL,NULL,NULL,NULL),(13420,633,2500,38.82,NULL,NULL,NULL,NULL),(13421,633,2916.67,39.38,NULL,NULL,NULL,NULL),(13422,633,4166.67,40,NULL,NULL,NULL,NULL),(13423,634,0.02,21.02,NULL,NULL,NULL,NULL),(13424,634,0.02,21.22,NULL,NULL,NULL,NULL),(13425,634,0.02,21.31,NULL,NULL,NULL,NULL),(13426,634,0.02,21.41,NULL,NULL,NULL,NULL),(13427,634,0.04,21.7,NULL,NULL,NULL,NULL),(13428,634,0.05,21.9,NULL,NULL,NULL,NULL),(13429,634,0.08,22.29,NULL,NULL,NULL,NULL),(13430,634,0.1,22.58,NULL,NULL,NULL,NULL),(13431,634,0.12,22.77,NULL,NULL,NULL,NULL),(13432,634,0.76,24.03,NULL,NULL,NULL,NULL),(13433,634,0.97,24.32,NULL,NULL,NULL,NULL),(13434,634,1.76,24.8,NULL,NULL,NULL,NULL),(13435,634,2.08,25.18,NULL,NULL,NULL,NULL),(13436,634,2.77,25.37,NULL,NULL,NULL,NULL),(13437,634,3.04,25.56,NULL,NULL,NULL,NULL),(13438,634,3.77,25.64,NULL,NULL,NULL,NULL),(13439,634,4.06,25.83,NULL,NULL,NULL,NULL),(13440,634,6.76,26.28,NULL,NULL,NULL,NULL),(13441,634,9.78,26.83,NULL,NULL,NULL,NULL),(13442,634,10.76,27.01,NULL,NULL,NULL,NULL),(13443,634,17.99,27.61,NULL,NULL,NULL,NULL),(13444,634,23.99,27.85,NULL,NULL,NULL,NULL),(13445,634,28.76,28.2,NULL,NULL,NULL,NULL),(13446,634,36.78,29.21,NULL,NULL,NULL,NULL),(13447,634,58.02,30.06,NULL,NULL,NULL,NULL),(13448,634,70.85,30.48,NULL,NULL,NULL,NULL),(13449,634,83.78,30.52,NULL,NULL,NULL,NULL),(13450,634,111.96,31.3,NULL,NULL,NULL,NULL),(13451,634,122.78,31.27,NULL,NULL,NULL,NULL),(13452,634,135.8,31.53,NULL,NULL,NULL,NULL),(13453,634,141.84,32,NULL,NULL,NULL,NULL),(13454,634,153.79,31.78,NULL,NULL,NULL,NULL),(13455,634,174.98,32.22,NULL,NULL,NULL,NULL),(13456,634,184.83,32,NULL,NULL,NULL,NULL),(13457,634,198.03,32.08,NULL,NULL,NULL,NULL),(13458,634,233,32.51,NULL,NULL,NULL,NULL),(13459,634,266.78,32.94,NULL,NULL,NULL,NULL),(13460,634,335.78,33.74,NULL,NULL,NULL,NULL),(13461,634,426.98,34.63,NULL,NULL,NULL,NULL),(13462,634,520.98,34.75,NULL,NULL,NULL,NULL),(13463,634,531.81,34.74,NULL,NULL,NULL,NULL),(13464,634,577.8,35.2,NULL,NULL,NULL,NULL),(13465,634,754.81,37.45,NULL,NULL,NULL,NULL),(13466,634,906.97,38.07,NULL,NULL,NULL,NULL),(13467,634,1011.98,37.94,NULL,NULL,NULL,NULL),(13468,634,1066.76,38.51,NULL,NULL,NULL,NULL),(13469,634,1263.79,38.75,NULL,NULL,NULL,NULL),(13470,635,0,30.42,NULL,NULL,NULL,NULL),(13471,635,0,30.98,NULL,NULL,NULL,NULL),(13472,635,0,31.54,NULL,NULL,NULL,NULL),(13473,635,0,31.82,NULL,NULL,NULL,NULL),(13474,635,0,32.1,NULL,NULL,NULL,NULL),(13475,635,0,32.37,NULL,NULL,NULL,NULL),(13476,635,0.01,33.2,NULL,NULL,NULL,NULL),(13477,635,0.01,34.04,NULL,NULL,NULL,NULL),(13478,635,0.03,35.36,NULL,NULL,NULL,NULL),(13479,635,0.05,36.43,NULL,NULL,NULL,NULL),(13480,635,0.69,44.01,NULL,NULL,NULL,NULL),(13481,635,3.04,47.31,NULL,NULL,NULL,NULL),(13482,635,6.91,49.92,NULL,NULL,NULL,NULL),(13483,635,8.7,50.43,NULL,NULL,NULL,NULL),(13484,635,12.72,51.11,NULL,NULL,NULL,NULL),(13485,635,13.91,51.16,NULL,NULL,NULL,NULL),(13486,635,16.75,50.42,NULL,NULL,NULL,NULL),(13487,635,20.9,50.73,NULL,NULL,NULL,NULL),(13488,635,23.7,51.29,NULL,NULL,NULL,NULL),(13489,635,26.72,51.31,NULL,NULL,NULL,NULL),(13490,636,0,20.95,NULL,NULL,NULL,NULL),(13491,636,0.01,22.53,NULL,NULL,NULL,NULL),(13492,636,0.02,24.11,NULL,NULL,NULL,NULL),(13493,636,0.03,24.68,NULL,NULL,NULL,NULL),(13494,636,0.04,24.96,NULL,NULL,NULL,NULL),(13495,636,0.08,26.24,NULL,NULL,NULL,NULL),(13496,636,0.12,26.8,NULL,NULL,NULL,NULL),(13497,636,0.24,28.19,NULL,NULL,NULL,NULL),(13498,636,0.75,31.01,NULL,NULL,NULL,NULL),(13499,636,1.01,31.78,NULL,NULL,NULL,NULL),(13500,636,2.06,33.34,NULL,NULL,NULL,NULL),(13501,636,3.76,35.09,NULL,NULL,NULL,NULL),(13502,636,4.79,35.89,NULL,NULL,NULL,NULL),(13503,636,6.08,36.69,NULL,NULL,NULL,NULL),(13504,636,7.04,37.56,NULL,NULL,NULL,NULL),(13505,636,7.79,37.6,NULL,NULL,NULL,NULL),(13506,636,11.04,38.54,NULL,NULL,NULL,NULL),(13507,636,12.08,39.17,NULL,NULL,NULL,NULL),(13508,636,13.81,39.46,NULL,NULL,NULL,NULL),(13509,636,18.08,39.9,NULL,NULL,NULL,NULL),(13510,636,20.1,40.52,NULL,NULL,NULL,NULL),(13511,636,21.87,40.86,NULL,NULL,NULL,NULL),(13512,636,27.04,41.38,NULL,NULL,NULL,NULL),(13513,636,33.12,41.76,NULL,NULL,NULL,NULL),(13514,636,45.87,43.06,NULL,NULL,NULL,NULL),(13515,636,82.12,44.36,NULL,NULL,NULL,NULL),(13516,636,126.99,45.26,NULL,NULL,NULL,NULL),(13517,636,151.99,45.61,NULL,NULL,NULL,NULL),(13518,636,186.87,45.52,NULL,NULL,NULL,NULL),(13519,636,209.99,45.61,NULL,NULL,NULL,NULL),(13520,636,250.01,45.69,NULL,NULL,NULL,NULL),(13521,636,281.83,46.23,NULL,NULL,NULL,NULL),(13522,636,315.99,45.9,NULL,NULL,NULL,NULL),(13523,636,334.91,45.89,NULL,NULL,NULL,NULL),(13524,636,356.91,46.01,NULL,NULL,NULL,NULL),(13525,636,431.83,46.68,NULL,NULL,NULL,NULL),(13526,636,465.99,46.95,NULL,NULL,NULL,NULL),(13527,637,0,20.4,NULL,NULL,NULL,NULL),(13528,637,0,20.61,NULL,NULL,NULL,NULL),(13529,637,0,20.72,NULL,NULL,NULL,NULL),(13530,637,0,20.83,NULL,NULL,NULL,NULL),(13531,637,0,20.94,NULL,NULL,NULL,NULL),(13532,637,0.01,21.04,NULL,NULL,NULL,NULL),(13533,637,0.01,21.15,NULL,NULL,NULL,NULL),(13534,637,0.02,21.25,NULL,NULL,NULL,NULL),(13535,637,0.04,21.47,NULL,NULL,NULL,NULL),(13536,637,0.09,21.78,NULL,NULL,NULL,NULL),(13537,637,0.13,21.99,NULL,NULL,NULL,NULL),(13538,637,0.21,22.41,NULL,NULL,NULL,NULL),(13539,637,0.29,22.61,NULL,NULL,NULL,NULL),(13540,637,0.42,22.91,NULL,NULL,NULL,NULL),(13541,637,0.63,23.31,NULL,NULL,NULL,NULL),(13542,637,1,23.91,NULL,NULL,NULL,NULL),(13543,637,1.5,24.38,NULL,NULL,NULL,NULL),(13544,637,1.7,24.57,NULL,NULL,NULL,NULL),(13545,637,6.77,27.11,NULL,NULL,NULL,NULL),(13546,637,8.76,27.84,NULL,NULL,NULL,NULL),(13547,637,10.8,28.15,NULL,NULL,NULL,NULL),(13548,637,14.74,28.72,NULL,NULL,NULL,NULL),(13549,637,18.02,29.14,NULL,NULL,NULL,NULL),(13550,637,27.78,29.95,NULL,NULL,NULL,NULL),(13551,637,42.08,30.46,NULL,NULL,NULL,NULL),(13552,637,52.01,30.77,NULL,NULL,NULL,NULL),(13553,637,77.72,31.22,NULL,NULL,NULL,NULL),(13554,637,108.81,31.61,NULL,NULL,NULL,NULL),(13555,637,157.76,32.01,NULL,NULL,NULL,NULL),(13556,637,188.74,32.28,NULL,NULL,NULL,NULL),(13557,637,268.01,32.4,NULL,NULL,NULL,NULL),(13558,637,335.76,32.56,NULL,NULL,NULL,NULL),(13559,637,485.93,33.13,NULL,NULL,NULL,NULL),(13560,637,575.76,33.75,NULL,NULL,NULL,NULL),(13561,637,833.33,34.45,NULL,NULL,NULL,NULL),(13562,637,1250,35.37,NULL,NULL,NULL,NULL),(13563,637,2083.33,35.65,NULL,NULL,NULL,NULL),(13564,637,2916.67,36.06,NULL,NULL,NULL,NULL),(13565,637,4166.67,36.91,NULL,NULL,NULL,NULL),(13566,638,0,19,NULL,NULL,NULL,NULL),(13567,638,0,19.08,NULL,NULL,NULL,NULL),(13568,638,0,19.17,NULL,NULL,NULL,NULL),(13569,638,0.01,19.75,NULL,NULL,NULL,NULL),(13570,638,0.02,20.08,NULL,NULL,NULL,NULL),(13571,638,0.04,20.25,NULL,NULL,NULL,NULL),(13572,638,0.08,20.33,NULL,NULL,NULL,NULL),(13573,638,0.13,20.5,NULL,NULL,NULL,NULL),(13574,638,0.77,21.32,NULL,NULL,NULL,NULL),(13575,638,1.06,21.48,NULL,NULL,NULL,NULL),(13576,638,1.84,21.63,NULL,NULL,NULL,NULL),(13577,638,2.78,22.02,NULL,NULL,NULL,NULL),(13578,638,3.76,22.26,NULL,NULL,NULL,NULL),(13579,638,6.83,22.95,NULL,NULL,NULL,NULL),(13580,638,8.01,22.93,NULL,NULL,NULL,NULL),(13581,638,10.99,23.3,NULL,NULL,NULL,NULL),(13582,638,16.99,23.73,NULL,NULL,NULL,NULL),(13583,638,21.76,24.01,NULL,NULL,NULL,NULL),(13584,638,29.79,24.27,NULL,NULL,NULL,NULL),(13585,638,50.94,25.13,NULL,NULL,NULL,NULL),(13586,638,63.86,25.58,NULL,NULL,NULL,NULL),(13587,638,76.78,25.61,NULL,NULL,NULL,NULL),(13588,638,73.96,26.04,NULL,NULL,NULL,NULL),(13589,638,115.78,26.18,NULL,NULL,NULL,NULL),(13590,638,128.8,26.65,NULL,NULL,NULL,NULL),(13591,638,134.8,26.73,NULL,NULL,NULL,NULL),(13592,638,146.79,26.96,NULL,NULL,NULL,NULL),(13593,638,167.98,27.1,NULL,NULL,NULL,NULL),(13594,638,177.84,27.25,NULL,NULL,NULL,NULL),(13595,638,191.01,27.32,NULL,NULL,NULL,NULL),(13596,638,259.78,27.6,NULL,NULL,NULL,NULL),(13597,638,328.78,28.23,NULL,NULL,NULL,NULL),(13598,638,419.98,28.61,NULL,NULL,NULL,NULL),(13599,638,513.98,28.83,NULL,NULL,NULL,NULL),(13600,638,524.82,28.91,NULL,NULL,NULL,NULL),(13601,638,570.8,29.82,NULL,NULL,NULL,NULL),(13602,638,747.82,30.13,NULL,NULL,NULL,NULL),(13603,638,899.98,30.86,NULL,NULL,NULL,NULL),(13604,638,1059.76,30.68,NULL,NULL,NULL,NULL),(13605,638,1256.79,31.17,NULL,NULL,NULL,NULL),(13606,639,0,27.6,NULL,NULL,NULL,NULL),(13607,639,0,27.82,NULL,NULL,NULL,NULL),(13608,639,0,28.04,NULL,NULL,NULL,NULL),(13609,639,0,28.48,NULL,NULL,NULL,NULL),(13610,639,0,29.37,NULL,NULL,NULL,NULL),(13611,639,0.01,29.59,NULL,NULL,NULL,NULL),(13612,639,0.01,30.44,NULL,NULL,NULL,NULL),(13613,639,0.02,31.73,NULL,NULL,NULL,NULL),(13614,639,0.09,33.39,NULL,NULL,NULL,NULL),(13615,639,0.7,38.37,NULL,NULL,NULL,NULL),(13616,639,3.71,43.03,NULL,NULL,NULL,NULL),(13617,639,5.05,43.92,NULL,NULL,NULL,NULL),(13618,639,5.7,44.54,NULL,NULL,NULL,NULL),(13619,639,8.05,44.84,NULL,NULL,NULL,NULL),(13620,639,11.92,46.13,NULL,NULL,NULL,NULL),(13621,639,13.72,46.69,NULL,NULL,NULL,NULL),(13622,639,17.74,47.18,NULL,NULL,NULL,NULL),(13623,639,21.93,45.52,NULL,NULL,NULL,NULL),(13624,639,25.91,46.7,NULL,NULL,NULL,NULL),(13625,639,26.72,46.62,NULL,NULL,NULL,NULL),(13626,640,0,21.97,NULL,NULL,NULL,NULL),(13627,640,0,22.13,NULL,NULL,NULL,NULL),(13628,640,0,22.29,NULL,NULL,NULL,NULL),(13629,640,0,22.44,NULL,NULL,NULL,NULL),(13630,640,0.01,22.76,NULL,NULL,NULL,NULL),(13631,640,0.01,22.92,NULL,NULL,NULL,NULL),(13632,640,0.02,22.91,NULL,NULL,NULL,NULL),(13633,640,0.04,22.9,NULL,NULL,NULL,NULL),(13634,640,0.06,23.05,NULL,NULL,NULL,NULL),(13635,640,0.09,23.19,NULL,NULL,NULL,NULL),(13636,640,0.13,23.33,NULL,NULL,NULL,NULL),(13637,640,0.17,23.47,NULL,NULL,NULL,NULL),(13638,640,0.25,23.74,NULL,NULL,NULL,NULL),(13639,640,0.38,24.32,NULL,NULL,NULL,NULL),(13640,640,0.5,24.74,NULL,NULL,NULL,NULL),(13641,640,0.75,25.42,NULL,NULL,NULL,NULL),(13642,640,1,25.79,NULL,NULL,NULL,NULL),(13643,640,1.64,26.5,NULL,NULL,NULL,NULL),(13644,640,1.87,26.89,NULL,NULL,NULL,NULL),(13645,640,3.16,28.08,NULL,NULL,NULL,NULL),(13646,640,3.91,28.68,NULL,NULL,NULL,NULL),(13647,640,5.95,30.13,NULL,NULL,NULL,NULL),(13648,640,8.86,31.06,NULL,NULL,NULL,NULL),(13649,640,10.99,31.56,NULL,NULL,NULL,NULL),(13650,640,15.91,32.61,NULL,NULL,NULL,NULL),(13651,640,17.91,32.91,NULL,NULL,NULL,NULL),(13652,640,19.93,33.39,NULL,NULL,NULL,NULL),(13653,640,23.88,33.75,NULL,NULL,NULL,NULL),(13654,640,27.18,34.18,NULL,NULL,NULL,NULL),(13655,640,36.93,34.83,NULL,NULL,NULL,NULL),(13656,640,51.22,35.29,NULL,NULL,NULL,NULL),(13657,640,61.16,35.35,NULL,NULL,NULL,NULL),(13658,640,86.87,35.64,NULL,NULL,NULL,NULL),(13659,640,116.95,36.04,NULL,NULL,NULL,NULL),(13660,640,166.91,36.08,NULL,NULL,NULL,NULL),(13661,640,197.89,36.52,NULL,NULL,NULL,NULL),(13662,640,277.16,36.79,NULL,NULL,NULL,NULL),(13663,640,344.87,37.52,NULL,NULL,NULL,NULL),(13664,640,419.15,38.13,NULL,NULL,NULL,NULL),(13665,641,0,22.71,NULL,NULL,NULL,NULL),(13666,641,0,22.94,NULL,NULL,NULL,NULL),(13667,641,0,23.06,NULL,NULL,NULL,NULL),(13668,641,0,23.06,NULL,NULL,NULL,NULL),(13669,641,0,23.17,NULL,NULL,NULL,NULL),(13670,641,0,23.29,NULL,NULL,NULL,NULL),(13671,641,0.01,23.4,NULL,NULL,NULL,NULL),(13672,641,0.01,23.52,NULL,NULL,NULL,NULL),(13673,641,0.02,23.63,NULL,NULL,NULL,NULL),(13674,641,0.03,23.75,NULL,NULL,NULL,NULL),(13675,641,0.04,23.86,NULL,NULL,NULL,NULL),(13676,641,0.09,24.2,NULL,NULL,NULL,NULL),(13677,641,0.13,24.54,NULL,NULL,NULL,NULL),(13678,641,0.17,24.65,NULL,NULL,NULL,NULL),(13679,641,0.21,24.88,NULL,NULL,NULL,NULL),(13680,641,0.29,25.21,NULL,NULL,NULL,NULL),(13681,641,0.42,25.54,NULL,NULL,NULL,NULL),(13682,641,0.67,26.07,NULL,NULL,NULL,NULL),(13683,641,1,26.6,NULL,NULL,NULL,NULL),(13684,641,1.5,27.22,NULL,NULL,NULL,NULL),(13685,641,1.88,27.62,NULL,NULL,NULL,NULL),(13686,641,3,28.63,NULL,NULL,NULL,NULL),(13687,641,4,29.09,NULL,NULL,NULL,NULL),(13688,641,4.85,29.46,NULL,NULL,NULL,NULL),(13689,641,7,30.29,NULL,NULL,NULL,NULL),(13690,641,11.92,31.75,NULL,NULL,NULL,NULL),(13691,641,13.91,32.09,NULL,NULL,NULL,NULL),(13692,641,15.95,32.55,NULL,NULL,NULL,NULL),(13693,641,19.89,33.05,NULL,NULL,NULL,NULL),(13694,641,23.18,33.37,NULL,NULL,NULL,NULL),(13695,641,32.93,33.95,NULL,NULL,NULL,NULL),(13696,641,47.23,34.29,NULL,NULL,NULL,NULL),(13697,641,57.16,34.57,NULL,NULL,NULL,NULL),(13698,641,82.87,34.9,NULL,NULL,NULL,NULL),(13699,641,112.96,35.54,NULL,NULL,NULL,NULL),(13700,641,162.91,35.91,NULL,NULL,NULL,NULL),(13701,641,193.89,36.23,NULL,NULL,NULL,NULL),(13702,641,273.16,36.67,NULL,NULL,NULL,NULL),(13703,641,340.91,37.2,NULL,NULL,NULL,NULL),(13704,641,491.08,37.78,NULL,NULL,NULL,NULL),(13705,641,580.91,38.26,NULL,NULL,NULL,NULL),(13706,641,783.5,38.73,NULL,NULL,NULL,NULL),(13707,641,986.5,39.89,NULL,NULL,NULL,NULL),(13708,641,1154.5,39.93,NULL,NULL,NULL,NULL),(13709,641,1308.5,40.46,NULL,NULL,NULL,NULL),(13710,641,1705.5,40.47,NULL,NULL,NULL,NULL),(13711,642,0,19.23,NULL,NULL,NULL,NULL),(13712,642,0,19.36,NULL,NULL,NULL,NULL),(13713,642,0,19.36,NULL,NULL,NULL,NULL),(13714,642,0,19.43,NULL,NULL,NULL,NULL),(13715,642,0.01,19.63,NULL,NULL,NULL,NULL),(13716,642,0.02,19.83,NULL,NULL,NULL,NULL),(13717,642,0.03,19.96,NULL,NULL,NULL,NULL),(13718,642,0.05,20.1,NULL,NULL,NULL,NULL),(13719,642,0.09,20.16,NULL,NULL,NULL,NULL),(13720,642,0.13,20.09,NULL,NULL,NULL,NULL),(13721,642,0.78,20.81,NULL,NULL,NULL,NULL),(13722,642,1.05,21,NULL,NULL,NULL,NULL),(13723,642,1.78,21.39,NULL,NULL,NULL,NULL),(13724,642,2.07,21.58,NULL,NULL,NULL,NULL),(13725,642,4.77,21.92,NULL,NULL,NULL,NULL),(13726,642,7.79,22.19,NULL,NULL,NULL,NULL),(13727,642,8.77,22.24,NULL,NULL,NULL,NULL),(13728,642,16,23.12,NULL,NULL,NULL,NULL),(13729,642,22,23.23,NULL,NULL,NULL,NULL),(13730,642,26.77,23.37,NULL,NULL,NULL,NULL),(13731,642,34.79,24.35,NULL,NULL,NULL,NULL),(13732,642,56.03,25.03,NULL,NULL,NULL,NULL),(13733,642,68.86,25.48,NULL,NULL,NULL,NULL),(13734,642,81.79,25.81,NULL,NULL,NULL,NULL),(13735,642,109.97,26.22,NULL,NULL,NULL,NULL),(13736,642,120.79,26.25,NULL,NULL,NULL,NULL),(13737,642,133.81,26.74,NULL,NULL,NULL,NULL),(13738,642,139.85,26.78,NULL,NULL,NULL,NULL),(13739,642,151.8,26.75,NULL,NULL,NULL,NULL),(13740,642,172.99,27.29,NULL,NULL,NULL,NULL),(13741,642,182.84,27.47,NULL,NULL,NULL,NULL),(13742,642,196.04,27.38,NULL,NULL,NULL,NULL),(13743,642,264.79,27.86,NULL,NULL,NULL,NULL),(13744,642,333.79,28.3,NULL,NULL,NULL,NULL),(13745,642,424.99,28.68,NULL,NULL,NULL,NULL),(13746,642,518.99,28.95,NULL,NULL,NULL,NULL),(13747,642,529.82,29.01,NULL,NULL,NULL,NULL),(13748,642,575.81,29.38,NULL,NULL,NULL,NULL),(13749,642,752.82,30.63,NULL,NULL,NULL,NULL),(13750,642,833.82,30.41,NULL,NULL,NULL,NULL),(13751,642,904.97,30.58,NULL,NULL,NULL,NULL),(13752,642,1009.99,30.62,NULL,NULL,NULL,NULL),(13753,642,1064.77,31.07,NULL,NULL,NULL,NULL),(13754,642,1098.03,31,NULL,NULL,NULL,NULL),(13755,642,1261.8,31.36,NULL,NULL,NULL,NULL),(13756,643,0,19.13,NULL,NULL,NULL,NULL),(13757,643,0,19.6,NULL,NULL,NULL,NULL),(13758,643,0,19.66,NULL,NULL,NULL,NULL),(13759,643,0,19.8,NULL,NULL,NULL,NULL),(13760,643,0.01,19.86,NULL,NULL,NULL,NULL),(13761,643,0.02,19.93,NULL,NULL,NULL,NULL),(13762,643,0.06,19.93,NULL,NULL,NULL,NULL),(13763,643,0.14,20.13,NULL,NULL,NULL,NULL),(13764,643,0.26,20.2,NULL,NULL,NULL,NULL),(13765,643,0.93,20.47,NULL,NULL,NULL,NULL),(13766,643,1.25,20.87,NULL,NULL,NULL,NULL),(13767,643,3.25,21.33,NULL,NULL,NULL,NULL),(13768,643,6.96,22.07,NULL,NULL,NULL,NULL),(13769,643,10.17,22.4,NULL,NULL,NULL,NULL),(13770,643,19.92,23.07,NULL,NULL,NULL,NULL),(13771,643,33.92,23.61,NULL,NULL,NULL,NULL),(13772,643,52,24.07,NULL,NULL,NULL,NULL),(13773,643,83.13,24.74,NULL,NULL,NULL,NULL),(13774,643,163.94,25.48,NULL,NULL,NULL,NULL),(13775,643,294.96,25.88,NULL,NULL,NULL,NULL),(13776,643,427.96,25.74,NULL,NULL,NULL,NULL),(13777,644,0.12,19.58,NULL,NULL,NULL,NULL),(13778,644,0.12,20.11,NULL,NULL,NULL,NULL),(13779,644,0.12,20.31,NULL,NULL,NULL,NULL),(13780,644,0.12,20.38,NULL,NULL,NULL,NULL),(13781,644,0.13,20.38,NULL,NULL,NULL,NULL),(13782,644,0.21,20.58,NULL,NULL,NULL,NULL),(13783,644,0.32,21.05,NULL,NULL,NULL,NULL),(13784,644,1,22.39,NULL,NULL,NULL,NULL),(13785,644,1.31,22.59,NULL,NULL,NULL,NULL),(13786,644,3.32,23.65,NULL,NULL,NULL,NULL),(13787,644,7.03,24.66,NULL,NULL,NULL,NULL),(13788,644,10.24,25.12,NULL,NULL,NULL,NULL),(13789,644,19.99,26.06,NULL,NULL,NULL,NULL),(13790,644,33.99,26.93,NULL,NULL,NULL,NULL),(13791,644,52.07,27.53,NULL,NULL,NULL,NULL),(13792,644,83.2,28.26,NULL,NULL,NULL,NULL),(13793,644,164.01,29.2,NULL,NULL,NULL,NULL),(13794,644,295.03,29.93,NULL,NULL,NULL,NULL),(13795,644,428.03,30.4,NULL,NULL,NULL,NULL),(13796,645,0,18.11,NULL,NULL,NULL,NULL),(13797,645,0.09,19.97,NULL,NULL,NULL,NULL),(13798,645,0.11,20.2,NULL,NULL,NULL,NULL),(13799,645,0.14,20.03,NULL,NULL,NULL,NULL),(13800,645,0.2,20.16,NULL,NULL,NULL,NULL),(13801,645,0.39,20.43,NULL,NULL,NULL,NULL),(13802,645,0.75,20.68,NULL,NULL,NULL,NULL),(13803,645,1.13,21.51,NULL,NULL,NULL,NULL),(13804,645,1.36,21.19,NULL,NULL,NULL,NULL),(13805,645,2.47,21.33,NULL,NULL,NULL,NULL),(13806,645,2.9,21.44,NULL,NULL,NULL,NULL),(13807,645,3.99,21.7,NULL,NULL,NULL,NULL),(13808,645,4.59,21.82,NULL,NULL,NULL,NULL),(13809,645,4.93,21.74,NULL,NULL,NULL,NULL),(13810,645,4.94,21.89,NULL,NULL,NULL,NULL),(13811,645,5.84,22.09,NULL,NULL,NULL,NULL),(13812,645,6.66,22.22,NULL,NULL,NULL,NULL),(13813,645,7.74,22.35,NULL,NULL,NULL,NULL),(13814,645,8.14,21.54,NULL,NULL,NULL,NULL),(13815,645,10.5,22.61,NULL,NULL,NULL,NULL),(13816,645,12.25,22.74,NULL,NULL,NULL,NULL),(13817,645,14.06,22.87,NULL,NULL,NULL,NULL),(13818,645,18.09,23.12,NULL,NULL,NULL,NULL),(13819,645,21.06,23.25,NULL,NULL,NULL,NULL),(13820,645,22.86,22.88,NULL,NULL,NULL,NULL),(13821,645,24.26,22.49,NULL,NULL,NULL,NULL),(13822,645,25.15,23.04,NULL,NULL,NULL,NULL),(13823,645,26.91,23.7,NULL,NULL,NULL,NULL),(13824,645,26.91,23.45,NULL,NULL,NULL,NULL),(13825,645,29.18,23.57,NULL,NULL,NULL,NULL),(13826,645,32.59,23.7,NULL,NULL,NULL,NULL),(13827,645,47.14,24.13,NULL,NULL,NULL,NULL),(13828,645,52.77,24.25,NULL,NULL,NULL,NULL),(13829,645,53.62,24.13,NULL,NULL,NULL,NULL),(13830,645,54.11,24.25,NULL,NULL,NULL,NULL),(13831,645,54.18,24.38,NULL,NULL,NULL,NULL),(13832,645,55.93,24.27,NULL,NULL,NULL,NULL),(13833,645,61.74,24.46,NULL,NULL,NULL,NULL),(13834,645,61.74,24.34,NULL,NULL,NULL,NULL),(13835,645,65.91,24.48,NULL,NULL,NULL,NULL),(13836,645,73.48,24.61,NULL,NULL,NULL,NULL),(13837,645,84.41,24.73,NULL,NULL,NULL,NULL),(13838,645,110.11,24.97,NULL,NULL,NULL,NULL),(13839,645,123.01,24.85,NULL,NULL,NULL,NULL),(13840,645,123.03,24.72,NULL,NULL,NULL,NULL),(13841,645,123.1,24.85,NULL,NULL,NULL,NULL),(13842,645,123.15,24.97,NULL,NULL,NULL,NULL),(13843,645,123.24,25.1,NULL,NULL,NULL,NULL),(13844,645,160.2,25.45,NULL,NULL,NULL,NULL),(13845,645,168.42,25.62,NULL,NULL,NULL,NULL),(13846,645,168.43,25.5,NULL,NULL,NULL,NULL),(13847,645,176.87,25.62,NULL,NULL,NULL,NULL),(13848,645,259.73,25.66,NULL,NULL,NULL,NULL),(13849,645,260.32,25.54,NULL,NULL,NULL,NULL),(13850,645,260.4,25.67,NULL,NULL,NULL,NULL),(13851,645,260.69,25.79,NULL,NULL,NULL,NULL),(13852,645,261.29,25.67,NULL,NULL,NULL,NULL),(13853,645,265.35,25.79,NULL,NULL,NULL,NULL),(13854,646,0,31.25,NULL,NULL,NULL,NULL),(13855,646,0.01,33.26,NULL,NULL,NULL,NULL),(13856,646,0.02,34.54,NULL,NULL,NULL,NULL),(13857,646,0.02,35.97,NULL,NULL,NULL,NULL),(13858,646,0.19,37.56,NULL,NULL,NULL,NULL),(13859,646,0.52,39.15,NULL,NULL,NULL,NULL),(13860,646,0.68,40.42,NULL,NULL,NULL,NULL),(13861,646,1.65,41.85,NULL,NULL,NULL,NULL),(13862,646,1.82,43.55,NULL,NULL,NULL,NULL),(13863,646,2.15,45.05,NULL,NULL,NULL,NULL),(13864,646,2.63,46.45,NULL,NULL,NULL,NULL),(13865,646,2.96,48.05,NULL,NULL,NULL,NULL),(13866,646,3.46,49.65,NULL,NULL,NULL,NULL),(13867,646,3.76,51.05,NULL,NULL,NULL,NULL),(13868,646,4.26,52.35,NULL,NULL,NULL,NULL),(13869,646,4.76,53.95,NULL,NULL,NULL,NULL),(13870,646,5.56,55.85,NULL,NULL,NULL,NULL),(13871,646,7.46,57.75,NULL,NULL,NULL,NULL),(13872,646,9.46,60.05,NULL,NULL,NULL,NULL),(13873,646,11.36,61.65,NULL,NULL,NULL,NULL),(13874,646,12.16,62.95,NULL,NULL,NULL,NULL),(13875,646,13.26,64.15,NULL,NULL,NULL,NULL),(13876,646,14.56,65.15,NULL,NULL,NULL,NULL),(13877,646,16.06,66.85,NULL,NULL,NULL,NULL),(13878,646,16.66,67.65,NULL,NULL,NULL,NULL),(13879,646,17.96,68.95,NULL,NULL,NULL,NULL),(13880,646,19.56,70.15,NULL,NULL,NULL,NULL),(13881,646,21.66,72.05,NULL,NULL,NULL,NULL),(13882,646,23.56,73.95,NULL,NULL,NULL,NULL),(13883,646,24.66,74.95,NULL,NULL,NULL,NULL),(13884,646,25.86,75.85,NULL,NULL,NULL,NULL),(13885,646,28.06,77.45,NULL,NULL,NULL,NULL),(13886,646,29.86,78.65,NULL,NULL,NULL,NULL),(13887,646,31.16,79.05,NULL,NULL,NULL,NULL),(13888,646,32.06,80.15,NULL,NULL,NULL,NULL),(13889,646,34.76,81.55,NULL,NULL,NULL,NULL),(13890,646,37.86,82.95,NULL,NULL,NULL,NULL),(13891,646,39.96,83.85,NULL,NULL,NULL,NULL),(13892,646,43.46,86.55,NULL,NULL,NULL,NULL),(13893,646,45.36,86.85,NULL,NULL,NULL,NULL),(13894,646,46.36,87.45,NULL,NULL,NULL,NULL),(13895,646,48.26,88.75,NULL,NULL,NULL,NULL),(13896,646,49.76,89.05,NULL,NULL,NULL,NULL),(13897,646,52.26,89.85,NULL,NULL,NULL,NULL),(13898,646,54.56,90.75,NULL,NULL,NULL,NULL),(13899,646,58.26,90.75,NULL,NULL,NULL,NULL),(13900,647,0,27.32,NULL,NULL,NULL,NULL),(13901,647,0.16,29.65,NULL,NULL,NULL,NULL),(13902,647,0.17,30.77,NULL,NULL,NULL,NULL),(13903,647,0.33,31.72,NULL,NULL,NULL,NULL),(13904,647,0.66,33.15,NULL,NULL,NULL,NULL),(13905,647,0.66,33.94,NULL,NULL,NULL,NULL),(13906,647,0.83,34.58,NULL,NULL,NULL,NULL),(13907,647,0.99,35.69,NULL,NULL,NULL,NULL),(13908,647,1.16,36.8,NULL,NULL,NULL,NULL),(13909,647,1.32,38.12,NULL,NULL,NULL,NULL),(13910,647,1.65,39.02,NULL,NULL,NULL,NULL),(13911,647,2.13,40.42,NULL,NULL,NULL,NULL),(13912,647,2.3,41.42,NULL,NULL,NULL,NULL),(13913,647,2.95,43.02,NULL,NULL,NULL,NULL),(13914,647,3.11,43.92,NULL,NULL,NULL,NULL),(13915,647,3.61,45.42,NULL,NULL,NULL,NULL),(13916,647,4.21,48.22,NULL,NULL,NULL,NULL),(13917,647,4.21,49.22,NULL,NULL,NULL,NULL),(13918,647,4.61,50.62,NULL,NULL,NULL,NULL),(13919,647,4.71,51.72,NULL,NULL,NULL,NULL),(13920,647,5.11,52.82,NULL,NULL,NULL,NULL),(13921,647,6.01,54.42,NULL,NULL,NULL,NULL),(13922,647,6.81,56.22,NULL,NULL,NULL,NULL),(13923,647,7.21,57.42,NULL,NULL,NULL,NULL),(13924,647,7.51,58.72,NULL,NULL,NULL,NULL),(13925,647,9.31,60.02,NULL,NULL,NULL,NULL),(13926,647,10.21,60.92,NULL,NULL,NULL,NULL),(13927,647,10.21,61.72,NULL,NULL,NULL,NULL),(13928,647,10.41,63.02,NULL,NULL,NULL,NULL),(13929,647,11.51,64.22,NULL,NULL,NULL,NULL),(13930,647,12.61,65.22,NULL,NULL,NULL,NULL),(13931,647,13.61,66.02,NULL,NULL,NULL,NULL),(13932,647,15.01,66.62,NULL,NULL,NULL,NULL),(13933,647,17.31,67.82,NULL,NULL,NULL,NULL),(13934,647,19.21,69.12,NULL,NULL,NULL,NULL),(13935,647,20.81,70.52,NULL,NULL,NULL,NULL),(13936,647,22.31,71.92,NULL,NULL,NULL,NULL),(13937,647,23.71,73.52,NULL,NULL,NULL,NULL),(13938,647,25.01,74.12,NULL,NULL,NULL,NULL),(13939,647,27.61,74.82,NULL,NULL,NULL,NULL),(13940,647,28.51,76.22,NULL,NULL,NULL,NULL),(13941,647,29.71,76.82,NULL,NULL,NULL,NULL),(13942,647,30.81,77.12,NULL,NULL,NULL,NULL),(13943,647,31.61,77.42,NULL,NULL,NULL,NULL),(13944,647,32.51,78.12,NULL,NULL,NULL,NULL),(13945,647,33.71,78.22,NULL,NULL,NULL,NULL),(13946,647,33.81,79.02,NULL,NULL,NULL,NULL),(13947,647,34.51,79.52,NULL,NULL,NULL,NULL),(13948,647,36.11,79.32,NULL,NULL,NULL,NULL),(13949,647,36.91,80.42,NULL,NULL,NULL,NULL),(13950,647,37.71,81.12,NULL,NULL,NULL,NULL),(13951,647,37.81,82.02,NULL,NULL,NULL,NULL),(13952,647,39.61,82.02,NULL,NULL,NULL,NULL),(13953,647,40.71,82.32,NULL,NULL,NULL,NULL),(13954,647,42.31,82.92,NULL,NULL,NULL,NULL),(13955,647,44.71,82.92,NULL,NULL,NULL,NULL),(13956,647,45.91,84.02,NULL,NULL,NULL,NULL),(13957,647,46.51,85.42,NULL,NULL,NULL,NULL),(13958,647,47.51,85.92,NULL,NULL,NULL,NULL),(13959,647,49.61,86.12,NULL,NULL,NULL,NULL),(13960,647,51.31,86.02,NULL,NULL,NULL,NULL),(13961,647,53.21,86.22,NULL,NULL,NULL,NULL),(13962,647,54.01,86.52,NULL,NULL,NULL,NULL),(13963,647,56.61,86.52,NULL,NULL,NULL,NULL),(13964,647,57.91,86.92,NULL,NULL,NULL,NULL),(13965,647,58.41,87.42,NULL,NULL,NULL,NULL),(13966,648,0,26.32,NULL,NULL,NULL,NULL),(13967,648,0.04,35.49,NULL,NULL,NULL,NULL),(13968,648,0.87,40.62,NULL,NULL,NULL,NULL),(13969,648,1.85,46.32,NULL,NULL,NULL,NULL),(13970,648,3.5,49.32,NULL,NULL,NULL,NULL),(13971,648,4.9,52.32,NULL,NULL,NULL,NULL),(13972,648,6.7,55.62,NULL,NULL,NULL,NULL),(13973,648,8.2,58.02,NULL,NULL,NULL,NULL),(13974,648,10.2,59.92,NULL,NULL,NULL,NULL),(13975,648,12.8,62.42,NULL,NULL,NULL,NULL),(13976,648,14.7,65.42,NULL,NULL,NULL,NULL),(13977,648,17.2,67.52,NULL,NULL,NULL,NULL),(13978,648,20.4,69.22,NULL,NULL,NULL,NULL),(13979,648,23.9,71.12,NULL,NULL,NULL,NULL),(13980,648,26.6,72.22,NULL,NULL,NULL,NULL),(13981,648,28.5,73.62,NULL,NULL,NULL,NULL),(13982,648,31.6,74.82,NULL,NULL,NULL,NULL),(13983,648,34.6,75.92,NULL,NULL,NULL,NULL),(13984,648,36.9,76.72,NULL,NULL,NULL,NULL),(13985,648,39.3,77.52,NULL,NULL,NULL,NULL),(13986,648,42.8,77.92,NULL,NULL,NULL,NULL),(13987,648,45.2,80.02,NULL,NULL,NULL,NULL),(13988,648,48.6,80.62,NULL,NULL,NULL,NULL),(13989,648,50.8,81.12,NULL,NULL,NULL,NULL),(13990,648,87.2,87.02,NULL,NULL,NULL,NULL),(13991,648,88.8,87.52,NULL,NULL,NULL,NULL),(13992,648,89.9,87.52,NULL,NULL,NULL,NULL),(13993,648,89.3,86.72,NULL,NULL,NULL,NULL),(13994,649,0,32.89,NULL,NULL,NULL,NULL),(13995,649,0.19,39.36,NULL,NULL,NULL,NULL),(13996,649,0.04,41.75,NULL,NULL,NULL,NULL),(13997,649,0.21,42.86,NULL,NULL,NULL,NULL),(13998,649,0.88,49.39,NULL,NULL,NULL,NULL),(13999,649,1.37,51.59,NULL,NULL,NULL,NULL),(14000,649,1.54,53.79,NULL,NULL,NULL,NULL),(14001,649,2.35,55.59,NULL,NULL,NULL,NULL),(14002,649,3.16,57.29,NULL,NULL,NULL,NULL),(14003,649,4.56,59.09,NULL,NULL,NULL,NULL),(14004,649,5.76,61.09,NULL,NULL,NULL,NULL),(14005,649,6.26,62.19,NULL,NULL,NULL,NULL),(14006,649,10.36,65.69,NULL,NULL,NULL,NULL),(14007,649,11.36,66.59,NULL,NULL,NULL,NULL),(14008,649,13.96,68.49,NULL,NULL,NULL,NULL),(14009,649,15.36,69.79,NULL,NULL,NULL,NULL),(14010,649,16.66,71.49,NULL,NULL,NULL,NULL),(14011,649,17.16,72.59,NULL,NULL,NULL,NULL),(14012,649,54.06,85.59,NULL,NULL,NULL,NULL),(14013,649,55.26,85.59,NULL,NULL,NULL,NULL),(14014,649,56.46,85.39,NULL,NULL,NULL,NULL),(14015,649,57.86,86.69,NULL,NULL,NULL,NULL),(14016,649,58.96,86.49,NULL,NULL,NULL,NULL),(14017,649,59.96,85.99,NULL,NULL,NULL,NULL),(14018,649,60.96,86.49,NULL,NULL,NULL,NULL),(14019,649,61.86,88.19,NULL,NULL,NULL,NULL),(14020,649,63.96,87.99,NULL,NULL,NULL,NULL),(14021,649,66.06,87.99,NULL,NULL,NULL,NULL),(14022,649,67.36,87.99,NULL,NULL,NULL,NULL),(14023,649,68.16,87.99,NULL,NULL,NULL,NULL),(14024,649,68.56,89.59,NULL,NULL,NULL,NULL),(14025,649,69.36,88.59,NULL,NULL,NULL,NULL),(14026,649,70.56,88.89,NULL,NULL,NULL,NULL),(14027,649,71.46,88.89,NULL,NULL,NULL,NULL),(14028,649,73.46,89.89,NULL,NULL,NULL,NULL),(14029,649,75.46,89.99,NULL,NULL,NULL,NULL),(14030,649,76.96,89.99,NULL,NULL,NULL,NULL),(14031,649,77.86,91.29,NULL,NULL,NULL,NULL),(14032,649,78.66,91.09,NULL,NULL,NULL,NULL),(14033,649,79.66,91.59,NULL,NULL,NULL,NULL),(14034,649,80.96,91.29,NULL,NULL,NULL,NULL),(14035,649,81.86,91.59,NULL,NULL,NULL,NULL),(14036,649,82.66,92.19,NULL,NULL,NULL,NULL),(14037,649,85.86,92.69,NULL,NULL,NULL,NULL),(14038,649,87.06,92.49,NULL,NULL,NULL,NULL),(14039,649,88.26,91.99,NULL,NULL,NULL,NULL),(14040,649,89.46,91.99,NULL,NULL,NULL,NULL),(14041,649,90.06,92.79,NULL,NULL,NULL,NULL),(14042,650,0,24.69,NULL,NULL,NULL,NULL),(14043,650,1.25,29.95,NULL,NULL,NULL,NULL),(14044,650,5.02,36.73,NULL,NULL,NULL,NULL),(14045,650,7.99,38.75,NULL,NULL,NULL,NULL),(14046,650,14.1,41.76,NULL,NULL,NULL,NULL),(14047,650,18.2,42.91,NULL,NULL,NULL,NULL),(14048,650,22.2,44.57,NULL,NULL,NULL,NULL),(14049,650,29.1,45.63,NULL,NULL,NULL,NULL),(14050,650,35.1,46.99,NULL,NULL,NULL,NULL),(14051,650,36.2,46.97,NULL,NULL,NULL,NULL),(14052,650,42.3,48.05,NULL,NULL,NULL,NULL),(14053,650,48.1,48.4,NULL,NULL,NULL,NULL),(14054,651,0,24.04,NULL,NULL,NULL,NULL),(14055,651,0.2,29.04,NULL,NULL,NULL,NULL),(14056,651,1.1,32.94,NULL,NULL,NULL,NULL),(14057,651,4.23,36.72,NULL,NULL,NULL,NULL),(14058,651,6.03,38.69,NULL,NULL,NULL,NULL),(14059,651,9.33,40.39,NULL,NULL,NULL,NULL),(14060,651,15.5,42.34,NULL,NULL,NULL,NULL),(14061,651,21.4,44.15,NULL,NULL,NULL,NULL),(14062,651,26.3,45.21,NULL,NULL,NULL,NULL),(14063,651,34.3,46.81,NULL,NULL,NULL,NULL),(14064,651,36.4,47.2,NULL,NULL,NULL,NULL),(14065,651,48.1,48.58,NULL,NULL,NULL,NULL),(14066,652,0,24.39,NULL,NULL,NULL,NULL),(14067,652,0.2,28.72,NULL,NULL,NULL,NULL),(14068,652,0.784,33.19,NULL,NULL,NULL,NULL),(14069,652,4,38.54,NULL,NULL,NULL,NULL),(14070,652,10.2,43.21,NULL,NULL,NULL,NULL),(14071,652,17.2,45.68,NULL,NULL,NULL,NULL),(14072,652,23.1,47.29,NULL,NULL,NULL,NULL),(14073,652,29.3,48.65,NULL,NULL,NULL,NULL),(14074,652,36.1,50.01,NULL,NULL,NULL,NULL),(14075,652,39.4,50.92,NULL,NULL,NULL,NULL),(14076,652,43.1,51.6,NULL,NULL,NULL,NULL),(14077,653,0,26.6,NULL,NULL,NULL,NULL),(14078,653,1.02,33.28,NULL,NULL,NULL,NULL),(14079,653,4,38.82,NULL,NULL,NULL,NULL),(14080,653,8.07,42.86,NULL,NULL,NULL,NULL),(14081,653,14.3,45.55,NULL,NULL,NULL,NULL),(14082,653,19,47.62,NULL,NULL,NULL,NULL),(14083,653,22.2,48.89,NULL,NULL,NULL,NULL),(14084,653,26.2,50.3,NULL,NULL,NULL,NULL),(14085,653,33.1,52.21,NULL,NULL,NULL,NULL),(14086,653,36.3,53.18,NULL,NULL,NULL,NULL),(14087,653,40.1,54.16,NULL,NULL,NULL,NULL),(14088,653,46.1,55.38,NULL,NULL,NULL,NULL),(14089,653,48.2,56.11,NULL,NULL,NULL,NULL),(14090,654,0,39.45,NULL,NULL,NULL,NULL),(14091,654,0.3,41.62,NULL,NULL,NULL,NULL),(14092,654,0.32,45.36,NULL,NULL,NULL,NULL),(14093,654,0.33,48.15,NULL,NULL,NULL,NULL),(14094,654,1.81,53.44,NULL,NULL,NULL,NULL),(14095,654,4.05,63.37,NULL,NULL,NULL,NULL),(14096,654,6.63,67.09,NULL,NULL,NULL,NULL),(14097,654,7.4,68.65,NULL,NULL,NULL,NULL),(14098,654,8.8,71.74,NULL,NULL,NULL,NULL),(14099,654,9.9,74,NULL,NULL,NULL,NULL),(14100,654,11.8,75.33,NULL,NULL,NULL,NULL),(14101,654,13.6,77.66,NULL,NULL,NULL,NULL),(14102,654,18.8,81.31,NULL,NULL,NULL,NULL),(14103,654,21,84.96,NULL,NULL,NULL,NULL),(14104,654,22.8,86.29,NULL,NULL,NULL,NULL),(14105,654,26.1,89.62,NULL,NULL,NULL,NULL),(14106,654,29.1,91.61,NULL,NULL,NULL,NULL),(14107,654,34.2,93.6,NULL,NULL,NULL,NULL),(14108,654,36.8,94.93,NULL,NULL,NULL,NULL),(14109,654,40.4,96.59,NULL,NULL,NULL,NULL),(14110,654,44.5,98.25,NULL,NULL,NULL,NULL),(14111,654,46.7,97.92,NULL,NULL,NULL,NULL),(14112,654,52.2,100.25,NULL,NULL,NULL,NULL),(14113,654,55.8,101.24,NULL,NULL,NULL,NULL),(14114,654,61.3,101.24,NULL,NULL,NULL,NULL),(14115,654,65.7,103.57,NULL,NULL,NULL,NULL),(14116,654,74.2,105.23,NULL,NULL,NULL,NULL),(14117,654,80,106.89,NULL,NULL,NULL,NULL),(14118,654,86.6,108.55,NULL,NULL,NULL,NULL),(14119,654,99,110.88,NULL,NULL,NULL,NULL),(14120,654,110,112.54,NULL,NULL,NULL,NULL),(14121,654,118,114.53,NULL,NULL,NULL,NULL),(14122,654,125,115.86,NULL,NULL,NULL,NULL),(14123,654,137,116.86,NULL,NULL,NULL,NULL),(14124,654,143,117.85,NULL,NULL,NULL,NULL),(14125,654,155,118.52,NULL,NULL,NULL,NULL),(14126,654,167,119.85,NULL,NULL,NULL,NULL),(14127,654,184,121.84,NULL,NULL,NULL,NULL),(14128,654,195,122.51,NULL,NULL,NULL,NULL),(14129,655,0,39.45,NULL,NULL,NULL,NULL),(14130,655,3.01,43.57,NULL,NULL,NULL,NULL),(14131,655,0.03,47.99,NULL,NULL,NULL,NULL),(14132,655,1.92,53.37,NULL,NULL,NULL,NULL),(14133,655,2.31,55.89,NULL,NULL,NULL,NULL),(14134,655,4.57,59.38,NULL,NULL,NULL,NULL),(14135,655,6.82,62.21,NULL,NULL,NULL,NULL),(14136,655,7.2,64.73,NULL,NULL,NULL,NULL),(14137,655,9.5,67.29,NULL,NULL,NULL,NULL),(14138,655,11.7,70.74,NULL,NULL,NULL,NULL),(14139,655,16.2,75,NULL,NULL,NULL,NULL),(14140,655,19.2,76.33,NULL,NULL,NULL,NULL),(14141,655,22.2,79.65,NULL,NULL,NULL,NULL),(14142,655,26,82.97,NULL,NULL,NULL,NULL),(14143,655,30.5,85.96,NULL,NULL,NULL,NULL),(14144,655,35.4,87.95,NULL,NULL,NULL,NULL),(14145,655,41.4,89.95,NULL,NULL,NULL,NULL),(14146,655,44.4,90.28,NULL,NULL,NULL,NULL),(14147,655,51.9,93.27,NULL,NULL,NULL,NULL),(14148,655,56.8,93.93,NULL,NULL,NULL,NULL),(14149,655,61.6,94.6,NULL,NULL,NULL,NULL),(14150,655,65.4,96.92,NULL,NULL,NULL,NULL),(14151,655,71.4,98.25,NULL,NULL,NULL,NULL),(14152,655,82.2,99.91,NULL,NULL,NULL,NULL),(14153,655,92.4,100.91,NULL,NULL,NULL,NULL),(14154,655,100,102.9,NULL,NULL,NULL,NULL),(14155,655,110,104.9,NULL,NULL,NULL,NULL),(14156,655,118,105.56,NULL,NULL,NULL,NULL),(14157,655,130,107.22,NULL,NULL,NULL,NULL),(14158,655,142,108.55,NULL,NULL,NULL,NULL),(14159,655,157,110.21,NULL,NULL,NULL,NULL),(14160,655,173,111.21,NULL,NULL,NULL,NULL),(14161,655,195,112.87,NULL,NULL,NULL,NULL),(14162,656,0,36.53,NULL,NULL,NULL,NULL),(14163,656,1.8,39.63,NULL,NULL,NULL,NULL),(14164,656,4.8,45.53,NULL,NULL,NULL,NULL),(14165,656,7.7,50.18,NULL,NULL,NULL,NULL),(14166,656,8.8,55.76,NULL,NULL,NULL,NULL),(14167,656,12.5,59.81,NULL,NULL,NULL,NULL),(14168,656,17.3,65.1,NULL,NULL,NULL,NULL),(14169,656,21,70.74,NULL,NULL,NULL,NULL),(14170,656,28.3,77.39,NULL,NULL,NULL,NULL),(14171,656,33.1,81.38,NULL,NULL,NULL,NULL),(14172,656,38.2,85.03,NULL,NULL,NULL,NULL),(14173,656,46.3,89.68,NULL,NULL,NULL,NULL),(14174,656,51.4,92.01,NULL,NULL,NULL,NULL),(14175,656,57.3,95.66,NULL,NULL,NULL,NULL),(14176,656,59.9,95.99,NULL,NULL,NULL,NULL),(14177,656,65.4,97.66,NULL,NULL,NULL,NULL),(14178,656,71.6,99.65,NULL,NULL,NULL,NULL),(14179,656,78.2,101.31,NULL,NULL,NULL,NULL),(14180,656,83,101.97,NULL,NULL,NULL,NULL),(14181,656,86.3,103.97,NULL,NULL,NULL,NULL),(14182,656,92.5,105.3,NULL,NULL,NULL,NULL),(14183,656,100,105.63,NULL,NULL,NULL,NULL),(14184,656,111,108.62,NULL,NULL,NULL,NULL),(14185,656,121,109.95,NULL,NULL,NULL,NULL),(14186,656,128,110.61,NULL,NULL,NULL,NULL),(14187,656,136,110.94,NULL,NULL,NULL,NULL),(14188,656,142,111.94,NULL,NULL,NULL,NULL),(14189,656,149,112.61,NULL,NULL,NULL,NULL),(14190,656,156,112.61,NULL,NULL,NULL,NULL),(14191,656,161,112.94,NULL,NULL,NULL,NULL),(14192,656,170,113.27,NULL,NULL,NULL,NULL),(14193,656,179,114.27,NULL,NULL,NULL,NULL),(14194,656,187,114.27,NULL,NULL,NULL,NULL),(14195,656,191,114.27,NULL,NULL,NULL,NULL),(14196,657,0,36.53,NULL,NULL,NULL,NULL),(14197,657,2.75,40.31,NULL,NULL,NULL,NULL),(14198,657,5.4,45.7,NULL,NULL,NULL,NULL),(14199,657,8.8,50.41,NULL,NULL,NULL,NULL),(14200,657,15.6,57.36,NULL,NULL,NULL,NULL),(14201,657,18.9,61.18,NULL,NULL,NULL,NULL),(14202,657,28.3,68.12,NULL,NULL,NULL,NULL),(14203,657,33.2,70.74,NULL,NULL,NULL,NULL),(14204,657,41.5,75.06,NULL,NULL,NULL,NULL),(14205,657,49.7,77.72,NULL,NULL,NULL,NULL),(14206,657,57.6,80.38,NULL,NULL,NULL,NULL),(14207,657,62.8,82.04,NULL,NULL,NULL,NULL),(14208,657,72.2,84.03,NULL,NULL,NULL,NULL),(14209,657,80.8,85.03,NULL,NULL,NULL,NULL),(14210,657,85.3,87.36,NULL,NULL,NULL,NULL),(14211,657,94,88.35,NULL,NULL,NULL,NULL),(14212,657,105,89.68,NULL,NULL,NULL,NULL),(14213,657,114,90.35,NULL,NULL,NULL,NULL),(14214,657,124,91.68,NULL,NULL,NULL,NULL),(14215,657,134,92.67,NULL,NULL,NULL,NULL),(14216,657,145,93.67,NULL,NULL,NULL,NULL),(14217,657,161,94,NULL,NULL,NULL,NULL),(14218,657,180,94.67,NULL,NULL,NULL,NULL),(14219,657,192,94.67,NULL,NULL,NULL,NULL),(14220,658,0,33.23,NULL,NULL,NULL,NULL),(14221,658,0.5,37.88,NULL,NULL,NULL,NULL),(14222,658,1,45.02,NULL,NULL,NULL,NULL),(14223,658,5,52.17,NULL,NULL,NULL,NULL),(14224,658,14.2,57.15,NULL,NULL,NULL,NULL),(14225,658,24.8,60.87,NULL,NULL,NULL,NULL),(14226,658,34.4,63.66,NULL,NULL,NULL,NULL),(14227,658,43.9,63.96,NULL,NULL,NULL,NULL),(14228,658,49.8,64.89,NULL,NULL,NULL,NULL),(14229,658,54.5,65.82,NULL,NULL,NULL,NULL),(14230,658,60.4,67.78,NULL,NULL,NULL,NULL),(14231,658,68.8,68.78,NULL,NULL,NULL,NULL),(14232,658,76,70.44,NULL,NULL,NULL,NULL),(14233,658,83,71.1,NULL,NULL,NULL,NULL),(14234,658,89,72.76,NULL,NULL,NULL,NULL),(14235,658,105,74.09,NULL,NULL,NULL,NULL),(14236,658,114,74.76,NULL,NULL,NULL,NULL),(14237,658,125,76.09,NULL,NULL,NULL,NULL),(14238,658,134,76.75,NULL,NULL,NULL,NULL),(14239,658,143,77.08,NULL,NULL,NULL,NULL),(14240,658,153,78.41,NULL,NULL,NULL,NULL),(14241,658,161,78.74,NULL,NULL,NULL,NULL),(14242,658,169,78.41,NULL,NULL,NULL,NULL),(14243,658,177,80.41,NULL,NULL,NULL,NULL),(14244,659,0,33.23,NULL,NULL,NULL,NULL),(14245,659,0.8,35.4,NULL,NULL,NULL,NULL),(14246,659,2.7,40.47,NULL,NULL,NULL,NULL),(14247,659,11.4,44.23,NULL,NULL,NULL,NULL),(14248,659,22.2,48.01,NULL,NULL,NULL,NULL),(14249,659,32,49.28,NULL,NULL,NULL,NULL),(14250,659,41,50.21,NULL,NULL,NULL,NULL),(14251,659,48.5,51.77,NULL,NULL,NULL,NULL),(14252,659,59,52.7,NULL,NULL,NULL,NULL),(14253,659,68,54.29,NULL,NULL,NULL,NULL),(14254,659,78,55.22,NULL,NULL,NULL,NULL),(14255,659,84,55.82,NULL,NULL,NULL,NULL),(14256,659,89,56.15,NULL,NULL,NULL,NULL),(14257,659,95,56.75,NULL,NULL,NULL,NULL),(14258,659,104,57.71,NULL,NULL,NULL,NULL),(14259,659,112,57.68,NULL,NULL,NULL,NULL),(14260,659,123,58.61,NULL,NULL,NULL,NULL),(14261,659,131,58.91,NULL,NULL,NULL,NULL),(14262,659,142,59.21,NULL,NULL,NULL,NULL),(14263,659,154,59.84,NULL,NULL,NULL,NULL),(14264,659,168,60.77,NULL,NULL,NULL,NULL),(14265,659,180,61.37,NULL,NULL,NULL,NULL),(14266,660,0,31.87,NULL,NULL,NULL,NULL),(14267,660,1,36.85,NULL,NULL,NULL,NULL),(14268,660,3.4,42.43,NULL,NULL,NULL,NULL),(14269,660,7.5,46.16,NULL,NULL,NULL,NULL),(14270,660,16,49.24,NULL,NULL,NULL,NULL),(14271,660,22,52.37,NULL,NULL,NULL,NULL),(14272,660,30,54.23,NULL,NULL,NULL,NULL),(14273,660,39,57.32,NULL,NULL,NULL,NULL),(14274,660,45,58.58,NULL,NULL,NULL,NULL),(14275,660,51,59.51,NULL,NULL,NULL,NULL),(14276,660,54,60.11,NULL,NULL,NULL,NULL),(14277,660,64,61.67,NULL,NULL,NULL,NULL),(14278,660,79,63.53,NULL,NULL,NULL,NULL),(14279,660,86,65.09,NULL,NULL,NULL,NULL),(14280,660,92,65.42,NULL,NULL,NULL,NULL),(14281,660,105,66.75,NULL,NULL,NULL,NULL),(14282,660,115,67.09,NULL,NULL,NULL,NULL),(14283,660,123,67.09,NULL,NULL,NULL,NULL),(14284,660,127,67.75,NULL,NULL,NULL,NULL),(14285,661,0,31.87,NULL,NULL,NULL,NULL),(14286,661,0.6,34.57,NULL,NULL,NULL,NULL),(14287,661,5.5,38.05,NULL,NULL,NULL,NULL),(14288,661,15,40.87,NULL,NULL,NULL,NULL),(14289,661,25,42.77,NULL,NULL,NULL,NULL),(14290,661,36,44.63,NULL,NULL,NULL,NULL),(14291,661,44,46.22,NULL,NULL,NULL,NULL),(14292,661,53,47.45,NULL,NULL,NULL,NULL),(14293,661,64,48.38,NULL,NULL,NULL,NULL),(14294,661,74,49.01,NULL,NULL,NULL,NULL),(14295,661,86,50.27,NULL,NULL,NULL,NULL),(14296,661,97,51.5,NULL,NULL,NULL,NULL),(14297,661,109,51.8,NULL,NULL,NULL,NULL),(14298,661,116,51.8,NULL,NULL,NULL,NULL),(14299,661,126,52.73,NULL,NULL,NULL,NULL),(14300,661,129,53.03,NULL,NULL,NULL,NULL),(14301,662,0,94.39,NULL,NULL,NULL,NULL),(14302,662,1,121.3,NULL,NULL,NULL,NULL),(14303,662,3,145.23,NULL,NULL,NULL,NULL),(14304,662,7,149.25,NULL,NULL,NULL,NULL),(14305,662,40,166.59,NULL,NULL,NULL,NULL),(14306,662,84,172.55,NULL,NULL,NULL,NULL),(14307,662,167,178.43,NULL,NULL,NULL,NULL),(14308,662,255,181.24,NULL,NULL,NULL,NULL),(14309,662,517,183.91,NULL,NULL,NULL,NULL),(14310,662,588,179.31,NULL,NULL,NULL,NULL),(14311,662,818,182.56,NULL,NULL,NULL,NULL),(14312,663,0,79.54,NULL,NULL,NULL,NULL),(14313,663,1,98.26,NULL,NULL,NULL,NULL),(14314,663,3,109.61,NULL,NULL,NULL,NULL),(14315,663,4,114.48,NULL,NULL,NULL,NULL),(14316,663,7,114.61,NULL,NULL,NULL,NULL),(14317,663,22,139.49,NULL,NULL,NULL,NULL),(14318,663,69,149.88,NULL,NULL,NULL,NULL),(14319,663,149,156.8,NULL,NULL,NULL,NULL),(14320,663,227,162.07,NULL,NULL,NULL,NULL),(14321,663,316,166.07,NULL,NULL,NULL,NULL),(14322,663,470,158.98,NULL,NULL,NULL,NULL),(14323,663,580,160.12,NULL,NULL,NULL,NULL),(14324,663,803,165.93,NULL,NULL,NULL,NULL),(14325,663,1225,173.87,NULL,NULL,NULL,NULL),(14326,664,0,51.92,NULL,NULL,NULL,NULL),(14327,664,1,83.03,NULL,NULL,NULL,NULL),(14328,664,3,97.58,NULL,NULL,NULL,NULL),(14329,664,4,110.21,NULL,NULL,NULL,NULL),(14330,664,30,125.27,NULL,NULL,NULL,NULL),(14331,664,75,143.57,NULL,NULL,NULL,NULL),(14332,664,158,157.64,NULL,NULL,NULL,NULL),(14333,664,232,169.74,NULL,NULL,NULL,NULL),(14334,664,332,164.68,NULL,NULL,NULL,NULL),(14335,664,466,172.73,NULL,NULL,NULL,NULL),(14336,664,581,172.81,NULL,NULL,NULL,NULL),(14337,664,820,165.83,NULL,NULL,NULL,NULL),(14338,664,1150,173.66,NULL,NULL,NULL,NULL),(14339,664,1255,175.46,NULL,NULL,NULL,NULL),(14340,665,0,47.17,NULL,NULL,NULL,NULL),(14341,665,1,56.42,NULL,NULL,NULL,NULL),(14342,665,2,62.15,NULL,NULL,NULL,NULL),(14343,665,3,64.64,NULL,NULL,NULL,NULL),(14344,665,6,70.39,NULL,NULL,NULL,NULL),(14345,665,7,71.75,NULL,NULL,NULL,NULL),(14346,665,23,79.46,NULL,NULL,NULL,NULL),(14347,665,44,88.96,NULL,NULL,NULL,NULL),(14348,665,126,98.51,NULL,NULL,NULL,NULL),(14349,665,191,106.12,NULL,NULL,NULL,NULL),(14350,665,283,108.95,NULL,NULL,NULL,NULL),(14351,665,441,111.97,NULL,NULL,NULL,NULL),(14352,665,534,107.15,NULL,NULL,NULL,NULL),(14353,665,771,113.7,NULL,NULL,NULL,NULL),(14354,665,1137,120.04,NULL,NULL,NULL,NULL),(14355,665,1170,118.76,NULL,NULL,NULL,NULL),(14356,666,0,136.81,NULL,NULL,NULL,NULL),(14357,666,7,150.91,NULL,NULL,NULL,NULL),(14358,666,15,152.1,NULL,NULL,NULL,NULL),(14359,666,38,164.13,NULL,NULL,NULL,NULL),(14360,666,66,160.22,NULL,NULL,NULL,NULL),(14361,666,85,167.11,NULL,NULL,NULL,NULL),(14362,666,124,174.2,NULL,NULL,NULL,NULL),(14363,666,171,175.43,NULL,NULL,NULL,NULL),(14364,666,231,178.16,NULL,NULL,NULL,NULL),(14365,666,307,183.98,NULL,NULL,NULL,NULL),(14366,666,367,195.05,NULL,NULL,NULL,NULL),(14367,666,501,198.09,NULL,NULL,NULL,NULL),(14368,666,1013,197.99,NULL,NULL,NULL,NULL),(14369,666,1349,199.87,NULL,NULL,NULL,NULL),(14370,666,1664,199.84,NULL,NULL,NULL,NULL),(14371,667,0,81.48,NULL,NULL,NULL,NULL),(14372,667,1,80.68,NULL,NULL,NULL,NULL),(14373,667,14,89.64,NULL,NULL,NULL,NULL),(14374,667,17,93.66,NULL,NULL,NULL,NULL),(14375,667,32,95.61,NULL,NULL,NULL,NULL),(14376,667,72,98.69,NULL,NULL,NULL,NULL),(14377,667,110,99.59,NULL,NULL,NULL,NULL),(14378,667,156,102.63,NULL,NULL,NULL,NULL),(14379,667,217,103.54,NULL,NULL,NULL,NULL),(14380,667,320,107.65,NULL,NULL,NULL,NULL),(14381,667,391,112.63,NULL,NULL,NULL,NULL),(14382,667,749,111.68,NULL,NULL,NULL,NULL),(14383,667,990,114.52,NULL,NULL,NULL,NULL),(14384,667,1045,115.79,NULL,NULL,NULL,NULL),(14385,667,1536,119.68,NULL,NULL,NULL,NULL),(14386,668,0,37.67,NULL,NULL,NULL,NULL),(14387,668,8,50.47,NULL,NULL,NULL,NULL),(14388,668,28,56.61,NULL,NULL,NULL,NULL),(14389,668,58,63.44,NULL,NULL,NULL,NULL),(14390,668,125,69.4,NULL,NULL,NULL,NULL),(14391,668,220,75.5,NULL,NULL,NULL,NULL),(14392,668,361,73.3,NULL,NULL,NULL,NULL),(14393,668,586,79.52,NULL,NULL,NULL,NULL),(14394,668,827,84.48,NULL,NULL,NULL,NULL),(14395,668,927,89.26,NULL,NULL,NULL,NULL),(14396,668,1409,82.91,NULL,NULL,NULL,NULL),(14397,668,1537,84.6,NULL,NULL,NULL,NULL),(14398,669,0,33.94,NULL,NULL,NULL,NULL),(14399,669,4,34.97,NULL,NULL,NULL,NULL),(14400,669,11,37.96,NULL,NULL,NULL,NULL),(14401,669,28,40.94,NULL,NULL,NULL,NULL),(14402,669,63,44.02,NULL,NULL,NULL,NULL),(14403,669,105,46.93,NULL,NULL,NULL,NULL),(14404,669,286,50.95,NULL,NULL,NULL,NULL),(14405,669,504,54.92,NULL,NULL,NULL,NULL),(14406,669,777,60.93,NULL,NULL,NULL,NULL),(14407,669,889,59.84,NULL,NULL,NULL,NULL),(14408,669,1139,57.89,NULL,NULL,NULL,NULL),(14409,669,1521,61.04,NULL,NULL,NULL,NULL),(14410,669,1650,59.75,NULL,NULL,NULL,NULL),(14411,670,0,135.9,NULL,NULL,NULL,NULL),(14412,670,1,141.9,NULL,NULL,NULL,NULL),(14413,670,2,158,NULL,NULL,NULL,NULL),(14414,670,7,172,NULL,NULL,NULL,NULL),(14415,670,20,181.8,NULL,NULL,NULL,NULL),(14416,670,54,188.2,NULL,NULL,NULL,NULL),(14417,670,108,196.8,NULL,NULL,NULL,NULL),(14418,670,165,199.2,NULL,NULL,NULL,NULL),(14419,670,242,199.1,NULL,NULL,NULL,NULL),(14420,670,292,204.1,NULL,NULL,NULL,NULL),(14421,670,427,201.1,NULL,NULL,NULL,NULL),(14422,670,540,199.3,NULL,NULL,NULL,NULL),(14423,670,761,203.2,NULL,NULL,NULL,NULL),(14424,670,1130,207.8,NULL,NULL,NULL,NULL),(14425,671,0,99.71,NULL,NULL,NULL,NULL),(14426,671,1,112.8,NULL,NULL,NULL,NULL),(14427,671,2,122.7,NULL,NULL,NULL,NULL),(14428,671,13,155.8,NULL,NULL,NULL,NULL),(14429,671,26,154,NULL,NULL,NULL,NULL),(14430,671,48,159,NULL,NULL,NULL,NULL),(14431,671,86,161,NULL,NULL,NULL,NULL),(14432,671,129,163.9,NULL,NULL,NULL,NULL),(14433,671,169,168.2,NULL,NULL,NULL,NULL),(14434,671,248,172.9,NULL,NULL,NULL,NULL),(14435,671,285,172,NULL,NULL,NULL,NULL),(14436,671,430,172,NULL,NULL,NULL,NULL),(14437,671,549,171.1,NULL,NULL,NULL,NULL),(14438,671,760,174.9,NULL,NULL,NULL,NULL),(14439,671,1079,178.1,NULL,NULL,NULL,NULL),(14440,671,1210,179.1,NULL,NULL,NULL,NULL),(14441,672,0,62.42,NULL,NULL,NULL,NULL),(14442,672,2,75.29,NULL,NULL,NULL,NULL),(14443,672,12,94.06,NULL,NULL,NULL,NULL),(14444,672,37,101.2,NULL,NULL,NULL,NULL),(14445,672,90,113.6,NULL,NULL,NULL,NULL),(14446,672,145,117.9,NULL,NULL,NULL,NULL),(14447,672,221,121,NULL,NULL,NULL,NULL),(14448,672,284,117.2,NULL,NULL,NULL,NULL),(14449,672,424,115.8,NULL,NULL,NULL,NULL),(14450,672,545,112.3,NULL,NULL,NULL,NULL),(14451,672,771,119.7,NULL,NULL,NULL,NULL),(14452,672,1086,123.6,NULL,NULL,NULL,NULL),(14453,672,1198,126.8,NULL,NULL,NULL,NULL),(14454,673,0,40.79,NULL,NULL,NULL,NULL),(14455,673,2,43.88,NULL,NULL,NULL,NULL),(14456,673,5,47.72,NULL,NULL,NULL,NULL),(14457,673,27,53.69,NULL,NULL,NULL,NULL),(14458,673,81,62.58,NULL,NULL,NULL,NULL),(14459,673,141,67.18,NULL,NULL,NULL,NULL),(14460,673,221,68.99,NULL,NULL,NULL,NULL),(14461,673,257,70.49,NULL,NULL,NULL,NULL),(14462,673,418,68.43,NULL,NULL,NULL,NULL),(14463,673,530,70.68,NULL,NULL,NULL,NULL),(14464,673,741,75.73,NULL,NULL,NULL,NULL),(14465,673,1062,78.4,NULL,NULL,NULL,NULL),(14466,673,1181,79.58,NULL,NULL,NULL,NULL),(14467,674,0,83.62,NULL,NULL,NULL,NULL),(14468,674,2,92.18,NULL,NULL,NULL,NULL),(14469,674,6,98.71,NULL,NULL,NULL,NULL),(14470,674,19,105.8,NULL,NULL,NULL,NULL),(14471,674,39,108.3,NULL,NULL,NULL,NULL),(14472,674,57,111.9,NULL,NULL,NULL,NULL),(14473,674,112,112.9,NULL,NULL,NULL,NULL),(14474,674,165,114.2,NULL,NULL,NULL,NULL),(14475,674,245,117.4,NULL,NULL,NULL,NULL),(14476,674,330,116.9,NULL,NULL,NULL,NULL),(14477,674,448,117.9,NULL,NULL,NULL,NULL),(14478,674,586,113.9,NULL,NULL,NULL,NULL),(14479,674,785,121.6,NULL,NULL,NULL,NULL),(14480,674,1017,116.5,NULL,NULL,NULL,NULL),(14481,674,1213,119.8,NULL,NULL,NULL,NULL),(14482,675,0,69.84,NULL,NULL,NULL,NULL),(14483,675,2,75.51,NULL,NULL,NULL,NULL),(14484,675,13,85.77,NULL,NULL,NULL,NULL),(14485,675,33,88.1,NULL,NULL,NULL,NULL),(14486,675,51,89.17,NULL,NULL,NULL,NULL),(14487,675,105,87.31,NULL,NULL,NULL,NULL),(14488,675,166,91.06,NULL,NULL,NULL,NULL),(14489,675,247,91.47,NULL,NULL,NULL,NULL),(14490,675,332,91.03,NULL,NULL,NULL,NULL),(14491,675,441,94.25,NULL,NULL,NULL,NULL),(14492,675,558,93.49,NULL,NULL,NULL,NULL),(14493,675,749,91.11,NULL,NULL,NULL,NULL),(14494,675,982,90.88,NULL,NULL,NULL,NULL),(14495,675,1182,93.67,NULL,NULL,NULL,NULL),(14496,676,0,48.76,NULL,NULL,NULL,NULL),(14497,676,2,54.96,NULL,NULL,NULL,NULL),(14498,676,20,71.34,NULL,NULL,NULL,NULL),(14499,676,38,70.35,NULL,NULL,NULL,NULL),(14500,676,92,72.36,NULL,NULL,NULL,NULL),(14501,676,145,75.89,NULL,NULL,NULL,NULL),(14502,676,222,78.46,NULL,NULL,NULL,NULL),(14503,676,312,75.87,NULL,NULL,NULL,NULL),(14504,676,456,81.12,NULL,NULL,NULL,NULL),(14505,676,572,79.5,NULL,NULL,NULL,NULL),(14506,676,779,83.15,NULL,NULL,NULL,NULL),(14507,676,1000,78.94,NULL,NULL,NULL,NULL),(14508,676,1192,80.66,NULL,NULL,NULL,NULL),(14509,677,0,32.94,NULL,NULL,NULL,NULL),(14510,677,2,34.09,NULL,NULL,NULL,NULL),(14511,677,14,40.16,NULL,NULL,NULL,NULL),(14512,677,31,40.02,NULL,NULL,NULL,NULL),(14513,677,86,42.03,NULL,NULL,NULL,NULL),(14514,677,140,47.6,NULL,NULL,NULL,NULL),(14515,677,214,48.88,NULL,NULL,NULL,NULL),(14516,677,304,48.65,NULL,NULL,NULL,NULL),(14517,677,421,52.08,NULL,NULL,NULL,NULL),(14518,677,543,53.25,NULL,NULL,NULL,NULL),(14519,677,732,56.58,NULL,NULL,NULL,NULL),(14520,677,961,58.61,NULL,NULL,NULL,NULL),(14521,677,1155,60.11,NULL,NULL,NULL,NULL),(14522,678,0,134.62,NULL,NULL,NULL,NULL),(14523,678,2,151.06,NULL,NULL,NULL,NULL),(14524,678,6,160.2,NULL,NULL,NULL,NULL),(14525,678,24,181.31,NULL,NULL,NULL,NULL),(14526,678,68,184.64,NULL,NULL,NULL,NULL),(14527,678,125,190.08,NULL,NULL,NULL,NULL),(14528,678,208,193.32,NULL,NULL,NULL,NULL),(14529,678,260,193.17,NULL,NULL,NULL,NULL),(14530,678,408,192.98,NULL,NULL,NULL,NULL),(14531,678,525,189.27,NULL,NULL,NULL,NULL),(14532,678,733,194.27,NULL,NULL,NULL,NULL),(14533,678,1231,197.61,NULL,NULL,NULL,NULL),(14534,679,0,79.692,NULL,NULL,NULL,NULL),(14535,679,1,104.76,NULL,NULL,NULL,NULL),(14536,679,7,126.36,NULL,NULL,NULL,NULL),(14537,679,21,139,NULL,NULL,NULL,NULL),(14538,679,54,156.22,NULL,NULL,NULL,NULL),(14539,679,124,173.67,NULL,NULL,NULL,NULL),(14540,679,207,181.87,NULL,NULL,NULL,NULL),(14541,679,276,185.26,NULL,NULL,NULL,NULL),(14542,679,418,187.2,NULL,NULL,NULL,NULL),(14543,679,543,187.34,NULL,NULL,NULL,NULL),(14544,679,752,193.15,NULL,NULL,NULL,NULL),(14545,679,1248,195.27,NULL,NULL,NULL,NULL),(14546,679,1374,198.39,NULL,NULL,NULL,NULL),(14547,680,0,56.585,NULL,NULL,NULL,NULL),(14548,680,1,71.42,NULL,NULL,NULL,NULL),(14549,680,3,82.483,NULL,NULL,NULL,NULL),(14550,680,7,87.145,NULL,NULL,NULL,NULL),(14551,680,27,106.21,NULL,NULL,NULL,NULL),(14552,680,61,114.65,NULL,NULL,NULL,NULL),(14553,680,120,119.58,NULL,NULL,NULL,NULL),(14554,680,197,122.61,NULL,NULL,NULL,NULL),(14555,680,258,121.75,NULL,NULL,NULL,NULL),(14556,680,403,120.94,NULL,NULL,NULL,NULL),(14557,680,514,121.9,NULL,NULL,NULL,NULL),(14558,680,740,124.76,NULL,NULL,NULL,NULL),(14559,680,1030,123.78,NULL,NULL,NULL,NULL),(14560,680,1163,126.29,NULL,NULL,NULL,NULL),(14561,681,0,40.828,NULL,NULL,NULL,NULL),(14562,681,3,48.851,NULL,NULL,NULL,NULL),(14563,681,3,54.704,NULL,NULL,NULL,NULL),(14564,681,10,63.977,NULL,NULL,NULL,NULL),(14565,681,54,77.597,NULL,NULL,NULL,NULL),(14566,681,92,87.515,NULL,NULL,NULL,NULL),(14567,681,170,98.328,NULL,NULL,NULL,NULL),(14568,681,240,95.114,NULL,NULL,NULL,NULL),(14569,681,390,96.531,NULL,NULL,NULL,NULL),(14570,681,517,98.295,NULL,NULL,NULL,NULL),(14571,681,742,100.04,NULL,NULL,NULL,NULL),(14572,681,1056,105.74,NULL,NULL,NULL,NULL),(14573,681,1183,108.35,NULL,NULL,NULL,NULL),(14574,682,0,108.76,NULL,NULL,NULL,NULL),(14575,682,2,117.95,NULL,NULL,NULL,NULL),(14576,682,6,123.01,NULL,NULL,NULL,NULL),(14577,682,17,123.63,NULL,NULL,NULL,NULL),(14578,682,71,124.24,NULL,NULL,NULL,NULL),(14579,682,126,132.64,NULL,NULL,NULL,NULL),(14580,682,173,134.59,NULL,NULL,NULL,NULL),(14581,682,251,132.39,NULL,NULL,NULL,NULL),(14582,682,409,133.6,NULL,NULL,NULL,NULL),(14583,682,532,134.56,NULL,NULL,NULL,NULL),(14584,682,852,132.33,NULL,NULL,NULL,NULL),(14585,682,1077,137.45,NULL,NULL,NULL,NULL),(14586,682,1289,137.41,NULL,NULL,NULL,NULL),(14587,683,0,75.752,NULL,NULL,NULL,NULL),(14588,683,2,83.702,NULL,NULL,NULL,NULL),(14589,683,7,88.641,NULL,NULL,NULL,NULL),(14590,683,25,94.168,NULL,NULL,NULL,NULL),(14591,683,70,95.676,NULL,NULL,NULL,NULL),(14592,683,123,101.43,NULL,NULL,NULL,NULL),(14593,683,201,103.86,NULL,NULL,NULL,NULL),(14594,683,282,102.17,NULL,NULL,NULL,NULL),(14595,683,417,107.97,NULL,NULL,NULL,NULL),(14596,683,541,107.91,NULL,NULL,NULL,NULL),(14597,683,748,108.65,NULL,NULL,NULL,NULL),(14598,683,971,113.16,NULL,NULL,NULL,NULL),(14599,683,1194,113.42,NULL,NULL,NULL,NULL),(14600,684,0,42.857,NULL,NULL,NULL,NULL),(14601,684,1,53.211,NULL,NULL,NULL,NULL),(14602,684,3,60.703,NULL,NULL,NULL,NULL),(14603,684,11,70.843,NULL,NULL,NULL,NULL),(14604,684,28,71.152,NULL,NULL,NULL,NULL),(14605,684,35,72.725,NULL,NULL,NULL,NULL),(14606,684,66,71.981,NULL,NULL,NULL,NULL),(14607,684,122,78.437,NULL,NULL,NULL,NULL),(14608,684,199,78.538,NULL,NULL,NULL,NULL),(14609,684,288,75.724,NULL,NULL,NULL,NULL),(14610,684,440,81.308,NULL,NULL,NULL,NULL),(14611,684,548,78.628,NULL,NULL,NULL,NULL),(14612,684,762,82.408,NULL,NULL,NULL,NULL),(14613,684,988,86.507,NULL,NULL,NULL,NULL),(14614,684,1219,88.185,NULL,NULL,NULL,NULL),(14615,685,0,33.354,NULL,NULL,NULL,NULL),(14616,685,2,32.84,NULL,NULL,NULL,NULL),(14617,685,3,35.189,NULL,NULL,NULL,NULL),(14618,685,9,36.821,NULL,NULL,NULL,NULL),(14619,685,58,38.573,NULL,NULL,NULL,NULL),(14620,685,91,46.379,NULL,NULL,NULL,NULL),(14621,685,171,45.844,NULL,NULL,NULL,NULL),(14622,685,252,42.52,NULL,NULL,NULL,NULL),(14623,685,390,50.026,NULL,NULL,NULL,NULL),(14624,685,504,48.148,NULL,NULL,NULL,NULL),(14625,685,734,51.413,NULL,NULL,NULL,NULL),(14626,685,955,53.079,NULL,NULL,NULL,NULL),(14627,686,0,170.7,NULL,NULL,NULL,NULL),(14628,686,1,203.9,NULL,NULL,NULL,NULL),(14629,686,2,215.1,NULL,NULL,NULL,NULL),(14630,686,3,222,NULL,NULL,NULL,NULL),(14631,686,7,235.9,NULL,NULL,NULL,NULL),(14632,686,20,248.1,NULL,NULL,NULL,NULL),(14633,686,52,258,NULL,NULL,NULL,NULL),(14634,686,123,263.6,NULL,NULL,NULL,NULL),(14635,686,157,260.8,NULL,NULL,NULL,NULL),(14636,686,179,265.7,NULL,NULL,NULL,NULL),(14637,686,229,265.7,NULL,NULL,NULL,NULL),(14638,686,371,269.7,NULL,NULL,NULL,NULL),(14639,686,466,260.8,NULL,NULL,NULL,NULL),(14640,686,613,267.6,NULL,NULL,NULL,NULL),(14641,686,742,269,NULL,NULL,NULL,NULL),(14642,686,958,270,NULL,NULL,NULL,NULL),(14643,686,1331,270.6,NULL,NULL,NULL,NULL),(14644,687,0,118.7,NULL,NULL,NULL,NULL),(14645,687,3,145.7,NULL,NULL,NULL,NULL),(14646,687,7,159.7,NULL,NULL,NULL,NULL),(14647,687,27,174.7,NULL,NULL,NULL,NULL),(14648,687,60,181.8,NULL,NULL,NULL,NULL),(14649,687,120,184.5,NULL,NULL,NULL,NULL),(14650,687,154,186,NULL,NULL,NULL,NULL),(14651,687,181,183.8,NULL,NULL,NULL,NULL),(14652,687,240,188.6,NULL,NULL,NULL,NULL),(14653,687,383,190.7,NULL,NULL,NULL,NULL),(14654,687,472,190.8,NULL,NULL,NULL,NULL),(14655,687,615,191.7,NULL,NULL,NULL,NULL),(14656,687,738,190.5,NULL,NULL,NULL,NULL),(14657,687,944,189.8,NULL,NULL,NULL,NULL),(14658,687,1361,193,NULL,NULL,NULL,NULL),(14659,688,0,54.88,NULL,NULL,NULL,NULL),(14660,688,3,81.6,NULL,NULL,NULL,NULL),(14661,688,7,88.29,NULL,NULL,NULL,NULL),(14662,688,34,103.6,NULL,NULL,NULL,NULL),(14663,688,67,109.2,NULL,NULL,NULL,NULL),(14664,688,126,112.3,NULL,NULL,NULL,NULL),(14665,688,160,112.3,NULL,NULL,NULL,NULL),(14666,688,190,109.9,NULL,NULL,NULL,NULL),(14667,688,243,111.5,NULL,NULL,NULL,NULL),(14668,688,384,120.3,NULL,NULL,NULL,NULL),(14669,688,492,115.3,NULL,NULL,NULL,NULL),(14670,688,623,116.2,NULL,NULL,NULL,NULL),(14671,688,748,115.9,NULL,NULL,NULL,NULL),(14672,688,984,116.1,NULL,NULL,NULL,NULL),(14673,688,1330,114.9,NULL,NULL,NULL,NULL),(14674,688,1366,112.9,NULL,NULL,NULL,NULL),(14675,689,0,37.45,NULL,NULL,NULL,NULL),(14676,689,2,45.87,NULL,NULL,NULL,NULL),(14677,689,5,48.02,NULL,NULL,NULL,NULL),(14678,689,13,53.85,NULL,NULL,NULL,NULL),(14679,689,15,54.99,NULL,NULL,NULL,NULL),(14680,689,101,59.01,NULL,NULL,NULL,NULL),(14681,689,138,58.59,NULL,NULL,NULL,NULL),(14682,689,159,57.6,NULL,NULL,NULL,NULL),(14683,689,215,61.01,NULL,NULL,NULL,NULL),(14684,689,394,65.84,NULL,NULL,NULL,NULL),(14685,689,451,63.3,NULL,NULL,NULL,NULL),(14686,689,594,65.71,NULL,NULL,NULL,NULL),(14687,689,739,64.02,NULL,NULL,NULL,NULL),(14688,689,980,65.58,NULL,NULL,NULL,NULL),(14689,689,1326,69.56,NULL,NULL,NULL,NULL),(14690,689,1375,68.43,NULL,NULL,NULL,NULL),(14691,690,0,126.9,NULL,NULL,NULL,NULL),(14692,690,2,133.9,NULL,NULL,NULL,NULL),(14693,690,13,145.9,NULL,NULL,NULL,NULL),(14694,690,17,147.7,NULL,NULL,NULL,NULL),(14695,690,80,149.7,NULL,NULL,NULL,NULL),(14696,690,108,150.7,NULL,NULL,NULL,NULL),(14697,690,169,151.7,NULL,NULL,NULL,NULL),(14698,690,276,150.8,NULL,NULL,NULL,NULL),(14699,690,429,154.7,NULL,NULL,NULL,NULL),(14700,690,585,151.8,NULL,NULL,NULL,NULL),(14701,690,749,155.7,NULL,NULL,NULL,NULL),(14702,690,875,153.8,NULL,NULL,NULL,NULL),(14703,690,1080,155.8,NULL,NULL,NULL,NULL),(14704,690,1369,157.6,NULL,NULL,NULL,NULL),(14705,690,1556,161.7,NULL,NULL,NULL,NULL),(14706,691,0,89.04,NULL,NULL,NULL,NULL),(14707,691,3,105.7,NULL,NULL,NULL,NULL),(14708,691,7,114.7,NULL,NULL,NULL,NULL),(14709,691,27,119.7,NULL,NULL,NULL,NULL),(14710,691,61,120.5,NULL,NULL,NULL,NULL),(14711,691,88,125.6,NULL,NULL,NULL,NULL),(14712,691,149,128.8,NULL,NULL,NULL,NULL),(14713,691,257,130.6,NULL,NULL,NULL,NULL),(14714,691,418,131.6,NULL,NULL,NULL,NULL),(14715,691,575,128.7,NULL,NULL,NULL,NULL),(14716,691,777,132.6,NULL,NULL,NULL,NULL),(14717,691,891,131.8,NULL,NULL,NULL,NULL),(14718,691,1182,133.8,NULL,NULL,NULL,NULL),(14719,691,1356,138.5,NULL,NULL,NULL,NULL),(14720,692,0,42.88,NULL,NULL,NULL,NULL),(14721,692,1,47.57,NULL,NULL,NULL,NULL),(14722,692,2,51.4,NULL,NULL,NULL,NULL),(14723,692,6,56.53,NULL,NULL,NULL,NULL),(14724,692,13,61.37,NULL,NULL,NULL,NULL),(14725,692,17,62.37,NULL,NULL,NULL,NULL),(14726,692,67,71.19,NULL,NULL,NULL,NULL),(14727,692,95,72.19,NULL,NULL,NULL,NULL),(14728,692,157,72.34,NULL,NULL,NULL,NULL),(14729,692,260,73.35,NULL,NULL,NULL,NULL),(14730,692,423,76.2,NULL,NULL,NULL,NULL),(14731,692,577,72.23,NULL,NULL,NULL,NULL),(14732,692,668,77.34,NULL,NULL,NULL,NULL),(14733,692,780,74.23,NULL,NULL,NULL,NULL),(14734,692,895,77.49,NULL,NULL,NULL,NULL),(14735,692,1188,80.9,NULL,NULL,NULL,NULL),(14736,692,1375,86.57,NULL,NULL,NULL,NULL),(14737,693,0,28.24,NULL,NULL,NULL,NULL),(14738,693,1,30.11,NULL,NULL,NULL,NULL),(14739,693,2,35.1,NULL,NULL,NULL,NULL),(14740,693,27,43.1,NULL,NULL,NULL,NULL),(14741,693,58,43.68,NULL,NULL,NULL,NULL),(14742,693,112,46.25,NULL,NULL,NULL,NULL),(14743,693,140,47.39,NULL,NULL,NULL,NULL),(14744,693,198,48.81,NULL,NULL,NULL,NULL),(14745,693,307,52.51,NULL,NULL,NULL,NULL),(14746,693,527,51.53,NULL,NULL,NULL,NULL),(14747,693,615,54.8,NULL,NULL,NULL,NULL),(14748,693,766,56.79,NULL,NULL,NULL,NULL),(14749,693,878,56.51,NULL,NULL,NULL,NULL),(14750,693,1074,58.64,NULL,NULL,NULL,NULL),(14751,693,1325,60.35,NULL,NULL,NULL,NULL),(14752,693,1533,62.9,NULL,NULL,NULL,NULL),(14753,694,0,91.95,NULL,NULL,NULL,NULL),(14754,694,1,110.9,NULL,NULL,NULL,NULL),(14755,694,3,123.7,NULL,NULL,NULL,NULL),(14756,694,6,129.9,NULL,NULL,NULL,NULL),(14757,694,13,137.3,NULL,NULL,NULL,NULL),(14758,694,42,145.9,NULL,NULL,NULL,NULL),(14759,694,70,147.3,NULL,NULL,NULL,NULL),(14760,694,153,149.4,NULL,NULL,NULL,NULL),(14761,694,309,150.1,NULL,NULL,NULL,NULL),(14762,694,360,150.5,NULL,NULL,NULL,NULL),(14763,694,553,153.9,NULL,NULL,NULL,NULL),(14764,694,686,153.2,NULL,NULL,NULL,NULL),(14765,694,1036,153.5,NULL,NULL,NULL,NULL),(14766,695,0,97.01,NULL,NULL,NULL,NULL),(14767,695,2,105.4,NULL,NULL,NULL,NULL),(14768,695,6,117.2,NULL,NULL,NULL,NULL),(14769,695,26,126.6,NULL,NULL,NULL,NULL),(14770,695,56,133.2,NULL,NULL,NULL,NULL),(14771,695,87,134.5,NULL,NULL,NULL,NULL),(14772,695,158,135.6,NULL,NULL,NULL,NULL),(14773,695,319,137.8,NULL,NULL,NULL,NULL),(14774,695,372,137.6,NULL,NULL,NULL,NULL),(14775,695,578,143,NULL,NULL,NULL,NULL),(14776,695,717,143.5,NULL,NULL,NULL,NULL),(14777,695,1082,144.6,NULL,NULL,NULL,NULL),(14778,696,0,45.45,NULL,NULL,NULL,NULL),(14779,696,1,53.83,NULL,NULL,NULL,NULL),(14780,696,3,62.86,NULL,NULL,NULL,NULL),(14781,696,18,74.24,NULL,NULL,NULL,NULL),(14782,696,49,79.52,NULL,NULL,NULL,NULL),(14783,696,78,78.24,NULL,NULL,NULL,NULL),(14784,696,154,78.58,NULL,NULL,NULL,NULL),(14785,696,316,79.81,NULL,NULL,NULL,NULL),(14786,696,378,76.49,NULL,NULL,NULL,NULL),(14787,696,571,79.9,NULL,NULL,NULL,NULL),(14788,696,689,81.36,NULL,NULL,NULL,NULL),(14789,696,1129,81.7,NULL,NULL,NULL,NULL),(14790,697,0,37,NULL,NULL,NULL,NULL),(14791,697,1,38.39,NULL,NULL,NULL,NULL),(14792,697,5,40.19,NULL,NULL,NULL,NULL),(14793,697,12,43.93,NULL,NULL,NULL,NULL),(14794,697,41,45.66,NULL,NULL,NULL,NULL),(14795,697,120,47.95,NULL,NULL,NULL,NULL),(14796,697,274,49.34,NULL,NULL,NULL,NULL),(14797,697,343,50.48,NULL,NULL,NULL,NULL),(14798,697,543,53.08,NULL,NULL,NULL,NULL),(14799,697,693,54.14,NULL,NULL,NULL,NULL),(14800,697,1115,55.77,NULL,NULL,NULL,NULL),(14801,698,0,82.15,NULL,NULL,NULL,NULL),(14802,698,1,93.05,NULL,NULL,NULL,NULL),(14803,698,3,100.8,NULL,NULL,NULL,NULL),(14804,698,18,103.1,NULL,NULL,NULL,NULL),(14805,698,72,113.1,NULL,NULL,NULL,NULL),(14806,698,150,113,NULL,NULL,NULL,NULL),(14807,698,238,109.9,NULL,NULL,NULL,NULL),(14808,698,362,112.5,NULL,NULL,NULL,NULL),(14809,698,478,110.5,NULL,NULL,NULL,NULL),(14810,698,684,113.1,NULL,NULL,NULL,NULL),(14811,698,928,110.6,NULL,NULL,NULL,NULL),(14812,698,1131,112.6,NULL,NULL,NULL,NULL),(14813,699,0,56.31,NULL,NULL,NULL,NULL),(14814,699,1,63.32,NULL,NULL,NULL,NULL),(14815,699,2,68.2,NULL,NULL,NULL,NULL),(14816,699,11,76.57,NULL,NULL,NULL,NULL),(14817,699,31,75.87,NULL,NULL,NULL,NULL),(14818,699,85,76.94,NULL,NULL,NULL,NULL),(14819,699,163,80.76,NULL,NULL,NULL,NULL),(14820,699,248,79.07,NULL,NULL,NULL,NULL),(14821,699,334,79.97,NULL,NULL,NULL,NULL),(14822,699,469,76.57,NULL,NULL,NULL,NULL),(14823,699,708,82.9,NULL,NULL,NULL,NULL),(14824,699,1160,83.48,NULL,NULL,NULL,NULL),(14825,700,0,42.14,NULL,NULL,NULL,NULL),(14826,700,1,49.47,NULL,NULL,NULL,NULL),(14827,700,2,52.57,NULL,NULL,NULL,NULL),(14828,700,6,59.39,NULL,NULL,NULL,NULL),(14829,700,16,60.95,NULL,NULL,NULL,NULL),(14830,700,23,57.55,NULL,NULL,NULL,NULL),(14831,700,77,60.49,NULL,NULL,NULL,NULL),(14832,700,156,64.64,NULL,NULL,NULL,NULL),(14833,700,243,60.28,NULL,NULL,NULL,NULL),(14834,700,374,64.17,NULL,NULL,NULL,NULL),(14835,700,485,61.1,NULL,NULL,NULL,NULL),(14836,700,708,67.99,NULL,NULL,NULL,NULL),(14837,700,960,68.08,NULL,NULL,NULL,NULL),(14838,700,1169,69.22,NULL,NULL,NULL,NULL),(14839,701,0,24.69,NULL,NULL,NULL,NULL),(14840,701,1,25.35,NULL,NULL,NULL,NULL),(14841,701,5,26.99,NULL,NULL,NULL,NULL),(14842,701,41,31.8,NULL,NULL,NULL,NULL),(14843,701,120,34.74,NULL,NULL,NULL,NULL),(14844,701,276,33.46,NULL,NULL,NULL,NULL),(14845,701,340,34.6,NULL,NULL,NULL,NULL),(14846,701,543,32.99,NULL,NULL,NULL,NULL),(14847,701,680,34.13,NULL,NULL,NULL,NULL),(14848,701,939,34.22,NULL,NULL,NULL,NULL),(14849,701,1144,35.76,NULL,NULL,NULL,NULL),(14850,702,0,192.82,NULL,NULL,NULL,NULL),(14851,702,1,216.27,NULL,NULL,NULL,NULL),(14852,702,3,226.58,NULL,NULL,NULL,NULL),(14853,702,4,228.37,NULL,NULL,NULL,NULL),(14854,702,17,245.24,NULL,NULL,NULL,NULL),(14855,702,45,249.05,NULL,NULL,NULL,NULL),(14856,702,74,251.55,NULL,NULL,NULL,NULL),(14857,702,107,251.9,NULL,NULL,NULL,NULL),(14858,702,292,253.99,NULL,NULL,NULL,NULL),(14859,702,359,252.99,NULL,NULL,NULL,NULL),(14860,702,545,256.92,NULL,NULL,NULL,NULL),(14861,702,677,255.25,NULL,NULL,NULL,NULL),(14862,702,1040,255.49,NULL,NULL,NULL,NULL),(14863,703,0,106.7,NULL,NULL,NULL,NULL),(14864,703,2,119.78,NULL,NULL,NULL,NULL),(14865,703,5,125.89,NULL,NULL,NULL,NULL),(14866,703,23,136.54,NULL,NULL,NULL,NULL),(14867,703,26,137.89,NULL,NULL,NULL,NULL),(14868,703,51,138.98,NULL,NULL,NULL,NULL),(14869,703,80,142.12,NULL,NULL,NULL,NULL),(14870,703,113,142.87,NULL,NULL,NULL,NULL),(14871,703,294,144.81,NULL,NULL,NULL,NULL),(14872,703,358,144.86,NULL,NULL,NULL,NULL),(14873,703,561,145.23,NULL,NULL,NULL,NULL),(14874,703,663,147.52,NULL,NULL,NULL,NULL),(14875,703,1086,148.3,NULL,NULL,NULL,NULL),(14876,704,0,58.057,NULL,NULL,NULL,NULL),(14877,704,2,65.035,NULL,NULL,NULL,NULL),(14878,704,13,78.253,NULL,NULL,NULL,NULL),(14879,704,31,84.928,NULL,NULL,NULL,NULL),(14880,704,65,86.559,NULL,NULL,NULL,NULL),(14881,704,73,88.04,NULL,NULL,NULL,NULL),(14882,704,154,86.896,NULL,NULL,NULL,NULL),(14883,704,294,88.241,NULL,NULL,NULL,NULL),(14884,704,428,90.842,NULL,NULL,NULL,NULL),(14885,704,646,92.924,NULL,NULL,NULL,NULL),(14886,704,1058,93.571,NULL,NULL,NULL,NULL),(14887,705,0,36,NULL,NULL,NULL,NULL),(14888,705,1,40,NULL,NULL,NULL,NULL),(14889,705,3,42,NULL,NULL,NULL,NULL),(14890,705,7,46,NULL,NULL,NULL,NULL),(14891,705,24,49,NULL,NULL,NULL,NULL),(14892,705,53,52,NULL,NULL,NULL,NULL),(14893,705,88,52,NULL,NULL,NULL,NULL),(14894,705,298,55,NULL,NULL,NULL,NULL),(14895,705,360,57,NULL,NULL,NULL,NULL),(14896,705,564,57,NULL,NULL,NULL,NULL),(14897,705,696,59,NULL,NULL,NULL,NULL),(14898,705,1053,62,NULL,NULL,NULL,NULL),(14899,706,0,102.86,NULL,NULL,NULL,NULL),(14900,706,2,109.74,NULL,NULL,NULL,NULL),(14901,706,16,117.69,NULL,NULL,NULL,NULL),(14902,706,44,120.83,NULL,NULL,NULL,NULL),(14903,706,73,122.54,NULL,NULL,NULL,NULL),(14904,706,107,125.27,NULL,NULL,NULL,NULL),(14905,706,286,121.81,NULL,NULL,NULL,NULL),(14906,706,351,124.63,NULL,NULL,NULL,NULL),(14907,706,547,121.7,NULL,NULL,NULL,NULL),(14908,706,673,130.74,NULL,NULL,NULL,NULL),(14909,706,913,130.68,NULL,NULL,NULL,NULL),(14910,706,1122,130.6,NULL,NULL,NULL,NULL),(14911,707,0,63.077,NULL,NULL,NULL,NULL),(14912,707,2,68.893,NULL,NULL,NULL,NULL),(14913,707,9,73.94,NULL,NULL,NULL,NULL),(14914,707,23,76.266,NULL,NULL,NULL,NULL),(14915,707,50,78.963,NULL,NULL,NULL,NULL),(14916,707,80,78.545,NULL,NULL,NULL,NULL),(14917,707,115,81.01,NULL,NULL,NULL,NULL),(14918,707,299,79.785,NULL,NULL,NULL,NULL),(14919,707,358,80.753,NULL,NULL,NULL,NULL),(14920,707,561,79.011,NULL,NULL,NULL,NULL),(14921,707,675,83.153,NULL,NULL,NULL,NULL),(14922,707,933,82.174,NULL,NULL,NULL,NULL),(14923,707,1137,82.486,NULL,NULL,NULL,NULL),(14924,708,0,47.749,NULL,NULL,NULL,NULL),(14925,708,2,60.936,NULL,NULL,NULL,NULL),(14926,708,13,58.558,NULL,NULL,NULL,NULL),(14927,708,31,65.235,NULL,NULL,NULL,NULL),(14928,708,65,68.053,NULL,NULL,NULL,NULL),(14929,708,74,67.951,NULL,NULL,NULL,NULL),(14930,708,154,65.747,NULL,NULL,NULL,NULL),(14931,708,307,71.464,NULL,NULL,NULL,NULL),(14932,708,437,65.733,NULL,NULL,NULL,NULL),(14933,708,638,74.945,NULL,NULL,NULL,NULL),(14934,708,892,71.456,NULL,NULL,NULL,NULL),(14935,708,1097,70.977,NULL,NULL,NULL,NULL),(14936,709,0,20.883,NULL,NULL,NULL,NULL),(14937,709,1,23.556,NULL,NULL,NULL,NULL),(14938,709,3,25.906,NULL,NULL,NULL,NULL),(14939,709,7,26.404,NULL,NULL,NULL,NULL),(14940,709,24,29.475,NULL,NULL,NULL,NULL),(14941,709,53,30.727,NULL,NULL,NULL,NULL),(14942,709,88,32.83,NULL,NULL,NULL,NULL),(14943,709,298,32.331,NULL,NULL,NULL,NULL),(14944,709,360,33.83,NULL,NULL,NULL,NULL),(14945,709,564,31.955,NULL,NULL,NULL,NULL),(14946,709,696,36.5,NULL,NULL,NULL,NULL),(14947,709,953,35.915,NULL,NULL,NULL,NULL),(14948,710,0,144.2,NULL,NULL,NULL,NULL),(14949,710,1,173.1,NULL,NULL,NULL,NULL),(14950,710,4,184.8,NULL,NULL,NULL,NULL),(14951,710,7,199,NULL,NULL,NULL,NULL),(14952,710,17,208.8,NULL,NULL,NULL,NULL),(14953,710,32,213.9,NULL,NULL,NULL,NULL),(14954,710,96,215.8,NULL,NULL,NULL,NULL),(14955,710,139,217.9,NULL,NULL,NULL,NULL),(14956,710,200,220.7,NULL,NULL,NULL,NULL),(14957,710,368,219.8,NULL,NULL,NULL,NULL),(14958,710,452,219.8,NULL,NULL,NULL,NULL),(14959,710,597,218,NULL,NULL,NULL,NULL),(14960,710,747,220,NULL,NULL,NULL,NULL),(14961,710,927,221.8,NULL,NULL,NULL,NULL),(14962,710,1256,221.2,NULL,NULL,NULL,NULL),(14963,711,0,63.07,NULL,NULL,NULL,NULL),(14964,711,1,72.34,NULL,NULL,NULL,NULL),(14965,711,3,82.33,NULL,NULL,NULL,NULL),(14966,711,5,90.99,NULL,NULL,NULL,NULL),(14967,711,7,95.09,NULL,NULL,NULL,NULL),(14968,711,10,97.73,NULL,NULL,NULL,NULL),(14969,711,25,109.4,NULL,NULL,NULL,NULL),(14970,711,87,114.8,NULL,NULL,NULL,NULL),(14971,711,131,114.2,NULL,NULL,NULL,NULL),(14972,711,193,116.4,NULL,NULL,NULL,NULL),(14973,711,369,117.5,NULL,NULL,NULL,NULL),(14974,711,453,118.3,NULL,NULL,NULL,NULL),(14975,711,587,117.5,NULL,NULL,NULL,NULL),(14976,711,722,117.8,NULL,NULL,NULL,NULL),(14977,711,937,120.4,NULL,NULL,NULL,NULL),(14978,711,1388,116.9,NULL,NULL,NULL,NULL),(14979,712,0,54.04,NULL,NULL,NULL,NULL),(14980,712,2,63.55,NULL,NULL,NULL,NULL),(14981,712,6,69.45,NULL,NULL,NULL,NULL),(14982,712,27,77.75,NULL,NULL,NULL,NULL),(14983,712,37,82.21,NULL,NULL,NULL,NULL),(14984,712,90,84.73,NULL,NULL,NULL,NULL),(14985,712,254,86.78,NULL,NULL,NULL,NULL),(14986,712,330,86.9,NULL,NULL,NULL,NULL),(14987,712,481,86.06,NULL,NULL,NULL,NULL),(14988,712,613,86.9,NULL,NULL,NULL,NULL),(14989,712,943,88.1,NULL,NULL,NULL,NULL),(14990,712,1350,89.79,NULL,NULL,NULL,NULL),(14991,713,0,24.67,NULL,NULL,NULL,NULL),(14992,713,2,27.8,NULL,NULL,NULL,NULL),(14993,713,4,29.49,NULL,NULL,NULL,NULL),(14994,713,60,31.53,NULL,NULL,NULL,NULL),(14995,713,223,44.29,NULL,NULL,NULL,NULL),(14996,713,325,44.29,NULL,NULL,NULL,NULL),(14997,713,445,44.05,NULL,NULL,NULL,NULL),(14998,713,562,44.65,NULL,NULL,NULL,NULL),(14999,713,791,45.98,NULL,NULL,NULL,NULL),(15000,713,1122,47.78,NULL,NULL,NULL,NULL),(15001,713,1227,45.74,NULL,NULL,NULL,NULL),(15002,714,0,85.7,NULL,NULL,NULL,NULL),(15003,714,1,108.4,NULL,NULL,NULL,NULL),(15004,714,2,120.5,NULL,NULL,NULL,NULL),(15005,714,7,126.4,NULL,NULL,NULL,NULL),(15006,714,45,131.3,NULL,NULL,NULL,NULL),(15007,714,73,135.3,NULL,NULL,NULL,NULL),(15008,714,125,138.3,NULL,NULL,NULL,NULL),(15009,714,153,139.3,NULL,NULL,NULL,NULL),(15010,714,213,140.2,NULL,NULL,NULL,NULL),(15011,714,325,140.2,NULL,NULL,NULL,NULL),(15012,714,448,140.3,NULL,NULL,NULL,NULL),(15013,714,541,139.3,NULL,NULL,NULL,NULL),(15014,714,729,147.4,NULL,NULL,NULL,NULL),(15015,714,839,139.3,NULL,NULL,NULL,NULL),(15016,714,1081,146.1,NULL,NULL,NULL,NULL),(15017,714,1236,146.4,NULL,NULL,NULL,NULL),(15018,714,1452,145.6,NULL,NULL,NULL,NULL),(15019,715,0,79.44,NULL,NULL,NULL,NULL),(15020,715,1,81.48,NULL,NULL,NULL,NULL),(15021,715,14,91.35,NULL,NULL,NULL,NULL),(15022,715,18,93.28,NULL,NULL,NULL,NULL),(15023,715,54,95.09,NULL,NULL,NULL,NULL),(15024,715,83,97.73,NULL,NULL,NULL,NULL),(15025,715,144,98.34,NULL,NULL,NULL,NULL),(15026,715,253,98.21,NULL,NULL,NULL,NULL),(15027,715,416,99.3,NULL,NULL,NULL,NULL),(15028,715,512,98.21,NULL,NULL,NULL,NULL),(15029,715,654,102.3,NULL,NULL,NULL,NULL),(15030,715,781,97.25,NULL,NULL,NULL,NULL),(15031,715,997,102.3,NULL,NULL,NULL,NULL),(15032,715,1183,102.3,NULL,NULL,NULL,NULL),(15033,715,1377,101.6,NULL,NULL,NULL,NULL),(15034,716,0,41.16,NULL,NULL,NULL,NULL),(15035,716,3,58.86,NULL,NULL,NULL,NULL),(15036,716,7,64.03,NULL,NULL,NULL,NULL),(15037,716,41,71.13,NULL,NULL,NULL,NULL),(15038,716,72,78.23,NULL,NULL,NULL,NULL),(15039,716,129,81,NULL,NULL,NULL,NULL),(15040,716,200,81.12,NULL,NULL,NULL,NULL),(15041,716,259,81.24,NULL,NULL,NULL,NULL),(15042,716,406,84.49,NULL,NULL,NULL,NULL),(15043,716,490,82.33,NULL,NULL,NULL,NULL),(15044,716,636,86.18,NULL,NULL,NULL,NULL),(15045,716,772,77.27,NULL,NULL,NULL,NULL),(15046,716,985,82.57,NULL,NULL,NULL,NULL),(15047,716,1168,83.05,NULL,NULL,NULL,NULL),(15048,716,1385,85.46,NULL,NULL,NULL,NULL),(15049,717,0,20.7,NULL,NULL,NULL,NULL),(15050,717,2,29.49,NULL,NULL,NULL,NULL),(15051,717,6,30.45,NULL,NULL,NULL,NULL),(15052,717,37,36.47,NULL,NULL,NULL,NULL),(15053,717,65,37.67,NULL,NULL,NULL,NULL),(15054,717,116,38.27,NULL,NULL,NULL,NULL),(15055,717,146,38.76,NULL,NULL,NULL,NULL),(15056,717,207,40.8,NULL,NULL,NULL,NULL),(15057,717,316,42.25,NULL,NULL,NULL,NULL),(15058,717,474,42.97,NULL,NULL,NULL,NULL),(15059,717,567,41.77,NULL,NULL,NULL,NULL),(15060,717,729,44.77,NULL,NULL,NULL,NULL),(15061,717,841,41.89,NULL,NULL,NULL,NULL),(15062,717,1053,44.29,NULL,NULL,NULL,NULL),(15063,717,1295,46.82,NULL,NULL,NULL,NULL),(15064,717,1392,48.51,NULL,NULL,NULL,NULL),(15065,718,0,90.54,NULL,NULL,NULL,NULL),(15066,718,1,124.3,NULL,NULL,NULL,NULL),(15067,718,3,138.1,NULL,NULL,NULL,NULL),(15068,718,27,156.5,NULL,NULL,NULL,NULL),(15069,718,50,160.2,NULL,NULL,NULL,NULL),(15070,718,58,162.4,NULL,NULL,NULL,NULL),(15071,718,138,164.4,NULL,NULL,NULL,NULL),(15072,718,285,167.6,NULL,NULL,NULL,NULL),(15073,718,404,168,NULL,NULL,NULL,NULL),(15074,718,603,174.1,NULL,NULL,NULL,NULL),(15075,718,933,169.8,NULL,NULL,NULL,NULL),(15076,719,0,63.12,NULL,NULL,NULL,NULL),(15077,719,1,81.66,NULL,NULL,NULL,NULL),(15078,719,3,92.67,NULL,NULL,NULL,NULL),(15079,719,7,102.5,NULL,NULL,NULL,NULL),(15080,719,10,104.8,NULL,NULL,NULL,NULL),(15081,719,20,108.6,NULL,NULL,NULL,NULL),(15082,719,47,113.6,NULL,NULL,NULL,NULL),(15083,719,72,114,NULL,NULL,NULL,NULL),(15084,719,78,115.7,NULL,NULL,NULL,NULL),(15085,719,154,116.9,NULL,NULL,NULL,NULL),(15086,719,296,119,NULL,NULL,NULL,NULL),(15087,719,412,119.9,NULL,NULL,NULL,NULL),(15088,719,626,123,NULL,NULL,NULL,NULL),(15089,719,960,121.6,NULL,NULL,NULL,NULL),(15090,719,1075,122.6,NULL,NULL,NULL,NULL),(15091,720,0,64.12,NULL,NULL,NULL,NULL),(15092,720,2,79.28,NULL,NULL,NULL,NULL),(15093,720,6,88.85,NULL,NULL,NULL,NULL),(15094,720,30,99.71,NULL,NULL,NULL,NULL),(15095,720,39,105.8,NULL,NULL,NULL,NULL),(15096,720,152,107.2,NULL,NULL,NULL,NULL),(15097,720,285,114.7,NULL,NULL,NULL,NULL),(15098,720,401,114.1,NULL,NULL,NULL,NULL),(15099,720,614,118.9,NULL,NULL,NULL,NULL),(15100,720,943,116.7,NULL,NULL,NULL,NULL),(15101,720,1075,117.4,NULL,NULL,NULL,NULL),(15102,721,0,32.75,NULL,NULL,NULL,NULL),(15103,721,2,34.95,NULL,NULL,NULL,NULL),(15104,721,6,37.51,NULL,NULL,NULL,NULL),(15105,721,20,42.33,NULL,NULL,NULL,NULL),(15106,721,45,45.15,NULL,NULL,NULL,NULL),(15107,721,51,48.13,NULL,NULL,NULL,NULL),(15108,721,130,51.67,NULL,NULL,NULL,NULL),(15109,721,278,56.21,NULL,NULL,NULL,NULL),(15110,721,431,56.59,NULL,NULL,NULL,NULL),(15111,721,616,59.48,NULL,NULL,NULL,NULL),(15112,721,945,59.05,NULL,NULL,NULL,NULL),(15113,721,1078,60.14,NULL,NULL,NULL,NULL),(15114,722,0,69.86,NULL,NULL,NULL,NULL),(15115,722,1,86.42,NULL,NULL,NULL,NULL),(15116,722,3,91.5,NULL,NULL,NULL,NULL),(15117,722,27,103.1,NULL,NULL,NULL,NULL),(15118,722,51,106.2,NULL,NULL,NULL,NULL),(15119,722,58,106.1,NULL,NULL,NULL,NULL),(15120,722,140,102.7,NULL,NULL,NULL,NULL),(15121,722,281,110.7,NULL,NULL,NULL,NULL),(15122,722,398,103.2,NULL,NULL,NULL,NULL),(15123,722,616,112,NULL,NULL,NULL,NULL),(15124,722,865,109.3,NULL,NULL,NULL,NULL),(15125,722,1076,108.6,NULL,NULL,NULL,NULL),(15126,723,0,53.51,NULL,NULL,NULL,NULL),(15127,723,2,55.27,NULL,NULL,NULL,NULL),(15128,723,9,60.18,NULL,NULL,NULL,NULL),(15129,723,20,60.22,NULL,NULL,NULL,NULL),(15130,723,47,61.61,NULL,NULL,NULL,NULL),(15131,723,72,62.71,NULL,NULL,NULL,NULL),(15132,723,78,63.07,NULL,NULL,NULL,NULL),(15133,723,153,62.74,NULL,NULL,NULL,NULL),(15134,723,303,65.56,NULL,NULL,NULL,NULL),(15135,723,416,63.33,NULL,NULL,NULL,NULL),(15136,723,632,67.66,NULL,NULL,NULL,NULL),(15137,723,913,63.45,NULL,NULL,NULL,NULL),(15138,723,1096,64.99,NULL,NULL,NULL,NULL),(15139,724,0,41.29,NULL,NULL,NULL,NULL),(15140,724,2,43.14,NULL,NULL,NULL,NULL),(15141,724,6,50.91,NULL,NULL,NULL,NULL),(15142,724,31,56.82,NULL,NULL,NULL,NULL),(15143,724,40,53.78,NULL,NULL,NULL,NULL),(15144,724,153,53.93,NULL,NULL,NULL,NULL),(15145,724,293,60.43,NULL,NULL,NULL,NULL),(15146,724,409,54.88,NULL,NULL,NULL,NULL),(15147,724,644,60.83,NULL,NULL,NULL,NULL),(15148,724,881,58.96,NULL,NULL,NULL,NULL),(15149,724,1097,59.87,NULL,NULL,NULL,NULL),(15150,725,0,24.11,NULL,NULL,NULL,NULL),(15151,725,2,25.42,NULL,NULL,NULL,NULL),(15152,725,6,25.46,NULL,NULL,NULL,NULL),(15153,725,20,29.92,NULL,NULL,NULL,NULL),(15154,725,44,32.11,NULL,NULL,NULL,NULL),(15155,725,51,32.48,NULL,NULL,NULL,NULL),(15156,725,130,33.96,NULL,NULL,NULL,NULL),(15157,725,276,33.1,NULL,NULL,NULL,NULL),(15158,725,416,34.29,NULL,NULL,NULL,NULL),(15159,725,606,38.62,NULL,NULL,NULL,NULL),(15160,725,860,38.55,NULL,NULL,NULL,NULL),(15161,725,1051,38.83,NULL,NULL,NULL,NULL),(15162,726,0.2,47.1,NULL,NULL,NULL,NULL),(15163,726,0.5,52.5,NULL,NULL,NULL,NULL),(15164,726,0.7,54.4,NULL,NULL,NULL,NULL),(15165,726,1,56.3,NULL,NULL,NULL,NULL),(15166,726,2,59.8,NULL,NULL,NULL,NULL),(15167,726,3,64.8,NULL,NULL,NULL,NULL),(15168,726,4,65.2,NULL,NULL,NULL,NULL),(15169,726,5,67.6,NULL,NULL,NULL,NULL),(15170,726,6,69.5,NULL,NULL,NULL,NULL),(15171,726,7,70.5,NULL,NULL,NULL,NULL),(15172,726,8,71.4,NULL,NULL,NULL,NULL),(15173,726,9,73.3,NULL,NULL,NULL,NULL),(15174,726,14,77.1,NULL,NULL,NULL,NULL),(15175,726,20,80.9,NULL,NULL,NULL,NULL),(15176,726,30,85.6,NULL,NULL,NULL,NULL),(15177,726,40,88.1,NULL,NULL,NULL,NULL),(15178,726,50,90.9,NULL,NULL,NULL,NULL),(15179,726,60,91.8,NULL,NULL,NULL,NULL),(15180,726,70,94.7,NULL,NULL,NULL,NULL),(15181,727,0.31,32.1,NULL,NULL,NULL,NULL),(15182,727,0.61,34,NULL,NULL,NULL,NULL),(15183,727,0.81,35,NULL,NULL,NULL,NULL),(15184,727,1.11,35.9,NULL,NULL,NULL,NULL),(15185,727,2.11,37.8,NULL,NULL,NULL,NULL),(15186,727,3.11,38.7,NULL,NULL,NULL,NULL),(15187,727,4.11,39.7,NULL,NULL,NULL,NULL),(15188,727,5.11,40.6,NULL,NULL,NULL,NULL),(15189,727,6.11,41.6,NULL,NULL,NULL,NULL),(15190,727,7.11,42.1,NULL,NULL,NULL,NULL),(15191,727,8.11,42.1,NULL,NULL,NULL,NULL),(15192,727,9.11,43.5,NULL,NULL,NULL,NULL),(15193,727,14.11,45.4,NULL,NULL,NULL,NULL),(15194,727,20.11,45.9,NULL,NULL,NULL,NULL),(15195,727,30.11,47.8,NULL,NULL,NULL,NULL),(15196,727,40.11,49.7,NULL,NULL,NULL,NULL),(15197,727,50.11,50.6,NULL,NULL,NULL,NULL),(15198,727,60.11,51.6,NULL,NULL,NULL,NULL),(15199,727,70.11,52.5,NULL,NULL,NULL,NULL),(15200,728,0.2,45.4,NULL,NULL,NULL,NULL),(15201,728,0.5,47.2,NULL,NULL,NULL,NULL),(15202,728,0.7,47.8,NULL,NULL,NULL,NULL),(15203,728,1,49.7,NULL,NULL,NULL,NULL),(15204,728,2,56.3,NULL,NULL,NULL,NULL),(15205,728,3,57.3,NULL,NULL,NULL,NULL),(15206,728,4,59.1,NULL,NULL,NULL,NULL),(15207,728,5,62,NULL,NULL,NULL,NULL),(15208,728,6,62.5,NULL,NULL,NULL,NULL),(15209,728,7,63.9,NULL,NULL,NULL,NULL),(15210,728,8,64.8,NULL,NULL,NULL,NULL),(15211,728,9,66.7,NULL,NULL,NULL,NULL),(15212,728,14,69,NULL,NULL,NULL,NULL),(15213,728,20,71.4,NULL,NULL,NULL,NULL),(15214,728,40,78,NULL,NULL,NULL,NULL),(15215,728,50,81.8,NULL,NULL,NULL,NULL),(15216,728,60,83.7,NULL,NULL,NULL,NULL),(15217,728,70,86.5,NULL,NULL,NULL,NULL),(15218,728,80,89.4,NULL,NULL,NULL,NULL),(15219,728,90,91.8,NULL,NULL,NULL,NULL),(15220,728,150,95.6,NULL,NULL,NULL,NULL),(15221,728,200,99.4,NULL,NULL,NULL,NULL),(15222,728,300,103.9,NULL,NULL,NULL,NULL),(15223,728,400,108.8,NULL,NULL,NULL,NULL),(15224,728,500,109.6,NULL,NULL,NULL,NULL),(15225,728,570,111.5,NULL,NULL,NULL,NULL),(15226,729,0.32,29.5,NULL,NULL,NULL,NULL),(15227,729,0.62,30.4,NULL,NULL,NULL,NULL),(15228,729,0.82,31.4,NULL,NULL,NULL,NULL),(15229,729,1.12,32.3,NULL,NULL,NULL,NULL),(15230,729,2.12,34.2,NULL,NULL,NULL,NULL),(15231,729,3.12,37,NULL,NULL,NULL,NULL),(15232,729,4.12,37,NULL,NULL,NULL,NULL),(15233,729,5.12,36.1,NULL,NULL,NULL,NULL),(15234,729,6.12,37,NULL,NULL,NULL,NULL),(15235,729,7.12,37,NULL,NULL,NULL,NULL),(15236,729,8.12,38.9,NULL,NULL,NULL,NULL),(15237,729,9.12,38.9,NULL,NULL,NULL,NULL),(15238,729,14.12,41.4,NULL,NULL,NULL,NULL),(15239,729,20.12,41.4,NULL,NULL,NULL,NULL),(15240,729,30.12,43.3,NULL,NULL,NULL,NULL),(15241,729,40.12,44.2,NULL,NULL,NULL,NULL),(15242,729,50.12,45.2,NULL,NULL,NULL,NULL),(15243,729,60.12,44.2,NULL,NULL,NULL,NULL),(15244,729,70.12,50.1,NULL,NULL,NULL,NULL),(15245,729,80.12,47.1,NULL,NULL,NULL,NULL),(15246,729,90.12,46.1,NULL,NULL,NULL,NULL),(15247,729,150.12,49,NULL,NULL,NULL,NULL),(15248,729,200.12,49.9,NULL,NULL,NULL,NULL),(15249,729,300.12,52.7,NULL,NULL,NULL,NULL),(15250,729,400.12,54.6,NULL,NULL,NULL,NULL),(15251,729,500.12,55.6,NULL,NULL,NULL,NULL),(15252,729,570.12,56.5,NULL,NULL,NULL,NULL),(15253,730,0.2,63.3,NULL,NULL,NULL,NULL),(15254,730,0.5,71.8,NULL,NULL,NULL,NULL),(15255,730,0.7,74.3,NULL,NULL,NULL,NULL),(15256,730,1,78,NULL,NULL,NULL,NULL),(15257,730,2,86.5,NULL,NULL,NULL,NULL),(15258,730,3,91.3,NULL,NULL,NULL,NULL),(15259,730,4,95,NULL,NULL,NULL,NULL),(15260,730,5,98.5,NULL,NULL,NULL,NULL),(15261,730,6,100.7,NULL,NULL,NULL,NULL),(15262,730,7,102,NULL,NULL,NULL,NULL),(15263,730,8,104.9,NULL,NULL,NULL,NULL),(15264,730,9,107.7,NULL,NULL,NULL,NULL),(15265,730,14,115.3,NULL,NULL,NULL,NULL),(15266,730,20,119,NULL,NULL,NULL,NULL),(15267,730,30,128.5,NULL,NULL,NULL,NULL),(15268,730,40,130.4,NULL,NULL,NULL,NULL),(15269,730,50,134.2,NULL,NULL,NULL,NULL),(15270,730,60,137,NULL,NULL,NULL,NULL),(15271,730,70,137.9,NULL,NULL,NULL,NULL),(15272,731,0.14,42.5,NULL,NULL,NULL,NULL),(15273,731,0.44,45.9,NULL,NULL,NULL,NULL),(15274,731,0.64,47.2,NULL,NULL,NULL,NULL),(15275,731,0.94,49.1,NULL,NULL,NULL,NULL),(15276,731,1.94,51,NULL,NULL,NULL,NULL),(15277,731,2.94,52.9,NULL,NULL,NULL,NULL),(15278,731,3.94,53.9,NULL,NULL,NULL,NULL),(15279,731,4.94,54.8,NULL,NULL,NULL,NULL),(15280,731,5.94,56.7,NULL,NULL,NULL,NULL),(15281,731,6.94,56.7,NULL,NULL,NULL,NULL),(15282,731,7.94,58.6,NULL,NULL,NULL,NULL),(15283,731,8.94,58.6,NULL,NULL,NULL,NULL),(15284,731,13.94,60.5,NULL,NULL,NULL,NULL),(15285,731,19.94,61.4,NULL,NULL,NULL,NULL),(15286,731,29.94,63.9,NULL,NULL,NULL,NULL),(15287,731,39.94,65.8,NULL,NULL,NULL,NULL),(15288,731,49.94,67.6,NULL,NULL,NULL,NULL),(15289,731,59.94,68.6,NULL,NULL,NULL,NULL),(15290,731,69.94,70.5,NULL,NULL,NULL,NULL),(15291,732,0.2,59.5,NULL,NULL,NULL,NULL),(15292,732,0.5,65.8,NULL,NULL,NULL,NULL),(15293,732,0.7,69,NULL,NULL,NULL,NULL),(15294,732,1,71.4,NULL,NULL,NULL,NULL),(15295,732,2,75.2,NULL,NULL,NULL,NULL),(15296,732,3,77.1,NULL,NULL,NULL,NULL),(15297,732,4,78.4,NULL,NULL,NULL,NULL),(15298,732,5,80.9,NULL,NULL,NULL,NULL),(15299,732,6,81.8,NULL,NULL,NULL,NULL),(15300,732,7,82.8,NULL,NULL,NULL,NULL),(15301,732,8,83.7,NULL,NULL,NULL,NULL),(15302,732,9,86.5,NULL,NULL,NULL,NULL),(15303,732,14,88.8,NULL,NULL,NULL,NULL),(15304,732,20,90.7,NULL,NULL,NULL,NULL),(15305,732,30,96.4,NULL,NULL,NULL,NULL),(15306,732,40,97.3,NULL,NULL,NULL,NULL),(15307,732,50,100.2,NULL,NULL,NULL,NULL),(15308,732,60,100.7,NULL,NULL,NULL,NULL),(15309,732,70,102,NULL,NULL,NULL,NULL),(15310,732,80,104.5,NULL,NULL,NULL,NULL),(15311,732,90,107.7,NULL,NULL,NULL,NULL),(15312,732,100,107.7,NULL,NULL,NULL,NULL),(15313,732,150,111.5,NULL,NULL,NULL,NULL),(15314,732,200,113.4,NULL,NULL,NULL,NULL),(15315,732,300,117.2,NULL,NULL,NULL,NULL),(15316,732,400,116.2,NULL,NULL,NULL,NULL),(15317,732,500,116.2,NULL,NULL,NULL,NULL),(15318,733,0.19,36.8,NULL,NULL,NULL,NULL),(15319,733,0.49,37.8,NULL,NULL,NULL,NULL),(15320,733,0.69,38.8,NULL,NULL,NULL,NULL),(15321,733,0.99,42.6,NULL,NULL,NULL,NULL),(15322,733,1.99,41.7,NULL,NULL,NULL,NULL),(15323,733,2.99,43.6,NULL,NULL,NULL,NULL),(15324,733,3.99,45.5,NULL,NULL,NULL,NULL),(15325,733,4.99,46.4,NULL,NULL,NULL,NULL),(15326,733,5.99,46.4,NULL,NULL,NULL,NULL),(15327,733,6.99,47.3,NULL,NULL,NULL,NULL),(15328,733,7.99,48.3,NULL,NULL,NULL,NULL),(15329,733,8.99,49.2,NULL,NULL,NULL,NULL),(15330,733,13.99,51.1,NULL,NULL,NULL,NULL),(15331,733,19.99,52.1,NULL,NULL,NULL,NULL),(15332,733,29.99,53,NULL,NULL,NULL,NULL),(15333,733,39.99,54.9,NULL,NULL,NULL,NULL),(15334,733,49.99,55.8,NULL,NULL,NULL,NULL),(15335,733,59.99,57.4,NULL,NULL,NULL,NULL),(15336,733,69.99,58.7,NULL,NULL,NULL,NULL),(15337,733,79.99,58.7,NULL,NULL,NULL,NULL),(15338,733,89.99,59.2,NULL,NULL,NULL,NULL),(15339,733,99.99,60.6,NULL,NULL,NULL,NULL),(15340,733,149.99,62.5,NULL,NULL,NULL,NULL),(15341,733,199.99,63.4,NULL,NULL,NULL,NULL),(15342,733,299.99,65.9,NULL,NULL,NULL,NULL),(15343,733,399.99,66.8,NULL,NULL,NULL,NULL),(15344,733,499.99,67.7,NULL,NULL,NULL,NULL),(15345,733,569.99,68.3,NULL,NULL,NULL,NULL),(15346,734,0.2,69.9,NULL,NULL,NULL,NULL),(15347,734,0.5,80.9,NULL,NULL,NULL,NULL),(15348,734,0.7,83.7,NULL,NULL,NULL,NULL),(15349,734,1,86.5,NULL,NULL,NULL,NULL),(15350,734,2,94.1,NULL,NULL,NULL,NULL),(15351,734,3,97.9,NULL,NULL,NULL,NULL),(15352,734,4,102,NULL,NULL,NULL,NULL),(15353,734,5,105.8,NULL,NULL,NULL,NULL),(15354,734,6,109.6,NULL,NULL,NULL,NULL),(15355,734,7,110.5,NULL,NULL,NULL,NULL),(15356,734,8,112.8,NULL,NULL,NULL,NULL),(15357,734,9,113.4,NULL,NULL,NULL,NULL),(15358,734,14,122.4,NULL,NULL,NULL,NULL),(15359,734,20,128.1,NULL,NULL,NULL,NULL),(15360,734,30,135.7,NULL,NULL,NULL,NULL),(15361,734,40,141.3,NULL,NULL,NULL,NULL),(15362,734,50,145.5,NULL,NULL,NULL,NULL),(15363,734,60,149.3,NULL,NULL,NULL,NULL),(15364,734,70,153.1,NULL,NULL,NULL,NULL),(15365,735,0.7,52.9,NULL,NULL,NULL,NULL),(15366,735,1,54.8,NULL,NULL,NULL,NULL),(15367,735,2,57.6,NULL,NULL,NULL,NULL),(15368,735,3,58.6,NULL,NULL,NULL,NULL),(15369,735,4,62.4,NULL,NULL,NULL,NULL),(15370,735,5,65.2,NULL,NULL,NULL,NULL),(15371,735,6,66.1,NULL,NULL,NULL,NULL),(15372,735,7,66.1,NULL,NULL,NULL,NULL),(15373,735,8,68,NULL,NULL,NULL,NULL),(15374,735,9,69,NULL,NULL,NULL,NULL),(15375,735,14,71.4,NULL,NULL,NULL,NULL),(15376,735,20,77.1,NULL,NULL,NULL,NULL),(15377,735,30,80.9,NULL,NULL,NULL,NULL),(15378,735,40,85.6,NULL,NULL,NULL,NULL),(15379,735,50,86.5,NULL,NULL,NULL,NULL),(15380,735,60,94.5,NULL,NULL,NULL,NULL),(15381,735,70,94.5,NULL,NULL,NULL,NULL),(15382,736,0.2,75.2,NULL,NULL,NULL,NULL),(15383,736,0.7,81.8,NULL,NULL,NULL,NULL),(15384,736,1,85.6,NULL,NULL,NULL,NULL),(15385,736,2,92.6,NULL,NULL,NULL,NULL),(15386,736,3,96.4,NULL,NULL,NULL,NULL),(15387,736,4,96.4,NULL,NULL,NULL,NULL),(15388,736,5,99.2,NULL,NULL,NULL,NULL),(15389,736,6,103,NULL,NULL,NULL,NULL),(15390,736,7,103,NULL,NULL,NULL,NULL),(15391,736,8,105.8,NULL,NULL,NULL,NULL),(15392,736,9,105.3,NULL,NULL,NULL,NULL),(15393,736,14,109.6,NULL,NULL,NULL,NULL),(15394,736,20,113.8,NULL,NULL,NULL,NULL),(15395,736,30,119,NULL,NULL,NULL,NULL),(15396,736,40,122.4,NULL,NULL,NULL,NULL),(15397,736,50,128.1,NULL,NULL,NULL,NULL),(15398,736,60,130,NULL,NULL,NULL,NULL),(15399,736,70,130,NULL,NULL,NULL,NULL),(15400,736,80,131.9,NULL,NULL,NULL,NULL),(15401,736,90,133.8,NULL,NULL,NULL,NULL),(15402,736,100,133.8,NULL,NULL,NULL,NULL),(15403,736,150,142.7,NULL,NULL,NULL,NULL),(15404,736,200,151.2,NULL,NULL,NULL,NULL),(15405,736,300,154,NULL,NULL,NULL,NULL),(15406,737,0.27,45.3,NULL,NULL,NULL,NULL),(15407,737,1.07,50.9,NULL,NULL,NULL,NULL),(15408,737,2.07,51.9,NULL,NULL,NULL,NULL),(15409,737,3.07,54.7,NULL,NULL,NULL,NULL),(15410,737,4.07,56.6,NULL,NULL,NULL,NULL),(15411,737,5.07,58.5,NULL,NULL,NULL,NULL),(15412,737,6.07,58.5,NULL,NULL,NULL,NULL),(15413,737,7.07,59.4,NULL,NULL,NULL,NULL),(15414,737,8.07,60.4,NULL,NULL,NULL,NULL),(15415,737,9.07,60.9,NULL,NULL,NULL,NULL),(15416,737,14.07,63.8,NULL,NULL,NULL,NULL),(15417,737,20.07,63.8,NULL,NULL,NULL,NULL),(15418,737,30.07,71.3,NULL,NULL,NULL,NULL),(15419,737,40.07,72.3,NULL,NULL,NULL,NULL),(15420,737,50.07,76.1,NULL,NULL,NULL,NULL),(15421,737,60.07,75.1,NULL,NULL,NULL,NULL),(15422,737,70.07,80.8,NULL,NULL,NULL,NULL),(15423,737,80.07,81.7,NULL,NULL,NULL,NULL),(15424,737,90.07,84.6,NULL,NULL,NULL,NULL),(15425,737,100.07,82.7,NULL,NULL,NULL,NULL),(15426,737,150.07,95.3,NULL,NULL,NULL,NULL),(15427,737,200.07,99.1,NULL,NULL,NULL,NULL),(15428,737,300.07,105.7,NULL,NULL,NULL,NULL),(15429,738,0.2,33.9,NULL,NULL,NULL,NULL),(15430,738,1,35.2,NULL,NULL,NULL,NULL),(15431,738,2,35.7,NULL,NULL,NULL,NULL),(15432,738,3.2,38.3,NULL,NULL,NULL,NULL),(15433,738,7.2,41.7,NULL,NULL,NULL,NULL),(15434,738,9,42.6,NULL,NULL,NULL,NULL),(15435,738,13,42.3,NULL,NULL,NULL,NULL),(15436,738,15.3,44,NULL,NULL,NULL,NULL),(15437,738,19.9,45.6,NULL,NULL,NULL,NULL),(15438,738,23.3,45.5,NULL,NULL,NULL,NULL),(15439,738,28.7,47.7,NULL,NULL,NULL,NULL),(15440,738,35.5,48.9,NULL,NULL,NULL,NULL),(15441,738,41.5,49.4,NULL,NULL,NULL,NULL),(15442,738,48.1,50.4,NULL,NULL,NULL,NULL),(15443,738,58.8,51.2,NULL,NULL,NULL,NULL),(15444,738,69.6,51.6,NULL,NULL,NULL,NULL),(15445,739,0.2,48.3,NULL,NULL,NULL,NULL),(15446,739,0.9,54.2,NULL,NULL,NULL,NULL),(15447,739,1,56.7,NULL,NULL,NULL,NULL),(15448,739,1.3,57.7,NULL,NULL,NULL,NULL),(15449,739,1.9,59.8,NULL,NULL,NULL,NULL),(15450,739,2.2,61.4,NULL,NULL,NULL,NULL),(15451,739,3.1,63.1,NULL,NULL,NULL,NULL),(15452,739,6.3,68.1,NULL,NULL,NULL,NULL),(15453,739,7.2,70.3,NULL,NULL,NULL,NULL),(15454,739,9.2,71.7,NULL,NULL,NULL,NULL),(15455,739,14.3,74.9,NULL,NULL,NULL,NULL),(15456,739,15.5,75.8,NULL,NULL,NULL,NULL),(15457,739,16.6,77,NULL,NULL,NULL,NULL),(15458,739,20.9,79,NULL,NULL,NULL,NULL),(15459,739,24.4,81.6,NULL,NULL,NULL,NULL),(15460,739,27.6,82,NULL,NULL,NULL,NULL),(15461,739,31,84,NULL,NULL,NULL,NULL),(15462,739,34.6,85.8,NULL,NULL,NULL,NULL),(15463,739,39.2,86.9,NULL,NULL,NULL,NULL),(15464,739,46.3,88.7,NULL,NULL,NULL,NULL),(15465,739,55.4,91.5,NULL,NULL,NULL,NULL),(15466,739,62.4,92,NULL,NULL,NULL,NULL),(15467,739,71.1,93.5,NULL,NULL,NULL,NULL),(15468,740,1.25,33.6,NULL,NULL,NULL,NULL),(15469,740,3.15,35.7,NULL,NULL,NULL,NULL),(15470,740,4.05,36.3,NULL,NULL,NULL,NULL),(15471,740,7.25,37.3,NULL,NULL,NULL,NULL),(15472,740,8.05,38.3,NULL,NULL,NULL,NULL),(15473,740,10.95,40.1,NULL,NULL,NULL,NULL),(15474,740,13.95,40.4,NULL,NULL,NULL,NULL),(15475,740,18.05,40.5,NULL,NULL,NULL,NULL),(15476,740,20.95,41.7,NULL,NULL,NULL,NULL),(15477,740,24.55,42,NULL,NULL,NULL,NULL),(15478,740,34.65,42.3,NULL,NULL,NULL,NULL),(15479,740,45.05,42.5,NULL,NULL,NULL,NULL),(15480,740,48.65,42.8,NULL,NULL,NULL,NULL),(15481,740,51.35,41.6,NULL,NULL,NULL,NULL),(15482,740,59.15,43.4,NULL,NULL,NULL,NULL),(15483,740,67.05,44.6,NULL,NULL,NULL,NULL),(15484,740,71.95,45.5,NULL,NULL,NULL,NULL),(15485,740,80.25,45.9,NULL,NULL,NULL,NULL),(15486,740,93.85,45.3,NULL,NULL,NULL,NULL),(15487,740,101.25,46.3,NULL,NULL,NULL,NULL),(15488,740,121.95,47.1,NULL,NULL,NULL,NULL),(15489,740,141.25,47,NULL,NULL,NULL,NULL),(15490,740,165.45,48.3,NULL,NULL,NULL,NULL),(15491,740,195.85,49.1,NULL,NULL,NULL,NULL),(15492,740,244.85,50.4,NULL,NULL,NULL,NULL),(15493,740,299.45,51.5,NULL,NULL,NULL,NULL),(15494,740,344.85,53,NULL,NULL,NULL,NULL),(15495,740,403.65,55.2,NULL,NULL,NULL,NULL),(15496,740,496.15,54.6,NULL,NULL,NULL,NULL),(15497,740,568.25,55.6,NULL,NULL,NULL,NULL),(15498,741,0.1,45.8,NULL,NULL,NULL,NULL),(15499,741,1,50,NULL,NULL,NULL,NULL),(15500,741,2,55.3,NULL,NULL,NULL,NULL),(15501,741,3.1,56.5,NULL,NULL,NULL,NULL),(15502,741,4.1,57.4,NULL,NULL,NULL,NULL),(15503,741,6.9,61.4,NULL,NULL,NULL,NULL),(15504,741,8,62.6,NULL,NULL,NULL,NULL),(15505,741,9.8,65.6,NULL,NULL,NULL,NULL),(15506,741,11.2,65.7,NULL,NULL,NULL,NULL),(15507,741,14.1,67.7,NULL,NULL,NULL,NULL),(15508,741,16.9,68.2,NULL,NULL,NULL,NULL),(15509,741,18,69.9,NULL,NULL,NULL,NULL),(15510,741,21.1,70.2,NULL,NULL,NULL,NULL),(15511,741,23.5,71.2,NULL,NULL,NULL,NULL),(15512,741,24.9,72.7,NULL,NULL,NULL,NULL),(15513,741,32.2,73.6,NULL,NULL,NULL,NULL),(15514,741,35,74.6,NULL,NULL,NULL,NULL),(15515,741,38.4,76.3,NULL,NULL,NULL,NULL),(15516,741,41,77.9,NULL,NULL,NULL,NULL),(15517,741,44.5,79.8,NULL,NULL,NULL,NULL),(15518,741,48.3,80.4,NULL,NULL,NULL,NULL),(15519,741,53,81.5,NULL,NULL,NULL,NULL),(15520,741,58.8,82.2,NULL,NULL,NULL,NULL),(15521,741,68.5,85.9,NULL,NULL,NULL,NULL),(15522,741,81.9,87.4,NULL,NULL,NULL,NULL),(15523,741,106.3,90.1,NULL,NULL,NULL,NULL),(15524,741,114.1,90.8,NULL,NULL,NULL,NULL),(15525,741,137.4,92.7,NULL,NULL,NULL,NULL),(15526,741,166.3,96.1,NULL,NULL,NULL,NULL),(15527,741,198,97.6,NULL,NULL,NULL,NULL),(15528,741,248.8,100,NULL,NULL,NULL,NULL),(15529,741,280.5,102.4,NULL,NULL,NULL,NULL),(15530,741,339.2,104.2,NULL,NULL,NULL,NULL),(15531,741,388.6,107.3,NULL,NULL,NULL,NULL),(15532,741,498.8,108.5,NULL,NULL,NULL,NULL),(15533,741,568.2,110.7,NULL,NULL,NULL,NULL),(15534,742,0.22,40.1,NULL,NULL,NULL,NULL),(15535,742,0.32,40.9,NULL,NULL,NULL,NULL),(15536,742,1.22,45.6,NULL,NULL,NULL,NULL),(15537,742,2.12,49.1,NULL,NULL,NULL,NULL),(15538,742,6.22,55.1,NULL,NULL,NULL,NULL),(15539,742,8.12,56.3,NULL,NULL,NULL,NULL),(15540,742,10.12,56.6,NULL,NULL,NULL,NULL),(15541,742,14.02,58.3,NULL,NULL,NULL,NULL),(15542,742,17.22,59.2,NULL,NULL,NULL,NULL),(15543,742,22.52,61,NULL,NULL,NULL,NULL),(15544,742,24.12,61.5,NULL,NULL,NULL,NULL),(15545,742,29.92,62.9,NULL,NULL,NULL,NULL),(15546,742,38.72,65,NULL,NULL,NULL,NULL),(15547,742,43.42,65.2,NULL,NULL,NULL,NULL),(15548,742,49.52,66.4,NULL,NULL,NULL,NULL),(15549,742,55.22,66.8,NULL,NULL,NULL,NULL),(15550,742,59.62,67.4,NULL,NULL,NULL,NULL),(15551,742,68.22,68.5,NULL,NULL,NULL,NULL),(15552,743,0.8,70.4,NULL,NULL,NULL,NULL),(15553,743,1,74.5,NULL,NULL,NULL,NULL),(15554,743,1.7,80.7,NULL,NULL,NULL,NULL),(15555,743,1.8,81.4,NULL,NULL,NULL,NULL),(15556,743,7.1,98.9,NULL,NULL,NULL,NULL),(15557,743,8.1,104.3,NULL,NULL,NULL,NULL),(15558,743,9.1,106.6,NULL,NULL,NULL,NULL),(15559,743,10.1,107.9,NULL,NULL,NULL,NULL),(15560,743,13.2,112.8,NULL,NULL,NULL,NULL),(15561,743,15.3,114.6,NULL,NULL,NULL,NULL),(15562,743,16.9,115.5,NULL,NULL,NULL,NULL),(15563,743,19.8,119.1,NULL,NULL,NULL,NULL),(15564,743,22.6,120.3,NULL,NULL,NULL,NULL),(15565,743,24.1,121.7,NULL,NULL,NULL,NULL),(15566,743,27.7,125.6,NULL,NULL,NULL,NULL),(15567,743,31.3,125.9,NULL,NULL,NULL,NULL),(15568,743,34.6,127.5,NULL,NULL,NULL,NULL),(15569,743,39.9,126.9,NULL,NULL,NULL,NULL),(15570,743,40,130.7,NULL,NULL,NULL,NULL),(15571,743,43.5,129,NULL,NULL,NULL,NULL),(15572,743,48.3,130.8,NULL,NULL,NULL,NULL),(15573,743,59.5,134.1,NULL,NULL,NULL,NULL),(15574,743,66.3,134.4,NULL,NULL,NULL,NULL),(15575,743,71.1,135.9,NULL,NULL,NULL,NULL),(15576,744,0.32,36.6,NULL,NULL,NULL,NULL),(15577,744,0.32,36.9,NULL,NULL,NULL,NULL),(15578,744,0.42,37.2,NULL,NULL,NULL,NULL),(15579,744,4.12,43.5,NULL,NULL,NULL,NULL),(15580,744,5.22,44.4,NULL,NULL,NULL,NULL),(15581,744,7.12,45,NULL,NULL,NULL,NULL),(15582,744,8.02,45.4,NULL,NULL,NULL,NULL),(15583,744,13.92,47.9,NULL,NULL,NULL,NULL),(15584,744,15.62,48.3,NULL,NULL,NULL,NULL),(15585,744,18.82,47.5,NULL,NULL,NULL,NULL),(15586,744,22.32,48.9,NULL,NULL,NULL,NULL),(15587,744,25.32,50.4,NULL,NULL,NULL,NULL),(15588,744,30.12,50.8,NULL,NULL,NULL,NULL),(15589,744,50.32,53.9,NULL,NULL,NULL,NULL),(15590,744,64.62,55.8,NULL,NULL,NULL,NULL),(15591,744,78.52,56.7,NULL,NULL,NULL,NULL),(15592,744,93.42,57.8,NULL,NULL,NULL,NULL),(15593,744,108.72,59.9,NULL,NULL,NULL,NULL),(15594,744,136.72,61,NULL,NULL,NULL,NULL),(15595,744,165.32,60.2,NULL,NULL,NULL,NULL),(15596,744,205.42,62.3,NULL,NULL,NULL,NULL),(15597,744,251.12,62.8,NULL,NULL,NULL,NULL),(15598,744,305.22,64.6,NULL,NULL,NULL,NULL),(15599,744,363.02,66.8,NULL,NULL,NULL,NULL),(15600,744,409.02,65.9,NULL,NULL,NULL,NULL),(15601,744,494.42,66,NULL,NULL,NULL,NULL),(15602,744,566.02,66.6,NULL,NULL,NULL,NULL),(15603,745,0.1,51.4,NULL,NULL,NULL,NULL),(15604,745,0.2,55.2,NULL,NULL,NULL,NULL),(15605,745,1.2,64.4,NULL,NULL,NULL,NULL),(15606,745,1.2,66,NULL,NULL,NULL,NULL),(15607,745,4.1,78.4,NULL,NULL,NULL,NULL),(15608,745,5.1,80.1,NULL,NULL,NULL,NULL),(15609,745,6.1,75.2,NULL,NULL,NULL,NULL),(15610,745,6.9,77.3,NULL,NULL,NULL,NULL),(15611,745,8.1,80.1,NULL,NULL,NULL,NULL),(15612,745,11,84.2,NULL,NULL,NULL,NULL),(15613,745,13.7,87.1,NULL,NULL,NULL,NULL),(15614,745,15,85.1,NULL,NULL,NULL,NULL),(15615,745,17.7,87.6,NULL,NULL,NULL,NULL),(15616,745,19.9,88.5,NULL,NULL,NULL,NULL),(15617,745,21.4,89.4,NULL,NULL,NULL,NULL),(15618,745,22.6,89.4,NULL,NULL,NULL,NULL),(15619,745,25.5,90.5,NULL,NULL,NULL,NULL),(15620,745,30,95.7,NULL,NULL,NULL,NULL),(15621,745,43.5,96.9,NULL,NULL,NULL,NULL),(15622,745,49.7,99,NULL,NULL,NULL,NULL),(15623,745,65.2,104.2,NULL,NULL,NULL,NULL),(15624,745,71.9,102.8,NULL,NULL,NULL,NULL),(15625,745,78,103.7,NULL,NULL,NULL,NULL),(15626,745,88.8,106.6,NULL,NULL,NULL,NULL),(15627,745,92.8,106.6,NULL,NULL,NULL,NULL),(15628,745,99.5,106.3,NULL,NULL,NULL,NULL),(15629,745,112.2,107.2,NULL,NULL,NULL,NULL),(15630,745,130,108.4,NULL,NULL,NULL,NULL),(15631,745,146.6,109.8,NULL,NULL,NULL,NULL),(15632,745,167.9,110.2,NULL,NULL,NULL,NULL),(15633,745,198.1,111.3,NULL,NULL,NULL,NULL),(15634,745,244.3,111.7,NULL,NULL,NULL,NULL),(15635,745,290.6,113.5,NULL,NULL,NULL,NULL),(15636,745,408.9,115.6,NULL,NULL,NULL,NULL),(15637,745,494.3,115.2,NULL,NULL,NULL,NULL),(15638,746,0.09,42.8,NULL,NULL,NULL,NULL),(15639,746,0.09,45,NULL,NULL,NULL,NULL),(15640,746,0.69,51.4,NULL,NULL,NULL,NULL),(15641,746,0.89,52.5,NULL,NULL,NULL,NULL),(15642,746,1.09,53.4,NULL,NULL,NULL,NULL),(15643,746,1.59,55.5,NULL,NULL,NULL,NULL),(15644,746,1.99,55.5,NULL,NULL,NULL,NULL),(15645,746,2.99,56.4,NULL,NULL,NULL,NULL),(15646,746,4.99,62.9,NULL,NULL,NULL,NULL),(15647,746,6.99,64.1,NULL,NULL,NULL,NULL),(15648,746,7.79,66.1,NULL,NULL,NULL,NULL),(15649,746,8.79,66.3,NULL,NULL,NULL,NULL),(15650,746,9.69,66.1,NULL,NULL,NULL,NULL),(15651,746,12.69,69.1,NULL,NULL,NULL,NULL),(15652,746,14.89,70.3,NULL,NULL,NULL,NULL),(15653,746,15.99,73.4,NULL,NULL,NULL,NULL),(15654,746,20.39,78.3,NULL,NULL,NULL,NULL),(15655,746,23.99,79.2,NULL,NULL,NULL,NULL),(15656,746,26.79,78.9,NULL,NULL,NULL,NULL),(15657,746,29.39,80.1,NULL,NULL,NULL,NULL),(15658,746,33.79,83.7,NULL,NULL,NULL,NULL),(15659,746,39.99,84.9,NULL,NULL,NULL,NULL),(15660,746,44.39,86,NULL,NULL,NULL,NULL),(15661,746,50.99,87.5,NULL,NULL,NULL,NULL),(15662,746,53.89,88.3,NULL,NULL,NULL,NULL),(15663,746,58.29,91.5,NULL,NULL,NULL,NULL),(15664,746,63.99,92.1,NULL,NULL,NULL,NULL),(15665,746,68.39,92.1,NULL,NULL,NULL,NULL),(15666,747,0.1,65.1,NULL,NULL,NULL,NULL),(15667,747,0.1,72,NULL,NULL,NULL,NULL),(15668,747,0.8,83.8,NULL,NULL,NULL,NULL),(15669,747,1.2,88.9,NULL,NULL,NULL,NULL),(15670,747,1.7,90.5,NULL,NULL,NULL,NULL),(15671,747,3,96.4,NULL,NULL,NULL,NULL),(15672,747,6.9,108.8,NULL,NULL,NULL,NULL),(15673,747,7.8,111,NULL,NULL,NULL,NULL),(15674,747,8.9,112,NULL,NULL,NULL,NULL),(15675,747,9.7,112.6,NULL,NULL,NULL,NULL),(15676,747,13.2,117.5,NULL,NULL,NULL,NULL),(15677,747,15,121.5,NULL,NULL,NULL,NULL),(15678,747,15.7,122.2,NULL,NULL,NULL,NULL),(15679,747,19.6,125.7,NULL,NULL,NULL,NULL),(15680,747,23,130.8,NULL,NULL,NULL,NULL),(15681,747,26.4,131.3,NULL,NULL,NULL,NULL),(15682,747,29,134.3,NULL,NULL,NULL,NULL),(15683,747,46.2,144.2,NULL,NULL,NULL,NULL),(15684,747,50.2,146.6,NULL,NULL,NULL,NULL),(15685,747,53.7,146.3,NULL,NULL,NULL,NULL),(15686,747,60.6,147.8,NULL,NULL,NULL,NULL),(15687,747,68.1,151.2,NULL,NULL,NULL,NULL),(15688,748,0.22,41.1,NULL,NULL,NULL,NULL),(15689,748,0.22,42.9,NULL,NULL,NULL,NULL),(15690,748,0.42,43.5,NULL,NULL,NULL,NULL),(15691,748,1.02,48.3,NULL,NULL,NULL,NULL),(15692,748,1.32,49.3,NULL,NULL,NULL,NULL),(15693,748,2.32,52.1,NULL,NULL,NULL,NULL),(15694,748,2.92,53.3,NULL,NULL,NULL,NULL),(15695,748,5.62,56.9,NULL,NULL,NULL,NULL),(15696,748,6.12,57.1,NULL,NULL,NULL,NULL),(15697,748,7.02,58,NULL,NULL,NULL,NULL),(15698,748,7.92,58,NULL,NULL,NULL,NULL),(15699,748,8.92,58.6,NULL,NULL,NULL,NULL),(15700,748,10.12,60.7,NULL,NULL,NULL,NULL),(15701,748,12.42,61.9,NULL,NULL,NULL,NULL),(15702,748,14.82,62.4,NULL,NULL,NULL,NULL),(15703,748,16.82,62.5,NULL,NULL,NULL,NULL),(15704,748,19.82,62.7,NULL,NULL,NULL,NULL),(15705,748,21.32,67,NULL,NULL,NULL,NULL),(15706,748,23.92,67,NULL,NULL,NULL,NULL),(15707,748,28.02,69.1,NULL,NULL,NULL,NULL),(15708,748,34.62,70.1,NULL,NULL,NULL,NULL),(15709,748,40.72,72.1,NULL,NULL,NULL,NULL),(15710,748,48.62,74.7,NULL,NULL,NULL,NULL),(15711,748,56.22,74.7,NULL,NULL,NULL,NULL),(15712,748,62.72,77,NULL,NULL,NULL,NULL),(15713,748,76.92,80.5,NULL,NULL,NULL,NULL),(15714,748,88.82,83.3,NULL,NULL,NULL,NULL),(15715,748,105.72,84.1,NULL,NULL,NULL,NULL),(15716,748,139.82,93.8,NULL,NULL,NULL,NULL),(15717,748,162.42,93.8,NULL,NULL,NULL,NULL),(15718,748,174.12,96.4,NULL,NULL,NULL,NULL),(15719,748,227.62,98.2,NULL,NULL,NULL,NULL),(15720,748,258.72,100.2,NULL,NULL,NULL,NULL),(15721,748,271.52,104,NULL,NULL,NULL,NULL),(15722,748,287.92,104,NULL,NULL,NULL,NULL),(15723,749,0.01,65.1,NULL,NULL,NULL,NULL),(15724,749,0.1,66.5,NULL,NULL,NULL,NULL),(15725,749,0.1,70.9,NULL,NULL,NULL,NULL),(15726,749,0.1,72.8,NULL,NULL,NULL,NULL),(15727,749,0.2,74.9,NULL,NULL,NULL,NULL),(15728,749,0.2,76.8,NULL,NULL,NULL,NULL),(15729,749,1.2,88.3,NULL,NULL,NULL,NULL),(15730,749,2,91.2,NULL,NULL,NULL,NULL),(15731,749,5.8,101.9,NULL,NULL,NULL,NULL),(15732,749,6.8,101.5,NULL,NULL,NULL,NULL),(15733,749,7.9,105.2,NULL,NULL,NULL,NULL),(15734,749,8.9,104,NULL,NULL,NULL,NULL),(15735,749,12.8,108.5,NULL,NULL,NULL,NULL),(15736,749,15.1,109.2,NULL,NULL,NULL,NULL),(15737,749,19.3,111.3,NULL,NULL,NULL,NULL),(15738,749,23.3,114.3,NULL,NULL,NULL,NULL),(15739,749,27.6,117.2,NULL,NULL,NULL,NULL),(15740,749,34,123.1,NULL,NULL,NULL,NULL),(15741,749,40.4,124.5,NULL,NULL,NULL,NULL),(15742,749,48.8,125.7,NULL,NULL,NULL,NULL),(15743,749,61.3,127,NULL,NULL,NULL,NULL),(15744,749,66.6,128.8,NULL,NULL,NULL,NULL),(15745,749,74.8,131.2,NULL,NULL,NULL,NULL),(15746,749,97.4,131.9,NULL,NULL,NULL,NULL),(15747,749,108.5,139.4,NULL,NULL,NULL,NULL),(15748,749,120.2,140.2,NULL,NULL,NULL,NULL),(15749,749,151.4,142.7,NULL,NULL,NULL,NULL),(15750,749,180.7,144.8,NULL,NULL,NULL,NULL),(15751,749,192.7,145.5,NULL,NULL,NULL,NULL),(15752,749,227.5,152.1,NULL,NULL,NULL,NULL),(15753,749,254.5,152.1,NULL,NULL,NULL,NULL),(15754,749,289.4,153.6,NULL,NULL,NULL,NULL),(15755,750,23.622,3.0827,NULL,NULL,NULL,NULL),(15756,750,48.032,4.94175,NULL,NULL,NULL,NULL),(15757,750,72.441,6.1183,NULL,NULL,NULL,NULL),(15758,750,96.063,7.00576,NULL,NULL,NULL,NULL),(15759,750,236.51,9.2007,NULL,NULL,NULL,NULL),(15760,750,477.34,11.5645,NULL,NULL,NULL,NULL),(15761,750,1199.2,15.1523,NULL,NULL,NULL,NULL),(15762,751,22.835,8.31477,NULL,NULL,NULL,NULL),(15763,751,45.669,10.2359,NULL,NULL,NULL,NULL),(15764,751,70.866,11.7538,NULL,NULL,NULL,NULL),(15765,751,97.638,13.1161,NULL,NULL,NULL,NULL),(15766,751,235.71,16.3002,NULL,NULL,NULL,NULL),(15767,751,477.34,20.3173,NULL,NULL,NULL,NULL),(15768,751,1198.5,24.4972,NULL,NULL,NULL,NULL),(15769,752,22.047,2.62541,NULL,NULL,NULL,NULL),(15770,752,73.228,7.64787,NULL,NULL,NULL,NULL),(15771,752,92.126,8.82462,NULL,NULL,NULL,NULL),(15772,752,168.18,11.793,NULL,NULL,NULL,NULL),(15773,752,190.91,12.4548,NULL,NULL,NULL,NULL),(15774,752,573.08,19.0809,NULL,NULL,NULL,NULL),(15775,752,720.31,19.7764,NULL,NULL,NULL,NULL),(15776,752,888.1,19.8921,NULL,NULL,NULL,NULL),(15777,752,1056.4,20.5136,NULL,NULL,NULL,NULL),(15778,752,1105.3,21.4298,NULL,NULL,NULL,NULL),(15779,752,1173.3,21.5894,NULL,NULL,NULL,NULL),(15780,753,20.472,10.6679,NULL,NULL,NULL,NULL),(15781,753,47.244,14.6211,NULL,NULL,NULL,NULL),(15782,753,70.079,17.0627,NULL,NULL,NULL,NULL),(15783,753,96.063,19.6161,NULL,NULL,NULL,NULL),(15784,753,235.71,27.2542,NULL,NULL,NULL,NULL),(15785,753,477.34,34.6704,NULL,NULL,NULL,NULL),(15786,753,1200,44.4914,NULL,NULL,NULL,NULL),(15787,754,26.772,6.71183,NULL,NULL,NULL,NULL),(15788,754,66.929,9.53078,NULL,NULL,NULL,NULL),(15789,754,239.68,24.8002,NULL,NULL,NULL,NULL),(15790,754,292.06,26.2714,NULL,NULL,NULL,NULL),(15791,754,311.63,27.0423,NULL,NULL,NULL,NULL),(15792,754,337.21,28.0187,NULL,NULL,NULL,NULL),(15793,754,506.15,31.5649,NULL,NULL,NULL,NULL),(15794,754,650,33.3729,NULL,NULL,NULL,NULL),(15795,754,834.13,36.4317,NULL,NULL,NULL,NULL),(15796,754,932.31,40.7965,NULL,NULL,NULL,NULL),(15797,754,1102.3,42.7329,NULL,NULL,NULL,NULL),(15798,755,25.984,8.21859,NULL,NULL,NULL,NULL),(15799,755,45.669,9.74186,NULL,NULL,NULL,NULL),(15800,755,72.441,15.955,NULL,NULL,NULL,NULL),(15801,755,254.76,23.6796,NULL,NULL,NULL,NULL),(15802,755,555.39,29.5486,NULL,NULL,NULL,NULL),(15803,755,739.06,33.5114,NULL,NULL,NULL,NULL),(15804,755,1004.8,35.6672,NULL,NULL,NULL,NULL),(15805,755,1106.1,37.2118,NULL,NULL,NULL,NULL),(15806,755,1174.1,37.4981,NULL,NULL,NULL,NULL),(15807,756,140.91,14.3188,NULL,NULL,NULL,NULL),(15808,756,181.82,16.6466,NULL,NULL,NULL,NULL),(15809,756,252.38,19.1255,NULL,NULL,NULL,NULL),(15810,756,296.83,20.6374,NULL,NULL,NULL,NULL),(15811,756,393.02,22.8976,NULL,NULL,NULL,NULL),(15812,756,492.19,24.6044,NULL,NULL,NULL,NULL),(15813,756,593.85,26.7718,NULL,NULL,NULL,NULL),(15814,756,688.28,28.3771,NULL,NULL,NULL,NULL),(15815,756,796.09,31.0695,NULL,NULL,NULL,NULL),(15816,756,1000,31.898,NULL,NULL,NULL,NULL),(15817,757,40.945,14.1195,NULL,NULL,NULL,NULL),(15818,757,86.614,16.4487,NULL,NULL,NULL,NULL),(15819,757,190.91,21.4376,NULL,NULL,NULL,NULL),(15820,757,293.65,27.3222,NULL,NULL,NULL,NULL),(15821,757,396.12,30.5912,NULL,NULL,NULL,NULL),(15822,757,493.75,32.8855,NULL,NULL,NULL,NULL),(15823,757,593.08,38.0717,NULL,NULL,NULL,NULL),(15824,757,687.5,38.2874,NULL,NULL,NULL,NULL),(15825,757,1000,40.5102,NULL,NULL,NULL,NULL),(15826,758,43.307,19.9355,NULL,NULL,NULL,NULL),(15827,758,87.402,22.4614,NULL,NULL,NULL,NULL),(15828,758,140.91,28.4667,NULL,NULL,NULL,NULL),(15829,758,189.39,32.4948,NULL,NULL,NULL,NULL),(15830,758,245.24,36.6906,NULL,NULL,NULL,NULL),(15831,758,295.24,40.4221,NULL,NULL,NULL,NULL),(15832,758,389.92,42.7311,NULL,NULL,NULL,NULL),(15833,758,490.63,46.3746,NULL,NULL,NULL,NULL),(15834,758,592.31,50.113,NULL,NULL,NULL,NULL),(15835,758,685.94,52.0374,NULL,NULL,NULL,NULL),(15836,758,797.66,52.3118,NULL,NULL,NULL,NULL),(15837,758,1000.8,53.2288,NULL,NULL,NULL,NULL),(15838,759,43.307,18.1395,NULL,NULL,NULL,NULL),(15839,759,87.402,21.3745,NULL,NULL,NULL,NULL),(15840,759,140.15,29.2875,NULL,NULL,NULL,NULL),(15841,759,191.67,32.3046,NULL,NULL,NULL,NULL),(15842,759,241.27,36.9749,NULL,NULL,NULL,NULL),(15843,759,295.24,41.3291,NULL,NULL,NULL,NULL),(15844,759,389.92,45.1925,NULL,NULL,NULL,NULL),(15845,759,491.41,48.6685,NULL,NULL,NULL,NULL),(15846,759,590.77,56.1647,NULL,NULL,NULL,NULL),(15847,759,685.94,58.3545,NULL,NULL,NULL,NULL),(15848,759,795.31,58.2551,NULL,NULL,NULL,NULL),(15849,759,1000,63.1345,NULL,NULL,NULL,NULL),(15850,760,0.81,35.9408,NULL,NULL,NULL,NULL),(15851,760,1.09,35.9408,NULL,NULL,NULL,NULL),(15852,760,1.28,32.5429,NULL,NULL,NULL,NULL),(15853,760,3.09,38.3898,NULL,NULL,NULL,NULL),(15854,760,4.04,39.1347,NULL,NULL,NULL,NULL),(15855,760,7.19,39.9816,NULL,NULL,NULL,NULL),(15856,760,9.08,40.6245,NULL,NULL,NULL,NULL),(15857,760,11.06,42.9306,NULL,NULL,NULL,NULL),(15858,760,17.58,42.9306,NULL,NULL,NULL,NULL),(15859,760,25.15,44.5939,NULL,NULL,NULL,NULL),(15860,760,35.23,44.9408,NULL,NULL,NULL,NULL),(15861,760,45.67,45.1857,NULL,NULL,NULL,NULL),(15862,760,59.13,46.1347,NULL,NULL,NULL,NULL),(15863,760,70.55,48.2673,NULL,NULL,NULL,NULL),(15864,760,87.67,49.451,NULL,NULL,NULL,NULL),(15865,760,101.7,49.2163,NULL,NULL,NULL,NULL),(15866,760,120.73,50.4,NULL,NULL,NULL,NULL),(15867,760,142.05,50.0429,NULL,NULL,NULL,NULL),(15868,760,200.8,52.298,NULL,NULL,NULL,NULL),(15869,760,296.62,54.7265,NULL,NULL,NULL,NULL),(15870,760,399.12,57.6449,NULL,NULL,NULL,NULL),(15871,760,507.01,57.6449,NULL,NULL,NULL,NULL),(15872,760,579.35,58.3694,NULL,NULL,NULL,NULL),(15873,760,581.62,31.7571,NULL,1,NULL,NULL),(15874,760,607.27,31.6245,NULL,1,NULL,NULL),(15875,761,0.37,34.1224,NULL,NULL,NULL,NULL),(15876,761,0.99,36.0306,NULL,NULL,NULL,NULL),(15877,761,1.99,37.5204,NULL,NULL,NULL,NULL),(15878,761,2.92,39.4388,NULL,NULL,NULL,NULL),(15879,761,3.94,40.2857,NULL,NULL,NULL,NULL),(15880,761,7.25,43.0714,NULL,NULL,NULL,NULL),(15881,761,8.83,43.6633,NULL,NULL,NULL,NULL),(15882,761,13.08,43.7857,NULL,NULL,NULL,NULL),(15883,761,17.85,46.7449,NULL,NULL,NULL,NULL),(15884,761,19.33,46.9898,NULL,NULL,NULL,NULL),(15885,761,25.89,48.1735,NULL,NULL,NULL,NULL),(15886,761,31.08,49.602,NULL,NULL,NULL,NULL),(15887,761,35.97,50.6633,NULL,NULL,NULL,NULL),(15888,761,48.58,51.9898,NULL,NULL,NULL,NULL),(15889,761,58.76,52.7245,NULL,NULL,NULL,NULL),(15890,761,69,53.5714,NULL,1,NULL,NULL),(15891,761,69.57,27.6429,NULL,1,NULL,NULL),(15892,761,72.19,24.2857,NULL,1,NULL,NULL),(15893,761,73.39,23.1224,NULL,1,NULL,NULL),(15894,761,76.78,21.9592,NULL,1,NULL,NULL),(15895,761,81.99,21.051,NULL,1,NULL,NULL),(15896,761,87.19,20.5408,NULL,1,NULL,NULL),(15897,761,91.96,19.8163,NULL,1,NULL,NULL),(15898,761,99,19.5816,NULL,1,NULL,NULL),(15899,762,1.01,51.8673,NULL,NULL,NULL,NULL),(15900,762,1.98,56.7245,NULL,NULL,NULL,NULL),(15901,762,3.02,58.6735,NULL,NULL,NULL,NULL),(15902,762,4.06,59.398,NULL,NULL,NULL,NULL),(15903,762,6.87,63.4286,NULL,NULL,NULL,NULL),(15904,762,9.75,67.6429,NULL,NULL,NULL,NULL),(15905,762,11.3,67.9592,NULL,NULL,NULL,NULL),(15906,762,14,69.3265,NULL,NULL,NULL,NULL),(15907,762,17,69.8469,NULL,NULL,NULL,NULL),(15908,762,21.13,71.8673,NULL,NULL,NULL,NULL),(15909,762,25.14,74.5816,NULL,NULL,NULL,NULL),(15910,762,32.24,75.449,NULL,NULL,NULL,NULL),(15911,762,38.69,79.2449,NULL,NULL,NULL,NULL),(15912,762,49,81.6327,NULL,NULL,NULL,NULL),(15913,762,58.28,84.0714,NULL,NULL,NULL,NULL),(15914,762,71.31,88.0102,NULL,NULL,NULL,NULL),(15915,762,81.65,89.1735,NULL,NULL,NULL,NULL),(15916,762,103.34,92.1837,NULL,NULL,NULL,NULL),(15917,762,138.33,95.551,NULL,NULL,NULL,NULL),(15918,762,180.37,99.7245,NULL,NULL,NULL,NULL),(15919,762,233.43,102.041,NULL,NULL,NULL,NULL),(15920,762,301.51,104.592,NULL,NULL,NULL,NULL),(15921,762,382.67,108.367,NULL,NULL,NULL,NULL),(15922,762,461.75,110.408,NULL,1,NULL,NULL),(15923,762,576.96,112.041,NULL,1,NULL,NULL),(15924,762,581.5,78.1633,NULL,1,NULL,NULL),(15925,762,602.4,77.6122,NULL,1,NULL,NULL),(15926,763,0.22,49.602,NULL,NULL,NULL,NULL),(15927,763,0.94,55.5204,NULL,NULL,NULL,NULL),(15928,763,1.28,59.6429,NULL,NULL,NULL,NULL),(15929,763,1.85,61.8571,NULL,NULL,NULL,NULL),(15930,763,2.24,63.0102,NULL,NULL,NULL,NULL),(15931,763,3.03,65.3265,NULL,NULL,NULL,NULL),(15932,763,4.71,68.5918,NULL,NULL,NULL,NULL),(15933,763,6.04,69.6429,NULL,NULL,NULL,NULL),(15934,763,9,73.2755,NULL,NULL,NULL,NULL),(15935,763,14.39,76.6429,NULL,NULL,NULL,NULL),(15936,763,16.77,78.3775,NULL,NULL,NULL,NULL),(15937,763,21.68,80.9796,NULL,NULL,NULL,NULL),(15938,763,27.69,83.7143,NULL,NULL,NULL,NULL),(15939,763,35.25,87.2041,NULL,NULL,NULL,NULL),(15940,763,42.7,89.1735,NULL,NULL,NULL,NULL),(15941,763,50.44,92.1837,NULL,NULL,NULL,NULL),(15942,763,62.77,93.8061,NULL,NULL,NULL,NULL),(15943,763,68.43,94.3878,NULL,NULL,NULL,NULL),(15944,763,69.57,63.2245,NULL,1,NULL,NULL),(15945,763,70.43,57.0918,NULL,1,NULL,NULL),(15946,763,72.19,56,NULL,1,NULL,NULL),(15947,763,75.22,55.398,NULL,1,NULL,NULL),(15948,763,78.05,53.6939,NULL,1,NULL,NULL),(15949,763,81.32,52.8469,NULL,1,NULL,NULL),(15950,763,88.63,51.9898,NULL,1,NULL,NULL),(15951,763,98.19,51.6224,NULL,1,NULL,NULL),(15952,764,1.1,41.7,NULL,NULL,NULL,NULL),(15953,764,2.12,43.1898,NULL,NULL,NULL,NULL),(15954,764,3.1,44.5673,NULL,NULL,NULL,NULL),(15955,764,4,46.1796,NULL,NULL,NULL,NULL),(15956,764,5.05,46.8633,NULL,NULL,NULL,NULL),(15957,764,5.99,47.6694,NULL,NULL,NULL,NULL),(15958,764,7,48.1286,NULL,NULL,NULL,NULL),(15959,764,7.94,48.5878,NULL,NULL,NULL,NULL),(15960,764,9.12,49.6184,NULL,NULL,NULL,NULL),(15961,764,12.02,50.649,NULL,NULL,NULL,NULL),(15962,764,15.35,51.3224,NULL,NULL,NULL,NULL),(15963,764,19.2,52.4959,NULL,NULL,NULL,NULL),(15964,764,25.08,53.0878,NULL,NULL,NULL,NULL),(15965,764,29.63,53.1796,NULL,NULL,NULL,NULL),(15966,764,39.45,55.6388,NULL,NULL,NULL,NULL),(15967,764,50.15,55.9347,NULL,NULL,NULL,NULL),(15968,764,64.83,57.7918,NULL,NULL,NULL,NULL),(15969,764,72.18,58.5776,NULL,NULL,NULL,NULL),(15970,764,83.04,59.2714,NULL,NULL,NULL,NULL),(15971,764,90.91,59.2714,NULL,NULL,NULL,NULL),(15972,764,101.16,59.4653,NULL,NULL,NULL,NULL),(15973,764,107.51,61.4245,NULL,NULL,NULL,NULL),(15974,764,131.71,61.6694,NULL,NULL,NULL,NULL),(15975,764,158.07,61.9143,NULL,NULL,NULL,NULL),(15976,764,200.8,63.3939,NULL,NULL,NULL,NULL),(15977,764,256.13,64.4959,NULL,NULL,NULL,NULL),(15978,764,323.85,66.098,NULL,NULL,NULL,NULL),(15979,764,410.68,67.4449,NULL,NULL,NULL,NULL),(15980,764,516.51,68.1898,NULL,NULL,NULL,NULL),(15981,764,570.21,69.1694,NULL,NULL,NULL,NULL),(15982,765,0.2,43.3367,NULL,NULL,NULL,NULL),(15983,765,0.77,48.1531,NULL,NULL,NULL,NULL),(15984,765,2.01,51.5102,NULL,NULL,NULL,NULL),(15985,765,2.98,52.8878,NULL,NULL,NULL,NULL),(15986,765,3.98,53.9694,NULL,NULL,NULL,NULL),(15987,765,4.98,54.8469,NULL,NULL,NULL,NULL),(15988,765,6.01,56.6122,NULL,NULL,NULL,NULL),(15989,765,7.93,58.0816,NULL,NULL,NULL,NULL),(15990,765,8.96,57.5918,NULL,NULL,NULL,NULL),(15991,765,10.1,58.2857,NULL,NULL,NULL,NULL),(15992,765,13.03,59.1633,NULL,NULL,NULL,NULL),(15993,765,17.09,60.8367,NULL,NULL,NULL,NULL),(15994,765,20.37,61.2245,NULL,NULL,NULL,NULL),(15995,765,24.11,62.7041,NULL,NULL,NULL,NULL),(15996,765,29.13,63.1939,NULL,NULL,NULL,NULL),(15997,765,36.89,64.5408,NULL,NULL,NULL,NULL),(15998,765,41.38,67.9898,NULL,NULL,NULL,NULL),(15999,765,46.78,67.6225,NULL,NULL,NULL,NULL),(16000,765,55.51,68.3571,NULL,NULL,NULL,NULL),(16001,765,65.25,69.2143,NULL,NULL,NULL,NULL),(16002,765,70,69.4592,NULL,NULL,NULL,NULL),(16003,765,70.001,39.5408,NULL,1,NULL,NULL),(16004,765,75.1,39.1531,NULL,1,NULL,NULL),(16005,765,78.59,39.1531,NULL,1,NULL,NULL),(16006,765,79.57,36.7347,NULL,1,NULL,NULL),(16007,765,83.61,35.0816,NULL,1,NULL,NULL),(16008,765,90.42,34.6939,NULL,1,NULL,NULL),(16009,765,98.19,33.4184,NULL,1,NULL,NULL),(16010,766,0.11,53.5714,NULL,NULL,NULL,NULL),(16011,766,0.19,57.0102,NULL,NULL,NULL,NULL),(16012,766,1.18,66.6327,NULL,NULL,NULL,NULL),(16013,766,2.02,75.3061,NULL,NULL,NULL,NULL),(16014,766,3.03,77.7551,NULL,NULL,NULL,NULL),(16015,766,4,80.6327,NULL,NULL,NULL,NULL),(16016,766,5.06,81.7449,NULL,NULL,NULL,NULL),(16017,766,8.79,86.3265,NULL,NULL,NULL,NULL),(16018,766,10.92,86.5612,NULL,NULL,NULL,NULL),(16019,766,13.99,88.9082,NULL,NULL,NULL,NULL),(16020,766,18.18,89.3775,NULL,NULL,NULL,NULL),(16021,766,21.18,90.898,NULL,NULL,NULL,NULL),(16022,766,26.05,92.551,NULL,NULL,NULL,NULL),(16023,766,29.38,97.8878,NULL,NULL,NULL,NULL),(16024,766,43.72,99.3163,NULL,NULL,NULL,NULL),(16025,766,49.82,101.449,NULL,NULL,NULL,NULL),(16026,766,61.32,101.806,NULL,NULL,NULL,NULL),(16027,766,72.65,104.796,NULL,NULL,NULL,NULL),(16028,766,88.94,108.163,NULL,NULL,NULL,NULL),(16029,766,100.63,108.265,NULL,NULL,NULL,NULL),(16030,766,112.76,108.98,NULL,NULL,NULL,NULL),(16031,766,127.38,110.102,NULL,NULL,NULL,NULL),(16032,766,145.06,111.531,NULL,NULL,NULL,NULL),(16033,766,164.49,111.837,NULL,NULL,NULL,NULL),(16034,766,201.52,111.633,NULL,NULL,NULL,NULL),(16035,766,235.4,112.755,NULL,NULL,NULL,NULL),(16036,766,269.23,114.388,NULL,NULL,NULL,NULL),(16037,766,301.51,117.449,NULL,NULL,NULL,NULL),(16038,766,326.45,119.49,NULL,NULL,NULL,NULL),(16039,766,340.39,116.837,NULL,NULL,NULL,NULL),(16040,766,381.07,117.449,NULL,NULL,NULL,NULL),(16041,766,440.94,117.143,NULL,NULL,NULL,NULL),(16042,766,489.59,116.633,NULL,NULL,NULL,NULL),(16043,767,0.11,61.7143,NULL,NULL,NULL,NULL),(16044,767,0.76,72.0918,NULL,NULL,NULL,NULL),(16045,767,0.97,75.6429,NULL,NULL,NULL,NULL),(16046,767,1.67,82.2143,NULL,NULL,NULL,NULL),(16047,767,1.84,83.3878,NULL,NULL,NULL,NULL),(16048,767,3.9,94.6837,NULL,NULL,NULL,NULL),(16049,767,6.04,101.684,NULL,NULL,NULL,NULL),(16050,767,7.01,101.806,NULL,NULL,NULL,NULL),(16051,767,8.16,106.531,NULL,NULL,NULL,NULL),(16052,767,9.13,108.469,NULL,NULL,NULL,NULL),(16053,767,10.19,110,NULL,NULL,NULL,NULL),(16054,767,13.81,115.918,NULL,NULL,NULL,NULL),(16055,767,16.94,117.857,NULL,NULL,NULL,NULL),(16056,767,19.76,121.429,NULL,NULL,NULL,NULL),(16057,767,22.41,123.163,NULL,NULL,NULL,NULL),(16058,767,24.11,124.796,NULL,NULL,NULL,NULL),(16059,767,28.26,127.653,NULL,NULL,NULL,NULL),(16060,767,30.8,128.469,NULL,NULL,NULL,NULL),(16061,767,34.45,130.102,NULL,NULL,NULL,NULL),(16062,767,38.34,129.898,NULL,NULL,NULL,NULL),(16063,767,40.17,131.939,NULL,NULL,NULL,NULL),(16064,767,44.09,132.041,NULL,NULL,NULL,NULL),(16065,767,47.98,133.98,NULL,NULL,NULL,NULL),(16066,767,51.29,136.837,NULL,NULL,NULL,NULL),(16067,767,56.91,137.755,NULL,NULL,NULL,NULL),(16068,767,59.81,137.449,NULL,NULL,NULL,NULL),(16069,767,65.52,137.755,NULL,NULL,NULL,NULL),(16070,767,67.72,136.735,NULL,NULL,NULL,NULL),(16071,767,69.42,138.469,NULL,NULL,NULL,NULL),(16072,767,72.06,97.1735,NULL,1,NULL,NULL),(16073,767,73.56,92.0714,NULL,1,NULL,NULL),(16074,767,77.62,88.9082,NULL,1,NULL,NULL),(16075,767,79.24,87.6122,NULL,1,NULL,NULL),(16076,767,83.61,86.5612,NULL,1,NULL,NULL),(16077,767,89.68,85.9694,NULL,1,NULL,NULL),(16078,767,94.23,85.5,NULL,1,NULL,NULL),(16079,767,99,84.7959,NULL,1,NULL,NULL),(16080,768,0.18,45.2633,NULL,NULL,NULL,NULL),(16081,768,0.28,46.1306,NULL,NULL,NULL,NULL),(16082,768,0.86,51.0082,NULL,NULL,NULL,NULL),(16083,768,0.99,51.3449,NULL,NULL,NULL,NULL),(16084,768,1.14,51.2327,NULL,NULL,NULL,NULL),(16085,768,1.61,51.5694,NULL,NULL,NULL,NULL),(16086,768,2.02,53.3653,NULL,NULL,NULL,NULL),(16087,768,2.21,54.9367,NULL,NULL,NULL,NULL),(16088,768,2.9,55.8347,NULL,NULL,NULL,NULL),(16089,768,5.69,60.3143,NULL,NULL,NULL,NULL),(16090,768,6.27,59.9776,NULL,NULL,NULL,NULL),(16091,768,7.02,60.9878,NULL,NULL,NULL,NULL),(16092,768,7.92,61.1,NULL,NULL,NULL,NULL),(16093,768,8.88,61.8959,NULL,NULL,NULL,NULL),(16094,768,10.19,63.8449,NULL,NULL,NULL,NULL),(16095,768,12.77,65.2225,NULL,NULL,NULL,NULL),(16096,768,13.95,65.4469,NULL,NULL,NULL,NULL),(16097,768,15.02,65.7939,NULL,NULL,NULL,NULL),(16098,768,17.31,66.0286,NULL,NULL,NULL,NULL),(16099,768,20.29,66.1408,NULL,NULL,NULL,NULL),(16100,768,21.52,66.7122,NULL,NULL,NULL,NULL),(16101,768,23.7,68.3143,NULL,NULL,NULL,NULL),(16102,768,24.72,70.498,NULL,NULL,NULL,NULL),(16103,768,29.1,72.4367,NULL,NULL,NULL,NULL),(16104,768,32.49,72.1,NULL,NULL,NULL,NULL),(16105,768,35.76,73.2327,NULL,NULL,NULL,NULL),(16106,768,39.67,74.0184,NULL,NULL,NULL,NULL),(16107,768,42.43,75.3857,NULL,NULL,NULL,NULL),(16108,768,46.4,76.6306,NULL,NULL,NULL,NULL),(16109,768,50.61,77.5388,NULL,NULL,NULL,NULL),(16110,768,54.29,78.2225,NULL,NULL,NULL,NULL),(16111,768,58.72,77.651,NULL,NULL,NULL,NULL),(16112,768,64.3,80.4878,NULL,NULL,NULL,NULL),(16113,768,68.11,81.1612,NULL,NULL,NULL,NULL),(16114,768,73.65,83.498,NULL,NULL,NULL,NULL),(16115,768,92.3,86.651,NULL,NULL,NULL,NULL),(16116,768,107.38,87.4061,NULL,NULL,NULL,NULL),(16117,768,119.02,89.2939,NULL,NULL,NULL,NULL),(16118,768,166.25,98.0592,NULL,NULL,NULL,NULL),(16119,768,196.43,100.784,NULL,NULL,NULL,NULL),(16120,768,238.45,102.141,NULL,NULL,NULL,NULL),(16121,768,275.37,105.61,NULL,NULL,NULL,NULL),(16122,768,298.96,107.753,NULL,NULL,NULL,NULL),(16123,768,303.54,76.8551,NULL,1,NULL,NULL),(16124,768,309.36,72.1,NULL,1,NULL,NULL),(16125,769,0.05,45.7061,NULL,NULL,NULL,NULL),(16126,769,0.1,47.7673,NULL,NULL,NULL,NULL),(16127,769,0.77,53.951,NULL,NULL,NULL,NULL),(16128,769,0.94,55.1857,NULL,NULL,NULL,NULL),(16129,769,1.12,56.298,NULL,NULL,NULL,NULL),(16130,769,1.63,58.2061,NULL,NULL,NULL,NULL),(16131,769,2.12,58.6551,NULL,NULL,NULL,NULL),(16132,769,3.07,59.4408,NULL,NULL,NULL,NULL),(16133,769,5.19,66.6245,NULL,NULL,NULL,NULL),(16134,769,7.14,67.3184,NULL,NULL,NULL,NULL),(16135,769,8.05,69.1551,NULL,NULL,NULL,NULL),(16136,769,9.2,69.6143,NULL,NULL,NULL,NULL),(16137,769,10.16,69.6143,NULL,NULL,NULL,NULL),(16138,769,13.03,72.5735,NULL,NULL,NULL,NULL),(16139,769,14.36,73.5939,NULL,NULL,NULL,NULL),(16140,769,15.25,73.8184,NULL,NULL,NULL,NULL),(16141,769,16.33,76.6551,NULL,NULL,NULL,NULL),(16142,769,21.36,81.5327,NULL,NULL,NULL,NULL),(16143,769,23.82,82.1653,NULL,NULL,NULL,NULL),(16144,769,27.46,82.4102,NULL,NULL,NULL,NULL),(16145,769,30.26,83.4204,NULL,NULL,NULL,NULL),(16146,769,35.44,87.5837,NULL,NULL,NULL,NULL),(16147,769,41.14,88.5837,NULL,NULL,NULL,NULL),(16148,769,45.6,89.9714,NULL,NULL,NULL,NULL),(16149,769,51.26,91.1041,NULL,NULL,NULL,NULL),(16150,769,56.37,92.6449,NULL,NULL,NULL,NULL),(16151,769,63.01,95.7061,NULL,NULL,NULL,NULL),(16152,769,66.2,96.2673,NULL,NULL,NULL,NULL),(16153,769,78.03,98.4306,NULL,NULL,NULL,NULL),(16154,769,81.3,53.7265,NULL,1,NULL,NULL),(16155,769,84.36,53.0531,NULL,1,NULL,NULL),(16156,769,87.89,52.4918,NULL,1,NULL,NULL),(16157,769,96.58,52.4918,NULL,1,NULL,NULL),(16158,769,101.13,51.4816,NULL,1,NULL,NULL),(16159,770,0.17,73.6939,NULL,NULL,NULL,NULL),(16160,770,0.27,77.7755,NULL,NULL,NULL,NULL),(16161,770,1.04,85.7857,NULL,NULL,NULL,NULL),(16162,770,2.18,93.7653,NULL,NULL,NULL,NULL),(16163,770,3.53,97.7347,NULL,NULL,NULL,NULL),(16164,770,6.25,105.204,NULL,NULL,NULL,NULL),(16165,770,8.22,108.367,NULL,NULL,NULL,NULL),(16166,770,10.38,110.102,NULL,NULL,NULL,NULL),(16167,770,14.51,112.245,NULL,NULL,NULL,NULL),(16168,770,17.43,113.571,NULL,NULL,NULL,NULL),(16169,770,20.16,114.796,NULL,NULL,NULL,NULL),(16170,770,22.11,115.612,NULL,NULL,NULL,NULL),(16171,770,24.45,117.755,NULL,NULL,NULL,NULL),(16172,770,28.64,121.327,NULL,NULL,NULL,NULL),(16173,770,30.14,123.776,NULL,NULL,NULL,NULL),(16174,770,36.14,127.449,NULL,NULL,NULL,NULL),(16175,770,42.47,128.571,NULL,NULL,NULL,NULL),(16176,770,51.28,130,NULL,NULL,NULL,NULL),(16177,770,56.86,130.714,NULL,NULL,NULL,NULL),(16178,770,65.41,132.653,NULL,NULL,NULL,NULL),(16179,770,71.6,134.286,NULL,NULL,NULL,NULL),(16180,770,78.37,135.816,NULL,NULL,NULL,NULL),(16181,770,84.72,135.918,NULL,NULL,NULL,NULL),(16182,770,100.28,135,NULL,NULL,NULL,NULL),(16183,770,106.04,137.449,NULL,NULL,NULL,NULL),(16184,770,113.58,141.939,NULL,NULL,NULL,NULL),(16185,770,125.89,145.102,NULL,NULL,NULL,NULL),(16186,770,162.77,147.449,NULL,NULL,NULL,NULL),(16187,770,189.05,149.286,NULL,NULL,NULL,NULL),(16188,770,203.14,151.02,NULL,NULL,NULL,NULL),(16189,770,246.47,157.857,NULL,NULL,NULL,NULL),(16190,770,278.82,157.347,NULL,NULL,NULL,NULL),(16191,770,305.89,157.653,NULL,NULL,NULL,NULL),(16192,770,307.06,110.408,NULL,1,NULL,NULL),(16193,770,316.53,108.673,NULL,1,NULL,NULL),(16194,770,326.29,108.367,NULL,1,NULL,NULL),(16195,771,0.79,84.4082,NULL,NULL,NULL,NULL),(16196,771,1.03,86.6735,NULL,NULL,NULL,NULL),(16197,771,1.27,91.0816,NULL,NULL,NULL,NULL),(16198,771,1.84,93.6531,NULL,NULL,NULL,NULL),(16199,771,3.09,99.2041,NULL,NULL,NULL,NULL),(16200,771,7.22,111.633,NULL,NULL,NULL,NULL),(16201,771,8.14,114.184,NULL,NULL,NULL,NULL),(16202,771,9.35,114.898,NULL,NULL,NULL,NULL),(16203,771,10.28,115.714,NULL,NULL,NULL,NULL),(16204,771,13.42,121.735,NULL,NULL,NULL,NULL),(16205,771,14.32,122.551,NULL,NULL,NULL,NULL),(16206,771,15.34,125.714,NULL,NULL,NULL,NULL),(16207,771,16.13,126.633,NULL,NULL,NULL,NULL),(16208,771,20.5,130.102,NULL,NULL,NULL,NULL),(16209,771,22.2,135.408,NULL,NULL,NULL,NULL),(16210,771,27.82,136.327,NULL,NULL,NULL,NULL),(16211,771,30.72,139.082,NULL,NULL,NULL,NULL),(16212,771,47.49,149.286,NULL,NULL,NULL,NULL),(16213,771,50.44,149.286,NULL,NULL,NULL,NULL),(16214,771,57.56,151.327,NULL,NULL,NULL,NULL),(16215,771,64.34,152.245,NULL,NULL,NULL,NULL),(16216,771,71.89,156.224,NULL,NULL,NULL,NULL),(16217,771,72.49,100.684,NULL,1,NULL,NULL),(16218,771,74.91,98.8673,NULL,1,NULL,NULL),(16219,771,80.65,95.5816,NULL,1,NULL,NULL),(16220,771,85.42,95.1225,NULL,1,NULL,NULL),(16221,771,87.91,92.9694,NULL,1,NULL,NULL),(16222,771,93.1,91.4592,NULL,1,NULL,NULL),(16223,772,0.14,4.03,NULL,NULL,NULL,NULL),(16224,772,1.01,4.327,NULL,NULL,NULL,NULL),(16225,772,2.21,4.561,NULL,NULL,NULL,NULL),(16226,772,5.82,4.95,NULL,NULL,NULL,NULL),(16227,772,12.74,5.275,NULL,NULL,NULL,NULL),(16228,772,27.63,5.66,NULL,NULL,NULL,NULL),(16229,772,65.25,6.093,NULL,NULL,NULL,NULL),(16230,772,98.07,6.287,NULL,NULL,NULL,NULL),(16231,772,189.4,6.606,NULL,NULL,NULL,NULL),(16232,773,0.03,2.198,NULL,NULL,NULL,NULL),(16233,773,0.46,2.643,NULL,NULL,NULL,NULL),(16234,773,0.96,2.927,NULL,NULL,NULL,NULL),(16235,773,2.27,3.298,NULL,NULL,NULL,NULL),(16236,773,3.01,3.465,NULL,NULL,NULL,NULL),(16237,773,4.09,3.612,NULL,NULL,NULL,NULL),(16238,773,6.94,3.971,NULL,NULL,NULL,NULL),(16239,773,9.28,4.162,NULL,NULL,NULL,NULL),(16240,773,20.65,4.712,NULL,NULL,NULL,NULL),(16241,773,30.47,5.006,NULL,NULL,NULL,NULL),(16242,773,56.64,5.437,NULL,NULL,NULL,NULL),(16243,773,184.8,6.247,NULL,NULL,NULL,NULL),(16244,774,1.1278,397.842,NULL,NULL,NULL,NULL),(16245,774,7.5188,442.464,NULL,NULL,NULL,NULL),(16246,774,30.827,492.304,NULL,NULL,NULL,NULL),(16247,774,50.376,513.659,NULL,NULL,NULL,NULL),(16248,774,71.053,536.044,NULL,NULL,NULL,NULL),(16249,774,100.38,555.368,NULL,NULL,NULL,NULL),(16250,774,151.71,586.894,NULL,NULL,NULL,NULL),(16251,774,201.52,612.33,NULL,NULL,NULL,NULL),(16252,774,250.19,630.633,NULL,NULL,NULL,NULL),(16253,774,300.76,649.841,NULL,NULL,NULL,NULL),(16254,774,350.94,662.946,NULL,NULL,NULL,NULL),(16255,774,405.66,672.013,NULL,NULL,NULL,NULL),(16256,775,1.1278,677.051,NULL,NULL,NULL,NULL),(16257,775,6.7669,745.557,NULL,NULL,NULL,NULL),(16258,775,33.083,850.34,NULL,NULL,NULL,NULL),(16259,775,50.752,882.026,NULL,NULL,NULL,NULL),(16260,775,100.38,924.947,NULL,NULL,NULL,NULL),(16261,775,152.47,958.673,NULL,NULL,NULL,NULL),(16262,775,201.14,988.318,NULL,NULL,NULL,NULL),(16263,775,250.57,1008.76,NULL,NULL,NULL,NULL),(16264,775,301.13,1027.16,NULL,NULL,NULL,NULL),(16265,775,352.08,1044.53,NULL,NULL,NULL,NULL),(16266,775,406.04,1063.99,NULL,NULL,NULL,NULL),(16267,776,1.1278,318.878,NULL,NULL,NULL,NULL),(16268,776,15.414,357.345,NULL,NULL,NULL,NULL),(16269,776,33.459,376.584,NULL,NULL,NULL,NULL),(16270,776,50.376,391.762,NULL,NULL,NULL,NULL),(16271,776,100,419.101,NULL,NULL,NULL,NULL),(16272,776,151.33,442.464,NULL,NULL,NULL,NULL),(16273,776,199.62,464.838,NULL,NULL,NULL,NULL),(16274,776,250.19,482.132,NULL,NULL,NULL,NULL),(16275,776,300,497.385,NULL,NULL,NULL,NULL),(16276,776,350.19,508.578,NULL,NULL,NULL,NULL),(16277,776,404.53,519.77,NULL,NULL,NULL,NULL),(16278,777,1.5038,582.834,NULL,NULL,NULL,NULL),(16279,777,15.414,637.755,NULL,NULL,NULL,NULL),(16280,777,51.128,675.032,NULL,NULL,NULL,NULL),(16281,777,100,701.233,NULL,NULL,NULL,NULL),(16282,777,152.09,723.395,NULL,NULL,NULL,NULL),(16283,777,201.14,737.5,NULL,NULL,NULL,NULL),(16284,777,250.95,746.567,NULL,NULL,NULL,NULL),(16285,777,301.51,758.652,NULL,NULL,NULL,NULL),(16286,777,351.7,765.71,NULL,NULL,NULL,NULL),(16287,777,405.66,771.758,NULL,NULL,NULL,NULL),(16288,778,0.01,44.0506,NULL,NULL,NULL,NULL),(16289,778,0.5,69.7472,NULL,NULL,NULL,NULL),(16290,778,1.8834,86.7062,NULL,NULL,NULL,NULL),(16291,778,5.9193,101.752,NULL,NULL,NULL,NULL),(16292,778,13.049,122.52,NULL,NULL,NULL,NULL),(16293,778,20.718,142.729,NULL,NULL,NULL,NULL),(16294,778,27.309,159.59,NULL,NULL,NULL,NULL),(16295,778,41.674,169.285,NULL,NULL,NULL,NULL),(16296,778,62.857,179.555,NULL,NULL,NULL,NULL),(16297,778,83.636,185.911,NULL,NULL,NULL,NULL),(16298,778,95.696,190.628,NULL,NULL,NULL,NULL),(16299,778,111.65,191.805,NULL,NULL,NULL,NULL),(16300,779,0.01,34.7025,NULL,NULL,NULL,NULL),(16301,779,0.5,43.1711,NULL,NULL,NULL,NULL),(16302,779,2.5561,44.8234,NULL,NULL,NULL,NULL),(16303,779,6.0538,47.9223,NULL,NULL,NULL,NULL),(16304,779,11.3,51.4333,NULL,NULL,NULL,NULL),(16305,779,19.91,52.8791,NULL,NULL,NULL,NULL),(16306,779,34.519,57.011,NULL,NULL,NULL,NULL),(16307,779,45.188,59.2826,NULL,NULL,NULL,NULL),(16308,779,55.732,59.2826,NULL,NULL,NULL,NULL),(16309,779,76.494,61.1421,NULL,NULL,NULL,NULL),(16310,779,91.646,62.3815,NULL,NULL,NULL,NULL),(16311,780,0.01,48.6785,NULL,NULL,NULL,NULL),(16312,780,0.5,64.9644,NULL,NULL,NULL,NULL),(16313,780,2.0359,74.6996,NULL,NULL,NULL,NULL),(16314,780,5.988,83.8704,NULL,NULL,NULL,NULL),(16315,780,13.413,91.1741,NULL,NULL,NULL,NULL),(16316,780,19.88,93.6113,NULL,NULL,NULL,NULL),(16317,780,34.012,97.3522,NULL,NULL,NULL,NULL),(16318,780,50.299,99.0364,NULL,NULL,NULL,NULL),(16319,780,70.512,101.287,NULL,NULL,NULL,NULL),(16320,780,87.52,102.599,NULL,NULL,NULL,NULL),(16321,781,0.1198,34.7328,NULL,NULL,NULL,NULL),(16322,781,1.0778,48.0835,NULL,NULL,NULL,NULL),(16323,781,3.7126,57.7449,NULL,NULL,NULL,NULL),(16324,781,5.7485,61.6967,NULL,NULL,NULL,NULL),(16325,781,13.054,68.2839,NULL,NULL,NULL,NULL),(16326,781,18.683,70.4787,NULL,NULL,NULL,NULL),(16327,781,27.425,73.7727,NULL,NULL,NULL,NULL),(16328,781,34.371,76.1419,NULL,NULL,NULL,NULL),(16329,781,47.305,77.6429,NULL,NULL,NULL,NULL),(16330,781,62.008,80.4314,NULL,NULL,NULL,NULL),(16331,781,75.118,81.0751,NULL,NULL,NULL,NULL),(16332,781,90,85.3646,NULL,NULL,NULL,NULL),(16333,782,0.5517,2.0001,NULL,NULL,NULL,NULL),(16334,782,1.7931,5.18684,NULL,NULL,NULL,NULL),(16335,782,4.5517,7.76327,NULL,NULL,NULL,NULL),(16336,782,9.6552,10.5092,NULL,NULL,NULL,NULL),(16337,782,15.103,12.6112,NULL,NULL,NULL,NULL),(16338,782,19.862,13.6959,NULL,NULL,NULL,NULL),(16339,782,24.552,14.7806,NULL,NULL,NULL,NULL),(16340,782,29.793,15.6622,NULL,NULL,NULL,NULL),(16341,782,35.448,16.7806,NULL,NULL,NULL,NULL),(16342,782,39.655,17.1194,NULL,NULL,NULL,NULL),(16343,782,45,17.9,NULL,NULL,NULL,NULL),(16344,782,50.069,18.7133,NULL,NULL,NULL,NULL),(16345,782,50.89,18.8153,NULL,NULL,NULL,NULL),(16346,782,51.781,18.4755,NULL,NULL,NULL,NULL),(16347,782,53.288,19.2214,NULL,NULL,NULL,NULL),(16348,782,59.795,19.798,NULL,NULL,NULL,NULL),(16349,782,60.486,19.9,NULL,NULL,NULL,NULL),(16350,783,0.4828,1.76286,NULL,NULL,NULL,NULL),(16351,783,1.931,5.25459,NULL,NULL,NULL,NULL),(16352,783,4.5517,7.66153,NULL,NULL,NULL,NULL),(16353,783,9.7241,9.79725,NULL,NULL,NULL,NULL),(16354,783,12.966,11.5602,NULL,NULL,NULL,NULL),(16355,783,15.241,11.899,NULL,NULL,NULL,NULL),(16356,783,19.793,13.1878,NULL,NULL,NULL,NULL),(16357,783,24.828,14.7133,NULL,NULL,NULL,NULL),(16358,783,29.862,15.4592,NULL,NULL,NULL,NULL),(16359,783,35.517,16.3745,NULL,NULL,NULL,NULL),(16360,783,39.724,17.3571,NULL,NULL,NULL,NULL),(16361,783,45.069,18.2724,NULL,NULL,NULL,NULL),(16362,783,50.069,19.2898,NULL,NULL,NULL,NULL),(16363,783,52.466,19.6622,NULL,NULL,NULL,NULL),(16364,783,55.616,19.9337,NULL,NULL,NULL,NULL),(16365,783,59.726,20.3408,NULL,NULL,NULL,NULL),(16366,783,60.556,20.4082,NULL,NULL,NULL,NULL),(16367,784,0.2069,1.35602,NULL,NULL,NULL,NULL),(16368,784,4.6207,3.83082,NULL,NULL,NULL,NULL),(16369,784,9.7241,4.98337,NULL,NULL,NULL,NULL),(16370,784,15.035,6.30551,NULL,NULL,NULL,NULL),(16371,784,19.931,7.79714,NULL,NULL,NULL,NULL),(16372,784,25.172,8.27173,NULL,NULL,NULL,NULL),(16373,784,30,8.71245,NULL,NULL,NULL,NULL),(16374,784,33.241,9.28878,NULL,NULL,NULL,NULL),(16375,784,34.69,8.84806,NULL,NULL,NULL,NULL),(16376,784,39.862,9.08541,NULL,NULL,NULL,NULL),(16377,784,44.795,9.49214,NULL,NULL,NULL,NULL),(16378,784,49.932,9.93286,NULL,NULL,NULL,NULL),(16379,784,55.343,10.3061,NULL,NULL,NULL,NULL),(16380,784,59.932,10.5429,NULL,NULL,NULL,NULL),(16381,784,65.069,10.848,NULL,NULL,NULL,NULL),(16382,784,69.931,11.1194,NULL,NULL,NULL,NULL),(16383,784,75.139,11.3908,NULL,NULL,NULL,NULL),(16384,784,79.861,11.4929,NULL,NULL,NULL,NULL),(16385,784,84.778,11.8316,NULL,NULL,NULL,NULL),(16386,784,90.375,12.2041,NULL,NULL,NULL,NULL),(16387,785,0.4828,1.72898,NULL,NULL,NULL,NULL),(16388,785,4.4138,4.06806,NULL,NULL,NULL,NULL),(16389,785,9.7931,5.52582,NULL,NULL,NULL,NULL),(16390,785,15.241,6.7801,NULL,NULL,NULL,NULL),(16391,785,18.138,8.03449,NULL,NULL,NULL,NULL),(16392,785,19.793,8.00051,NULL,NULL,NULL,NULL),(16393,785,24.828,8.67857,NULL,NULL,NULL,NULL),(16394,785,29.931,9.15316,NULL,NULL,NULL,NULL),(16395,785,33.655,9.69561,NULL,NULL,NULL,NULL),(16396,785,34.897,9.35653,NULL,NULL,NULL,NULL),(16397,785,39.862,9.69561,NULL,NULL,NULL,NULL),(16398,785,44.932,10.0007,NULL,NULL,NULL,NULL),(16399,785,50.069,10.3398,NULL,NULL,NULL,NULL),(16400,785,55.274,10.7469,NULL,NULL,NULL,NULL),(16401,785,59.795,11.052,NULL,NULL,NULL,NULL),(16402,785,65,11.4245,NULL,NULL,NULL,NULL),(16403,785,69.931,11.798,NULL,NULL,NULL,NULL),(16404,785,75.347,12.0684,NULL,NULL,NULL,NULL),(16405,785,79.653,12.3061,NULL,NULL,NULL,NULL),(16406,785,84.642,12.6786,NULL,NULL,NULL,NULL),(16407,785,90.58,13.052,NULL,NULL,NULL,NULL),(16408,786,0.2653,8.50337,NULL,NULL,NULL,NULL),(16409,786,5.305,27.4378,NULL,NULL,NULL,NULL),(16410,786,10.743,31.2929,NULL,NULL,NULL,NULL),(16411,786,50.928,62.1704,NULL,NULL,NULL,NULL),(16412,786,65.915,65.549,NULL,NULL,NULL,NULL),(16413,786,102.79,73.5459,NULL,NULL,NULL,NULL),(16414,786,156.63,73.9969,NULL,NULL,NULL,NULL),(16415,787,0.2653,7.93653,NULL,NULL,NULL,NULL),(16416,787,1.5915,30.6122,NULL,NULL,NULL,NULL),(16417,787,6.8966,73.7714,NULL,NULL,NULL,NULL),(16418,787,10.743,81.3173,NULL,NULL,NULL,NULL),(16419,787,50.531,100.914,NULL,NULL,NULL,NULL),(16420,787,65.783,107.786,NULL,NULL,NULL,NULL),(16421,787,100.93,109.357,NULL,NULL,NULL,NULL),(16422,787,157.29,111.276,NULL,NULL,NULL,NULL),(16423,788,0.3979,6.00908,NULL,NULL,NULL,NULL),(16424,788,6.6313,50.7939,NULL,NULL,NULL,NULL),(16425,788,11.406,55.9765,NULL,NULL,NULL,NULL),(16426,788,50.531,76.7,NULL,NULL,NULL,NULL),(16427,788,66.446,80.6418,NULL,NULL,NULL,NULL),(16428,788,101.19,86.1602,NULL,NULL,NULL,NULL),(16429,788,156.76,91.1163,NULL,NULL,NULL,NULL),(16430,789,0.5305,4.08163,NULL,NULL,NULL,NULL),(16431,789,6.8966,65.099,NULL,NULL,NULL,NULL),(16432,789,10.345,75.2357,NULL,NULL,NULL,NULL),(16433,789,50.796,96.2969,NULL,NULL,NULL,NULL),(16434,789,66.048,98.8878,NULL,NULL,NULL,NULL),(16435,789,100.93,101.703,NULL,NULL,NULL,NULL),(16436,789,157.29,105.418,NULL,NULL,NULL,NULL),(16437,790,0.3575,2.08092,NULL,NULL,NULL,NULL),(16438,790,2.0551,3.78163,NULL,NULL,NULL,NULL),(16439,790,3.9649,6.72949,NULL,NULL,NULL,NULL),(16440,790,19.137,17.6143,NULL,NULL,NULL,NULL),(16441,790,29.217,15.4592,NULL,NULL,NULL,NULL),(16442,790,43.434,17.8408,NULL,NULL,NULL,NULL),(16443,790,99.668,20.448,NULL,NULL,NULL,NULL),(16444,790,157.04,26.5704,NULL,NULL,NULL,NULL),(16445,791,0.2653,3.74153,NULL,NULL,NULL,NULL),(16446,791,2.069,13.8327,NULL,NULL,NULL,NULL),(16447,791,4.0849,21.3153,NULL,NULL,NULL,NULL),(16448,791,19.204,46.4857,NULL,NULL,NULL,NULL),(16449,791,30.61,55.3,NULL,NULL,NULL,NULL),(16450,791,45.464,61.2694,NULL,NULL,NULL,NULL),(16451,791,100.8,81.7684,NULL,NULL,NULL,NULL),(16452,791,157.29,102.265,NULL,NULL,NULL,NULL),(16453,792,0.7427,3.62816,NULL,NULL,NULL,NULL),(16454,792,4.2971,7.02949,NULL,NULL,NULL,NULL),(16455,792,19.151,13.9459,NULL,NULL,NULL,NULL),(16456,792,29.549,14.1724,NULL,NULL,NULL,NULL),(16457,792,43.13,15.5327,NULL,NULL,NULL,NULL),(16458,792,100,17.6867,NULL,NULL,NULL,NULL),(16459,792,157.03,23.0163,NULL,NULL,NULL,NULL),(16460,793,0.3183,9.29704,NULL,NULL,NULL,NULL),(16461,793,2.1751,20.5214,NULL,NULL,NULL,NULL),(16462,793,4.0849,27.6643,NULL,NULL,NULL,NULL),(16463,793,19.257,46.3714,NULL,NULL,NULL,NULL),(16464,793,31.459,49.6602,NULL,NULL,NULL,NULL),(16465,793,46.101,58.5663,NULL,NULL,NULL,NULL),(16466,793,100.93,77.2622,NULL,NULL,NULL,NULL),(16467,793,156.9,94.0439,NULL,NULL,NULL,NULL),(16468,794,0.7566,5.21541,NULL,NULL,NULL,NULL),(16469,794,2.3481,7.25622,NULL,NULL,NULL,NULL),(16470,794,4.2579,9.07031,NULL,NULL,NULL,NULL),(16471,794,19.324,19.9551,NULL,NULL,NULL,NULL),(16472,794,30.518,20.5214,NULL,NULL,NULL,NULL),(16473,794,44.735,21.5418,NULL,NULL,NULL,NULL),(16474,794,100.65,24.9429,NULL,NULL,NULL,NULL),(16475,794,157.55,29.0245,NULL,NULL,NULL,NULL),(16476,795,0.3714,6.80275,NULL,NULL,NULL,NULL),(16477,795,2.0159,17.3469,NULL,NULL,NULL,NULL),(16478,795,3.9788,24.3765,NULL,NULL,NULL,NULL),(16479,795,18.886,48.4122,NULL,NULL,NULL,NULL),(16480,795,30.61,51.6959,NULL,NULL,NULL,NULL),(16481,795,45.464,55.5255,NULL,NULL,NULL,NULL),(16482,795,100.66,71.8561,NULL,NULL,NULL,NULL),(16483,795,156.9,89.7643,NULL,NULL,NULL,NULL),(16484,796,1.5198,3.28776,NULL,NULL,NULL,NULL),(16485,796,6.383,3.89653,NULL,NULL,NULL,NULL),(16486,796,11.246,5.23602,NULL,NULL,NULL,NULL),(16487,796,21.277,6.69725,NULL,NULL,NULL,NULL),(16488,796,30.091,6.69725,NULL,NULL,NULL,NULL),(16489,796,39.818,8.03663,NULL,NULL,NULL,NULL),(16490,796,69.909,8.64551,NULL,NULL,NULL,NULL),(16491,796,119.94,10.2286,NULL,NULL,NULL,NULL),(16492,796,160.12,12.1765,NULL,NULL,NULL,NULL),(16493,796,209.15,15.952,NULL,NULL,NULL,NULL),(16494,796,230.49,16.1949,NULL,NULL,NULL,NULL),(16495,796,329.88,17.2908,NULL,NULL,NULL,NULL),(16496,796,392.68,20.5786,NULL,NULL,NULL,NULL),(16497,797,1.2158,11.3245,NULL,NULL,NULL,NULL),(16498,797,5.1672,12.0551,NULL,NULL,NULL,NULL),(16499,797,9.4225,16.9255,NULL,NULL,NULL,NULL),(16500,797,20.973,21.0653,NULL,NULL,NULL,NULL),(16501,797,32.219,22.8918,NULL,NULL,NULL,NULL),(16502,797,41.337,23.9878,NULL,NULL,NULL,NULL),(16503,797,70.517,26.6673,NULL,NULL,NULL,NULL),(16504,797,119.64,30.0765,NULL,NULL,NULL,NULL),(16505,797,160.12,31.7816,NULL,NULL,NULL,NULL),(16506,797,209.15,34.9469,NULL,NULL,NULL,NULL),(16507,797,230.79,36.8959,NULL,NULL,NULL,NULL),(16508,797,330.18,39.2092,NULL,NULL,NULL,NULL),(16509,797,393.29,43.2276,NULL,NULL,NULL,NULL),(16510,798,1.5198,13.0296,NULL,NULL,NULL,NULL),(16511,798,5.4711,23.6224,NULL,NULL,NULL,NULL),(16512,798,10.638,34.0949,NULL,NULL,NULL,NULL),(16513,798,20.973,40.3051,NULL,NULL,NULL,NULL),(16514,798,32.219,44.201,NULL,NULL,NULL,NULL),(16515,798,41.033,50.2898,NULL,NULL,NULL,NULL),(16516,798,68.693,55.3939,NULL,NULL,NULL,NULL),(16517,798,122.05,63.8969,NULL,NULL,NULL,NULL),(16518,798,160.42,66.8122,NULL,NULL,NULL,NULL),(16519,798,209.76,69.6061,NULL,NULL,NULL,NULL),(16520,798,329.57,76.0449,NULL,NULL,NULL,NULL),(16521,798,392.07,79.4459,NULL,NULL,NULL,NULL),(16522,799,0.304,15.5867,NULL,NULL,NULL,NULL),(16523,799,8.2067,48.95,NULL,NULL,NULL,NULL),(16524,799,10.334,60.6173,NULL,NULL,NULL,NULL),(16525,799,21.277,80.4184,NULL,NULL,NULL,NULL),(16526,799,28.268,83.2122,NULL,NULL,NULL,NULL),(16527,799,40.122,93.7806,NULL,NULL,NULL,NULL),(16528,799,67.781,99.7327,NULL,NULL,NULL,NULL),(16529,799,121.15,110.541,NULL,NULL,NULL,NULL),(16530,799,161.93,117.469,NULL,NULL,NULL,NULL),(16531,799,210.37,125.724,NULL,NULL,NULL,NULL),(16532,799,330.79,143.224,NULL,NULL,NULL,NULL),(16533,799,393.9,151.357,NULL,NULL,NULL,NULL),(16534,800,0.304,8.03663,NULL,NULL,NULL,NULL),(16535,800,5.1672,16.9255,NULL,NULL,NULL,NULL),(16536,800,10.334,23.501,NULL,NULL,NULL,NULL),(16537,800,20.061,30.8071,NULL,NULL,NULL,NULL),(16538,800,31.003,36.1653,NULL,NULL,NULL,NULL),(16539,800,40.426,40.0612,NULL,NULL,NULL,NULL),(16540,800,72.948,50.2898,NULL,NULL,NULL,NULL),(16541,800,120.54,61.2245,NULL,NULL,NULL,NULL),(16542,800,161.03,68.6347,NULL,NULL,NULL,NULL),(16543,800,210.67,77.9888,NULL,NULL,NULL,NULL),(16544,800,230.49,79.8102,NULL,NULL,NULL,NULL),(16545,800,330.79,88.0714,NULL,NULL,NULL,NULL),(16546,800,393.6,90.8653,NULL,NULL,NULL,NULL),(16547,801,0.304,12.1765,NULL,NULL,NULL,NULL),(16548,801,4.5593,26.0582,NULL,NULL,NULL,NULL),(16549,801,8.8146,43.9582,NULL,NULL,NULL,NULL),(16550,802,0.304,9.37602,NULL,NULL,NULL,NULL),(16551,802,5.4711,47.4888,NULL,NULL,NULL,NULL),(16552,802,10.334,65.3551,NULL,NULL,NULL,NULL),(16553,802,19.453,76.5306,NULL,NULL,NULL,NULL),(16554,802,27.964,81.3898,NULL,NULL,NULL,NULL),(16555,802,39.818,87.4633,NULL,NULL,NULL,NULL),(16556,802,68.085,92.9296,NULL,NULL,NULL,NULL),(16557,802,120.54,103.745,NULL,NULL,NULL,NULL),(16558,802,159.82,103.622,NULL,NULL,NULL,NULL),(16559,802,209.76,103.378,NULL,NULL,NULL,NULL),(16560,802,329.27,103.99,NULL,NULL,NULL,NULL),(16561,802,391.16,104.102,NULL,NULL,NULL,NULL),(16562,803,0.9119,34.5816,NULL,NULL,NULL,NULL),(16563,803,4.8632,70.3357,NULL,NULL,NULL,NULL),(16564,803,9.1185,88.1929,NULL,NULL,NULL,NULL),(16565,803,19.149,102.286,NULL,NULL,NULL,NULL),(16566,803,30.091,108.847,NULL,NULL,NULL,NULL),(16567,803,42.553,112.735,NULL,NULL,NULL,NULL),(16568,803,68.389,118.929,NULL,NULL,NULL,NULL),(16569,803,121.15,125.969,NULL,NULL,NULL,NULL),(16570,803,160.42,129.612,NULL,NULL,NULL,NULL),(16571,803,208.54,130.224,NULL,NULL,NULL,NULL),(16572,803,329.27,131.316,NULL,NULL,NULL,NULL),(16573,803,391.16,133.265,NULL,NULL,NULL,NULL),(16574,804,5.7751,5.23602,NULL,NULL,NULL,NULL),(16575,804,10.942,7.9149,NULL,NULL,NULL,NULL),(16576,804,19.453,10.4724,NULL,NULL,NULL,NULL),(16577,804,30.699,11.8112,NULL,NULL,NULL,NULL),(16578,804,39.514,13.2724,NULL,NULL,NULL,NULL),(16579,804,69.605,16.4388,NULL,NULL,NULL,NULL),(16580,804,119.64,19.4827,NULL,NULL,NULL,NULL),(16581,804,159.52,21.6745,NULL,NULL,NULL,NULL),(16582,804,209.15,26.4235,NULL,NULL,NULL,NULL),(16583,804,230.49,28.0061,NULL,NULL,NULL,NULL),(16584,804,330.18,34.0949,NULL,NULL,NULL,NULL),(16585,804,392.99,39.2092,NULL,NULL,NULL,NULL),(16586,805,0.304,6.2101,NULL,NULL,NULL,NULL),(16587,805,5.4711,8.76725,NULL,NULL,NULL,NULL),(16588,805,13.374,16.4388,NULL,NULL,NULL,NULL),(16589,805,20.365,24.4755,NULL,NULL,NULL,NULL),(16590,805,31.003,30.5633,NULL,NULL,NULL,NULL),(16591,805,40.73,35.8,NULL,NULL,NULL,NULL),(16592,805,73.556,47.1235,NULL,NULL,NULL,NULL),(16593,805,119.64,63.4112,NULL,NULL,NULL,NULL),(16594,805,161.33,70.3357,NULL,NULL,NULL,NULL),(16595,805,210.67,76.1663,NULL,NULL,NULL,NULL),(16596,805,235.06,78.7173,NULL,NULL,NULL,NULL),(16597,805,331.1,81.7541,NULL,NULL,NULL,NULL),(16598,805,394.21,87.3418,NULL,NULL,NULL,NULL),(16599,806,2.1277,12.9071,NULL,NULL,NULL,NULL),(16600,806,10.334,26.1796,NULL,NULL,NULL,NULL),(16601,806,11.246,31.9031,NULL,NULL,NULL,NULL),(16602,806,19.757,37.0173,NULL,NULL,NULL,NULL),(16603,806,30.395,48.95,NULL,NULL,NULL,NULL),(16604,806,41.337,56.1224,NULL,NULL,NULL,NULL),(16605,806,68.693,63.2898,NULL,NULL,NULL,NULL),(16606,806,120.85,73.9796,NULL,NULL,NULL,NULL),(16607,806,159.82,78.5959,NULL,NULL,NULL,NULL),(16608,806,208.84,79.6888,NULL,NULL,NULL,NULL),(16609,806,334.45,88.5571,NULL,NULL,NULL,NULL),(16610,806,391.77,93.1735,NULL,NULL,NULL,NULL),(16611,807,2.7356,26.0582,NULL,NULL,NULL,NULL),(16612,807,4.2553,46.15,NULL,NULL,NULL,NULL),(16613,807,9.7264,66.9337,NULL,NULL,NULL,NULL),(16614,807,20.061,81.3898,NULL,NULL,NULL,NULL),(16615,807,28.268,88.6786,NULL,NULL,NULL,NULL),(16616,807,39.818,95.4806,NULL,NULL,NULL,NULL),(16617,807,67.477,104.102,NULL,NULL,NULL,NULL),(16618,807,119.64,112.367,NULL,NULL,NULL,NULL),(16619,807,159.52,112.245,NULL,NULL,NULL,NULL),(16620,807,209.45,112.245,NULL,NULL,NULL,NULL),(16621,807,329.27,112.245,NULL,NULL,NULL,NULL),(16622,807,392.07,112.367,NULL,NULL,NULL,NULL),(16623,808,0.08,36.4653,NULL,NULL,NULL,NULL),(16624,808,0.12,36.9505,NULL,NULL,NULL,NULL),(16625,808,0.22,37.4356,NULL,NULL,NULL,NULL),(16626,808,0.35,37.4356,NULL,NULL,NULL,NULL),(16627,808,1.06,38.8812,NULL,NULL,NULL,NULL),(16628,808,2.02,39.8515,NULL,NULL,NULL,NULL),(16629,808,3.12,41.6535,NULL,NULL,NULL,NULL),(16630,808,4.14,41.8911,NULL,NULL,NULL,NULL),(16631,808,5.26,42.7921,NULL,NULL,NULL,NULL),(16632,808,6.36,42.3861,NULL,NULL,NULL,NULL),(16633,808,7.45,43.2871,NULL,NULL,NULL,NULL),(16634,808,9.41,43.9406,NULL,NULL,NULL,NULL),(16635,808,11.6,45.8218,NULL,NULL,NULL,NULL),(16636,808,13.64,46.1485,NULL,NULL,NULL,NULL),(16637,808,15.43,46.7228,NULL,NULL,NULL,NULL),(16638,808,18.66,47.2178,NULL,NULL,NULL,NULL),(16639,808,21.62,47.2178,NULL,NULL,NULL,NULL),(16640,808,23.35,47.9505,NULL,NULL,NULL,NULL),(16641,808,26.7,48.9307,NULL,NULL,NULL,NULL),(16642,808,30.08,48.9307,NULL,NULL,NULL,NULL),(16643,808,34.57,49.8317,NULL,NULL,NULL,NULL),(16644,808,39.47,50.3861,NULL,NULL,NULL,NULL),(16645,808,43.72,51.8416,NULL,NULL,NULL,NULL),(16646,808,49.9,52.0792,NULL,NULL,NULL,NULL),(16647,808,58.37,53.0495,NULL,NULL,NULL,NULL),(16648,808,64.66,53.7723,NULL,NULL,NULL,NULL),(16649,808,72.92,54.1683,NULL,NULL,NULL,NULL),(16650,808,80.27,54.7426,NULL,NULL,NULL,NULL),(16651,808,90.5,55.4653,NULL,NULL,NULL,NULL),(16652,808,102.76,56.2673,NULL,NULL,NULL,NULL),(16653,808,112.07,56.7525,NULL,NULL,NULL,NULL),(16654,808,127.64,58.0396,NULL,NULL,NULL,NULL),(16655,808,140.06,58.9208,NULL,NULL,NULL,NULL),(16656,808,155.59,59.4059,NULL,NULL,NULL,NULL),(16657,809,0.01,30.6792,NULL,NULL,NULL,NULL),(16658,809,0.08,34.0566,NULL,NULL,NULL,NULL),(16659,809,0.14,35.434,NULL,NULL,NULL,NULL),(16660,809,0.22,34.6604,NULL,NULL,NULL,NULL),(16661,809,0.35,35.1321,NULL,NULL,NULL,NULL),(16662,809,1.07,36.3585,NULL,NULL,NULL,NULL),(16663,809,2.07,37.7358,NULL,NULL,NULL,NULL),(16664,809,3.12,39.9057,NULL,NULL,NULL,NULL),(16665,809,4.1,39.9057,NULL,NULL,NULL,NULL),(16666,809,5.3,41.7547,NULL,NULL,NULL,NULL),(16667,809,6.23,41.6038,NULL,NULL,NULL,NULL),(16668,809,7.2,41.9057,NULL,NULL,NULL,NULL),(16669,809,9.47,41.283,NULL,NULL,NULL,NULL),(16670,809,11.31,43.9245,NULL,NULL,NULL,NULL),(16671,809,13.39,44.2264,NULL,NULL,NULL,NULL),(16672,809,15.34,45.3208,NULL,NULL,NULL,NULL),(16673,809,18.32,45.3208,NULL,NULL,NULL,NULL),(16674,809,21.34,45.7736,NULL,NULL,NULL,NULL),(16675,809,23.5,46.8679,NULL,NULL,NULL,NULL),(16676,809,26.7,46.3962,NULL,NULL,NULL,NULL),(16677,809,29.71,46.6981,NULL,NULL,NULL,NULL),(16678,809,34.57,47.7925,NULL,NULL,NULL,NULL),(16679,809,39.47,49.1887,NULL,NULL,NULL,NULL),(16680,809,42.43,49.7925,NULL,NULL,NULL,NULL),(16681,809,49.6,50.566,NULL,NULL,NULL,NULL),(16682,809,58.02,51.1887,NULL,NULL,NULL,NULL),(16683,809,63.89,51.8113,NULL,NULL,NULL,NULL),(16684,809,72.05,52.283,NULL,NULL,NULL,NULL),(16685,809,79.79,52.283,NULL,NULL,NULL,NULL),(16686,809,90.5,53.2075,NULL,NULL,NULL,NULL),(16687,809,102.12,54.1321,NULL,NULL,NULL,NULL),(16688,809,110.01,54.7547,NULL,NULL,NULL,NULL),(16689,809,127.64,55.8302,NULL,NULL,NULL,NULL),(16690,809,140.06,57.3774,NULL,NULL,NULL,NULL),(16691,809,152.73,57.8302,NULL,NULL,NULL,NULL),(16692,810,1.01,55.8673,NULL,NULL,NULL,NULL),(16693,810,1.97,60.3878,NULL,NULL,NULL,NULL),(16694,810,3.05,62.0408,NULL,NULL,NULL,NULL),(16695,810,5.03,66.449,NULL,NULL,NULL,NULL),(16696,810,5.98,68.2449,NULL,NULL,NULL,NULL),(16697,810,7.02,69.551,NULL,NULL,NULL,NULL),(16698,810,7.96,71.1837,NULL,NULL,NULL,NULL),(16699,810,9,71.5102,NULL,NULL,NULL,NULL),(16700,810,12.05,75.2653,NULL,NULL,NULL,NULL),(16701,810,14.33,76.898,NULL,NULL,NULL,NULL),(16702,810,16.24,79.0204,NULL,NULL,NULL,NULL),(16703,810,19.36,80.9796,NULL,NULL,NULL,NULL),(16704,810,22.17,82.8469,NULL,NULL,NULL,NULL),(16705,810,24.3,83.5306,NULL,NULL,NULL,NULL),(16706,810,26.15,85.2653,NULL,NULL,NULL,NULL),(16707,810,28.3,86.6429,NULL,NULL,NULL,NULL),(16708,810,30.08,86.4796,NULL,NULL,NULL,NULL),(16709,810,32.54,88.898,NULL,NULL,NULL,NULL),(16710,810,39.95,92.5306,NULL,NULL,NULL,NULL),(16711,810,48.13,93.051,NULL,NULL,NULL,NULL),(16712,810,54.25,95.2959,NULL,NULL,NULL,NULL),(16713,810,67.66,97.1939,NULL,NULL,NULL,NULL),(16714,810,82.84,100.653,NULL,NULL,NULL,NULL),(16715,810,96.11,103.673,NULL,NULL,NULL,NULL),(16716,810,113.47,107.041,NULL,NULL,NULL,NULL),(16717,810,128.28,109.286,NULL,NULL,NULL,NULL),(16718,810,143.04,107.041,NULL,NULL,NULL,NULL),(16719,810,156.27,107.551,NULL,NULL,NULL,NULL),(16720,811,1,4.63061,NULL,NULL,NULL,NULL),(16721,811,1.96,8.06122,NULL,NULL,NULL,NULL),(16722,811,2.98,8.91837,NULL,NULL,NULL,NULL),(16723,811,5,11.8327,NULL,NULL,NULL,NULL),(16724,811,5.92,12.5184,NULL,NULL,NULL,NULL),(16725,811,6.84,13.2061,NULL,NULL,NULL,NULL),(16726,811,7.88,14.5776,NULL,NULL,NULL,NULL),(16727,811,8.88,14.749,NULL,NULL,NULL,NULL),(16728,811,11.78,15.4347,NULL,NULL,NULL,NULL),(16729,811,13.99,17.3204,NULL,NULL,NULL,NULL),(16730,811,15.84,18.6939,NULL,NULL,NULL,NULL),(16731,811,18.64,20.7347,NULL,NULL,NULL,NULL),(16732,811,22.08,21.0816,NULL,NULL,NULL,NULL),(16733,811,23.64,20.2367,NULL,NULL,NULL,NULL),(16734,811,25.63,22.898,NULL,NULL,NULL,NULL),(16735,811,27.6,23.5714,NULL,NULL,NULL,NULL),(16736,811,29.74,23.0612,NULL,NULL,NULL,NULL),(16737,811,32.07,23.898,NULL,NULL,NULL,NULL),(16738,811,39.17,25.7143,NULL,NULL,NULL,NULL),(16739,811,47.8,26.3878,NULL,NULL,NULL,NULL),(16740,811,53.27,28.2041,NULL,NULL,NULL,NULL),(16741,811,68.39,30.0408,NULL,NULL,NULL,NULL),(16742,811,83.36,32.5102,NULL,NULL,NULL,NULL),(16743,811,96.51,33.8367,NULL,NULL,NULL,NULL),(16744,811,109.17,34.6735,NULL,NULL,NULL,NULL),(16745,811,124.1,34.5102,NULL,NULL,NULL,NULL),(16746,811,136.82,36,NULL,NULL,NULL,NULL),(16747,811,151.75,36.3469,NULL,NULL,NULL,NULL),(16748,812,1,7.05816,NULL,NULL,NULL,NULL),(16749,812,2,9.89694,NULL,NULL,NULL,NULL),(16750,812,3,12.1122,NULL,NULL,NULL,NULL),(16751,812,5,14.8469,NULL,NULL,NULL,NULL),(16752,812,5.88,16.9082,NULL,NULL,NULL,NULL),(16753,812,6.94,18.5,NULL,NULL,NULL,NULL),(16754,812,8.01,19.0408,NULL,NULL,NULL,NULL),(16755,812,8.95,19.949,NULL,NULL,NULL,NULL),(16756,812,11.98,22.2653,NULL,NULL,NULL,NULL),(16757,812,13.91,23.0408,NULL,NULL,NULL,NULL),(16758,812,16.12,24.8878,NULL,NULL,NULL,NULL),(16759,812,19,26.051,NULL,NULL,NULL,NULL),(16760,812,22.11,27.3673,NULL,NULL,NULL,NULL),(16761,812,23.98,27.2857,NULL,NULL,NULL,NULL),(16762,812,26,28.6837,NULL,NULL,NULL,NULL),(16763,812,27.86,30.3776,NULL,NULL,NULL,NULL),(16764,812,29.83,30.4592,NULL,NULL,NULL,NULL),(16765,812,33.93,31,NULL,NULL,NULL,NULL),(16766,812,39.67,33.7041,NULL,NULL,NULL,NULL),(16767,812,47.4,36.2551,NULL,NULL,NULL,NULL),(16768,812,54.11,37.7245,NULL,NULL,NULL,NULL),(16769,812,68.31,39.9694,NULL,NULL,NULL,NULL),(16770,812,82.73,42.4592,NULL,NULL,NULL,NULL),(16771,812,97.3,44.9796,NULL,NULL,NULL,NULL),(16772,812,111.28,47.2551,NULL,NULL,NULL,NULL),(16773,812,126.54,46.5408,NULL,NULL,NULL,NULL),(16774,812,139.74,49.1327,NULL,NULL,NULL,NULL),(16775,812,155.21,50.7041,NULL,NULL,NULL,NULL),(16776,813,1,5.83061,NULL,NULL,NULL,NULL),(16777,813,1.98,8.51633,NULL,NULL,NULL,NULL),(16778,813,3.02,10.051,NULL,NULL,NULL,NULL),(16779,813,5.03,11.9592,NULL,NULL,NULL,NULL),(16780,813,6,13.551,NULL,NULL,NULL,NULL),(16781,813,7.07,14.2449,NULL,NULL,NULL,NULL),(16782,813,8.06,14.8469,NULL,NULL,NULL,NULL),(16783,813,9.06,15.5306,NULL,NULL,NULL,NULL),(16784,813,12.05,17.2143,NULL,NULL,NULL,NULL),(16785,813,14.07,18.6531,NULL,NULL,NULL,NULL),(16786,813,16.32,19.5,NULL,NULL,NULL,NULL),(16787,813,19.34,20.5612,NULL,NULL,NULL,NULL),(16788,813,22.24,22.5714,NULL,NULL,NULL,NULL),(16789,813,23.98,22.7245,NULL,NULL,NULL,NULL),(16790,813,25.85,24.1939,NULL,NULL,NULL,NULL),(16791,813,28.02,24.8878,NULL,NULL,NULL,NULL),(16792,813,29.83,25.3571,NULL,NULL,NULL,NULL),(16793,813,32.99,26.2041,NULL,NULL,NULL,NULL),(16794,813,40.12,28.0612,NULL,NULL,NULL,NULL),(16795,813,47.4,29.2959,NULL,NULL,NULL,NULL),(16796,813,54.43,30.1531,NULL,NULL,NULL,NULL),(16797,813,69.51,32,NULL,NULL,NULL,NULL),(16798,813,84.18,34.0102,NULL,NULL,NULL,NULL),(16799,813,99.58,35.3265,NULL,NULL,NULL,NULL),(16800,813,113.91,36.7959,NULL,NULL,NULL,NULL),(16801,813,125.81,36.3367,NULL,NULL,NULL,NULL),(16802,813,142.21,37.7245,NULL,NULL,NULL,NULL),(16803,813,158.87,39.0408,NULL,NULL,NULL,NULL),(16804,814,0.18,36.6436,NULL,NULL,NULL,NULL),(16805,814,0.24,37.1287,NULL,NULL,NULL,NULL),(16806,814,0.3,37.5644,NULL,NULL,NULL,NULL),(16807,814,0.44,37.6139,NULL,NULL,NULL,NULL),(16808,814,1.11,39.0693,NULL,NULL,NULL,NULL),(16809,814,2.12,40.1386,NULL,NULL,NULL,NULL),(16810,814,3.12,41.6535,NULL,NULL,NULL,NULL),(16811,814,4.12,41.9208,NULL,NULL,NULL,NULL),(16812,814,5.12,42.7228,NULL,NULL,NULL,NULL),(16813,814,6.12,42.4554,NULL,NULL,NULL,NULL),(16814,814,7.02,43.3663,NULL,NULL,NULL,NULL),(16815,814,9.02,43.8515,NULL,NULL,NULL,NULL),(16816,814,10.92,45.6436,NULL,NULL,NULL,NULL),(16817,814,13.22,46.1188,NULL,NULL,NULL,NULL),(16818,814,15.02,46.5446,NULL,NULL,NULL,NULL),(16819,814,18.12,47.1386,NULL,NULL,NULL,NULL),(16820,814,23.12,47.7822,NULL,NULL,NULL,NULL),(16821,814,26.12,48.8614,NULL,NULL,NULL,NULL),(16822,814,29.52,48.703,NULL,NULL,NULL,NULL),(16823,814,33.72,49.7723,NULL,NULL,NULL,NULL),(16824,814,38.62,50.4158,NULL,NULL,NULL,NULL),(16825,814,41.92,51.7129,NULL,NULL,NULL,NULL),(16826,814,48.92,51.8713,NULL,NULL,NULL,NULL),(16827,814,55.82,52.8416,NULL,NULL,NULL,NULL),(16828,814,62.82,53.6535,NULL,NULL,NULL,NULL),(16829,814,69.82,54.0792,NULL,NULL,NULL,NULL),(16830,814,77.62,54.7228,NULL,NULL,NULL,NULL),(16831,814,87.42,55.4257,NULL,NULL,NULL,NULL),(16832,814,99.52,56.1782,NULL,NULL,NULL,NULL),(16833,814,109.42,56.6634,NULL,NULL,NULL,NULL),(16834,814,123.32,58.1188,NULL,NULL,NULL,NULL),(16835,814,134.52,59.1386,NULL,NULL,NULL,NULL),(16836,815,0.05,7.91089,NULL,NULL,NULL,NULL),(16837,815,0.1,7.85149,NULL,NULL,NULL,NULL),(16838,815,0.2,8.06931,NULL,NULL,NULL,NULL),(16839,815,0.3,7.85149,NULL,NULL,NULL,NULL),(16840,815,1,8.39604,NULL,NULL,NULL,NULL),(16841,815,2,8.33663,NULL,NULL,NULL,NULL),(16842,815,3,8.66337,NULL,NULL,NULL,NULL),(16843,815,4,8.71287,NULL,NULL,NULL,NULL),(16844,815,5,9.08911,NULL,NULL,NULL,NULL),(16845,815,6,8.82178,NULL,NULL,NULL,NULL),(16846,815,7,9.36634,NULL,NULL,NULL,NULL),(16847,815,8.9,9.52475,NULL,NULL,NULL,NULL),(16848,815,11,8.93069,NULL,NULL,NULL,NULL),(16849,815,13,8.71287,NULL,NULL,NULL,NULL),(16850,815,15.3,9.08911,NULL,NULL,NULL,NULL),(16851,815,18,9.19802,NULL,NULL,NULL,NULL),(16852,815,21.1,9.14851,NULL,NULL,NULL,NULL),(16853,815,23.4,9.14851,NULL,NULL,NULL,NULL),(16854,815,26,9.14851,NULL,NULL,NULL,NULL),(16855,815,28.4,9.08911,NULL,NULL,NULL,NULL),(16856,815,34.1,8.9901,NULL,NULL,NULL,NULL),(16857,815,38.7,9.08911,NULL,NULL,NULL,NULL),(16858,815,41.1,9.14851,NULL,NULL,NULL,NULL),(16859,815,49.2,9.14851,NULL,NULL,NULL,NULL),(16860,815,55.7,9.14851,NULL,NULL,NULL,NULL),(16861,815,63.5,9.14851,NULL,NULL,NULL,NULL),(16862,815,70,9.0396,NULL,NULL,NULL,NULL),(16863,815,78.2,9.79208,NULL,NULL,NULL,NULL),(16864,815,88,9.90099,NULL,NULL,NULL,NULL),(16865,815,99.4,10.0099,NULL,NULL,NULL,NULL),(16866,815,112.1,9.79208,NULL,NULL,NULL,NULL),(16867,815,123.2,9.95049,NULL,NULL,NULL,NULL),(16868,815,138.3,10.4356,NULL,NULL,NULL,NULL),(16869,816,0.22,34.1962,NULL,NULL,NULL,NULL),(16870,816,0.23,35.5547,NULL,NULL,NULL,NULL),(16871,816,0.31,34.517,NULL,NULL,NULL,NULL),(16872,816,0.42,35.2528,NULL,NULL,NULL,NULL),(16873,816,1.12,36.083,NULL,NULL,NULL,NULL),(16874,816,2.12,37.7434,NULL,NULL,NULL,NULL),(16875,816,3.12,39.6302,NULL,NULL,NULL,NULL),(16876,816,4.12,39.517,NULL,NULL,NULL,NULL),(16877,816,6.02,41.4038,NULL,NULL,NULL,NULL),(16878,816,9.12,41.1019,NULL,NULL,NULL,NULL),(16879,816,10.92,43.8943,NULL,NULL,NULL,NULL),(16880,816,13.02,43.9887,NULL,NULL,NULL,NULL),(16881,816,15.02,45.083,NULL,NULL,NULL,NULL),(16882,816,18.02,44.9887,NULL,NULL,NULL,NULL),(16883,816,20.82,45.4792,NULL,NULL,NULL,NULL),(16884,816,23.02,46.366,NULL,NULL,NULL,NULL),(16885,816,25.92,46.3849,NULL,NULL,NULL,NULL),(16886,816,29.02,46.6679,NULL,NULL,NULL,NULL),(16887,816,33.92,47.5736,NULL,NULL,NULL,NULL),(16888,816,38.82,48.6679,NULL,NULL,NULL,NULL),(16889,816,42.22,49.3472,NULL,NULL,NULL,NULL),(16890,816,48.92,50.3472,NULL,NULL,NULL,NULL),(16891,816,55.52,50.9509,NULL,NULL,NULL,NULL),(16892,816,62.52,51.4415,NULL,NULL,NULL,NULL),(16893,816,69.52,52.0264,NULL,NULL,NULL,NULL),(16894,816,78.32,52.3283,NULL,NULL,NULL,NULL),(16895,816,87.42,53.1208,NULL,NULL,NULL,NULL),(16896,816,99.52,53.7245,NULL,NULL,NULL,NULL),(16897,816,109.92,54.8189,NULL,NULL,NULL,NULL),(16898,816,124.92,55.517,NULL,NULL,NULL,NULL),(16899,816,137.92,57.4226,NULL,NULL,NULL,NULL),(16900,817,0.02,7.79811,NULL,NULL,NULL,NULL),(16901,817,0.05,7.47736,NULL,NULL,NULL,NULL),(16902,817,0.12,7.98679,NULL,NULL,NULL,NULL),(16903,817,0.92,9.23208,NULL,NULL,NULL,NULL),(16904,817,1.92,9.32642,NULL,NULL,NULL,NULL),(16905,817,2.92,9.23208,NULL,NULL,NULL,NULL),(16906,817,3.92,9.11887,NULL,NULL,NULL,NULL),(16907,817,4.92,9.43962,NULL,NULL,NULL,NULL),(16908,817,5.92,8.91132,NULL,NULL,NULL,NULL),(16909,817,6.92,10.5528,NULL,NULL,NULL,NULL),(16910,817,8.92,10.1566,NULL,NULL,NULL,NULL),(16911,817,10.92,8.60943,NULL,NULL,NULL,NULL),(16912,817,12.92,8.72264,NULL,NULL,NULL,NULL),(16913,817,14.92,8.72264,NULL,NULL,NULL,NULL),(16914,817,17.92,8.81698,NULL,NULL,NULL,NULL),(16915,817,20.72,9.11887,NULL,NULL,NULL,NULL),(16916,817,23.22,9.11887,NULL,NULL,NULL,NULL),(16917,817,25.72,9.11887,NULL,NULL,NULL,NULL),(16918,817,29.02,9.02453,NULL,NULL,NULL,NULL),(16919,817,33.52,9.74151,NULL,NULL,NULL,NULL),(16920,817,38.62,9.53396,NULL,NULL,NULL,NULL),(16921,817,41.22,9.43962,NULL,NULL,NULL,NULL),(16922,817,48.32,9.6283,NULL,NULL,NULL,NULL),(16923,817,54.42,9.23208,NULL,NULL,NULL,NULL),(16924,817,61.62,9.6283,NULL,NULL,NULL,NULL),(16925,817,69.32,10.1566,NULL,NULL,NULL,NULL),(16926,817,79.02,9.83585,NULL,NULL,NULL,NULL),(16927,817,88.22,9.94906,NULL,NULL,NULL,NULL),(16928,817,98.12,10.3453,NULL,NULL,NULL,NULL),(16929,817,112.02,11.0811,NULL,NULL,NULL,NULL),(16930,817,123.72,11.383,NULL,NULL,NULL,NULL),(16931,817,134.92,11.6849,NULL,NULL,NULL,NULL),(16932,818,0.88,6.25306,NULL,NULL,NULL,NULL),(16933,818,1.88,10.4265,NULL,NULL,NULL,NULL),(16934,818,2.78,12.4571,NULL,NULL,NULL,NULL),(16935,818,4.78,16.8347,NULL,NULL,NULL,NULL),(16936,818,5.88,19.0388,NULL,NULL,NULL,NULL),(16937,818,6.78,20.1408,NULL,NULL,NULL,NULL),(16938,818,7.78,21.5592,NULL,NULL,NULL,NULL),(16939,818,8.88,21.9878,NULL,NULL,NULL,NULL),(16940,818,11.68,25.8143,NULL,NULL,NULL,NULL),(16941,818,13.78,27.2837,NULL,NULL,NULL,NULL),(16942,818,15.28,29.3959,NULL,NULL,NULL,NULL),(16943,818,18.48,31.8857,NULL,NULL,NULL,NULL),(16944,818,21.48,33.4469,NULL,NULL,NULL,NULL),(16945,818,23.28,34.4265,NULL,NULL,NULL,NULL),(16946,818,25.78,35.7225,NULL,NULL,NULL,NULL),(16947,818,26.88,37.0694,NULL,NULL,NULL,NULL),(16948,818,29.38,37.0694,NULL,NULL,NULL,NULL),(16949,818,32.38,39.5592,NULL,NULL,NULL,NULL),(16950,818,39.38,43.0592,NULL,NULL,NULL,NULL),(16951,818,46.58,43.549,NULL,NULL,NULL,NULL),(16952,818,53.88,45.9469,NULL,NULL,NULL,NULL),(16953,818,66.68,47.8551,NULL,NULL,NULL,NULL),(16954,818,82.68,50.9265,NULL,NULL,NULL,NULL),(16955,818,94.98,54.3653,NULL,NULL,NULL,NULL),(16956,818,109.58,57.3245,NULL,NULL,NULL,NULL),(16957,818,134.38,57.3245,NULL,NULL,NULL,NULL),(16958,819,1.05,-4.2551,NULL,NULL,NULL,NULL),(16959,819,2.05,-4.15306,NULL,NULL,NULL,NULL),(16960,819,3.05,-3.12245,NULL,NULL,NULL,NULL),(16961,819,5.05,-3.33673,NULL,NULL,NULL,NULL),(16962,819,6.05,-2.53061,NULL,NULL,NULL,NULL),(16963,819,7.15,-2.20408,NULL,NULL,NULL,NULL),(16964,819,8.05,-1.82653,NULL,NULL,NULL,NULL),(16965,819,9.05,-1.66327,NULL,NULL,NULL,NULL),(16966,819,12.05,-1.02041,NULL,NULL,NULL,NULL),(16967,819,14.15,-0.642857,NULL,NULL,NULL,NULL),(16968,819,15.95,-1.18367,NULL,NULL,NULL,NULL),(16969,819,19.05,-0.744898,NULL,NULL,NULL,NULL),(16970,819,22.35,-0.367347,NULL,NULL,NULL,NULL),(16971,819,24.35,0.602041,NULL,NULL,NULL,NULL),(16972,819,26.05,-0.204082,NULL,NULL,NULL,NULL),(16973,819,27.95,0.173469,NULL,NULL,NULL,NULL),(16974,819,30.15,0.112245,NULL,NULL,NULL,NULL),(16975,819,33.25,-0.265306,NULL,NULL,NULL,NULL),(16976,819,39.85,0.173469,NULL,NULL,NULL,NULL),(16977,819,47.75,0.173469,NULL,NULL,NULL,NULL),(16978,819,53.85,0.387755,NULL,NULL,NULL,NULL),(16979,819,67.95,1.2449,NULL,NULL,NULL,NULL),(16980,819,81.55,1.46939,NULL,NULL,NULL,NULL),(16981,819,95.15,2.22449,NULL,NULL,NULL,NULL),(16982,819,114.15,2.37755,NULL,NULL,NULL,NULL),(16983,819,123.45,4.37755,NULL,NULL,NULL,NULL),(16984,819,139.45,4.32653,NULL,NULL,NULL,NULL),(16985,820,0.88,2.6449,NULL,NULL,NULL,NULL),(16986,820,1.88,5.72653,NULL,NULL,NULL,NULL),(16987,820,2.88,7.54286,NULL,NULL,NULL,NULL),(16988,820,4.88,10.6449,NULL,NULL,NULL,NULL),(16989,820,5.98,12.0327,NULL,NULL,NULL,NULL),(16990,820,6.98,12.5633,NULL,NULL,NULL,NULL),(16991,820,7.78,13.5224,NULL,NULL,NULL,NULL),(16992,820,9.08,14.3796,NULL,NULL,NULL,NULL),(16993,820,11.78,15.3592,NULL,NULL,NULL,NULL),(16994,820,13.78,17.8082,NULL,NULL,NULL,NULL),(16995,820,15.78,18.5633,NULL,NULL,NULL,NULL),(16996,820,18.78,19.4204,NULL,NULL,NULL,NULL),(16997,820,21.78,20.6857,NULL,NULL,NULL,NULL),(16998,820,23.88,21.0122,NULL,NULL,NULL,NULL),(16999,820,25.58,23.1551,NULL,NULL,NULL,NULL),(17000,820,27.78,23.5837,NULL,NULL,NULL,NULL),(17001,820,29.48,24.4408,NULL,NULL,NULL,NULL),(17002,820,32.68,24.9714,NULL,NULL,NULL,NULL),(17003,820,39.68,26.4612,NULL,NULL,NULL,NULL),(17004,820,47.18,27.3184,NULL,NULL,NULL,NULL),(17005,820,54.38,28.9306,NULL,NULL,NULL,NULL),(17006,820,66.18,31.3796,NULL,NULL,NULL,NULL),(17007,820,82.68,33.4,NULL,NULL,NULL,NULL),(17008,820,94.58,34.6857,NULL,NULL,NULL,NULL),(17009,820,109.58,35.8694,NULL,NULL,NULL,NULL),(17010,820,122.78,35.2163,NULL,NULL,NULL,NULL),(17011,820,131.78,36.7265,NULL,NULL,NULL,NULL),(17012,821,0.88,2.6449,NULL,NULL,NULL,NULL),(17013,821,1.88,5.72653,NULL,NULL,NULL,NULL),(17014,821,2.88,7.54286,NULL,NULL,NULL,NULL),(17015,821,4.88,10.6449,NULL,NULL,NULL,NULL),(17016,821,5.98,12.0327,NULL,NULL,NULL,NULL),(17017,821,6.98,12.5633,NULL,NULL,NULL,NULL),(17018,821,7.78,13.5224,NULL,NULL,NULL,NULL),(17019,821,9.08,14.3796,NULL,NULL,NULL,NULL),(17020,821,11.78,15.3592,NULL,NULL,NULL,NULL),(17021,821,13.78,17.8082,NULL,NULL,NULL,NULL),(17022,821,15.78,18.5633,NULL,NULL,NULL,NULL),(17023,821,18.78,19.4204,NULL,NULL,NULL,NULL),(17024,821,21.78,20.6857,NULL,NULL,NULL,NULL),(17025,821,23.88,21.0122,NULL,NULL,NULL,NULL),(17026,821,25.58,23.1551,NULL,NULL,NULL,NULL),(17027,821,27.78,23.5837,NULL,NULL,NULL,NULL),(17028,821,29.48,24.4408,NULL,NULL,NULL,NULL),(17029,821,32.68,24.9714,NULL,NULL,NULL,NULL),(17030,821,39.68,26.4612,NULL,NULL,NULL,NULL),(17031,821,47.18,27.3184,NULL,NULL,NULL,NULL),(17032,821,54.38,28.9306,NULL,NULL,NULL,NULL),(17033,821,66.18,31.3796,NULL,NULL,NULL,NULL),(17034,821,82.68,33.4,NULL,NULL,NULL,NULL),(17035,821,94.58,34.6857,NULL,NULL,NULL,NULL),(17036,821,109.58,35.8694,NULL,NULL,NULL,NULL),(17037,821,122.78,35.2163,NULL,NULL,NULL,NULL),(17038,821,131.78,36.7265,NULL,NULL,NULL,NULL),(17039,822,0.88,4.53673,NULL,NULL,NULL,NULL),(17040,822,1.88,7.63878,NULL,NULL,NULL,NULL),(17041,822,2.88,9.77143,NULL,NULL,NULL,NULL),(17042,822,5.78,15.0061,NULL,NULL,NULL,NULL),(17043,822,6.88,16.3429,NULL,NULL,NULL,NULL),(17044,822,7.78,16.9347,NULL,NULL,NULL,NULL),(17045,822,8.78,17.7306,NULL,NULL,NULL,NULL),(17046,822,11.58,19.9653,NULL,NULL,NULL,NULL),(17047,822,13.58,20.7306,NULL,NULL,NULL,NULL),(17048,822,15.48,22.4755,NULL,NULL,NULL,NULL),(17049,822,18.68,23.6184,NULL,NULL,NULL,NULL),(17050,822,21.68,25.098,NULL,NULL,NULL,NULL),(17051,822,23.58,25.149,NULL,NULL,NULL,NULL),(17052,822,25.88,26.8429,NULL,NULL,NULL,NULL),(17053,822,27.58,28.2,NULL,NULL,NULL,NULL),(17054,822,28.98,28.3122,NULL,NULL,NULL,NULL),(17055,822,32.48,28.9041,NULL,NULL,NULL,NULL),(17056,822,39.98,31.6592,NULL,NULL,NULL,NULL),(17057,822,46.58,34.1388,NULL,NULL,NULL,NULL),(17058,822,52.88,34.4143,NULL,NULL,NULL,NULL),(17059,822,66.18,37.7102,NULL,NULL,NULL,NULL),(17060,822,81.68,40.3735,NULL,NULL,NULL,NULL),(17061,822,95.38,42.8837,NULL,NULL,NULL,NULL),(17062,822,110.38,45.1184,NULL,NULL,NULL,NULL),(17063,822,123.28,44.5776,NULL,NULL,NULL,NULL),(17064,822,132.28,47.1898,NULL,NULL,NULL,NULL),(17065,823,1.1,-0.0836735,NULL,NULL,NULL,NULL),(17066,823,2.1,0.712245,NULL,NULL,NULL,NULL),(17067,823,3.1,2.1,NULL,NULL,NULL,NULL),(17068,823,5.2,2.90612,NULL,NULL,NULL,NULL),(17069,823,6.2,3.70204,NULL,NULL,NULL,NULL),(17070,823,7.2,3.65102,NULL,NULL,NULL,NULL),(17071,823,8,3.97755,NULL,NULL,NULL,NULL),(17072,823,9.2,4.45714,NULL,NULL,NULL,NULL),(17073,823,12.1,4.93673,NULL,NULL,NULL,NULL),(17074,823,14.2,6.05918,NULL,NULL,NULL,NULL),(17075,823,15.9,6.1102,NULL,NULL,NULL,NULL),(17076,823,19,6.91633,NULL,NULL,NULL,NULL),(17077,823,22.3,7.44694,NULL,NULL,NULL,NULL),(17078,823,24.1,7.87551,NULL,NULL,NULL,NULL),(17079,823,25.8,8.14082,NULL,NULL,NULL,NULL),(17080,823,27.6,8.19184,NULL,NULL,NULL,NULL),(17081,823,29.8,9.21224,NULL,NULL,NULL,NULL),(17082,823,32.9,9.74286,NULL,NULL,NULL,NULL),(17083,823,40,10.1714,NULL,NULL,NULL,NULL),(17084,823,47.4,10.651,NULL,NULL,NULL,NULL),(17085,823,54.8,11.3959,NULL,NULL,NULL,NULL),(17086,823,66.6,12.4163,NULL,NULL,NULL,NULL),(17087,823,83.3,13.5388,NULL,NULL,NULL,NULL),(17088,823,93.6,14.1204,NULL,NULL,NULL,NULL),(17089,823,109.8,14.8755,NULL,NULL,NULL,NULL),(17090,823,121.6,16.151,NULL,NULL,NULL,NULL),(17091,823,135.2,15.9367,NULL,NULL,NULL,NULL),(17092,824,0.88,5.58163,NULL,NULL,NULL,NULL),(17093,824,1.88,8.58163,NULL,NULL,NULL,NULL),(17094,824,2.88,10.8265,NULL,NULL,NULL,NULL),(17095,824,4.88,12.8571,NULL,NULL,NULL,NULL),(17096,824,5.88,14.6735,NULL,NULL,NULL,NULL),(17097,824,6.88,15.5816,NULL,NULL,NULL,NULL),(17098,824,7.78,16.2143,NULL,NULL,NULL,NULL),(17099,824,8.78,16.8061,NULL,NULL,NULL,NULL),(17100,824,11.68,18.7857,NULL,NULL,NULL,NULL),(17101,824,13.68,20.102,NULL,NULL,NULL,NULL),(17102,824,15.48,21.1327,NULL,NULL,NULL,NULL),(17103,824,18.58,22.6633,NULL,NULL,NULL,NULL),(17104,824,21.68,24.1429,NULL,NULL,NULL,NULL),(17105,824,23.38,24.4694,NULL,NULL,NULL,NULL),(17106,824,25.28,26.1531,NULL,NULL,NULL,NULL),(17107,824,27.58,26.8673,NULL,NULL,NULL,NULL),(17108,824,29.08,27.1939,NULL,NULL,NULL,NULL),(17109,824,31.88,28.1224,NULL,NULL,NULL,NULL),(17110,824,39.18,30.398,NULL,NULL,NULL,NULL),(17111,824,46.78,32.2347,NULL,NULL,NULL,NULL),(17112,824,53.28,33.2041,NULL,NULL,NULL,NULL),(17113,824,65.88,35.2041,NULL,NULL,NULL,NULL),(17114,824,81.08,37.6327,NULL,NULL,NULL,NULL),(17115,824,93.78,39.1939,NULL,NULL,NULL,NULL),(17116,824,108.68,40.949,NULL,NULL,NULL,NULL),(17117,824,120.38,41.2755,NULL,NULL,NULL,NULL),(17118,824,131.28,42.6327,NULL,NULL,NULL,NULL),(17119,825,0.88,5.58163,NULL,NULL,NULL,NULL),(17120,825,1.88,8.58163,NULL,NULL,NULL,NULL),(17121,825,2.88,10.8265,NULL,NULL,NULL,NULL),(17122,825,4.88,12.8571,NULL,NULL,NULL,NULL),(17123,825,5.88,14.6735,NULL,NULL,NULL,NULL),(17124,825,6.88,15.5816,NULL,NULL,NULL,NULL),(17125,825,7.78,16.2143,NULL,NULL,NULL,NULL),(17126,825,8.78,16.8061,NULL,NULL,NULL,NULL),(17127,825,11.68,18.7857,NULL,NULL,NULL,NULL),(17128,825,13.68,20.102,NULL,NULL,NULL,NULL),(17129,825,15.48,21.1327,NULL,NULL,NULL,NULL),(17130,825,18.58,22.6633,NULL,NULL,NULL,NULL),(17131,825,21.68,24.1429,NULL,NULL,NULL,NULL),(17132,825,23.38,24.4694,NULL,NULL,NULL,NULL),(17133,825,25.28,26.1531,NULL,NULL,NULL,NULL),(17134,825,27.58,26.8673,NULL,NULL,NULL,NULL),(17135,825,29.08,27.1939,NULL,NULL,NULL,NULL),(17136,825,31.88,28.1224,NULL,NULL,NULL,NULL),(17137,825,39.18,30.398,NULL,NULL,NULL,NULL),(17138,825,46.78,32.2347,NULL,NULL,NULL,NULL),(17139,825,53.28,33.2041,NULL,NULL,NULL,NULL),(17140,825,65.88,35.2041,NULL,NULL,NULL,NULL),(17141,825,81.08,37.6327,NULL,NULL,NULL,NULL),(17142,825,93.78,39.1939,NULL,NULL,NULL,NULL),(17143,825,108.68,40.949,NULL,NULL,NULL,NULL),(17144,825,120.38,41.2755,NULL,NULL,NULL,NULL),(17145,825,131.28,42.6327,NULL,NULL,NULL,NULL),(17146,826,0.01,23.9333,NULL,NULL,NULL,NULL),(17147,826,0.5,24.5126,NULL,NULL,NULL,NULL),(17148,826,8.0952,27.4536,NULL,NULL,NULL,NULL),(17149,826,16.667,28.6122,NULL,NULL,NULL,NULL),(17150,826,27.143,29.9371,NULL,NULL,NULL,NULL),(17151,826,49.762,32.7505,NULL,NULL,NULL,NULL),(17152,826,74.524,34.7282,NULL,NULL,NULL,NULL),(17153,826,99.286,36.1354,NULL,NULL,NULL,NULL),(17154,826,123.35,37.058,NULL,NULL,NULL,NULL),(17155,826,150.47,38.5087,NULL,NULL,NULL,NULL),(17156,826,173.11,38.8201,NULL,NULL,NULL,NULL),(17157,826,199.76,39.6296,NULL,NULL,NULL,NULL),(17158,826,213.29,39.9894,NULL,NULL,NULL,NULL),(17159,827,0.2381,26.8298,NULL,NULL,NULL,NULL),(17160,827,4.0476,32.0909,NULL,NULL,NULL,NULL),(17161,827,14.524,34.9923,NULL,NULL,NULL,NULL),(17162,827,25.952,37.1025,NULL,NULL,NULL,NULL),(17163,827,50,39.9894,NULL,NULL,NULL,NULL),(17164,827,74.762,43.2282,NULL,NULL,NULL,NULL),(17165,827,99.762,45.0725,NULL,NULL,NULL,NULL),(17166,827,122.88,46.8269,NULL,NULL,NULL,NULL),(17167,827,150.71,48.4004,NULL,NULL,NULL,NULL),(17168,827,171.93,49.9159,NULL,NULL,NULL,NULL),(17169,827,199.76,50.852,NULL,NULL,NULL,NULL),(17170,827,212.56,51.2979,NULL,NULL,NULL,NULL),(17171,828,1.1173,24.6166,NULL,NULL,NULL,NULL),(17172,828,5.3073,31.1521,NULL,NULL,NULL,NULL),(17173,828,13.967,34.6184,NULL,NULL,NULL,NULL),(17174,828,22.626,36.4299,NULL,NULL,NULL,NULL),(17175,828,52.486,39.4144,NULL,NULL,NULL,NULL),(17176,828,77.348,41.112,NULL,NULL,NULL,NULL),(17177,828,102.17,43.2732,NULL,NULL,NULL,NULL),(17178,828,125.82,44.4572,NULL,NULL,NULL,NULL),(17179,828,149.19,46.0082,NULL,NULL,NULL,NULL),(17180,828,174.73,46.7933,NULL,NULL,NULL,NULL),(17181,828,200.28,47.8406,NULL,NULL,NULL,NULL),(17182,828,224.72,48.4681,NULL,NULL,NULL,NULL),(17183,828,250.28,48.9399,NULL,NULL,NULL,NULL),(17184,828,267.58,49.6721,NULL,NULL,NULL,NULL),(17185,829,1.1173,26.0738,NULL,NULL,NULL,NULL),(17186,829,2.7933,32.0829,NULL,NULL,NULL,NULL),(17187,829,9.4972,37.459,NULL,NULL,NULL,NULL),(17188,829,22.626,43.4281,NULL,NULL,NULL,NULL),(17189,829,51.381,51.8188,NULL,NULL,NULL,NULL),(17190,829,77.901,57.4035,NULL,NULL,NULL,NULL),(17191,829,103.26,61.827,NULL,NULL,NULL,NULL),(17192,829,125.82,65.2095,NULL,NULL,NULL,NULL),(17193,829,148.91,68.2796,NULL,NULL,NULL,NULL),(17194,829,175.27,70.5182,NULL,NULL,NULL,NULL),(17195,829,199.19,72.3916,NULL,NULL,NULL,NULL),(17196,829,224.72,73.3798,NULL,NULL,NULL,NULL),(17197,829,250.28,74.3689,NULL,NULL,NULL,NULL),(17198,829,269.23,75.0455,NULL,NULL,NULL,NULL),(17199,830,14.319,32.0177,NULL,NULL,NULL,NULL),(17200,830,27.7,34.2588,NULL,NULL,NULL,NULL),(17201,830,52.103,36.9867,NULL,NULL,NULL,NULL),(17202,830,76.402,39.485,NULL,NULL,NULL,NULL),(17203,830,97.897,41.0468,NULL,NULL,NULL,NULL),(17204,830,122.99,42.0724,NULL,NULL,NULL,NULL),(17205,830,146.92,43.5,NULL,NULL,NULL,NULL),(17206,830,161.68,43.8127,NULL,NULL,NULL,NULL),(17207,830,189.02,45.0804,NULL,NULL,NULL,NULL),(17208,830,200.23,45.8542,NULL,NULL,NULL,NULL),(17209,830,216.36,46.811,NULL,NULL,NULL,NULL),(17210,831,0.7042,30.682,NULL,NULL,NULL,NULL),(17211,831,2.5822,32.4921,NULL,NULL,NULL,NULL),(17212,831,8.6855,34.4311,NULL,NULL,NULL,NULL),(17213,831,16.667,35.5141,NULL,NULL,NULL,NULL),(17214,831,27.465,36.8083,NULL,NULL,NULL,NULL),(17215,831,52.57,38.1016,NULL,NULL,NULL,NULL),(17216,831,73.598,38.1466,NULL,NULL,NULL,NULL),(17217,831,97.196,38.9496,NULL,NULL,NULL,NULL),(17218,831,122.75,39.1723,NULL,NULL,NULL,NULL),(17219,831,146.68,39.7085,NULL,NULL,NULL,NULL),(17220,831,161.22,40.2438,NULL,NULL,NULL,NULL),(17221,831,188.32,40.7341,NULL,NULL,NULL,NULL),(17222,831,199.53,41.2694,NULL,NULL,NULL,NULL),(17223,831,216.12,40.8684,NULL,NULL,NULL,NULL),(17224,832,1.196,27.9194,NULL,NULL,NULL,NULL),(17225,832,1.3593,28.3449,NULL,NULL,NULL,NULL),(17226,832,2.1363,30.2582,NULL,NULL,NULL,NULL),(17227,832,5.1846,31.2408,NULL,NULL,NULL,NULL),(17228,832,7.1625,31.3806,NULL,NULL,NULL,NULL),(17229,832,10.12,32.0102,NULL,NULL,NULL,NULL),(17230,832,19.957,34.5265,NULL,NULL,NULL,NULL),(17231,832,29.417,35.8541,NULL,NULL,NULL,NULL),(17232,832,41.383,37.5316,NULL,NULL,NULL,NULL),(17233,832,51.064,38.65,NULL,NULL,NULL,NULL),(17234,832,70.747,40.1878,NULL,NULL,NULL,NULL),(17235,832,98.034,41.4541,NULL,NULL,NULL,NULL),(17236,832,202.8,45.5643,NULL,NULL,NULL,NULL),(17237,832,251.31,46.5561,NULL,NULL,NULL,NULL),(17238,833,0.8853,27.5786,NULL,NULL,NULL,NULL),(17239,833,0.9504,31.1582,NULL,NULL,NULL,NULL),(17240,833,1.1064,32.6265,NULL,NULL,NULL,NULL),(17241,833,1.8963,36.3306,NULL,NULL,NULL,NULL),(17242,833,4.9712,42.2469,NULL,NULL,NULL,NULL),(17243,833,6.8858,43.5224,NULL,NULL,NULL,NULL),(17244,833,9.933,45.4357,NULL,NULL,NULL,NULL),(17245,833,19.822,48.9786,NULL,NULL,NULL,NULL),(17246,833,29.023,51.5337,NULL,NULL,NULL,NULL),(17247,833,41.143,52.4296,NULL,NULL,NULL,NULL),(17248,833,50.025,53.3265,NULL,NULL,NULL,NULL),(17249,833,72.011,55.4633,NULL,NULL,NULL,NULL),(17250,833,98.312,56.1531,NULL,NULL,NULL,NULL),(17251,833,201.51,60.2459,NULL,NULL,NULL,NULL),(17252,833,247.16,62.301,NULL,NULL,NULL,NULL),(17253,834,0.8905,24.5561,NULL,NULL,NULL,NULL),(17254,834,1.5676,26.5398,NULL,NULL,NULL,NULL),(17255,834,1.9068,26.3276,NULL,NULL,NULL,NULL),(17256,834,3.9453,27.5316,NULL,NULL,NULL,NULL),(17257,834,6.8858,27.7449,NULL,NULL,NULL,NULL),(17258,834,9.933,28.4531,NULL,NULL,NULL,NULL),(17259,834,22.75,30.851,NULL,NULL,NULL,NULL),(17260,834,27.968,31.0602,NULL,NULL,NULL,NULL),(17261,834,41.143,32.249,NULL,NULL,NULL,NULL),(17262,834,50.556,32.8776,NULL,NULL,NULL,NULL),(17263,834,70.136,33.5071,NULL,NULL,NULL,NULL),(17264,834,97.794,34.5551,NULL,NULL,NULL,NULL),(17265,834,195.27,38.1898,NULL,NULL,NULL,NULL),(17266,834,312.82,40.2163,NULL,NULL,NULL,NULL),(17267,834,435.03,43.9725,NULL,NULL,NULL,NULL),(17268,835,0.8853,25.1643,NULL,NULL,NULL,NULL),(17269,835,1.5854,27.5735,NULL,NULL,NULL,NULL),(17270,835,1.8963,27.0776,NULL,NULL,NULL,NULL),(17271,835,3.9453,28.7786,NULL,NULL,NULL,NULL),(17272,835,6.9225,28.9204,NULL,NULL,NULL,NULL),(17273,835,13.032,30.1918,NULL,NULL,NULL,NULL),(17274,835,19.928,31.2398,NULL,NULL,NULL,NULL),(17275,835,28.116,32.4286,NULL,NULL,NULL,NULL),(17276,835,37.608,33.8265,NULL,NULL,NULL,NULL),(17277,835,51.909,34.9449,NULL,NULL,NULL,NULL),(17278,835,70.507,35.9224,NULL,NULL,NULL,NULL),(17279,835,97.794,37.251,NULL,NULL,NULL,NULL),(17280,835,201.51,40.0469,NULL,NULL,NULL,NULL),(17281,835,275.88,42.5255,NULL,NULL,NULL,NULL),(17282,835,435.03,44.2969,NULL,NULL,NULL,NULL),(17283,836,0.01,26.5306,NULL,NULL,NULL,NULL),(17284,836,1.9943,30.7541,NULL,NULL,NULL,NULL),(17285,836,7.265,33.3755,NULL,NULL,NULL,NULL),(17286,836,12.251,34.8643,NULL,NULL,NULL,NULL),(17287,836,25.641,37.8398,NULL,NULL,NULL,NULL),(17288,836,37.892,39.3286,NULL,NULL,NULL,NULL),(17289,836,49.288,41.098,NULL,NULL,NULL,NULL),(17290,836,60.845,42.1531,NULL,NULL,NULL,NULL),(17291,836,71.127,43.2796,NULL,NULL,NULL,NULL),(17292,836,79.718,43.6316,NULL,NULL,NULL,NULL),(17293,836,87.747,44.4755,NULL,NULL,NULL,NULL),(17294,837,0.01,28.0082,NULL,NULL,NULL,NULL),(17295,837,2.5641,32.3837,NULL,NULL,NULL,NULL),(17296,837,7.4074,34.0133,NULL,NULL,NULL,NULL),(17297,837,14.245,35.9265,NULL,NULL,NULL,NULL),(17298,837,25.641,38.2653,NULL,NULL,NULL,NULL),(17299,837,34.758,40.0367,NULL,NULL,NULL,NULL),(17300,837,42.45,41.3796,NULL,NULL,NULL,NULL),(17301,837,60.704,43.1388,NULL,NULL,NULL,NULL),(17302,837,75.493,44.4051,NULL,NULL,NULL,NULL),(17303,837,87.465,45.25,NULL,NULL,NULL,NULL),(17304,838,0.01,29.6969,NULL,NULL,NULL,NULL),(17305,838,0.5,34.9347,NULL,NULL,NULL,NULL),(17306,838,3.5613,39.1867,NULL,NULL,NULL,NULL),(17307,838,8.547,41.9418,NULL,NULL,NULL,NULL),(17308,838,12.536,44.0531,NULL,NULL,NULL,NULL),(17309,838,25.641,47.3612,NULL,NULL,NULL,NULL),(17310,838,37.749,49.1204,NULL,NULL,NULL,NULL),(17311,838,42.878,50.1755,NULL,NULL,NULL,NULL),(17312,838,60.845,51.7194,NULL,NULL,NULL,NULL),(17313,838,75.352,52.4878,NULL,NULL,NULL,NULL),(17314,838,87.465,53.5367,NULL,NULL,NULL,NULL),(17315,839,0.19,65.5612,NULL,NULL,NULL,NULL),(17316,839,0.98,70.398,NULL,NULL,NULL,NULL),(17317,839,1.91,76.8163,NULL,NULL,NULL,NULL),(17318,839,3.04,80.6633,NULL,NULL,NULL,NULL),(17319,839,3.95,83.5102,NULL,NULL,NULL,NULL),(17320,839,5.84,88.6429,NULL,NULL,NULL,NULL),(17321,839,6.78,89.9286,NULL,NULL,NULL,NULL),(17322,839,13.75,98.6225,NULL,NULL,NULL,NULL),(17323,839,20.71,101.184,NULL,NULL,NULL,NULL),(17324,839,28.19,105.102,NULL,NULL,NULL,NULL),(17325,839,35.16,106.735,NULL,NULL,NULL,NULL),(17326,839,40.83,106.735,NULL,NULL,NULL,NULL),(17327,839,47.53,109.286,NULL,NULL,NULL,NULL),(17328,839,54.25,108.878,NULL,NULL,NULL,NULL),(17329,839,60.36,109.898,NULL,NULL,NULL,NULL),(17330,839,73.92,110.918,NULL,NULL,NULL,NULL),(17331,839,89.03,106.122,NULL,NULL,NULL,NULL),(17332,839,101.02,114.082,NULL,NULL,NULL,NULL),(17333,839,115.72,112.755,NULL,NULL,NULL,NULL),(17334,839,126.04,114.796,NULL,NULL,NULL,NULL),(17335,839,137.97,115.918,NULL,NULL,NULL,NULL),(17336,839,153.32,116.735,NULL,NULL,NULL,NULL),(17337,839,164.48,115.51,NULL,NULL,NULL,NULL),(17338,839,210.59,116.122,NULL,NULL,NULL,NULL),(17339,839,245.33,121.735,NULL,NULL,NULL,NULL),(17340,839,274.7,121.02,NULL,NULL,NULL,NULL),(17341,839,300.55,120.306,NULL,NULL,NULL,NULL),(17342,839,331.46,123.367,NULL,NULL,NULL,NULL),(17343,839,358.09,122.143,NULL,NULL,NULL,NULL),(17344,839,479.85,125.204,NULL,NULL,NULL,NULL),(17345,839,539.03,124.184,NULL,NULL,NULL,NULL),(17346,839,600.51,127.245,NULL,NULL,NULL,NULL),(17347,839,655.38,129.286,NULL,NULL,NULL,NULL),(17348,839,715.24,130,NULL,NULL,NULL,NULL),(17349,839,776.57,131.02,NULL,NULL,NULL,NULL),(17350,839,825.98,129.898,NULL,NULL,NULL,NULL),(17351,839,838.82,131.429,NULL,NULL,NULL,NULL),(17352,839,906.05,137.653,NULL,NULL,NULL,NULL),(17353,839,973.66,136.531,NULL,NULL,NULL,NULL),(17354,839,1036.4,136.735,NULL,NULL,NULL,NULL),(17355,839,1081,138.163,NULL,NULL,NULL,NULL),(17356,839,1157.4,136.939,NULL,NULL,NULL,NULL),(17357,840,0.22,57.0102,NULL,NULL,NULL,NULL),(17358,840,1,61.1429,NULL,NULL,NULL,NULL),(17359,840,1.95,62.7041,NULL,NULL,NULL,NULL),(17360,840,3.95,66.1327,NULL,NULL,NULL,NULL),(17361,840,5.84,68.1225,NULL,NULL,NULL,NULL),(17362,840,6.7,69.8367,NULL,NULL,NULL,NULL),(17363,840,13.44,74.2551,NULL,NULL,NULL,NULL),(17364,840,20.36,74.5408,NULL,NULL,NULL,NULL),(17365,840,27.71,78.6735,NULL,NULL,NULL,NULL),(17366,840,34.8,79.2347,NULL,NULL,NULL,NULL),(17367,840,41.03,80.0918,NULL,NULL,NULL,NULL),(17368,840,47.29,81.6633,NULL,NULL,NULL,NULL),(17369,840,56.01,82.949,NULL,NULL,NULL,NULL),(17370,840,61.67,83.7959,NULL,NULL,NULL,NULL),(17371,840,76.31,85.6531,NULL,NULL,NULL,NULL),(17372,840,89.98,87.3673,NULL,NULL,NULL,NULL),(17373,840,102.04,88.3571,NULL,NULL,NULL,NULL),(17374,840,114.56,89.6429,NULL,NULL,NULL,NULL),(17375,840,128.6,90.7857,NULL,NULL,NULL,NULL),(17376,840,140.07,91.9184,NULL,NULL,NULL,NULL),(17377,840,156.43,92.9184,NULL,NULL,NULL,NULL),(17378,840,208.22,96.7653,NULL,NULL,NULL,NULL),(17379,840,246.72,97.051,NULL,NULL,NULL,NULL),(17380,840,276.26,99.1939,NULL,NULL,NULL,NULL),(17381,840,302.1,99.1939,NULL,NULL,NULL,NULL),(17382,840,334.9,100.327,NULL,NULL,NULL,NULL),(17383,840,408.03,101.469,NULL,NULL,NULL,NULL),(17384,840,482.54,103.367,NULL,NULL,NULL,NULL),(17385,840,547.41,105.408,NULL,NULL,NULL,NULL),(17386,840,619.33,106.122,NULL,NULL,NULL,NULL),(17387,840,658.75,110.204,NULL,NULL,NULL,NULL),(17388,840,722.64,109.898,NULL,NULL,NULL,NULL),(17389,840,780.57,108.469,NULL,NULL,NULL,NULL),(17390,840,851.85,110.918,NULL,NULL,NULL,NULL),(17391,840,1081,116.531,NULL,NULL,NULL,NULL),(17392,840,1121.5,117.449,NULL,NULL,NULL,NULL),(17393,840,1226.3,116.939,NULL,NULL,NULL,NULL),(17394,840,1258.9,118.265,NULL,NULL,NULL,NULL),(17395,841,0.33,50.4531,NULL,NULL,NULL,NULL),(17396,841,1.09,52.3204,NULL,NULL,NULL,NULL),(17397,841,2.04,53.8816,NULL,NULL,NULL,NULL),(17398,841,4.07,56.3102,NULL,NULL,NULL,NULL),(17399,841,4.98,57.1673,NULL,NULL,NULL,NULL),(17400,841,5.96,57.1673,NULL,NULL,NULL,NULL),(17401,841,13.56,59.3,NULL,NULL,NULL,NULL),(17402,841,20.6,60.4429,NULL,NULL,NULL,NULL),(17403,841,27.68,59.5857,NULL,NULL,NULL,NULL),(17404,841,40.74,62.1469,NULL,NULL,NULL,NULL),(17405,841,47.41,62.5755,NULL,NULL,NULL,NULL),(17406,841,55.24,63.0041,NULL,NULL,NULL,NULL),(17407,841,61.46,63.2898,NULL,NULL,NULL,NULL),(17408,841,74.43,64.4327,NULL,NULL,NULL,NULL),(17409,841,89.15,63.8612,NULL,NULL,NULL,NULL),(17410,841,101.14,64.7184,NULL,NULL,NULL,NULL),(17411,841,112.4,64.0041,NULL,NULL,NULL,NULL),(17412,841,127.44,65.7184,NULL,NULL,NULL,NULL),(17413,841,137.4,67.5653,NULL,NULL,NULL,NULL),(17414,841,152.67,67.9939,NULL,NULL,NULL,NULL),(17415,841,164.6,67.7082,NULL,NULL,NULL,NULL),(17416,841,177.45,68.1367,NULL,NULL,NULL,NULL),(17417,841,205.99,69.2796,NULL,NULL,NULL,NULL),(17418,841,237.27,69.9939,NULL,NULL,NULL,NULL),(17419,841,265.66,71.5551,NULL,NULL,NULL,NULL),(17420,841,311.71,71.1265,NULL,NULL,NULL,NULL),(17421,841,365.67,71.4122,NULL,NULL,NULL,NULL),(17422,841,401.36,72.8408,NULL,NULL,NULL,NULL),(17423,841,461.56,73.9837,NULL,NULL,NULL,NULL),(17424,841,645.46,76.9735,NULL,NULL,NULL,NULL),(17425,841,722.76,76.5449,NULL,NULL,NULL,NULL),(17426,841,776.69,77.6878,NULL,NULL,NULL,NULL),(17427,841,838.94,78.6878,NULL,NULL,NULL,NULL),(17428,841,910.84,80.9633,NULL,NULL,NULL,NULL),(17429,841,953.96,80.6776,NULL,NULL,NULL,NULL),(17430,841,1025.72,82.249,NULL,NULL,NULL,NULL),(17431,841,1081.12,81.1061,NULL,NULL,NULL,NULL),(17432,842,0.34,46.8367,NULL,NULL,NULL,NULL),(17433,842,1.11,49.2857,NULL,NULL,NULL,NULL),(17434,842,3.16,51.449,NULL,NULL,NULL,NULL),(17435,842,4.05,52.449,NULL,NULL,NULL,NULL),(17436,842,5.01,53.2959,NULL,NULL,NULL,NULL),(17437,842,5.96,53.2959,NULL,NULL,NULL,NULL),(17438,842,6.66,53.0204,NULL,NULL,NULL,NULL),(17439,842,13.72,56.0102,NULL,NULL,NULL,NULL),(17440,842,20.36,54.1531,NULL,NULL,NULL,NULL),(17441,842,27.83,55.0102,NULL,NULL,NULL,NULL),(17442,842,35.1,54.7245,NULL,NULL,NULL,NULL),(17443,842,40.33,54.4388,NULL,NULL,NULL,NULL),(17444,842,47.65,55.7245,NULL,NULL,NULL,NULL),(17445,842,53.22,57.5816,NULL,NULL,NULL,NULL),(17446,842,58.89,57.5816,NULL,NULL,NULL,NULL),(17447,842,74.43,58.5714,NULL,NULL,NULL,NULL),(17448,842,87.74,58.2857,NULL,NULL,NULL,NULL),(17449,842,100.63,58.2857,NULL,NULL,NULL,NULL),(17450,842,126.16,58.4286,NULL,NULL,NULL,NULL),(17451,842,140.89,59.1429,NULL,NULL,NULL,NULL),(17452,842,153.44,58.8571,NULL,NULL,NULL,NULL),(17453,842,160.52,60.8571,NULL,NULL,NULL,NULL),(17454,842,177.45,61.4286,NULL,NULL,NULL,NULL),(17455,842,189.39,61.5714,NULL,NULL,NULL,NULL),(17456,842,208.34,60.4286,NULL,NULL,NULL,NULL),(17457,842,233.28,61.4286,NULL,NULL,NULL,NULL),(17458,842,261.19,61.8469,NULL,NULL,NULL,NULL),(17459,842,324.82,62.4184,NULL,NULL,NULL,NULL),(17460,842,358.21,62.8469,NULL,NULL,NULL,NULL),(17461,842,410.43,65.8367,NULL,NULL,NULL,NULL),(17462,842,466.74,66.9796,NULL,NULL,NULL,NULL),(17463,842,533.63,67.6939,NULL,NULL,NULL,NULL),(17464,842,603.73,70.9694,NULL,NULL,NULL,NULL),(17465,842,606.84,70.8265,NULL,NULL,NULL,NULL),(17466,842,658.87,69.9694,NULL,NULL,NULL,NULL),(17467,842,772.7,71.6837,NULL,NULL,NULL,NULL),(17468,842,851.97,72.9694,NULL,NULL,NULL,NULL),(17469,842,929.76,74.1122,NULL,NULL,NULL,NULL),(17470,842,944.21,75.3878,NULL,NULL,NULL,NULL),(17471,842,1058.62,75.2449,NULL,NULL,NULL,NULL),(17472,842,1098.22,75.2449,NULL,NULL,NULL,NULL),(17473,843,0.32,39.4898,NULL,NULL,NULL,NULL),(17474,843,1.05,41.3673,NULL,NULL,NULL,NULL),(17475,843,2.04,42.5204,NULL,NULL,NULL,NULL),(17476,843,3.09,43.0918,NULL,NULL,NULL,NULL),(17477,843,4.89,44.102,NULL,NULL,NULL,NULL),(17478,843,5.86,44.6735,NULL,NULL,NULL,NULL),(17479,843,6.71,44.8265,NULL,NULL,NULL,NULL),(17480,843,14.63,45.9796,NULL,NULL,NULL,NULL),(17481,843,20.33,46.8367,NULL,NULL,NULL,NULL),(17482,843,27.03,47.9898,NULL,NULL,NULL,NULL),(17483,843,34.35,48.7143,NULL,NULL,NULL,NULL),(17484,843,47.38,48.4286,NULL,NULL,NULL,NULL),(17485,843,61.76,49.4388,NULL,NULL,NULL,NULL),(17486,843,72.83,50.2959,NULL,NULL,NULL,NULL),(17487,843,88.65,49.8673,NULL,NULL,NULL,NULL),(17488,843,100.09,49.8673,NULL,NULL,NULL,NULL),(17489,843,115.81,51.3061,NULL,NULL,NULL,NULL),(17490,843,126.13,51.5918,NULL,NULL,NULL,NULL),(17491,843,138.06,51.1633,NULL,NULL,NULL,NULL),(17492,843,150.36,51.7347,NULL,NULL,NULL,NULL),(17493,843,162.11,51.5918,NULL,NULL,NULL,NULL),(17494,843,175.65,51.8776,NULL,NULL,NULL,NULL),(17495,843,231.93,54.8673,NULL,NULL,NULL,NULL),(17496,843,299.09,56.0102,NULL,NULL,NULL,NULL),(17497,843,326.47,57.0102,NULL,NULL,NULL,NULL),(17498,843,349.08,56.8673,NULL,NULL,NULL,NULL),(17499,843,375.18,58.1429,NULL,NULL,NULL,NULL),(17500,843,412.71,58.2857,NULL,NULL,NULL,NULL),(17501,843,446.3,58.4286,NULL,NULL,NULL,NULL),(17502,843,512.09,59.1429,NULL,NULL,NULL,NULL),(17503,843,561.76,61.1429,NULL,NULL,NULL,NULL),(17504,843,616.25,61.2857,NULL,NULL,NULL,NULL),(17505,843,690.05,63.2755,NULL,NULL,NULL,NULL),(17506,843,749.21,63.1327,NULL,NULL,NULL,NULL),(17507,843,813.43,63.4184,NULL,NULL,NULL,NULL),(17508,844,6.82,81.6633,NULL,NULL,NULL,NULL),(17509,844,13.83,87.3673,NULL,NULL,NULL,NULL),(17510,844,20.95,88.6429,NULL,NULL,NULL,NULL),(17511,844,28.19,89.0714,NULL,NULL,NULL,NULL),(17512,844,35.16,89.6429,NULL,NULL,NULL,NULL),(17513,844,41.24,89.5,NULL,NULL,NULL,NULL),(17514,844,47.53,90.6429,NULL,NULL,NULL,NULL),(17515,844,55.12,92.4898,NULL,NULL,NULL,NULL),(17516,844,62.66,93.3469,NULL,NULL,NULL,NULL),(17517,844,68.97,93.6327,NULL,NULL,NULL,NULL),(17518,844,77.95,96.7653,NULL,NULL,NULL,NULL),(17519,844,83.09,95.9082,NULL,NULL,NULL,NULL),(17520,844,88.09,95.0612,NULL,NULL,NULL,NULL),(17521,844,95.39,96.3367,NULL,NULL,NULL,NULL),(17522,844,103.07,95.3469,NULL,NULL,NULL,NULL),(17523,844,110.04,95.9082,NULL,NULL,NULL,NULL),(17524,844,117.48,97.6225,NULL,NULL,NULL,NULL),(17525,844,121.69,101.755,NULL,NULL,NULL,NULL),(17526,844,130.56,102.449,NULL,NULL,NULL,NULL),(17527,844,135.91,101.755,NULL,NULL,NULL,NULL),(17528,844,142.2,100.051,NULL,NULL,NULL,NULL),(17529,844,148.02,100.327,NULL,NULL,NULL,NULL),(17530,844,160.4,99.3367,NULL,NULL,NULL,NULL),(17531,844,166.13,98.6225,NULL,NULL,NULL,NULL),(17532,844,171.21,100.327,NULL,NULL,NULL,NULL),(17533,844,185.51,99.4796,NULL,NULL,NULL,NULL),(17534,844,190.22,102.041,NULL,NULL,NULL,NULL),(17535,844,205.87,101.041,NULL,NULL,NULL,NULL),(17536,844,221.59,101.327,NULL,NULL,NULL,NULL),(17537,844,238.49,101.469,NULL,NULL,NULL,NULL),(17538,844,242.57,99.7653,NULL,NULL,NULL,NULL),(17539,844,259.6,99.6225,NULL,NULL,NULL,NULL),(17540,844,268.56,101.612,NULL,NULL,NULL,NULL),(17541,844,276.26,102.959,NULL,NULL,NULL,NULL),(17542,844,295.64,103.367,NULL,NULL,NULL,NULL),(17543,844,318.08,103.98,NULL,NULL,NULL,NULL),(17544,844,338.37,102.653,NULL,NULL,NULL,NULL),(17545,844,341.87,100.898,NULL,NULL,NULL,NULL),(17546,844,356.25,100.327,NULL,NULL,NULL,NULL),(17547,844,377.02,100.755,NULL,NULL,NULL,NULL),(17548,844,396.95,98.9082,NULL,NULL,NULL,NULL),(17549,844,419.6,102.041,NULL,NULL,NULL,NULL),(17550,844,433.91,103.163,NULL,NULL,NULL,NULL),(17551,844,477.18,103.163,NULL,NULL,NULL,NULL),(17552,844,509.38,104.388,NULL,NULL,NULL,NULL),(17553,844,536.26,105.408,NULL,NULL,NULL,NULL),(17554,844,579.28,106.429,NULL,NULL,NULL,NULL),(17555,844,616.16,105.51,NULL,NULL,NULL,NULL),(17556,844,625.74,104.388,NULL,NULL,NULL,NULL),(17557,844,648.67,105.816,NULL,NULL,NULL,NULL),(17558,844,662.15,106.735,NULL,NULL,NULL,NULL),(17559,844,715.24,105.102,NULL,NULL,NULL,NULL),(17560,844,749.12,104.898,NULL,NULL,NULL,NULL),(17561,844,805.02,104.898,NULL,NULL,NULL,NULL),(17562,844,860.66,105.51,NULL,NULL,NULL,NULL),(17563,844,920.13,106.224,NULL,NULL,NULL,NULL),(17564,844,939.25,107.653,NULL,NULL,NULL,NULL),(17565,844,999,108.673,NULL,NULL,NULL,NULL),(17566,844,1020.2,109.184,NULL,NULL,NULL,NULL),(17567,844,1064,110.408,NULL,NULL,NULL,NULL),(17568,844,1127.4,108.98,NULL,NULL,NULL,NULL),(17569,844,1157.4,110.204,NULL,NULL,NULL,NULL),(17570,844,1213.5,109.592,NULL,NULL,NULL,NULL),(17571,844,1272.2,110.612,NULL,NULL,NULL,NULL),(17572,844,1313,112.041,NULL,NULL,NULL,NULL),(17573,845,1.95,60.1429,NULL,NULL,NULL,NULL),(17574,845,3.08,60.8571,NULL,NULL,NULL,NULL),(17575,845,7.98,62.9898,NULL,NULL,NULL,NULL),(17576,845,13.83,63.5612,NULL,NULL,NULL,NULL),(17577,845,20.83,65.9796,NULL,NULL,NULL,NULL),(17578,845,28.19,67.6939,NULL,NULL,NULL,NULL),(17579,845,35.34,71.9694,NULL,NULL,NULL,NULL),(17580,845,41.66,71.9694,NULL,NULL,NULL,NULL),(17581,845,48.02,70.398,NULL,NULL,NULL,NULL),(17582,845,54.25,71.1122,NULL,NULL,NULL,NULL),(17583,845,62,71.2551,NULL,NULL,NULL,NULL),(17584,845,68.97,72.2551,NULL,NULL,NULL,NULL),(17585,845,75.91,72.6837,NULL,NULL,NULL,NULL),(17586,845,82.21,73.2551,NULL,NULL,NULL,NULL),(17587,845,89.98,77.5306,NULL,NULL,NULL,NULL),(17588,845,95.39,78.6735,NULL,NULL,NULL,NULL),(17589,845,103.59,77.102,NULL,NULL,NULL,NULL),(17590,845,109.49,75.8163,NULL,NULL,NULL,NULL),(17591,845,118.66,74.1122,NULL,NULL,NULL,NULL),(17592,845,124.16,76.2449,NULL,NULL,NULL,NULL),(17593,845,133.88,76.3878,NULL,NULL,NULL,NULL),(17594,845,135.91,79.8061,NULL,NULL,NULL,NULL),(17595,845,143.63,79.5204,NULL,NULL,NULL,NULL),(17596,845,150.27,79.0918,NULL,NULL,NULL,NULL),(17597,845,160.4,79.5204,NULL,NULL,NULL,NULL),(17598,845,168.65,81.5204,NULL,NULL,NULL,NULL),(17599,845,176.44,77.5306,NULL,NULL,NULL,NULL),(17600,845,187.38,80.949,NULL,NULL,NULL,NULL),(17601,845,200.13,81.0918,NULL,NULL,NULL,NULL),(17602,845,210.59,82.6633,NULL,NULL,NULL,NULL),(17603,845,225.38,83.9388,NULL,NULL,NULL,NULL),(17604,845,238.49,83.9388,NULL,NULL,NULL,NULL),(17605,845,253.8,85.2245,NULL,NULL,NULL,NULL),(17606,845,264.04,83.3673,NULL,NULL,NULL,NULL),(17607,845,297.32,82.2347,NULL,NULL,NULL,NULL),(17608,845,313.2,82.7959,NULL,NULL,NULL,NULL),(17609,845,331.46,79.5204,NULL,NULL,NULL,NULL),(17610,845,341.87,84.5102,NULL,NULL,NULL,NULL),(17611,845,359.94,83.5102,NULL,NULL,NULL,NULL),(17612,845,380.93,81.5204,NULL,NULL,NULL,NULL),(17613,845,405.75,85.2245,NULL,NULL,NULL,NULL),(17614,845,419.6,80.2347,NULL,NULL,NULL,NULL),(17615,845,446.21,82.6633,NULL,NULL,NULL,NULL),(17616,845,464.02,83.0918,NULL,NULL,NULL,NULL),(17617,845,493.45,81.8061,NULL,NULL,NULL,NULL),(17618,845,533.51,82.0918,NULL,NULL,NULL,NULL),(17619,845,585.27,83.3673,NULL,NULL,NULL,NULL),(17620,845,648.67,83.6531,NULL,NULL,NULL,NULL),(17621,845,689.96,84.5102,NULL,NULL,NULL,NULL),(17622,846,5.91,56.8673,NULL,NULL,NULL,NULL),(17623,846,13.67,57.4286,NULL,NULL,NULL,NULL),(17624,846,20.83,59.2857,NULL,NULL,NULL,NULL),(17625,846,27.87,61.4286,NULL,NULL,NULL,NULL),(17626,846,34.98,61,NULL,NULL,NULL,NULL),(17627,846,41.45,61.5714,NULL,NULL,NULL,NULL),(17628,846,47.53,64.4184,NULL,NULL,NULL,NULL),(17629,846,53.67,63.5612,NULL,NULL,NULL,NULL),(17630,846,62.66,64.2755,NULL,NULL,NULL,NULL),(17631,846,67.52,63.1327,NULL,NULL,NULL,NULL),(17632,846,74.31,63.8469,NULL,NULL,NULL,NULL),(17633,846,82.21,64.4184,NULL,NULL,NULL,NULL),(17634,846,89.03,64.7041,NULL,NULL,NULL,NULL),(17635,846,95.39,64.9898,NULL,NULL,NULL,NULL),(17636,846,109.49,68.6939,NULL,NULL,NULL,NULL),(17637,846,135.91,69.4082,NULL,NULL,NULL,NULL),(17638,846,153.32,69.4082,NULL,NULL,NULL,NULL),(17639,846,175.56,66.2653,NULL,NULL,NULL,NULL),(17640,846,195.05,69.8367,NULL,NULL,NULL,NULL),(17641,846,220.34,68.9796,NULL,NULL,NULL,NULL),(17642,846,237.15,70.9694,NULL,NULL,NULL,NULL),(17643,846,252.37,70.1225,NULL,NULL,NULL,NULL),(17644,846,276.26,69.8367,NULL,NULL,NULL,NULL),(17645,846,311.59,68.2653,NULL,NULL,NULL,NULL),(17646,846,333.18,68.2653,NULL,NULL,NULL,NULL),(17647,846,356.25,68.2653,NULL,NULL,NULL,NULL),(17648,846,373.16,68.9796,NULL,NULL,NULL,NULL),(17649,846,390.86,68.4082,NULL,NULL,NULL,NULL),(17650,846,408.03,69.8367,NULL,NULL,NULL,NULL),(17651,846,429.09,71.398,NULL,NULL,NULL,NULL),(17652,846,443.73,70.1225,NULL,NULL,NULL,NULL),(17653,846,466.62,69.4082,NULL,NULL,NULL,NULL),(17654,846,490.7,67.9796,NULL,NULL,NULL,NULL),(17655,846,499,69.551,NULL,NULL,NULL,NULL),(17656,846,517.3,69.1225,NULL,NULL,NULL,NULL),(17657,846,519.97,70.8265,NULL,NULL,NULL,NULL),(17658,846,541.81,71.1122,NULL,NULL,NULL,NULL),(17659,846,573.35,70.5408,NULL,NULL,NULL,NULL),(17660,846,600.51,69.8367,NULL,NULL,NULL,NULL),(17661,846,616.16,68.4082,NULL,NULL,NULL,NULL),(17662,846,635.46,68.4082,NULL,NULL,NULL,NULL),(17663,846,672.44,68.4082,NULL,NULL,NULL,NULL),(17664,847,0.16,80.2143,NULL,NULL,NULL,NULL),(17665,847,0.99,85.1735,NULL,NULL,NULL,NULL),(17666,847,2.02,90.7041,NULL,NULL,NULL,NULL),(17667,847,3,94.5306,NULL,NULL,NULL,NULL),(17668,847,4.88,98.6429,NULL,NULL,NULL,NULL),(17669,847,5.76,103.776,NULL,NULL,NULL,NULL),(17670,847,6.91,106.02,NULL,NULL,NULL,NULL),(17671,847,13.78,116.429,NULL,NULL,NULL,NULL),(17672,847,20.6,121.837,NULL,NULL,NULL,NULL),(17673,847,27.79,127.449,NULL,NULL,NULL,NULL),(17674,847,34.65,129.592,NULL,NULL,NULL,NULL),(17675,847,41.08,130.612,NULL,NULL,NULL,NULL),(17676,847,47.5,134.082,NULL,NULL,NULL,NULL),(17677,847,53.88,135.408,NULL,NULL,NULL,NULL),(17678,847,59.86,135.714,NULL,NULL,NULL,NULL),(17679,847,73.08,140.816,NULL,NULL,NULL,NULL),(17680,847,88.24,142.143,NULL,NULL,NULL,NULL),(17681,847,99,142.857,NULL,NULL,NULL,NULL),(17682,847,116.25,145.306,NULL,NULL,NULL,NULL),(17683,847,128.93,145.204,NULL,NULL,NULL,NULL),(17684,847,140.79,146.122,NULL,NULL,NULL,NULL),(17685,847,155.31,145.204,NULL,NULL,NULL,NULL),(17686,847,169.57,147.041,NULL,NULL,NULL,NULL),(17687,847,185.13,148.469,NULL,NULL,NULL,NULL),(17688,847,203.31,149.796,NULL,NULL,NULL,NULL),(17689,847,236.23,150.612,NULL,NULL,NULL,NULL),(17690,847,268.64,153.776,NULL,NULL,NULL,NULL),(17691,847,292.67,152.959,NULL,NULL,NULL,NULL),(17692,847,322.23,157.041,NULL,NULL,NULL,NULL),(17693,847,352.87,157.347,NULL,NULL,NULL,NULL),(17694,847,485.25,165.612,NULL,NULL,NULL,NULL),(17695,847,552.66,166.327,NULL,NULL,NULL,NULL),(17696,847,612.07,168.673,NULL,NULL,NULL,NULL),(17697,847,667.56,170.816,NULL,NULL,NULL,NULL),(17698,847,717,169.592,NULL,NULL,NULL,NULL),(17699,847,750.7,171.224,NULL,NULL,NULL,NULL),(17700,847,835.62,168.367,NULL,NULL,NULL,NULL),(17701,847,906.7,168.878,NULL,NULL,NULL,NULL),(17702,847,939.67,172.755,NULL,NULL,NULL,NULL),(17703,847,1025.6,170.204,NULL,NULL,NULL,NULL),(17704,847,1075.3,171.939,NULL,NULL,NULL,NULL),(17705,848,1.01,60.5204,NULL,NULL,NULL,NULL),(17706,848,2,63.4898,NULL,NULL,NULL,NULL),(17707,848,2.98,66.0408,NULL,NULL,NULL,NULL),(17708,848,4.94,67.7449,NULL,NULL,NULL,NULL),(17709,848,6.02,69.3061,NULL,NULL,NULL,NULL),(17710,848,6.99,70.1531,NULL,NULL,NULL,NULL),(17711,848,13.71,73.9796,NULL,NULL,NULL,NULL),(17712,848,20.6,76.9592,NULL,NULL,NULL,NULL),(17713,848,28.24,79.6531,NULL,NULL,NULL,NULL),(17714,848,33.91,81.4898,NULL,NULL,NULL,NULL),(17715,848,41.08,83.4796,NULL,NULL,NULL,NULL),(17716,848,48.75,86.0306,NULL,NULL,NULL,NULL),(17717,848,55.32,86.5918,NULL,NULL,NULL,NULL),(17718,848,61.13,87.5816,NULL,NULL,NULL,NULL),(17719,848,73.85,89.4286,NULL,NULL,NULL,NULL),(17720,848,89.17,90.1327,NULL,NULL,NULL,NULL),(17721,848,103.19,95.0918,NULL,NULL,NULL,NULL),(17722,848,113.87,94.9592,NULL,NULL,NULL,NULL),(17723,848,129.6,96.7959,NULL,NULL,NULL,NULL),(17724,848,142.25,97.9286,NULL,NULL,NULL,NULL),(17725,848,156.12,98.6429,NULL,NULL,NULL,NULL),(17726,848,170.45,99.9184,NULL,NULL,NULL,NULL),(17727,848,182.28,100.194,NULL,NULL,NULL,NULL),(17728,848,206.61,102.653,NULL,NULL,NULL,NULL),(17729,848,238.78,104.796,NULL,NULL,NULL,NULL),(17730,848,271.53,106.02,NULL,NULL,NULL,NULL),(17731,848,330.96,111.531,NULL,NULL,NULL,NULL),(17732,848,436.35,115.408,NULL,NULL,NULL,NULL),(17733,848,501.56,117.143,NULL,NULL,NULL,NULL),(17734,848,552.66,118.571,NULL,NULL,NULL,NULL),(17735,848,615.2,120.408,NULL,NULL,NULL,NULL),(17736,848,674.41,118.878,NULL,NULL,NULL,NULL),(17737,848,844.19,120,NULL,NULL,NULL,NULL),(17738,848,897.5,124.49,NULL,NULL,NULL,NULL),(17739,848,949.31,124.286,NULL,NULL,NULL,NULL),(17740,848,1041.9,123.163,NULL,NULL,NULL,NULL),(17741,848,1069.7,125.918,NULL,NULL,NULL,NULL),(17742,849,0.33,51.5061,NULL,NULL,NULL,NULL),(17743,849,2.2,55.6184,NULL,NULL,NULL,NULL),(17744,849,4.12,58.8735,NULL,NULL,NULL,NULL),(17745,849,5.96,59.7204,NULL,NULL,NULL,NULL),(17746,849,7.24,60.4347,NULL,NULL,NULL,NULL),(17747,849,14.14,61.7102,NULL,NULL,NULL,NULL),(17748,849,19.96,63.2714,NULL,NULL,NULL,NULL),(17749,849,27.91,66.098,NULL,NULL,NULL,NULL),(17750,849,35.15,66.8122,NULL,NULL,NULL,NULL),(17751,849,42.5,70.2102,NULL,NULL,NULL,NULL),(17752,849,48.62,70.4959,NULL,NULL,NULL,NULL),(17753,849,55.73,71.6286,NULL,NULL,NULL,NULL),(17754,849,63.88,72.0571,NULL,NULL,NULL,NULL),(17755,849,74.36,73.3327,NULL,NULL,NULL,NULL),(17756,849,91.18,74.0367,NULL,NULL,NULL,NULL),(17757,849,105.48,75.1694,NULL,NULL,NULL,NULL),(17758,849,116.98,75.7408,NULL,NULL,NULL,NULL),(17759,849,132.43,77.4347,NULL,NULL,NULL,NULL),(17760,849,143.11,78.2918,NULL,NULL,NULL,NULL),(17761,849,159.5,78.4347,NULL,NULL,NULL,NULL),(17762,849,170.57,78.9959,NULL,NULL,NULL,NULL),(17763,849,181.46,80.2714,NULL,NULL,NULL,NULL),(17764,849,219.28,81.6898,NULL,NULL,NULL,NULL),(17765,849,242.77,83.6796,NULL,NULL,NULL,NULL),(17766,849,276.05,84.3837,NULL,NULL,NULL,NULL),(17767,849,443.85,89.2,NULL,NULL,NULL,NULL),(17768,849,499.12,90.9041,NULL,NULL,NULL,NULL),(17769,849,575.82,92.0367,NULL,NULL,NULL,NULL),(17770,849,634.46,92.8837,NULL,NULL,NULL,NULL),(17771,849,677.98,94.302,NULL,NULL,NULL,NULL),(17772,849,735.65,96.8531,NULL,NULL,NULL,NULL),(17773,849,790.13,98.1286,NULL,NULL,NULL,NULL),(17774,849,866.13,97.1388,NULL,NULL,NULL,NULL),(17775,849,930.25,98.2714,NULL,NULL,NULL,NULL),(17776,849,978.94,100.261,NULL,NULL,NULL,NULL),(17777,849,1042.02,99.6898,NULL,NULL,NULL,NULL),(17778,850,1.09,51.8673,NULL,NULL,NULL,NULL),(17779,850,2.1,53.4286,NULL,NULL,NULL,NULL),(17780,850,2.98,54.7041,NULL,NULL,NULL,NULL),(17781,850,4.12,55.551,NULL,NULL,NULL,NULL),(17782,850,4.88,56.4082,NULL,NULL,NULL,NULL),(17783,850,7.03,57.1122,NULL,NULL,NULL,NULL),(17784,850,13.83,59.102,NULL,NULL,NULL,NULL),(17785,850,20.83,61.3673,NULL,NULL,NULL,NULL),(17786,850,26.76,61.9286,NULL,NULL,NULL,NULL),(17787,850,33.49,63.9184,NULL,NULL,NULL,NULL),(17788,850,41.2,64.3469,NULL,NULL,NULL,NULL),(17789,850,47.62,65.7551,NULL,NULL,NULL,NULL),(17790,850,54,66.1837,NULL,NULL,NULL,NULL),(17791,850,61.58,67.602,NULL,NULL,NULL,NULL),(17792,850,75.14,68.3061,NULL,NULL,NULL,NULL),(17793,850,90.23,69.7245,NULL,NULL,NULL,NULL),(17794,850,103.85,70.5816,NULL,NULL,NULL,NULL),(17795,850,115.77,71,NULL,NULL,NULL,NULL),(17796,850,128.39,72.8469,NULL,NULL,NULL,NULL),(17797,850,167.95,74.9694,NULL,NULL,NULL,NULL),(17798,850,270.2,77.102,NULL,NULL,NULL,NULL),(17799,850,302.33,77.949,NULL,NULL,NULL,NULL),(17800,850,332.85,84.1837,NULL,NULL,NULL,NULL),(17801,850,372.36,84.0408,NULL,NULL,NULL,NULL),(17802,850,417.38,85.8878,NULL,NULL,NULL,NULL),(17803,850,493.57,88.1531,NULL,NULL,NULL,NULL),(17804,850,538.84,89.1429,NULL,NULL,NULL,NULL),(17805,850,628.01,91.1327,NULL,NULL,NULL,NULL),(17806,850,667.68,91.8367,NULL,NULL,NULL,NULL),(17807,850,735.65,95.2347,NULL,NULL,NULL,NULL),(17808,850,848.63,100.908,NULL,NULL,NULL,NULL),(17809,851,1.08,48.8469,NULL,NULL,NULL,NULL),(17810,851,2.06,50.2959,NULL,NULL,NULL,NULL),(17811,851,3.04,51.5918,NULL,NULL,NULL,NULL),(17812,851,3.93,52.8673,NULL,NULL,NULL,NULL),(17813,851,5.88,54.4184,NULL,NULL,NULL,NULL),(17814,851,7.11,54,NULL,NULL,NULL,NULL),(17815,851,7.9,54.2755,NULL,NULL,NULL,NULL),(17816,851,14.78,56.9694,NULL,NULL,NULL,NULL),(17817,851,74.36,64.0612,NULL,NULL,NULL,NULL),(17818,851,88.36,65.4796,NULL,NULL,NULL,NULL),(17819,851,116.98,66.898,NULL,NULL,NULL,NULL),(17820,851,129.72,67.7449,NULL,NULL,NULL,NULL),(17821,851,143.85,69.0204,NULL,NULL,NULL,NULL),(17822,851,155.43,69.5816,NULL,NULL,NULL,NULL),(17823,851,168.82,70.1531,NULL,NULL,NULL,NULL),(17824,851,183.35,70.4388,NULL,NULL,NULL,NULL),(17825,851,205.63,72.1327,NULL,NULL,NULL,NULL),(17826,851,236.35,73.9796,NULL,NULL,NULL,NULL),(17827,851,273.11,74.8265,NULL,NULL,NULL,NULL),(17828,851,303.95,75.2551,NULL,NULL,NULL,NULL),(17829,851,327.56,76.3878,NULL,NULL,NULL,NULL),(17830,851,384.48,77.8061,NULL,NULL,NULL,NULL),(17831,851,461.56,80.6429,NULL,NULL,NULL,NULL),(17832,851,527.95,81.7755,NULL,NULL,NULL,NULL),(17833,851,567.07,82.9082,NULL,NULL,NULL,NULL),(17834,851,640.96,85.4592,NULL,NULL,NULL,NULL),(17835,851,709.84,86.1633,NULL,NULL,NULL,NULL),(17836,852,1.26,35.4082,NULL,NULL,NULL,NULL),(17837,852,2.05,38.0102,NULL,NULL,NULL,NULL),(17838,852,2.24,37.8673,NULL,NULL,NULL,NULL),(17839,852,3.02,39.3163,NULL,NULL,NULL,NULL),(17840,852,3.18,39.0204,NULL,NULL,NULL,NULL),(17841,852,5.98,42.0612,NULL,NULL,NULL,NULL),(17842,852,6.87,43.0714,NULL,NULL,NULL,NULL),(17843,852,8.74,44.0816,NULL,NULL,NULL,NULL),(17844,852,12.81,42.9286,NULL,NULL,NULL,NULL),(17845,852,13.48,44.5204,NULL,NULL,NULL,NULL),(17846,852,14.66,45.3878,NULL,NULL,NULL,NULL),(17847,852,15.41,46.398,NULL,NULL,NULL,NULL),(17848,852,16.83,46.398,NULL,NULL,NULL,NULL),(17849,852,18.49,46.9694,NULL,NULL,NULL,NULL),(17850,852,20.27,47.2653,NULL,NULL,NULL,NULL),(17851,852,21.62,46.5408,NULL,NULL,NULL,NULL),(17852,852,22.21,47.4082,NULL,NULL,NULL,NULL),(17853,852,23.18,47.4082,NULL,NULL,NULL,NULL),(17854,852,26.21,48.1327,NULL,NULL,NULL,NULL),(17855,852,27.65,48.7041,NULL,NULL,NULL,NULL),(17856,852,28.54,49.5714,NULL,NULL,NULL,NULL),(17857,852,30.61,49.4286,NULL,NULL,NULL,NULL),(17858,852,33.55,49.1429,NULL,NULL,NULL,NULL),(17859,852,34.47,51.0204,NULL,NULL,NULL,NULL),(17860,852,36.76,51.3061,NULL,NULL,NULL,NULL),(17861,852,40.24,50.1531,NULL,NULL,NULL,NULL),(17862,852,42.6,51.449,NULL,NULL,NULL,NULL),(17863,852,43.72,50.1531,NULL,NULL,NULL,NULL),(17864,852,45.81,51.0204,NULL,NULL,NULL,NULL),(17865,852,48,51.1633,NULL,NULL,NULL,NULL),(17866,852,49.26,51.3061,NULL,NULL,NULL,NULL),(17867,852,50.58,51.8673,NULL,NULL,NULL,NULL),(17868,852,52.2,52.1531,NULL,NULL,NULL,NULL),(17869,852,56.49,52.5816,NULL,NULL,NULL,NULL),(17870,852,59.86,52.8673,NULL,NULL,NULL,NULL),(17871,852,64.09,52.8673,NULL,NULL,NULL,NULL),(17872,852,67.55,53,NULL,NULL,NULL,NULL),(17873,853,0.73,33.5306,NULL,NULL,NULL,NULL),(17874,853,1.01,34.2551,NULL,NULL,NULL,NULL),(17875,853,1.77,35.551,NULL,NULL,NULL,NULL),(17876,853,2.89,37,NULL,NULL,NULL,NULL),(17877,853,3.75,37.4388,NULL,NULL,NULL,NULL),(17878,853,6.96,39.3163,NULL,NULL,NULL,NULL),(17879,853,7.84,40.0408,NULL,NULL,NULL,NULL),(17880,853,9.67,40.0408,NULL,NULL,NULL,NULL),(17881,853,10.72,41.9184,NULL,NULL,NULL,NULL),(17882,853,13.3,41.7653,NULL,NULL,NULL,NULL),(17883,853,16.53,41.7653,NULL,NULL,NULL,NULL),(17884,853,17.47,42.9286,NULL,NULL,NULL,NULL),(17885,853,19.92,43.0714,NULL,NULL,NULL,NULL),(17886,853,21.13,42.4898,NULL,NULL,NULL,NULL),(17887,853,22.18,43.3571,NULL,NULL,NULL,NULL),(17888,853,24.04,42.9286,NULL,NULL,NULL,NULL),(17889,853,31.25,44.0816,NULL,NULL,NULL,NULL),(17890,853,34.25,43.6531,NULL,NULL,NULL,NULL),(17891,853,38.14,44.5204,NULL,NULL,NULL,NULL),(17892,853,41.7,45.3878,NULL,NULL,NULL,NULL),(17893,853,45.54,43.3571,NULL,NULL,NULL,NULL),(17894,853,47.47,43.9388,NULL,NULL,NULL,NULL),(17895,853,51.35,42.9286,NULL,NULL,NULL,NULL),(17896,853,55,44.0816,NULL,NULL,NULL,NULL),(17897,853,63.73,45.6735,NULL,NULL,NULL,NULL),(17898,853,68.23,45.0918,NULL,NULL,NULL,NULL),(17899,853,73.82,47.6939,NULL,NULL,NULL,NULL),(17900,853,78.2,47.6939,NULL,NULL,NULL,NULL),(17901,853,82.41,47.6939,NULL,NULL,NULL,NULL),(17902,853,87.3,47.551,NULL,NULL,NULL,NULL),(17903,853,97.43,47.551,NULL,NULL,NULL,NULL),(17904,853,102.63,47.6939,NULL,NULL,NULL,NULL),(17905,853,108.65,48.5612,NULL,NULL,NULL,NULL),(17906,853,114.43,47.6939,NULL,NULL,NULL,NULL),(17907,853,118.66,49,NULL,NULL,NULL,NULL),(17908,853,128.9,49.2857,NULL,NULL,NULL,NULL),(17909,853,133.66,49.2857,NULL,NULL,NULL,NULL),(17910,853,142.96,48.8469,NULL,NULL,NULL,NULL),(17911,853,155.28,49.5714,NULL,NULL,NULL,NULL),(17912,853,164.37,49.8673,NULL,NULL,NULL,NULL),(17913,853,173.08,48.7041,NULL,NULL,NULL,NULL),(17914,853,178.53,50.4388,NULL,NULL,NULL,NULL),(17915,853,181.31,50.2959,NULL,NULL,NULL,NULL),(17916,853,200.04,50.7347,NULL,NULL,NULL,NULL),(17917,853,220.31,51.0204,NULL,NULL,NULL,NULL),(17918,853,226.29,51.7245,NULL,NULL,NULL,NULL),(17919,853,240.03,52.2959,NULL,NULL,NULL,NULL),(17920,853,254.6,52.7245,NULL,NULL,NULL,NULL),(17921,853,268.61,53.4286,NULL,NULL,NULL,NULL),(17922,853,274.42,52.0102,NULL,NULL,NULL,NULL),(17923,853,287.97,53.1429,NULL,NULL,NULL,NULL),(17924,853,297.37,52.5816,NULL,NULL,NULL,NULL),(17925,853,308.71,53.7143,NULL,NULL,NULL,NULL),(17926,853,334.48,53.4286,NULL,NULL,NULL,NULL),(17927,853,356.63,54.8469,NULL,NULL,NULL,NULL),(17928,853,378.22,54.1429,NULL,NULL,NULL,NULL),(17929,853,382.28,55.551,NULL,NULL,NULL,NULL),(17930,853,401.21,56.1224,NULL,NULL,NULL,NULL),(17931,853,429.06,55.8367,NULL,NULL,NULL,NULL),(17932,853,451.2,55.6939,NULL,NULL,NULL,NULL),(17933,853,471.84,56.4082,NULL,NULL,NULL,NULL),(17934,853,493.42,55.1327,NULL,NULL,NULL,NULL),(17935,853,519.78,56.1224,NULL,NULL,NULL,NULL),(17936,853,544.22,56.1224,NULL,NULL,NULL,NULL),(17937,853,566.92,56.8265,NULL,NULL,NULL,NULL),(17938,853,581.57,57.2551,NULL,NULL,NULL,NULL),(17939,854,1,10.2041,NULL,NULL,NULL,NULL),(17940,854,7,15,NULL,NULL,NULL,NULL),(17941,854,28,22.449,NULL,NULL,NULL,NULL),(17942,854,180,33.9796,NULL,NULL,NULL,NULL),(17943,854,500,41.5306,NULL,NULL,NULL,NULL),(17944,854,800,44.1837,NULL,NULL,NULL,NULL),(17945,854,1250,47.6531,NULL,NULL,NULL,NULL),(17946,855,1,5.40816,NULL,NULL,NULL,NULL),(17947,855,7,8.87755,NULL,NULL,NULL,NULL),(17948,855,28,14.898,NULL,NULL,NULL,NULL),(17949,855,180,23.1633,NULL,NULL,NULL,NULL),(17950,855,500,28.5714,NULL,NULL,NULL,NULL),(17951,855,800,29.898,NULL,NULL,NULL,NULL),(17952,855,1250,33.9796,NULL,NULL,NULL,NULL),(17953,856,1,4.79592,NULL,NULL,NULL,NULL),(17954,856,7,6.12245,NULL,NULL,NULL,NULL),(17955,856,28,10.2041,NULL,NULL,NULL,NULL),(17956,856,180,14.4898,NULL,NULL,NULL,NULL),(17957,856,500,16.3265,NULL,NULL,NULL,NULL),(17958,856,800,17.6531,NULL,NULL,NULL,NULL),(17959,856,1250,19.0816,NULL,NULL,NULL,NULL),(17960,857,1,8.16327,NULL,NULL,NULL,NULL),(17961,857,7,11.5306,NULL,NULL,NULL,NULL),(17962,857,28,17.9592,NULL,NULL,NULL,NULL),(17963,857,180,28.2653,NULL,NULL,NULL,NULL),(17964,857,500,36.6327,NULL,NULL,NULL,NULL),(17965,857,800,39.4898,NULL,NULL,NULL,NULL),(17966,857,1250,43.6735,NULL,NULL,NULL,NULL),(17967,858,1,11.4286,NULL,NULL,NULL,NULL),(17968,858,7,13.8776,NULL,NULL,NULL,NULL),(17969,858,28,17.551,NULL,NULL,NULL,NULL),(17970,858,180,23.2653,NULL,NULL,NULL,NULL),(17971,858,500,27.449,NULL,NULL,NULL,NULL),(17972,858,800,28.0612,NULL,NULL,NULL,NULL),(17973,858,1250,30.3061,NULL,NULL,NULL,NULL),(17974,859,1,7.44898,NULL,NULL,NULL,NULL),(17975,859,7,11.2245,NULL,NULL,NULL,NULL),(17976,859,28,15.2041,NULL,NULL,NULL,NULL),(17977,859,180,20.8163,NULL,NULL,NULL,NULL),(17978,859,500,24.898,NULL,NULL,NULL,NULL),(17979,859,800,27.7551,NULL,NULL,NULL,NULL),(17980,859,1250,28.9796,NULL,NULL,NULL,NULL),(17981,860,1,2.85714,NULL,NULL,NULL,NULL),(17982,860,7,4.38775,NULL,NULL,NULL,NULL),(17983,860,28,5.71429,NULL,NULL,NULL,NULL),(17984,860,180,7.65306,NULL,NULL,NULL,NULL),(17985,860,500,9.28571,NULL,NULL,NULL,NULL),(17986,860,800,9.69388,NULL,NULL,NULL,NULL),(17987,860,1250,10.102,NULL,NULL,NULL,NULL),(17988,861,1,1.63265,NULL,NULL,NULL,NULL),(17989,861,7,2.65306,NULL,NULL,NULL,NULL),(17990,861,28,3.77551,NULL,NULL,NULL,NULL),(17991,861,180,6.53061,NULL,NULL,NULL,NULL),(17992,861,500,7.85714,NULL,NULL,NULL,NULL),(17993,861,800,8.57143,NULL,NULL,NULL,NULL),(17994,861,1250,8.87755,NULL,NULL,NULL,NULL),(17995,862,1,0,NULL,NULL,NULL,NULL),(17996,862,7,0,NULL,NULL,NULL,NULL),(17997,862,28,0.306122,NULL,NULL,NULL,NULL),(17998,862,180,1.63265,NULL,NULL,NULL,NULL),(17999,862,500,2.14286,NULL,NULL,NULL,NULL),(18000,862,800,2.34694,NULL,NULL,NULL,NULL),(18001,862,1250,2.2449,NULL,NULL,NULL,NULL),(18002,863,1,18.3673,NULL,NULL,NULL,NULL),(18003,863,7,30.6122,NULL,NULL,NULL,NULL),(18004,863,28,42.8571,NULL,NULL,NULL,NULL),(18005,863,180,55.102,NULL,NULL,NULL,NULL),(18006,863,500,58.4694,NULL,NULL,NULL,NULL),(18007,863,800,59.898,NULL,NULL,NULL,NULL),(18008,863,1250,62.2449,NULL,NULL,NULL,NULL),(18009,864,1,10.2041,NULL,NULL,NULL,NULL),(18010,864,7,16.3265,NULL,NULL,NULL,NULL),(18011,864,28,26.2245,NULL,NULL,NULL,NULL),(18012,864,180,37.449,NULL,NULL,NULL,NULL),(18013,864,500,42.551,NULL,NULL,NULL,NULL),(18014,864,800,43.6735,NULL,NULL,NULL,NULL),(18015,864,1250,44.1837,NULL,NULL,NULL,NULL),(18016,865,1,3.77551,NULL,NULL,NULL,NULL),(18017,865,7,7.65306,NULL,NULL,NULL,NULL),(18018,865,28,11.6327,NULL,NULL,NULL,NULL),(18019,865,180,13.5714,NULL,NULL,NULL,NULL),(18020,865,500,14.2857,NULL,NULL,NULL,NULL),(18021,865,800,14.6939,NULL,NULL,NULL,NULL),(18022,865,1250,15.3061,NULL,NULL,NULL,NULL),(18023,866,1,19.6939,NULL,NULL,NULL,NULL),(18024,866,7,26.5306,NULL,NULL,NULL,NULL),(18025,866,28,43.0612,NULL,NULL,NULL,NULL),(18026,866,180,52.1429,NULL,NULL,NULL,NULL),(18027,866,500,55.6122,NULL,NULL,NULL,NULL),(18028,866,800,56.3265,NULL,NULL,NULL,NULL),(18029,866,1250,57.9592,NULL,NULL,NULL,NULL),(18030,867,1,8.26531,NULL,NULL,NULL,NULL),(18031,867,7,14.898,NULL,NULL,NULL,NULL),(18032,867,28,23.1633,NULL,NULL,NULL,NULL),(18033,867,180,33.4694,NULL,NULL,NULL,NULL),(18034,867,500,41.2245,NULL,NULL,NULL,NULL),(18035,867,800,43.1633,NULL,NULL,NULL,NULL),(18036,867,1250,44.898,NULL,NULL,NULL,NULL),(18037,868,1,8.97959,NULL,NULL,NULL,NULL),(18038,868,7,13.5714,NULL,NULL,NULL,NULL),(18039,868,28,18.8776,NULL,NULL,NULL,NULL),(18040,868,180,24.1837,NULL,NULL,NULL,NULL),(18041,868,500,30.5102,NULL,NULL,NULL,NULL),(18042,868,800,31.0204,NULL,NULL,NULL,NULL),(18043,868,1250,32.6531,NULL,NULL,NULL,NULL),(18044,869,1,4.59184,NULL,NULL,NULL,NULL),(18045,869,7,8.36735,NULL,NULL,NULL,NULL),(18046,869,28,11.5306,NULL,NULL,NULL,NULL),(18047,869,180,21.7347,NULL,NULL,NULL,NULL),(18048,869,500,25.7143,NULL,NULL,NULL,NULL),(18049,869,800,25.5102,NULL,NULL,NULL,NULL),(18050,869,1250,24.7959,NULL,NULL,NULL,NULL),(18051,870,1,1.12245,NULL,NULL,NULL,NULL),(18052,870,7,2.04082,NULL,NULL,NULL,NULL),(18053,870,28,5.40816,NULL,NULL,NULL,NULL),(18054,870,180,9.28571,NULL,NULL,NULL,NULL),(18055,870,500,8.67347,NULL,NULL,NULL,NULL),(18056,870,800,9.18367,NULL,NULL,NULL,NULL),(18057,870,1250,9.69388,NULL,NULL,NULL,NULL),(18058,871,1,0,NULL,NULL,NULL,NULL),(18059,871,7,1.12245,NULL,NULL,NULL,NULL),(18060,871,28,1.63265,NULL,NULL,NULL,NULL),(18061,871,180,3.36735,NULL,NULL,NULL,NULL),(18062,871,500,1.93878,NULL,NULL,NULL,NULL),(18063,871,800,1.93878,NULL,NULL,NULL,NULL),(18064,871,1250,2.2449,NULL,NULL,NULL,NULL),(18065,872,1,4.69388,NULL,NULL,NULL,NULL),(18066,872,5,11.0204,NULL,NULL,NULL,NULL),(18067,872,28,18.8776,NULL,NULL,NULL,NULL),(18068,872,180,32.1429,NULL,NULL,NULL,NULL),(18069,872,500,38.4694,NULL,NULL,NULL,NULL),(18070,872,800,41.2245,NULL,NULL,NULL,NULL),(18071,872,1250,44.898,NULL,NULL,NULL,NULL),(18072,873,1,9.08163,NULL,NULL,NULL,NULL),(18073,873,5,13.2653,NULL,NULL,NULL,NULL),(18074,873,28,21.1224,NULL,NULL,NULL,NULL),(18075,873,180,31.0204,NULL,NULL,NULL,NULL),(18076,873,500,38.4694,NULL,NULL,NULL,NULL),(18077,873,800,41.2245,NULL,NULL,NULL,NULL),(18078,873,1250,43.6735,NULL,NULL,NULL,NULL),(18079,874,1,2.55102,NULL,NULL,NULL,NULL),(18080,874,5,4.89796,NULL,NULL,NULL,NULL),(18081,874,28,9.79592,NULL,NULL,NULL,NULL),(18082,874,180,19.2857,NULL,NULL,NULL,NULL),(18083,874,500,22.2449,NULL,NULL,NULL,NULL),(18084,874,800,23.3673,NULL,NULL,NULL,NULL),(18085,874,1250,28.7755,NULL,NULL,NULL,NULL),(18086,875,1,3.16327,NULL,NULL,NULL,NULL),(18087,875,5,6.02041,NULL,NULL,NULL,NULL),(18088,875,28,9.28571,NULL,NULL,NULL,NULL),(18089,875,180,16.5306,NULL,NULL,NULL,NULL),(18090,875,500,20.5102,NULL,NULL,NULL,NULL),(18091,875,800,21.7347,NULL,NULL,NULL,NULL),(18092,875,1250,25,NULL,NULL,NULL,NULL),(18093,876,1,5,NULL,NULL,NULL,NULL),(18094,876,5,8.06122,NULL,NULL,NULL,NULL),(18095,876,28,13.3673,NULL,NULL,NULL,NULL),(18096,876,180,21.4286,NULL,NULL,NULL,NULL),(18097,876,500,26.6327,NULL,NULL,NULL,NULL),(18098,876,800,28.1633,NULL,NULL,NULL,NULL),(18099,876,1250,31.5306,NULL,NULL,NULL,NULL),(18100,877,1,7.55102,NULL,NULL,NULL,NULL),(18101,877,5,10.3061,NULL,NULL,NULL,NULL),(18102,877,28,14.7959,NULL,NULL,NULL,NULL),(18103,877,180,19.2857,NULL,NULL,NULL,NULL),(18104,877,500,22.6531,NULL,NULL,NULL,NULL),(18105,877,800,24.4898,NULL,NULL,NULL,NULL),(18106,877,1250,25.8163,NULL,NULL,NULL,NULL),(18107,878,1,3.57143,NULL,NULL,NULL,NULL),(18108,878,5,5.40816,NULL,NULL,NULL,NULL),(18109,878,28,8.97959,NULL,NULL,NULL,NULL),(18110,878,200,12.0408,NULL,NULL,NULL,NULL),(18111,878,500,15,NULL,NULL,NULL,NULL),(18112,878,800,16.2245,NULL,NULL,NULL,NULL),(18113,878,1250,16.9388,NULL,NULL,NULL,NULL),(18114,879,1,3.06122,NULL,NULL,NULL,NULL),(18115,879,5,5.71429,NULL,NULL,NULL,NULL),(18116,879,28,8.67347,NULL,NULL,NULL,NULL),(18117,879,200,15.6122,NULL,NULL,NULL,NULL),(18118,879,500,21.0204,NULL,NULL,NULL,NULL),(18119,879,800,22.449,NULL,NULL,NULL,NULL),(18120,879,1250,25.5102,NULL,NULL,NULL,NULL),(18121,880,1,1.02041,NULL,NULL,NULL,NULL),(18122,880,5,4.08163,NULL,NULL,NULL,NULL),(18123,880,28,6.93878,NULL,NULL,NULL,NULL),(18124,880,200,11.5306,NULL,NULL,NULL,NULL),(18125,880,500,13.4694,NULL,NULL,NULL,NULL),(18126,880,800,14.2857,NULL,NULL,NULL,NULL),(18127,880,1250,16.3265,NULL,NULL,NULL,NULL),(18128,881,1,3.67347,NULL,NULL,NULL,NULL),(18129,881,5,5.91837,NULL,NULL,NULL,NULL),(18130,881,28,8.36735,NULL,NULL,NULL,NULL),(18131,881,200,11.8367,NULL,NULL,NULL,NULL),(18132,881,500,13.6735,NULL,NULL,NULL,NULL),(18133,881,800,13.9796,NULL,NULL,NULL,NULL),(18134,881,1250,15.102,NULL,NULL,NULL,NULL),(18135,882,5,10,NULL,NULL,NULL,NULL),(18136,882,28,21.9388,NULL,NULL,NULL,NULL),(18137,882,180,40.7143,NULL,NULL,NULL,NULL),(18138,882,500,47.7551,NULL,NULL,NULL,NULL),(18139,882,800,48.5714,NULL,NULL,NULL,NULL),(18140,882,1250,49.898,NULL,NULL,NULL,NULL),(18141,883,1,16.4286,NULL,NULL,NULL,NULL),(18142,883,5,26.6327,NULL,NULL,NULL,NULL),(18143,883,28,36.8367,NULL,NULL,NULL,NULL),(18144,883,180,46.5306,NULL,NULL,NULL,NULL),(18145,883,500,50.102,NULL,NULL,NULL,NULL),(18146,883,800,50.6122,NULL,NULL,NULL,NULL),(18147,883,1250,51.0204,NULL,NULL,NULL,NULL),(18148,884,1,12.8571,NULL,NULL,NULL,NULL),(18149,884,5,18.6735,NULL,NULL,NULL,NULL),(18150,884,28,28.2653,NULL,NULL,NULL,NULL),(18151,884,180,41.8367,NULL,NULL,NULL,NULL),(18152,884,500,50.9184,NULL,NULL,NULL,NULL),(18153,884,800,50.2041,NULL,NULL,NULL,NULL),(18154,884,1250,50.4082,NULL,NULL,NULL,NULL),(18155,885,1,10.3061,NULL,NULL,NULL,NULL),(18156,885,5,15.3061,NULL,NULL,NULL,NULL),(18157,885,28,21.7347,NULL,NULL,NULL,NULL),(18158,885,180,35.8163,NULL,NULL,NULL,NULL),(18159,885,500,44.1837,NULL,NULL,NULL,NULL),(18160,885,800,45.2041,NULL,NULL,NULL,NULL),(18161,885,1250,47.1429,NULL,NULL,NULL,NULL),(18162,886,1,14.1837,NULL,NULL,NULL,NULL),(18163,886,5,19.4898,NULL,NULL,NULL,NULL),(18164,886,28,27.0408,NULL,NULL,NULL,NULL),(18165,886,180,36.2245,NULL,NULL,NULL,NULL),(18166,886,500,40.2041,NULL,NULL,NULL,NULL),(18167,886,800,41.0204,NULL,NULL,NULL,NULL),(18168,886,1250,44.0816,NULL,NULL,NULL,NULL),(18169,887,1,15.8163,NULL,NULL,NULL,NULL),(18170,887,5,20.9184,NULL,NULL,NULL,NULL),(18171,887,28,29.2857,NULL,NULL,NULL,NULL),(18172,887,180,34.898,NULL,NULL,NULL,NULL),(18173,887,500,38.3673,NULL,NULL,NULL,NULL),(18174,887,800,40.5102,NULL,NULL,NULL,NULL),(18175,887,1250,43.2653,NULL,NULL,NULL,NULL),(18176,888,1,2.95918,NULL,NULL,NULL,NULL),(18177,888,5,6.83673,NULL,NULL,NULL,NULL),(18178,888,28,10.102,NULL,NULL,NULL,NULL),(18179,888,200,10.8163,NULL,NULL,NULL,NULL),(18180,888,500,11.4286,NULL,NULL,NULL,NULL),(18181,888,800,11.4286,NULL,NULL,NULL,NULL),(18182,888,1250,11.3265,NULL,NULL,NULL,NULL),(18183,889,1,3.16327,NULL,NULL,NULL,NULL),(18184,889,5,4.69388,NULL,NULL,NULL,NULL),(18185,889,28,7.55102,NULL,NULL,NULL,NULL),(18186,889,200,8.36735,NULL,NULL,NULL,NULL),(18187,889,500,8.97959,NULL,NULL,NULL,NULL),(18188,889,1250,8.16327,NULL,NULL,NULL,NULL),(18189,890,1,2.65306,NULL,NULL,NULL,NULL),(18190,890,5,5.20408,NULL,NULL,NULL,NULL),(18191,890,28,6.73469,NULL,NULL,NULL,NULL),(18192,890,200,13.0612,NULL,NULL,NULL,NULL),(18193,890,500,15.3061,NULL,NULL,NULL,NULL),(18194,890,800,15,NULL,NULL,NULL,NULL),(18195,890,1250,13.8776,NULL,NULL,NULL,NULL),(18196,891,1,6.12245,NULL,NULL,NULL,NULL),(18197,891,5,9.59184,NULL,NULL,NULL,NULL),(18198,891,28,12.551,NULL,NULL,NULL,NULL),(18199,891,200,14.2857,NULL,NULL,NULL,NULL),(18200,891,500,16.2245,NULL,NULL,NULL,NULL),(18201,891,800,16.5306,NULL,NULL,NULL,NULL),(18202,891,1250,17.1429,NULL,NULL,NULL,NULL),(18203,892,0.04,70.4082,NULL,NULL,NULL,NULL),(18204,892,0.05,75.5102,NULL,NULL,NULL,NULL),(18205,892,0.1,77.551,NULL,NULL,NULL,NULL),(18206,892,0.2,79.5918,NULL,NULL,NULL,NULL),(18207,892,0.4,81.6327,NULL,NULL,NULL,NULL),(18208,892,1,90.8163,NULL,NULL,NULL,NULL),(18209,892,2,95.9184,NULL,NULL,NULL,NULL),(18210,892,3.1,101.02,NULL,NULL,NULL,NULL),(18211,892,4.1,105.102,NULL,NULL,NULL,NULL),(18212,892,5.2,107.143,NULL,NULL,NULL,NULL),(18213,892,6.2,107.143,NULL,NULL,NULL,NULL),(18214,892,7.2,109.184,NULL,NULL,NULL,NULL),(18215,892,8.3,113.265,NULL,NULL,NULL,NULL),(18216,892,10.2,114.286,NULL,NULL,NULL,NULL),(18217,892,12.2,114.286,NULL,NULL,NULL,NULL),(18218,892,14.4,118.367,NULL,NULL,NULL,NULL),(18219,892,17.3,118.367,NULL,NULL,NULL,NULL),(18220,892,19.5,122.449,NULL,NULL,NULL,NULL),(18221,892,21.5,125.51,NULL,NULL,NULL,NULL),(18222,892,24.9,123.469,NULL,NULL,NULL,NULL),(18223,892,26.8,128.571,NULL,NULL,NULL,NULL),(18224,892,29.2,129.592,NULL,NULL,NULL,NULL),(18225,892,31.8,133.673,NULL,NULL,NULL,NULL),(18226,892,36.7,132.653,NULL,NULL,NULL,NULL),(18227,892,41.6,135.714,NULL,NULL,NULL,NULL),(18228,892,49,135.714,NULL,NULL,NULL,NULL),(18229,892,56,137.755,NULL,NULL,NULL,NULL),(18230,892,63.5,137.755,NULL,NULL,NULL,NULL),(18231,892,70.5,137.755,NULL,NULL,NULL,NULL),(18232,892,78.2,138.776,NULL,NULL,NULL,NULL),(18233,892,85.5,140.816,NULL,NULL,NULL,NULL),(18234,892,100.4,142.857,NULL,NULL,NULL,NULL),(18235,892,116.8,142.857,NULL,NULL,NULL,NULL),(18236,892,131.5,144.898,NULL,NULL,NULL,NULL),(18237,892,146.5,144.898,NULL,NULL,NULL,NULL),(18238,892,159.6,146.939,NULL,NULL,NULL,NULL),(18239,892,172,148.98,NULL,NULL,NULL,NULL),(18240,893,0.04,56.1224,NULL,NULL,NULL,NULL),(18241,893,0.07,64.2857,NULL,NULL,NULL,NULL),(18242,893,0.1,66.3265,NULL,NULL,NULL,NULL),(18243,893,0.2,68.3673,NULL,NULL,NULL,NULL),(18244,893,0.4,70.4082,NULL,NULL,NULL,NULL),(18245,893,1,76.5306,NULL,NULL,NULL,NULL),(18246,893,2.1,79.5918,NULL,NULL,NULL,NULL),(18247,893,3.1,82.6531,NULL,NULL,NULL,NULL),(18248,893,4.2,86.7347,NULL,NULL,NULL,NULL),(18249,893,5.2,89.7959,NULL,NULL,NULL,NULL),(18250,893,6.2,93.8775,NULL,NULL,NULL,NULL),(18251,893,7.3,92.8571,NULL,NULL,NULL,NULL),(18252,893,8.3,93.8775,NULL,NULL,NULL,NULL),(18253,893,10.3,96.9388,NULL,NULL,NULL,NULL),(18254,893,13.3,98.9796,NULL,NULL,NULL,NULL),(18255,893,15.5,100,NULL,NULL,NULL,NULL),(18256,893,17.5,102.041,NULL,NULL,NULL,NULL),(18257,893,20.5,105.102,NULL,NULL,NULL,NULL),(18258,893,22.5,106.122,NULL,NULL,NULL,NULL),(18259,893,25.1,107.143,NULL,NULL,NULL,NULL),(18260,893,28,108.163,NULL,NULL,NULL,NULL),(18261,893,31.9,110.204,NULL,NULL,NULL,NULL),(18262,893,34.8,112.245,NULL,NULL,NULL,NULL),(18263,893,39,112.245,NULL,NULL,NULL,NULL),(18264,893,44.1,114.286,NULL,NULL,NULL,NULL),(18265,893,51.2,115.306,NULL,NULL,NULL,NULL),(18266,893,59,118.367,NULL,NULL,NULL,NULL),(18267,893,65.8,119.388,NULL,NULL,NULL,NULL),(18268,893,75.1,119.388,NULL,NULL,NULL,NULL),(18269,893,80.5,121.429,NULL,NULL,NULL,NULL),(18270,893,96.2,121.429,NULL,NULL,NULL,NULL),(18271,893,111,126.531,NULL,NULL,NULL,NULL),(18272,893,127.8,127.551,NULL,NULL,NULL,NULL),(18273,893,142.3,129.592,NULL,NULL,NULL,NULL),(18274,893,156.8,129.592,NULL,NULL,NULL,NULL),(18275,893,169.6,130.612,NULL,NULL,NULL,NULL),(18276,894,0.1,47.9592,NULL,NULL,NULL,NULL),(18277,894,0.15,48.9796,NULL,NULL,NULL,NULL),(18278,894,0.25,50,NULL,NULL,NULL,NULL),(18279,894,0.45,52.0408,NULL,NULL,NULL,NULL),(18280,894,1.05,54.0816,NULL,NULL,NULL,NULL),(18281,894,2.05,59.1837,NULL,NULL,NULL,NULL),(18282,894,3.15,59.1837,NULL,NULL,NULL,NULL),(18283,894,4.15,61.2245,NULL,NULL,NULL,NULL),(18284,894,5.15,63.2653,NULL,NULL,NULL,NULL),(18285,894,6.15,63.2653,NULL,NULL,NULL,NULL),(18286,894,7.25,64.2857,NULL,NULL,NULL,NULL),(18287,894,8.25,66.3265,NULL,NULL,NULL,NULL),(18288,894,10.15,67.3469,NULL,NULL,NULL,NULL),(18289,894,13.25,69.3878,NULL,NULL,NULL,NULL),(18290,894,15.35,70.4082,NULL,NULL,NULL,NULL),(18291,894,17.15,71.4286,NULL,NULL,NULL,NULL),(18292,894,20.15,72.449,NULL,NULL,NULL,NULL),(18293,894,22.35,73.4694,NULL,NULL,NULL,NULL),(18294,894,24.65,75.5102,NULL,NULL,NULL,NULL),(18295,894,27.45,76.5306,NULL,NULL,NULL,NULL),(18296,894,31.45,76.5306,NULL,NULL,NULL,NULL),(18297,894,34.85,77.551,NULL,NULL,NULL,NULL),(18298,894,38.95,78.5714,NULL,NULL,NULL,NULL),(18299,894,43.85,80.6122,NULL,NULL,NULL,NULL),(18300,894,50.65,81.6327,NULL,NULL,NULL,NULL),(18301,894,58.55,82.6531,NULL,NULL,NULL,NULL),(18302,894,64.95,84.6939,NULL,NULL,NULL,NULL),(18303,894,71.25,85.7143,NULL,NULL,NULL,NULL),(18304,894,79.95,87.7551,NULL,NULL,NULL,NULL),(18305,894,95.95,89.7959,NULL,NULL,NULL,NULL),(18306,894,108.35,91.8367,NULL,NULL,NULL,NULL),(18307,894,126.95,92.8571,NULL,NULL,NULL,NULL),(18308,894,139.25,92.8571,NULL,NULL,NULL,NULL),(18309,894,152.95,93.8775,NULL,NULL,NULL,NULL),(18310,894,168.45,95.9184,NULL,NULL,NULL,NULL),(18311,895,0.07,44.898,NULL,NULL,NULL,NULL),(18312,895,0.2,46.9388,NULL,NULL,NULL,NULL),(18313,895,0.3,46.9388,NULL,NULL,NULL,NULL),(18314,895,1,53.0612,NULL,NULL,NULL,NULL),(18315,895,2,56.1224,NULL,NULL,NULL,NULL),(18316,895,6.9,63.2653,NULL,NULL,NULL,NULL),(18317,895,7.2,61.2245,NULL,NULL,NULL,NULL),(18318,895,8,62.2449,NULL,NULL,NULL,NULL),(18319,895,9,61.2245,NULL,NULL,NULL,NULL),(18320,895,10,59.1837,NULL,NULL,NULL,NULL),(18321,895,13,61.2245,NULL,NULL,NULL,NULL),(18322,895,14.8,65.3061,NULL,NULL,NULL,NULL),(18323,895,17,65.3061,NULL,NULL,NULL,NULL),(18324,895,19.9,66.3265,NULL,NULL,NULL,NULL),(18325,895,27.1,67.3469,NULL,NULL,NULL,NULL),(18326,895,34.4,69.3878,NULL,NULL,NULL,NULL),(18327,895,40.3,72.449,NULL,NULL,NULL,NULL),(18328,895,41.6,73.4694,NULL,NULL,NULL,NULL),(18329,895,47.6,74.4898,NULL,NULL,NULL,NULL),(18330,895,54.8,81.6327,NULL,NULL,NULL,NULL),(18331,895,61.8,80.6122,NULL,NULL,NULL,NULL),(18332,895,76.7,81.6327,NULL,NULL,NULL,NULL),(18333,895,82.4,84.6939,NULL,NULL,NULL,NULL),(18334,895,88.6,83.6735,NULL,NULL,NULL,NULL),(18335,895,95.2,84.6939,NULL,NULL,NULL,NULL),(18336,896,0.1,41.6327,NULL,NULL,NULL,NULL),(18337,896,1,43.2653,NULL,NULL,NULL,NULL),(18338,896,1.2,42.7551,NULL,NULL,NULL,NULL),(18339,896,2,45.4082,NULL,NULL,NULL,NULL),(18340,896,3,44.3878,NULL,NULL,NULL,NULL),(18341,896,4.3,45.6122,NULL,NULL,NULL,NULL),(18342,896,5,46.5306,NULL,NULL,NULL,NULL),(18343,896,5.9,50.7143,NULL,NULL,NULL,NULL),(18344,896,6.9,49.2857,NULL,NULL,NULL,NULL),(18345,896,7.9,51.2245,NULL,NULL,NULL,NULL),(18346,896,8.9,56.0204,NULL,NULL,NULL,NULL),(18347,896,9.8,53.6735,NULL,NULL,NULL,NULL),(18348,896,12.8,59.3878,NULL,NULL,NULL,NULL),(18349,896,13.7,54.898,NULL,NULL,NULL,NULL),(18350,896,15.9,56.3265,NULL,NULL,NULL,NULL),(18351,896,16.9,56.2245,NULL,NULL,NULL,NULL),(18352,896,22.8,59.3878,NULL,NULL,NULL,NULL),(18353,896,26.5,60.7143,NULL,NULL,NULL,NULL),(18354,896,27.6,58.2653,NULL,NULL,NULL,NULL),(18355,896,29.6,57.7551,NULL,NULL,NULL,NULL),(18356,896,30.8,61.0204,NULL,NULL,NULL,NULL),(18357,896,35,63.3673,NULL,NULL,NULL,NULL),(18358,896,40.4,63.2653,NULL,NULL,NULL,NULL),(18359,896,47.2,61.2245,NULL,NULL,NULL,NULL),(18360,896,54.8,64.5918,NULL,NULL,NULL,NULL),(18361,896,61.6,63.6735,NULL,NULL,NULL,NULL),(18362,896,68,62.2449,NULL,NULL,NULL,NULL),(18363,896,75.6,63.7755,NULL,NULL,NULL,NULL),(18364,896,83,65,NULL,NULL,NULL,NULL),(18365,896,88.2,66.1225,NULL,NULL,NULL,NULL),(18366,896,94.8,66.0204,NULL,NULL,NULL,NULL),(18367,897,0.03,58.4694,NULL,NULL,NULL,NULL),(18368,897,0.2,68.6735,NULL,NULL,NULL,NULL),(18369,897,0.3,72.8571,NULL,NULL,NULL,NULL),(18370,897,1,80.6122,NULL,NULL,NULL,NULL),(18371,897,2,88.0612,NULL,NULL,NULL,NULL),(18372,897,3.1,93.3673,NULL,NULL,NULL,NULL),(18373,897,4.1,96.0204,NULL,NULL,NULL,NULL),(18374,897,5.1,98.4694,NULL,NULL,NULL,NULL),(18375,897,6.1,100.816,NULL,NULL,NULL,NULL),(18376,897,7.2,103.673,NULL,NULL,NULL,NULL),(18377,897,8.2,103.469,NULL,NULL,NULL,NULL),(18378,897,11.2,106.224,NULL,NULL,NULL,NULL),(18379,897,13.2,110.204,NULL,NULL,NULL,NULL),(18380,897,15.4,111.224,NULL,NULL,NULL,NULL),(18381,897,18.4,113.265,NULL,NULL,NULL,NULL),(18382,897,20.4,113.571,NULL,NULL,NULL,NULL),(18383,897,22.3,113.571,NULL,NULL,NULL,NULL),(18384,897,25.7,113.673,NULL,NULL,NULL,NULL),(18385,897,27.5,120.612,NULL,NULL,NULL,NULL),(18386,897,29.6,118.98,NULL,NULL,NULL,NULL),(18387,897,32.6,120.204,NULL,NULL,NULL,NULL),(18388,897,36.3,122.653,NULL,NULL,NULL,NULL),(18389,897,41.6,122.653,NULL,NULL,NULL,NULL),(18390,897,48.5,125.204,NULL,NULL,NULL,NULL),(18391,897,55.7,125.204,NULL,NULL,NULL,NULL),(18392,897,62.4,129.388,NULL,NULL,NULL,NULL),(18393,897,70.2,127.755,NULL,NULL,NULL,NULL),(18394,897,76.4,130.204,NULL,NULL,NULL,NULL),(18395,897,83.5,133.265,NULL,NULL,NULL,NULL),(18396,897,97.6,138.571,NULL,NULL,NULL,NULL),(18397,897,115,141.02,NULL,NULL,NULL,NULL),(18398,897,127,142.143,NULL,NULL,NULL,NULL),(18399,897,141,145,NULL,NULL,NULL,NULL),(18400,897,151,143.367,NULL,NULL,NULL,NULL),(18401,897,170,146.02,NULL,NULL,NULL,NULL),(18402,898,0.03,57.5469,NULL,NULL,NULL,NULL),(18403,898,0.06,59.2816,NULL,NULL,NULL,NULL),(18404,898,0.07,61.9347,NULL,NULL,NULL,NULL),(18405,898,0.21,67.4449,NULL,NULL,NULL,NULL),(18406,898,0.31,68.2612,NULL,NULL,NULL,NULL),(18407,898,1.01,75.5061,NULL,NULL,NULL,NULL),(18408,898,2.11,78.9755,NULL,NULL,NULL,NULL),(18409,898,3.11,83.0571,NULL,NULL,NULL,NULL),(18410,898,4.21,85.4041,NULL,NULL,NULL,NULL),(18411,898,5.21,88.2612,NULL,NULL,NULL,NULL),(18412,898,6.31,90.098,NULL,NULL,NULL,NULL),(18413,898,7.21,91.3224,NULL,NULL,NULL,NULL),(18414,898,9.11,93.4653,NULL,NULL,NULL,NULL),(18415,898,11.21,97.4449,NULL,NULL,NULL,NULL),(18416,898,14.31,99.3837,NULL,NULL,NULL,NULL),(18417,898,16.71,100.914,NULL,NULL,NULL,NULL),(18418,898,18.71,102.037,NULL,NULL,NULL,NULL),(18419,898,21.61,104.792,NULL,NULL,NULL,NULL),(18420,898,23.61,106.118,NULL,NULL,NULL,NULL),(18421,898,29.01,109.18,NULL,NULL,NULL,NULL),(18422,898,38.01,110.098,NULL,NULL,NULL,NULL),(18423,898,45.21,112.547,NULL,NULL,NULL,NULL),(18424,898,51.51,114.996,NULL,NULL,NULL,NULL),(18425,898,59.81,116.424,NULL,NULL,NULL,NULL),(18426,898,65.41,118.159,NULL,NULL,NULL,NULL),(18427,898,73.31,119.486,NULL,NULL,NULL,NULL),(18428,898,80.61,121.22,NULL,NULL,NULL,NULL),(18429,898,92.91,123.976,NULL,NULL,NULL,NULL),(18430,898,109.81,127.853,NULL,NULL,NULL,NULL),(18431,898,120.91,129.486,NULL,NULL,NULL,NULL),(18432,898,140.31,130.098,NULL,NULL,NULL,NULL),(18433,898,151.61,132.139,NULL,NULL,NULL,NULL),(18434,898,169.41,132.955,NULL,NULL,NULL,NULL),(18435,898,185.11,135.098,NULL,NULL,NULL,NULL),(18436,899,0.15,50.8163,NULL,NULL,NULL,NULL),(18437,899,0.19,51.8367,NULL,NULL,NULL,NULL),(18438,899,0.32,52.6531,NULL,NULL,NULL,NULL),(18439,899,0.42,55.4082,NULL,NULL,NULL,NULL),(18440,899,1.12,58.8776,NULL,NULL,NULL,NULL),(18441,899,2.12,61.6327,NULL,NULL,NULL,NULL),(18442,899,3.22,64.5918,NULL,NULL,NULL,NULL),(18443,899,4.22,66.2245,NULL,NULL,NULL,NULL),(18444,899,5.22,67.7551,NULL,NULL,NULL,NULL),(18445,899,6.22,69.4898,NULL,NULL,NULL,NULL),(18446,899,7.22,71.3265,NULL,NULL,NULL,NULL),(18447,899,9.12,72.0408,NULL,NULL,NULL,NULL),(18448,899,11.22,73.3673,NULL,NULL,NULL,NULL),(18449,899,14.32,74.4898,NULL,NULL,NULL,NULL),(18450,899,16.12,76.1225,NULL,NULL,NULL,NULL),(18451,899,18.32,76.8367,NULL,NULL,NULL,NULL),(18452,899,21.42,78.0612,NULL,NULL,NULL,NULL),(18453,899,23.62,78.3673,NULL,NULL,NULL,NULL),(18454,899,25.32,79.4898,NULL,NULL,NULL,NULL),(18455,899,28.52,79.4898,NULL,NULL,NULL,NULL),(18456,899,32.42,81.3265,NULL,NULL,NULL,NULL),(18457,899,37.32,82.449,NULL,NULL,NULL,NULL),(18458,899,44.42,84.2857,NULL,NULL,NULL,NULL),(18459,899,50.92,86.9388,NULL,NULL,NULL,NULL),(18460,899,58.02,86.6327,NULL,NULL,NULL,NULL),(18461,899,65.52,88.5714,NULL,NULL,NULL,NULL),(18462,899,72.82,89.5918,NULL,NULL,NULL,NULL),(18463,899,79.32,92.2449,NULL,NULL,NULL,NULL),(18464,899,94.32,95,NULL,NULL,NULL,NULL),(18465,899,108.32,97.8571,NULL,NULL,NULL,NULL),(18466,899,122.42,98.9796,NULL,NULL,NULL,NULL),(18467,899,136.82,98.8775,NULL,NULL,NULL,NULL),(18468,899,151.12,100.102,NULL,NULL,NULL,NULL),(18469,899,166.42,101.429,NULL,NULL,NULL,NULL),(18470,900,0.2,64.4898,NULL,NULL,NULL,NULL),(18471,900,0.3,67.449,NULL,NULL,NULL,NULL),(18472,900,1,75.3061,NULL,NULL,NULL,NULL),(18473,900,2,80.4082,NULL,NULL,NULL,NULL),(18474,900,3.1,84.6939,NULL,NULL,NULL,NULL),(18475,900,4.1,88.4694,NULL,NULL,NULL,NULL),(18476,900,5.1,89.898,NULL,NULL,NULL,NULL),(18477,900,6.1,92.449,NULL,NULL,NULL,NULL),(18478,900,7.1,94.0816,NULL,NULL,NULL,NULL),(18479,900,9.1,96.8367,NULL,NULL,NULL,NULL),(18480,900,11.1,98.5714,NULL,NULL,NULL,NULL),(18481,900,14.4,101.02,NULL,NULL,NULL,NULL),(18482,900,16.3,102.245,NULL,NULL,NULL,NULL),(18483,900,18.4,103.265,NULL,NULL,NULL,NULL),(18484,900,25.5,107.041,NULL,NULL,NULL,NULL),(18485,900,28.7,107.857,NULL,NULL,NULL,NULL),(18486,900,32.5,108.878,NULL,NULL,NULL,NULL),(18487,900,51.1,115.612,NULL,NULL,NULL,NULL),(18488,900,58.3,115.102,NULL,NULL,NULL,NULL),(18489,900,65.1,117.347,NULL,NULL,NULL,NULL),(18490,900,72,118.265,NULL,NULL,NULL,NULL),(18491,900,78.9,119.388,NULL,NULL,NULL,NULL),(18492,900,92.6,121.531,NULL,NULL,NULL,NULL),(18493,900,109,125.51,NULL,NULL,NULL,NULL),(18494,900,120.5,125.204,NULL,NULL,NULL,NULL),(18495,900,138.2,125.918,NULL,NULL,NULL,NULL),(18496,900,150.5,127.653,NULL,NULL,NULL,NULL),(18497,900,163.8,128.878,NULL,NULL,NULL,NULL),(18498,900,177,129.49,NULL,NULL,NULL,NULL),(18499,901,0.02,64.2857,NULL,NULL,NULL,NULL),(18500,901,0.03,69.7959,NULL,NULL,NULL,NULL),(18501,901,0.07,73.7755,NULL,NULL,NULL,NULL),(18502,901,0.2,77.9592,NULL,NULL,NULL,NULL),(18503,901,0.3,83.3673,NULL,NULL,NULL,NULL),(18504,901,1,91.5306,NULL,NULL,NULL,NULL),(18505,901,2,99.1837,NULL,NULL,NULL,NULL),(18506,901,3,106.224,NULL,NULL,NULL,NULL),(18507,901,3.9,113.265,NULL,NULL,NULL,NULL),(18508,901,4.9,120,NULL,NULL,NULL,NULL),(18509,901,5.9,122.959,NULL,NULL,NULL,NULL),(18510,901,7,127.755,NULL,NULL,NULL,NULL),(18511,901,7.9,131.633,NULL,NULL,NULL,NULL),(18512,901,9.9,138.265,NULL,NULL,NULL,NULL),(18513,901,11.7,142.959,NULL,NULL,NULL,NULL),(18514,901,13.9,147.245,NULL,NULL,NULL,NULL),(18515,901,16.9,156.837,NULL,NULL,NULL,NULL),(18516,901,19,155.612,NULL,NULL,NULL,NULL),(18517,901,20.7,158.673,NULL,NULL,NULL,NULL),(18518,901,23.7,162.551,NULL,NULL,NULL,NULL),(18519,901,25.4,164.184,NULL,NULL,NULL,NULL),(18520,901,27.4,165.204,NULL,NULL,NULL,NULL),(18521,901,30.6,168.061,NULL,NULL,NULL,NULL),(18522,901,34.2,171.939,NULL,NULL,NULL,NULL),(18523,901,39.8,173.98,NULL,NULL,NULL,NULL),(18524,901,46.8,179.082,NULL,NULL,NULL,NULL),(18525,901,53,181.939,NULL,NULL,NULL,NULL),(18526,901,58.7,183.776,NULL,NULL,NULL,NULL),(18527,901,65.9,187.959,NULL,NULL,NULL,NULL),(18528,901,73.2,190.204,NULL,NULL,NULL,NULL),(18529,901,81.2,190.306,NULL,NULL,NULL,NULL),(18530,901,95.7,192.449,NULL,NULL,NULL,NULL),(18531,901,109.6,197.143,NULL,NULL,NULL,NULL),(18532,901,123.2,197.959,NULL,NULL,NULL,NULL),(18533,901,134.4,199.898,NULL,NULL,NULL,NULL),(18534,901,148.8,202.449,NULL,NULL,NULL,NULL),(18535,901,160,203.776,NULL,NULL,NULL,NULL),(18536,902,0.14,50.6061,NULL,NULL,NULL,NULL),(18537,902,0.2,53.1571,NULL,NULL,NULL,NULL),(18538,902,0.32,60.5041,NULL,NULL,NULL,NULL),(18539,902,0.42,62.4429,NULL,NULL,NULL,NULL),(18540,902,1.12,70.9122,NULL,NULL,NULL,NULL),(18541,902,2.12,76.2184,NULL,NULL,NULL,NULL),(18542,902,3.12,79.8918,NULL,NULL,NULL,NULL),(18543,902,4.02,83.8714,NULL,NULL,NULL,NULL),(18544,902,5.12,86.3204,NULL,NULL,NULL,NULL),(18545,902,6.12,88.2592,NULL,NULL,NULL,NULL),(18546,902,7.12,90.7082,NULL,NULL,NULL,NULL),(18547,902,8.12,89.8918,NULL,NULL,NULL,NULL),(18548,902,10.02,92.4429,NULL,NULL,NULL,NULL),(18549,902,13.02,95.3,NULL,NULL,NULL,NULL),(18550,902,15.12,98.0551,NULL,NULL,NULL,NULL),(18551,902,17.02,98.7694,NULL,NULL,NULL,NULL),(18552,902,19.82,100.402,NULL,NULL,NULL,NULL),(18553,902,22.02,100.3,NULL,NULL,NULL,NULL),(18554,902,23.82,102.443,NULL,NULL,NULL,NULL),(18555,902,27.02,102.953,NULL,NULL,NULL,NULL),(18556,902,30.72,103.871,NULL,NULL,NULL,NULL),(18557,902,33.72,105.606,NULL,NULL,NULL,NULL),(18558,902,37.62,106.218,NULL,NULL,NULL,NULL),(18559,902,42.82,107.341,NULL,NULL,NULL,NULL),(18560,902,48.92,109.892,NULL,NULL,NULL,NULL),(18561,902,56.22,111.014,NULL,NULL,NULL,NULL),(18562,902,63.12,112.545,NULL,NULL,NULL,NULL),(18563,902,69.82,114.178,NULL,NULL,NULL,NULL),(18564,902,77.82,114.484,NULL,NULL,NULL,NULL),(18565,902,90.62,118.259,NULL,NULL,NULL,NULL),(18566,902,107.02,120.3,NULL,NULL,NULL,NULL),(18567,902,121.92,121.32,NULL,NULL,NULL,NULL),(18568,902,133.02,122.443,NULL,NULL,NULL,NULL),(18569,902,145.72,122.035,NULL,NULL,NULL,NULL),(18570,902,158.92,123.463,NULL,NULL,NULL,NULL),(18571,903,0.01,44.5939,NULL,NULL,NULL,NULL),(18572,903,0.02,46.0224,NULL,NULL,NULL,NULL),(18573,903,0.06,47.9612,NULL,NULL,NULL,NULL),(18574,903,0.26,50.2061,NULL,NULL,NULL,NULL),(18575,903,0.96,54.2878,NULL,NULL,NULL,NULL),(18576,903,1.96,57.8592,NULL,NULL,NULL,NULL),(18577,903,2.96,59.9,NULL,NULL,NULL,NULL),(18578,903,3.96,62.2469,NULL,NULL,NULL,NULL),(18579,903,4.86,63.9816,NULL,NULL,NULL,NULL),(18580,903,6.06,65.7163,NULL,NULL,NULL,NULL),(18581,903,6.96,66.0224,NULL,NULL,NULL,NULL),(18582,903,7.96,67.1449,NULL,NULL,NULL,NULL),(18583,903,9.96,68.2673,NULL,NULL,NULL,NULL),(18584,903,12.76,70.1041,NULL,NULL,NULL,NULL),(18585,903,14.76,71.6347,NULL,NULL,NULL,NULL),(18586,903,16.86,72.6551,NULL,NULL,NULL,NULL),(18587,903,19.76,73.8796,NULL,NULL,NULL,NULL),(18588,903,21.86,75.5122,NULL,NULL,NULL,NULL),(18589,903,23.66,75.3082,NULL,NULL,NULL,NULL),(18590,903,26.86,76.9408,NULL,NULL,NULL,NULL),(18591,903,30.66,78.9816,NULL,NULL,NULL,NULL),(18592,903,33.56,79.6959,NULL,NULL,NULL,NULL),(18593,903,37.96,81.3286,NULL,NULL,NULL,NULL),(18594,903,42.56,82.9612,NULL,NULL,NULL,NULL),(18595,903,48.96,83.9816,NULL,NULL,NULL,NULL),(18596,903,56.66,85.002,NULL,NULL,NULL,NULL),(18597,903,63.66,86.5327,NULL,NULL,NULL,NULL),(18598,903,69.16,88.1653,NULL,NULL,NULL,NULL),(18599,903,78.56,89.4918,NULL,NULL,NULL,NULL),(18600,903,89.86,91.3286,NULL,NULL,NULL,NULL),(18601,903,104.16,92.349,NULL,NULL,NULL,NULL),(18602,903,120.86,93.6755,NULL,NULL,NULL,NULL),(18603,903,132.96,94.2878,NULL,NULL,NULL,NULL),(18604,903,146.06,95.5122,NULL,NULL,NULL,NULL),(18605,903,158.16,95.5122,NULL,NULL,NULL,NULL),(18606,903,171.96,96.2265,NULL,NULL,NULL,NULL),(18607,904,0.05,51.5306,NULL,NULL,NULL,NULL),(18608,904,0.1,57.6531,NULL,NULL,NULL,NULL),(18609,904,1,68.9796,NULL,NULL,NULL,NULL),(18610,904,2,74.4898,NULL,NULL,NULL,NULL),(18611,904,2.9,78.0612,NULL,NULL,NULL,NULL),(18612,904,3.9,79.6939,NULL,NULL,NULL,NULL),(18613,904,4.9,79.6939,NULL,NULL,NULL,NULL),(18614,904,5.9,83.7755,NULL,NULL,NULL,NULL),(18615,904,6.9,85,NULL,NULL,NULL,NULL),(18616,904,7.8,86.3265,NULL,NULL,NULL,NULL),(18617,904,9.7,89.2857,NULL,NULL,NULL,NULL),(18618,904,12.5,91.4286,NULL,NULL,NULL,NULL),(18619,904,14.7,93.3673,NULL,NULL,NULL,NULL),(18620,904,16.5,94.6939,NULL,NULL,NULL,NULL),(18621,904,19.5,95.4082,NULL,NULL,NULL,NULL),(18622,904,21.4,95.6122,NULL,NULL,NULL,NULL),(18623,904,23.4,97.2449,NULL,NULL,NULL,NULL),(18624,904,26.3,97.551,NULL,NULL,NULL,NULL),(18625,904,30.1,98.7755,NULL,NULL,NULL,NULL),(18626,904,32.8,99.6939,NULL,NULL,NULL,NULL),(18627,904,37.7,100.918,NULL,NULL,NULL,NULL),(18628,904,41.7,102.245,NULL,NULL,NULL,NULL),(18629,904,47.7,102.551,NULL,NULL,NULL,NULL),(18630,904,55.7,104.082,NULL,NULL,NULL,NULL),(18631,904,62.1,105.408,NULL,NULL,NULL,NULL),(18632,904,67.2,106.633,NULL,NULL,NULL,NULL),(18633,904,75.4,106.531,NULL,NULL,NULL,NULL),(18634,904,88.9,109.082,NULL,NULL,NULL,NULL),(18635,904,103.1,110.102,NULL,NULL,NULL,NULL),(18636,904,118.8,110.816,NULL,NULL,NULL,NULL),(18637,904,131.5,112.755,NULL,NULL,NULL,NULL),(18638,904,144,112.755,NULL,NULL,NULL,NULL),(18639,904,157.7,113.265,NULL,NULL,NULL,NULL),(18640,905,0.04,77.1429,NULL,NULL,NULL,NULL),(18641,905,0.1,86.4286,NULL,NULL,NULL,NULL),(18642,905,0.4,93.3673,NULL,NULL,NULL,NULL),(18643,905,1,101.429,NULL,NULL,NULL,NULL),(18644,905,2,107.449,NULL,NULL,NULL,NULL),(18645,905,3,115.102,NULL,NULL,NULL,NULL),(18646,905,3.9,117.245,NULL,NULL,NULL,NULL),(18647,905,5,118.878,NULL,NULL,NULL,NULL),(18648,905,6,120.408,NULL,NULL,NULL,NULL),(18649,905,8,120.816,NULL,NULL,NULL,NULL),(18650,905,9.9,122.653,NULL,NULL,NULL,NULL),(18651,905,12.8,124.592,NULL,NULL,NULL,NULL),(18652,905,17,126.02,NULL,NULL,NULL,NULL),(18653,905,20.1,125.612,NULL,NULL,NULL,NULL),(18654,905,24.1,125.408,NULL,NULL,NULL,NULL),(18655,905,27.1,128.163,NULL,NULL,NULL,NULL),(18656,905,31,127.755,NULL,NULL,NULL,NULL),(18657,905,38.1,130.204,NULL,NULL,NULL,NULL),(18658,905,43.7,131.531,NULL,NULL,NULL,NULL),(18659,905,49.9,131.735,NULL,NULL,NULL,NULL),(18660,905,57.6,133.367,NULL,NULL,NULL,NULL),(18661,905,63.3,134.388,NULL,NULL,NULL,NULL),(18662,905,70.3,134.898,NULL,NULL,NULL,NULL),(18663,905,77.6,135.306,NULL,NULL,NULL,NULL),(18664,905,92.1,136.735,NULL,NULL,NULL,NULL),(18665,905,107.8,137.551,NULL,NULL,NULL,NULL),(18666,905,123.7,137.551,NULL,NULL,NULL,NULL),(18667,905,133.6,139.082,NULL,NULL,NULL,NULL),(18668,905,141.9,137.347,NULL,NULL,NULL,NULL),(18669,905,161.6,138.469,NULL,NULL,NULL,NULL),(18670,906,0.05,80.4082,NULL,NULL,NULL,NULL),(18671,906,0.1,89.7959,NULL,NULL,NULL,NULL),(18672,906,0.3,97.3469,NULL,NULL,NULL,NULL),(18673,906,1,108.878,NULL,NULL,NULL,NULL),(18674,906,2,122.449,NULL,NULL,NULL,NULL),(18675,906,3,131.122,NULL,NULL,NULL,NULL),(18676,906,3.9,138.878,NULL,NULL,NULL,NULL),(18677,906,5,142.041,NULL,NULL,NULL,NULL),(18678,906,6,144.49,NULL,NULL,NULL,NULL),(18679,906,7,147.857,NULL,NULL,NULL,NULL),(18680,906,8,151.224,NULL,NULL,NULL,NULL),(18681,906,9.9,154.898,NULL,NULL,NULL,NULL),(18682,906,13,162.857,NULL,NULL,NULL,NULL),(18683,906,14.8,164.49,NULL,NULL,NULL,NULL),(18684,906,17.3,165.204,NULL,NULL,NULL,NULL),(18685,906,20.1,168.367,NULL,NULL,NULL,NULL),(18686,906,22.1,170.408,NULL,NULL,NULL,NULL),(18687,906,24.4,173.163,NULL,NULL,NULL,NULL),(18688,906,27.3,175.51,NULL,NULL,NULL,NULL),(18689,906,31.4,177.959,NULL,NULL,NULL,NULL),(18690,906,33.9,178.878,NULL,NULL,NULL,NULL),(18691,906,38.3,181.122,NULL,NULL,NULL,NULL),(18692,906,43.4,184.286,NULL,NULL,NULL,NULL),(18693,906,49.5,187.143,NULL,NULL,NULL,NULL),(18694,906,57.1,189.694,NULL,NULL,NULL,NULL),(18695,906,63.8,190.51,NULL,NULL,NULL,NULL),(18696,906,70.3,192.347,NULL,NULL,NULL,NULL),(18697,906,79,194.388,NULL,NULL,NULL,NULL),(18698,906,92,199.796,NULL,NULL,NULL,NULL),(18699,906,108.5,201.224,NULL,NULL,NULL,NULL),(18700,906,121.9,202.245,NULL,NULL,NULL,NULL),(18701,906,133.6,204.49,NULL,NULL,NULL,NULL),(18702,906,145.4,204.694,NULL,NULL,NULL,NULL),(18703,906,162.2,205.918,NULL,NULL,NULL,NULL),(18704,907,0.09,33.4694,NULL,NULL,NULL,NULL),(18705,907,0.1,37.551,NULL,NULL,NULL,NULL),(18706,907,0.2,37.6531,NULL,NULL,NULL,NULL),(18707,907,1,46.7347,NULL,NULL,NULL,NULL),(18708,907,1.2,47.3469,NULL,NULL,NULL,NULL),(18709,907,2,47.8571,NULL,NULL,NULL,NULL),(18710,907,3,49.7959,NULL,NULL,NULL,NULL),(18711,907,6.8,58.3673,NULL,NULL,NULL,NULL),(18712,907,7.8,58.5714,NULL,NULL,NULL,NULL),(18713,907,8.8,61.4286,NULL,NULL,NULL,NULL),(18714,907,9.8,60.9184,NULL,NULL,NULL,NULL),(18715,907,12.6,63.5714,NULL,NULL,NULL,NULL),(18716,907,14.5,62.551,NULL,NULL,NULL,NULL),(18717,907,15.6,59.4898,NULL,NULL,NULL,NULL),(18718,907,16.8,61.5306,NULL,NULL,NULL,NULL),(18719,907,19.7,60.7143,NULL,NULL,NULL,NULL),(18720,907,22.8,62.1429,NULL,NULL,NULL,NULL),(18721,907,23.8,60.5102,NULL,NULL,NULL,NULL),(18722,907,26.7,61.3265,NULL,NULL,NULL,NULL),(18723,907,27.5,64.6939,NULL,NULL,NULL,NULL),(18724,907,28.4,70.2041,NULL,NULL,NULL,NULL),(18725,907,30.9,63.0612,NULL,NULL,NULL,NULL),(18726,907,33.4,62.551,NULL,NULL,NULL,NULL),(18727,907,34.2,66.8367,NULL,NULL,NULL,NULL),(18728,907,37,66.1225,NULL,NULL,NULL,NULL),(18729,907,40.9,69.3878,NULL,NULL,NULL,NULL),(18730,907,48,65.6122,NULL,NULL,NULL,NULL),(18731,907,54.5,66.8367,NULL,NULL,NULL,NULL),(18732,907,61.6,67.0408,NULL,NULL,NULL,NULL),(18733,907,68.3,63.8776,NULL,NULL,NULL,NULL),(18734,907,73.8,64.0816,NULL,NULL,NULL,NULL),(18735,907,81.5,68.1633,NULL,NULL,NULL,NULL),(18736,907,88.4,65.6122,NULL,NULL,NULL,NULL),(18737,907,95.4,65.6122,NULL,NULL,NULL,NULL),(18738,908,0.22,34.3796,NULL,NULL,NULL,NULL),(18739,908,0.42,34.3796,NULL,NULL,NULL,NULL),(18740,908,1.12,33.1551,NULL,NULL,NULL,NULL),(18741,908,1.32,38.1551,NULL,NULL,NULL,NULL),(18742,908,2.12,39.6857,NULL,NULL,NULL,NULL),(18743,908,3.12,41.3184,NULL,NULL,NULL,NULL),(18744,908,5.92,47.849,NULL,NULL,NULL,NULL),(18745,908,7.02,47.4408,NULL,NULL,NULL,NULL),(18746,908,8.02,52.2367,NULL,NULL,NULL,NULL),(18747,908,9.02,47.3388,NULL,NULL,NULL,NULL),(18748,908,9.92,49.8898,NULL,NULL,NULL,NULL),(18749,908,13.02,51.2163,NULL,NULL,NULL,NULL),(18750,908,13.82,49.9918,NULL,NULL,NULL,NULL),(18751,908,14.92,50.6041,NULL,NULL,NULL,NULL),(18752,908,15.72,52.6449,NULL,NULL,NULL,NULL),(18753,908,17.02,50.6041,NULL,NULL,NULL,NULL),(18754,908,20.82,52.5429,NULL,NULL,NULL,NULL),(18755,908,26.62,55.0939,NULL,NULL,NULL,NULL),(18756,908,27.62,57.1347,NULL,NULL,NULL,NULL),(18757,908,29.92,56.3184,NULL,NULL,NULL,NULL),(18758,908,32.12,54.9918,NULL,NULL,NULL,NULL),(18759,908,33.32,54.0735,NULL,NULL,NULL,NULL),(18760,908,34.62,58.2571,NULL,NULL,NULL,NULL),(18761,908,37.52,54.9918,NULL,NULL,NULL,NULL),(18762,908,40.52,57.6449,NULL,NULL,NULL,NULL),(18763,908,41.12,59.3796,NULL,NULL,NULL,NULL),(18764,908,48.42,58.0531,NULL,NULL,NULL,NULL),(18765,908,55.22,57.0327,NULL,NULL,NULL,NULL),(18766,908,62.82,57.2367,NULL,NULL,NULL,NULL),(18767,908,68.72,60.4,NULL,NULL,NULL,NULL),(18768,908,74.42,60.9102,NULL,NULL,NULL,NULL),(18769,908,79.82,61.0122,NULL,NULL,NULL,NULL),(18770,908,87.52,60.7061,NULL,NULL,NULL,NULL),(18771,908,94.82,62.849,NULL,NULL,NULL,NULL),(18772,909,0.01,70.4796,NULL,NULL,NULL,NULL),(18773,909,0.15,83.1429,NULL,NULL,NULL,NULL),(18774,909,1.04,93.2449,NULL,NULL,NULL,NULL),(18775,909,2.06,98.4898,NULL,NULL,NULL,NULL),(18776,909,3.06,101.898,NULL,NULL,NULL,NULL),(18777,909,4.08,105,NULL,NULL,NULL,NULL),(18778,909,9.14,113.98,NULL,NULL,NULL,NULL),(18779,909,19.2,123.061,NULL,NULL,NULL,NULL),(18780,909,29.62,128.265,NULL,NULL,NULL,NULL),(18781,909,39.98,131.837,NULL,NULL,NULL,NULL),(18782,909,50.25,135,NULL,NULL,NULL,NULL),(18783,909,100.4,144.286,NULL,NULL,NULL,NULL),(18784,909,180.7,151.224,NULL,NULL,NULL,NULL),(18785,910,0.35,70.8878,NULL,NULL,NULL,NULL),(18786,910,1.02,75.9796,NULL,NULL,NULL,NULL),(18787,910,2.07,80.9388,NULL,NULL,NULL,NULL),(18788,910,3.06,84.3878,NULL,NULL,NULL,NULL),(18789,910,4.1,87.2857,NULL,NULL,NULL,NULL),(18790,910,9.14,96.3673,NULL,NULL,NULL,NULL),(18791,910,19.1,105,NULL,NULL,NULL,NULL),(18792,910,29.31,109.796,NULL,NULL,NULL,NULL),(18793,910,39.78,113.98,NULL,NULL,NULL,NULL),(18794,910,50,116.735,NULL,NULL,NULL,NULL),(18795,910,99.9,125.408,NULL,NULL,NULL,NULL),(18796,910,179,132.653,NULL,NULL,NULL,NULL),(18797,911,1.01,53.2959,NULL,NULL,NULL,NULL),(18798,911,2,56.9286,NULL,NULL,NULL,NULL),(18799,911,3.02,59.8776,NULL,NULL,NULL,NULL),(18800,911,4.05,61.7551,NULL,NULL,NULL,NULL),(18801,911,9.14,68.4694,NULL,NULL,NULL,NULL),(18802,911,19,74.7347,NULL,NULL,NULL,NULL),(18803,911,29.46,78.5918,NULL,NULL,NULL,NULL),(18804,911,39.58,81.3571,NULL,NULL,NULL,NULL),(18805,911,50,83.2857,NULL,NULL,NULL,NULL),(18806,911,100.4,89.7653,NULL,NULL,NULL,NULL),(18807,911,176.3,95.5204,NULL,NULL,NULL,NULL),(18808,912,0.18,73.0306,NULL,NULL,NULL,NULL),(18809,912,1.01,82.1735,NULL,NULL,NULL,NULL),(18810,912,2.05,87.7551,NULL,NULL,NULL,NULL),(18811,912,3.1,91.5612,NULL,NULL,NULL,NULL),(18812,912,4.12,95.2347,NULL,NULL,NULL,NULL),(18813,912,9.19,104.898,NULL,NULL,NULL,NULL),(18814,912,19.5,114.592,NULL,NULL,NULL,NULL),(18815,912,29.78,120.612,NULL,NULL,NULL,NULL),(18816,912,39.96,124.286,NULL,NULL,NULL,NULL),(18817,912,49.5,127.857,NULL,NULL,NULL,NULL),(18818,912,100,137.449,NULL,NULL,NULL,NULL),(18819,912,179,145.612,NULL,NULL,NULL,NULL),(18820,913,0.15,65.6735,NULL,NULL,NULL,NULL),(18821,913,1.04,73.1735,NULL,NULL,NULL,NULL),(18822,913,2.05,78,NULL,NULL,NULL,NULL),(18823,913,3.08,82.3061,NULL,NULL,NULL,NULL),(18824,913,4.12,84.7551,NULL,NULL,NULL,NULL),(18825,913,9.19,94.2449,NULL,NULL,NULL,NULL),(18826,913,19.29,103.571,NULL,NULL,NULL,NULL),(18827,913,29.78,109.592,NULL,NULL,NULL,NULL),(18828,913,39.76,112.857,NULL,NULL,NULL,NULL),(18829,913,49.75,116.224,NULL,NULL,NULL,NULL),(18830,913,99,125.714,NULL,NULL,NULL,NULL),(18831,913,179,132.653,NULL,NULL,NULL,NULL),(18832,914,0.06,62.2245,NULL,NULL,NULL,NULL),(18833,914,1.03,76.1225,NULL,NULL,NULL,NULL),(18834,914,2.05,80.9592,NULL,NULL,NULL,NULL),(18835,914,3.06,84.2143,NULL,NULL,NULL,NULL),(18836,914,4.12,86.7959,NULL,NULL,NULL,NULL),(18837,914,9.19,95.2347,NULL,NULL,NULL,NULL),(18838,914,19.29,103.265,NULL,NULL,NULL,NULL),(18839,914,29.31,108.878,NULL,NULL,NULL,NULL),(18840,914,39.57,111.633,NULL,NULL,NULL,NULL),(18841,914,50,113.98,NULL,NULL,NULL,NULL),(18842,914,101,123.061,NULL,NULL,NULL,NULL),(18843,914,181.7,129.592,NULL,NULL,NULL,NULL),(18844,915,0.21,51.2857,NULL,NULL,NULL,NULL),(18845,915,1,56.4592,NULL,NULL,NULL,NULL),(18846,915,2.02,60.5408,NULL,NULL,NULL,NULL),(18847,915,3.04,63.0918,NULL,NULL,NULL,NULL),(18848,915,4.12,65.9592,NULL,NULL,NULL,NULL),(18849,915,9.24,72.6327,NULL,NULL,NULL,NULL),(18850,915,19.19,78.8061,NULL,NULL,NULL,NULL),(18851,915,29.46,82.7143,NULL,NULL,NULL,NULL),(18852,915,39.76,85.7143,NULL,NULL,NULL,NULL),(18853,915,49.5,88.0204,NULL,NULL,NULL,NULL),(18854,915,100,94.6633,NULL,NULL,NULL,NULL),(18855,915,179.9,99.9082,NULL,NULL,NULL,NULL),(18856,916,0.27,80.4082,NULL,NULL,NULL,NULL),(18857,916,1.02,92.1122,NULL,NULL,NULL,NULL),(18858,916,2.09,102.959,NULL,NULL,NULL,NULL),(18859,916,3.04,110.918,NULL,NULL,NULL,NULL),(18860,916,4.12,117.143,NULL,NULL,NULL,NULL),(18861,916,9.05,134.388,NULL,NULL,NULL,NULL),(18862,916,19.09,152.653,NULL,NULL,NULL,NULL),(18863,916,28.85,162.857,NULL,NULL,NULL,NULL),(18864,916,49,176.122,NULL,NULL,NULL,NULL),(18865,916,100.5,195.204,NULL,NULL,NULL,NULL),(18866,916,138.3,204.082,NULL,NULL,NULL,NULL),(18867,917,0.11,61.4898,NULL,NULL,NULL,NULL),(18868,917,1,71.4286,NULL,NULL,NULL,NULL),(18869,917,2.04,76.4592,NULL,NULL,NULL,NULL),(18870,917,3.04,79.5918,NULL,NULL,NULL,NULL),(18871,917,4.1,82.4388,NULL,NULL,NULL,NULL),(18872,917,9,90.2245,NULL,NULL,NULL,NULL),(18873,917,19,98.3469,NULL,NULL,NULL,NULL),(18874,917,28.85,102.959,NULL,NULL,NULL,NULL),(18875,917,39.18,106.224,NULL,NULL,NULL,NULL),(18876,917,49.5,109.592,NULL,NULL,NULL,NULL),(18877,917,97.99,117.755,NULL,NULL,NULL,NULL),(18878,917,179.9,124.49,NULL,NULL,NULL,NULL),(18879,918,0.33,63.2041,NULL,NULL,NULL,NULL),(18880,918,1,69.7041,NULL,NULL,NULL,NULL),(18881,918,2.06,74.6939,NULL,NULL,NULL,NULL),(18882,918,2.98,77.551,NULL,NULL,NULL,NULL),(18883,918,4.07,79.8571,NULL,NULL,NULL,NULL),(18884,918,9.1,86.5918,NULL,NULL,NULL,NULL),(18885,918,19.19,93.5306,NULL,NULL,NULL,NULL),(18886,918,29,97.7857,NULL,NULL,NULL,NULL),(18887,918,39.94,100.622,NULL,NULL,NULL,NULL),(18888,918,49.5,102.959,NULL,NULL,NULL,NULL),(18889,918,96.99,110,NULL,NULL,NULL,NULL),(18890,918,179,115.714,NULL,NULL,NULL,NULL),(18891,919,0.31,48.3061,NULL,NULL,NULL,NULL),(18892,919,1.01,52.8571,NULL,NULL,NULL,NULL),(18893,919,2.01,56.9694,NULL,NULL,NULL,NULL),(18894,919,3.02,59.6633,NULL,NULL,NULL,NULL),(18895,919,4.1,61.6224,NULL,NULL,NULL,NULL),(18896,919,9.05,68.1122,NULL,NULL,NULL,NULL),(18897,919,18.9,74.6939,NULL,NULL,NULL,NULL),(18898,919,28.41,78.5,NULL,NULL,NULL,NULL),(18899,919,39.75,81.6327,NULL,NULL,NULL,NULL),(18900,919,49.5,83.6429,NULL,NULL,NULL,NULL),(18901,919,99,90.6225,NULL,NULL,NULL,NULL),(18902,919,178.1,96.0816,NULL,NULL,NULL,NULL),(18903,920,0.34,102.857,NULL,NULL,NULL,NULL),(18904,920,1.06,109.898,NULL,NULL,NULL,NULL),(18905,920,2.03,112.449,NULL,NULL,NULL,NULL),(18906,920,3,114.49,NULL,NULL,NULL,NULL),(18907,920,4.07,116.429,NULL,NULL,NULL,NULL),(18908,920,9.2,121.531,NULL,NULL,NULL,NULL),(18909,920,19.5,126.122,NULL,NULL,NULL,NULL),(18910,920,29.3,128.367,NULL,NULL,NULL,NULL),(18911,920,39.58,130.612,NULL,NULL,NULL,NULL),(18912,920,49.5,131.735,NULL,NULL,NULL,NULL),(18913,920,101,137.449,NULL,NULL,NULL,NULL),(18914,920,183.5,140.816,NULL,NULL,NULL,NULL),(18915,921,0.25,103.673,NULL,NULL,NULL,NULL),(18916,921,1.05,118.673,NULL,NULL,NULL,NULL),(18917,921,2.05,127.551,NULL,NULL,NULL,NULL),(18918,921,3.02,133.163,NULL,NULL,NULL,NULL),(18919,921,4.07,138.265,NULL,NULL,NULL,NULL),(18920,921,9.25,152.857,NULL,NULL,NULL,NULL),(18921,921,19.7,166.327,NULL,NULL,NULL,NULL),(18922,921,29.92,174.082,NULL,NULL,NULL,NULL),(18923,921,39.98,181.633,NULL,NULL,NULL,NULL),(18924,921,50.01,185.816,NULL,NULL,NULL,NULL),(18925,921,102,199.49,NULL,NULL,NULL,NULL),(18926,921,181.7,212.245,NULL,NULL,NULL,NULL),(18927,922,0.2,63.0306,NULL,NULL,NULL,NULL),(18928,922,1.03,71.0408,NULL,NULL,NULL,NULL),(18929,922,2.03,75.6837,NULL,NULL,NULL,NULL),(18930,922,3.02,78.5306,NULL,NULL,NULL,NULL),(18931,922,4.07,81.3673,NULL,NULL,NULL,NULL),(18932,922,9.2,89.5612,NULL,NULL,NULL,NULL),(18933,922,19.4,97.5,NULL,NULL,NULL,NULL),(18934,922,29.45,102.551,NULL,NULL,NULL,NULL),(18935,922,39.98,105.918,NULL,NULL,NULL,NULL),(18936,922,50.01,108.469,NULL,NULL,NULL,NULL),(18937,922,101,117.347,NULL,NULL,NULL,NULL),(18938,922,180.8,123.265,NULL,NULL,NULL,NULL),(18939,923,0.13,46.5918,NULL,NULL,NULL,NULL),(18940,923,0.35,46.5918,NULL,NULL,NULL,NULL),(18941,923,1,53.3469,NULL,NULL,NULL,NULL),(18942,923,2.02,56.5816,NULL,NULL,NULL,NULL),(18943,923,6.07,64.5204,NULL,NULL,NULL,NULL),(18944,923,7.15,63.1429,NULL,NULL,NULL,NULL),(18945,923,7.54,61.1224,NULL,NULL,NULL,NULL),(18946,923,8.1,61.9694,NULL,NULL,NULL,NULL),(18947,923,9.31,61.1224,NULL,NULL,NULL,NULL),(18948,923,10.49,59.3061,NULL,NULL,NULL,NULL),(18949,923,13.58,60.9184,NULL,NULL,NULL,NULL),(18950,923,15.75,64.6225,NULL,NULL,NULL,NULL),(18951,923,21.11,66.5408,NULL,NULL,NULL,NULL),(18952,923,28.39,66.8571,NULL,NULL,NULL,NULL),(18953,923,36.61,69.4082,NULL,NULL,NULL,NULL),(18954,923,42.87,71.7347,NULL,NULL,NULL,NULL),(18955,923,44.24,72.6633,NULL,NULL,NULL,NULL),(18956,923,49.39,74.6225,NULL,NULL,NULL,NULL),(18957,923,57.33,82.051,NULL,NULL,NULL,NULL),(18958,923,63.97,80.602,NULL,NULL,NULL,NULL),(18959,923,80.23,81.1122,NULL,NULL,NULL,NULL),(18960,923,87.41,85,NULL,NULL,NULL,NULL),(18961,923,95.97,83.949,NULL,NULL,NULL,NULL),(18962,924,0.06,38.7735,NULL,NULL,NULL,NULL),(18963,924,0.14,38.9776,NULL,NULL,NULL,NULL),(18964,924,0.17,39.7939,NULL,NULL,NULL,NULL),(18965,924,0.29,40.9163,NULL,NULL,NULL,NULL),(18966,924,1.07,41.9571,NULL,NULL,NULL,NULL),(18967,924,1.26,41.7531,NULL,NULL,NULL,NULL),(18968,924,2.1,45.0796,NULL,NULL,NULL,NULL),(18969,924,3.08,44.9776,NULL,NULL,NULL,NULL),(18970,924,3.41,43.9367,NULL,NULL,NULL,NULL),(18971,924,5.42,45.702,NULL,NULL,NULL,NULL),(18972,924,6.39,51.1204,NULL,NULL,NULL,NULL),(18973,924,7.45,49.3551,NULL,NULL,NULL,NULL),(18974,924,8.43,51.1204,NULL,NULL,NULL,NULL),(18975,924,9.76,56.0184,NULL,NULL,NULL,NULL),(18976,924,10.62,52.9571,NULL,NULL,NULL,NULL),(18977,924,13.97,58.7735,NULL,NULL,NULL,NULL),(18978,924,15.16,54.4878,NULL,NULL,NULL,NULL),(18979,924,15.92,55.6102,NULL,NULL,NULL,NULL),(18980,924,17,55.7122,NULL,NULL,NULL,NULL),(18981,924,18.14,55.5082,NULL,NULL,NULL,NULL),(18982,924,24.83,59.1816,NULL,NULL,NULL,NULL),(18983,924,28.66,60.3041,NULL,NULL,NULL,NULL),(18984,924,30.3,58.1612,NULL,NULL,NULL,NULL),(18985,924,31.53,58.7735,NULL,NULL,NULL,NULL),(18986,924,31.78,57.4469,NULL,NULL,NULL,NULL),(18987,924,32.8,60.7122,NULL,NULL,NULL,NULL),(18988,924,35.51,61.5388,NULL,NULL,NULL,NULL),(18989,924,38.73,62.9571,NULL,NULL,NULL,NULL),(18990,924,43.93,62.6306,NULL,NULL,NULL,NULL),(18991,924,51.41,61.4367,NULL,NULL,NULL,NULL),(18992,924,59.19,63.6,NULL,NULL,NULL,NULL),(18993,924,67.61,62.9571,NULL,NULL,NULL,NULL),(18994,924,79.03,62.3041,NULL,NULL,NULL,NULL),(18995,924,82.81,63.0592,NULL,NULL,NULL,NULL),(18996,924,92.34,64.151,NULL,NULL,NULL,NULL),(18997,924,99.04,65.8857,NULL,NULL,NULL,NULL),(18998,924,104.58,65.7735,NULL,NULL,NULL,NULL),(18999,925,0.04,1.34821,NULL,NULL,NULL,NULL),(19000,925,0.08,2.43495,NULL,NULL,NULL,NULL),(19001,925,0.13,3.13648,NULL,NULL,NULL,NULL),(19002,925,0.17,3.66199,NULL,NULL,NULL,NULL),(19003,925,0.21,4.01275,NULL,NULL,NULL,NULL),(19004,925,0.25,4.50383,NULL,NULL,NULL,NULL),(19005,925,0.29,4.81888,NULL,NULL,NULL,NULL),(19006,925,0.33,4.99362,NULL,NULL,NULL,NULL),(19007,926,0.04,4.04719,NULL,NULL,NULL,NULL),(19008,926,0.08,7.16582,NULL,NULL,NULL,NULL),(19009,926,0.12,9.65434,NULL,NULL,NULL,NULL),(19010,926,0.17,10.4247,NULL,NULL,NULL,NULL),(19011,926,0.21,10.9503,NULL,NULL,NULL,NULL),(19012,926,0.25,11.4413,NULL,NULL,NULL,NULL),(19013,926,0.29,11.9311,NULL,NULL,NULL,NULL),(19014,926,0.33,12.6327,NULL,NULL,NULL,NULL),(19015,927,0.04,9.0574,NULL,NULL,NULL,NULL),(19016,927,0.08,13.4031,NULL,NULL,NULL,NULL),(19017,927,0.12,15.8559,NULL,NULL,NULL,NULL),(19018,927,0.17,17.4681,NULL,NULL,NULL,NULL),(19019,927,0.21,18.1684,NULL,NULL,NULL,NULL),(19020,927,0.25,19.1849,NULL,NULL,NULL,NULL),(19021,927,0.29,20.4821,NULL,NULL,NULL,NULL),(19022,927,0.33,21.3571,NULL,NULL,NULL,NULL),(19023,928,0.002,1.12245,NULL,NULL,NULL,NULL),(19024,928,0.003,1.32653,NULL,NULL,NULL,NULL),(19025,928,0.005,1.42857,NULL,NULL,NULL,NULL),(19026,928,0.007,1.63265,NULL,NULL,NULL,NULL),(19027,928,0.009,1.63265,NULL,NULL,NULL,NULL),(19028,928,0.012,1.83673,NULL,NULL,NULL,NULL),(19029,928,0.023,2.34694,NULL,NULL,NULL,NULL),(19030,928,0.035,2.65306,NULL,NULL,NULL,NULL),(19031,928,0.046,2.85714,NULL,NULL,NULL,NULL),(19032,928,0.069,3.26531,NULL,NULL,NULL,NULL),(19033,928,0.093,3.57143,NULL,NULL,NULL,NULL),(19034,928,0.116,3.87755,NULL,NULL,NULL,NULL),(19035,928,0.231,4.59184,NULL,NULL,NULL,NULL),(19036,928,0.347,5.20408,NULL,NULL,NULL,NULL),(19037,928,0.463,5.5102,NULL,NULL,NULL,NULL),(19038,928,0.694,6.22449,NULL,NULL,NULL,NULL),(19039,928,0.926,6.73469,NULL,NULL,NULL,NULL),(19040,928,1.157,7.2449,NULL,NULL,NULL,NULL),(19041,928,1.273,7.55102,NULL,NULL,NULL,NULL),(19042,928,1.62,7.95918,NULL,NULL,NULL,NULL),(19043,928,2.083,8.46939,NULL,NULL,NULL,NULL),(19044,929,0.002,1.27551,NULL,NULL,NULL,NULL),(19045,929,0.003,1.42128,NULL,NULL,NULL,NULL),(19046,929,0.005,1.67638,NULL,NULL,NULL,NULL),(19047,929,0.007,1.78571,NULL,NULL,NULL,NULL),(19048,929,0.009,1.78571,NULL,NULL,NULL,NULL),(19049,929,0.012,1.93149,NULL,NULL,NULL,NULL),(19050,929,0.023,2.44169,NULL,NULL,NULL,NULL),(19051,929,0.035,2.76968,NULL,NULL,NULL,NULL),(19052,929,0.046,2.98834,NULL,NULL,NULL,NULL),(19053,929,0.069,3.4621,NULL,NULL,NULL,NULL),(19054,929,0.093,3.75364,NULL,NULL,NULL,NULL),(19055,929,0.116,4.00875,NULL,NULL,NULL,NULL),(19056,929,0.231,4.99271,NULL,NULL,NULL,NULL),(19057,929,0.347,5.61225,NULL,NULL,NULL,NULL),(19058,929,0.463,6.08601,NULL,NULL,NULL,NULL),(19059,929,0.694,6.77843,NULL,NULL,NULL,NULL),(19060,929,0.926,7.39796,NULL,NULL,NULL,NULL),(19061,929,1.157,7.87172,NULL,NULL,NULL,NULL),(19062,929,1.273,8.27259,NULL,NULL,NULL,NULL),(19063,929,1.62,8.56414,NULL,NULL,NULL,NULL),(19064,929,2.083,9.07434,NULL,NULL,NULL,NULL),(19065,930,0.002,1.32653,NULL,NULL,NULL,NULL),(19066,930,0.003,1.42857,NULL,NULL,NULL,NULL),(19067,930,0.005,1.63265,NULL,NULL,NULL,NULL),(19068,930,0.007,1.83673,NULL,NULL,NULL,NULL),(19069,930,0.009,1.83673,NULL,NULL,NULL,NULL),(19070,930,0.012,1.93878,NULL,NULL,NULL,NULL),(19071,930,0.023,2.44898,NULL,NULL,NULL,NULL),(19072,930,0.035,2.7551,NULL,NULL,NULL,NULL),(19073,930,0.046,2.95918,NULL,NULL,NULL,NULL),(19074,930,0.069,3.46939,NULL,NULL,NULL,NULL),(19075,930,0.093,3.77551,NULL,NULL,NULL,NULL),(19076,930,0.116,3.97959,NULL,NULL,NULL,NULL),(19077,930,0.231,5,NULL,NULL,NULL,NULL),(19078,930,0.347,5.61225,NULL,NULL,NULL,NULL),(19079,930,0.463,6.02041,NULL,NULL,NULL,NULL),(19080,930,0.694,6.73469,NULL,NULL,NULL,NULL),(19081,930,0.926,7.34694,NULL,NULL,NULL,NULL),(19082,930,1.157,7.65306,NULL,NULL,NULL,NULL),(19083,930,1.273,8.06122,NULL,NULL,NULL,NULL),(19084,930,1.62,8.46939,NULL,NULL,NULL,NULL),(19085,930,2.083,8.87755,NULL,NULL,NULL,NULL),(19086,931,0.002,0.510204,NULL,NULL,NULL,NULL),(19087,931,0.003,0.510204,NULL,NULL,NULL,NULL),(19088,931,0.005,0.510204,NULL,NULL,NULL,NULL),(19089,931,0.007,0.510204,NULL,NULL,NULL,NULL),(19090,931,0.009,0.510204,NULL,NULL,NULL,NULL),(19091,931,0.012,0.612245,NULL,NULL,NULL,NULL),(19092,931,0.023,0.612245,NULL,NULL,NULL,NULL),(19093,931,0.035,0.714286,NULL,NULL,NULL,NULL),(19094,931,0.046,0.714286,NULL,NULL,NULL,NULL),(19095,931,0.069,0.816327,NULL,NULL,NULL,NULL),(19096,931,0.093,0.816327,NULL,NULL,NULL,NULL),(19097,931,0.116,0.918367,NULL,NULL,NULL,NULL),(19098,931,0.231,0.918367,NULL,NULL,NULL,NULL),(19099,931,0.347,1.02041,NULL,NULL,NULL,NULL),(19100,931,0.463,1.12245,NULL,NULL,NULL,NULL),(19101,931,0.694,1.12245,NULL,NULL,NULL,NULL),(19102,931,0.926,1.22449,NULL,NULL,NULL,NULL),(19103,931,1.157,1.22449,NULL,NULL,NULL,NULL),(19104,931,1.273,1.32653,NULL,NULL,NULL,NULL),(19105,931,1.62,1.32653,NULL,NULL,NULL,NULL),(19106,931,2.083,1.42857,NULL,NULL,NULL,NULL),(19107,932,0.002,0.874636,NULL,NULL,NULL,NULL),(19108,932,0.003,0.947522,NULL,NULL,NULL,NULL),(19109,932,0.005,1.12974,NULL,NULL,NULL,NULL),(19110,932,0.007,1.27551,NULL,NULL,NULL,NULL),(19111,932,0.009,1.27551,NULL,NULL,NULL,NULL),(19112,932,0.012,1.42128,NULL,NULL,NULL,NULL),(19113,932,0.023,1.67638,NULL,NULL,NULL,NULL),(19114,932,0.035,1.93149,NULL,NULL,NULL,NULL),(19115,932,0.046,2.00437,NULL,NULL,NULL,NULL),(19116,932,0.069,2.15015,NULL,NULL,NULL,NULL),(19117,932,0.093,2.33236,NULL,NULL,NULL,NULL),(19118,932,0.116,2.40525,NULL,NULL,NULL,NULL),(19119,932,0.231,2.80612,NULL,NULL,NULL,NULL),(19120,932,0.347,3.13411,NULL,NULL,NULL,NULL),(19121,932,0.463,3.24344,NULL,NULL,NULL,NULL),(19122,932,0.694,3.42566,NULL,NULL,NULL,NULL),(19123,932,0.926,3.64431,NULL,NULL,NULL,NULL),(19124,932,1.157,3.86297,NULL,NULL,NULL,NULL),(19125,932,1.273,3.93586,NULL,NULL,NULL,NULL),(19126,932,1.62,4.11808,NULL,NULL,NULL,NULL),(19127,932,2.083,4.30029,NULL,NULL,NULL,NULL),(19128,933,0.002,0.031237,NULL,NULL,NULL,NULL),(19129,933,0.003,0.031237,NULL,NULL,NULL,NULL),(19130,933,0.005,0.0364431,NULL,NULL,NULL,NULL),(19131,933,0.007,0.0468555,NULL,NULL,NULL,NULL),(19132,933,0.009,0.0468555,NULL,NULL,NULL,NULL),(19133,933,0.012,0.0468555,NULL,NULL,NULL,NULL),(19134,933,0.023,0.0572678,NULL,NULL,NULL,NULL),(19135,933,0.035,0.0676801,NULL,NULL,NULL,NULL),(19136,933,0.046,0.0676801,NULL,NULL,NULL,NULL),(19137,933,0.069,0.0780925,NULL,NULL,NULL,NULL),(19138,933,0.093,0.093711,NULL,NULL,NULL,NULL),(19139,933,0.116,0.119742,NULL,NULL,NULL,NULL),(19140,933,0.231,0.130154,NULL,NULL,NULL,NULL),(19141,933,0.347,0.156185,NULL,NULL,NULL,NULL),(19142,933,0.463,0.171803,NULL,NULL,NULL,NULL),(19143,933,0.694,0.192628,NULL,NULL,NULL,NULL),(19144,933,0.926,0.213453,NULL,NULL,NULL,NULL),(19145,933,1.157,0.223865,NULL,NULL,NULL,NULL),(19146,933,1.273,0.239484,NULL,NULL,NULL,NULL),(19147,933,1.62,0.239484,NULL,NULL,NULL,NULL),(19148,933,2.083,0.260308,NULL,NULL,NULL,NULL),(19149,934,0.002,0.0468555,NULL,NULL,NULL,NULL),(19150,934,0.003,0.0520616,NULL,NULL,NULL,NULL),(19151,934,0.005,0.062474,NULL,NULL,NULL,NULL),(19152,934,0.007,0.0676801,NULL,NULL,NULL,NULL),(19153,934,0.009,0.0676801,NULL,NULL,NULL,NULL),(19154,934,0.012,0.0780925,NULL,NULL,NULL,NULL),(19155,934,0.023,0.0989171,NULL,NULL,NULL,NULL),(19156,934,0.035,0.109329,NULL,NULL,NULL,NULL),(19157,934,0.046,0.124948,NULL,NULL,NULL,NULL),(19158,934,0.069,0.140566,NULL,NULL,NULL,NULL),(19159,934,0.093,0.156185,NULL,NULL,NULL,NULL),(19160,934,0.116,0.161391,NULL,NULL,NULL,NULL),(19161,934,0.231,0.20304,NULL,NULL,NULL,NULL),(19162,934,0.347,0.229071,NULL,NULL,NULL,NULL),(19163,934,0.463,0.249896,NULL,NULL,NULL,NULL),(19164,934,0.694,0.281133,NULL,NULL,NULL,NULL),(19165,934,0.926,0.301958,NULL,NULL,NULL,NULL),(19166,934,1.157,0.322782,NULL,NULL,NULL,NULL),(19167,934,1.273,0.333194,NULL,NULL,NULL,NULL),(19168,934,1.62,0.343607,NULL,NULL,NULL,NULL),(19169,934,2.083,0.369638,NULL,NULL,NULL,NULL),(19170,935,0.002,0.0468555,NULL,NULL,NULL,NULL),(19171,935,0.003,0.0468555,NULL,NULL,NULL,NULL),(19172,935,0.005,0.0520616,NULL,NULL,NULL,NULL),(19173,935,0.007,0.0572678,NULL,NULL,NULL,NULL),(19174,935,0.009,0.0572678,NULL,NULL,NULL,NULL),(19175,935,0.012,0.0676801,NULL,NULL,NULL,NULL),(19176,935,0.023,0.0885048,NULL,NULL,NULL,NULL),(19177,935,0.035,0.0989171,NULL,NULL,NULL,NULL),(19178,935,0.046,0.109329,NULL,NULL,NULL,NULL),(19179,935,0.069,0.124948,NULL,NULL,NULL,NULL),(19180,935,0.093,0.13536,NULL,NULL,NULL,NULL),(19181,935,0.116,0.145773,NULL,NULL,NULL,NULL),(19182,935,0.231,0.182216,NULL,NULL,NULL,NULL),(19183,935,0.347,0.20304,NULL,NULL,NULL,NULL),(19184,935,0.463,0.223865,NULL,NULL,NULL,NULL),(19185,935,0.694,0.249896,NULL,NULL,NULL,NULL),(19186,935,0.926,0.265514,NULL,NULL,NULL,NULL),(19187,935,1.157,0.286339,NULL,NULL,NULL,NULL),(19188,935,1.273,0.296751,NULL,NULL,NULL,NULL),(19189,935,1.62,0.301958,NULL,NULL,NULL,NULL),(19190,935,2.083,0.327988,NULL,NULL,NULL,NULL),(19191,936,0.002,0.0208247,NULL,NULL,NULL,NULL),(19192,936,0.003,0.0208247,NULL,NULL,NULL,NULL),(19193,936,0.005,0.0260308,NULL,NULL,NULL,NULL),(19194,936,0.007,0.0260308,NULL,NULL,NULL,NULL),(19195,936,0.009,0.0260308,NULL,NULL,NULL,NULL),(19196,936,0.012,0.031237,NULL,NULL,NULL,NULL),(19197,936,0.023,0.0364431,NULL,NULL,NULL,NULL),(19198,936,0.035,0.0416493,NULL,NULL,NULL,NULL),(19199,936,0.046,0.0416493,NULL,NULL,NULL,NULL),(19200,936,0.069,0.0468555,NULL,NULL,NULL,NULL),(19201,936,0.093,0.0520616,NULL,NULL,NULL,NULL),(19202,936,0.116,0.0520616,NULL,NULL,NULL,NULL),(19203,936,0.231,0.0572678,NULL,NULL,NULL,NULL),(19204,936,0.347,0.0572678,NULL,NULL,NULL,NULL),(19205,936,0.463,0.0676801,NULL,NULL,NULL,NULL),(19206,936,0.694,0.0728863,NULL,NULL,NULL,NULL),(19207,936,0.926,0.0728863,NULL,NULL,NULL,NULL),(19208,936,1.157,0.0728863,NULL,NULL,NULL,NULL),(19209,936,1.273,0.0780925,NULL,NULL,NULL,NULL),(19210,936,1.62,0.0780925,NULL,NULL,NULL,NULL),(19211,936,2.083,0.0780925,NULL,NULL,NULL,NULL),(19212,937,0.002,0.0208247,NULL,NULL,NULL,NULL),(19213,937,0.003,0.0260308,NULL,NULL,NULL,NULL),(19214,937,0.005,0.031237,NULL,NULL,NULL,NULL),(19215,937,0.007,0.031237,NULL,NULL,NULL,NULL),(19216,937,0.009,0.031237,NULL,NULL,NULL,NULL),(19217,937,0.012,0.0416493,NULL,NULL,NULL,NULL),(19218,937,0.023,0.0468555,NULL,NULL,NULL,NULL),(19219,937,0.035,0.0520616,NULL,NULL,NULL,NULL),(19220,937,0.046,0.0520616,NULL,NULL,NULL,NULL),(19221,937,0.069,0.0572678,NULL,NULL,NULL,NULL),(19222,937,0.093,0.062474,NULL,NULL,NULL,NULL),(19223,937,0.116,0.0676801,NULL,NULL,NULL,NULL),(19224,937,0.231,0.0728863,NULL,NULL,NULL,NULL),(19225,937,0.347,0.0780925,NULL,NULL,NULL,NULL),(19226,937,0.463,0.0832986,NULL,NULL,NULL,NULL),(19227,937,0.694,0.0885048,NULL,NULL,NULL,NULL),(19228,937,0.926,0.093711,NULL,NULL,NULL,NULL),(19229,937,1.157,0.093711,NULL,NULL,NULL,NULL),(19230,937,1.273,0.093711,NULL,NULL,NULL,NULL),(19231,937,1.62,0.0989171,NULL,NULL,NULL,NULL),(19232,937,2.083,0.104123,NULL,NULL,NULL,NULL),(19233,938,2.4476,21.7918,NULL,NULL,NULL,NULL),(19234,938,3.8462,27.7582,NULL,NULL,NULL,NULL),(19235,938,6.2937,35.85,NULL,NULL,NULL,NULL),(19236,938,10.14,39.6429,NULL,NULL,NULL,NULL),(19237,938,13.636,41.1806,NULL,NULL,NULL,NULL),(19238,938,23.427,46.1918,NULL,NULL,NULL,NULL),(19239,938,32.518,52.0857,NULL,NULL,NULL,NULL),(19240,938,39.86,52.1735,NULL,NULL,NULL,NULL),(19241,938,43.706,54.0378,NULL,NULL,NULL,NULL),(19242,938,48.951,54.6582,NULL,NULL,NULL,NULL),(19243,938,55.594,54.7469,NULL,NULL,NULL,NULL),(19244,938,60.14,56.2551,NULL,NULL,NULL,NULL),(19245,938,74.476,57.0541,NULL,NULL,NULL,NULL),(19246,938,91.259,55.4571,NULL,NULL,NULL,NULL),(19247,938,117.19,59.1837,NULL,NULL,NULL,NULL),(19248,938,144.21,62.4888,NULL,NULL,NULL,NULL),(19249,938,164.21,61.5857,NULL,NULL,NULL,NULL),(19250,938,194.39,64.1143,NULL,NULL,NULL,NULL),(19251,938,216.49,66.6429,NULL,NULL,NULL,NULL),(19252,938,242.29,68.9908,NULL,NULL,NULL,NULL),(19253,938,267.74,67.9969,NULL,NULL,NULL,NULL),(19254,938,301.79,73.7765,NULL,NULL,NULL,NULL),(19255,938,335.48,74.0469,NULL,NULL,NULL,NULL),(19256,938,351.61,75.5827,NULL,NULL,NULL,NULL),(19257,938,415.9,75.1306,NULL,NULL,NULL,NULL),(19258,938,459.72,76.3949,NULL,NULL,NULL,NULL),(19259,939,3.1469,16.1327,NULL,NULL,NULL,NULL),(19260,939,4.1958,20.1163,NULL,NULL,NULL,NULL),(19261,939,6.6434,23.5214,NULL,NULL,NULL,NULL),(19262,939,9.0909,27.499,NULL,NULL,NULL,NULL),(19263,939,14.336,32.8694,NULL,NULL,NULL,NULL),(19264,939,18.532,34.0439,NULL,NULL,NULL,NULL),(19265,939,27.972,39.8235,NULL,NULL,NULL,NULL),(19266,939,33.217,39.8235,NULL,NULL,NULL,NULL),(19267,939,37.762,42.8204,NULL,NULL,NULL,NULL),(19268,939,45.804,43.1847,NULL,NULL,NULL,NULL),(19269,939,49.65,43.3673,NULL,NULL,NULL,NULL),(19270,939,54.895,44.6429,NULL,NULL,NULL,NULL),(19271,939,70.629,45.6449,NULL,NULL,NULL,NULL),(19272,939,87.063,45.7357,NULL,NULL,NULL,NULL),(19273,939,111.23,49.1071,NULL,NULL,NULL,NULL),(19274,939,138.25,51.5531,NULL,NULL,NULL,NULL),(19275,939,158.95,51.198,NULL,NULL,NULL,NULL),(19276,939,189.83,53.15,NULL,NULL,NULL,NULL),(19277,939,211.47,54.4806,NULL,NULL,NULL,NULL),(19278,939,236.92,57.7643,NULL,NULL,NULL,NULL),(19279,939,262.72,56.6102,NULL,NULL,NULL,NULL),(19280,939,297.49,60.6031,NULL,NULL,NULL,NULL),(19281,939,331.54,62.3082,NULL,NULL,NULL,NULL),(19282,939,343.37,63.4816,NULL,NULL,NULL,NULL),(19283,939,410.25,64.0235,NULL,NULL,NULL,NULL),(19284,939,432.86,64.3847,NULL,NULL,NULL,NULL),(19285,939,454.77,66.552,NULL,NULL,NULL,NULL),(19286,940,3.1469,10.9816,NULL,NULL,NULL,NULL),(19287,940,4.8951,17.5898,NULL,NULL,NULL,NULL),(19288,940,7.6923,20.2143,NULL,NULL,NULL,NULL),(19289,940,12.937,23.1755,NULL,NULL,NULL,NULL),(19290,940,15.035,24.2133,NULL,NULL,NULL,NULL),(19291,940,19.231,25.8561,NULL,NULL,NULL,NULL),(19292,940,25.874,28.9694,NULL,NULL,NULL,NULL),(19293,940,29.371,30.2663,NULL,NULL,NULL,NULL),(19294,940,34.266,30.5255,NULL,NULL,NULL,NULL),(19295,940,51.399,32.9602,NULL,NULL,NULL,NULL),(19296,940,55.245,33.8633,NULL,NULL,NULL,NULL),(19297,940,66.084,35.0367,NULL,NULL,NULL,NULL),(19298,940,92.657,38.5592,NULL,NULL,NULL,NULL),(19299,940,119.3,41.1806,NULL,NULL,NULL,NULL),(19300,940,138.6,40.999,NULL,NULL,NULL,NULL),(19301,940,170.18,44.0959,NULL,NULL,NULL,NULL),(19302,940,189.83,46.101,NULL,NULL,NULL,NULL),(19303,940,216.85,48.9245,NULL,NULL,NULL,NULL),(19304,940,241.58,49.0163,NULL,NULL,NULL,NULL),(19305,940,277.06,51.6418,NULL,NULL,NULL,NULL),(19306,940,311.11,54.3031,NULL,NULL,NULL,NULL),(19307,940,326.88,54.3918,NULL,NULL,NULL,NULL),(19308,940,388.89,56.9653,NULL,NULL,NULL,NULL),(19309,940,414.13,57.6755,NULL,NULL,NULL,NULL),(19310,940,438.16,59.9827,NULL,NULL,NULL,NULL),(19311,941,2.0979,7.6301,NULL,NULL,NULL,NULL),(19312,941,5.2448,9.2848,NULL,NULL,NULL,NULL),(19313,941,6.993,10.399,NULL,NULL,NULL,NULL),(19314,941,13.287,14.3827,NULL,NULL,NULL,NULL),(19315,941,21.329,17.201,NULL,NULL,NULL,NULL),(19316,941,31.119,18.2704,NULL,NULL,NULL,NULL),(19317,941,57.343,23.0888,NULL,NULL,NULL,NULL),(19318,941,83.916,26.8939,NULL,NULL,NULL,NULL),(19319,941,102.81,27.9316,NULL,NULL,NULL,NULL),(19320,941,135.09,30.8837,NULL,NULL,NULL,NULL),(19321,941,155.79,33.3214,NULL,NULL,NULL,NULL),(19322,941,166.32,33.9531,NULL,NULL,NULL,NULL),(19323,941,179.3,36.3918,NULL,NULL,NULL,NULL),(19324,941,207.17,37.3847,NULL,NULL,NULL,NULL),(19325,941,243.73,40.0041,NULL,NULL,NULL,NULL),(19326,941,275.99,42.7296,NULL,NULL,NULL,NULL),(19327,941,279.21,42.2745,NULL,NULL,NULL,NULL),(19328,941,292.12,42.6388,NULL,NULL,NULL,NULL),(19329,941,355.2,44.7337,NULL,NULL,NULL,NULL),(19330,941,377.78,44.6429,NULL,NULL,NULL,NULL),(19331,941,402.83,47.5582,NULL,NULL,NULL,NULL),(19332,942,2.3276,-0.0986735,NULL,NULL,NULL,NULL),(19333,942,2.6772,1.18837,NULL,NULL,NULL,NULL),(19334,942,5.1248,2.65918,NULL,NULL,NULL,NULL),(19335,942,9.6702,3.39469,NULL,NULL,NULL,NULL),(19336,942,19.111,5.69286,NULL,NULL,NULL,NULL),(19337,942,29.6,5.87673,NULL,NULL,NULL,NULL),(19338,942,43.237,7.87041,NULL,NULL,NULL,NULL),(19339,942,48.831,8.25918,NULL,NULL,NULL,NULL),(19340,942,61.419,9.81429,NULL,NULL,NULL,NULL),(19341,942,95.335,13.6041,NULL,NULL,NULL,NULL),(19342,942,111.81,14.1867,NULL,NULL,NULL,NULL),(19343,942,159.88,17.1673,NULL,NULL,NULL,NULL),(19344,942,188.65,18.7245,NULL,NULL,NULL,NULL),(19345,942,217.08,20.0214,NULL,NULL,NULL,NULL),(19346,942,251.85,21.6643,NULL,NULL,NULL,NULL),(19347,942,256.87,22.2694,NULL,NULL,NULL,NULL),(19348,943,1,2.60606,NULL,NULL,NULL,NULL),(19349,943,3,7.63636,NULL,NULL,NULL,NULL),(19350,943,5,9.45455,NULL,NULL,NULL,NULL),(19351,943,7,10.7273,NULL,NULL,NULL,NULL),(19352,943,10,13.3939,NULL,NULL,NULL,NULL),(19353,943,15,16.1818,NULL,NULL,NULL,NULL),(19354,943,20,17.8182,NULL,NULL,NULL,NULL),(19355,943,25,18.4242,NULL,NULL,NULL,NULL),(19356,943,30,23.0303,NULL,NULL,NULL,NULL),(19357,943,35,24.1212,NULL,NULL,NULL,NULL),(19358,943,40,25.4545,NULL,NULL,NULL,NULL),(19359,943,41,28.6061,NULL,NULL,NULL,NULL),(19360,943,43,29.7576,NULL,NULL,NULL,NULL),(19361,943,45,29.5758,NULL,NULL,NULL,NULL),(19362,943,47,30.4848,NULL,NULL,NULL,NULL),(19363,943,50,31.1515,NULL,NULL,NULL,NULL),(19364,943,55,32.303,NULL,NULL,NULL,NULL),(19365,943,60,33.3939,NULL,NULL,NULL,NULL),(19366,943,65,34.1212,NULL,NULL,NULL,NULL),(19367,943,70,35.4545,NULL,NULL,NULL,NULL),(19368,943,71,38.4848,NULL,NULL,NULL,NULL),(19369,943,73,39.5152,NULL,NULL,NULL,NULL),(19370,943,75,41.697,NULL,NULL,NULL,NULL),(19371,943,77,43.6364,NULL,NULL,NULL,NULL),(19372,943,80,44.9091,NULL,NULL,NULL,NULL),(19373,943,85,46,NULL,NULL,NULL,NULL),(19374,943,90,47.8182,NULL,NULL,NULL,NULL),(19375,943,91,50.4848,NULL,NULL,NULL,NULL),(19376,943,93,52.1212,NULL,NULL,NULL,NULL),(19377,943,95,53.2121,NULL,NULL,NULL,NULL),(19378,943,97,53.6364,NULL,NULL,NULL,NULL),(19379,943,100,55.697,NULL,NULL,NULL,NULL),(19380,943,105,57.2121,NULL,NULL,NULL,NULL),(19381,943,110,59.5758,NULL,NULL,NULL,NULL),(19382,943,115,60.3636,NULL,NULL,NULL,NULL),(19383,943,120,61.9394,NULL,NULL,NULL,NULL),(19384,943,121,64.1818,NULL,NULL,NULL,NULL),(19385,943,123,65.4545,NULL,NULL,NULL,NULL),(19386,943,125,67.0303,NULL,NULL,NULL,NULL),(19387,943,127,68.1212,NULL,NULL,NULL,NULL),(19388,943,130,69.8182,NULL,NULL,NULL,NULL),(19389,943,135,72.4242,NULL,NULL,NULL,NULL),(19390,943,140,74.6667,NULL,NULL,NULL,NULL),(19391,943,145,79.0303,NULL,NULL,NULL,NULL),(19392,943,150,80.9091,NULL,NULL,NULL,NULL),(19393,943,155,82.1818,NULL,NULL,NULL,NULL),(19394,943,160,83.9394,NULL,NULL,NULL,NULL),(19395,944,1,2.72727,NULL,NULL,NULL,NULL),(19396,944,3,4.95868,NULL,NULL,NULL,NULL),(19397,944,5,5.33058,NULL,NULL,NULL,NULL),(19398,944,7,5.3719,NULL,NULL,NULL,NULL),(19399,944,10,7.35537,NULL,NULL,NULL,NULL),(19400,944,15,8.34711,NULL,NULL,NULL,NULL),(19401,944,20,9.21488,NULL,NULL,NULL,NULL),(19402,944,25,9.79339,NULL,NULL,NULL,NULL),(19403,944,30,11.4463,NULL,NULL,NULL,NULL),(19404,944,35,11.4876,NULL,NULL,NULL,NULL),(19405,944,40,12.7273,NULL,NULL,NULL,NULL),(19406,944,41,13.6777,NULL,NULL,NULL,NULL),(19407,944,43,15.124,NULL,NULL,NULL,NULL),(19408,944,45,14.9587,NULL,NULL,NULL,NULL),(19409,944,47,15.4545,NULL,NULL,NULL,NULL),(19410,944,50,15.8264,NULL,NULL,NULL,NULL),(19411,944,55,16.0331,NULL,NULL,NULL,NULL),(19412,944,60,17.5207,NULL,NULL,NULL,NULL),(19413,944,65,18.0992,NULL,NULL,NULL,NULL),(19414,944,70,18.6364,NULL,NULL,NULL,NULL),(19415,944,71,20.0413,NULL,NULL,NULL,NULL),(19416,944,73,20.5785,NULL,NULL,NULL,NULL),(19417,944,75,21.2397,NULL,NULL,NULL,NULL),(19418,944,77,21.9421,NULL,NULL,NULL,NULL),(19419,944,80,23.0165,NULL,NULL,NULL,NULL),(19420,944,85,23.4711,NULL,NULL,NULL,NULL),(19421,944,90,24.2149,NULL,NULL,NULL,NULL),(19422,944,91,25.6198,NULL,NULL,NULL,NULL),(19423,944,93,26.4463,NULL,NULL,NULL,NULL),(19424,944,95,26.7769,NULL,NULL,NULL,NULL),(19425,944,97,27.438,NULL,NULL,NULL,NULL),(19426,944,100,28.1405,NULL,NULL,NULL,NULL),(19427,944,105,28.8017,NULL,NULL,NULL,NULL),(19428,944,110,30.2066,NULL,NULL,NULL,NULL),(19429,944,115,30.8678,NULL,NULL,NULL,NULL),(19430,944,120,31.6116,NULL,NULL,NULL,NULL),(19431,944,121,32.9752,NULL,NULL,NULL,NULL),(19432,944,123,33.6364,NULL,NULL,NULL,NULL),(19433,944,125,34.3388,NULL,NULL,NULL,NULL),(19434,944,127,35.124,NULL,NULL,NULL,NULL),(19435,944,130,36.0744,NULL,NULL,NULL,NULL),(19436,944,135,37.9339,NULL,NULL,NULL,NULL),(19437,944,140,39.2975,NULL,NULL,NULL,NULL),(19438,944,145,41.3223,NULL,NULL,NULL,NULL),(19439,944,150,42.1074,NULL,NULL,NULL,NULL),(19440,944,155,42.8512,NULL,NULL,NULL,NULL),(19441,944,160,44.0083,NULL,NULL,NULL,NULL),(19442,945,1,1.56146,NULL,NULL,NULL,NULL),(19443,945,3,1.69435,NULL,NULL,NULL,NULL),(19444,945,5,1.96013,NULL,NULL,NULL,NULL),(19445,945,7,2.09302,NULL,NULL,NULL,NULL),(19446,945,10,2.62458,NULL,NULL,NULL,NULL),(19447,945,15,3.25581,NULL,NULL,NULL,NULL),(19448,945,20,3.95349,NULL,NULL,NULL,NULL),(19449,945,25,4.18605,NULL,NULL,NULL,NULL),(19450,945,30,5.61462,NULL,NULL,NULL,NULL),(19451,945,35,6.24585,NULL,NULL,NULL,NULL),(19452,945,40,5.98007,NULL,NULL,NULL,NULL),(19453,945,41,6.64452,NULL,NULL,NULL,NULL),(19454,945,43,7.30897,NULL,NULL,NULL,NULL),(19455,945,45,7.50831,NULL,NULL,NULL,NULL),(19456,945,47,7.87375,NULL,NULL,NULL,NULL),(19457,945,50,8.40532,NULL,NULL,NULL,NULL),(19458,945,55,8.90365,NULL,NULL,NULL,NULL),(19459,945,60,9.16944,NULL,NULL,NULL,NULL),(19460,945,65,8.63787,NULL,NULL,NULL,NULL),(19461,945,70,9.56811,NULL,NULL,NULL,NULL),(19462,945,71,11.0631,NULL,NULL,NULL,NULL),(19463,945,73,11.7608,NULL,NULL,NULL,NULL),(19464,945,75,12.2259,NULL,NULL,NULL,NULL),(19465,945,77,12.5914,NULL,NULL,NULL,NULL),(19466,945,80,13.0897,NULL,NULL,NULL,NULL),(19467,945,85,13.5216,NULL,NULL,NULL,NULL),(19468,945,90,13.7542,NULL,NULL,NULL,NULL),(19469,945,91,14.8173,NULL,NULL,NULL,NULL),(19470,945,93,15.1827,NULL,NULL,NULL,NULL),(19471,945,95,15.6478,NULL,NULL,NULL,NULL),(19472,945,97,16.3123,NULL,NULL,NULL,NULL),(19473,945,100,17.01,NULL,NULL,NULL,NULL),(19474,945,105,17.6412,NULL,NULL,NULL,NULL),(19475,945,110,18.3721,NULL,NULL,NULL,NULL),(19476,945,115,18.6047,NULL,NULL,NULL,NULL),(19477,945,120,19.5681,NULL,NULL,NULL,NULL),(19478,945,121,21.0963,NULL,NULL,NULL,NULL),(19479,945,123,22.6246,NULL,NULL,NULL,NULL),(19480,945,125,23.4551,NULL,NULL,NULL,NULL),(19481,945,127,24.3854,NULL,NULL,NULL,NULL),(19482,945,130,25.4817,NULL,NULL,NULL,NULL),(19483,945,135,26.9103,NULL,NULL,NULL,NULL),(19484,945,140,27.608,NULL,NULL,NULL,NULL),(19485,945,145,28.804,NULL,NULL,NULL,NULL),(19486,945,150,29.7674,NULL,NULL,NULL,NULL),(19487,945,155,30.3987,NULL,NULL,NULL,NULL),(19488,945,160,31.1628,NULL,NULL,NULL,NULL),(19489,946,1,0.962099,NULL,NULL,NULL,NULL),(19490,946,3,1.19534,NULL,NULL,NULL,NULL),(19491,946,5,1.42857,NULL,NULL,NULL,NULL),(19492,946,7,1.45773,NULL,NULL,NULL,NULL),(19493,946,10,2.27405,NULL,NULL,NULL,NULL),(19494,946,15,2.97376,NULL,NULL,NULL,NULL),(19495,946,20,3.00292,NULL,NULL,NULL,NULL),(19496,946,25,3.23615,NULL,NULL,NULL,NULL),(19497,946,30,4.37318,NULL,NULL,NULL,NULL),(19498,946,35,4.75219,NULL,NULL,NULL,NULL),(19499,946,40,4.95627,NULL,NULL,NULL,NULL),(19500,946,41,5.86006,NULL,NULL,NULL,NULL),(19501,946,43,6.06414,NULL,NULL,NULL,NULL),(19502,946,45,6.20991,NULL,NULL,NULL,NULL),(19503,946,47,6.90962,NULL,NULL,NULL,NULL),(19504,946,50,7.52187,NULL,NULL,NULL,NULL),(19505,946,55,8.01749,NULL,NULL,NULL,NULL),(19506,946,60,8.45481,NULL,NULL,NULL,NULL),(19507,946,65,8.51312,NULL,NULL,NULL,NULL),(19508,946,70,8.92128,NULL,NULL,NULL,NULL),(19509,946,71,9.97085,NULL,NULL,NULL,NULL),(19510,946,73,10.379,NULL,NULL,NULL,NULL),(19511,946,75,10.8163,NULL,NULL,NULL,NULL),(19512,946,77,11.2536,NULL,NULL,NULL,NULL),(19513,946,80,11.8367,NULL,NULL,NULL,NULL),(19514,946,85,12.3615,NULL,NULL,NULL,NULL),(19515,946,90,12.7988,NULL,NULL,NULL,NULL),(19516,946,91,13.4985,NULL,NULL,NULL,NULL),(19517,946,93,13.9942,NULL,NULL,NULL,NULL),(19518,946,95,14.4315,NULL,NULL,NULL,NULL),(19519,946,97,15.0437,NULL,NULL,NULL,NULL),(19520,946,100,15.5977,NULL,NULL,NULL,NULL),(19521,946,105,16.5598,NULL,NULL,NULL,NULL),(19522,946,110,17.7551,NULL,NULL,NULL,NULL),(19523,946,115,18.6006,NULL,NULL,NULL,NULL),(19524,946,120,18.9213,NULL,NULL,NULL,NULL),(19525,946,121,19.7376,NULL,NULL,NULL,NULL),(19526,946,123,20.2915,NULL,NULL,NULL,NULL),(19527,946,125,20.9329,NULL,NULL,NULL,NULL),(19528,946,127,21.3703,NULL,NULL,NULL,NULL),(19529,946,130,22.07,NULL,NULL,NULL,NULL),(19530,946,135,22.8863,NULL,NULL,NULL,NULL),(19531,946,140,23.7609,NULL,NULL,NULL,NULL),(19532,946,145,25.0729,NULL,NULL,NULL,NULL),(19533,946,150,25.5977,NULL,NULL,NULL,NULL),(19534,946,155,26.1516,NULL,NULL,NULL,NULL),(19535,946,160,26.7347,NULL,NULL,NULL,NULL),(19536,947,1,1.06145,NULL,NULL,NULL,NULL),(19537,947,3,2.01117,NULL,NULL,NULL,NULL),(19538,947,5,1.89944,NULL,NULL,NULL,NULL),(19539,947,7,2.01117,NULL,NULL,NULL,NULL),(19540,947,10,2.7095,NULL,NULL,NULL,NULL),(19541,947,15,3.21229,NULL,NULL,NULL,NULL),(19542,947,20,3.54749,NULL,NULL,NULL,NULL),(19543,947,25,3.54749,NULL,NULL,NULL,NULL),(19544,947,30,4.55307,NULL,NULL,NULL,NULL),(19545,947,35,5.11173,NULL,NULL,NULL,NULL),(19546,947,40,5.0838,NULL,NULL,NULL,NULL),(19547,947,41,5.69832,NULL,NULL,NULL,NULL),(19548,947,43,5.69832,NULL,NULL,NULL,NULL),(19549,947,45,6.25698,NULL,NULL,NULL,NULL),(19550,947,47,6.75978,NULL,NULL,NULL,NULL),(19551,947,50,7.34637,NULL,NULL,NULL,NULL),(19552,947,55,7.34637,NULL,NULL,NULL,NULL),(19553,947,60,7.56983,NULL,NULL,NULL,NULL),(19554,947,65,7.84916,NULL,NULL,NULL,NULL),(19555,947,70,8.07263,NULL,NULL,NULL,NULL),(19556,947,71,8.74302,NULL,NULL,NULL,NULL),(19557,947,73,9.46927,NULL,NULL,NULL,NULL),(19558,947,75,9.69274,NULL,NULL,NULL,NULL),(19559,947,77,10.1397,NULL,NULL,NULL,NULL),(19560,947,80,10.6704,NULL,NULL,NULL,NULL),(19561,947,85,10.9777,NULL,NULL,NULL,NULL),(19562,947,90,11.257,NULL,NULL,NULL,NULL),(19563,947,91,11.9274,NULL,NULL,NULL,NULL),(19564,947,93,12.3464,NULL,NULL,NULL,NULL),(19565,947,95,12.7654,NULL,NULL,NULL,NULL),(19566,947,97,13.1285,NULL,NULL,NULL,NULL),(19567,947,100,13.7151,NULL,NULL,NULL,NULL),(19568,947,105,14.6369,NULL,NULL,NULL,NULL),(19569,947,110,15.2235,NULL,NULL,NULL,NULL),(19570,947,115,15.6983,NULL,NULL,NULL,NULL),(19571,947,120,16.1453,NULL,NULL,NULL,NULL),(19572,947,121,16.9832,NULL,NULL,NULL,NULL),(19573,947,123,17.4302,NULL,NULL,NULL,NULL),(19574,947,125,17.6816,NULL,NULL,NULL,NULL),(19575,947,127,18.0168,NULL,NULL,NULL,NULL),(19576,947,130,18.4916,NULL,NULL,NULL,NULL),(19577,947,135,18.8827,NULL,NULL,NULL,NULL),(19578,947,140,19.4134,NULL,NULL,NULL,NULL),(19579,947,145,20.5028,NULL,NULL,NULL,NULL),(19580,947,150,20.7542,NULL,NULL,NULL,NULL),(19581,947,155,20.9497,NULL,NULL,NULL,NULL),(19582,947,160,21.1173,NULL,NULL,NULL,NULL),(19583,948,1,9.51515,NULL,NULL,NULL,NULL),(19584,948,3,41.8788,NULL,NULL,NULL,NULL),(19585,948,5,47.697,NULL,NULL,NULL,NULL),(19586,948,7,51.3939,NULL,NULL,NULL,NULL),(19587,948,10,72,NULL,NULL,NULL,NULL),(19588,948,15,83.1515,NULL,NULL,NULL,NULL),(19589,948,20,89.3939,NULL,NULL,NULL,NULL),(19590,948,25,93.5758,NULL,NULL,NULL,NULL),(19591,948,30,106,NULL,NULL,NULL,NULL),(19592,948,35,112.606,NULL,NULL,NULL,NULL),(19593,948,40,119.091,NULL,NULL,NULL,NULL),(19594,948,41,122.909,NULL,NULL,NULL,NULL),(19595,948,43,122.909,NULL,NULL,NULL,NULL),(19596,948,45,122.061,NULL,NULL,NULL,NULL),(19597,948,47,122.545,NULL,NULL,NULL,NULL),(19598,948,50,122.909,NULL,NULL,NULL,NULL),(19599,948,55,123.576,NULL,NULL,NULL,NULL),(19600,948,60,124.424,NULL,NULL,NULL,NULL),(19601,948,65,125.394,NULL,NULL,NULL,NULL),(19602,948,70,126.788,NULL,NULL,NULL,NULL),(19603,948,71,127.091,NULL,NULL,NULL,NULL),(19604,948,73,125.636,NULL,NULL,NULL,NULL),(19605,948,75,126.545,NULL,NULL,NULL,NULL),(19606,948,77,127.515,NULL,NULL,NULL,NULL),(19607,948,80,127.515,NULL,NULL,NULL,NULL),(19608,948,85,127.03,NULL,NULL,NULL,NULL),(19609,948,90,127.394,NULL,NULL,NULL,NULL),(19610,948,91,127.636,NULL,NULL,NULL,NULL),(19611,948,93,127.273,NULL,NULL,NULL,NULL),(19612,948,95,127.03,NULL,NULL,NULL,NULL),(19613,948,97,126.182,NULL,NULL,NULL,NULL),(19614,948,100,126.788,NULL,NULL,NULL,NULL),(19615,948,105,126.364,NULL,NULL,NULL,NULL),(19616,948,110,126.848,NULL,NULL,NULL,NULL),(19617,948,115,126.242,NULL,NULL,NULL,NULL),(19618,948,120,126.061,NULL,NULL,NULL,NULL),(19619,948,121,125.515,NULL,NULL,NULL,NULL),(19620,948,123,125.333,NULL,NULL,NULL,NULL),(19621,948,125,125.515,NULL,NULL,NULL,NULL),(19622,948,127,125.576,NULL,NULL,NULL,NULL),(19623,948,130,125.455,NULL,NULL,NULL,NULL),(19624,948,135,125.333,NULL,NULL,NULL,NULL),(19625,948,140,125.455,NULL,NULL,NULL,NULL),(19626,948,145,125.455,NULL,NULL,NULL,NULL),(19627,948,150,125.333,NULL,NULL,NULL,NULL),(19628,948,155,125.273,NULL,NULL,NULL,NULL),(19629,948,160,125.455,NULL,NULL,NULL,NULL),(19630,949,1,5.33058,NULL,NULL,NULL,NULL),(19631,949,3,13.0165,NULL,NULL,NULL,NULL),(19632,949,5,15.124,NULL,NULL,NULL,NULL),(19633,949,7,16.3223,NULL,NULL,NULL,NULL),(19634,949,10,23.0165,NULL,NULL,NULL,NULL),(19635,949,15,26.9835,NULL,NULL,NULL,NULL),(19636,949,20,30,NULL,NULL,NULL,NULL),(19637,949,25,32.0661,NULL,NULL,NULL,NULL),(19638,949,30,35.7851,NULL,NULL,NULL,NULL),(19639,949,35,37.7686,NULL,NULL,NULL,NULL),(19640,949,40,40.3719,NULL,NULL,NULL,NULL),(19641,949,41,40.7025,NULL,NULL,NULL,NULL),(19642,949,43,41.7355,NULL,NULL,NULL,NULL),(19643,949,45,41.281,NULL,NULL,NULL,NULL),(19644,949,47,41.7769,NULL,NULL,NULL,NULL),(19645,949,50,42.0248,NULL,NULL,NULL,NULL),(19646,949,55,42.4793,NULL,NULL,NULL,NULL),(19647,949,60,44.0083,NULL,NULL,NULL,NULL),(19648,949,65,44.7934,NULL,NULL,NULL,NULL),(19649,949,70,45.4959,NULL,NULL,NULL,NULL),(19650,949,71,45.9504,NULL,NULL,NULL,NULL),(19651,949,73,45.4545,NULL,NULL,NULL,NULL),(19652,949,75,45.4132,NULL,NULL,NULL,NULL),(19653,949,77,45.8678,NULL,NULL,NULL,NULL),(19654,949,80,46.281,NULL,NULL,NULL,NULL),(19655,949,85,45.9504,NULL,NULL,NULL,NULL),(19656,949,90,45.9504,NULL,NULL,NULL,NULL),(19657,949,91,45.9917,NULL,NULL,NULL,NULL),(19658,949,93,45.7851,NULL,NULL,NULL,NULL),(19659,949,95,45.3306,NULL,NULL,NULL,NULL),(19660,949,97,45.2893,NULL,NULL,NULL,NULL),(19661,949,100,45.124,NULL,NULL,NULL,NULL),(19662,949,105,44.876,NULL,NULL,NULL,NULL),(19663,949,110,45.0826,NULL,NULL,NULL,NULL),(19664,949,115,45,NULL,NULL,NULL,NULL),(19665,949,120,44.5868,NULL,NULL,NULL,NULL),(19666,949,121,44.5455,NULL,NULL,NULL,NULL),(19667,949,123,44.2562,NULL,NULL,NULL,NULL),(19668,949,125,44.0496,NULL,NULL,NULL,NULL),(19669,949,127,44.1736,NULL,NULL,NULL,NULL),(19670,949,130,44.1322,NULL,NULL,NULL,NULL),(19671,949,135,44.2562,NULL,NULL,NULL,NULL),(19672,949,140,44.2149,NULL,NULL,NULL,NULL),(19673,949,145,44.1322,NULL,NULL,NULL,NULL),(19674,949,150,43.8017,NULL,NULL,NULL,NULL),(19675,949,155,43.719,NULL,NULL,NULL,NULL),(19676,949,160,43.9669,NULL,NULL,NULL,NULL),(19677,950,1,4.01993,NULL,NULL,NULL,NULL),(19678,950,3,7.9402,NULL,NULL,NULL,NULL),(19679,950,5,9.36877,NULL,NULL,NULL,NULL),(19680,950,7,10.5316,NULL,NULL,NULL,NULL),(19681,950,10,12.99,NULL,NULL,NULL,NULL),(19682,950,15,15.5482,NULL,NULL,NULL,NULL),(19683,950,20,17.5083,NULL,NULL,NULL,NULL),(19684,950,25,19.2359,NULL,NULL,NULL,NULL),(19685,950,30,23.1561,NULL,NULL,NULL,NULL),(19686,950,35,25.5482,NULL,NULL,NULL,NULL),(19687,950,40,26.8439,NULL,NULL,NULL,NULL),(19688,950,41,27.0764,NULL,NULL,NULL,NULL),(19689,950,43,27.309,NULL,NULL,NULL,NULL),(19690,950,45,27.309,NULL,NULL,NULL,NULL),(19691,950,47,27.5748,NULL,NULL,NULL,NULL),(19692,950,50,27.9734,NULL,NULL,NULL,NULL),(19693,950,55,28.4385,NULL,NULL,NULL,NULL),(19694,950,60,28.6711,NULL,NULL,NULL,NULL),(19695,950,65,28.1728,NULL,NULL,NULL,NULL),(19696,950,70,29.2691,NULL,NULL,NULL,NULL),(19697,950,71,29.9668,NULL,NULL,NULL,NULL),(19698,950,73,29.5681,NULL,NULL,NULL,NULL),(19699,950,75,29.5681,NULL,NULL,NULL,NULL),(19700,950,77,29.4684,NULL,NULL,NULL,NULL),(19701,950,80,29.4684,NULL,NULL,NULL,NULL),(19702,950,85,29.2027,NULL,NULL,NULL,NULL),(19703,950,90,28.7708,NULL,NULL,NULL,NULL),(19704,950,91,28.9037,NULL,NULL,NULL,NULL),(19705,950,93,28.505,NULL,NULL,NULL,NULL),(19706,950,95,28.505,NULL,NULL,NULL,NULL),(19707,950,97,28.6379,NULL,NULL,NULL,NULL),(19708,950,100,28.6711,NULL,NULL,NULL,NULL),(19709,950,105,28.4053,NULL,NULL,NULL,NULL),(19710,950,110,28.3389,NULL,NULL,NULL,NULL),(19711,950,115,28.0731,NULL,NULL,NULL,NULL),(19712,950,120,28.3056,NULL,NULL,NULL,NULL),(19713,950,121,28.0731,NULL,NULL,NULL,NULL),(19714,950,123,28.2392,NULL,NULL,NULL,NULL),(19715,950,125,28.1395,NULL,NULL,NULL,NULL),(19716,950,127,28.206,NULL,NULL,NULL,NULL),(19717,950,130,28.3389,NULL,NULL,NULL,NULL),(19718,950,135,28.3056,NULL,NULL,NULL,NULL),(19719,950,140,27.9402,NULL,NULL,NULL,NULL),(19720,950,145,27.9402,NULL,NULL,NULL,NULL),(19721,950,150,28.0399,NULL,NULL,NULL,NULL),(19722,950,155,27.8405,NULL,NULL,NULL,NULL),(19723,950,160,27.9734,NULL,NULL,NULL,NULL),(19724,951,1,3.35277,NULL,NULL,NULL,NULL),(19725,951,3,6.26822,NULL,NULL,NULL,NULL),(19726,951,5,7.60933,NULL,NULL,NULL,NULL),(19727,951,7,8.45481,NULL,NULL,NULL,NULL),(19728,951,10,11.2245,NULL,NULL,NULL,NULL),(19729,951,15,13.7026,NULL,NULL,NULL,NULL),(19730,951,20,14.9854,NULL,NULL,NULL,NULL),(19731,951,25,16.5306,NULL,NULL,NULL,NULL),(19732,951,30,19.5627,NULL,NULL,NULL,NULL),(19733,951,35,21.1953,NULL,NULL,NULL,NULL),(19734,951,40,22.6531,NULL,NULL,NULL,NULL),(19735,951,41,22.828,NULL,NULL,NULL,NULL),(19736,951,43,22.5948,NULL,NULL,NULL,NULL),(19737,951,45,22.3907,NULL,NULL,NULL,NULL),(19738,951,47,23.0029,NULL,NULL,NULL,NULL),(19739,951,50,23.4111,NULL,NULL,NULL,NULL),(19740,951,55,23.8192,NULL,NULL,NULL,NULL),(19741,951,60,24.1691,NULL,NULL,NULL,NULL),(19742,951,65,24.4023,NULL,NULL,NULL,NULL),(19743,951,70,24.8396,NULL,NULL,NULL,NULL),(19744,951,71,25.1604,NULL,NULL,NULL,NULL),(19745,951,73,24.7813,NULL,NULL,NULL,NULL),(19746,951,75,24.898,NULL,NULL,NULL,NULL),(19747,951,77,24.8688,NULL,NULL,NULL,NULL),(19748,951,80,25.2478,NULL,NULL,NULL,NULL),(19749,951,85,25.1895,NULL,NULL,NULL,NULL),(19750,951,90,25.2478,NULL,NULL,NULL,NULL),(19751,951,91,25.1895,NULL,NULL,NULL,NULL),(19752,951,93,25.0729,NULL,NULL,NULL,NULL),(19753,951,95,24.9854,NULL,NULL,NULL,NULL),(19754,951,97,25.2187,NULL,NULL,NULL,NULL),(19755,951,100,25.1604,NULL,NULL,NULL,NULL),(19756,951,105,25.3353,NULL,NULL,NULL,NULL),(19757,951,110,25.656,NULL,NULL,NULL,NULL),(19758,951,115,25.7726,NULL,NULL,NULL,NULL),(19759,951,120,25.5102,NULL,NULL,NULL,NULL),(19760,951,121,25.4519,NULL,NULL,NULL,NULL),(19761,951,123,25.1895,NULL,NULL,NULL,NULL),(19762,951,125,25.3936,NULL,NULL,NULL,NULL),(19763,951,127,25.2478,NULL,NULL,NULL,NULL),(19764,951,130,25.3353,NULL,NULL,NULL,NULL),(19765,951,135,25.1895,NULL,NULL,NULL,NULL),(19766,951,140,25.3061,NULL,NULL,NULL,NULL),(19767,951,145,25.3353,NULL,NULL,NULL,NULL),(19768,951,150,25.1604,NULL,NULL,NULL,NULL),(19769,951,155,25.0437,NULL,NULL,NULL,NULL),(19770,951,160,25.0437,NULL,NULL,NULL,NULL),(19771,952,1,3.29609,NULL,NULL,NULL,NULL),(19772,952,3,5.83799,NULL,NULL,NULL,NULL),(19773,952,5,6.50838,NULL,NULL,NULL,NULL),(19774,952,7,7.40223,NULL,NULL,NULL,NULL),(19775,952,10,9.38548,NULL,NULL,NULL,NULL),(19776,952,15,11.0056,NULL,NULL,NULL,NULL),(19777,952,20,11.9553,NULL,NULL,NULL,NULL),(19778,952,25,12.933,NULL,NULL,NULL,NULL),(19779,952,30,15.3911,NULL,NULL,NULL,NULL),(19780,952,35,16.8994,NULL,NULL,NULL,NULL),(19781,952,40,17.5698,NULL,NULL,NULL,NULL),(19782,952,41,17.5419,NULL,NULL,NULL,NULL),(19783,952,43,17.1229,NULL,NULL,NULL,NULL),(19784,952,45,17.3743,NULL,NULL,NULL,NULL),(19785,952,47,17.5978,NULL,NULL,NULL,NULL),(19786,952,50,18.0447,NULL,NULL,NULL,NULL),(19787,952,55,17.905,NULL,NULL,NULL,NULL),(19788,952,60,18.0168,NULL,NULL,NULL,NULL),(19789,952,65,18.1564,NULL,NULL,NULL,NULL),(19790,952,70,18.1844,NULL,NULL,NULL,NULL),(19791,952,71,18.324,NULL,NULL,NULL,NULL),(19792,952,73,18.0447,NULL,NULL,NULL,NULL),(19793,952,75,17.9609,NULL,NULL,NULL,NULL),(19794,952,77,18.1006,NULL,NULL,NULL,NULL),(19795,952,80,18.1285,NULL,NULL,NULL,NULL),(19796,952,85,17.933,NULL,NULL,NULL,NULL),(19797,952,90,17.8212,NULL,NULL,NULL,NULL),(19798,952,91,17.7374,NULL,NULL,NULL,NULL),(19799,952,93,17.5978,NULL,NULL,NULL,NULL),(19800,952,95,17.6257,NULL,NULL,NULL,NULL),(19801,952,97,17.5698,NULL,NULL,NULL,NULL),(19802,952,100,17.6257,NULL,NULL,NULL,NULL),(19803,952,105,17.6536,NULL,NULL,NULL,NULL),(19804,952,110,17.514,NULL,NULL,NULL,NULL),(19805,952,115,17.486,NULL,NULL,NULL,NULL),(19806,952,120,17.2626,NULL,NULL,NULL,NULL),(19807,952,121,17.3464,NULL,NULL,NULL,NULL),(19808,952,123,17.2905,NULL,NULL,NULL,NULL),(19809,952,125,17.1788,NULL,NULL,NULL,NULL),(19810,952,127,17.1508,NULL,NULL,NULL,NULL),(19811,952,130,17.2067,NULL,NULL,NULL,NULL),(19812,952,135,17.095,NULL,NULL,NULL,NULL),(19813,952,140,17.067,NULL,NULL,NULL,NULL),(19814,952,145,17.095,NULL,NULL,NULL,NULL),(19815,952,150,16.9553,NULL,NULL,NULL,NULL),(19816,952,155,16.7318,NULL,NULL,NULL,NULL),(19817,952,160,16.6201,NULL,NULL,NULL,NULL),(19818,953,1,109.899,NULL,NULL,NULL,NULL),(19819,953,3,171.515,NULL,NULL,NULL,NULL),(19820,953,5,191.717,NULL,NULL,NULL,NULL),(19821,953,7,206.061,NULL,NULL,NULL,NULL),(19822,953,10,250.707,NULL,NULL,NULL,NULL),(19823,953,14,274.747,NULL,NULL,NULL,NULL),(19824,953,20,296.566,NULL,NULL,NULL,NULL),(19825,953,30,349.091,NULL,NULL,NULL,NULL),(19826,953,40,384.242,NULL,NULL,NULL,NULL),(19827,953,50,404.848,NULL,NULL,NULL,NULL),(19828,953,60,421.616,NULL,NULL,NULL,NULL),(19829,953,70,436.566,NULL,NULL,NULL,NULL),(19830,953,80,463.03,NULL,NULL,NULL,NULL),(19831,953,90,477.576,NULL,NULL,NULL,NULL),(19832,953,100,488.081,NULL,NULL,NULL,NULL),(19833,953,120,506.465,NULL,NULL,NULL,NULL),(19834,953,140,524.04,NULL,NULL,NULL,NULL),(19835,953,160,557.374,NULL,NULL,NULL,NULL),(19836,953,180,574.343,NULL,NULL,NULL,NULL),(19837,953,200,586.465,NULL,NULL,NULL,NULL),(19838,953,250,609.293,NULL,NULL,NULL,NULL),(19839,953,300,626.263,NULL,NULL,NULL,NULL),(19840,953,400,643.232,NULL,NULL,NULL,NULL),(19841,953,500,654.545,NULL,NULL,NULL,NULL),(19842,953,600,664.242,NULL,NULL,NULL,NULL),(19843,954,1,71.3499,NULL,NULL,NULL,NULL),(19844,954,3,99.0358,NULL,NULL,NULL,NULL),(19845,954,5,109.642,NULL,NULL,NULL,NULL),(19846,954,7,116.942,NULL,NULL,NULL,NULL),(19847,954,10,133.196,NULL,NULL,NULL,NULL),(19848,954,14,144.077,NULL,NULL,NULL,NULL),(19849,954,20,161.157,NULL,NULL,NULL,NULL),(19850,954,30,187.328,NULL,NULL,NULL,NULL),(19851,954,40,209.642,NULL,NULL,NULL,NULL),(19852,954,50,225.62,NULL,NULL,NULL,NULL),(19853,954,60,237.328,NULL,NULL,NULL,NULL),(19854,954,70,246.143,NULL,NULL,NULL,NULL),(19855,954,80,262.259,NULL,NULL,NULL,NULL),(19856,954,90,270.523,NULL,NULL,NULL,NULL),(19857,954,100,273.416,NULL,NULL,NULL,NULL),(19858,954,120,287.19,NULL,NULL,NULL,NULL),(19859,954,140,299.725,NULL,NULL,NULL,NULL),(19860,954,160,317.08,NULL,NULL,NULL,NULL),(19861,954,180,326.446,NULL,NULL,NULL,NULL),(19862,954,200,333.747,NULL,NULL,NULL,NULL),(19863,954,250,348.623,NULL,NULL,NULL,NULL),(19864,954,300,357.163,NULL,NULL,NULL,NULL),(19865,954,400,365.152,NULL,NULL,NULL,NULL),(19866,954,500,373.278,NULL,NULL,NULL,NULL),(19867,954,600,386.226,NULL,NULL,NULL,NULL),(19868,955,1,52.6024,NULL,NULL,NULL,NULL),(19869,955,3,66.3344,NULL,NULL,NULL,NULL),(19870,955,5,71.2071,NULL,NULL,NULL,NULL),(19871,955,7,77.1872,NULL,NULL,NULL,NULL),(19872,955,10,85.4928,NULL,NULL,NULL,NULL),(19873,955,14,94.5736,NULL,NULL,NULL,NULL),(19874,955,20,105.537,NULL,NULL,NULL,NULL),(19875,955,30,123.588,NULL,NULL,NULL,NULL),(19876,955,40,139.203,NULL,NULL,NULL,NULL),(19877,955,50,147.065,NULL,NULL,NULL,NULL),(19878,955,60,154.817,NULL,NULL,NULL,NULL),(19879,955,70,160.576,NULL,NULL,NULL,NULL),(19880,955,80,172.536,NULL,NULL,NULL,NULL),(19881,955,90,178.405,NULL,NULL,NULL,NULL),(19882,955,100,182.724,NULL,NULL,NULL,NULL),(19883,955,120,190.033,NULL,NULL,NULL,NULL),(19884,955,140,200.111,NULL,NULL,NULL,NULL),(19885,955,160,210.188,NULL,NULL,NULL,NULL),(19886,955,180,215.725,NULL,NULL,NULL,NULL),(19887,955,200,220.598,NULL,NULL,NULL,NULL),(19888,955,250,229.457,NULL,NULL,NULL,NULL),(19889,955,300,234.662,NULL,NULL,NULL,NULL),(19890,955,400,243.522,NULL,NULL,NULL,NULL),(19891,955,500,249.723,NULL,NULL,NULL,NULL),(19892,955,600,255.482,NULL,NULL,NULL,NULL),(19893,956,1,40.9709,NULL,NULL,NULL,NULL),(19894,956,3,50.0971,NULL,NULL,NULL,NULL),(19895,956,5,56.0194,NULL,NULL,NULL,NULL),(19896,956,7,60.3883,NULL,NULL,NULL,NULL),(19897,956,10,67.1845,NULL,NULL,NULL,NULL),(19898,956,14,75.3398,NULL,NULL,NULL,NULL),(19899,956,20,82.233,NULL,NULL,NULL,NULL),(19900,956,30,94.0777,NULL,NULL,NULL,NULL),(19901,956,40,103.883,NULL,NULL,NULL,NULL),(19902,956,50,109.029,NULL,NULL,NULL,NULL),(19903,956,60,115.534,NULL,NULL,NULL,NULL),(19904,956,70,119.417,NULL,NULL,NULL,NULL),(19905,956,80,125.728,NULL,NULL,NULL,NULL),(19906,956,90,130.097,NULL,NULL,NULL,NULL),(19907,956,100,133.204,NULL,NULL,NULL,NULL),(19908,956,120,141.942,NULL,NULL,NULL,NULL),(19909,956,140,147.961,NULL,NULL,NULL,NULL),(19910,956,160,156.019,NULL,NULL,NULL,NULL),(19911,956,180,161.359,NULL,NULL,NULL,NULL),(19912,956,200,165.243,NULL,NULL,NULL,NULL),(19913,956,250,169.612,NULL,NULL,NULL,NULL),(19914,956,300,173.107,NULL,NULL,NULL,NULL),(19915,956,400,179.029,NULL,NULL,NULL,NULL),(19916,956,500,184.757,NULL,NULL,NULL,NULL),(19917,957,1,36.2617,NULL,NULL,NULL,NULL),(19918,957,3,45.514,NULL,NULL,NULL,NULL),(19919,957,5,49.6262,NULL,NULL,NULL,NULL),(19920,957,7,51.5888,NULL,NULL,NULL,NULL),(19921,957,10,58.0374,NULL,NULL,NULL,NULL),(19922,957,14,64.3925,NULL,NULL,NULL,NULL),(19923,957,20,69.0654,NULL,NULL,NULL,NULL),(19924,957,30,77.9439,NULL,NULL,NULL,NULL),(19925,957,40,82.3364,NULL,NULL,NULL,NULL),(19926,957,50,87.8505,NULL,NULL,NULL,NULL),(19927,957,60,91.7757,NULL,NULL,NULL,NULL),(19928,957,70,92.4299,NULL,NULL,NULL,NULL),(19929,957,80,99.8131,NULL,NULL,NULL,NULL),(19930,957,90,102.617,NULL,NULL,NULL,NULL),(19931,957,100,104.579,NULL,NULL,NULL,NULL),(19932,957,120,109.533,NULL,NULL,NULL,NULL),(19933,957,140,113.364,NULL,NULL,NULL,NULL),(19934,957,160,115.794,NULL,NULL,NULL,NULL),(19935,957,180,118.131,NULL,NULL,NULL,NULL),(19936,957,200,120.374,NULL,NULL,NULL,NULL),(19937,957,250,122.617,NULL,NULL,NULL,NULL),(19938,957,300,126.262,NULL,NULL,NULL,NULL),(19939,957,400,132.804,NULL,NULL,NULL,NULL),(19940,957,500,136.542,NULL,NULL,NULL,NULL),(19941,958,2.1,91.9388,NULL,NULL,NULL,NULL),(19942,958,3.1,90.5102,NULL,NULL,NULL,NULL),(19943,958,4.3,96.0204,NULL,NULL,NULL,NULL),(19944,958,5.3,101.429,NULL,NULL,NULL,NULL),(19945,958,7.4,102.551,NULL,NULL,NULL,NULL),(19946,958,9.3,106.531,NULL,NULL,NULL,NULL),(19947,958,14.4,107.857,NULL,NULL,NULL,NULL),(19948,958,20.6,108.469,NULL,NULL,NULL,NULL),(19949,958,30.9,115.816,NULL,NULL,NULL,NULL),(19950,958,41,122.143,NULL,NULL,NULL,NULL),(19951,958,52.5,123.98,NULL,NULL,NULL,NULL),(19952,958,63.1,124.796,NULL,NULL,NULL,NULL),(19953,958,74.1,126.122,NULL,NULL,NULL,NULL),(19954,958,82.4,133.469,NULL,NULL,NULL,NULL),(19955,958,95.8,134.388,NULL,NULL,NULL,NULL),(19956,958,105.6,135.714,NULL,NULL,NULL,NULL),(19957,958,138.6,137.857,NULL,NULL,NULL,NULL),(19958,958,169.3,139.796,NULL,NULL,NULL,NULL),(19959,958,188.3,137.755,NULL,NULL,NULL,NULL),(19960,958,210.8,138.98,NULL,NULL,NULL,NULL),(19961,958,251.6,139.388,NULL,NULL,NULL,NULL),(19962,958,295.5,139.898,NULL,NULL,NULL,NULL),(19963,958,328.6,141.531,NULL,NULL,NULL,NULL),(19964,958,361.9,142.857,NULL,NULL,NULL,NULL),(19965,958,374.9,140.306,NULL,NULL,NULL,NULL),(19966,958,399.8,142.245,NULL,NULL,NULL,NULL),(19967,959,3.2,53.2653,NULL,NULL,NULL,NULL),(19968,959,4.3,65.102,NULL,NULL,NULL,NULL),(19969,959,5.2,64.1837,NULL,NULL,NULL,NULL),(19970,959,7.4,69.898,NULL,NULL,NULL,NULL),(19971,959,10,73.7755,NULL,NULL,NULL,NULL),(19972,959,15,82.2449,NULL,NULL,NULL,NULL),(19973,959,20.2,88.0612,NULL,NULL,NULL,NULL),(19974,959,30.6,93.7755,NULL,NULL,NULL,NULL),(19975,959,40.2,86.0204,NULL,NULL,NULL,NULL),(19976,959,51.8,94.4898,NULL,NULL,NULL,NULL),(19977,959,62.3,96.5306,NULL,NULL,NULL,NULL),(19978,959,72.6,96.4286,NULL,NULL,NULL,NULL),(19979,959,84.4,96.6327,NULL,NULL,NULL,NULL),(19980,959,94.5,96.5306,NULL,NULL,NULL,NULL),(19981,959,102.9,96.8367,NULL,NULL,NULL,NULL),(19982,959,117.5,96.2245,NULL,NULL,NULL,NULL),(19983,959,146.9,96.7347,NULL,NULL,NULL,NULL),(19984,959,180.5,96.4286,NULL,NULL,NULL,NULL),(19985,959,206.7,97.6531,NULL,NULL,NULL,NULL),(19986,959,228.4,97.1429,NULL,NULL,NULL,NULL),(19987,960,2.1,50.5102,NULL,NULL,NULL,NULL),(19988,960,3,55,NULL,NULL,NULL,NULL),(19989,960,4.2,52.1429,NULL,NULL,NULL,NULL),(19990,960,5.2,51.7347,NULL,NULL,NULL,NULL),(19991,960,7.1,59.1837,NULL,NULL,NULL,NULL),(19992,960,10.3,64.0816,NULL,NULL,NULL,NULL),(19993,960,15,66.4286,NULL,NULL,NULL,NULL),(19994,960,20.4,67.9592,NULL,NULL,NULL,NULL),(19995,960,30.7,73.4694,NULL,NULL,NULL,NULL),(19996,960,41.5,79.0816,NULL,NULL,NULL,NULL),(19997,960,51.3,80.5102,NULL,NULL,NULL,NULL),(19998,960,62.9,81.0204,NULL,NULL,NULL,NULL),(19999,960,72.6,81.3265,NULL,NULL,NULL,NULL),(20000,960,82.1,87.3469,NULL,NULL,NULL,NULL),(20001,960,93.9,87.3469,NULL,NULL,NULL,NULL),(20002,960,104.9,89.4898,NULL,NULL,NULL,NULL),(20003,960,115.6,89.5918,NULL,NULL,NULL,NULL),(20004,960,135,92.0408,NULL,NULL,NULL,NULL),(20005,960,154.7,95.8163,NULL,NULL,NULL,NULL),(20006,960,166.6,95.2041,NULL,NULL,NULL,NULL),(20007,960,187.7,93.7755,NULL,NULL,NULL,NULL),(20008,960,208.7,94.6939,NULL,NULL,NULL,NULL),(20009,960,230.6,94.3878,NULL,NULL,NULL,NULL),(20010,960,248.4,95.5102,NULL,NULL,NULL,NULL),(20011,960,266.6,97.9592,NULL,NULL,NULL,NULL),(20012,960,291.7,98.7755,NULL,NULL,NULL,NULL),(20013,960,331.8,97.6531,NULL,NULL,NULL,NULL),(20014,961,2,2.70408,NULL,NULL,NULL,NULL),(20015,961,3,3.16327,NULL,NULL,NULL,NULL),(20016,961,4,3.88776,NULL,NULL,NULL,NULL),(20017,961,5,4.42857,NULL,NULL,NULL,NULL),(20018,961,6.1,5.15306,NULL,NULL,NULL,NULL),(20019,961,9.9,5.96939,NULL,NULL,NULL,NULL),(20020,961,14.8,7.14286,NULL,NULL,NULL,NULL),(20021,961,19.7,8.13265,NULL,NULL,NULL,NULL),(20022,961,29.8,9.94898,NULL,NULL,NULL,NULL),(20023,961,39.7,12.551,NULL,NULL,NULL,NULL),(20024,961,50.5,13.6735,NULL,NULL,NULL,NULL),(20025,961,60.9,17.8571,NULL,NULL,NULL,NULL),(20026,961,70.7,19.7959,NULL,NULL,NULL,NULL),(20027,961,81.1,20.102,NULL,NULL,NULL,NULL),(20028,961,91.7,22.2449,NULL,NULL,NULL,NULL),(20029,961,101.6,22.1429,NULL,NULL,NULL,NULL),(20030,961,112.7,24.1837,NULL,NULL,NULL,NULL),(20031,961,133.7,28.5714,NULL,NULL,NULL,NULL),(20032,961,144.1,29.1837,NULL,NULL,NULL,NULL),(20033,961,154.7,30.5102,NULL,NULL,NULL,NULL),(20034,961,174.8,32.551,NULL,NULL,NULL,NULL),(20035,961,203.4,34.3878,NULL,NULL,NULL,NULL),(20036,961,239,36.1224,NULL,NULL,NULL,NULL),(20037,961,281.6,38.5714,NULL,NULL,NULL,NULL),(20038,961,306.1,41.1224,NULL,NULL,NULL,NULL),(20039,961,324.4,41.7347,NULL,NULL,NULL,NULL),(20040,961,367.7,42.449,NULL,NULL,NULL,NULL),(20041,961,402.3,44.2857,NULL,NULL,NULL,NULL),(20042,961,444.5,46.8367,NULL,NULL,NULL,NULL),(20043,961,477,47.0408,NULL,NULL,NULL,NULL),(20044,962,1,32.068,NULL,NULL,NULL,NULL),(20045,962,2,34.1769,NULL,NULL,NULL,NULL),(20046,962,3,35.0204,NULL,NULL,NULL,NULL),(20047,962,3.9,35.415,NULL,NULL,NULL,NULL),(20048,962,4.9,35.9592,NULL,NULL,NULL,NULL),(20049,962,6,36.2449,NULL,NULL,NULL,NULL),(20050,962,7,36.7483,NULL,NULL,NULL,NULL),(20051,962,8,37.5238,NULL,NULL,NULL,NULL),(20052,962,8.9,38.0272,NULL,NULL,NULL,NULL),(20053,962,15,39.1429,NULL,NULL,NULL,NULL),(20054,962,19.9,40.2041,NULL,NULL,NULL,NULL),(20055,962,29.8,42.2993,NULL,NULL,NULL,NULL),(20056,962,40.3,44.4762,NULL,NULL,NULL,NULL),(20057,962,49.8,45.619,NULL,NULL,NULL,NULL),(20058,962,59.3,49.619,NULL,NULL,NULL,NULL),(20059,962,74.1,52.2993,NULL,NULL,NULL,NULL),(20060,962,80.8,52.0816,NULL,NULL,NULL,NULL),(20061,962,94.8,55.2109,NULL,NULL,NULL,NULL),(20062,962,149.9,61.9048,NULL,NULL,NULL,NULL),(20063,962,200.3,65.2517,NULL,NULL,NULL,NULL),(20064,962,290.2,71.619,NULL,NULL,NULL,NULL),(20065,962,310.1,72.5442,NULL,NULL,NULL,NULL),(20066,962,398.1,74.8571,NULL,NULL,NULL,NULL),(20067,962,494.5,78.6803,NULL,NULL,NULL,NULL),(20068,963,1,42.2449,NULL,NULL,NULL,NULL),(20069,963,2,42.8707,NULL,NULL,NULL,NULL),(20070,963,3,42.9388,NULL,NULL,NULL,NULL),(20071,963,4,43.3333,NULL,NULL,NULL,NULL),(20072,963,5,43.102,NULL,NULL,NULL,NULL),(20073,963,6,43.2109,NULL,NULL,NULL,NULL),(20074,963,6.9,43.3878,NULL,NULL,NULL,NULL),(20075,963,8,43.7959,NULL,NULL,NULL,NULL),(20076,963,9,43.9592,NULL,NULL,NULL,NULL),(20077,963,12.9,43.7959,NULL,NULL,NULL,NULL),(20078,963,19.8,43.6735,NULL,NULL,NULL,NULL),(20079,963,29.7,44.1361,NULL,NULL,NULL,NULL),(20080,963,38.8,43.9592,NULL,NULL,NULL,NULL),(20081,963,49.6,44.068,NULL,NULL,NULL,NULL),(20082,963,59.9,45.3333,NULL,NULL,NULL,NULL),(20083,963,73.2,45.4422,NULL,NULL,NULL,NULL),(20084,963,81.3,45.3333,NULL,NULL,NULL,NULL),(20085,963,95.7,46.3673,NULL,NULL,NULL,NULL),(20086,963,109.1,46.1905,NULL,NULL,NULL,NULL),(20087,963,116.6,43.9592,NULL,NULL,NULL,NULL),(20088,963,121.3,49.5646,NULL,NULL,NULL,NULL),(20089,963,129.2,50.1905,NULL,NULL,NULL,NULL),(20090,963,150.8,50.4218,NULL,NULL,NULL,NULL),(20091,963,202.1,50.2449,NULL,NULL,NULL,NULL),(20092,963,245.2,50.4218,NULL,NULL,NULL,NULL),(20093,963,270.8,52.0816,NULL,NULL,NULL,NULL),(20094,963,295.5,52.9932,NULL,NULL,NULL,NULL),(20095,963,324.5,50.3129,NULL,NULL,NULL,NULL),(20096,963,349.8,49.3333,NULL,NULL,NULL,NULL),(20097,963,399.4,50.1905,NULL,NULL,NULL,NULL),(20098,963,429.3,51.5646,NULL,NULL,NULL,NULL),(20099,963,477,50.4218,NULL,NULL,NULL,NULL),(20100,963,522.4,51.8503,NULL,NULL,NULL,NULL),(20101,964,1,58,NULL,NULL,NULL,NULL),(20102,964,2,58.7891,NULL,NULL,NULL,NULL),(20103,964,3,58.5578,NULL,NULL,NULL,NULL),(20104,964,4,58.6122,NULL,NULL,NULL,NULL),(20105,964,4.9,58.6803,NULL,NULL,NULL,NULL),(20106,964,6,58.5578,NULL,NULL,NULL,NULL),(20107,964,7,58.6122,NULL,NULL,NULL,NULL),(20108,964,8,58.6803,NULL,NULL,NULL,NULL),(20109,964,9,59.0748,NULL,NULL,NULL,NULL),(20110,964,13,58.6122,NULL,NULL,NULL,NULL),(20111,964,19.9,58.7347,NULL,NULL,NULL,NULL),(20112,964,29.8,59.2381,NULL,NULL,NULL,NULL),(20113,964,40,60.6531,NULL,NULL,NULL,NULL),(20114,964,49.9,60.8299,NULL,NULL,NULL,NULL),(20115,964,53.1,61.0612,NULL,NULL,NULL,NULL),(20116,964,53.6,63.3741,NULL,NULL,NULL,NULL),(20117,964,59.4,63.8912,NULL,NULL,NULL,NULL),(20118,964,63.4,64.1225,NULL,NULL,NULL,NULL),(20119,964,74.8,62.8707,NULL,NULL,NULL,NULL),(20120,964,87.8,63.3197,NULL,NULL,NULL,NULL),(20121,964,93.7,63.3741,NULL,NULL,NULL,NULL),(20122,964,108.1,64.8027,NULL,NULL,NULL,NULL),(20123,964,108.8,73.4694,NULL,NULL,NULL,NULL),(20124,964,130.1,69.7007,NULL,NULL,NULL,NULL),(20125,964,150.3,69.4694,NULL,NULL,NULL,NULL),(20126,964,199,71.619,NULL,NULL,NULL,NULL),(20127,964,247.4,71.4422,NULL,NULL,NULL,NULL),(20128,964,294.6,73.8095,NULL,NULL,NULL,NULL),(20129,964,345.6,70.8708,NULL,NULL,NULL,NULL),(20130,964,394.6,71.4966,NULL,NULL,NULL,NULL),(20131,964,439.7,74.1633,NULL,NULL,NULL,NULL),(20132,964,450.5,71.619,NULL,NULL,NULL,NULL),(20133,964,508.3,72.3673,NULL,NULL,NULL,NULL),(20134,965,0.5,0,NULL,NULL,NULL,NULL),(20135,965,1.9,17.3469,NULL,NULL,NULL,NULL),(20136,965,6,26.5306,NULL,NULL,NULL,NULL),(20137,965,8,30.6122,NULL,NULL,NULL,NULL),(20138,965,9.8,34.6939,NULL,NULL,NULL,NULL),(20139,965,12.1,38.7755,NULL,NULL,NULL,NULL),(20140,965,13.9,43.8776,NULL,NULL,NULL,NULL),(20141,965,16,47.9592,NULL,NULL,NULL,NULL),(20142,965,18,47.9592,NULL,NULL,NULL,NULL),(20143,965,20.1,52.0408,NULL,NULL,NULL,NULL),(20144,965,22.1,57.1429,NULL,NULL,NULL,NULL),(20145,965,23.9,57.1429,NULL,NULL,NULL,NULL),(20146,965,26,57.1429,NULL,NULL,NULL,NULL),(20147,965,28,61.2245,NULL,NULL,NULL,NULL),(20148,965,30,61.2245,NULL,NULL,NULL,NULL),(20149,965,32.1,61.2245,NULL,NULL,NULL,NULL),(20150,965,34.1,65.3061,NULL,NULL,NULL,NULL),(20151,965,36.2,65.3061,NULL,NULL,NULL,NULL),(20152,965,37.9,65.3061,NULL,NULL,NULL,NULL),(20153,965,40,65.3061,NULL,NULL,NULL,NULL),(20154,965,42,65.3061,NULL,NULL,NULL,NULL),(20155,965,44.1,65.3061,NULL,NULL,NULL,NULL),(20156,965,46.1,69.3878,NULL,NULL,NULL,NULL),(20157,965,48.1,69.3878,NULL,NULL,NULL,NULL),(20158,965,49.9,69.3878,NULL,NULL,NULL,NULL),(20159,965,52,69.3878,NULL,NULL,NULL,NULL),(20160,965,54,69.3878,NULL,NULL,NULL,NULL),(20161,965,56.1,69.3878,NULL,NULL,NULL,NULL),(20162,965,58,69.3878,NULL,NULL,NULL,NULL),(20163,965,59.9,69.3878,NULL,NULL,NULL,NULL),(20164,965,62.1,69.3878,NULL,NULL,NULL,NULL),(20165,965,64.1,74.4898,NULL,NULL,NULL,NULL),(20166,965,66,74.4898,NULL,NULL,NULL,NULL),(20167,965,68.1,74.4898,NULL,NULL,NULL,NULL),(20168,965,69.8,78.5714,NULL,NULL,NULL,NULL),(20169,965,72.4,78.5714,NULL,NULL,NULL,NULL),(20170,965,75.9,86.7347,NULL,NULL,NULL,NULL),(20171,965,79.5,86.7347,NULL,NULL,NULL,NULL),(20172,965,82.6,91.8367,NULL,NULL,NULL,NULL),(20173,965,86.4,91.8367,NULL,NULL,NULL,NULL),(20174,965,89.2,100,NULL,NULL,NULL,NULL),(20175,965,94.3,100,NULL,NULL,NULL,NULL),(20176,965,97.4,105.102,NULL,NULL,NULL,NULL),(20177,965,100.7,109.184,NULL,NULL,NULL,NULL),(20178,965,106.1,109.184,NULL,NULL,NULL,NULL),(20179,965,114.5,113.265,NULL,NULL,NULL,NULL),(20180,965,120.9,122.449,NULL,NULL,NULL,NULL),(20181,965,128.3,126.531,NULL,NULL,NULL,NULL),(20182,965,134.9,126.531,NULL,NULL,NULL,NULL),(20183,965,141.8,130.612,NULL,NULL,NULL,NULL),(20184,965,148.4,134.694,NULL,NULL,NULL,NULL),(20185,965,156.1,139.796,NULL,NULL,NULL,NULL),(20186,965,161.2,139.796,NULL,NULL,NULL,NULL),(20187,965,174.9,147.959,NULL,NULL,NULL,NULL),(20188,966,0.2,0,NULL,NULL,NULL,NULL),(20189,966,2.1,21.4286,NULL,NULL,NULL,NULL),(20190,966,4.9,25.5102,NULL,NULL,NULL,NULL),(20191,966,7,29.5918,NULL,NULL,NULL,NULL),(20192,966,9.8,33.6735,NULL,NULL,NULL,NULL),(20193,966,10.6,33.6735,NULL,NULL,NULL,NULL),(20194,966,13.7,41.8367,NULL,NULL,NULL,NULL),(20195,966,17.2,41.8367,NULL,NULL,NULL,NULL),(20196,966,19.8,45.9184,NULL,NULL,NULL,NULL),(20197,966,22.9,51.0204,NULL,NULL,NULL,NULL),(20198,966,25.9,51.0204,NULL,NULL,NULL,NULL),(20199,966,29,55.102,NULL,NULL,NULL,NULL),(20200,966,30.3,55.102,NULL,NULL,NULL,NULL),(20201,966,33.1,55.102,NULL,NULL,NULL,NULL),(20202,966,34.9,55.102,NULL,NULL,NULL,NULL),(20203,966,36.9,55.102,NULL,NULL,NULL,NULL),(20204,966,40.7,59.1837,NULL,NULL,NULL,NULL),(20205,966,44.5,59.1837,NULL,NULL,NULL,NULL),(20206,966,47.3,59.1837,NULL,NULL,NULL,NULL),(20207,966,51.7,59.1837,NULL,NULL,NULL,NULL),(20208,966,54.2,59.1837,NULL,NULL,NULL,NULL),(20209,966,56.8,63.2653,NULL,NULL,NULL,NULL),(20210,966,62.1,63.2653,NULL,NULL,NULL,NULL),(20211,966,65.2,63.2653,NULL,NULL,NULL,NULL),(20212,966,70.5,67.3469,NULL,NULL,NULL,NULL),(20213,966,72.8,71.4286,NULL,NULL,NULL,NULL),(20214,966,75.4,71.4286,NULL,NULL,NULL,NULL),(20215,966,77.4,75.5102,NULL,NULL,NULL,NULL),(20216,966,80,75.5102,NULL,NULL,NULL,NULL),(20217,966,82.8,80.6122,NULL,NULL,NULL,NULL),(20218,966,86.9,80.6122,NULL,NULL,NULL,NULL),(20219,966,91,88.7755,NULL,NULL,NULL,NULL),(20220,966,94.3,84.6939,NULL,NULL,NULL,NULL),(20221,966,97.9,92.8571,NULL,NULL,NULL,NULL),(20222,966,100.9,92.8571,NULL,NULL,NULL,NULL),(20223,966,105.8,92.8571,NULL,NULL,NULL,NULL),(20224,966,113.7,96.9388,NULL,NULL,NULL,NULL),(20225,966,120.8,101.02,NULL,NULL,NULL,NULL),(20226,966,128.2,105.102,NULL,NULL,NULL,NULL),(20227,966,134.3,105.102,NULL,NULL,NULL,NULL),(20228,966,141.4,105.102,NULL,NULL,NULL,NULL),(20229,966,148.8,109.184,NULL,NULL,NULL,NULL),(20230,966,155.2,114.286,NULL,NULL,NULL,NULL),(20231,966,161.8,114.286,NULL,NULL,NULL,NULL),(20232,966,175.1,118.367,NULL,NULL,NULL,NULL),(20233,967,1.3,11.2245,NULL,NULL,NULL,NULL),(20234,967,5.4,22.449,NULL,NULL,NULL,NULL),(20235,967,7,22.449,NULL,NULL,NULL,NULL),(20236,967,9.5,26.5306,NULL,NULL,NULL,NULL),(20237,967,13.1,29.5918,NULL,NULL,NULL,NULL),(20238,967,15.4,33.6735,NULL,NULL,NULL,NULL),(20239,967,19.3,33.6735,NULL,NULL,NULL,NULL),(20240,967,22.6,36.7347,NULL,NULL,NULL,NULL),(20241,967,25.4,40.8163,NULL,NULL,NULL,NULL),(20242,967,29.7,40.8163,NULL,NULL,NULL,NULL),(20243,967,32.8,40.8163,NULL,NULL,NULL,NULL),(20244,967,35.6,40.8163,NULL,NULL,NULL,NULL),(20245,967,38.9,44.898,NULL,NULL,NULL,NULL),(20246,967,42.7,44.898,NULL,NULL,NULL,NULL),(20247,967,45,44.898,NULL,NULL,NULL,NULL),(20248,967,47.1,44.898,NULL,NULL,NULL,NULL),(20249,967,52.7,47.9592,NULL,NULL,NULL,NULL),(20250,967,56.5,47.9592,NULL,NULL,NULL,NULL),(20251,967,62.1,47.9592,NULL,NULL,NULL,NULL),(20252,967,67.4,52.0408,NULL,NULL,NULL,NULL),(20253,967,69.7,52.0408,NULL,NULL,NULL,NULL),(20254,967,72.5,52.0408,NULL,NULL,NULL,NULL),(20255,967,75.9,56.1224,NULL,NULL,NULL,NULL),(20256,967,77.6,56.1224,NULL,NULL,NULL,NULL),(20257,967,79.4,56.1224,NULL,NULL,NULL,NULL),(20258,967,83,59.1837,NULL,NULL,NULL,NULL),(20259,967,86.6,59.1837,NULL,NULL,NULL,NULL),(20260,967,90.9,63.2653,NULL,NULL,NULL,NULL),(20261,967,94.2,63.2653,NULL,NULL,NULL,NULL),(20262,967,98.1,67.3469,NULL,NULL,NULL,NULL),(20263,967,101.1,67.3469,NULL,NULL,NULL,NULL),(20264,967,105.9,67.3469,NULL,NULL,NULL,NULL),(20265,967,114.1,70.4082,NULL,NULL,NULL,NULL),(20266,967,121.2,74.4898,NULL,NULL,NULL,NULL),(20267,967,127.4,74.4898,NULL,NULL,NULL,NULL),(20268,967,134.5,78.5714,NULL,NULL,NULL,NULL),(20269,967,142.1,78.5714,NULL,NULL,NULL,NULL),(20270,967,148.8,81.6327,NULL,NULL,NULL,NULL),(20271,967,155.4,81.6327,NULL,NULL,NULL,NULL),(20272,967,161.5,81.6327,NULL,NULL,NULL,NULL),(20273,967,174.7,85.7143,NULL,NULL,NULL,NULL),(20274,968,0,40.8277,NULL,NULL,NULL,NULL),(20275,968,0.2,45.7143,NULL,NULL,NULL,NULL),(20276,968,0.4,47.415,NULL,NULL,NULL,NULL),(20277,968,0.9,48.39,NULL,NULL,NULL,NULL),(20278,968,1.3,49.1043,NULL,NULL,NULL,NULL),(20279,968,1.9,50.0794,NULL,NULL,NULL,NULL),(20280,968,2.3,50.7937,NULL,NULL,NULL,NULL),(20281,968,2.7,51.2698,NULL,NULL,NULL,NULL),(20282,968,3.2,51.9955,NULL,NULL,NULL,NULL),(20283,968,3.8,52.4717,NULL,NULL,NULL,NULL),(20284,968,4.3,52.9478,NULL,NULL,NULL,NULL),(20285,968,4.8,53.1746,NULL,NULL,NULL,NULL),(20286,968,5.3,53.6621,NULL,NULL,NULL,NULL),(20287,968,5.9,53.4014,NULL,NULL,NULL,NULL),(20288,968,6.7,54.6032,NULL,NULL,NULL,NULL),(20289,968,7.3,54.5805,NULL,NULL,NULL,NULL),(20290,968,7.9,54.8186,NULL,NULL,NULL,NULL),(20291,968,8.3,55.2948,NULL,NULL,NULL,NULL),(20292,968,8.8,55.2834,NULL,NULL,NULL,NULL),(20293,968,9.2,55.7596,NULL,NULL,NULL,NULL),(20294,968,9.8,56.2358,NULL,NULL,NULL,NULL),(20295,968,10.4,56.2245,NULL,NULL,NULL,NULL),(20296,968,10.8,56.4512,NULL,NULL,NULL,NULL),(20297,968,11.3,56.4399,NULL,NULL,NULL,NULL),(20298,968,11.9,56.9161,NULL,NULL,NULL,NULL),(20299,968,12.8,56.8934,NULL,NULL,NULL,NULL),(20300,968,13.7,57.1202,NULL,NULL,NULL,NULL),(20301,968,14.3,57.3469,NULL,NULL,NULL,NULL),(20302,968,14.8,57.8231,NULL,NULL,NULL,NULL),(20303,968,15.5,57.8118,NULL,NULL,NULL,NULL),(20304,968,16.8,58.2653,NULL,NULL,NULL,NULL),(20305,968,17.3,58.254,NULL,NULL,NULL,NULL),(20306,968,17.8,58.2426,NULL,NULL,NULL,NULL),(20307,968,18.4,58.4694,NULL,NULL,NULL,NULL),(20308,968,19.1,58.9456,NULL,NULL,NULL,NULL),(20309,968,19.8,59.4104,NULL,NULL,NULL,NULL),(20310,968,20.3,58.9116,NULL,NULL,NULL,NULL),(20311,968,20.8,59.6372,NULL,NULL,NULL,NULL),(20312,968,21.3,59.6259,NULL,NULL,NULL,NULL),(20313,968,21.8,59.6145,NULL,NULL,NULL,NULL),(20314,968,22.4,59.5918,NULL,NULL,NULL,NULL),(20315,968,22.8,60.3175,NULL,NULL,NULL,NULL),(20316,968,23.3,60.0567,NULL,NULL,NULL,NULL),(20317,968,23.9,60.0454,NULL,NULL,NULL,NULL),(20318,968,24.8,60.7596,NULL,NULL,NULL,NULL),(20319,968,25.3,60.9977,NULL,NULL,NULL,NULL),(20320,968,25.7,61.4739,NULL,NULL,NULL,NULL),(20321,968,26.3,61.2132,NULL,NULL,NULL,NULL),(20322,968,26.8,61.4399,NULL,NULL,NULL,NULL),(20323,968,27.3,61.9161,NULL,NULL,NULL,NULL),(20324,968,27.9,61.6667,NULL,NULL,NULL,NULL),(20325,968,28.4,62.1429,NULL,NULL,NULL,NULL),(20326,968,28.9,62.3696,NULL,NULL,NULL,NULL),(20327,968,29.3,62.3583,NULL,NULL,NULL,NULL),(20328,968,29.7,62.3469,NULL,NULL,NULL,NULL),(20329,968,30.3,62.3356,NULL,NULL,NULL,NULL),(20330,968,30.7,62.3243,NULL,NULL,NULL,NULL),(20331,968,31.3,62.3129,NULL,NULL,NULL,NULL),(20332,968,31.8,62.0522,NULL,NULL,NULL,NULL),(20333,968,32.3,62.2902,NULL,NULL,NULL,NULL),(20334,968,32.9,62.2676,NULL,NULL,NULL,NULL),(20335,968,33.3,62.2562,NULL,NULL,NULL,NULL),(20336,968,33.8,62.4943,NULL,NULL,NULL,NULL),(20337,968,34.4,62.483,NULL,NULL,NULL,NULL),(20338,968,34.6,61.9841,NULL,NULL,NULL,NULL),(20339,968,34.9,63.4467,NULL,NULL,NULL,NULL),(20340,968,35.3,63.1859,NULL,NULL,NULL,NULL),(20341,968,35.8,62.9365,NULL,NULL,NULL,NULL),(20342,968,36.3,62.6757,NULL,NULL,NULL,NULL),(20343,968,36.8,62.9138,NULL,NULL,NULL,NULL),(20344,968,37.3,62.9025,NULL,NULL,NULL,NULL),(20345,968,37.7,62.8912,NULL,NULL,NULL,NULL),(20346,968,38.8,63.5941,NULL,NULL,NULL,NULL),(20347,968,38.9,45.9864,NULL,1,NULL,NULL),(20348,968,39,43.7868,NULL,1,NULL,NULL),(20349,968,39.5,42.8005,NULL,1,NULL,NULL),(20350,968,40.3,41.5533,NULL,1,NULL,NULL),(20351,968,40.8,41.542,NULL,1,NULL,NULL),(20352,968,40.9,42.2676,NULL,1,NULL,NULL),(20353,968,41.2,41.2925,NULL,1,NULL,NULL),(20354,968,41.8,41.2698,NULL,1,NULL,NULL),(20355,968,42.4,40.2834,NULL,1,NULL,NULL),(20356,968,42.8,41.0091,NULL,1,NULL,NULL),(20357,968,43.3,40.2608,NULL,1,NULL,NULL),(20358,968,43.8,40.4875,NULL,1,NULL,NULL),(20359,968,44.4,40.2381,NULL,1,NULL,NULL),(20360,968,44.8,39.9773,NULL,1,NULL,NULL),(20361,968,45.2,38.9909,NULL,1,NULL,NULL),(20362,968,45.8,40.1927,NULL,1,NULL,NULL),(20363,968,46,40.9297,NULL,1,NULL,NULL),(20364,968,46.3,39.2063,NULL,1,NULL,NULL),(20365,968,46.8,39.932,NULL,1,NULL,NULL),(20366,968,47.3,38.6961,NULL,1,NULL,NULL),(20367,968,47.8,39.4104,NULL,1,NULL,NULL),(20368,968,48.4,38.424,NULL,1,NULL,NULL),(20369,968,48.8,39.6372,NULL,1,NULL,NULL),(20370,968,49.3,38.8889,NULL,1,NULL,NULL),(20371,968,50.2,37.8912,NULL,1,NULL,NULL),(20372,968,50.8,38.6054,NULL,1,NULL,NULL),(20373,968,51.2,37.8685,NULL,1,NULL,NULL),(20374,968,51.9,37.8458,NULL,1,NULL,NULL),(20375,969,0,25.1814,NULL,NULL,NULL,NULL),(20376,969,1,28.3333,NULL,NULL,NULL,NULL),(20377,969,2.1,29.7732,NULL,NULL,NULL,NULL),(20378,969,3,30.7256,NULL,NULL,NULL,NULL),(20379,969,4,30.9524,NULL,NULL,NULL,NULL),(20380,969,5,31.4172,NULL,NULL,NULL,NULL),(20381,969,6.1,31.8821,NULL,NULL,NULL,NULL),(20382,969,7,32.3469,NULL,NULL,NULL,NULL),(20383,969,8.1,32.8118,NULL,NULL,NULL,NULL),(20384,969,9,33.7642,NULL,NULL,NULL,NULL),(20385,969,10.1,34.4671,NULL,NULL,NULL,NULL),(20386,969,11,35.1814,NULL,NULL,NULL,NULL),(20387,969,12.1,35.8844,NULL,NULL,NULL,NULL),(20388,969,13,36.1111,NULL,NULL,NULL,NULL),(20389,969,14.1,36.0884,NULL,NULL,NULL,NULL),(20390,969,15,36.5533,NULL,NULL,NULL,NULL),(20391,969,16,36.7687,NULL,NULL,NULL,NULL),(20392,969,17,36.9955,NULL,NULL,NULL,NULL),(20393,969,18,37.4603,NULL,NULL,NULL,NULL),(20394,969,19,37.6757,NULL,NULL,NULL,NULL),(20395,969,20,37.8912,NULL,NULL,NULL,NULL),(20396,969,21,38.356,NULL,NULL,NULL,NULL),(20397,969,22,38.8209,NULL,NULL,NULL,NULL),(20398,969,23.1,39.0476,NULL,NULL,NULL,NULL),(20399,969,24,39.0136,NULL,NULL,NULL,NULL),(20400,969,25.1,39.2404,NULL,NULL,NULL,NULL),(20401,969,26,39.9433,NULL,NULL,NULL,NULL),(20402,969,27,40.1701,NULL,NULL,NULL,NULL),(20403,969,28,40.6349,NULL,NULL,NULL,NULL),(20404,969,29.1,40.6122,NULL,NULL,NULL,NULL),(20405,969,29.9,40.8277,NULL,NULL,NULL,NULL),(20406,969,30.8,41.2925,NULL,NULL,NULL,NULL),(20407,969,32,41.5079,NULL,NULL,NULL,NULL),(20408,969,33.1,41.9728,NULL,NULL,NULL,NULL),(20409,969,34,41.712,NULL,NULL,NULL,NULL),(20410,969,35,42.1769,NULL,NULL,NULL,NULL),(20411,969,36,41.9048,NULL,NULL,NULL,NULL),(20412,969,36.9,42.1202,NULL,NULL,NULL,NULL),(20413,969,37.1,23.5488,NULL,1,NULL,NULL),(20414,969,38,22.3016,NULL,1,NULL,NULL),(20415,969,39,21.542,NULL,1,NULL,NULL),(20416,969,40.1,20.7823,NULL,1,NULL,NULL),(20417,969,41,21.2472,NULL,1,NULL,NULL),(20418,969,42,20.4875,NULL,1,NULL,NULL),(20419,969,43,20.2154,NULL,1,NULL,NULL),(20420,969,44.1,20.4422,NULL,1,NULL,NULL),(20421,969,45,20.4082,NULL,1,NULL,NULL),(20422,969,46,20.1474,NULL,1,NULL,NULL),(20423,969,47,19.6259,NULL,1,NULL,NULL),(20424,969,48,19.8526,NULL,1,NULL,NULL),(20425,969,49,19.8299,NULL,1,NULL,NULL),(20426,969,50.1,19.3084,NULL,1,NULL,NULL),(20427,969,51,19.2857,NULL,1,NULL,NULL),(20428,969,52,19.263,NULL,1,NULL,NULL),(20429,969,53,19.2404,NULL,1,NULL,NULL),(20430,969,54,18.9683,NULL,1,NULL,NULL),(20431,969,55,19.195,NULL,1,NULL,NULL),(20432,969,56,18.6735,NULL,1,NULL,NULL),(20433,969,57,18.6508,NULL,1,NULL,NULL),(20434,969,58,18.39,NULL,1,NULL,NULL),(20435,970,0,24.5011,NULL,NULL,NULL,NULL),(20436,970,0.1,25.5896,NULL,NULL,NULL,NULL),(20437,970,0.6,26.7914,NULL,NULL,NULL,NULL),(20438,970,1.2,27.1429,NULL,NULL,NULL,NULL),(20439,970,1.7,27.6077,NULL,NULL,NULL,NULL),(20440,970,2.2,28.0839,NULL,NULL,NULL,NULL),(20441,970,2.8,28.1859,NULL,NULL,NULL,NULL),(20442,970,3.2,28.5374,NULL,NULL,NULL,NULL),(20443,970,3.7,29.0023,NULL,NULL,NULL,NULL),(20444,970,4.2,29.2404,NULL,NULL,NULL,NULL),(20445,970,4.7,29.4671,NULL,NULL,NULL,NULL),(20446,970,5.2,29.8186,NULL,NULL,NULL,NULL),(20447,970,5.8,29.9206,NULL,NULL,NULL,NULL),(20448,970,6.2,30.1474,NULL,NULL,NULL,NULL),(20449,970,6.8,30.4989,NULL,NULL,NULL,NULL),(20450,970,7.3,30.4762,NULL,NULL,NULL,NULL),(20451,970,7.7,31.0771,NULL,NULL,NULL,NULL),(20452,970,8.3,31.542,NULL,NULL,NULL,NULL),(20453,970,8.8,31.7687,NULL,NULL,NULL,NULL),(20454,970,9.3,32.1202,NULL,NULL,NULL,NULL),(20455,970,9.9,31.8594,NULL,NULL,NULL,NULL),(20456,970,10.3,32.3356,NULL,NULL,NULL,NULL),(20457,970,10.9,33.1633,NULL,NULL,NULL,NULL),(20458,970,11.3,33.2766,NULL,NULL,NULL,NULL),(20459,970,11.9,33.1406,NULL,NULL,NULL,NULL),(20460,970,12.3,33.4921,NULL,NULL,NULL,NULL),(20461,970,12.9,33.5941,NULL,NULL,NULL,NULL),(20462,970,13.3,33.8209,NULL,NULL,NULL,NULL),(20463,970,13.8,34.0476,NULL,NULL,NULL,NULL),(20464,970,14.3,34.3991,NULL,NULL,NULL,NULL),(20465,970,14.9,34.3878,NULL,NULL,NULL,NULL),(20466,970,15.4,34.7279,NULL,NULL,NULL,NULL),(20467,970,15.8,34.8413,NULL,NULL,NULL,NULL),(20468,970,16.2,35.068,NULL,NULL,NULL,NULL),(20469,970,16.9,35.1701,NULL,NULL,NULL,NULL),(20470,970,17.3,35.2834,NULL,NULL,NULL,NULL),(20471,970,17.9,35.3855,NULL,NULL,NULL,NULL),(20472,970,18.2,35.6236,NULL,NULL,NULL,NULL),(20473,970,18.9,35.3515,NULL,NULL,NULL,NULL),(20474,970,19.3,35.5896,NULL,NULL,NULL,NULL),(20475,970,19.8,35.8163,NULL,NULL,NULL,NULL),(20476,970,20.3,35.7937,NULL,NULL,NULL,NULL),(20477,970,20.9,36.0204,NULL,NULL,NULL,NULL),(20478,970,21.4,36.2585,NULL,NULL,NULL,NULL),(20479,970,21.8,36.3605,NULL,NULL,NULL,NULL),(20480,970,22.3,36.712,NULL,NULL,NULL,NULL),(20481,970,22.8,36.8141,NULL,NULL,NULL,NULL),(20482,970,23.6,36.9161,NULL,NULL,NULL,NULL),(20483,970,24.3,37.1315,NULL,NULL,NULL,NULL),(20484,970,24.9,37.1202,NULL,NULL,NULL,NULL),(20485,970,25.4,37.3469,NULL,NULL,NULL,NULL),(20486,970,25.8,37.3356,NULL,NULL,NULL,NULL),(20487,970,26.4,37.6757,NULL,NULL,NULL,NULL),(20488,970,27,37.7891,NULL,NULL,NULL,NULL),(20489,970,27.3,37.7778,NULL,NULL,NULL,NULL),(20490,970,27.8,37.8798,NULL,NULL,NULL,NULL),(20491,970,28.3,37.9819,NULL,NULL,NULL,NULL),(20492,970,28.8,37.9705,NULL,NULL,NULL,NULL),(20493,970,29.4,37.9592,NULL,NULL,NULL,NULL),(20494,970,29.9,38.1859,NULL,NULL,NULL,NULL),(20495,970,30.4,38.288,NULL,NULL,NULL,NULL),(20496,970,30.9,38.39,NULL,NULL,NULL,NULL),(20497,970,31.3,38.7415,NULL,NULL,NULL,NULL),(20498,970,31.9,38.6054,NULL,NULL,NULL,NULL),(20499,970,32.3,38.7188,NULL,NULL,NULL,NULL),(20500,970,32.8,38.9456,NULL,NULL,NULL,NULL),(20501,970,33.3,39.0476,NULL,NULL,NULL,NULL),(20502,970,33.8,39.0363,NULL,NULL,NULL,NULL),(20503,970,33.81,20.4308,NULL,1,NULL,NULL),(20504,970,34.2,19.932,NULL,1,NULL,NULL),(20505,970,34.7,19.0703,NULL,1,NULL,NULL),(20506,970,35.3,18.6848,NULL,1,NULL,NULL),(20507,970,35.8,18.9116,NULL,1,NULL,NULL),(20508,970,36.4,18.5261,NULL,1,NULL,NULL),(20509,970,36.9,18.39,NULL,1,NULL,NULL),(20510,970,37.3,18.7415,NULL,1,NULL,NULL),(20511,970,37.8,18.6054,NULL,1,NULL,NULL),(20512,970,38.3,18.8322,NULL,1,NULL,NULL),(20513,970,38.8,18.3333,NULL,1,NULL,NULL),(20514,970,39.3,18.322,NULL,1,NULL,NULL),(20515,970,39.9,17.9365,NULL,1,NULL,NULL),(20516,970,40.4,17.9252,NULL,1,NULL,NULL),(20517,970,40.9,17.7891,NULL,1,NULL,NULL),(20518,970,41.3,17.8912,NULL,1,NULL,NULL),(20519,970,41.8,17.8798,NULL,1,NULL,NULL),(20520,970,42.3,17.619,NULL,1,NULL,NULL),(20521,970,42.7,17.7324,NULL,1,NULL,NULL),(20522,970,43.3,17.8345,NULL,1,NULL,NULL),(20523,970,43.8,17.3356,NULL,1,NULL,NULL),(20524,970,44.2,17.4376,NULL,1,NULL,NULL),(20525,970,44.9,17.3016,NULL,1,NULL,NULL),(20526,970,45.3,17.2902,NULL,1,NULL,NULL),(20527,970,45.7,17.2789,NULL,1,NULL,NULL),(20528,970,46.3,17.1315,NULL,1,NULL,NULL),(20529,970,46.7,17.1202,NULL,1,NULL,NULL),(20530,970,47.3,17.1088,NULL,1,NULL,NULL),(20531,970,47.8,17.0862,NULL,1,NULL,NULL),(20532,970,48.3,16.9501,NULL,1,NULL,NULL),(20533,970,48.8,16.8141,NULL,1,NULL,NULL),(20534,970,49.2,16.9274,NULL,1,NULL,NULL),(20535,970,49.8,16.6667,NULL,1,NULL,NULL),(20536,970,50.3,16.6553,NULL,1,NULL,NULL),(20537,970,50.7,16.3946,NULL,1,NULL,NULL),(20538,970,51.3,16.4966,NULL,1,NULL,NULL),(20539,970,51.7,16.61,NULL,1,NULL,NULL),(20540,970,52.2,16.5873,NULL,1,NULL,NULL),(20541,970,52.8,16.4512,NULL,1,NULL,NULL),(20542,970,53.2,16.1905,NULL,1,NULL,NULL),(20543,970,53.7,16.0544,NULL,1,NULL,NULL),(20544,970,54.2,16.0431,NULL,1,NULL,NULL),(20545,970,55.1,16.0204,NULL,1,NULL,NULL),(20546,971,0.1,49.7732,NULL,NULL,NULL,NULL),(20547,971,0.4,52.5057,NULL,NULL,NULL,NULL),(20548,971,0.8,53.5828,NULL,NULL,NULL,NULL),(20549,971,1.3,55.4649,NULL,NULL,NULL,NULL),(20550,971,2,56.8027,NULL,NULL,NULL,NULL),(20551,971,2.4,57.3129,NULL,NULL,NULL,NULL),(20552,971,2.8,58.6621,NULL,NULL,NULL,NULL),(20553,971,3.2,59.4671,NULL,NULL,NULL,NULL),(20554,971,3.9,59.6939,NULL,NULL,NULL,NULL),(20555,971,4.5,60.2041,NULL,NULL,NULL,NULL),(20556,971,4.9,61.2698,NULL,NULL,NULL,NULL),(20557,971,5.4,60.9637,NULL,NULL,NULL,NULL),(20558,971,5.9,61.7574,NULL,NULL,NULL,NULL),(20559,971,6.5,61.9841,NULL,NULL,NULL,NULL),(20560,971,7,62.5057,NULL,NULL,NULL,NULL),(20561,971,7.6,63.5601,NULL,NULL,NULL,NULL),(20562,971,8,65.1814,NULL,NULL,NULL,NULL),(20563,971,8.5,66.5193,NULL,NULL,NULL,NULL),(20564,971,9.1,65.6576,NULL,NULL,NULL,NULL),(20565,971,9.7,69.195,NULL,NULL,NULL,NULL),(20566,971,10.3,68.8775,NULL,NULL,NULL,NULL),(20567,971,11,68.8322,NULL,NULL,NULL,NULL),(20568,971,11.5,69.3424,NULL,NULL,NULL,NULL),(20569,971,11.9,70.1361,NULL,NULL,NULL,NULL),(20570,971,12.5,70.3742,NULL,NULL,NULL,NULL),(20571,971,13.1,70.3288,NULL,NULL,NULL,NULL),(20572,971,13.5,70.5782,NULL,NULL,NULL,NULL),(20573,971,14,71.0998,NULL,NULL,NULL,NULL),(20574,971,14.5,71.3379,NULL,NULL,NULL,NULL),(20575,971,15,72.1315,NULL,NULL,NULL,NULL),(20576,971,15.6,72.3696,NULL,NULL,NULL,NULL),(20577,971,16,72.6077,NULL,NULL,NULL,NULL),(20578,971,16.6,73.1179,NULL,NULL,NULL,NULL),(20579,971,17,73.6395,NULL,NULL,NULL,NULL),(20580,971,17.5,73.8889,NULL,NULL,NULL,NULL),(20581,971,17.9,74.127,NULL,NULL,NULL,NULL),(20582,971,18.5,74.6372,NULL,NULL,NULL,NULL),(20583,971,19,74.8753,NULL,NULL,NULL,NULL),(20584,971,19.5,75.1247,NULL,NULL,NULL,NULL),(20585,971,20.1,75.3628,NULL,NULL,NULL,NULL),(20586,971,20.5,75.0567,NULL,NULL,NULL,NULL),(20587,971,20.9,75.8503,NULL,NULL,NULL,NULL),(20588,971,21.4,76.0884,NULL,NULL,NULL,NULL),(20589,971,21.9,76.0544,NULL,NULL,NULL,NULL),(20590,971,22.5,76.5646,NULL,NULL,NULL,NULL),(20591,971,23,75.7029,NULL,NULL,NULL,NULL),(20592,971,23.5,75.9524,NULL,NULL,NULL,NULL),(20593,971,24,76.7347,NULL,NULL,NULL,NULL),(20594,971,24.5,77.2562,NULL,NULL,NULL,NULL),(20595,971,25,77.2222,NULL,NULL,NULL,NULL),(20596,971,25.5,77.1882,NULL,NULL,NULL,NULL),(20597,971,26,77.6984,NULL,NULL,NULL,NULL),(20598,971,26.5,77.9365,NULL,NULL,NULL,NULL),(20599,971,27,77.9138,NULL,NULL,NULL,NULL),(20600,971,27.5,78.9796,NULL,NULL,NULL,NULL),(20601,971,28.1,78.6621,NULL,NULL,NULL,NULL),(20602,971,28.4,79.1837,NULL,NULL,NULL,NULL),(20603,971,29,79.1383,NULL,NULL,NULL,NULL),(20604,971,29.4,79.6712,NULL,NULL,NULL,NULL),(20605,971,29.9,79.9093,NULL,NULL,NULL,NULL),(20606,971,30.5,80.1474,NULL,NULL,NULL,NULL),(20607,971,31,80.6576,NULL,NULL,NULL,NULL),(20608,971,31.5,80.6236,NULL,NULL,NULL,NULL),(20609,971,32,80.8617,NULL,NULL,NULL,NULL),(20610,971,32.4,80.5669,NULL,NULL,NULL,NULL),(20611,971,32.8,80.805,NULL,NULL,NULL,NULL),(20612,971,32.9,39.2744,NULL,1,NULL,NULL),(20613,971,33.1,35.6803,NULL,1,NULL,NULL),(20614,971,33.5,33.458,NULL,1,NULL,NULL),(20615,971,34,32.8685,NULL,1,NULL,NULL),(20616,971,34.4,32.5624,NULL,1,NULL,NULL),(20617,971,34.9,31.4286,NULL,1,NULL,NULL),(20618,971,35.5,31.3946,NULL,1,NULL,NULL),(20619,971,36,30.805,NULL,1,NULL,NULL),(20620,971,36.5,30.771,NULL,1,NULL,NULL),(20621,971,37,30.1814,NULL,1,NULL,NULL),(20622,971,37.5,29.8753,NULL,1,NULL,NULL),(20623,971,38,29.2971,NULL,1,NULL,NULL),(20624,971,38.5,29.5351,NULL,1,NULL,NULL),(20625,971,39,28.6735,NULL,1,NULL,NULL),(20626,971,39.4,28.3673,NULL,1,NULL,NULL),(20627,971,39.9,27.5057,NULL,1,NULL,NULL),(20628,971,40.5,27.1882,NULL,1,NULL,NULL),(20629,971,41,27.7098,NULL,1,NULL,NULL),(20630,971,41.5,27.6757,NULL,1,NULL,NULL),(20631,971,42,27.0975,NULL,1,NULL,NULL),(20632,971,42.5,27.0522,NULL,1,NULL,NULL),(20633,971,42.9,26.4739,NULL,1,NULL,NULL),(20634,971,43.5,26.4399,NULL,1,NULL,NULL),(20635,971,44,26.4059,NULL,1,NULL,NULL),(20636,971,44.5,26.0998,NULL,1,NULL,NULL),(20637,971,45,25.7823,NULL,1,NULL,NULL),(20638,971,45.5,25.4762,NULL,1,NULL,NULL),(20639,971,46.1,25.4308,NULL,1,NULL,NULL),(20640,972,0,66.7574,NULL,NULL,NULL,NULL),(20641,972,0.1,69.7506,NULL,NULL,NULL,NULL),(20642,972,0.2,73.5828,NULL,NULL,NULL,NULL),(20643,972,0.3,78.7642,NULL,NULL,NULL,NULL),(20644,972,0.6,82.5737,NULL,NULL,NULL,NULL),(20645,972,1.1,85,NULL,NULL,NULL,NULL),(20646,972,1.6,88.2426,NULL,NULL,NULL,NULL),(20647,972,2,90.4082,NULL,NULL,NULL,NULL),(20648,972,2.9,92.5283,NULL,NULL,NULL,NULL),(20649,972,3.4,93.5941,NULL,NULL,NULL,NULL),(20650,972,4,94.9093,NULL,NULL,NULL,NULL),(20651,972,4.4,95.7029,NULL,NULL,NULL,NULL),(20652,972,4.9,96.7687,NULL,NULL,NULL,NULL),(20653,972,5.4,98.0952,NULL,NULL,NULL,NULL),(20654,972,6.1,98.5941,NULL,NULL,NULL,NULL),(20655,972,6.5,99.6599,NULL,NULL,NULL,NULL),(20656,972,7.1,99.3424,NULL,NULL,NULL,NULL),(20657,972,7.7,99.3084,NULL,NULL,NULL,NULL),(20658,972,8,100.102,NULL,NULL,NULL,NULL),(20659,972,8.5,100.34,NULL,NULL,NULL,NULL),(20660,972,9,100.578,NULL,NULL,NULL,NULL),(20661,972,9.6,101.077,NULL,NULL,NULL,NULL),(20662,972,10.1,101.587,NULL,NULL,NULL,NULL),(20663,972,10.6,101.553,NULL,NULL,NULL,NULL),(20664,972,11.1,102.063,NULL,NULL,NULL,NULL),(20665,972,11.6,103.129,NULL,NULL,NULL,NULL),(20666,972,12,103.367,NULL,NULL,NULL,NULL),(20667,972,12.5,103.878,NULL,NULL,NULL,NULL),(20668,972,12.9,104.399,NULL,NULL,NULL,NULL),(20669,972,13.4,105.454,NULL,NULL,NULL,NULL),(20670,972,14,105.692,NULL,NULL,NULL,NULL),(20671,972,14.4,106.757,NULL,NULL,NULL,NULL),(20672,972,14.9,107.268,NULL,NULL,NULL,NULL),(20673,972,15.4,106.406,NULL,NULL,NULL,NULL),(20674,972,15.8,108.56,NULL,NULL,NULL,NULL),(20675,972,16.4,109.898,NULL,NULL,NULL,NULL),(20676,972,17,110.397,NULL,NULL,NULL,NULL),(20677,972,17.5,110.363,NULL,NULL,NULL,NULL),(20678,972,17.9,111.156,NULL,NULL,NULL,NULL),(20679,972,18.3,110.578,NULL,NULL,NULL,NULL),(20680,972,18.9,111.633,NULL,NULL,NULL,NULL),(20681,972,19.3,111.054,NULL,NULL,NULL,NULL),(20682,972,19.8,111.565,NULL,NULL,NULL,NULL),(20683,972,20.4,112.891,NULL,NULL,NULL,NULL),(20684,972,20.8,112.585,NULL,NULL,NULL,NULL),(20685,972,21.4,111.451,NULL,NULL,NULL,NULL),(20686,972,21.8,112.789,NULL,NULL,NULL,NULL),(20687,972,22.4,114.66,NULL,NULL,NULL,NULL),(20688,972,23.1,113.515,NULL,NULL,NULL,NULL),(20689,972,23.8,116.746,NULL,NULL,NULL,NULL),(20690,972,24.3,114.796,NULL,NULL,NULL,NULL),(20691,972,24.8,115.306,NULL,NULL,NULL,NULL),(20692,972,25.4,115.261,NULL,NULL,NULL,NULL),(20693,972,25.7,115.51,NULL,NULL,NULL,NULL),(20694,972,26.3,115.476,NULL,NULL,NULL,NULL),(20695,972,26.9,116.531,NULL,NULL,NULL,NULL),(20696,972,27.3,116.497,NULL,NULL,NULL,NULL),(20697,972,27.7,117.562,NULL,NULL,NULL,NULL),(20698,972,28.4,119.705,NULL,NULL,NULL,NULL),(20699,972,28.9,121.032,NULL,NULL,NULL,NULL),(20700,972,29.3,121.281,NULL,NULL,NULL,NULL),(20701,972,29.9,122.88,NULL,NULL,NULL,NULL),(20702,972,30.5,119.546,NULL,NULL,NULL,NULL),(20703,972,31,69.1723,NULL,1,NULL,NULL),(20704,972,31.5,65.034,NULL,1,NULL,NULL),(20705,972,32.4,60.873,NULL,1,NULL,NULL),(20706,972,32.8,57.5624,NULL,1,NULL,NULL),(20707,972,33.3,56.1565,NULL,1,NULL,NULL),(20708,972,33.8,55.2948,NULL,1,NULL,NULL),(20709,972,34.3,57.7211,NULL,1,NULL,NULL),(20710,972,35,55.7596,NULL,1,NULL,NULL),(20711,973,0,54.6485,NULL,NULL,NULL,NULL),(20712,973,0.1,56.2812,NULL,NULL,NULL,NULL),(20713,973,0.2,57.9025,NULL,NULL,NULL,NULL),(20714,973,0.4,59.2517,NULL,NULL,NULL,NULL),(20715,973,0.7,60.873,NULL,NULL,NULL,NULL),(20716,973,1.1,63.0272,NULL,NULL,NULL,NULL),(20717,973,1.6,64.898,NULL,NULL,NULL,NULL),(20718,973,1.9,66.2245,NULL,NULL,NULL,NULL),(20719,973,2.3,67.0181,NULL,NULL,NULL,NULL),(20720,973,3,67.7778,NULL,NULL,NULL,NULL),(20721,973,3.4,68.8435,NULL,NULL,NULL,NULL),(20722,973,4.1,70.4195,NULL,NULL,NULL,NULL),(20723,973,4.5,71.2132,NULL,NULL,NULL,NULL),(20724,973,5.1,71.712,NULL,NULL,NULL,NULL),(20725,973,5.6,73.0272,NULL,NULL,NULL,NULL),(20726,973,6.2,74.0703,NULL,NULL,NULL,NULL),(20727,973,6.8,75.941,NULL,NULL,NULL,NULL),(20728,973,7.3,77.2676,NULL,NULL,NULL,NULL),(20729,973,7.8,78.3107,NULL,NULL,NULL,NULL),(20730,973,8.4,78.8095,NULL,NULL,NULL,NULL),(20731,973,9,80.6689,NULL,NULL,NULL,NULL),(20732,973,9.6,80.907,NULL,NULL,NULL,NULL),(20733,973,10,81.6893,NULL,NULL,NULL,NULL),(20734,973,10.4,82.4717,NULL,NULL,NULL,NULL),(20735,973,11,82.1542,NULL,NULL,NULL,NULL),(20736,973,11.5,83.2086,NULL,NULL,NULL,NULL),(20737,973,11.9,83.9909,NULL,NULL,NULL,NULL),(20738,973,12.4,84.7619,NULL,NULL,NULL,NULL),(20739,973,12.9,85,NULL,NULL,NULL,NULL),(20740,973,13.4,85.7823,NULL,NULL,NULL,NULL),(20741,973,13.9,86.5533,NULL,NULL,NULL,NULL),(20742,973,14.4,87.6077,NULL,NULL,NULL,NULL),(20743,973,14.9,88.39,NULL,NULL,NULL,NULL),(20744,973,15.5,87.8005,NULL,NULL,NULL,NULL),(20745,973,16,88.2993,NULL,NULL,NULL,NULL),(20746,973,16.4,89.3537,NULL,NULL,NULL,NULL),(20747,973,17.1,90.941,NULL,NULL,NULL,NULL),(20748,973,17.6,90.907,NULL,NULL,NULL,NULL),(20749,973,18,91.1451,NULL,NULL,NULL,NULL),(20750,973,18.5,92.7438,NULL,NULL,NULL,NULL),(20751,973,18.9,93.5261,NULL,NULL,NULL,NULL),(20752,973,19.4,94.8526,NULL,NULL,NULL,NULL),(20753,973,19.9,94.263,NULL,NULL,NULL,NULL),(20754,973,20.4,94.5011,NULL,NULL,NULL,NULL),(20755,973,20.9,95,NULL,NULL,NULL,NULL),(20756,973,21.2,97.1655,NULL,NULL,NULL,NULL),(20757,973,21.6,95.2154,NULL,NULL,NULL,NULL),(20758,973,22,95.737,NULL,NULL,NULL,NULL),(20759,973,22.4,96.5193,NULL,NULL,NULL,NULL),(20760,973,23.1,96.7347,NULL,NULL,NULL,NULL),(20761,973,23.6,97.2449,NULL,NULL,NULL,NULL),(20762,973,24,97.483,NULL,NULL,NULL,NULL),(20763,973,24.5,97.9819,NULL,NULL,NULL,NULL),(20764,973,25,98.7642,NULL,NULL,NULL,NULL),(20765,973,25.5,97.6304,NULL,NULL,NULL,NULL),(20766,973,26.1,98.9456,NULL,NULL,NULL,NULL),(20767,973,26.6,98.9002,NULL,NULL,NULL,NULL),(20768,973,27,99.4218,NULL,NULL,NULL,NULL),(20769,973,27.5,99.3764,NULL,NULL,NULL,NULL),(20770,973,28,99.8866,NULL,NULL,NULL,NULL),(20771,973,28.4,99.8526,NULL,NULL,NULL,NULL),(20772,973,28.9,99.5351,NULL,NULL,NULL,NULL),(20773,973,29.4,99.7732,NULL,NULL,NULL,NULL),(20774,973,30,100.544,NULL,NULL,NULL,NULL),(20775,973,30.4,101.054,NULL,NULL,NULL,NULL),(20776,973,30.9,102.381,NULL,NULL,NULL,NULL),(20777,973,31.1,50.1814,NULL,1,NULL,NULL),(20778,973,31.6,47.415,NULL,1,NULL,NULL),(20779,973,32,45.737,NULL,1,NULL,NULL),(20780,973,32.4,42.9705,NULL,1,NULL,NULL),(20781,973,32.9,43.1973,NULL,1,NULL,NULL),(20782,973,33.5,43.1519,NULL,1,NULL,NULL),(20783,973,33.9,42.3016,NULL,1,NULL,NULL),(20784,973,34.4,42.2676,NULL,1,NULL,NULL),(20785,973,34.9,41.9388,NULL,1,NULL,NULL),(20786,973,35.4,41.0884,NULL,1,NULL,NULL),(20787,973,35.9,40.2268,NULL,1,NULL,NULL),(20788,973,36.5,39.898,NULL,1,NULL,NULL),(20789,973,36.9,39.8639,NULL,1,NULL,NULL),(20790,973,37.5,40.0907,NULL,1,NULL,NULL),(20791,973,38,39.5011,NULL,1,NULL,NULL),(20792,974,0,107.302,NULL,NULL,NULL,NULL),(20793,974,0.3,110.952,NULL,NULL,NULL,NULL),(20794,974,0.9,113.118,NULL,NULL,NULL,NULL),(20795,974,1.3,116.769,NULL,NULL,NULL,NULL),(20796,974,1.9,118.923,NULL,NULL,NULL,NULL),(20797,974,2.6,121.077,NULL,NULL,NULL,NULL),(20798,974,3.1,122.506,NULL,NULL,NULL,NULL),(20799,974,3.4,126.168,NULL,NULL,NULL,NULL),(20800,974,4,127.959,NULL,NULL,NULL,NULL),(20801,974,4.6,131.973,NULL,NULL,NULL,NULL),(20802,974,5,135.249,NULL,NULL,NULL,NULL),(20803,974,5.5,137.052,NULL,NULL,NULL,NULL),(20804,974,6,138.481,NULL,NULL,NULL,NULL),(20805,974,6.5,139.546,NULL,NULL,NULL,NULL),(20806,974,7,140.601,NULL,NULL,NULL,NULL),(20807,974,7.6,142.029,NULL,NULL,NULL,NULL),(20808,974,8,144.195,NULL,NULL,NULL,NULL),(20809,974,8.5,145.635,NULL,NULL,NULL,NULL),(20810,974,9,148.549,NULL,NULL,NULL,NULL),(20811,974,9.5,148.129,NULL,NULL,NULL,NULL),(20812,974,10.1,148.084,NULL,NULL,NULL,NULL),(20813,974,10.6,149.138,NULL,NULL,NULL,NULL),(20814,974,11.1,149.456,NULL,NULL,NULL,NULL),(20815,974,11.5,150.896,NULL,NULL,NULL,NULL),(20816,974,12.1,153.81,NULL,NULL,NULL,NULL),(20817,974,12.6,155.601,NULL,NULL,NULL,NULL),(20818,974,13.1,155.181,NULL,NULL,NULL,NULL),(20819,974,13.6,156.621,NULL,NULL,NULL,NULL),(20820,974,14.1,156.202,NULL,NULL,NULL,NULL),(20821,974,14.7,158.005,NULL,NULL,NULL,NULL),(20822,974,15.1,159.07,NULL,NULL,NULL,NULL),(20823,974,15.6,159.399,NULL,NULL,NULL,NULL),(20824,974,16.1,160.454,NULL,NULL,NULL,NULL),(20825,974,16.7,161.508,NULL,NULL,NULL,NULL),(20826,974,17.1,162.574,NULL,NULL,NULL,NULL),(20827,974,17.6,163.265,NULL,NULL,NULL,NULL),(20828,974,18.2,163.594,NULL,NULL,NULL,NULL),(20829,974,18.7,166.134,NULL,NULL,NULL,NULL),(20830,974,19.1,167.2,NULL,NULL,NULL,NULL),(20831,974,19.6,167.154,NULL,NULL,NULL,NULL),(20832,974,20.1,167.846,NULL,NULL,NULL,NULL),(20833,974,20.5,168.549,NULL,NULL,NULL,NULL),(20834,974,21,169.615,NULL,NULL,NULL,NULL),(20835,974,21.6,170.669,NULL,NULL,NULL,NULL),(20836,974,22.2,172.46,NULL,NULL,NULL,NULL),(20837,974,22.7,172.789,NULL,NULL,NULL,NULL),(20838,974,23.3,172.732,NULL,NULL,NULL,NULL),(20839,974,23.8,173.061,NULL,NULL,NULL,NULL),(20840,974,24.3,174.116,NULL,NULL,NULL,NULL),(20841,974,24.7,174.444,NULL,NULL,NULL,NULL),(20842,974,25.3,174.762,NULL,NULL,NULL,NULL),(20843,974,25.8,175.465,NULL,NULL,NULL,NULL),(20844,974,26.3,176.156,NULL,NULL,NULL,NULL),(20845,974,26.8,176.848,NULL,NULL,NULL,NULL),(20846,974,27.3,176.44,NULL,NULL,NULL,NULL),(20847,974,27.8,177.132,NULL,NULL,NULL,NULL),(20848,974,28.3,178.186,NULL,NULL,NULL,NULL),(20849,974,28.7,178.889,NULL,NULL,NULL,NULL),(20850,974,29.3,179.581,NULL,NULL,NULL,NULL),(20851,974,29.7,179.535,NULL,NULL,NULL,NULL),(20852,974,30.2,180.975,NULL,NULL,NULL,NULL),(20853,974,30.7,181.304,NULL,NULL,NULL,NULL),(20854,974,31.3,182.347,NULL,NULL,NULL,NULL),(20855,974,31.8,183.05,NULL,NULL,NULL,NULL),(20856,974,32.2,183.742,NULL,NULL,NULL,NULL),(20857,974,32.8,184.07,NULL,NULL,NULL,NULL),(20858,974,33.2,184.036,NULL,NULL,NULL,NULL),(20859,974,33.6,183.991,NULL,NULL,NULL,NULL),(20860,974,34.1,185.057,NULL,NULL,NULL,NULL),(20861,974,34.6,185.76,NULL,NULL,NULL,NULL),(20862,974,35.2,186.44,NULL,NULL,NULL,NULL),(20863,974,35.8,94.9433,NULL,1,NULL,NULL),(20864,974,36.4,90.8277,NULL,1,NULL,NULL),(20865,974,37,88.9456,NULL,1,NULL,NULL),(20866,974,37.5,84.8413,NULL,1,NULL,NULL),(20867,974,37.9,84.8073,NULL,1,NULL,NULL),(20868,974,38.4,82.551,NULL,1,NULL,NULL),(20869,974,38.9,81.7687,NULL,1,NULL,NULL),(20870,974,39.3,80.6236,NULL,1,NULL,NULL),(20871,974,39.7,80.5896,NULL,1,NULL,NULL),(20872,974,40.3,79.8073,NULL,1,NULL,NULL),(20873,974,40.8,79.3878,NULL,1,NULL,NULL),(20874,974,41.4,78.2313,NULL,1,NULL,NULL),(20875,974,41.8,78.1973,NULL,1,NULL,NULL),(20876,974,42.3,77.415,NULL,1,NULL,NULL),(20877,974,42.9,78.0952,NULL,1,NULL,NULL),(20878,974,43.3,75.8503,NULL,1,NULL,NULL),(20879,974,43.8,76.5419,NULL,1,NULL,NULL),(20880,974,44.4,74.6485,NULL,1,NULL,NULL),(20881,974,44.9,74.6032,NULL,1,NULL,NULL),(20882,974,45.3,74.2064,NULL,1,NULL,NULL),(20883,974,45.7,73.0612,NULL,1,NULL,NULL),(20884,974,46.3,73.0045,NULL,1,NULL,NULL),(20885,974,47.1,73.3107,NULL,1,NULL,NULL),(20886,975,0.2,96.9614,NULL,NULL,NULL,NULL),(20887,975,0.4,101.361,NULL,NULL,NULL,NULL),(20888,975,0.8,105.748,NULL,NULL,NULL,NULL),(20889,975,1.3,109.388,NULL,NULL,NULL,NULL),(20890,975,1.8,111.19,NULL,NULL,NULL,NULL),(20891,975,2.1,113.379,NULL,NULL,NULL,NULL),(20892,975,2.7,113.696,NULL,NULL,NULL,NULL),(20893,975,3,116.247,NULL,NULL,NULL,NULL),(20894,975,3.5,118.424,NULL,NULL,NULL,NULL),(20895,975,4,119.478,NULL,NULL,NULL,NULL),(20896,975,4.4,120.918,NULL,NULL,NULL,NULL),(20897,975,5.1,121.961,NULL,NULL,NULL,NULL),(20898,975,5.4,125.998,NULL,NULL,NULL,NULL),(20899,975,6,125.578,NULL,NULL,NULL,NULL),(20900,975,6.5,126.27,NULL,NULL,NULL,NULL),(20901,975,7,127.336,NULL,NULL,NULL,NULL),(20902,975,7.5,128.027,NULL,NULL,NULL,NULL),(20903,975,7.8,133.163,NULL,NULL,NULL,NULL),(20904,975,8.7,130.125,NULL,NULL,NULL,NULL),(20905,975,9.5,132.642,NULL,NULL,NULL,NULL),(20906,975,10,132.971,NULL,NULL,NULL,NULL),(20907,975,10.5,135.499,NULL,NULL,NULL,NULL),(20908,975,10.9,136.576,NULL,NULL,NULL,NULL),(20909,975,11.5,136.893,NULL,NULL,NULL,NULL),(20910,975,12.1,138.322,NULL,NULL,NULL,NULL),(20911,975,12.5,140.125,NULL,NULL,NULL,NULL),(20912,975,13,140.079,NULL,NULL,NULL,NULL),(20913,975,13.7,141.485,NULL,NULL,NULL,NULL),(20914,975,14.5,144.376,NULL,NULL,NULL,NULL),(20915,975,14.9,144.705,NULL,NULL,NULL,NULL),(20916,975,15.5,151.667,NULL,NULL,NULL,NULL),(20917,975,15.9,147.2,NULL,NULL,NULL,NULL),(20918,975,16.4,148.628,NULL,NULL,NULL,NULL),(20919,975,16.8,154.127,NULL,NULL,NULL,NULL),(20920,975,17.6,149.637,NULL,NULL,NULL,NULL),(20921,975,17.9,155.499,NULL,NULL,NULL,NULL),(20922,975,18.5,152.506,NULL,NULL,NULL,NULL),(20923,975,19.2,153.549,NULL,NULL,NULL,NULL),(20924,975,19.9,154.955,NULL,NULL,NULL,NULL),(20925,975,20.3,161.19,NULL,NULL,NULL,NULL),(20926,975,21,156.701,NULL,NULL,NULL,NULL),(20927,975,21.4,161.837,NULL,NULL,NULL,NULL),(20928,975,22.2,158.073,NULL,NULL,NULL,NULL),(20929,975,22.7,159.512,NULL,NULL,NULL,NULL),(20930,975,23.2,160.204,NULL,NULL,NULL,NULL),(20931,975,24,160.499,NULL,NULL,NULL,NULL),(20932,975,24.5,161.939,NULL,NULL,NULL,NULL),(20933,975,25,162.993,NULL,NULL,NULL,NULL),(20934,975,25.4,163.696,NULL,NULL,NULL,NULL),(20935,975,26,164.376,NULL,NULL,NULL,NULL),(20936,975,26.7,164.694,NULL,NULL,NULL,NULL),(20937,975,27.1,166.871,NULL,NULL,NULL,NULL),(20938,975,27.5,167.574,NULL,NULL,NULL,NULL),(20939,975,27.9,169.376,NULL,NULL,NULL,NULL),(20940,975,28.5,168.22,NULL,NULL,NULL,NULL),(20941,975,29,168.912,NULL,NULL,NULL,NULL),(20942,975,29.6,170.703,NULL,NULL,NULL,NULL),(20943,975,30.4,171.372,NULL,NULL,NULL,NULL),(20944,975,31.2,94.9773,NULL,1,NULL,NULL),(20945,975,31.5,82.415,NULL,1,NULL,NULL),(20946,975,32,75.737,NULL,1,NULL,NULL),(20947,975,32.5,72.7324,NULL,1,NULL,NULL),(20948,975,32.9,71.5986,NULL,1,NULL,NULL),(20949,975,33.5,70.8163,NULL,1,NULL,NULL),(20950,975,34,70.034,NULL,1,NULL,NULL),(20951,975,34.5,68.8775,NULL,1,NULL,NULL),(20952,975,34.9,68.8435,NULL,1,NULL,NULL),(20953,975,35.4,64.7392,NULL,1,NULL,NULL),(20954,975,36.1,65.4195,NULL,1,NULL,NULL),(20955,975,36.6,65.7483,NULL,1,NULL,NULL),(20956,975,37,62.3923,NULL,1,NULL,NULL),(20957,975,37.6,64.1837,NULL,1,NULL,NULL),(20958,975,38.1,62.6644,NULL,1,NULL,NULL),(20959,975,38.6,62.2562,NULL,1,NULL,NULL),(20960,975,39.1,61.0998,NULL,1,NULL,NULL),(20961,975,39.6,61.0658,NULL,1,NULL,NULL),(20962,975,40,61.0204,NULL,1,NULL,NULL),(20963,975,40.5,59.5011,NULL,1,NULL,NULL),(20964,975,41,60.1927,NULL,1,NULL,NULL),(20965,975,41.5,61.6327,NULL,1,NULL,NULL),(20966,975,42.1,59.0023,NULL,1,NULL,NULL),(20967,975,42.6,58.5828,NULL,1,NULL,NULL),(20968,975,43.1,58.5374,NULL,1,NULL,NULL),(20969,975,43.7,58.4921,NULL,1,NULL,NULL),(20970,976,0,34.7814,NULL,NULL,NULL,NULL),(20971,976,0.5,36.5125,NULL,NULL,NULL,NULL),(20972,976,1,37.0287,NULL,NULL,NULL,NULL),(20973,976,1.5,37.8889,NULL,NULL,NULL,NULL),(20974,976,2,38.405,NULL,NULL,NULL,NULL),(20975,976,2.5,38.9211,NULL,NULL,NULL,NULL),(20976,976,3,39.1756,NULL,NULL,NULL,NULL),(20977,976,3.5,39.7778,NULL,NULL,NULL,NULL),(20978,976,4,40.1183,NULL,NULL,NULL,NULL),(20979,976,4.5,40.7204,NULL,NULL,NULL,NULL),(20980,976,5,40.9749,NULL,NULL,NULL,NULL),(20981,976,5.5,41.491,NULL,NULL,NULL,NULL),(20982,976,6,41.8315,NULL,NULL,NULL,NULL),(20983,976,6.5,42.3477,NULL,NULL,NULL,NULL),(20984,976,7,42.5125,NULL,NULL,NULL,NULL),(20985,976,7.5,43.0287,NULL,NULL,NULL,NULL),(20986,976,8,43.1111,NULL,NULL,NULL,NULL),(20987,976,8.5,43.5376,NULL,NULL,NULL,NULL),(20988,976,9,43.5305,NULL,NULL,NULL,NULL),(20989,976,9.5,43.6129,NULL,NULL,NULL,NULL),(20990,976,10,43.6057,NULL,NULL,NULL,NULL),(20991,976,10.5,43.6846,NULL,NULL,NULL,NULL),(20992,976,11,43.5054,NULL,NULL,NULL,NULL),(20993,976,11.5,43.4982,NULL,NULL,NULL,NULL),(20994,976,12,43.405,NULL,NULL,NULL,NULL),(20995,976,12.5,43.5735,NULL,NULL,NULL,NULL),(20996,976,13,43.4803,NULL,NULL,NULL,NULL),(20997,976,13.5,44.1685,NULL,NULL,NULL,NULL),(20998,976,13.9,44.4229,NULL,NULL,NULL,NULL),(20999,976,14.5,44.0681,NULL,NULL,NULL,NULL),(21000,976,15,43.7993,NULL,NULL,NULL,NULL),(21001,976,15.5,44.0538,NULL,NULL,NULL,NULL),(21002,976,16,44.2222,NULL,NULL,NULL,NULL),(21003,976,16.5,44.3047,NULL,NULL,NULL,NULL),(21004,976,17,44.1219,NULL,NULL,NULL,NULL),(21005,976,17.5,44.3763,NULL,NULL,NULL,NULL),(21006,976,18,44.4588,NULL,NULL,NULL,NULL),(21007,976,18.5,44.5376,NULL,NULL,NULL,NULL),(21008,976,19,44.5305,NULL,NULL,NULL,NULL),(21009,976,19.5,44.6129,NULL,NULL,NULL,NULL),(21010,976,20,44.7778,NULL,NULL,NULL,NULL),(21011,976,20.5,44.9462,NULL,NULL,NULL,NULL),(21012,976,21,45.0251,NULL,NULL,NULL,NULL),(21013,976,21.5,45.1936,NULL,NULL,NULL,NULL),(21014,976,22.1,45.362,NULL,NULL,NULL,NULL),(21015,976,22.5,45.6165,NULL,NULL,NULL,NULL),(21016,976,23,45.7814,NULL,NULL,NULL,NULL),(21017,976,23.5,45.9498,NULL,NULL,NULL,NULL),(21018,976,24,45.8566,NULL,NULL,NULL,NULL),(21019,976,24.5,45.7634,NULL,NULL,NULL,NULL),(21020,976,25.1,45.8423,NULL,NULL,NULL,NULL),(21021,976,25.5,45.7491,NULL,NULL,NULL,NULL),(21022,976,26.1,45.6559,NULL,NULL,NULL,NULL),(21023,976,26.5,45.6487,NULL,NULL,NULL,NULL),(21024,976,27.1,45.5556,NULL,NULL,NULL,NULL),(21025,976,27.5,45.724,NULL,NULL,NULL,NULL),(21026,976,28,45.8925,NULL,NULL,NULL,NULL),(21027,976,28.5,45.9713,NULL,NULL,NULL,NULL),(21028,976,29.1,45.9642,NULL,NULL,NULL,NULL),(21029,976,29.5,46.1326,NULL,NULL,NULL,NULL),(21030,976,30.1,46.2115,NULL,NULL,NULL,NULL),(21031,976,30.5,46.3799,NULL,NULL,NULL,NULL),(21032,976,31,46.5484,NULL,NULL,NULL,NULL),(21033,976,31.4,46.8029,NULL,NULL,NULL,NULL),(21034,976,31.7,46.8889,NULL,NULL,NULL,NULL),(21035,976,31.71,22.9749,NULL,1,NULL,NULL),(21036,976,32,21.9283,NULL,1,NULL,NULL),(21037,976,32.6,21.3118,NULL,1,NULL,NULL),(21038,976,33.3,20.957,NULL,1,NULL,NULL),(21039,976,33.7,20.6882,NULL,1,NULL,NULL),(21040,976,34.2,20.2473,NULL,1,NULL,NULL),(21041,976,34.9,19.8029,NULL,1,NULL,NULL),(21042,976,35.5,19.448,NULL,1,NULL,NULL),(21043,977,0,32.7814,NULL,NULL,NULL,NULL),(21044,977,0.4,33.7312,NULL,NULL,NULL,NULL),(21045,977,1,34.3333,NULL,NULL,NULL,NULL),(21046,977,1.5,34.7599,NULL,NULL,NULL,NULL),(21047,977,2,35.0143,NULL,NULL,NULL,NULL),(21048,977,2.5,35.4444,NULL,NULL,NULL,NULL),(21049,977,3,35.5233,NULL,NULL,NULL,NULL),(21050,977,3.5,36.0394,NULL,NULL,NULL,NULL),(21051,977,4,36.2939,NULL,NULL,NULL,NULL),(21052,977,4.5,36.4624,NULL,NULL,NULL,NULL),(21053,977,5,36.4552,NULL,NULL,NULL,NULL),(21054,977,5.5,36.448,NULL,NULL,NULL,NULL),(21055,977,6,36.3548,NULL,NULL,NULL,NULL),(21056,977,6.5,36.5197,NULL,NULL,NULL,NULL),(21057,977,7,36.5125,NULL,NULL,NULL,NULL),(21058,977,7.5,36.681,NULL,NULL,NULL,NULL),(21059,977,8,36.6738,NULL,NULL,NULL,NULL),(21060,977,8.5,36.8423,NULL,NULL,NULL,NULL),(21061,977,9,36.9247,NULL,NULL,NULL,NULL),(21062,977,9.5,37.0036,NULL,NULL,NULL,NULL),(21063,977,10,37.0824,NULL,NULL,NULL,NULL),(21064,977,10.5,37.1649,NULL,NULL,NULL,NULL),(21065,977,11,37.2437,NULL,NULL,NULL,NULL),(21066,977,11.5,37.4122,NULL,NULL,NULL,NULL),(21067,977,12,37.5806,NULL,NULL,NULL,NULL),(21068,977,12.5,37.6595,NULL,NULL,NULL,NULL),(21069,977,13,37.5663,NULL,NULL,NULL,NULL),(21070,977,13.5,37.6452,NULL,NULL,NULL,NULL),(21071,977,14,37.7276,NULL,NULL,NULL,NULL),(21072,977,14.5,37.8064,NULL,NULL,NULL,NULL),(21073,977,15,37.8889,NULL,NULL,NULL,NULL),(21074,977,15.5,38.0538,NULL,NULL,NULL,NULL),(21075,977,16,38.0502,NULL,NULL,NULL,NULL),(21076,977,16.5,38.3047,NULL,NULL,NULL,NULL),(21077,977,17,38.4695,NULL,NULL,NULL,NULL),(21078,977,17.5,38.552,NULL,NULL,NULL,NULL),(21079,977,18,38.6308,NULL,NULL,NULL,NULL),(21080,977,18.5,38.7993,NULL,NULL,NULL,NULL),(21081,977,19,38.9677,NULL,NULL,NULL,NULL),(21082,977,19.6,39.0466,NULL,NULL,NULL,NULL),(21083,977,20.1,39.1254,NULL,NULL,NULL,NULL),(21084,977,20.5,39.2079,NULL,NULL,NULL,NULL),(21085,977,21.2,39.2007,NULL,NULL,NULL,NULL),(21086,977,21.6,39.2796,NULL,NULL,NULL,NULL),(21087,977,22.1,39.0143,NULL,NULL,NULL,NULL),(21088,977,22.5,39.0072,NULL,NULL,NULL,NULL),(21089,977,23,38.914,NULL,NULL,NULL,NULL),(21090,977,23.5,38.9928,NULL,NULL,NULL,NULL),(21091,977,24,38.8996,NULL,NULL,NULL,NULL),(21092,977,24.5,38.8064,NULL,NULL,NULL,NULL),(21093,977,25,38.7133,NULL,NULL,NULL,NULL),(21094,977,25.5,38.8817,NULL,NULL,NULL,NULL),(21095,977,26,38.7885,NULL,NULL,NULL,NULL),(21096,977,26.5,38.7814,NULL,NULL,NULL,NULL),(21097,977,27,38.7742,NULL,NULL,NULL,NULL),(21098,977,27.5,39.0287,NULL,NULL,NULL,NULL),(21099,977,28,39.1971,NULL,NULL,NULL,NULL),(21100,977,28.5,39.276,NULL,NULL,NULL,NULL),(21101,977,29,39.1828,NULL,NULL,NULL,NULL),(21102,977,29.5,39.0896,NULL,NULL,NULL,NULL),(21103,977,30,38.9964,NULL,NULL,NULL,NULL),(21104,977,30.1,14.9104,NULL,1,NULL,NULL),(21105,977,30.5,14.1219,NULL,1,NULL,NULL),(21106,977,31,12.9857,NULL,1,NULL,NULL),(21107,977,31.5,12.6308,NULL,1,NULL,NULL),(21108,977,32,11.9283,NULL,1,NULL,NULL),(21109,977,32.5,11.6631,NULL,1,NULL,NULL),(21110,977,33,11.5699,NULL,1,NULL,NULL),(21111,977,33.5,11.5627,NULL,1,NULL,NULL),(21112,977,34.1,11.5556,NULL,1,NULL,NULL),(21113,977,34.5,11.6344,NULL,1,NULL,NULL),(21114,977,35.1,11.5412,NULL,1,NULL,NULL),(21115,978,0,29.3011,NULL,NULL,NULL,NULL),(21116,978,0.5,30.4265,NULL,NULL,NULL,NULL),(21117,978,1.1,31.2867,NULL,NULL,NULL,NULL),(21118,978,1.5,32.1505,NULL,NULL,NULL,NULL),(21119,978,2,32.4946,NULL,NULL,NULL,NULL),(21120,978,2.5,32.7455,NULL,NULL,NULL,NULL),(21121,978,3,32.5663,NULL,NULL,NULL,NULL),(21122,978,3.5,32.7348,NULL,NULL,NULL,NULL),(21123,978,4,32.9032,NULL,NULL,NULL,NULL),(21124,978,4.5,33.0681,NULL,NULL,NULL,NULL),(21125,978,5,33.2366,NULL,NULL,NULL,NULL),(21126,978,5.5,33.5771,NULL,NULL,NULL,NULL),(21127,978,6,34.0072,NULL,NULL,NULL,NULL),(21128,978,6.5,34.086,NULL,NULL,NULL,NULL),(21129,978,7,34.1649,NULL,NULL,NULL,NULL),(21130,978,7.5,34.1613,NULL,NULL,NULL,NULL),(21131,978,8,34.3262,NULL,NULL,NULL,NULL),(21132,978,8.5,34.7563,NULL,NULL,NULL,NULL),(21133,978,9,34.6631,NULL,NULL,NULL,NULL),(21134,978,9.5,34.5699,NULL,NULL,NULL,NULL),(21135,978,10.1,34.7348,NULL,NULL,NULL,NULL),(21136,978,10.5,34.9032,NULL,NULL,NULL,NULL),(21137,978,11,34.724,NULL,NULL,NULL,NULL),(21138,978,11.5,34.8889,NULL,NULL,NULL,NULL),(21139,978,11.9,34.8853,NULL,NULL,NULL,NULL),(21140,978,12.5,35.0502,NULL,NULL,NULL,NULL),(21141,978,13,35.043,NULL,NULL,NULL,NULL),(21142,978,13.6,34.9498,NULL,NULL,NULL,NULL),(21143,978,14,34.8566,NULL,NULL,NULL,NULL),(21144,978,14.5,35.1111,NULL,NULL,NULL,NULL),(21145,978,15,35.1075,NULL,NULL,NULL,NULL),(21146,978,15.5,34.8387,NULL,NULL,NULL,NULL),(21147,978,16,35.0036,NULL,NULL,NULL,NULL),(21148,978,16.5,35.3477,NULL,NULL,NULL,NULL),(21149,978,17,35.2545,NULL,NULL,NULL,NULL),(21150,978,17.5,35.4194,NULL,NULL,NULL,NULL),(21151,978,18,35.4158,NULL,NULL,NULL,NULL),(21152,978,18.5,35.3226,NULL,NULL,NULL,NULL),(21153,978,19,35.3154,NULL,NULL,NULL,NULL),(21154,978,19.5,35.3082,NULL,NULL,NULL,NULL),(21155,978,20,35.4767,NULL,NULL,NULL,NULL),(21156,978,20.6,35.5556,NULL,NULL,NULL,NULL),(21157,978,21,35.6344,NULL,NULL,NULL,NULL),(21158,978,21.5,35.5412,NULL,NULL,NULL,NULL),(21159,978,22,35.6237,NULL,NULL,NULL,NULL),(21160,978,22.5,35.6165,NULL,NULL,NULL,NULL),(21161,978,23,35.6953,NULL,NULL,NULL,NULL),(21162,978,23.5,35.6021,NULL,NULL,NULL,NULL),(21163,978,24,35.5986,NULL,NULL,NULL,NULL),(21164,978,24.5,35.5914,NULL,NULL,NULL,NULL),(21165,978,25,35.6702,NULL,NULL,NULL,NULL),(21166,978,25.5,35.7527,NULL,NULL,NULL,NULL),(21167,978,26,35.7455,NULL,NULL,NULL,NULL),(21168,978,26.5,35.7383,NULL,NULL,NULL,NULL),(21169,978,27,35.5591,NULL,NULL,NULL,NULL),(21170,978,27.5,35.8136,NULL,NULL,NULL,NULL),(21171,978,28,35.7168,NULL,NULL,NULL,NULL),(21172,978,28.5,35.7993,NULL,NULL,NULL,NULL),(21173,978,29,35.7061,NULL,NULL,NULL,NULL),(21174,978,29.5,35.6989,NULL,NULL,NULL,NULL),(21175,978,30,35.5197,NULL,NULL,NULL,NULL),(21176,978,30.5,35.8602,NULL,NULL,NULL,NULL),(21177,978,31,35.767,NULL,NULL,NULL,NULL),(21178,978,31.1,8.81004,NULL,1,NULL,NULL),(21179,978,31.5,8.89247,NULL,1,NULL,NULL),(21180,978,32.1,8.79928,NULL,1,NULL,NULL),(21181,978,32.5,8.87814,NULL,1,NULL,NULL),(21182,978,33,8.52688,NULL,1,NULL,NULL),(21183,978,33.5,8.34409,NULL,1,NULL,NULL),(21184,978,34,8.16487,NULL,1,NULL,NULL),(21185,978,34.5,8.24373,NULL,1,NULL,NULL),(21186,978,35,8.24014,NULL,1,NULL,NULL),(21187,978,35.5,8.40502,NULL,1,NULL,NULL),(21188,978,36,8.39785,NULL,1,NULL,NULL),(21189,979,0,25.6487,NULL,NULL,NULL,NULL),(21190,979,0.5,27.7312,NULL,NULL,NULL,NULL),(21191,979,1,28.5054,NULL,NULL,NULL,NULL),(21192,979,1.5,29.1971,NULL,NULL,NULL,NULL),(21193,979,2,29.5376,NULL,NULL,NULL,NULL),(21194,979,2.5,29.7921,NULL,NULL,NULL,NULL),(21195,979,3,29.871,NULL,NULL,NULL,NULL),(21196,979,3.5,30.2115,NULL,NULL,NULL,NULL),(21197,979,4,30.2043,NULL,NULL,NULL,NULL),(21198,979,4.5,30.3728,NULL,NULL,NULL,NULL),(21199,979,5,30.2796,NULL,NULL,NULL,NULL),(21200,979,5.5,30.2724,NULL,NULL,NULL,NULL),(21201,979,6,30.3548,NULL,NULL,NULL,NULL),(21202,979,6.5,30.871,NULL,NULL,NULL,NULL),(21203,979,7,31.2115,NULL,NULL,NULL,NULL),(21204,979,7.5,31.9857,NULL,NULL,NULL,NULL),(21205,979,8,31.4588,NULL,NULL,NULL,NULL),(21206,979,8.5,32.4086,NULL,NULL,NULL,NULL),(21207,979,9,32.0538,NULL,NULL,NULL,NULL),(21208,979,9.5,31.7849,NULL,NULL,NULL,NULL),(21209,979,10,31.6918,NULL,NULL,NULL,NULL),(21210,979,10.5,31.9462,NULL,NULL,NULL,NULL),(21211,979,11,31.767,NULL,NULL,NULL,NULL),(21212,979,11.5,31.9319,NULL,NULL,NULL,NULL),(21213,979,12,31.9283,NULL,NULL,NULL,NULL),(21214,979,12.5,31.9211,NULL,NULL,NULL,NULL),(21215,979,13,32,NULL,NULL,NULL,NULL),(21216,979,13.5,32.1685,NULL,NULL,NULL,NULL),(21217,979,14,32.2509,NULL,NULL,NULL,NULL),(21218,979,14.5,32.4158,NULL,NULL,NULL,NULL),(21219,979,15,32.3226,NULL,NULL,NULL,NULL),(21220,979,15.5,32.3154,NULL,NULL,NULL,NULL),(21221,979,16,32.3979,NULL,NULL,NULL,NULL),(21222,979,16.5,32.6523,NULL,NULL,NULL,NULL),(21223,979,17,32.5591,NULL,NULL,NULL,NULL),(21224,979,17.5,32.724,NULL,NULL,NULL,NULL),(21225,979,18,32.5448,NULL,NULL,NULL,NULL),(21226,979,18.5,32.7993,NULL,NULL,NULL,NULL),(21227,979,19,32.7921,NULL,NULL,NULL,NULL),(21228,979,19.5,32.9606,NULL,NULL,NULL,NULL),(21229,979,20,33.1254,NULL,NULL,NULL,NULL),(21230,979,20.5,33.3835,NULL,NULL,NULL,NULL),(21231,979,21,33.6344,NULL,NULL,NULL,NULL),(21232,979,21.5,33.4552,NULL,NULL,NULL,NULL),(21233,979,22,33.1864,NULL,NULL,NULL,NULL),(21234,979,22.5,32.9211,NULL,NULL,NULL,NULL),(21235,979,23,32.914,NULL,NULL,NULL,NULL),(21236,979,23.5,33.0824,NULL,NULL,NULL,NULL),(21237,979,24,33.1613,NULL,NULL,NULL,NULL),(21238,979,24.5,33.2437,NULL,NULL,NULL,NULL),(21239,979,25,33.3226,NULL,NULL,NULL,NULL),(21240,979,25.5,33.6631,NULL,NULL,NULL,NULL),(21241,979,26,33.8315,NULL,NULL,NULL,NULL),(21242,979,26.5,34.2581,NULL,NULL,NULL,NULL),(21243,979,27,10.5161,NULL,1,NULL,NULL),(21244,979,27.5,9.81362,NULL,1,NULL,NULL),(21245,979,28.1,8.93907,NULL,1,NULL,NULL),(21246,979,28.5,8.84588,NULL,1,NULL,NULL),(21247,979,29,8.49104,NULL,1,NULL,NULL),(21248,979,29.5,8.6595,NULL,1,NULL,NULL),(21249,979,30,8.56272,NULL,1,NULL,NULL),(21250,979,30.5,8.64516,NULL,1,NULL,NULL),(21251,979,31,8.46237,NULL,1,NULL,NULL),(21252,979,31.5,8.5448,NULL,1,NULL,NULL),(21253,979,32.1,8.45161,NULL,1,NULL,NULL),(21254,979,32.5,8.44444,NULL,1,NULL,NULL),(21255,979,33.1,8.35125,NULL,1,NULL,NULL),(21256,979,33.5,8.34409,NULL,1,NULL,NULL),(21257,979,34,8.07885,NULL,1,NULL,NULL),(21258,979,34.5,8.07168,NULL,1,NULL,NULL),(21259,979,35,7.63082,NULL,1,NULL,NULL),(21260,980,0,43.7599,NULL,NULL,NULL,NULL),(21261,980,0.5,45.0251,NULL,NULL,NULL,NULL),(21262,980,1,46.2903,NULL,NULL,NULL,NULL),(21263,980,1.5,46.8602,NULL,NULL,NULL,NULL),(21264,980,2,47.319,NULL,NULL,NULL,NULL),(21265,980,2.5,48.0036,NULL,NULL,NULL,NULL),(21266,980,3,47.8817,NULL,NULL,NULL,NULL),(21267,980,3.5,48.2222,NULL,NULL,NULL,NULL),(21268,980,4,48.681,NULL,NULL,NULL,NULL),(21269,980,4.4,49.3692,NULL,NULL,NULL,NULL),(21270,980,5,49.362,NULL,NULL,NULL,NULL),(21271,980,5.5,49.4695,NULL,NULL,NULL,NULL),(21272,980,6.2,50.0394,NULL,NULL,NULL,NULL),(21273,980,6.5,50.8459,NULL,NULL,NULL,NULL),(21274,980,7,51.4158,NULL,NULL,NULL,NULL),(21275,980,7.5,52.3333,NULL,NULL,NULL,NULL),(21276,980,8,52.6738,NULL,NULL,NULL,NULL),(21277,980,8.5,53.1326,NULL,NULL,NULL,NULL),(21278,980,9,53.1254,NULL,NULL,NULL,NULL),(21279,980,9.5,53.2366,NULL,NULL,NULL,NULL),(21280,980,10,53.6918,NULL,NULL,NULL,NULL),(21281,980,10.5,54.147,NULL,NULL,NULL,NULL),(21282,980,11,54.2581,NULL,NULL,NULL,NULL),(21283,980,11.5,54.1362,NULL,NULL,NULL,NULL),(21284,980,12,54.362,NULL,NULL,NULL,NULL),(21285,980,12.5,54.9319,NULL,NULL,NULL,NULL),(21286,980,13,55.043,NULL,NULL,NULL,NULL),(21287,980,13.5,55.7312,NULL,NULL,NULL,NULL),(21288,980,14,55.9534,NULL,NULL,NULL,NULL),(21289,980,14.5,56.4122,NULL,NULL,NULL,NULL),(21290,980,15,56.8674,NULL,NULL,NULL,NULL),(21291,980,15.5,57.3226,NULL,NULL,NULL,NULL),(21292,980,16,57.6631,NULL,NULL,NULL,NULL),(21293,980,16.5,57.8889,NULL,NULL,NULL,NULL),(21294,980,17,57.9964,NULL,NULL,NULL,NULL),(21295,980,17.5,58.4552,NULL,NULL,NULL,NULL),(21296,980,18,58.6774,NULL,NULL,NULL,NULL),(21297,980,18.5,59.1362,NULL,NULL,NULL,NULL),(21298,980,19,59.4767,NULL,NULL,NULL,NULL),(21299,980,19.5,59.8172,NULL,NULL,NULL,NULL),(21300,980,20,60.043,NULL,NULL,NULL,NULL),(21301,980,20.5,60.2688,NULL,NULL,NULL,NULL),(21302,980,21,60.3763,NULL,NULL,NULL,NULL),(21303,980,21.5,60.7168,NULL,NULL,NULL,NULL),(21304,980,22,60.828,NULL,NULL,NULL,NULL),(21305,980,22.5,60.9355,NULL,NULL,NULL,NULL),(21306,980,23,61.0466,NULL,NULL,NULL,NULL),(21307,980,23.5,61.2724,NULL,NULL,NULL,NULL),(21308,980,24,61.3799,NULL,NULL,NULL,NULL),(21309,980,24.5,61.6057,NULL,NULL,NULL,NULL),(21310,980,25,61.7168,NULL,NULL,NULL,NULL),(21311,980,25.5,62.0573,NULL,NULL,NULL,NULL),(21312,980,26,61.9355,NULL,NULL,NULL,NULL),(21313,980,28,62.3728,NULL,NULL,NULL,NULL),(21314,980,28.5,62.4839,NULL,NULL,NULL,NULL),(21315,980,29,62.4803,NULL,NULL,NULL,NULL),(21316,980,29.5,62.4731,NULL,NULL,NULL,NULL),(21317,980,30,62.466,NULL,NULL,NULL,NULL),(21318,980,30.5,62.4624,NULL,NULL,NULL,NULL),(21319,980,31,62.4552,NULL,NULL,NULL,NULL),(21320,980,31.5,62.5663,NULL,NULL,NULL,NULL),(21321,980,32,62.7885,NULL,NULL,NULL,NULL),(21322,980,32.01,26.534,NULL,1,NULL,NULL),(21323,980,32.5,25.491,NULL,1,NULL,NULL),(21324,980,33,24.2115,NULL,1,NULL,NULL),(21325,980,33.5,24.0932,NULL,1,NULL,NULL),(21326,980,34,24.2007,NULL,1,NULL,NULL),(21327,980,34.5,23.6201,NULL,1,NULL,NULL),(21328,980,35,23.4982,NULL,1,NULL,NULL),(21329,980,35.5,23.147,NULL,1,NULL,NULL),(21330,980,36.1,22.7921,NULL,1,NULL,NULL),(21331,980,36.5,22.6703,NULL,1,NULL,NULL),(21332,980,37,22.5484,NULL,1,NULL,NULL),(21333,980,37.5,22.3154,NULL,1,NULL,NULL),(21334,980,38,21.8459,NULL,1,NULL,NULL),(21335,980,38.5,21.957,NULL,1,NULL,NULL),(21336,980,39,21.8351,NULL,1,NULL,NULL),(21337,980,39.5,21.5986,NULL,1,NULL,NULL),(21338,980,40,21.362,NULL,1,NULL,NULL),(21339,980,40.5,21.3548,NULL,1,NULL,NULL),(21340,980,41,21.3477,NULL,1,NULL,NULL),(21341,981,0,37.0645,NULL,NULL,NULL,NULL),(21342,981,0.5,38.9068,NULL,NULL,NULL,NULL),(21343,981,1,40.4014,NULL,NULL,NULL,NULL),(21344,981,1.5,41.7814,NULL,NULL,NULL,NULL),(21345,981,2,42.4695,NULL,NULL,NULL,NULL),(21346,981,2.5,43.3871,NULL,NULL,NULL,NULL),(21347,981,3,43.957,NULL,NULL,NULL,NULL),(21348,981,3.5,44.4122,NULL,NULL,NULL,NULL),(21349,981,4,44.871,NULL,NULL,NULL,NULL),(21350,981,4.5,45.4409,NULL,NULL,NULL,NULL),(21351,981,5,45.8996,NULL,NULL,NULL,NULL),(21352,981,5.5,46.3548,NULL,NULL,NULL,NULL),(21353,981,6,46.5771,NULL,NULL,NULL,NULL),(21354,981,6.5,46.6882,NULL,NULL,NULL,NULL),(21355,981,7,46.7957,NULL,NULL,NULL,NULL),(21356,981,7.5,47.1398,NULL,NULL,NULL,NULL),(21357,981,8,47.1326,NULL,NULL,NULL,NULL),(21358,981,8.5,47.3584,NULL,NULL,NULL,NULL),(21359,981,9,47.5842,NULL,NULL,NULL,NULL),(21360,981,9.5,47.5771,NULL,NULL,NULL,NULL),(21361,981,10,47.8029,NULL,NULL,NULL,NULL),(21362,981,10.5,48.1434,NULL,NULL,NULL,NULL),(21363,981,11,48.4839,NULL,NULL,NULL,NULL),(21364,981,11.5,48.595,NULL,NULL,NULL,NULL),(21365,981,12,48.4731,NULL,NULL,NULL,NULL),(21366,981,14,48.1039,NULL,NULL,NULL,NULL),(21367,981,14.5,48.2115,NULL,NULL,NULL,NULL),(21368,981,15,48.552,NULL,NULL,NULL,NULL),(21369,981,15.4,48.7778,NULL,NULL,NULL,NULL),(21370,981,16,48.8889,NULL,NULL,NULL,NULL),(21371,981,16.5,48.9964,NULL,NULL,NULL,NULL),(21372,981,17,49.3369,NULL,NULL,NULL,NULL),(21373,981,17.5,49.5627,NULL,NULL,NULL,NULL),(21374,981,18,49.5591,NULL,NULL,NULL,NULL),(21375,981,18.5,49.6667,NULL,NULL,NULL,NULL),(21376,981,19,49.5448,NULL,NULL,NULL,NULL),(21377,981,19.5,49.6559,NULL,NULL,NULL,NULL),(21378,981,20,49.767,NULL,NULL,NULL,NULL),(21379,981,20.5,49.8746,NULL,NULL,NULL,NULL),(21380,981,21,49.9857,NULL,NULL,NULL,NULL),(21381,981,21.5,50.0932,NULL,NULL,NULL,NULL),(21382,981,22,50.0896,NULL,NULL,NULL,NULL),(21383,981,22.5,50.0824,NULL,NULL,NULL,NULL),(21384,981,23,50.1936,NULL,NULL,NULL,NULL),(21385,981,23.5,50.0717,NULL,NULL,NULL,NULL),(21386,981,24,50.0645,NULL,NULL,NULL,NULL),(21387,981,24.5,50.1756,NULL,NULL,NULL,NULL),(21388,981,25,50.1685,NULL,NULL,NULL,NULL),(21389,981,25.4,50.5125,NULL,NULL,NULL,NULL),(21390,981,26,50.8495,NULL,NULL,NULL,NULL),(21391,981,26.5,50.7312,NULL,NULL,NULL,NULL),(21392,981,27,50.3763,NULL,NULL,NULL,NULL),(21393,981,27.5,50.7168,NULL,NULL,NULL,NULL),(21394,981,28,50.7133,NULL,NULL,NULL,NULL),(21395,981,28.5,50.8208,NULL,NULL,NULL,NULL),(21396,981,29,50.9319,NULL,NULL,NULL,NULL),(21397,981,29.5,51.1577,NULL,NULL,NULL,NULL),(21398,981,30,51.1505,NULL,NULL,NULL,NULL),(21399,981,30.5,51.491,NULL,NULL,NULL,NULL),(21400,981,31,51.4875,NULL,NULL,NULL,NULL),(21401,981,31.5,51.828,NULL,NULL,NULL,NULL),(21402,981,32,51.7061,NULL,NULL,NULL,NULL),(21403,981,32.01,17.1828,NULL,1,NULL,NULL),(21404,981,32.5,14.9821,NULL,1,NULL,NULL),(21405,981,33,13.7061,NULL,1,NULL,NULL),(21406,981,33.5,12.7778,NULL,1,NULL,NULL),(21407,981,34,12.1935,NULL,1,NULL,NULL),(21408,981,34.5,12.0717,NULL,1,NULL,NULL),(21409,981,35,11.8351,NULL,1,NULL,NULL),(21410,981,35.5,11.4839,NULL,1,NULL,NULL),(21411,981,36,11.129,NULL,1,NULL,NULL),(21412,981,36.5,10.7778,NULL,1,NULL,NULL),(21413,981,37,10.0824,NULL,1,NULL,NULL),(21414,981,37.5,9.84229,NULL,1,NULL,NULL),(21415,981,38,9.49104,NULL,1,NULL,NULL),(21416,981,38.5,9.25448,NULL,1,NULL,NULL),(21417,981,39,9.01792,NULL,1,NULL,NULL),(21418,981,39.5,9.01075,NULL,1,NULL,NULL),(21419,981,40,9.00717,NULL,1,NULL,NULL),(21420,981,40.5,9,NULL,1,NULL,NULL),(21421,981,41,8.76344,NULL,1,NULL,NULL),(21422,982,0,46.3431,NULL,NULL,NULL,NULL),(21423,982,0.5,50.0584,NULL,NULL,NULL,NULL),(21424,982,1,52.7007,NULL,NULL,NULL,NULL),(21425,982,1.5,53.7518,NULL,NULL,NULL,NULL),(21426,982,2,54.2701,NULL,NULL,NULL,NULL),(21427,982,2.5,54.7883,NULL,NULL,NULL,NULL),(21428,982,3,54.7737,NULL,NULL,NULL,NULL),(21429,982,3.5,55.8248,NULL,NULL,NULL,NULL),(21430,982,4,56.5182,NULL,NULL,NULL,NULL),(21431,982,4.5,57.0438,NULL,NULL,NULL,NULL),(21432,982,5,57.9124,NULL,NULL,NULL,NULL),(21433,982,5.5,58.0803,NULL,NULL,NULL,NULL),(21434,982,6,58.0657,NULL,NULL,NULL,NULL),(21435,982,6.5,58.2263,NULL,NULL,NULL,NULL),(21436,982,7,58.7445,NULL,NULL,NULL,NULL),(21437,982,7.5,58.9051,NULL,NULL,NULL,NULL),(21438,982,7.9,58.8978,NULL,NULL,NULL,NULL),(21439,982,8.5,59.0584,NULL,NULL,NULL,NULL),(21440,982,9,59.3942,NULL,NULL,NULL,NULL),(21441,982,9.5,59.3869,NULL,NULL,NULL,NULL),(21442,982,10,59.0146,NULL,NULL,NULL,NULL),(21443,982,10.5,60.0657,NULL,NULL,NULL,NULL),(21444,982,11.1,60.4015,NULL,NULL,NULL,NULL),(21445,982,11.5,60.7445,NULL,NULL,NULL,NULL),(21446,982,12,60.9051,NULL,NULL,NULL,NULL),(21447,982,12.5,61.781,NULL,NULL,NULL,NULL),(21448,982,13,61.7664,NULL,NULL,NULL,NULL),(21449,982,13.5,61.7518,NULL,NULL,NULL,NULL),(21450,982,14,62.0949,NULL,NULL,NULL,NULL),(21451,982,14.5,62.0803,NULL,NULL,NULL,NULL),(21452,982,15,62.5985,NULL,NULL,NULL,NULL),(21453,982,15.5,63.1168,NULL,NULL,NULL,NULL),(21454,982,16,63.4599,NULL,NULL,NULL,NULL),(21455,982,16.5,63.9708,NULL,NULL,NULL,NULL),(21456,982,17,64.4964,NULL,NULL,NULL,NULL),(21457,982,17.5,64.2993,NULL,NULL,NULL,NULL),(21458,982,18,63.7518,NULL,NULL,NULL,NULL),(21459,982,18.5,63.562,NULL,NULL,NULL,NULL),(21460,982,19,63.365,NULL,NULL,NULL,NULL),(21461,982,19.5,63.3577,NULL,NULL,NULL,NULL),(21462,982,20,64.2263,NULL,NULL,NULL,NULL),(21463,982,20.5,64.3942,NULL,NULL,NULL,NULL),(21464,982,21,64.5547,NULL,NULL,NULL,NULL),(21465,982,21.5,65.2482,NULL,NULL,NULL,NULL),(21466,982,22,65.2336,NULL,NULL,NULL,NULL),(21467,982,22.5,65.7591,NULL,NULL,NULL,NULL),(21468,982,23,65.562,NULL,NULL,NULL,NULL),(21469,982,23.5,65.9051,NULL,NULL,NULL,NULL),(21470,982,24,65.8905,NULL,NULL,NULL,NULL),(21471,982,24.5,65.6934,NULL,NULL,NULL,NULL),(21472,982,25,66.0365,NULL,NULL,NULL,NULL),(21473,982,25.5,66.0219,NULL,NULL,NULL,NULL),(21474,982,26,65.8321,NULL,NULL,NULL,NULL),(21475,982,26.5,65.8175,NULL,NULL,NULL,NULL),(21476,982,27,65.2701,NULL,NULL,NULL,NULL),(21477,982,27.5,65.2555,NULL,NULL,NULL,NULL),(21478,982,28,65.0657,NULL,NULL,NULL,NULL),(21479,982,28.5,65.9343,NULL,NULL,NULL,NULL),(21480,982,29,66.4526,NULL,NULL,NULL,NULL),(21481,982,29.5,66.9708,NULL,NULL,NULL,NULL),(21482,982,30,67.4891,NULL,NULL,NULL,NULL),(21483,982,30.5,68.1898,NULL,NULL,NULL,NULL),(21484,982,31,68.3504,NULL,NULL,NULL,NULL),(21485,982,31.5,67.9781,NULL,NULL,NULL,NULL),(21486,982,32,67.7883,NULL,NULL,NULL,NULL),(21487,982,32.5,24.2774,NULL,1,NULL,NULL),(21488,982,33.1,23.3723,NULL,1,NULL,NULL),(21489,982,33.5,22.292,NULL,1,NULL,NULL),(21490,982,34,21.7445,NULL,1,NULL,NULL),(21491,982,34.5,21.0219,NULL,1,NULL,NULL),(21492,982,35,20.8248,NULL,1,NULL,NULL),(21493,982,35.5,20.2847,NULL,1,NULL,NULL),(21494,982,36,20.0876,NULL,1,NULL,NULL),(21495,982,36.5,19.5401,NULL,1,NULL,NULL),(21496,982,37,19.8832,NULL,1,NULL,NULL),(21497,982,37.5,19.5182,NULL,1,NULL,NULL),(21498,982,38,19.3212,NULL,1,NULL,NULL),(21499,982,38.5,18.9562,NULL,1,NULL,NULL),(21500,982,38.9,19.4745,NULL,1,NULL,NULL),(21501,982,39.5,18.7445,NULL,1,NULL,NULL),(21502,983,0,47.4088,NULL,NULL,NULL,NULL),(21503,983,0.5,50.4088,NULL,NULL,NULL,NULL),(21504,983,1,52.7007,NULL,NULL,NULL,NULL),(21505,983,1.5,54.1095,NULL,NULL,NULL,NULL),(21506,983,2,54.6277,NULL,NULL,NULL,NULL),(21507,983,2.5,54.7883,NULL,NULL,NULL,NULL),(21508,983,3,55.3139,NULL,NULL,NULL,NULL),(21509,983,3.5,56.0073,NULL,NULL,NULL,NULL),(21510,983,4,56.3431,NULL,NULL,NULL,NULL),(21511,983,4.5,57.219,NULL,NULL,NULL,NULL),(21512,983,5,57.562,NULL,NULL,NULL,NULL),(21513,983,5.5,57.7226,NULL,NULL,NULL,NULL),(21514,983,6,58.2409,NULL,NULL,NULL,NULL),(21515,983,6.5,58.4015,NULL,NULL,NULL,NULL),(21516,983,7,58.0365,NULL,NULL,NULL,NULL),(21517,983,7.5,58.5547,NULL,NULL,NULL,NULL),(21518,983,8,58.7153,NULL,NULL,NULL,NULL),(21519,983,8.5,59.2336,NULL,NULL,NULL,NULL),(21520,983,9,59.7518,NULL,NULL,NULL,NULL),(21521,983,9.5,60.0949,NULL,NULL,NULL,NULL),(21522,983,10,60.2555,NULL,NULL,NULL,NULL),(21523,983,10.5,61.1314,NULL,NULL,NULL,NULL),(21524,983,11,60.5839,NULL,NULL,NULL,NULL),(21525,983,11.5,60.9197,NULL,NULL,NULL,NULL),(21526,983,12,61.0876,NULL,NULL,NULL,NULL),(21527,983,12.5,62.1387,NULL,NULL,NULL,NULL),(21528,983,13,63.0146,NULL,NULL,NULL,NULL),(21529,983,13.5,64.2409,NULL,NULL,NULL,NULL),(21530,983,14,66.1752,NULL,NULL,NULL,NULL),(21531,983,14.5,67.2263,NULL,NULL,NULL,NULL),(21532,983,15,68.1022,NULL,NULL,NULL,NULL),(21533,983,15.5,68.0876,NULL,NULL,NULL,NULL),(21534,983,16,67.8978,NULL,NULL,NULL,NULL),(21535,983,16.5,68.4161,NULL,NULL,NULL,NULL),(21536,983,17,68.5766,NULL,NULL,NULL,NULL),(21537,983,17.5,68.0292,NULL,NULL,NULL,NULL),(21538,983,19,69.5839,NULL,NULL,NULL,NULL),(21539,983,19.5,69.927,NULL,NULL,NULL,NULL),(21540,983,20,69.9124,NULL,NULL,NULL,NULL),(21541,983,20.5,69.8978,NULL,NULL,NULL,NULL),(21542,983,21,70.2336,NULL,NULL,NULL,NULL),(21543,983,21.5,70.4015,NULL,NULL,NULL,NULL),(21544,983,22,70.562,NULL,NULL,NULL,NULL),(21545,983,22.5,70.5474,NULL,NULL,NULL,NULL),(21546,983,23,71.0657,NULL,NULL,NULL,NULL),(21547,983,23.6,70.8759,NULL,NULL,NULL,NULL),(21548,983,24,71.0365,NULL,NULL,NULL,NULL),(21549,983,24.5,71.3796,NULL,NULL,NULL,NULL),(21550,983,25,71.1898,NULL,NULL,NULL,NULL),(21551,983,25.5,70.9927,NULL,NULL,NULL,NULL),(21552,983,26,71.5109,NULL,NULL,NULL,NULL),(21553,983,26.5,71.4964,NULL,NULL,NULL,NULL),(21554,983,27,70.7737,NULL,NULL,NULL,NULL),(21555,983,27.5,70.7591,NULL,NULL,NULL,NULL),(21556,983,29,72.1387,NULL,NULL,NULL,NULL),(21557,983,29.5,71.7664,NULL,NULL,NULL,NULL),(21558,983,30,72.1095,NULL,NULL,NULL,NULL),(21559,983,30.5,72.4453,NULL,NULL,NULL,NULL),(21560,983,31,72.4307,NULL,NULL,NULL,NULL),(21561,983,31.5,72.4161,NULL,NULL,NULL,NULL),(21562,983,32,72.2263,NULL,NULL,NULL,NULL),(21563,983,32.5,72.0365,NULL,NULL,NULL,NULL),(21564,983,32.51,27.4745,NULL,1,NULL,NULL),(21565,983,33,23.7299,NULL,1,NULL,NULL),(21566,983,33.5,22.6496,NULL,1,NULL,NULL),(21567,983,34,21.7445,NULL,1,NULL,NULL),(21568,983,34.5,21.0219,NULL,1,NULL,NULL),(21569,983,35,20.8321,NULL,1,NULL,NULL),(21570,983,35.5,20.635,NULL,1,NULL,NULL),(21571,983,36,20.2701,NULL,1,NULL,NULL),(21572,983,36.5,19.365,NULL,1,NULL,NULL),(21573,983,37,19.5255,NULL,1,NULL,NULL),(21574,983,37.5,19.8686,NULL,1,NULL,NULL),(21575,983,38,19.854,NULL,1,NULL,NULL),(21576,983,38.5,19.1314,NULL,1,NULL,NULL),(21577,983,39,18.7591,NULL,1,NULL,NULL),(21578,983,39.5,18.0365,NULL,1,NULL,NULL),(21579,984,0.05,6.7,NULL,NULL,NULL,NULL),(21580,984,0.1,16.8,NULL,NULL,NULL,NULL),(21581,984,0.2,22.4,NULL,NULL,NULL,NULL),(21582,984,0.3,29.1,NULL,NULL,NULL,NULL),(21583,984,0.4,30.9,NULL,NULL,NULL,NULL),(21584,984,0.5,32,NULL,NULL,NULL,NULL),(21585,984,0.6,33.6,NULL,NULL,NULL,NULL),(21586,984,0.65,35,NULL,NULL,NULL,NULL),(21587,984,0.7,35.8,NULL,NULL,NULL,NULL),(21588,984,0.8,36.6,NULL,NULL,NULL,NULL),(21589,984,0.9,37.2,NULL,NULL,NULL,NULL),(21590,984,1,37.7,NULL,NULL,NULL,NULL),(21591,984,1.5,41,NULL,NULL,NULL,NULL),(21592,984,2,43.2,NULL,NULL,NULL,NULL),(21593,984,2.5,44.5,NULL,NULL,NULL,NULL),(21594,984,3,45.6,NULL,NULL,NULL,NULL),(21595,984,3.5,46.6,NULL,NULL,NULL,NULL),(21596,984,4,47.6,NULL,NULL,NULL,NULL),(21597,984,4.5,48.1,NULL,NULL,NULL,NULL),(21598,984,5,49.1,NULL,NULL,NULL,NULL),(21599,985,0.01,19,NULL,NULL,NULL,NULL),(21600,985,0.04,24.9,NULL,NULL,NULL,NULL),(21601,985,0.08,31.1,NULL,NULL,NULL,NULL),(21602,985,0.16,36.7,NULL,NULL,NULL,NULL),(21603,985,0.25,41.8,NULL,NULL,NULL,NULL),(21604,985,0.34,44.3,NULL,NULL,NULL,NULL),(21605,985,0.42,47.4,NULL,NULL,NULL,NULL),(21606,985,0.5,49,NULL,NULL,NULL,NULL),(21607,985,0.57,50,NULL,NULL,NULL,NULL),(21608,985,0.66,51.5,NULL,NULL,NULL,NULL),(21609,985,0.75,52.3,NULL,NULL,NULL,NULL),(21610,985,0.82,52.9,NULL,NULL,NULL,NULL),(21611,985,1,53.6,NULL,NULL,NULL,NULL),(21612,985,1.5,56.9,NULL,NULL,NULL,NULL),(21613,985,2,58.8,NULL,NULL,NULL,NULL),(21614,985,2.5,60.2,NULL,NULL,NULL,NULL),(21615,985,3,61.3,NULL,NULL,NULL,NULL),(21616,985,3.5,61.9,NULL,NULL,NULL,NULL),(21617,985,4,62.3,NULL,NULL,NULL,NULL),(21618,985,4.5,62.7,NULL,NULL,NULL,NULL),(21619,985,5,63.2,NULL,NULL,NULL,NULL),(21620,986,0.01,18.8,NULL,NULL,NULL,NULL),(21621,986,0.02,24.8,NULL,NULL,NULL,NULL),(21622,986,0.04,32.1,NULL,NULL,NULL,NULL),(21623,986,0.09,40.5,NULL,NULL,NULL,NULL),(21624,986,0.15,49.7,NULL,NULL,NULL,NULL),(21625,986,0.25,55.2,NULL,NULL,NULL,NULL),(21626,986,0.35,60.3,NULL,NULL,NULL,NULL),(21627,986,0.4,63.4,NULL,NULL,NULL,NULL),(21628,986,0.5,66,NULL,NULL,NULL,NULL),(21629,986,0.6,67.3,NULL,NULL,NULL,NULL),(21630,986,0.7,69.8,NULL,NULL,NULL,NULL),(21631,986,0.75,70.8,NULL,NULL,NULL,NULL),(21632,986,0.85,72.7,NULL,NULL,NULL,NULL),(21633,986,0.9,74.4,NULL,NULL,NULL,NULL),(21634,986,1,75.3,NULL,NULL,NULL,NULL),(21635,986,1.5,80.3,NULL,NULL,NULL,NULL),(21636,986,2,83.5,NULL,NULL,NULL,NULL),(21637,986,2.5,86,NULL,NULL,NULL,NULL),(21638,986,3,88.5,NULL,NULL,NULL,NULL),(21639,986,3.5,89.5,NULL,NULL,NULL,NULL),(21640,986,4,90.7,NULL,NULL,NULL,NULL),(21641,986,4.5,91.1,NULL,NULL,NULL,NULL),(21642,986,5,91.3,NULL,NULL,NULL,NULL),(21643,987,0,-4.9,NULL,NULL,NULL,NULL),(21644,987,0.07,0.2,NULL,NULL,NULL,NULL),(21645,987,0.15,6.9,NULL,NULL,NULL,NULL),(21646,987,0.23,9.6,NULL,NULL,NULL,NULL),(21647,987,0.31,12.3,NULL,NULL,NULL,NULL),(21648,987,0.4,13.6,NULL,NULL,NULL,NULL),(21649,987,0.48,14.6,NULL,NULL,NULL,NULL),(21650,987,0.57,15.3,NULL,NULL,NULL,NULL),(21651,987,0.64,16.3,NULL,NULL,NULL,NULL),(21652,987,0.72,17.1,NULL,NULL,NULL,NULL),(21653,987,0.81,17.9,NULL,NULL,NULL,NULL),(21654,987,0.89,18.4,NULL,NULL,NULL,NULL),(21655,987,0.98,19.3,NULL,NULL,NULL,NULL),(21656,987,1.06,19.8,NULL,NULL,NULL,NULL),(21657,987,1.14,20.2,NULL,NULL,NULL,NULL),(21658,987,1.23,20.6,NULL,NULL,NULL,NULL),(21659,987,1.31,21.2,NULL,NULL,NULL,NULL),(21660,987,1.39,21.6,NULL,NULL,NULL,NULL),(21661,987,1.48,22.4,NULL,NULL,NULL,NULL),(21662,987,1.57,22.8,NULL,NULL,NULL,NULL),(21663,987,1.64,23.4,NULL,NULL,NULL,NULL),(21664,987,1.73,24,NULL,NULL,NULL,NULL),(21665,987,1.8,24.5,NULL,NULL,NULL,NULL),(21666,987,1.9,25,NULL,NULL,NULL,NULL),(21667,987,1.98,25.3,NULL,NULL,NULL,NULL),(21668,987,2.06,25.9,NULL,NULL,NULL,NULL),(21669,987,2.14,26.3,NULL,NULL,NULL,NULL),(21670,987,2.22,26.4,NULL,NULL,NULL,NULL),(21671,987,2.31,27,NULL,NULL,NULL,NULL),(21672,987,2.39,27.1,NULL,NULL,NULL,NULL),(21673,987,2.48,27.4,NULL,NULL,NULL,NULL),(21674,987,2.57,27.8,NULL,NULL,NULL,NULL),(21675,987,2.64,28.4,NULL,NULL,NULL,NULL),(21676,987,2.72,28.6,NULL,NULL,NULL,NULL),(21677,987,2.81,28.9,NULL,NULL,NULL,NULL),(21678,987,2.89,29,NULL,NULL,NULL,NULL),(21679,987,2.98,29.4,NULL,NULL,NULL,NULL),(21680,987,3.06,29.5,NULL,NULL,NULL,NULL),(21681,987,3.15,30,NULL,NULL,NULL,NULL),(21682,987,3.23,29.9,NULL,NULL,NULL,NULL),(21683,987,3.32,30.2,NULL,NULL,NULL,NULL),(21684,987,3.4,30.4,NULL,NULL,NULL,NULL),(21685,987,3.48,30.3,NULL,NULL,NULL,NULL),(21686,987,3.56,30.4,NULL,NULL,NULL,NULL),(21687,987,3.64,30.4,NULL,NULL,NULL,NULL),(21688,987,3.72,30.6,NULL,NULL,NULL,NULL),(21689,987,3.82,30.6,NULL,NULL,NULL,NULL),(21690,987,3.9,30.8,NULL,NULL,NULL,NULL),(21691,987,3.98,30.9,NULL,NULL,NULL,NULL),(21692,987,4.06,31.1,NULL,NULL,NULL,NULL),(21693,987,4.15,31.1,NULL,NULL,NULL,NULL),(21694,987,4.24,31,NULL,NULL,NULL,NULL),(21695,987,4.31,30.9,NULL,NULL,NULL,NULL),(21696,987,4.4,31.1,NULL,NULL,NULL,NULL),(21697,987,4.49,31.2,NULL,NULL,NULL,NULL),(21698,987,4.57,31.1,NULL,NULL,NULL,NULL),(21699,987,4.66,31.2,NULL,NULL,NULL,NULL),(21700,987,4.74,31.2,NULL,NULL,NULL,NULL),(21701,987,4.82,31.3,NULL,NULL,NULL,NULL),(21702,987,4.9,31.3,NULL,NULL,NULL,NULL),(21703,987,4.97,31.2,NULL,NULL,NULL,NULL),(21704,988,0.01,10.8,NULL,NULL,NULL,NULL),(21705,988,0.04,14.3,NULL,NULL,NULL,NULL),(21706,988,0.16,18.9,NULL,NULL,NULL,NULL),(21707,988,0.24,21.5,NULL,NULL,NULL,NULL),(21708,988,0.32,24.5,NULL,NULL,NULL,NULL),(21709,988,0.42,27.1,NULL,NULL,NULL,NULL),(21710,988,0.5,29.8,NULL,NULL,NULL,NULL),(21711,988,0.58,30.5,NULL,NULL,NULL,NULL),(21712,988,0.67,30.7,NULL,NULL,NULL,NULL),(21713,988,0.75,30.7,NULL,NULL,NULL,NULL),(21714,988,0.82,33,NULL,NULL,NULL,NULL),(21715,988,0.91,33.9,NULL,NULL,NULL,NULL),(21716,988,1.08,33.9,NULL,NULL,NULL,NULL),(21717,988,1.16,34.6,NULL,NULL,NULL,NULL),(21718,988,1.24,36.6,NULL,NULL,NULL,NULL),(21719,988,1.34,38.1,NULL,NULL,NULL,NULL),(21720,988,1.41,38.3,NULL,NULL,NULL,NULL),(21721,988,1.5,38.2,NULL,NULL,NULL,NULL),(21722,988,1.58,40.1,NULL,NULL,NULL,NULL),(21723,988,1.66,41.8,NULL,NULL,NULL,NULL),(21724,988,1.75,41.1,NULL,NULL,NULL,NULL),(21725,988,1.83,43.9,NULL,NULL,NULL,NULL),(21726,988,1.92,42,NULL,NULL,NULL,NULL),(21727,988,2,44.2,NULL,NULL,NULL,NULL),(21728,988,2.09,44.3,NULL,NULL,NULL,NULL),(21729,988,2.17,45.2,NULL,NULL,NULL,NULL),(21730,988,2.26,42.2,NULL,NULL,NULL,NULL),(21731,988,2.33,43.5,NULL,NULL,NULL,NULL),(21732,988,2.42,43,NULL,NULL,NULL,NULL),(21733,988,2.49,44.5,NULL,NULL,NULL,NULL),(21734,988,2.57,45.8,NULL,NULL,NULL,NULL),(21735,988,2.66,46.4,NULL,NULL,NULL,NULL),(21736,988,2.74,46.9,NULL,NULL,NULL,NULL),(21737,988,2.83,48.5,NULL,NULL,NULL,NULL),(21738,988,3,48.2,NULL,NULL,NULL,NULL),(21739,988,3.08,48.2,NULL,NULL,NULL,NULL),(21740,988,3.18,48.5,NULL,NULL,NULL,NULL),(21741,988,3.25,49.8,NULL,NULL,NULL,NULL),(21742,988,3.33,48.2,NULL,NULL,NULL,NULL),(21743,988,3.41,49.8,NULL,NULL,NULL,NULL),(21744,988,3.5,48.6,NULL,NULL,NULL,NULL),(21745,988,3.6,47.7,NULL,NULL,NULL,NULL),(21746,988,3.67,47.7,NULL,NULL,NULL,NULL),(21747,988,3.75,48.6,NULL,NULL,NULL,NULL),(21748,988,3.84,50.3,NULL,NULL,NULL,NULL),(21749,988,3.92,49.9,NULL,NULL,NULL,NULL),(21750,988,4,51.1,NULL,NULL,NULL,NULL),(21751,988,4.09,50.7,NULL,NULL,NULL,NULL),(21752,988,4.17,51.7,NULL,NULL,NULL,NULL),(21753,988,4.26,51.4,NULL,NULL,NULL,NULL),(21754,988,4.33,50.6,NULL,NULL,NULL,NULL),(21755,988,4.42,50.6,NULL,NULL,NULL,NULL),(21756,988,4.51,50.6,NULL,NULL,NULL,NULL),(21757,988,4.59,52.1,NULL,NULL,NULL,NULL),(21758,988,4.68,51.5,NULL,NULL,NULL,NULL),(21759,988,4.76,51.2,NULL,NULL,NULL,NULL),(21760,988,4.85,51.6,NULL,NULL,NULL,NULL),(21761,988,4.93,51.7,NULL,NULL,NULL,NULL),(21762,988,5,51,NULL,NULL,NULL,NULL),(21763,989,0,8.9,NULL,NULL,NULL,NULL),(21764,989,0.02,14.4,NULL,NULL,NULL,NULL),(21765,989,0.07,15.3,NULL,NULL,NULL,NULL),(21766,989,0.15,21.5,NULL,NULL,NULL,NULL),(21767,989,0.23,23.6,NULL,NULL,NULL,NULL),(21768,989,0.31,26.5,NULL,NULL,NULL,NULL),(21769,989,0.4,29.6,NULL,NULL,NULL,NULL),(21770,989,0.48,33.6,NULL,NULL,NULL,NULL),(21771,989,0.56,33.1,NULL,NULL,NULL,NULL),(21772,989,0.64,36.5,NULL,NULL,NULL,NULL),(21773,989,0.74,39.8,NULL,NULL,NULL,NULL),(21774,989,0.81,42.5,NULL,NULL,NULL,NULL),(21775,989,0.89,43.2,NULL,NULL,NULL,NULL),(21776,989,0.98,46.8,NULL,NULL,NULL,NULL),(21777,989,1.06,46.7,NULL,NULL,NULL,NULL),(21778,989,1.15,48.3,NULL,NULL,NULL,NULL),(21779,989,1.23,50.1,NULL,NULL,NULL,NULL),(21780,989,1.31,52.2,NULL,NULL,NULL,NULL),(21781,989,1.39,52.8,NULL,NULL,NULL,NULL),(21782,989,1.48,53.1,NULL,NULL,NULL,NULL),(21783,989,1.55,53.8,NULL,NULL,NULL,NULL),(21784,989,1.64,53.7,NULL,NULL,NULL,NULL),(21785,989,1.73,53.5,NULL,NULL,NULL,NULL),(21786,989,1.81,54,NULL,NULL,NULL,NULL),(21787,989,1.89,54.3,NULL,NULL,NULL,NULL),(21788,989,1.98,56.5,NULL,NULL,NULL,NULL),(21789,989,2.05,57.2,NULL,NULL,NULL,NULL),(21790,989,2.14,59.7,NULL,NULL,NULL,NULL),(21791,989,2.23,63,NULL,NULL,NULL,NULL),(21792,989,2.31,63.8,NULL,NULL,NULL,NULL),(21793,989,2.39,61.4,NULL,NULL,NULL,NULL),(21794,989,2.48,63.2,NULL,NULL,NULL,NULL),(21795,989,2.56,64.6,NULL,NULL,NULL,NULL),(21796,989,2.65,66.4,NULL,NULL,NULL,NULL),(21797,989,2.72,66.2,NULL,NULL,NULL,NULL),(21798,989,2.8,67.2,NULL,NULL,NULL,NULL),(21799,989,2.89,66.8,NULL,NULL,NULL,NULL),(21800,989,2.97,67.5,NULL,NULL,NULL,NULL),(21801,989,3.06,66.3,NULL,NULL,NULL,NULL),(21802,989,3.15,66.4,NULL,NULL,NULL,NULL),(21803,989,3.23,67.3,NULL,NULL,NULL,NULL),(21804,989,3.31,70.1,NULL,NULL,NULL,NULL),(21805,989,3.39,70.2,NULL,NULL,NULL,NULL),(21806,989,3.49,70.1,NULL,NULL,NULL,NULL),(21807,989,3.56,72.6,NULL,NULL,NULL,NULL),(21808,989,3.64,73.3,NULL,NULL,NULL,NULL),(21809,989,3.73,70.6,NULL,NULL,NULL,NULL),(21810,989,3.82,70.6,NULL,NULL,NULL,NULL),(21811,989,3.9,73.7,NULL,NULL,NULL,NULL),(21812,989,3.98,75.1,NULL,NULL,NULL,NULL),(21813,989,4.06,73.8,NULL,NULL,NULL,NULL),(21814,989,4.16,73.6,NULL,NULL,NULL,NULL),(21815,989,4.24,75.3,NULL,NULL,NULL,NULL),(21816,989,4.31,77.2,NULL,NULL,NULL,NULL),(21817,989,4.41,76.9,NULL,NULL,NULL,NULL),(21818,989,4.49,79.6,NULL,NULL,NULL,NULL),(21819,989,4.56,80.9,NULL,NULL,NULL,NULL),(21820,989,4.65,80.5,NULL,NULL,NULL,NULL),(21821,989,4.74,79.7,NULL,NULL,NULL,NULL),(21822,989,4.82,80.4,NULL,NULL,NULL,NULL),(21823,989,4.9,81.6,NULL,NULL,NULL,NULL),(21824,989,4.96,80.9,NULL,NULL,NULL,NULL),(21825,990,0.05,7.5,NULL,NULL,NULL,NULL),(21826,990,0.15,12.1,NULL,NULL,NULL,NULL),(21827,990,0.24,14.9,NULL,NULL,NULL,NULL),(21828,990,0.32,22.2,NULL,NULL,NULL,NULL),(21829,990,0.41,24.9,NULL,NULL,NULL,NULL),(21830,990,0.51,24.9,NULL,NULL,NULL,NULL),(21831,990,0.58,27.1,NULL,NULL,NULL,NULL),(21832,990,0.67,29.8,NULL,NULL,NULL,NULL),(21833,990,0.74,32.9,NULL,NULL,NULL,NULL),(21834,990,0.83,35.3,NULL,NULL,NULL,NULL),(21835,990,0.91,35.3,NULL,NULL,NULL,NULL),(21836,990,0.99,34.1,NULL,NULL,NULL,NULL),(21837,990,1.08,37.6,NULL,NULL,NULL,NULL),(21838,990,1.17,38.2,NULL,NULL,NULL,NULL),(21839,990,1.25,40.7,NULL,NULL,NULL,NULL),(21840,990,1.33,42.5,NULL,NULL,NULL,NULL),(21841,990,1.4,42.6,NULL,NULL,NULL,NULL),(21842,990,1.5,45.6,NULL,NULL,NULL,NULL),(21843,990,1.58,42.5,NULL,NULL,NULL,NULL),(21844,990,1.65,46.2,NULL,NULL,NULL,NULL),(21845,990,1.74,48.5,NULL,NULL,NULL,NULL),(21846,990,1.82,47.9,NULL,NULL,NULL,NULL),(21847,990,1.91,50.9,NULL,NULL,NULL,NULL),(21848,990,1.99,51,NULL,NULL,NULL,NULL),(21849,990,2.08,51.1,NULL,NULL,NULL,NULL),(21850,990,2.16,51.1,NULL,NULL,NULL,NULL),(21851,990,2.24,53.4,NULL,NULL,NULL,NULL),(21852,990,2.32,53.8,NULL,NULL,NULL,NULL),(21853,990,2.41,54.1,NULL,NULL,NULL,NULL),(21854,990,2.49,53.9,NULL,NULL,NULL,NULL),(21855,990,2.58,53.7,NULL,NULL,NULL,NULL),(21856,990,2.66,55.6,NULL,NULL,NULL,NULL),(21857,990,2.75,58.2,NULL,NULL,NULL,NULL),(21858,990,2.82,59.8,NULL,NULL,NULL,NULL),(21859,990,2.91,60.9,NULL,NULL,NULL,NULL),(21860,990,2.99,60.1,NULL,NULL,NULL,NULL),(21861,990,3.09,60.7,NULL,NULL,NULL,NULL),(21862,990,3.16,62.6,NULL,NULL,NULL,NULL),(21863,990,3.24,62.8,NULL,NULL,NULL,NULL),(21864,990,3.33,65.2,NULL,NULL,NULL,NULL),(21865,990,3.43,65.1,NULL,NULL,NULL,NULL),(21866,990,3.5,67.9,NULL,NULL,NULL,NULL),(21867,990,3.57,68.3,NULL,NULL,NULL,NULL),(21868,990,3.67,67.1,NULL,NULL,NULL,NULL),(21869,990,3.75,69.8,NULL,NULL,NULL,NULL),(21870,990,3.83,69.1,NULL,NULL,NULL,NULL),(21871,990,3.92,69.6,NULL,NULL,NULL,NULL),(21872,990,4.01,69.8,NULL,NULL,NULL,NULL),(21873,990,4.08,69.9,NULL,NULL,NULL,NULL),(21874,990,4.17,70.3,NULL,NULL,NULL,NULL),(21875,990,4.26,70.5,NULL,NULL,NULL,NULL),(21876,990,4.33,72.3,NULL,NULL,NULL,NULL),(21877,990,4.42,72.4,NULL,NULL,NULL,NULL),(21878,990,4.5,72.2,NULL,NULL,NULL,NULL),(21879,990,4.59,72.7,NULL,NULL,NULL,NULL),(21880,990,4.67,73.1,NULL,NULL,NULL,NULL),(21881,990,4.75,73.1,NULL,NULL,NULL,NULL),(21882,990,4.82,73.1,NULL,NULL,NULL,NULL),(21883,990,4.92,73.3,NULL,NULL,NULL,NULL),(21884,990,4.99,73.5,NULL,NULL,NULL,NULL),(21885,991,0.02,15.3333,NULL,NULL,NULL,NULL),(21886,991,0.07,35.0238,NULL,NULL,NULL,NULL),(21887,991,0.13,48.2381,NULL,NULL,NULL,NULL),(21888,991,0.19,57.2143,NULL,NULL,NULL,NULL),(21889,991,0.25,62.4762,NULL,NULL,NULL,NULL),(21890,991,0.3,65.2857,NULL,NULL,NULL,NULL),(21891,991,0.36,67,NULL,NULL,NULL,NULL),(21892,991,0.41,68.5,NULL,NULL,NULL,NULL),(21893,991,0.46,69.9762,NULL,NULL,NULL,NULL),(21894,991,0.51,70.7857,NULL,NULL,NULL,NULL),(21895,991,0.57,71.5714,NULL,NULL,NULL,NULL),(21896,991,0.61,72.0476,NULL,NULL,NULL,NULL),(21897,991,0.62,72.2381,NULL,NULL,NULL,NULL),(21898,991,0.66,72.9286,NULL,NULL,NULL,NULL),(21899,991,0.71,73.5714,NULL,NULL,NULL,NULL),(21900,991,0.76,73.9048,NULL,NULL,NULL,NULL),(21901,991,0.81,74.2381,NULL,NULL,NULL,NULL),(21902,991,0.85,74.7143,NULL,NULL,NULL,NULL),(21903,991,0.9,75.0238,NULL,NULL,NULL,NULL),(21904,991,0.95,75.381,NULL,NULL,NULL,NULL),(21905,991,0.99,75.881,NULL,NULL,NULL,NULL),(21906,991,1.04,76.1905,NULL,NULL,NULL,NULL),(21907,991,1.08,76.3333,NULL,NULL,NULL,NULL),(21908,991,1.13,76.6667,NULL,NULL,NULL,NULL),(21909,991,1.17,76.8095,NULL,NULL,NULL,NULL),(21910,991,1.21,77,NULL,NULL,NULL,NULL),(21911,991,1.26,77.1429,NULL,NULL,NULL,NULL),(21912,991,1.3,77.6667,NULL,NULL,NULL,NULL),(21913,991,1.34,77.8095,NULL,NULL,NULL,NULL),(21914,991,2.39,81.0952,NULL,NULL,NULL,NULL),(21915,991,2.43,81.4048,NULL,NULL,NULL,NULL),(21916,991,2.47,81.2381,NULL,NULL,NULL,NULL),(21917,991,2.51,81.2381,NULL,NULL,NULL,NULL),(21918,991,2.55,81.2143,NULL,NULL,NULL,NULL),(21919,991,2.59,81.4048,NULL,NULL,NULL,NULL),(21920,991,2.63,81.4048,NULL,NULL,NULL,NULL),(21921,991,2.67,81.5714,NULL,NULL,NULL,NULL),(21922,991,2.71,81.7381,NULL,NULL,NULL,NULL),(21923,991,2.75,81.5714,NULL,NULL,NULL,NULL),(21924,991,2.79,81.9048,NULL,NULL,NULL,NULL),(21925,991,2.83,81.9048,NULL,NULL,NULL,NULL),(21926,991,2.87,81.9048,NULL,NULL,NULL,NULL),(21927,991,2.91,82.0714,NULL,NULL,NULL,NULL),(21928,991,2.95,82.0714,NULL,NULL,NULL,NULL),(21929,991,2.99,82.0714,NULL,NULL,NULL,NULL),(21930,991,3.03,82.0714,NULL,NULL,NULL,NULL),(21931,991,3.07,82.2619,NULL,NULL,NULL,NULL),(21932,991,3.11,82.2381,NULL,NULL,NULL,NULL),(21933,991,3.15,82.2381,NULL,NULL,NULL,NULL),(21934,991,3.19,82.4286,NULL,NULL,NULL,NULL),(21935,991,3.23,82.2381,NULL,NULL,NULL,NULL),(21936,991,3.28,82.4286,NULL,NULL,NULL,NULL),(21937,991,3.32,82.5952,NULL,NULL,NULL,NULL),(21938,991,3.36,82.4048,NULL,NULL,NULL,NULL),(21939,991,3.4,82.5952,NULL,NULL,NULL,NULL),(21940,991,3.44,82.7619,NULL,NULL,NULL,NULL),(21941,991,3.48,82.9286,NULL,NULL,NULL,NULL),(21942,991,3.52,82.7857,NULL,NULL,NULL,NULL),(21943,991,3.56,82.9762,NULL,NULL,NULL,NULL),(21944,991,3.6,83.1429,NULL,NULL,NULL,NULL),(21945,991,3.64,83.1667,NULL,NULL,NULL,NULL),(21946,991,3.84,83.1429,NULL,NULL,NULL,NULL),(21947,991,3.88,83.3095,NULL,NULL,NULL,NULL),(21948,991,3.92,83.3095,NULL,NULL,NULL,NULL),(21949,991,3.96,83.3095,NULL,NULL,NULL,NULL),(21950,991,4,83.3095,NULL,NULL,NULL,NULL),(21951,991,4.04,83.5,NULL,NULL,NULL,NULL),(21952,991,4.08,83.5,NULL,NULL,NULL,NULL),(21953,991,4.12,83.4762,NULL,NULL,NULL,NULL),(21954,991,4.16,83.4762,NULL,NULL,NULL,NULL),(21955,991,4.2,83.4762,NULL,NULL,NULL,NULL),(21956,991,4.24,83.4762,NULL,NULL,NULL,NULL),(21957,991,4.28,83.4524,NULL,NULL,NULL,NULL),(21958,991,4.32,83.6429,NULL,NULL,NULL,NULL),(21959,991,4.36,83.8095,NULL,NULL,NULL,NULL),(21960,991,4.4,83.8095,NULL,NULL,NULL,NULL),(21961,991,4.44,83.8095,NULL,NULL,NULL,NULL),(21962,991,4.48,83.8333,NULL,NULL,NULL,NULL),(21963,991,4.52,83.8333,NULL,NULL,NULL,NULL),(21964,991,4.56,84,NULL,NULL,NULL,NULL),(21965,991,4.6,84,NULL,NULL,NULL,NULL),(21966,991,4.64,84,NULL,NULL,NULL,NULL),(21967,991,4.68,84.2381,NULL,NULL,NULL,NULL),(21968,991,4.72,84.2381,NULL,NULL,NULL,NULL),(21969,991,4.76,84,NULL,NULL,NULL,NULL),(21970,991,4.8,84.1667,NULL,NULL,NULL,NULL),(21971,991,4.84,84.1667,NULL,NULL,NULL,NULL),(21972,991,4.88,84.1667,NULL,NULL,NULL,NULL),(21973,991,4.91,84.1667,NULL,NULL,NULL,NULL),(21974,991,4.95,84.1667,NULL,NULL,NULL,NULL),(21975,991,4.99,84.3333,NULL,NULL,NULL,NULL),(21976,991,5.03,84.3333,NULL,NULL,NULL,NULL),(21977,991,5.07,84.5,NULL,NULL,NULL,NULL),(21978,991,5.11,84.3095,NULL,NULL,NULL,NULL),(21979,991,5.15,84.5,NULL,NULL,NULL,NULL),(21980,991,5.19,84.4762,NULL,NULL,NULL,NULL),(21981,991,5.23,84.4762,NULL,NULL,NULL,NULL),(21982,991,5.27,84.6667,NULL,NULL,NULL,NULL),(21983,991,5.31,84.6667,NULL,NULL,NULL,NULL),(21984,991,5.35,84.6667,NULL,NULL,NULL,NULL),(21985,991,5.39,84.6667,NULL,NULL,NULL,NULL),(21986,991,5.43,84.6429,NULL,NULL,NULL,NULL),(21987,991,5.47,84.6429,NULL,NULL,NULL,NULL),(21988,991,5.51,84.6667,NULL,NULL,NULL,NULL),(21989,991,5.55,85.0238,NULL,NULL,NULL,NULL),(21990,991,5.59,84.8571,NULL,NULL,NULL,NULL),(21991,991,5.63,84.8333,NULL,NULL,NULL,NULL),(21992,991,5.67,84.8333,NULL,NULL,NULL,NULL),(21993,991,5.71,85,NULL,NULL,NULL,NULL),(21994,991,5.75,85.0238,NULL,NULL,NULL,NULL),(21995,991,5.79,85.1905,NULL,NULL,NULL,NULL),(21996,991,5.83,85,NULL,NULL,NULL,NULL),(21997,991,5.87,85,NULL,NULL,NULL,NULL),(21998,991,5.91,85,NULL,NULL,NULL,NULL),(21999,991,5.95,85,NULL,NULL,NULL,NULL),(22000,991,5.99,85,NULL,NULL,NULL,NULL),(22001,991,6.03,85,NULL,NULL,NULL,NULL),(22002,991,6.07,85,NULL,NULL,NULL,NULL),(22003,991,6.11,85.1667,NULL,NULL,NULL,NULL),(22004,991,6.15,85.1667,NULL,NULL,NULL,NULL),(22005,991,6.19,85.3333,NULL,NULL,NULL,NULL),(22006,991,6.23,85.3333,NULL,NULL,NULL,NULL),(22007,991,6.27,85.3095,NULL,NULL,NULL,NULL),(22008,991,6.3,85.3095,NULL,NULL,NULL,NULL),(22009,991,6.34,85.5,NULL,NULL,NULL,NULL),(22010,991,6.38,85.5,NULL,NULL,NULL,NULL),(22011,991,6.42,85.3333,NULL,NULL,NULL,NULL),(22012,991,6.46,85.5476,NULL,NULL,NULL,NULL),(22013,991,6.49,85.5,NULL,NULL,NULL,NULL),(22014,991,6.53,85.3333,NULL,NULL,NULL,NULL),(22015,991,6.57,85.4762,NULL,NULL,NULL,NULL),(22016,991,6.61,85.4762,NULL,NULL,NULL,NULL),(22017,991,6.65,85.6429,NULL,NULL,NULL,NULL),(22018,991,6.69,85.6667,NULL,NULL,NULL,NULL),(22019,991,6.73,85.6667,NULL,NULL,NULL,NULL),(22020,991,6.77,85.6667,NULL,NULL,NULL,NULL),(22021,991,6.81,85.6667,NULL,NULL,NULL,NULL),(22022,991,6.85,85.6667,NULL,NULL,NULL,NULL),(22023,991,6.89,85.6429,NULL,NULL,NULL,NULL),(22024,991,6.93,85.8333,NULL,NULL,NULL,NULL),(22025,991,6.97,85.6429,NULL,NULL,NULL,NULL),(22026,991,8,86.3095,NULL,NULL,NULL,NULL),(22027,991,8.03,86.6429,NULL,NULL,NULL,NULL),(22028,991,8.08,86.6667,NULL,NULL,NULL,NULL),(22029,991,8.2,86.8333,NULL,NULL,NULL,NULL),(22030,991,8.32,86.6667,NULL,NULL,NULL,NULL),(22031,991,8.44,86.8333,NULL,NULL,NULL,NULL),(22032,991,8.56,87.5476,NULL,NULL,NULL,NULL),(22033,991,8.67,86.8333,NULL,NULL,NULL,NULL),(22034,991,8.79,86.8095,NULL,NULL,NULL,NULL),(22035,991,8.91,86.8095,NULL,NULL,NULL,NULL),(22036,991,9.03,86.9762,NULL,NULL,NULL,NULL),(22037,991,9.15,86.9762,NULL,NULL,NULL,NULL),(22038,991,9.26,87.1429,NULL,NULL,NULL,NULL),(22039,991,9.38,87.1429,NULL,NULL,NULL,NULL),(22040,991,9.5,87.3333,NULL,NULL,NULL,NULL),(22041,991,9.62,87.5,NULL,NULL,NULL,NULL),(22042,991,9.74,87.3095,NULL,NULL,NULL,NULL),(22043,991,9.85,87.1429,NULL,NULL,NULL,NULL),(22044,991,9.97,87.2857,NULL,NULL,NULL,NULL),(22045,991,10.09,87.4762,NULL,NULL,NULL,NULL),(22046,991,10.21,87.5,NULL,NULL,NULL,NULL),(22047,991,10.32,87.6667,NULL,NULL,NULL,NULL),(22048,991,10.44,87.6429,NULL,NULL,NULL,NULL),(22049,991,10.56,87.6429,NULL,NULL,NULL,NULL),(22050,991,10.68,87.6429,NULL,NULL,NULL,NULL),(22051,991,10.79,87.8095,NULL,NULL,NULL,NULL),(22052,991,10.91,87.6429,NULL,NULL,NULL,NULL),(22053,991,11.03,87.8095,NULL,NULL,NULL,NULL),(22054,991,11.15,88,NULL,NULL,NULL,NULL),(22055,991,11.26,88.1429,NULL,NULL,NULL,NULL),(22056,991,11.38,87.9762,NULL,NULL,NULL,NULL),(22057,991,11.5,88.1429,NULL,NULL,NULL,NULL),(22058,991,11.61,88.119,NULL,NULL,NULL,NULL),(22059,991,11.73,88.119,NULL,NULL,NULL,NULL),(22060,991,11.85,88.4762,NULL,NULL,NULL,NULL),(22061,991,11.96,88.2857,NULL,NULL,NULL,NULL),(22062,991,12.08,88.4762,NULL,NULL,NULL,NULL),(22063,991,12.2,88.4762,NULL,NULL,NULL,NULL),(22064,991,12.32,88.6667,NULL,NULL,NULL,NULL),(22065,991,12.43,88.6667,NULL,NULL,NULL,NULL),(22066,991,12.55,88.4762,NULL,NULL,NULL,NULL),(22067,991,12.67,88.6429,NULL,NULL,NULL,NULL),(22068,991,12.78,88.619,NULL,NULL,NULL,NULL),(22069,991,12.9,88.4762,NULL,NULL,NULL,NULL),(22070,991,13.02,88.8333,NULL,NULL,NULL,NULL),(22071,991,13.14,89,NULL,NULL,NULL,NULL),(22072,991,13.25,88.8095,NULL,NULL,NULL,NULL),(22073,991,13.37,89,NULL,NULL,NULL,NULL),(22074,991,13.49,88.8095,NULL,NULL,NULL,NULL),(22075,991,13.6,88.619,NULL,NULL,NULL,NULL),(22076,991,13.72,88.7857,NULL,NULL,NULL,NULL),(22077,991,13.84,88.9762,NULL,NULL,NULL,NULL),(22078,991,13.95,88.9762,NULL,NULL,NULL,NULL),(22079,991,14.07,88.9762,NULL,NULL,NULL,NULL),(22080,991,14.19,88.9762,NULL,NULL,NULL,NULL),(22081,991,14.3,88.9762,NULL,NULL,NULL,NULL),(22082,992,0.01,3.28571,NULL,NULL,NULL,NULL),(22083,992,0.05,8.62245,NULL,NULL,NULL,NULL),(22084,992,0.1,10.7959,NULL,NULL,NULL,NULL),(22085,992,0.15,12.2245,NULL,NULL,NULL,NULL),(22086,992,0.2,13.398,NULL,NULL,NULL,NULL),(22087,992,0.24,14.3367,NULL,NULL,NULL,NULL),(22088,992,0.29,15.1531,NULL,NULL,NULL,NULL),(22089,992,0.34,15.9286,NULL,NULL,NULL,NULL),(22090,992,0.38,16.5306,NULL,NULL,NULL,NULL),(22091,992,0.43,17.102,NULL,NULL,NULL,NULL),(22092,992,0.47,17.4796,NULL,NULL,NULL,NULL),(22093,992,0.52,17.949,NULL,NULL,NULL,NULL),(22094,992,0.56,18.3469,NULL,NULL,NULL,NULL),(22095,992,0.6,18.7551,NULL,NULL,NULL,NULL),(22096,992,0.65,18.949,NULL,NULL,NULL,NULL),(22097,992,0.69,19.3878,NULL,NULL,NULL,NULL),(22098,992,0.73,19.6531,NULL,NULL,NULL,NULL),(22099,992,1.78,24.5714,NULL,NULL,NULL,NULL),(22100,992,1.82,24.7551,NULL,NULL,NULL,NULL),(22101,992,1.86,24.8265,NULL,NULL,NULL,NULL),(22102,992,1.9,25.0102,NULL,NULL,NULL,NULL),(22103,992,1.94,25.0102,NULL,NULL,NULL,NULL),(22104,992,1.98,25.1633,NULL,NULL,NULL,NULL),(22105,992,2.02,25.3163,NULL,NULL,NULL,NULL),(22106,992,2.06,25.4082,NULL,NULL,NULL,NULL),(22107,992,2.1,25.4898,NULL,NULL,NULL,NULL),(22108,992,2.14,25.4898,NULL,NULL,NULL,NULL),(22109,992,2.18,25.7245,NULL,NULL,NULL,NULL),(22110,992,2.22,25.7959,NULL,NULL,NULL,NULL),(22111,992,2.26,25.8469,NULL,NULL,NULL,NULL),(22112,992,2.3,25.9694,NULL,NULL,NULL,NULL),(22113,992,2.34,26.051,NULL,NULL,NULL,NULL),(22114,992,2.38,26.051,NULL,NULL,NULL,NULL),(22115,992,2.42,26.1735,NULL,NULL,NULL,NULL),(22116,992,2.46,26.2551,NULL,NULL,NULL,NULL),(22117,992,2.5,26.3367,NULL,NULL,NULL,NULL),(22118,992,2.54,26.4592,NULL,NULL,NULL,NULL),(22119,992,2.58,26.5102,NULL,NULL,NULL,NULL),(22120,992,2.67,26.6327,NULL,NULL,NULL,NULL),(22121,992,2.71,26.7347,NULL,NULL,NULL,NULL),(22122,992,2.75,26.7653,NULL,NULL,NULL,NULL),(22123,992,2.79,26.8878,NULL,NULL,NULL,NULL),(22124,992,2.83,27.0204,NULL,NULL,NULL,NULL),(22125,992,2.87,27.0714,NULL,NULL,NULL,NULL),(22126,992,2.91,26.3673,NULL,NULL,NULL,NULL),(22127,992,2.95,26.5,NULL,NULL,NULL,NULL),(22128,992,2.99,26.5816,NULL,NULL,NULL,NULL),(22129,992,3.03,26.7143,NULL,NULL,NULL,NULL),(22130,992,3.07,26.7959,NULL,NULL,NULL,NULL),(22131,992,3.11,26.8469,NULL,NULL,NULL,NULL),(22132,992,3.15,26.8673,NULL,NULL,NULL,NULL),(22133,992,3.19,26.9184,NULL,NULL,NULL,NULL),(22134,992,3.23,26.8878,NULL,NULL,NULL,NULL),(22135,992,3.27,27.0612,NULL,NULL,NULL,NULL),(22136,992,3.31,26.9898,NULL,NULL,NULL,NULL),(22137,992,3.35,27.0408,NULL,NULL,NULL,NULL),(22138,992,3.39,27.1327,NULL,NULL,NULL,NULL),(22139,992,3.43,27.2959,NULL,NULL,NULL,NULL),(22140,992,3.47,27.3163,NULL,NULL,NULL,NULL),(22141,992,3.51,27.2959,NULL,NULL,NULL,NULL),(22142,992,3.55,27.449,NULL,NULL,NULL,NULL),(22143,992,3.59,27.4388,NULL,NULL,NULL,NULL),(22144,992,3.63,27.4898,NULL,NULL,NULL,NULL),(22145,992,3.67,27.4286,NULL,NULL,NULL,NULL),(22146,992,3.71,27.5306,NULL,NULL,NULL,NULL),(22147,992,3.75,27.5816,NULL,NULL,NULL,NULL),(22148,992,3.79,27.6327,NULL,NULL,NULL,NULL),(22149,992,3.83,27.6122,NULL,NULL,NULL,NULL),(22150,992,3.87,27.7041,NULL,NULL,NULL,NULL),(22151,992,3.91,27.7959,NULL,NULL,NULL,NULL),(22152,992,3.95,27.8571,NULL,NULL,NULL,NULL),(22153,992,3.99,27.8571,NULL,NULL,NULL,NULL),(22154,992,4.03,27.9592,NULL,NULL,NULL,NULL),(22155,992,4.07,27.949,NULL,NULL,NULL,NULL),(22156,992,4.11,28,NULL,NULL,NULL,NULL),(22157,992,4.15,28.051,NULL,NULL,NULL,NULL),(22158,992,4.19,28,NULL,NULL,NULL,NULL),(22159,992,4.23,28.1633,NULL,NULL,NULL,NULL),(22160,992,4.27,28.1837,NULL,NULL,NULL,NULL),(22161,992,4.3,28.2347,NULL,NULL,NULL,NULL),(22162,992,4.34,28.2857,NULL,NULL,NULL,NULL),(22163,992,4.38,28.3878,NULL,NULL,NULL,NULL),(22164,992,4.42,28.4388,NULL,NULL,NULL,NULL),(22165,992,4.46,28.398,NULL,NULL,NULL,NULL),(22166,992,4.5,28.449,NULL,NULL,NULL,NULL),(22167,992,4.54,28.5714,NULL,NULL,NULL,NULL),(22168,992,4.58,28.4796,NULL,NULL,NULL,NULL),(22169,992,4.62,28.5,NULL,NULL,NULL,NULL),(22170,992,4.66,28.602,NULL,NULL,NULL,NULL),(22171,992,4.7,28.6122,NULL,NULL,NULL,NULL),(22172,992,4.74,28.6327,NULL,NULL,NULL,NULL),(22173,992,4.78,28.7041,NULL,NULL,NULL,NULL),(22174,992,4.82,28.6327,NULL,NULL,NULL,NULL),(22175,992,4.86,28.7041,NULL,NULL,NULL,NULL),(22176,992,4.9,28.8061,NULL,NULL,NULL,NULL),(22177,992,4.94,29,NULL,NULL,NULL,NULL),(22178,992,4.98,28.9898,NULL,NULL,NULL,NULL),(22179,992,5.02,28.8571,NULL,NULL,NULL,NULL),(22180,992,5.06,28.9898,NULL,NULL,NULL,NULL),(22181,992,5.1,29.0102,NULL,NULL,NULL,NULL),(22182,992,5.14,29.0408,NULL,NULL,NULL,NULL),(22183,992,5.18,29.2041,NULL,NULL,NULL,NULL),(22184,992,5.22,29.1429,NULL,NULL,NULL,NULL),(22185,992,5.26,29.1327,NULL,NULL,NULL,NULL),(22186,992,5.3,29.1122,NULL,NULL,NULL,NULL),(22187,992,5.34,29.2143,NULL,NULL,NULL,NULL),(22188,992,5.38,29.2653,NULL,NULL,NULL,NULL),(22189,992,5.42,29.2857,NULL,NULL,NULL,NULL),(22190,992,5.46,29.2959,NULL,NULL,NULL,NULL),(22191,992,5.5,29.3673,NULL,NULL,NULL,NULL),(22192,992,5.54,29.3878,NULL,NULL,NULL,NULL),(22193,992,5.58,29.4898,NULL,NULL,NULL,NULL),(22194,992,5.62,29.5408,NULL,NULL,NULL,NULL),(22195,992,5.66,29.3571,NULL,NULL,NULL,NULL),(22196,992,5.69,29.4286,NULL,NULL,NULL,NULL),(22197,992,5.73,29.5204,NULL,NULL,NULL,NULL),(22198,992,5.77,29.5714,NULL,NULL,NULL,NULL),(22199,992,5.81,29.6224,NULL,NULL,NULL,NULL),(22200,992,5.85,29.6531,NULL,NULL,NULL,NULL),(22201,992,5.88,29.6837,NULL,NULL,NULL,NULL),(22202,992,5.92,29.6735,NULL,NULL,NULL,NULL),(22203,992,5.96,29.6224,NULL,NULL,NULL,NULL),(22204,992,6,29.5306,NULL,NULL,NULL,NULL),(22205,992,6.04,29.6327,NULL,NULL,NULL,NULL),(22206,992,6.08,29.6939,NULL,NULL,NULL,NULL),(22207,992,6.12,29.7551,NULL,NULL,NULL,NULL),(22208,992,6.16,29.9082,NULL,NULL,NULL,NULL),(22209,992,6.2,29.9286,NULL,NULL,NULL,NULL),(22210,992,6.24,29.8776,NULL,NULL,NULL,NULL),(22211,992,6.28,29.8673,NULL,NULL,NULL,NULL),(22212,992,6.32,29.8878,NULL,NULL,NULL,NULL),(22213,992,6.36,29.898,NULL,NULL,NULL,NULL),(22214,992,7.39,30.4184,NULL,NULL,NULL,NULL),(22215,992,7.42,30.4898,NULL,NULL,NULL,NULL),(22216,992,7.47,30.551,NULL,NULL,NULL,NULL),(22217,992,7.59,30.602,NULL,NULL,NULL,NULL),(22218,992,7.71,30.7551,NULL,NULL,NULL,NULL),(22219,992,7.83,30.7551,NULL,NULL,NULL,NULL),(22220,992,7.95,30.9082,NULL,NULL,NULL,NULL),(22221,992,8.06,30.9694,NULL,NULL,NULL,NULL),(22222,992,8.18,31.0102,NULL,NULL,NULL,NULL),(22223,992,8.3,31.0102,NULL,NULL,NULL,NULL),(22224,992,8.42,31.1633,NULL,NULL,NULL,NULL),(22225,992,8.54,31.1327,NULL,NULL,NULL,NULL),(22226,992,8.65,31.2143,NULL,NULL,NULL,NULL),(22227,992,8.77,31.2857,NULL,NULL,NULL,NULL),(22228,992,8.89,31.3061,NULL,NULL,NULL,NULL),(22229,992,9.01,31.4184,NULL,NULL,NULL,NULL),(22230,992,9.13,31.4592,NULL,NULL,NULL,NULL),(22231,992,9.24,31.4592,NULL,NULL,NULL,NULL),(22232,992,9.36,31.4592,NULL,NULL,NULL,NULL),(22233,992,9.48,31.4592,NULL,NULL,NULL,NULL),(22234,992,9.6,31.6224,NULL,NULL,NULL,NULL),(22235,992,9.71,31.6633,NULL,NULL,NULL,NULL),(22236,992,9.83,31.6327,NULL,NULL,NULL,NULL),(22237,992,9.95,31.7551,NULL,NULL,NULL,NULL),(22238,992,10.07,31.6837,NULL,NULL,NULL,NULL),(22239,992,10.18,31.8367,NULL,NULL,NULL,NULL),(22240,992,10.3,31.8367,NULL,NULL,NULL,NULL),(22241,992,10.42,31.8163,NULL,NULL,NULL,NULL),(22242,992,10.54,32.0204,NULL,NULL,NULL,NULL),(22243,992,10.65,31.9592,NULL,NULL,NULL,NULL),(22244,992,10.77,31.9898,NULL,NULL,NULL,NULL),(22245,992,10.89,32.0408,NULL,NULL,NULL,NULL),(22246,992,11,31.9592,NULL,NULL,NULL,NULL),(22247,992,11.12,31.9592,NULL,NULL,NULL,NULL),(22248,992,11.24,32.1327,NULL,NULL,NULL,NULL),(22249,992,11.35,32.0612,NULL,NULL,NULL,NULL),(22250,992,11.47,32.2653,NULL,NULL,NULL,NULL),(22251,992,11.59,32.2959,NULL,NULL,NULL,NULL),(22252,992,11.71,32.2653,NULL,NULL,NULL,NULL),(22253,992,11.82,32.2653,NULL,NULL,NULL,NULL),(22254,992,11.94,32.2653,NULL,NULL,NULL,NULL),(22255,992,12.06,32.2347,NULL,NULL,NULL,NULL),(22256,992,12.17,32.3571,NULL,NULL,NULL,NULL),(22257,992,12.29,32.398,NULL,NULL,NULL,NULL),(22258,992,12.41,32.4694,NULL,NULL,NULL,NULL),(22259,992,12.53,32.4898,NULL,NULL,NULL,NULL),(22260,992,12.64,32.3673,NULL,NULL,NULL,NULL),(22261,992,12.76,32.5408,NULL,NULL,NULL,NULL),(22262,992,12.88,32.5408,NULL,NULL,NULL,NULL),(22263,992,12.99,32.3878,NULL,NULL,NULL,NULL),(22264,992,13.11,32.4796,NULL,NULL,NULL,NULL),(22265,992,13.23,32.5714,NULL,NULL,NULL,NULL),(22266,992,13.34,32.5408,NULL,NULL,NULL,NULL),(22267,992,13.46,32.602,NULL,NULL,NULL,NULL),(22268,992,13.58,32.602,NULL,NULL,NULL,NULL),(22269,992,13.69,32.6939,NULL,NULL,NULL,NULL),(22270,993,0,-3.405,NULL,NULL,NULL,NULL),(22271,993,0.04,-2.755,NULL,NULL,NULL,NULL),(22272,993,0.08,-2.33,NULL,NULL,NULL,NULL),(22273,993,0.12,-2.02,NULL,NULL,NULL,NULL),(22274,993,0.16,-1.685,NULL,NULL,NULL,NULL),(22275,993,0.19,-1.495,NULL,NULL,NULL,NULL),(22276,993,0.23,-1.27,NULL,NULL,NULL,NULL),(22277,993,0.27,-1.065,NULL,NULL,NULL,NULL),(22278,993,0.31,-0.815,NULL,NULL,NULL,NULL),(22279,993,0.35,-0.615,NULL,NULL,NULL,NULL),(22280,993,0.39,-0.465,NULL,NULL,NULL,NULL),(22281,993,0.43,-0.295,NULL,NULL,NULL,NULL),(22282,993,0.47,-0.13,NULL,NULL,NULL,NULL),(22283,993,0.51,0.155,NULL,NULL,NULL,NULL),(22284,993,0.55,0.35,NULL,NULL,NULL,NULL),(22285,993,0.59,0.44,NULL,NULL,NULL,NULL),(22286,993,0.63,0.535,NULL,NULL,NULL,NULL),(22287,993,1.7,3.185,NULL,NULL,NULL,NULL),(22288,993,1.73,3.31,NULL,NULL,NULL,NULL),(22289,993,1.78,3.535,NULL,NULL,NULL,NULL),(22290,993,1.9,3.685,NULL,NULL,NULL,NULL),(22291,993,2.02,3.875,NULL,NULL,NULL,NULL),(22292,993,2.14,3.99,NULL,NULL,NULL,NULL),(22293,993,2.26,4.16,NULL,NULL,NULL,NULL),(22294,993,2.37,4.33,NULL,NULL,NULL,NULL),(22295,993,2.49,4.43,NULL,NULL,NULL,NULL),(22296,993,2.61,4.62,NULL,NULL,NULL,NULL),(22297,993,2.73,4.735,NULL,NULL,NULL,NULL),(22298,993,2.85,4.86,NULL,NULL,NULL,NULL),(22299,993,2.96,4.945,NULL,NULL,NULL,NULL),(22300,993,3.08,5.12,NULL,NULL,NULL,NULL),(22301,993,3.2,5.23,NULL,NULL,NULL,NULL),(22302,993,3.32,5.365,NULL,NULL,NULL,NULL),(22303,993,3.44,5.385,NULL,NULL,NULL,NULL),(22304,993,3.55,5.415,NULL,NULL,NULL,NULL),(22305,993,3.67,5.55,NULL,NULL,NULL,NULL),(22306,993,3.79,5.635,NULL,NULL,NULL,NULL),(22307,993,3.91,5.765,NULL,NULL,NULL,NULL),(22308,993,4.02,5.83,NULL,NULL,NULL,NULL),(22309,993,4.14,5.95,NULL,NULL,NULL,NULL),(22310,993,4.26,6.04,NULL,NULL,NULL,NULL),(22311,993,4.38,6.125,NULL,NULL,NULL,NULL),(22312,993,4.49,6.235,NULL,NULL,NULL,NULL),(22313,993,4.61,6.3,NULL,NULL,NULL,NULL),(22314,993,4.73,6.41,NULL,NULL,NULL,NULL),(22315,993,4.85,6.505,NULL,NULL,NULL,NULL),(22316,993,4.96,6.575,NULL,NULL,NULL,NULL),(22317,993,5.08,6.64,NULL,NULL,NULL,NULL),(22318,993,5.2,6.715,NULL,NULL,NULL,NULL),(22319,993,5.31,6.78,NULL,NULL,NULL,NULL),(22320,993,5.43,6.83,NULL,NULL,NULL,NULL),(22321,993,5.55,6.96,NULL,NULL,NULL,NULL),(22322,993,5.66,7.01,NULL,NULL,NULL,NULL),(22323,993,5.78,7.09,NULL,NULL,NULL,NULL),(22324,993,5.9,7.14,NULL,NULL,NULL,NULL),(22325,993,6.02,7.26,NULL,NULL,NULL,NULL),(22326,993,6.13,7.29,NULL,NULL,NULL,NULL),(22327,993,6.25,7.325,NULL,NULL,NULL,NULL),(22328,993,6.37,7.41,NULL,NULL,NULL,NULL),(22329,993,6.48,7.47,NULL,NULL,NULL,NULL),(22330,993,6.6,7.525,NULL,NULL,NULL,NULL),(22331,993,6.72,7.625,NULL,NULL,NULL,NULL),(22332,993,6.84,7.685,NULL,NULL,NULL,NULL),(22333,993,6.95,7.675,NULL,NULL,NULL,NULL),(22334,993,7.07,7.775,NULL,NULL,NULL,NULL),(22335,993,7.19,7.81,NULL,NULL,NULL,NULL),(22336,993,7.3,7.835,NULL,NULL,NULL,NULL),(22337,993,7.42,7.88,NULL,NULL,NULL,NULL),(22338,993,7.54,7.975,NULL,NULL,NULL,NULL),(22339,993,7.65,7.975,NULL,NULL,NULL,NULL),(22340,993,7.77,8.06,NULL,NULL,NULL,NULL),(22341,993,7.89,8.09,NULL,NULL,NULL,NULL),(22342,993,8,8.185,NULL,NULL,NULL,NULL),(22343,994,0.01,11.2245,NULL,NULL,NULL,NULL),(22344,994,0.02,14.2857,NULL,NULL,NULL,NULL),(22345,994,0.05,18.3673,NULL,NULL,NULL,NULL),(22346,994,0.1,22.449,NULL,NULL,NULL,NULL),(22347,994,0.2,27.551,NULL,NULL,NULL,NULL),(22348,994,0.5,36.7347,NULL,NULL,NULL,NULL),(22349,994,1,43.8776,NULL,NULL,NULL,NULL),(22350,994,2,52.0408,NULL,NULL,NULL,NULL),(22351,994,3,59.1837,NULL,NULL,NULL,NULL),(22352,994,4,68.3673,NULL,NULL,NULL,NULL),(22353,994,5,74.4898,NULL,NULL,NULL,NULL),(22354,995,0.01,15.3061,NULL,NULL,NULL,NULL),(22355,995,0.02,21.4286,NULL,NULL,NULL,NULL),(22356,995,0.05,26.5306,NULL,NULL,NULL,NULL),(22357,995,0.1,31.6327,NULL,NULL,NULL,NULL),(22358,995,0.2,37.7551,NULL,NULL,NULL,NULL),(22359,995,0.5,48.9796,NULL,NULL,NULL,NULL),(22360,995,1,60.2041,NULL,NULL,NULL,NULL),(22361,995,2,77.551,NULL,NULL,NULL,NULL),(22362,995,3,87.7551,NULL,NULL,NULL,NULL),(22363,995,4,93.8775,NULL,NULL,NULL,NULL),(22364,995,5,96.9388,NULL,NULL,NULL,NULL),(22365,996,0.01,25.5102,NULL,NULL,NULL,NULL),(22366,996,0.02,32.6531,NULL,NULL,NULL,NULL),(22367,996,0.05,37.7551,NULL,NULL,NULL,NULL),(22368,996,0.1,45.9184,NULL,NULL,NULL,NULL),(22369,996,0.2,58.1633,NULL,NULL,NULL,NULL),(22370,996,0.5,81.6327,NULL,NULL,NULL,NULL),(22371,996,1,94.898,NULL,NULL,NULL,NULL),(22372,996,2,108.163,NULL,NULL,NULL,NULL),(22373,996,3,119.388,NULL,NULL,NULL,NULL),(22374,996,4,127.551,NULL,NULL,NULL,NULL),(22375,996,5,133.673,NULL,NULL,NULL,NULL),(22376,997,0.01,16.3265,NULL,NULL,NULL,NULL),(22377,997,0.02,21.4286,NULL,NULL,NULL,NULL),(22378,997,0.05,24.4898,NULL,NULL,NULL,NULL),(22379,997,0.1,27.551,NULL,NULL,NULL,NULL),(22380,997,0.2,38.7755,NULL,NULL,NULL,NULL),(22381,997,0.5,48.9796,NULL,NULL,NULL,NULL),(22382,997,1,60.2041,NULL,NULL,NULL,NULL),(22383,997,2,71.4286,NULL,NULL,NULL,NULL),(22384,997,3,78.5714,NULL,NULL,NULL,NULL),(22385,997,4,81.6327,NULL,NULL,NULL,NULL),(22386,997,5,86.7347,NULL,NULL,NULL,NULL),(22387,998,0.01,33.6735,NULL,NULL,NULL,NULL),(22388,998,0.02,38.7755,NULL,NULL,NULL,NULL),(22389,998,0.05,46.9388,NULL,NULL,NULL,NULL),(22390,998,0.1,56.1224,NULL,NULL,NULL,NULL),(22391,998,0.2,65.3061,NULL,NULL,NULL,NULL),(22392,998,0.5,93.8775,NULL,NULL,NULL,NULL),(22393,998,1,120.408,NULL,NULL,NULL,NULL),(22394,998,2,174.49,NULL,NULL,NULL,NULL),(22395,998,3,204.082,NULL,NULL,NULL,NULL),(22396,998,4,219.388,NULL,NULL,NULL,NULL),(22397,998,5,219.388,NULL,NULL,NULL,NULL),(22398,998,6,225.51,NULL,NULL,NULL,NULL),(22399,999,0.01,33.6735,NULL,NULL,NULL,NULL),(22400,999,0.02,38.7755,NULL,NULL,NULL,NULL),(22401,999,0.05,46.9388,NULL,NULL,NULL,NULL),(22402,999,0.1,56.1224,NULL,NULL,NULL,NULL),(22403,999,0.2,65.3061,NULL,NULL,NULL,NULL),(22404,999,0.5,76.5306,NULL,NULL,NULL,NULL),(22405,999,1,91.8367,NULL,NULL,NULL,NULL),(22406,999,2,111.224,NULL,NULL,NULL,NULL),(22407,999,3,117.347,NULL,NULL,NULL,NULL),(22408,999,4,132.653,NULL,NULL,NULL,NULL),(22409,999,5,138.776,NULL,NULL,NULL,NULL),(22410,999,6,147.959,NULL,NULL,NULL,NULL),(22411,1000,0.02,25.5102,NULL,NULL,NULL,NULL),(22412,1000,0.03,27.551,NULL,NULL,NULL,NULL),(22413,1000,0.06,30.6122,NULL,NULL,NULL,NULL),(22414,1000,0.11,35.7143,NULL,NULL,NULL,NULL),(22415,1000,0.21,39.7959,NULL,NULL,NULL,NULL),(22416,1000,0.51,50,NULL,NULL,NULL,NULL),(22417,1000,1.01,56.1224,NULL,NULL,NULL,NULL),(22418,1000,2.01,66.3265,NULL,NULL,NULL,NULL),(22419,1000,3.01,72.449,NULL,NULL,NULL,NULL),(22420,1000,4.01,81.6327,NULL,NULL,NULL,NULL),(22421,1000,5.01,85.7143,NULL,NULL,NULL,NULL),(22422,1000,6.01,87.7551,NULL,NULL,NULL,NULL),(22423,1001,0,25.6102,NULL,NULL,NULL,NULL),(22424,1001,0.01,27.651,NULL,NULL,NULL,NULL),(22425,1001,0.04,30.7122,NULL,NULL,NULL,NULL),(22426,1001,0.09,33.7735,NULL,NULL,NULL,NULL),(22427,1001,0.19,33.7735,NULL,NULL,NULL,NULL),(22428,1001,0.49,41.9367,NULL,NULL,NULL,NULL),(22429,1001,0.99,52.1408,NULL,NULL,NULL,NULL),(22430,1001,1.99,66.4265,NULL,NULL,NULL,NULL),(22431,1001,2.99,72.549,NULL,NULL,NULL,NULL),(22432,1001,3.99,81.7327,NULL,NULL,NULL,NULL),(22433,1001,4.99,85.8143,NULL,NULL,NULL,NULL),(22434,1001,5.99,87.8551,NULL,NULL,NULL,NULL),(22435,1002,0.01,14.2857,NULL,NULL,NULL,NULL),(22436,1002,0.02,19.3878,NULL,NULL,NULL,NULL),(22437,1002,0.05,24.4898,NULL,NULL,NULL,NULL),(22438,1002,0.1,31.6327,NULL,NULL,NULL,NULL),(22439,1002,0.2,37.7551,NULL,NULL,NULL,NULL),(22440,1002,0.5,37.7551,NULL,NULL,NULL,NULL),(22441,1002,1,37.7551,NULL,NULL,NULL,NULL),(22442,1002,2,40.8163,NULL,NULL,NULL,NULL),(22443,1002,3,40.8163,NULL,NULL,NULL,NULL),(22444,1002,4,40.8163,NULL,NULL,NULL,NULL),(22445,1002,5,43.8776,NULL,NULL,NULL,NULL),(22446,1002,6,54.0816,NULL,NULL,NULL,NULL),(22447,1003,0.01,10.2041,NULL,NULL,NULL,NULL),(22448,1003,0.02,15.3061,NULL,NULL,NULL,NULL),(22449,1003,0.05,19.3878,NULL,NULL,NULL,NULL),(22450,1003,0.1,23.4694,NULL,NULL,NULL,NULL),(22451,1003,0.2,29.5918,NULL,NULL,NULL,NULL),(22452,1003,0.5,31.6327,NULL,NULL,NULL,NULL),(22453,1003,1,33.6735,NULL,NULL,NULL,NULL),(22454,1003,2,40.8163,NULL,NULL,NULL,NULL),(22455,1003,3,40.8163,NULL,NULL,NULL,NULL),(22456,1003,4,40.8163,NULL,NULL,NULL,NULL),(22457,1003,5,40.8163,NULL,NULL,NULL,NULL),(22458,1003,6,43.8776,NULL,NULL,NULL,NULL),(22459,1004,0,14.0857,NULL,NULL,NULL,NULL),(22460,1004,0.01,19.1878,NULL,NULL,NULL,NULL),(22461,1004,0.04,24.2898,NULL,NULL,NULL,NULL),(22462,1004,0.09,31.4327,NULL,NULL,NULL,NULL),(22463,1004,0.19,37.5551,NULL,NULL,NULL,NULL),(22464,1004,0.49,51.8408,NULL,NULL,NULL,NULL),(22465,1004,0.99,65.1061,NULL,NULL,NULL,NULL),(22466,1004,1.99,69.1878,NULL,NULL,NULL,NULL),(22467,1004,2.99,71.2286,NULL,NULL,NULL,NULL),(22468,1004,3.99,74.2898,NULL,NULL,NULL,NULL),(22469,1004,4.99,76.3306,NULL,NULL,NULL,NULL),(22470,1004,5.99,84.4939,NULL,NULL,NULL,NULL),(22471,1005,0,14.0857,NULL,NULL,NULL,NULL),(22472,1005,0.01,19.1878,NULL,NULL,NULL,NULL),(22473,1005,0.04,24.2898,NULL,NULL,NULL,NULL),(22474,1005,0.09,31.4327,NULL,NULL,NULL,NULL),(22475,1005,0.19,37.5551,NULL,NULL,NULL,NULL),(22476,1005,0.49,51.8408,NULL,NULL,NULL,NULL),(22477,1005,0.99,56.9429,NULL,NULL,NULL,NULL),(22478,1005,1.99,69.1878,NULL,NULL,NULL,NULL),(22479,1005,2.99,71.2286,NULL,NULL,NULL,NULL),(22480,1005,3.99,71.2286,NULL,NULL,NULL,NULL),(22481,1005,4.99,71.2286,NULL,NULL,NULL,NULL),(22482,1005,5.99,74.2898,NULL,NULL,NULL,NULL),(22483,1006,0.125,46.25,NULL,NULL,NULL,NULL),(22484,1006,0.25,28.75,NULL,NULL,NULL,NULL),(22485,1006,0.5,42.5,NULL,NULL,NULL,NULL),(22486,1006,1,52.5,NULL,NULL,NULL,NULL),(22487,1006,2,55,NULL,NULL,NULL,NULL),(22488,1006,3,70,NULL,NULL,NULL,NULL),(22489,1006,4,70,NULL,NULL,NULL,NULL),(22490,1006,5,71.25,NULL,NULL,NULL,NULL),(22491,1006,6,76.25,NULL,NULL,NULL,NULL),(22492,1006,8,88.75,NULL,NULL,NULL,NULL),(22493,1006,9,81.25,NULL,NULL,NULL,NULL),(22494,1006,10,86.25,NULL,NULL,NULL,NULL),(22495,1006,12,90,NULL,NULL,NULL,NULL),(22496,1006,14,87.5,NULL,NULL,NULL,NULL),(22497,1006,21,97.5,NULL,NULL,NULL,NULL),(22498,1006,28,115,NULL,NULL,NULL,NULL),(22499,1007,0.125,26.6667,NULL,NULL,NULL,NULL),(22500,1007,0.25,26.6667,NULL,NULL,NULL,NULL),(22501,1007,0.5,31.6667,NULL,NULL,NULL,NULL),(22502,1007,1,42.5,NULL,NULL,NULL,NULL),(22503,1007,2,50.8333,NULL,NULL,NULL,NULL),(22504,1007,3,50.8333,NULL,NULL,NULL,NULL),(22505,1007,4,55.8333,NULL,NULL,NULL,NULL),(22506,1007,5,70.8333,NULL,NULL,NULL,NULL),(22507,1007,6,69.1667,NULL,NULL,NULL,NULL),(22508,1007,8,76.6667,NULL,NULL,NULL,NULL),(22509,1007,9,77.5,NULL,NULL,NULL,NULL),(22510,1007,10,82.5,NULL,NULL,NULL,NULL),(22511,1007,12,101.667,NULL,NULL,NULL,NULL),(22512,1007,14,110,NULL,NULL,NULL,NULL),(22513,1007,21,114.167,NULL,NULL,NULL,NULL),(22514,1007,22,115.833,NULL,NULL,NULL,NULL),(22515,1008,0.125,21.875,NULL,NULL,NULL,NULL),(22516,1008,0.25,23.75,NULL,NULL,NULL,NULL),(22517,1008,1,34.375,NULL,NULL,NULL,NULL),(22518,1008,3,61.25,NULL,NULL,NULL,NULL),(22519,1008,4,70,NULL,NULL,NULL,NULL),(22520,1008,6,81.25,NULL,NULL,NULL,NULL),(22521,1008,7,91.25,NULL,NULL,NULL,NULL),(22522,1008,9,99.375,NULL,NULL,NULL,NULL),(22523,1008,14,118.125,NULL,NULL,NULL,NULL),(22524,1008,21,143.75,NULL,NULL,NULL,NULL),(22525,1008,25,152.5,NULL,NULL,NULL,NULL),(22526,1009,730,37.9547,NULL,NULL,NULL,NULL),(22527,1010,730,42.7363,NULL,NULL,NULL,NULL),(22528,1011,730,33.4119,NULL,NULL,NULL,NULL),(22529,1012,730,34.3196,NULL,NULL,NULL,NULL),(22530,1013,730,32.4099,NULL,NULL,NULL,NULL),(22531,1014,730,33.4768,NULL,NULL,NULL,NULL),(22532,1015,0,0,NULL,NULL,NULL,NULL),(22533,1015,0.1,20.4547,NULL,NULL,NULL,NULL),(22534,1015,3,51.2272,NULL,NULL,NULL,NULL),(22535,1015,6.7,69.3286,NULL,NULL,NULL,NULL),(22536,1015,8,67.5185,NULL,NULL,NULL,NULL),(22537,1015,9.8,69.3286,NULL,NULL,NULL,NULL),(22538,1015,11.7,96.4808,NULL,NULL,NULL,NULL),(22539,1015,15.3,109.152,NULL,NULL,NULL,NULL),(22540,1015,18,127.253,NULL,NULL,NULL,NULL),(22541,1015,21.5,132.684,NULL,NULL,NULL,NULL),(22542,1015,22.7,130.874,NULL,NULL,NULL,NULL),(22543,1015,24.3,148.975,NULL,NULL,NULL,NULL),(22544,1015,26.8,152.595,NULL,NULL,NULL,NULL),(22545,1015,28.3,165.266,NULL,NULL,NULL,NULL),(22546,1015,29.5,163.456,NULL,NULL,NULL,NULL),(22547,1015,30.5,168.887,NULL,NULL,NULL,NULL),(22548,1015,31.8,165.266,NULL,NULL,NULL,NULL),(22549,1015,36.1,179.748,NULL,NULL,NULL,NULL),(22550,1015,38.2,174.317,NULL,NULL,NULL,NULL),(22551,1015,41,181.558,NULL,NULL,NULL,NULL),(22552,1015,43,190.608,NULL,NULL,NULL,NULL),(22553,1015,45.9,199.659,NULL,NULL,NULL,NULL),(22554,1015,47.8,196.039,NULL,NULL,NULL,NULL),(22555,1015,49.9,203.28,NULL,NULL,NULL,NULL),(22556,1015,53.9,205.09,NULL,NULL,NULL,NULL),(22557,1015,57.7,212.33,NULL,NULL,NULL,NULL),(22558,1015,60.3,205.09,NULL,NULL,NULL,NULL),(22559,1015,69.3,221.381,NULL,NULL,NULL,NULL),(22560,1015,73,223.191,NULL,NULL,NULL,NULL),(22561,1015,78,228.622,NULL,NULL,NULL,NULL),(22562,1015,81.9,230.432,NULL,NULL,NULL,NULL),(22563,1015,84.4,226.811,NULL,NULL,NULL,NULL),(22564,1015,93,239.482,NULL,NULL,NULL,NULL),(22565,1016,0.02,1,NULL,NULL,NULL,NULL),(22566,1016,0.1,2.5,NULL,NULL,NULL,NULL),(22567,1016,0.3,5,NULL,NULL,NULL,NULL),(22568,1016,0.7,7,NULL,NULL,NULL,NULL),(22569,1016,1,7.5,NULL,NULL,NULL,NULL),(22570,1016,3,12.5,NULL,NULL,NULL,NULL),(22571,1016,6,17.3,NULL,NULL,NULL,NULL),(22572,1016,8,20.8,NULL,NULL,NULL,NULL),(22573,1016,20,31,NULL,NULL,NULL,NULL),(22574,1016,40,40,NULL,NULL,NULL,NULL),(22575,1016,51,41.7,NULL,NULL,NULL,NULL),(22576,1016,200,60,NULL,NULL,NULL,NULL),(22577,1016,320,70,NULL,NULL,NULL,NULL),(22578,1016,420,80,NULL,NULL,NULL,NULL),(22579,1016,800,84.3,NULL,NULL,NULL,NULL),(22580,1016,4000,101.1,NULL,NULL,NULL,NULL),(22581,1017,0.17,1,NULL,NULL,NULL,NULL),(22582,1017,5,1.3,NULL,NULL,NULL,NULL),(22583,1017,9,1.5,NULL,NULL,NULL,NULL),(22584,1017,15,4,NULL,NULL,NULL,NULL),(22585,1017,24,5,NULL,NULL,NULL,NULL),(22586,1017,44,9,NULL,NULL,NULL,NULL),(22587,1017,80,11.7,NULL,NULL,NULL,NULL),(22588,1017,170,19,NULL,NULL,NULL,NULL),(22589,1017,580,33.7,NULL,NULL,NULL,NULL),(22590,1017,900,37,NULL,NULL,NULL,NULL),(22591,1017,2000,50,NULL,NULL,NULL,NULL),(22592,1018,10,6.8,NULL,NULL,NULL,NULL),(22593,1018,21,8.4,NULL,NULL,NULL,NULL),(22594,1018,35,9.6,NULL,NULL,NULL,NULL),(22595,1018,48,11,NULL,NULL,NULL,NULL),(22596,1018,70,13.8,NULL,NULL,NULL,NULL),(22597,1018,92,14.5,NULL,NULL,NULL,NULL),(22598,1018,182,17.9,NULL,NULL,NULL,NULL),(22599,1018,248,17.2,NULL,NULL,NULL,NULL),(22600,1018,335,19.3,NULL,NULL,NULL,NULL),(22601,1018,365,20,NULL,NULL,NULL,NULL),(22602,1018,410,21.2,NULL,NULL,NULL,NULL),(22603,1019,10,6.8,NULL,NULL,NULL,NULL),(22604,1019,21,8.4,NULL,NULL,NULL,NULL),(22605,1019,35,10.5,NULL,NULL,NULL,NULL),(22606,1019,48,11.9,NULL,NULL,NULL,NULL),(22607,1019,70,14,NULL,NULL,NULL,NULL),(22608,1019,92,15,NULL,NULL,NULL,NULL),(22609,1019,182,16.9,NULL,NULL,NULL,NULL),(22610,1019,248,18.9,NULL,NULL,NULL,NULL),(22611,1019,335,20.1,NULL,NULL,NULL,NULL),(22612,1019,365,21.9,NULL,NULL,NULL,NULL),(22613,1019,410,21.5,NULL,NULL,NULL,NULL),(22614,1020,10,7.9,NULL,NULL,NULL,NULL),(22615,1020,21,12.8,NULL,NULL,NULL,NULL),(22616,1020,35,14.5,NULL,NULL,NULL,NULL),(22617,1020,48,16.7,NULL,NULL,NULL,NULL),(22618,1020,70,18.4,NULL,NULL,NULL,NULL),(22619,1020,92,20,NULL,NULL,NULL,NULL),(22620,1020,193,22,NULL,NULL,NULL,NULL),(22621,1020,258,25,NULL,NULL,NULL,NULL),(22622,1020,335,24,NULL,NULL,NULL,NULL),(22623,1020,365,23.8,NULL,NULL,NULL,NULL),(22624,1020,421,26.8,NULL,NULL,NULL,NULL),(22625,1021,10,19.7,NULL,NULL,NULL,NULL),(22626,1021,21,25.9,NULL,NULL,NULL,NULL),(22627,1021,35,32.8,NULL,NULL,NULL,NULL),(22628,1021,48,38.4,NULL,NULL,NULL,NULL),(22629,1021,70,45.8,NULL,NULL,NULL,NULL),(22630,1021,92,50.2,NULL,NULL,NULL,NULL),(22631,1021,188,64,NULL,NULL,NULL,NULL),(22632,1021,252,75.8,NULL,NULL,NULL,NULL),(22633,1021,309,84.1,NULL,NULL,NULL,NULL),(22634,1021,335,86.3,NULL,NULL,NULL,NULL),(22635,1021,365,87.8,NULL,NULL,NULL,NULL),(22636,1021,416,91,NULL,NULL,NULL,NULL),(22637,1022,10,14,NULL,NULL,NULL,NULL),(22638,1022,21,17.5,NULL,NULL,NULL,NULL),(22639,1022,35,21.9,NULL,NULL,NULL,NULL),(22640,1022,48,24,NULL,NULL,NULL,NULL),(22641,1022,70,27.1,NULL,NULL,NULL,NULL),(22642,1022,92,28,NULL,NULL,NULL,NULL),(22643,1022,182,33,NULL,NULL,NULL,NULL),(22644,1022,248,31,NULL,NULL,NULL,NULL),(22645,1022,335,37.2,NULL,NULL,NULL,NULL),(22646,1022,365,40.5,NULL,NULL,NULL,NULL),(22647,1022,410,32.7,NULL,NULL,NULL,NULL),(22648,1023,730,40.5,NULL,NULL,NULL,NULL),(22649,1024,730,59.1,NULL,NULL,NULL,NULL),(22650,1025,730,103.2,NULL,NULL,NULL,NULL),(22651,1026,730,23.4,NULL,NULL,NULL,NULL),(22652,1027,730,29.8,NULL,NULL,NULL,NULL),(22653,1028,730,61.2,NULL,NULL,NULL,NULL),(22654,1029,730,64.5,NULL,NULL,NULL,NULL),(22655,1030,730,53,NULL,NULL,NULL,NULL),(22656,1031,730,135.3,NULL,NULL,NULL,NULL),(22657,1032,730,96,NULL,NULL,NULL,NULL),(22658,1033,1,8.79044,NULL,NULL,NULL,NULL),(22659,1033,2,13.5624,NULL,NULL,NULL,NULL),(22660,1033,3,15.8228,NULL,NULL,NULL,NULL),(22661,1033,6,20.0924,NULL,NULL,NULL,NULL),(22662,1033,8,25.1155,NULL,NULL,NULL,NULL),(22663,1033,14,28.8829,NULL,NULL,NULL,NULL),(22664,1033,21,33.4037,NULL,NULL,NULL,NULL),(22665,1033,42,37.9245,NULL,NULL,NULL,NULL),(22666,1033,70,43.1987,NULL,NULL,NULL,NULL),(22667,1033,130,49.9799,NULL,NULL,NULL,NULL),(22668,1033,182,53.2449,NULL,NULL,NULL,NULL),(22669,1033,252,57.2634,NULL,NULL,NULL,NULL),(22670,1033,300,59.0215,NULL,NULL,NULL,NULL),(22671,1033,365,61.0307,NULL,NULL,NULL,NULL),(22672,1033,730,64.0948,NULL,NULL,NULL,NULL),(22673,1034,1,3.68686,NULL,NULL,NULL,NULL),(22674,1034,2,9.83163,NULL,NULL,NULL,NULL),(22675,1034,3,11.4702,NULL,NULL,NULL,NULL),(22676,1034,6,15.9764,NULL,NULL,NULL,NULL),(22677,1034,7,15.9764,NULL,NULL,NULL,NULL),(22678,1034,8,22.1212,NULL,NULL,NULL,NULL),(22679,1034,14,24.9887,NULL,NULL,NULL,NULL),(22680,1034,21,28.0611,NULL,NULL,NULL,NULL),(22681,1034,42,31.9528,NULL,NULL,NULL,NULL),(22682,1034,70,37.2783,NULL,NULL,NULL,NULL),(22683,1034,130,40.5555,NULL,NULL,NULL,NULL),(22684,1034,182,44.652,NULL,NULL,NULL,NULL),(22685,1034,252,46.7003,NULL,NULL,NULL,NULL),(22686,1034,300,49.1582,NULL,NULL,NULL,NULL),(22687,1034,365,49.9775,NULL,NULL,NULL,NULL),(22688,1034,730,53.0089,NULL,NULL,NULL,NULL),(22689,1035,1,22.2819,NULL,NULL,NULL,NULL),(22690,1035,2,21.7867,NULL,NULL,NULL,NULL),(22691,1035,3,26.7382,NULL,NULL,NULL,NULL),(22692,1035,4,29.7091,NULL,NULL,NULL,NULL),(22693,1035,5,36.1461,NULL,NULL,NULL,NULL),(22694,1035,6,37.6316,NULL,NULL,NULL,NULL),(22695,1035,7,41.5928,NULL,NULL,NULL,NULL),(22696,1035,10,46.5443,NULL,NULL,NULL,NULL),(22697,1035,14,52.9813,NULL,NULL,NULL,NULL),(22698,1035,21,62.8844,NULL,NULL,NULL,NULL),(22699,1035,42,81.7002,NULL,NULL,NULL,NULL),(22700,1035,70,97.545,NULL,NULL,NULL,NULL),(22701,1035,140,108.934,NULL,NULL,NULL,NULL),(22702,1035,189,119.332,NULL,NULL,NULL,NULL),(22703,1035,252,123.293,NULL,NULL,NULL,NULL),(22704,1035,300,125.769,NULL,NULL,NULL,NULL),(22705,1035,365,128.74,NULL,NULL,NULL,NULL),(22706,1035,730,135.325,NULL,NULL,NULL,NULL),(22707,1036,1,10.8132,NULL,NULL,NULL,NULL),(22708,1036,2,9.26849,NULL,NULL,NULL,NULL),(22709,1036,3,13.1304,NULL,NULL,NULL,NULL),(22710,1036,4,14.2889,NULL,NULL,NULL,NULL),(22711,1036,5,18.537,NULL,NULL,NULL,NULL),(22712,1036,6,20.8541,NULL,NULL,NULL,NULL),(22713,1036,7,23.1712,NULL,NULL,NULL,NULL),(22714,1036,10,27.0331,NULL,NULL,NULL,NULL),(22715,1036,14,32.4397,NULL,NULL,NULL,NULL),(22716,1036,21,38.6187,NULL,NULL,NULL,NULL),(22717,1036,42,53.2938,NULL,NULL,NULL,NULL),(22718,1036,70,64.8794,NULL,NULL,NULL,NULL),(22719,1036,140,72.6031,NULL,NULL,NULL,NULL),(22720,1036,189,84.1887,NULL,NULL,NULL,NULL),(22721,1036,252,85.3473,NULL,NULL,NULL,NULL),(22722,1036,300,89.5954,NULL,NULL,NULL,NULL),(22723,1036,365,92.2987,NULL,NULL,NULL,NULL),(22724,1036,730,95.9288,NULL,NULL,NULL,NULL),(22725,1037,2,20.7,NULL,NULL,NULL,NULL),(22726,1037,4,30,NULL,NULL,NULL,NULL),(22727,1037,7,35.5,NULL,NULL,NULL,NULL),(22728,1037,11,37,NULL,NULL,NULL,NULL),(22729,1037,14,45.8,NULL,NULL,NULL,NULL),(22730,1037,21,46,NULL,NULL,NULL,NULL),(22731,1037,28,55.5,NULL,NULL,NULL,NULL),(22732,1037,34,56.8,NULL,NULL,NULL,NULL),(22733,1037,49,68,NULL,NULL,NULL,NULL),(22734,1037,63,72,NULL,NULL,NULL,NULL),(22735,1037,76,76.1,NULL,NULL,NULL,NULL),(22736,1037,106,82.2,NULL,NULL,NULL,NULL),(22737,1037,134,88,NULL,NULL,NULL,NULL),(22738,1037,185,89,NULL,NULL,NULL,NULL),(22739,1037,303,93,NULL,NULL,NULL,NULL),(22740,1038,2,10,NULL,NULL,NULL,NULL),(22741,1038,4,12,NULL,NULL,NULL,NULL),(22742,1038,7,15,NULL,NULL,NULL,NULL),(22743,1038,11,15.8,NULL,NULL,NULL,NULL),(22744,1038,14,19.8,NULL,NULL,NULL,NULL),(22745,1038,21,20.2,NULL,NULL,NULL,NULL),(22746,1038,28,24.5,NULL,NULL,NULL,NULL),(22747,1038,34,26.4,NULL,NULL,NULL,NULL),(22748,1038,49,29,NULL,NULL,NULL,NULL),(22749,1038,63,31,NULL,NULL,NULL,NULL),(22750,1038,76,32.7,NULL,NULL,NULL,NULL),(22751,1038,106,35.2,NULL,NULL,NULL,NULL),(22752,1038,134,37,NULL,NULL,NULL,NULL),(22753,1038,185,41.5,NULL,NULL,NULL,NULL),(22754,1038,303,44,NULL,NULL,NULL,NULL),(22755,1039,2,10.5,NULL,NULL,NULL,NULL),(22756,1039,4,12.2,NULL,NULL,NULL,NULL),(22757,1039,7,15.3,NULL,NULL,NULL,NULL),(22758,1039,11,16.5,NULL,NULL,NULL,NULL),(22759,1039,14,18.5,NULL,NULL,NULL,NULL),(22760,1039,21,19,NULL,NULL,NULL,NULL),(22761,1039,28,22,NULL,NULL,NULL,NULL),(22762,1039,34,22,NULL,NULL,NULL,NULL),(22763,1039,49,26,NULL,NULL,NULL,NULL),(22764,1039,63,26.5,NULL,NULL,NULL,NULL),(22765,1039,76,28.3,NULL,NULL,NULL,NULL),(22766,1039,106,30,NULL,NULL,NULL,NULL),(22767,1039,134,28.8,NULL,NULL,NULL,NULL),(22768,1039,185,32,NULL,NULL,NULL,NULL),(22769,1039,303,32,NULL,NULL,NULL,NULL),(22770,1040,7,38.2,NULL,NULL,NULL,NULL),(22771,1041,7,60,NULL,NULL,NULL,NULL),(22772,1042,7,35.8,NULL,NULL,NULL,NULL),(22773,1043,7,37.8,NULL,NULL,NULL,NULL),(22774,1044,7,55,NULL,NULL,NULL,NULL),(22775,1045,0.1,12.1693,NULL,NULL,NULL,NULL),(22776,1045,0.2,16.1376,NULL,NULL,NULL,NULL),(22777,1045,0.3,18.5185,NULL,NULL,NULL,NULL),(22778,1045,0.5,22.2222,NULL,NULL,NULL,NULL),(22779,1045,0.75,24.3386,NULL,NULL,NULL,NULL),(22780,1045,1,26.0582,NULL,NULL,NULL,NULL),(22781,1045,1.5,28.7037,NULL,NULL,NULL,NULL),(22782,1045,2,30.4233,NULL,NULL,NULL,NULL),(22783,1045,3,32.5397,NULL,NULL,NULL,NULL),(22784,1045,4,33.9947,NULL,NULL,NULL,NULL),(22785,1045,5,35.3175,NULL,NULL,NULL,NULL),(22786,1045,6,36.2434,NULL,NULL,NULL,NULL),(22787,1045,7,37.037,NULL,NULL,NULL,NULL),(22788,1046,0.1,13.7011,NULL,NULL,NULL,NULL),(22789,1046,0.2,17.6157,NULL,NULL,NULL,NULL),(22790,1046,0.3,20.2847,NULL,NULL,NULL,NULL),(22791,1046,0.5,24.5552,NULL,NULL,NULL,NULL),(22792,1046,0.75,27.0463,NULL,NULL,NULL,NULL),(22793,1046,1,28.8256,NULL,NULL,NULL,NULL),(22794,1046,1.5,31.4947,NULL,NULL,NULL,NULL),(22795,1046,2,33.274,NULL,NULL,NULL,NULL),(22796,1046,3,35.2313,NULL,NULL,NULL,NULL),(22797,1046,4,36.8327,NULL,NULL,NULL,NULL),(22798,1046,5,38.0783,NULL,NULL,NULL,NULL),(22799,1046,6,39.3238,NULL,NULL,NULL,NULL),(22800,1046,7,40.0356,NULL,NULL,NULL,NULL),(22801,1047,0.1,20.5298,NULL,NULL,NULL,NULL),(22802,1047,0.2,26.4901,NULL,NULL,NULL,NULL),(22803,1047,0.3,31.1258,NULL,NULL,NULL,NULL),(22804,1047,0.5,35.7616,NULL,NULL,NULL,NULL),(22805,1047,0.75,40.0662,NULL,NULL,NULL,NULL),(22806,1047,1,43.0464,NULL,NULL,NULL,NULL),(22807,1047,1.5,45.6954,NULL,NULL,NULL,NULL),(22808,1047,2,49.6689,NULL,NULL,NULL,NULL),(22809,1047,3,52.3179,NULL,NULL,NULL,NULL),(22810,1047,4,55.298,NULL,NULL,NULL,NULL),(22811,1047,5,56.9536,NULL,NULL,NULL,NULL),(22812,1047,6,58.2781,NULL,NULL,NULL,NULL),(22813,1047,7,59.6026,NULL,NULL,NULL,NULL),(22814,1048,7,37.2,NULL,NULL,NULL,NULL),(22815,1049,7,41.9,NULL,NULL,NULL,NULL),(22816,1050,7,58.1,NULL,NULL,NULL,NULL),(22817,1051,6,11.0204,NULL,NULL,NULL,NULL),(22818,1051,17,17.7551,NULL,NULL,NULL,NULL),(22819,1051,32,22.0408,NULL,NULL,NULL,NULL),(22820,1051,47,26.3265,NULL,NULL,NULL,NULL),(22821,1051,75,30.5102,NULL,NULL,NULL,NULL),(22822,1051,97,31.7347,NULL,NULL,NULL,NULL),(22823,1051,123,33.9796,NULL,NULL,NULL,NULL),(22824,1051,165,36.9388,NULL,NULL,NULL,NULL),(22825,1051,220,36.4286,NULL,NULL,NULL,NULL),(22826,1051,261,39.1837,NULL,NULL,NULL,NULL),(22827,1052,4,12.1429,NULL,NULL,NULL,NULL),(22828,1052,15,21.5306,NULL,NULL,NULL,NULL),(22829,1052,18,22.449,NULL,NULL,NULL,NULL),(22830,1052,29,26.8367,NULL,NULL,NULL,NULL),(22831,1052,47,29.898,NULL,NULL,NULL,NULL),(22832,1052,74,34.6939,NULL,NULL,NULL,NULL),(22833,1052,96,35.9184,NULL,NULL,NULL,NULL),(22834,1052,123,39.1837,NULL,NULL,NULL,NULL),(22835,1052,165,40.5102,NULL,NULL,NULL,NULL),(22836,1052,206.5,42.3469,NULL,NULL,NULL,NULL),(22837,1052,262,43.4694,NULL,NULL,NULL,NULL),(22838,1053,4,17.9592,NULL,NULL,NULL,NULL),(22839,1053,15,23.3673,NULL,NULL,NULL,NULL),(22840,1053,18,24.1837,NULL,NULL,NULL,NULL),(22841,1053,29,27.7551,NULL,NULL,NULL,NULL),(22842,1053,47,31.3265,NULL,NULL,NULL,NULL),(22843,1053,74,35.4082,NULL,NULL,NULL,NULL),(22844,1053,96,36.5306,NULL,NULL,NULL,NULL),(22845,1053,132,39.0816,NULL,NULL,NULL,NULL),(22846,1053,175,41.1224,NULL,NULL,NULL,NULL),(22847,1053,213,42.8571,NULL,NULL,NULL,NULL),(22848,1053,255,43.8776,NULL,NULL,NULL,NULL),(22849,1054,3,16.9388,NULL,NULL,NULL,NULL),(22850,1054,7,21.4286,NULL,NULL,NULL,NULL),(22851,1054,14,25.5102,NULL,NULL,NULL,NULL),(22852,1054,25,28.4694,NULL,NULL,NULL,NULL),(22853,1054,40,33.1633,NULL,NULL,NULL,NULL),(22854,1054,53,34.5918,NULL,NULL,NULL,NULL),(22855,1054,67,37.449,NULL,NULL,NULL,NULL),(22856,1054,89,39.3878,NULL,NULL,NULL,NULL),(22857,1054,115,41.6327,NULL,NULL,NULL,NULL),(22858,1054,159,43.9796,NULL,NULL,NULL,NULL),(22859,1054,200,45.9184,NULL,NULL,NULL,NULL),(22860,1054,255,48.2653,NULL,NULL,NULL,NULL),(22861,1055,4,9.38776,NULL,NULL,NULL,NULL),(22862,1055,15,17.0408,NULL,NULL,NULL,NULL),(22863,1055,18,19.1837,NULL,NULL,NULL,NULL),(22864,1055,29,22.449,NULL,NULL,NULL,NULL),(22865,1055,47,23.9796,NULL,NULL,NULL,NULL),(22866,1055,67,26.1224,NULL,NULL,NULL,NULL),(22867,1055,90,29.5918,NULL,NULL,NULL,NULL),(22868,1055,127.5,31.0204,NULL,NULL,NULL,NULL),(22869,1055,161.5,33.8776,NULL,NULL,NULL,NULL),(22870,1055,200,34.7959,NULL,NULL,NULL,NULL),(22871,1055,242.5,37.551,NULL,NULL,NULL,NULL),(22872,1056,3,12.0408,NULL,NULL,NULL,NULL),(22873,1056,7,15.6122,NULL,NULL,NULL,NULL),(22874,1056,14,20.2041,NULL,NULL,NULL,NULL),(22875,1056,25,24.0816,NULL,NULL,NULL,NULL),(22876,1056,40,26.6327,NULL,NULL,NULL,NULL),(22877,1056,53,29.3878,NULL,NULL,NULL,NULL),(22878,1056,67,30.2041,NULL,NULL,NULL,NULL),(22879,1056,89,33.3673,NULL,NULL,NULL,NULL),(22880,1056,117,34.6939,NULL,NULL,NULL,NULL),(22881,1056,162,37.7551,NULL,NULL,NULL,NULL),(22882,1056,200,39.6939,NULL,NULL,NULL,NULL),(22883,1056,242,40.8163,NULL,NULL,NULL,NULL),(22884,1057,6,16.9388,NULL,NULL,NULL,NULL),(22885,1057,17,23.3673,NULL,NULL,NULL,NULL),(22886,1057,32,26.8367,NULL,NULL,NULL,NULL),(22887,1057,47,26.8367,NULL,NULL,NULL,NULL),(22888,1057,75,27.551,NULL,NULL,NULL,NULL),(22889,1057,102,28.9796,NULL,NULL,NULL,NULL),(22890,1057,144,30.4082,NULL,NULL,NULL,NULL),(22891,1057,188,33.1633,NULL,NULL,NULL,NULL),(22892,1057,228,31.0204,NULL,NULL,NULL,NULL),(22893,1057,284,36.8367,NULL,NULL,NULL,NULL),(22894,1058,4,7.95918,NULL,NULL,NULL,NULL),(22895,1058,14,12.8571,NULL,NULL,NULL,NULL),(22896,1058,24,14.7959,NULL,NULL,NULL,NULL),(22897,1058,39,16.3265,NULL,NULL,NULL,NULL),(22898,1058,52,17.3469,NULL,NULL,NULL,NULL),(22899,1058,81,18.9796,NULL,NULL,NULL,NULL),(22900,1058,108,20.7143,NULL,NULL,NULL,NULL),(22901,1058,151,22.551,NULL,NULL,NULL,NULL),(22902,1058,206,23.3673,NULL,NULL,NULL,NULL),(22903,1058,262,25.5102,NULL,NULL,NULL,NULL),(22904,1059,0.5,5.5,NULL,NULL,NULL,NULL),(22905,1059,2,14.5,NULL,NULL,NULL,NULL),(22906,1059,6.5,19,NULL,NULL,NULL,NULL),(22907,1059,9,21.5,NULL,NULL,NULL,NULL),(22908,1059,17,21.5,NULL,NULL,NULL,NULL),(22909,1059,27.5,24.5,NULL,NULL,NULL,NULL),(22910,1060,0.5,2,NULL,NULL,NULL,NULL),(22911,1060,4.5,6,NULL,NULL,NULL,NULL),(22912,1060,11,8,NULL,NULL,NULL,NULL),(22913,1060,21,10,NULL,NULL,NULL,NULL),(22914,1060,28,10,NULL,NULL,NULL,NULL),(22915,1061,21,24.6032,NULL,NULL,NULL,NULL),(22916,1061,49,37.3016,NULL,NULL,NULL,NULL),(22917,1061,112,43.6508,NULL,NULL,NULL,NULL),(22918,1061,180,48.4127,NULL,NULL,NULL,NULL),(22919,1061,365,50.7937,NULL,NULL,NULL,NULL),(22920,1061,610,59.5238,NULL,NULL,NULL,NULL),(22921,1061,850,61.9048,NULL,NULL,NULL,NULL),(22922,1061,1090,61.9048,NULL,NULL,NULL,NULL),(22923,1062,7,11.1801,NULL,NULL,NULL,NULL),(22924,1062,21,16.1491,NULL,NULL,NULL,NULL),(22925,1062,49,31.0559,NULL,NULL,NULL,NULL),(22926,1062,112,31.0559,NULL,NULL,NULL,NULL),(22927,1062,180,37.8882,NULL,NULL,NULL,NULL),(22928,1062,365,44.7205,NULL,NULL,NULL,NULL),(22929,1062,610,50.9317,NULL,NULL,NULL,NULL),(22930,1062,850,50.9317,NULL,NULL,NULL,NULL),(22931,1062,1090,53.4161,NULL,NULL,NULL,NULL),(22932,1063,7,31.6456,NULL,NULL,NULL,NULL),(22933,1063,21,41.7722,NULL,NULL,NULL,NULL),(22934,1063,49,48.1013,NULL,NULL,NULL,NULL),(22935,1063,112,51.8987,NULL,NULL,NULL,NULL),(22936,1063,180,60.1266,NULL,NULL,NULL,NULL),(22937,1063,365,65.8228,NULL,NULL,NULL,NULL),(22938,1063,610,72.7848,NULL,NULL,NULL,NULL),(22939,1063,850,79.1139,NULL,NULL,NULL,NULL),(22940,1063,1090,75.3165,NULL,NULL,NULL,NULL),(22941,1064,7,28.5714,NULL,NULL,NULL,NULL),(22942,1064,21,50,NULL,NULL,NULL,NULL),(22943,1064,35,64.2857,NULL,NULL,NULL,NULL),(22944,1064,63,80.6122,NULL,NULL,NULL,NULL),(22945,1064,91,92.8571,NULL,NULL,NULL,NULL),(22946,1064,140,106.122,NULL,NULL,NULL,NULL),(22947,1064,231,111.224,NULL,NULL,NULL,NULL),(22948,1064,322,119.388,NULL,NULL,NULL,NULL),(22949,1064,427,117.347,NULL,NULL,NULL,NULL),(22950,1064,434,112.245,NULL,NULL,NULL,NULL),(22951,1065,7,21.9388,NULL,NULL,NULL,NULL),(22952,1065,21,33.6735,NULL,NULL,NULL,NULL),(22953,1065,35,38.2653,NULL,NULL,NULL,NULL),(22954,1065,63,46.4286,NULL,NULL,NULL,NULL),(22955,1065,91,51.0204,NULL,NULL,NULL,NULL),(22956,1065,140,56.1224,NULL,NULL,NULL,NULL),(22957,1065,231,59.1837,NULL,NULL,NULL,NULL),(22958,1065,322,66.3265,NULL,NULL,NULL,NULL),(22959,1065,427,65.8163,NULL,NULL,NULL,NULL),(22960,1065,434,81.6327,NULL,1,NULL,NULL),(22961,1066,7,38.7755,NULL,NULL,NULL,NULL),(22962,1066,21,59.1837,NULL,NULL,NULL,NULL),(22963,1066,35,70.4082,NULL,NULL,NULL,NULL),(22964,1066,63,77.551,NULL,NULL,NULL,NULL),(22965,1066,91,88.7755,NULL,NULL,NULL,NULL),(22966,1066,140,105.102,NULL,NULL,NULL,NULL),(22967,1066,231,117.347,NULL,NULL,NULL,NULL),(22968,1066,322,135.714,NULL,NULL,NULL,NULL),(22969,1066,427,140.816,NULL,NULL,NULL,NULL),(22970,1066,434,132.653,NULL,NULL,NULL,NULL),(22971,1067,7,50,NULL,NULL,NULL,NULL),(22972,1067,21,65.3061,NULL,NULL,NULL,NULL),(22973,1067,35,75.5102,NULL,NULL,NULL,NULL),(22974,1067,49,84.6939,NULL,NULL,NULL,NULL),(22975,1067,91,102.041,NULL,NULL,NULL,NULL),(22976,1067,140,119.388,NULL,NULL,NULL,NULL),(22977,1067,231,132.653,NULL,NULL,NULL,NULL),(22978,1067,322,153.061,NULL,NULL,NULL,NULL),(22979,1067,427,160.204,NULL,NULL,NULL,NULL),(22980,1067,434,153.061,NULL,NULL,NULL,NULL),(22981,1068,7,24.4898,NULL,NULL,NULL,NULL),(22982,1068,21,40.8163,NULL,NULL,NULL,NULL),(22983,1068,35,46.9388,NULL,NULL,NULL,NULL),(22984,1068,63,57.1429,NULL,NULL,NULL,NULL),(22985,1068,91,61.2245,NULL,NULL,NULL,NULL),(22986,1068,140,72.449,NULL,NULL,NULL,NULL),(22987,1068,231,81.6327,NULL,NULL,NULL,NULL),(22988,1068,322,93.8775,NULL,NULL,NULL,NULL),(22989,1068,427,94.898,NULL,NULL,NULL,NULL),(22990,1068,434,90.8163,NULL,NULL,NULL,NULL),(22991,1069,7,27.551,NULL,NULL,NULL,NULL),(22992,1069,21,47.9592,NULL,NULL,NULL,NULL),(22993,1069,35,56.1224,NULL,NULL,NULL,NULL),(22994,1069,63,68.3673,NULL,NULL,NULL,NULL),(22995,1069,91,78.5714,NULL,NULL,NULL,NULL),(22996,1069,140,94.898,NULL,NULL,NULL,NULL),(2299