(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 13.1' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    364533,       6992]
NotebookOptionsPosition[    354785,       6853]
NotebookOutlinePosition[    355220,       6870]
CellTagsIndexPosition[    355177,       6867]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["\<\
Dark Matter Capture in Celestial Bodies 
(sample notebook for Asteria package)\
\>", "Title",
 CellChangeTimes->{{3.885225689799555*^9, 3.885225701337187*^9}, {
  3.892355479149901*^9, 3.8923554928230743`*^9}, {3.892456100432901*^9, 
  3.892456107275577*^9}, {3.895768548686306*^9, 
  3.895768550606443*^9}},ExpressionUUID->"84ab6d8c-d97b-4f4a-9330-\
55403ae360a2"],

Cell[CellGroupData[{

Cell["Inits: run to load package and initialise colors", "Section",
 CellChangeTimes->{{3.885225711393515*^9, 3.88522571218388*^9}, {
  3.892456528248241*^9, 3.8924565555157146`*^9}, {3.892460549201394*^9, 
  3.892460549857307*^9}},ExpressionUUID->"fcc77209-a368-4111-b0ff-\
7b83154b9b28"],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{"load", " ", "package"}], " ", "*)"}]], "Input",
 CellChangeTimes->{{3.885225768242354*^9, 3.885225775502561*^9}},
 CellLabel->
  "In[799]:=",ExpressionUUID->"ad72bb3a-7377-4e71-a94d-7a7aa269d5a3"],

Cell[BoxData[{
 RowBox[{"<<", "\"\<Asteria`\>\""}], "\[IndentingNewLine]", 
 RowBox[{"Get", "[", "\"\<Asteria`\>\"", "]"}]}], "Input",
 CellChangeTimes->{{3.89243323274452*^9, 3.892433233474268*^9}, {
   3.8924333153917027`*^9, 3.892433318988061*^9}, 3.892460115721232*^9, {
   3.892460305198257*^9, 3.892460305435575*^9}, {3.896519234218055*^9, 
   3.896519240229312*^9}},
 CellLabel->
  "In[800]:=",ExpressionUUID->"ca605006-ecae-417a-9c02-c494eabb9c8d"],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.892433273111003*^9, 3.892433275292465*^9}, {
   3.8924333212720127`*^9, 3.8924333218544817`*^9}, {3.892433391557806*^9, 
   3.8924333921310577`*^9}, 3.892460119717965*^9, 3.892460304336182*^9},
 CellLabel->
  "In[802]:=",ExpressionUUID->"4cfa6a07-0455-400e-8240-70f70d1d602b"],

Cell[BoxData[
 RowBox[{"(*", "colors", "*)"}]], "Input",
 CellChangeTimes->{{3.8852293746409187`*^9, 3.885229377968433*^9}},
 CellLabel->
  "In[803]:=",ExpressionUUID->"6d48c3d8-5266-4359-aac6-3d3c4de5f575"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"Color7Lines", "=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"RGBColor", "[", 
       RowBox[{"0.254627", ",", "0.013882", ",", "0.615419"}], "]"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"RGBColor", "[", 
       RowBox[{"0.477344", ",", "0.00698", ",", "0.659549"}], "]"}], ",", 
      RowBox[{"RGBColor", "[", 
       RowBox[{"0.674522", ",", "0.147419", ",", "0.578688"}], "]"}], ",", 
      RowBox[{"RGBColor", "[", 
       RowBox[{"0.819651", ",", "0.306812", ",", "0.448306"}], "]"}], ",", 
      RowBox[{"RGBColor", "[", 
       RowBox[{"0.928329", ",", "0.472975", ",", "0.326067"}], "]"}], ",", 
      RowBox[{"RGBColor", "[", 
       RowBox[{"0.989935", ",", "0.663787", ",", "0.204859"}], "]"}], ",", 
      RowBox[{"RGBColor", "[", 
       RowBox[{"0.968443", ",", "0.894564", ",", "0.147014"}], "]"}]}], 
     "}"}]}], ";"}], "\n"}], "\n", 
 RowBox[{
  RowBox[{"Color10Lines", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"RGBColor", "[", 
      RowBox[{"0.254627", ",", "0.013882", ",", "0.615419"}], "]"}], ",", 
     RowBox[{"RGBColor", "[", 
      RowBox[{"0.405503", ",", "0.000678", ",", "0.656977"}], "]"}], ",", 
     RowBox[{"RGBColor", "[", 
      RowBox[{"0.546157", ",", "0.038954", ",", "0.64701"}], "]"}], ",", 
     RowBox[{"RGBColor", "[", 
      RowBox[{"0.674522", ",", "0.147419", ",", "0.578688"}], "]"}], ",", 
     RowBox[{"RGBColor", "[", 
      RowBox[{"0.775796", ",", "0.253658", ",", "0.491171"}], "]"}], ",", 
     RowBox[{"RGBColor", "[", 
      RowBox[{"0.85975", ",", "0.360588", ",", "0.406917"}], "]"}], ",", 
     RowBox[{"RGBColor", "[", 
      RowBox[{"0.976428", ",", "0.596595", ",", "0.244767"}], "]"}], ",", 
     RowBox[{"RGBColor", "[", 
      RowBox[{"0.994495", ",", "0.74088", ",", "0.166335"}], "]"}], ",", 
     RowBox[{"RGBColor", "[", 
      RowBox[{"0.994495", ",", "0.74088", ",", "0.166335"}], "]"}], ",", 
     RowBox[{"RGBColor", "[", 
      RowBox[{"0.968443", ",", "0.894564", ",", "0.147014"}], "]"}]}], 
    "}"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.885225759898753*^9, 3.885225760650971*^9}, {
  3.8852284131803207`*^9, 3.885228441177472*^9}, {3.885228552709797*^9, 
  3.8852285591893673`*^9}, {3.885229328404065*^9, 3.885229342394229*^9}},
 CellLabel->
  "In[804]:=",ExpressionUUID->"6823d135-2e24-4e4d-8bac-1e4adae3c5de"],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{"DM", " ", "properties"}], "*)"}]], "Input",
 CellChangeTimes->{{3.884590674138419*^9, 3.8845906787306967`*^9}, 
   3.892433984044977*^9},
 CellLabel->
  "In[806]:=",ExpressionUUID->"e41e76fc-6b00-466d-9144-0577e68924a0"],

Cell[BoxData[
 RowBox[{
  RowBox[{"vDMlocal", "=", 
   RowBox[{"270", " ", 
    RowBox[{"km", "/", "s"}]}]}], ";"}]], "Input",
 CellChangeTimes->{{3.884590666137834*^9, 3.884590672674777*^9}},
 CellLabel->
  "In[807]:=",ExpressionUUID->"5b2280ae-240c-4193-9de4-6cafc2d93ea3"],

Cell[BoxData[
 RowBox[{
  RowBox[{"nDMlocal", "=", 
   RowBox[{"0.4", " ", 
    RowBox[{"GeV", "/", 
     RowBox[{"cm", "^", "3"}]}]}]}], ";"}]], "Input",
 CellChangeTimes->{{3.884592145396196*^9, 3.884592149672927*^9}},
 CellLabel->
  "In[808]:=",ExpressionUUID->"4ff64f86-f618-4929-8a65-21cc35b5ab38"]
}, Closed]],

Cell[CellGroupData[{

Cell["Get Total Capture Rate", "Section",
 CellChangeTimes->{{3.885228587255619*^9, 3.885228600362206*^9}, {
  3.892433512453267*^9, 3.892433518444819*^9}, {3.895768673195421*^9, 
  3.89576868175593*^9}},ExpressionUUID->"cb1541b6-0371-4657-944a-\
02cba7c33b1b"],

Cell[BoxData[
 RowBox[{"Clear", "[", 
  RowBox[{
  "DarkMatterMass", ",", "DarkMatterElasticCrossSection", ",", 
   "DarkMatterVelocity", ",", "DarkMatterDensity", ",", "Radius", ",", 
   "ObjectMass", ",", "CompositionVector"}], "]"}]], "Input",
 CellChangeTimes->{{3.8924340446839123`*^9, 3.892434072257474*^9}},
 CellLabel->"In[11]:=",ExpressionUUID->"e66e8266-887b-483a-846a-2be432159b9a"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"DarkMatterMass", "=", "ENTERMASS"}], ";"}], " ", 
  RowBox[{"(*", "GeV", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"DarkMatterElasticCrossSection", "=", "ENTERCROSSSECTION"}], ";"}],
   "  ", 
  RowBox[{"(*", " ", 
   RowBox[{"in", " ", 
    RowBox[{"cm", "^", "2"}]}], " ", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"DarkMatterVelocity", " ", "=", " ", "ENTERVELOCITY"}], ";"}], " ", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"km", "/", "s"}], " ", ",", " ", 
    RowBox[{"local", " ", 
     SubscriptBox["v", "\[Chi]"], " ", "is", " ", "270", " ", 
     RowBox[{"km", "/", "s"}]}]}], " ", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"DarkMatterDensity", " ", "=", " ", "ENTERDENSITY"}], ";"}], " ", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"in", " ", 
     RowBox[{"GeV", "/", 
      RowBox[{"cm", "^", "3"}]}]}], ",", " ", 
    RowBox[{
     RowBox[{"local", " ", "n\[Chi]"}], " ", "=", " ", 
     RowBox[{"0.4", " ", 
      RowBox[{"GeV", "/", 
       RowBox[{"cm", "^", "3"}]}]}]}]}], " ", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Radius", "=", " ", "ENTERRADIUS"}], ";"}], " ", 
  RowBox[{"(*", " ", 
   RowBox[{"in", " ", "cm"}], " ", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ObjectMass", " ", "=", " ", "ENTERMASSOBJECT"}], ";"}], " ", 
  RowBox[{"(*", " ", 
   RowBox[{"in", " ", "g"}], " ", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"CompositionVector", "=", 
    RowBox[{"{", 
     RowBox[{"ENTERELEMENMASSFRACTION", ",", " ", "ENTERELEMENTMASS"}], 
     "}"}]}], ";"}], " ", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"for", " ", "100", "%", " ", "htdrogen", " ", "enter", " ", 
     RowBox[{"{", 
      RowBox[{"1", ",", "1"}], "}"}]}], ",", " ", 
    RowBox[{"for", " ", "75", "%", " ", "hydrogen"}], ",", " ", 
    RowBox[{"25", "%", " ", "helim", " ", "enter", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0.75", ",", "1"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"0.25", ",", "4"}], "}"}]}], "}"}], " ", 
     RowBox[{"etc", "."}]}]}], "  ", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SigmaWeightsVector", " ", "=", " ", 
   RowBox[{"{", "CROSSSECTIONWEIGHTS", "}"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.892433537197378*^9, 3.8924338815961227`*^9}, {
  3.892434186719185*^9, 3.892434187173925*^9}, {3.8924342664662647`*^9, 
  3.892434268724469*^9}, {3.892460392581724*^9, 3.892460400845875*^9}, {
  3.8989240264070473`*^9, 
  3.8989240506921177`*^9}},ExpressionUUID->"d51c7abe-dcb0-4187-bbef-\
fb04b3657871"],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{
   RowBox[{"get", " ", "capture", " ", "rates", " ", "with", " ", 
    RowBox[{"options", ":", " ", 
     RowBox[{
      RowBox[{
      "the", " ", "default", " ", "is", " ", "that", " ", "the", " ", "input",
        " ", "cross", " ", "section", " ", "is", " ", "assumed", " ", "to", 
       " ", "be", " ", "the", " ", "dark", " ", "matter"}], "-", 
      RowBox[{"nucleon", " ", "cross", " ", "section"}]}]}]}], ",", 
   "\[IndentingNewLine]", "   ", 
   RowBox[{
   "depending", " ", "on", " ", "the", " ", "elemental", " ", "composition", 
    " ", "it", " ", "is", " ", "then", " ", "internally", " ", "converted", 
    " ", "to", " ", "the", " ", "dark", " ", "matter", " ", "nucleus", " ", 
    "cross", " ", "section", "\[IndentingNewLine]", "\[IndentingNewLine]", 
    "\"\<Total\>\"", " ", "which", " ", "gives", " ", "you", " ", "the", " ", 
    "total", " ", "capture", " ", "rate", " ", 
    RowBox[{"in", " ", "[", 
     RowBox[{"1", "/", "s"}], "]"}], "\[IndentingNewLine]", "\"\<Normal\>\"", 
    " ", "gives", " ", "you", " ", "the", " ", "capture", " ", "rate"}], ",", 
   " ", 
   RowBox[{
   "normalized", " ", "to", " ", "the", " ", "dark", " ", "matter", " ", 
    "flux", " ", "through", " ", "the", " ", "object", "\[IndentingNewLine]", 
    "\"\<Normal no Reflection\>\"", " ", "gives", " ", "you", " ", "the", " ",
     "capture", " ", "rate"}], ",", " ", 
   RowBox[{
   "normalized", " ", "to", " ", "the", " ", "dark", " ", "matter", " ", 
    "flux", " ", "through", " ", "the", " ", "object", " ", "and", " ", 
    "switches", " ", "off", " ", "reflection", "\[IndentingNewLine]", 
    "\"\<Geometric\>\"", " ", "gives", " ", "you", " ", "the", " ", "total", 
    " ", "dark", " ", "matter", " ", "flux", " ", "through", " ", "the", " ", 
    "obejct", " ", "in", " ", 
    RowBox[{"particles", " ", "[", 
     RowBox[{"1", "/", "s"}], "]"}], "\[IndentingNewLine]", 
    "\"\<Reflection\>\"", " ", "gives", " ", "you", " ", "the", " ", 
    "fraction", " ", "of", " ", "relected", " ", "dark", " ", "matter", " ", 
    "particles", " ", "in", " ", "the", " ", "diffusive", " ", "regime", " ", 
    "\[IndentingNewLine]", "\"\<Total Crosssection\>\"", " ", "gives", " ", 
    "you", " ", "the", " ", "total", " ", "capture", " ", "rate", " ", 
    RowBox[{"in", " ", "[", 
     RowBox[{"1", "/", "s"}], "]"}]}], ",", " ", "however", ",", 
   "            ", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
    "now", " ", "the", " ", "input", " ", "cross", " ", "section", " ", "is", 
     " ", "assumed", " ", "to", " ", "be", " ", "the", " ", "dark", " ", 
     "matter", " ", "neutleus", " ", "cross", " ", 
     RowBox[{"section", ".", " ", "This"}], " ", "is", " ", "the", " ", "way",
      " ", "to", " ", "apply", " ", "the", " ", "package", " ", "to", " ", 
     "spin"}], "-", 
    RowBox[{
    "dependent", " ", "or", " ", "other", " ", "specific", " ", 
     "interactions"}]}]}], "\[IndentingNewLine]", "*)"}]], "Input",
 CellChangeTimes->{{3.892433927569426*^9, 3.892433962435256*^9}, {
  3.892434813607222*^9, 3.892434814919579*^9}, {3.89576819231658*^9, 
  3.895768213117695*^9}, {3.896519573127302*^9, 
  3.8965199210755873`*^9}},ExpressionUUID->"db9faa2d-f396-4299-a0ff-\
f41bf145b180"],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.8957688646721497`*^9, 3.89576888951857*^9}, 
   3.8965199270544252`*^9},ExpressionUUID->"62277ad2-e692-4b16-a966-\
b2e2ecc6ad24"],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{
   RowBox[{
   "example", " ", "of", " ", "syntax", " ", "for", " ", "the", " ", 
    "default", " ", "Spin"}], "-", 
   RowBox[{"Independent", " ", 
    RowBox[{"scattering", ":"}]}]}], "*)"}]], "Input",
 CellChangeTimes->{{3.896519952156498*^9, 3.8965199576570797`*^9}, {
  3.899179668052706*^9, 
  3.899179687231887*^9}},ExpressionUUID->"004845b7-fba8-4505-9271-\
24f72f906b9f"],

Cell[BoxData[
 RowBox[{"DMCapture", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "DarkMatterMass", ",", "DarkMatterElasticCrossSection", ",", 
     "DarkMatterVelocity", ",", "ObjectMass", ",", "Radius", ",", 
     "DarkMatterDensity"}], "}"}], ",", "\"\<Total\>\"", ",", 
   RowBox[{"CompositionVector", "[", 
    RowBox[{"[", 
     RowBox[{"All", ",", "1"}], "]"}], "]"}], ",", 
   RowBox[{"CompositionVector", "[", 
    RowBox[{"[", 
     RowBox[{"All", ",", "2"}], "]"}], "]"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.89243367581429*^9, 3.892433753130638*^9}, {
  3.8924338876278267`*^9, 3.892433921344171*^9}, {3.8924603202112427`*^9, 
  3.8924603217521544`*^9}, {3.895396842565482*^9, 3.895396851451065*^9}},
 CellLabel->"In[21]:=",ExpressionUUID->"213192b1-4a2a-44b5-b847-de62bf8d6cdc"],

Cell[BoxData[
 RowBox[{"(*", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
   "Example", " ", "of", " ", "syntax", " ", "for", " ", "manual", " ", 
    "cross", " ", "section", " ", 
    RowBox[{"input", ":", " ", 
     RowBox[{
     "The", " ", "\"\<Total Crosssection\>\"", " ", "switches", " ", "off", 
      " ", "the", " ", "internal", " ", "default", " ", "scaling", " ", "for",
       " ", "Spin", " ", "Independent", " ", "cross", " ", "sections", " ", 
      "and", " ", "takes", " ", "the", " ", 
      "\"\<DarkMatterElasticCrossSection\>\"", " ", "as", " ", "direct", " ", 
      
      RowBox[{"input", ".", " ", "In"}], " ", "the", " ", "case", " ", "of", 
      " ", "multiple", " ", "elements", " ", "weight", " ", "factors", " ", 
      "for", " ", "each", " ", "element", " ", "have", " ", "to", " ", "be", 
      " ", "provided", " ", "as", " ", "a", " ", "vector", " ", "of", " ", 
      "the", " ", "same", " ", "length", " ", "as", " ", "the", " ", 
      "Composition", " ", 
      RowBox[{"Vector", ".", " ", "For"}], " ", "example", " ", "in", " ", 
      "an", " ", "object", " ", "composed", " ", "of", " ", "three", " ", 
      "elements", " ", "a", " ", "SigmaWeightsVector"}]}]}], " ", "=", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", " ", "1", ",", " ", "1"}], "}"}], " ", "will", " ", 
     "give", " ", "equal", " ", "interaction", " ", "cros", " ", "sections", 
     " ", "with", " ", "all", " ", "three", " ", "elements", " ", "set", " ", 
     "by", " ", "the", " ", "value", " ", "of", " ", 
     RowBox[{"\"\<DarkMatterElasticCrossSection\>\"", ".", " ", "This"}], " ",
      "input", " ", "mode", " ", "can", " ", "be", " ", "used", " ", "to", 
     " ", "implement", " ", "Spin"}], "-", 
    RowBox[{"Dependent", " ", "dark", " ", "matter", " ", 
     RowBox[{"scattering", "."}]}]}]}], "\[IndentingNewLine]", 
  "*)"}]], "Input",
 CellChangeTimes->{{3.898923992065865*^9, 3.89892400236309*^9}, {
  3.899179397947191*^9, 3.899179659515444*^9}, {3.899179693280375*^9, 
  3.899179724970812*^9}},ExpressionUUID->"73a645c3-06dc-4308-8e26-\
c79fc3ab0a11"],

Cell[BoxData[
 RowBox[{
  RowBox[{"DMCapture", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
     "DarkMatterMass", ",", "DarkMatterElasticCrossSection", ",", 
      "DarkMatterVelocity", ",", "ObjectMass", ",", "Radius", ",", 
      "DarkMatterDensity"}], "}"}], ",", "\"\<Total Crosssection\>\"", ",", 
    RowBox[{"CompositionVector", "[", 
     RowBox[{"[", 
      RowBox[{"All", ",", "1"}], "]"}], "]"}], ",", 
    RowBox[{"CompositionVector", "[", 
     RowBox[{"[", 
      RowBox[{"All", ",", "2"}], "]"}], "]"}], ",", "SigmaWeightsVector"}], 
   "]"}], "\[IndentingNewLine]"}]], "Input",
 CellChangeTimes->{
  3.892434209160986*^9, {3.8989239835167017`*^9, 
   3.898924021214138*^9}},ExpressionUUID->"20eb835d-1e27-480b-ad47-\
5ef5841cab76"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example Rates for Jupiter given different output options ", "Section",
 CellChangeTimes->{{3.89576844252796*^9, 
  3.895768477809503*^9}},ExpressionUUID->"ce64a44c-db06-4d1c-b162-\
639e8b3347b7"],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{
   RowBox[{
   "example", " ", "for", " ", "Jupiter", " ", "at", " ", "the", " ", "local",
     " ", "position"}], ",", " ", 
   RowBox[{
   "and", " ", "a", " ", "rate", " ", "for", " ", "capturing", " ", "1.0", 
    " ", "GeV", " ", "dark", " ", "matter", " ", "with", " ", "a", "  ", 
    RowBox[{"10", "^", 
     RowBox[{"-", "32"}]}], " ", 
    RowBox[{"cm", "^", "2"}], " ", "cross", " ", "section"}]}], " ", 
  "*)"}]], "Input",
 CellChangeTimes->{{3.892434075635817*^9, 3.89243412666358*^9}},
 CellLabel->
  "In[600]:=",ExpressionUUID->"f662b32f-6349-4cf6-958c-730ba958182f"],

Cell[BoxData[
 RowBox[{"Clear", "[", 
  RowBox[{
  "DarkMatterMass", ",", "DarkMatterElasticCrossSection", ",", 
   "DarkMatterVelocity", ",", "DarkMatterDensity", ",", "Radius", ",", 
   "ObjectMass", ",", "CompositionVector"}], "]"}]], "Input",
 CellLabel->
  "In[601]:=",ExpressionUUID->"4346a0f2-51f4-47c0-b19e-6aca7dd3fb1e"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"DarkMatterMass", "=", "1.0"}], ";"}], " ", 
  RowBox[{"(*", "GeV", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"DarkMatterElasticCrossSection", "=", 
    RowBox[{"10", "^", 
     RowBox[{"-", "33."}]}]}], ";"}], "  ", 
  RowBox[{"(*", " ", 
   RowBox[{"in", " ", 
    RowBox[{"cm", "^", "2"}]}], " ", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"DarkMatterVelocity", " ", "=", " ", "270."}], ";"}], " ", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"km", "/", "s"}], " ", ",", " ", 
    RowBox[{"local", " ", 
     SubscriptBox["v", "\[Chi]"], " ", "is", " ", "270", " ", 
     RowBox[{"km", "/", "s"}]}]}], " ", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"DarkMatterDensity", " ", "=", " ", "0.4"}], ";"}], " ", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"in", " ", 
     RowBox[{"GeV", "/", 
      RowBox[{"cm", "^", "3"}]}]}], ",", " ", 
    RowBox[{
     RowBox[{"local", " ", "n\[Chi]"}], " ", "=", " ", 
     RowBox[{"0.4", " ", 
      RowBox[{"GeV", "/", 
       RowBox[{"cm", "^", "3"}]}]}]}]}], " ", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Radius", "=", " ", 
    RowBox[{"6.99", "*", 
     RowBox[{"10", "^", "9"}]}]}], ";"}], " ", 
  RowBox[{"(*", " ", 
   RowBox[{"in", " ", "cm"}], " ", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ObjectMass", " ", "=", " ", 
    RowBox[{"1.89", "*", 
     RowBox[{"10", "^", "30"}]}]}], ";"}], " ", 
  RowBox[{"(*", " ", 
   RowBox[{"in", " ", "g"}], " ", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"CompositionVector", "=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0.75", ",", "1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0.25", ",", "4"}], "}"}]}], "}"}]}], ";"}], " ", 
  RowBox[{"(*", " ", 
   RowBox[{"for", " ", "100", "%", " ", "htdrogen", " ", "enter", " ", 
    RowBox[{"{", 
     RowBox[{"1", ",", "1"}], "}"}]}], "*)"}]}]}], "Input",
 CellChangeTimes->{{3.892434135110031*^9, 3.892434281300942*^9}, {
  3.892465248920361*^9, 3.892465290009678*^9}, {3.892465338499535*^9, 
  3.892465338759495*^9}, {3.89246539512842*^9, 3.892465395293254*^9}, {
  3.892465593705185*^9, 3.892465603212139*^9}, {3.894037260220632*^9, 
  3.894037260974675*^9}, {3.894038289778508*^9, 3.894038290148493*^9}, {
  3.89652013774867*^9, 3.8965201378110237`*^9}, {3.9011872290068817`*^9, 
  3.90118723146143*^9}},
 CellLabel->
  "In[602]:=",ExpressionUUID->"eb806861-aee8-4d7d-99a8-cc221f15d053"],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.892433927569426*^9, 3.892433962435256*^9}, {
   3.892456297641592*^9, 3.8924563102815533`*^9}, {3.892456482925774*^9, 
   3.8924565088842983`*^9}, {3.892465142499111*^9, 3.8924651477240067`*^9}, 
   3.895768611702317*^9},
 CellLabel->
  "In[609]:=",ExpressionUUID->"4a77dd31-e889-4200-aef9-3d0676f67d8e"],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{"Total", ":", " ", 
   RowBox[{"total", " ", "capture", " ", "rate", " ", "in", " ", 
    RowBox[{"1", "/", "s"}], " ", "including", " ", "reflection"}]}], " ", 
  "*)"}]], "Input",
 CellChangeTimes->{{3.892456316192833*^9, 3.892456345155982*^9}},
 CellLabel->
  "In[610]:=",ExpressionUUID->"46c8d485-1245-4e55-a43e-5642e1376d34"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DMCapture", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "DarkMatterMass", ",", "DarkMatterElasticCrossSection", ",", 
     "DarkMatterVelocity", ",", "ObjectMass", ",", "Radius", ",", 
     "DarkMatterDensity"}], " ", "}"}], ",", "\"\<Total\>\"", ",", 
   RowBox[{"CompositionVector", "[", 
    RowBox[{"[", 
     RowBox[{"All", ",", "1"}], "]"}], "]"}], ",", 
   RowBox[{"CompositionVector", "[", 
    RowBox[{"[", 
     RowBox[{"All", ",", "2"}], "]"}], "]"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.89243367581429*^9, 3.892433753130638*^9}, {
   3.8924338876278267`*^9, 3.892433921344171*^9}, 3.892460345846753*^9},
 CellLabel->
  "In[611]:=",ExpressionUUID->"bb8222dd-1d02-4203-b6e5-c1b814c45741"],

Cell[BoxData["8.973298799207416`*^26"], "Output",
 CellChangeTimes->{
  3.892434221960425*^9, {3.892434275650545*^9, 3.8924342841736298`*^9}, 
   3.8924603464543962`*^9, {3.892465265163952*^9, 3.892465292382265*^9}, {
   3.8924653298977013`*^9, 3.892465341019938*^9}, 3.892465399413506*^9, {
   3.89246558155214*^9, 3.8924656088827133`*^9}, 3.8934212901776342`*^9, {
   3.894037256004466*^9, 3.894037264008739*^9}, 3.894038292142874*^9, {
   3.89539675011889*^9, 3.895396764601452*^9}, 3.895396867775663*^9, 
   3.895396897906967*^9, 3.8965199772370377`*^9, 3.896520140607856*^9, 
   3.901257745839822*^9},
 CellLabel->
  "Out[611]=",ExpressionUUID->"4a1016a5-3ec5-47a8-a629-789a70f8ee53"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{"Geometric", ":", " ", 
   RowBox[{"geometric", " ", "capture", " ", "rate", " ", "in", " ", 
    RowBox[{"1", "/", "s"}], " ", 
    RowBox[{"i", ".", "e", ".", " ", "the"}], " ", "flux", " ", "of", " ", 
    "DM", " ", "particles", " ", "through", " ", "the", " ", "object", " ", 
    "including", " ", "gravitational", " ", "focusing"}]}], " ", 
  "*)"}]], "Input",
 CellChangeTimes->{{3.8924343671802797`*^9, 3.892434370621711*^9}, {
  3.892456347234714*^9, 3.8924563823870707`*^9}},
 CellLabel->
  "In[612]:=",ExpressionUUID->"57bea563-ffff-47a2-a59c-52311ef51c19"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DMCapture", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "DarkMatterMass", ",", "DarkMatterElasticCrossSection", ",", 
     "DarkMatterVelocity", ",", "ObjectMass", ",", "Radius", ",", 
     "DarkMatterDensity"}], " ", "}"}], ",", "\"\<Geometric\>\"", ",", 
   RowBox[{"CompositionVector", "[", 
    RowBox[{"[", 
     RowBox[{"All", ",", "1"}], "]"}], "]"}], ",", 
   RowBox[{"CompositionVector", "[", 
    RowBox[{"[", 
     RowBox[{"All", ",", "2"}], "]"}], "]"}]}], "]"}]], "Input",
 CellChangeTimes->{3.892434374806163*^9, 3.892460348577032*^9},
 CellLabel->
  "In[613]:=",ExpressionUUID->"f4721d89-b568-41ef-9d95-17c5a59e89be"],

Cell[BoxData["1.641696961068287`*^27"], "Output",
 CellChangeTimes->{
  3.892434375341544*^9, 3.8924603490158577`*^9, {3.8924652666533127`*^9, 
   3.89246529497141*^9}, {3.892465331496481*^9, 3.8924653446801558`*^9}, 
   3.892465402953261*^9, {3.892465583179512*^9, 3.8924656108320923`*^9}, 
   3.893421290215972*^9, 3.894037267951118*^9, 3.894038294606275*^9, {
   3.895396750140312*^9, 3.895396764622611*^9}, 3.8953968678043833`*^9, 
   3.895396899697324*^9, 3.896519980629141*^9, 3.896520142710166*^9, 
   3.901257745858308*^9},
 CellLabel->
  "Out[613]=",ExpressionUUID->"af229265-8e78-42a5-b554-884130aaa95d"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{"Total", " ", 
    RowBox[{"Crosssection", ":", " ", 
     RowBox[{
      RowBox[{"capture", " ", "rate", " ", "in", " ", 
       RowBox[{"1", "/", "s"}], " ", "with", " ", "\[Sigma]", " ", "in", " ", 
       
       RowBox[{"cm", "^", "2"}], " ", "taking", " ", "as", " ", "input", " ", 
       "the", " ", "total", " ", "DM"}], "-", 
      RowBox[{"nucleus", " ", "cross", " ", "section"}]}]}]}], " ", "*)"}], 
  RowBox[{"(*", " ", 
   RowBox[{"rename", " ", "->", " ", "Nucleus"}], " ", "*)"}]}]], "Input",
 CellChangeTimes->{{3.8924343671802797`*^9, 3.892434370621711*^9}, {
  3.892456347234714*^9, 3.8924563823870707`*^9}, {3.892465163575983*^9, 
  3.892465205895424*^9}, {3.895768308137887*^9, 3.895768325739593*^9}},
 CellLabel->
  "In[614]:=",ExpressionUUID->"cee2294f-298a-46e4-b26e-72209ce1b6ed"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DMCapture", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "DarkMatterMass", ",", "DarkMatterElasticCrossSection", ",", 
     "DarkMatterVelocity", ",", "ObjectMass", ",", "Radius", ",", 
     "DarkMatterDensity"}], " ", "}"}], ",", "\"\<Total Crosssection\>\"", 
   ",", 
   RowBox[{"CompositionVector", "[", 
    RowBox[{"[", 
     RowBox[{"All", ",", "1"}], "]"}], "]"}], ",", 
   RowBox[{"CompositionVector", "[", 
    RowBox[{"[", 
     RowBox[{"All", ",", "2"}], "]"}], "]"}]}], "]"}]], "Input",
 CellChangeTimes->{
  3.892434374806163*^9, 3.892460348577032*^9, {3.892465210325328*^9, 
   3.892465213601815*^9}},
 CellLabel->
  "In[615]:=",ExpressionUUID->"4f6298c4-7ed6-47e7-9f92-5cef6f3cdb5e"],

Cell[BoxData[
 RowBox[{"Asteria`Private`Option5", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "1.`", ",", "1.`*^-33", ",", "270.`", ",", "1.89`*^30", ",", "6.99`*^9", 
     ",", "0.4`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.75`", ",", "0.25`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "4"}], "}"}]}], "]"}]], "Output",
 CellChangeTimes->{
  3.892434375341544*^9, 3.8924603490158577`*^9, 3.892465214206565*^9, {
   3.8924652688853617`*^9, 3.892465296744424*^9}, {3.892465333066868*^9, 
   3.892465346402162*^9}, 3.892465404908547*^9, {3.8924655855649548`*^9, 
   3.892465615616411*^9}, 3.893421290254703*^9, 3.894037270854846*^9, 
   3.894038299250876*^9, {3.895396750164104*^9, 3.89539676464198*^9}, 
   3.895396867823791*^9, 3.895396901618725*^9, 3.896519987693225*^9, 
   3.896520144406645*^9, 3.901257745879879*^9},
 CellLabel->
  "Out[615]=",ExpressionUUID->"501be3e4-9735-405d-9144-f580bdcb4766"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{"Normal", ":", " ", 
   RowBox[{
   "capture", " ", "rate", " ", "normalised", " ", "to", " ", "the", " ", 
    "geometric", " ", "rate", " ", "including", " ", "reflection", " ", 
    RowBox[{"i", ".", "e", ".", " ", "fraction"}], " ", "of", " ", "DM", " ", 
    "particles", " ", "captured", " ", "that", " ", "pass", " ", 
    "through"}]}], " ", "*)"}]], "Input",
 CellChangeTimes->{{3.892434294580377*^9, 3.8924343049314823`*^9}, {
  3.892456394398335*^9, 3.892456426725358*^9}},
 CellLabel->
  "In[616]:=",ExpressionUUID->"6c6ac345-9b87-4e2b-9bba-d1ae8072d0af"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DMCapture", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "DarkMatterMass", ",", "DarkMatterElasticCrossSection", ",", 
     "DarkMatterVelocity", ",", "ObjectMass", ",", "Radius", ",", 
     "DarkMatterDensity"}], " ", "}"}], ",", "\"\<Normal\>\"", ",", 
   RowBox[{"CompositionVector", "[", 
    RowBox[{"[", 
     RowBox[{"All", ",", "1"}], "]"}], "]"}], ",", 
   RowBox[{"CompositionVector", "[", 
    RowBox[{"[", 
     RowBox[{"All", ",", "2"}], "]"}], "]"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.892434299513734*^9, 3.8924343001661253`*^9}, {
  3.8924603512678022`*^9, 3.892460353042734*^9}},
 CellLabel->
  "In[617]:=",ExpressionUUID->"fdb58d76-b7e8-4cba-9726-d0270a350f7b"],

Cell[BoxData["0.5465867947619456`"], "Output",
 CellChangeTimes->{
  3.8924343005732203`*^9, 3.8924346888310547`*^9, 3.892460353486829*^9, 
   3.89246530098521*^9, {3.892465335244275*^9, 3.892465364340047*^9}, 
   3.892465406411821*^9, 3.892465575335764*^9, 3.892465622494412*^9, 
   3.893421290314836*^9, 3.894037275383491*^9, 3.894038301662752*^9, {
   3.895396750188808*^9, 3.895396764660139*^9}, 3.895396867845434*^9, 
   3.895396903235876*^9, 3.896519995345339*^9, 3.896520146807156*^9, 
   3.9012577459007883`*^9},
 CellLabel->
  "Out[617]=",ExpressionUUID->"0889dbd8-77c7-4692-abf1-60b35cc1a327"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{"Normal", " ", "no", " ", 
   RowBox[{"Reflection", ":", "  ", 
    RowBox[{
    "capture", " ", "rate", " ", "normalised", " ", "to", " ", "the", " ", 
     "geometric", " ", "rate", " ", "without", " ", "reflection"}]}]}], " ", 
  "*)"}]], "Input",
 CellChangeTimes->{{3.892434784085537*^9, 3.8924348039565363`*^9}, {
  3.8924564359838047`*^9, 3.892456449387965*^9}},
 CellLabel->
  "In[618]:=",ExpressionUUID->"36dc015f-53c9-4b7e-9e39-a8fcd5cbb9cb"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DMCapture", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "DarkMatterMass", ",", "DarkMatterElasticCrossSection", ",", 
     "DarkMatterVelocity", ",", "ObjectMass", ",", "Radius", ",", 
     "DarkMatterDensity"}], " ", "}"}], ",", "\"\<Normal no Reflection\>\"", 
   ",", 
   RowBox[{"CompositionVector", "[", 
    RowBox[{"[", 
     RowBox[{"All", ",", "1"}], "]"}], "]"}], ",", 
   RowBox[{"CompositionVector", "[", 
    RowBox[{"[", 
     RowBox[{"All", ",", "2"}], "]"}], "]"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.8924343107162724`*^9, 3.89243434074404*^9}, 
   3.8924603565646973`*^9},
 CellLabel->
  "In[619]:=",ExpressionUUID->"9a91f474-0d96-4d22-b6e6-580da5ae2007"],

Cell[BoxData["0.9537302235976883`"], "Output",
 CellChangeTimes->{{3.892434315290289*^9, 3.8924343411541433`*^9}, 
   3.892434689707842*^9, 3.892460356937644*^9, 3.892465307037438*^9, 
   3.8924653749743423`*^9, 3.892465407790427*^9, 3.892465457937392*^9, 
   3.8924655684992733`*^9, 3.8924656238275213`*^9, 3.893421290348473*^9, 
   3.8940372772082033`*^9, 3.8940383081902246`*^9, {3.895396750208934*^9, 
   3.895396764678234*^9}, 3.8953968678712807`*^9, 3.895396904942487*^9, 
   3.8965199982871428`*^9, 3.8965201494014883`*^9, 3.901257745916194*^9},
 CellLabel->
  "Out[619]=",ExpressionUUID->"76c43c6b-c9c8-42b6-bfde-050700d2042c"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{"Reflection", ":", " ", 
   RowBox[{
   "Reflected", " ", "fraction", " ", "of", " ", "the", " ", "DM", " ", 
    "flux"}]}], " ", "*)"}]], "Input",
 CellChangeTimes->{{3.892434791232326*^9, 3.892434802269937*^9}, {
  3.892456454316779*^9, 3.892456461291112*^9}},
 CellLabel->
  "In[620]:=",ExpressionUUID->"615d5236-97ec-45ec-a679-e49e1bf3b878"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DMCapture", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "DarkMatterMass", ",", "DarkMatterElasticCrossSection", ",", 
     "DarkMatterVelocity", ",", "ObjectMass", ",", "Radius", ",", 
     "DarkMatterDensity"}], " ", "}"}], ",", "\"\<Reflection\>\"", ",", 
   RowBox[{"CompositionVector", "[", 
    RowBox[{"[", 
     RowBox[{"All", ",", "1"}], "]"}], "]"}], ",", 
   RowBox[{"CompositionVector", "[", 
    RowBox[{"[", 
     RowBox[{"All", ",", "2"}], "]"}], "]"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.8924343847255898`*^9, 3.892434386089916*^9}, {
   3.892434423582822*^9, 3.892434433749897*^9}, {3.892434475181994*^9, 
   3.892434519833775*^9}, {3.892434563570697*^9, 3.8924345793213778`*^9}, {
   3.892434703363937*^9, 3.892434711810996*^9}, 3.892434763382803*^9, {
   3.892460360031756*^9, 3.89246037949426*^9}},
 CellLabel->
  "In[621]:=",ExpressionUUID->"24ad005f-43a0-4c13-a43f-77e3174b54cb"],

Cell[BoxData["0.4534132052380544`"], "Output",
 CellChangeTimes->{
  3.892434386459901*^9, {3.892434426451069*^9, 3.892434434056041*^9}, {
   3.892434471275649*^9, 3.892434520206873*^9}, {3.8924345562531347`*^9, 
   3.892434579731534*^9}, {3.892434697822256*^9, 3.892434712172789*^9}, {
   3.8924347548095913`*^9, 3.892434764215798*^9}, {3.892460360457984*^9, 
   3.8924603799312687`*^9}, 3.892460479130229*^9, 3.892465311527135*^9, 
   3.892465376916132*^9, 3.8924654090951757`*^9, 3.892465625444111*^9, 
   3.89342129037948*^9, 3.894037278840111*^9, 3.8940383112093067`*^9, {
   3.8953967502286873`*^9, 3.8953967646949577`*^9}, 3.895396906629592*^9, 
   3.896520016221039*^9, 3.8965201530196466`*^9, 3.9012577459420156`*^9},
 CellLabel->
  "Out[621]=",ExpressionUUID->"d0d6aa07-c782-4bc1-8fe4-cbd2b0a63a8f"]
}, Open  ]],

Cell[BoxData[""], "Input",
 CellChangeTimes->{3.892434360503978*^9},
 CellLabel->
  "In[622]:=",ExpressionUUID->"a74b79dd-bccc-480e-8d3a-da93e3307492"]
}, Closed]],

Cell[CellGroupData[{

Cell["Generate Example Plots Jupiter", "Section",
 CellChangeTimes->{{3.884590566014189*^9, 3.884590576421175*^9}, {
  3.884602499355714*^9, 3.884602514105564*^9}, {3.892456512734013*^9, 
  3.892456514563643*^9}},ExpressionUUID->"1cd94e43-03c1-4c5c-a721-\
f6a3106b8055"],

Cell[BoxData[
 RowBox[{
  RowBox[{"RJup", "=", 
   RowBox[{"6.99", "*", 
    RowBox[{"10", "^", "9"}], " ", "cm"}]}], ";"}]], "Input",
 CellLabel->
  "In[623]:=",ExpressionUUID->"cfa2221c-9ffb-4898-aa5c-b211dfe3f30b"],

Cell[BoxData[
 RowBox[{
  RowBox[{"MJup", "=", 
   RowBox[{"1.89", "*", 
    RowBox[{"10", "^", "30"}], "g"}]}], ";"}]], "Input",
 CellLabel->
  "In[624]:=",ExpressionUUID->"573f02c1-fee7-43ac-8573-877daa4a195c"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"CompositionVector", "=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0.75", ",", "1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0.25", ",", "4"}], "}"}]}], "}"}]}], ";"}], " "}]], "Input",
 CellLabel->
  "In[625]:=",ExpressionUUID->"437488cf-abd4-4fb3-9d0c-a82cc3054a62"],

Cell[BoxData[
 RowBox[{
  RowBox[{"JupRaster", "=", 
   RowBox[{"Union", "[", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{"i", ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", 
         RowBox[{"-", "3.9"}], ",", 
         RowBox[{"-", "1"}], ",", "0.3"}], "}"}]}], "]"}], ",", 
     RowBox[{"Table", "[", 
      RowBox[{"i", ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", 
         RowBox[{"-", "1"}], ",", "5", ",", "0.1"}], "}"}]}], "]"}]}], 
    "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.889771901007822*^9, 3.889771988813361*^9}, {
  3.889772036272653*^9, 3.889772042182068*^9}, {3.889772092325987*^9, 
  3.889772094044684*^9}, {3.889789546731756*^9, 3.889789552463068*^9}, {
  3.88979714412254*^9, 3.889797145082426*^9}, {3.889803107633544*^9, 
  3.8898031080529947`*^9}, {3.892301544686962*^9, 3.892301547835392*^9}, {
  3.892355119062681*^9, 3.89235513209566*^9}, {3.895399616132868*^9, 
  3.895399617219062*^9}},
 CellLabel->
  "In[626]:=",ExpressionUUID->"625481dd-00e2-4efd-ba7d-ad9d5b26b20f"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"DataPlotDMJup", "[", "l\[Sigma]_", "]"}], ":=", 
   RowBox[{
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"10", "^", "lmDM"}], ",", 
        RowBox[{"DMCapture", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"10", "^", "lmDM"}], ",", 
            RowBox[{"10", "^", "l\[Sigma]"}], ",", 
            RowBox[{"vDMlocal", " ", 
             RowBox[{"s", "/", "km"}]}], ",", 
            RowBox[{"MJup", "/", "g"}], ",", 
            RowBox[{"RJup", "/", "cm"}], ",", 
            RowBox[{"nDMlocal", " ", 
             RowBox[{
              RowBox[{"cm", "^", "3"}], "/", "GeV"}]}]}], "}"}], ",", 
          "\"\<Total\>\"", ",", 
          RowBox[{"CompositionVector", "[", 
           RowBox[{"[", 
            RowBox[{"All", ",", "1"}], "]"}], "]"}], ",", 
          RowBox[{"CompositionVector", "[", 
           RowBox[{"[", 
            RowBox[{"All", ",", "2"}], "]"}], "]"}]}], "]"}]}], "  ", "}"}], 
      ",", 
      RowBox[{"{", 
       RowBox[{"lmDM", ",", "JupRaster"}], "}"}]}], "]"}], "//", "Quiet"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.884593298165538*^9, 3.884593365640114*^9}, {
   3.884593551520721*^9, 3.884593551567355*^9}, {3.884596050658052*^9, 
   3.884596051318948*^9}, {3.884602520677404*^9, 3.884602543441139*^9}, {
   3.884602900919114*^9, 3.884602918293921*^9}, {3.885228324742679*^9, 
   3.885228371181819*^9}, {3.885228637229282*^9, 3.8852286373972597`*^9}, {
   3.886420483963056*^9, 3.886420535443213*^9}, {3.888497371409891*^9, 
   3.888497372819743*^9}, {3.888501745172906*^9, 3.8885017664826307`*^9}, {
   3.888501798700272*^9, 3.8885017987802687`*^9}, {3.8896802503749723`*^9, 
   3.889680260622519*^9}, {3.889680293440497*^9, 3.889680293983395*^9}, {
   3.889771839331341*^9, 3.8897718395251417`*^9}, 3.889771993298607*^9, 
   3.89246050354283*^9, {3.89652016962175*^9, 3.896520169807149*^9}, 
   3.901257782517295*^9},
 CellLabel->
  "In[627]:=",ExpressionUUID->"e9bcfa05-481e-4341-bc10-0f99147e4542"],

Cell[BoxData[
 RowBox[{"Clear", "[", "DataPlotDMCalcFitJup", "]"}]], "Input",
 CellChangeTimes->{{3.884594841586844*^9, 3.884594845911023*^9}, 
   3.884596353043357*^9, 3.884602550760064*^9},
 CellLabel->
  "In[628]:=",ExpressionUUID->"7422c9ac-4b06-4ee4-bb33-abd9e3a6db3c"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"DataPlotDMCalcFitJup", "[", "l\[Sigma]_", "]"}], ":=", 
   RowBox[{"Interpolation", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"DataPlotDMJup", "[", "l\[Sigma]", "]"}], "/.", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"x_", ",", "y_"}], "}"}], ":>", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Log10", "[", "x", "]"}], ",", 
          RowBox[{"Log10", "[", " ", "y", "]"}]}], "}"}]}], "}"}]}], ",", 
     RowBox[{"InterpolationOrder", "->", "1"}]}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.884594849027102*^9, 3.884594850447727*^9}, {
  3.884596057673152*^9, 3.884596059296566*^9}, {3.884602554598899*^9, 
  3.8846025583765993`*^9}},
 CellLabel->
  "In[629]:=",ExpressionUUID->"b0900fbe-81a3-4483-8785-f2d6d85dae0c"],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Sigma]ElTabJup", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"10", "^", "l\[Sigma]"}], ",", 
     RowBox[{"{", 
      RowBox[{"l\[Sigma]", ",", 
       RowBox[{"-", "37."}], ",", 
       RowBox[{"-", "31."}], ",", "1"}], "}"}]}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.884594344159565*^9, 3.884594380587932*^9}, {
   3.8845955259782343`*^9, 3.8845955261498013`*^9}, 3.884596062949692*^9, 
   3.8846025641197157`*^9, {3.884801637299452*^9, 3.884801637386883*^9}, {
   3.8848037535369873`*^9, 3.884803753929702*^9}, {3.8884977276526537`*^9, 
   3.888497729807784*^9}, {3.892298448023553*^9, 3.892298448315802*^9}, {
   3.8922984785309477`*^9, 3.892298479757082*^9}, {3.892299027637916*^9, 
   3.892299028434293*^9}, {3.8923013908624983`*^9, 3.892301435837978*^9}, {
   3.8923014740474157`*^9, 3.892301522320414*^9}, {3.892301568034584*^9, 
   3.8923015709603157`*^9}, {3.892304260054562*^9, 3.8923042723662577`*^9}},
 CellLabel->
  "In[630]:=",ExpressionUUID->"cbd9525f-42d0-482b-936e-d4a71c9c60b5"],

Cell[BoxData[
 RowBox[{"Clear", "[", "DataDMFitCalcJup", "]"}]], "Input",
 CellChangeTimes->{{3.884595630588786*^9, 3.8845956316248293`*^9}, 
   3.884596067668391*^9, 3.8846025693371696`*^9},
 CellLabel->
  "In[631]:=",ExpressionUUID->"bc56470c-b045-4dc6-b552-76c7081745fc"],

Cell[BoxData[
 RowBox[{
  RowBox[{"DataDMFitCalcJup", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"DataPlotDMCalcFitJup", "[", 
      RowBox[{"Log10", "[", 
       RowBox[{"\[Sigma]ElTabJup", "[", 
        RowBox[{"[", "i", "]"}], "]"}], "]"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "1", ",", 
       RowBox[{"Length", "[", "\[Sigma]ElTabJup", "]"}]}], "}"}]}], "]"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.8845956897309847`*^9, 3.8845957204665403`*^9}, {
  3.8845960696719627`*^9, 3.884596074835845*^9}, {3.884602573546475*^9, 
  3.884602589486902*^9}, {3.888498918995462*^9, 3.8884989286561537`*^9}},
 CellLabel->
  "In[632]:=",ExpressionUUID->"0207189e-184d-4194-b65d-f194485c1104"],

Cell[BoxData[
 RowBox[{
  RowBox[{"PlotsDataDMJup", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Plot", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"DataDMFitCalcJup", "[", 
         RowBox[{"[", "i", "]"}], "]"}], "[", "lmDM", "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"lmDM", ",", 
         RowBox[{"-", "3.8"}], ",", "10"}], "}"}], ",", 
       RowBox[{"Axes", "->", "False"}], ",", 
       RowBox[{"PlotRange", "->", "All"}], ",", 
       RowBox[{"PlotStyle", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Thickness", "[", "0.007", "]"}], ",", 
          RowBox[{"Color7Lines", "[", 
           RowBox[{"[", "i", "]"}], "]"}]}], "}"}]}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "1", ",", 
       RowBox[{"Length", "[", "\[Sigma]ElTabJup", "]"}]}], "}"}]}], "]"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.8845957523891706`*^9, 3.884595953124914*^9}, {
   3.8845960803539047`*^9, 3.884596084158746*^9}, {3.884602594862957*^9, 
   3.88460260526711*^9}, {3.8864206237418613`*^9, 3.886420629314684*^9}, {
   3.888497376963414*^9, 3.8884973775493793`*^9}, 3.888498936644864*^9, 
   3.8884989728971653`*^9, {3.892301529881279*^9, 3.8923015301873817`*^9}, {
   3.895399628059278*^9, 3.8953996370646687`*^9}},
 CellLabel->
  "In[633]:=",ExpressionUUID->"396cffb8-8983-47dc-bc98-0d42b3ed0889"],

Cell[BoxData[
 RowBox[{
  RowBox[{"CJupGeoFit", "=", 
   RowBox[{"Interpolation", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"lmDM", ",", 
          RowBox[{"Log10", "[", " ", 
           RowBox[{"DMCapture", "[", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"(*", "GeV", "*)"}], " ", 
              RowBox[{
               RowBox[{"10", "^", "lmDM"}], ",", "\[Sigma]", ",", 
               RowBox[{"vDMlocal", " ", 
                RowBox[{"s", "/", "km"}]}], ",", 
               RowBox[{"MJup", "/", "g"}], ",", 
               RowBox[{"RJup", "/", "cm"}], ",", " ", 
               RowBox[{"nDMlocal", " ", 
                RowBox[{
                 RowBox[{"cm", "^", "3"}], "/", "GeV"}]}]}], "}"}], ",", 
             "\"\<Geometric\>\"", ",", 
             RowBox[{"{", "1", "}"}], ",", 
             RowBox[{"{", "1", "}"}]}], "]"}], "  ", "]"}]}], 
         "\[IndentingNewLine]", "  ", "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"lmDM", ",", 
          RowBox[{"-", "5"}], ",", "8", ",", "0.2"}], "}"}]}], "]"}], "//", 
      "Quiet"}], ",", 
     RowBox[{"InterpolationOrder", "->", "1"}]}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.884596620370172*^9, 3.884596724472307*^9}, {
   3.884602619050453*^9, 3.8846026337936287`*^9}, {3.8852286822000513`*^9, 
   3.885228686658411*^9}, {3.885399192784916*^9, 3.885399229373623*^9}, {
   3.888497402862239*^9, 3.888497403690946*^9}, 3.892460507378512*^9, {
   3.896520174828857*^9, 3.896520175294626*^9}},
 CellLabel->
  "In[634]:=",ExpressionUUID->"d624b9dc-eee8-4750-b3a9-ceb06786b2ea"],

Cell[BoxData[
 RowBox[{
  RowBox[{"CJupGeoPlot", "=", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"CJupGeoFit", "[", "lmDM", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"lmDM", ",", 
       RowBox[{"-", "5"}], ",", "10"}], "}"}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Thickness", "[", "0.007", "]"}], ",", "Dashed", ",", 
        "Black"}], "}"}]}], ",", 
     RowBox[{"Axes", "->", "False"}]}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.884596725856454*^9, 3.8845968062009172`*^9}, {
   3.884602638804257*^9, 3.8846026431791687`*^9}, 3.885228689439405*^9, 
   3.885228760271021*^9, {3.888497407117989*^9, 3.888497407670579*^9}, {
   3.892301787864642*^9, 3.8923017947252483`*^9}, {3.892304282696822*^9, 
   3.892304294883128*^9}},
 CellLabel->
  "In[635]:=",ExpressionUUID->"14b447fa-9e66-44e2-b357-8d5cf93ce3b6"],

Cell[BoxData[
 RowBox[{
  RowBox[{"PlotSettingRatesJup", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"PlotRange", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "4"}], ",", "5"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"17", ",", "32"}], "}"}]}], "}"}]}], ",", 
     RowBox[{"Frame", "->", "True"}], ",", 
     RowBox[{"LabelStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"FontFamily", "\[Rule]", "\"\<Times\>\""}], "}"}]}], ",", 
     RowBox[{"BaseStyle", "->", "17"}], ",", 
     RowBox[{"FrameStyle", "\[Rule]", 
      RowBox[{"Thickness", "[", "0.0045", "]"}]}], ",", 
     RowBox[{"ImageSize", "\[Rule]", "400"}], ",", 
     RowBox[{"AspectRatio", "\[Rule]", "0.92"}]}], "}"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.8661770639165983`*^9, 3.866177070226347*^9}, {
   3.866190510994719*^9, 3.866190511192675*^9}, {3.866194039914996*^9, 
   3.86619404009339*^9}, {3.866195097189847*^9, 3.866195116010172*^9}, {
   3.866196297021264*^9, 3.866196297746401*^9}, {3.866201784126067*^9, 
   3.866201789630039*^9}, {3.8662018318352947`*^9, 3.8662018360128803`*^9}, 
   3.866202076168412*^9, {3.866202308159042*^9, 3.866202315524818*^9}, {
   3.8662569757529783`*^9, 3.866257000350449*^9}, {3.866260793096089*^9, 
   3.866260793649808*^9}, {3.866270509602785*^9, 3.866270510021145*^9}, {
   3.8670611254818907`*^9, 3.8670611256792393`*^9}, {3.884595980014073*^9, 
   3.884596019624016*^9}, {3.884596362453342*^9, 3.884596362619647*^9}, 
   3.8846026491170073`*^9, {3.8846027107896976`*^9, 3.884602719606842*^9}, {
   3.8884974105898*^9, 3.888497439720592*^9}, {3.888497715704742*^9, 
   3.888497716280102*^9}, {3.8884989935784187`*^9, 3.8884990198870783`*^9}, {
   3.890042593448948*^9, 3.890042593693911*^9}, {3.8923014604430227`*^9, 
   3.892301460799779*^9}, {3.892301593171534*^9, 3.8923015935955973`*^9}, {
   3.892301809745573*^9, 3.892301854632443*^9}, {3.892301921965295*^9, 
   3.8923019286250896`*^9}, {3.892302131265711*^9, 3.892302131907918*^9}, {
   3.892304297078884*^9, 3.892304297859626*^9}, 3.892355142441197*^9, {
   3.8953996322273912`*^9, 3.895399632462481*^9}},
 CellLabel->
  "In[636]:=",ExpressionUUID->"edc8607a-5ee5-4c3a-931c-bb88eae2dcd3"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PlotJupiter", "=", 
  RowBox[{"Show", "[", 
   RowBox[{
   "CJupGeoPlot", ",", "PlotsDataDMJup", ",", "PlotSettingRatesJup", ",", 
    RowBox[{"FrameLabel", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
      "\"\<\!\(\*SubscriptBox[\(m\), \(\[Chi]\)]\) [GeV]\>\"", ",", 
       "\"\<\!\(\*SubscriptBox[\(C\), \(\[Psi]\)]\) [\!\(\*SuperscriptBox[\(s\
\), \(-1\)]\)]\>\""}], "}"}]}], ",", 
    RowBox[{"PlotLabel", "\[Rule]", "\"\<Jupiter\>\""}], ",", 
    RowBox[{"Epilog", "->", 
     RowBox[{"{", "\[IndentingNewLine]", " ", 
      RowBox[{
       RowBox[{"Text", "[", 
        RowBox[{
         RowBox[{"Style", "[", 
          RowBox[{
          "\"\<\!\(\*SubscriptBox[\(\[Sigma]\), \(\[Chi]N\)]\) = \
\!\(\*SuperscriptBox[\(10\), \(-37\)]\) \!\(\*SuperscriptBox[\(cm\), \(2\)]\)\
\>\"", ",", 
           RowBox[{"FontFamily", "\[Rule]", "\"\<Times\>\""}], ",", 
           RowBox[{"FontColor", "\[Rule]", 
            RowBox[{"Color7Lines", "[", 
             RowBox[{"[", "1", "]"}], "]"}]}]}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"Log10", "[", 
            RowBox[{"3", " ", 
             RowBox[{"10", "^", 
              RowBox[{"-", "3"}]}]}], "]"}], ",", 
           RowBox[{"Log10", "[", 
            RowBox[{"10", "^", "21.4"}], "]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", "0"}], "}"}]}], "]"}], ",", "\[IndentingNewLine]",
        " ", 
       RowBox[{"Text", "[", 
        RowBox[{
         RowBox[{"Style", "[", 
          RowBox[{
          "\"\<\!\(\*SuperscriptBox[\(10\), \(-36\)]\) \
\!\(\*SuperscriptBox[\(cm\), \(2\)]\)\>\"", ",", 
           RowBox[{"FontFamily", "\[Rule]", "\"\<Times\>\""}], ",", 
           RowBox[{"FontColor", "\[Rule]", 
            RowBox[{"Color7Lines", "[", 
             RowBox[{"[", "2", "]"}], "]"}]}]}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"Log10", "[", 
            RowBox[{"10", "^", 
             RowBox[{"-", "3"}]}], "]"}], ",", 
           RowBox[{"Log10", "[", 
            RowBox[{"10", "^", "22.5"}], "]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", "0"}], "}"}]}], "]"}], ",", "\[IndentingNewLine]", 
       RowBox[{"Text", "[", 
        RowBox[{
         RowBox[{"Style", "[", 
          RowBox[{
          "\"\<\!\(\*SuperscriptBox[\(10\), \(-35\)]\) \
\!\(\*SuperscriptBox[\(cm\), \(2\)]\)\>\"", ",", 
           RowBox[{"FontFamily", "\[Rule]", "\"\<Times\>\""}], ",", 
           RowBox[{"FontColor", "\[Rule]", 
            RowBox[{"Color7Lines", "[", 
             RowBox[{"[", "3", "]"}], "]"}]}]}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"Log10", "[", 
            RowBox[{"10", "^", 
             RowBox[{"-", "3"}]}], "]"}], ",", 
           RowBox[{"Log10", "[", 
            RowBox[{"10", "^", "23.5"}], "]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", "0"}], "}"}]}], "]"}], ",", 
       RowBox[{"Text", "[", 
        RowBox[{
         RowBox[{"Style", "[", 
          RowBox[{
          "\"\<\!\(\*SuperscriptBox[\(10\), \(-34\)]\) \
\!\(\*SuperscriptBox[\(cm\), \(2\)]\)\>\"", ",", 
           RowBox[{"FontFamily", "\[Rule]", "\"\<Times\>\""}], ",", 
           RowBox[{"FontColor", "\[Rule]", 
            RowBox[{"Color7Lines", "[", 
             RowBox[{"[", "4", "]"}], "]"}]}]}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"Log10", "[", 
            RowBox[{"10", "^", 
             RowBox[{"-", "3"}]}], "]"}], ",", 
           RowBox[{"Log10", "[", 
            RowBox[{"10", "^", "24.5"}], "]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", "0"}], "}"}]}], "]"}], ",", " ", 
       "\[IndentingNewLine]", 
       RowBox[{"Text", "[", 
        RowBox[{
         RowBox[{"Style", "[", 
          RowBox[{
          "\"\<\!\(\*SuperscriptBox[\(10\), \(-33\)]\) \
\!\(\*SuperscriptBox[\(cm\), \(2\)]\)\>\"", ",", 
           RowBox[{"FontFamily", "\[Rule]", "\"\<Times\>\""}], ",", 
           RowBox[{"FontColor", "\[Rule]", 
            RowBox[{"Color7Lines", "[", 
             RowBox[{"[", "5", "]"}], "]"}]}]}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"Log10", "[", 
            RowBox[{"10", "^", 
             RowBox[{"-", "3"}]}], "]"}], ",", 
           RowBox[{"Log10", "[", 
            RowBox[{"10", "^", "25.4"}], "]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", "0"}], "}"}]}], "]"}], ",", " ", 
       "\[IndentingNewLine]", 
       RowBox[{"Text", "[", 
        RowBox[{
         RowBox[{"Style", "[", 
          RowBox[{
          "\"\<\!\(\*SuperscriptBox[\(10\), \(-32\)]\) \
\!\(\*SuperscriptBox[\(cm\), \(2\)]\)\>\"", ",", 
           RowBox[{"FontFamily", "\[Rule]", "\"\<Times\>\""}], ",", 
           RowBox[{"FontColor", "\[Rule]", 
            RowBox[{"Color7Lines", "[", 
             RowBox[{"[", "6", "]"}], "]"}]}]}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"Log10", "[", 
            RowBox[{"0.9", " ", 
             RowBox[{"10", "^", 
              RowBox[{"-", "3"}]}]}], "]"}], ",", 
           RowBox[{"Log10", "[", 
            RowBox[{"10", "^", "26.3"}], "]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", "0"}], "}"}]}], "]"}], ",", " ", 
       "\[IndentingNewLine]", 
       RowBox[{"Text", "[", 
        RowBox[{
         RowBox[{"Style", "[", 
          RowBox[{
          "\"\<\!\(\*SuperscriptBox[\(10\), \(-31\)]\) \
\!\(\*SuperscriptBox[\(cm\), \(2\)]\)\>\"", ",", 
           RowBox[{"FontFamily", "\[Rule]", "\"\<Times\>\""}], ",", 
           RowBox[{"FontColor", "\[Rule]", 
            RowBox[{"Color7Lines", "[", 
             RowBox[{"[", "7", "]"}], "]"}]}]}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"Log10", "[", 
            RowBox[{"1.5", " ", 
             RowBox[{"10", "^", 
              RowBox[{"-", "3"}]}]}], "]"}], ",", 
           RowBox[{"Log10", "[", 
            RowBox[{"6.2", " ", 
             RowBox[{"10", "^", "28"}]}], "]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", "0"}], "}"}]}], "]"}], ",", "\[IndentingNewLine]", 
       RowBox[{"Text", "[", 
        RowBox[{
         RowBox[{"Style", "[", 
          RowBox[{"\"\<Geometric Capture Rate\>\"", ",", 
           RowBox[{"FontFamily", "\[Rule]", "\"\<Times\>\""}], ",", 
           RowBox[{"FontColor", "\[Rule]", "Black"}]}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"Log10", "[", "4", "]"}], ",", 
           RowBox[{"Log10", "[", 
            RowBox[{"0.3", " ", 
             RowBox[{"10", "^", "28"}]}], "]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", 
           RowBox[{"-", "0.56"}]}], "}"}]}], "]"}]}], "}"}]}]}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.884593950295188*^9, 3.8845940702342043`*^9}, {
   3.884594114066513*^9, 3.884594123379677*^9}, {3.884594544584634*^9, 
   3.88459456595557*^9}, {3.884595966802081*^9, 3.8845960039485188`*^9}, {
   3.884596812446742*^9, 3.884596869587677*^9}, {3.884596938231949*^9, 
   3.884597049770011*^9}, {3.8845970854454803`*^9, 3.88459723787391*^9}, {
   3.884597277637197*^9, 3.884597277808341*^9}, {3.88459749082962*^9, 
   3.884597631610702*^9}, {3.884602657560815*^9, 3.88460266913871*^9}, {
   3.884602815408682*^9, 3.88460281805984*^9}, {3.8846755345648193`*^9, 
   3.884675537343976*^9}, 3.8898462286092033`*^9, {3.889936203277707*^9, 
   3.889936591439355*^9}, {3.8899366240167503`*^9, 3.8899366405851717`*^9}, {
   3.889944078541925*^9, 3.889944093312914*^9}, {3.88994422021796*^9, 
   3.889944236749072*^9}, {3.889944351325687*^9, 3.889944359398217*^9}, {
   3.889944767474403*^9, 3.889944782934442*^9}, {3.895399656255417*^9, 
   3.8953997123901463`*^9}, {3.901257806325933*^9, 3.901257820603683*^9}},
 CellLabel->
  "In[641]:=",ExpressionUUID->"c06e1620-0cec-4a46-90f5-925a72af7653"],

Cell[BoxData[
 GraphicsBox[{{{{}, {}, 
     TagBox[
      {GrayLevel[0], Thickness[0.007], Opacity[1.], Dashing[{Small, Small}], 
       LineBox[CompressedData["
1:eJwVkWs0lAkAhiVp2EyKErl/qU0qn7mYMcz3Shcz5XRTIzG2kE0qW4yaZJXb
nNIFWyHbLtOJ1iWl7GaZ+Wo7rcqSW2uHOjbFUbOZ2kZDh1n74znPj+fn47b7
4JZYUxMTE/EU//tDyJcLP8UyablcFto3ncKY6KlnqpRJjx/dN6o1pXAgtaZE
EsqkRSiPqZhG4VVNLpMlZtKF5gMd0SYUWm1EH4Y5TJpTEH5DMyFE2fN7dyVW
TDqxSvR1s0EI8Td1waxGK/r1iyUa5Tshigsv7nljb0W3Bb1qCtcI4TcUURbW
/QWttIrMar4pxKW6IZecFAt6ZRxzG3OPEEd2pntPDJrTnqludhM2Qmj3OcoS
dpvR/MkuY/xvAUitrL+33MKUXrY2eGnQkQC4nGnC/vFJ9RmR05oHiwOQ5mZp
SfDH1Z1zb5Xe0Phjek5kwJNzerWXaGiRw3l/5ClbLpqe0Kk/+qUVL6f8Uemf
aPg1b0hd+qFrU+W/Aigw4exerVGrYs+MtZcKEE52d0nCG9TaNYPNKZsFMEau
smgRN1PGt5M9OeYCLIwzq8sX9FMZIUd7cccPwXL1es+fh6nhpDrnmL1+qDvn
1tI++Z6iJRtDve384JAXwXC0/ET9VH669thDPtazL/Puqz5TKU05IeQxPvys
o0oTEkxw++zrvnNL+WBJDrkubjVFt8f06rDnPBRxTsYPEjPA8Lyn/DGfh2O8
TLeoqpmoGu7PzQvkIXCWoiPLwhKsg3S9Vu+LDLM0XUzRLCyrndapU/rC57vE
v8ROs8GRDsxL2uqL3XIf6UiDNYiOzKJdDF8MN3pkXzCZixPTFLMN9Vy8HLKv
zPe2wf1R8UNDPBf50typ9baw21GjPOLKRfpQyujI9/PQKzt8uLSNg/6wmNvK
J/OREW7IYGdykNb3qKJu7gKUjL3ITvTh4Gywd7HDansUSrMezx9kI9Rk3vvM
gw645t3C9r/MRtjjQ2nrby+Ehyopz1LMRltqO2PvgCMUc56vCJpkITPw+qOX
y5wR7lquWlTFwshm40jUARdQJXOSs3ayEOdRaVEc4grGC0HCJmsW9J4F3Fs6
V6D3920PVD5ovPr5b73CDZFXbNLLDvlAupqAwNkdua3Gp8YlPnDZn3N3Be0O
r4YQW/M/SdhbJtwMkRCo2bezUHaaREXQcbluB4Gh1g6WxykS3ONngwoiCLj6
iNs6FSS26Gq7e3YRyDfwzMlsEqee6ceiEwjIsuYnvU0nMV727Sr5CQLCH9o3
fiUj0Sco6LxWSeCPjnUzxbtIxCdfLRHVEDDnqssMUSQMNXditbUEqCKusFxK
wta95xNZT+BmlEeyWQSJDQwnxyaawAWt6YBqO4mmrmsxnd0EIsxVKtaGqc78
ZbmsZ6rv5YS/FJPQrHs0uqCXQGtLlf68iMRow1uFtJ8ACi57vVtLYkWpd/Xw
GwKLXI8WVwSSaNQEynL/IRCZoeNIQEJsu5VaqSNwcTCufQZFYk9OcnuSngCj
ejsj2p/ERzq72M5AINC6VTlHQOLk+KXohnEC8sNrKJpPwpp93StygkDds0bN
AR6JK/sb9EYjAS2fLXPyJfEfhuEOkw==
        "]]},
      Annotation[#, "Charting`Private`Tag$279905#1"]& ]}, {}}, {{{}, {}, 
     TagBox[
      {RGBColor[0.254627, 0.013882, 0.615419], Thickness[0.007], Opacity[1.], 
       LineBox[CompressedData["
1:eJwV2Hk8lE8YAPB1L9a6SpR7KYnIsftzvkOFpEKuKFdSSVSkiFyFkCjRKdLp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        "]]},
      Annotation[#, "Charting`Private`Tag$279152#1"]& ]}, {}}, {{{}, {}, 
     TagBox[
      {RGBColor[0.477344, 0.00698, 0.659549], Thickness[0.007], Opacity[1.], 
       LineBox[CompressedData["
1:eJwV13c41V8YAHB7z4yQJDeVEULuRfqeUpHsTWWPUikziYz8klFRkkoiKllZ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        "]]},
      Annotation[#, "Charting`Private`Tag$279205#1"]& ]}, {}}, {{{}, {}, 
     TagBox[
      {RGBColor[0.674522, 0.147419, 0.578688], Thickness[0.007], Opacity[1.], 
       LineBox[CompressedData["
1:eJwV2Hc8Vl0cAHDZe8+S5CESkfU8j3VPyArZoUJCkjSUQmbDSFZpE5FkJYqI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        "]]},
      Annotation[#, "Charting`Private`Tag$279258#1"]& ]}, {}}, {{{}, {}, 
     TagBox[
      {RGBColor[0.819651, 0.306812, 0.448306], Thickness[0.007], Opacity[1.], 
       LineBox[CompressedData["
1:eJwV13c8Vl8YAHDba48iMpKXkigh3BfdY/wykuxQWUmSlEKR7KxkhdIkTSFS
KuKckIqSki2y994yfuf9h8/389577r3nPM9zzrPV5azFCSYGBgZN/If+3+VG
OnBz40VbVOzklwY1gGAb576SY7xozHKHLt0V0oGa/Na8qNhnyY5umVcOasV6
vMiqKD2G7r46qgLvVl4UQ7QO0u3Om7epqI0HzZBHni5ji9hsEeKq50HIaSek
++u9REGnah4UH/qvkW55xQs8nO95kFzFHbZ/2CMHNJgd0njQsf3tJ+j2iikf
ZzXnQZ9NjsmsYEv+VBm1N+RBKWcUtej+IfJ46CXJg1ziVy3pVnoW1Wu3iwet
/LgXTvdUlUlrLhcP2mPZ0U33Q96yJiZmHrR2IW+Zbgub3Q2Hl7lRTUqQ4Cr2
qz6BOsYhbuTWKKlLt4ti+Hebv9xIZWHcju4NvrPVL5q4EYMI9Ka78sOJLww/
uFGtRkIM3T4sTZ+sq7iRAhtvId0yJoYV2aXc6J/TjW66G268R+uvuVF1iYjg
GrYa9W7J8yxudMqb6k33oo5zwWoIN3rcrrF7Hfty8Mjdx5rcaEvh8RcMQxpA
ipo7Qypzo1s2gx10V1V5GbfKcSP+ZU9BRmx+3ukFXmFuxKTj50/3o7uLFpcm
uVBvbbQBE/a396wcBx5zoezh3B5mbO9jnx377nAharzyJhZsYcaYouBkLnRn
z1tjup0MuV1fB3Oh65dQAd2zjYJQwp4LnWWrD2bFFp/d4jvJy4X2Si+KsWN/
vNlVE8vKhXI/BR6i200zS1p2hRNtO8UYTnd+2LY6uyFOtCmfc5hufQHFnRUV
nGhZW+IdBXvo9XjosWJOdKErc4TueNv85oV8TjQasW0LB3bzA5VIhfuc6E/N
7ki6r+jNtVelcCKbs6/f0y09UKTifI0T1QoSY3R77qJ1pV7iRMhO14oTW+DX
P3Wls5xIY7Uqiu4i39L46hOc6Hn4/TK6j4gG97ke5UQx7d6yXNgMpUBr3YIT
eez9L47ux05MN9KNOJFxvMgM3cYslUMqgBPtHBix48ZOOWBw010Rv++t5O08
2B/crQ5qdnOgCUdFB376fB505PNt4UCXzZXK6GZR9viZV8eBKHoqkgLYB/8F
W0tDDiS1jeigu+P6i2McdzmQxai+wwb6+xQyeTVZc6A3l446CNPX9yaPksBB
DqTj4VhGt2GgyLSxPgf6fsRFchN20n+7/MqUOVD/PvcOuqWb7YIe83EgEVYf
B1Hs/1bz4y98paCApGsO4tjDXSVmuYiC2MPjy+iOr6oSHHhLQTd8kiQlsBsT
2tPsn1BQzuGbHXS7S1Me6IRT0B+JLIct2NzsG5wvB1CQB9+TMrrzRySob7wp
aJ7huaQU9tJrladyThTE15vXQXesgeNLPm0KAtnFDtLYuxQ8vI1UKej7ndIy
un/x+6qE76Qgu+tIkortNxc890GagvqCKoLoFmuNfTsvSkHnz1V10I3KUv2V
BChozfnrPhls16wMTQ8KBcVafrtPNyX6xWrWOjtSvVnMJIud41kE/8yzoy1/
TpfTbWb+MXTTODvipEqEbaPH+95veuZ97GjevVZnO7b2etfnynp29G1W6aMc
dm0ST92LfHbkzz0Pd2J7Id6HAs/Y0cyr3ssK2LwTfD4XH7CjM3b16orYpiaC
Inrx7MjlSf7LXfT72TY5tZ5mR8bg9IM9dF+WmqRsZ0fiPn+D1Ok+ocLvdo8N
lbVVa+vRx09R7a5JYUNE2Pslunkr9r7eE8eGCuWevdGnjy+lYbsawIae+l5V
3E+/v1UrI8WWDSXyAQkjug/tV6rYwIac9d6smNLHCzJg2sHFhtqGst4doo+X
a/g7nokNWScm+5jRx+M8cMl+ihUZ/zk7ao49rmFijAZZUWW4wzMLenycPCi+
7S8r2id/0NWSPn7lITRVy4qUL8q3W9HHnzFLPlzFinIlRG9Z08eXtnAtLWVF
2yvZrWyw88ws1ahvWFGmxzzfYfrzgq0oMTmsSEygr4bu8Vzr1vEsVpT6tj7K
lv68dpscqzusiM+hXM+OHi9ctkHFyawodt+VVHvsH4SdmVQsK5rhnOE+Sl//
yuzLNSGsSDdW89Ex7EXTlSd+F1lRIkeEpiM9H1wfrH5zZUWKFCEPF2yf+L5s
f5IVnWRV/+yOLdrjzVo/y4La1gNCfbGPx8UWX3VkQRWzTPPx9PGE2/uUbFiQ
gM+B64nYcZmKAu0mLMhp5oZMMr2+FNWdVKaxoNUpGctUevx1CQt1bmRB6hP7
8+9g5+7NOqtRzYyyh2I9nmHrotnbPYgZLbnXM2bT8814f1X8W2ZkMCiW/oKe
/05D4n2PmFFvf87nPGyL2N3VScHMSLK3VuYNdv/G0DktP2Z05vimD0XYlx/8
khr0ZEYl3Y6W7+j14rXvxX32zMi2azK0BJsgPz8cMmNGT50I0VL6+n0VqU0x
YEZznaH5ZdguVh5L5D5mpO9YbYCwFzpKZEZUmVFyh2DnR3r+ZtuU7FVgRucP
nYyrxJb0mzIPoTKjSPGqiM/Y+3m2BwsJMqO8onDf79hpmskt5AQTWh1es2nB
VrvlHp/ynAndtZwTnaLPv7nQorYkE2qV6X4gNYznSyI/PlqICY1PgVtU7LuD
xrL13EyIET5I3IZdGRxi4f6PEe2wOxaqgL0hbyQnuZkR+V9vdtHAfsVZ7jyQ
zIg2zdfKmmHvbzy6uCeWEe2sUJS0xG7NXIgPDGVEZGKcsA02E6H4QeAcIzop
b8x+FNvi5C1hrYOMqMjh0+BJ7H5lldxIfUZUvVOmywM7YO273k9NRtSxGNZy
BvthKrO3mzwjYrsBqi9gT1V41SSyMyLrzyUvgunXj9iVSK0xIJbgip4w+vM2
/Pcif5YBvVKrEYvEjqUp3QEjDMh5/JdlDP17XMSu1XUxIP4nrdfi6N8fw3bZ
qZkBwWPdFQnYMgVTHpO1DOiM0PC/ZOyc5nb7kE8MiNH/8+tb2HsZvhjzf2BA
s2N+Ox5gl20vpGW8YkD9LtvuP6bPx6H78krPGVBLU4NgDvbh+z6cZmkMqOyj
6so7bH+trdUJ5xhQdOp07S/6+7pyF285yYACOB/qtdDf99rC85fHGJBnsPm7
Tuw7rd9jfhgzIPNT+Zmj2KWXAoz4ZBmQmLaXD9sIvt/jaZJE4Tp82TskSsPe
8P6Kt3bGOnxolx4PsGUoVubHrq/DlFpDZgPs/U8YBO6dXIf+756OWmLHdtsl
iouvQ724E/AMtuAR7gSxq2uwSaXLNRObmt3tpXl+DX59ltjyFFt16Z3pEcc1
+EECmOZh29w8wXuHWIOZ7A/US7Bv15dd3zy+Cj3ajnI20O838Y4TPbwK18Ka
X1JGNYDCbtW4JP1V2MzsysaHrSq4cI1DeRUWREwcFcLWbw68tsS9Cl0j2Til
sU1KyGveyytQmz3ZSQ7b+j7TtaGBFbgpWuLtLmyH0E+xzg0rcJLynGcvtptr
dGxL+QqkXT7Zsg/by+BArHn+Coybj8k4gH1Rnjf2670V2Omdc9IWO3ryRsz7
Syswwn1qzhs7O/BBdPquFVhrfVnwMfYrR5doAfEVuPXnvZYC7BJd2egYjhXo
Y4IyyrC/UV5E+ff+g6J6rLubscdTiiLtbv+Dx5USDnCNaQDl3O8Romz/4CJn
VoQ3Ni0xMSJpZhkaR346EIStd8EygqNrGd5jHBS8hm1FtIQvlSxD3UWFzEfY
fp96w1q8l2FcX1FpE3bxn38h6X+W4FZUPa89rgHKUVmIQM0SvKA5VmqMXZMV
GhLzbglWFfFdPYzdfoo9xP/GEjyda7XBG3ttTjDYzmgJvrndsfsRtg6v/BXR
N4vQ2HfanXMCn3cuBFvWZS3CxueaVsLYZs2/d0QlL0LnjghSGtvhYXDj7NlF
eMlgkzAN+wR7Q84Lh0XIEujEuB/b01M+3OXgIkzMfz5qjh2g1rC7Tn4RPhXV
qjiFHXpHni1KdBGqmF7N88WOZghp16YswrKw2vRQ7IQTDa9m5xfg1hCO1RvY
adXyMS/6FqCSoMF/Odj3doc4uvxegOBRxPVK7EcpDXtFKxbgIbXyhnbsVw4h
3ZEZC/CMvbYbz6QGeF/R8E47YQFeGQ3Ik8VGcjsTZq8swLigd/Pa2LXTDZou
RxZg9kOVKC/s4cidqdrCC3BgeMezH9jSLxsNZq/NQ+fLwsNJUxpgx0YFyRcB
8/Acj5VyNraSf+is86l5GPIgKaAce5+eQuaP/fPwfgU31wy2fVPocjbjPGzj
YlawmtYAyesKuc4X56D13YkzwjM4f83CBX+4zEKj0i9Tt2c1wLSn/x1+s1mo
fv/0/jfY3TFnZSy0Z6FsMO+dH9gVFUfUGjbNQkYdK32WOQ0Qoa5q3/ZtBr6v
7Ew7g+1jJd8jXjwDnz4OG4nCdvWW8nR4OgNTI2XBQ+z/XnAHdYXOQG/D00ON
2GpfmNipZ2eg4w7efVPY2/oWE1yPzsCDnAXJXPO4f2GaEHliNAM1RywHZLHZ
tvRlDqjNwB3f5jUB9rxmm/wOmRm4LzOn9DR2v+3PQg+BGbi17kbAHezPyaWf
xkam4YCiy+wydjRb2tBMxjQ8P7Q28H5BA3CO79/DwDUNo500fqgvaYBlTu1i
ncUpeDphS9xJ7OHtKnrhfVPQtIzN6CZ2jfMWazY0BTeKN5TPY8c1LFzi9p2C
D5q8i94s4/NQ6TMk0jkJ35i+uKeyguO95b6R/bdJeOtKsv1x7PH5lF933k/C
yzn+m25g/1AK7ZVMmYSA0zBpGhsdvHjGKXQSUondptKr+LztcWY+02sSsrkL
c1lgJz6yo8gaTcJvn3ojCrBDPh5KclObhHmzNTpd2Oc6/tv8jDoJk6iFa/xr
uD/5p5k1xD8JfSxulwDsh0qutjYrE7D8k2fMeewwDzOPlsYJqH+g4fRb7OOP
tAKPFkzAqjpt0xVsGRGhDBe3Cfi1jXdD5DqOF5ttjsf1JiBrWolzFXbnDXVJ
V6kJqGPmns/GQIDbfPZ3T7SOw+LKjwejsAXYH9xyNx2H2bk+0dGMBBjXzz98
auc47D+5tekL9rewj8IelHEoLV0ry8FEgOi1npTT5WPwdtr2ihjstTm5JC+1
MRgb3Loay0yAdhWa2dkNY7CKiDKpwX7vfYDv3OQoZJpVucPFQgCfsTPXvbNH
YYTumef3sS12BpucjxqFv94wfpzC3n0qkeuC6yiU2pHWrM9KgOHeVzE+kqPw
Ax9kH8FuqtcKC2AbgQrZLpXhFAK8FjDVudwzDAMkFtoasZMPOTIEomH4JfHa
zA4OApjWhAZdCRiGrhdfS9dhK3Dc0A46PAxfDRvSqJwE4DB4tBKkOgwZHP6Y
+2FXllcFhIwPwTv6bKHiXAR4yNBMhNYMwaG3t2+dxQ7eN7QY+mwIqu/cnV+O
fTRw+W3Y1SFYLrxPQoabALRirovhLkNwMshUMRE7v8DsQmTjIHyxJfEM4CVA
/ISzclThIGyNyriSg31a8cJUVOIg5JjMvy7CR4Btz1PPxhgPQjf0M3cS+15G
6+m4sgG41XnDeIYAAQI6RuSv3xmAZl+pa9yCBLAVXx26fmkABu9R5fXH3nhr
i3uC8gBsZ7TeZb6BALEJrq7JT/rhzYdpXoxCBLCZMz2uF9EPd6aedTiNTT1C
uMw690M5D0pSC/Ykojo/JvuhRarwcVdhAnzYxutkI9EPA5HM3gns8dK3Rzan
9EHZM8eubBbF6zfKafkwtBderKrl8ZYggKTFnLmlYy/MnGrv/Ic98rbTjEW7
F9aIjxREShIgIvy1qdtiD5S6wG5zdwsBzIbuH9zU2AON7wvJbZcigMShGJMv
hT3Q5yt1uQC7aLODsfzZHvh1C7j/eSsBwkIMjdpMeuCMsek5C2kCHOpXNoyT
74Fje24HDWKLm0gYaFN64Lomf8cDKgEGC9j3j/d1Q4H9kdqHZQiw2ahA59XR
bmjv5VCiup0A/Xl3wHFaN/S89HvzKHbhxkhyo0g3DAozDsiSI4DJX3ttv/ou
+DBNjRCUJ0DQRRaCZtwFh8t4304oEMD4z7j6yPYuuPolQvipIgE26bWo3WXt
gnz1y74Ou/D68+aprqG/UGWgX/X7bgIE+txSeXn/L/xv6mhKhBIBjFrDlJ0C
/8LD/37NaO4hQPfjw0rl6n/hZT74KluZAHlcursvCP2F8aJ7BV1UCDDfbXvU
sL8TahWv8iupEiAhT9E+O7MTPmzz+UbdSwC5ACZb7mOdkGN1JGqTGgGuPbM+
lGLcAR+GffHtJ/B6sa5oP5Jthw3XQ80jdAiQmG/JtqetDapZTlTG6RKg9siL
2tLENnhT5JhGqh7+vlf2jk3/WqFtlsaWJ//h/D/2artrQSt87/4kOW8/Aaoo
nJOTbq1w866NbG8NCMDy2vndFfFWeHkm1B8aEkDH8X0I568W2PZuYvSzEZ4/
TgGjm1EtsOXosmmfMY6vN+4CMtot8I2Y5AF9EwJocIs81H7WDM+kn9BjOkQA
pfd+FeeCmuCflFmVICsCeLnWXltVaYLvLUWU/lgTIIdvm1XsUCNMFdRS0DqM
v9+toTfLqhEeTAyXWbYjgNQGVbYm+QZYek1QyM+RAA5l12qP//0N043VBBqc
CHD3VE/aZOpv6Mthz6PqQgARlLydk/E3VIzKZJ12JQDfmSlD7aZf8O/5CMsJ
DxwPIkYC1XG/4J+Rdc63nji/KjJabHR/wRbXy+VBXgRg22zmcS73J/xpc34P
73lcH6vyrmWF18FymhOfoj8B2nSa725w+gazmLRqPKIIcOv596c5AhWwq118
s/EzAlD4BcY+RJZDnjt8b82yCXDJz0r5+7+PUMOOyepwDgHs9No+jPUhGN8w
cN01nwAqxT+zjvmUQs3aV4zB7wigtpWy6PzpNRQyvl146SuOf/+nzNaa12Cs
wkfwZBTn498/h+3iwmDB7RuiLeME+JMgZ1tSfAG2UNymuaZwfXz2L9eNyYv0
uKJ323SOAOtPLBT1JVNJg/mETxdXCeB/VctLdOwFyTQoJ17NQwNFPgW8EVaQ
rH+iysmlQAMZKXyK7QCRSRnqNyoUaaDfq8rCrwmRh27TxAN308B5qur9bJZy
8tt1sGtMmQZi4/j2bnCsJD/5mFj8IGigzq3KPneukgz3OtQWpUkDwjpXQgzi
PpE67hauQJuGzyjDNZffV5GlR2z9CgANDP7InBIy+0xetj6yfkqXBnZl227K
7/9M0g45REvr04BPBJ+28ZUv5KKhs0DbfzRQ7FDl0rvhK1mk63r7hgENMBBX
ooOyv5KXZldEtIxoYP8G1TwRnWpysaA264QxDcSNDde/aqom/c9m7Eo4QAO/
PmcumXjVkMsK59+/M6GBIaUriW++fCdXpd/3Opjj6xk3O1bs+0ky8xlovrCn
gZdec978sT/JiG8iVb+P4Pvb6iKONfwkWWOHzdaO0sCcYc7NbKlfZKTBh7bt
DjQgUhSVvXD6F8nGGu9m7kgDmtTjpfpvf5FR5Y5TAU404JC4ry6JqZ6khOwJ
fORMA6Groj0dB+vJyGPeTEkuNPDIY25uZ3o9mT77aD/vcRr43FRH8e+tJ3Ov
Ncdewx7WzxGr2v2b/CjN/YPiSgNKW47rOFX9JgfNLhxmPkEDH+rr4lJmGkj1
XB33RTca6AQ5D7r2NZIH9H1zfE/SAFNe1KtdsY2kY9uzyWlsw+h9zV+kmshI
Dn7/MXcaOD0nOiLk2UTeztAr9ThFA/Euc6sub5vIXPWLjIPYv7VyqKsHm8mG
Ex0x3R40sPA8Ss04vZkcWhGodTxNA5s3HTe62dtMrtz4T/APtnbEvqO9u1tI
/p3+NvaeNOA0JXp2z+UWUqY853YTdrjDXGhQVQu5w2H/bpYzNPCkpi6lRqCV
lF/+JrGMf/+ikfNU5FgrqZBmyT2JPfI4qvjEs1ZSUbl1uQ9bqSL/oMV0K3nW
N0ykHdvvb8vffVptZP47ebVf2AxiCuwidW2kKnnZuwx7Y2KdZfVCO6lpIj6Y
hm2Xu9RfpPOHvJJQyXod+361dEDWtT8k/OVJDcfeweqbEbilg9S1K3U4i+0l
fV/l1KkOMuLuicAT2K/Jz1XWhR1kVSfP7SPY+wJEx3YZdJJGbg4NBtgRN3VD
xJI6yWvP2Wa0sb++Pr2B0tZJfh/N41fFZj9lbBkg+Jf8ePpHwgKer+yFjrvn
1P+Szeajp6OxTSIv9Lsd/UtOqHMYimJPbKQoHQv9S7JJbpPJxvOvqrynwqjm
L6k67Nheg9enEX3iBpN/SZO6wHdHsf0P2duoCXWRx4vSU+jrW+YZPiTt2EUm
hdWb8GEbPW3gW5nuIsc2G5Ra4HgZ3ethN72pm2RhdE3vwfEUX7n2cFCrmxQb
CPH1wf7dtV2tIbKbNCosVkzD8ed37kNwzYtu0im9iWM7tui62dePdd3kxeDZ
vrc4Xj9c7xN8N9dNxp8QKDfEdhAPOJq3uYd8fGDX/RYc7wwveJ88InvIG6d4
8s2xs4isiduuPeTt5N+Dt3B+DNp8C4vK6yGze13st+P8OZ8k+dxJt5f8Eh2s
rX8Mr6dU4bTNyV6yrmC/3zWcj2/zDLQOxvWSTa08L3/hfF2pOfeDaOwlBxTu
SjnjfI5iq5gT9OgjWX++Yw46TAPyqYdJjoQ+kmc5WOuTDQ18o45Grxf2kUJU
A19ubEEdIfHR1T5Sxreh/7YVDdy9fFL3U1I/uf5uIvASrhe6bE0d2q/7yQfg
bUu6GQ0MJO6/XNTYT+77EqRWcogGlJ/Ivn4qNkBeaeKZXD2I47muRzb28QC5
PLfzeDiuT7OyThyH3g+Sc8ruRvF6eL3rbOua/w6TqyL/SAVVGpi2/+JpzjxC
Utb6WLep0MDNPnWOatkRckNPXc0WXH+7l4V1SzxGyB25Tw5vUKKBS7INhfdm
R0grHYuzyztxPQkwv+lCGSNfn3kaEkvF8yFj7DC6e4KU4b/YN8BPAz/IS6mH
rCdwPA2GPuLD9dn+ybdXARPk0E47SWdeXB8SmTT9P02QeQaah1u5aKD6yh+u
cMVJcnTnwIUTbLi+D6UO8lVMknfjH9fMLxMgZF4h4mPDJDltf28+eokAQ8yV
Wy4MTpKG21O3ii3i84LktE0jzxQ5CyMuknh/crEy/XTXdoo0mTpOjZ7A5yXI
9nDH+BRZrXvksEwP3s+/39NuY5gmpz7rmod0ESC0VbUlbsM0KXpQ/kB7JwGs
5lz4JzWmyZOHl/altBNgWR4GFYVPk6yeN7exNBJgf9rFI3qiMySZWj/X84UA
nZ6DG4/pz5I+/iN6Jnh/Nl4cbflhPUse4w7UvoL379fhU/d1T86SBg+41fOe
4PPB7WU5udhZcvMnRXn+LALMya6P3b4zS7LYllF1MgngVMBcyJM7S44Nm0qc
f0CAGi3KpZCyWbLpSqdw1j28n3/h1p75MUtWZr8s/HiHAJmWAkxuXbPkx0Kr
xbh0AnB3Cn1unp4l4YclLdub+Pw4J2leJjRHvq/VqxpPxv0Gdc+JmCNzZN50
U7NYLAGW8vbKr3jOkS/+BUoM4POHK4024RU0Rz5nkXZ5dRX3L+Z6/laZc2SW
sOeIYSg+HwdZX98yMEfeojGs+V4igDmnvUXy4hyZpvdYV8cPr0eqwyZWznny
holxFLcP7r9yTmYOK8yT1x1S+LPOEmBfq/+bN+fnyYFTI6Zn3Qjw/ERQgFzE
PFlc02tZcBz3K1Nh5J1UfL1ih+0MPo8Ns8d9DXk3TypP1blcPEKAtL33/xxY
myeDLhX5BZvh/iOxnLU7ZoEUjgq9n0DD/ZEBlw1v5iJ5SDarlwn3d5JiZ93n
CxfJjGXRHEfcL2aM/wroqFokp34kXviA+9lHqbcf5I0ukjcCgpj8ljVAds+O
IVONJbLxh53U0IgGeBdsGJjwY4mUGVM9SHzXAL/fXn3Iv7ZMXm01dd0aqwG4
5RgmBI+skhsb1CJ3rKmDtJMXux6eWSXd9vr9mVhSB1JPx+uVQ1bJd6lvVIvm
1MHebX/eWTxeJY/YqPbojqkDB5nisOSJVTKzaQ842q4O8qV8hAUj1sjq9QYf
9hJ1YC06qC2Qu06eCWTqkg5UB4dY3aui1hlAhSTBCinqYKOrvZUShRGk1a5Z
PGJVB63lJt3N/IzAPagyI4ZJHbiF7FnbIc0IeDoOaVmtqIGgf8t7v+kzApt7
bheGJtRAztT1x/yxjGBILKVrQ5Ma4OwojEjfyASWLPodTz1TA1VF67ovdjCD
N6MfybhDakD4dMjpS2Gs4OU52FWZsRekdOZ/9ChkB+rHU5O3c+wFMg2mm+1a
OEDocMvWb/6q4Pr3BskpRW4Q/pr8d7hLBchEcpvn2fMCDeQRk2ClAqql0m5y
HuEHHWET9XUflAEXbGfXChcAL4IV0/+TUwbHtf/xhtwUBBdX7iWM3NsD5LR5
R0UqNoCDBNeWdfY9gEViybGydSN45lzGJBSoBE6Vbm4YGxUCj46ppTf37Qa0
TiUpT+FN4FvHwcldH3YB6S5JptWdImDOXuWW7xNFcNGVsbjbVhRMl/oxu/or
gJ7PJZQ2781gSiwa6jrtBM0jObbmV8VAXMWowSMTeUAkJQeJ54uDVfOXN3K3
7gAFwmaay1USwKuNVHrKKQdSJZhqFeYkwZsDuxIN27eB0PNz+eO8UuAW67kP
noWyQK/Ker9ZuhQIKg4mQu/LgBL7/P1Hd28FGjZj/trnqYDs9Ev2LtkKpkfl
uIbtpAF7ZXPHJ31pYPT9rbuowVYQOaSaVtkiDXxSHsVMiksB/vWVW99cqUA/
t2z+LI8k0Nl3wY04SQUZ0UM2JcyS4PyVIZUnp6hg+fjGt2zLEqD+X0NtsBcV
99EeF+/1S4C0xTwWlUtUIB8ttFgNJYD4tNO59GtUIHjcc0n2vASQ66s0cHtF
BR0im1faGsWBnYymUP1rKqDN6h/d/l0cxB4v6CbfUkHaj7MfzleIg5Gue1dE
P1CBReSnQA48T3kdfoXfPlFB1cy5VbUYcaDaLLdFpYUKcmo/ryVpioMTmx6M
PmijAkr2tMOfPeIgzUaomLuDClyvSkA5OXGw8JvRur+bCqS0LgTDjeKg+Gdr
bPooFaQ8l2QYGxMDw/zmtmwTVDAbYeSk0SsGxMw+y16YogIzJx8U3ioGAmsL
kck8FXBvqg7Z/FkM5PLIx79fpAL36dm/J0rFQIdJxpFt/6ig/PsWnYJCMcAb
J7zjxioVSD83zlx5LgbImrj59XUqCIrwZTTMEAP/A5buB0E=
        "]]},
      Annotation[#, "Charting`Private`Tag$279311#1"]& ]}, {}}, {{{}, {}, 
     TagBox[
      {RGBColor[0.928329, 0.472975, 0.326067], Thickness[0.007], Opacity[1.], 
       LineBox[CompressedData["
1:eJwV13k41F8XAPAxtrHvJdkykhCyju/EHIkQQkiESPKrXqVF0oJSypYkLcpS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        "]]},
      Annotation[#, "Charting`Private`Tag$279364#1"]& ]}, {}}, {{{}, {}, 
     TagBox[
      {RGBColor[0.989935, 0.663787, 0.204859], Thickness[0.007], Opacity[1.], 
       LineBox[CompressedData["
1:eJwV13k8lM8fAPB1L7vWkStXWEoiyrHsE/spUhQhcuVI6FZJOuQqkSMRUSkp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        "]]},
      Annotation[#, "Charting`Private`Tag$279417#1"]& ]}, {}}, {{{}, {}, 
     TagBox[
      {RGBColor[0.968443, 0.894564, 0.147014], Thickness[0.007], Opacity[1.], 
       LineBox[CompressedData["
1:eJwV1Hk4VO0bB3C7MWaGGbtSMhJCssww5zC3lGQnSmSfJJXS4tUi2kWLSlSI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        "]]},
      Annotation[#, "Charting`Private`Tag$279470#1"]& ]}, {}}},
  AspectRatio->0.92,
  Axes->{False, False},
  AxesLabel->{None, None},
  AxesOrigin->{0, 17.215293300390808`},
  BaseStyle->17,
  DisplayFunction->Identity,
  Epilog->{
    InsetBox[
     FormBox[
      StyleBox[
      "\"\\!\\(\\*SubscriptBox[\\(\[Sigma]\\), \\(\[Chi]N\\)]\\) = \
\\!\\(\\*SuperscriptBox[\\(10\\), \\(-37\\)]\\) \\!\\(\\*SuperscriptBox[\\(cm\
\\), \\(2\\)]\\)\"", FontFamily -> "Times", FontColor -> 
       RGBColor[0.254627, 0.013882, 0.615419], StripOnInput -> False], 
      TraditionalForm], 
     NCache[{-Log[10]^(-1) Log[
         Rational[1000, 3]], 21.4}, {-2.5228787452803374`, 21.4}], 
     NCache[
      ImageScaled[{
        Rational[1, 2], 
        Rational[1, 2]}], 
      ImageScaled[{0.5, 0.5}]], Automatic, {1, 0}], 
    InsetBox[
     FormBox[
      StyleBox[
      "\"\\!\\(\\*SuperscriptBox[\\(10\\), \\(-36\\)]\\) \
\\!\\(\\*SuperscriptBox[\\(cm\\), \\(2\\)]\\)\"", FontFamily -> "Times", 
       FontColor -> RGBColor[0.477344, 0.00698, 0.659549], StripOnInput -> 
       False], TraditionalForm], {-3, 22.5}, 
     NCache[
      ImageScaled[{
        Rational[1, 2], 
        Rational[1, 2]}], 
      ImageScaled[{0.5, 0.5}]], Automatic, {1, 0}], 
    InsetBox[
     FormBox[
      StyleBox[
      "\"\\!\\(\\*SuperscriptBox[\\(10\\), \\(-35\\)]\\) \
\\!\\(\\*SuperscriptBox[\\(cm\\), \\(2\\)]\\)\"", FontFamily -> "Times", 
       FontColor -> RGBColor[0.674522, 0.147419, 0.578688], StripOnInput -> 
       False], TraditionalForm], {-3, 23.5}, 
     NCache[
      ImageScaled[{
        Rational[1, 2], 
        Rational[1, 2]}], 
      ImageScaled[{0.5, 0.5}]], Automatic, {1, 0}], 
    InsetBox[
     FormBox[
      StyleBox[
      "\"\\!\\(\\*SuperscriptBox[\\(10\\), \\(-34\\)]\\) \
\\!\\(\\*SuperscriptBox[\\(cm\\), \\(2\\)]\\)\"", FontFamily -> "Times", 
       FontColor -> RGBColor[0.819651, 0.306812, 0.448306], StripOnInput -> 
       False], TraditionalForm], {-3, 24.5}, 
     NCache[
      ImageScaled[{
        Rational[1, 2], 
        Rational[1, 2]}], 
      ImageScaled[{0.5, 0.5}]], Automatic, {1, 0}], 
    InsetBox[
     FormBox[
      StyleBox[
      "\"\\!\\(\\*SuperscriptBox[\\(10\\), \\(-33\\)]\\) \
\\!\\(\\*SuperscriptBox[\\(cm\\), \\(2\\)]\\)\"", FontFamily -> "Times", 
       FontColor -> RGBColor[0.928329, 0.472975, 0.326067], StripOnInput -> 
       False], TraditionalForm], {-3, 25.4}, 
     NCache[
      ImageScaled[{
        Rational[1, 2], 
        Rational[1, 2]}], 
      ImageScaled[{0.5, 0.5}]], Automatic, {1, 0}], 
    InsetBox[
     FormBox[
      StyleBox[
      "\"\\!\\(\\*SuperscriptBox[\\(10\\), \\(-32\\)]\\) \
\\!\\(\\*SuperscriptBox[\\(cm\\), \\(2\\)]\\)\"", FontFamily -> "Times", 
       FontColor -> RGBColor[0.989935, 0.663787, 0.204859], StripOnInput -> 
       False], TraditionalForm], {-3.0457574905606752`, 26.3}, 
     NCache[
      ImageScaled[{
        Rational[1, 2], 
        Rational[1, 2]}], 
      ImageScaled[{0.5, 0.5}]], Automatic, {1, 0}], 
    InsetBox[
     FormBox[
      StyleBox[
      "\"\\!\\(\\*SuperscriptBox[\\(10\\), \\(-31\\)]\\) \
\\!\\(\\*SuperscriptBox[\\(cm\\), \\(2\\)]\\)\"", FontFamily -> "Times", 
       FontColor -> RGBColor[0.968443, 0.894564, 0.147014], StripOnInput -> 
       False], TraditionalForm], {-2.8239087409443187`, 28.792391689498253`}, 
     
     NCache[
      ImageScaled[{
        Rational[1, 2], 
        Rational[1, 2]}], 
      ImageScaled[{0.5, 0.5}]], Automatic, {1, 0}], 
    InsetBox[
     FormBox[
      StyleBox[
      "\"Geometric Capture Rate\"", FontFamily -> "Times", FontColor -> 
       GrayLevel[0], StripOnInput -> False], TraditionalForm], 
     NCache[{Log[4]/Log[10], 27.477121254719663`}, {0.6020599913279623, 
      27.477121254719663`}], 
     NCache[
      ImageScaled[{
        Rational[1, 2], 
        Rational[1, 2]}], 
      ImageScaled[{0.5, 0.5}]], Automatic, {1, -0.56}]},
  Frame->True,
  FrameLabel->{
    FormBox[
    "\"\\!\\(\\*SubscriptBox[\\(m\\), \\(\[Chi]\\)]\\) [GeV]\"", 
     TraditionalForm], 
    FormBox[
    "\"\\!\\(\\*SubscriptBox[\\(C\\), \\(\[Psi]\\)]\\) \
[\\!\\(\\*SuperscriptBox[\\(s\\), \\(-1\\)]\\)]\"", TraditionalForm]},
  FrameStyle->Thickness[0.0045],
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  ImageSize->400,
  LabelStyle->{FontFamily -> "Times"},
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotLabel->FormBox["\"Jupiter\"", TraditionalForm],
  PlotRange->{{-4, 5}, {17, 32}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{{3.884593976481764*^9, 3.884594034945293*^9}, {
   3.88459406508959*^9, 3.884594070694845*^9}, 3.8845941248288193`*^9, {
   3.8845945554259233`*^9, 3.884594566625681*^9}, 3.884594921590362*^9, 
   3.884595968017223*^9, {3.884596004542377*^9, 3.884596020951312*^9}, 
   3.884596093023551*^9, {3.8845963590642633`*^9, 3.8845963635603848`*^9}, 
   3.884596813677721*^9, 3.884596931555024*^9, {3.884597030742347*^9, 
   3.884597052552537*^9}, {3.8845971065796003`*^9, 3.884597238364102*^9}, 
   3.884597278251411*^9, {3.884597491502304*^9, 3.884597632152072*^9}, {
   3.884602701351323*^9, 3.884602721337822*^9}, 3.8846028187623053`*^9, 
   3.884602931600305*^9, 3.884603962850288*^9, 3.884675545100923*^9, 
   3.884796827533926*^9, 3.884801644120335*^9, 3.884803761018053*^9, 
   3.885228613488896*^9, 3.885228655301042*^9, 3.885228765075824*^9, 
   3.885399249554504*^9, 3.886416315688366*^9, 3.886418608211903*^9, 
   3.886420453343109*^9, {3.886420492469488*^9, 3.886420541777966*^9}, 
   3.8864206332273283`*^9, 3.888490542639282*^9, 3.8884905986378307`*^9, 
   3.8884907764017076`*^9, 3.888491011696473*^9, 3.88849709598726*^9, 
   3.888497363664168*^9, {3.888497412523786*^9, 3.88849744112333*^9}, 
   3.8884977185453176`*^9, 3.888498949740012*^9, {3.888498995430791*^9, 
   3.888499021910448*^9}, 3.8885017821775103`*^9, 3.888501813625696*^9, 
   3.8896801933676233`*^9, 3.88968028187309*^9, 3.8896803282226467`*^9, 
   3.88977182107658*^9, 3.889771861965269*^9, 3.8897720242195807`*^9, 
   3.889772066126771*^9, 3.8897721164949627`*^9, 3.889780274435823*^9, 
   3.889780888532689*^9, 3.889780938227304*^9, 3.889781072433156*^9, 
   3.8897811507429743`*^9, 3.889781189645495*^9, 3.889787377196439*^9, 
   3.8897884013736362`*^9, 3.8897888786884327`*^9, 3.8897892802545958`*^9, 
   3.889789463419833*^9, 3.88978957811381*^9, 3.889792927990512*^9, 
   3.8897937692936497`*^9, 3.8897966189333553`*^9, 3.8897966702436113`*^9, 
   3.8897970398439217`*^9, 3.8897971315326853`*^9, 3.88979717097546*^9, 
   3.8898030977614613`*^9, 3.8898031285290613`*^9, 3.8898035492878*^9, 
   3.889805941331843*^9, 3.889935861929686*^9, 3.889936182706809*^9, {
   3.889936251706143*^9, 3.8899362975179453`*^9}, {3.8899363287319813`*^9, 
   3.88993644165167*^9}, {3.889936476559804*^9, 3.889936592020989*^9}, {
   3.88993662748385*^9, 3.88993664104697*^9}, {3.889944079413512*^9, 
   3.889944093755537*^9}, {3.88994422442822*^9, 3.889944237406911*^9}, 
   3.889944361436606*^9, {3.889944771227059*^9, 3.889944783683782*^9}, 
   3.8900425948490057`*^9, 3.890291722232403*^9, 3.891933657060836*^9, 
   3.8919378776926527`*^9, 3.892032360064783*^9, 3.892032406173386*^9, 
   3.8920327642706013`*^9, 3.892033530917151*^9, 3.892209706716342*^9, {
   3.8922984442674227`*^9, 3.892298453858924*^9}, 3.892298486643936*^9, 
   3.892298936035659*^9, {3.8922990194732313`*^9, 3.892299033510212*^9}, 
   3.892299582301339*^9, 3.892299789938044*^9, {3.892301443954628*^9, 
   3.89230148086539*^9}, {3.89230155399642*^9, 3.892301594749696*^9}, {
   3.892301790069704*^9, 3.8923018556408443`*^9}, {3.892301923395673*^9, 
   3.892301930027295*^9}, 3.8923021330389347`*^9, {3.892304253003974*^9, 
   3.892304298665223*^9}, 3.892354157274949*^9, 3.892354851344318*^9, 
   3.892355146645981*^9, 3.892460514748151*^9, 3.893421305334017*^9, 
   3.895396918776875*^9, 3.8953979102107143`*^9, 3.895397949152142*^9, {
   3.895397980002543*^9, 3.895398005641477*^9}, 3.89539925184844*^9, 
   3.895399600311967*^9, {3.8953996336772957`*^9, 3.895399712615094*^9}, 
   3.8965201858051434`*^9, {3.901257795841103*^9, 3.901257820929811*^9}},
 CellLabel->
  "Out[641]=",ExpressionUUID->"5da3b881-fd44-4ab5-864d-184497ebea64"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Generate Example Plots Earth Multi-component model", "Section",
 CellChangeTimes->{{3.884590566014189*^9, 3.884590576421175*^9}, {
   3.884602499355714*^9, 3.884602500946186*^9}, {3.884614161854924*^9, 
   3.88461418792811*^9}, {3.884614379885*^9, 3.884614386118614*^9}, {
   3.885229398865143*^9, 3.885229399182651*^9}, {3.892291015731029*^9, 
   3.89229101786374*^9}, {3.89245651654352*^9, 3.8924565179218807`*^9}, 
   3.895400167007205*^9},ExpressionUUID->"013f83f2-7020-4886-b4fd-\
e4451065344b"],

Cell[BoxData[
 RowBox[{
  RowBox[{"REarth", "=", 
   RowBox[{"6.371", "*", 
    RowBox[{"10", "^", "8"}], "cm"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.8371831049335814`*^9, 3.8371831256102448`*^9}},
 CellLabel->"In[80]:=",ExpressionUUID->"0085fea6-4fc8-44da-96b4-ac209bf5a2ac"],

Cell[BoxData[
 RowBox[{
  RowBox[{"MEarth", "=", 
   RowBox[{"5.972", " ", 
    RowBox[{"10", "^", "27"}], " ", "g"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.87034055382477*^9, 3.8703405809252357`*^9}},
 CellLabel->"In[81]:=",ExpressionUUID->"b6225b76-5138-40aa-8f5c-b4960c34011a"],

Cell[BoxData[
 RowBox[{
  RowBox[{"fM", " ", "=", "0.67"}], ";"}]], "Input",
 CellChangeTimes->{{3.884804340562888*^9, 3.884804346311857*^9}},
 CellLabel->"In[82]:=",ExpressionUUID->"f0e4c55d-86cf-42bc-a51b-3fc73a9134cc"],

Cell[BoxData[
 RowBox[{
  RowBox[{"ElementVector", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"fM", "  ", "0.443"}], ",", "16"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"fM", " ", "0.213"}], ",", "28"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"fM", "  ", "0.023"}], ",", " ", "27"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"fM", "  ", "0.063"}], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"1", "-", "fM"}], " ", ")"}], "0.85"}]}], ",", "56"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"fM", "  ", "0.025"}], ",", "40"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"fM", " ", "0.223"}], ",", "24"}], "}"}]}], "}"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.884794605441958*^9, 3.8847946359932413`*^9}, {
   3.884797376182675*^9, 3.88479738416735*^9}, {3.884801919329245*^9, 
   3.884801920803722*^9}, {3.88480209876794*^9, 3.8848021026725607`*^9}, {
   3.884802373691269*^9, 3.884802455518512*^9}, 3.8848041373458853`*^9, {
   3.884804317225672*^9, 3.8848043646064777`*^9}, 3.885229118878942*^9},
 CellLabel->"In[83]:=",ExpressionUUID->"9603692f-13c5-4921-8731-bd7f206a029d"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"DataPlotDMEarth", "[", "l\[Sigma]_", "]"}], ":=", 
   RowBox[{
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"10", "^", "lmDM"}], ",", " ", 
        RowBox[{"DMCapture", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"10", "^", "lmDM"}], ",", 
            RowBox[{"10", "^", "l\[Sigma]"}], ",", 
            RowBox[{"vDMlocal", " ", 
             RowBox[{"s", "/", "km"}]}], ",", 
            RowBox[{"MEarth", "/", "g"}], ",", 
            RowBox[{"REarth", "/", "cm"}], ",", 
            RowBox[{"nDMlocal", " ", 
             RowBox[{
              RowBox[{"cm", "^", "3"}], "/", "GeV"}]}]}], "}"}], ",", 
          "\"\<Total\>\"", ",", 
          RowBox[{"ElementVector", "[", 
           RowBox[{"[", 
            RowBox[{"All", ",", "1"}], "]"}], "]"}], ",", 
          RowBox[{"ElementVector", "[", 
           RowBox[{"[", 
            RowBox[{"All", ",", "2"}], "]"}], "]"}]}], "]"}]}], "    ", "}"}],
       ",", 
      RowBox[{"{", 
       RowBox[{"lmDM", ",", 
        RowBox[{"-", "3.9"}], ",", "5", ",", "0.1"}], "}"}]}], "]"}], "//", 
    "Quiet"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.884593298165538*^9, 3.884593365640114*^9}, {
   3.884593551520721*^9, 3.884593551567355*^9}, {3.884596050658052*^9, 
   3.884596051318948*^9}, {3.88461431311911*^9, 3.884614314545579*^9}, {
   3.884614357123377*^9, 3.884614370473733*^9}, 3.8847948148683043`*^9, {
   3.884795194572839*^9, 3.884795207368718*^9}, {3.884802040027821*^9, 
   3.884802041649322*^9}, 3.884802485178708*^9, {3.885229043589985*^9, 
   3.8852290583964157`*^9}, {3.885229149412754*^9, 3.8852291570283537`*^9}, {
   3.886417963266872*^9, 3.886417963443657*^9}, {3.886420206808483*^9, 
   3.88642020696562*^9}, {3.888502183738508*^9, 3.8885021870778637`*^9}, {
   3.889762613790461*^9, 3.889762614047099*^9}, {3.8897628267878857`*^9, 
   3.8897628293339148`*^9}, {3.88976420651437*^9, 3.8897642076197968`*^9}, {
   3.8897936290058413`*^9, 3.889793629086197*^9}, {3.892305807102393*^9, 
   3.892305807415628*^9}, {3.89235506892914*^9, 3.8923550697508497`*^9}, 
   3.892460520215149*^9, {3.895399576210135*^9, 3.895399577400631*^9}, 
   3.896520191261574*^9, {3.8965202672846603`*^9, 3.896520267454381*^9}},
 CellLabel->"In[84]:=",ExpressionUUID->"1b14c060-b2de-47e1-80bf-b6fc9826d1d1"],

Cell[BoxData[
 RowBox[{"Clear", "[", "DataPlotDMCalcFitEarth", "]"}]], "Input",
 CellChangeTimes->{{3.884594841586844*^9, 3.884594845911023*^9}, 
   3.884596353043357*^9},
 CellLabel->"In[85]:=",ExpressionUUID->"08631e7b-1056-46fe-811f-6e2193f7696b"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"DataPlotDMCalcFitEarth", "[", "l\[Sigma]_", "]"}], ":=", 
   RowBox[{"Interpolation", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"DataPlotDMEarth", "[", "l\[Sigma]", "]"}], "/.", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"x_", ",", "y_"}], "}"}], ":>", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Log10", "[", "x", "]"}], ",", 
          RowBox[{"Log10", "[", " ", "y", "]"}]}], "}"}]}], "}"}]}], ",", 
     RowBox[{"InterpolationOrder", "->", "1"}]}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.884594849027102*^9, 3.884594850447727*^9}, {
  3.884596057673152*^9, 3.884596059296566*^9}},
 CellLabel->"In[86]:=",ExpressionUUID->"f33fc824-522b-47f6-bec4-50a836465381"],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Sigma]ElTabEarth", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"10", "^", "l\[Sigma]"}], ",", 
     RowBox[{"{", 
      RowBox[{"l\[Sigma]", ",", 
       RowBox[{"-", "43."}], ",", 
       RowBox[{"-", "31."}], ",", "2"}], "}"}]}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.884594344159565*^9, 3.884594380587932*^9}, {
   3.8845955259782343`*^9, 3.8845955261498013`*^9}, 3.884596062949692*^9, {
   3.8848015104904833`*^9, 3.8848015117796087`*^9}, {3.88480377971185*^9, 
   3.884803779898993*^9}, {3.88641823851071*^9, 3.8864182386409597`*^9}, {
   3.886418275608337*^9, 3.886418275778343*^9}, {3.886419083709365*^9, 
   3.88641908599855*^9}, {3.8922104290140944`*^9, 3.892210459928049*^9}, {
   3.892210681164587*^9, 3.892210683508437*^9}, {3.892210774728937*^9, 
   3.8922107761796513`*^9}, {3.892352319739601*^9, 3.892352319961195*^9}, {
   3.892352367983917*^9, 3.8923523743625803`*^9}, {3.892352738644375*^9, 
   3.892352768329267*^9}, {3.89235314050364*^9, 3.8923531442580757`*^9}, {
   3.892354092416071*^9, 3.892354115167055*^9}, {3.895399874071951*^9, 
   3.895399877739705*^9}},
 CellLabel->"In[87]:=",ExpressionUUID->"882165b5-b7e7-45de-b01a-cef3b63f75f6"],

Cell[BoxData[
 RowBox[{"Clear", "[", "DataDMFitCalcEarth", "]"}]], "Input",
 CellChangeTimes->{{3.884595630588786*^9, 3.8845956316248293`*^9}, 
   3.884596067668391*^9},
 CellLabel->"In[88]:=",ExpressionUUID->"46855c78-5aa3-48f1-93b2-f5171654b3a6"],

Cell[BoxData[
 RowBox[{
  RowBox[{"DataDMFitCalcEarth", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"DataPlotDMCalcFitEarth", "[", 
      RowBox[{"Log10", "[", 
       RowBox[{"\[Sigma]ElTabEarth", "[", 
        RowBox[{"[", "i", "]"}], "]"}], "]"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "1", ",", 
       RowBox[{"Length", "[", "\[Sigma]ElTabEarth", "]"}]}], "}"}]}], "]"}]}],
   ";"}]], "Input",
 CellChangeTimes->{{3.8845956897309847`*^9, 3.8845957204665403`*^9}, {
  3.8845960696719627`*^9, 3.884596074835845*^9}},
 CellLabel->"In[89]:=",ExpressionUUID->"b8c4342f-cf34-4e4d-b4fb-3b1cf458599c"],

Cell[BoxData[
 RowBox[{
  RowBox[{"PlotsDataDMEarth", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Plot", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"DataDMFitCalcEarth", "[", 
         RowBox[{"[", "i", "]"}], "]"}], "[", "lmDM", "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"lmDM", ",", 
         RowBox[{"-", "3.9"}], ",", "5"}], "}"}], ",", 
       RowBox[{"Axes", "->", "False"}], ",", 
       RowBox[{"PlotRange", "->", "All"}], ",", 
       RowBox[{"PlotStyle", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Thickness", "[", "0.007", "]"}], ",", 
          RowBox[{"Color7Lines", "[", 
           RowBox[{"[", "i", "]"}], "]"}]}], "}"}]}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "1", ",", 
       RowBox[{"Length", "[", "\[Sigma]ElTabEarth", "]"}]}], "}"}]}], "]"}]}],
   ";"}]], "Input",
 CellChangeTimes->{{3.8845957523891706`*^9, 3.884595953124914*^9}, {
   3.8845960803539047`*^9, 3.884596084158746*^9}, {3.8864184149785433`*^9, 
   3.88641841565254*^9}, {3.888502196801607*^9, 3.888502196898728*^9}, {
   3.8923058148940268`*^9, 3.8923058152532682`*^9}, {3.892355072881143*^9, 
   3.892355073116726*^9}, 3.895399894929248*^9, {3.896520345098721*^9, 
   3.896520363501526*^9}},
 CellLabel->
  "In[115]:=",ExpressionUUID->"d8b84ea4-89af-4153-9d74-970f809e7d4d"],

Cell[BoxData[
 RowBox[{
  RowBox[{"CEarthGeoFit", "=", 
   RowBox[{"Interpolation", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"lmDM", ",", 
          RowBox[{"Log10", "[", " ", 
           RowBox[{"DMCapture", "[", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"(*", "GeV", "*)"}], " ", 
              RowBox[{
               RowBox[{"10", "^", "lmDM"}], ",", "\[Sigma]", ",", 
               RowBox[{"vDMlocal", " ", 
                RowBox[{"s", "/", "km"}]}], ",", 
               RowBox[{"MEarth", "/", "g"}], ",", 
               RowBox[{"REarth", "/", "cm"}], ",", " ", 
               RowBox[{"nDMlocal", " ", 
                RowBox[{
                 RowBox[{"cm", "^", "3"}], "/", "GeV"}]}]}], "}"}], ",", 
             "\"\<Geometric\>\"", ",", 
             RowBox[{"ElementVector", "[", 
              RowBox[{"[", 
               RowBox[{"All", ",", "1"}], "]"}], "]"}], ",", 
             RowBox[{"ElementVector", "[", 
              RowBox[{"[", 
               RowBox[{"All", ",", "2"}], "]"}], "]"}]}], "]"}], "  ", 
           "]"}]}], " ", "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"lmDM", ",", 
          RowBox[{"-", "3.9"}], ",", "5", ",", "0.2"}], "}"}]}], "]"}], "//", 
      "Quiet"}], ",", 
     RowBox[{"InterpolationOrder", "->", "1"}]}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.884596620370172*^9, 3.884596724472307*^9}, {
   3.885397004411257*^9, 3.8853970560134287`*^9}, {3.888502204100737*^9, 
   3.888502204207857*^9}, 3.892460521807117*^9, {3.895399905187408*^9, 
   3.895399905987402*^9}, 3.89652019349973*^9},
 CellLabel->"In[91]:=",ExpressionUUID->"b1027fd0-cc76-4ce4-a83d-c4351945aba2"],

Cell[BoxData[
 RowBox[{
  RowBox[{"CEarthGeoPlot", "=", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"CEarthGeoFit", "[", "lmDM", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"lmDM", ",", 
       RowBox[{"-", "3.9"}], ",", "5"}], "}"}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Thickness", "[", "0.007", "]"}], ",", "Dashed", ",", 
        "Black"}], "}"}]}], ",", 
     RowBox[{"Axes", "->", "False"}]}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.884596725856454*^9, 3.8845968062009172`*^9}, {
  3.888502206865653*^9, 3.8885022070315533`*^9}, {3.889762702672847*^9, 
  3.889762704338128*^9}, {3.892305799447466*^9, 3.892305799858931*^9}, {
  3.892355080770253*^9, 3.8923550809990187`*^9}, {3.8953999013666897`*^9, 
  3.895399902812664*^9}, {3.89652036963667*^9, 3.89652037117479*^9}},
 CellLabel->
  "In[116]:=",ExpressionUUID->"cb7376b6-ba2a-40ca-8bde-e9c10381b667"],

Cell[BoxData[
 RowBox[{
  RowBox[{"PlotSettingRatesEarth", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"PlotRange", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "3.82"}], ",", "4.83"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"10", ",", "28"}], "}"}]}], "}"}]}], ",", 
     RowBox[{"Frame", "->", "True"}], ",", 
     RowBox[{"LabelStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"FontFamily", "\[Rule]", "\"\<Times\>\""}], "}"}]}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"BaseStyle", "->", "17"}], ",", 
     RowBox[{"FrameStyle", "\[Rule]", 
      RowBox[{"Thickness", "[", "0.0045", "]"}]}], ",", 
     RowBox[{"ImageSize", "\[Rule]", "400"}], ",", 
     RowBox[{"AspectRatio", "\[Rule]", "0.92"}]}], "}"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.8661770639165983`*^9, 3.866177070226347*^9}, {
   3.866190510994719*^9, 3.866190511192675*^9}, {3.866194039914996*^9, 
   3.86619404009339*^9}, {3.866195097189847*^9, 3.866195116010172*^9}, {
   3.866196297021264*^9, 3.866196297746401*^9}, {3.866201784126067*^9, 
   3.866201789630039*^9}, {3.8662018318352947`*^9, 3.8662018360128803`*^9}, 
   3.866202076168412*^9, {3.866202308159042*^9, 3.866202315524818*^9}, {
   3.8662569757529783`*^9, 3.866257000350449*^9}, {3.866260793096089*^9, 
   3.866260793649808*^9}, {3.866270509602785*^9, 3.866270510021145*^9}, {
   3.8670611254818907`*^9, 3.8670611256792393`*^9}, {3.884595980014073*^9, 
   3.884596019624016*^9}, {3.884596362453342*^9, 3.884596362619647*^9}, {
   3.884804612294482*^9, 3.884804618290362*^9}, {3.884804649146019*^9, 
   3.8848046501985807`*^9}, {3.8885022105599527`*^9, 3.888502210714711*^9}, {
   3.889787772975827*^9, 3.889787773087783*^9}, {3.889806206548649*^9, 
   3.889806207354032*^9}, {3.890042563475851*^9, 3.890042576461792*^9}, {
   3.892305791648151*^9, 3.892305792026988*^9}, {3.892306124112467*^9, 
   3.892306124882465*^9}, {3.892307402352488*^9, 3.892307423823248*^9}, {
   3.8923507239554243`*^9, 3.892350724269168*^9}, 3.892355041567721*^9, {
   3.892355084549069*^9, 3.892355084769093*^9}, 3.895397527289001*^9, 
   3.8953998568669786`*^9, 3.896520231270254*^9},
 CellLabel->
  "In[117]:=",ExpressionUUID->"933d7f29-fa6c-476b-b2bd-166470c7638b"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PlotEarthMantleModel", "=", 
  RowBox[{"Show", "[", 
   RowBox[{
   "CEarthGeoPlot", ",", "PlotsDataDMEarth", ",", "PlotSettingRatesEarth", 
    ",", 
    RowBox[{"FrameLabel", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"\"\<\!\(\*SubscriptBox[\(m\), \(\[Chi]\)]\) [GeV]\>\"", ",", 
       RowBox[{
        RowBox[{"ToString", "[", 
         RowBox[{
          RowBox[{"Subscript", "[", 
           RowBox[{"\"\<C\>\"", ",", " ", "\"\<\[CirclePlus]\>\""}], "]"}], 
          ",", 
          RowBox[{"FormatType", "->", "StandardForm"}]}], "]"}], "<>", 
        "\"\<[\!\(\*SuperscriptBox[\(s\), \(-1\)]\)]\>\""}]}], "}"}]}], ",", 
    RowBox[{"PlotLabel", "\[Rule]", "\"\<Earth\>\""}], ",", 
    RowBox[{"Epilog", "->", 
     RowBox[{"{", " ", 
      RowBox[{
       RowBox[{"Text", "[", 
        RowBox[{
         RowBox[{"Style", "[", 
          RowBox[{
          "\"\<\!\(\*SubscriptBox[\(\[Sigma]\), \(\[Chi]N\)]\) = \
\!\(\*SuperscriptBox[\(10\), \(-43\)]\) \!\(\*SuperscriptBox[\(cm\), \(2\)]\)\
\>\"", ",", 
           RowBox[{"FontFamily", "\[Rule]", "\"\<Times\>\""}], ",", 
           RowBox[{"FontColor", "\[Rule]", 
            RowBox[{"Color7Lines", "[", 
             RowBox[{"[", "1", "]"}], "]"}]}]}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"Log10", "[", "0.01", "]"}], ",", 
           RowBox[{"Log10", "[", 
            RowBox[{"10", "^", "11.5"}], "]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", "0"}], "}"}]}], "]"}], ",", 
       RowBox[{"Text", "[", 
        RowBox[{
         RowBox[{"Style", "[", 
          RowBox[{
          "\"\<\!\(\*SuperscriptBox[\(10\), \(-41\)]\) \
\!\(\*SuperscriptBox[\(cm\), \(2\)]\)\>\"", ",", 
           RowBox[{"FontFamily", "\[Rule]", "\"\<Times\>\""}], ",", 
           RowBox[{"FontColor", "\[Rule]", 
            RowBox[{"Color7Lines", "[", 
             RowBox[{"[", "2", "]"}], "]"}]}]}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"Log10", "[", "0.007", "]"}], ",", 
           RowBox[{"Log10", "[", 
            RowBox[{"10", "^", 
             RowBox[{"(", 
              RowBox[{"12.5", "+", "1"}], ")"}]}], "]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", "0"}], "}"}]}], "]"}], ",", 
       RowBox[{"Text", "[", 
        RowBox[{
         RowBox[{"Style", "[", 
          RowBox[{
          "\"\< \!\(\*SuperscriptBox[\(10\), \(-39\)]\) \!\(\*SuperscriptBox[\
\(cm\), \(2\)]\)\>\"", ",", 
           RowBox[{"FontFamily", "\[Rule]", "\"\<Times\>\""}], ",", 
           RowBox[{"FontColor", "\[Rule]", 
            RowBox[{"Color7Lines", "[", 
             RowBox[{"[", "3", "]"}], "]"}]}]}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"Log10", "[", "0.007", "]"}], ",", 
           RowBox[{"Log10", "[", 
            RowBox[{"10", "^", "15.5"}], "]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", "0"}], "}"}]}], "]"}], ",", 
       RowBox[{"Text", "[", 
        RowBox[{
         RowBox[{"Style", "[", 
          RowBox[{
          "\"\< \!\(\*SuperscriptBox[\(10\), \(-37\)]\) \!\(\*SuperscriptBox[\
\(cm\), \(2\)]\)\>\"", ",", 
           RowBox[{"FontFamily", "\[Rule]", "\"\<Times\>\""}], ",", 
           RowBox[{"FontColor", "\[Rule]", 
            RowBox[{"Color7Lines", "[", 
             RowBox[{"[", "4", "]"}], "]"}]}]}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"Log10", "[", "0.007", "]"}], ",", 
           RowBox[{"Log10", "[", 
            RowBox[{"10", "^", "17.5"}], "]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", "0"}], "}"}]}], "]"}], ",", 
       RowBox[{"Text", "[", 
        RowBox[{
         RowBox[{"Style", "[", 
          RowBox[{
          "\"\< \!\(\*SuperscriptBox[\(10\), \(-35\)]\) \!\(\*SuperscriptBox[\
\(cm\), \(2\)]\)\>\"", ",", 
           RowBox[{"FontFamily", "\[Rule]", "\"\<Times\>\""}], ",", 
           RowBox[{"FontColor", "\[Rule]", 
            RowBox[{"Color7Lines", "[", 
             RowBox[{"[", "5", "]"}], "]"}]}]}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"Log10", "[", "0.007", "]"}], ",", 
           RowBox[{"Log10", "[", 
            RowBox[{"10", "^", "19.5"}], "]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", "0"}], "}"}]}], "]"}], ",", 
       RowBox[{"Text", "[", 
        RowBox[{
         RowBox[{"Style", "[", 
          RowBox[{
          "\"\< \!\(\*SuperscriptBox[\(10\), \(-33\)]\) \!\(\*SuperscriptBox[\
\(cm\), \(2\)]\)\>\"", ",", 
           RowBox[{"FontFamily", "\[Rule]", "\"\<Times\>\""}], ",", 
           RowBox[{"FontColor", "\[Rule]", 
            RowBox[{"Color7Lines", "[", 
             RowBox[{"[", "6", "]"}], "]"}]}]}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"Log10", "[", "0.003", "]"}], ",", 
           RowBox[{"Log10", "[", 
            RowBox[{"10", "^", "21.5"}], "]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", "0"}], "}"}]}], "]"}], ",", 
       RowBox[{"Text", "[", 
        RowBox[{
         RowBox[{"Style", "[", 
          RowBox[{
          "\"\< \!\(\*SuperscriptBox[\(10\), \(-31\)]\) \!\(\*SuperscriptBox[\
\(cm\), \(2\)]\)\>\"", ",", 
           RowBox[{"FontFamily", "\[Rule]", "\"\<Times\>\""}], ",", 
           RowBox[{"FontColor", "\[Rule]", 
            RowBox[{"Color7Lines", "[", 
             RowBox[{"[", "7", "]"}], "]"}]}]}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"Log10", "[", "0.033", "]"}], ",", 
           RowBox[{"Log10", "[", 
            RowBox[{"10", "^", "23.5"}], "]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", "0"}], "}"}]}], "]"}], ",", 
       RowBox[{"Text", "[", 
        RowBox[{
         RowBox[{"Style", "[", 
          RowBox[{"\"\<Geometric Capture Rate\>\"", ",", 
           RowBox[{"FontFamily", "\[Rule]", "\"\<Times\>\""}], ",", 
           RowBox[{"FontColor", "\[Rule]", "Black"}]}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"Log10", "[", "12", "]"}], ",", 
           RowBox[{"Log10", "[", 
            RowBox[{"10", "^", "24.8"}], "]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", 
           RowBox[{"-", "0.41"}]}], "}"}]}], "]"}]}], "}"}]}]}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.884593950295188*^9, 3.8845940702342043`*^9}, {
   3.884594114066513*^9, 3.884594123379677*^9}, {3.884594544584634*^9, 
   3.88459456595557*^9}, {3.884595966802081*^9, 3.8845960039485188`*^9}, {
   3.884596812446742*^9, 3.884596869587677*^9}, {3.884596938231949*^9, 
   3.884597049770011*^9}, {3.8845970854454803`*^9, 3.88459723787391*^9}, {
   3.884597277637197*^9, 3.884597277808341*^9}, {3.88459749082962*^9, 
   3.884597631610702*^9}, {3.884803586233817*^9, 3.884803594064165*^9}, {
   3.8848037917121572`*^9, 3.884803797395853*^9}, 3.884803969610257*^9, {
   3.887093318587195*^9, 3.887093618322784*^9}, {3.88994411808609*^9, 
   3.889944121795332*^9}, {3.8899442497545223`*^9, 3.8899443088026247`*^9}, {
   3.889944795869957*^9, 3.8899447972713337`*^9}, {3.88994521136314*^9, 
   3.889945245656144*^9}, 3.895399927639442*^9},
 CellLabel->
  "In[118]:=",ExpressionUUID->"ac7717f8-183c-4a1f-b6d1-a21a72e3a2aa"],

Cell[BoxData[
 GraphicsBox[{{{{}, {}, 
     TagBox[
      {GrayLevel[0], Thickness[0.007], Opacity[1.], Dashing[{Small, Small}], 
       LineBox[CompressedData["
1:eJwVyXk41AkAxvExGFHOH56oHGkiuZbfzJhD8+5GGuQYrd22QsfKkYdqE5KN
Wl2WRbt5wrYPErWVlhok8xOqdW2sRpQnSpMmZyJHmbV/vM/3+Tyv5e4Y8fd0
Go22ZXH/99i2TlMXF13Kd7w1wUbFDfIoHZV8e10q7+D53w7T3OCb7PVGzUaX
GvqwveK+UgCzovsVspW6VOqsYnjHggDU8F8+iQxdSkLXDM2aF0DteE5yfY8O
ZW7ksWluSoD0kq0v/Y7rUOPcewatCgHyJ2Vl+9u0qewT16/FdAmQs87eMkO0
jArwyu2dLBJgtGr19T0vtCi3T8bpN+IE6JIUvA1M0qRMd5Tk+HgJkC2O1LGb
16AOjAlzrU0FqNwk86zKYVBT0dHm3BE+bspyIux01Kkp88tFp2r5YMlk/LuZ
qpT8x5Fj1el8mDlWr16wpVOqLX/3Woby0W81MmFTSqPyROXkQ0c+tAePX9NN
XpCGVNjqF9H5iAlx7qLXzEuNW25v3C3jIdXgVFtT9YzU09j7UHAJDzvjTcfH
h6ekl31+YGYl8PDWKODVu1fvpcl3rnTRRDwYM5kxrp1j0s3t73oCTRb/E8zI
iI0K6YaOhl19w1ysEu9n8ASD0nKNEnlRLRcNS3cpbnP6pL7rVo7+kcmFnjhO
i8PokIYn57/vDeaiXfy8hs2ulB5Msd8y48CFdRzLYvhwlbA0RmzrQ+dCdcI9
yZ3bKdyelaLW1+GKndUp3tGn+oS83913FRe7ojxV5B3qOyjU2rbc0C/eFX7V
5/wiAxTCrZ7TDezNrgg5669SPDImbLUIn966whUacW+WmKtMCuvsB5nlCg4e
PVxRzv48JSwcir02WsNBfZi+g7xpRliRkVWxJ4MDzfY9z5qa54XC8Noqo2AO
zqQeCXHLXxBO2x3FghMHc+tRL71Jw6VLXmbNahx0zx1UxDvS0eixZraziw3/
WIby2K+qMOrOCjIoZWNCtHl9nok6BvI0b2UcYcOhWfGV2kkGeryNMr70YqO/
V+Oq+I0GGsq+qO9exUaN37821eGasOZ/O3F1hAWnKGV21GMtVEsMiispFtoU
PYbsoGV4sK87cD6Thf45B/nrLm00NP25jRnKQuatwcIBri5GdIxf/uTCgktY
8d3EYD3knDuzz0qVheEHaXm2hD72Tv4S8/EJiRcxa622NOrDWrOs7UYZCblX
wZ2jJw0QJm6xKUogwU9oFD7mEOhIS2G0+5AovHx+YZxHQHK0Taa+aK3Ovff0
NxAoiDW54uZNotdWnR/oTiDiu1ue10Uk4p97sGX+BFQcBk6nbyJxR/jQ7nkE
AecnWOoNEk6MZpOhPALnrWh6j1xI5DpffLrkEoHE5T79SmcSyuDIC+sKCYRq
55ZzFt0u0TKKKiVg99Ex4IoTiegIb73RSgKNzSHZafYkrra2Mj60EZg6IDX0
sCZhMJvfZNhB4FnY0tdJa0kkMqNPsroI1G//5nYlk4QoWZt+pJfAzx5jX69Z
Q2LI0ffzrJzAWhPzC6qWJPx3mNWaKggs04nax7cgITk9msgfIfCeLuEcMieR
NpAxkzRJoG7Y9+nLVSRGtUMkBdMEigculpouOojnGFc3S+CsTB4vXkmiLkxJ
vvhEILbFWXR2BQlmzj+TSiWBICrZ5L4pif8Aygsm+w==
        "]]},
      Annotation[#, "Charting`Private`Tag$75241#1"]& ]}, {}}, {{{}, {}, 
     TagBox[
      {RGBColor[0.254627, 0.013882, 0.615419], Thickness[0.007], Opacity[1.], 
       LineBox[CompressedData["
1:eJwV13k4VF0YAPAZ+66iTZbE2GamZK3IOZUkESlLQiT7mlISKRRJKCkpfC0U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        "]]},
      Annotation[#, "Charting`Private`Tag$74525#1"]& ]}, {}}, {{{}, {}, 
     TagBox[
      {RGBColor[0.477344, 0.00698, 0.659549], Thickness[0.007], Opacity[1.], 
       LineBox[CompressedData["
1:eJwV13c8Vl8YAHB779GQlD1f703iV8k5lZZUklVJJJUtVETJSgkphEpDskKI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        "]]},
      Annotation[#, "Charting`Private`Tag$74578#1"]& ]}, {}}, {{{}, {}, 
     TagBox[
      {RGBColor[0.674522, 0.147419, 0.578688], Thickness[0.007], Opacity[1.], 
       LineBox[CompressedData["
1:eJwV13c8lV8YAHB7z2jJL8mmy73XauAcpUKyykhmGlaUEJKsym4gI6OMBpJC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        "]]},
      Annotation[#, "Charting`Private`Tag$74631#1"]& ]}, {}}, {{{}, {}, 
     TagBox[
      {RGBColor[0.819651, 0.306812, 0.448306], Thickness[0.007], Opacity[1.], 
       LineBox[CompressedData["
1:eJwV13k8lE0cAPBd674l6VLIkXvt2vVW8oySJCSFkqscuaVDcl+RHOUMkSIq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        "]]},
      Annotation[#, "Charting`Private`Tag$74684#1"]& ]}, {}}, {{{}, {}, 
     TagBox[
      {RGBColor[0.928329, 0.472975, 0.326067], Thickness[0.007], Opacity[1.], 
       LineBox[CompressedData["
1:eJwV2Hc8lV8YAHB7r3ul/Nolm4x7uSn1HkVJ2YVkVsgIicgqI7JCKCFJCNl7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        "]]},
      Annotation[#, "Charting`Private`Tag$74737#1"]& ]}, {}}, {{{}, {}, 
     TagBox[
      {RGBColor[0.989935, 0.663787, 0.204859], Thickness[0.007], Opacity[1.], 
       LineBox[CompressedData["
1:eJwV13c8Vl8YAHB7j/yEkqJCISXeYd+TrGSXyEopRYVIpEJSChVlVWSEJEVC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        "]]},
      Annotation[#, "Charting`Private`Tag$74790#1"]& ]}, {}}, {{{}, {}, 
     TagBox[
      {RGBColor[0.968443, 0.894564, 0.147014], Thickness[0.007], Opacity[1.], 
       LineBox[CompressedData["
1:eJwV13c8ld8fAPC73Hu5Q7paUnYpibjucymeI8rO+qYSLaNslUJlRUhDQ0hU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        "]]},
      Annotation[#, "Charting`Private`Tag$74843#1"]& ]}, {}}},
  AspectRatio->0.92,
  Axes->{False, False},
  AxesLabel->{None, None},
  AxesOrigin->{0, 20.10452422470588},
  BaseStyle->17,
  DisplayFunction->Identity,
  Epilog->{
    InsetBox[
     FormBox[
      StyleBox[
      "\"\\!\\(\\*SubscriptBox[\\(\[Sigma]\\), \\(\[Chi]N\\)]\\) = \
\\!\\(\\*SuperscriptBox[\\(10\\), \\(-43\\)]\\) \\!\\(\\*SuperscriptBox[\\(cm\
\\), \\(2\\)]\\)\"", FontFamily -> "Times", FontColor -> 
       RGBColor[0.254627, 0.013882, 0.615419], StripOnInput -> False], 
      TraditionalForm], {-2., 11.5}, 
     NCache[
      ImageScaled[{
        Rational[1, 2], 
        Rational[1, 2]}], 
      ImageScaled[{0.5, 0.5}]], Automatic, {1, 0}], 
    InsetBox[
     FormBox[
      StyleBox[
      "\"\\!\\(\\*SuperscriptBox[\\(10\\), \\(-41\\)]\\) \
\\!\\(\\*SuperscriptBox[\\(cm\\), \\(2\\)]\\)\"", FontFamily -> "Times", 
       FontColor -> RGBColor[0.477344, 0.00698, 0.659549], StripOnInput -> 
       False], TraditionalForm], {-2.154901959985743, 13.5}, 
     NCache[
      ImageScaled[{
        Rational[1, 2], 
        Rational[1, 2]}], 
      ImageScaled[{0.5, 0.5}]], Automatic, {1, 0}], 
    InsetBox[
     FormBox[
      StyleBox[
      "\" \\!\\(\\*SuperscriptBox[\\(10\\), \\(-39\\)]\\) \
\\!\\(\\*SuperscriptBox[\\(cm\\), \\(2\\)]\\)\"", FontFamily -> "Times", 
       FontColor -> RGBColor[0.674522, 0.147419, 0.578688], StripOnInput -> 
       False], TraditionalForm], {-2.154901959985743, 15.5}, 
     NCache[
      ImageScaled[{
        Rational[1, 2], 
        Rational[1, 2]}], 
      ImageScaled[{0.5, 0.5}]], Automatic, {1, 0}], 
    InsetBox[
     FormBox[
      StyleBox[
      "\" \\!\\(\\*SuperscriptBox[\\(10\\), \\(-37\\)]\\) \
\\!\\(\\*SuperscriptBox[\\(cm\\), \\(2\\)]\\)\"", FontFamily -> "Times", 
       FontColor -> RGBColor[0.819651, 0.306812, 0.448306], StripOnInput -> 
       False], TraditionalForm], {-2.154901959985743, 17.5}, 
     NCache[
      ImageScaled[{
        Rational[1, 2], 
        Rational[1, 2]}], 
      ImageScaled[{0.5, 0.5}]], Automatic, {1, 0}], 
    InsetBox[
     FormBox[
      StyleBox[
      "\" \\!\\(\\*SuperscriptBox[\\(10\\), \\(-35\\)]\\) \
\\!\\(\\*SuperscriptBox[\\(cm\\), \\(2\\)]\\)\"", FontFamily -> "Times", 
       FontColor -> RGBColor[0.928329, 0.472975, 0.326067], StripOnInput -> 
       False], TraditionalForm], {-2.154901959985743, 19.5}, 
     NCache[
      ImageScaled[{
        Rational[1, 2], 
        Rational[1, 2]}], 
      ImageScaled[{0.5, 0.5}]], Automatic, {1, 0}], 
    InsetBox[
     FormBox[
      StyleBox[
      "\" \\!\\(\\*SuperscriptBox[\\(10\\), \\(-33\\)]\\) \
\\!\\(\\*SuperscriptBox[\\(cm\\), \\(2\\)]\\)\"", FontFamily -> "Times", 
       FontColor -> RGBColor[0.989935, 0.663787, 0.204859], StripOnInput -> 
       False], TraditionalForm], {-2.5228787452803374`, 21.5}, 
     NCache[
      ImageScaled[{
        Rational[1, 2], 
        Rational[1, 2]}], 
      ImageScaled[{0.5, 0.5}]], Automatic, {1, 0}], 
    InsetBox[
     FormBox[
      StyleBox[
      "\" \\!\\(\\*SuperscriptBox[\\(10\\), \\(-31\\)]\\) \
\\!\\(\\*SuperscriptBox[\\(cm\\), \\(2\\)]\\)\"", FontFamily -> "Times", 
       FontColor -> RGBColor[0.968443, 0.894564, 0.147014], StripOnInput -> 
       False], TraditionalForm], {-1.4814860601221125`, 23.5}, 
     NCache[
      ImageScaled[{
        Rational[1, 2], 
        Rational[1, 2]}], 
      ImageScaled[{0.5, 0.5}]], Automatic, {1, 0}], 
    InsetBox[
     FormBox[
      StyleBox[
      "\"Geometric Capture Rate\"", FontFamily -> "Times", FontColor -> 
       GrayLevel[0], StripOnInput -> False], TraditionalForm], 
     NCache[{Log[10]^(-1) Log[12], 24.8}, {1.0791812460476247`, 24.8}], 
     NCache[
      ImageScaled[{
        Rational[1, 2], 
        Rational[1, 2]}], 
      ImageScaled[{0.5, 0.5}]], Automatic, {1, -0.41}]},
  Frame->True,
  FrameLabel->{
    FormBox[
    "\"\\!\\(\\*SubscriptBox[\\(m\\), \\(\[Chi]\\)]\\) [GeV]\"", 
     TraditionalForm], 
    FormBox[
    "\"\\!\\(\\*SubscriptBox[\\\"\\\\\\\"C\\\\\\\"\\\", \\\"\\\\\\\"\
\[CirclePlus]\\\\\\\"\\\"]\\)[\\!\\(\\*SuperscriptBox[\\(s\\), \
\\(-1\\)]\\)]\"", TraditionalForm]},
  FrameStyle->Thickness[0.0045],
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  ImageSize->400,
  LabelStyle->{FontFamily -> "Times"},
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotLabel->FormBox["\"Earth\"", TraditionalForm],
  PlotRange->{{-3.82, 4.83}, {10, 28}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{{3.8870935384970093`*^9, 3.887093618839553*^9}, 
   3.888491110785103*^9, 3.888502256979517*^9, 3.889680168210725*^9, 
   3.8896971830949907`*^9, 3.889697651004744*^9, 3.889697905955696*^9, 
   3.8896981151789007`*^9, 3.889699939270639*^9, 3.889751745096663*^9, 
   3.8897521211198483`*^9, 3.889762754873391*^9, 3.889762890915228*^9, 
   3.8897642673584213`*^9, 3.889764494861024*^9, 3.889771802415925*^9, 
   3.889787450691703*^9, 3.889787630947315*^9, 3.889787739637435*^9, 
   3.889787774572209*^9, 3.889787871308731*^9, 3.8897887517197847`*^9, 
   3.889788828770114*^9, 3.889789249830242*^9, 3.8897894080345993`*^9, 
   3.889793314768784*^9, 3.88979354227435*^9, 3.889793734462283*^9, 
   3.889794113369947*^9, 3.8897951566685343`*^9, 3.889795332679854*^9, 
   3.889795607399283*^9, 3.8897964353830433`*^9, 3.8897972838232193`*^9, 
   3.889797466102871*^9, 3.889797943466338*^9, 3.889798234150669*^9, 
   3.889798415144665*^9, 3.889802577281805*^9, 3.889803661165002*^9, 
   3.889803792091909*^9, 3.889806209436417*^9, 3.889944212871933*^9, {
   3.889944252427919*^9, 3.889944309317728*^9}, 3.8899447979806347`*^9, 
   3.889945246750061*^9, {3.890042565079672*^9, 3.890042578559654*^9}, 
   3.890291711439555*^9, 3.89029502750772*^9, {3.891933731365102*^9, 
   3.8919337421748123`*^9}, 3.892032356612959*^9, 3.892032393396777*^9, {
   3.892032633908574*^9, 3.8920326806092052`*^9}, 3.892032757956444*^9, 
   3.8920335244145613`*^9, 3.892114922786673*^9, 3.892115370971562*^9, 
   3.892115436026904*^9, 3.892115565786248*^9, 3.8921156273997*^9, 
   3.892115683007751*^9, 3.892209670895362*^9, 3.892210092998521*^9, 
   3.892210309804275*^9, 3.892210382579493*^9, {3.892210445299491*^9, 
   3.892210473020939*^9}, 3.892210563014357*^9, 3.8922107167223177`*^9, {
   3.8922107604852877`*^9, 3.892210780005434*^9}, 3.8922910088231373`*^9, 
   3.8923002247756977`*^9, 3.892304222668689*^9, 3.892305758610086*^9, {
   3.892305794176734*^9, 3.892305819985113*^9}, {3.892306082153492*^9, 
   3.892306126027895*^9}, {3.892306321631948*^9, 3.892306331940907*^9}, 
   3.8923067814592943`*^9, 3.892307054175997*^9, 3.892307162110261*^9, 
   3.892307272942671*^9, {3.892307404058025*^9, 3.8923074259718924`*^9}, 
   3.892307464535075*^9, {3.892350718003943*^9, 3.892350726264297*^9}, 
   3.892351129326899*^9, 3.892351176022564*^9, 3.892351644905011*^9, 
   3.892351809186096*^9, {3.8923518398678207`*^9, 3.892351864128531*^9}, {
   3.892351908888962*^9, 3.892351935533793*^9}, 3.8923522182384233`*^9, {
   3.89235230911915*^9, 3.8923523258153057`*^9}, 3.892352381161891*^9, 
   3.89235263160602*^9, 3.892352674306156*^9, 3.892352714046474*^9, {
   3.892352746936095*^9, 3.8923527740846853`*^9}, {3.892353135872157*^9, 
   3.892353150480227*^9}, 3.892353770722692*^9, 3.8923538378579617`*^9, 
   3.892353873453597*^9, 3.8923539159813232`*^9, 3.892353948820241*^9, {
   3.8923540813061943`*^9, 3.892354120516958*^9}, 3.892354841854216*^9, {
   3.8923550573238153`*^9, 3.892355085623837*^9}, 3.8924605263925247`*^9, 
   3.89342131521806*^9, 3.895396935032652*^9, 3.8953995895933523`*^9, 
   3.8953997264078493`*^9, 3.8953999596729937`*^9, {3.896520208935479*^9, 
   3.896520233444193*^9}, 3.8965202966328*^9, 3.896520373785817*^9},
 CellLabel->
  "Out[118]=",ExpressionUUID->"5749ce21-3cde-4e27-91c4-30d7e0c9f928"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Generate Example Plots Sun Multi-component model", "Section",
 CellChangeTimes->{{3.884590566014189*^9, 3.884590576421175*^9}, {
   3.884602499355714*^9, 3.884602514105564*^9}, {3.884603170799758*^9, 
   3.88460317178617*^9}, {3.892289315710812*^9, 3.89228931923951*^9}, {
   3.892290863625499*^9, 3.892290865131693*^9}, {3.8922910466685753`*^9, 
   3.892291051610649*^9}, 3.892304360180808*^9, {3.892355475344116*^9, 
   3.892355475575253*^9}, {3.8924565194208317`*^9, 3.892456520480556*^9}, 
   3.895400165140593*^9},ExpressionUUID->"42af45b7-e408-4174-9db0-\
07bf479410dd"],

Cell[BoxData[
 RowBox[{
  RowBox[{"MSol", "=", 
   RowBox[{"1.988", "*", 
    RowBox[{"10", "^", "33"}], "g"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.829377238147131*^9, 3.829377253011642*^9}},
 CellLabel->
  "In[823]:=",ExpressionUUID->"07ef3e85-7058-4bbb-bdbc-57163b3f6771"],

Cell[BoxData[
 RowBox[{
  RowBox[{"RSol", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"696", "*", 
      RowBox[{"10", "^", "3"}], "km"}], "/.", 
     RowBox[{"{", 
      RowBox[{"km", "\[Rule]", 
       RowBox[{
        RowBox[{"10", "^", "5"}], " ", "cm"}]}], "}"}]}], "//", "N"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.835884893660556*^9, 3.835884938133012*^9}},
 CellLabel->
  "In[824]:=",ExpressionUUID->"7fddb728-16a2-40f9-aeb9-ae88bd88327d"],

Cell[BoxData[
 RowBox[{
  RowBox[{"ElementVectorSun", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"1", "/", "100"}], "*", "68.59"}], ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"1", "/", "100"}], "*", "29.89"}], ",", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"1", "/", "100"}], "*", "0.64"}], ",", "16"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"1", "/", "100"}], "*", "0.1980"}], ",", "12"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"1", "/", "100"}], "*", "0.1517"}], ",", "10."}], "}"}], ",", 
     
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"1", "/", "100"}], "*", "0.1299"}], ",", "56."}], "}"}]}], 
    "}"}]}], ";"}]], "Input",
 CellChangeTimes->{3.896677851714941*^9},
 CellLabel->
  "In[825]:=",ExpressionUUID->"efe237a8-85f5-4406-a2c3-96b562dede7b"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"DataPlotDMSun", "[", "l\[Sigma]_", "]"}], ":=", 
   RowBox[{
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"10", "^", "lmDM"}], ",", " ", 
        RowBox[{"DMCapture", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"10", "^", "lmDM"}], ",", 
            RowBox[{"10", "^", "l\[Sigma]"}], ",", 
            RowBox[{"vDMlocal", " ", 
             RowBox[{"s", "/", "km"}]}], ",", 
            RowBox[{"MSol", "/", "g"}], ",", 
            RowBox[{"RSol", "/", "cm"}], ",", 
            RowBox[{"nDMlocal", " ", 
             RowBox[{
              RowBox[{"cm", "^", "3"}], "/", "GeV"}]}]}], "}"}], ",", 
          "\"\<Total\>\"", ",", 
          RowBox[{"ElementVectorSun", "[", 
           RowBox[{"[", 
            RowBox[{"All", ",", "1"}], "]"}], "]"}], ",", 
          RowBox[{"ElementVectorSun", "[", 
           RowBox[{"[", 
            RowBox[{"All", ",", "2"}], "]"}], "]"}]}], "   ", "]"}]}], "   ", 
       "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"lmDM", ",", 
        RowBox[{"-", "3.9"}], ",", "10", ",", "0.2"}], "}"}]}], "]"}], "//", 
    "Quiet"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.884593298165538*^9, 3.884593365640114*^9}, {
   3.884593551520721*^9, 3.884593551567355*^9}, {3.884596050658052*^9, 
   3.884596051318948*^9}, {3.884602520677404*^9, 3.884602543441139*^9}, {
   3.884602900919114*^9, 3.884602918293921*^9}, {3.884603211195957*^9, 
   3.8846032238771544`*^9}, {3.884603320709074*^9, 3.8846033254287577`*^9}, {
   3.884604476492931*^9, 3.884604478614012*^9}, {3.885228918909686*^9, 
   3.8852289275099382`*^9}, {3.889806063913651*^9, 3.889806065161027*^9}, {
   3.892289348940626*^9, 3.892289356938858*^9}, {3.89229026366472*^9, 
   3.892290263862602*^9}, {3.892290318497376*^9, 3.892290318621394*^9}, {
   3.892304800233535*^9, 3.892304800519783*^9}, {3.892305902599148*^9, 
   3.8923059027156973`*^9}, 3.8924605305225983`*^9, {3.895400004286705*^9, 
   3.895400005253621*^9}, {3.896520301645094*^9, 3.896520302371624*^9}},
 CellLabel->
  "In[826]:=",ExpressionUUID->"56e2dbf7-85c2-4eb2-bf80-d790f3c1cccc"],

Cell[BoxData[
 RowBox[{"Clear", "[", "DataPlotDMCalcFitSun", "]"}]], "Input",
 CellChangeTimes->{{3.884594841586844*^9, 3.884594845911023*^9}, 
   3.884596353043357*^9, 3.884602550760064*^9, {3.8846032288681707`*^9, 
   3.8846032300506477`*^9}},
 CellLabel->
  "In[827]:=",ExpressionUUID->"e8046b54-d06a-4c97-af08-c7127d00805f"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"DataPlotDMCalcFitSun", "[", "l\[Sigma]_", "]"}], ":=", 
   RowBox[{"Interpolation", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"DataPlotDMSun", "[", "l\[Sigma]", "]"}], "/.", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"x_", ",", "y_"}], "}"}], ":>", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Log10", "[", "x", "]"}], ",", 
          RowBox[{"Log10", "[", " ", "y", "]"}]}], "}"}]}], "}"}]}], ",", 
     RowBox[{"InterpolationOrder", "->", "1"}]}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.884594849027102*^9, 3.884594850447727*^9}, {
  3.884596057673152*^9, 3.884596059296566*^9}, {3.884602554598899*^9, 
  3.8846025583765993`*^9}, {3.884603231822154*^9, 3.884603235500312*^9}},
 CellLabel->
  "In[828]:=",ExpressionUUID->"27db7f60-fc21-4dad-a5e0-a46f16bcf985"],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Sigma]ElTabSun", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"10", "^", "l\[Sigma]"}], ",", 
     RowBox[{"{", 
      RowBox[{"l\[Sigma]", ",", 
       RowBox[{"-", "44."}], ",", 
       RowBox[{"-", "30."}], ",", "2"}], "}"}]}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.884594344159565*^9, 3.884594380587932*^9}, {
   3.8845955259782343`*^9, 3.8845955261498013`*^9}, 3.884596062949692*^9, 
   3.8846025641197157`*^9, {3.8846032380337267`*^9, 3.884603239045711*^9}, {
   3.88460347150537*^9, 3.884603486232161*^9}, {3.884603902078515*^9, 
   3.884603955176486*^9}, {3.891934003673221*^9, 3.891934003791291*^9}, {
   3.892032790865246*^9, 3.892032790943596*^9}, {3.8920328238555317`*^9, 
   3.8920328339145327`*^9}, {3.892033558623954*^9, 3.8920335588776197`*^9}, {
   3.89229012892557*^9, 3.892290133980213*^9}, {3.8922902166902657`*^9, 
   3.892290258065641*^9}, {3.892290315366696*^9, 3.8922903165770893`*^9}, {
   3.8922903575707703`*^9, 3.892290357751177*^9}, {3.892290398641396*^9, 
   3.892290402659699*^9}, {3.892300426341505*^9, 3.892300456653357*^9}, {
   3.892304612185645*^9, 3.892304612891062*^9}, 3.892305039674202*^9, {
   3.892306403915317*^9, 3.8923064277931347`*^9}, {3.8923068563695383`*^9, 
   3.892306862309188*^9}, {3.892357654300516*^9, 3.892357654916176*^9}, {
   3.8942968739442377`*^9, 3.8942968961593857`*^9}, 3.895400099631502*^9},
 CellLabel->
  "In[829]:=",ExpressionUUID->"10994a69-dafc-48d4-84da-c40f733ad544"],

Cell[BoxData[
 RowBox[{"Clear", "[", "DataDMFitCalcSun", "]"}]], "Input",
 CellChangeTimes->{{3.884595630588786*^9, 3.8845956316248293`*^9}, 
   3.884596067668391*^9, 3.8846025693371696`*^9, {3.884603240711342*^9, 
   3.884603241656969*^9}},
 CellLabel->
  "In[830]:=",ExpressionUUID->"0d0332a8-ea5a-411f-9e5c-7fe17c645beb"],

Cell[BoxData[
 RowBox[{
  RowBox[{"DataDMFitCalcSun", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"DataPlotDMCalcFitSun", "[", 
      RowBox[{"Log10", "[", 
       RowBox[{"\[Sigma]ElTabSun", "[", 
        RowBox[{"[", "i", "]"}], "]"}], "]"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "1", ",", 
       RowBox[{"Length", "[", "\[Sigma]ElTabSun", "]"}]}], "}"}]}], "]"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.8845956897309847`*^9, 3.8845957204665403`*^9}, {
  3.8845960696719627`*^9, 3.884596074835845*^9}, {3.884602573546475*^9, 
  3.884602589486902*^9}, {3.884603243028047*^9, 3.884603252897546*^9}},
 CellLabel->
  "In[831]:=",ExpressionUUID->"7f5308fd-ab14-4e6c-ac88-c2e0b83b7b03"],

Cell[BoxData[
 RowBox[{
  RowBox[{"PlotsDataDMSun", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Plot", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"DataDMFitCalcSun", "[", 
         RowBox[{"[", "i", "]"}], "]"}], "[", "lmDM", "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"lmDM", ",", 
         RowBox[{"-", "3.9"}], ",", "10"}], "}"}], ",", 
       RowBox[{"Axes", "->", "False"}], ",", 
       RowBox[{"PlotStyle", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Thickness", "[", "0.007", "]"}], ",", 
          RowBox[{"Color10Lines", "[", 
           RowBox[{"[", 
            RowBox[{"i", "+", "2"}], "]"}], "]"}]}], "}"}]}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "1", ",", 
       RowBox[{"Length", "[", "\[Sigma]ElTabSun", "]"}]}], "}"}]}], "]"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.8845957523891706`*^9, 3.884595953124914*^9}, {
  3.8845960803539047`*^9, 3.884596084158746*^9}, {3.884602594862957*^9, 
  3.88460260526711*^9}, {3.884603255019034*^9, 3.88460326335992*^9}, {
  3.884604486734459*^9, 3.884604486842911*^9}, {3.88980612217342*^9, 
  3.889806122856134*^9}, {3.8919340216714354`*^9, 3.891934021870471*^9}, {
  3.892290697416847*^9, 3.8922907128888073`*^9}, {3.892292525614093*^9, 
  3.892292532894948*^9}, {3.892300450400817*^9, 3.892300466092564*^9}, {
  3.8923046537360983`*^9, 3.892304656917858*^9}, {3.892304902914794*^9, 
  3.892304915642906*^9}, {3.892305088027779*^9, 3.8923050881829853`*^9}, {
  3.892305898037202*^9, 3.892305898491399*^9}, {3.892357685905406*^9, 
  3.892357692138179*^9}, {3.8942069610620623`*^9, 3.894206963108233*^9}, {
  3.895400110223044*^9, 3.895400114541485*^9}},
 CellLabel->
  "In[832]:=",ExpressionUUID->"09501fdd-0e2c-48eb-b26d-bb5271931aa9"],

Cell[BoxData[
 RowBox[{
  RowBox[{"CSunGeoFit", "=", 
   RowBox[{"Interpolation", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"lmDM", ",", 
          RowBox[{"Log10", "[", " ", 
           RowBox[{"DMCapture", "[", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"(*", "GeV", "*)"}], " ", 
              RowBox[{
               RowBox[{"10", "^", "lmDM"}], ",", "\[Sigma]", ",", 
               RowBox[{"vDMlocal", " ", 
                RowBox[{"s", "/", "km"}]}], ",", 
               RowBox[{"MSol", "/", "g"}], ",", 
               RowBox[{"RSol", "/", "cm"}], ",", " ", 
               RowBox[{"nDMlocal", " ", 
                RowBox[{
                 RowBox[{"cm", "^", "3"}], "/", "GeV"}]}]}], "}"}], ",", 
             "\"\<Geometric\>\"", ",", 
             RowBox[{"{", "1", "}"}], ",", 
             RowBox[{"{", "1", "}"}]}], "]"}], " ", " ", "]"}]}], "  ", "}"}],
         ",", 
        RowBox[{"{", 
         RowBox[{"lmDM", ",", 
          RowBox[{"-", "3.9"}], ",", "10", ",", "0.2"}], "}"}]}], "]"}], "//",
       "Quiet"}], ",", 
     RowBox[{"InterpolationOrder", "->", "1"}]}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.884596620370172*^9, 3.884596724472307*^9}, {
   3.884602619050453*^9, 3.8846026337936287`*^9}, {3.884603266570772*^9, 
   3.88460328853375*^9}, {3.885399295841432*^9, 3.885399305069364*^9}, {
   3.889806085172515*^9, 3.8898060860146837`*^9}, {3.892304927382316*^9, 
   3.892304931408165*^9}, {3.892357682041432*^9, 3.89235768215168*^9}, 
   3.892460755686276*^9, {3.895400117615954*^9, 3.895400118309471*^9}, 
   3.896520304664164*^9},
 CellLabel->
  "In[833]:=",ExpressionUUID->"aea81dcf-476b-49a9-8879-7e226a4c876c"],

Cell[BoxData[
 RowBox[{
  RowBox[{"CSunGeoPlot", "=", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"CSunGeoFit", "[", "lmDM", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"lmDM", ",", 
       RowBox[{"-", "3.9"}], ",", "10"}], "}"}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Thickness", "[", "0.007", "]"}], ",", "Dashed", ",", 
        "Black"}], "}"}]}], ",", 
     RowBox[{"Axes", "->", "False"}]}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.884596725856454*^9, 3.8845968062009172`*^9}, {
  3.884602638804257*^9, 3.8846026431791687`*^9}, {3.8846032926780787`*^9, 
  3.884603295950645*^9}, {3.884604505519986*^9, 3.884604507779203*^9}, {
  3.889806088461218*^9, 3.889806089502902*^9}, {3.889936736549307*^9, 
  3.88993673670638*^9}, {3.892304937172407*^9, 3.892304937621876*^9}, {
  3.8923576797821503`*^9, 3.8923576800440197`*^9}, {3.8954001241337633`*^9, 
  3.8954001247442913`*^9}},
 CellLabel->
  "In[834]:=",ExpressionUUID->"8de0b952-738a-44ed-a1fa-7b61cec9b64b"],

Cell[BoxData[
 RowBox[{
  RowBox[{"PlotSettingRatesSun", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"PlotRange", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "3.82"}], ",", "4.83"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"20.77", ",", "35"}], "}"}]}], "}"}]}], ",", 
     RowBox[{"Frame", "->", "True"}], ",", 
     RowBox[{"LabelStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"FontFamily", "\[Rule]", "\"\<Times\>\""}], "}"}]}], ",", 
     RowBox[{"BaseStyle", "->", "17"}], ",", 
     RowBox[{"FrameStyle", "\[Rule]", 
      RowBox[{"Thickness", "[", "0.0045", "]"}]}], ",", 
     RowBox[{"ImageSize", "\[Rule]", "400"}], ",", 
     RowBox[{"AspectRatio", "\[Rule]", "0.92"}]}], "}"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.8661770639165983`*^9, 3.866177070226347*^9}, {
   3.866190510994719*^9, 3.866190511192675*^9}, {3.866194039914996*^9, 
   3.86619404009339*^9}, {3.866195097189847*^9, 3.866195116010172*^9}, {
   3.866196297021264*^9, 3.866196297746401*^9}, {3.866201784126067*^9, 
   3.866201789630039*^9}, {3.8662018318352947`*^9, 3.8662018360128803`*^9}, 
   3.866202076168412*^9, {3.866202308159042*^9, 3.866202315524818*^9}, {
   3.8662569757529783`*^9, 3.866257000350449*^9}, {3.866260793096089*^9, 
   3.866260793649808*^9}, {3.866270509602785*^9, 3.866270510021145*^9}, {
   3.8670611254818907`*^9, 3.8670611256792393`*^9}, {3.884595980014073*^9, 
   3.884596019624016*^9}, {3.884596362453342*^9, 3.884596362619647*^9}, 
   3.8846026491170073`*^9, {3.8846027107896976`*^9, 3.884602719606842*^9}, {
   3.884603299125804*^9, 3.884603299627274*^9}, {3.884603457237756*^9, 
   3.884603457359005*^9}, {3.884604279086543*^9, 3.884604284381488*^9}, {
   3.884604509917734*^9, 3.884604510161037*^9}, {3.884804673836726*^9, 
   3.884804674390854*^9}, {3.889806076012762*^9, 3.88980607672246*^9}, {
   3.890042612019154*^9, 3.8900426121979094`*^9}, {3.892304950166561*^9, 
   3.8923049569250813`*^9}, {3.892305258377956*^9, 3.8923052586903048`*^9}, {
   3.892305889945221*^9, 3.892305890087916*^9}, {3.892351281664049*^9, 
   3.892351282106827*^9}, {3.8923514075337687`*^9, 3.892351414505308*^9}, {
   3.8934206783785686`*^9, 3.893420687192864*^9}, {3.894296930795184*^9, 
   3.894296975976225*^9}, {3.896520336155623*^9, 3.8965203365734053`*^9}},
 CellLabel->
  "In[835]:=",ExpressionUUID->"c1bea7ae-af5a-4361-b388-a3573aa3b8c4"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PlotSun", "=", 
  RowBox[{"Show", "[", 
   RowBox[{
   "PlotsDataDMSun", ",", "CSunGeoPlot", ",", "PlotSettingRatesSun", ",", 
    RowBox[{"FrameLabel", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"\"\<\!\(\*SubscriptBox[\(m\), \(\[Chi]\)]\) [GeV]\>\"", ",", 
       RowBox[{
        RowBox[{"ToString", "[", 
         RowBox[{
          RowBox[{"Subscript", "[", 
           RowBox[{"\"\<C\>\"", ",", " ", "\"\<\[CircleDot]\>\""}], "]"}], 
          ",", 
          RowBox[{"FormatType", "->", "StandardForm"}]}], "]"}], "<>", 
        "\"\<[\!\(\*SuperscriptBox[\(s\), \(-1\)]\)]\>\""}]}], "}"}]}], ",", 
    RowBox[{"PlotLabel", "\[Rule]", "\"\<Sun\>\""}], ",", 
    RowBox[{"Epilog", "->", 
     RowBox[{"{", "\[IndentingNewLine]", " ", 
      RowBox[{
       RowBox[{"Text", "[", 
        RowBox[{
         RowBox[{"Style", "[", 
          RowBox[{
          "\"\<\!\(\*SubscriptBox[\(\[Sigma]\), \(\[Chi]N\)]\) = \
\!\(\*SuperscriptBox[\(10\), \(-42\)]\) \!\(\*SuperscriptBox[\(cm\), \(2\)]\)\
\>\"", ",", 
           RowBox[{"FontFamily", "\[Rule]", "\"\<Times\>\""}], ",", 
           RowBox[{"FontColor", "\[Rule]", 
            RowBox[{"Color10Lines", "[", 
             RowBox[{"[", "3", "]"}], "]"}]}]}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"Log10", "[", 
            RowBox[{"5.9", " ", 
             RowBox[{"10", "^", 
              RowBox[{"-", "3"}]}]}], "]"}], ",", 
           RowBox[{"Log10", "[", 
            RowBox[{"10", "^", "21.1"}], "]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", "0"}], "}"}]}], "]"}], ",", "\[IndentingNewLine]",
        " ", 
       RowBox[{"Text", "[", 
        RowBox[{
         RowBox[{"Style", "[", 
          RowBox[{
          "\"\<\!\(\*SuperscriptBox[\(10\), \(-40\)]\) \
\!\(\*SuperscriptBox[\(cm\), \(2\)]\)\>\"", ",", 
           RowBox[{"FontFamily", "\[Rule]", "\"\<Times\>\""}], ",", 
           RowBox[{"FontColor", "\[Rule]", 
            RowBox[{"Color10Lines", "[", 
             RowBox[{"[", "4", "]"}], "]"}]}]}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"Log10", "[", 
            RowBox[{"3", " ", 
             RowBox[{"10", "^", 
              RowBox[{"-", "3"}]}]}], "]"}], ",", 
           RowBox[{"Log10", "[", 
            RowBox[{"10", "^", 
             RowBox[{"(", "23.4", ")"}]}], "]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", "0"}], "}"}]}], "]"}], ",", "\[IndentingNewLine]", 
       RowBox[{"Text", "[", 
        RowBox[{
         RowBox[{"Style", "[", 
          RowBox[{
          "\"\<\!\(\*SuperscriptBox[\(10\), \(-38\)]\) \
\!\(\*SuperscriptBox[\(cm\), \(2\)]\)\>\"", ",", 
           RowBox[{"FontFamily", "\[Rule]", "\"\<Times\>\""}], ",", 
           RowBox[{"FontColor", "\[Rule]", 
            RowBox[{"Color10Lines", "[", 
             RowBox[{"[", "5", "]"}], "]"}]}]}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"Log10", "[", 
            RowBox[{"3", " ", 
             RowBox[{"10", "^", 
              RowBox[{"-", "3"}]}]}], "]"}], ",", 
           RowBox[{"Log10", "[", 
            RowBox[{"10", "^", 
             RowBox[{"(", "25.4", ")"}]}], "]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", "0"}], "}"}]}], "]"}], ",", "\[IndentingNewLine]", 
       RowBox[{"Text", "[", 
        RowBox[{
         RowBox[{"Style", "[", 
          RowBox[{
          "\"\<\!\(\*SuperscriptBox[\(10\), \(-36\)]\) \
\!\(\*SuperscriptBox[\(cm\), \(2\)]\)\>\"", ",", 
           RowBox[{"FontFamily", "\[Rule]", "\"\<Times\>\""}], ",", 
           RowBox[{"FontColor", "\[Rule]", 
            RowBox[{"Color10Lines", "[", 
             RowBox[{"[", "6", "]"}], "]"}]}]}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"Log10", "[", 
            RowBox[{"3", " ", 
             RowBox[{"10", "^", 
              RowBox[{"-", "3"}]}]}], "]"}], ",", 
           RowBox[{"Log10", "[", 
            RowBox[{"10", "^", 
             RowBox[{"(", "27.4", ")"}]}], "]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", "0"}], "}"}]}], "]"}], ",", "\[IndentingNewLine]", 
       RowBox[{"Text", "[", 
        RowBox[{
         RowBox[{"Style", "[", 
          RowBox[{
          "\"\< \!\(\*SuperscriptBox[\(10\), \(-34\)]\) \!\(\*SuperscriptBox[\
\(cm\), \(2\)]\)\>\"", ",", 
           RowBox[{"FontFamily", "\[Rule]", "\"\<Times\>\""}], ",", 
           RowBox[{"FontColor", "\[Rule]", 
            RowBox[{"Color10Lines", "[", 
             RowBox[{"[", "7", "]"}], "]"}]}]}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"Log10", "[", 
            RowBox[{"3", " ", 
             RowBox[{"10", "^", 
              RowBox[{"-", "3"}]}]}], "]"}], ",", 
           RowBox[{"Log10", "[", 
            RowBox[{"10", "^", 
             RowBox[{"(", "29.4", ")"}]}], "]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", "0"}], "}"}]}], "]"}], ",", "\[IndentingNewLine]", 
       RowBox[{"Text", "[", 
        RowBox[{
         RowBox[{"Style", "[", 
          RowBox[{
          "\"\<\!\(\*SuperscriptBox[\(10\), \(-32\)]\) \
\!\(\*SuperscriptBox[\(cm\), \(2\)]\)\>\"", ",", 
           RowBox[{"FontFamily", "\[Rule]", "\"\<Times\>\""}], ",", 
           RowBox[{"FontColor", "\[Rule]", 
            RowBox[{"Color10Lines", "[", 
             RowBox[{"[", "8", "]"}], "]"}]}]}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"Log10", "[", 
            RowBox[{"3", " ", 
             RowBox[{"10", "^", 
              RowBox[{"-", "3"}]}]}], "]"}], ",", 
           RowBox[{"Log10", "[", 
            RowBox[{"10", "^", 
             RowBox[{"(", 
              RowBox[{"26.6", "+", "4.2"}], ")"}]}], "]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", "0"}], "}"}]}], "]"}], ",", 
       RowBox[{"Text", "[", 
        RowBox[{
         RowBox[{"Style", "[", 
          RowBox[{
          "\"\<\!\(\*SuperscriptBox[\(10\), \(-30\)]\) \
\!\(\*SuperscriptBox[\(cm\), \(2\)]\)\>\"", ",", 
           RowBox[{"FontFamily", "\[Rule]", "\"\<Times\>\""}], ",", 
           RowBox[{"FontColor", "\[Rule]", 
            RowBox[{"Color10Lines", "[", 
             RowBox[{"[", "10", "]"}], "]"}]}]}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"Log10", "[", 
            RowBox[{"1", " ", 
             RowBox[{"10", "^", 
              RowBox[{"-", "3"}]}]}], "]"}], ",", 
           RowBox[{"Log10", "[", 
            RowBox[{"10", "^", 
             RowBox[{"(", 
              RowBox[{"25.6", "+", "6.8"}], ")"}]}], "]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", 
           RowBox[{"-", "0.3"}]}], "}"}]}], "]"}], ",", "\[IndentingNewLine]", 
       RowBox[{"Text", "[", 
        RowBox[{
         RowBox[{"Style", "[", 
          RowBox[{"\"\<Geometric Capture Rate\>\"", ",", 
           RowBox[{"FontFamily", "\[Rule]", "\"\<Times\>\""}], ",", 
           RowBox[{"FontColor", "\[Rule]", "Black"}]}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"Log10", "[", "5", "]"}], ",", 
           RowBox[{"Log10", "[", " ", 
            RowBox[{"10", "^", "30.3"}], "]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", 
           RowBox[{"-", "0.54"}]}], "}"}]}], "]"}]}], "}"}]}]}], 
   "]"}]}]], "Input",
 CellChangeTimes->CompressedData["
1:eJwd0Fsow3EUB/C/LaU8EElJM7V40dzWolz2R3PZw7REyXUztxiWYmh5QjJP
5JZLmIepkdhmonjZZjWUxIPri7FL7srcft89nD6d861z6sRK2yRyBkVRbFKQ
q7TJhM9uelptUcIbdk43LI5rUUHJVpgeBo3trcMV3UV1PjGvXF0HDaJRGxQ4
No4huyX/AnqX0u5hDa13wbDPnV/okm0yC5BfbvvNHilnwevh10SY8pK8XIT7
7cta6A73GCH/kTZB1fvbG7RGpH9A4X5noYh4FsIpgl57pkuBeZTcDft9K5wu
H9mnSebBDHFVbQ/RIDZqoNMd74TMK90DZOSesnqJxmAzGz5qh+KhY/grCZoX
gviQd6ii4eKAXgglxlYRrOAONgv/yD+cBwrIm6d2fUTnx7sdJmkSCiMoD106
EyqFPeNzimiGh3ZR3j5olUWuxjJJ3vHjV3YrOLIQn7QPx/B8quIFsk5M31A3
2yuwEusDzCUwq1FTCSUxcVL4WjbR4O+V6ia4ljp4fhfooRuHJv3+A7MvGZk=

  "],
 CellLabel->
  "In[836]:=",ExpressionUUID->"70e91bd3-3c1a-41c8-b2d9-d6c4ff28a590"],

Cell[BoxData[
 GraphicsBox[{{{{}, {}, 
     TagBox[
      {RGBColor[0.546157, 0.038954, 0.64701], Thickness[0.007], Opacity[1.], 
       LineBox[CompressedData["
1:eJwV13k8lM8fAPBlrXWTKEfOFUkSdl3JMyki5UtSEXJHUUgSKiKKHJUzcuUn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        "]]},
      Annotation[#, "Charting`Private`Tag$4393390#1"]& ]}, {}}, {{{}, {}, 
     TagBox[
      {RGBColor[0.674522, 0.147419, 0.578688], Thickness[0.007], Opacity[1.], 
       LineBox[CompressedData["
1:eJwV13k8lE8YAPA9rZsc5UjOSJIj7UrHOyJSSElFkZAkSSiKikilHB2K5MzP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        "]]},
      Annotation[#, "Charting`Private`Tag$4393443#1"]& ]}, {}}, {{{}, {}, 
     TagBox[
      {RGBColor[0.775796, 0.253658, 0.491171], Thickness[0.007], Opacity[1.], 
       LineBox[CompressedData["
1:eJwV13k4VF0YAPBZjLGTIpIsMxKSrZiLukdCJIlWKYpESYpKlrIURUkLEpHl
IyoRyZZ7bFGWSEgkpOzZd8Z35q95fs/M3Hve97znPefInbpgdZpCIpF6yCQS
53MeyApqaQnDHZpRsdwquuBzH3PmqrIwVAPphziOC1f6VSwnDOUsildxvKND
M9tYRBhSz/aE0JADrxodtBkRgp8St3hyIQtknn0WkCYED66qMqcg/zxwIfhj
vBA0kflB5zhz0eMCf5QQZKmOlJGR95v6GUTeFIJSpqsxjqN67/95cVIIdvvb
KZCQZaXeqTZICcHzY7PLy8q6YLy0QFxstRA8weYr4LjMuWTlKJ8QtBTY4Mnx
6byqxt9zglBr067BJeSM/T8uzzYLwnm7iJZFZJ+5zhP6dYJw8HzyA47NE36b
BFQIwnafPHOO/w0PS/LnCMKS6I6yBWTi0TjFMkMQZv036sdxhO7M0ONEQZiY
Q8E4PtW98K3tiSDs25o4No+sdXvlw4YIQUh+4xbEMZcaV5pDiCCUUtIX57il
mSfixXVBuC2ZN30O2YshekrzvCA8G51SP4tcXMLkNjYThE03fkjOIBtPm1qc
5xKEKZbGWRPILxNOaM8sCMBE516MYxEzjw03xgXgM//A8nHk9vi4fxGdAjAy
q6RlDNl992h4br4ADBbRWf6H/DT28ZdFVwHo0qBoNoS8YpT+/qaDADzdX9k0
iOw49iFB0EYAniQ5HudYzajvgoyJALRRf+4+gPx4dPHwi+0C8NDuHQv9yAsx
IkBjqwC0su8I4rjiHyZiKCcA90RIRPchK8VYzNWsFYAmL/JkOQ43dOg6ICQA
DeGBjL/IUyNXq39yCUD8+4QWx0ef3M1yWuSHYVLzsX+QS3YmPhkd54cTJzy6
epGZI+/8vfr5oU3SCJPjfwa/LEOb+eEmpZ7XPcjWw5Os1bX88L6r7UQ3cn4U
j1xcGT+cfdOizXHQkMb46zf8sFK7hviFLBF580HjHX7osCu3sQN5Z7/SV4kd
/PCZXfB0C3Lawx2FiVv5IVcySZdjge3WScoq/ND1r/f1ZuTWB76X9CX4oe75
C/RvyK56X0TtJ/jgd+8jko3I0eGe1mmpfFA0Snl7DfLzE+H1Dc/4YImUaPhn
Tn1ueWG68JgPuiTOd37ixFvfju8N4oPwVbV/NXJ1/HThFW8+eE4zq7EKudFN
WPv5RT64Nj9anuMfO5SyPznzwbLtNzw+IvcKGW6etOODMpI/r1Vy8tNpm7b+
MB/c1pzkWIE8l3lF3tiCD+554LyvHJl/X4ZEjD4f9OKdYpYia95fRcMl+WDD
PF9DMbK+nYq/swgf/PuuobAI2UjNaPEBnQ8uXYz6rxD5yBev8d5pXrhpUM4n
H/mGcNfP0K+80P8Ha2Mucu39zLyWMF6oUeTk+5JT/3bVGqQgXmhydfOZDORf
aj2vlLx54XGtif3pyBNfxJJ9nXnhnZd+imnIkiJ+9+WNeGF37OOvScjyXVF8
5vq8cPawzYdE5M1ZWbcua/FCwTWyL54jA8ten2o5XojdfekXj+wUscfZjc0D
H/qWbXrKWQ/2p39HT/PAF6zbq2OQr6nfOFE6zANLpvayo5EDSTFtg7954Les
1QNRyHcb3h5Y084DB13bmiKRo57Xftn+lQeSlBJKHnPm0/2v2ZlPPNAs8tC5
R5z5BKSPEZAHkrmTcx8g54isMyh8zwMLrowu3+es7y6t4t+ZPNC9T88kHPlj
1l4dwVQeqHjkdsRdznxaBqjaP+aBUZgc4w4y6UG/JPdFHui5ZLU7EPlFw7uZ
Y8488Kqn7lN/5P0iQU3ZdjzQZ1hu+Dpy0n3pe8cteGBgx9h9H+Rd4Vakdyo8
8EFxeKsn8p2w4r8Of+nwje9npzOc+a65U17wkw7fTmXnn+a8n+/wc+FmOsxz
jeFz5OQ3dPxoUTkdfrB1zrRHrr+9sU40kQ5r9blnjiJfqZ5Md35Chw25IyZH
kGV4SoNL7tNh0+bmmEOcfIccA2ev02H7+pTt1siiwRE5pcfocGDJ4JY5cmHl
8Yi11nQ44qnUaobsQFM5f96MDseHRZRMOevNaM603IAOpxznvE2Qc29WbpTE
6HCu41etEfLxiofUC+p0mJzOrjdE5uay76pQpMMUHbKiAfLhoIUYd3E6TLPm
btXj5LO86spHQTpM7+ZRwzj5pERar6fRYcYF/hBtTj8LUBOsnuSGr8NEdDSQ
4/wd/WUauWFO+brojcgKPqy9fsbcsDbZcO2SEur/JWJKa7dzw5/NydvmkePJ
k1zZWtxwlM51YAZZ4vbr4l5ZbrjatSJiDJkvUn6z+SIN2mw14vuDbPJ9hf53
nAbPOf23qQf5ptTP3zf6adDvCc3kF/JyYnRsTjMNJi5VBrUh6/7xvLq3lgbf
btmY1IJ8ZZOVdV8ZDVbYB8Mm5LFMAX6pLBrsrzBerkPePDHwNzeVBudnUqVq
kF22VZVZPKNBfiW6bjVyqldKfP8jGlRPGzpYgdxTFOAdGEqDpeKunwhkmZUT
h9YH0KB18LB+EbLtTn3NvKs02DvtmpWH3Fw9MzDgSIP05vPRr5ELe7qq8yVp
8NH+i1p3kGcUSlKsRGhQoXQ89Saylkus/zA3DeapX1rnj/xq9CBLdooLtgl7
kK8iJyx9Tgup54Iy9Z5fHDn5EH8XfCiIC7408zoHkEuPPjw1do0L6hfOdeoh
s+Mu7Ah154L1StesdJCvMpRnPhznguM83tgW5LPqCacVWFxQp8qHvp4Tr4ev
AbGFC1ZrL3mvRf6dd1T6qAIXtEn1/SeKLLugPT8hxQWHxJZPCnHi3b6m+a4o
F/S75dfMixzjP561kZcLCk0v76Yht5TX34UrVOig2pJBQhalv3K2maHCuKeE
//wmXbDP7M6uqWEq/EZPPzSBrJ5zLmdLLxXeODOXOoQsut5C3qWdCpWrTGZ7
kb+NiJI6P1Ghf/Df6FbkIw/iiqpSqXAzjdlWjGz//Y1mrD0V3qIkHAtBNjB4
mNh8mArVT/176Y8sn+EpIrKPCttLty9dQ+71wf7d3E6FGgEdca7IzjLl6W7r
qPDnimTnfmR3pxbZnd8ocNvyY/v1yPu/5N/3raHALtveLDFkTVYsO6+MAsOK
tcjCyFO89h0q2RTY7fM1kYzcfGnnHqcXFHi3XW5iQVEX5LUzC58nUKCO3sWd
U8herweixcIp8N6C8O+/yEfFa7ktb1Egy8ZOqwtZ90bm5VBfCvxdkBnUhizV
H9Fb4UGB4ZLspq/IS5Ye1itnKVD32l5mLfLPgoNl2CkKJF4y/itHLpFnaXge
pcA7pFDFAmT/qSWhARMKlM44tDkF+eTxX34MnAL72MWZMcg7P5YOH9emwGxr
hsZ9ZK4nwZ+/Milw1/LoNm/k23oiwcVkCnS1vINbIkcEMpbvF5Fh0UyR1dJG
XUAbFTsn9JYM2apmU2PI3sd42u6+IEOD098j/yA7bh3JvRNJhlVNU9/rkbG/
ea5BF8jwa5aqXSJyplX6D7ITGYr1F5GikJlE7G5/WzI8ImOWFIos9MSf6WdK
hp33nP54IPeYmnVcYZDh4NmEc8bIh/P0zaYlyVA1SVVQD7lWXi3fQ4QM3duK
MtWQ8xZXP3ZfJsEZk+/jEsgqztyU0UkSxG44PRJEfv5t7sL5QRL0yZvaSkEW
Mxj6OdRFgiUjgS0zCrog9PXPPWdbSZCssMprCHlFsqGgv44Ed9kmSHYhewaX
KZ6pIMGX9A7pL8gDE7mRfwpJ8JOhgeMH5BN2aVTHbBLsu5Ga8RJZa9XFouNh
JGjnrlfhiPzCz0GpI4AE/V4957NG3jB4MNrGiwRj+2n7DZB5ynU9Dp8mwVb7
hp/SyB3oVrEfJ0HL/adnW5i6gDdbbdudvysEOqgomyJP3VmzKrhphTjhNuWu
g9x5an44EK4QvhlH3ysgv11TnuL7dIXIl2fuoiDbeB1a426xQmisLjhexED7
4369MVe9FWLfvg0p6chblGVrXTatEOfDggajkakdA0EOlBUinWpx1RP5Fe43
eSiPTchN9USoIn+brX74KplNaInyKq9HXnqzRpPygE0YqauV8yEzne0bD19n
E4csDtrOy6P7huwr99fn2ISzq890H7Ln91lh6lE2EbVtuvoLclyE4Zsjxmyi
lEEfz0UeJrWPUOXYhDhJxeAG8pqCjfeOCrEJ8E/fxRFZ/+KlzW8Wl4lzHRYP
TJHvdvOes2lZJmD+pe7VyKplrP6ssGXi7MXCgBdyuuCQ980Q7mvLxGO72vR7
yNc1GzbaOi0TxN7OxkvI9UlnTtMNlok1yhT57chuQVE9x2eWiJIe07JGWVS/
u6Y6+E4uEaIH2iiLMqj/LeG+9hZLxPadQ8pdyOzcMKk8vSXijPqyVSWyhQLD
5qT4ElEsIJd8H/kfzar1fc0i4VTpbMhEFi95dkWwYJF4kON9jhd5x5UBMYfU
RaIo8e6jfxvQfeGv/wGhgEVC5HrW73zkvPjaSQe3RULPtYw/HrnzkMSjgmOL
xGmbb1pByNzCjprCpotExO6/x5yR1areNDpqLxKF2nNBe5GP3Fh0L2QsEgrH
3rAUkf11TEREVi0SG6ZNItjSuqAhrdOiaGiBEFG6hr9Gdr8tWLsqcYGYjmh/
xoecZXruYwn/AvHB/rlNpZQukNtbGnZwYZ5g8ZadT0B+aLl2/3D/PJGb/dv/
GrLH4fJ2yY/zRAZFMU0VWfu01Lin/zwRnfJ6MnKdLvjgXyOlMj1HXOwvvOsk
iervplx36e85YiSiIwEgx4dcTT3ydY5wxthv1yH7hzM0gt/MEXahBm31Eqh+
43yMu13mCPPN1Qo6yO8SGvm9jswRVd8GWKuQNyYrNgqZzBE7/fjNh9ai82uq
X9R/2+aIEgVVu0pkekbTMX3mHIHVW1xKWMvp10pyTaJzRO4V91vXkPuzbvx1
Ic8RajIPn1gjH81tfkkamyXMx084SSN/fq9yMbpzlvgvUazij7gu0CsK0N5S
N0uw99fKZSK/KmldrCiaJQ5Tgm5cQb5XGRQ88WSW4HUY06UjWza1x+61niXc
mDXZm8RQPf0L+0itniG00/wTzq1G+7PCsJR79jRR/WrIe1xYF/iqn/oVHj9N
WNqpKL5DXqP3Pel12DTxfdW5Ji9kY8sKpaHT08TAlUEVEnKGd5yO07ppgtdg
oENISBdc+mJubRs0RVxQXDrSyI/uPz/KxH3cp4itscupfsgpvawfMceniDmh
lSkl5JZ55slWnSkicIb8IJAP7VfMZTer4UkispL+SYtXF5CvvQ7dfXCSKHZY
jUVxo/t1EMPizM5JIqB1TchOZM3wmFXBapOE0R7x5n80tD8k33pSzjtJfNGU
vGiCXF13PHVHyQTRQ5ZJn6Oi/UZeqGyr4gTB+1xZ8hgZnb9q3eZl58eInuvW
rScXMUCSH+3x7xsjovn7vrIXMNBz9UJtV/MYYf7Euz4WOZXhnvD87RiRl51Y
2TyPgc0+F41kXceI0N7RHNM5DHge6JfHS0YJTbO7ERrTGMgQmbTSDx0hAsUq
TcmjGBC/w5OjLT9A9Je+jrHsxsBPieSN9653ER6qccWulRjomOBKD/WpJT7t
Me8eSMOAvdoDjZjRGuLQSntVAPLvc9KFaQ41RO/bc5mSyIO922oq9nwmSOvC
fExTMTDX4jTClqomtPs/iaWnYECsqFrDo7icSLlpYuaciIE4bsnL7xfeERNP
Iq9Lx2Ig+YZG8LeeXKIxpH+s8ika75xp9PjnHCL7ip6DG3L+oHeBSmw2cfFA
twkRg75/VrCIX80gxoRVV518ggFt28B18hMPiNHgiuSUSAxQst98Madm4MOe
k9UqERgYa/MbED31Cleot+6uvY/ipZhT22AmbqeYO38e2VbZM1aTyMab2jyV
s8LR83xFvpT45uGFO2bCtt5D8cmYarfOEviU7NCplFD0fq3jFK6rn/BW/ivN
/bcwELr9jPNT7RbcxVlYa9IXA1m3aBtEAlrwypzZY++QW+qSm27VtOCyK79u
XkWWP9G146J9K94amdWy6IOBoutHxXaHfseNyvd7cyEPE3vKpn/+wOU2PC4V
u4aBfTvV1++/9Qtva5KwZF1G70te6qOe7cWVGg9nq7phYJz6PEpRYgTf/ET0
sPdJ9Pz+hHUbDSbx9pbn91qtMXCp4+v2AqtJ/K+CYH0yclkD7aS54yQ+4XlN
yB35VMG5tEshkzjvaqv7PMhJoTpbibpJXGcf9QFmhQE51S97j9hM4Y+rTj+O
tcSA7CW2f6jHNG60POUotBdD50uNFOlb07jlLWHxr+YYgDaOVVlR07iNoHJV
JLK94WfB1oJp3E3aTkkaOWFN1FMGaQaP3v5pRGUPBja8V80tvjuD9/s9u2Jq
igG3l/at++Jn8AlavqIgcknCo4WeNzP40r2v3xt2Y+DE7XnA2zSDi8TT9Y4g
xx+trDsoOYtjJRdXnEwwIL1k2/fvv1k8lG10+6YRBnYNXBBYyJ/FZ49Jqhki
u7YEatBqZ3HHguFmMvLj8shDIr9m8a/i0BfuwkBx1gsfqYlZHPd8xLiB3Pus
6PlG2hwuVFhL6CALhNVXakjM4Wu1E0W6DFH9nJ4S3r1jDlfcYvZWHflpfRgr
sWUOdxH6x/IAKN9F8cdfDczhF0PL7kghD77IDny/NIdf447+UY5jAAtqra2T
n0fjxX3XIH/XYZxccJvHX/57QLzbjtZrYuEda/oCPlK/zXhOFwM7wusyT6xb
wKfN+KKfIzv5dDW5qC7gyx87+3YjvzvIvcHfegEXIkLuxGAYOMBn9fZVwgKu
9qatVpeFAd9Zx9b3bxdwHZVM6d86GOqHV5fKKhdwPC3QLQx5suSZcdvQAr4v
QUWkQxsD615lnetlL+BHpEgnbyLvjCmPGF21iNtHf8vejHw2uOXdAnMRd16d
TmnehoGHHgM/aKxFvL3N67AncqH90orInkVc+t+1LfNbUT/bK6yw/gT6P8WH
dh1ZY9O2C5o3F/E/yn45IVoYaOjwp9o1LOJjPgHCsRoYEDaW2JzvvITTNoRW
laqi/mJdce+szxJOl3nasRu556T76PrwJZxXNmP8y2YM5PlVvw3IWcIF5D9L
daqgennnhe1hL+GrN/K5LyhhIJPZZtz5aBmX2xIqobURA080b72ISF3G5dWe
qhYqYCAQaPAZFizjTPWMnQbIh2zv1KV1LuOKmp9d9zExAM5uU7MZX8aVtH4E
tDAwoOzVHSHAxcZVtg5GHUdefoQduKjExrdo85Wek8fA38Q/7xj6bFxdZ13L
hByK782DtS0WbFyTpTx0Dbnww/Zrt0+ycS1Ml0RGTqkZ+KHrycbttQ+UOMli
ILwtUn8kmI13e3ZDKIMBrz6D+IQYNu6Q41a+Dtmc+vQkF8HGndTvVNdLo/61
yrg8r5GN97uJ12xClpWZYLr0svGzr5PrAtdjYErXrL+OdwU/r1zyVVsKA7GX
FtyiD6zgnszJjngJVJ/dNr7Kgyt4gMTxcbfVaP103dvzIpQE4kga64R50Xop
PTFg/4gE9mX9wT15MPAnSS1EMo4EKPZPT7fRMRB8urEs9DUJuBDU7GRu1P+M
k+wN80hA+kJ+Cw+y4iYP9mIJCTRsOL90nobi4d0Vl1tFAkH1cvJNXBioHlyj
e76BBORSFpKYyBK1f1oV2khgj2dSmA0VAy6v8y53dpPA5V1mnhEUDPC5H8ne
N0kCn3pjjJZIGNg7HbtJU5wMLipg/U3LLHCIL4NWnEgGqzflXdIcZ4HUIe9k
zwwy2D53/JjzGAvM1u4xUM0hgzPVtF3xoyzw5P6Ib3wFGRQ5HxTj+8cC7Ws0
pvz7yMAhfep99yAL2Mvk9xipUkCustZyRC8LuGz9SHzJR1aktW5oYYGNoiEn
dpVRwOVy6bNCzSzQM2qynF9DAdp22svLTSxg+/KTblInBeRHnWH8bGQBC/m6
d55cVFBM+3whto4FNEW+vZS0pILy3+E8EpUs8G/ksVn4USq4eSMtll7BAi9r
Dg5QHKjASApumS1jAWZI68bhy1RQZTV+oAWygDj7R2JJLBXUlFonPi5mgYWh
7miHPir4miChuyqXBfI+JWl/H6OCR3oadaQcFvBIc2g2X6CCA62m9mPZLDB8
6o+otiAXoB64Rr3+hgU62/rv8WhxActFkSmrDBYoqxoNen2dCwyYgualBBba
j5YvzIrRgFRffLRlGAskHSvwqdlAA4fbmiqkQlmgcPXlkARFGnhYwzPx9zYL
DAYNx5tgNMCbdcncL5gF9ji210Xb0sCMlzE5I4AFBBQKVFjJNPDn+WG/0qss
EJ7q2eelzg3WZtXqvLJngUfpQycWzOjgggfpvz4N9PuJSZ4kazrw7E70N1Jn
gWDdpbemtnTgtc/QNnkLC3jVCNBjztNBoErwajsVlP8R1Tc6EXQQ+Zs/sIWJ
5kvDfcWzmQ6KrNei8zIab/5UwqgdD6Bv3SKZvKwDuqqWu3o9eUHa26MeK5U6
QIksnPCljh9cZuQJuxjqAJvGlthItiD4Xbz3fQ3UBoadFoOqaiJA47+rt+y3
aINFu10NN4+uAsfk2Vr0uG1AUTXy4KcLomDqVdx9PdFtoDHkz9y9Z6uBxR2+
YgXfrWBU9YEeeL8G0BQLrV6MagG1rnoTpxoxELln9mfVaS0wLCNwSWBWHLSP
5jxd1aAJNrxM0XsuJAHelvmdOLhLE9SV6zNyt0sCH6dgn6ZXGmBMUT3j3ZF1
oMOY1+6QjAbY9uTdgrKbFDCICM+Kf6wO5iJ1XWRj1wO5pMAE0yU1oPZr3VVq
rjTY/cl41un3FtD7biHJqXcDcKs8yc2VowpOmGvXxtNlQdfuns2qtzeDm7/j
xMmPZMGE6KVU54sqwMWA6s5QlgM+PvsWGYbKgMdobYz+ezngf4D6enyTEsi3
mEq9byAPfGjmj/as2QQUZRrLk1rlgQs900ahfyOwjDyW9cqBAa45KQeualAA
PGs8l6WdGED78WLflhoFUPrwrtl9ZwaoFqjda/5RAWhGfOi9eJ4BfOpdJUOK
FcCaMBlJnasM0L0/M2vphQL47v87oDSUAV4f0fjVF6AATrqes27JZgBDJx39
Ei0FsG4o6LlJLgNIVdGT2rcogK8ucSP5eQwwo/idPq+kAHadqQuJLWKAtAGv
Ji1ZBbDxlFqxfSUDCJ4vPJsuoAAGD08yh74zwHeP7TGP/zBBUgv/Jdt2Bsj5
JriS3cUExw4yibqfDBC2rdPxSzsT1FodPJrVwwA7Zq+r831lgsy97+9dHmaA
FG9YdaOECZxqv/z4+48BbrRHqD4rYAKZPf2KR8YZ4LD+yUeFuUwQsVuyTHeG
AfjYZLvpDCbYXaUh/GqOAf6c+FohmsoEZGMzW+lFBvhAJCmrJzJBYcWp9PBl
BoiS9YjYG8cElwx9ZlZWGMA9wHDmbDQT/A/woK4O
        "]]},
      Annotation[#, "Charting`Private`Tag$4393496#1"]& ]}, {}}, {{{}, {}, 
     TagBox[
      {RGBColor[0.85975, 0.360588, 0.406917], Thickness[0.007], Opacity[1.], 
       LineBox[CompressedData["
1:eJwV13k4lE8cAPC1rGstkoRyrtxyJnbVO4hI/CpRhNzRQYkolCuKkg5XRChK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        "]]},
      Annotation[#, "Charting`Private`Tag$4393549#1"]& ]}, {}}, {{{}, {}, 
     TagBox[
      {RGBColor[0.976428, 0.596595, 0.244767], Thickness[0.007], Opacity[1.], 
       LineBox[CompressedData["
1:eJwV13c8lV8YAPDrXtdeDUpkXZGVkO16j5BEaMiWVaFCEoWKHyp7S1GJ0rTK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        "]]},
      Annotation[#, "Charting`Private`Tag$4393602#1"]& ]}, {}}, {{{}, {}, 
     TagBox[
      {RGBColor[0.994495, 0.74088, 0.166335], Thickness[0.007], Opacity[1.], 
       LineBox[CompressedData["
1:eJwV13k0VH0YB3DbMGZBoixZp3hVMllKjJkHkZCSVEopCi2yJCopIutbKGQp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        "]]},
      Annotation[#, "Charting`Private`Tag$4393655#1"]& ]}, {}}, {{{}, {}, 
     TagBox[
      {RGBColor[0.994495, 0.74088, 0.166335], Thickness[0.007], Opacity[1.], 
       LineBox[CompressedData["
1:eJwV0Hs0lHsXB3CiomJKKrdxe4qTLnqfGLfxzDchuaRijksX0XFLEq/zOo70
UlLGG0oKEV1ck3AqSvkN6XJEpBMqRUwZB1ETpZIz7x977fVZe63v3mvr+YVt
9Z8hIyMTL63/90noKq1dyxIWHw2S2C8DmgaWTkQZsYRr03zVZKXOSVnec1uP
JazL9LauXQow3XSl/XyW8GmJ81FjqQ9F2fG9R5SFU4/WaKpRwLzyPbnxRcpC
t/mTNoO6gK7m9VVtmtJ5ZtLJZC3AfnzjplB5JWHI/SyNtoXAmZRIt6LCOULv
Dw6ZvTKAzAmx+qxwBWHy4tdmfq95WBZj7hJrP0t4J/9AYUUtD66OSbafhuWE
v50Trpx1moe0Q9RUaq2s8FHe5Y6WCB7KeLGSn2/8IDpOJy8lOPNQsTHkft3c
r8TjOSe9xICH/mXDmvsrx8lPuvN/+jSThwNr/HpSzo2TM/eqlMKlVrXqunAl
eZzMDOFLRuR5sN/cuHzIf5y8uZ5dNyDHQ+nvOWYBGuMky2kZ/6UsDxGtzm7b
D38iBpX252V+MJCNviJw4EtITZxd/OMJBtmHqU2BNhJSGWrns01qOiVrQaKx
hJR621mLxxn8cvFI5l1FCckxsZuUlfphy45Cpu4jiRfbhptKGKTpKzeYGH4k
jpttfXNGGeg075vUnRwjKm6iP68NMJDRH+2LGxgj/54W+ZhK3RcV1tz7bIw8
u/x2/Po7BoXU/rz8qjGSKT+gV/2WwcqYcDvdvWNE+8Zg9M1+BpHuYn1e3Sgx
Uh9dXtfDoHS+ZCtXMELW9UwmPehksDhJ4Q+O/iDRnOs85HyPAV/SMa94Wkxc
h/M/VTcyOLWjIED9lZgcbhmf0pdahbbR+H5GTIZT8+ZPNjBgvYyJr1cSkzpV
iWmBkIHCqlFX58l3xE87O26qlsHXtmfDvm0isk9jjsvKSgYWVpfsn14REbc9
J+P+U8Hgt4KIfNtkETG/pXFNeJXBRDTL3dBeRGS9V2jyyxlI9DfWDtf2k4ws
58HYywyGI28nRRX1kVq11COtBQxW9Aj6xQl9JC9oyU11qfds9LL29usjCTV5
w7svMRCzJ8a47D6yybPC7csFBqL7xp4z0t+QN2ee6OnlM3ildtHg+MFeMnuJ
al1ENoO9JyoPKHv1kkzT4NgrWQy+KwrbU9f2EiP3Oq44k4HpxM2ppU96SMOp
ykbuGQbuAx0lhok9xGa5Z4PNaQYRXRK+kZV0fucHcchgUHFrVblxwWvS8M6p
1j2dQdH6RSw7l25SL4grTkiW/pcvagvL7SSkffCQKIZB90f5EkFMM/ENjf0l
1IvBjMqrrc5ypbzVFXVGZCEDgXVgUDang5fceFdR46E1BBe/D8jtEfFKTlbK
C2Ot8UEu/7Sh2givx3mLko+5NfTFeRoG6yS8gxZaOhojXLC/bx94X/CZ93vA
S4XOQi5Y9mora4K+85QlcQ5V3lzY9h53KhbI4FmartJ7FhfBJvdJa80MvAnM
UlvZZCXdNxX2edFMtHz2lxw7aIX0kqGdXx1ng+0Yf2zQzAq9D6Z6RZGKyFzv
UFX20RLLZVl5rS1zYdd36lJqkSW8n3SczfihhJUP5RWifC2x/vWmv1cZz0fZ
rB73g4ss8c3Hti3BawGWhccXiJssYLgqg/9nmApKvk0c8zhigSdH3345nrsQ
xie++L2zsMDoqhNWqFZFaIpne7TEHMa9jzcEPFqE6acbXPeXm2NYZ17EvM+L
kXKvujFxtzm0L1+yyldWQ6jDlvbzbHO03OVS16zVcWxGSFf3EzOMGa4pve6p
AZ8VMYKFyWYwzbz+1WifJsJeDn46YWeGLxmWwbpntfCy98CvzZMcGPdoRMld
Y8OkUJB9t5IDwc4muXs1bHCd0g4freBA9Co6LfEOG3ZjGXudrnKQ3d1VoviA
DQ/L88zTMg5mvTjdzXrBRvTj6r6+Ig66/1Kx0ZLRxq5EpTrZc9K8pjlKps7a
WB3pZaKZJM27/vVCgEgb9/n+txJ3crA/tu3HgkFtJIeUTSzewcE320LvOyPa
cI2X0EXbOFD5a4uK6mdtPC+Lv/zAkwPex+L4ekUdDMmdy1Fwk96z2mOXlrEO
FlR1HBRs4GBz0R/s9mgdbFN2WJ+yhoOdzpzmc7N1sc8/tJo1ZYqE/pzFsum6
qNqRFZJzwhTB6+T2U0Z6SE+z9P42zxQKdkuyuNV6+BL0MD88yQQ1mz4Vpq7T
x9XimDJDeRMY6jy5e6FTH+lK6v99vX8tNmdsqyjbTcEz12/O+nc0FFQjp9gB
FFZwTDmd/TTqT/7PMTWIgllNRFbwGxp02h1ReCiF3Ca++Hg3DdVkHXWzKApB
o5qJHe00uuL64+sFFKbNi+sDCQ3fvSFuHZXSvGahuSCThsbQ4fwN1yjs4NO7
tE7TaA/OGam5QSHt9cWj5ek0bANbjp6tpTA+Jo1LoWHgZ3x71z0KwkUukZpH
aPztIVk61EXBw+f51bJwGhc65kZsf0lBIHbsZMJobOMvJS2vKNwOv/2jbS+N
5q18r4o+CvoJeS7jgTTKXaqP/zpMYaTYf8h6J42A5tYX795T0KM7Vdq20dBx
Eht6fqDgVutg6edFI81BvcFygsLNlhVJie40HB78i1X2hcLwz7kValtpyNo7
bmd/o6Ddq9xV6krjVqNfScoUhS3BcdNcFxoR62MmpqcpJHz8YNDqSOMf8FfI
JA==
        "]]},
      Annotation[#, "Charting`Private`Tag$4393708#1"]& ]}, {}}, {{{}, {}, 
     TagBox[
      {RGBColor[0.968443, 0.894564, 0.147014], Thickness[0.007], Opacity[1.], 
       LineBox[CompressedData["
1:eJwV0Hs4lHkfBnAiKTEqidHk8JASq8Mzzp65w0xOSTGbQ2Upp868WttKS+lE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        "]]},
      Annotation[#, "Charting`Private`Tag$4393761#1"]& ]}, {}}, {{{}, {}, 
     TagBox[
      {GrayLevel[0], Thickness[0.007], Opacity[1.], Dashing[{Small, Small}], 
       LineBox[CompressedData["
1:eJwVjWs0lHkAh5mRbC7TRdZtGrwuSyzL3xiMmZ9cR9FWO+tWSjahdU1pCyez
tZgw2o5VpKSLdFHOEieteaVYLYtackqySxKjzSWhZNsPz3nO8+kx3hm/eRdD
SUnJ/xP/ew5Gmg4OLFpx8pFJL9MdD16azqRYsejgwYjEDZ/6dJ7l8zvGLLrF
ZlpOM9wh6LOv8l7Oos/d1d5WoewOSYqXOGRcixYrxIUHFwGNypiSjHItukHY
q85+DxgZ1Nh0GmjRsuG+6fBJwPutKCBWRZO2J8PNYwNAYV7ylvJLy+jmZ7zd
rHpA6fiInmqiGj3OLt1SUwiYHeL5p3mr0jLD7maNfcBGv2zPaQWTllj6cZM3
AvkSakFWr0yrtj+a2GYNXBOmTX1766P8SXpJRaAqcFO0p7lBfV4u7o/uXHJX
iEEzhUFC1Vu5rqLxxY5UIThtcXNGc2/kqTpFU0/thNDJVvuVa/JKzogrPhU6
KsAz3fPmuekD8ox1PH/BRQH6JlUqpIfa5KUO4jmECMCoutGxgXlF+PemYjdf
bQGkbrujirg9wns54Qfjf3eD9PyHl8yYIeEZz6Z7c2lumGCW/mKhOy4ssgwo
z+K5wWTkrL65+5SQtzZY4jTOB/vD1pevL74Tzgbnvh29xAfLW9e6LuqDMPii
e3hDCB+eA7nrL0uVUBV7/Mk0i49o0izvqGPAJmKZwvaB66ffQvy71Usg2sec
kaa74kTFWNi831JkVpudHHVyxUDLwsBQ8mdoSBj0uT7pAktl1tmOdnUUiIzf
yMpdENLVU1zwUROyjVl2KeEu8OgPGLWxXQ6rpPjo9NUueL/ds/NI8ArUr5i8
MfLAGRY2BeLW+JVI6C/JCzzqjK7MF7O5JavQ3NK6a9jZGf/aHHdFrTaE/Wu6
f5jiwXbgT5/IP1ajMpG1OaGSBwVHI0njnQ5o48MtP0XwsObqBddSLV1MfdTr
Psfmob2JT1W76aFl1uFpX5cT3ljYXakJ0kcDJ+UHw2NOcDxZM28VZ4DrTWIz
uZcTZgtcoo2KDcE/Ut2aMc+F7XP9FGY1G68T+aqiai6GaubLIofWYF2qp6td
FBdhG7htZ5YaIYc5knaQzcWRwdM6yieMMFtbHdT62BHR7swEysoYqtnK1rwc
R6h5fX6KX2sMbmZK4VUvR9QFTF+SuZsgjJG9XKLkCAtOV1PZYxOYF+lLDtQQ
fF0QevNaBIWV27uP7Y0nUNNOXmBHUrjFEb1wiSNo/DnHTxZFIWTgjoARS2Cf
/9tQYiyFsvALE/kxBNrHOHpOKRTsvtsbWLmLoPfwYEajlEJA9ArqVShB+Pd7
tvRUUZDu9b8d5kugP/ZjqU81hS9J4ypzH4KH0afH625ReDhNYse9CDx3t2cW
11PQ3W9olOpBYL7T9s6O+xQuHxg7ekpAMBo4ZTrWS6E5LXvTX4SgrEc9aetT
CjGChSvFDgShYlN5+zMKmosJKhH2BG2bxcE3/6HwzeGg2glbgkr/2tx9CgpD
Egs2ay1BZFvHk+HXFLI8ivf3WBJw1o9YBE1QWKvC6iz5giDfV++uywyFpKMz
EmtzAt+Wr1jXZinoeMf0TZkSKHv7bWW/p3Bbtd+xniK4fW9nRd4ChbCWTTKJ
CUGSx6GZxUUKjKz7IyJjgv8Aw+oeiA==
        "]]},
      Annotation[#, "Charting`Private`Tag$4394290#1"]& ]}, {}}},
  AspectRatio->0.92,
  Axes->{False, False},
  AxesLabel->{None, None},
  AxesOrigin->{0, 6.294899929994464},
  BaseStyle->17,
  DisplayFunction->Identity,
  Epilog->{
    InsetBox[
     FormBox[
      StyleBox[
      "\"\\!\\(\\*SubscriptBox[\\(\[Sigma]\\), \\(\[Chi]N\\)]\\) = \
\\!\\(\\*SuperscriptBox[\\(10\\), \\(-42\\)]\\) \\!\\(\\*SuperscriptBox[\\(cm\
\\), \\(2\\)]\\)\"", FontFamily -> "Times", FontColor -> 
       RGBColor[0.546157, 0.038954, 0.64701], StripOnInput -> False], 
      TraditionalForm], {-2.2291479883578558`, 21.1}, 
     NCache[
      ImageScaled[{
        Rational[1, 2], 
        Rational[1, 2]}], 
      ImageScaled[{0.5, 0.5}]], Automatic, {1, 0}], 
    InsetBox[
     FormBox[
      StyleBox[
      "\"\\!\\(\\*SuperscriptBox[\\(10\\), \\(-40\\)]\\) \
\\!\\(\\*SuperscriptBox[\\(cm\\), \\(2\\)]\\)\"", FontFamily -> "Times", 
       FontColor -> RGBColor[0.674522, 0.147419, 0.578688], StripOnInput -> 
       False], TraditionalForm], 
     NCache[{-Log[10]^(-1) Log[
         Rational[1000, 3]], 23.4}, {-2.5228787452803374`, 23.4}], 
     NCache[
      ImageScaled[{
        Rational[1, 2], 
        Rational[1, 2]}], 
      ImageScaled[{0.5, 0.5}]], Automatic, {1, 0}], 
    InsetBox[
     FormBox[
      StyleBox[
      "\"\\!\\(\\*SuperscriptBox[\\(10\\), \\(-38\\)]\\) \
\\!\\(\\*SuperscriptBox[\\(cm\\), \\(2\\)]\\)\"", FontFamily -> "Times", 
       FontColor -> RGBColor[0.775796, 0.253658, 0.491171], StripOnInput -> 
       False], TraditionalForm], 
     NCache[{-Log[10]^(-1) Log[
         Rational[1000, 3]], 25.4}, {-2.5228787452803374`, 25.4}], 
     NCache[
      ImageScaled[{
        Rational[1, 2], 
        Rational[1, 2]}], 
      ImageScaled[{0.5, 0.5}]], Automatic, {1, 0}], 
    InsetBox[
     FormBox[
      StyleBox[
      "\"\\!\\(\\*SuperscriptBox[\\(10\\), \\(-36\\)]\\) \
\\!\\(\\*SuperscriptBox[\\(cm\\), \\(2\\)]\\)\"", FontFamily -> "Times", 
       FontColor -> RGBColor[0.85975, 0.360588, 0.406917], StripOnInput -> 
       False], TraditionalForm], 
     NCache[{-Log[10]^(-1) Log[
         Rational[1000, 3]], 27.4}, {-2.5228787452803374`, 27.4}], 
     NCache[
      ImageScaled[{
        Rational[1, 2], 
        Rational[1, 2]}], 
      ImageScaled[{0.5, 0.5}]], Automatic, {1, 0}], 
    InsetBox[
     FormBox[
      StyleBox[
      "\" \\!\\(\\*SuperscriptBox[\\(10\\), \\(-34\\)]\\) \
\\!\\(\\*SuperscriptBox[\\(cm\\), \\(2\\)]\\)\"", FontFamily -> "Times", 
       FontColor -> RGBColor[0.976428, 0.596595, 0.244767], StripOnInput -> 
       False], TraditionalForm], 
     NCache[{-Log[10]^(-1) Log[
         Rational[1000, 3]], 29.4}, {-2.5228787452803374`, 29.4}], 
     NCache[
      ImageScaled[{
        Rational[1, 2], 
        Rational[1, 2]}], 
      ImageScaled[{0.5, 0.5}]], Automatic, {1, 0}], 
    InsetBox[
     FormBox[
      StyleBox[
      "\"\\!\\(\\*SuperscriptBox[\\(10\\), \\(-32\\)]\\) \
\\!\\(\\*SuperscriptBox[\\(cm\\), \\(2\\)]\\)\"", FontFamily -> "Times", 
       FontColor -> RGBColor[0.994495, 0.74088, 0.166335], StripOnInput -> 
       False], TraditionalForm], 
     NCache[{-Log[10]^(-1) Log[
         Rational[1000, 3]], 30.8}, {-2.5228787452803374`, 30.8}], 
     NCache[
      ImageScaled[{
        Rational[1, 2], 
        Rational[1, 2]}], 
      ImageScaled[{0.5, 0.5}]], Automatic, {1, 0}], 
    InsetBox[
     FormBox[
      StyleBox[
      "\"\\!\\(\\*SuperscriptBox[\\(10\\), \\(-30\\)]\\) \
\\!\\(\\*SuperscriptBox[\\(cm\\), \\(2\\)]\\)\"", FontFamily -> "Times", 
       FontColor -> RGBColor[0.968443, 0.894564, 0.147014], StripOnInput -> 
       False], TraditionalForm], {-3, 32.4}, 
     NCache[
      ImageScaled[{
        Rational[1, 2], 
        Rational[1, 2]}], 
      ImageScaled[{0.5, 0.5}]], Automatic, {1, -0.3}], 
    InsetBox[
     FormBox[
      StyleBox[
      "\"Geometric Capture Rate\"", FontFamily -> "Times", FontColor -> 
       GrayLevel[0], StripOnInput -> False], TraditionalForm], 
     NCache[{Log[5]/Log[10], 30.3}, {0.6989700043360186, 30.3}], 
     NCache[
      ImageScaled[{
        Rational[1, 2], 
        Rational[1, 2]}], 
      ImageScaled[{0.5, 0.5}]], Automatic, {1, -0.54}]},
  Frame->True,
  FrameLabel->{
    FormBox[
    "\"\\!\\(\\*SubscriptBox[\\(m\\), \\(\[Chi]\\)]\\) [GeV]\"", 
     TraditionalForm], 
    FormBox[
    "\"\\!\\(\\*SubscriptBox[\\\"\\\\\\\"C\\\\\\\"\\\", \\\"\\\\\\\"\
\[CircleDot]\\\\\\\"\\\"]\\)[\\!\\(\\*SuperscriptBox[\\(s\\), \
\\(-1\\)]\\)]\"", TraditionalForm]},
  FrameStyle->Thickness[0.0045],
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  ImageSize->400,
  LabelStyle->{FontFamily -> "Times"},
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotLabel->FormBox["\"Sun\"", TraditionalForm],
  PlotRange->{{-3.82, 4.83}, {20.77, 35}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{{3.8899450706328373`*^9, 3.88994510077639*^9}, {
   3.889945149751045*^9, 3.889945180620463*^9}, 3.8900426134248447`*^9, 
   3.890291748380796*^9, 3.891933697475442*^9, {3.891934007564389*^9, 
   3.8919340705710573`*^9}, 3.892032424565345*^9, {3.892032775253326*^9, 
   3.892032794743058*^9}, {3.892032828518873*^9, 3.8920328380268517`*^9}, 
   3.892033563040785*^9, 3.8922900950732527`*^9, 3.892290149608849*^9, 
   3.892290236391711*^9, 3.892290288668687*^9, 3.8922903310422363`*^9, 
   3.8922903723802023`*^9, 3.892290417821759*^9, {3.8922905858035307`*^9, 
   3.89229063287155*^9}, {3.8922906786726713`*^9, 3.8922907153133593`*^9}, {
   3.892292509970676*^9, 3.892292535264982*^9}, 3.892299930989567*^9, {
   3.892300415257266*^9, 3.892300433215712*^9}, 3.892300471267198*^9, {
   3.892304371344327*^9, 3.892304500977571*^9}, 3.892304573783346*^9, {
   3.892304619108428*^9, 3.8923046406074257`*^9}, {3.892304681921565*^9, 
   3.892304695802331*^9}, 3.892304818640956*^9, {3.892304951760277*^9, 
   3.892304977480321*^9}, 3.8923050455868196`*^9, {3.892305091166729*^9, 
   3.892305112527323*^9}, {3.892305260023233*^9, 3.89230527649328*^9}, {
   3.8923053845866327`*^9, 3.8923054332224083`*^9}, {3.8923054665904093`*^9, 
   3.892305522622005*^9}, {3.892305875677609*^9, 3.892305909923164*^9}, 
   3.892306288858842*^9, 3.892306432502087*^9, 3.892306805092404*^9, 
   3.892306868366609*^9, 3.892307351799197*^9, {3.892351236251915*^9, 
   3.8923512835341043`*^9}, {3.8923514092482758`*^9, 3.892351415720845*^9}, 
   3.8923515122023582`*^9, 3.8923516294673433`*^9, {3.892357648274185*^9, 
   3.892357661016529*^9}, {3.892357698581094*^9, 3.892357725204064*^9}, {
   3.892357756423201*^9, 3.892357904999584*^9}, 3.8924579496918373`*^9, 
   3.8934206953191843`*^9, {3.89342091746268*^9, 3.89342103188446*^9}, {
   3.89395592778609*^9, 3.893955936227063*^9}, 3.894206587453088*^9, 
   3.8942069994434566`*^9, 3.894207060290078*^9, 3.8942071171844883`*^9, 
   3.894207177787925*^9, {3.8942072892675447`*^9, 3.8942073181056833`*^9}, 
   3.894207396328175*^9, {3.894207456769133*^9, 3.894207475064629*^9}, 
   3.894295870510865*^9, 3.894295905195376*^9, 3.894295945488145*^9, {
   3.894296186529211*^9, 3.894296199712123*^9}, {3.8942964675148067`*^9, 
   3.894296550040362*^9}, {3.894296921986038*^9, 3.894296976942326*^9}, {
   3.8942971086644363`*^9, 3.894297166700193*^9}, {3.89429719707858*^9, 
   3.89429721629634*^9}, {3.894297311660199*^9, 3.894297361681334*^9}, {
   3.894297405323741*^9, 3.894297420704401*^9}, 3.8954001354932213`*^9, {
   3.896520330914719*^9, 3.896520337736341*^9}, 3.8966778852710752`*^9},
 CellLabel->
  "Out[836]=",ExpressionUUID->"75c45290-338d-4856-8d01-f4b5836a8159"]
}, Open  ]]
}, Closed]]
}, Open  ]]
},
WindowSize->{1316, 740},
WindowMargins->{{Automatic, 0}, {Automatic, 25}},
TaggingRules-><|"TryRealOnly" -> False|>,
FrontEndVersion->"13.1 for Mac OS X ARM (64-bit) (June 16, 2022)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"5c340392-fe00-42a4-9c5c-fa2f7fdab0c9"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[580, 22, 375, 8, 160, "Title",ExpressionUUID->"84ab6d8c-d97b-4f4a-9330-55403ae360a2"],
Cell[CellGroupData[{
Cell[980, 34, 289, 4, 67, "Section",ExpressionUUID->"fcc77209-a368-4111-b0ff-7b83154b9b28"],
Cell[1272, 40, 237, 5, 30, "Input",ExpressionUUID->"ad72bb3a-7377-4e71-a94d-7a7aa269d5a3"],
Cell[1512, 47, 456, 8, 52, "Input",ExpressionUUID->"ca605006-ecae-417a-9c02-c494eabb9c8d"],
Cell[1971, 57, 325, 5, 30, "Input",ExpressionUUID->"4cfa6a07-0455-400e-8240-70f70d1d602b"],
Cell[2299, 64, 207, 4, 30, "Input",ExpressionUUID->"6d48c3d8-5266-4359-aac6-3d3c4de5f575"],
Cell[2509, 70, 2370, 51, 178, "Input",ExpressionUUID->"6823d135-2e24-4e4d-8bac-1e4adae3c5de"],
Cell[4882, 123, 261, 6, 30, "Input",ExpressionUUID->"e41e76fc-6b00-466d-9144-0577e68924a0"],
Cell[5146, 131, 275, 7, 30, "Input",ExpressionUUID->"5b2280ae-240c-4193-9de4-6cafc2d93ea3"],
Cell[5424, 140, 303, 8, 30, "Input",ExpressionUUID->"4ff64f86-f618-4929-8a65-21cc35b5ab38"]
}, Closed]],
Cell[CellGroupData[{
Cell[5764, 153, 261, 4, 53, "Section",ExpressionUUID->"cb1541b6-0371-4657-944a-02cba7c33b1b"],
Cell[6028, 159, 393, 7, 30, "Input",ExpressionUUID->"e66e8266-887b-483a-846a-2be432159b9a"],
Cell[6424, 168, 2701, 72, 201, "Input",ExpressionUUID->"d51c7abe-dcb0-4187-bbef-fb04b3657871"],
Cell[9128, 242, 3281, 60, 262, "Input",ExpressionUUID->"db9faa2d-f396-4299-a0ff-f41bf145b180"],
Cell[12412, 304, 178, 3, 30, "Input",ExpressionUUID->"62277ad2-e692-4b16-a966-b2e2ecc6ad24"],
Cell[12593, 309, 422, 11, 30, "Input",ExpressionUUID->"004845b7-fba8-4505-9271-24f72f906b9f"],
Cell[13018, 322, 801, 17, 52, "Input",ExpressionUUID->"213192b1-4a2a-44b5-b847-de62bf8d6cdc"],
Cell[13822, 341, 2121, 39, 178, "Input",ExpressionUUID->"73a645c3-06dc-4308-8e26-c79fc3ab0a11"],
Cell[15946, 382, 753, 19, 73, "Input",ExpressionUUID->"20eb835d-1e27-480b-ad47-5ef5841cab76"]
}, Open  ]],
Cell[CellGroupData[{
Cell[16736, 406, 201, 3, 67, "Section",ExpressionUUID->"ce64a44c-db06-4d1c-b162-639e8b3347b7"],
Cell[16940, 411, 624, 15, 30, "Input",ExpressionUUID->"f662b32f-6349-4cf6-958c-730ba958182f"],
Cell[17567, 428, 329, 7, 30, "Input",ExpressionUUID->"4346a0f2-51f4-47c0-b19e-6aca7dd3fb1e"],
Cell[17899, 437, 2561, 70, 180, "Input",ExpressionUUID->"eb806861-aee8-4d7d-99a8-cc221f15d053"],
Cell[20463, 509, 353, 6, 30, "Input",ExpressionUUID->"4a77dd31-e889-4200-aef9-3d0676f67d8e"],
Cell[20819, 517, 375, 8, 30, "Input",ExpressionUUID->"46c8d485-1245-4e55-a43e-5642e1376d34"],
Cell[CellGroupData[{
Cell[21219, 529, 734, 17, 52, "Input",ExpressionUUID->"bb8222dd-1d02-4203-b6e5-c1b814c45741"],
Cell[21956, 548, 689, 11, 34, "Output",ExpressionUUID->"4a1016a5-3ec5-47a8-a629-789a70f8ee53"]
}, Open  ]],
Cell[22660, 562, 609, 12, 30, "Input",ExpressionUUID->"57bea563-ffff-47a2-a59c-52311ef51c19"],
Cell[CellGroupData[{
Cell[23294, 578, 663, 16, 52, "Input",ExpressionUUID->"f4721d89-b568-41ef-9d95-17c5a59e89be"],
Cell[23960, 596, 614, 10, 34, "Output",ExpressionUUID->"af229265-8e78-42a5-b554-884130aaa95d"]
}, Open  ]],
Cell[24589, 609, 858, 18, 30, "Input",ExpressionUUID->"cee2294f-298a-46e4-b26e-72209ce1b6ed"],
Cell[CellGroupData[{
Cell[25472, 631, 729, 19, 52, "Input",ExpressionUUID->"4f6298c4-7ed6-47e7-9f92-5cef6f3cdb5e"],
Cell[26204, 652, 930, 20, 37, "Output",ExpressionUUID->"501be3e4-9735-405d-9144-f580bdcb4766"]
}, Open  ]],
Cell[27149, 675, 612, 12, 30, "Input",ExpressionUUID->"6c6ac345-9b87-4e2b-9bba-d1ae8072d0af"],
Cell[CellGroupData[{
Cell[27786, 691, 715, 17, 52, "Input",ExpressionUUID->"fdb58d76-b7e8-4cba-9726-d0270a350f7b"],
Cell[28504, 710, 603, 10, 34, "Output",ExpressionUUID->"0889dbd8-77c7-4692-abf1-60b35cc1a327"]
}, Open  ]],
Cell[29122, 723, 497, 11, 30, "Input",ExpressionUUID->"36dc015f-53c9-4b7e-9e39-a8fcd5cbb9cb"],
Cell[CellGroupData[{
Cell[29644, 738, 709, 18, 52, "Input",ExpressionUUID->"9a91f474-0d96-4d22-b6e6-580da5ae2007"],
Cell[30356, 758, 635, 9, 34, "Output",ExpressionUUID->"76c43c6b-c9c8-42b6-bfde-050700d2042c"]
}, Open  ]],
Cell[31006, 770, 391, 9, 30, "Input",ExpressionUUID->"615d5236-97ec-45ec-a679-e49e1bf3b878"],
Cell[CellGroupData[{
Cell[31422, 783, 937, 20, 52, "Input",ExpressionUUID->"24ad005f-43a0-4c13-a43f-77e3174b54cb"],
Cell[32362, 805, 809, 12, 34, "Output",ExpressionUUID->"d0d6aa07-c782-4bc1-8fe4-cbd2b0a63a8f"]
}, Open  ]],
Cell[33186, 820, 151, 3, 30, "Input",ExpressionUUID->"a74b79dd-bccc-480e-8d3a-da93e3307492"]
}, Closed]],
Cell[CellGroupData[{
Cell[33374, 828, 270, 4, 53, "Section",ExpressionUUID->"1cd94e43-03c1-4c5c-a721-f6a3106b8055"],
Cell[33647, 834, 217, 6, 30, "Input",ExpressionUUID->"cfa2221c-9ffb-4898-aa5c-b211dfe3f30b"],
Cell[33867, 842, 212, 6, 30, "Input",ExpressionUUID->"573f02c1-fee7-43ac-8573-877daa4a195c"],
Cell[34082, 850, 352, 11, 30, "Input",ExpressionUUID->"437488cf-abd4-4fb3-9d0c-a82cc3054a62"],
Cell[34437, 863, 1032, 25, 30, "Input",ExpressionUUID->"625481dd-00e2-4efd-ba7d-ad9d5b26b20f"],
Cell[35472, 890, 2083, 47, 73, "Input",ExpressionUUID->"e9bcfa05-481e-4341-bc10-0f99147e4542"],
Cell[37558, 939, 274, 5, 30, "Input",ExpressionUUID->"7422c9ac-4b06-4ee4-bb33-abd9e3a6db3c"],
Cell[37835, 946, 824, 21, 30, "Input",ExpressionUUID->"b0900fbe-81a3-4483-8785-f2d6d85dae0c"],
Cell[38662, 969, 1057, 20, 30, "Input",ExpressionUUID->"cbd9525f-42d0-482b-936e-d4a71c9c60b5"],
Cell[39722, 991, 274, 5, 30, "Input",ExpressionUUID->"bc56470c-b045-4dc6-b552-76c7081745fc"],
Cell[39999, 998, 723, 17, 30, "Input",ExpressionUUID->"0207189e-184d-4194-b65d-f194485c1104"],
Cell[40725, 1017, 1365, 32, 52, "Input",ExpressionUUID->"396cffb8-8983-47dc-bc98-0d42b3ed0889"],
Cell[42093, 1051, 1658, 39, 73, "Input",ExpressionUUID->"d624b9dc-eee8-4750-b3a9-ceb06786b2ea"],
Cell[43754, 1092, 889, 21, 30, "Input",ExpressionUUID->"14b447fa-9e66-44e2-b357-8d5cf93ce3b6"],
Cell[44646, 1115, 2248, 42, 52, "Input",ExpressionUUID->"edc8607a-5ee5-4c3a-931c-bb88eae2dcd3"],
Cell[CellGroupData[{
Cell[46919, 1161, 8535, 204, 217, "Input",ExpressionUUID->"c06e1620-0cec-4a46-90f5-925a72af7653"],
Cell[55457, 1367, 81744, 1411, 408, "Output",ExpressionUUID->"5da3b881-fd44-4ab5-864d-184497ebea64"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[137250, 2784, 506, 7, 53, "Section",ExpressionUUID->"013f83f2-7020-4886-b4fd-e4451065344b"],
Cell[137759, 2793, 281, 6, 30, "Input",ExpressionUUID->"0085fea6-4fc8-44da-96b4-ac209bf5a2ac"],
Cell[138043, 2801, 283, 6, 30, "Input",ExpressionUUID->"b6225b76-5138-40aa-8f5c-b4960c34011a"],
Cell[138329, 2809, 221, 4, 30, "Input",ExpressionUUID->"f0e4c55d-86cf-42bc-a51b-3fc73a9134cc"],
Cell[138553, 2815, 1273, 34, 30, "Input",ExpressionUUID->"9603692f-13c5-4921-8731-bd7f206a029d"],
Cell[139829, 2851, 2398, 50, 73, "Input",ExpressionUUID->"1b14c060-b2de-47e1-80bf-b6fc9826d1d1"],
Cell[142230, 2903, 250, 4, 30, "Input",ExpressionUUID->"08631e7b-1056-46fe-811f-6e2193f7696b"],
Cell[142483, 2909, 773, 19, 30, "Input",ExpressionUUID->"f33fc824-522b-47f6-bec4-50a836465381"],
Cell[143259, 2930, 1223, 22, 30, "Input",ExpressionUUID->"882165b5-b7e7-45de-b01a-cef3b63f75f6"],
Cell[144485, 2954, 248, 4, 30, "Input",ExpressionUUID->"46855c78-5aa3-48f1-93b2-f5171654b3a6"],
Cell[144736, 2960, 630, 15, 30, "Input",ExpressionUUID->"b8c4342f-cf34-4e4d-b4fb-3b1cf458599c"],
Cell[145369, 2977, 1344, 32, 52, "Input",ExpressionUUID->"d8b84ea4-89af-4153-9d74-970f809e7d4d"],
Cell[146716, 3011, 1743, 41, 94, "Input",ExpressionUUID->"b1027fd0-cc76-4ce4-a83d-c4351945aba2"],
Cell[148462, 3054, 938, 21, 30, "Input",ExpressionUUID->"cb7376b6-ba2a-40ca-8bde-e9c10381b667"],
Cell[149403, 3077, 2277, 43, 52, "Input",ExpressionUUID->"933d7f29-fa6c-476b-b2bd-166470c7638b"],
Cell[CellGroupData[{
Cell[151705, 3124, 7877, 187, 240, "Input",ExpressionUUID->"ac7717f8-183c-4a1f-b6d1-a21a72e3a2aa"],
Cell[159585, 3313, 102624, 1751, 410, "Output",ExpressionUUID->"5749ce21-3cde-4e27-91c4-30d7e0c9f928"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[262258, 5070, 582, 8, 53, "Section",ExpressionUUID->"42af45b7-e408-4174-9db0-07bf479410dd"],
Cell[262843, 5080, 279, 7, 30, "Input",ExpressionUUID->"07ef3e85-7058-4bbb-bdbc-57163b3f6771"],
Cell[263125, 5089, 454, 14, 30, "Input",ExpressionUUID->"7fddb728-16a2-40f9-aeb9-ae88bd88327d"],
Cell[263582, 5105, 1011, 33, 30, "Input",ExpressionUUID->"efe237a8-85f5-4406-a2c3-96b562dede7b"],
Cell[264596, 5140, 2187, 48, 73, "Input",ExpressionUUID->"56e2dbf7-85c2-4eb2-bf80-d790f3c1cccc"],
Cell[266786, 5190, 328, 6, 30, "Input",ExpressionUUID->"e8046b54-d06a-4c97-af08-c7127d00805f"],
Cell[267117, 5198, 870, 21, 30, "Input",ExpressionUUID->"27db7f60-fc21-4dad-a5e0-a46f16bcf985"],
Cell[267990, 5221, 1499, 26, 30, "Input",ExpressionUUID->"10994a69-dafc-48d4-84da-c40f733ad544"],
Cell[269492, 5249, 324, 6, 30, "Input",ExpressionUUID->"0d0332a8-ea5a-411f-9e5c-7fe17c645beb"],
Cell[269819, 5257, 721, 17, 30, "Input",ExpressionUUID->"7f5308fd-ab14-4e6c-ac88-c2e0b83b7b03"],
Cell[270543, 5276, 1777, 38, 52, "Input",ExpressionUUID->"09501fdd-0e2c-48eb-b26d-bb5271931aa9"],
Cell[272323, 5316, 1761, 41, 73, "Input",ExpressionUUID->"aea81dcf-476b-49a9-8879-7e226a4c876c"],
Cell[274087, 5359, 1040, 23, 30, "Input",ExpressionUUID->"8de0b952-738a-44ed-a1fa-7b61cec9b64b"],
Cell[275130, 5384, 2428, 44, 52, "Input",ExpressionUUID->"c1bea7ae-af5a-4361-b388-a3573aa3b8c4"],
Cell[CellGroupData[{
Cell[277583, 5432, 8671, 215, 240, "Input",ExpressionUUID->"70e91bd3-3c1a-41c8-b2d9-d6c4ff28a590"],
Cell[286257, 5649, 68488, 1199, 433, "Output",ExpressionUUID->"75c45290-338d-4856-8d01-f4b5836a8159"]
}, Open  ]]
}, Closed]]
}, Open  ]]
}
]
*)

