(* ::Package:: *)

BeginPackage["Asteria`"]

(* process input data according to chosen option *)
DMCapture::usage = "DMCapture[data, option, params...] processes the input data according to the chosen option.
Options:
- 'Normal'
- 'Total'
- 'Reflection'
- 'Geometric'
- 'Total Crosssection'

The number of input parameters for each option is different."

Begin["`Private`"]

(* Unit conversion function *)
ToNatural[x_] := x //. {Mbar -> 4.817850206399999`*^-27 GeV^4, barn ->
       10 ^ -28 * (100 * cm) ^ 2, g -> 5.62 * 10^23 * GeV, 1 / g -> 1 / (5.62
       * 10^23 * GeV), 1 / cm -> 1.98 * 10 ^ -14 * GeV, cm -> 1 / (1.98 * 10
       ^ -14 * GeV), 1 / s -> 6.58 * 10 ^ -25 * GeV, s -> 1 / (6.58 * 10 ^ 
      -25 * GeV), Kel -> 8.621738 * 10 ^ -14 * GeV};

(* Calculation of geometric capture rate, assuming isotropic velocity distribution *)
CGeometrical = (nDM Sqrt[(2 \[Pi]) / 3] R^2 (2 vDM^2 + 3 vesc^2)) / vDM;

(* Calculation of reduced mass *)
\[Mu]red[mSM_, m\[Chi]_] := mSM * m\[Chi] / (mSM + m\[Chi]);

(* Calculation of spin-independent scattering cross section *)
\[Sigma]\[Chi]A[A_, mN_, m\[Chi]_, \[Sigma]el_] := A^2*(\[Mu]red[A* mN, m\[Chi]] / \[Mu]red[mN, m\[Chi]]) ^ 2 * \[Sigma]el;

(* Calculation of optical depth *)
\[Tau]opt[\[Sigma]_, R_, Nn_] = 3 / 2 * (\[Sigma] / \[Sigma]tr) /. {\[Sigma]tr -> Pi * R^2 / Nn};

(* Approximation of integral for fixed number of scatters *)
C1ApproxIntegral = (nDM * Pi * R^2 * Sqrt[6] / (3 * Sqrt[Pi] vDM) ((2
       * vDM^2 + 3 vesc^2) - (2 vDM^2 + 3 vN^2) * Exp[-3 (vN^2 - vesc^2) / 
      (2 * vDM^2)]) //. {vN -> vesc * (1 - \[Beta]plus / 2) ^ (-Nscat / 2), \[Beta]plus
       -> 4 * mDM * mSM / (mDM + mSM) ^ 2});
       
       
(*Normalized capture rate as function of v and m ratios *)
CNormalizedSimple = 1-(E^(3/2 rV^2 (1-((1+\[Mu]^2)/(1+\[Mu])^2)^-Nscat)) (2+3 rV^2 ((1+\[Mu]^2)/(1+\[Mu])^2)^-Nscat))/(2+3 rV^2);
       
(* approximate expression for large \[Tau] as an integral *)
CIntNumFull[\[Mu]In_,rVIn_,\[Tau]_, NTargetsLinear_] := If[\[Tau]<10^8., NIntegrate[(CNormalizedSimple (2Nscat/Min[\[Tau], NTargetsLinear]^2)/.{rV->rVIn,\[Mu]->\[Mu]In}),{Nscat,1, Min[\[Tau], NTargetsLinear]},Method->"Trapezoidal"],


If[\[Mu]In > 1, 

NIntegrate[(Min[1, Abs[(1/(80 (2+3 rV^2) \[Mu]^6) Nscat rV^4 (-Nscat^5 (-2+3 rV^2) (512-4296 rV^2+3816 rV^4-1026 rV^6+81 rV^8)+6 Nscat^4 (256-1560 rV^2+1980 rV^4-756 rV^6+81 rV^8) (-5+\[Mu])-10 Nscat^3 (-64+3 rV^2 (76+9 rV^2 (-6+rV^2))) (22+3 (-4+\[Mu]) \[Mu])+120 Nscat^2 (16-30 rV^2+9 rV^4) (-3+\[Mu] (4+(-3+\[Mu]) \[Mu]))+48 (-5+3 \[Mu]+5 \[Mu]^3 (1+3 (-1+\[Mu]) \[Mu]))-8 Nscat (-4+3 rV^2) (23+15 (-1+\[Mu]) \[Mu] (2+3 (-1+\[Mu]) \[Mu]))))  ]  ]*(2 Nscat/Min[\[Tau], NTargetsLinear]^2)/.{rV->rVIn,\[Mu]->\[Mu]In}),{Nscat,1, Min[\[Tau], NTargetsLinear]},Method->"Trapezoidal"],

NIntegrate[(Min[1, Abs[ (-(1/(8 (2+3 rV^2)))3 Nscat rV^4 \[Mu] (-24+12 (2+Nscat (-4+3 rV^2)) \[Mu]-4 (2+6 Nscat (-4+3 rV^2)+Nscat^2 (16-30 rV^2+9 rV^4)) \[Mu]^2+Nscat (-80+60 rV^2+12 Nscat (16-30 rV^2+9 rV^4)+Nscat^2 (-64+228 rV^2-162 rV^4+27 rV^6)) \[Mu]^3))  ]  ] (2Nscat/Min[\[Tau], NTargetsLinear]^2)/.{rV->rVIn,\[Mu]->\[Mu]In}),{Nscat,1, Min[\[Tau], NTargetsLinear]},Method->"Trapezoidal"]
]
];

(* Calculation of P_N, for fixed number of scatters *)
pmultFixed[Nin_, \[Tau]_]= If[\[Tau] > 0.1, 2(Nin+1)/\[Tau]^2*(1-Gamma[2+Nin,\[Tau]]/Gamma[2+Nin]),(2 (1+Nin) \[Tau]^Nin)/((2+Nin) Gamma[2+Nin])];

       
(* Calculation of number of scatters needed for capture, replaced by expansion for fEnergy -> 0 for numerical stability *)
NscatCaptureEst = Log[vesc^2 / (vDM^2 + vesc^2)] *  If[ \[Mu] < 10^12, 1/ Log[1 - fEnergy] /. {fEnergy
       -> 4 CosThetaSqared \[Mu] / (1 + \[Mu]) ^ 2 }, -1/2*(1 + \[Mu] + \[Mu]^2)/\[Mu]] ;

(*analytic reflection at fixed number of scatterings*)
fTheoretical = 2 / Sqrt[Pi] 1 / Sqrt[NscatCap];

(*best fit parameters from simulations for the reflection coefficient*)
fixN=12;
CLog=1.8;

\[Mu]Transition[vesc_,vDM_]:=1.56 -30.10/(19.47+10.11 Log[Sqrt[vDM^2+vesc^2]/vesc]);
fTransition[vesc_,vDM_]:=0.22+1/(1.27+0.29 Log[Sqrt[vDM^2+vesc^2]/vesc]);

\[Mu]Trans[vescin_,vDMin_]:=\[Mu]in/.FindRoot[(NscatCaptureEst//.{ vesc->vescin,vDM->vDMin,\[Mu]->\[Mu]in, CosThetaSqared->1/2.})==fixN+CLog*Log[Sqrt[vDMin^2+vescin^2]/vescin],{\[Mu]in,10^-4,1}];
       
(*fitted reflection function*)
fCapFittedT[\[Mu]in_,vescin_,vDMin_,\[Mu]T_,fT_]:=Quiet[If[\[Mu]in<\[Mu]Trans[vescin,vDMin],fTheoretical//.{NscatCap->NscatCaptureEst,vesc->vescin,vDM->vDMin, \[Mu]->\[Mu]in,CosThetaSqared->1/2.},If[\[Mu]in<\[Mu]T,( a+b \[Mu]in)/.Solve[a+\[Mu]Trans[vescin,vDMin] b ==( fTheoretical//.{NscatCap->NscatCaptureEst,vesc->vescin,vDM->vDMin, \[Mu]->\[Mu]in,CosThetaSqared->1/2.,\[Mu]in->\[Mu]Trans[vescin,vDMin]})&&
a+b \[Mu]T ==fT][[1]],1/(1+b/\[Mu]in)/.Solve[1/(1+b/\[Mu]T )==fT,b][[1]]]]];

(*capture rate in diffusive regime given reflection *)
ReflectionCoefficient[\[Tau]In_, NNeededForCapture_ , mDM_, mSM_, vescin_, vDMin_] := If[   vescin < 800.,   

   fCapFittedT[mDM / mSM, vescin, vDMin, \[Mu]Transition[vescin,vDMin], fTransition[vescin,vDMin]] , 
   
    If[(fSmallM=(fTheoretical//.{NscatCap->NscatCaptureEst,vesc->vescin,vDM->vDMin, \[Mu]-> mDM/mSM,CosThetaSqared->1/2.})) < 1, fSmallM , 1]
    
        ];
       
(*number of scettering needed for capture on average*)
NscatCapture[vDM_, mDM_, vesc_, mSM_] := (1 + Floor[(Log[vesc^2 / (vDM^2+vesc^2)] / Log[1 - zav \[Beta]] /. {zav -> 1/2, 
            \[Beta] -> 4 mDM mSM / (mDM + mSM) ^ 2})]);
            
(*capture rate fixed number of interactions*)
CNormalized[Nscatin_, vDMin_, mDMin_, vescin_, mSMin_] := ((2 * vDM^2 + 3 * vesc^2 - (2 * vDM^2 + (3 * vesc^2) / (1 - (2 
            * mDM * mSM) / (mDM + mSM) ^ 2) ^ Nscat) / E ^ ((3 * (-vesc^2 + vesc^
            2 / (1 - (2 * mDM * mSM) / (mDM + mSM) ^ 2) ^ Nscat)) / (2 * vDM^2)))
             / (2 * vDM^2 + 3 * vesc^2) /. {Nscat -> Nscatin, vDM -> vDMin, vesc 
            -> vescin, mSM -> mSMin, mDM -> mDMin});

  (*capture rate fixed number of interactions full angular integral*)
CNormalizedFull[Nscatin_, vDMin_, mDMin_, vescin_, mSMin_] := 
          If[
        ((2 mDMin mSMin)/(mDMin+mSMin)^2)(vescin/vDMin)^2 < 10^-5, 
          Nscatin*mDMin*mSMin/(mDMin +mSMin)^2* (9vescin^4)/(vDMin^2 (2 vDMin^2+3 vescin^2)),
        Sum[((((3*2^(1 - 2*Nscat)*(E^((-3*vesc^2*(-1 + 4^(1 - Nscat)*(((mDM + mSM)^2*Log[(mDM + mSM)^2/(mDM - mSM)^2])/(mDM*mSM))^(-1 + Nscat)))/
       (2*vDM^2)) - E^((-3*vesc^2*(-1 + (4^(1 - Nscat)*(mDM + mSM)^2*(((mDM + mSM)^2*Log[(mDM + mSM)^2/(mDM - mSM)^2])/(mDM*mSM))^
            (-1 + Nscat))/(mDM - mSM)^2))/(2*vDM^2)))*mDM*mSM*vesc^2*Log[(mDM + mSM)^2/(mDM - mSM)^2]^(-1 + Nscat))/
        ((mDM*mSM)/(mDM + mSM)^2)^Nscat - 
       (3*(mDM - mSM)^2*(vDM^2/3 + 2^(1 - 2*Nscat)*vesc^2*(((mDM + mSM)^2*Log[(mDM + mSM)^2/(mDM - mSM)^2])/(mDM*mSM))^(-1 + Nscat)))/
        E^((3*vesc^2*(-1 + 4^(1 - Nscat)*(((mDM + mSM)^2*Log[(mDM + mSM)^2/(mDM - mSM)^2])/(mDM*mSM))^(-1 + Nscat)))/(2*vDM^2)) + 
       ((mDM - mSM)^2*vDM^2 + 3*2^(1 - 2*Nscat)*(mDM + mSM)^2*vesc^2*(((mDM + mSM)^2*Log[(mDM + mSM)^2/(mDM - mSM)^2])/(mDM*mSM))^
       (-1 + Nscat))/
       E^((3*vesc^2*(-1 + (4^(1 - Nscat)*(mDM + mSM)^2*(((mDM + mSM)^2*Log[(mDM + mSM)^2/(mDM - mSM)^2])/(mDM*mSM))^(-1 + Nscat))/
       (mDM - mSM)^2))/(2*vDM^2)))/(2*mDM*mSM*(2*vDM^2 + 3*vesc^2))) /. { vDM -> vDMin, vesc 
            -> vescin, mSM -> mSMin, mDM -> If[mDMin ==mSMin, mDMin (1 + 10^-3), mDMin]}),{Nscat,1, Nscatin}]
              ];
              
(* Calculation of total capture rate, summing over all possible numbers of scatters *)
CNormalizedSummed[tauin_, vescIn_, vDMIn_, mDMIn_, mSMIn_, NTargetsLinear_] := 
If[tauin > 3/2.,
    If[tauin < 10^2.,

      Sum[pmultFixed[Nscat, tauin] CNormalized[Nscat, vDMIn, mDMIn, vescIn,
             mSMIn], {Nscat, 1, Max[10, E * Floor[tauin]]}]
    ,
      CIntNumFull[mDMIn/mSMIn,vescIn/vDMIn,tauin,NTargetsLinear]
      ],
     Sum[pmultFixed[Nscat, tauin] CNormalizedFull[Nscat, vDMIn, mDMIn, vescIn,
             mSMIn], {Nscat, 1, Max[10, E * Floor[tauin]]}]
  ];

            
(*capture for multi- and single element system switch*)
            
CElementNormalized[
      OptionNormalized_
      ,(*GeV*)mDMIn_
      ,(*cm^2*)\[Sigma]In_
      ,
      (* km    /s*)vDMIn_
      ,
      nDMIn_(* GeV/cm^3*),(*g*)MObjectIn_
      ,(*cm*)RObjectIn_
      ,
      (*mass fraction of targets *)fElementIn__
      ,(*Nucleons*)MelementIn__
      ] := Module[
			{vescDerived, Mproton, CGeoObject, RateElementNormalized,RateElementNormalizedNoReflection,RateElementNormalizedTotalCrossSection,
             MelementAverage,NTargetsLinearDerived,OpticalDepth,OpticalDepthVector ,OpticalDepthTotalCrossSection},
       
      
      vescDerived = Sqrt[(ToNatural[2 GN MObjectIn / RObjectIn] /. {GN
             -> 1 / (1.22 10^19 GeV) ^ 2})] 300000(*km/s*);
             
      Mproton = 0.94;

      OpticalDepth= Sum[\[Tau]opt[\[Sigma]\[Chi]A[MelementIn[[i]], Mproton, mDMIn, \[Sigma]In] cm^2, RObjectIn, fElementIn[[i]]*ToNatural[MObjectIn] / (MelementIn[[i]]
             * Mproton GeV)],{i,Length[fElementIn]}];
             
      OpticalDepthVector= Table[\[Tau]opt[\[Sigma]\[Chi]A[MelementIn[[i]], Mproton, mDMIn, \[Sigma]In] cm^2, RObjectIn, fElementIn[[i]]*ToNatural[MObjectIn] / (MelementIn[[i]]
             * Mproton GeV)],{i,Length[fElementIn]}];
      
      MelementAverage = 1/OpticalDepth*Sum[OpticalDepthVector[[i]]*MelementIn[[i]], {i, 1, Length[MelementIn]}]; 
                
      OpticalDepthTotalCrossSection= Sum[\[Tau]opt[\[Sigma]In cm^2, RObjectIn, fElementIn[[i]]*ToNatural[MObjectIn] / (MelementIn[[i]]
             * Mproton GeV)],{i,Length[fElementIn]}];
             
            
      NTargetsLinearDerived = (ToNatural[MObjectIn] / (MelementAverage * Mproton GeV))^(1/3.);
    
         (*RateElementNormalized = Min[ ReflectionCoefficient[OpticalDepth, NscatCapture[vDMIn, mDMIn, vescDerived, MelementAverage], mDMIn, MelementAverage,
             vescDerived, vDMIn]  , 
           CNormalizedSummed[OpticalDepth, vescDerived, vDMIn, mDMIn, MelementAverage, NTargetsLinearDerived] ];*)
      
      RateElementNormalized =  If[ OpticalDepth > 3/2.,
           Min[ ReflectionCoefficient[OpticalDepth, NscatCapture[vDMIn, mDMIn, vescDerived, MelementAverage], mDMIn, MelementAverage,
             vescDerived, vDMIn]  , 
           CNormalizedSummed[OpticalDepth, vescDerived, vDMIn, mDMIn, MelementAverage, NTargetsLinearDerived] ],
           Sum[ CNormalizedSummed[OpticalDepthVector[[i]], vescDerived, vDMIn, mDMIn, MelementIn[[i]], NTargetsLinearDerived] , {i, 1, Length[fElementIn]} ]
           ];
           
      RateElementNormalizedTotalCrossSection = Min[ ReflectionCoefficient[OpticalDepthTotalCrossSection, NscatCapture[vDMIn, mDMIn, vescDerived, MelementAverage], mDMIn, MelementAverage,
             vescDerived, vDMIn]  , 
           CNormalizedSummed[OpticalDepthTotalCrossSection, vescDerived, vDMIn, mDMIn, MelementAverage, NTargetsLinearDerived] ];
            
      RateElementNormalizedNoReflection =  If[ OpticalDepth > 3/2., 
           CNormalizedSummed[OpticalDepth, vescDerived, vDMIn, mDMIn, MelementAverage, NTargetsLinearDerived],
           Sum[ CNormalizedSummed[OpticalDepthVector[[i]], vescDerived, vDMIn, mDMIn, MelementIn[[i]], NTargetsLinearDerived] , {i, 1, Length[fElementIn]} ]
           ];
                      
      CGeoObject = s CGeometrical //. {vDM -> vDMIn km / s, vesc -> vescDerived
             km / s, R -> RObjectIn, km -> 10^5. cm, nDM -> nDMIn GeV / cm^3 1 / 
            (GeV mDMIn)};


             
      Switch[OptionNormalized,
            "Normal no Reflection",
                  output = RateElementNormalizedNoReflection;
                  ,
             "Normal",
                  output = RateElementNormalized;
            ,
            "Total",
                  output = RateElementNormalized * CGeoObject;
            ,
            "Reflection",
                  output = If[OpticalDepth>3/2, ReflectionCoefficient[OpticalDepth, NscatCapture[vDMIn, mDMIn, vescDerived, MelementAverage], mDMIn, MelementAverage,
             vescDerived, vDMIn]  ,"Invalid regime, optical depth is below 3/2"];
            ,
            "Geometric",
                  output =  CGeoObject;
            ,
            "Total Crosssection",
                  output =  RateElementNormalizedTotalCrossSection* CGeoObject;
            ,
            _,
                  output = "Invalid option";
      ];
      
      output
]

CElementNormalizedInputCrossSection[
      OptionNormalized_
      ,(*GeV*)mDMIn_
      ,(*cm^2*)\[Sigma]In_
      ,
      (* km    /s*)vDMIn_
      ,
      nDMIn_(* GeV/cm^3*),(*g*)MObjectIn_
      ,(*cm*)RObjectIn_
      ,
      (*mass fraction of targets *)fElementIn__
      ,(*Nucleons*)MelementIn__
      , (*Cross section weights for spin dependent interactions*) \[Sigma]ElementScaling__
      ] := Module[
			{vescDerived, Mproton, CGeoObject,RateElementNormalizedTotalCrossSection,
             MelementAverage,NTargetsLinearDerived,OpticalDepthVectorTotalCrossSection ,OpticalDepthTotalCrossSection},
       
      
      vescDerived = Sqrt[(ToNatural[2 GN MObjectIn / RObjectIn] /. {GN
             -> 1 / (1.22 10^19 GeV) ^ 2})] 300000(*km/s*);
             
      Mproton = 0.94;
             
      OpticalDepthVectorTotalCrossSection= Table[\[Tau]opt[ \[Sigma]ElementScaling[[i]] \[Sigma]In  cm^2, RObjectIn, fElementIn[[i]]*ToNatural[MObjectIn] / (MelementIn[[i]]
             * Mproton GeV)],{i,Length[fElementIn]}];
                
      OpticalDepthTotalCrossSection= Sum[\[Tau]opt[ \[Sigma]ElementScaling[[i]] \[Sigma]In  cm^2, RObjectIn, fElementIn[[i]]*ToNatural[MObjectIn] / (MelementIn[[i]]
             * Mproton GeV)],{i,Length[fElementIn]}];
             
      MelementAverage = 1/OpticalDepthTotalCrossSection*Sum[OpticalDepthVectorTotalCrossSection[[i]]*MelementIn[[i]], {i, 1, Length[MelementIn]}]; 
            
      NTargetsLinearDerived = (ToNatural[MObjectIn] / (MelementAverage * Mproton GeV))^(1/3.);

           
      RateElementNormalizedTotalCrossSection = If[ OpticalDepthTotalCrossSection > 3/2.,
           Min[ ReflectionCoefficient[OpticalDepthTotalCrossSection, NscatCapture[vDMIn, mDMIn, vescDerived, MelementAverage], mDMIn, MelementAverage,
             vescDerived, vDMIn]  , 
           CNormalizedSummed[OpticalDepthTotalCrossSection, vescDerived, vDMIn, mDMIn, MelementAverage, NTargetsLinearDerived] ],
           Sum[ CNormalizedSummed[OpticalDepthVectorTotalCrossSection[[i]], vescDerived, vDMIn, mDMIn, MelementIn[[i]], NTargetsLinearDerived] , {i, 1, Length[fElementIn]} ]
           ];
      
      CGeoObject = s CGeometrical //. {vDM -> vDMIn km / s, vesc -> vescDerived
             km / s, R -> RObjectIn, km -> 10^5. cm, nDM -> nDMIn GeV / cm^3 1 / 
            (GeV mDMIn)};


             
      Switch[OptionNormalized,
            "Total Crosssection",
                  output =  RateElementNormalizedTotalCrossSection* CGeoObject;
            ,
            _,
                  output = "Invalid option";
      ];
      
      output
]

(*choose option*)
DMCapture[data__, option_, params__] := Module[{result},
      Switch[option,
            "Normal no Reflection",
                  result = Option0[data, params]
            , 
            "Normal",
                  result = Option1[data, params]
            ,
            "Total",
                  result = Option2[data, params]
            ,
            "Reflection",
                  result = Option3[data, params]
            ,
            "Geometric",
                  result = Option4[data, params]
            ,
            "Total Crosssection",
                  result = Option5[data, params]
            ,
            _,
                  result = "Invalid option"
      ];
      
     If[ data[[1]]>10^-4, result , "Error: out of range of validity, dark matter mass below 0.1 MeV, collective effects will contribute."]
     
]
(*define global output functions*)

Option0[data_, param1_, param2_] := CElementNormalized[(*normalized no reflection*)
      "Normal no Reflection"
      ,(*GeV*)data[[1]]
      ,
      (*cm^2*)data[[2]]
      ,(* km/s*)data[[3]]
      ,
      1(*data[[6]]*)(*DM densidy  GeV/cm^3*),
      (*mass g*)data[[4]] g
      ,(* radius cm*)data[[5]] cm
      ,(*fractions*)param1
      ,
      (*Nucleons*)param2
]//Quiet

Option1[data_, param1_, param2_] := CElementNormalized[(*normalized*)
      "Normal"
      ,(*GeV*)data[[1]]
      ,
      (*cm^2        *)data[[2]]
      ,(* km/s*)data[[3]]
      ,
      1(*data[[6]]*)(*DM densidy  GeV/cm^3*),
      (*mass g*)data[[4]] g
      ,(* radius cm*)data[[5]] cm
      ,(*fractions*)param1
      ,
      (*Nucleons*)param2
] //Quiet

Option2[data_, param1_, param2_] := If[(NumericQ[data[[6]]] == True) 
      ,
      CElementNormalized[(*normalized*)"Total"
            ,(*GeV*)data[[1]]
            ,
            (*cm            ^2*)data[[2]]
            ,(* km/s*)data[[3]]
            ,
            data[[6]](*DM densidy  GeV/cm^3*),
            (* mass g*)data[[4]] g
            ,(* radius cm*)data[[5]] cm
            ,(*fractions*)param1
            ,
            (*            Nucleons*)param2
      ] 
      ,
      "Error: please enter dark matter density in GeV/cm^3 as #6 entry"
            
]//Quiet

Option3[data_, param1_, param2_] := 1 - CElementNormalized[
      (*normalized    *)"Reflection"
      ,(*GeV*)data[[1]]
      ,
      (*cm^2*)data[[2]]
      ,(* km/s*)data[[3]]
      ,
      1(*data[[6]]*)(*DM densidy  GeV        /cm^3*),(*mass g*)data[[4]] g
      ,(* radius cm*)data[[5]] cm
      ,(*fractions*)
      param1
      ,(*Nucleons*)param2
]//Quiet

Option4[data_, param1_, param2_] := If[(NumericQ[data[[6]]] == True) 
      ,
      CElementNormalized[(*Geometric*)"Geometric"
            ,(*GeV*)data[[1]]
            ,
            (*cm            ^2*)data[[2]]
            ,(* km/s*)data[[3]]
            ,
            data[[6]](*DM densidy  GeV/cm^3*),
            (*            mass g*)data[[4]] g
            ,(* radius cm*)data[[5]] cm
            ,(*fractions*)param1
            ,
            (*            Nucleons*)param2
      ]  
      ,
      "Error: please enter dark matter density in GeV/cm^3 as #6 entry"
            
]//Quiet

Option5[data_, param1_, param2_, param3_] := CElementNormalizedInputCrossSection[
      (*Total with fixed \[Sigma] *)"Total Crosssection"
      ,(*GeV*)data[[1]]
      ,
      (*cm^2*)data[[2]]
      ,(* km/s*)data[[3]]
      ,
       data[[6]](*DM densidy  GeV/cm^3*),
       (*mass g*)data[[4]] g
      ,(* radius cm*)data[[5]] cm
      ,(*fractions*)
      param1
      ,(*Nucleons*)param2
      ,(*Cross section weights*)param3
]//Quiet  

End[]

EndPackage[]







