#!/usr/bin/env python3


#program to find the median zero-point value
from astropy.table import Table
from astropy.io import ascii
import numpy as np
import matplotlib.pyplot as plt


data = Table.read('panR_new.dat', format = 'ascii')


data['R_p'] = data['Rmag']
data['R_e_p'] = data['Rerr'] 
data['R_s'] = data['r_s']
data['R_e_s'] = data['r_e_s']




#defining a temp file and storing the PanSTARRS and psfphotmetry magnitude difference to it!
temp = []
temp = data['R_p'] - data['R_s']

#calculating the mean and median of the difference
m = np.median(temp)
mean = np.mean(temp)

#defining a final table and assinging the values to the new tables
final = Table()
final['diff'] = temp 
final['R_source'] = data['R_s']
final['serr'] =  data['R_e_s']
final['R_pan'] = data['R_p']
final['perr'] = data['R_e_p']
final['R_new'] = data['R_s'] + m #adding the median value
final['c_diff'] = final['R_new'] - final ['R_pan'] 
#defining the error on the differnce value
final['differr'] = np.sqrt(np.square(data['R_e_s'])+ np.square(data['R_e_p']))

#plotting to see the difference values with respect to the corrected magnitude
plt.clf()
plt.errorbar(final['R_new'],final['c_diff'], yerr = final['differr'] , fmt='.', ecolor='orange')
plt.xlabel('corrected_magnitude')
plt.ylabel('pan-psf phot difference')
plt.title('All sources for calculating the ZP')
plt.show()
 
outliers_out = Table()
out = Table()
#throwing away the the points having high c_diff
out = final[abs(final['c_diff']) < 0.3]
print(out)

#plotting again to see the point used for final calculation of the ZP
plt.clf()
plt.errorbar(out['R_new'],out['c_diff'], yerr = out['differr'] , fmt='.', ecolor='blue')
plt.xlabel('corrected_magnitude')
plt.ylabel('pan-psf phot difference')
plt.title('Sources for calculating the ZP having difference less than 0.2 mag')
plt.show()
 
median_new = np.median(out['diff'])
n = len(out['diff'])
print(n)
meanerr = np.sqrt(np.sum(np.square(out['differr'])))/n
print(np.mean(out['diff']))
print("ZP is",median_new,"+-",meanerr)




