#program to transform Sln r and slni magnitude to R magnitude


from astropy.table import Table
from astropy.io import ascii
import numpy as np


#reading the Pan table 
data = Table.read('r_zp.dat', format = 'ascii')
data1 = Table.read('i_zp.dat', format = 'ascii')




#transformation equation: https://www.sdss.org/dr12/algorithms/sdssUBVRITransform/#Lupton2005
data['Rmag']= np.around(data['r_p'] - 0.2936*(data['r_p'] - data1['i_p']) - 0.1439, decimals = 4)

#error calculation
data['Rerr'] = np.around(np.sqrt((0.7064*np.square(data['r_e_p']))+(0.2936*np.square(data1['i_e_p']))), decimals = 4)



ascii.write(data, 'panR.dat') 