from astropy.io import fits
import numpy as np
import scipy.stats as st
import matplotlib.pyplot as plt
from math import *
from numpy import *
import time
from decimal import *
from matplotlib.gridspec import GridSpec
from mpl_toolkits.axes_grid1.inset_locator import zoomed_inset_axes
from matplotlib.ticker import ScalarFormatter
from datetime import date
import matplotlib.patches as patches
from scipy.odr import *
from scipy.optimize import curve_fit
from sklearn.decomposition import PCA
from scipy.special import wofz
import pylab
from scipy.odr import ODR, Model, Data, RealData
import matplotlib.collections as mcoll
from mpl_toolkits.axes_grid1.inset_locator import zoomed_inset_axes
from mpl_toolkits.axes_grid1.inset_locator import mark_inset
from astropy.stats import *
import scipy.optimize as op
#plt.style.use('classic')
#%matplotlib notebook

# A function to query CSC2.0 for a given obsID
import requests
from io import BytesIO
from astropy.io import votable
from astropy.coordinates import SkyCoord
from astropy.table import Table
from astropy import wcs
from astropy.io import fits

from astropy import units as u
from astropy.coordinates import SkyCoord
from astropy.io import ascii







#SM_SDSS_low_z_li=np.array(SM_SDSS_low_z)
#SM_SDSS_low_z_li=np.log10(SM_SDSS_low_z_li)
#SFR_SDSS_low_z_li=np.array(SFR_SDSS_low_z)
#SFR_SDSS_low_z_li=np.log10(SFR_SDSS_low_z_li)


#SM_SDSS_high_z_1_li=np.array(SM_SDSS_high_z_1)
#SM_SDSS_high_z_1_li=np.log10(SM_SDSS_high_z_1_li)
#SFR_SDSS_high_z_1_li=np.array(SFR_SDSS_high_z_1)
#SFR_SDSS_high_z_1_li=np.log10(SFR_SDSS_high_z_1_li)

#SFR_SDSS_total_li=np.array(SFR_SDSS_total)
#SFR_SDSS_total_li=np.log10(SFR_SDSS_total_li)
#SM_SDSS_total_li=np.array(SM_SDSS_total)
#SM_SDSS_total_li=np.log10(SM_SDSS_total_li)


import seaborn as sns
import matplotlib.pyplot as plt
sns.set_style("darkgrid")


#fig=plt.figure(figsize=(7,7))
#fig.patch.set_facecolor('white')
#sns.kdeplot(SM_SDSS_total_li,SFR_SDSS_total_li,cmap="gray_r", shade=True, bw_adjust=.5)

'''
M=10**np.linspace(np.log10(1e4), np.log10(1e13), 40)
SFR=M*10**(-10-0.1*(np.log10(M)-10.))
M=np.array(M)
M=np.log10(M)
SFR=np.array(SFR)
SFR=np.log10(SFR)
plt.plot(M,SFR,'-',zorder=3,color='aqua',linewidth=3.0)

z=0.0
M=10**np.linspace(np.log10(1e4), np.log10(1e13), 40)
Log_SFR=-0.49+0.65*(np.log10(M)-10)+1.07*(z-0.1)
M=np.log10(M)
plt.plot(M,Log_SFR,'--',zorder=3,color='r',linewidth=2.0)
plt.text(7.0,-2.9,'$z=0.0$',color='r',fontsize=20,zorder=3)

z=0.1
M=10**np.linspace(np.log10(1e4), np.log10(1e13), 40)
Log_SFR=-0.49+0.65*(np.log10(M)-10)+1.07*(z-0.1)
M=np.log10(M)
plt.plot(M,Log_SFR,'--',zorder=3,color='royalblue',linewidth=2.0)
plt.text(7.8,-2.9,'$0.1$',color='royalblue',fontsize=20,zorder=3)

z=0.2
M=10**np.linspace(np.log10(1e4), np.log10(1e13), 40)
Log_SFR=-0.49+0.65*(np.log10(M)-10)+1.07*(z-0.1)
M=np.log10(M)
plt.plot(M,Log_SFR,'--',zorder=3,color='orange',linewidth=2.0)
plt.text(8.2,-2.9,'$0.2$',color='orange',fontsize=20,zorder=3)

z=0.3
M=10**np.linspace(np.log10(1e4), np.log10(1e13), 40)
Log_SFR=-0.49+0.65*(np.log10(M)-10)+1.07*(z-0.1)
M=np.log10(M)
plt.plot(M,Log_SFR,'--',zorder=3,color='seagreen',linewidth=2.0)
plt.text(8.6,-2.9,'$0.3$',color='seagreen',fontsize=20,zorder=3)

z=0.4
M=10**np.linspace(np.log10(1e4), np.log10(1e13), 40)
Log_SFR=-0.49+0.65*(np.log10(M)-10)+1.07*(z-0.1)
M=np.log10(M)
plt.plot(M,Log_SFR,'--',zorder=3,color='k',linewidth=2.0)
plt.text(9.0,-2.9,'$0.4$',color='k',fontsize=20,zorder=3)
'''

#########################################
#LGRBs
lGRB_M_star=[9,8.65,8.52,9.19,9.59,9.21,8.49,9.33,9.42,9.48,10.20,9.29,8.53,9.31,9.26,9.32,9.52, 8.82,9.69,
            9.81,9.77,11.51,9.75,8.66,10.50,8.87,10.20,10.32,10.87,8.83,7.74,8.82,8.82,9.20,8.66,9.98,9.73,
            9.78,9.84,8.1,9.79,9.69,10.42,9.04,10.14,7.78,9.90,10.33,9.41,7.95,9.95,10.1,9.13,9.99,9.23,11.01,
            10.08,8.5,10.31,9.11,10.39,10.49,9.7,11.08,11.05,8.07,11.02,9.2,9.58,9.6,9.9,9.7,9.82,10.57,11.2,
            9.24,10.18,9.54,9.38,9.98,10.1,9.52,8.3,8.95,9.54,8.98,10.68,9.68,10.5,9.3,8.95,10.6,8.3,9.9,9,
            7.9,9.5]

lGRB_SFR=[0.35,0.53,1.14,0.87,11.40,0.21,4.70,7.03,5.72,2.50,6.96,2.39,19.63,2.28,10.35,1.57,4.46,0.34,2.50,2.24,
         0.8,2.7,4.29,6.76,12.5,2.65,40,1.4,1.6,3.20,0.11,9.96,12.68,0.85,0.34,0.06,1.65,19.7,4.5,0.07,9.13,72.1,
         60,5.8,45.5,0.05,17.6,8.3,0.43,0.01,19.9,7.1,0.96,54,5.1,88.4,26,0.05,2.38,2.7,101,26,24,32,77,0.13,
         47,2.1,15.5,47,39.81,45,11.8,35,24,4.8,13.8,0.5,0.56,8.0,26,1.29,0.37,1.7,4.2, 8.7,23,0.16,34,43,1.38,
          30,6,37,0.34,0.05,2.9]


lGRB_M_star=np.asarray(lGRB_M_star)
lGRB_SFR=np.asarray(lGRB_SFR)
lGRB_SFR=np.log10(lGRB_SFR)

plt.plot(lGRB_M_star,lGRB_SFR,'o',markersize=7,color='#fde725',label='$\mathrm{LGRBs}$',zorder=1)


###############################################
#low luminosity GRBs 4.8 8.26
Low_Lumin_GRB_SFR=[np.log10(0.3),np.log10(1.0),np.log10(0.065),np.log10(0.03),np.log10(4.11),np.log10(1.7),
                  np.log10(1.2),np.log10(4.8)]
Low_Lumin_GRB_M=[np.log10(10**8.7),np.log10(3.3e10),np.log10(1e7),8.37,10.10,8.79,7.91,8.26]
plt.plot(Low_Lumin_GRB_M,Low_Lumin_GRB_SFR,'o',markersize=7,color='#90d743',label='$\mathrm{LL-LGRBs}$',zorder=1)

##############################################3
#SGRBs
SGRB=ascii.read('SGRBs_host_properties_fong.txt')

SGRB = SGRB[SGRB['col3'] > 0]

sGRB_M_star = SGRB['col2']
sGRB_SFR = SGRB['col3']



#sGRB_M_star=[11.08,8.66,10.64,8.61,9.1,10.43,9.6,9.1,10.4,9.4,10.1,10.4,10.81,9.7,10.3,10.7,9.15,9.23]

#sGRB_SFR=[16.87,0.14,18.76,2.11,6.1,0.17,1.2,2.5,1.1,0.4,2.5,0.6,14.4,0.6,0.1,30,16,4.85]

sGRB_M_star=np.asarray(sGRB_M_star)
sGRB_SFR=np.asarray(sGRB_SFR)
sGRB_SFR=np.log10(sGRB_SFR)

plt.plot(sGRB_M_star,sGRB_SFR,'o',markersize=7,color='#f98e09',label='$\mathrm{SGRBs}$',zorder=1)


##################################################

I_a_M=[771018739.7351618 ,3570724221.327179 ,236202937083.52957 ,1183879.5375834615 ,5283310229.446987 ,
131867040981.65053 ,30157536796.350243 ,195875782037.3866 ,149275761.71821076 ,118011467131.70012 ,
103208792660.91563 ,33523152185.425514 ,32675994990.057514 ,38556002098.73331 ,67374861690.04758 ,
110277559015.99327 ,11392465886.698395 ,7673837999.014014 ,46160489014.99372 ,56337090031.87971 ,
16945800154.942572 ,11182899462.194582 ,63667373070.87042 ,95740416844.44075 ,72538571744.56674 ,
31096331674.777973 ,5763115327.699927 ,199996561780.97284 ,90810004565.34221 ,13378535548.712116 ,
23390963895.18475 ,8252253694.839424 ,22552674480.228584 ,8131890760.984015 ,4560793941.127705 ,
20365501595.60561 ,8530921411.350611 ,75068339595.30215 ,32462439204.387 ,24767750616.281246 ,
10456751369.81397 ,14109924461.07819 ,77081898069.11542 ,22549109049.595566 ,12818682742.513891 ,
97041084785.76027 ,97946457096.40852 ,28120328238.576553 ,45281021332.884285 ,967555334.634301 ,
79205799284.55331 ,18341843906.03647 ,64611438481.55319 ,2538556255.454121 ,110777782461.97925 ,
20180088084.02649 ,1334942414.8960526 ,35141803896.44812 ,46263793568.52374 ,38395809541.57836 ,
26065334863.501633 ,129992502487.39392 ,8921865371.867403 ,118771900823.81651 ,133284223926.10394 ,
42695355152.15907 ,118362609393.34525 ,18552566927.397568 ,59134256647.81158 ,28349297729.4606 ,
84506921399.81079 ,37672218334.75224 ,41828322841.62748 ,57914186172.412415 ,51672526536.14908 ,
321261605.7032507 ,80575548388.98586 ,118521783926.77257 ,14005647023.863426 ,5368083934.717458 ,
57625205584.14874 ,101868173851.94502 ,29319876203.48422 ,1081665313.5594943 ,57032273155.9882 ,
111025696849.42354 ,358336272287.35834 ,51285241951.25021 ,47330838192.66445 ,5177395335.778869 ,
24439967501.890724 ,5771727372.655853 ,3550387882.2719846 ,44389544958.55821 ,8844793510.247833 ,
160391768315.2411 ,12621512799.522512 ,67172622888.19041 ,37131393582.28561 ,41164960434.861725 ,
297045613166.23816 ,45969306984.39576 ,177116713231.21906 ,588169689201.7722 ,182190889888.6176 ,
31931690868.14229 ,46531036761.307495 ,71422666405.13748 ,99533580556.91556 ,3432896767.4692135 ,
190037831023.80637 ,40558760912.89257 ,37564251721.022896 ,116902908770.43263 ,1544854549.3481624 ,
48148933276.90107 ,41690039872.36386 ,2727425324.4266324 ,25170689870.080654 ,67250107908.08888 ,
93479931136.24059 ,431275844.82517576 ,15939916359.041025 ,30469729515.322304 ,50907119787.16747 ,
67494214621.78753 ,11031873394.946259 ,87904617441.38515 ,75688391170.16754]

I_a_SFR=[0.0058488442284794695 ,0.05924205233719897 ,0.21807209663688054 ,0.006743417857005361 ,
0.5698625303483492 ,0.3309025242658153 ,1.9783817493099973 ,0.5066173806756255 ,
0.16012903927323846 ,0.27081334209450797 ,0.030660555161430077 ,1.3833118194243532 ,0.0883832820654743 ,
9.59599726569973 ,1.8404757485887877 ,0.13337366796863612 ,1.8507600119198921 ,1.0801649858795639 ,
2.575076205110969 ,0.07061713490838291 ,1.9139478004959707 ,1.8629881278330653 ,0.17779111623231492 ,
0.12985541482474233 ,0.31847114275016747 ,0.990991871112846 ,0.4024668359233962 ,1.0015902602470161 ,
11.597119390393491 ,0.3100131353997099 ,3.802507491701032 ,0.4000369469286732 ,0.09006582705966147 ,
1.484807300204043 ,0.04943334887879377 ,7.2296965795679045 ,2.602076727103041 ,0.5084521305989597 ,
0.03126727316018255 ,4.664660955628559 ,2.1006325211885857 ,0.5941691382108366 ,0.05428377515813324 ,
2.091318052649896 ,0.05441768540062036 ,3.7950728424417783 ,0.12121324993289237 ,5.518233454572336 ,
1.5617089645816782 ,0.015435121779388673 ,0.11214504015615435 ,2.8177996073491673 ,0.04760033834477851 ,
0.30999173465517293 ,12.51180824500405 ,0.024724644963513974 ,0.08280184943549135 ,1.126990071067265 ,
0.15766673635393358 ,0.852020603019927 ,0.06827002554366643 ,0.12698430608284214 ,1.1490266367687754 ,
1.5922823965612092 ,0.6647526672059128 ,1.1977607761255198 ,0.1564624353096601 ,1.1398562650909096 ,
0.06595990604357187 ,6.96835249977003 ,0.16369299205085952 ,3.1551506439364823 ,0.29781741384171084 ,
0.2955630073608049 ,3.486423133000067 ,0.03854074411677653 ,0.059210676294956174 ,0.08713850486744215 ,
0.7801715179827137 ,0.5432504612238297 ,1.1554205697950561 ,0.07850187978717763 ,0.04716285396022923 ,
0.2754673256178255 ,14.716687989403185 ,0.04481774878602245 ,0.2991163080231598 ,0.10354999212241282 ,
1.6147306740903051 ,1.0552129073002947 ,1.2882498372340625 ,0.5565319527128494 ,0.4130571076463423 ,
1.0185212419955934 ,0.9003888242756317 ,0.08806432674812045 ,2.5711066982349458 ,1.6405145842039337 ,
4.409507708983769 ,4.482704391300534 ,1.4518110142155045 ,8.399434858331809 ,0.10879028120449676 ,
0.17672992859509062 ,5.122713580071219 ,0.026716533338289872 ,1.3516370576397487 ,0.11965203221466066 ,
2.658398553222801 ,1.26587287979915 ,0.12274959656234095 ,0.702085652905136 ,4.745698116797681 ,
0.34640973676289405 ,0.14164136457326693 ,0.7255378789326333 ,2.8002068000497227 ,0.5106814570127068 ,
0.4232043064897652 ,3.1014878580012386 ,2.1925530068868895 ,0.08343150818010303 ,0.18021878954134582 ,
2.2338299252507614 ,0.35016287405671576 ,0.14349940474575482 ,0.13299339726094084 ,2.0240446300075576 ,
0.05171542125541821]



# Nov 28 updated the Sn list from Schulze+21 paper. col18 is log SFR and col21 is log M

SNIb=ascii.read('SNIb.dat')

SNIb_M_star = SNIb['col21']
SNIb_SFR = SNIb['col18']


SNIb_M_star=np.asarray(SNIb_M_star)
SNIb_SFR=np.asarray(SNIb_SFR)
#SNIb_SFR=np.log10(SNIb_SFR)

plt.plot(SNIb_M_star,SNIb_SFR,'o',markersize=7.0,color='#31688e',label='$\mathrm{SN\ Ib}$',zorder=1, alpha=.25)




SNIc=ascii.read('SNIc.dat')

SNIc_M_star = SNIc['col21']
SNIc_SFR = SNIc['col18']


SNIc_M_star=np.asarray(SNIc_M_star)
SNIc_SFR=np.asarray(SNIc_SFR)
#SNIc_SFR=np.log10(SNIc_SFR)

plt.plot(SNIc_M_star,SNIc_SFR,'o',color='#443983',label='$\mathrm{SN\ Ic}$',markersize=7.0,zorder=1, alpha=.25)


SNII=ascii.read('SNII.dat')

SNII_M_star = SNII['col21']
SNII_SFR = SNII['col18']


SNII_M_star=np.asarray(SNII_M_star)
SNII_SFR=np.asarray(SNII_SFR)
#SNII_SFR=np.log10(SNII_SFR)

plt.plot(SNII_M_star,SNII_SFR,'o',markersize=7.0,label='$\mathrm{SN\ II}$',color='#440154',zorder=1, alpha=.25)


'''
Galva_Ib_SFR=[1.24,3.63,1.30,4.05,1.74]
Galva_Ib_M=[10**9.80,10**10.79,10**9.90,10**10.82,10**10.59]


Galva_Ic_SFR=[3.16,6.12,0.30,0.76,2.45,3.46,0.66,5.21,0.10,4.99]
Galva_Ic_M=[10**9.81,10**10.40,10**9.29,10**10.28,10**10.82,10**10.59,10**9.52,10**10.83,10**9.13,10**11.00]

Galva_II_SFR=[0.22,3.46,7.78,3.32,7.53,3.54,7.28,4.08,13.48,3.59,0.31,1.22,5.21,1.30,1.36,1.04,1.36,1.13,
              2.15,0.25,0.39,0.91,1.38,1.48,1.38,0.34,4.95,0.85,1.22,0.78,1.88,6.37]
Galva_II_M=[10**8.84,10**10.59,10**10.89,10**11.02,10**11.32,10**10.21,10**10.99,10**10.59,10**10.89,10**10.64,
            10**9.03,10**9.34,10**10.83,10**10.99,10**11.35,10**10.28,10**11.35,10**10.14,10**10.46,10**9.73,  
            10**9.63,10**11.01,10**10.23,10**10.62,10**10.23,10**10.02,10**11.13,10**10.48,10**9.34,10**10.45,  
            10**10.43,10**10.69]

'''
I_a_M,I_a_SFR=np.array(I_a_M),np.array(I_a_SFR)
I_a_M,I_a_SFR=np.log10(I_a_M),np.log10(I_a_SFR)
plt.plot(I_a_M,I_a_SFR,'o',markersize=7.0,color='#21918c',
                   label='$\mathrm{SN\ Ia}$',zorder=1)
'''
Galva_Ib_M,Galva_Ib_SFR=np.array(Galva_Ib_M),np.array(Galva_Ib_SFR)
Galva_Ib_M,Galva_Ib_SFR=np.log10(Galva_Ib_M),np.log10(Galva_Ib_SFR)
plt.plot(Galva_Ib_M,Galva_Ib_SFR,'o',markersize=7.0,color='#31688e',label='$\mathrm{SN\ Ib}$',zorder=1)

Galva_Ic_M,Galva_Ic_SFR=np.array(Galva_Ic_M),np.array(Galva_Ic_SFR)
Galva_Ic_M,Galva_Ic_SFR=np.log10(Galva_Ic_M),np.log10(Galva_Ic_SFR)
plt.plot(Galva_Ic_M,Galva_Ic_SFR,'o',color='#443983',label='$\mathrm{SN\ Ic}$',markersize=7.0,zorder=1)

Galva_II_M,Galva_II_SFR=np.array(Galva_II_M),np.array(Galva_II_SFR)
Galva_II_M,Galva_II_SFR=np.log10(Galva_II_M),np.log10(Galva_II_SFR)
plt.plot(Galva_II_M,Galva_II_SFR,'o',markersize=7.0,label='$\mathrm{SN\ II}$',color='#440154',zorder=1)
'''
##############################################################################################33
'''
#SN2020bvc
M=10.28
SFR=np.log10(0.08)
plt.plot(M,SFR,'+',color='orange',label='$\mathrm{SN2020bvc}$',mew=5,ms=18,zorder=1)
'''

#Gw170817
M=np.log10(0.75e11)
SFR=np.log10(4e-3)
plt.plot(M,SFR,'P',color='#bc3754',label='$\mathrm{GW170817}$',markersize=7.0,zorder=1)

#######################################################################################################33

#Local Sample Paper I

x_local=[np.log10(7.9e11),np.log10(1.3e11),np.log10(1e11),np.log10(7.4e8),np.log10(6.3e10),np.log10(2.5e10),]
y_local=[np.log10(0.01),np.log10(2.17),np.log10(1),np.log10(0.07),np.log10(3.2),np.log10(1.37),]

plt.plot(x_local,y_local,'D',color='#b12a90',markeredgecolor='k',markeredgewidth=1.0,
               label='$\mathrm{FXTs\ (local)}$',markersize=10,zorder=3)


##############################################3
#Distant sample Paper I


x_distant=[10.5,10.4,7.99]
y_distant=[-0.3,2.1,np.log10(1.15)]
plt.plot(x_distant,y_distant,'D',color='#d8576b',markeredgecolor='k',markeredgewidth=1.0,
               label='$\mathrm{FXTs\ (distant)}$',markersize=10,zorder=3)

##############################################3
#FXRT 16/XT2
M=9.07
SFR=np.log10(0.81)
plt.plot(M,SFR,'D',color='aqua',label='$\mathrm{CDF-XT2}$',markeredgecolor='k',markeredgewidth=1.0,
              markersize=10,zorder=3.0)

##############################################3
'''
#FXRT 19/XRT 170901
M=8.9
SFR=np.log10(4.05)
plt.plot(M,SFR,'*',color='r',label='$\mathrm{FXRT\ 19}$',markeredgecolor='k',markeredgewidth=2.0,
              markersize=25,zorder=3.0)

##############################################3
#FXRT 21/XRT 192223
M=10.2
SFR=np.log10(1.66)
plt.plot(M,SFR,'*',color='royalblue',label='$\mathrm{FXRT\ 21}$',markeredgecolor='k',markeredgewidth=2.0,
              markersize=25,zorder=3.0)
'''
##############################################3
#FXRT 22/XRT 210423_cNE
M=9.37
SFR=np.log10(21.5)
plt.plot(M,SFR,'*',color='skyblue',label='$\mathrm{cNE }$',markeredgecolor='k',markeredgewidth=1.0,
              markersize=20,zorder=3.0)

##############################################3
#FXRT 22/XRT 210423_CW
M=9.97
SFR=np.log10(7.46)
plt.plot(M,SFR,'*',color='red',label='$\mathrm{cW}$',markeredgecolor='k',markeredgewidth=1.0,
              markersize=20,zorder=3.0)



plt.ylim(-3,5)
plt.xlim(6.8,12)
plt.legend(loc=2,numpoints=1,ncol=3,fontsize=10.,framealpha=1.0,markerscale=0.9)
plt.xlabel('$\mathrm{Log(M_*[M_\odot])}$',fontsize=18.,fontweight='bold')
plt.ylabel('$\mathrm{Log(SFR[M_\odot\ yr^{-1}])}$',fontsize=18.,fontweight='bold')
plt.tick_params(axis='both', which='major', labelsize=15)

plt.subplots_adjust(top=0.95, bottom=0.11, left=0.14, right=0.96, hspace=0.,wspace=0.2)
plt.savefig('sfr_mass_nnn.pdf',format='pdf',dpi=300,  bbox_inches='tight')
plt.show()