from astropy.io import fits
from astropy.wcs import WCS
import matplotlib.pyplot as plt
from astropy import units as u
from mpl_toolkits.axes_grid1.inset_locator import inset_axes
import matplotlib.patches as patches
from astropy.visualization.wcsaxes import SphericalCircle
import numpy as np
from scipy import ndimage
import seaborn as sns
#sns.set_theme()
from astropy.visualization.wcsaxes import WCSAxes



from astropy.coordinates import SkyCoord
from astropy.wcs import WCS



plt.rcParams['font.family'] = 'serif'
plt.rcParams['font.serif'] = ['Times New Roman'] + plt.rcParams['font.serif']
#plt.rcParams['mathtext.default'] = 'regular'


scale = 0.16 # arcsec / pix
#scale = 0.25 # arcsec / pix



HDU = fits.open("z_im.fits")
wcs = WCS(HDU[0].header)

color_map = plt.cm.get_cmap('gray')
reversed_color_map = color_map.reversed()

ax = plt.subplot(projection=wcs)

#sky = SkyCoord(207.2363778 * u.deg, 26.6629166* u.deg,frame='fk5') wrong
sky = SkyCoord(207.2352500 * u.deg, 26.6623056* u.deg,frame='fk5')

#X,Y = wcs.world_to_pixel(sky)

rotated_img = ndimage.rotate(HDU[0].data, 0)

#im = ax.imshow(rotated_img, vmin=2050, vmax=2130, origin='lower', cmap=reversed_color_map) #g
#im = ax.imshow(rotated_img, vmin=285, vmax=320, origin='lower', cmap=reversed_color_map) #u
#im = ax.imshow(rotated_img, vmin=3750, vmax=4100, origin='lower', cmap=reversed_color_map) #r
#im = ax.imshow(rotated_img, vmin=8450, vmax=8950, origin='lower', cmap=reversed_color_map) #i
im = ax.imshow(rotated_img, vmin=20560, vmax=21100, origin='lower', cmap=reversed_color_map) #z
#im = ax.imshow(rotated_img, vmin=7600, vmax=8200, origin='lower', cmap=reversed_color_map) #R



r = SphericalCircle((207.2352500 * u.deg,  26.6623056* u.deg), 1 * u.arcsec,
                     edgecolor='orange', facecolor='none', linestyle='dashed', linewidth=3,
                     transform=ax.get_transform('fk5'))

ax.add_patch(r)


#plt.xlim(45, 100)
#plt.ylim(45,110)

#plt.xlim(820, 875)
#plt.ylim(430,495)


ax.text(75, 300, r"GTC/HiPERCAM $z_s$-filter", fontsize = 12, weight='bold').set_color('black')#u
#ax.text(845, 490, r"VLT/FORS $R$-filter", fontsize = 12, weight='bold').set_color('black')#u

#plt.xticks(fontsize=28)
#plt.yticks(fontsize=28)


plt.xlabel('R.A.')
plt.ylabel('Dec')

#plt.grid(False)

plt.savefig("z.pdf",dpi=300, bbox_inches='tight')

plt.show()
