from astropy.io import fits
from astropy.wcs import WCS
import matplotlib.pyplot as plt
from astropy import units as u
from mpl_toolkits.axes_grid1.inset_locator import inset_axes
import matplotlib.patches as patches
from astropy.visualization.wcsaxes import SphericalCircle
import numpy as np
from scipy import ndimage
import seaborn as sns
from astropy.visualization.wcsaxes import WCSAxes



from astropy.coordinates import SkyCoord
from astropy.wcs import WCS



plt.rcParams['font.family'] = 'serif'
plt.rcParams['font.serif'] = ['Times New Roman'] + plt.rcParams['font.serif']
#plt.rcParams['mathtext.default'] = 'regular'


scale = 0.25 # arcsec / pix for panstaars



HDU = fits.open("xrt210423_astrometrycorrec.fits")
wcs = WCS(HDU[0].header)

color_map = plt.cm.get_cmap('gray')
reversed_color_map = color_map.reversed()

ax = plt.subplot(projection=wcs)
'''
sky = SkyCoord(207.2363778 * u.deg, 26.6629166* u.deg,frame='fk5')
X,Y = wcs.world_to_pixel(sky)
'''


im = ax.imshow(HDU[0].data, vmin=7600, vmax=8700, origin='lower', cmap=reversed_color_map)


r = SphericalCircle((207.2352500 * u.deg,  26.6623056* u.deg), 1 * u.arcsec,
                     edgecolor='orange', facecolor='none', linewidth=2,
                     transform=ax.get_transform('fk5'))

leda94646  = SphericalCircle(( 207.2232917 * u.deg,  26.6641944* u.deg), 7 * u.arcsec,
                     edgecolor='red', facecolor='none', linestyle='dashed', linewidth=2,
                     transform=ax.get_transform('fk5'))

leda94647  = SphericalCircle(( 207.21850 * u.deg,  26.6660167* u.deg), 7 * u.arcsec,
                     edgecolor='red', facecolor='none', linestyle='dashed', linewidth=2,
                     transform=ax.get_transform('fk5'))

mas = SphericalCircle(( 207.2499583  * u.deg,  26.6455778* u.deg), 7 * u.arcsec,
                     edgecolor='red', facecolor='none', linestyle='dashed', linewidth=2,
                     transform=ax.get_transform('fk5'))


LEDA94611 = SphericalCircle(( 207.2157500  * u.deg,  26.6475917* u.deg), 7 * u.arcsec,
                     edgecolor='red', facecolor='none', linestyle='dashed', linewidth=2,
                     transform=ax.get_transform('fk5'))



ax.add_patch(r)
ax.add_patch(leda94646)
ax.add_patch(leda94647)
ax.add_patch(mas)
ax.add_patch(LEDA94611)

#ax.text(228, 325, "XRT 210423", fontsize = 12, weight='bold').set_color('black')
#ax.text(400, 270, "LEDA 94646 ", fontsize = 12, weight='bold').set_color('red')

ax.text(800, 420, "XRT 210423", fontsize = 12, weight='bold').set_color('black')
ax.text(820, 520, "LEDA 94646 ", fontsize = 12, weight='bold').set_color('red')

plt.xlim(600,1200)
plt.ylim(100,700)


#plt.xlim(50,600)
#plt.ylim(0,550)



#ax.text(440, 520, "Abell 1795", fontsize = 15, weight='bold').set_color('black')
#ax.text(365, 495, r"PanSTARRS $g$-filter", fontsize = 12, weight='bold').set_color('black')
ax.text(1020, 670, "Abell 1795", fontsize = 15, weight='bold').set_color('black')
ax.text(990, 640, r"FORS2 $R$-filter", fontsize = 12, weight='bold').set_color('black')

#ax.text(410, 50, r"$10^{\prime\prime}$", fontsize = 10, weight='bold').set_color('black')
#ax.arrow(405, 45, 10/scale, 0,linewidth=2,head_width=0, head_length=0 ).set_color('black')
#ax.text(395, 20, "14 kpc", fontsize = 10, weight='bold').set_color('black')


ax.text(1000, 150, r"$10^{\prime\prime}$", fontsize = 10, weight='bold').set_color('black')
ax.arrow(995, 145, 10/scale, 0,linewidth=2,head_width=0, head_length=0 ).set_color('black')
ax.text(990, 120, "14 kpc", fontsize = 10, weight='bold').set_color('black')


plt.xlabel('R.A.')
plt.ylabel('Dec')

plt.savefig("abell1795_fors.pdf",dpi=300, bbox_inches='tight')

plt.show()
