#progam to calulate the phot z 

import numpy as np 
import bagpipes as pipes
import matplotlib.pyplot as plt
from astropy.io import fits




def load_goodss(ID):
    """ Load CANDELS GOODS South photometry from the Guo et al. (2013) catalogue. """

    # load up the relevant columns from the catalogue.
    cat = np.loadtxt("gal_1_51.txt",
                     usecols=(2,4,6,8,10,12,
                              3,5,7,9,11,13))
    
    # Find the correct row for the object we want.
    row = int(ID) - 1
    # Extract the object we want from the catalogue.
    fluxes = cat[:6]
    fluxerrs = cat[6:]
    print(fluxes)
    print(fluxerrs)

    # Turn these into a 2D array.
    photometry = np.c_[fluxes, fluxerrs]


    return photometry



def read_filter(filename):
    datos = np.loadtxt(filename, float)
    wave = []
    trans=[]
    for i in range (0,len(datos)):
        wave.append(np.log10(datos[i][0]))
        trans.append(abs(datos[i][1]))
    return wave,trans  

goodss_filt_list = np.loadtxt("filters_hipercam/filter_list.txt", dtype="str")
print (goodss_filt_list)
#filter_sdss/filter.dat


galaxy = pipes.galaxy("1", load_goodss, spectrum_exists=False, filt_list=goodss_filt_list)

fig = galaxy.plot()
plt.show()

exp = {}                                  # Tau-model star-formation history component
exp["age"] = (0.1, 15.)                   # Vary age between 100 Myr and 15 Gyr. In practice 
                                          # the code automatically limits this to the age of
                                          # the Universe at the observed redshift.

exp["tau"] = (0.3, 10.)                   # Vary tau between 300 Myr and 10 Gyr
exp["massformed"] = (1., 15.)             # vary log_10(M*/M_solar) between 1 and 15
exp["metallicity"] = (0., 2.5)            # vary Z between 0 and 2.5 Z_oldsolar

dust = {}                                 # Dust component
dust["type"] = "Calzetti"                 # Define the shape of the attenuation curve
dust["Av"] = (0., 2.)                     # Vary Av between 0 and 2 magnitudes

fit_instructions = {}                     # The fit instructions dictionary
fit_instructions["redshift"] = 1.51
#(0., 2.)  # Vary observed redshift from 0 to 10
fit_instructions["exponential"] = exp   
fit_instructions["dust"] = dust



nebular = {}
nebular["logU"] = -3.0 # Log_10 of the ionization parameter (required).
fit_instructions["nebular"] = nebular


fit = pipes.fit(galaxy, fit_instructions)

fit.fit(verbose=False)




fig = fit.plot_spectrum_posterior(save=False, show=True)
fig = fit.plot_sfh_posterior(save=False, show=True)
fig = fit.plot_corner(save=False, show=True)


import matplotlib.pyplot as plt
import matplotlib as mpl



list(fit.posterior.samples)


fig = plt.figure(figsize=(9, 7))
gs = mpl.gridspec.GridSpec(9, 5, hspace=6, wspace=0.1)

ax1 = plt.subplot(gs[:6, :])

pipes.plotting.add_observed_photometry(fit.galaxy, ax1, zorder=10,color='royalblue',ptsize=100)
pipes.plotting.add_photometry_posterior(fit, ax1)

labels = ["sfr", "mass_weighted_age", "stellar_mass", "exponential:metallicity","dust:Av"]


post_quantities = dict(zip(labels, [fit.posterior.samples[l] for l in labels]))
#ax1.set_yscale('log')
ax1.set_xlim(3.4,4.1)
ax1.set_ylim(0.0,8.0)
ax1.set_xticks([3.4,3.5,3.7,3.9,4.1])
ax1.set_title('$\mathrm{cNE}$',fontsize=18)

num_plots = len(fit.galaxy.filt_list)
#x=np.arange(3.6,4.6,0.1)
#num_plots = len(x)

colormap = plt.cm.gist_ncar
plt.gca().set_prop_cycle(plt.cycler('color', plt.cm.rainbow(np.linspace(0, 1, num_plots))))

for i in range(0, len(fit.galaxy.filt_list)):
    wave,trans=read_filter(fit.galaxy.filt_list[i])
    trans=np.array(trans)
    ax1.plot(wave, trans/2)
    ax1.fill_between(wave,trans/2,alpha=0.5)
    

###############################################################3

axes = []
for i in range(5):
    axes.append(plt.subplot(gs[6:, i]))
    pipes.plotting.hist1d(post_quantities[labels[i]], axes[-1], smooth=True, label=labels[i])

plt.subplots_adjust(top=0.95, bottom=0.1, left=0.1, right=0.96, hspace=0.9,wspace=0.6)
plt.savefig('cNE_nnn.pdf',format='pdf')
plt.show()



#print('Redshift:',np.percentile(fit.posterior.samples["redshift"], (16, 50,84)))
print('stellar_mass:',np.percentile(fit.posterior.samples["stellar_mass"], (16, 50,84)))
print('sfr:',np.percentile(fit.posterior.samples["sfr"], (16, 50,84)))
print('dust:Av:',np.percentile(fit.posterior.samples["dust:Av"], (16, 50,84)))
print('mass_weighted_age:',np.percentile(fit.posterior.samples["mass_weighted_age"], (16, 50,84)))
print('chisq_phot:',np.percentile(fit.posterior.samples["chisq_phot"], (16, 50,84)))

