# -*- coding: utf-8 -*-

#Python 2.7


from pyraf import iraf
from iraf import noao,digiphot,daophot
import numpy as np
import os
from astropy.io import ascii
from astropy.table import Table


    
#%matplotlib inline

# Load IRAF packages needed

iraf.noao.digiphot.daophot(_doprint=0)



#defining the parameters
iraf.daophot.findpars.threshold=3.0 #5sigma detections only

#centerpars
iraf.daophot.centerpars.calgori="centroid"

#fitskypars
iraf.daophot.fitskypars.salgori="mode"
iraf.daophot.fitskypars.annulus=20.0 #Inner radius of sky annulus in scale units
iraf.daophot.fitskypars.dannulu=5.0 #Width of sky annulus in scale units

#photpars
iraf.daophot.photpars.apertur=5 #List of aperture radii in scale 2-2.5 * fwhmpsf
iraf.daophot.photpars.zmag=27.14

#datapars
iraf.daophot.datapars.fwhmpsf=5 #FWHM of the PSF in scale units
iraf.daophot.datapars.sigma=35.3 #Standard deviation of background in counts
iraf.daophot.datapars.readnoi=7.15 #CCD readout noise in electrons
iraf.daophot.datapars.epadu=5.6 #Gain in electrons per count
iraf.daophot.datapars.itime=180 #Exposure time


#daopars
iraf.daophot.daopars.functio="gauss" #Form of analytic component of psf model
iraf.daophot.daopars.varorde=0 #Order of empirical component of psf model
iraf.daophot.daopars.psfrad=12.5 #Radius of psf model in scale units
iraf.daophot.daopars.fitrad=5.0 #Fitting radius in scale units



# Info about the images
image ="R_art.fits"
psf_file = "R.fits.psf.1.fits"

# Location of x-ray source
position_x =  41 
position_y =  46
#positional_uncertainty = 4   # standard deviation of Gaussian that describes 
#the uncertainty on the position in pixels


# Function to write a magfile in the format required by addstar
def write_magfile(x,y,mag):

    with open('photfile.mag', 'w') as f:
        f.write("%.2f %.2f %.2f\n" % (x, y, mag)) 

iterations=1000
magnitude =[]
recovery = []
counter =[]
results = Table()
check= Table()
find_check = Table()
test = []


# Loop over all magnitudes we are interested in
for mag in np.arange(22.0, 25, 0.1):
    
    sucess_counter = 0
    
    # Now we do 100 iterations in each mag bin, changing the position slightly each time
    for i in range (0, iterations):
        # Delete any exisiting artificial files
        if os.path.exists("out.art"):
            os.remove("out.art")  
        if os.path.exists("out.coo"):
            os.remove("out.coo") 
        if os.path.exists("out.fits"):
            os.remove("out.fits")  
        if os.path.exists("out.mag"):
            os.remove("out.mag")
        if os.path.exists("out.dat"):
            os.remove("out.dat")
        if os.path.exists("reject.dat"):
            os.remove("reject.dat")
        if os.path.exists("sub.fits"):
            os.remove("sub.fits")
        
        # Pick a random offset for the source
        r = 4 * np.sqrt(np.random.random())
        theta = np.random.random()* 2 * np.pi
        deltax = r * np.cos(theta)
        deltay = r * np.sin(theta)
     
        # Now create the magfile we need
        write_magfile(position_x+deltax, position_y+deltay, mag)

        # Now add a source at this position and magnitude
        iraf.noao.digiphot.daophot.addstar(image, "photfile.mag", psf_file, "out",
                                  simple_text="yes", verbose='no', verify ="no")

        iraf.noao.digiphot.daophot.daofind("out.fits","out.coo",
                                            interactive = "no",verbose='no', verify ="no")

        find_check = ascii.read("out.coo")
        #print (find_check)
        find_check = find_check[((find_check['XCENTER']>30) & (find_check['XCENTER']<52)) 
                      & ((find_check['YCENTER']>35) & (find_check['YCENTER']<55)) ]

        test = find_check['XCENTER']
        

        #print(find_check)

        if len(test) == 0:
            flag=0
        else :
            flag=1

        
        if flag == 1:  
        # DO PHOTOMETRY ON ARTIFICIAL IMAGE (iraf.noao.digiphot.daophot.phot,
        #iraf.noao.digiphot.daophot.allstar)
        # Now check if your recovered magnitude matches the input mag to (for example) 0.2 mag
        # if it does, then sucess_counter = sucess_counter + 1

            iraf.noao.digiphot.daophot.phot("out.fits","photfile.mag","out.mag",
                                        interactive = "no",verbose='no', verify ="no")

            iraf.noao.digiphot.daophot.allstar("out.fits","out.mag",psf_file,"out.dat","reject.dat",
                                            subimage="sub.fits",verbose="no", verify ="no")

            check = ascii.read("out.dat")
            if(np.absolute(check['MAG']-mag)<0.3):
               sucess_counter=sucess_counter+1
            else:
               sucess_counter=sucess_counter+0

        else:   
            continue



    magnitude.append("%.2f"%mag)
    recovery.append("%.4f"%(np.float(sucess_counter)/np.float(iterations)))
    counter.append(sucess_counter)

	
    print ("%.2f %.2f %.2f\n" %(mag,sucess_counter,np.float(sucess_counter)/np.float(iterations)))



results['mag']=magnitude
results['recovery']=recovery
results['counter']=counter
print(results)

ascii.write(results,'R_1000.dat',overwrite= True)





    
