

from astropy.io import ascii
import seaborn as sns
from matplotlib import pyplot as plt
sns.set_style("darkgrid")
#sns.set_style("ticks")


#from the paper Fong+22: updated SGRB offsets
offsets =ascii.read('fong+22_deepak.txt')

#offsets of different transients 

# Columns are
# 0 FRBs - Mannings et al. 2020 (could be updated now, e.g. Bhandari et
# al. 2022)
# 1 Long GRBs - Blanchard et al. 2016
# 2 Long GRBs (can combine with 2) - Lyman et al. 2017
# 3 Short GRBs (can skip if you have updated sample)
# 4 Type Ia SNe - Uddin et al. 2020
# 5 Regular SNe - Kelly & Kirschner 2012 + Schulze et al. 2020
# 6 SLSNe - Schulze et al. 2020
# 7 Ca-rich SNe - Lunnan et al. 2017 + De et al. 2020

# Offsets are in kpc.The 999s are there to make the columns all the same
# length


offset_all =ascii.read('comparison_offset_data.txt')



ax =sns.ecdfplot(data=offsets['r_l'], log_scale = True,  linewidth = 4, 
	color ='royalblue', label='SGRBs')
#ax.set_xscale('log')

LGRB= []
SLSNe =[]
Sne1a =[]

SLSNe = offset_all['col7']
SLSNe  = SLSNe [SLSNe <999]

LGRB = offset_all['col3']
LGRB = LGRB[LGRB<999]

Sne1a = offset_all['col5']
Sne1a= Sne1a[Sne1a<999]


Sne20 = offset_all['col6']
Sne20= Sne20[Sne20<999]
#Type Ia SNe


ax1 =sns.ecdfplot(data=LGRB, log_scale = True,  linewidth = 4, color ='forestgreen',label='LGRBs')
ax2 =sns.ecdfplot(data=SLSNe, log_scale = True,  linewidth = 4, color ='grey',label='SLSNe')
ax2 =sns.ecdfplot(data=Sne1a, log_scale = True,  linewidth = 4, color ='blueviolet',label='Type Ia SNe')
ax3 =sns.ecdfplot(data=Sne20, log_scale = True,  linewidth = 4, color ='brown',label='CC-SNe')


plt.ylabel(' Cumulative Distribution', fontsize=16)
plt.xlabel('Galactocentric Offset [kpc]', fontsize=16)

plt.axvline(1.96, color ='black', linewidth = 4, linestyle='--', label='GW170817')
plt.axvline(3.3, color ='#f7d13d', linewidth = 4, linestyle='--', label='CDF-XT2')
plt.axvline(39.9, color ='pink', linewidth = 4, linestyle='--', label='cNE')
plt.axvline(29.5, color ='orange', linewidth = 4, linestyle='--', label='cW')
plt.axvline(49.1, color ='red', linewidth = 4, linestyle='--', label='Abell 1795')
plt.axvline(0.7, color ='greenyellow', linewidth = 4, linestyle='--', label='cX at Abell 1795')
ax.axvspan(4.5, 4.8, alpha=0.5, color='skyblue',label='cX at z~ 1-1.5')


ax.set(xlim=(0, 200))
plt.legend(fontsize=12) #,loc='upper left'

plt.xticks(fontsize=14)
plt.yticks(fontsize=14)

plt.savefig("offset_n.pdf",dpi=300, bbox_inches='tight')
plt.show()
