#!/usr/bin/env python3
# -*- coding: utf-8 -*-
"""
@author: Deepak
"""

import numpy as np
import seaborn as sns
import matplotlib.pyplot as plt
from astropy.table import Table
from astropy.io import ascii
from astropy.cosmology import FlatLambdaCDM
from scipy.integrate import simps
from astropy.io import fits

sns.set_style("darkgrid")


LC = Table.read('kilonova.csv', format='csv')  #From Cowperthwaite et al. 2017

Mu = 5*np.log10((42.2*1000000)/10)   #Because DL for 170817 = 42.2Mpc
LC['absmags'] = LC['MAG'] - Mu

LC['MJD'] = LC['MJD']/ 1.009


MJDt0 = 54474.56435     

LCSN = Table.read('SN_2008D.dat', format='ascii')
LCSN['MJD'] = LCSN['Date'] - MJDt0

LCSN['MJD'] = LCSN['MJD']/ 1.007

GRB_AG = Table.read('SGRB_AG.dat', format='ascii')  #the data is for a z=1 in r-filter
GRB_AG = GRB_AG[GRB_AG['MJD'] > 0.3]

GRB_AG = GRB_AG[GRB_AG['MJD'].argsort()]



Mu1 = 5*np.log10((27*1000000)/10) #Because DL for SN2008D = 27Mpc
LCSN['absmags_g'] = LCSN['g'] - Mu1
LCSN['absmags_r'] = LCSN['r'] - Mu1 
LCSN['absmags_i'] = LCSN['i'] - Mu1
LCSN['absmags_z'] = LCSN['z'] - Mu1

LCSN = LCSN[LCSN['i'] > 0]
LCSN = LCSN[LCSN['g'] > 0]

#distance  = [290,7200]
distance =[7000]

for d in distance:

#for z=1, correct for the time. multiply with (1=z), ie with 2

    LC['MJD'] = LC['MJD'] * 2 #( if at the  redshift of 1 we need to sonvert into observers frame again, so  time  1+z)

    LC['Mu_obs'] = 5*np.log10((d*1000000)/10)
    LC['newmags'] = LC['absmags'] + LC['Mu_obs']

    LCSN['MJD'] = LCSN['MJD'] * 2

    LCSN['Mu_obs_g'] = 5*np.log10((d*1000000)/10) 
    LCSN['newmags_g'] = LCSN['absmags_g'] + LCSN['Mu_obs_g']


    LCSN['Mu_obs_r'] = 5*np.log10((d*1000000)/10) 
    LCSN['newmags_r'] = LCSN['absmags_r'] + LCSN['Mu_obs_r']

    LCSN['Mu_obs_i'] = 5*np.log10((d*1000000)/10) 
    LCSN['newmags_i'] = LCSN['absmags_i'] + LCSN['Mu_obs_i']

    LCSN['Mu_obs_z'] = 5*np.log10((d*1000000)/10) 
    LCSN['newmags_z'] = LCSN['absmags_z'] + LCSN['Mu_obs_z']



    LC_u = LC[LC['FILTER']== 'UV']
    LC_g = LC[LC['FILTER']== 'GREEN']
    #LC_rizY = LC[LC['FILTER']== 'RED']
    LC_r= LC[LC['OBS']== 'r']
    LC_i= LC[LC['OBS']== 'i']
    LC_z= LC[LC['OBS']== 'z']
   

    LC_JHK = LC[LC['FILTER']== 'NIR']
    
    LC_u = LC_u[LC_u['MAG']> 0]
    LC_g = LC_g[LC_g['MAG']> 0]
    LC_r = LC_r[LC_r['MAG']> 0]
    LC_i = LC_i[LC_i['MAG']> 0]
    LC_z = LC_z[LC_z['MAG']> 0]

    #LC_rizY = LC_rizY[LC_rizY['MAG']> 0]
    #LC_JHK= LC_JHK[LC_JHK['MAG']> 0]



    
    plt.errorbar(x=np.log10(LC_u['MJD']),y=LC_u['newmags'],yerr=LC_u['ERR'], marker='o', markeredgecolor="black", markerfacecolor='royalblue',
        label='GW 170817 KN u', ls='none',zorder =0,markersize=9, alpha=.65)
    plt.errorbar(x=np.log10(LC_g['MJD']),y=LC_g['newmags'],yerr=LC_g['ERR'], marker='o',markeredgecolor="black", markerfacecolor='yellowgreen',
        label='GW 170817 KN g',  ls='none',zorder =0,markersize=9, alpha=.65)
    plt.errorbar(x=np.log10(LC_r['MJD']),y=LC_r['newmags'],yerr=LC_r['ERR'], marker='o',markeredgecolor="black", markerfacecolor='red',
        label='GW 170817 KN r', ls='none', zorder =0,markersize=9, alpha=.65)
    plt.errorbar(x=np.log10(LC_i['MJD']),y=LC_i['newmags'],yerr=LC_i['ERR'], marker='o',markeredgecolor="black", markerfacecolor='orange',
        label='GW 170817 KN i', ls='none', zorder =0,markersize=9, alpha=.65)
    plt.errorbar(x=np.log10(LC_z['MJD']),y=LC_z['newmags'],yerr=LC_z['ERR'], marker='o',markeredgecolor="black", markerfacecolor='gold',
        label='GW 170817 KN z', ls='none', zorder =0,markersize=9, alpha=.65)





    #plt.errorbar(x=np.log10(LC_rizY['MJD']),y=LC_rizY['newmags'],yerr=LC_rizY['ERR'], marker='o',markeredgecolor="black", markerfacecolor='orangered',
    #    label='GW 170817 KN rizY', ls='none', zorder =0,markersize=9)
    #plt.errorbar(x=np.log10(LC_JHK ['MJD']),y=LC_JHK ['newmags'],yerr=LC_JHK ['ERR'], marker='o',markeredgecolor="black", markerfacecolor='gold',
    #    label='GW 170817 KN JHK', ls='none', zorder =0)







    plt.errorbar(x=np.log10(LCSN['MJD']),y=LCSN['newmags_g'],yerr=LCSN['σ(g)'], marker='D', markeredgecolor="black", markerfacecolor='yellowgreen',
        label='SN 2008D g', ls='none',zorder =0,markersize=9, alpha=.65)
    plt.errorbar(x=np.log10(LCSN['MJD']),y=LCSN['newmags_r'],yerr=LCSN['σ(r)'], marker='D',markeredgecolor="black", markerfacecolor='red',
        label='SN 2008D r', ls='none',zorder =0,markersize=9, alpha=.65)
    plt.errorbar(x=np.log10(LCSN['MJD']),y=LCSN['newmags_i'],yerr=LCSN['σ(i)'], marker='D',markeredgecolor="black", markerfacecolor='orange',
        label='SN 2008D i', ls='none',zorder =0,markersize=9, alpha=.65)
    plt.errorbar(x=np.log10(LCSN['MJD']),y=LCSN['newmags_z'],yerr=LCSN['σ(z)'], marker='D',markeredgecolor="black", markerfacecolor='gold',
        label='SN 2008D z', ls='none',zorder =0,markersize=9, alpha=.65)


    ax= sns.scatterplot(np.log10(GRB_AG['MJD']),GRB_AG['mag'],marker='s',label='SGRB afterglows in Rc-filter',color='lightcoral',zorder=0, alpha=.50)




time=[12.1,48.0,48.0,48.0,48.0,48.0]
OL=[24.7,26.2,27,26.1,24.4,24.7]

plt.plot(np.log10(13), 24.7, marker='v', markersize=14, markeredgecolor="black", markerfacecolor="tomato", label= 'FORS R', zorder=5)
plt.plot(np.log10(48.9), 26.2, marker='v', markersize=14, markeredgecolor="black", markerfacecolor="blue", label= 'u-filter',  zorder=5)
plt.plot(np.log10(48.9), 27, marker='v', markersize=14, markeredgecolor="black", markerfacecolor="yellowgreen", label= 'g-filter',  zorder =5)
plt.plot(np.log10(48.9), 26.1, marker='v', markersize=14, markeredgecolor="black", markerfacecolor="red", label= 'r-filter',  zorder=5)
plt.plot(np.log10(48.9), 24.4, marker='v', markersize=14, markeredgecolor="black", markerfacecolor="orange", label= 'i-filter',  zorder=5)
plt.plot(np.log10(48.9), 24.7, marker='v', markersize=14, markeredgecolor="black", markerfacecolor="gold", label= 'z-filter',  zorder=5)



#ax= sns.scatterplot(cNW_stsci_S['z'],cNW_stsci_S['g_r'],label='K-C s0', color='red',alpha=1, zorder=10,edgecolor = 'none',s = 30, marker="^")
#ax= sns.pointplot(np.log10(np.array[13]), [24], color = 'red', marker =11,s=200)  #13 days after the event, FORS observation
         

#plt.text(x=1.12, y=27.2, s="d = 290 Mpc", fontdict=dict(color="black", alpha=0.5, size=12))
#plt.text(x=1.12, y=33.2, s="d = 7200 Mpc (z = 1)", fontdict=dict(color="black", alpha=0.5, size=12))                                                                                        

    

handles, labels = plt.gca().get_legend_handles_labels()
by_label = dict(zip(labels, handles))
plt.legend(by_label.values(), by_label.keys(), fontsize=9, ncol=3)

plt.title('z ~ 1 ('+str(d)+' Mpc)',fontweight='bold')
#plt.title('At the distance of Abell 1795 cluster ('+str(d)+' Mpc)',fontweight='bold')
plt.gca().invert_yaxis()
plt.xlabel('log (observer time in days)',fontsize=14)
plt.ylabel('Apparent magnitude',fontsize=14)
#plt.legend(fontsize=12)



plt.savefig('optical_limits_z1_n.pdf',dpi=300, bbox_inches='tight', overwrite = True)
plt.show()





