

import numpy as np
import matplotlib.pyplot as plt
from astropy.table import Table
from astropy.io import ascii
from astropy.io import fits
from astropy.wcs import WCS



hdu = fits.open('TOO_hard-hostXRT210423_SCI_SLIT_FLUX_MERGE2D_NIR.fits')
data = hdu[0].data
wcs = WCS(hdu[0].header)

plt.rcParams['font.family'] = 'serif'
plt.rcParams['font.serif'] = ['Times New Roman'] + plt.rcParams['font.serif']

color_map = plt.cm.get_cmap('gray')
reversed_color_map = color_map.reversed()
plt.Circle((10876, 42), 10, color='red')

ax = plt.subplot(projection=wcs)
im = ax.imshow(data,cmap=reversed_color_map,vmin=-2e-18, vmax=3e-18, origin='lower')
plt.xlim(4300,4450)
plt.ylim(10,75)


x = ax.coords[0]
y = ax.coords[1]

y.set_ticks_visible(False)
y.set_ticklabel_visible(False)
x.set_ticks_position('b')

plt.tick_params(labelsize=15)

#ax.text(4336, 48, r"$O III$", fontsize =25, weight='bold').set_color('darkblue')
plt.title(r"$[O III]$", fontsize =25)
cir = plt.Circle((4371, 42), 10, linewidth=4, fill=False, color='red',linestyle='--')

ax.add_patch(cir)

plt.ylabel(' ',fontsize=15)

#plt.axis('off')
plt.xlabel('Wavelength (nm)',fontsize=15)

plt.savefig("O3.pdf",dpi=300, bbox_inches='tight')

plt.show()
