(define
  (domain taskAssigment)
  (:requirements :adl)
  (:predicates
    (ElectronicsAgent ?x )
    (Designer ?x )
    (SoftwareAgent ?x )
    (InformaticEngineer ?x )
    (MaterialsAgent ?x )
    (DesignAgent ?x )
    (TaskAgent ?x )
    (MaterialsEngineer ?x )
    (CodingAgent ?x )
    (TestingAgent ?x )
    (ElectronicEngineer ?x )
    (Employee ?x )
    (FullName ?x )
    (Engineer ?x )
    (SpecificationsAgent ?x )
    (Developer ?x )
    (hasPersonalInfo ?x ?y )
    (CheckConsistency)
    (Error)
  )
  (:action assignMaterialsAgent
    :parameters ( ?x )
    :precondition ( and
      (not (CheckConsistency))
      (not (Error))
      (or
        (MaterialsAgent ?x)
        (Developer ?x)
        (SpecificationsAgent ?x)
        (ElectronicsAgent ?x)
        (CodingAgent ?x)
        (DesignAgent ?x)
        (InformaticEngineer ?x)
        (Employee ?x)
        (TestingAgent ?x)
        (ElectronicEngineer ?x)
        (exists (?z_0 )
          (hasPersonalInfo ?x ?z_0)
        )
        (MaterialsEngineer ?x)
        (Designer ?x)
        (TaskAgent ?x)
        (Engineer ?x)
        (SoftwareAgent ?x)
      )
    )
    :effect ( and
      (CheckConsistency)
      (when
        (= a a)
        (and
          (MaterialsAgent ?x)
        )
      )
    )
  )
  (:action removePersonalInfo
    :parameters ( ?x ?y )
    :precondition ( and
      (not (CheckConsistency))
      (not (Error))
      (hasPersonalInfo ?x ?y)
    )
    :effect ( and
      (CheckConsistency)
      (when
        (= a a)
        (and
          (not (hasPersonalInfo ?x ?y))
        )
      )
    )
  )
  (:action assignElectronicsAgent
    :parameters ( ?x )
    :precondition ( and
      (not (CheckConsistency))
      (not (Error))
      (or
        (MaterialsAgent ?x)
        (Developer ?x)
        (SpecificationsAgent ?x)
        (ElectronicsAgent ?x)
        (CodingAgent ?x)
        (DesignAgent ?x)
        (InformaticEngineer ?x)
        (Employee ?x)
        (TestingAgent ?x)
        (ElectronicEngineer ?x)
        (exists (?z_0 )
          (hasPersonalInfo ?x ?z_0)
        )
        (MaterialsEngineer ?x)
        (Designer ?x)
        (TaskAgent ?x)
        (Engineer ?x)
        (SoftwareAgent ?x)
      )
    )
    :effect ( and
      (CheckConsistency)
      (when
        (= a a)
        (and
          (ElectronicsAgent ?x)
        )
      )
    )
  )
  (:action assignDesignAgent
    :parameters ( ?x )
    :precondition ( and
      (not (CheckConsistency))
      (not (Error))
      (or
        (MaterialsAgent ?x)
        (Developer ?x)
        (SpecificationsAgent ?x)
        (ElectronicsAgent ?x)
        (CodingAgent ?x)
        (DesignAgent ?x)
        (InformaticEngineer ?x)
        (Employee ?x)
        (TestingAgent ?x)
        (ElectronicEngineer ?x)
        (exists (?z_0 )
          (hasPersonalInfo ?x ?z_0)
        )
        (MaterialsEngineer ?x)
        (Designer ?x)
        (TaskAgent ?x)
        (Engineer ?x)
        (SoftwareAgent ?x)
      )
    )
    :effect ( and
      (CheckConsistency)
      (when
        (= a a)
        (and
          (DesignAgent ?x)
        )
      )
    )
  )
  (:action hireElectronicEng
    :parameters ( ?n )
    :precondition ( and
      (not (CheckConsistency))
      (not (Error))
      (= a a)
    )
    :effect ( and
      (CheckConsistency)
      (when
        (not
          (exists ( ?x2 ?x3 ?x1 )
            (and
              (ElectronicEngineer ?x3)
              (ElectronicEngineer ?x1)
              (not
                (=?x1 ?x2 )
              )
              (ElectronicEngineer ?x2)
              (not
                (=?x1 ?x3 )
              )
              (not
                (=?x2 ?x3 )
              )
            )
          )
        )
        (and
          (ElectronicEngineer ?n)
        )
      )
    )
  )
  (:action hireInformaticEng
    :parameters ( ?n )
    :precondition ( and
      (not (CheckConsistency))
      (not (Error))
      (= a a)
    )
    :effect ( and
      (CheckConsistency)
      (when
        (not
          (exists ( ?x2 ?x3 ?x1 )
            (and
              (not
                (=?x1 ?x3 )
              )
              (InformaticEngineer ?x3)
              (not
                (=?x2 ?x3 )
              )
              (InformaticEngineer ?x2)
              (InformaticEngineer ?x1)
              (not
                (=?x1 ?x2 )
              )
            )
          )
        )
        (and
          (InformaticEngineer ?n)
        )
      )
    )
  )
  (:action assignTaskAgent
    :parameters ( ?x )
    :precondition ( and
      (not (CheckConsistency))
      (not (Error))
      (or
        (MaterialsAgent ?x)
        (Developer ?x)
        (SpecificationsAgent ?x)
        (ElectronicsAgent ?x)
        (CodingAgent ?x)
        (DesignAgent ?x)
        (InformaticEngineer ?x)
        (Employee ?x)
        (TestingAgent ?x)
        (ElectronicEngineer ?x)
        (exists (?z_0 )
          (hasPersonalInfo ?x ?z_0)
        )
        (MaterialsEngineer ?x)
        (Designer ?x)
        (TaskAgent ?x)
        (Engineer ?x)
        (SoftwareAgent ?x)
      )
    )
    :effect ( and
      (CheckConsistency)
      (when
        (= a a)
        (and
          (TaskAgent ?x)
        )
      )
    )
  )
  (:action assignTestingAgent
    :parameters ( ?x )
    :precondition ( and
      (not (CheckConsistency))
      (not (Error))
      (or
        (MaterialsAgent ?x)
        (Developer ?x)
        (SpecificationsAgent ?x)
        (ElectronicsAgent ?x)
        (CodingAgent ?x)
        (DesignAgent ?x)
        (InformaticEngineer ?x)
        (Employee ?x)
        (TestingAgent ?x)
        (ElectronicEngineer ?x)
        (exists (?z_0 )
          (hasPersonalInfo ?x ?z_0)
        )
        (MaterialsEngineer ?x)
        (Designer ?x)
        (TaskAgent ?x)
        (Engineer ?x)
        (SoftwareAgent ?x)
      )
    )
    :effect ( and
      (CheckConsistency)
      (when
        (= a a)
        (and
          (TestingAgent ?x)
        )
      )
    )
  )
  (:action assignCodingAgent
    :parameters ( ?x )
    :precondition ( and
      (not (CheckConsistency))
      (not (Error))
      (or
        (MaterialsAgent ?x)
        (Developer ?x)
        (SpecificationsAgent ?x)
        (ElectronicsAgent ?x)
        (CodingAgent ?x)
        (DesignAgent ?x)
        (InformaticEngineer ?x)
        (Employee ?x)
        (TestingAgent ?x)
        (ElectronicEngineer ?x)
        (exists (?z_0 )
          (hasPersonalInfo ?x ?z_0)
        )
        (MaterialsEngineer ?x)
        (Designer ?x)
        (TaskAgent ?x)
        (Engineer ?x)
        (SoftwareAgent ?x)
      )
    )
    :effect ( and
      (CheckConsistency)
      (when
        (= a a)
        (and
          (CodingAgent ?x)
        )
      )
    )
  )
  (:action assignSpecificationsAgent
    :parameters ( ?x )
    :precondition ( and
      (not (CheckConsistency))
      (not (Error))
      (or
        (MaterialsAgent ?x)
        (Developer ?x)
        (SpecificationsAgent ?x)
        (ElectronicsAgent ?x)
        (CodingAgent ?x)
        (DesignAgent ?x)
        (InformaticEngineer ?x)
        (Employee ?x)
        (TestingAgent ?x)
        (ElectronicEngineer ?x)
        (exists (?z_0 )
          (hasPersonalInfo ?x ?z_0)
        )
        (MaterialsEngineer ?x)
        (Designer ?x)
        (TaskAgent ?x)
        (Engineer ?x)
        (SoftwareAgent ?x)
      )
    )
    :effect ( and
      (CheckConsistency)
      (when
        (= a a)
        (and
          (SpecificationsAgent ?x)
        )
      )
    )
  )
  (:action assignSoftwareAgent
    :parameters ( ?x )
    :precondition ( and
      (not (CheckConsistency))
      (not (Error))
      (or
        (MaterialsAgent ?x)
        (Developer ?x)
        (SpecificationsAgent ?x)
        (ElectronicsAgent ?x)
        (CodingAgent ?x)
        (DesignAgent ?x)
        (InformaticEngineer ?x)
        (Employee ?x)
        (TestingAgent ?x)
        (ElectronicEngineer ?x)
        (exists (?z_0 )
          (hasPersonalInfo ?x ?z_0)
        )
        (MaterialsEngineer ?x)
        (Designer ?x)
        (TaskAgent ?x)
        (Engineer ?x)
        (SoftwareAgent ?x)
      )
    )
    :effect ( and
      (CheckConsistency)
      (when
        (= a a)
        (and
          (SoftwareAgent ?x)
        )
      )
    )
  )
  (:action CheckConsistencyAction
    :parameters ( )
    :precondition ( and
      (CheckConsistency)
      (not (Error))
    )
    :effect ( and
      (not (CheckConsistency))
      (when
        (or
          (exists (?x_0 ?z_0 )
            (and
              (Developer ?x_0)
              (hasPersonalInfo ?z_0 ?x_0)
            )
          )
          (exists (?x_0 ?z_0 ?z_1 )
            (and
              (hasPersonalInfo ?z_0 ?x_0)
              (hasPersonalInfo ?x_0 ?z_1)
            )
          )
          (exists (?x_0 )
            (and
              (TestingAgent ?x_0)
              (FullName ?x_0)
            )
          )
          (exists (?x_0 )
            (and
              (FullName ?x_0)
              (DesignAgent ?x_0)
            )
          )
          (exists (?x_8 )
            (and
              (SoftwareAgent ?x_8)
              (MaterialsEngineer ?x_8)
            )
          )
          (exists (?x_0 )
            (and
              (FullName ?x_0)
              (CodingAgent ?x_0)
            )
          )
          (exists (?x_6 )
            (and
              (Designer ?x_6)
              (ElectronicsAgent ?x_6)
            )
          )
          (exists (?x_0 ?z_0 )
            (and
              (TestingAgent ?x_0)
              (hasPersonalInfo ?z_0 ?x_0)
            )
          )
          (exists (?x_0 ?z_0 )
            (and
              (InformaticEngineer ?x_0)
              (hasPersonalInfo ?z_0 ?x_0)
            )
          )
          (exists (?x_1 )
            (and
              (SoftwareAgent ?x_1)
              (Designer ?x_1)
            )
          )
          (exists (?x_0 ?z_0 )
            (and
              (ElectronicEngineer ?x_0)
              (hasPersonalInfo ?z_0 ?x_0)
            )
          )
          (exists (?z_0 )
            (hasPersonalInfo ?z_0 ?z_0)
          )
          (exists (?x_0 )
            (and
              (FullName ?x_0)
              (SpecificationsAgent ?x_0)
            )
          )
          (exists (?x_0 )
            (and
              (FullName ?x_0)
              (ElectronicsAgent ?x_0)
            )
          )
          (exists (?x_0 )
            (and
              (FullName ?x_0)
              (ElectronicEngineer ?x_0)
            )
          )
          (exists (?x_0 ?z_0 )
            (and
              (hasPersonalInfo ?z_0 ?x_0)
              (SpecificationsAgent ?x_0)
            )
          )
          (exists (?x_0 ?z_0 )
            (and
              (SoftwareAgent ?x_0)
              (hasPersonalInfo ?z_0 ?x_0)
            )
          )
          (exists (?x_0 ?z_0 )
            (and
              (hasPersonalInfo ?x_0 ?z_0)
              (FullName ?x_0)
            )
          )
          (exists (?x_0 ?z_0 )
            (and
              (Designer ?x_0)
              (hasPersonalInfo ?z_0 ?x_0)
            )
          )
          (exists (?x_0 ?z_0 )
            (and
              (hasPersonalInfo ?z_0 ?x_0)
              (ElectronicsAgent ?x_0)
            )
          )
          (exists (?x_0 ?z_0 )
            (and
              (DesignAgent ?x_0)
              (hasPersonalInfo ?z_0 ?x_0)
            )
          )
          (exists (?x_0 ?z_0 )
            (and
              (Engineer ?x_0)
              (hasPersonalInfo ?z_0 ?x_0)
            )
          )
          (exists (?x_0 )
            (and
              (FullName ?x_0)
              (Employee ?x_0)
            )
          )
          (exists (?x_3 )
            (and
              (Developer ?x_3)
              (SpecificationsAgent ?x_3)
            )
          )
          (exists (?x_1 )
            (and
              (CodingAgent ?x_1)
              (Designer ?x_1)
            )
          )
          (exists (?x_0 )
            (and
              (FullName ?x_0)
              (Developer ?x_0)
            )
          )
          (exists (?x_0 ?z_0 )
            (and
              (MaterialsAgent ?x_0)
              (hasPersonalInfo ?z_0 ?x_0)
            )
          )
          (exists (?x_0 ?z_0 )
            (and
              (hasPersonalInfo ?z_0 ?x_0)
              (CodingAgent ?x_0)
            )
          )
          (exists (?x_0 )
            (and
              (TaskAgent ?x_0)
              (FullName ?x_0)
            )
          )
          (exists (?x_0 )
            (and
              (MaterialsEngineer ?x_0)
              (FullName ?x_0)
            )
          )
          (exists (?x_0 )
            (and
              (FullName ?x_0)
              (MaterialsAgent ?x_0)
            )
          )
          (exists (?x_0 ?z_0 )
            (and
              (ElectronicsAgent ?x_0)
              (hasPersonalInfo ?z_0 ?x_0)
            )
          )
          (exists (?x_4 )
            (and
              (ElectronicEngineer ?x_4)
              (InformaticEngineer ?x_4)
            )
          )
          (exists (?x_0 )
            (and
              (Engineer ?x_0)
              (FullName ?x_0)
            )
          )
          (exists (?x_8 )
            (and
              (SpecificationsAgent ?x_8)
              (MaterialsEngineer ?x_8)
            )
          )
          (exists (?x_0 ?z_0 )
            (and
              (MaterialsEngineer ?x_0)
              (hasPersonalInfo ?z_0 ?x_0)
            )
          )
          (exists (?x_5 )
            (and
              (MaterialsEngineer ?x_5)
              (ElectronicsAgent ?x_5)
            )
          )
          (exists (?x_0 )
            (and
              (InformaticEngineer ?x_0)
              (FullName ?x_0)
            )
          )
          (exists (?x_2 )
            (and
              (InformaticEngineer ?x_2)
              (ElectronicsAgent ?x_2)
            )
          )
          (exists (?x_8 )
            (and
              (CodingAgent ?x_8)
              (MaterialsEngineer ?x_8)
            )
          )
          (exists (?x_0 )
            (and
              (FullName ?x_0)
              (SoftwareAgent ?x_0)
            )
          )
          (exists (?x_0 ?z_0 )
            (and
              (hasPersonalInfo ?z_0 ?x_0)
              (Employee ?x_0)
            )
          )
          (exists (?x_7 )
            (and
              (ElectronicEngineer ?x_7)
              (CodingAgent ?x_7)
            )
          )
          (exists (?x_0 ?z_0 )
            (and
              (TaskAgent ?x_0)
              (hasPersonalInfo ?z_0 ?x_0)
            )
          )
          (exists (?x_0 )
            (and
              (FullName ?x_0)
              (Designer ?x_0)
            )
          )
          (exists (?x_1 )
            (and
              (SpecificationsAgent ?x_1)
              (Designer ?x_1)
            )
          )
        )
        (Error)
      )
    )
  )
)