(define
  (domain taskAssigment)
  (:requirements :adl)
  (:predicates
    (ElectronicsAgent ?x )
    (Designer ?x )
    (SoftwareAgent ?x )
    (InformaticEngineer ?x )
    (MaterialsAgent ?x )
    (DesignAgent ?x )
    (TaskAgent ?x )
    (MaterialsEngineer ?x )
    (CodingAgent ?x )
    (TestingAgent ?x )
    (ElectronicEngineer ?x )
    (Employee ?x )
    (FullName ?x )
    (Engineer ?x )
    (SpecificationsAgent ?x )
    (Developer ?x )
    (hasPersonalInfo ?x ?y )
    (CheckConsistency)
    (Error)
  )
  (:action assignElectronicsAgent
    :parameters ( ?x )
    :precondition ( and
      (not (CheckConsistency))
      (not (Error))
      (or
        (MaterialsAgent ?x)
        (TaskAgent ?x)
        (SpecificationsAgent ?x)
        (ElectronicsAgent ?x)
        (CodingAgent ?x)
        (DesignAgent ?x)
        (InformaticEngineer ?x)
        (Employee ?x)
        (TestingAgent ?x)
        (ElectronicEngineer ?x)
        (Developer ?x)
        (exists (?z_0 )
          (hasPersonalInfo ?x ?z_0)
        )
        (MaterialsEngineer ?x)
        (Designer ?x)
        (Engineer ?x)
        (SoftwareAgent ?x)
      )
    )
    :effect ( and
      (CheckConsistency)
      (when
        (= a a)
        (and
          (ElectronicsAgent ?x)
        )
      )
    )
  )
  (:action removePersonalInfo
    :parameters ( ?x ?y )
    :precondition ( and
      (not (CheckConsistency))
      (not (Error))
      (hasPersonalInfo ?x ?y)
    )
    :effect ( and
      (CheckConsistency)
      (when
        (= a a)
        (and
          (not (hasPersonalInfo ?x ?y))
        )
      )
    )
  )
  (:action assignSpecificationsAgent
    :parameters ( ?x )
    :precondition ( and
      (not (CheckConsistency))
      (not (Error))
      (or
        (MaterialsAgent ?x)
        (TaskAgent ?x)
        (SpecificationsAgent ?x)
        (ElectronicsAgent ?x)
        (CodingAgent ?x)
        (DesignAgent ?x)
        (InformaticEngineer ?x)
        (Employee ?x)
        (TestingAgent ?x)
        (ElectronicEngineer ?x)
        (Developer ?x)
        (exists (?z_0 )
          (hasPersonalInfo ?x ?z_0)
        )
        (MaterialsEngineer ?x)
        (Designer ?x)
        (Engineer ?x)
        (SoftwareAgent ?x)
      )
    )
    :effect ( and
      (CheckConsistency)
      (when
        (= a a)
        (and
          (SpecificationsAgent ?x)
        )
      )
    )
  )
  (:action hireInformaticEng
    :parameters ( ?n )
    :precondition ( and
      (not (CheckConsistency))
      (not (Error))
      (= a a)
    )
    :effect ( and
      (CheckConsistency)
      (when
        (not
          (exists ( ?x2 ?x3 ?x1 )
            (and
              (InformaticEngineer ?x2)
              (not
                (=?x1 ?x2 )
              )
              (InformaticEngineer ?x1)
              (not
                (=?x2 ?x3 )
              )
              (not
                (=?x1 ?x3 )
              )
              (InformaticEngineer ?x3)
            )
          )
        )
        (and
          (InformaticEngineer ?n)
        )
      )
    )
  )
  (:action assignCodingAgent
    :parameters ( ?x )
    :precondition ( and
      (not (CheckConsistency))
      (not (Error))
      (or
        (MaterialsAgent ?x)
        (TaskAgent ?x)
        (SpecificationsAgent ?x)
        (ElectronicsAgent ?x)
        (CodingAgent ?x)
        (DesignAgent ?x)
        (InformaticEngineer ?x)
        (Employee ?x)
        (TestingAgent ?x)
        (ElectronicEngineer ?x)
        (Developer ?x)
        (exists (?z_0 )
          (hasPersonalInfo ?x ?z_0)
        )
        (MaterialsEngineer ?x)
        (Designer ?x)
        (Engineer ?x)
        (SoftwareAgent ?x)
      )
    )
    :effect ( and
      (CheckConsistency)
      (when
        (= a a)
        (and
          (CodingAgent ?x)
        )
      )
    )
  )
  (:action assignSoftwareAgent
    :parameters ( ?x )
    :precondition ( and
      (not (CheckConsistency))
      (not (Error))
      (or
        (MaterialsAgent ?x)
        (TaskAgent ?x)
        (SpecificationsAgent ?x)
        (ElectronicsAgent ?x)
        (CodingAgent ?x)
        (DesignAgent ?x)
        (InformaticEngineer ?x)
        (Employee ?x)
        (TestingAgent ?x)
        (ElectronicEngineer ?x)
        (Developer ?x)
        (exists (?z_0 )
          (hasPersonalInfo ?x ?z_0)
        )
        (MaterialsEngineer ?x)
        (Designer ?x)
        (Engineer ?x)
        (SoftwareAgent ?x)
      )
    )
    :effect ( and
      (CheckConsistency)
      (when
        (= a a)
        (and
          (SoftwareAgent ?x)
        )
      )
    )
  )
  (:action hireElectronicEng
    :parameters ( ?n )
    :precondition ( and
      (not (CheckConsistency))
      (not (Error))
      (= a a)
    )
    :effect ( and
      (CheckConsistency)
      (when
        (not
          (exists ( ?x2 ?x3 ?x1 )
            (and
              (not
                (=?x1 ?x2 )
              )
              (ElectronicEngineer ?x2)
              (ElectronicEngineer ?x1)
              (not
                (=?x2 ?x3 )
              )
              (ElectronicEngineer ?x3)
              (not
                (=?x1 ?x3 )
              )
            )
          )
        )
        (and
          (ElectronicEngineer ?n)
        )
      )
    )
  )
  (:action assignTaskAgent
    :parameters ( ?x )
    :precondition ( and
      (not (CheckConsistency))
      (not (Error))
      (or
        (MaterialsAgent ?x)
        (TaskAgent ?x)
        (SpecificationsAgent ?x)
        (ElectronicsAgent ?x)
        (CodingAgent ?x)
        (DesignAgent ?x)
        (InformaticEngineer ?x)
        (Employee ?x)
        (TestingAgent ?x)
        (ElectronicEngineer ?x)
        (Developer ?x)
        (exists (?z_0 )
          (hasPersonalInfo ?x ?z_0)
        )
        (MaterialsEngineer ?x)
        (Designer ?x)
        (Engineer ?x)
        (SoftwareAgent ?x)
      )
    )
    :effect ( and
      (CheckConsistency)
      (when
        (= a a)
        (and
          (TaskAgent ?x)
        )
      )
    )
  )
  (:action assignMaterialsAgent
    :parameters ( ?x )
    :precondition ( and
      (not (CheckConsistency))
      (not (Error))
      (or
        (MaterialsAgent ?x)
        (TaskAgent ?x)
        (SpecificationsAgent ?x)
        (ElectronicsAgent ?x)
        (CodingAgent ?x)
        (DesignAgent ?x)
        (InformaticEngineer ?x)
        (Employee ?x)
        (TestingAgent ?x)
        (ElectronicEngineer ?x)
        (Developer ?x)
        (exists (?z_0 )
          (hasPersonalInfo ?x ?z_0)
        )
        (MaterialsEngineer ?x)
        (Designer ?x)
        (Engineer ?x)
        (SoftwareAgent ?x)
      )
    )
    :effect ( and
      (CheckConsistency)
      (when
        (= a a)
        (and
          (MaterialsAgent ?x)
        )
      )
    )
  )
  (:action assignDesignAgent
    :parameters ( ?x )
    :precondition ( and
      (not (CheckConsistency))
      (not (Error))
      (or
        (MaterialsAgent ?x)
        (TaskAgent ?x)
        (SpecificationsAgent ?x)
        (ElectronicsAgent ?x)
        (CodingAgent ?x)
        (DesignAgent ?x)
        (InformaticEngineer ?x)
        (Employee ?x)
        (TestingAgent ?x)
        (ElectronicEngineer ?x)
        (Developer ?x)
        (exists (?z_0 )
          (hasPersonalInfo ?x ?z_0)
        )
        (MaterialsEngineer ?x)
        (Designer ?x)
        (Engineer ?x)
        (SoftwareAgent ?x)
      )
    )
    :effect ( and
      (CheckConsistency)
      (when
        (= a a)
        (and
          (DesignAgent ?x)
        )
      )
    )
  )
  (:action assignTestingAgent
    :parameters ( ?x )
    :precondition ( and
      (not (CheckConsistency))
      (not (Error))
      (or
        (MaterialsAgent ?x)
        (TaskAgent ?x)
        (SpecificationsAgent ?x)
        (ElectronicsAgent ?x)
        (CodingAgent ?x)
        (DesignAgent ?x)
        (InformaticEngineer ?x)
        (Employee ?x)
        (TestingAgent ?x)
        (ElectronicEngineer ?x)
        (Developer ?x)
        (exists (?z_0 )
          (hasPersonalInfo ?x ?z_0)
        )
        (MaterialsEngineer ?x)
        (Designer ?x)
        (Engineer ?x)
        (SoftwareAgent ?x)
      )
    )
    :effect ( and
      (CheckConsistency)
      (when
        (= a a)
        (and
          (TestingAgent ?x)
        )
      )
    )
  )
  (:action CheckConsistencyAction
    :parameters ( )
    :precondition ( and
      (CheckConsistency)
      (not (Error))
    )
    :effect ( and
      (not (CheckConsistency))
      (when
        (or
          (exists (?x_6 )
            (and
              (SpecificationsAgent ?x_6)
              (MaterialsEngineer ?x_6)
            )
          )
          (exists (?x_8 )
            (and
              (ElectronicsAgent ?x_8)
              (InformaticEngineer ?x_8)
            )
          )
          (exists (?x_1 )
            (and
              (CodingAgent ?x_1)
              (ElectronicEngineer ?x_1)
            )
          )
          (exists (?x_7 )
            (and
              (Designer ?x_7)
              (FullName ?x_7)
            )
          )
          (exists (?x_7 )
            (and
              (CodingAgent ?x_7)
              (FullName ?x_7)
            )
          )
          (exists (?z_0 ?x_7 )
            (and
              (hasPersonalInfo ?z_0 ?x_7)
              (InformaticEngineer ?x_7)
            )
          )
          (exists (?z_0 ?x_7 )
            (and
              (hasPersonalInfo ?z_0 ?x_7)
              (TestingAgent ?x_7)
            )
          )
          (exists (?x_7 )
            (and
              (TestingAgent ?x_7)
              (FullName ?x_7)
            )
          )
          (exists (?z_0 ?x_7 )
            (and
              (hasPersonalInfo ?z_0 ?x_7)
              (DesignAgent ?x_7)
            )
          )
          (exists (?z_0 ?x_7 )
            (and
              (hasPersonalInfo ?z_0 ?x_7)
              (MaterialsEngineer ?x_7)
            )
          )
          (exists (?z_0 ?x_7 )
            (and
              (ElectronicEngineer ?x_7)
              (hasPersonalInfo ?z_0 ?x_7)
            )
          )
          (exists (?x_2 )
            (and
              (SoftwareAgent ?x_2)
              (Designer ?x_2)
            )
          )
          (exists (?z_0 ?x_7 )
            (and
              (SoftwareAgent ?x_7)
              (hasPersonalInfo ?z_0 ?x_7)
            )
          )
          (exists (?x_2 )
            (and
              (SpecificationsAgent ?x_2)
              (Designer ?x_2)
            )
          )
          (exists (?z_0 ?x_7 )
            (and
              (hasPersonalInfo ?z_0 ?x_7)
              (TaskAgent ?x_7)
            )
          )
          (exists (?x_2 )
            (and
              (CodingAgent ?x_2)
              (Designer ?x_2)
            )
          )
          (exists (?z_0 ?x_7 )
            (and
              (CodingAgent ?x_7)
              (hasPersonalInfo ?z_0 ?x_7)
            )
          )
          (exists (?x_7 )
            (and
              (Engineer ?x_7)
              (FullName ?x_7)
            )
          )
          (exists (?x_5 )
            (and
              (ElectronicsAgent ?x_5)
              (Designer ?x_5)
            )
          )
          (exists (?x_7 )
            (and
              (MaterialsAgent ?x_7)
              (FullName ?x_7)
            )
          )
          (exists (?x_0 )
            (and
              (MaterialsEngineer ?x_0)
              (ElectronicsAgent ?x_0)
            )
          )
          (exists (?x_7 )
            (and
              (SoftwareAgent ?x_7)
              (FullName ?x_7)
            )
          )
          (exists (?z_0 ?x_7 )
            (and
              (hasPersonalInfo ?x_7 ?z_0)
              (FullName ?x_7)
            )
          )
          (exists (?z_0 ?x_7 )
            (and
              (Developer ?x_7)
              (hasPersonalInfo ?z_0 ?x_7)
            )
          )
          (exists (?x_3 )
            (and
              (Developer ?x_3)
              (SpecificationsAgent ?x_3)
            )
          )
          (exists (?z_0 ?z_1 ?x_7 )
            (and
              (hasPersonalInfo ?x_7 ?z_0)
              (hasPersonalInfo ?z_1 ?x_7)
            )
          )
          (exists (?z_0 ?x_7 )
            (and
              (Employee ?x_7)
              (hasPersonalInfo ?z_0 ?x_7)
            )
          )
          (exists (?z_0 ?x_7 )
            (and
              (Designer ?x_7)
              (hasPersonalInfo ?z_0 ?x_7)
            )
          )
          (exists (?x_7 )
            (and
              (Developer ?x_7)
              (FullName ?x_7)
            )
          )
          (exists (?x_7 )
            (and
              (FullName ?x_7)
              (InformaticEngineer ?x_7)
            )
          )
          (exists (?x_7 )
            (and
              (ElectronicEngineer ?x_7)
              (FullName ?x_7)
            )
          )
          (exists (?x_6 )
            (and
              (CodingAgent ?x_6)
              (MaterialsEngineer ?x_6)
            )
          )
          (exists (?x_7 )
            (and
              (FullName ?x_7)
              (DesignAgent ?x_7)
            )
          )
          (exists (?x_7 )
            (and
              (Employee ?x_7)
              (FullName ?x_7)
            )
          )
          (exists (?x_7 )
            (and
              (ElectronicsAgent ?x_7)
              (FullName ?x_7)
            )
          )
          (exists (?x_7 )
            (and
              (TaskAgent ?x_7)
              (FullName ?x_7)
            )
          )
          (exists (?x_4 )
            (and
              (ElectronicEngineer ?x_4)
              (InformaticEngineer ?x_4)
            )
          )
          (exists (?z_0 ?x_7 )
            (and
              (ElectronicsAgent ?x_7)
              (hasPersonalInfo ?z_0 ?x_7)
            )
          )
          (exists (?x_7 )
            (and
              (SpecificationsAgent ?x_7)
              (FullName ?x_7)
            )
          )
          (exists (?x_6 )
            (and
              (SoftwareAgent ?x_6)
              (MaterialsEngineer ?x_6)
            )
          )
          (exists (?z_0 ?x_7 )
            (and
              (MaterialsAgent ?x_7)
              (hasPersonalInfo ?z_0 ?x_7)
            )
          )
          (exists (?z_0 ?x_7 )
            (and
              (hasPersonalInfo ?z_0 ?x_7)
              (Engineer ?x_7)
            )
          )
          (exists (?x_7 )
            (and
              (MaterialsEngineer ?x_7)
              (FullName ?x_7)
            )
          )
          (exists (?z_0 ?x_7 )
            (and
              (SpecificationsAgent ?x_7)
              (hasPersonalInfo ?z_0 ?x_7)
            )
          )
          (exists (?z_0 )
            (hasPersonalInfo ?z_0 ?z_0)
          )
        )
        (Error)
      )
    )
  )
)