(define
  (domain taskAssigment)
  (:requirements :adl)
  (:predicates
    (ElectronicsAgent ?x )
    (Designer ?x )
    (SoftwareAgent ?x )
    (InformaticEngineer ?x )
    (MaterialsAgent ?x )
    (DesignAgent ?x )
    (TaskAgent ?x )
    (MaterialsEngineer ?x )
    (CodingAgent ?x )
    (TestingAgent ?x )
    (ElectronicEngineer ?x )
    (Employee ?x )
    (FullName ?x )
    (Engineer ?x )
    (SpecificationsAgent ?x )
    (Developer ?x )
    (hasPersonalInfo ?x ?y )
    (CheckConsistency)
    (Error)
  )
  (:action assignSoftwareAgent
    :parameters ( ?x )
    :precondition ( and
      (not (CheckConsistency))
      (not (Error))
      (or
        (MaterialsAgent ?x)
        (Developer ?x)
        (SpecificationsAgent ?x)
        (ElectronicsAgent ?x)
        (CodingAgent ?x)
        (DesignAgent ?x)
        (InformaticEngineer ?x)
        (Employee ?x)
        (TestingAgent ?x)
        (ElectronicEngineer ?x)
        (exists (?z_0 )
          (hasPersonalInfo ?x ?z_0)
        )
        (MaterialsEngineer ?x)
        (Designer ?x)
        (TaskAgent ?x)
        (Engineer ?x)
        (SoftwareAgent ?x)
      )
    )
    :effect ( and
      (CheckConsistency)
      (when
        (= a a)
        (and
          (SoftwareAgent ?x)
        )
      )
    )
  )
  (:action hireElectronicEng
    :parameters ( ?n )
    :precondition ( and
      (not (CheckConsistency))
      (not (Error))
      (= a a)
    )
    :effect ( and
      (CheckConsistency)
      (when
        (not
          (exists ( ?x2 ?x3 ?x1 )
            (and
              (ElectronicEngineer ?x2)
              (not
                (=?x2 ?x3 )
              )
              (not
                (=?x1 ?x2 )
              )
              (not
                (=?x1 ?x3 )
              )
              (ElectronicEngineer ?x3)
              (ElectronicEngineer ?x1)
            )
          )
        )
        (and
          (ElectronicEngineer ?n)
        )
      )
    )
  )
  (:action assignTaskAgent
    :parameters ( ?x )
    :precondition ( and
      (not (CheckConsistency))
      (not (Error))
      (or
        (MaterialsAgent ?x)
        (Developer ?x)
        (SpecificationsAgent ?x)
        (ElectronicsAgent ?x)
        (CodingAgent ?x)
        (DesignAgent ?x)
        (InformaticEngineer ?x)
        (Employee ?x)
        (TestingAgent ?x)
        (ElectronicEngineer ?x)
        (exists (?z_0 )
          (hasPersonalInfo ?x ?z_0)
        )
        (MaterialsEngineer ?x)
        (Designer ?x)
        (TaskAgent ?x)
        (Engineer ?x)
        (SoftwareAgent ?x)
      )
    )
    :effect ( and
      (CheckConsistency)
      (when
        (= a a)
        (and
          (TaskAgent ?x)
        )
      )
    )
  )
  (:action assignMaterialsAgent
    :parameters ( ?x )
    :precondition ( and
      (not (CheckConsistency))
      (not (Error))
      (or
        (MaterialsAgent ?x)
        (Developer ?x)
        (SpecificationsAgent ?x)
        (ElectronicsAgent ?x)
        (CodingAgent ?x)
        (DesignAgent ?x)
        (InformaticEngineer ?x)
        (Employee ?x)
        (TestingAgent ?x)
        (ElectronicEngineer ?x)
        (exists (?z_0 )
          (hasPersonalInfo ?x ?z_0)
        )
        (MaterialsEngineer ?x)
        (Designer ?x)
        (TaskAgent ?x)
        (Engineer ?x)
        (SoftwareAgent ?x)
      )
    )
    :effect ( and
      (CheckConsistency)
      (when
        (= a a)
        (and
          (MaterialsAgent ?x)
        )
      )
    )
  )
  (:action removePersonalInfo
    :parameters ( ?x ?y )
    :precondition ( and
      (not (CheckConsistency))
      (not (Error))
      (hasPersonalInfo ?x ?y)
    )
    :effect ( and
      (CheckConsistency)
      (when
        (= a a)
        (and
          (not (hasPersonalInfo ?x ?y))
        )
      )
    )
  )
  (:action assignElectronicsAgent
    :parameters ( ?x )
    :precondition ( and
      (not (CheckConsistency))
      (not (Error))
      (or
        (MaterialsAgent ?x)
        (Developer ?x)
        (SpecificationsAgent ?x)
        (ElectronicsAgent ?x)
        (CodingAgent ?x)
        (DesignAgent ?x)
        (InformaticEngineer ?x)
        (Employee ?x)
        (TestingAgent ?x)
        (ElectronicEngineer ?x)
        (exists (?z_0 )
          (hasPersonalInfo ?x ?z_0)
        )
        (MaterialsEngineer ?x)
        (Designer ?x)
        (TaskAgent ?x)
        (Engineer ?x)
        (SoftwareAgent ?x)
      )
    )
    :effect ( and
      (CheckConsistency)
      (when
        (= a a)
        (and
          (ElectronicsAgent ?x)
        )
      )
    )
  )
  (:action assignTestingAgent
    :parameters ( ?x )
    :precondition ( and
      (not (CheckConsistency))
      (not (Error))
      (or
        (MaterialsAgent ?x)
        (Developer ?x)
        (SpecificationsAgent ?x)
        (ElectronicsAgent ?x)
        (CodingAgent ?x)
        (DesignAgent ?x)
        (InformaticEngineer ?x)
        (Employee ?x)
        (TestingAgent ?x)
        (ElectronicEngineer ?x)
        (exists (?z_0 )
          (hasPersonalInfo ?x ?z_0)
        )
        (MaterialsEngineer ?x)
        (Designer ?x)
        (TaskAgent ?x)
        (Engineer ?x)
        (SoftwareAgent ?x)
      )
    )
    :effect ( and
      (CheckConsistency)
      (when
        (= a a)
        (and
          (TestingAgent ?x)
        )
      )
    )
  )
  (:action assignCodingAgent
    :parameters ( ?x )
    :precondition ( and
      (not (CheckConsistency))
      (not (Error))
      (or
        (MaterialsAgent ?x)
        (Developer ?x)
        (SpecificationsAgent ?x)
        (ElectronicsAgent ?x)
        (CodingAgent ?x)
        (DesignAgent ?x)
        (InformaticEngineer ?x)
        (Employee ?x)
        (TestingAgent ?x)
        (ElectronicEngineer ?x)
        (exists (?z_0 )
          (hasPersonalInfo ?x ?z_0)
        )
        (MaterialsEngineer ?x)
        (Designer ?x)
        (TaskAgent ?x)
        (Engineer ?x)
        (SoftwareAgent ?x)
      )
    )
    :effect ( and
      (CheckConsistency)
      (when
        (= a a)
        (and
          (CodingAgent ?x)
        )
      )
    )
  )
  (:action hireInformaticEng
    :parameters ( ?n )
    :precondition ( and
      (not (CheckConsistency))
      (not (Error))
      (= a a)
    )
    :effect ( and
      (CheckConsistency)
      (when
        (not
          (exists ( ?x2 ?x3 ?x1 )
            (and
              (InformaticEngineer ?x1)
              (InformaticEngineer ?x3)
              (InformaticEngineer ?x2)
              (not
                (=?x2 ?x3 )
              )
              (not
                (=?x1 ?x3 )
              )
              (not
                (=?x1 ?x2 )
              )
            )
          )
        )
        (and
          (InformaticEngineer ?n)
        )
      )
    )
  )
  (:action assignSpecificationsAgent
    :parameters ( ?x )
    :precondition ( and
      (not (CheckConsistency))
      (not (Error))
      (or
        (MaterialsAgent ?x)
        (Developer ?x)
        (SpecificationsAgent ?x)
        (ElectronicsAgent ?x)
        (CodingAgent ?x)
        (DesignAgent ?x)
        (InformaticEngineer ?x)
        (Employee ?x)
        (TestingAgent ?x)
        (ElectronicEngineer ?x)
        (exists (?z_0 )
          (hasPersonalInfo ?x ?z_0)
        )
        (MaterialsEngineer ?x)
        (Designer ?x)
        (TaskAgent ?x)
        (Engineer ?x)
        (SoftwareAgent ?x)
      )
    )
    :effect ( and
      (CheckConsistency)
      (when
        (= a a)
        (and
          (SpecificationsAgent ?x)
        )
      )
    )
  )
  (:action assignDesignAgent
    :parameters ( ?x )
    :precondition ( and
      (not (CheckConsistency))
      (not (Error))
      (or
        (MaterialsAgent ?x)
        (Developer ?x)
        (SpecificationsAgent ?x)
        (ElectronicsAgent ?x)
        (CodingAgent ?x)
        (DesignAgent ?x)
        (InformaticEngineer ?x)
        (Employee ?x)
        (TestingAgent ?x)
        (ElectronicEngineer ?x)
        (exists (?z_0 )
          (hasPersonalInfo ?x ?z_0)
        )
        (MaterialsEngineer ?x)
        (Designer ?x)
        (TaskAgent ?x)
        (Engineer ?x)
        (SoftwareAgent ?x)
      )
    )
    :effect ( and
      (CheckConsistency)
      (when
        (= a a)
        (and
          (DesignAgent ?x)
        )
      )
    )
  )
  (:action CheckConsistencyAction
    :parameters ( )
    :precondition ( and
      (CheckConsistency)
      (not (Error))
    )
    :effect ( and
      (not (CheckConsistency))
      (when
        (or
          (exists (?x_6 )
            (and
              (SpecificationsAgent ?x_6)
              (MaterialsEngineer ?x_6)
            )
          )
          (exists (?x_4 )
            (and
              (ElectronicEngineer ?x_4)
              (FullName ?x_4)
            )
          )
          (exists (?z_0 ?x_4 )
            (and
              (SoftwareAgent ?x_4)
              (hasPersonalInfo ?z_0 ?x_4)
            )
          )
          (exists (?x_4 )
            (and
              (CodingAgent ?x_4)
              (FullName ?x_4)
            )
          )
          (exists (?z_0 ?x_4 )
            (and
              (Developer ?x_4)
              (hasPersonalInfo ?z_0 ?x_4)
            )
          )
          (exists (?x_7 )
            (and
              (Designer ?x_7)
              (CodingAgent ?x_7)
            )
          )
          (exists (?z_0 ?x_4 )
            (and
              (hasPersonalInfo ?x_4 ?z_0)
              (FullName ?x_4)
            )
          )
          (exists (?x_8 )
            (and
              (ElectronicsAgent ?x_8)
              (Designer ?x_8)
            )
          )
          (exists (?z_0 ?x_4 )
            (and
              (Employee ?x_4)
              (hasPersonalInfo ?z_0 ?x_4)
            )
          )
          (exists (?x_4 )
            (and
              (Employee ?x_4)
              (FullName ?x_4)
            )
          )
          (exists (?z_0 ?x_4 )
            (and
              (ElectronicsAgent ?x_4)
              (hasPersonalInfo ?z_0 ?x_4)
            )
          )
          (exists (?z_0 ?x_4 )
            (and
              (hasPersonalInfo ?z_0 ?x_4)
              (TestingAgent ?x_4)
            )
          )
          (exists (?z_0 ?x_4 )
            (and
              (MaterialsAgent ?x_4)
              (hasPersonalInfo ?z_0 ?x_4)
            )
          )
          (exists (?x_4 )
            (and
              (FullName ?x_4)
              (DesignAgent ?x_4)
            )
          )
          (exists (?x_4 )
            (and
              (InformaticEngineer ?x_4)
              (FullName ?x_4)
            )
          )
          (exists (?z_0 ?x_4 )
            (and
              (hasPersonalInfo ?z_0 ?x_4)
              (MaterialsEngineer ?x_4)
            )
          )
          (exists (?x_0 )
            (and
              (ElectronicEngineer ?x_0)
              (CodingAgent ?x_0)
            )
          )
          (exists (?z_0 ?x_4 )
            (and
              (hasPersonalInfo ?z_0 ?x_4)
              (ElectronicsAgent ?x_4)
            )
          )
          (exists (?x_4 )
            (and
              (MaterialsEngineer ?x_4)
              (FullName ?x_4)
            )
          )
          (exists (?x_4 )
            (and
              (TaskAgent ?x_4)
              (FullName ?x_4)
            )
          )
          (exists (?x_1 )
            (and
              (ElectronicEngineer ?x_1)
              (InformaticEngineer ?x_1)
            )
          )
          (exists (?z_0 ?x_4 )
            (and
              (hasPersonalInfo ?z_0 ?x_4)
              (InformaticEngineer ?x_4)
            )
          )
          (exists (?z_0 ?x_4 )
            (and
              (ElectronicEngineer ?x_4)
              (hasPersonalInfo ?z_0 ?x_4)
            )
          )
          (exists (?x_4 )
            (and
              (TestingAgent ?x_4)
              (FullName ?x_4)
            )
          )
          (exists (?z_0 ?x_4 )
            (and
              (hasPersonalInfo ?z_0 ?x_4)
              (CodingAgent ?x_4)
            )
          )
          (exists (?z_0 ?z_1 ?x_4 )
            (and
              (hasPersonalInfo ?z_1 ?x_4)
              (hasPersonalInfo ?x_4 ?z_0)
            )
          )
          (exists (?x_7 )
            (and
              (Designer ?x_7)
              (SoftwareAgent ?x_7)
            )
          )
          (exists (?x_4 )
            (and
              (Designer ?x_4)
              (FullName ?x_4)
            )
          )
          (exists (?x_3 )
            (and
              (MaterialsEngineer ?x_3)
              (ElectronicsAgent ?x_3)
            )
          )
          (exists (?x_4 )
            (and
              (MaterialsAgent ?x_4)
              (FullName ?x_4)
            )
          )
          (exists (?x_4 )
            (and
              (SoftwareAgent ?x_4)
              (FullName ?x_4)
            )
          )
          (exists (?x_6 )
            (and
              (CodingAgent ?x_6)
              (MaterialsEngineer ?x_6)
            )
          )
          (exists (?x_4 )
            (and
              (ElectronicsAgent ?x_4)
              (FullName ?x_4)
            )
          )
          (exists (?x_5 )
            (and
              (SpecificationsAgent ?x_5)
              (Developer ?x_5)
            )
          )
          (exists (?x_7 )
            (and
              (Designer ?x_7)
              (SpecificationsAgent ?x_7)
            )
          )
          (exists (?x_4 )
            (and
              (SpecificationsAgent ?x_4)
              (FullName ?x_4)
            )
          )
          (exists (?z_0 ?x_4 )
            (and
              (hasPersonalInfo ?z_0 ?x_4)
              (SpecificationsAgent ?x_4)
            )
          )
          (exists (?z_0 ?x_4 )
            (and
              (hasPersonalInfo ?z_0 ?x_4)
              (DesignAgent ?x_4)
            )
          )
          (exists (?x_4 )
            (and
              (Engineer ?x_4)
              (FullName ?x_4)
            )
          )
          (exists (?x_2 )
            (and
              (InformaticEngineer ?x_2)
              (ElectronicsAgent ?x_2)
            )
          )
          (exists (?x_6 )
            (and
              (SoftwareAgent ?x_6)
              (MaterialsEngineer ?x_6)
            )
          )
          (exists (?z_0 ?x_4 )
            (and
              (Designer ?x_4)
              (hasPersonalInfo ?z_0 ?x_4)
            )
          )
          (exists (?z_0 ?x_4 )
            (and
              (hasPersonalInfo ?z_0 ?x_4)
              (TaskAgent ?x_4)
            )
          )
          (exists (?x_4 )
            (and
              (Developer ?x_4)
              (FullName ?x_4)
            )
          )
          (exists (?z_0 ?x_4 )
            (and
              (hasPersonalInfo ?z_0 ?x_4)
              (Engineer ?x_4)
            )
          )
          (exists (?z_0 )
            (hasPersonalInfo ?z_0 ?z_0)
          )
        )
        (Error)
      )
    )
  )
)