(define
  (domain taskAssigment)
  (:requirements :adl)
  (:predicates
    (ElectronicsAgent ?x )
    (Designer ?x )
    (SoftwareAgent ?x )
    (InformaticEngineer ?x )
    (MaterialsAgent ?x )
    (DesignAgent ?x )
    (TaskAgent ?x )
    (MaterialsEngineer ?x )
    (CodingAgent ?x )
    (TestingAgent ?x )
    (ElectronicEngineer ?x )
    (Employee ?x )
    (FullName ?x )
    (Engineer ?x )
    (SpecificationsAgent ?x )
    (Developer ?x )
    (hasPersonalInfo ?x ?y )
    (CheckConsistency)
    (Error)
  )
  (:action assignElectronicsAgent
    :parameters ( ?x )
    :precondition ( and
      (not (CheckConsistency))
      (not (Error))
      (or
        (MaterialsAgent ?x)
        (Developer ?x)
        (SpecificationsAgent ?x)
        (ElectronicsAgent ?x)
        (CodingAgent ?x)
        (DesignAgent ?x)
        (InformaticEngineer ?x)
        (Employee ?x)
        (TestingAgent ?x)
        (ElectronicEngineer ?x)
        (exists (?z_0 )
          (hasPersonalInfo ?x ?z_0)
        )
        (MaterialsEngineer ?x)
        (Designer ?x)
        (TaskAgent ?x)
        (Engineer ?x)
        (SoftwareAgent ?x)
      )
    )
    :effect ( and
      (CheckConsistency)
      (when
        (= a a)
        (and
          (ElectronicsAgent ?x)
        )
      )
    )
  )
  (:action assignDesignAgent
    :parameters ( ?x )
    :precondition ( and
      (not (CheckConsistency))
      (not (Error))
      (or
        (MaterialsAgent ?x)
        (Developer ?x)
        (SpecificationsAgent ?x)
        (ElectronicsAgent ?x)
        (CodingAgent ?x)
        (DesignAgent ?x)
        (InformaticEngineer ?x)
        (Employee ?x)
        (TestingAgent ?x)
        (ElectronicEngineer ?x)
        (exists (?z_0 )
          (hasPersonalInfo ?x ?z_0)
        )
        (MaterialsEngineer ?x)
        (Designer ?x)
        (TaskAgent ?x)
        (Engineer ?x)
        (SoftwareAgent ?x)
      )
    )
    :effect ( and
      (CheckConsistency)
      (when
        (= a a)
        (and
          (DesignAgent ?x)
        )
      )
    )
  )
  (:action assignSpecificationsAgent
    :parameters ( ?x )
    :precondition ( and
      (not (CheckConsistency))
      (not (Error))
      (or
        (MaterialsAgent ?x)
        (Developer ?x)
        (SpecificationsAgent ?x)
        (ElectronicsAgent ?x)
        (CodingAgent ?x)
        (DesignAgent ?x)
        (InformaticEngineer ?x)
        (Employee ?x)
        (TestingAgent ?x)
        (ElectronicEngineer ?x)
        (exists (?z_0 )
          (hasPersonalInfo ?x ?z_0)
        )
        (MaterialsEngineer ?x)
        (Designer ?x)
        (TaskAgent ?x)
        (Engineer ?x)
        (SoftwareAgent ?x)
      )
    )
    :effect ( and
      (CheckConsistency)
      (when
        (= a a)
        (and
          (SpecificationsAgent ?x)
        )
      )
    )
  )
  (:action assignMaterialsAgent
    :parameters ( ?x )
    :precondition ( and
      (not (CheckConsistency))
      (not (Error))
      (or
        (MaterialsAgent ?x)
        (Developer ?x)
        (SpecificationsAgent ?x)
        (ElectronicsAgent ?x)
        (CodingAgent ?x)
        (DesignAgent ?x)
        (InformaticEngineer ?x)
        (Employee ?x)
        (TestingAgent ?x)
        (ElectronicEngineer ?x)
        (exists (?z_0 )
          (hasPersonalInfo ?x ?z_0)
        )
        (MaterialsEngineer ?x)
        (Designer ?x)
        (TaskAgent ?x)
        (Engineer ?x)
        (SoftwareAgent ?x)
      )
    )
    :effect ( and
      (CheckConsistency)
      (when
        (= a a)
        (and
          (MaterialsAgent ?x)
        )
      )
    )
  )
  (:action removePersonalInfo
    :parameters ( ?x ?y )
    :precondition ( and
      (not (CheckConsistency))
      (not (Error))
      (hasPersonalInfo ?x ?y)
    )
    :effect ( and
      (CheckConsistency)
      (when
        (= a a)
        (and
          (not (hasPersonalInfo ?x ?y))
        )
      )
    )
  )
  (:action assignTaskAgent
    :parameters ( ?x )
    :precondition ( and
      (not (CheckConsistency))
      (not (Error))
      (or
        (MaterialsAgent ?x)
        (Developer ?x)
        (SpecificationsAgent ?x)
        (ElectronicsAgent ?x)
        (CodingAgent ?x)
        (DesignAgent ?x)
        (InformaticEngineer ?x)
        (Employee ?x)
        (TestingAgent ?x)
        (ElectronicEngineer ?x)
        (exists (?z_0 )
          (hasPersonalInfo ?x ?z_0)
        )
        (MaterialsEngineer ?x)
        (Designer ?x)
        (TaskAgent ?x)
        (Engineer ?x)
        (SoftwareAgent ?x)
      )
    )
    :effect ( and
      (CheckConsistency)
      (when
        (= a a)
        (and
          (TaskAgent ?x)
        )
      )
    )
  )
  (:action assignCodingAgent
    :parameters ( ?x )
    :precondition ( and
      (not (CheckConsistency))
      (not (Error))
      (or
        (MaterialsAgent ?x)
        (Developer ?x)
        (SpecificationsAgent ?x)
        (ElectronicsAgent ?x)
        (CodingAgent ?x)
        (DesignAgent ?x)
        (InformaticEngineer ?x)
        (Employee ?x)
        (TestingAgent ?x)
        (ElectronicEngineer ?x)
        (exists (?z_0 )
          (hasPersonalInfo ?x ?z_0)
        )
        (MaterialsEngineer ?x)
        (Designer ?x)
        (TaskAgent ?x)
        (Engineer ?x)
        (SoftwareAgent ?x)
      )
    )
    :effect ( and
      (CheckConsistency)
      (when
        (= a a)
        (and
          (CodingAgent ?x)
        )
      )
    )
  )
  (:action assignSoftwareAgent
    :parameters ( ?x )
    :precondition ( and
      (not (CheckConsistency))
      (not (Error))
      (or
        (MaterialsAgent ?x)
        (Developer ?x)
        (SpecificationsAgent ?x)
        (ElectronicsAgent ?x)
        (CodingAgent ?x)
        (DesignAgent ?x)
        (InformaticEngineer ?x)
        (Employee ?x)
        (TestingAgent ?x)
        (ElectronicEngineer ?x)
        (exists (?z_0 )
          (hasPersonalInfo ?x ?z_0)
        )
        (MaterialsEngineer ?x)
        (Designer ?x)
        (TaskAgent ?x)
        (Engineer ?x)
        (SoftwareAgent ?x)
      )
    )
    :effect ( and
      (CheckConsistency)
      (when
        (= a a)
        (and
          (SoftwareAgent ?x)
        )
      )
    )
  )
  (:action hireInformaticEng
    :parameters ( ?n )
    :precondition ( and
      (not (CheckConsistency))
      (not (Error))
      (= a a)
    )
    :effect ( and
      (CheckConsistency)
      (when
        (not
          (exists ( ?x2 ?x3 ?x1 )
            (and
              (InformaticEngineer ?x2)
              (not
                (=?x2 ?x3 )
              )
              (InformaticEngineer ?x3)
              (not
                (=?x1 ?x3 )
              )
              (InformaticEngineer ?x1)
              (not
                (=?x1 ?x2 )
              )
            )
          )
        )
        (and
          (InformaticEngineer ?n)
        )
      )
    )
  )
  (:action assignTestingAgent
    :parameters ( ?x )
    :precondition ( and
      (not (CheckConsistency))
      (not (Error))
      (or
        (MaterialsAgent ?x)
        (Developer ?x)
        (SpecificationsAgent ?x)
        (ElectronicsAgent ?x)
        (CodingAgent ?x)
        (DesignAgent ?x)
        (InformaticEngineer ?x)
        (Employee ?x)
        (TestingAgent ?x)
        (ElectronicEngineer ?x)
        (exists (?z_0 )
          (hasPersonalInfo ?x ?z_0)
        )
        (MaterialsEngineer ?x)
        (Designer ?x)
        (TaskAgent ?x)
        (Engineer ?x)
        (SoftwareAgent ?x)
      )
    )
    :effect ( and
      (CheckConsistency)
      (when
        (= a a)
        (and
          (TestingAgent ?x)
        )
      )
    )
  )
  (:action hireElectronicEng
    :parameters ( ?n )
    :precondition ( and
      (not (CheckConsistency))
      (not (Error))
      (= a a)
    )
    :effect ( and
      (CheckConsistency)
      (when
        (not
          (exists ( ?x2 ?x3 ?x1 )
            (and
              (ElectronicEngineer ?x1)
              (ElectronicEngineer ?x2)
              (not
                (=?x2 ?x3 )
              )
              (ElectronicEngineer ?x3)
              (not
                (=?x1 ?x2 )
              )
              (not
                (=?x1 ?x3 )
              )
            )
          )
        )
        (and
          (ElectronicEngineer ?n)
        )
      )
    )
  )
  (:action CheckConsistencyAction
    :parameters ( )
    :precondition ( and
      (CheckConsistency)
      (not (Error))
    )
    :effect ( and
      (not (CheckConsistency))
      (when
        (or
          (exists (?x_5 )
            (and
              (FullName ?x_5)
              (SoftwareAgent ?x_5)
            )
          )
          (exists (?x_3 )
            (and
              (ElectronicsAgent ?x_3)
              (Designer ?x_3)
            )
          )
          (exists (?z_0 ?x_5 )
            (and
              (Engineer ?x_5)
              (hasPersonalInfo ?z_0 ?x_5)
            )
          )
          (exists (?z_0 ?x_5 )
            (and
              (hasPersonalInfo ?z_0 ?x_5)
              (CodingAgent ?x_5)
            )
          )
          (exists (?x_7 )
            (and
              (Designer ?x_7)
              (CodingAgent ?x_7)
            )
          )
          (exists (?z_0 ?x_5 )
            (and
              (hasPersonalInfo ?z_0 ?x_5)
              (ElectronicEngineer ?x_5)
            )
          )
          (exists (?x_5 )
            (and
              (FullName ?x_5)
              (DesignAgent ?x_5)
            )
          )
          (exists (?x_5 )
            (and
              (FullName ?x_5)
              (ElectronicEngineer ?x_5)
            )
          )
          (exists (?z_0 ?x_5 )
            (and
              (hasPersonalInfo ?z_0 ?x_5)
              (Employee ?x_5)
            )
          )
          (exists (?z_0 ?x_5 )
            (and
              (hasPersonalInfo ?z_0 ?x_5)
              (Designer ?x_5)
            )
          )
          (exists (?x_5 )
            (and
              (FullName ?x_5)
              (Employee ?x_5)
            )
          )
          (exists (?z_0 ?x_5 )
            (and
              (TaskAgent ?x_5)
              (hasPersonalInfo ?z_0 ?x_5)
            )
          )
          (exists (?x_5 )
            (and
              (FullName ?x_5)
              (CodingAgent ?x_5)
            )
          )
          (exists (?z_0 ?x_5 )
            (and
              (FullName ?x_5)
              (hasPersonalInfo ?x_5 ?z_0)
            )
          )
          (exists (?x_1 )
            (and
              (SpecificationsAgent ?x_1)
              (MaterialsEngineer ?x_1)
            )
          )
          (exists (?z_0 ?x_5 )
            (and
              (TestingAgent ?x_5)
              (hasPersonalInfo ?z_0 ?x_5)
            )
          )
          (exists (?x_5 )
            (and
              (FullName ?x_5)
              (TestingAgent ?x_5)
            )
          )
          (exists (?x_5 )
            (and
              (FullName ?x_5)
              (TaskAgent ?x_5)
            )
          )
          (exists (?x_5 )
            (and
              (FullName ?x_5)
              (Designer ?x_5)
            )
          )
          (exists (?x_5 )
            (and
              (FullName ?x_5)
              (InformaticEngineer ?x_5)
            )
          )
          (exists (?z_0 ?x_5 )
            (and
              (hasPersonalInfo ?z_0 ?x_5)
              (MaterialsAgent ?x_5)
            )
          )
          (exists (?x_7 )
            (and
              (Designer ?x_7)
              (SoftwareAgent ?x_7)
            )
          )
          (exists (?z_0 ?x_5 )
            (and
              (MaterialsEngineer ?x_5)
              (hasPersonalInfo ?z_0 ?x_5)
            )
          )
          (exists (?z_0 ?x_5 )
            (and
              (hasPersonalInfo ?z_0 ?x_5)
              (SoftwareAgent ?x_5)
            )
          )
          (exists (?x_1 )
            (and
              (SoftwareAgent ?x_1)
              (MaterialsEngineer ?x_1)
            )
          )
          (exists (?x_1 )
            (and
              (CodingAgent ?x_1)
              (MaterialsEngineer ?x_1)
            )
          )
          (exists (?x_7 )
            (and
              (Designer ?x_7)
              (SpecificationsAgent ?x_7)
            )
          )
          (exists (?x_6 )
            (and
              (CodingAgent ?x_6)
              (ElectronicEngineer ?x_6)
            )
          )
          (exists (?x_4 )
            (and
              (ElectronicEngineer ?x_4)
              (InformaticEngineer ?x_4)
            )
          )
          (exists (?z_0 ?x_5 )
            (and
              (InformaticEngineer ?x_5)
              (hasPersonalInfo ?z_0 ?x_5)
            )
          )
          (exists (?x_5 )
            (and
              (FullName ?x_5)
              (SpecificationsAgent ?x_5)
            )
          )
          (exists (?z_0 ?x_5 )
            (and
              (hasPersonalInfo ?z_0 ?x_5)
              (Developer ?x_5)
            )
          )
          (exists (?x_5 )
            (and
              (FullName ?x_5)
              (Engineer ?x_5)
            )
          )
          (exists (?x_5 )
            (and
              (FullName ?x_5)
              (Developer ?x_5)
            )
          )
          (exists (?x_8 )
            (and
              (ElectronicsAgent ?x_8)
              (MaterialsEngineer ?x_8)
            )
          )
          (exists (?z_0 ?x_5 )
            (and
              (hasPersonalInfo ?z_0 ?x_5)
              (ElectronicsAgent ?x_5)
            )
          )
          (exists (?x_2 )
            (and
              (InformaticEngineer ?x_2)
              (ElectronicsAgent ?x_2)
            )
          )
          (exists (?z_0 ?x_5 )
            (and
              (hasPersonalInfo ?z_0 ?x_5)
              (SpecificationsAgent ?x_5)
            )
          )
          (exists (?x_0 )
            (and
              (Developer ?x_0)
              (SpecificationsAgent ?x_0)
            )
          )
          (exists (?z_0 ?x_5 )
            (and
              (DesignAgent ?x_5)
              (hasPersonalInfo ?z_0 ?x_5)
            )
          )
          (exists (?x_5 )
            (and
              (FullName ?x_5)
              (MaterialsEngineer ?x_5)
            )
          )
          (exists (?x_5 )
            (and
              (FullName ?x_5)
              (MaterialsAgent ?x_5)
            )
          )
          (exists (?z_0 ?z_1 ?x_5 )
            (and
              (hasPersonalInfo ?z_0 ?x_5)
              (hasPersonalInfo ?x_5 ?z_1)
            )
          )
          (exists (?z_0 )
            (hasPersonalInfo ?z_0 ?z_0)
          )
          (exists (?x_5 )
            (and
              (FullName ?x_5)
              (ElectronicsAgent ?x_5)
            )
          )
        )
        (Error)
      )
    )
  )
)