(define
  (domain taskAssigment)
  (:requirements :adl)
  (:predicates
    (ElectronicsAgent ?x )
    (Designer ?x )
    (SoftwareAgent ?x )
    (InformaticEngineer ?x )
    (MaterialsAgent ?x )
    (DesignAgent ?x )
    (TaskAgent ?x )
    (MaterialsEngineer ?x )
    (CodingAgent ?x )
    (TestingAgent ?x )
    (ElectronicEngineer ?x )
    (Employee ?x )
    (FullName ?x )
    (Engineer ?x )
    (SpecificationsAgent ?x )
    (Developer ?x )
    (hasPersonalInfo ?x ?y )
    (CheckConsistency)
    (Error)
  )
  (:action assignCodingAgent
    :parameters ( ?x )
    :precondition ( and
      (not (CheckConsistency))
      (not (Error))
      (or
        (MaterialsAgent ?x)
        (Developer ?x)
        (SpecificationsAgent ?x)
        (ElectronicsAgent ?x)
        (CodingAgent ?x)
        (DesignAgent ?x)
        (InformaticEngineer ?x)
        (Employee ?x)
        (TestingAgent ?x)
        (ElectronicEngineer ?x)
        (exists (?z_0 )
          (hasPersonalInfo ?x ?z_0)
        )
        (MaterialsEngineer ?x)
        (Designer ?x)
        (TaskAgent ?x)
        (Engineer ?x)
        (SoftwareAgent ?x)
      )
    )
    :effect ( and
      (CheckConsistency)
      (when
        (= a a)
        (and
          (CodingAgent ?x)
        )
      )
    )
  )
  (:action hireInformaticEng
    :parameters ( ?n )
    :precondition ( and
      (not (CheckConsistency))
      (not (Error))
      (= a a)
    )
    :effect ( and
      (CheckConsistency)
      (when
        (not
          (exists ( ?x2 ?x3 ?x1 )
            (and
              (not
                (=?x2 ?x3 )
              )
              (not
                (=?x1 ?x3 )
              )
              (not
                (=?x1 ?x2 )
              )
              (InformaticEngineer ?x3)
              (InformaticEngineer ?x1)
              (InformaticEngineer ?x2)
            )
          )
        )
        (and
          (InformaticEngineer ?n)
        )
      )
    )
  )
  (:action assignDesignAgent
    :parameters ( ?x )
    :precondition ( and
      (not (CheckConsistency))
      (not (Error))
      (or
        (MaterialsAgent ?x)
        (Developer ?x)
        (SpecificationsAgent ?x)
        (ElectronicsAgent ?x)
        (CodingAgent ?x)
        (DesignAgent ?x)
        (InformaticEngineer ?x)
        (Employee ?x)
        (TestingAgent ?x)
        (ElectronicEngineer ?x)
        (exists (?z_0 )
          (hasPersonalInfo ?x ?z_0)
        )
        (MaterialsEngineer ?x)
        (Designer ?x)
        (TaskAgent ?x)
        (Engineer ?x)
        (SoftwareAgent ?x)
      )
    )
    :effect ( and
      (CheckConsistency)
      (when
        (= a a)
        (and
          (DesignAgent ?x)
        )
      )
    )
  )
  (:action assignTestingAgent
    :parameters ( ?x )
    :precondition ( and
      (not (CheckConsistency))
      (not (Error))
      (or
        (MaterialsAgent ?x)
        (Developer ?x)
        (SpecificationsAgent ?x)
        (ElectronicsAgent ?x)
        (CodingAgent ?x)
        (DesignAgent ?x)
        (InformaticEngineer ?x)
        (Employee ?x)
        (TestingAgent ?x)
        (ElectronicEngineer ?x)
        (exists (?z_0 )
          (hasPersonalInfo ?x ?z_0)
        )
        (MaterialsEngineer ?x)
        (Designer ?x)
        (TaskAgent ?x)
        (Engineer ?x)
        (SoftwareAgent ?x)
      )
    )
    :effect ( and
      (CheckConsistency)
      (when
        (= a a)
        (and
          (TestingAgent ?x)
        )
      )
    )
  )
  (:action assignTaskAgent
    :parameters ( ?x )
    :precondition ( and
      (not (CheckConsistency))
      (not (Error))
      (or
        (MaterialsAgent ?x)
        (Developer ?x)
        (SpecificationsAgent ?x)
        (ElectronicsAgent ?x)
        (CodingAgent ?x)
        (DesignAgent ?x)
        (InformaticEngineer ?x)
        (Employee ?x)
        (TestingAgent ?x)
        (ElectronicEngineer ?x)
        (exists (?z_0 )
          (hasPersonalInfo ?x ?z_0)
        )
        (MaterialsEngineer ?x)
        (Designer ?x)
        (TaskAgent ?x)
        (Engineer ?x)
        (SoftwareAgent ?x)
      )
    )
    :effect ( and
      (CheckConsistency)
      (when
        (= a a)
        (and
          (TaskAgent ?x)
        )
      )
    )
  )
  (:action assignElectronicsAgent
    :parameters ( ?x )
    :precondition ( and
      (not (CheckConsistency))
      (not (Error))
      (or
        (MaterialsAgent ?x)
        (Developer ?x)
        (SpecificationsAgent ?x)
        (ElectronicsAgent ?x)
        (CodingAgent ?x)
        (DesignAgent ?x)
        (InformaticEngineer ?x)
        (Employee ?x)
        (TestingAgent ?x)
        (ElectronicEngineer ?x)
        (exists (?z_0 )
          (hasPersonalInfo ?x ?z_0)
        )
        (MaterialsEngineer ?x)
        (Designer ?x)
        (TaskAgent ?x)
        (Engineer ?x)
        (SoftwareAgent ?x)
      )
    )
    :effect ( and
      (CheckConsistency)
      (when
        (= a a)
        (and
          (ElectronicsAgent ?x)
        )
      )
    )
  )
  (:action assignSoftwareAgent
    :parameters ( ?x )
    :precondition ( and
      (not (CheckConsistency))
      (not (Error))
      (or
        (MaterialsAgent ?x)
        (Developer ?x)
        (SpecificationsAgent ?x)
        (ElectronicsAgent ?x)
        (CodingAgent ?x)
        (DesignAgent ?x)
        (InformaticEngineer ?x)
        (Employee ?x)
        (TestingAgent ?x)
        (ElectronicEngineer ?x)
        (exists (?z_0 )
          (hasPersonalInfo ?x ?z_0)
        )
        (MaterialsEngineer ?x)
        (Designer ?x)
        (TaskAgent ?x)
        (Engineer ?x)
        (SoftwareAgent ?x)
      )
    )
    :effect ( and
      (CheckConsistency)
      (when
        (= a a)
        (and
          (SoftwareAgent ?x)
        )
      )
    )
  )
  (:action assignMaterialsAgent
    :parameters ( ?x )
    :precondition ( and
      (not (CheckConsistency))
      (not (Error))
      (or
        (MaterialsAgent ?x)
        (Developer ?x)
        (SpecificationsAgent ?x)
        (ElectronicsAgent ?x)
        (CodingAgent ?x)
        (DesignAgent ?x)
        (InformaticEngineer ?x)
        (Employee ?x)
        (TestingAgent ?x)
        (ElectronicEngineer ?x)
        (exists (?z_0 )
          (hasPersonalInfo ?x ?z_0)
        )
        (MaterialsEngineer ?x)
        (Designer ?x)
        (TaskAgent ?x)
        (Engineer ?x)
        (SoftwareAgent ?x)
      )
    )
    :effect ( and
      (CheckConsistency)
      (when
        (= a a)
        (and
          (MaterialsAgent ?x)
        )
      )
    )
  )
  (:action removePersonalInfo
    :parameters ( ?x ?y )
    :precondition ( and
      (not (CheckConsistency))
      (not (Error))
      (hasPersonalInfo ?x ?y)
    )
    :effect ( and
      (CheckConsistency)
      (when
        (= a a)
        (and
          (not (hasPersonalInfo ?x ?y))
        )
      )
    )
  )
  (:action assignSpecificationsAgent
    :parameters ( ?x )
    :precondition ( and
      (not (CheckConsistency))
      (not (Error))
      (or
        (MaterialsAgent ?x)
        (Developer ?x)
        (SpecificationsAgent ?x)
        (ElectronicsAgent ?x)
        (CodingAgent ?x)
        (DesignAgent ?x)
        (InformaticEngineer ?x)
        (Employee ?x)
        (TestingAgent ?x)
        (ElectronicEngineer ?x)
        (exists (?z_0 )
          (hasPersonalInfo ?x ?z_0)
        )
        (MaterialsEngineer ?x)
        (Designer ?x)
        (TaskAgent ?x)
        (Engineer ?x)
        (SoftwareAgent ?x)
      )
    )
    :effect ( and
      (CheckConsistency)
      (when
        (= a a)
        (and
          (SpecificationsAgent ?x)
        )
      )
    )
  )
  (:action hireElectronicEng
    :parameters ( ?n )
    :precondition ( and
      (not (CheckConsistency))
      (not (Error))
      (= a a)
    )
    :effect ( and
      (CheckConsistency)
      (when
        (not
          (exists ( ?x2 ?x3 ?x1 )
            (and
              (ElectronicEngineer ?x3)
              (not
                (=?x1 ?x3 )
              )
              (ElectronicEngineer ?x1)
              (not
                (=?x2 ?x3 )
              )
              (ElectronicEngineer ?x2)
              (not
                (=?x1 ?x2 )
              )
            )
          )
        )
        (and
          (ElectronicEngineer ?n)
        )
      )
    )
  )
  (:action CheckConsistencyAction
    :parameters ( )
    :precondition ( and
      (CheckConsistency)
      (not (Error))
    )
    :effect ( and
      (not (CheckConsistency))
      (when
        (or
          (exists (?x_6 )
            (and
              (SpecificationsAgent ?x_6)
              (MaterialsEngineer ?x_6)
            )
          )
          (exists (?x_4 )
            (and
              (ElectronicsAgent ?x_4)
              (MaterialsEngineer ?x_4)
            )
          )
          (exists (?x_1 ?z_0 )
            (and
              (hasPersonalInfo ?z_0 ?x_1)
              (Employee ?x_1)
            )
          )
          (exists (?x_1 )
            (and
              (DesignAgent ?x_1)
              (FullName ?x_1)
            )
          )
          (exists (?x_1 ?z_0 )
            (and
              (hasPersonalInfo ?z_0 ?x_1)
              (ElectronicEngineer ?x_1)
            )
          )
          (exists (?x_1 ?z_0 )
            (and
              (hasPersonalInfo ?z_0 ?x_1)
              (ElectronicsAgent ?x_1)
            )
          )
          (exists (?x_1 )
            (and
              (SoftwareAgent ?x_1)
              (FullName ?x_1)
            )
          )
          (exists (?x_5 )
            (and
              (InformaticEngineer ?x_5)
              (ElectronicEngineer ?x_5)
            )
          )
          (exists (?x_1 )
            (and
              (Developer ?x_1)
              (FullName ?x_1)
            )
          )
          (exists (?x_1 ?z_0 )
            (and
              (SpecificationsAgent ?x_1)
              (hasPersonalInfo ?z_0 ?x_1)
            )
          )
          (exists (?x_1 )
            (and
              (Employee ?x_1)
              (FullName ?x_1)
            )
          )
          (exists (?x_8 )
            (and
              (ElectronicsAgent ?x_8)
              (Designer ?x_8)
            )
          )
          (exists (?x_1 ?z_0 )
            (and
              (hasPersonalInfo ?z_0 ?x_1)
              (DesignAgent ?x_1)
            )
          )
          (exists (?x_1 )
            (and
              (ElectronicsAgent ?x_1)
              (FullName ?x_1)
            )
          )
          (exists (?x_2 )
            (and
              (InformaticEngineer ?x_2)
              (ElectronicsAgent ?x_2)
            )
          )
          (exists (?x_7 )
            (and
              (Developer ?x_7)
              (SpecificationsAgent ?x_7)
            )
          )
          (exists (?x_1 ?z_0 )
            (and
              (hasPersonalInfo ?z_0 ?x_1)
              (TaskAgent ?x_1)
            )
          )
          (exists (?x_1 )
            (and
              (MaterialsAgent ?x_1)
              (FullName ?x_1)
            )
          )
          (exists (?x_1 ?z_0 )
            (and
              (hasPersonalInfo ?z_0 ?x_1)
              (SoftwareAgent ?x_1)
            )
          )
          (exists (?x_1 ?z_0 )
            (and
              (CodingAgent ?x_1)
              (hasPersonalInfo ?z_0 ?x_1)
            )
          )
          (exists (?x_1 )
            (and
              (FullName ?x_1)
              (TaskAgent ?x_1)
            )
          )
          (exists (?x_1 )
            (and
              (ElectronicEngineer ?x_1)
              (FullName ?x_1)
            )
          )
          (exists (?x_0 )
            (and
              (SoftwareAgent ?x_0)
              (Designer ?x_0)
            )
          )
          (exists (?x_1 )
            (and
              (CodingAgent ?x_1)
              (FullName ?x_1)
            )
          )
          (exists (?x_1 ?z_0 )
            (and
              (hasPersonalInfo ?z_0 ?x_1)
              (MaterialsAgent ?x_1)
            )
          )
          (exists (?x_1 ?z_0 ?z_1 )
            (and
              (hasPersonalInfo ?z_1 ?x_1)
              (hasPersonalInfo ?x_1 ?z_0)
            )
          )
          (exists (?x_1 ?z_0 )
            (and
              (hasPersonalInfo ?z_0 ?x_1)
              (InformaticEngineer ?x_1)
            )
          )
          (exists (?x_1 )
            (and
              (FullName ?x_1)
              (Engineer ?x_1)
            )
          )
          (exists (?x_1 )
            (and
              (FullName ?x_1)
              (MaterialsEngineer ?x_1)
            )
          )
          (exists (?x_1 ?z_0 )
            (and
              (FullName ?x_1)
              (hasPersonalInfo ?x_1 ?z_0)
            )
          )
          (exists (?x_6 )
            (and
              (CodingAgent ?x_6)
              (MaterialsEngineer ?x_6)
            )
          )
          (exists (?x_0 )
            (and
              (Designer ?x_0)
              (SpecificationsAgent ?x_0)
            )
          )
          (exists (?x_1 )
            (and
              (Designer ?x_1)
              (FullName ?x_1)
            )
          )
          (exists (?x_0 )
            (and
              (Designer ?x_0)
              (CodingAgent ?x_0)
            )
          )
          (exists (?x_1 ?z_0 )
            (and
              (hasPersonalInfo ?z_0 ?x_1)
              (Developer ?x_1)
            )
          )
          (exists (?x_1 )
            (and
              (FullName ?x_1)
              (InformaticEngineer ?x_1)
            )
          )
          (exists (?x_1 )
            (and
              (SpecificationsAgent ?x_1)
              (FullName ?x_1)
            )
          )
          (exists (?x_3 )
            (and
              (ElectronicEngineer ?x_3)
              (CodingAgent ?x_3)
            )
          )
          (exists (?x_1 ?z_0 )
            (and
              (hasPersonalInfo ?z_0 ?x_1)
              (MaterialsEngineer ?x_1)
            )
          )
          (exists (?x_6 )
            (and
              (SoftwareAgent ?x_6)
              (MaterialsEngineer ?x_6)
            )
          )
          (exists (?x_1 )
            (and
              (FullName ?x_1)
              (TestingAgent ?x_1)
            )
          )
          (exists (?x_1 ?z_0 )
            (and
              (hasPersonalInfo ?z_0 ?x_1)
              (Designer ?x_1)
            )
          )
          (exists (?x_1 ?z_0 )
            (and
              (hasPersonalInfo ?z_0 ?x_1)
              (Engineer ?x_1)
            )
          )
          (exists (?x_1 ?z_0 )
            (and
              (hasPersonalInfo ?z_0 ?x_1)
              (TestingAgent ?x_1)
            )
          )
          (exists (?z_0 )
            (hasPersonalInfo ?z_0 ?z_0)
          )
        )
        (Error)
      )
    )
  )
)