(define
  (domain taskAssigment)
  (:requirements :adl)
  (:predicates
    (ElectronicsAgent ?x )
    (Designer ?x )
    (SoftwareAgent ?x )
    (InformaticEngineer ?x )
    (MaterialsAgent ?x )
    (DesignAgent ?x )
    (TaskAgent ?x )
    (MaterialsEngineer ?x )
    (CodingAgent ?x )
    (TestingAgent ?x )
    (ElectronicEngineer ?x )
    (Employee ?x )
    (FullName ?x )
    (Engineer ?x )
    (SpecificationsAgent ?x )
    (Developer ?x )
    (hasPersonalInfo ?x ?y )
    (CheckConsistency)
    (Error)
  )
  (:action hireElectronicEng
    :parameters ( ?n )
    :precondition ( and
      (not (CheckConsistency))
      (not (Error))
      (= a a)
    )
    :effect ( and
      (CheckConsistency)
      (when
        (not
          (exists ( ?x2 ?x3 ?x1 )
            (and
              (ElectronicEngineer ?x1)
              (not
                (=?x2 ?x3 )
              )
              (ElectronicEngineer ?x3)
              (not
                (=?x1 ?x3 )
              )
              (not
                (=?x1 ?x2 )
              )
              (ElectronicEngineer ?x2)
            )
          )
        )
        (and
          (ElectronicEngineer ?n)
        )
      )
    )
  )
  (:action removePersonalInfo
    :parameters ( ?x ?y )
    :precondition ( and
      (not (CheckConsistency))
      (not (Error))
      (hasPersonalInfo ?x ?y)
    )
    :effect ( and
      (CheckConsistency)
      (when
        (= a a)
        (and
          (not (hasPersonalInfo ?x ?y))
        )
      )
    )
  )
  (:action assignMaterialsAgent
    :parameters ( ?x )
    :precondition ( and
      (not (CheckConsistency))
      (not (Error))
      (or
        (MaterialsAgent ?x)
        (TaskAgent ?x)
        (SpecificationsAgent ?x)
        (ElectronicsAgent ?x)
        (CodingAgent ?x)
        (DesignAgent ?x)
        (InformaticEngineer ?x)
        (Employee ?x)
        (TestingAgent ?x)
        (ElectronicEngineer ?x)
        (Developer ?x)
        (exists (?z_0 )
          (hasPersonalInfo ?x ?z_0)
        )
        (MaterialsEngineer ?x)
        (Designer ?x)
        (Engineer ?x)
        (SoftwareAgent ?x)
      )
    )
    :effect ( and
      (CheckConsistency)
      (when
        (= a a)
        (and
          (MaterialsAgent ?x)
        )
      )
    )
  )
  (:action assignSoftwareAgent
    :parameters ( ?x )
    :precondition ( and
      (not (CheckConsistency))
      (not (Error))
      (or
        (MaterialsAgent ?x)
        (TaskAgent ?x)
        (SpecificationsAgent ?x)
        (ElectronicsAgent ?x)
        (CodingAgent ?x)
        (DesignAgent ?x)
        (InformaticEngineer ?x)
        (Employee ?x)
        (TestingAgent ?x)
        (ElectronicEngineer ?x)
        (Developer ?x)
        (exists (?z_0 )
          (hasPersonalInfo ?x ?z_0)
        )
        (MaterialsEngineer ?x)
        (Designer ?x)
        (Engineer ?x)
        (SoftwareAgent ?x)
      )
    )
    :effect ( and
      (CheckConsistency)
      (when
        (= a a)
        (and
          (SoftwareAgent ?x)
        )
      )
    )
  )
  (:action assignElectronicsAgent
    :parameters ( ?x )
    :precondition ( and
      (not (CheckConsistency))
      (not (Error))
      (or
        (MaterialsAgent ?x)
        (TaskAgent ?x)
        (SpecificationsAgent ?x)
        (ElectronicsAgent ?x)
        (CodingAgent ?x)
        (DesignAgent ?x)
        (InformaticEngineer ?x)
        (Employee ?x)
        (TestingAgent ?x)
        (ElectronicEngineer ?x)
        (Developer ?x)
        (exists (?z_0 )
          (hasPersonalInfo ?x ?z_0)
        )
        (MaterialsEngineer ?x)
        (Designer ?x)
        (Engineer ?x)
        (SoftwareAgent ?x)
      )
    )
    :effect ( and
      (CheckConsistency)
      (when
        (= a a)
        (and
          (ElectronicsAgent ?x)
        )
      )
    )
  )
  (:action assignDesignAgent
    :parameters ( ?x )
    :precondition ( and
      (not (CheckConsistency))
      (not (Error))
      (or
        (MaterialsAgent ?x)
        (TaskAgent ?x)
        (SpecificationsAgent ?x)
        (ElectronicsAgent ?x)
        (CodingAgent ?x)
        (DesignAgent ?x)
        (InformaticEngineer ?x)
        (Employee ?x)
        (TestingAgent ?x)
        (ElectronicEngineer ?x)
        (Developer ?x)
        (exists (?z_0 )
          (hasPersonalInfo ?x ?z_0)
        )
        (MaterialsEngineer ?x)
        (Designer ?x)
        (Engineer ?x)
        (SoftwareAgent ?x)
      )
    )
    :effect ( and
      (CheckConsistency)
      (when
        (= a a)
        (and
          (DesignAgent ?x)
        )
      )
    )
  )
  (:action assignSpecificationsAgent
    :parameters ( ?x )
    :precondition ( and
      (not (CheckConsistency))
      (not (Error))
      (or
        (MaterialsAgent ?x)
        (TaskAgent ?x)
        (SpecificationsAgent ?x)
        (ElectronicsAgent ?x)
        (CodingAgent ?x)
        (DesignAgent ?x)
        (InformaticEngineer ?x)
        (Employee ?x)
        (TestingAgent ?x)
        (ElectronicEngineer ?x)
        (Developer ?x)
        (exists (?z_0 )
          (hasPersonalInfo ?x ?z_0)
        )
        (MaterialsEngineer ?x)
        (Designer ?x)
        (Engineer ?x)
        (SoftwareAgent ?x)
      )
    )
    :effect ( and
      (CheckConsistency)
      (when
        (= a a)
        (and
          (SpecificationsAgent ?x)
        )
      )
    )
  )
  (:action hireInformaticEng
    :parameters ( ?n )
    :precondition ( and
      (not (CheckConsistency))
      (not (Error))
      (= a a)
    )
    :effect ( and
      (CheckConsistency)
      (when
        (not
          (exists ( ?x2 ?x3 ?x1 )
            (and
              (InformaticEngineer ?x1)
              (InformaticEngineer ?x2)
              (not
                (=?x1 ?x2 )
              )
              (not
                (=?x1 ?x3 )
              )
              (not
                (=?x2 ?x3 )
              )
              (InformaticEngineer ?x3)
            )
          )
        )
        (and
          (InformaticEngineer ?n)
        )
      )
    )
  )
  (:action assignTestingAgent
    :parameters ( ?x )
    :precondition ( and
      (not (CheckConsistency))
      (not (Error))
      (or
        (MaterialsAgent ?x)
        (TaskAgent ?x)
        (SpecificationsAgent ?x)
        (ElectronicsAgent ?x)
        (CodingAgent ?x)
        (DesignAgent ?x)
        (InformaticEngineer ?x)
        (Employee ?x)
        (TestingAgent ?x)
        (ElectronicEngineer ?x)
        (Developer ?x)
        (exists (?z_0 )
          (hasPersonalInfo ?x ?z_0)
        )
        (MaterialsEngineer ?x)
        (Designer ?x)
        (Engineer ?x)
        (SoftwareAgent ?x)
      )
    )
    :effect ( and
      (CheckConsistency)
      (when
        (= a a)
        (and
          (TestingAgent ?x)
        )
      )
    )
  )
  (:action assignCodingAgent
    :parameters ( ?x )
    :precondition ( and
      (not (CheckConsistency))
      (not (Error))
      (or
        (MaterialsAgent ?x)
        (TaskAgent ?x)
        (SpecificationsAgent ?x)
        (ElectronicsAgent ?x)
        (CodingAgent ?x)
        (DesignAgent ?x)
        (InformaticEngineer ?x)
        (Employee ?x)
        (TestingAgent ?x)
        (ElectronicEngineer ?x)
        (Developer ?x)
        (exists (?z_0 )
          (hasPersonalInfo ?x ?z_0)
        )
        (MaterialsEngineer ?x)
        (Designer ?x)
        (Engineer ?x)
        (SoftwareAgent ?x)
      )
    )
    :effect ( and
      (CheckConsistency)
      (when
        (= a a)
        (and
          (CodingAgent ?x)
        )
      )
    )
  )
  (:action assignTaskAgent
    :parameters ( ?x )
    :precondition ( and
      (not (CheckConsistency))
      (not (Error))
      (or
        (MaterialsAgent ?x)
        (TaskAgent ?x)
        (SpecificationsAgent ?x)
        (ElectronicsAgent ?x)
        (CodingAgent ?x)
        (DesignAgent ?x)
        (InformaticEngineer ?x)
        (Employee ?x)
        (TestingAgent ?x)
        (ElectronicEngineer ?x)
        (Developer ?x)
        (exists (?z_0 )
          (hasPersonalInfo ?x ?z_0)
        )
        (MaterialsEngineer ?x)
        (Designer ?x)
        (Engineer ?x)
        (SoftwareAgent ?x)
      )
    )
    :effect ( and
      (CheckConsistency)
      (when
        (= a a)
        (and
          (TaskAgent ?x)
        )
      )
    )
  )
  (:action CheckConsistencyAction
    :parameters ( )
    :precondition ( and
      (CheckConsistency)
      (not (Error))
    )
    :effect ( and
      (not (CheckConsistency))
      (when
        (or
          (exists (?x_3 )
            (and
              (FullName ?x_3)
              (MaterialsAgent ?x_3)
            )
          )
          (exists (?x_4 )
            (and
              (ElectronicsAgent ?x_4)
              (MaterialsEngineer ?x_4)
            )
          )
          (exists (?x_3 )
            (and
              (FullName ?x_3)
              (Developer ?x_3)
            )
          )
          (exists (?x_3 ?z_0 )
            (and
              (Designer ?x_3)
              (hasPersonalInfo ?z_0 ?x_3)
            )
          )
          (exists (?x_3 )
            (and
              (FullName ?x_3)
              (SpecificationsAgent ?x_3)
            )
          )
          (exists (?x_3 ?z_0 )
            (and
              (hasPersonalInfo ?z_0 ?x_3)
              (CodingAgent ?x_3)
            )
          )
          (exists (?x_3 ?z_0 )
            (and
              (SoftwareAgent ?x_3)
              (hasPersonalInfo ?z_0 ?x_3)
            )
          )
          (exists (?x_3 ?z_0 )
            (and
              (MaterialsEngineer ?x_3)
              (hasPersonalInfo ?z_0 ?x_3)
            )
          )
          (exists (?x_3 )
            (and
              (DesignAgent ?x_3)
              (FullName ?x_3)
            )
          )
          (exists (?x_3 ?z_0 )
            (and
              (hasPersonalInfo ?z_0 ?x_3)
              (SpecificationsAgent ?x_3)
            )
          )
          (exists (?x_3 ?z_0 )
            (and
              (ElectronicsAgent ?x_3)
              (hasPersonalInfo ?z_0 ?x_3)
            )
          )
          (exists (?x_3 ?z_0 )
            (and
              (SpecificationsAgent ?x_3)
              (hasPersonalInfo ?z_0 ?x_3)
            )
          )
          (exists (?x_7 )
            (and
              (Developer ?x_7)
              (SpecificationsAgent ?x_7)
            )
          )
          (exists (?x_3 )
            (and
              (FullName ?x_3)
              (CodingAgent ?x_3)
            )
          )
          (exists (?x_3 ?z_0 )
            (and
              (CodingAgent ?x_3)
              (hasPersonalInfo ?z_0 ?x_3)
            )
          )
          (exists (?x_3 ?z_0 )
            (and
              (MaterialsAgent ?x_3)
              (hasPersonalInfo ?z_0 ?x_3)
            )
          )
          (exists (?x_3 ?z_0 )
            (and
              (TestingAgent ?x_3)
              (hasPersonalInfo ?z_0 ?x_3)
            )
          )
          (exists (?x_3 )
            (and
              (FullName ?x_3)
              (SoftwareAgent ?x_3)
            )
          )
          (exists (?x_3 ?z_0 ?z_1 )
            (and
              (hasPersonalInfo ?x_3 ?z_0)
              (hasPersonalInfo ?z_1 ?x_3)
            )
          )
          (exists (?x_3 )
            (and
              (FullName ?x_3)
              (Designer ?x_3)
            )
          )
          (exists (?x_3 )
            (and
              (FullName ?x_3)
              (ElectronicEngineer ?x_3)
            )
          )
          (exists (?x_3 ?z_0 )
            (and
              (ElectronicEngineer ?x_3)
              (hasPersonalInfo ?z_0 ?x_3)
            )
          )
          (exists (?x_5 )
            (and
              (InformaticEngineer ?x_5)
              (ElectronicsAgent ?x_5)
            )
          )
          (exists (?x_3 ?z_0 )
            (and
              (Engineer ?x_3)
              (hasPersonalInfo ?z_0 ?x_3)
            )
          )
          (exists (?x_1 )
            (and
              (ElectronicEngineer ?x_1)
              (InformaticEngineer ?x_1)
            )
          )
          (exists (?x_3 )
            (and
              (Engineer ?x_3)
              (FullName ?x_3)
            )
          )
          (exists (?x_2 )
            (and
              (Designer ?x_2)
              (ElectronicsAgent ?x_2)
            )
          )
          (exists (?x_3 )
            (and
              (TestingAgent ?x_3)
              (FullName ?x_3)
            )
          )
          (exists (?x_8 )
            (and
              (Designer ?x_8)
              (SoftwareAgent ?x_8)
            )
          )
          (exists (?x_8 )
            (and
              (CodingAgent ?x_8)
              (Designer ?x_8)
            )
          )
          (exists (?x_3 )
            (and
              (MaterialsEngineer ?x_3)
              (FullName ?x_3)
            )
          )
          (exists (?x_8 )
            (and
              (SpecificationsAgent ?x_8)
              (Designer ?x_8)
            )
          )
          (exists (?x_6 )
            (and
              (CodingAgent ?x_6)
              (MaterialsEngineer ?x_6)
            )
          )
          (exists (?x_3 )
            (and
              (FullName ?x_3)
              (ElectronicsAgent ?x_3)
            )
          )
          (exists (?x_3 ?z_0 )
            (and
              (Employee ?x_3)
              (hasPersonalInfo ?z_0 ?x_3)
            )
          )
          (exists (?x_3 )
            (and
              (FullName ?x_3)
              (InformaticEngineer ?x_3)
            )
          )
          (exists (?x_0 )
            (and
              (ElectronicEngineer ?x_0)
              (CodingAgent ?x_0)
            )
          )
          (exists (?x_3 ?z_0 )
            (and
              (InformaticEngineer ?x_3)
              (hasPersonalInfo ?z_0 ?x_3)
            )
          )
          (exists (?x_3 ?z_0 )
            (and
              (FullName ?x_3)
              (hasPersonalInfo ?x_3 ?z_0)
            )
          )
          (exists (?x_3 ?z_0 )
            (and
              (DesignAgent ?x_3)
              (hasPersonalInfo ?z_0 ?x_3)
            )
          )
          (exists (?x_3 ?z_0 )
            (and
              (Developer ?x_3)
              (hasPersonalInfo ?z_0 ?x_3)
            )
          )
          (exists (?x_3 ?z_0 ?z_1 )
            (and
              (hasPersonalInfo ?x_3 ?z_1)
              (hasPersonalInfo ?z_0 ?x_3)
            )
          )
          (exists (?x_6 )
            (and
              (SoftwareAgent ?x_6)
              (MaterialsEngineer ?x_6)
            )
          )
          (exists (?x_6 )
            (and
              (SpecificationsAgent ?x_6)
              (MaterialsEngineer ?x_6)
            )
          )
          (exists (?x_3 ?z_0 )
            (and
              (TaskAgent ?x_3)
              (hasPersonalInfo ?z_0 ?x_3)
            )
          )
          (exists (?x_3 )
            (and
              (FullName ?x_3)
              (Employee ?x_3)
            )
          )
          (exists (?z_0 )
            (hasPersonalInfo ?z_0 ?z_0)
          )
          (exists (?x_3 )
            (and
              (TaskAgent ?x_3)
              (FullName ?x_3)
            )
          )
        )
        (Error)
      )
    )
  )
)