(define
  (domain taskAssigment)
  (:requirements :adl)
  (:predicates
    (ElectronicsAgent ?x )
    (Designer ?x )
    (SoftwareAgent ?x )
    (InformaticEngineer ?x )
    (MaterialsAgent ?x )
    (DesignAgent ?x )
    (TaskAgent ?x )
    (MaterialsEngineer ?x )
    (CodingAgent ?x )
    (TestingAgent ?x )
    (ElectronicEngineer ?x )
    (Employee ?x )
    (FullName ?x )
    (Engineer ?x )
    (SpecificationsAgent ?x )
    (Developer ?x )
    (hasPersonalInfo ?x ?y )
    (CheckConsistency)
    (Error)
  )
  (:action hireElectronicEng
    :parameters ( ?n )
    :precondition ( and
      (not (CheckConsistency))
      (not (Error))
      (= a a)
    )
    :effect ( and
      (CheckConsistency)
      (when
        (not
          (exists ( ?x2 ?x3 ?x1 )
            (and
              (not
                (=?x1 ?x2 )
              )
              (ElectronicEngineer ?x1)
              (ElectronicEngineer ?x3)
              (ElectronicEngineer ?x2)
              (not
                (=?x1 ?x3 )
              )
              (not
                (=?x2 ?x3 )
              )
            )
          )
        )
        (and
          (ElectronicEngineer ?n)
        )
      )
    )
  )
  (:action assignTaskAgent
    :parameters ( ?x )
    :precondition ( and
      (not (CheckConsistency))
      (not (Error))
      (or
        (MaterialsAgent ?x)
        (Developer ?x)
        (SpecificationsAgent ?x)
        (ElectronicsAgent ?x)
        (CodingAgent ?x)
        (DesignAgent ?x)
        (InformaticEngineer ?x)
        (Employee ?x)
        (TestingAgent ?x)
        (ElectronicEngineer ?x)
        (exists (?z_0 )
          (hasPersonalInfo ?x ?z_0)
        )
        (MaterialsEngineer ?x)
        (Designer ?x)
        (TaskAgent ?x)
        (Engineer ?x)
        (SoftwareAgent ?x)
      )
    )
    :effect ( and
      (CheckConsistency)
      (when
        (= a a)
        (and
          (TaskAgent ?x)
        )
      )
    )
  )
  (:action assignTestingAgent
    :parameters ( ?x )
    :precondition ( and
      (not (CheckConsistency))
      (not (Error))
      (or
        (MaterialsAgent ?x)
        (Developer ?x)
        (SpecificationsAgent ?x)
        (ElectronicsAgent ?x)
        (CodingAgent ?x)
        (DesignAgent ?x)
        (InformaticEngineer ?x)
        (Employee ?x)
        (TestingAgent ?x)
        (ElectronicEngineer ?x)
        (exists (?z_0 )
          (hasPersonalInfo ?x ?z_0)
        )
        (MaterialsEngineer ?x)
        (Designer ?x)
        (TaskAgent ?x)
        (Engineer ?x)
        (SoftwareAgent ?x)
      )
    )
    :effect ( and
      (CheckConsistency)
      (when
        (= a a)
        (and
          (TestingAgent ?x)
        )
      )
    )
  )
  (:action assignSoftwareAgent
    :parameters ( ?x )
    :precondition ( and
      (not (CheckConsistency))
      (not (Error))
      (or
        (MaterialsAgent ?x)
        (Developer ?x)
        (SpecificationsAgent ?x)
        (ElectronicsAgent ?x)
        (CodingAgent ?x)
        (DesignAgent ?x)
        (InformaticEngineer ?x)
        (Employee ?x)
        (TestingAgent ?x)
        (ElectronicEngineer ?x)
        (exists (?z_0 )
          (hasPersonalInfo ?x ?z_0)
        )
        (MaterialsEngineer ?x)
        (Designer ?x)
        (TaskAgent ?x)
        (Engineer ?x)
        (SoftwareAgent ?x)
      )
    )
    :effect ( and
      (CheckConsistency)
      (when
        (= a a)
        (and
          (SoftwareAgent ?x)
        )
      )
    )
  )
  (:action assignDesignAgent
    :parameters ( ?x )
    :precondition ( and
      (not (CheckConsistency))
      (not (Error))
      (or
        (MaterialsAgent ?x)
        (Developer ?x)
        (SpecificationsAgent ?x)
        (ElectronicsAgent ?x)
        (CodingAgent ?x)
        (DesignAgent ?x)
        (InformaticEngineer ?x)
        (Employee ?x)
        (TestingAgent ?x)
        (ElectronicEngineer ?x)
        (exists (?z_0 )
          (hasPersonalInfo ?x ?z_0)
        )
        (MaterialsEngineer ?x)
        (Designer ?x)
        (TaskAgent ?x)
        (Engineer ?x)
        (SoftwareAgent ?x)
      )
    )
    :effect ( and
      (CheckConsistency)
      (when
        (= a a)
        (and
          (DesignAgent ?x)
        )
      )
    )
  )
  (:action assignElectronicsAgent
    :parameters ( ?x )
    :precondition ( and
      (not (CheckConsistency))
      (not (Error))
      (or
        (MaterialsAgent ?x)
        (Developer ?x)
        (SpecificationsAgent ?x)
        (ElectronicsAgent ?x)
        (CodingAgent ?x)
        (DesignAgent ?x)
        (InformaticEngineer ?x)
        (Employee ?x)
        (TestingAgent ?x)
        (ElectronicEngineer ?x)
        (exists (?z_0 )
          (hasPersonalInfo ?x ?z_0)
        )
        (MaterialsEngineer ?x)
        (Designer ?x)
        (TaskAgent ?x)
        (Engineer ?x)
        (SoftwareAgent ?x)
      )
    )
    :effect ( and
      (CheckConsistency)
      (when
        (= a a)
        (and
          (ElectronicsAgent ?x)
        )
      )
    )
  )
  (:action assignSpecificationsAgent
    :parameters ( ?x )
    :precondition ( and
      (not (CheckConsistency))
      (not (Error))
      (or
        (MaterialsAgent ?x)
        (Developer ?x)
        (SpecificationsAgent ?x)
        (ElectronicsAgent ?x)
        (CodingAgent ?x)
        (DesignAgent ?x)
        (InformaticEngineer ?x)
        (Employee ?x)
        (TestingAgent ?x)
        (ElectronicEngineer ?x)
        (exists (?z_0 )
          (hasPersonalInfo ?x ?z_0)
        )
        (MaterialsEngineer ?x)
        (Designer ?x)
        (TaskAgent ?x)
        (Engineer ?x)
        (SoftwareAgent ?x)
      )
    )
    :effect ( and
      (CheckConsistency)
      (when
        (= a a)
        (and
          (SpecificationsAgent ?x)
        )
      )
    )
  )
  (:action hireInformaticEng
    :parameters ( ?n )
    :precondition ( and
      (not (CheckConsistency))
      (not (Error))
      (= a a)
    )
    :effect ( and
      (CheckConsistency)
      (when
        (not
          (exists ( ?x2 ?x3 ?x1 )
            (and
              (not
                (=?x1 ?x3 )
              )
              (not
                (=?x1 ?x2 )
              )
              (InformaticEngineer ?x2)
              (not
                (=?x2 ?x3 )
              )
              (InformaticEngineer ?x1)
              (InformaticEngineer ?x3)
            )
          )
        )
        (and
          (InformaticEngineer ?n)
        )
      )
    )
  )
  (:action assignMaterialsAgent
    :parameters ( ?x )
    :precondition ( and
      (not (CheckConsistency))
      (not (Error))
      (or
        (MaterialsAgent ?x)
        (Developer ?x)
        (SpecificationsAgent ?x)
        (ElectronicsAgent ?x)
        (CodingAgent ?x)
        (DesignAgent ?x)
        (InformaticEngineer ?x)
        (Employee ?x)
        (TestingAgent ?x)
        (ElectronicEngineer ?x)
        (exists (?z_0 )
          (hasPersonalInfo ?x ?z_0)
        )
        (MaterialsEngineer ?x)
        (Designer ?x)
        (TaskAgent ?x)
        (Engineer ?x)
        (SoftwareAgent ?x)
      )
    )
    :effect ( and
      (CheckConsistency)
      (when
        (= a a)
        (and
          (MaterialsAgent ?x)
        )
      )
    )
  )
  (:action assignCodingAgent
    :parameters ( ?x )
    :precondition ( and
      (not (CheckConsistency))
      (not (Error))
      (or
        (MaterialsAgent ?x)
        (Developer ?x)
        (SpecificationsAgent ?x)
        (ElectronicsAgent ?x)
        (CodingAgent ?x)
        (DesignAgent ?x)
        (InformaticEngineer ?x)
        (Employee ?x)
        (TestingAgent ?x)
        (ElectronicEngineer ?x)
        (exists (?z_0 )
          (hasPersonalInfo ?x ?z_0)
        )
        (MaterialsEngineer ?x)
        (Designer ?x)
        (TaskAgent ?x)
        (Engineer ?x)
        (SoftwareAgent ?x)
      )
    )
    :effect ( and
      (CheckConsistency)
      (when
        (= a a)
        (and
          (CodingAgent ?x)
        )
      )
    )
  )
  (:action removePersonalInfo
    :parameters ( ?x ?y )
    :precondition ( and
      (not (CheckConsistency))
      (not (Error))
      (hasPersonalInfo ?x ?y)
    )
    :effect ( and
      (CheckConsistency)
      (when
        (= a a)
        (and
          (not (hasPersonalInfo ?x ?y))
        )
      )
    )
  )
  (:action CheckConsistencyAction
    :parameters ( )
    :precondition ( and
      (CheckConsistency)
      (not (Error))
    )
    :effect ( and
      (not (CheckConsistency))
      (when
        (or
          (exists (?x_1 ?z_0 )
            (and
              (hasPersonalInfo ?z_0 ?x_1)
              (Designer ?x_1)
            )
          )
          (exists (?x_1 ?z_0 )
            (and
              (hasPersonalInfo ?z_0 ?x_1)
              (Employee ?x_1)
            )
          )
          (exists (?x_1 ?z_0 )
            (and
              (hasPersonalInfo ?z_0 ?x_1)
              (ElectronicEngineer ?x_1)
            )
          )
          (exists (?x_1 ?z_0 )
            (and
              (hasPersonalInfo ?z_0 ?x_1)
              (ElectronicsAgent ?x_1)
            )
          )
          (exists (?x_7 )
            (and
              (ElectronicEngineer ?x_7)
              (InformaticEngineer ?x_7)
            )
          )
          (exists (?x_1 )
            (and
              (SoftwareAgent ?x_1)
              (FullName ?x_1)
            )
          )
          (exists (?x_6 )
            (and
              (ElectronicsAgent ?x_6)
              (MaterialsEngineer ?x_6)
            )
          )
          (exists (?x_2 )
            (and
              (MaterialsEngineer ?x_2)
              (CodingAgent ?x_2)
            )
          )
          (exists (?x_1 ?z_0 )
            (and
              (SpecificationsAgent ?x_1)
              (hasPersonalInfo ?z_0 ?x_1)
            )
          )
          (exists (?x_1 )
            (and
              (Employee ?x_1)
              (FullName ?x_1)
            )
          )
          (exists (?x_1 ?z_0 )
            (and
              (hasPersonalInfo ?z_0 ?x_1)
              (DesignAgent ?x_1)
            )
          )
          (exists (?x_1 )
            (and
              (ElectronicsAgent ?x_1)
              (FullName ?x_1)
            )
          )
          (exists (?x_1 ?z_0 )
            (and
              (hasPersonalInfo ?z_0 ?x_1)
              (TaskAgent ?x_1)
            )
          )
          (exists (?x_1 )
            (and
              (MaterialsAgent ?x_1)
              (FullName ?x_1)
            )
          )
          (exists (?x_1 ?z_0 )
            (and
              (hasPersonalInfo ?z_0 ?x_1)
              (SoftwareAgent ?x_1)
            )
          )
          (exists (?x_0 )
            (and
              (InformaticEngineer ?x_0)
              (ElectronicsAgent ?x_0)
            )
          )
          (exists (?x_4 )
            (and
              (Designer ?x_4)
              (SpecificationsAgent ?x_4)
            )
          )
          (exists (?x_1 ?z_0 )
            (and
              (CodingAgent ?x_1)
              (hasPersonalInfo ?z_0 ?x_1)
            )
          )
          (exists (?x_1 )
            (and
              (FullName ?x_1)
              (TaskAgent ?x_1)
            )
          )
          (exists (?x_3 )
            (and
              (ElectronicsAgent ?x_3)
              (Designer ?x_3)
            )
          )
          (exists (?x_1 )
            (and
              (ElectronicEngineer ?x_1)
              (FullName ?x_1)
            )
          )
          (exists (?x_2 )
            (and
              (MaterialsEngineer ?x_2)
              (SoftwareAgent ?x_2)
            )
          )
          (exists (?x_1 )
            (and
              (CodingAgent ?x_1)
              (FullName ?x_1)
            )
          )
          (exists (?x_1 ?z_0 )
            (and
              (hasPersonalInfo ?z_0 ?x_1)
              (MaterialsAgent ?x_1)
            )
          )
          (exists (?x_8 )
            (and
              (CodingAgent ?x_8)
              (ElectronicEngineer ?x_8)
            )
          )
          (exists (?x_1 ?z_0 ?z_1 )
            (and
              (hasPersonalInfo ?z_1 ?x_1)
              (hasPersonalInfo ?x_1 ?z_0)
            )
          )
          (exists (?x_1 ?z_0 )
            (and
              (hasPersonalInfo ?z_0 ?x_1)
              (InformaticEngineer ?x_1)
            )
          )
          (exists (?x_1 )
            (and
              (FullName ?x_1)
              (Engineer ?x_1)
            )
          )
          (exists (?x_1 )
            (and
              (FullName ?x_1)
              (MaterialsEngineer ?x_1)
            )
          )
          (exists (?x_4 )
            (and
              (Designer ?x_4)
              (SoftwareAgent ?x_4)
            )
          )
          (exists (?x_1 )
            (and
              (DesignAgent ?x_1)
              (FullName ?x_1)
            )
          )
          (exists (?x_5 )
            (and
              (SpecificationsAgent ?x_5)
              (Developer ?x_5)
            )
          )
          (exists (?x_1 )
            (and
              (Designer ?x_1)
              (FullName ?x_1)
            )
          )
          (exists (?x_1 ?z_0 )
            (and
              (hasPersonalInfo ?z_0 ?x_1)
              (Developer ?x_1)
            )
          )
          (exists (?x_1 )
            (and
              (FullName ?x_1)
              (InformaticEngineer ?x_1)
            )
          )
          (exists (?x_1 )
            (and
              (SpecificationsAgent ?x_1)
              (FullName ?x_1)
            )
          )
          (exists (?x_1 ?z_0 )
            (and
              (hasPersonalInfo ?z_0 ?x_1)
              (MaterialsEngineer ?x_1)
            )
          )
          (exists (?x_1 )
            (and
              (FullName ?x_1)
              (TestingAgent ?x_1)
            )
          )
          (exists (?x_2 )
            (and
              (MaterialsEngineer ?x_2)
              (SpecificationsAgent ?x_2)
            )
          )
          (exists (?x_4 )
            (and
              (Designer ?x_4)
              (CodingAgent ?x_4)
            )
          )
          (exists (?x_1 )
            (and
              (Developer ?x_1)
              (FullName ?x_1)
            )
          )
          (exists (?x_1 ?z_0 )
            (and
              (hasPersonalInfo ?z_0 ?x_1)
              (Engineer ?x_1)
            )
          )
          (exists (?x_1 ?z_0 )
            (and
              (hasPersonalInfo ?z_0 ?x_1)
              (TestingAgent ?x_1)
            )
          )
          (exists (?x_1 ?z_0 )
            (and
              (FullName ?x_1)
              (hasPersonalInfo ?x_1 ?z_0)
            )
          )
          (exists (?z_0 )
            (hasPersonalInfo ?z_0 ?z_0)
          )
        )
        (Error)
      )
    )
  )
)