(define
  (domain taskAssigment)
  (:requirements :adl)
  (:predicates
    (ElectronicsAgent ?x )
    (Designer ?x )
    (SoftwareAgent ?x )
    (InformaticEngineer ?x )
    (MaterialsAgent ?x )
    (DesignAgent ?x )
    (TaskAgent ?x )
    (MaterialsEngineer ?x )
    (CodingAgent ?x )
    (TestingAgent ?x )
    (ElectronicEngineer ?x )
    (Employee ?x )
    (FullName ?x )
    (Engineer ?x )
    (SpecificationsAgent ?x )
    (Developer ?x )
    (hasPersonalInfo ?x ?y )
    (CheckConsistency)
    (Error)
  )
  (:action assignTestingAgent
    :parameters ( ?x )
    :precondition ( and
      (not (CheckConsistency))
      (not (Error))
      (or
        (MaterialsAgent ?x)
        (TaskAgent ?x)
        (SpecificationsAgent ?x)
        (ElectronicsAgent ?x)
        (CodingAgent ?x)
        (DesignAgent ?x)
        (InformaticEngineer ?x)
        (Employee ?x)
        (TestingAgent ?x)
        (ElectronicEngineer ?x)
        (Developer ?x)
        (exists (?z_0 )
          (hasPersonalInfo ?x ?z_0)
        )
        (MaterialsEngineer ?x)
        (Designer ?x)
        (Engineer ?x)
        (SoftwareAgent ?x)
      )
    )
    :effect ( and
      (CheckConsistency)
      (when
        (= a a)
        (and
          (TestingAgent ?x)
        )
      )
    )
  )
  (:action assignMaterialsAgent
    :parameters ( ?x )
    :precondition ( and
      (not (CheckConsistency))
      (not (Error))
      (or
        (MaterialsAgent ?x)
        (TaskAgent ?x)
        (SpecificationsAgent ?x)
        (ElectronicsAgent ?x)
        (CodingAgent ?x)
        (DesignAgent ?x)
        (InformaticEngineer ?x)
        (Employee ?x)
        (TestingAgent ?x)
        (ElectronicEngineer ?x)
        (Developer ?x)
        (exists (?z_0 )
          (hasPersonalInfo ?x ?z_0)
        )
        (MaterialsEngineer ?x)
        (Designer ?x)
        (Engineer ?x)
        (SoftwareAgent ?x)
      )
    )
    :effect ( and
      (CheckConsistency)
      (when
        (= a a)
        (and
          (MaterialsAgent ?x)
        )
      )
    )
  )
  (:action hireElectronicEng
    :parameters ( ?n )
    :precondition ( and
      (not (CheckConsistency))
      (not (Error))
      (= a a)
    )
    :effect ( and
      (CheckConsistency)
      (when
        (not
          (exists ( ?x2 ?x3 ?x1 )
            (and
              (ElectronicEngineer ?x1)
              (ElectronicEngineer ?x3)
              (not
                (=?x1 ?x2 )
              )
              (ElectronicEngineer ?x2)
              (not
                (=?x1 ?x3 )
              )
              (not
                (=?x2 ?x3 )
              )
            )
          )
        )
        (and
          (ElectronicEngineer ?n)
        )
      )
    )
  )
  (:action assignTaskAgent
    :parameters ( ?x )
    :precondition ( and
      (not (CheckConsistency))
      (not (Error))
      (or
        (MaterialsAgent ?x)
        (TaskAgent ?x)
        (SpecificationsAgent ?x)
        (ElectronicsAgent ?x)
        (CodingAgent ?x)
        (DesignAgent ?x)
        (InformaticEngineer ?x)
        (Employee ?x)
        (TestingAgent ?x)
        (ElectronicEngineer ?x)
        (Developer ?x)
        (exists (?z_0 )
          (hasPersonalInfo ?x ?z_0)
        )
        (MaterialsEngineer ?x)
        (Designer ?x)
        (Engineer ?x)
        (SoftwareAgent ?x)
      )
    )
    :effect ( and
      (CheckConsistency)
      (when
        (= a a)
        (and
          (TaskAgent ?x)
        )
      )
    )
  )
  (:action hireInformaticEng
    :parameters ( ?n )
    :precondition ( and
      (not (CheckConsistency))
      (not (Error))
      (= a a)
    )
    :effect ( and
      (CheckConsistency)
      (when
        (not
          (exists ( ?x2 ?x3 ?x1 )
            (and
              (not
                (=?x1 ?x2 )
              )
              (InformaticEngineer ?x3)
              (not
                (=?x1 ?x3 )
              )
              (InformaticEngineer ?x2)
              (InformaticEngineer ?x1)
              (not
                (=?x2 ?x3 )
              )
            )
          )
        )
        (and
          (InformaticEngineer ?n)
        )
      )
    )
  )
  (:action assignDesignAgent
    :parameters ( ?x )
    :precondition ( and
      (not (CheckConsistency))
      (not (Error))
      (or
        (MaterialsAgent ?x)
        (TaskAgent ?x)
        (SpecificationsAgent ?x)
        (ElectronicsAgent ?x)
        (CodingAgent ?x)
        (DesignAgent ?x)
        (InformaticEngineer ?x)
        (Employee ?x)
        (TestingAgent ?x)
        (ElectronicEngineer ?x)
        (Developer ?x)
        (exists (?z_0 )
          (hasPersonalInfo ?x ?z_0)
        )
        (MaterialsEngineer ?x)
        (Designer ?x)
        (Engineer ?x)
        (SoftwareAgent ?x)
      )
    )
    :effect ( and
      (CheckConsistency)
      (when
        (= a a)
        (and
          (DesignAgent ?x)
        )
      )
    )
  )
  (:action assignElectronicsAgent
    :parameters ( ?x )
    :precondition ( and
      (not (CheckConsistency))
      (not (Error))
      (or
        (MaterialsAgent ?x)
        (TaskAgent ?x)
        (SpecificationsAgent ?x)
        (ElectronicsAgent ?x)
        (CodingAgent ?x)
        (DesignAgent ?x)
        (InformaticEngineer ?x)
        (Employee ?x)
        (TestingAgent ?x)
        (ElectronicEngineer ?x)
        (Developer ?x)
        (exists (?z_0 )
          (hasPersonalInfo ?x ?z_0)
        )
        (MaterialsEngineer ?x)
        (Designer ?x)
        (Engineer ?x)
        (SoftwareAgent ?x)
      )
    )
    :effect ( and
      (CheckConsistency)
      (when
        (= a a)
        (and
          (ElectronicsAgent ?x)
        )
      )
    )
  )
  (:action removePersonalInfo
    :parameters ( ?x ?y )
    :precondition ( and
      (not (CheckConsistency))
      (not (Error))
      (hasPersonalInfo ?x ?y)
    )
    :effect ( and
      (CheckConsistency)
      (when
        (= a a)
        (and
          (not (hasPersonalInfo ?x ?y))
        )
      )
    )
  )
  (:action assignSpecificationsAgent
    :parameters ( ?x )
    :precondition ( and
      (not (CheckConsistency))
      (not (Error))
      (or
        (MaterialsAgent ?x)
        (TaskAgent ?x)
        (SpecificationsAgent ?x)
        (ElectronicsAgent ?x)
        (CodingAgent ?x)
        (DesignAgent ?x)
        (InformaticEngineer ?x)
        (Employee ?x)
        (TestingAgent ?x)
        (ElectronicEngineer ?x)
        (Developer ?x)
        (exists (?z_0 )
          (hasPersonalInfo ?x ?z_0)
        )
        (MaterialsEngineer ?x)
        (Designer ?x)
        (Engineer ?x)
        (SoftwareAgent ?x)
      )
    )
    :effect ( and
      (CheckConsistency)
      (when
        (= a a)
        (and
          (SpecificationsAgent ?x)
        )
      )
    )
  )
  (:action assignSoftwareAgent
    :parameters ( ?x )
    :precondition ( and
      (not (CheckConsistency))
      (not (Error))
      (or
        (MaterialsAgent ?x)
        (TaskAgent ?x)
        (SpecificationsAgent ?x)
        (ElectronicsAgent ?x)
        (CodingAgent ?x)
        (DesignAgent ?x)
        (InformaticEngineer ?x)
        (Employee ?x)
        (TestingAgent ?x)
        (ElectronicEngineer ?x)
        (Developer ?x)
        (exists (?z_0 )
          (hasPersonalInfo ?x ?z_0)
        )
        (MaterialsEngineer ?x)
        (Designer ?x)
        (Engineer ?x)
        (SoftwareAgent ?x)
      )
    )
    :effect ( and
      (CheckConsistency)
      (when
        (= a a)
        (and
          (SoftwareAgent ?x)
        )
      )
    )
  )
  (:action assignCodingAgent
    :parameters ( ?x )
    :precondition ( and
      (not (CheckConsistency))
      (not (Error))
      (or
        (MaterialsAgent ?x)
        (TaskAgent ?x)
        (SpecificationsAgent ?x)
        (ElectronicsAgent ?x)
        (CodingAgent ?x)
        (DesignAgent ?x)
        (InformaticEngineer ?x)
        (Employee ?x)
        (TestingAgent ?x)
        (ElectronicEngineer ?x)
        (Developer ?x)
        (exists (?z_0 )
          (hasPersonalInfo ?x ?z_0)
        )
        (MaterialsEngineer ?x)
        (Designer ?x)
        (Engineer ?x)
        (SoftwareAgent ?x)
      )
    )
    :effect ( and
      (CheckConsistency)
      (when
        (= a a)
        (and
          (CodingAgent ?x)
        )
      )
    )
  )
  (:action CheckConsistencyAction
    :parameters ( )
    :precondition ( and
      (CheckConsistency)
      (not (Error))
    )
    :effect ( and
      (not (CheckConsistency))
      (when
        (or
          (exists (?x_6 )
            (and
              (SpecificationsAgent ?x_6)
              (MaterialsEngineer ?x_6)
            )
          )
          (exists (?x_1 )
            (and
              (CodingAgent ?x_1)
              (ElectronicEngineer ?x_1)
            )
          )
          (exists (?x_4 )
            (and
              (ElectronicEngineer ?x_4)
              (FullName ?x_4)
            )
          )
          (exists (?z_0 ?x_4 )
            (and
              (SoftwareAgent ?x_4)
              (hasPersonalInfo ?z_0 ?x_4)
            )
          )
          (exists (?x_3 )
            (and
              (ElectronicsAgent ?x_3)
              (Designer ?x_3)
            )
          )
          (exists (?x_4 )
            (and
              (CodingAgent ?x_4)
              (FullName ?x_4)
            )
          )
          (exists (?x_5 )
            (and
              (InformaticEngineer ?x_5)
              (ElectronicEngineer ?x_5)
            )
          )
          (exists (?z_0 ?x_4 )
            (and
              (Developer ?x_4)
              (hasPersonalInfo ?z_0 ?x_4)
            )
          )
          (exists (?z_0 ?x_4 )
            (and
              (hasPersonalInfo ?x_4 ?z_0)
              (FullName ?x_4)
            )
          )
          (exists (?x_0 )
            (and
              (Designer ?x_0)
              (SpecificationsAgent ?x_0)
            )
          )
          (exists (?x_4 )
            (and
              (Employee ?x_4)
              (FullName ?x_4)
            )
          )
          (exists (?z_0 ?x_4 )
            (and
              (ElectronicsAgent ?x_4)
              (hasPersonalInfo ?z_0 ?x_4)
            )
          )
          (exists (?x_7 )
            (and
              (Developer ?x_7)
              (SpecificationsAgent ?x_7)
            )
          )
          (exists (?z_0 ?x_4 )
            (and
              (hasPersonalInfo ?z_0 ?x_4)
              (TestingAgent ?x_4)
            )
          )
          (exists (?z_0 ?x_4 )
            (and
              (MaterialsAgent ?x_4)
              (hasPersonalInfo ?z_0 ?x_4)
            )
          )
          (exists (?x_4 )
            (and
              (FullName ?x_4)
              (DesignAgent ?x_4)
            )
          )
          (exists (?x_4 )
            (and
              (InformaticEngineer ?x_4)
              (FullName ?x_4)
            )
          )
          (exists (?z_0 ?x_4 )
            (and
              (hasPersonalInfo ?z_0 ?x_4)
              (MaterialsEngineer ?x_4)
            )
          )
          (exists (?z_0 ?x_4 )
            (and
              (hasPersonalInfo ?z_0 ?x_4)
              (ElectronicsAgent ?x_4)
            )
          )
          (exists (?x_4 )
            (and
              (MaterialsEngineer ?x_4)
              (FullName ?x_4)
            )
          )
          (exists (?x_4 )
            (and
              (TaskAgent ?x_4)
              (FullName ?x_4)
            )
          )
          (exists (?x_0 )
            (and
              (SoftwareAgent ?x_0)
              (Designer ?x_0)
            )
          )
          (exists (?z_0 ?x_4 )
            (and
              (hasPersonalInfo ?z_0 ?x_4)
              (InformaticEngineer ?x_4)
            )
          )
          (exists (?z_0 ?x_4 )
            (and
              (ElectronicEngineer ?x_4)
              (hasPersonalInfo ?z_0 ?x_4)
            )
          )
          (exists (?z_0 ?x_4 )
            (and
              (hasPersonalInfo ?z_0 ?x_4)
              (SpecificationsAgent ?x_4)
            )
          )
          (exists (?x_4 )
            (and
              (TestingAgent ?x_4)
              (FullName ?x_4)
            )
          )
          (exists (?z_0 ?x_4 )
            (and
              (hasPersonalInfo ?z_0 ?x_4)
              (CodingAgent ?x_4)
            )
          )
          (exists (?z_0 ?z_1 ?x_4 )
            (and
              (hasPersonalInfo ?z_1 ?x_4)
              (hasPersonalInfo ?x_4 ?z_0)
            )
          )
          (exists (?x_4 )
            (and
              (Designer ?x_4)
              (FullName ?x_4)
            )
          )
          (exists (?x_4 )
            (and
              (MaterialsAgent ?x_4)
              (FullName ?x_4)
            )
          )
          (exists (?x_4 )
            (and
              (SoftwareAgent ?x_4)
              (FullName ?x_4)
            )
          )
          (exists (?x_6 )
            (and
              (CodingAgent ?x_6)
              (MaterialsEngineer ?x_6)
            )
          )
          (exists (?x_4 )
            (and
              (ElectronicsAgent ?x_4)
              (FullName ?x_4)
            )
          )
          (exists (?z_0 ?x_4 )
            (and
              (Employee ?x_4)
              (hasPersonalInfo ?z_0 ?x_4)
            )
          )
          (exists (?x_4 )
            (and
              (SpecificationsAgent ?x_4)
              (FullName ?x_4)
            )
          )
          (exists (?x_0 )
            (and
              (Designer ?x_0)
              (CodingAgent ?x_0)
            )
          )
          (exists (?z_0 ?x_4 )
            (and
              (hasPersonalInfo ?z_0 ?x_4)
              (DesignAgent ?x_4)
            )
          )
          (exists (?x_4 )
            (and
              (Engineer ?x_4)
              (FullName ?x_4)
            )
          )
          (exists (?x_8 )
            (and
              (ElectronicsAgent ?x_8)
              (MaterialsEngineer ?x_8)
            )
          )
          (exists (?x_2 )
            (and
              (InformaticEngineer ?x_2)
              (ElectronicsAgent ?x_2)
            )
          )
          (exists (?x_6 )
            (and
              (SoftwareAgent ?x_6)
              (MaterialsEngineer ?x_6)
            )
          )
          (exists (?z_0 ?x_4 )
            (and
              (Designer ?x_4)
              (hasPersonalInfo ?z_0 ?x_4)
            )
          )
          (exists (?z_0 ?x_4 )
            (and
              (hasPersonalInfo ?z_0 ?x_4)
              (TaskAgent ?x_4)
            )
          )
          (exists (?x_4 )
            (and
              (Developer ?x_4)
              (FullName ?x_4)
            )
          )
          (exists (?z_0 ?x_4 )
            (and
              (hasPersonalInfo ?z_0 ?x_4)
              (Engineer ?x_4)
            )
          )
          (exists (?z_0 )
            (hasPersonalInfo ?z_0 ?z_0)
          )
        )
        (Error)
      )
    )
  )
)