(define
  (domain taskAssigment)
  (:requirements :adl)
  (:predicates
    (ElectronicsAgent ?x )
    (Designer ?x )
    (SoftwareAgent ?x )
    (InformaticEngineer ?x )
    (MaterialsAgent ?x )
    (DesignAgent ?x )
    (TaskAgent ?x )
    (MaterialsEngineer ?x )
    (CodingAgent ?x )
    (TestingAgent ?x )
    (ElectronicEngineer ?x )
    (Employee ?x )
    (FullName ?x )
    (Engineer ?x )
    (SpecificationsAgent ?x )
    (Developer ?x )
    (hasPersonalInfo ?x ?y )
    (CheckConsistency)
    (Error)
  )
  (:action assignDesignAgent
    :parameters ( ?x )
    :precondition ( and
      (not (CheckConsistency))
      (not (Error))
      (or
        (MaterialsAgent ?x)
        (Developer ?x)
        (SpecificationsAgent ?x)
        (ElectronicsAgent ?x)
        (CodingAgent ?x)
        (DesignAgent ?x)
        (InformaticEngineer ?x)
        (Employee ?x)
        (TestingAgent ?x)
        (ElectronicEngineer ?x)
        (exists (?z_0 )
          (hasPersonalInfo ?x ?z_0)
        )
        (MaterialsEngineer ?x)
        (Designer ?x)
        (TaskAgent ?x)
        (Engineer ?x)
        (SoftwareAgent ?x)
      )
    )
    :effect ( and
      (CheckConsistency)
      (when
        (= a a)
        (and
          (DesignAgent ?x)
        )
      )
    )
  )
  (:action hireElectronicEng
    :parameters ( ?n )
    :precondition ( and
      (not (CheckConsistency))
      (not (Error))
      (= a a)
    )
    :effect ( and
      (CheckConsistency)
      (when
        (not
          (exists ( ?x2 ?x3 ?x1 )
            (and
              (not
                (=?x1 ?x2 )
              )
              (ElectronicEngineer ?x2)
              (ElectronicEngineer ?x1)
              (ElectronicEngineer ?x3)
              (not
                (=?x1 ?x3 )
              )
              (not
                (=?x2 ?x3 )
              )
            )
          )
        )
        (and
          (ElectronicEngineer ?n)
        )
      )
    )
  )
  (:action assignSpecificationsAgent
    :parameters ( ?x )
    :precondition ( and
      (not (CheckConsistency))
      (not (Error))
      (or
        (MaterialsAgent ?x)
        (Developer ?x)
        (SpecificationsAgent ?x)
        (ElectronicsAgent ?x)
        (CodingAgent ?x)
        (DesignAgent ?x)
        (InformaticEngineer ?x)
        (Employee ?x)
        (TestingAgent ?x)
        (ElectronicEngineer ?x)
        (exists (?z_0 )
          (hasPersonalInfo ?x ?z_0)
        )
        (MaterialsEngineer ?x)
        (Designer ?x)
        (TaskAgent ?x)
        (Engineer ?x)
        (SoftwareAgent ?x)
      )
    )
    :effect ( and
      (CheckConsistency)
      (when
        (= a a)
        (and
          (SpecificationsAgent ?x)
        )
      )
    )
  )
  (:action assignSoftwareAgent
    :parameters ( ?x )
    :precondition ( and
      (not (CheckConsistency))
      (not (Error))
      (or
        (MaterialsAgent ?x)
        (Developer ?x)
        (SpecificationsAgent ?x)
        (ElectronicsAgent ?x)
        (CodingAgent ?x)
        (DesignAgent ?x)
        (InformaticEngineer ?x)
        (Employee ?x)
        (TestingAgent ?x)
        (ElectronicEngineer ?x)
        (exists (?z_0 )
          (hasPersonalInfo ?x ?z_0)
        )
        (MaterialsEngineer ?x)
        (Designer ?x)
        (TaskAgent ?x)
        (Engineer ?x)
        (SoftwareAgent ?x)
      )
    )
    :effect ( and
      (CheckConsistency)
      (when
        (= a a)
        (and
          (SoftwareAgent ?x)
        )
      )
    )
  )
  (:action assignCodingAgent
    :parameters ( ?x )
    :precondition ( and
      (not (CheckConsistency))
      (not (Error))
      (or
        (MaterialsAgent ?x)
        (Developer ?x)
        (SpecificationsAgent ?x)
        (ElectronicsAgent ?x)
        (CodingAgent ?x)
        (DesignAgent ?x)
        (InformaticEngineer ?x)
        (Employee ?x)
        (TestingAgent ?x)
        (ElectronicEngineer ?x)
        (exists (?z_0 )
          (hasPersonalInfo ?x ?z_0)
        )
        (MaterialsEngineer ?x)
        (Designer ?x)
        (TaskAgent ?x)
        (Engineer ?x)
        (SoftwareAgent ?x)
      )
    )
    :effect ( and
      (CheckConsistency)
      (when
        (= a a)
        (and
          (CodingAgent ?x)
        )
      )
    )
  )
  (:action assignTestingAgent
    :parameters ( ?x )
    :precondition ( and
      (not (CheckConsistency))
      (not (Error))
      (or
        (MaterialsAgent ?x)
        (Developer ?x)
        (SpecificationsAgent ?x)
        (ElectronicsAgent ?x)
        (CodingAgent ?x)
        (DesignAgent ?x)
        (InformaticEngineer ?x)
        (Employee ?x)
        (TestingAgent ?x)
        (ElectronicEngineer ?x)
        (exists (?z_0 )
          (hasPersonalInfo ?x ?z_0)
        )
        (MaterialsEngineer ?x)
        (Designer ?x)
        (TaskAgent ?x)
        (Engineer ?x)
        (SoftwareAgent ?x)
      )
    )
    :effect ( and
      (CheckConsistency)
      (when
        (= a a)
        (and
          (TestingAgent ?x)
        )
      )
    )
  )
  (:action removePersonalInfo
    :parameters ( ?x ?y )
    :precondition ( and
      (not (CheckConsistency))
      (not (Error))
      (hasPersonalInfo ?x ?y)
    )
    :effect ( and
      (CheckConsistency)
      (when
        (= a a)
        (and
          (not (hasPersonalInfo ?x ?y))
        )
      )
    )
  )
  (:action assignElectronicsAgent
    :parameters ( ?x )
    :precondition ( and
      (not (CheckConsistency))
      (not (Error))
      (or
        (MaterialsAgent ?x)
        (Developer ?x)
        (SpecificationsAgent ?x)
        (ElectronicsAgent ?x)
        (CodingAgent ?x)
        (DesignAgent ?x)
        (InformaticEngineer ?x)
        (Employee ?x)
        (TestingAgent ?x)
        (ElectronicEngineer ?x)
        (exists (?z_0 )
          (hasPersonalInfo ?x ?z_0)
        )
        (MaterialsEngineer ?x)
        (Designer ?x)
        (TaskAgent ?x)
        (Engineer ?x)
        (SoftwareAgent ?x)
      )
    )
    :effect ( and
      (CheckConsistency)
      (when
        (= a a)
        (and
          (ElectronicsAgent ?x)
        )
      )
    )
  )
  (:action hireInformaticEng
    :parameters ( ?n )
    :precondition ( and
      (not (CheckConsistency))
      (not (Error))
      (= a a)
    )
    :effect ( and
      (CheckConsistency)
      (when
        (not
          (exists ( ?x2 ?x3 ?x1 )
            (and
              (not
                (=?x1 ?x3 )
              )
              (not
                (=?x2 ?x3 )
              )
              (InformaticEngineer ?x2)
              (InformaticEngineer ?x1)
              (InformaticEngineer ?x3)
              (not
                (=?x1 ?x2 )
              )
            )
          )
        )
        (and
          (InformaticEngineer ?n)
        )
      )
    )
  )
  (:action assignMaterialsAgent
    :parameters ( ?x )
    :precondition ( and
      (not (CheckConsistency))
      (not (Error))
      (or
        (MaterialsAgent ?x)
        (Developer ?x)
        (SpecificationsAgent ?x)
        (ElectronicsAgent ?x)
        (CodingAgent ?x)
        (DesignAgent ?x)
        (InformaticEngineer ?x)
        (Employee ?x)
        (TestingAgent ?x)
        (ElectronicEngineer ?x)
        (exists (?z_0 )
          (hasPersonalInfo ?x ?z_0)
        )
        (MaterialsEngineer ?x)
        (Designer ?x)
        (TaskAgent ?x)
        (Engineer ?x)
        (SoftwareAgent ?x)
      )
    )
    :effect ( and
      (CheckConsistency)
      (when
        (= a a)
        (and
          (MaterialsAgent ?x)
        )
      )
    )
  )
  (:action assignTaskAgent
    :parameters ( ?x )
    :precondition ( and
      (not (CheckConsistency))
      (not (Error))
      (or
        (MaterialsAgent ?x)
        (Developer ?x)
        (SpecificationsAgent ?x)
        (ElectronicsAgent ?x)
        (CodingAgent ?x)
        (DesignAgent ?x)
        (InformaticEngineer ?x)
        (Employee ?x)
        (TestingAgent ?x)
        (ElectronicEngineer ?x)
        (exists (?z_0 )
          (hasPersonalInfo ?x ?z_0)
        )
        (MaterialsEngineer ?x)
        (Designer ?x)
        (TaskAgent ?x)
        (Engineer ?x)
        (SoftwareAgent ?x)
      )
    )
    :effect ( and
      (CheckConsistency)
      (when
        (= a a)
        (and
          (TaskAgent ?x)
        )
      )
    )
  )
  (:action CheckConsistencyAction
    :parameters ( )
    :precondition ( and
      (CheckConsistency)
      (not (Error))
    )
    :effect ( and
      (not (CheckConsistency))
      (when
        (or
          (exists (?x_6 )
            (and
              (SpecificationsAgent ?x_6)
              (MaterialsEngineer ?x_6)
            )
          )
          (exists (?x_8 ?z_0 )
            (and
              (hasPersonalInfo ?z_0 ?x_8)
              (DesignAgent ?x_8)
            )
          )
          (exists (?x_8 ?z_0 )
            (and
              (hasPersonalInfo ?z_0 ?x_8)
              (MaterialsEngineer ?x_8)
            )
          )
          (exists (?x_8 )
            (and
              (FullName ?x_8)
              (DesignAgent ?x_8)
            )
          )
          (exists (?x_1 )
            (and
              (ElectronicsAgent ?x_1)
              (InformaticEngineer ?x_1)
            )
          )
          (exists (?x_2 )
            (and
              (CodingAgent ?x_2)
              (ElectronicEngineer ?x_2)
            )
          )
          (exists (?x_8 )
            (and
              (FullName ?x_8)
              (Designer ?x_8)
            )
          )
          (exists (?x_8 ?z_0 )
            (and
              (hasPersonalInfo ?z_0 ?x_8)
              (SoftwareAgent ?x_8)
            )
          )
          (exists (?x_8 )
            (and
              (FullName ?x_8)
              (SoftwareAgent ?x_8)
            )
          )
          (exists (?x_8 ?z_0 )
            (and
              (hasPersonalInfo ?z_0 ?x_8)
              (ElectronicsAgent ?x_8)
            )
          )
          (exists (?x_8 ?z_0 )
            (and
              (FullName ?x_8)
              (hasPersonalInfo ?x_8 ?z_0)
            )
          )
          (exists (?x_8 )
            (and
              (FullName ?x_8)
              (CodingAgent ?x_8)
            )
          )
          (exists (?x_7 )
            (and
              (Developer ?x_7)
              (SpecificationsAgent ?x_7)
            )
          )
          (exists (?x_5 )
            (and
              (ElectronicsAgent ?x_5)
              (Designer ?x_5)
            )
          )
          (exists (?x_8 ?z_0 )
            (and
              (hasPersonalInfo ?z_0 ?x_8)
              (Employee ?x_8)
            )
          )
          (exists (?x_8 ?z_0 )
            (and
              (hasPersonalInfo ?z_0 ?x_8)
              (InformaticEngineer ?x_8)
            )
          )
          (exists (?x_8 )
            (and
              (FullName ?x_8)
              (SpecificationsAgent ?x_8)
            )
          )
          (exists (?x_8 ?z_0 )
            (and
              (hasPersonalInfo ?z_0 ?x_8)
              (TaskAgent ?x_8)
            )
          )
          (exists (?x_8 )
            (and
              (FullName ?x_8)
              (MaterialsEngineer ?x_8)
            )
          )
          (exists (?x_8 ?z_0 )
            (and
              (hasPersonalInfo ?z_0 ?x_8)
              (MaterialsAgent ?x_8)
            )
          )
          (exists (?x_8 ?z_0 )
            (and
              (hasPersonalInfo ?z_0 ?x_8)
              (Designer ?x_8)
            )
          )
          (exists (?x_8 )
            (and
              (FullName ?x_8)
              (TestingAgent ?x_8)
            )
          )
          (exists (?x_8 )
            (and
              (FullName ?x_8)
              (Employee ?x_8)
            )
          )
          (exists (?x_8 )
            (and
              (FullName ?x_8)
              (ElectronicEngineer ?x_8)
            )
          )
          (exists (?x_8 ?z_0 )
            (and
              (SpecificationsAgent ?x_8)
              (hasPersonalInfo ?z_0 ?x_8)
            )
          )
          (exists (?x_8 ?z_0 )
            (and
              (hasPersonalInfo ?z_0 ?x_8)
              (ElectronicEngineer ?x_8)
            )
          )
          (exists (?x_3 )
            (and
              (MaterialsEngineer ?x_3)
              (ElectronicsAgent ?x_3)
            )
          )
          (exists (?x_8 ?z_0 )
            (and
              (hasPersonalInfo ?z_0 ?x_8)
              (Engineer ?x_8)
            )
          )
          (exists (?x_4 )
            (and
              (Designer ?x_4)
              (SoftwareAgent ?x_4)
            )
          )
          (exists (?x_6 )
            (and
              (CodingAgent ?x_6)
              (MaterialsEngineer ?x_6)
            )
          )
          (exists (?x_8 )
            (and
              (FullName ?x_8)
              (Engineer ?x_8)
            )
          )
          (exists (?x_8 ?z_0 ?z_1 )
            (and
              (hasPersonalInfo ?z_1 ?x_8)
              (hasPersonalInfo ?x_8 ?z_0)
            )
          )
          (exists (?x_8 )
            (and
              (FullName ?x_8)
              (MaterialsAgent ?x_8)
            )
          )
          (exists (?x_8 )
            (and
              (FullName ?x_8)
              (InformaticEngineer ?x_8)
            )
          )
          (exists (?x_8 )
            (and
              (FullName ?x_8)
              (TaskAgent ?x_8)
            )
          )
          (exists (?x_8 )
            (and
              (FullName ?x_8)
              (Developer ?x_8)
            )
          )
          (exists (?x_8 )
            (and
              (FullName ?x_8)
              (ElectronicsAgent ?x_8)
            )
          )
          (exists (?x_8 ?z_0 )
            (and
              (CodingAgent ?x_8)
              (hasPersonalInfo ?z_0 ?x_8)
            )
          )
          (exists (?x_6 )
            (and
              (SoftwareAgent ?x_6)
              (MaterialsEngineer ?x_6)
            )
          )
          (exists (?x_0 )
            (and
              (InformaticEngineer ?x_0)
              (ElectronicEngineer ?x_0)
            )
          )
          (exists (?x_4 )
            (and
              (Designer ?x_4)
              (CodingAgent ?x_4)
            )
          )
          (exists (?x_8 ?z_0 )
            (and
              (hasPersonalInfo ?z_0 ?x_8)
              (Developer ?x_8)
            )
          )
          (exists (?x_8 ?z_0 )
            (and
              (hasPersonalInfo ?z_0 ?x_8)
              (TestingAgent ?x_8)
            )
          )
          (exists (?x_4 )
            (and
              (Designer ?x_4)
              (SpecificationsAgent ?x_4)
            )
          )
          (exists (?z_0 )
            (hasPersonalInfo ?z_0 ?z_0)
          )
        )
        (Error)
      )
    )
  )
)