# Profile data of *Canarium album* (Lour.) DC. fruits
---

We digitized the side profiles of 574 fruits of *Canarium album* (Lour.) DC., and used an explicit re-expression of Preston’s equation (referred to as EPE hereinafter) to fit the planar coordinates of each fruit profile. By using the estimated parameters, we calculated the volume and surface area of each fruit. The black_white.zip file saves the black and white .bmp images at 600 dpi for the 574 fruits profiles. The edge_data.zip file includes the planar coordinates of each of the 574 fruits, and the EPE results.csv file includes the estimated parameters and goodness-of-fit of the EPE, and the fruit surface area and volume calculated by the surface area and volume formulas of the solid of revolution based on the EPE for each fruit. In addition, the EPE results.csv file also provided the measured volumes of 574 fruits using the graduated cylinders. 


## Description of the data and file structure

In the black_white.zip file, there are 574 .bmp images at 600 dpi. The image size was scaled to its actual size using the ratio of its actual fruit length measured to the fruit length in the scanned image. This means that the image size in a .bmp file is equal to the actual size of a fruit profile. 

In the edge_data.zip file, there are 574 .csv files. In each .csv file, there are two columns, which record the x- and y-coordinates in cm for an arbitrary fruit’s side profile.

In the EPE results.csv file, there are 18 columns.
(1) Image saves the code of each of the 574 fruits. The number represents the individual code of a fruit. 
(2) x0 and y0 represent the coordinates of the center of a fruit profile (in cm), and theta represents the angle between the midline of the fruit profile and the x-axis. 
(3) a, b, c1, c2 and c3 represent the estimated values of the parameters of the explicit Preston equation (see Wang et al. [2023] for details), where the units of a and b are cm, and c1, c2, and c3 are unitless.
(4) scan.length, scan.width and scan.area represent the scanned fruit length (in cm), maximum width (in cm) and planar area (in cm2).
(5) RSS represents the residual sum of squares in y-coordinates in cm2. 
(6) sample.size represents the sample size.
(7) RMSE represents the root-mean-square error in cm.
(8) V.pre and S.pre represent the predicted fruit volume (in cm3) and surface area (in cm2) using the volume and surface area formulas based on the explicit Preston equation with estimated parameters, respectively.
(9) V.obs represents the volume (in cm3) measured using the graduated cylinder.

Reference(s)
Wang L, Shi P, Chen L, Gielis J, Niklas KJ. 2023. Evidence that Chinese white olive (*Canarium album* (Lour.) DC.) fruits are solids of revolution. Botany Letters, under review.

