# RA_Atlas_CITEseq

## Overview
This repo provides the data, code, and website for our work on "Cellular deconstruction of inflamed synovium defines diverse inflammatory phenotypes in rheumatoid arthritis". The data is generated through a collaborative effort with NIH funded [AMP RA/SLE (Accelerating Medicines Partnership Rheumatoid Arthritis and Systemic Lupus Erythematosus)](https://www.niams.nih.gov/grants-funding/funded-research/accelerating-medicines/RA-SLE).

The preprint version of our manuscript can be viewed and cited: [Zhang*, Jonsson*, Nathan*, Wei*, Millard*, et al, bioRxiv, 2022.](https://www.biorxiv.org/content/10.1101/2022.02.25.481990v1.abstract)

```
- RA Synovial Single-cell Multimodal (transcriptomics and Proteomics) Cell Atlas
- Inflammatory tissue stratification: RA Synovial Cell Type Abundance Phenotypes (CTAPs)
- Associations of certain CTAPs with disease-relevant cytokines, histology, serology metrics
- Reveal significant associations between RA causal genes and cell type-specific synovial CTAPs
- Infer inflammatory phenotypes from clinical trial bulk RNA-seq of RA synovial tissue
- Functional cell-cell interaction and immune mediator assays
- Microscopy analysis for different synovial phenotypes 
```

<img src="https://github.com/immunogenomics/RA_Atlas_CITEseq/blob/master/figure/overview.png" width="800" align="center">


## Website
Feel free to check out our [Website](https://immunogenomics.io/ampra2/) regarding the single-cell data and results.


## Source code
Source code for reproducing the results are available at our [Github repo](https://github.com/immunogenomics/RA_Atlas_CITEseq).


## Data availability
All the raw, processed, results, and metadata will be available at Synapse.

## Contact
Please email Fan Zhang (fanzhanglab@gmail.com) and Helena Jonsson (a.helena.jonsson@gmail.com) for any questions.
