# Deutsch
## Beschreibung des Vortrags (Abstract)
Der Vortrag soll einen ersten Einblick in die einfache, aber sehr universell nutzbare Auszeichnungssprache Markdown geben. Die Auszeichnungssprache "Markdown" hat zwar nur sehr peripher mit dem Thema "Coding" zu tun, wird aber an vielen Stellen für die Code-Dokumentation genutzt und kann beispielsweise in Verbindung mit dem Markdown-basierten Diagramm- und Charting-Tool "Mermaid" auch dazu genutzt werden, um Planungsprozesse in reinen Textdateien zu skizzieren. Außerdem wird es in Tools wie "GitLab" oder "JupyterNotebooks" vorausgesetzt bzw. findet dort häufig Verwendung, weshalb ein Überblick über diese einfache Auszeichnungssprache und dessen Anwendungsbereiche für die spätere Beschäftigung mit dem eigentlichen Code nützlich sein kann.

## Anmerkungen zu den Folien bzw. Datensatz
Der Foliensatz liegt in verschiedenen Formaten vor. Die Ursprungsdatei ist die Markdown-Datei mit dem Namen `hefdi-data-week_markdown_pietsch_20230615.md`, die mit dem Framework "[Marp](https://marp.app/)" erstellt wurde. Aus dieser wurden die `*.html`, `*.pdf` und `*.pptx` erzeugt. Der Export bringt folgende Probleme mit sich:

- **\*.pptx**: Eine mit "Marp" erzeugte *.pptx erstellt PowerPoint-Folien lediglich als Bilder. Integrierte, normalerweise auch klickbare Links sind zwar dann immer noch hellblau bzw. mit der Farbe des Links hinterlegt, können aber nicht mehr angeklickt werden.
- **\*.pdf**: In der *.pdf-Version ist die Darstellung des Mermaid-Diagramms (Folie 26) fehlerhaft.
- **\*.html**: Hier kommt es zu Problemen bei der Darstellung der Bilder, da diese praktisch live über den Pfad, wo sich die Bilder befinden, sprich dem Ordner "bilder", erzeugt werden. Einerseits können bestimmte Bilder und der Hintergrund nicht dargestellt werden, da sie aufgrund einer nicht offenen Lizenz entfernt werden mussten. Andererseits kommt es in manchen Fällen zu Problemen bei der relativen Pfadangabe, sodass auch die anderen Bilder nicht angezeigt werden. Ein Grund dafür könnte ein unterschiedliches Betriebssystem sein (z.B. Linux), da die Folien auf einem Windows-Rechner in das `*.html`-Format exportiert worden sind.

Sie können die ursprüngliche Markdown-Datei allerdings als Vorlage nutzen, um ihre eigenen Bilder und Texte und somit ihre eigenen Folien in verschiedenen Formaten zu erzeugen. Dazu hier eine kurze Anleitung, wie Sie "Marp" verwenden können:

1. Installieren Sie zuerst den Quelltext-Editor "Visual Studio Code" über den folgenden Link: [https://code.visualstudio.com/](https://code.visualstudio.com/).
2. Öffnen Sie "Visual Studio Code" (nutzen Sie am besten die englische Version) und klicken Sie `Strg`+`Shift`+`X` oder klicken Sie links auf `Extensions`.
3. Geben Sie in das Suchfeld `Marp for VS Code` ein uns installieren Sie die Erweiterung.
4. Nun können Sie mit `Strg`+`Shift`+`E` oder einem Klick auf `Explorer` zu den Dateien zurückkehren und die Markdown-Datei anklicken.
5. Um nun eine Side-by-Side-Preview in "Visual Studio Code" zu erzeugen, klicken Sie zuerst `Strg`+`K`, um in den Shortcut-Modus zu gelangen und klicken Sie dann (ohne `Strg`+`K` weiter gedrückt zu halten) die Taste `V`. In der Side-by-Side-Preview können Sie nun live sehen, welche Änderungen Sie durch die Änderung der Markdown-Datei erzeugen.
6. Wenn Sie mit der Bearbeitung der Folien fertig sind, können Sie die Markdown-Datei nun in ein anderes Format exportieren. Hier bietet sich vor allem `*.html` an. Dafür klicken Sie, während Sie sich in der Markdown-Datei befinden auf die zwei sich überlappenden Dreiecke oben rechts ("Show Quick Pick of Marp Commands"). In dem dann erscheinenden Dropdown-Menü klicken Sie auf "Export Slide Deck..." und wählen nun das Format für die Folien aus.

# English
## Description of the talk (Abstract)
The talk is intended to give a first insight into the simple but very universally usable "Markdown" language. Although Markdown is only peripherally related to coding, it is used in many places for code documentation and can also be used, for example, in conjunction with the Markdown-based diagramming and charting tool "Mermaid" to outline planning processes in plain text files. Furthermore, it is a prerequisite in tools such as "GitLab" or "JupyterNotebooks" or is frequently used there, which is why an overview of this simple markup language and its areas of application can be useful for dealing with the actual code later on.

## Notes on the slides or data set
The slide set is available in different formats. The original file is the Markdown file named `hefdi-data-week_markdown_pietsch_20230615.md`, which was created with the framework "[Marp](https://marp.app/)". From this the `*.html`, `*.pdf` and `*.pptx` were created. With the export came up the following problems:

- **\*.pptx**: A *.pptx created with "Marp" creates PowerPoint slides as images only. Integrated, normally also clickable links are then still highlighted in light blue or with the color of the link, but can no longer be clicked.
- **\*.pdf**: In the *.pdf version, the display of the Mermaid diagram (slide 26) is incorrect.
- **\*.html**: Here there are problems with the display of the images, since they are created practically live via the path where the images are located, i.e. the folder "bilder". On the one hand, certain images and the background cannot be displayed because they had to be removed due to a non-open license. On the other hand, in some cases there are problems with the relative path, so that the other images are not displayed either. One reason for this could be a different operating system (e.g. Linux), since the slides have been exported to `*.html` format on a Windows system.

However, you can use the original Markdown file as a template to create your own images and text and thus your own slides in different formats. For this purpose, here is a short tutorial on how to use "Marp":

1. First install the source code editor "Visual Studio Code" via the following link: [https://code.visualstudio.com/](https://code.visualstudio.com/).
2. Open "Visual Studio Code" (use best the english version) and click `Ctrl`+`Shift`+`X` or click on `Extensions` on the left.
3. Type `Marp for VS Code` in the search field and install the extension.
4. Now you can return to the files with `Ctrl`+`Shift`+`E` or click on `Explorer` and click on the Markdown file.
5. Now to create a side-by-side preview in "Visual Studio Code", first click `Ctrl`+`K` to enter the shortcut mode and then click (without holding down `Ctrl`+`K` any further) the `V` key. In the side-by-side preview, you can now see live what changes you are creating by modifying the Markdown file.
6. When you have finished editing the slides, you can now export the Markdown file to another format. The most suitable format here is `*.html`. To do this, while you are in the Markdown file, click on the two overlapping triangles at the top right ("Show Quick Pick of Marp Commands"). In the dropdown menu that appears, click on "Export Slide Deck..." and now select the format for the slides.