---

title: Einführung in Markdown und Beispiele für dessen Anwendungsbereiche
# paginate: true
marp: true
theme: uncover
class: invert
backgroundImage: url("./bilder/hefdi_background.png")
footer: " "
style: |
  header {
    position: absolute;
    top: 0px;
    left: 0px;
    height: 100%;
    margin: 0px;
  }
  header img {
    position: absolute;
    top: 0px;
    left: 0px;
    right: 0px;
    width: 1280px;
    height: 280px;
  }
  .two-columns {
    display: grid;
    grid-template-columns: repeat(2, minmax(0, 1fr));
    gap: 1rem;
  }
  .three-columns {
    display: grid;
    grid-template-columns: repeat(3, minmax(0, 1fr));
    gap: 1rem;
  }
  .mermaid {
    font-size: 8px;
  }
#  section::after {
#  font-weight: bold;
#  color: red;
# }

math: mathjax
---

<style scoped>
h2 {
  margin-top: -430px;
}
h4 {
  margin-top: 0px;
  color: grey;
}
p {
  font-size: 24px;
  margin-top: 10px;
}
footer {
  background-color: white;
  height: 18%;
  bottom: 50px;
}
.footer-text {
  position: relative;
  color: #0346f5;
  font-size: 7px;
  top: 75px;
  right: -420px;
}
img[alt~="umr"] {
  position: fixed;
  height: 50px;
  top: 555px;
  right: 1050px;
  z-index: 2;
}
img[alt~="guf"] {
  position: fixed;
  height: 50px;
  top: 550px;
  right: 900px;
  z-index: 2;
}
img[alt~="fra-uas"] {
  position: fixed;
  height: 50px;
  top: 550px;
  right: 710px;
  z-index: 2;
}
img[alt~="hda"] {
  position: fixed;
  height: 50px;
  top: 550px;
  right: 525px;
  z-index: 2;
}
img[alt~="hsgm"] {
  position: fixed;
  height: 50px;
  top: 545px;
  right: 315px;
  z-index: 2;
}
img[alt~="hsrm"] {
  position: fixed;
  height: 35px;
  top: 550px;
  right: 85px;
  z-index: 2;
}
img[alt~="tuda"] {
  position: fixed;
  height: 50px;
  top: 615px;
  right: 1060px;
  z-index: 2;
}
img[alt~="thm"] {
  position: fixed;
  height: 50px;
  top: 615px;
  right: 870px;
  z-index: 2;
}
img[alt~="jlu"] {
  position: fixed;
  height: 50px;
  top: 615px;
  right: 700px;
  z-index: 2;
}
img[alt~="uks"] {
  position: fixed;
  height: 35px;
  top: 620px;
  right: 500px;
  z-index: 2;
}
img[alt~="hfd"] {
  position: fixed;
  height: 35px;
  top: 620px;
  right: 285px;
  z-index: 2;
}
img[alt~="hmwk"] {
  position: fixed;
  height: 38px;
  top: 630px;
  right: 100px;
  z-index: 2;
}
</style>

<!-- _backgroundImage: url("./bilder/hefdi_background_title.png") -->
<!-- _footer: <div class='footer-text'>gefördert durch:</div> -->

![umr](./bilder/umr_logo.svg)
![guf](./bilder/guf_logo.png)
![fra-uas](./bilder/fra-uas_logo.png)
![hda](./bilder/h_da_logo.png)
![hsgm](./bilder/hsgm_logo.png)
![hsrm](./bilder/hsrm_logo.png)
![tuda](./bilder/tuda_logo.png)
![thm](./bilder/thm_logo.png)
![jlu](./bilder/jlu_logo_w1181.png)
![uks](./bilder/uks_logo.png)
![hfd](./bilder/hfd_logo.png)
![hmwk](./bilder/hmwk_logo.png)

## Einführung in Markdown

#### …und Beispiele für dessen Anwendungsbereiche

**Referent:** Andre M. Pietsch (JLU Gießen)
**E-Mail:** <a href="mailto:andre.m.pietsch@bibsys.uni-giessen.de">Andre.M.Pietsch@bibsys.uni-giessen.de</a>

<!-- 
- Begrüßen
- Sich vorstellen
- Was ist HeFDI?
- Was ist die HeFDI Data Week?
- Auf ELN-Track morgen hinweisen und auf Q&A-Session
- Track eröffnen (HeFDI Data Week, HeFDI, Überblick über Vorträge)
- Hintergründe für den Vortrag erläutern (HeFDI Data School, eigene Hintergründe: Ziel ist nicht die Missionierung, sondern zu zeigen, wo Markdown vielleicht auch einfach besser geeignet ist als ein Word-Dokument)
-->

---

<style scoped>
ul {
  background: #485a8e;
  padding: 30px 50px;
}
li {
  padding: 5px;
  font-size: 34px;
}
</style>

## Heutige Ziele

#### …oder Fragen, auf die Sie nach dem heutigen Vortrag Antworten haben sollten.

- Was ist Markdown und warum sollte man es verwenden?
- Wie formatiere ich Inhalte in Markdown?
- Wo findet Markdown überall Anwendung?
- Wo liegen die Grenzen von Markdown?

<!-- 
- Zielgruppe definieren
- Ziele erläutern
- Aber auch darauf eingehen, dass Markdown nicht die Lösung für alles ist.
-->

---

<!-- _header: "![w:100%](./bilder/banner_01.jpg)" -->

## Was ist Markdown?

---

<style scoped>
li {
  font-size: 34px;
}
</style>

![bg left:33% invert h:40%](./bilder/markdown_logo_bw.png)

- vereinfachte Auszeichnungssprache
- Erstveröffentlichung: 2004
- Entwickler: John Gruber / Aaron Swartz
- Dateiendung: *.md
- MIME-Type: text/markdown
- zunächst vorwiegend im Bereich der Software- und Webentwicklung genutzt (z.B. GitHub)
- mittlerweile auch entwicklungsferne Einsatzgebiete (z.B. Obsidian)

<!-- 
Markdown bedeutet in diesem Fall übersetzt so viel wie "Abschrift".

MIME-Type bedeutet Multipurpose Internet Mail Extension. Man bezeichnet es häudig auch als Content-Type, da dieser die Daten im Body von Dokumenten im Internet klassifiziert, um dem Webserver mitzuteilen, welche Daten er an den Browser senden soll.

Hauptgrund für die Entwicklung von Markdown war laut Gruber, dass er für seine Webseiten immer wieder Texte in nervigem HTML verfassen musste. Er wollte eine einfache Lösung, ähnlich dem Schreiben einer E-Mail, um Webtexte zu produzieren.
-->

---

<style scoped>
h2 {
  padding-top: 90px;
}
</style>

<!-- _header: "![w:100%](./bilder/banner_01.jpg)" -->

## Warum sollte man Markdown verwenden?

---

<style scoped>
li {
  font-size: 32px;
}
</style>

![bg right:25%](./bilder/computer_screen_edited.jpg)

- menschenlesbar
- nicht-proprietär: Markdown ist einfach <span style="color:red; font-weight:bold">Text</span>
- einfach zu erlernen
- <span style="color:red; font-weight:bold">unabhängig</span> vom Betriebssystem nachnutzbar
- nicht gebunden an bestimmte Software bzw. Tools
- <span style="color:red; font-weight:bold">geringe Fehleranfälligkeit</span>, einfache Korrekturen
- <span style="color:red; font-weight:bold">einfache Konvertierung</span> in viele gängige Formate (z.B. PDF, HTML)
- Konzentration auf Inhalt, nicht auf Formatierung, <span style="color:red; font-weight:bold">gut für die Dokumentation</span>

<!-- Vor allem im Bereich des Codens ist Markdown neben der Codekommentierung eigentlich unerlässlich, da in einem Team mit Markdown auch die entsprechende Dokumentation mitversioniert werden kann, da es rein textbasiert ist.

Es gibt auch noch zusätzliche Vorteile, wie beispielsweise einen extrem großen Support durch die Community. -->

---

<style scoped>
h2 {
  padding-top: 90px;
}
</style>

<!-- _header: "![w:100%](./bilder/banner_01.jpg)" -->

## Wie verwende ich Markdown?

---

**einfachste Verwendungsmöglichkeit**

jeder einfache, bereits integrierte Texteditor Ihres Betriebssystems:

- Linux (Ubuntu): [Nano](https://wiki.ubuntuusers.de/Nano/)
- Mac OS X: [TextEdit](https://support.apple.com/de-de/guide/textedit/welcome/mac)
- Windows: Editor

<span style="color:red;font-weight:bold">Nachteil</span>: Keine Komfortfunktionen oder Preview!

---

<style scoped>
h1 {
  position: relative;
  font-size: 60px;
  top: -290px;
}
</style>

<!-- transition: fade -->

![bg fit](./bilder/ausschnitt_editor.png)
![bg fit contrast blur](./bilder/ausschnitt_editor_preview.png)

# Markdown im Editor ohne Preview

---

<style scoped>
h1 {
  position: relative;
  font-size: 60px;
  top: -290px;
}
</style>

![bg fit](./bilder/ausschnitt_editor.png)
![bg fit contrast](./bilder/ausschnitt_editor_preview.png)

<!-- transition: none -->

# Wie es mit Preview aussehen könnte

---

<style scoped>
h1 {
  font-size: 54px;
}
h2 {
  color: grey;
  font-size: 36px;
}
li {
  font-size: 34px
}
</style>

# Kostenfreie Markdown-Editoren mit erhöhtem Funktionsumfang

<div class="two-columns">
<div>

## Reine Markdown-Editoren:
- [Pulsar-Edit](https://pulsar-edit.dev/)
- [Ghostwriter](https://ghostwriter.kde.org/de/)
- [MarkText](https://github.com/marktext/marktext)
- [Bluefish](https://bluefish.openoffice.nl/index.html)
- [HedgeDoc](https://hedgedoc.org/) (webbasiert)

</div>
<div>

## Code-Editoren:
- [VSCode](https://code.visualstudio.com/)
- [PyCharm](https://www.jetbrains.com/pycharm/)
- [IntelliJ IDEA](https://www.jetbrains.com/idea/)

</div>
</div>

<!-- Pulsar-Edit ist ein Community-Folgeprojekt zum sehr beliebten, aber eingestellten Markdown-Editor "Atom". -->

---

<style scoped>
h2 {
  padding-top: 90px;
}
</style>

<!-- _header: "![w:100%](./bilder/banner_01.jpg)" -->

## Wie formatiere ich Inhalte in Markdown?

---

<style scoped>
header {
  top: 25px;
  right: 0px;
}
h1 {
  font-size: 50px;
  text-align: left;
}
h2 {
  font-size: 46px;
  text-align: left;
}
h3 {
  font-size: 42px;
  text-align: left;
}
h4 {
  font-size: 38px;
  text-align: left;
}
h5 {
  color: grey;
}
li {
  font-size: 26px;
}
p {
  text-align: left;
}
</style>

<!-- _header: <span style="font-size:70px;color:white;font-weight:bold">Überschriften</span> -->

<div class="three-columns">
<div>

##### Markdown

```markdown
# Überschrift 1

## Überschrift 2

### Überschrift 3

#### Überschrift 4
```


<span style="font-size:36px;color:red;font-weight:bold">Wichtig:</span>
- Leerzeile vor und nach Überschrift
- Leerzeichen nach "#"


</div>
<div>

##### HTML

```html
<h1>Überschrift 1</h1>

<h2>Überschrift 2</h2>

<h3>Überschrift 3</h3>

<h4>Überschrift 4</h4>
```

</div>
<div>

##### Output

# Überschrift 1

## Überschrift 2

### Überschrift 3

#### Überschrift 4

</div>
</div>

<!-- Wichtig: Vergessen Sie nicht das Leerzeichen zwischen der Raute und der eigentlichen Überschrift. Setzen Sie außerdem immer Leerzeilen vor und nach den Überschriften, bevor Sie weitere Überschriften oder Absätze einfügen, sonst gibt es Probleme beim Rendern des Output. -->

---

<style scoped>
header {
  top: 25px;
  right: 0px;
}
h5 {
  color: grey;
}
li {
  font-size: 21px;
}
p {
  text-align: left;
  font-size: 26px;
}
</style>

<!-- _header: <span style="font-size:70px;color:white;font-weight:bold">Absätze</span> -->

<div class="three-columns">
<div>

##### Markdown

```markdown
Dies ist ein Absatz. Er 
besteht aus mehreren Zeilen

Und dies ist ein weiterer
Absatz aus mehreren Zeilen,
ein sehr schöner Absatz.
```

<span style="font-size:36px;color:red;font-weight:bold">Wichtig:</span>
- Absätze werden durch eine Leerzeile getrennt.
- Einrückungen vor einem Absatz sind nicht erlaubt.

</div>
<div>

##### HTML

```html
<p>Dies ist ein Absatz. Er 
besteht aus mehreren Zeilen
</p>

<p>Und dies ist ein weiterer
Absatz aus mehreren Zeilen,
ein sehr schöner Absatz.
</p>
```

</div>
<div>

##### Output

Dies ist ein Absatz. Er besteht aus mehreren Zeilen

Und dies ist ein weiterer Absatz aus mehreren Zeilen, ein sehr schöner Absatz.

</div>

<!-- Das <p>-Element in HTML steht für das Wort "paragraph" -->

---

<style scoped>
header {
  top: 25px;
  right: 0px;
}
h5 {
  color: grey;
}
li {
  font-size: 26px;
}
p {
  font-size: 26px;
  text-align: left;
}
</style>

<!-- _header: <span style="font-size:70px;color:white;font-weight:bold">Zeilenumbrüche</span> -->

<div class="three-columns">
<div>

##### Markdown

```markdown
Dies ist die erste Zeile.  
Dies ist die zweite Zeile.
```

<span style="font-size:36px;color:red;font-weight:bold">Wichtig:</span>
- Um einen Zeilenumbruch zu erzeugen, setze zwei Leerzeichen nach der Zeile und nutze dann "Enter".

</div>
<div>

##### HTML

```html
<p>Dies ist die erste Zeile.<br>
Dies ist die zweite Zeile.</p>
```

</div>
<div>

##### Output

Dies ist die erste Zeile.
Dies ist die zweite Zeile.

</div>

---

<style scoped>
header {
  top: 25px;
  right: 0px;
}
h5 {
  color: grey;
}
li {
  font-size: 26px;
}
p {
  text-align: left;
  font-size: 27px;
}
</style>

<!-- _header: <span style="font-size:70px;color:white;font-weight:bold">Hervorhebungen</span> -->

<div class="three-columns">
<div>

##### Markdown

```markdown
**Dies** ist Fettdruck.
__Dies__ auch.
Im W**or**t jedoch nur so.


*Dies* ist Kursivdruck.
_Dies_ auch.
Im W*or*t jedoch nur so.


***Dies*** ist kursiv und fett.
___Dies___ auch.
Im W***or***t jedoch nur so.
```
 
</div>
<div>

##### HTML

```html
<strong>Dies</strong> ist Fettdruck.
<strong>Dies</strong> auch.
Im W<strong>or</strong>t jedoch nur so.


<em>Dies</em> ist Kursivdruck.
<em>Dies</em> auch.
Im W<em>or</em>t jedoch nur so.


<em><strong>Dies</strong></em> 
ist kursiv und fett.
<em><strong>Dies</strong></em> auch.
Im W<em><strong>or</strong></em>t
jedoch nur so.
```

</div>
<div>

##### Output

**Dies** ist Fettdruck.
__Dies__ auch.
Im W**or**t jedoch nur so.


*Dies* ist Kursivdruck.
_Dies_ auch.
Im W*or*t jedoch nur so.


***Dies*** ist kursiv und fett.
___Dies___ auch.
Im W***or***t jedoch nur so.

</div>

---

<style scoped>
header {
  top: 25px;
  right: 0px;
}
h5 {
  color: grey;
}
li {
  font-size: 18px;
}
p {
  text-align: left;
}
</style>

<!-- _header: <span style="font-size:70px;color:white;font-weight:bold">Ordered Lists</span> -->

<div class="three-columns">
<div>

##### Markdown

```markdown
1. Punkt 1
2. Punkt 2
    1. Unterpunkt 1
    2. Unterpunkt 2
3. Punkt 3
```

<span style="font-size:36px;color:red;font-weight:bold">Wichtig:</span>

- Ordered List muss mit 1 beginnen, danach ist die Reihenfolge egal.
- Für Unterpunkte doppelte Einrückungen nutzen.
- Nummer für Unterkategorien (z.B. 2.1) sind nicht möglich.

</div>
<div>

##### HTML

```html
<ol>
  <li>Punkt 1</li>
  <li>Punkt 2</li>
    <ol>
      <li>Unterpunkt 1</li>
      <li>Unterpunkt 2</li>
    </ol>
  <li>Punkt 3</li>
</ol>
```

</div>
<div>

##### Output

1. Punkt 1
2. Punkt 2
    1. Unterpunkt 1
    2. Unterpunkt 2
3. Punkt 3

</div>

---

<style scoped>
header {
  top: 25px;
  right: 0px;
}
h5 {
  color: grey;
}
li {
  font-size: 21px;
}
p {
  text-align: left;
}
</style>

<!-- _header: <span style="font-size:70px;color:white;font-weight:bold">Unordered Lists</span> -->

<div class="three-columns">
<div>

##### Markdown

```markdown
- Punkt 1
- Punkt 2
    - Unterpunkt 1
    - Unterpunkt 2
- Punkt 3
```

<span style="font-size:36px;color:red;font-weight:bold">Wichtig:</span>

- Unordered Lists werden mit <span style="color:red;font-weight:bold">-</span>, <span style="color:red;font-weight:bold">*</span> oder <span style="color:red;font-weight:bold">+</span> erzeugt.
- Für Unterpunkte doppelte Einrückungen nutzen.

</div>
<div>

##### HTML

```html
<ul>
  <li>Punkt 1</li>
  <li>Punkt 2</li>
    <ul>
      <li>Unterpunkt 1</li>
      <li>Unterpunkt 2</li>
    </ul>
  <li>Punkt 3</li>
</ul>
```

</div>
<div>

##### Output

- Punkt 1
- Punkt 2
    - Unterpunkt 1
    - Unterpunkt 2
- Punkt 3

</div>

---

<style scoped>
header {
  top: 25px;
  right: 0px;
}
h5 {
  color: grey;
}
li {
  font-size: 26px;
}
p {
  text-align: left;
}
img {
  display: block;
  margin-left: auto;
  margin-right: auto;
  width: 50%;
  filter: invert(1);
}
</style>

<!-- _header: <span style="font-size:70px;color:white;font-weight:bold">Bilder</span> -->

<div class="three-columns">
<div>

##### Markdown

```markdown
![Markdown-Logo](./bilder/markdown_logo_bw.png)
```

</div>
<div>

##### HTML

```html
<img src="./bilder/markdown_logo_bw.png" 
alt="Markdown-Logo">
```

</div>
<div>

##### Output

![Markdown-Logo](./bilder/markdown_logo_bw.png)

</div>

---

<style scoped>
header {
  top: 25px;
  right: 0px;
}
h5 {
  color: grey;
}
li {
  font-size: 26px;
}
p {
  text-align: left;
}
</style>

<!-- _header: <span style="font-size:70px;color:white;font-weight:bold">Links</span> -->

<div class="three-columns">
<div>

##### Markdown

```markdown
[HeFDI](www.hefdi.de)

Dies ist ein [Link](www.hefdi.de).
```

</div>
<div>

##### HTML

```html
<a href="www.hefdi.de">HeFDI</a>

Dies ist ein 
<a href="www.hefdi.de">Link</a>.
```

</div>
<div>

##### Output

[HeFDI](www.hefdi.de)

Dies ist ein [Link](www.hefdi.de).

</div>

---

<style scoped>
header {
  top: 25px;
  right: 0px;
}
h5 {
  color: grey;
}
li {
  font-size: 26px;
}
p {
  text-align: left;
}
img {
  display: block;
  margin-left: auto;
  margin-right: auto;
  width: 100%;
}
</style>

<!-- _header: <span style="font-size:70px;color:white;font-weight:bold">Zitate</span> -->

<div class="three-columns">
<div>

##### Markdown

```markdown
> Dies ist ein Zitat.
>
> Mit zwei Absätzen.
>
>> Und einem Zitat im Zitat.
```

</div>
<div>

##### HTML

```html
<blockquote>
  <p>Dies ist ein Zitat.</p>
  <p>Mit zwei Absätzen</p>
  <blockquote>
    <p>Und einem Zitat im Zitat</p>
  </blockquote>
</blockquote>
```

</div>
<div>

##### Output

![](./bilder/nested_quotation.png)

</div>

---

<style scoped>
header {
  top: 25px;
  right: 0px;
}
h5 {
  color: grey;
}
li {
  font-size: 26px;
}
p {
  text-align: left;
}
img {
  display: block;
  margin-left: auto;
  margin-right: auto;
  width: 100%;
}
</style>

<!-- _header: <span style="font-size:70px;color:white;font-weight:bold">Fußnoten</span> -->

<div class="three-columns">
<div>

##### Markdown

```markdown
Dies ist ein Text.[^1]

Dies ist ein zweiter Absatz.[^2]

[^1]: Dies ist die Fußnote.
[^2]: Dies ist die zweite Fußnote.
```

</div>
<div>

##### HTML

```html
<p>Dies ist ein Text.
<a href="#footnote-1">[1]</a></p>
<p>Dies ist ein zweiter Absatz.
<a href="#footnote-2">[2]</a></p>

<p id="footnote-1">
[1] Dies ist die Fußnote.</p>
<p id="footnote-1">
[2] Dies ist die zweite Fußnote.</p>
```

</div>
<div>

##### Output

![](./bilder/footnotes.png)


</div>

---

<style scoped>
header {
  top: 25px;
  right: 0px;
}
h5 {
  color: grey;
}
li {
  font-size: 20px;
}
p {
  text-align: left;
  font-size: 22px;
}
</style>

<!-- _header: <span style="font-size:70px;color:white;font-weight:bold">Code-Blöcke</span> -->

<div class="three-columns">
<div>

##### Markdown

Dies ist kein Codeblock.
```markdown
Dies ist ein Codeblock.
```
Im Text kann man auch `einzelne Worte` als Code darstellen.

<span style="font-size:36px;color:red;font-weight:bold">Wichtig:</span>

- wird mit drei <span style="color:red;font-weight:bold">`</span> eingeleitet und beendet
- innerhalb von Text nutzt man jeweils ein <span style="color:red;font-weight:bold">`</span>

</div>
<div>

##### HTML

```html
<p>Dies ist kein Codeblock.</p>
<pre>
  <code>
    Dies ist ein Codeblock
  </code>
</pre>
<p>
  Im Text kann man auch 
  einzelne Worte als Code
  darstellen.
</p>
```

</div>
<div>

##### Output

Dies ist kein Codeblock.
```markdown
Dies ist ein Codeblock.
```
Im Text kann man auch `einzelne Worte` als Code darstellen.

</div>

---

<style scoped>
header {
  top: 25px;
  right: 0px;
}
h5 {
  color: grey;
}
li {
  font-size: 26px;
}
p {
  text-align: left;
  font-size: 22px;
}
</style>

<!-- _header: <span style="font-size:70px;color:white;font-weight:bold">Character Escapes</span> -->

<div class="three-columns">
<div>

##### Markdown

```markdown
Man kann funktionale Zeichen
mit einem Backslash ohne ihre
Funktion darstellen (escapen), 
z.B.\[Link\]\(Adresse\).
```

</div>
<div>

##### HTML

```html
Man kann funktionale Zeichen
mit einem Backslash ohne ihre
Funktion darstellen (escapen), 
z.B. &#91;Link&#93;&#40;Adresse&#41;.
```

</div>
<div>

##### Output

Man kann funktionale Zeichen mit einem Backslash ohne ihre Funktion darstellen (escapen), z.B. \[Link\]\(Adresse\).

</div>

---

<style scoped>
header {
  top: 25px;
  right: 0px;
}
h5 {
  color: grey;
}
li {
  font-size: 26px;
}
p {
  text-align: left;
  font-size: 22px;
}
</style>

<!-- _header: <span style="font-size:70px;color:white;font-weight:bold">[Mathematische Formeln](https://math.meta.stackexchange.com/questions/5020/mathjax-basic-tutorial-and-quick-reference)</span> -->

<div class="three-columns">
<div>

##### Markdown

```markdown
Mathematische Gleichungen
im Text: $ax^2+bc+c$.

Oder als Blöcke:
$$ I_{xx}=\int\int_Ry^2f(x,y)\cdot{}dydx $$

$$
f(x) =
  \int_{-\infty}^\infty
  \hat f(\xi)\,e^{2 \pi i \xi x}
  \,d\xi
$$
```

</div>
<div>

##### HTML

```html
<script type="text/javascript" 
  id="MathJax-script" async
  src="https://cdn.jsdelivr.net/npm/mathjax@3/es5/tex-chtml.js">
</script>
<p>Mathematische Gleichungen
im Text: \(ax^2+bc+c$\).</p>
  
<p>Oder als Blöcke:
$$ I_{xx}=\int\int_Ry^2f(x,y)\cdot{}dydx $$
  
$$
f(x) =
  \int_{-\infty}^\infty
  \hat f(\xi)\,e^{2 \pi i \xi x}
  \,d\xi
$$
</p>
```

</div>
<div>

##### Output

Mathematische Gleichungen
im Text: $ax^2+bc+c$.

Oder als Blöcke:
$$ I_{xx}=\int\int_Ry^2f(x,y)\cdot{}dydx $$

$$
f(x) =
  \int_{-\infty}^\infty
  \hat f(\xi)\,e^{2 \pi i \xi x}
  \,d\xi
$$

</div>

---

<style scoped>
header {
  top: 25px;
  right: 0px;
}
h5 {
  color: grey;
}
li {
  font-size: 26px;
}
p {
  text-align: left;
}
</style>

<!-- _header: <span style="font-size:70px;color:white;font-weight:bold">Diagramme mit <a href="https://mermaid.js.org/intro/">Mermaid</a></span> -->

<div class="three-columns">
<div>

##### Markdown

```mermaid
flowchart TD;
  A[Start]-->B[Entscheidung 1];
  A-->C[Entscheidung 2];
  B-->D[Ende];
  C-->D;
```

</div>
<div>

##### HTML

```html
<script type="module">
  import mermaid from 'https://cdn.jsdelivr.
  net/npm/mermaid@10/dist/mermaid.esm.min.mjs';
</script>
<pre class="mermaid">
  flowchart TD;
    A[Start]-->B[Entscheidung 1];
    A-->C[Entscheidung 2];
    B-->D[Ende];
    C-->D;
</pre>
```

</div>
<div>

##### Output

<div class="mermaid">
flowchart TD;
  A[Start]-->B[Entscheidung 1];
  A-->C[Entscheidung 2];
  B-->D[Ende];
  C-->D;
</div>

<!-- mermaid.js -->
<script src="https://unpkg.com/mermaid@10.2.0/dist/mermaid.min.js">
mermaid.initialize({startOnLoad:true});
</script>

</div>

---

<style scoped>
h2 {
  padding-top: 90px;
}
</style>

<!-- _header: "![w:100%](./bilder/banner_01.jpg)" -->

## Wo findet Markdown überall Anwendung?

---
<style scoped>
div {
  position: fixed;
  background-color: black;
  border: 6px dashed grey;
  border-radius: 16px;
  width: 900px;
  top: 50%;
  left: 50%;
  transform: translate(-50%, -50%);
}
</style>

<!-- _backgroundImage: none) -->
![bg opacity:0.7](./bilder/screenshot_obsidian.png)

<div>

<span style=color:lightgrey>

## Note-Taking Apps

</span>

### [Joplin](https://joplinapp.org/)
### [Obsidian](https://obsidian.md/)

</div>

---

<style scoped>
div {
  position: fixed;
  background-color: black;
  border: 6px dashed grey;
  border-radius: 16px;
  width: 900px;
  top: 50%;
  left: 50%;
  transform: translate(-50%, -50%);
}
</style>

<!-- _backgroundImage: none) -->
![bg opacity:0.7](./bilder/screenshot_jupyter_notebooks.png)

<div>

<span style=color:lightgrey>

## Code-Dokumentation

</span>

### [Jupyter Notebooks](https://jupyter.org/)

</div>

---

<style scoped>
div {
  position: fixed;
  background-color: black;
  border: 6px dashed grey;
  border-radius: 16px;
  width: 900px;
  top: 50%;
  left: 50%;
  transform: translate(-50%, -50%);
}
</style>

<!-- _backgroundImage: none) -->
![bg opacity:0.7](./bilder/screenshot_gitlab.png)

<div>

<span style=color:lightgrey>

## Versionsverwaltung

</span>

### [GitLab](https://about.gitlab.com/)
### [GitHub](https://github.com/)

</div>

---

<style scoped>
div {
  position: fixed;
  background-color: black;
  border: 6px dashed grey;
  border-radius: 16px;
  width: 900px;
  top: 50%;
  left: 50%;
  transform: translate(-50%, -50%);
}
</style>

<!-- _backgroundImage: none) -->
![bg opacity:0.7](./bilder/screenshot_pandoc_md_to_pdf.png)

<div>

<span style=color:lightgrey>

## Dokumentkonvertierung

</span>

### [Pandoc](https://pandoc.org/)

</div>

---

<style scoped>
div {
  position: fixed;
  background-color: black;
  border: 6px dashed grey;
  border-radius: 16px;
  width: 900px;
  top: 50%;
  left: 50%;
  transform: translate(-50%, -50%);
}
</style>

<!-- _backgroundImage: none) -->
![bg opacity:0.7](./bilder/screenshot_zettlr.png)

<div>

<span style=color:lightgrey>

## Wissenschaftliches Schreiben

</span>

### [Zettlr](https://www.zettlr.com/)

</div>

---

<style scoped>
div {
  position: fixed;
  background-color: black;
  border: 6px dashed grey;
  border-radius: 16px;
  width: 900px;
  top: 50%;
  left: 50%;
  transform: translate(-50%, -50%);
}
</style>

<!-- _backgroundImage: none) -->
![bg opacity:0.7](./bilder/screenshot_marp.png)

<div>

<span style=color:lightgrey>

## Präsentationen

</span>

### [Reveal.js](https://revealjs.com/)
### [Marp](https://marp.app/)
### [React](https://de.legacy.reactjs.org/) + [MDX Deck](https://www.npmjs.com/package/mdx-deck)

</div>

---

<style scoped>
h2 {
  padding-top: 90px;
}
</style>

<!-- _header: "![w:100%](./bilder/banner_01.jpg)" -->

## Wo liegen die Grenzen von Markdown?

---


<style scoped>
li {
  font-size: 32px;
}
</style>

![bg right:30%](./bilder/computer_chip_lightning.jpg)

- komplexe Layouts (z.B. bei der Positionierung von Elementen oder der Erstellung von komplexen Tabellen)
- Anpassung typografischer Eigenschaften (Schriftgröße, Schriftart, Zeilenabstände)
- Textfluss um Grafiken
- animiertes oder multimediales Material
- interaktive Elemente

<!-- 
Komplexe Layouts:
Markdown ist hauptsächlich auf einfache Textformatierung ausgelegt und unterstützt keine komplexen Layoutoptionen wie mehrspaltige Tabellen oder komplexe Positionierung von Elementen.

Feinere Typografie:
Markdown bietet begrenzte Optionen für die Steuerung der Typografie, wie Schriftarten, Schriftgrößen oder Zeilenabstände. Es ist darauf ausgelegt, einfachen Text ohne detaillierte Formatierungen darzustellen.

Grafiken mit Textfluss:
Obwohl Markdown die Einbindung von Bildern unterstützt, gibt es keine Möglichkeit, den Textfluss um die Bilder herum anzupassen. Das bedeutet, dass Bilder in Markdown-Dokumenten normalerweise nur neben dem Text angezeigt werden können.

Animiertes oder multimediales Material:
Markdown ist auf statische Inhalte beschränkt und bietet keine Möglichkeit, animierte Grafiken oder Multimedia-Inhalte wie Videos oder Audiodateien einzufügen.

Interaktive Elemente:
Markdown kann statische Inhalte darstellen, aber es bietet keine direkte Unterstützung für interaktive Elemente wie Formulare, Buttons oder andere dynamische Elemente.
 -->


