#!/usr/bin/env python3
# -*- coding: utf-8 -*-
"""
Created on Fri Mar 11 10:07:09 2022

@author: david
"""

import pandas as pd
import geopandas as gpd
import matplotlib.pyplot as plt
import xarray as xr
import glob
import numpy as np


Q_all_mean = pd.read_pickle("/path/to/Data_Ehype/eHYPE_discharge_model-mean_historical.pkl")

Q_all_rcp45 = pd.read_pickle("/path/to/Data_Ehype/eHYPE_discharge_model-mean_rcp45.pkl")
Q_all_rcp85 = pd.read_pickle("/path/to/Data_Ehype/eHYPE_discharge_model-mean_rcp85.pkl")
Q_all_scen = pd.concat([Q_all_rcp45, Q_all_rcp85], axis=1)
Q_all_scen.columns = Q_all_scen.columns.droplevel(1)

Q_all_obs = pd.read_pickle("/metstor_nfs/home/david/Projects/SECURES/Data_Ehype/discharge_all_ERA5.pkl")

cmt_id = Q_all_mean.columns.to_frame().set_index("pp_id")
cmt_id["cmt_id"] = cmt_id["cmt_id"].astype(int)

pp_db = "../Data_Power/jrc-hydro-power-plant-database_geometry_est_ann_power.xlsx"
pp_df = pd.read_excel(pp_db)
pp_gdf = gpd.GeoDataFrame(pp_df, geometry=gpd.points_from_xy(pp_df.lon, pp_df.lat))
pp_gdf.set_crs(epsg=4326, inplace=True)
pp_gdf.set_index("id", inplace=True)

nuts2 = gpd.read_file("/path/to/NUTS2.shp")[["NUTS","NUTS0","geometry"]]

nuts3 = gpd.read_file("../GIS/OGDEXT_NUTS_1_STATISTIK_AUSTRIA_NUTS3_20220101/STATISTIK_AUSTRIA_NUTS3_20220101.shp", encoding="utf8").to_crs(epsg=4326)
nuts3.columns = ["NUTS3", "NUTS3_name", "geometry"]

pp_gdf = gpd.sjoin(pp_gdf, nuts2, how="left")
pp_gdf = gpd.sjoin(pp_gdf, nuts3, how="left", rsuffix = "nuts3")

pp_gdf.loc[pp_gdf.country_code == "EL", "country_code"] = "GR"
pp_gdf.loc[pp_gdf.country_code == "UK", "country_code"] = "GB"

pp_gdf = pp_gdf.loc[pp_gdf.country_code == pp_gdf.NUTS0]



for pp_type in ["ror", "reservoir"]:
    if pp_type == "reservoir":
        daily_power_all = pd.read_pickle("../Data_Ehype/daily_power_reservoir_all.pkl")
        
        daily_power_obs = pd.read_pickle("../Data_Ehype/daily_power_reservoir_all_ERA5.pkl")
        
        df_apc = pd.read_pickle("../Data_Ehype/scaling_reservoir_all.pkl")
        df_apc = pd.DataFrame(df_apc, columns = ["k"])
        
        df_apc_obs = pd.read_pickle("../Data_Ehype/scaling_reservoir_all_ERA5.pkl")
        df_apc_obs = pd.DataFrame(df_apc, columns = ["k_ERA5"])
        
    elif pp_type == "ror":
        daily_power_all = pd.read_pickle("../Data_Ehype/daily_power_ror_all.pkl")
        
        daily_power_obs = pd.read_pickle("../Data_Ehype/daily_power_ror_era5.pkl")
        
        df_apc = pd.read_pickle("../Data_Ehype/daily_ror_all_apc_all.pkl")
        df_apc_obs = pd.read_pickle("../Data_Ehype/daily_ror_all_apc_era5.pkl")
        df_apc_obs.columns += "_ERA5"


    plants_out = sorted(set(daily_power_all.loc[:,daily_power_all.max()>0].columns.get_level_values(0)) & set(pp_gdf.index))
    df_meta = pd.concat([pp_gdf.loc[plants_out,:].drop('Unnamed: 0', axis=1), df_apc.loc[plants_out], df_apc_obs.loc[plants_out], cmt_id.loc[plants_out, "cmt_id"]], axis=1)
    
    daily_power_all = daily_power_all[plants_out]
    daily_power_obs = daily_power_obs[plants_out]

#%% Export data
# TODO check variable names
    df_meta.to_file("/path/to/Data_deliver/Metadata_" + pp_type + ".shp")
    df_meta.to_csv("/path/to/Data_deliver/Metadata_" + pp_type + ".csv", sep=",")
    

#%% aggregate countrywise

    countries = df_meta.loc[daily_power_all.columns.get_level_values(0),"country_code"]
    
    daily_power_all_cols_orig = daily_power_all.columns
    daily_power_all.columns = pd.MultiIndex.from_arrays([daily_power_all.columns.get_level_values(0),
                                                           daily_power_all.columns.get_level_values(1),
                                                           countries])
    
    countries_obs = df_meta.loc[daily_power_obs.columns.get_level_values(0),"country_code"]
    daily_power_obs_cols_orig = daily_power_obs.columns
    daily_power_obs.columns = pd.MultiIndex.from_arrays([daily_power_obs.columns.get_level_values(0),
                                                           daily_power_obs.columns.get_level_values(1),
                                                           countries_obs])
    
    
    power_agg = daily_power_all.groupby(axis=1,level=[1,2]).sum()
    power_hist_mean = power_agg.loc[slice("1981-01-01","2005-12-31"),"historical"].mean()
    power_rel = power_agg/power_hist_mean[power_agg.columns.get_level_values(1)].values

    power_rel.loc[slice("1971-01-01","2005-12-31"), "historical"].dropna(0).to_csv("/path/to/Data_deliver/Power_daily_relative_countries_historical_1971-2005_" + pp_type + ".csv", float_format = "%.3f", sep=",")
    power_rel.loc[slice("2006-01-01","2100-12-31"), "rcp45"].dropna(0).to_csv("/path/to/Data_deliver/Power_daily_relative_countries_EUR-11_ICHEC-EC-EARTH_rcp45_r12i1p1_KNMI-RACMO22E_2006-2100_" + pp_type + ".csv", float_format = "%.3f", sep=",")
    power_rel.loc[slice("2006-01-01","2100-12-31"), "rcp85"].dropna(0).to_csv("/path/to/Data_deliver/Power_daily_relative_countries_EUR-11_ICHEC-EC-EARTH_rcp85_r12i1p1_KNMI-RACMO22E_2006-2100_" + pp_type + ".csv", float_format = "%.3f", sep=",")
    
    power_agg.loc[slice("1971-01-01","2005-12-31"), "historical"].dropna(0).to_csv("/path/to/Data_deliver/Power_daily_absolute_countries_historical_1971-2005_" + pp_type + ".csv", float_format = "%.3f", sep=",")
    power_agg.loc[slice("2006-01-01","2100-12-31"), "rcp45"].dropna(0).to_csv("/path/to/Data_deliver/Power_daily_absolute_countries_EUR-11_ICHEC-EC-EARTH_rcp45_r12i1p1_KNMI-RACMO22E_2006-2100_" + pp_type + ".csv", float_format = "%.3f", sep=",")
    power_agg.loc[slice("2006-01-01","2100-12-31"), "rcp85"].dropna(0).to_csv("/path/to/Data_deliver/Power_daily_absolute_countries_EUR-11_ICHEC-EC-EARTH_rcp85_r12i1p1_KNMI-RACMO22E_2006-2100_" + pp_type + ".csv", float_format = "%.3f", sep=",")
    
    
    power_agg_obs = daily_power_obs.groupby(axis=1,level=[1,2]).sum()
    power_obs_mean = power_agg_obs.loc[slice("1981-01-01","2005-12-31")].mean()
    power_rel_obs = power_agg_obs/power_obs_mean


    power_rel_obs.loc[slice('1981-01-01','2010-12-31'), "ERA5"].dropna(0).to_csv("/path/to/Data_deliver/Power_daily_relative_countries_ERA5_1981-2010_" + pp_type + ".csv", float_format = "%.3f", sep=",") 
    power_agg_obs.loc[slice('1981-01-01','2010-12-31'), "ERA5"].dropna(0).to_csv("/path/to/Data_deliver/Power_daily_absolute_countries_ERA5_1981-2010_" + pp_type + ".csv", float_format = "%.3f", sep=",")
    
    
    
#%%  aggregate on NUTS  
    nuts = df_meta.loc[daily_power_all.columns.get_level_values(0),"NUTS"]
    
    daily_power_all.columns = daily_power_all_cols_orig
    daily_power_all.columns = pd.MultiIndex.from_arrays([daily_power_all.columns.get_level_values(0),
                                                           daily_power_all.columns.get_level_values(1),
                                                           nuts])
    
    nuts_obs = df_meta.loc[daily_power_obs.columns.get_level_values(0),"NUTS"]
    daily_power_obs.columns = daily_power_obs_cols_orig
    daily_power_obs.columns = pd.MultiIndex.from_arrays([daily_power_obs.columns.get_level_values(0),
                                                           daily_power_obs.columns.get_level_values(1),
                                                           nuts_obs])
    
    power_agg = daily_power_all.groupby(axis=1,level=[1,2]).sum()
    power_hist_mean = power_agg.loc[slice("1981-01-01","2005-12-31"),"historical"].mean()
    power_rel = power_agg/power_hist_mean[power_agg.columns.get_level_values(1)].values


    power_rel.loc[slice("1971-01-01","2005-12-31"), "historical"].dropna(0).to_csv("/path/to/Data_deliver/Power_daily_relative_NUTS2_historical_1971-2005_" + pp_type + ".csv", float_format = "%.3f", sep=",")
    power_rel.loc[slice("2006-01-01","2100-12-31"), "rcp45"].dropna(0).to_csv("/path/to/Data_deliver/Power_daily_relative_NUTS2_EUR-11_ICHEC-EC-EARTH_rcp45_r12i1p1_KNMI-RACMO22E_2006-2100_" + pp_type + ".csv", float_format = "%.3f", sep=",")
    power_rel.loc[slice("2006-01-01","2100-12-31"), "rcp85"].dropna(0).to_csv("/path/to/Data_deliver/Power_daily_relative_NUTS2_EUR-11_ICHEC-EC-EARTH_rcp85_r12i1p1_KNMI-RACMO22E_2006-2100_" + pp_type + ".csv", float_format = "%.3f", sep=",")   
    
    power_agg.loc[slice("1971-01-01","2005-12-31"), "historical"].dropna(0).to_csv("/path/to/Data_deliver/Power_daily_absolute_NUTS2_historical_1971-2005_" + pp_type + ".csv", float_format = "%.3f", sep=",")
    power_agg.loc[slice("2006-01-01","2100-12-31"), "rcp45"].dropna(0).to_csv("/path/to/Data_deliver/Power_daily_absolute_NUTS2_EUR-11_ICHEC-EC-EARTH_rcp45_r12i1p1_KNMI-RACMO22E_2006-2100_" + pp_type + ".csv", float_format = "%.3f", sep=",")
    power_agg.loc[slice("2006-01-01","2100-12-31"), "rcp85"].dropna(0).to_csv("/path/to/Data_deliver/Power_daily_absolute_NUTS2_EUR-11_ICHEC-EC-EARTH_rcp85_r12i1p1_KNMI-RACMO22E_2006-2100_" + pp_type + ".csv", float_format = "%.3f", sep=",")  
    
    power_agg_obs = daily_power_obs.groupby(axis=1,level=[1,2]).sum()
    power_obs_mean = power_agg_obs.loc[slice("1981-01-01","2005-12-31")].mean()
    power_rel_obs = power_agg_obs/power_obs_mean


    power_rel_obs.loc[slice('1981-01-01','2010-12-31'), "ERA5"].dropna(0).to_csv("/path/to/Data_deliver/Power_daily_relative_NUTS2_ERA5_1981-2010_" + pp_type + ".csv", float_format = "%.3f", sep=",") 
    power_agg_obs.loc[slice('1981-01-01','2010-12-31'), "ERA5"].dropna(0).to_csv("/path/to/Data_deliver/Power_daily_absolute_NUTS2_ERA5_1981-2010_" + pp_type + ".csv", float_format = "%.3f", sep=",")
    
#%%  aggregate on NUTS  
    nuts = df_meta.loc[daily_power_all.columns.get_level_values(0),"NUTS3"]
    
    daily_power_all.columns = daily_power_all_cols_orig
    daily_power_all.columns = pd.MultiIndex.from_arrays([daily_power_all.columns.get_level_values(0),
                                                           daily_power_all.columns.get_level_values(1),
                                                           nuts])
    
    nuts_obs = df_meta.loc[daily_power_obs.columns.get_level_values(0),"NUTS3"]
    daily_power_obs.columns = daily_power_obs_cols_orig
    daily_power_obs.columns = pd.MultiIndex.from_arrays([daily_power_obs.columns.get_level_values(0),
                                                           daily_power_obs.columns.get_level_values(1),
                                                           nuts_obs])
    
    power_agg = daily_power_all.groupby(axis=1,level=[1,2]).sum()
    power_hist_mean = power_agg.loc[slice("1981-01-01","2005-12-31"),"historical"].mean()
    power_rel = power_agg/power_hist_mean[power_agg.columns.get_level_values(1)].values


    power_rel.loc[slice("1971-01-01","2005-12-31"), "historical"].dropna(0).to_csv("/path/to/Data_deliver/Power_daily_relative_NUTS3_historical_1971-2005_" + pp_type + ".csv", float_format = "%.3f", sep=",")
    power_rel.loc[slice("2006-01-01","2100-12-31"), "rcp45"].dropna(0).to_csv("/path/to/Data_deliver/Power_daily_relative_NUTS3_EUR-11_ICHEC-EC-EARTH_rcp45_r12i1p1_KNMI-RACMO22E_2006-2100_" + pp_type + ".csv", float_format = "%.3f", sep=",")
    power_rel.loc[slice("2006-01-01","2100-12-31"), "rcp85"].dropna(0).to_csv("/path/to/Data_deliver/Power_daily_relative_NUTS3_EUR-11_ICHEC-EC-EARTH_rcp85_r12i1p1_KNMI-RACMO22E_2006-2100_" + pp_type + ".csv", float_format = "%.3f", sep=",")   
    
    power_agg.loc[slice("1971-01-01","2005-12-31"), "historical"].dropna(0).to_csv("/path/to/Data_deliver/Power_daily_absolute_NUTS3_historical_1971-2005_" + pp_type + ".csv", float_format = "%.3f", sep=",")
    power_agg.loc[slice("2006-01-01","2100-12-31"), "rcp45"].dropna(0).to_csv("/path/to/Data_deliver/Power_daily_absolute_NUTS3_EUR-11_ICHEC-EC-EARTH_rcp45_r12i1p1_KNMI-RACMO22E_2006-2100_" + pp_type + ".csv", float_format = "%.3f", sep=",")
    power_agg.loc[slice("2006-01-01","2100-12-31"), "rcp85"].dropna(0).to_csv("/path/to/Data_deliver/Power_daily_absolute_NUTS3_EUR-11_ICHEC-EC-EARTH_rcp85_r12i1p1_KNMI-RACMO22E_2006-2100_" + pp_type + ".csv", float_format = "%.3f", sep=",")  
    
    
    power_agg_obs = daily_power_obs.groupby(axis=1,level=[1,2]).sum()
    power_obs_mean = power_agg_obs.loc[slice("1981-01-01","2005-12-31")].mean()
    power_rel_obs = power_agg_obs/power_obs_mean

    power_rel_obs.loc[slice('1981-01-01','2010-12-31'), "ERA5"].dropna(0).to_csv("/path/to/Data_deliver/Power_daily_relative_NUTS3_ERA5_1981-2010_" + pp_type + ".csv", float_format = "%.3f", sep=",") 
    power_agg_obs.loc[slice('1981-01-01','2010-12-31'), "ERA5"].dropna(0).to_csv("/path/to/Data_deliver/Power_daily_absolute_NUTS3_ERA5_1981-2010_" + pp_type + ".csv", float_format = "%.3f", sep=",")
    

