#!/usr/bin/env python3
# -*- coding: utf-8 -*-
"""
@author: david
"""

import pandas as pd
import geopandas as gpd
import matplotlib.pyplot as plt
import xarray as xr
import glob
import numpy as np

flh = pd.read_excel("../Data_Power/FLH_1984_extracted_modified_countrycodes.xlsx", skiprows=1, index_col=0)

pp_db = "../Data_Power/jrc-hydro-power-plant-database.csv"
pp_df = pd.read_csv(pp_db)
pp_gdf = gpd.GeoDataFrame(pp_df, geometry=gpd.points_from_xy(pp_df.lon, pp_df.lat))
pp_gdf.set_crs(epsg=4326, inplace=True)

pp_gdf.loc[pp_gdf["type"].isin(["HDAM", "HPHS"]), "FLH"] = flh.loc[pp_gdf.loc[pp_gdf["type"].isin(["HDAM", "HPHS"]), "country_code"], "Reservoir"].values
pp_gdf.loc[pp_gdf["type"]=="HROR","FLH"] = flh.loc[pp_gdf.loc[pp_gdf["type"]=="HROR","country_code"],"ROR"].values

pp_gdf["avg_annual_generation_GWh_original"] = pp_gdf["avg_annual_generation_GWh"]
pp_gdf["avg_annual_generation_GWh"] = pp_gdf["avg_annual_generation_GWh"].fillna(pp_gdf["FLH"]*pp_gdf["installed_capacity_MW"]/1000)

pp_gdf.to_excel("../Data_Power/jrc-hydro-power-plant-database_geometry_est_ann_power.xlsx")
pp_gdf.to_file("../Data_Power/jrc-hydro-power-plant-database_geometry_est_ann_power.shp")
