#! /usr/bin/env python3

import numpy as np

def powercurve_land(ws):
    #TURBINE="N163-4.95"
    pc_raw_land="powerRel=(ws>=3&&ws<=26)?((ws>=3&&ws<3.5)*((ws-3)*0.0432323232323232+0.0096969696969697)+(ws>=3.5&&ws<4)*((ws-3.5)*0.0577777777777778+0.0313131313131313)+(ws>=4&&ws<4.5)*((ws-4)*0.0711111111111111+0.0602020202020202)+(ws>=4.5&&ws<5)*((ws-4.5)*0.0852525252525252+0.0957575757575758)+(ws>=5&&ws<5.5)*((ws-5)*0.101414141414141+0.138383838383838)+(ws>=5.5&&ws<6)*((ws-5.5)*0.11959595959596+0.189090909090909)+(ws>=6&&ws<6.5)*((ws-6)*0.141414141414141+0.248888888888889)+(ws>=6.5&&ws<7)*((ws-6.5)*0.164040404040404+0.31959595959596)+(ws>=7&&ws<7.5)*((ws-7)*0.188686868686869+0.401616161616162)+(ws>=7.5&&ws<8)*((ws-7.5)*0.208888888888889+0.495959595959596)+(ws>=8&&ws<8.5)*((ws-8)*0.214949494949495+0.60040404040404)+(ws>=8.5&&ws<9)*((ws-8.5)*0.210909090909091+0.707878787878788)+(ws>=9&&ws<9.5)*((ws-9)*0.197171717171717+0.813333333333333)+(ws>=9.5&&ws<10)*((ws-9.5)*0.151919191919192+0.911919191919192)+(ws>=10&&ws<10.5)*((ws-10)*0.0242424242424242+0.987878787878788)+(ws>=10.5&&ws<11)*((ws-10.5)*0+1)+(ws>=11&&ws<11.5)*((ws-11)*0+1)+(ws>=11.5&&ws<12)*((ws-11.5)*0+1)+(ws>=12&&ws<12.5)*((ws-12)*0+1)+(ws>=12.5&&ws<13)*((ws-12.5)*0+1)+(ws>=13&&ws<13.5)*((ws-13)*0+1)+(ws>=13.5&&ws<14)*((ws-13.5)*0+1)+(ws>=14&&ws<14.5)*((ws-14)*0+1)+(ws>=14.5&&ws<15)*((ws-14.5)*0+1)+(ws>=15&&ws<15.5)*((ws-15)*0+1)+(ws>=15.5&&ws<16)*((ws-15.5)*0+1)+(ws>=16&&ws<16.5)*((ws-16)*0+1)+(ws>=16.5&&ws<17)*((ws-16.5)*0+1)+(ws>=17&&ws<17.5)*((ws-17)*0+1)+(ws>=17.5&&ws<18)*((ws-17.5)*0+1)+(ws>=18&&ws<18.5)*((ws-18)*0+1)+(ws>=18.5&&ws<19)*((ws-18.5)*0+1)+(ws>=19&&ws<19.5)*((ws-19)*0+1)+(ws>=19.5&&ws<20)*((ws-19.5)*0+1)+(ws>=20&&ws<20.5)*((ws-20)*0+1)+(ws>=20.5&&ws<21)*((ws-20.5)*0+1)+(ws>=21&&ws<21.5)*((ws-21)*0+1)+(ws>=21.5&&ws<22)*((ws-21.5)*0+1)+(ws>=22&&ws<22.5)*((ws-22)*0+1)+(ws>=22.5&&ws<23)*((ws-22.5)*-0.037979797979798+1)+(ws>=23&&ws<23.5)*((ws-23)*-0.0597979797979797+0.981010101010101)+(ws>=23.5&&ws<24)*((ws-23.5)*-0.0597979797979797+0.951111111111111)+(ws>=24&&ws<24.5)*((ws-24)*-0.0573737373737375+0.921212121212121)+(ws>=24.5&&ws<25)*((ws-24.5)*-0.0602020202020201+0.892525252525252)+(ws>=25&&ws<25.5)*((ws-25)*-0.0597979797979797+0.862424242424242)+(ws>=25.5&&ws<26)*((ws-25.5)*-0.05979797979798+0.832525252525253)+0):0;"
    
    pc_land = eval("lambda ws: " + pc_raw_land.split("?")[1].split(":")[0].replace("ws>", "(ws>").replace("&&",")&(").replace(")*(","))*("))
    
    return pc_land(ws)

def powercurve_offshore(ws):
    #TURBINE="V164-8000"
    pc_raw_offshore="powerRel=(ws>=3.5&&ws<=25)?((ws>=3.5&&ws<4)*((ws-3.5)*0.015+0.005)+(ws>=4&&ws<4.5)*((ws-4)*0.0675+0.0125)+(ws>=4.5&&ws<5)*((ws-4.5)*0.07+0.04625)+(ws>=5&&ws<5.5)*((ws-5)*0.06125+0.08125)+(ws>=5.5&&ws<6)*((ws-5.5)*0.06375+0.111875)+(ws>=6&&ws<6.5)*((ws-6)*0.0875+0.14375)+(ws>=6.5&&ws<7)*((ws-6.5)*0.0875+0.1875)+(ws>=7&&ws<7.5)*((ws-7)*0.13125+0.23125)+(ws>=7.5&&ws<8)*((ws-7.5)*0.13125+0.296875)+(ws>=8&&ws<8.5)*((ws-8)*0.15625+0.3625)+(ws>=8.5&&ws<9)*((ws-8.5)*0.15625+0.440625)+(ws>=9&&ws<9.5)*((ws-9)*0.18125+0.51875)+(ws>=9.5&&ws<10)*((ws-9.5)*0.18125+0.609375)+(ws>=10&&ws<10.5)*((ws-10)*0.1875+0.7)+(ws>=10.5&&ws<11)*((ws-10.5)*0.1875+0.79375)+(ws>=11&&ws<11.5)*((ws-11)*0.12+0.8875)+(ws>=11.5&&ws<12)*((ws-11.5)*0.0549999999999999+0.9475)+(ws>=12&&ws<12.5)*((ws-12)*0.03+0.975)+(ws>=12.5&&ws<13)*((ws-12.5)*0.02+0.99)+(ws>=13&&ws<13.5)*((ws-13)*0+1)+(ws>=13.5&&ws<14)*((ws-13.5)*0+1)+(ws>=14&&ws<14.5)*((ws-14)*0+1)+(ws>=14.5&&ws<15)*((ws-14.5)*0+1)+(ws>=15&&ws<15.5)*((ws-15)*0+1)+(ws>=15.5&&ws<16)*((ws-15.5)*0+1)+(ws>=16&&ws<16.5)*((ws-16)*0+1)+(ws>=16.5&&ws<17)*((ws-16.5)*0+1)+(ws>=17&&ws<17.5)*((ws-17)*0+1)+(ws>=17.5&&ws<18)*((ws-17.5)*0+1)+(ws>=18&&ws<18.5)*((ws-18)*0+1)+(ws>=18.5&&ws<19)*((ws-18.5)*0+1)+(ws>=19&&ws<19.5)*((ws-19)*0+1)+(ws>=19.5&&ws<20)*((ws-19.5)*0+1)+(ws>=20&&ws<20.5)*((ws-20)*0+1)+(ws>=20.5&&ws<21)*((ws-20.5)*0+1)+(ws>=21&&ws<21.5)*((ws-21)*0+1)+(ws>=21.5&&ws<22)*((ws-21.5)*0+1)+(ws>=22&&ws<22.5)*((ws-22)*0+1)+(ws>=22.5&&ws<23)*((ws-22.5)*0+1)+(ws>=23&&ws<23.5)*((ws-23)*0+1)+(ws>=23.5&&ws<24)*((ws-23.5)*0+1)+(ws>=24&&ws<24.5)*((ws-24)*0+1)+(ws>=24.5&&ws<25)*((ws-24.5)*0+1)+0):0;"
    
    pc_os = eval("lambda ws: " + pc_raw_offshore.split("?")[1].split(":")[0].replace("ws>", "(ws>").replace("&&",")&(").replace(")*(","))*("))
    
    return pc_os(ws)

def powercurve_land2(ws):
    #TURBINE="N163-4.95"
    pc_raw_land="powerRel=(ws>=3&&ws<=26)?((ws>=3&&ws<3.5)*((ws-3)*0.0432323232323232+0.0096969696969697)+(ws>=3.5&&ws<4)*((ws-3.5)*0.0577777777777778+0.0313131313131313)+(ws>=4&&ws<4.5)*((ws-4)*0.0711111111111111+0.0602020202020202)+(ws>=4.5&&ws<5)*((ws-4.5)*0.0852525252525252+0.0957575757575758)+(ws>=5&&ws<5.5)*((ws-5)*0.101414141414141+0.138383838383838)+(ws>=5.5&&ws<6)*((ws-5.5)*0.11959595959596+0.189090909090909)+(ws>=6&&ws<6.5)*((ws-6)*0.141414141414141+0.248888888888889)+(ws>=6.5&&ws<7)*((ws-6.5)*0.164040404040404+0.31959595959596)+(ws>=7&&ws<7.5)*((ws-7)*0.188686868686869+0.401616161616162)+(ws>=7.5&&ws<8)*((ws-7.5)*0.208888888888889+0.495959595959596)+(ws>=8&&ws<8.5)*((ws-8)*0.214949494949495+0.60040404040404)+(ws>=8.5&&ws<9)*((ws-8.5)*0.210909090909091+0.707878787878788)+(ws>=9&&ws<9.5)*((ws-9)*0.197171717171717+0.813333333333333)+(ws>=9.5&&ws<10)*((ws-9.5)*0.151919191919192+0.911919191919192)+(ws>=10&&ws<10.5)*((ws-10)*0.0242424242424242+0.987878787878788)+(ws>=10.5&&ws<22.5)*(1)+(ws>=22.5&&ws<23)*((ws-22.5)*-0.037979797979798+1)+(ws>=23&&ws<23.5)*((ws-23)*-0.0597979797979797+0.981010101010101)+(ws>=23.5&&ws<24)*((ws-23.5)*-0.0597979797979797+0.951111111111111)+(ws>=24&&ws<24.5)*((ws-24)*-0.0573737373737375+0.921212121212121)+(ws>=24.5&&ws<25)*((ws-24.5)*-0.0602020202020201+0.892525252525252)+(ws>=25&&ws<25.5)*((ws-25)*-0.0597979797979797+0.862424242424242)+(ws>=25.5&&ws<26)*((ws-25.5)*-0.05979797979798+0.832525252525253)+0):0;"
    
    pc_land = eval("lambda ws: " + pc_raw_land.split("?")[1].split(":")[0].replace("ws>", "(ws>").replace("&&",")&(").replace(")*(","))*("))
    
    return pc_land(ws)

def powercurve_offshore2(ws):
    #TURBINE="V164-8000"
    pc_raw_offshore="powerRel=(ws>=3.5&&ws<=25)?((ws>=3.5&&ws<4)*((ws-3.5)*0.015+0.005)+(ws>=4&&ws<4.5)*((ws-4)*0.0675+0.0125)+(ws>=4.5&&ws<5)*((ws-4.5)*0.07+0.04625)+(ws>=5&&ws<5.5)*((ws-5)*0.06125+0.08125)+(ws>=5.5&&ws<6)*((ws-5.5)*0.06375+0.111875)+(ws>=6&&ws<6.5)*((ws-6)*0.0875+0.14375)+(ws>=6.5&&ws<7)*((ws-6.5)*0.0875+0.1875)+(ws>=7&&ws<7.5)*((ws-7)*0.13125+0.23125)+(ws>=7.5&&ws<8)*((ws-7.5)*0.13125+0.296875)+(ws>=8&&ws<8.5)*((ws-8)*0.15625+0.3625)+(ws>=8.5&&ws<9)*((ws-8.5)*0.15625+0.440625)+(ws>=9&&ws<9.5)*((ws-9)*0.18125+0.51875)+(ws>=9.5&&ws<10)*((ws-9.5)*0.18125+0.609375)+(ws>=10&&ws<10.5)*((ws-10)*0.1875+0.7)+(ws>=10.5&&ws<11)*((ws-10.5)*0.1875+0.79375)+(ws>=11&&ws<11.5)*((ws-11)*0.12+0.8875)+(ws>=11.5&&ws<12)*((ws-11.5)*0.0549999999999999+0.9475)+(ws>=12&&ws<12.5)*((ws-12)*0.03+0.975)+(ws>=12.5&&ws<13)*((ws-12.5)*0.02+0.99)+(ws>=13&&ws<25)*(1)+0):0;"
    
    pc_os = eval("lambda ws: " + pc_raw_offshore.split("?")[1].split(":")[0].replace("ws>", "(ws>").replace("&&",")&(").replace(")*(","))*("))
    
    return pc_os(ws)

def powercurve_land3(ws):
    #TURBINE="N163-4.95"
    pc_raw_land="powerRel=(ws>=3&&ws<=26)?((ws>=3&&ws<3.5)*((ws-3)*0.0432323232323232+0.0096969696969697)+(ws>=3.5&&ws<4)*((ws-3.5)*0.0577777777777778+0.0313131313131313)+(ws>=4&&ws<4.5)*((ws-4)*0.0711111111111111+0.0602020202020202)+(ws>=4.5&&ws<5)*((ws-4.5)*0.0852525252525252+0.0957575757575758)+(ws>=5&&ws<5.5)*((ws-5)*0.101414141414141+0.138383838383838)+(ws>=5.5&&ws<6)*((ws-5.5)*0.11959595959596+0.189090909090909)+(ws>=6&&ws<6.5)*((ws-6)*0.141414141414141+0.248888888888889)+(ws>=6.5&&ws<7)*((ws-6.5)*0.164040404040404+0.31959595959596)+(ws>=7&&ws<7.5)*((ws-7)*0.188686868686869+0.401616161616162)+(ws>=7.5&&ws<8)*((ws-7.5)*0.208888888888889+0.495959595959596)+(ws>=8&&ws<8.5)*((ws-8)*0.214949494949495+0.60040404040404)+(ws>=8.5&&ws<9)*((ws-8.5)*0.210909090909091+0.707878787878788)+(ws>=9&&ws<9.5)*((ws-9)*0.197171717171717+0.813333333333333)+(ws>=9.5&&ws<10)*((ws-9.5)*0.151919191919192+0.911919191919192)+(ws>=10&&ws<10.5)*((ws-10)*0.0242424242424242+0.987878787878788)+(ws>=10.5&&ws<22.5)*((ws-22)*0+1)+(ws>=22.5&&ws<23)*((ws-22.5)*-0.037979797979798+1)+(ws>=23&&ws<23.5)*((ws-23)*-0.0597979797979797+0.981010101010101)+(ws>=23.5&&ws<24)*((ws-23.5)*-0.0597979797979797+0.951111111111111)+(ws>=24&&ws<24.5)*((ws-24)*-0.0573737373737375+0.921212121212121)+(ws>=24.5&&ws<25)*((ws-24.5)*-0.0602020202020201+0.892525252525252)+(ws>=25&&ws<25.5)*((ws-25)*-0.0597979797979797+0.862424242424242)+(ws>=25.5&&ws<26)*((ws-25.5)*-0.05979797979798+0.832525252525253)+0):0;"
    
    params = []
    for pp in pc_raw_land.split("?")[1].split("+0):")[0].split(")+("):
        pp2 = pp.split("*")
        ll = float(pp2[0].split("&&")[0].replace("ws>=","").replace("(",""))
        ul = float(pp2[0].split("&&")[1].replace("ws<","").replace(")",""))
        slope = float(pp2[2].split("+")[0])
        offset = float(pp2[2].split("+")[1].replace(")",""))
        params.append((ll, ul, slope, offset))

    pc_land = np.zeros(ws.shape, dtype=np.float32)
    for ll, ul, slope, offset in params:
        print("powercurve_land3",ll)
        pc_land[(ws>=ll) & (ws<ul)] += (ws[(ws>=ll) & (ws<ul)]-ll)*slope + offset
    pc_land[np.isnan(ws)] = np.nan
        
    return pc_land    

def powercurve_offshore3(ws):
    #TURBINE="V164-8000"
    pc_raw_offshore="powerRel=(ws>=3.5&&ws<=25)?((ws>=3.5&&ws<4)*((ws-3.5)*0.015+0.005)+(ws>=4&&ws<4.5)*((ws-4)*0.0675+0.0125)+(ws>=4.5&&ws<5)*((ws-4.5)*0.07+0.04625)+(ws>=5&&ws<5.5)*((ws-5)*0.06125+0.08125)+(ws>=5.5&&ws<6)*((ws-5.5)*0.06375+0.111875)+(ws>=6&&ws<6.5)*((ws-6)*0.0875+0.14375)+(ws>=6.5&&ws<7)*((ws-6.5)*0.0875+0.1875)+(ws>=7&&ws<7.5)*((ws-7)*0.13125+0.23125)+(ws>=7.5&&ws<8)*((ws-7.5)*0.13125+0.296875)+(ws>=8&&ws<8.5)*((ws-8)*0.15625+0.3625)+(ws>=8.5&&ws<9)*((ws-8.5)*0.15625+0.440625)+(ws>=9&&ws<9.5)*((ws-9)*0.18125+0.51875)+(ws>=9.5&&ws<10)*((ws-9.5)*0.18125+0.609375)+(ws>=10&&ws<10.5)*((ws-10)*0.1875+0.7)+(ws>=10.5&&ws<11)*((ws-10.5)*0.1875+0.79375)+(ws>=11&&ws<11.5)*((ws-11)*0.12+0.8875)+(ws>=11.5&&ws<12)*((ws-11.5)*0.0549999999999999+0.9475)+(ws>=12&&ws<12.5)*((ws-12)*0.03+0.975)+(ws>=12.5&&ws<13)*((ws-12.5)*0.02+0.99)+(ws>=13&&ws<25)*((ws-24.5)*0+1)+0):0;"
    
    params = []
    for pp in pc_raw_offshore.split("?")[1].split("+0):")[0].split(")+("):
        pp2 = pp.split("*")
        ll = float(pp2[0].split("&&")[0].replace("ws>=","").replace("(",""))
        ul = float(pp2[0].split("&&")[1].replace("ws<","").replace(")",""))
        slope = float(pp2[2].split("+")[0])
        offset = float(pp2[2].split("+")[1].replace(")",""))
        params.append((ll, ul, slope, offset))

    pc_os = np.zeros(ws.shape, dtype=np.float32)
    for ll, ul, slope, offset in params:
        print("powercurve_offshore3",ll)
        pc_os[(ws>=ll) & (ws<ul)] += (ws[(ws>=ll) & (ws<ul)]-ll)*slope + offset
    pc_os[np.isnan(ws)] = np.nan
        
    return pc_os

def powercurve_land4(ws2):
    ws = ws2.view().reshape(-1)
    #TURBINE="N163-4.95"
    pc_raw_land="powerRel=(ws>=3&&ws<=26)?((ws>=3&&ws<3.5)*((ws-3)*0.0432323232323232+0.0096969696969697)+(ws>=3.5&&ws<4)*((ws-3.5)*0.0577777777777778+0.0313131313131313)+(ws>=4&&ws<4.5)*((ws-4)*0.0711111111111111+0.0602020202020202)+(ws>=4.5&&ws<5)*((ws-4.5)*0.0852525252525252+0.0957575757575758)+(ws>=5&&ws<5.5)*((ws-5)*0.101414141414141+0.138383838383838)+(ws>=5.5&&ws<6)*((ws-5.5)*0.11959595959596+0.189090909090909)+(ws>=6&&ws<6.5)*((ws-6)*0.141414141414141+0.248888888888889)+(ws>=6.5&&ws<7)*((ws-6.5)*0.164040404040404+0.31959595959596)+(ws>=7&&ws<7.5)*((ws-7)*0.188686868686869+0.401616161616162)+(ws>=7.5&&ws<8)*((ws-7.5)*0.208888888888889+0.495959595959596)+(ws>=8&&ws<8.5)*((ws-8)*0.214949494949495+0.60040404040404)+(ws>=8.5&&ws<9)*((ws-8.5)*0.210909090909091+0.707878787878788)+(ws>=9&&ws<9.5)*((ws-9)*0.197171717171717+0.813333333333333)+(ws>=9.5&&ws<10)*((ws-9.5)*0.151919191919192+0.911919191919192)+(ws>=10&&ws<10.5)*((ws-10)*0.0242424242424242+0.987878787878788)+(ws>=10.5&&ws<22.5)*((ws-22)*0+1)+(ws>=22.5&&ws<23)*((ws-22.5)*-0.037979797979798+1)+(ws>=23&&ws<23.5)*((ws-23)*-0.0597979797979797+0.981010101010101)+(ws>=23.5&&ws<24)*((ws-23.5)*-0.0597979797979797+0.951111111111111)+(ws>=24&&ws<24.5)*((ws-24)*-0.0573737373737375+0.921212121212121)+(ws>=24.5&&ws<25)*((ws-24.5)*-0.0602020202020201+0.892525252525252)+(ws>=25&&ws<25.5)*((ws-25)*-0.0597979797979797+0.862424242424242)+(ws>=25.5&&ws<26)*((ws-25.5)*-0.05979797979798+0.832525252525253)+0):0;"
    
    params = []
    for pp in pc_raw_land.split("?")[1].split("+0):")[0].split(")+("):
        pp2 = pp.split("*")
        ll = float(pp2[0].split("&&")[0].replace("ws>=","").replace("(",""))
        ul = float(pp2[0].split("&&")[1].replace("ws<","").replace(")",""))
        slope = float(pp2[2].split("+")[0])
        offset = float(pp2[2].split("+")[1].replace(")",""))
        params.append((ll, ul, slope, offset))

    pc_land = np.zeros(ws.shape, dtype=np.float32)
    for ll, ul, slope, offset in params:
        print("powercurve_land3",ll)
        pc_land[(ws>=ll) & (ws<ul)] += (ws[(ws>=ll) & (ws<ul)]-ll)*slope + offset
    pc_land[np.isnan(ws)] = np.nan
    
    pc_out = pc_land.view().reshape(ws2.shape)
        
    return pc_out    

def powercurve_offshore4(ws2):
    ws = ws2.view().reshape(-1)
    #TURBINE="V164-8000"
    pc_raw_offshore="powerRel=(ws>=3.5&&ws<=25)?((ws>=3.5&&ws<4)*((ws-3.5)*0.015+0.005)+(ws>=4&&ws<4.5)*((ws-4)*0.0675+0.0125)+(ws>=4.5&&ws<5)*((ws-4.5)*0.07+0.04625)+(ws>=5&&ws<5.5)*((ws-5)*0.06125+0.08125)+(ws>=5.5&&ws<6)*((ws-5.5)*0.06375+0.111875)+(ws>=6&&ws<6.5)*((ws-6)*0.0875+0.14375)+(ws>=6.5&&ws<7)*((ws-6.5)*0.0875+0.1875)+(ws>=7&&ws<7.5)*((ws-7)*0.13125+0.23125)+(ws>=7.5&&ws<8)*((ws-7.5)*0.13125+0.296875)+(ws>=8&&ws<8.5)*((ws-8)*0.15625+0.3625)+(ws>=8.5&&ws<9)*((ws-8.5)*0.15625+0.440625)+(ws>=9&&ws<9.5)*((ws-9)*0.18125+0.51875)+(ws>=9.5&&ws<10)*((ws-9.5)*0.18125+0.609375)+(ws>=10&&ws<10.5)*((ws-10)*0.1875+0.7)+(ws>=10.5&&ws<11)*((ws-10.5)*0.1875+0.79375)+(ws>=11&&ws<11.5)*((ws-11)*0.12+0.8875)+(ws>=11.5&&ws<12)*((ws-11.5)*0.0549999999999999+0.9475)+(ws>=12&&ws<12.5)*((ws-12)*0.03+0.975)+(ws>=12.5&&ws<13)*((ws-12.5)*0.02+0.99)+(ws>=13&&ws<25)*((ws-24.5)*0+1)+0):0;"
    
    params = []
    for pp in pc_raw_offshore.split("?")[1].split("+0):")[0].split(")+("):
        pp2 = pp.split("*")
        ll = float(pp2[0].split("&&")[0].replace("ws>=","").replace("(",""))
        ul = float(pp2[0].split("&&")[1].replace("ws<","").replace(")",""))
        slope = float(pp2[2].split("+")[0])
        offset = float(pp2[2].split("+")[1].replace(")",""))
        params.append((ll, ul, slope, offset))

    pc_os = np.zeros(ws.shape, dtype=np.float32)
    for ll, ul, slope, offset in params:
        print("powercurve_offshore3",ll)
        pc_os[(ws>=ll) & (ws<ul)] += (ws[(ws>=ll) & (ws<ul)]-ll)*slope + offset
    pc_os[np.isnan(ws)] = np.nan
    
    pc_out = pc_os.view().reshape(ws2.shape)
        
    return pc_out

