#! /usr/bin/env python3

from osgeo import gdal, osr, gdalconst
import numpy as np
import matplotlib.pyplot as plt
import xarray as xr
import os
import pyproj as pyp
import pandas as pd

def get_extent_npx(ds):
    
    upx, xres, xskew, upy, yskew, yres = ds.GetGeoTransform()
    
    cols = ds.RasterXSize
    rows = ds.RasterYSize

    ulx = upx + 0*xres + 0*xskew
    uly = upy + 0*yskew + 0*yres
    
    llx = upx + 0*xres + rows*xskew
    lly = upy + 0*yskew + rows*yres
    
    lrx = upx + cols*xres + rows*xskew
    lry = upy + cols*yskew + rows*yres
    
    urx = upx + cols*xres + 0*xskew
    ury = upy + cols*yskew + 0*yres
    
    return (llx, lly, urx, ury), cols, rows, xres, yres

def get_extent_nc(ds):
    xres = np.round(tds.lon.diff(dim='lon').mean().values.item(),1 )

    yres = np.round(tds.lat.diff(dim='lat').mean().values.item(),1 )


    cols = tds.lon.shape[0]
    rows = tds.lat.shape[0]

    llx = np.round(tds.lon[0].item() - xres/2, 2)
    lly = np.round(tds.lat[0].item() - yres/2, 2)
    urx = np.round(tds.lon[-1].item() + xres/2, 2)
    ury = np.round(tds.lat[-1].item() + yres/2, 2)

    extent = (llx, lly, urx, ury)
    
    return (llx, lly, urx, ury), cols, rows, xres, yres

def get_coordinate_vector(extent, cols, rows, xres, yres):
    x = np.linspace(extent[0] + np.abs(xres/2), extent[2] - np.abs(xres/2), cols)
    y = np.linspace(extent[1] + np.abs(yres/2), extent[3] - np.abs(yres/2), rows)
    
    return x, y

def warp_to_target_grid(sds, tds, tds_epsg, out_name, method="Average", outputType = gdalconst.GDT_Float32):
    #source SRS
    s_srs = osr.SpatialReference()
    s_srs.ImportFromWkt(sds.GetProjection())
    
    #target SRS
    t_srs = osr.SpatialReference()
    t_srs.ImportFromEPSG(tds_epsg)
    
    #target extent and nr of pixel
    extent, nx, ny, xres, yres = get_extent_nc(tds)
    
    projected = gdal.Warp(out_name, sds, srcSRS = s_srs, dstSRS = t_srs, outputBounds = extent, width = nx, height = ny, resampleAlg = method, outputType = outputType)
    
    return projected
    
    
    

# source
s_file = '/path/to/usable-area+buffer301m.tif'
sds = gdal.Open(s_file, gdal.GA_ReadOnly)
band = sds.GetRasterBand(1)
band.SetNoDataValue(7)
#sds.FlushCache()

# target grid
t_file = '/path/to/REA/converted/regridded_ERA5/WS_150m.2D.199501_atERA5.nc4'
tds = xr.open_dataset(t_file)

# output
out_file = "/path/to/wind_masks_projected/" + os.path.basename(s_file).replace(".tif","_ERA5.tif")
pds = warp_to_target_grid(sds, tsd, 4326, out_file)

## project target grid to lat lon

p_srs = osr.SpatialReference()
p_srs.ImportFromEPSG(4326)


LON, LAT = np.meshgrid(tds.lon.data, tds.lat.data)

# set some values to 0
p_band = pds.GetRasterBand(1)
pds_data = p_band.ReadAsArray()
pds_data[(LON[::-1,:] < -31) | (LON[::-1,:] > 62.7)] = 0
p_band.WriteArray(pds_data)
#out_file2 = out_file.replace(".tif","_corrected.tif")
pds.FlushCache()


