#! /usr/bin/env python3
import xarray as xr
import numpy as np
import pandas as pd
import matplotlib.pyplot as plt
import matplotlib.colors as mpl
import glob
import geopandas as gpd
from joblib import Parallel, delayed
import os

def create_dir(path):
    os.makedirs(path)

def corr_wind(fname):
    df = pd.read_csv(fname, index_col = 0)
    wgt_tmp = wgt_corr.reindex(df.columns)
    df_corr = df*wgt_tmp
    
    outname = fname.replace("Wind_Power","Wind_Power_corr")
    print(outname)
    try:
        create_dir(os.path.dirname(outname))
    except:
        pass
    df_corr.to_csv(outname, float_format = "%.2f")
    
flist_wgt = glob.glob("/path/to/Weights_NUTS0_agg/*_weights.csv") 

wgt = pd.concat([pd.read_csv(ff, index_col = 0) for ff in flist_wgt], axis=0)
wgt_corr = wgt.n_pixel/(wgt.land + wgt.offshore)
wgt_corr[wgt_corr == np.inf] = 0
wgt_corr[wgt_corr.isna()] = 0

flist = sorted(list(set(glob.glob("/path/to/Final_Data/Wind_Power/*/*/*NUTS3*csv")) - set(glob.glob("/path/to/Final_Data/Wind_Power/*/*/*NUTS0*csv"))))

num_cores = 16
Parallel(n_jobs=num_cores)(delayed(corr_wind)(args) for args in flist)     
    
