;.............. Rule to find input files (Sec 1)..............

 setfileoption("nc","Format","NetCDF4Classic") 
 
 Intrp_mthd = "patch"     ; "bilinear", "patch" or "conserve"

 fin0    = addfile("Secure_grid_era5L_topo.nc","r")
 fmask   = fin0->height
 fmask   = where(fmask .gt. 0.0, 1.0, fmask@_FillValue)
 
 fmask!0 = "lat"        ; rename latitude  to lat
 fmask!1 = "lon"        ; rename longitude to lon
 
 dims    = dimsizes(fmask)
 nlat    = dims(0)
 nlon    = dims(1)
 
 printVarSummary(fmask)
 print("nlat and nlon are "+nlat+"   "+nlon)
 
 fmask@_FillValue = 1.e+20
 fmask@units = "m"
 fmask@long_name="ERA5L Mask"
 fmask@standard_name="Mask"
 
 printVarSummary(fmask)
  
  ; ---------- Regridding ---------

 Opt                   = True
 Opt@InterpMethod      = Intrp_mthd
 Opt@SrcRegional       = True
 
 Opt@DstGridLat        = fmask&lat
 Opt@DstGridLon        = fmask&lon
 Opt@DstRegional       = True

 Opt@ForceOverwrite    = True
 Opt@PrintTimings      = False
 Opt@Debug             = False
 
;........ Vars to be average over a month. (Sec 4).......................
          
 
  fin   = addfile("Population_density.nc","r")
  mlon  = fin->lon
  mlat  = fin->lat
  invar = fin->Pop_den
     
  Opt@SrcGridLat = mlat
  Opt@SrcGridLon = mlon
   
  invar_reg = ESMF_regrid(invar,Opt)
  
  fout  = addfile("Population_density_era5L_grid.nc","c")
  filedimdef(fout,"time",-1,True)
  fout->Pop_den = invar_reg
  fout->fmask=fmask
  
 
