  ncfile=asciiread("Regions.txt",-1,"string")
  nreg = dimsizes(ncfile)
  print(nreg)
 
  do nf = 0,nreg-1
    if (nf .eq. 0) then
      fin0 = addfile(ncfile(nf)+"_rcp45_1951-2000.nc","r")
      rsds  = fin0->rsds
      time  = fin0->time
      printVarSummary(time)
      ;time!0 = "time"
      ;time&time = time

      
      ntim = dimsizes(time)
      rsds_all  = new((/ntim,nreg/),float,rsds@_FillValue)      
      rsds_all!0 = "time" 
      rsds_all!1 = "reg"
      rsds_all&time = time
      rsds_all&reg  = ispan(1,nreg,1)
      rsds_all@standard_name = rsds@standard_name
      rsds_all@units = rsds@units
      rsdsr_all = rsds_all
      rsds_all@long_name = "Population Weighted Radiation"
      rsdsr_all@long_name = "Radiaton (not Weighted)"
      rsds_all@units = "W/m2"
      rsdsr_all@units = "W/m2"
      
      printVarSummary(rsds_all)
      printVarSummary(rsdsr_all)
      delete(fin0)
    end if
      fin = addfile(ncfile(nf)+"_rcp45_1951-2000.nc","r")      
      
      rsds_all(:,nf)  = (/ fin->rsds /)
      rsdsr_all(:,nf) = (/ fin->rsds_raw /)
      delete(fin)
  end do
  
  fout = addfile("ICHEC_Rsds_Nuts2_pop_weighted_rcp45_1951-2000.nc","c")
  filedimdef(fout,"time",-1,True)
  fout->rsds=rsds_all
  fout->rsds_raw=rsdsr_all
        
      
      
      
      
      
        
      
  

  
