 Set = "Mask01"


 mskfils=systemfunc("ls "+Set+"/*nc")
 print(mskfils)
 nfiles = dimsizes(mskfils)
 
 outfiles = str_sub_str(mskfils,Set+"/","")   ; remove the directory name from file paths
 outfiles = str_sub_str(outfiles,"_isopop.nc","")
 
 do nf  = 0, nfiles - 1
   fwgts = addfile(mskfils(nf),"r")
   Wghts = fwgts->Wghts
   printMinMax(Wghts,True)
   ;printVarSummary(Wghts)
   htdiff= fwgts->htdiff
   printMinMax(htdiff,True)
   ;printVarSummary(htdiff)
   fmask = fwgts->fmask
 
   indices = str_sub_str(fmask@cut_ind,",",":")
   y1 = stringtointeger(str_get_field(indices,1,":"))
   y2 = stringtointeger(str_get_field(indices,2,":"))
   x1 = stringtointeger(str_get_field(indices,3,":"))
   x2 = stringtointeger(str_get_field(indices,4,":"))
   ;replace_ieeenan(Wghts, Wghts@_FillValue, 0)
   ;replace_ieeenan(htdiff, htdiff@_FillValue, 0)
   ;replace_ieeenan(fmask, fmask@_FillValue, 0)
   do yr= 1951,1951,1 
     print("Processing year "+yr)
     f1km =systemfunc("ls ICHEC-EC-EARTH_KNMI-RACMO22E_rcp45_1951_??_tas_hourly_1km.nc")
      
     fin  = addfiles(f1km,"r")
     t2m  = fin[:]->tas(:,y1:y2,x1:x2)
     replace_ieeenan(t2m, t2m@_FillValue, 0)
     
     t2m_raw = t2m
     t2m_raw = t2m * conform(t2m,fmask,(/1,2/))
     t2m_raw_avg = dim_avg_n_Wrap(t2m_raw,(/1,2/))
          
     printMinMax(t2m,True)
     t2m  = t2m + conform(t2m,htdiff,(/1,2/))     ; apply ht correction
     printMinMax(t2m,True)
     t2m  = t2m * conform(t2m,Wghts,(/1,2/))      ; apply weights
     printMinMax(t2m,True)
     t2m1 = t2m(:,0,0)
     t2m1 = (/ dim_sum_n(t2m,(/1,2/)) /)
     
     printMinMax(t2m1,True)
     outname = str_sub_str(f1km(0),"ICHEC-EC-EARTH_KNMI-RACMO22E",outfiles(nf))
     outname = str_sub_str(outname,"_tas_hourly_1km","")
     print("outname is "+outname)
     
     fout = addfile(outname,"c")
     filedimdef(fout,"time",-1,True)
     fout->t2m=t2m1
     fout->t2m_raw=t2m_raw_avg
     delete([/t2m,t2m1,t2m_raw,t2m_raw_avg,fout/])
     ;system("rm -rvf "+f1km)
   end do
     ;system("ncrcat "+outfiles(nf)+"_????_hourly_t2m.nc"+"  "+outfiles(nf)+"_hourly_t2m_1981-2020.nc")
     delete([/fwgts,Wghts,htdiff,fmask,indices/])
     ;system("rm -rvf "+outfiles(nf)+"_????_hourly_t2m.nc")
  end do  
    
     
     
     
     
     
     
