
fina = addfile("Uwnd_Malta_1980-2020.nc","r")
finb = addfile("Vwnd_Malta_1980-2020.nc","r")

U10  = fina->U10(:,0,:,:)
V10  = finb->V10(:,0,:,:)
time = finb->t
ntim = dimsizes(time)

ymd   = cd_calendar(time, -5)           ; -5 = type integer in yrs,mns,dys and hrs
yrs   = ymd(:,0)
mns   = ymd(:,1)
dys   = ymd(:,2)
hrs   = ymd(:,3)
mins  = ymd(:,4)
printMinMax(mns,True)

  
  hrs = where(mins .gt. 50, hrs+1, hrs)
  hrs = where(hrs .gt. 24, 0, hrs)
  mins = where(mins .gt. 50, 0, mins)
; .......... Creating new time .........
  opt  = 0
  opt@return_type = "float"
  units  = "hours since 1979-01-01 00:00:00"
  sc     = mins
  sc     = 0
  ntime  = cd_inv_calendar(yrs,mns,dys,hrs,mins,sc,units,opt)
  printVarSummary(ntime)
  etime = yrs+""+sprinti("%0.2i",mns)+""+sprinti("%0.2i",dys)+""+sprinti("%0.2i",hrs)
  
  
  
  Wspd = U10
  Wspd      = wind_speed(U10,V10)
  
  delete(Wspd@t)
  Wspd!0 ="time"
  Wspd&time = ntime

  
  printVarSummary(Wspd)
  sleep(10)
  
  Wspd_frac =  Wspd
  
  Wspd@units         = "m s**-1"
  Wspd@standard_name = "wind_speed"
  Wspd@long_name     = "10 metre wind speed"
  Wspd@title         = "10 metre wind speed" 
  Wspd@name          = "Wspd"

 
  Wspd_frac@units         = "0-1"
  Wspd_frac@standard_name = "wind_speed_fractions"
  Wspd_frac@long_name     = "10 metre wind speed fractions"
  Wspd_frac@title         = "10 metre wind speed fractions" 
  Wspd_frac@name          = "Wspd_frac"
  Wspd_frac@comments      = "Hourly wind as a fraction of mean daily wind"
  Wspd_frac@info          = "Day starts at 00:00 and end at 23:00"

  delete([/Wspd@time,Wspd@date,Wspd@missing_value/])

  idal     = ind(hrs .eq. 12)
  Wspd_dal = Wspd(idal,:,:)

  Wspd_dal@long_name = "Mean daily 10-m wind speed"

  dcnt  = dimsizes(idal)
  dstps = idal(1:dcnt-1)-idal(0:dcnt-2)
  stps  = min(dstps)
 
  print("ntim and ndal are  "+ntim+"    "+dimsizes(idal)+"   "+stps) 

h = 0
do nt=0,ntim-1,stps
   print("nt1 and nt2 are "+nt+"   "+(nt+stps-1)+"   "+etime(nt)+"     "+etime(nt+stps-1)+"     "+etime(idal(h)))
   Wspd_dal(h,:,:) = dim_avg_n(Wspd(nt:nt+stps-1,:,:),0)
   Wspd_frac(nt:nt+stps-1,:,:) = (/ Wspd(nt:nt+stps-1,:,:) / conform(Wspd(nt:nt+stps-1,:,:),Wspd_dal(h,:,:),(/1,2/)) /)
   h = h + 1 
 end do
 
 fout1 = addfile("Era5l_eu_wspd_hourly_1980-2020_Malta.nc","c")
 filedimdef(fout1,"time",-1,True)
 
 fout2 = addfile("Era5l_eu_wspd_daily_1980-2020_Malta.nc","c")
 filedimdef(fout2,"time",-1,True)
 
 fout3 = addfile("Era5l_eu_wspd_frac_1980-2020_Malta.nc","c")
 filedimdef(fout3,"time",-1,True)
 
  
 fout1->wspd      = Wspd
 fout2->wspd      = Wspd_dal
 fout3->wspd_frac = Wspd_frac
 
 
 
