 infile0 = addfile("Population_density.nc","r")
 infile1 = addfile("Ht_corrections_additive_EU.nc","r")
 infile2 = addfile("Era5l_eu_1981_hourly_t2m_yearmean_1km.nc","r")
  
 popden0  = infile0->Pop_den
 htdiff0  = infile1->htdiff_degC
 t2m_era5 = infile2->t2m(0,:,:)
 
 htdiff0@_FillValue = t2m_era5@_FillValue
 delete([/htdiff0@_Fillvalue,htdiff0@missing_value/])
 
 replace_ieeenan(popden0,popden0@_FillValue, 0)
 replace_ieeenan(htdiff0,htdiff0@_FillValue, 0)
 replace_ieeenan(t2m_era5,t2m_era5@_FillValue, 0) 
 
 fmask_n   = t2m_era5
 fmask_n   = where(.not.ismissing(popden0) .and. .not.ismissing(htdiff0)  .and. .not.ismissing(t2m_era5), 1.0, t2m_era5@_FillValue)


 print("Total number of non missing values in era5 1km are "+num(.not.ismissing(t2m_era5)))
 print("Total number of non missing values in fmask_n are "+num(.not.ismissing(fmask_n)))
  
 printVarSummary(popden0)
 printVarSummary(htdiff0)
 mfiles = systemfunc("ls *_isopop.nc")
 nfiles = dimsizes(mfiles)
 
 do nf = 0, nfiles - 1
 
   fmskf   = addfile(mfiles(nf),"r")
   fmask0  = fmskf->fmasK
   fmask0  = fmask0 * fmask_n
   
   fmask0  = where(.not.ismissing(fmask0),1.0,fmask0@_FillValue)     
   cutind  = ind_resolve(ind(.not.ismissing(ndtooned(fmask0))),dimsizes(fmask0))
   ymn     = min(cutind(:,0)) ;- 5
   ymx     = max(cutind(:,0)) ;+ 5
   xmn     = min(cutind(:,1)) ;- 5 
   xmx     = max(cutind(:,1)) ;+ 5  
   print(ymn+"   "+ymx+"   "+xmn+"    "+xmx)
   fmask   = fmask0(ymn:ymx,xmn:xmx)
   fmask@cut_ind = ymn+":"+ymx+","+xmn+":"+xmx
   
   fmask2 = fmask_n(ymn:ymx,xmn:xmx) ; based on interpolated t2m 
 
   Wghts  = fmask 
   Wghts  = Wghts@_FillValue
  
   popden = popden0(ymn:ymx,xmn:xmx)
   popden = popden * fmask
   
   htdiff = htdiff0(ymn:ymx,xmn:xmx)
   htdiff = htdiff * fmask
   
   popden1 = popden
   Wghts   =  popden1 / sum(popden1)
   
     
   print("Sum of all weights old is "+sum(Wghts)+" for points ; "+num(.not.ismissing(Wghts))+"  ; "+num(.not.ismissing(htdiff))+"  ; "+num(.not.ismissing(fmask))+"  ;  for file "+mfiles(nf))
   
   Wghts  = Wghts * fmask2
   htdiff = htdiff * fmask2
   fmask  = fmask *   fmask2
   fmask2  = fmask2 *   fmask
   print("Sum of all weights old is "+sum(Wghts)+" for points ; "+num(.not.ismissing(Wghts))+"  ; "+num(.not.ismissing(htdiff))+"  ; "+num(.not.ismissing(fmask))+"  ;  for file "+mfiles(nf))
   ;print("Sum of all weights new is "+sum(Wghts)+" for points  "+num(.not.ismissing(Wghts))+"   "+num(.not.ismissing(htdiff))+"   "+num(.not.ismissing(fmask2))+"    for file "+mfiles(nf))
   
   fout = addfile("./Weights_lastver/"+mfiles(nf),"c")
   fout->fmask=fmask
   fout->Wghts=Wghts
   fout->htdiff=htdiff
   delete([/fmask0,cutind,fmask,fmask2,Wghts,popden,popden1,htdiff/])
 end do
  
 

 
