
 start_year = 1976
 end_year   = 1981
 
 do year = start_year, end_year, 1
    
    numofhrs  = 8760
    if (isleapyear(year)) then
      numofhrs = 8784
    end if
   
    outfile = "Pr/Era5l_eu_pr_dalsum_"+year+".nc"
    nextyear = year + 1
    print("Era5l_eu_"+year+"_pr.nc , Era5l_eu_"+nextyear+"_pr.nc")
    fnames = (/"Era5l_eu_"+year+"_pr.nc","Era5l_eu_"+nextyear+"_pr.nc"/)
    fin = addfiles(fnames,"r")
    
    invar = fin[:]->TP(0:numofhrs,0,:,:)               ; (t, surface, latitude, longitude) ;
    time  = fin[:]->time(0:numofhrs)
    utime = cd_calendar(time,-5)
    invar = invar * 1000.0 ; m to mm
    
    yrs = utime(:,0)
    mon = utime(:,1)
    dys = utime(:,2)
    hrs = utime(:,3)
    mns = utime(:,4)
    
    printMinMax(mns,True)
;   ... important if printMinMax of mns bring values other than 0 ...... 
    
    hrs = where(mns .gt. 50, hrs+1, hrs)
    hrs = where(hrs .gt. 24, 0, hrs)
    mns = where(mns .gt. 50, 0, mns)
     
    tstring = yrs+""+sprinti("%0.2i",mon)+""+sprinti("%0.2i",dys)+"-"+sprinti("%0.2i",hrs)+":"+sprinti("%0.2i",mns)
    
    
    indd  =  ind(hrs .eq. 12)  
    ind24 =  (ind(hrs .eq. 23))+1
    
    ndys = dimsizes(indd)
    ntim = dimsizes(time)
    
    print(tstring(0)+"   "+tstring(ntim-1)+"  are time bouds")
    ;printMinMax(tstring(0)+"   Last "+Tstring(ntim-1))
    print("ntim and ndys are "+ntim+"  "+ndys)
     
    invar_dal1  = invar(indd,:,:)
    
    invar_dal1@units = "mm/day"
    invar_dal1@comments = "Daily Sums calc. from Hourly"

    invar_dal2  = invar_dal1
    
     do dy = 0, ndys-1
       cind = indd(dy)
       print(tstring(cind-11)+" till  "+tstring(cind+12)+" for day "+tstring(cind)+"    "+(cind-11)+"   "+cind+"  "+(cind+12))                      ; 00:01 to 00:00
       invar_dal1(dy,:,:) = dim_max_n(invar(cind-11:cind+12,:,:),0)
     end do 
     
;    ....Calculation by simple method, the last forcast step gives accumulated precipitation of the day.....
    
     invar_dal2 = (/ invar(ind24,:,:) /)
         
     
     system("rm -rvf "+outfile)
     fout = addfile(outfile,"c")
     filedimdef(fout,"time",-1,True)
     
     fout->pr=invar_dal2
    
     fout1 = addfile("pr_daily_"+year+"_check.nc","c")
     filedimdef(fout1,"time",-1,True)
     fout1->pr=invar_dal1
     delete([/invar,time,utime,fout,invar_dal1,invar_dal2,indd,yrs,mon,dys,hrs,mns,ind24,tstring/])
 end do  ;; End year loop
  
