  ncfile=asciiread("Regions_NUTS3_AT.txt",-1,"string")
  nreg = dimsizes(ncfile)
  print(nreg)
 
  do nf = 0,nreg-1
    if (nf .eq. 0) then
      fin0 = addfile(ncfile(nf)+"_1981-2020.nc","r")
      time = fin0->time
      rsds  = fin0->rsds
      rsdsr = fin0->rsds_raw
       
      ntim = dimsizes(time)
      rsds_all  = new((/ntim,nreg/),float,rsds@_FillValue)      
      rsds_all!0 = "time" 
      rsds_all!1 = "reg"
      rsds_all&time = time
      rsds_all&reg  = ispan(1,nreg,1)
      rsds_all@standard_name = rsds@standard_name
      rsds_all@units = rsds@units
      rsdsr_all = rsds_all
      rsds_all@long_name = "Population Weighted Radiation"
      rsdsr_all@long_name = "Radiaton (not Weighted)"
      rsds_all@units = "W/m2"
      rsdsr_all@units = "W/m2"
      
      printVarSummary(rsds_all)
      printVarSummary(rsdsr_all)
      delete(fin0)
    end if
      fin = addfile(ncfile(nf)+"_1981-2020.nc","r")      
      rsds_all(:,nf)  = (/ fin->rsds /)
      rsdsr_all(:,nf) = (/ fin->rsds_raw /)
      delete(fin)
  end do
  
  rsds_all = rsds_all / 3600.0           ; J/m2 into W/m2
  rsdsr_all = rsdsr_all / 3600.0

  
  fout = addfile("Rsds_NUTS3_AUSTRIA_weighted_hourly_1981-2020.nc","c")
  filedimdef(fout,"time",-1,True)
  fout->rsds=rsds_all
  fout->rsds_raw=rsdsr_all
  
      
      
      
      
      
      
      
      
        
      
  

  
