   do yr= 1981,1990,1
     print("Processing year "+yr)
     infils = systemfunc("ls Era5l_eu_rsds_hourly_"+yr+".nc")
     fin    = addfiles(infils,"r")
     rsds   = fin[:]->rsds
     time   = fin[:]->time
      
     mskfils = systemfunc("ls *_isopop_era5.nc")
     outfils = str_sub_str(mskfils,"isopop_era5",yr)
     
     
     print(outfils)
     
     nfiles = dimsizes(mskfils)               
     do nf  = 0, nfiles - 1
       fwgts = addfile(mskfils(nf),"r")
       fmask = fwgts->fmask
       Wghts = fwgts->Wghts
       indices = str_sub_str(fmask@cut_ind,",",":")
       y1 = stringtointeger(str_get_field(indices,1,":"))
       y2 = stringtointeger(str_get_field(indices,2,":"))
       x1 = stringtointeger(str_get_field(indices,3,":"))
       x2 = stringtointeger(str_get_field(indices,4,":"))
       rsds_raw = rsds(:,y1:y2,x1:x2)
       rsds_wgt = rsds_raw

       rsds_raw =  rsds_raw * conform(rsds_raw,fmask,(/1,2/))
       rsds_wgt =  rsds_wgt * conform(rsds_wgt,Wghts,(/1,2/))
       
       rsds_raw_avg = dim_avg_n_Wrap(rsds_raw,(/1,2/))
       rsds_wgt_avg = dim_sum_n_Wrap(rsds_wgt,(/1,2/))
       
       ;printVarSummary(rsds_raw_avg)
       ;printVarSummary(rsds_wgt_avg)
       
       fout = addfile(outfils(nf),"c")
       filedimdef(fout,"time",-1,True)
       
       fout->time=time
       fout->rsds_raw=rsds_raw_avg
       fout->rsds=rsds_wgt_avg
       delete([/fmask,Wghts,indices,rsds_raw,rsds_wgt,rsds_raw_avg,rsds_wgt_avg/])
       print("Done region "+mskfils(nf))
     end do
     delete([/rsds,time/])
   end do
   
